/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.semgraph;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.semgraph.DirectedEdge;
import java.io.Serializable;
import java.util.Comparator;
import org.jgrapht.EdgeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticGraphEdge
extends DirectedEdge<IndexedWord>
implements Comparable<SemanticGraphEdge> {
    public static boolean printOnlyRelation = false;
    private GrammaticalRelation relation;
    private double weight;
    private IndexedWord cachedSourceRef;
    private IndexedWord cachedTargetRef;
    private static Comparator<SemanticGraphEdge> targetComparator = new SemanticGraphEdgeTargetComparator();
    private static final long serialVersionUID = 1L;

    public SemanticGraphEdge(IndexedWord source, IndexedWord target, GrammaticalRelation relation, double weight2) {
        super(source, target);
        this.cachedSourceRef = source;
        this.cachedTargetRef = target;
        this.relation = relation;
        this.setWeight(weight2);
    }

    public SemanticGraphEdge(SemanticGraphEdge e) {
        super(e.getSource(), e.getTarget());
        this.relation = e.getRelation();
        this.weight = e.weight;
    }

    @Override
    public String toString() {
        if (printOnlyRelation) {
            return this.getSource() + " -> " + this.getTarget() + " (" + this.getRelation() + ")";
        }
        return this.getRelation().toString();
    }

    public GrammaticalRelation getRelation() {
        return this.relation;
    }

    public void setRelation(GrammaticalRelation relation) {
        this.relation = relation;
    }

    public IndexedWord getGovernor() {
        return (IndexedWord)this.getSource();
    }

    public IndexedWord getDependent() {
        return (IndexedWord)this.getTarget();
    }

    public void setWeight(double weight2) {
        this.weight = weight2;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean typeEquals(SemanticGraphEdge e) {
        return this.relation.equals(e.relation);
    }

    public static Comparator<SemanticGraphEdge> orderByTargetComparator() {
        return targetComparator;
    }

    @Override
    public int compareTo(SemanticGraphEdge other) {
        int sourceVal = ((IndexedWord)this.getSource()).compareTo((IndexedWord)other.getSource());
        if (sourceVal != 0) {
            return sourceVal;
        }
        int targetVal = ((IndexedWord)this.getTarget()).compareTo((IndexedWord)other.getTarget());
        if (targetVal != 0) {
            return targetVal;
        }
        String thisRelation = this.getRelation().toString();
        String thatRelation = other.getRelation().toString();
        return thisRelation.compareTo(thatRelation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SemanticGraphEdge)) {
            return false;
        }
        SemanticGraphEdge semanticGraphEdge = (SemanticGraphEdge)o;
        if (this.relation != null) {
            boolean retFlag = this.relation.equals(semanticGraphEdge.relation);
            boolean govMatch = this.getGovernor().equals(semanticGraphEdge.getGovernor());
            boolean depMatch = this.getDependent().equals(semanticGraphEdge.getDependent());
            boolean matched = retFlag && govMatch && depMatch;
            return matched;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int result = this.relation != null ? this.relation.hashCode() : 0;
        result = 29 * result + (this.getSource() != null ? ((IndexedWord)this.getSource()).hashCode() : 0);
        result = 29 * result + (this.getTarget() != null ? ((IndexedWord)this.getTarget()).hashCode() : 0);
        return result;
    }

    public IndexedWord getCachedSourceRef() {
        return this.cachedSourceRef;
    }

    public IndexedWord getCachedTargetRef() {
        return this.cachedTargetRef;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements EdgeFactory<IndexedWord, SemanticGraphEdge>,
    Serializable {
        private static final long serialVersionUID = -8778385005883694770L;

        public SemanticGraphEdge createEdge(IndexedWord arg0, IndexedWord arg1) {
            return new SemanticGraphEdge(arg0, arg1, null, 0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SemanticGraphEdgeTargetComparator
    implements Comparator<SemanticGraphEdge> {
        private SemanticGraphEdgeTargetComparator() {
        }

        @Override
        public int compare(SemanticGraphEdge o1, SemanticGraphEdge o2) {
            int targetVal = ((IndexedWord)o1.getTarget()).compareTo((IndexedWord)o2.getTarget());
            if (targetVal != 0) {
                return targetVal;
            }
            int sourceVal = ((IndexedWord)o1.getSource()).compareTo((IndexedWord)o2.getSource());
            if (sourceVal != 0) {
                return sourceVal;
            }
            return o1.getRelation().toString().compareTo(o2.getRelation().toString());
        }
    }
}

