/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Characters {
    private Characters() {
    }

    public static Character getCharacter(char c) {
        Character cC = CharacterHolder.canonicalCharacters[c];
        if (cC == null) {
            CharacterHolder.canonicalCharacters[c] = cC = Character.valueOf(c);
        }
        return cC;
    }

    public static Character[] asCharacterArray(String s) {
        Character[] split = new Character[s.length()];
        for (int i = 0; i < split.length; ++i) {
            split[i] = Characters.getCharacter(s.charAt(i));
        }
        return split;
    }

    public static List<Character> asCharacterList(String s) {
        return Arrays.asList(Characters.asCharacterArray(s));
    }

    public static String unicodeBlockStringOf(int codePoint) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(codePoint);
        if (block == null) {
            return "Undefined";
        }
        return block.toString();
    }

    private static class CharacterHolder {
        private static final Character[] canonicalCharacters = new Character[65536];

        private CharacterHolder() {
        }
    }
}

