/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MetaClass;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static boolean hasProperty(Properties props, String key) {
        String value = props.getProperty(key);
        if (value == null) {
            return false;
        }
        return !(value = value.toLowerCase()).equals("false") && !value.equals("no") && !value.equals("off");
    }

    public static void printProperties(String message, Properties properties, PrintStream stream) {
        if (message != null) {
            stream.println(message);
        }
        if (properties.isEmpty()) {
            stream.println("  [empty]");
        } else {
            ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(properties.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                    return e1.getKey().compareTo(e2.getKey());
                }
            });
            for (Map.Entry entry : entries) {
                if ("".equals(entry.getKey())) continue;
                stream.format("  %-30s = %s%n", entry.getKey(), entry.getValue());
            }
        }
        stream.println();
    }

    public static void printProperties(String message, Properties properties) {
        PropertiesUtils.printProperties(message, properties, System.out);
    }

    public static void checkProperties(Properties properties, Properties defaults) {
        HashSet<?> names = Generics.newHashSet();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        e = defaults.propertyNames();
        while (e.hasMoreElements()) {
            names.remove(e.nextElement());
        }
        if (!names.isEmpty()) {
            if (names.size() == 1) {
                throw new IllegalArgumentException("Unknown property: " + (String)names.iterator().next());
            }
            throw new IllegalArgumentException("Unknown properties: " + names);
        }
    }

    public static <E> E get(Properties props, String key, E defaultValue, Type type) {
        String value = props.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return MetaClass.cast(value, type);
    }

    public static int getInt(Properties props, String key) {
        return PropertiesUtils.getInt(props, key, 0);
    }

    public static int getInt(Properties props, String key, int defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public static double getDouble(Properties props, String key) {
        return PropertiesUtils.getDouble(props, key, 0.0);
    }

    public static double getDouble(Properties props, String key, double defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Double.parseDouble(value);
        }
        return defaultValue;
    }

    public static boolean getBool(Properties props, String key) {
        return PropertiesUtils.getBool(props, key, false);
    }

    public static boolean getBool(Properties props, String key, boolean defaultValue) {
        String value = props.getProperty(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static int[] getIntArray(Properties props, String key) {
        Integer[] result = (Integer[])MetaClass.cast(props.getProperty(key), Integer[].class);
        return ArrayUtils.toPrimitive(result);
    }

    public static double[] getDoubleArray(Properties props, String key) {
        Double[] result = (Double[])MetaClass.cast(props.getProperty(key), Double[].class);
        return ArrayUtils.toPrimitive(result);
    }

    public static String[] getStringArray(Properties props, String key) {
        return (String[])MetaClass.cast(props.getProperty(key), String[].class);
    }
}

