/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringParsingTask<E> {
    protected String s;
    protected int index = 0;
    protected boolean isEOF = false;

    public StringParsingTask(String s) {
        this.s = s;
        this.index = 0;
    }

    public abstract E parse();

    protected String readName() {
        this.readWhiteSpace();
        StringBuilder sb = new StringBuilder();
        char ch = this.read();
        while (!(this.isWhiteSpace(ch) || this.isPunct(ch) || this.isEOF)) {
            sb.append(ch);
            ch = this.read();
        }
        this.unread();
        return sb.toString().intern();
    }

    protected String readJavaIdentifier() {
        this.readWhiteSpace();
        StringBuilder sb = new StringBuilder();
        char ch = this.read();
        if (Character.isJavaIdentifierStart(ch) && !this.isEOF) {
            sb.append(ch);
            ch = this.read();
            while (Character.isJavaIdentifierPart(ch) && !this.isEOF) {
                sb.append(ch);
                ch = this.read();
            }
        }
        this.unread();
        return sb.toString().intern();
    }

    protected void readLeftParen() {
        this.readWhiteSpace();
        char ch = this.read();
        if (!this.isLeftParen(ch)) {
            throw new ParserException("Expected left paren!");
        }
    }

    protected void readRightParen() {
        this.readWhiteSpace();
        char ch = this.read();
        if (!this.isRightParen(ch)) {
            throw new ParserException("Expected right paren!");
        }
    }

    protected void readDot() {
        this.readWhiteSpace();
        if (this.isDot(this.peek())) {
            this.read();
        }
    }

    protected void readWhiteSpace() {
        char ch = this.read();
        while (this.isWhiteSpace(ch) && !this.isEOF()) {
            ch = this.read();
        }
        this.unread();
    }

    protected char read() {
        if (this.index >= this.s.length() || this.index < 0) {
            this.isEOF = true;
            return ' ';
        }
        return this.s.charAt(this.index++);
    }

    protected void unread() {
        --this.index;
    }

    protected char peek() {
        char ch = this.read();
        this.unread();
        return ch;
    }

    protected boolean isEOF() {
        return this.isEOF;
    }

    protected boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\f' || ch == '\r' || ch == '\n';
    }

    protected boolean isPunct(char ch) {
        return this.isLeftParen(ch) || this.isRightParen(ch);
    }

    protected boolean isLeftParen(char ch) {
        return ch == '(';
    }

    protected boolean isRightParen(char ch) {
        return ch == ')';
    }

    protected boolean isDot(char ch) {
        return ch == '.';
    }

    public static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParserException(Exception e) {
            super(e);
        }

        public ParserException(String message) {
            super(message);
        }
    }
}

