use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"       => "Attean Linked Data Fragments store",
  "author"         => [
                        "Kjetil Kjernsmo <kjetilk\@cpan.org>",
                        "Patrick Hochstenbach (HOCHSTEN) <patrick.hochstenbach\@ugent.be>",
                        "KJETILK <kjetilk\@cpan.org>",
                      ],
  "dynamic_config" => 0,
  "generated_by"   => "Dist::Inkt::Profile::TOBYINK version 0.023, CPAN::Meta::Converter version 2.150005",
  "keywords"       => [],
  "license"        => ["perl_5"],
  "meta-spec"      => {
                        url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                        version => 2,
                      },
  "name"           => "AtteanX-Store-LDF",
  "no_index"       => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"        => {
                        configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                        develop   => { recommends => { "Dist::Inkt" => 0.001 } },
                        runtime   => {
                                       requires => {
                                                     "Attean" => "0.010",
                                                     "Carp" => 0,
                                                     "Data::Dumper" => 0,
                                                     "Moo" => "1.006000",
                                                     "MooX::Log::Any" => 0,
                                                     "perl" => 5.014,
                                                     "RDF::LDF" => 0,
                                                     "Types::URI" => 0,
                                                   },
                                       suggests => {
                                                     "HTTP::Message::PSGI"  => 0,
                                                     "RDF::LinkedData"      => 0.74,
                                                     "Test::LWP::UserAgent" => 0.027,
                                                   },
                                     },
                        test      => {
                                       requires => {
                                         "RDF::Generator::Void" => 0,
                                         "RDF::LinkedData"      => 0.74,
                                         "Test::Exception"      => 0,
                                         "Test::LWP::UserAgent" => 0.027,
                                         "Test::More"           => 0.88,
                                         "Test::Roo"            => 0,
                                       },
                                     },
                      },
  "provides"       => {
                        "AtteanX::Query::AccessPlan::LDF"             => { file => "lib/AtteanX/Query/AccessPlan/LDF.pm", version => 0.01 },
                        "AtteanX::Store::LDF"                         => { file => "lib/AtteanX/Store/LDF.pm", version => 0.01 },
                        "AtteanX::Store::LDF::Plan::Triple"           => { file => "lib/AtteanX/Store/LDF/Plan/Triple.pm", version => 0.01 },
                        "Test::Attean::Store::LDF::Role::CreateStore" => {
                                                                           file => "lib/Test/Attean/Store/LDF/Role/CreateStore.pm",
                                                                           version => 0.01,
                                                                         },
                      },
  "release_status" => "stable",
  "resources"      => {
                        bugtracker   => { web => "https://github.com/phochste/AtteanX-Store-LDF/issues" },
                        homepage     => "https://metacpan.org/release/AtteanX-Store-LDF",
                        license      => ["http://dev.perl.org/licenses/"],
                        repository   => {
                                          type => "git",
                                          url  => "git://github.com/phochste/AtteanX-Store-LDF.git",
                                          web  => "https://github.com/phochste/AtteanX-Store-LDF",
                                        },
                        x_identifier => "http://purl.org/NET/cpan-uri/dist/AtteanX-Store-LDF/project",
                      },
  "version"        => 0.01,
};

my %dynamic_config;

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}

sub FixMakefile
{
	return unless -d 'inc';
	my $file = shift;
	
	local *MAKEFILE;
	open MAKEFILE, "< $file" or die "FixMakefile: Couldn't open $file: $!; bailing out";
	my $makefile = do { local $/; <MAKEFILE> };
	close MAKEFILE or die $!;
	
	$makefile =~ s/\b(test_harness\(\$\(TEST_VERBOSE\), )/$1'inc', /;
	$makefile =~ s/( -I\$\(INST_ARCHLIB\))/ -Iinc$1/g;
	$makefile =~ s/( "-I\$\(INST_LIB\)")/ "-Iinc"$1/g;
	$makefile =~ s/^(FULLPERL = .*)/$1 "-Iinc"/m;
	$makefile =~ s/^(PERL = .*)/$1 "-Iinc"/m;
	
	open  MAKEFILE, "> $file" or die "FixMakefile: Couldn't open $file: $!; bailing out";
	print MAKEFILE $makefile or die $!;
	close MAKEFILE or die $!;
}

my $mm = WriteMakefile(%WriteMakefileArgs);
FixMakefile($mm->{FIRST_MAKEFILE} || 'Makefile');
exit(0);

