CREATE TABLE func_import_new_topic_status(
    project_uuid VARCHAR(40) NOT NULL,
    tkind VARCHAR NOT NULL,
    status VARCHAR(40) NOT NULL,
    rank INTEGER NOT NULL,
    def INTEGER,
    bill BOOL NOT NULL,
    uuid VARCHAR(40) NOT NULL
);


CREATE TRIGGER
    func_import_new_topic_status_bi_1
BEFORE INSERT ON
    func_import_new_topic_status
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.project_uuid,
        NEW.tkind,
        NEW.status,
        NEW.rank,
        NEW.def,
        NEW.bill,
        NEW.uuid
    );

    INSERT INTO
        func_new_topic_status(
            change_id,
            id,
            project_id,
            tkind,
            status,
            rank,
            def,
            bill,
            uuid
        )
    SELECT
        currval('changes'),
        nextval('nodes'),
        p.id,
        NEW.tkind,
        NEW.status,
        NEW.rank,
        NEW.def,
        NEW.bill,
        NEW.uuid
    FROM
        nodes p
    WHERE
        p.uuid = NEW.project_uuid
    ;

    SELECT RAISE(IGNORE);
END;
