CREATE TABLE func_import_update_entity(
    change_uuid VARCHAR(40) NOT NULL,
    entity_uuid VARCHAR(40) NOT NULL,
    name VARCHAR,
    contact_uuid VARCHAR(40),
    default_contact_method_uuid VARCHAR(40)
);

CREATE TRIGGER
    func_import_update_entity_bi_1
BEFORE INSERT ON
    func_import_update_entity
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_uuid,
        NEW.entity_uuid,
        NEW.name,
        NEW.contact_uuid,
        NEW.default_contact_method_uuid
    );

    INSERT INTO
        entity_deltas(
            change_id,
            entity_id,
            name,
            contact_id,
            default_contact_method_id
        )
    SELECT
        c.id,
        e.id,
        NEW.name,
        cn.id,
        dcm.id
        
    FROM
        nodes e
    INNER JOIN
        changes c
    ON
        c.uuid = NEW.change_uuid
    LEFT JOIN
        nodes cn
    ON
        cn.uuid = NEW.contact_uuid
    LEFT JOIN
        nodes dcm
    ON
        dcm.uuid = NEW.default_contact_method_uuid
    WHERE
        e.uuid = NEW.entity_uuid
    ;

    SELECT RAISE(IGNORE);
END;
