/*
    This is an internal function that doesn't create its own
    node_delta, which is left up to whatever the calling function is.
*/
CREATE TABLE func_new_node(
    change_id INTEGER,
    id INTEGER NOT NULL DEFAULT (nextval('nodes')),
    parent_id INTEGER,
    kind VARCHAR,
    name VARCHAR NOT NULL,
    bill BOOL NOT NULL,
    uuid VARCHAR(40)
);


CREATE TRIGGER
    func_new_node_bi_1
BEFORE INSERT ON
    func_new_node
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.id,
        NEW.parent_id,
        NEW.name,
        NEW.kind,
        NEW.bill,
        NEW.uuid
    );

    INSERT INTO
        nodes(
            id,
            parent_id,
            first_change_id,
            last_change_id,
            name,
            path,
            kind,
            ctime,
            ctimetz,
            mtime,
            mtimetz,
            lang,
            bill,
            uuid
        )
    SELECT
        NEW.id,
        NEW.parent_id,
        NEW.change_id,
        NEW.change_id,
        NEW.name,
        NEW.kind || '-' || NEW.id, -- just to make the insertion unique
        NEW.kind,
        c.mtime,
        c.mtimetz,
        c.mtime,
        c.mtimetz,
        c.lang,
        NEW.bill,
        sha1_hex(c.yaml)
    FROM
        changes c
    WHERE
        c.id = NEW.change_id
    ;


    SELECT
        CASE WHEN
            NEW.uuid IS NULL OR
            (NEW.uuid IS NOT NULL AND n.uuid = NEW.uuid)
        THEN
            RAISE(IGNORE)
        ELSE
            RAISE(ABORT, 'Bif::Err::TopicUUIDMismatch')
        END
    FROM
        nodes n
    WHERE
        n.id = NEW.id
    ;

END;
