CREATE TABLE link_topics (
    id INTEGER NOT NULL PRIMARY KEY,
    count INTEGER NOT NULL DEFAULT 0,
    FOREIGN KEY(id) REFERENCES nodes(id) ON DELETE CASCADE
);


CREATE TRIGGER
    link_topics_bu_1
BEFORE UPDATE OF
    count
ON
    link_topics
FOR EACH ROW WHEN
    NEW.count = 0
BEGIN
    SELECT debug(
        NEW.id
    );

    DELETE FROM
        link_topics
    WHERE
        id = NEW.id
    ;

    SELECT RAISE(IGNORE);

END;


CREATE TRIGGER
    link_topics_ad_1
AFTER DELETE ON
    link_topics
FOR EACH ROW
BEGIN
    SELECT debug(
        OLD.id
    );

    DELETE FROM
        nodes
    WHERE
        id = OLD.id
    ;

END;
