CREATE TABLE topic_status_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    topic_status_id INTEGER NOT NULL,
    status VARCHAR,
    rank INTEGER,
    def INTEGER,
    CONSTRAINT def_constraint CHECK (def BETWEEN 0 AND 1),
    FOREIGN KEY(id) REFERENCES deltas(id),
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(topic_status_id) REFERENCES topic_status(id) ON DELETE CASCADE
);

CREATE TRIGGER
    topic_status_deltas_ai_1
AFTER INSERT ON
    topic_status_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.change_id,
        NEW.topic_status_id,
        NEW.status,
        NEW.rank,
        NEW.def
    );


    INSERT OR IGNORE INTO
        topic_status_tomerge(topic_status_id)
    VALUES
        (NEW.topic_status_id)
    ;


    UPDATE
        topic_status_tomerge
    SET
        status = status + (NEW.status IS NOT NULL),
        rank   = rank + (NEW.rank IS NOT NULL),
        def    = def + (NEW.def IS NOT NULL)
    WHERE
        topic_status_id = NEW.topic_status_id
    ;


    UPDATE
        change_nodes
    SET
        hub_change = hub_change + 1
    WHERE
        change_id = NEW.change_id AND node_id = NEW.topic_status_id
    ;

END;


CREATE TRIGGER
    topic_status_deltas_ad_1
AFTER DELETE ON
    topic_status_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.change_id,
        OLD.topic_status_id,
        OLD.status,
        OLD.rank,
        OLD.def
    );


    INSERT OR IGNORE INTO
        topic_status_tomerge(topic_status_id)
    VALUES
        (OLD.topic_status_id)
    ;


    UPDATE
        topic_status_tomerge
    SET
        status = status + (OLD.status IS NOT NULL),
        rank   = rank + (OLD.rank IS NOT NULL),
        def    = def + (OLD.def IS NOT NULL)
    WHERE
        topic_status_id = OLD.topic_status_id
    ;

END;
