CREATE TABLE work_deltas(
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    node_id INTEGER NOT NULL,
    offset INTEGER NOT NULL,
    start INTEGER NOT NULL,
    stop INTEGER NOT NULL,
    gtime_start INTEGER,
    gtime_stop INTEGER,
    comment TEXT,
    bill BOOL NOT NULL,
    FOREIGN KEY(id) REFERENCES deltas(id) ON DELETE CASCADE,
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE,
    FOREIGN KEY(node_id) REFERENCES nodes(id) ON DELETE CASCADE,
    CONSTRAINT start_stop_order CHECK(stop >= start),
    CONSTRAINT offset_check CHECK(offset BETWEEN -64800 AND 64800)
    CONSTRAINT bill_is_bool CHECK(bill BETWEEN 0 AND 1)
);


CREATE INDEX
    work_deltas_gtime_start_gtime_stop
ON
    work_deltas(gtime_start,gtime_stop)
;


CREATE TRIGGER
    work_deltas_bi_1
BEFORE INSERT ON
    work_deltas
FOR EACH ROW WHEN
    -- intersects with existing delta
    EXISTS (
        SELECT
            1
        FROM
            work_deltas wd
        WHERE
            -- just checking the start time at insert
            NEW.start + NEW.offset > wd.gtime_start AND
            NEW.start + NEW.offset < wd.gtime_stop
    )
BEGIN
    SELECT RAISE(ABORT, 'cannot overlap work_deltas (insert)');
END;


CREATE TRIGGER
    work_deltas_ai_1
AFTER INSERT ON
    work_deltas
FOR EACH ROW
BEGIN

    UPDATE
        work_deltas
    SET
        gtime_start = NEW.start + NEW.offset,
        gtime_stop  = NEW.stop  + NEW.offset
    WHERE
        id = NEW.id
    ;

END;
