#!perl

use strict;
use warnings;

# This test was generated by inc::CheckJiraInChanges

use Test::More tests => 1;

my @commits = split /\n/, <<'EOC';
63a750e PERL-492 Implemented server selection tests
41349b3 PERL-489 fix BSON crash encoding reference to PVNV etc.
a484d5d PERL-477 support cursor in list indexes/collections
498a48e PERL-401 fixed index creation to always have a non-zero write concern
4a16e4e PERL-423 improved documentation of cursor snapshot mode
ce58684 PERL-259 implemented write commands for MongoDB 2.6+
10f9889 PERL-93 implemented awaitData
34c80db PERL-371 test host localhost:port handled correctly
e111473 PERL-466 changed read_preference on MongoClient to be immutable
471cd0a PERL-466 added read preference to Database and Collection classes
8e8923b fix regression from PERL-465 cherry pick
94dfd57 PERL-465 added support for arbitrary options on index creation
acbb474 PERL-135 set write_concern at db and collection level

EOC

my %ticket_map;
for my $commit ( @commits ) {
    for my $ticket ( $commit =~ /PERL-(\d+)/g ) {
        next if $ENV{CHECK_JIRA_SKIP}
            && grep { $ticket eq $_ } split " ", $ENV{CHECK_JIRA_SKIP};
        $ticket_map{$ticket} ||= [];
        push @{$ticket_map{$ticket}}, $commit;
    }
}

# grab Changes lines from new version to next un-indented line
open my $fh, "<:encoding(UTF-8)", "Changes";
my @content = grep { /^v0.999.998.2(?:\s+|$)/ ... /^\S/ } <$fh>;

# drop the version line
shift @content;

# drop unindented last line and trailing blank lines
pop @content while ( @content && $content[-1] =~ /^(?:\S|\s*$)/ );

my $changelog = join(" ", @content);

my @bad;
for my $ticket ( keys %ticket_map ) {
    if ( index( $changelog, "PERL-$ticket" ) < 0 ) {
       push @bad, $ticket;
    }
}

if ( !@commits ) {
    pass("No commits with Jira tickets");
}
else {
    ok( ! scalar @bad, "Jira tickets in Changes")
        or diag "Jira tickets missing:\n"
        . join("\n", map { "  * $_" } map { @{$ticket_map{$_}} } sort { $a <=> $b } @bad );
}
