##-*- Mode: CPerl -*-
##
## File: DDC::Query::Parser.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: pure-perl DDC query parser, top-level [DEPRECATED]
##======================================================================

package DDC::Query::Parser;
use DDC::Utils qw(:escape);
use DDC::Query;
use DDC::Query::Filter;
use DDC::Query::yylexer;
use DDC::Query::yyparser;

use strict;

##======================================================================
## Globals etc.
our @ISA = qw();


##======================================================================
## $qp = $CLASS_OR_OBJ->new(%args)
## + abstract constructor
## + you should probably call free() before destroying the object to be safe
## + object structure, %args:
##   {
##    ##-- Status flags
##    error => $current_errstr, ##-- false indicates no error
##
##    ##-- parsed data
##    #query  => $query,          ##-- most recently parsed query, a DDC::Query object
##    #filters => \@filters,      ##-- query filters
##
##    ##-- Underlying lexer/parser pair
##    lexer  => $yylexer,   ##-- a DDC::YYLexer object
##    parser => $yyparser,  ##-- a DDC::YYParser object
##    yydebug => $mask,     ##-- yydebug value
##
##    ##-- Closures
##    yylex    => \&yylex,   ##-- yapp-friendly lexer sub
##    yyerror  => \&yyerror, ##-- yapp-friendly parser sub
##   }
sub new {
  my $that = shift;
  my $qp = bless({
		  ##-- Status flags
		  error => undef,

		  ##-- Underlying lexer/parser pair
		  lexer  => DDC::Query::yylexer->new(),
		  parser => DDC::Query::yyparser->new(),

		  ##-- runtime data
		  query   => undef,
		  filters => undef,

		  ##-- parser debugging
		  yydebug  => 0, # no debug
		  #yydebug => 0x01,  # lexer debug
		  #yydebug => 0x02,  # state info
		  #yydebug => 0x04,  # driver actions (shift/reduce/etc.)
		  #yydebug => 0x08,  # stack dump
		  #yydebug => 0x10,  # Error recovery trace
		  #yydebug => 0x01 | 0x02 | 0x04 | 0x08, # almost everything
		  #yydebug => 0xffffffff, ##-- pretty much everything

		  ##-- User args
		  @_
		 },
		 ref($that)||$that);
  $qp->getClosures();
  return $qp;
}

## undef = $qp->free()
##  + clears $qp itself, as well as $qp->{parser}{USER}
##  + makes $qp subsequently useless, but destroyable
sub free {
  my $qp = shift;
  delete($qp->{parser}{USER}) if ($qp->{parser});
  %$qp = qw();
}

## $qp = $qp->getClosures()
##  + compiles lexer & parser closures
sub getClosures {
  my $qp = shift;
  delete(@$qp{qw(yylex yyerror)});
  $qp->{yylex}   = $qp->_yylex_sub();
  $qp->{yyerror} = $qp->_yyerror_sub();
  return $qp;
}

##======================================================================
## API: Input selection

## undef = $qp->reset()
##  + reset all parse-relevant data structures
sub reset {
  my $qp = shift;

  ##-- status flags
  delete($qp->{error});

  ##-- runtime data
  delete(@$qp{qw(query filters)});

  ##-- lexer & parser state
  $qp->{lexer}->reset();
  delete($qp->{parser}{USER}{hint});
  $qp->{parser}{USER}{qp}      = $qp;
  $qp->{parser}{USER}{lex}     = $qp->{lexer};
}

## $qp = $qp->from($which,$src, %opts)
##  + wraps $qp->{lexer}->from()
##  + $which is one of qw(fh file string)
##  + $src is the actual source (default: 'string')
##  + %opts may contain (src=>$name)
sub from {
  return $_[0]{lexer}->from(@_[1..$#_]) ? $_[0] : undef;
}

## $qp = $qp->fromFile($filename_or_handle,%opts)
##  + wraps $qp->{lexer}->fromFile()
sub fromFile {
  return $_[0]{lexer}->fromFile(@_[1..$#_]) ? $_[0] : undef;
}

## $qp = $qp->fromFh($fh,%opts)
##  + wraps $qp->{lexer}->fromFh()
sub fromFh {
  return $_[0]{lexer}->fromFh(@_[1..$#_]) ? $_[0] : undef;
}

## $qp = $qp->fromString($str,%opts)
## $qp = $qp->fromString(\$str,%opts)
##  + wraps $qp->{lexer}->fromString()
sub fromString {
  return $_[0]{lexer}->fromString(@_[1..$#_]) ? $_[0] : undef;
}


##======================================================================
## API: High-level Parsing

## $query_or_undef = $qp->parse(string=>$str)
## $query_or_undef = $qp->parse(string=>\$str)
## $query_or_undef = $qp->parse(file=>$filename)
## $query_or_undef = $qp->parse(fh=>$handle)
sub parse {
  my $qp = shift;
  $qp->reset();
  $qp->from(@_);
  my $result = eval { $qp->yyparse(); };
  delete($qp->{parser}{qp});       ##-- chop circular reference we know how to get at...
  delete($qp->{parser}{USER}{qp}); ##-- chop circular reference we know how to get at...

  ##-- how'd it go?
  return $result if (!$@);
  $qp->{error} = $@ if (!$qp->{error});
  return undef;
}

## $query_or_undef = $qp->yyparse()
##  + parses from currently selected input source; no reset or error catching
sub yyparse {
  my $qp = shift;
  return $qp->{parser}->YYParse(
				yylex   => $qp->{yylex},
				yyerror => $qp->{yyerror},
				yydebug => $qp->{yydebug},
			       );
}

##======================================================================
## API: Mid-level: Query Generation API

##------------------------------------------------------
## Query Generation API: Mid-level: generic

## $q = $parser->newq($class,%args)
##  + wrapper for DDC::Query->new(class=>$class,%args); called by yapp parser
sub newq {
  return DDC::Query->new(class=>$_[1],@_[2..$#_]);
}

## $qf = $parser->newf($class,%args)
##  + wrapper for DDC::Query::Filter->new(class=>$class,%args); called by yapp parser
sub newf {
  return DDC::Query::Filter->new(class=>$_[1],@_[2..$#_]);
}


##======================================================================
## API: Low-LEVEL: Parse::Lex <-> Parse::Yapp interface
##
## - REQUIREMENTS on yylex() sub:
##   + Yapp-compatible lexing routine
##   + reads input and returns token values to the parser
##   + our only argument ($MyParser) is the YYParser object itself
##   + We return a list ($TOKENTYPE, $TOKENVAL) of the next tokens to the parser
##   + on end-of-input, we should return the list ('', undef)
##

## \&yylex_sub = $qp->_yylex_sub()
##   + returns a Parse::Yapp-friendly lexer subroutine
sub _yylex_sub {
  my $qp = shift;
  my ($type,$text,@expect);

  return sub {
    $qp->{yyexpect} = [$qp->{parser}->YYExpect];
    ($type,$text) = $qp->{lexer}->yylex();
    return ('',undef) if ($type eq '__EOF__');

    ##-- un-escape single-quoted symbols
    if ($type =~ /^SQ_(.*)$/) {
      $type = $1;
      $text = unescapeq($text);
    }
    elsif ($type eq 'SYMBOL') {
      $text = unescape($text);
    }

    if ($qp->{yydebug} & 0x01) {
      print STDERR ": yylex(): type=($type) ; text=($text)\n";
    }

    return ($type,$text);
  };
}


## \&yyerror_sub = $qp->_yyerror_sub()
##  + returns error subroutine for the underlying Yapp parser
sub _yyerror_sub {
  my $qp = shift;
  my (%expect);
  return sub {
    @expect{@{$qp->{yyexpect}||[]}}=qw();
    @expect{@{$qp->{yyexpect}||[]}, $qp->{parser}->YYExpect}=qw();
    $qp->{error} = ("Syntax error in ".$qp->{lexer}->yywhere().":\n"
		    #." > Expected one of (here): ".join(', ', map {$_ eq '' ? '__EOF__' : $_} $qp->{parser}->YYExpect)."\n"
		    #." > Expected one of (prev): ".join(', ', map {$_ eq '' ? '__EOF__' : $_} @{$qp->{yyexpect}||['???']})."\n"
		    ." > Expected one of: ".join(', ', sort map {$_ eq '' ? '__EOF__' : $_} keys %expect)."\n"
		    ." > Got: ".$qp->{lexer}->yytype.' "'.$qp->{lexer}->yytext."\"\n"
		   );
  };
}


1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl

##========================================================================
## NAME
=pod

=head1 NAME

DDC::Query::Parser - pure-perl DDC query parser, top-level [DEPRECATED]

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 ##========================================================================
 ## PRELIMINARIES
 
 use DDC::Query::Parser;
 
 ##========================================================================
 ## Constructors etc.
 
 $qp = $CLASS_OR_OBJ->new(%args);
 undef = $qp->free();
 $qp = $qp->getClosures();
 
 ##========================================================================
 ## API: Input selection
 
 undef = $qp->reset();
 $qp = $qp->from($which,$src, %opts);
 $qp = $qp->fromFile($filename_or_handle,%opts);
 $qp = $qp->fromFh($fh,%opts);
 $qp = $qp->fromString($str,%opts);
 
 ##========================================================================
 ## API: High-level Parsing
 
 $query_or_undef = $qp->parse(string=>$str);
 $query_or_undef = $qp->yyparse();
 
 ##========================================================================
 ## Query Generation API: Mid-level: generic
 
 $q = $parser->newq($class,%args);
 $qf = $parser->newf($class,%args);
 \&yylex_sub = $qp->_yylex_sub();
 \&yyerror_sub = $qp->_yyerror_sub();
 

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

The DDC::Parser module provides
pure-perl wrapper classes for parsing DDC queries.
Its use is deprecated in favor of the L<DDC::XS::CQueryCompiler|DDC::XS::CQueryCompiler>
module providing direct access to the underlying C++ libraries.

=cut


##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Parser: Constructors etc.
=pod

=head2 Constructors etc.

=over 4

=item new

 $qp = $CLASS_OR_OBJ->new(%args);

Abstract constructor;
you should probably call free() before destroying the object to be safe.

object structure, %args:

   {
    ##-- Status flags
    error => $current_errstr, ##-- false indicates no error
    ##-- parsed data
    #query  => $query,          ##-- most recently parsed query, a DDC::Query object
    #filters => \@filters,      ##-- query filters
    ##-- Underlying lexer/parser pair
    lexer  => $yylexer,   ##-- a DDC::YYLexer object
    parser => $yyparser,  ##-- a DDC::YYParser object
    yydebug => $mask,     ##-- yydebug value
    ##-- Closures
    yylex    => \&yylex,   ##-- yapp-friendly lexer sub
    yyerror  => \&yyerror, ##-- yapp-friendly parser sub
   }


=item free

 undef = $qp->free();


=over 4

=item *

clears $qp itself, as well as $qp-E<gt>{parser}{USER}

=item *

makes $qp subsequently useless, but destroyable

=back

=item getClosures

 $qp = $qp->getClosures();

compiles lexer & parser closures

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Parser: API: Input selection
=pod

=head2 API: Input selection

=over 4

=item reset

 undef = $qp->reset();

reset all parse-relevant data structures

=item from

 $qp = $qp->from($which,$src, %opts);


=over 4


=item *

wraps $qp-E<gt>{lexer}-E<gt>from()

=item *

$which is one of qw(fh file string)

=item *

$src is the actual source (default: 'string')

=item *

%opts may contain (src=E<gt>$name)

=back

=item fromFile

 $qp = $qp->fromFile($filename_or_handle,%opts);

wraps $qp-E<gt>{lexer}-E<gt>fromFile()

=item fromFh

 $qp = $qp->fromFh($fh,%opts);

wraps $qp-E<gt>{lexer}-E<gt>fromFh()

=item fromString

 $qp = $qp->fromString($str,%opts);
 $qp = $qp->fromString(\$str,%opts);

wraps $qp-E<gt>{lexer}-E<gt>fromString()

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Parser: API: High-level Parsing
=pod

=head2 API: High-level Parsing

=over 4

=item parse

 $query_or_undef = $qp->parse(string=>$str);
 $query_or_undef = $qp->parse(string=>\$str)
 $query_or_undef = $qp->parse(file=>$filename)
 $query_or_undef = $qp->parse(fh=>$handle)

=item yyparse

 $query_or_undef = $qp->yyparse();

parses from currently selected input source; no reset or error catching

=back

=cut

##----------------------------------------------------------------
## DESCRIPTION: DDC::Query::Parser: Query Generation API: Mid-level: generic
=pod

=head2 Query Generation API: Mid-level: generic

=over 4

=item newq

 $q = $parser->newq($class,%args);

wrapper for DDC::Query-E<gt>new(class=E<gt>$class,%args); called by yapp parser

=item newf

 $qf = $parser->newf($class,%args);

wrapper for DDC::Query::Filter-E<gt>new(class=E<gt>$class,%args); called by yapp parser

=item _yylex_sub

 \&yylex_sub = $qp->_yylex_sub();

returns a Parse::Yapp-friendly lexer subroutine

=item _yyerror_sub

 \&yyerror_sub = $qp->_yyerror_sub();

returns error subroutine for the underlying Yapp parser

=back

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
=pod

=head1 ACKNOWLEDGEMENTS

perl by Larry Wall.

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT

Copyright (c) 2011-2015, Bryan Jurish.  All rights reserved.

This package is free software.  You may redistribute it
and/or modify it under the same terms as Perl itself.

=head1 SEE ALSO

perl(1)

=cut
