package WordList::Phrase::SU::Proverb::PeribahasaNet;

our $DATE = '2016-02-10'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"num_words",0,"num_words_contains_whitespace",0,"longest_word_len",undef,"shortest_word_len",undef); # STATS

1;
# ABSTRACT: Sundanese proverbs from peribahasa.net

=pod

=encoding UTF-8

=head1 NAME

WordList::Phrase::SU::Proverb::PeribahasaNet - Sundanese proverbs from peribahasa.net

=head1 VERSION

This document describes version 0.01 of WordList::Phrase::SU::Proverb::PeribahasaNet (from Perl distribution WordList-Phrase-SU-Proverb-PeribahasaNet), released on 2016-02-10.

=head1 SYNOPSIS

 use WordList::Phrase::SU::Proverb::PeribahasaNet;

 my $wl = WordList::Phrase::SU::Proverb::PeribahasaNet->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | longest_word_len                 |       |
 | num_words                        | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                |       |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-Phrase-SU-Proverb-PeribahasaNet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-Phrase-SU-Proverb-PeribahasaNet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-Phrase-SU-Proverb-PeribahasaNet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<http://www.peribahasa.net/peribahasa-sunda.php>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__