package Statocles::Util;
# ABSTRACT: Various utility functions to reduce dependencies
$Statocles::Util::VERSION = '0.049';
use Statocles::Base;
use Exporter 'import';

our @EXPORT_OK = qw(
    dircopy
);


sub dircopy($$) {
    my ( $source, $destination ) = @_;
    $source = Path::Tiny->new( $source );
    $destination = Path::Tiny->new( $destination );
    $destination->mkpath;
    my $iter = $source->iterator({ recurse => 1 });
    while ( my $thing = $iter->() ) {
        my $relative = $thing->relative( $source );
        if ( $thing->is_dir ) {
            mkdir $destination->child( $relative );
        }
        else {
            $thing->copy( $destination->child( $relative ) );
        }
    }
}

1;

__END__

=pod

=head1 NAME

Statocles::Util - Various utility functions to reduce dependencies

=head1 VERSION

version 0.049

=head1 SYNOPSIS

    use Statocles::Util qw( dircopy );

    dircopy $source, $destination;

=head1 DESCRIPTION

This module contains some utility functions to help reduce non-core dependencies.

=head1 SUBROUTINES

=head2 dircopy $source, $destination;

Copy everything in $source to $destination, recursively.

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
