package Statocles::App::Static;
# ABSTRACT: (DEPRECATED) Manage static files like CSS, JS, images, and other untemplated content
$Statocles::App::Static::VERSION = '0.058';
use Statocles::Base 'Class';
use Statocles::Page::File;
with 'Statocles::App';


has store => (
    is => 'ro',
    isa => Store,
    required => 1,
    coerce => Store->coercion,
);


sub pages {
    my ( $self ) = @_;

    warn qq{Statocles::App::Static has been replaced by Statocles::App::Basic and will be removed in 2.0. Change the app class to "Statocles::App::Basic" to silence this message.\n};

    my @pages;
    my $iter = $self->store->find_files( include_documents => 1 );
    FILE: while ( my $path = $iter->() ) {
        # Check for hidden files and folders
        next if $path->basename =~ /^[.]/;
        my $parent = $path->parent;
        while ( !$parent->is_rootdir ) {
            next FILE if $parent->basename =~ /^[.]/;
            $parent = $parent->parent;
        }

        push @pages, Statocles::Page::File->new(
            path => $path,
            file_path => $self->store->path->child( $path ),
        );
    }

    return @pages;
}

1;

__END__

=pod

=head1 NAME

Statocles::App::Static - (DEPRECATED) Manage static files like CSS, JS, images, and other untemplated content

=head1 VERSION

version 0.058

=head1 DESCRIPTION

B<NOTE:> This application's functionality has been added to
L<Statocles::App::Basic>. You can use the Basic app to replace this app. This
class will be removed with v2.0. See L<Statocles::Help::Upgrading>.

This L<Statocles::App|Statocles::App> manages static content with no processing,
perfect for images, stylesheets, scripts, or already-built HTML.

=head1 ATTRIBUTES

=head2 store

The L<store|Statocles::Store> containing this app's files. Required.

=head1 METHODS

=head2 pages

    my @pages = $app->pages;

Get the L<page objects|Statocles::Page> for this app.

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
