use Test::More tests => 5;
use constant EPS     => 1e-3;
use Array::Compare;

use Statistics::Data::Dichotomize;
my $ddat = Statistics::Data::Dichotomize->new();

my @raw_data = ();
my @res_data = ();
my $val;
my $data_aref;
my $debug    = 0;
my $cmp_aref = Array::Compare->new;

# cut method
@raw_data = ( 4, 3, 3, 5, 3, 4, 5, 6, 3, 5, 3, 3, 6, 4, 4, 7, 6, 4, 7, 3 );
( $data_aref, $val ) =
  $ddat->cut( data => \@raw_data, value => \&Statistics::Lite::median );
ok( equal( $val, 4 ), "median cut value  $val != 4" );

( $data_aref, $val ) = $ddat->cut( data => \@raw_data, value => 'median' );
ok( equal( $val, 4 ), "median cut value  $val != 4" );

@res_data = ( 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0 );
( $data_aref, $val ) = $ddat->cut( data => \@raw_data, value => 5 );
diag(
    "cut() method:\n\texpected\t=>\t",
    join( '', @res_data ),
    "\n\tobserved\t=>\t", join( '', @$data_aref ),
    "\n\tvalue\t=>\t", $val
) if $debug;
ok( $cmp_aref->simple_compare( \@res_data, $data_aref ),
    "Error in cut results" );

# - same but using prior load() of data:
$ddat->load( \@raw_data );
( $data_aref, $val ) = $ddat->cut( index => 0, value => 5 );
diag(
    "cut() method (with prior data load):\n\texpected\t=>\t",
    join( '', @res_data ),
    "\n\tobserved\t=>\t",
    join( '', @$data_aref ),
    "\n\tvalue\t=>\t",
    $val
) if $debug;
ok( $cmp_aref->simple_compare( \@res_data, $data_aref ),
    "Error in cut results" );

# using custom cut fn (mean = 4):
@res_data = ( 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0 );
( $data_aref, $val ) = $ddat->cut(
    index => 0,
    value => sub {
        my @ari = @_;
        my $sum = 0;
        for (@ari) { $sum += $_ }
        return int( $sum / ( scalar @ari ) );
    }
);

diag(
"cut() method (with prior data load using custom sub for value):\n\texpected\t=>\t",
    join( '', @res_data ),
    "\n\tobserved\t=>\t",
    join( '', @$data_aref ),
    "\n\tvalue\t=>\t",
    $val
) if $debug;
ok( $cmp_aref->simple_compare( \@res_data, $data_aref ),
    "Error in cut results" );

sub equal {
    return 0 if !defined $_[0] || !defined $_[1];
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
1;
