use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.05\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = "any version";
    my $pv = ($^V || $]);
    $v .= "perl: $pv (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('Dist::Zilla','4.102341') };
eval { $v .= pmver('Dist::Zilla::Plugin::AutoPrereqs','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::AutoVersion','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::GitFmtChanges','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::GithubMeta','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::InstallGuide','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::MetaJSON','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::OurPkgVersion','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::PerlTidy','0.11') };
eval { $v .= pmver('Dist::Zilla::Plugin::PodWeaver','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::ReadmeFromPod','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::ReportPhase','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::ReportVersions::Tiny','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::Signature','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::TaskWeaver','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::Test::Pod::No404s','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::Test::UseAllModules','any version') };
eval { $v .= pmver('Dist::Zilla::Plugin::VersionFromModule','any version') };
eval { $v .= pmver('Dist::Zilla::PluginBundle::Git','any version') };
eval { $v .= pmver('Dist::Zilla::PluginBundle::TestingMania','0.012') };
eval { $v .= pmver('Dist::Zilla::Role::PluginBundle::Easy','any version') };
eval { $v .= pmver('ExtUtils::MakeMaker','6.30') };
eval { $v .= pmver('File::Find','any version') };
eval { $v .= pmver('File::Temp','any version') };
eval { $v .= pmver('Moose','0.99') };
eval { $v .= pmver('Pod::Elemental','0.102362') };
eval { $v .= pmver('Pod::Elemental::Transformer::List','any version') };
eval { $v .= pmver('Pod::Weaver::Config::Assembler','any version') };
eval { $v .= pmver('Pod::Weaver::Plugin::Encoding','0.01') };
eval { $v .= pmver('Pod::Weaver::Plugin::EnsureUniqueSections','any version') };
eval { $v .= pmver('Pod::Weaver::Section::BugsAndLimitations','any version') };
eval { $v .= pmver('Pod::Weaver::Section::SeeAlso','1.002') };
eval { $v .= pmver('Pod::Weaver::Section::Support','1.003') };
eval { $v .= pmver('Pod::Weaver::Section::WarrantyDisclaimer','0.103511') };
eval { $v .= pmver('Test::More','0.88') };
eval { $v .= pmver('Test::UseAllModules','any version') };
eval { $v .= pmver('namespace::autoclean','0.09') };
eval { $v .= pmver('namespace::clean','any version') };
eval { $v .= pmver('strict','any version') };
eval { $v .= pmver('version','any version') };
eval { $v .= pmver('warnings','any version') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
