package Acme::MetaSyntactic::mlpfim;

use strict;
use warnings;

our $VERSION = '0.0.1';

use parent 'Acme::MetaSyntactic::List';

__PACKAGE__->init();

1;

=pod

=head1 NAME

Acme::MetaSyntactic::mlpfim - a meta syntactic variable for everypony!

=head1 VERSION

version 0.0.1

=head1 DESCRIPTION

Acme::MetaSyntactic::mlpfim is a L<Acme::MetaSyntactic> theme which provides
names of characters from the I<My Little Pony - Friendship is Magic> franchise.
See L<http://mlp.wikia.com/wiki/Characters>.

=head1 COPYRIGHTS AND TRADEMARKS INFORMATION

As far as the originators of this CPAN distribution (= Shlomi Fish)
is concerned, this distribution may be used under the terms of the MIT/X11
licence. However, it contains data that may infringe on the copyrights and
trademarks of the owners of the I<My Little Pony - Friendship is Magic>
franchise. Note that all the names were collected from this page in the MLP-FiM
Wikia wiki: L<http://mlp.wikia.com/wiki/Characters> .

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-MetaSyntactic-mlpfim or by
email to bug-acme-metasyntactic-mlpfim@rt.cpan.org.

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Perldoc

You can find documentation for this module with the perldoc command.

  perldoc Acme::MetaSyntactic::mlpfim

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<http://metacpan.org/release/Acme-MetaSyntactic-mlpfim>

=item *

Search CPAN

The default CPAN search engine, useful to view POD in HTML format.

L<http://search.cpan.org/dist/Acme-MetaSyntactic-mlpfim>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-MetaSyntactic-mlpfim>

=item *

AnnoCPAN

The AnnoCPAN is a website that allows community annotations of Perl module documentation.

L<http://annocpan.org/dist/Acme-MetaSyntactic-mlpfim>

=item *

CPAN Ratings

The CPAN Ratings is a website that allows community ratings and reviews of Perl modules.

L<http://cpanratings.perl.org/d/Acme-MetaSyntactic-mlpfim>

=item *

CPAN Forum

The CPAN Forum is a web forum for discussing Perl modules.

L<http://cpanforum.com/dist/Acme-MetaSyntactic-mlpfim>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/Acme-MetaSyntactic-mlpfim>

=item *

CPAN Testers

The CPAN Testers is a network of smokers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/A/Acme-MetaSyntactic-mlpfim>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=Acme-MetaSyntactic-mlpfim>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=Acme::MetaSyntactic::mlpfim>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-acme-metasyntactic-mlpfim at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=Acme-MetaSyntactic-mlpfim>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<http://github.com/shlomif/perl-Acme-MetaSyntactic-mlpfim>

  git clone https://github.com/shlomif/perl-Acme-MetaSyntactic-mlpfim.git

=cut

__DATA__
# names
Apple_Bloom
Apple_Rose
Apple_Strudel
Applejack
Aunt_Orange
Auntie_Applesauce
Babs_Seed
Big_McIntosh
Diamond_Tiara
Discword
Featherweight
Fluttershy
Goldie_Delicious
Granny_Smith
Hayseed_Turnip_Truck
King_Sombra
Lord_Tirek
Maud_Pie
Mr_Cake
Mrs_Cake
Nightmare_Moon
Peachy_Pie
Pinkie_Pie
Pipsqueak
Pound_Cake
Prince_Blueblood
Princess_Amore
Princess_Cadance
Princess_Celestia
Princess_Luna
Pumpkin_Cake
Queen_Chrysalis
Rainbow_Dash
Rarity
Rumble
Sctootaloo
Shining_Armor
Silver_Spoon
Snails
Snips
Spike
Starlight_Glimmer
Sunny_Daze
Sweetie_Belle
Twilight_Sparkle
Uncle_Orange
Zipporwhill
braeburn
twist
