package Google::Ads::AdWords::v201509::AdUrlUpgrade;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201509' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %adId_of :ATTR(:get<adId>);
my %finalUrl_of :ATTR(:get<finalUrl>);
my %finalMobileUrl_of :ATTR(:get<finalMobileUrl>);
my %trackingUrlTemplate_of :ATTR(:get<trackingUrlTemplate>);

__PACKAGE__->_factory(
    [ qw(        adId
        finalUrl
        finalMobileUrl
        trackingUrlTemplate

    ) ],
    {
        'adId' => \%adId_of,
        'finalUrl' => \%finalUrl_of,
        'finalMobileUrl' => \%finalMobileUrl_of,
        'trackingUrlTemplate' => \%trackingUrlTemplate_of,
    },
    {
        'adId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'finalUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'finalMobileUrl' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'trackingUrlTemplate' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'adId' => 'adId',
        'finalUrl' => 'finalUrl',
        'finalMobileUrl' => 'finalMobileUrl',
        'trackingUrlTemplate' => 'trackingUrlTemplate',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201509::AdUrlUpgrade

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
AdUrlUpgrade from the namespace https://adwords.google.com/api/adwords/cm/v201509.

Represents an upgrade operation to upgrade Ad.url. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * adId


=item * finalUrl


=item * finalMobileUrl


=item * trackingUrlTemplate




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

