# generated with h2fields.pl
package Net::NfDump::Fields;
our %NFL_FIELDS_INT = (
	0x00010064 => 'first',
	0x00020064 => 'last',
	0x00030064 => 'received',
	0x00040064 => 'bytes',
	0x00050064 => 'pkts',
	0x00060064 => 'outbytes',
	0x00070064 => 'outpkts',
	0x00080064 => 'flows',
	0x00090016 => 'srcport',
	0x000a0016 => 'dstport',
	0x000b0008 => 'tcpflags',
	0x000c00a1 => 'srcip',
	0x000d00a1 => 'dstip',
	0x000e00a1 => 'nexthop',
	0x000f0008 => 'srcmask',
	0x00100008 => 'dstmask',
	0x00110008 => 'tos',
	0x00130008 => 'dsttos',
	0x00140032 => 'srcas',
	0x00150032 => 'dstas',
	0x00160032 => 'nextas',
	0x00170032 => 'prevas',
	0x001800a1 => 'bgpnexthop',
	0x00190008 => 'proto',
	0x00200016 => 'srcvlan',
	0x00210016 => 'dstvlan',
	0x002200a2 => 'insrcmac',
	0x002300a2 => 'outsrcmac',
	0x002400a2 => 'indstmac',
	0x002500a2 => 'outdstmac',
	0x002600ab => 'mpls',
	0x00270016 => 'inif',
	0x00280016 => 'outif',
	0x00290008 => 'dir',
	0x00300008 => 'fwd',
	0x003100a1 => 'router',
	0x00320008 => 'systype',
	0x00340064 => 'eventtime',
	0x00350032 => 'connid',
	0x00360008 => 'icmpcode',
	0x00370008 => 'icmptype',
	0x00380016 => 'xevent',
	0x003900a1 => 'xsrcip',
	0x003a0008 => 'sysid',
	0x004000a1 => 'xdstip',
	0x00410016 => 'xsrcport',
	0x00420016 => 'xdstport',
	0x00430032 => 'iacl',
	0x00440032 => 'iace',
	0x00450032 => 'ixace',
	0x00460032 => 'eacl',
	0x00470032 => 'eace',
	0x00480032 => 'exace',
	0x004900aa => 'username',
	0x00500032 => 'ingressvrfid',
	0x00510008 => 'eventflag',
	0x00520032 => 'egressvrfid',
	0x00530016 => 'blockstart',
	0x00540016 => 'blockend',
	0x00550016 => 'blockstep',
	0x00560016 => 'blocksize',
	0x00570064 => 'cl',
	0x00580064 => 'sl',
	0x00590064 => 'al',
);

our %NFL_FIELDS_TXT = (
	'first' => 0x00010064,
	'last' => 0x00020064,
	'received' => 0x00030064,
	'bytes' => 0x00040064,
	'pkts' => 0x00050064,
	'outbytes' => 0x00060064,
	'outpkts' => 0x00070064,
	'flows' => 0x00080064,
	'srcport' => 0x00090016,
	'dstport' => 0x000a0016,
	'tcpflags' => 0x000b0008,
	'srcip' => 0x000c00a1,
	'dstip' => 0x000d00a1,
	'nexthop' => 0x000e00a1,
	'srcmask' => 0x000f0008,
	'dstmask' => 0x00100008,
	'tos' => 0x00110008,
	'dsttos' => 0x00130008,
	'srcas' => 0x00140032,
	'dstas' => 0x00150032,
	'nextas' => 0x00160032,
	'prevas' => 0x00170032,
	'bgpnexthop' => 0x001800a1,
	'proto' => 0x00190008,
	'srcvlan' => 0x00200016,
	'dstvlan' => 0x00210016,
	'insrcmac' => 0x002200a2,
	'outsrcmac' => 0x002300a2,
	'indstmac' => 0x002400a2,
	'outdstmac' => 0x002500a2,
	'mpls' => 0x002600ab,
	'inif' => 0x00270016,
	'outif' => 0x00280016,
	'dir' => 0x00290008,
	'fwd' => 0x00300008,
	'router' => 0x003100a1,
	'systype' => 0x00320008,
	'eventtime' => 0x00340064,
	'connid' => 0x00350032,
	'icmpcode' => 0x00360008,
	'icmptype' => 0x00370008,
	'xevent' => 0x00380016,
	'xsrcip' => 0x003900a1,
	'sysid' => 0x003a0008,
	'xdstip' => 0x004000a1,
	'xsrcport' => 0x00410016,
	'xdstport' => 0x00420016,
	'iacl' => 0x00430032,
	'iace' => 0x00440032,
	'ixace' => 0x00450032,
	'eacl' => 0x00460032,
	'eace' => 0x00470032,
	'exace' => 0x00480032,
	'username' => 0x004900aa,
	'ingressvrfid' => 0x00500032,
	'eventflag' => 0x00510008,
	'egressvrfid' => 0x00520032,
	'blockstart' => 0x00530016,
	'blockend' => 0x00540016,
	'blockstep' => 0x00550016,
	'blocksize' => 0x00560016,
	'cl' => 0x00570064,
	'sl' => 0x00580064,
	'al' => 0x00590064,
);

=pod

=head1 LIST OF ITEMS SUPPORTED BY Net::NfDump

  first => Timestamp of the first packet seen (in miliseconds)
  last => Timestamp of the last packet seen (in miliseconds)
  received => Timestamp regarding when the packet was received by collector
  bytes => The number of bytes
  pkts => The number of packets
  outbytes => The number of output bytes
  outpkts => The number of output packets
  flows => The number of flows (aggregated)
  srcport => Source port
  dstport => Destination port
  tcpflags => TCP flags
  srcip => Source IP address
  dstip => Destination IP address
  nexthop => IP next hop
  srcmask => Source mask
  dstmask => Destination mask
  tos => Source type of service
  dsttos => Destination type of service
  srcas => Source AS number
  dstas => Destination AS number
  nextas => BGP Next AS
  prevas => BGP Previous AS
  bgpnexthop => BGP next hop
  proto => IP protocol
  srcvlan => Source vlan label
  dstvlan => Destination vlan label
  insrcmac => In source MAC address
  outsrcmac => Out destination MAC address
  indstmac => In destination MAC address
  outdstmac => Out source MAC address
  mpls => MPLS labels
  inif => SNMP input interface number
  outif => SNMP output interface number
  dir => Flow directions ingress/egress
  fwd => Forwarding status
  router => Exporting router IP
  systype => Type of exporter
  eventtime => NSEL The time that the flow was created
  connid => NSEL An identifier of a unique flow for the device
  icmpcode => NSEL ICMP code value
  icmptype => NSEL ICMP type value
  xevent => NSEL Extended event code
  xsrcip => NSEL Mapped source IPv4 address
  sysid => Internal SysID of exporter
  xdstip => NSEL Mapped destination IPv4 address
  xsrcport => NSEL Mapped source port
  xdstport => NSEL Mapped destination port
  iacl => Hash value or ID of the ACL name
  iace => Hash value or ID of the ACL name
  ixace => Hash value or ID of an extended ACE configuration
  eacl => Hash value or ID of the ACL name
  eace => Hash value or ID of the ACL name
  exace => Hash value or ID of an extended ACE configuration
  username => NSEL username
  ingressvrfid => NEL NAT ingress vrf id
  eventflag => NAT event flag (always set to 1 by nfdump)
  egressvrfid => NAT egress VRF ID
  blockstart => NAT pool block start
  blockend => NAT pool block end
  blockstep => NAT pool block step
  blocksize => NAT pool block size
  cl => nprobe latency client_nw_delay_usec
  sl => nprobe latency server_nw_delay_usec
  al => nprobe latency appl_latency_usec

=cut

