package Pcore::Whois::Server;

use Pcore -class;
use Pcore::Whois::Data;

has host       => ( is => 'ro', isa => Str, required => 1 );                      # whois host addr
has req_format => ( is => 'ro', isa => Str, default  => qq[<: QUERY :>$CRLF] );
has is_verisign   => ( is => 'ro', isa => Bool );
has not_found_md5 => ( is => 'ro', isa => Str );

has status  => ( is => 'ro', isa => Int,               default => 0,                      init_arg => undef );
has reason  => ( is => 'ro', isa => Str,               default => 'Server was not found', init_arg => undef );
has threads => ( is => 'ro', isa => PositiveOrZeroInt, default => 0,                      init_arg => undef );    # total active threads num.

around new => sub ( $orig, $self, $host ) {
    my $args = { host => $host };

    $args->@{ keys $Pcore::Whois::Data::SERVER->{$host}->%* } = values $Pcore::Whois::Data::SERVER->{$host}->%* if exists $Pcore::Whois::Data::SERVER->{$host};

    return $self->$orig($args);
};

sub validate ( $self, $whois, $tld, $cb ) {
    $whois->run_request(
        $self,
        "$Pcore::Whois::Data::NOT_AVAIL_DOMAIN.$tld",
        sub ( $domain, $res ) {
            $self->{status} = $res->status;

            $self->{reason} = $res->reason;

            $self->{not_found_md5} = $res->md5 if $res->is_success;

            $cb->($self);

            return;
        }
    );

    return;
}

sub get_request_content ( $self, $query ) {
    return q[domain ] . $query . $CRLF if $self->is_verisign;

    return $query . q[/e] . $CRLF if $self->host =~ /[.]jp\z/smi;

    return $self->req_format =~ s/<: QUERY :>/$query/smgr;
}

1;
## -----SOURCE FILTER LOG BEGIN-----
##
## PerlCritic profile "pcore-script" policy violations:
## ┌──────┬──────────────────────┬────────────────────────────────────────────────────────────────────────────────────────────────────────────────┐
## │ Sev. │ Lines                │ Policy                                                                                                         │
## ╞══════╪══════════════════════╪════════════════════════════════════════════════════════════════════════════════════════════════════════════════╡
## │    3 │ 18                   │ References::ProhibitDoubleSigils - Double-sigil dereference                                                    │
## └──────┴──────────────────────┴────────────────────────────────────────────────────────────────────────────────────────────────────────────────┘
##
## -----SOURCE FILTER LOG END-----
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Server

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
