package Pcore::Whois::Response;

use Pcore -class;
use Pcore::Whois::Data qw[:CONST];

has query => ( is => 'ro', isa => Str, required => 1 );
has server => ( is => 'ro' );
has raw => ( is => 'ro', isa => Maybe [ScalarRef] );

has _status => ( is => 'ro', isa => Int, required => 1, init_arg => 'status' );
has status => ( is => 'lazy', isa => Int, init_arg => undef );

has _reason => ( is => 'ro', isa => Str, required => 1, init_arg => 'reason' );
has reason => ( is => 'lazy', isa => Str, init_arg => undef );

has cached => ( is => 'ro', isa => Bool, default => 0 );

has is_success  => ( is => 'lazy', isa => Bool, init_arg => undef );    # no network error, no ban, server return some data
has is_verisign => ( is => 'lazy', isa => Bool, init_arg => undef );    # true, if invalid request to the verisign server
has md5         => ( is => 'lazy', isa => Str,  init_arg => undef );
has is_found    => ( is => 'lazy', isa => Bool, init_arg => undef );    # whois response is valid, and domain was found on whois server (not available for registration)
has expire => ( is => 'lazy', isa => Maybe [Int], init_arg => undef );

sub _build_status ($self) {
    if ( $self->_status == $WHOIS_STATUS_OK ) {
        return $WHOIS_STATUS_NO_CONTENT if !$self->raw || !length $self->raw->$*;

        # check for ban
        for my $re ( $Pcore::Whois::Data::RATE_LIMIT_RE->@* ) {
            if ( $self->raw->$* =~ $re ) {
                return $WHOIS_STATUS_BANNED;
            }
        }
    }

    return $self->_status;
}

sub _build_reason ($self) {
    if ( $self->status == $WHOIS_STATUS_NO_CONTENT ) {
        return 'No content';
    }
    elsif ( $self->status == $WHOIS_STATUS_BANNED ) {
        return 'IP is banned';
    }
    else {
        return $self->_reason;
    }
}

sub _build_is_success ($self) {
    return $self->status == $WHOIS_STATUS_OK ? 1 : 0;
}

sub _build_is_verisign ($self) {
    if ( $self->is_success ) {
        for my $re ( $Pcore::Whois::Data::VERISIGN_RE->@* ) {
            return 1 if $self->raw->$* =~ $re;
        }
    }

    return 0;
}

sub _build_md5 ($self) {
    return q[] if !$self->is_success;

    my $content = $self->raw->$*;

    # remove comments (lines, started with '#' or '%')
    $content =~ s/^[%#].*?$//smg;

    # remove query
    my $query = $self->query;

    $content =~ s/$query//smgi;

    $content =~ s/[^[:alpha:]]+//smgi;

    return P->digest->md5_hex($content);
}

sub _build_is_found ($self) {
    return 0 if !$self->is_success;

    return 0 if !$self->server->not_found_md5;

    return $self->md5 eq $self->server->not_found_md5 ? 0 : 1;
}

sub _build_expire ($self) {
    return;
}

1;
__END__
=pod

=encoding utf8

=head1 NAME

Pcore::Whois::Response

=head1 SYNOPSIS

=head1 DESCRIPTION

=cut
