# This Makefile.PL for Data-TestImage was generated by
# inc::TestImageMakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.20.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.014000;

use ExtUtils::MakeMaker 6.30;

use File::ShareDir::Install;
install_share dist => "share";


my %WriteMakefileArgs = (
  "ABSTRACT" => "interface for retrieving test images",
  "AUTHOR" => "Zakariyya Mughal <zmughal\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30",
    "File::ShareDir::Install" => "0.03"
  },
  "DISTNAME" => "Data-TestImage",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Data::TestImage",
  "PREREQ_PM" => {
    "Archive::Extract" => 0,
    "File::ShareDir" => 0,
    "File::Temp" => 0,
    "HTTP::Tiny" => 0,
    "List::AllUtils" => 0,
    "Module::Load" => 0,
    "Path::Class" => 0,
    "Try::Tiny" => 0,
    "YAML::Tiny" => 0,
    "constant" => 0,
    "parent" => 0,
    "strict" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => 0,
    "lib" => 0
  },
  "VERSION" => "0.003",
  "test" => {
    "TESTS" => "t/*.t"
  }
);
use lib 'lib';
use lib 't/lib';
use Module::Load;
load 'Data::TestImage';
load 'StubTestImage';
$WriteMakefileArgs{CONFIGURE} = sub {
	my $install_these = $ENV{PERL_DATA_TESTIMAGE_INSTALL} // "USC::SIPI=miscellaneous";
	my @install = split ' ', $install_these;
	for my $package (@install) {
		my ($module_part,$args) = split "=", $package;
		my $module = "Data::TestImage::DB::$module_part";
		load $module;
		$module->install_package($args, verbose => 1);
	}
	return {};
};


my %FallbackPrereqs = (
  "Archive::Extract" => 0,
  "File::ShareDir" => 0,
  "File::Temp" => 0,
  "HTTP::Tiny" => 0,
  "List::AllUtils" => 0,
  "Module::Load" => 0,
  "Path::Class" => 0,
  "Test::More" => 0,
  "Try::Tiny" => 0,
  "YAML::Tiny" => 0,
  "constant" => 0,
  "lib" => 0,
  "parent" => 0,
  "strict" => 0,
  "warnings" => 0
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}


