use strict;
use warnings FATAL => 'all';

package Data::Scan::Printer;

# ABSTRACT: Data::Scan::Printer - Example of a printer consumer for Data::Scan

our $VERSION = '0.001'; # VERSION

# AUTHORITY

use Exporter qw/import/;
use vars qw/@EXPORT/;
use Data::Scan::Impl::Printer;
use Moo;
extends 'Data::Scan';
#
# Using this module intentionaly means caller is ok to pollute its namespace
#
@EXPORT = qw/dspp/;


sub dspp {
  my $consumer = Data::Scan::Impl::Printer->new(%Data::Scan::Printer::Option);
  __PACKAGE__->new(consumer => $consumer)->process(@_);
  print $consumer->output
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Scan::Printer - Data::Scan::Printer - Example of a printer consumer for Data::Scan

=head1 VERSION

version 0.001

=head1 DESCRIPTION

Data::Scan::Printer is polluting user's namespace with a dspp() method, showing our Data::Scan can be used to dump an arbitrary structure.

=head1 SUBROUTINES/METHODS

=head2 dspp(@arguments)

Print to STDOUT a dumped vision of the arguments.

=head1 AUTHOR

Jean-Damien Durand <jeandamiendurand@free.fr>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Jean-Damien Durand.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
