use strict;
use warnings FATAL => 'all';

package Data::Scan::Role::Consumer;
use Moo::Role;

# ABSTRACT: Data::Scan consumer role

our $VERSION = '0.001'; # VERSION

# AUTHORITY

requires 'start';
requires 'sopen';
requires 'sread';
requires 'sclose';
requires 'end';
requires 'output';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Scan::Role::Consumer - Data::Scan consumer role

=head1 VERSION

version 0.001

=head1 AUTHOR

Jean-Damien Durand <jeandamiendurand@free.fr>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Jean-Damien Durand.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
