/*
 * Decompiled with CFR 0.152.
 */
package org.seleniumhq.jetty7.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import org.seleniumhq.jetty7.servlet.ErrorPageErrorHandler;
import org.seleniumhq.jetty7.servlet.ServletHandler;
import org.seleniumhq.jetty7.util.log.Log;
import org.seleniumhq.jetty7.util.log.Logger;
import org.seleniumhq.jetty7.util.resource.Resource;
import org.seleniumhq.jetty7.webapp.AbstractConfiguration;
import org.seleniumhq.jetty7.webapp.StandardDescriptorProcessor;
import org.seleniumhq.jetty7.webapp.WebAppContext;

public class WebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(WebXmlConfiguration.class);

    public void preConfigure(WebAppContext context) throws Exception {
        Resource webxml;
        String defaultsDescriptor = context.getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource(defaultsDescriptor);
            if (dftResource == null) {
                dftResource = context.newResource(defaultsDescriptor);
            }
            context.getMetaData().setDefaults(dftResource);
        }
        if ((webxml = this.findWebXml(context)) != null) {
            context.getMetaData().setWebXml(webxml);
        }
        for (String overrideDescriptor : context.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = Resource.newSystemResource(overrideDescriptor);
            if (orideResource == null) {
                orideResource = context.newResource(overrideDescriptor);
            }
            context.getMetaData().addOverride(orideResource);
        }
    }

    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        context.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
    }

    protected Resource findWebXml(WebAppContext context) throws IOException, MalformedURLException {
        Resource web;
        String descriptor = context.getDescriptor();
        if (descriptor != null && (web = context.newResource(descriptor)).exists() && !web.isDirectory()) {
            return web;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource web2 = web_inf.addPath("web.xml");
            if (web2.exists()) {
                return web2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No WEB-INF/web.xml in " + context.getWar() + ". Serving files and default/dynamic servlets only", new Object[0]);
            }
        }
        return null;
    }

    public void deconfigure(WebAppContext context) throws Exception {
        ServletHandler _servletHandler = context.getServletHandler();
        _servletHandler.setFilters(null);
        _servletHandler.setFilterMappings(null);
        _servletHandler.setServlets(null);
        _servletHandler.setServletMappings(null);
        context.setEventListeners(null);
        context.setWelcomeFiles(null);
        if (context.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)context.getErrorHandler()).setErrorPages(null);
        }
    }
}

