/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.httpclient;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicPathHandler;

final class HtmlUnitPathHandler
extends BasicPathHandler {
    private final BrowserVersion browserVersion_;

    HtmlUnitPathHandler(BrowserVersion browserVersion) {
        this.browserVersion_ = browserVersion;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        int lastSlashPos;
        String targetpath = origin.getPath();
        if (this.browserVersion_ != null && this.browserVersion_.hasFeature(BrowserVersionFeatures.HTTP_COOKIE_EXTRACT_PATH_FROM_LOCATION) && targetpath.length() > 0 && (lastSlashPos = targetpath.lastIndexOf(47)) > 1 && lastSlashPos < targetpath.length()) {
            targetpath = targetpath.substring(0, lastSlashPos);
        }
        CookieOrigin newOrigin = new CookieOrigin(origin.getHost(), origin.getPort(), targetpath, origin.isSecure());
        return super.match(cookie, newOrigin);
    }
}

