/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.ClassConfiguration;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstant;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractJavaScriptConfiguration {
    private static final Log LOG = LogFactory.getLog(AbstractJavaScriptConfiguration.class);
    private static final Map<String, String> CLASS_NAME_MAP_ = new HashMap<String, String>();
    private Map<Class<?>, Class<? extends SimpleScriptable>> domJavaScriptMap_;
    private final Map<String, ClassConfiguration> configuration_;

    protected AbstractJavaScriptConfiguration(BrowserVersion browser) {
        this.configuration_ = this.buildUsageMap(browser);
    }

    protected abstract Class<? extends SimpleScriptable>[] getClasses();

    public Iterable<ClassConfiguration> getAll() {
        return this.configuration_.values();
    }

    private Map<String, ClassConfiguration> buildUsageMap(BrowserVersion browser) {
        HashMap<String, ClassConfiguration> classMap = new HashMap<String, ClassConfiguration>(this.getClasses().length);
        for (Class<? extends SimpleScriptable> klass : this.getClasses()) {
            ClassConfiguration config = AbstractJavaScriptConfiguration.getClassConfiguration(klass, browser);
            if (config == null) continue;
            classMap.put(config.getClassName(), config);
        }
        return Collections.unmodifiableMap(classMap);
    }

    public static ClassConfiguration getClassConfiguration(Class<? extends SimpleScriptable> klass, BrowserVersion browser) {
        if (browser != null) {
            String expectedBrowserName = browser.isIE() ? "IE" : (browser.isFirefox() ? "FF" : "CHROME");
            float browserVersionNumeric = browser.getBrowserVersionNumeric();
            String hostClassName = klass.getName();
            JsxClasses jsxClasses = klass.getAnnotation(JsxClasses.class);
            if (jsxClasses != null) {
                if (klass.getAnnotation(JsxClass.class) != null) {
                    throw new RuntimeException("Invalid JsxClasses/JsxClass annotation; class '" + hostClassName + "' has both.");
                }
                JsxClass[] jsxClassValues = jsxClasses.value();
                HashSet domClasses = new HashSet();
                boolean isJsObject = false;
                boolean isDefinedInStandardsMode = false;
                String className = null;
                for (int i = 0; i < jsxClassValues.length; ++i) {
                    JsxClass jsxClass = jsxClassValues[i];
                    if (jsxClass == null || !AbstractJavaScriptConfiguration.isSupported(jsxClass.browsers(), expectedBrowserName, browserVersionNumeric)) continue;
                    domClasses.add(jsxClass.domClass());
                    if (jsxClass.isJSObject()) {
                        isJsObject = true;
                    }
                    if (jsxClass.isDefinedInStandardsMode()) {
                        isDefinedInStandardsMode = true;
                    }
                    if (jsxClass.className().isEmpty()) continue;
                    className = jsxClass.className();
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), isJsObject, isDefinedInStandardsMode, className);
                AbstractJavaScriptConfiguration.process(classConfiguration, hostClassName, expectedBrowserName, browserVersionNumeric);
                return classConfiguration;
            }
            JsxClass jsxClass = klass.getAnnotation(JsxClass.class);
            if (jsxClass != null && AbstractJavaScriptConfiguration.isSupported(jsxClass.browsers(), expectedBrowserName, browserVersionNumeric)) {
                String className;
                HashSet domClasses = new HashSet();
                Class<?> domClass = jsxClass.domClass();
                if (domClass != null && domClass != Object.class) {
                    domClasses.add(domClass);
                }
                if ((className = jsxClass.className()).isEmpty()) {
                    className = null;
                }
                ClassConfiguration classConfiguration = new ClassConfiguration(klass, domClasses.toArray(new Class[0]), jsxClass.isJSObject(), jsxClass.isDefinedInStandardsMode(), className);
                AbstractJavaScriptConfiguration.process(classConfiguration, hostClassName, expectedBrowserName, browserVersionNumeric);
                return classConfiguration;
            }
        }
        return null;
    }

    private static void process(ClassConfiguration classConfiguration, String hostClassName, String expectedBrowserName, float browserVersionNumeric) {
        String simpleClassName = hostClassName.substring(hostClassName.lastIndexOf(46) + 1);
        CLASS_NAME_MAP_.put(hostClassName, simpleClassName);
        HashMap<String, Executable> allGetters = new HashMap<String, Executable>();
        HashMap<String, Executable> allSetters = new HashMap<String, Executable>();
        for (Constructor<?> constructor : classConfiguration.getHostClass().getDeclaredConstructors()) {
            for (Annotation annotation : constructor.getAnnotations()) {
                if (!(annotation instanceof JsxConstructor) || !AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowserName, browserVersionNumeric)) continue;
                classConfiguration.setJSConstructor(constructor);
            }
        }
        for (Executable executable : classConfiguration.getHostClass().getDeclaredMethods()) {
            for (Annotation annotation : executable.getAnnotations()) {
                String property;
                if (annotation instanceof JsxGetter) {
                    JsxGetter jsxGetter = (JsxGetter)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxGetter.value(), expectedBrowserName, browserVersionNumeric)) continue;
                    if (jsxGetter.propertyName().isEmpty()) {
                        int prefix = ((Method)executable).getName().startsWith("is") ? 2 : 3;
                        property = ((Method)executable).getName().substring(prefix);
                        property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                    } else {
                        property = jsxGetter.propertyName();
                    }
                    allGetters.put(property, executable);
                    continue;
                }
                if (annotation instanceof JsxSetter) {
                    JsxSetter jsxSetter = (JsxSetter)annotation;
                    if (!AbstractJavaScriptConfiguration.isSupported(jsxSetter.value(), expectedBrowserName, browserVersionNumeric)) continue;
                    if (jsxSetter.propertyName().isEmpty()) {
                        property = ((Method)executable).getName().substring(3);
                        property = Character.toLowerCase(property.charAt(0)) + property.substring(1);
                    } else {
                        property = jsxSetter.propertyName();
                    }
                    allSetters.put(property, executable);
                    continue;
                }
                if (annotation instanceof JsxFunction) {
                    if (!AbstractJavaScriptConfiguration.isSupported(((JsxFunction)annotation).value(), expectedBrowserName, browserVersionNumeric)) continue;
                    classConfiguration.addFunction((Method)executable);
                    continue;
                }
                if (annotation instanceof JsxStaticFunction) {
                    if (!AbstractJavaScriptConfiguration.isSupported(((JsxStaticFunction)annotation).value(), expectedBrowserName, browserVersionNumeric)) continue;
                    classConfiguration.addStaticFunction((Method)executable);
                    continue;
                }
                if (!(annotation instanceof JsxConstructor) || !AbstractJavaScriptConfiguration.isSupported(((JsxConstructor)annotation).value(), expectedBrowserName, browserVersionNumeric)) continue;
                classConfiguration.setJSConstructor(executable);
            }
        }
        for (AccessibleObject accessibleObject : classConfiguration.getHostClass().getDeclaredFields()) {
            JsxConstant jsxConstant = ((Field)accessibleObject).getAnnotation(JsxConstant.class);
            if (jsxConstant == null || !AbstractJavaScriptConfiguration.isSupported(jsxConstant.value(), expectedBrowserName, browserVersionNumeric)) continue;
            classConfiguration.addConstant(((Field)accessibleObject).getName());
        }
        for (Map.Entry getterEntry : allGetters.entrySet()) {
            String property = (String)getterEntry.getKey();
            classConfiguration.addProperty(property, (Method)getterEntry.getValue(), (Method)allSetters.get(property));
        }
    }

    private static boolean isSupported(WebBrowser[] browsers, String expectedBrowserName, float expectedVersionNumeric) {
        for (WebBrowser browser : browsers) {
            if (!browser.value().name().equals(expectedBrowserName) || !(browser.minVersion() <= expectedVersionNumeric) || !(browser.maxVersion() >= expectedVersionNumeric)) continue;
            return true;
        }
        return false;
    }

    public ClassConfiguration getClassConfiguration(String hostClassName) {
        return this.configuration_.get(hostClassName);
    }

    String getClassnameForClass(Class<?> clazz) {
        String name = CLASS_NAME_MAP_.get(clazz.getName());
        if (name == null) {
            throw new IllegalStateException("Did not find the mapping of the class to the classname for " + clazz.getName());
        }
        return name;
    }

    public Map<Class<?>, Class<? extends SimpleScriptable>> getDomJavaScriptMapping() {
        if (this.domJavaScriptMap_ != null) {
            return this.domJavaScriptMap_;
        }
        HashMap map = new HashMap(this.configuration_.size());
        boolean debug = LOG.isDebugEnabled();
        for (String hostClassName : this.configuration_.keySet()) {
            ClassConfiguration classConfig = this.getClassConfiguration(hostClassName);
            for (Class<?> domClass : classConfig.getDomClasses()) {
                if (debug) {
                    LOG.debug("Mapping " + domClass.getName() + " to " + hostClassName);
                }
                map.put(domClass, classConfig.getHostClass());
            }
        }
        this.domJavaScriptMap_ = Collections.unmodifiableMap(map);
        return this.domJavaScriptMap_;
    }
}

