/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.io;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openqa.selenium.internal.Base64Encoder;
import org.openqa.selenium.io.FileHandler;

public class Zip {
    private static final int BUF_SIZE = 16384;

    public void zip(File inputDir, File output) throws IOException {
        if (output.exists()) {
            throw new IOException("File already exists: " + output);
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(output);
            this.zip(inputDir, fos);
        }
        finally {
            Closeables.close(fos, false);
        }
    }

    public String zip(File inputDir) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.zip(inputDir, bos);
            String string = new Base64Encoder().encode(bos.toByteArray());
            return string;
        }
        finally {
            bos.close();
        }
    }

    public String zipFile(File baseDir, File fileToCompress) throws IOException {
        Preconditions.checkArgument(fileToCompress.isFile(), "File should be a file: " + fileToCompress);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(bos);
        try {
            this.addToZip(baseDir.getAbsolutePath(), zos, fileToCompress);
            String string = new Base64Encoder().encode(bos.toByteArray());
            return string;
        }
        finally {
            zos.close();
            bos.close();
        }
    }

    private void zip(File inputDir, OutputStream writeTo) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(writeTo);
            this.addToZip(inputDir.getAbsolutePath(), zos, inputDir);
        }
        finally {
            Closeables.close(zos, false);
        }
    }

    private void addToZip(String basePath, ZipOutputStream zos, File toAdd) throws IOException {
        if (toAdd.isDirectory()) {
            File[] files = toAdd.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.addToZip(basePath, zos, file);
                    ++n2;
                }
            }
        } else {
            int len;
            FileInputStream fis = new FileInputStream(toAdd);
            String name = toAdd.getAbsolutePath().substring(basePath.length() + 1);
            ZipEntry entry = new ZipEntry(name.replace('\\', '/'));
            zos.putNextEntry(entry);
            byte[] buffer = new byte[4096];
            while ((len = fis.read(buffer)) != -1) {
                zos.write(buffer, 0, len);
            }
            fis.close();
            zos.closeEntry();
        }
    }

    public void unzip(String source, File outputDir) throws IOException {
        byte[] bytes = new Base64Encoder().decode(source);
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            this.unzip(bis, outputDir);
        }
        finally {
            Closeables.close(bis, false);
        }
    }

    public void unzip(File source, File outputDir) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(source);
            this.unzip(fis, outputDir);
        }
        finally {
            Closeables.close(fis, false);
        }
    }

    public void unzip(InputStream source, File outputDir) throws IOException {
        ZipInputStream zis = new ZipInputStream(source);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    FileHandler.createDir(file);
                    continue;
                }
                this.unzipFile(outputDir, zis, entry.getName());
            }
        }
        finally {
            zis.close();
        }
    }

    public void unzipFile(File output, InputStream zipStream, String name) throws IOException {
        File toWrite = new File(output, name);
        if (!FileHandler.createDir(toWrite.getParentFile())) {
            throw new IOException("Cannot create parent director for: " + name);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toWrite), 16384);
        try {
            int read;
            byte[] buffer = new byte[16384];
            while ((read = zipStream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
        finally {
            ((OutputStream)out).close();
        }
    }
}

