/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.DriverProvider;

public class DefaultDriverProvider
implements DriverProvider {
    private static final Logger LOG = Logger.getLogger(DefaultDriverProvider.class.getName());
    private Capabilities capabilities;
    private Class<? extends WebDriver> driverClass;
    private String driverClassName;

    public DefaultDriverProvider(Capabilities capabilities, Class<? extends WebDriver> driverClass) {
        this.capabilities = capabilities;
        this.driverClass = driverClass;
    }

    public DefaultDriverProvider(Capabilities capabilities, String driverClassName) {
        this.capabilities = capabilities;
        this.driverClassName = driverClassName;
    }

    @Override
    public Capabilities getProvidedCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean canCreateDriverInstances() {
        return this.getDriverClass() != null;
    }

    @Override
    public Class<? extends WebDriver> getDriverClass() {
        if (this.driverClass != null) {
            return this.driverClass;
        }
        try {
            return Class.forName(this.driverClassName).asSubclass(WebDriver.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.log(Level.INFO, "Driver class not found: " + this.driverClassName);
            return null;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            LOG.log(Level.INFO, "Driver class not found: " + this.driverClassName);
            return null;
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            LOG.log(Level.INFO, "Driver class is built for higher Java version: " + this.driverClassName);
            return null;
        }
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        LOG.info("Creating a new session for " + capabilities);
        return this.callConstructor(this.getDriverClass(), capabilities);
    }

    private WebDriver callConstructor(Class<? extends WebDriver> from, Capabilities capabilities) {
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new WebDriverException(e);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WebDriverException(e);
            }
        }
        catch (InvocationTargetException e) {
            throw new WebDriverException(e);
        }
        catch (InstantiationException e) {
            throw new WebDriverException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException(e);
        }
    }

    public String toString() {
        return this.driverClass != null ? this.driverClass.toString() : this.driverClassName;
    }
}

