#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2015 -- leonerd@leonerd.org.uk

package Device::BusPirate::Chip::SSD1306::SPI4;

use strict;
use warnings;
use base qw( Device::BusPirate::Chip::SSD1306 );

our $VERSION = '0.01';

use constant CHIP => "SSD1306-SPI4";
use constant MODE => "SPI";

=head1 NAME

C<Device::BusPirate::Chip::SSD1306::SPI4> - use a F<SSD1306> OLED driver in 4-wire SPI mode

=head1 DESCRIPTION

This L<Device::BusPirate::Chip::SSD1306> subclass provides specific
communication to an F<SSD1306> chip attached to the F<Bus Pirate> via SPI in
4-wire mode; where the C<D/C#> pin is attached to the C<AUX> line.

The chip name for this module is C<SSD1306-SPI4>.

For actually interacting with the attached module, see the main
L<Device::BusPirate::Chip::SSD1306> documentation.

=cut

sub mount
{
   my $self = shift;
   my ( $mode ) = @_;

   $self->SUPER::mount( $mode )
      ->then( sub {
         $mode->configure(
            speed => "8M",
         )
      });
}

sub send_cmd
{
   my $self = shift;
   my @vals = @_;

   $self->aux(0)->then( sub {
      $self->mode->writeread_cs( join "", map { chr } @vals )
   });
}

sub send_data
{
   my $self = shift;
   my ( $bytes ) = @_;

   $self->aux(1)->then( sub {
      $self->mode->writeread_cs( $bytes );
   });
}

=head1 AUTHOR

Paul Evans <leonerd@leonerd.org.uk>

=cut

0x55AA;
