package Bencher::Scenario::LogAny::Startup;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    module_startup => 1,
    participants => [
        {module => 'Log::Any'},
        {module => 'Log::Any::Adapter::Null'},
        {module => 'Log::Any::Adapter::Screen'},
        {module => 'Log::Any::Adapter::Stdout'},
        {module => 'Log::Any::IfLOG'},
        {module => 'Log::Any::Proxy'},
    ],
};

1;
# ABSTRACT:

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogAny::Startup

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::LogAny::Startup (from Perl distribution Bencher-Scenario-LogAny), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogAny::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Log::Any>

L<Log::Any::Adapter::Null>

L<Log::Any::Adapter::Screen>

L<Log::Any::Adapter::Stdout>

L<Log::Any::IfLOG>

L<Log::Any::Proxy>

=head1 SAMPLE BENCHMARK RESULTS

Run on: CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------+-------+-------------------+---------+---------+
 | seq | name                      | time  | mod_overhead_time | errors  | samples |
 +-----+---------------------------+-------+-------------------+---------+---------+
 | 3   | Log::Any::Adapter::Screen | 22ms  | 17ms              | 0.00011 | 20      |
 | 2   | Log::Any::Adapter::Null   | 22ms  | 17ms              | 0.00016 | 20      |
 | 4   | Log::Any::Adapter::Stdout | 22ms  | 17ms              | 0.00015 | 21      |
 | 6   | Log::Any::Proxy           | 22ms  | 17ms              | 0.00015 | 20      |
 | 1   | Log::Any                  | 21ms  | 16ms              | 6.9e-05 | 20      |
 | 5   | Log::Any::IfLOG           | 5.4ms | 0.34ms            | 4.2e-05 | 21      |
 | 0   | perl -e1 (baseline)       | 5ms   | 0ms               | 4.4e-05 | 20      |
 +-----+---------------------------+-------+-------------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-LogAny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-LogAny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-LogAny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
