use strict;
use warnings;

package Compiler::Lexer::TokenType;
use constant {
    T_Return => 0,
    T_Add => 1,
    T_Sub => 2,
    T_Mul => 3,
    T_Div => 4,
    T_Mod => 5,
    T_ThreeTermOperator => 6,
    T_Greater => 7,
    T_Less => 8,
    T_StringAdd => 9,
    T_Ref => 10,
    T_Glob => 11,
    T_BitNot => 12,
    T_BitOr => 13,
    T_AlphabetOr => 14,
    T_BitAnd => 15,
    T_AlphabetAnd => 16,
    T_BitXOr => 17,
    T_AlphabetXOr => 18,
    T_StringMul => 19,
    T_AddEqual => 20,
    T_SubEqual => 21,
    T_MulEqual => 22,
    T_DivEqual => 23,
    T_ModEqual => 24,
    T_StringAddEqual => 25,
    T_GreaterEqual => 26,
    T_LessEqual => 27,
    T_EqualEqual => 28,
    T_Diamond => 29,
    T_Compare => 30,
    T_PolymorphicCompare => 31,
    T_RegOK => 32,
    T_RegNot => 33,
    T_NotEqual => 34,
    T_StringLess => 35,
    T_StringLessEqual => 36,
    T_StringGreater => 37,
    T_StringGreaterEqual => 38,
    T_StringEqual => 39,
    T_StringNotEqual => 40,
    T_StringCompare => 41,
    T_Inc => 42,
    T_Dec => 43,
    T_Exp => 44,
    T_PowerEqual => 45,
    T_DefaultEqual => 46,
    T_LeftShift => 47,
    T_RightShift => 48,
    T_And => 49,
    T_Or => 50,
    T_AndBitEqual => 51,
    T_OrBitEqual => 52,
    T_NotBitEqual => 53,
    T_OrEqual => 54,
    T_AndEqual => 55,
    T_Slice => 56,
    T_DefaultOperator => 57,
    T_ToDo => 58,
    T_VarDecl => 59,
    T_FunctionDecl => 60,
    T_Method => 61,
    T_Assign => 62,
    T_ArraySize => 63,
    T_Is => 64,
    T_Not => 65,
    T_AlphabetNot => 66,
    T_BuiltinFunc => 67,
    T_RequireDecl => 68,
    T_Import => 69,
    T_SpecificKeyword => 70,
    T_DataWord => 71,
    T_ModWord => 72,
    T_AUTOLOAD => 73,
    T_CORE => 74,
    T_DESTROY => 75,
    T_STDIN => 76,
    T_STDOUT => 77,
    T_STDERR => 78,
    T_Redo => 79,
    T_Next => 80,
    T_Last => 81,
    T_Goto => 82,
    T_Continue => 83,
    T_Do => 84,
    T_Break => 85,
    T_Handle => 86,
    T_LocalDecl => 87,
    T_OurDecl => 88,
    T_StateDecl => 89,
    T_UseDecl => 90,
    T_UsedName => 91,
    T_RequiredName => 92,
    T_IfStmt => 93,
    T_ElseStmt => 94,
    T_ElsifStmt => 95,
    T_UnlessStmt => 96,
    T_UntilStmt => 97,
    T_WhenStmt => 98,
    T_GivenStmt => 99,
    T_DefaultStmt => 100,
    T_Comma => 101,
    T_Colon => 102,
    T_SemiColon => 103,
    T_LeftParenthesis => 104,
    T_RightParenthesis => 105,
    T_LeftBrace => 106,
    T_RightBrace => 107,
    T_LeftBracket => 108,
    T_RightBracket => 109,
    T_ArrayDereference => 110,
    T_HashDereference => 111,
    T_ScalarDereference => 112,
    T_CodeDereference => 113,
    T_ShortScalarDereference => 114,
    T_ShortArrayDereference => 115,
    T_ShortHashDereference => 116,
    T_ShortCodeDereference => 117,
    T_ArraySizeDereference => 118,
    T_Key => 119,
    T_BareWord => 120,
    T_Arrow => 121,
    T_Pointer => 122,
    T_NamespaceResolver => 123,
    T_Namespace => 124,
    T_Package => 125,
    T_Class => 126,
    T_CallDecl => 127,
    T_CodeRef => 128,
    T_WhileStmt => 129,
    T_ForStmt => 130,
    T_ForeachStmt => 131,
    T_Annotation => 132,
    T_ArgumentArray => 133,
    T_SpecificValue => 134,
    T_ConstValue => 135,
    T_ProgramArgument => 136,
    T_LibraryDirectories => 137,
    T_Environment => 138,
    T_Include => 139,
    T_Signal => 140,
    T_RegOpt => 141,
    T_RegQuote => 142,
    T_RegDoubleQuote => 143,
    T_RegList => 144,
    T_RegExec => 145,
    T_RegDecl => 146,
    T_RegMatch => 147,
    T_RegDelim => 148,
    T_HandleDelim => 149,
    T_RegMiddleDelim => 150,
    T_RegAllReplace => 151,
    T_RegReplace => 152,
    T_RegReplaceFrom => 153,
    T_RegReplaceTo => 154,
    T_FieldDecl => 155,
    T_TypeRef => 156,
    T_LabelRef => 157,
    T_LocalVarDecl => 158,
    T_GlobalVarDecl => 159,
    T_MultiLocalVarDecl => 160,
    T_MultiGlobalVarDecl => 161,
    T_Prototype => 162,
    T_Var => 163,
    T_CodeVar => 164,
    T_ArrayVar => 165,
    T_HashVar => 166,
    T_Int => 167,
    T_Double => 168,
    T_String => 169,
    T_RawString => 170,
    T_ExecString => 171,
    T_VersionString => 172,
    T_HereDocumentTag => 173,
    T_HereDocumentRawTag => 174,
    T_HereDocumentExecTag => 175,
    T_RawHereDocument => 176,
    T_HereDocument => 177,
    T_HereDocumentEnd => 178,
    T_FormatDecl => 179,
    T_Format => 180,
    T_FormatEnd => 181,
    T_Object => 182,
    T_RegExp => 183,
    T_Array => 184,
    T_Hash => 185,
    T_Operator => 186,
    T_LocalVar => 187,
    T_LocalArrayVar => 188,
    T_LocalHashVar => 189,
    T_GlobalVar => 190,
    T_GlobalArrayVar => 191,
    T_GlobalHashVar => 192,
    T_ArrayRef => 193,
    T_HashRef => 194,
    T_ArrayAt => 195,
    T_HashAt => 196,
    T_ArraySet => 197,
    T_HashSet => 198,
    T_Function => 199,
    T_Call => 200,
    T_Argument => 201,
    T_List => 202,
    T_Default => 203,
    T_Pod => 204,
    T_Comment => 205,
    T_WhiteSpace => 206,
    T_Undefined => 207
};

package Compiler::Lexer::SyntaxType;
use constant {
    T_Value => 0,
    T_Term => 1,
    T_Expr => 2,
    T_Stmt => 3,
    T_BlockStmt => 4
};

package Compiler::Lexer::Kind;
use constant {
    T_Return => 0,
    T_Operator => 1,
    T_Assign => 2,
    T_Decl => 3,
    T_Function => 4,
    T_SingleTerm => 5,
    T_Import => 6,
    T_SpecificKeyword => 7,
    T_DataWord => 8,
    T_ModWord => 9,
    T_AUTOLOAD => 10,
    T_CORE => 11,
    T_DESTROY => 12,
    T_Handle => 13,
    T_Control => 14,
    T_Do => 15,
    T_Module => 16,
    T_Stmt => 17,
    T_DefaultStmt => 18,
    T_Comma => 19,
    T_Colon => 20,
    T_StmtEnd => 21,
    T_Symbol => 22,
    T_Modifier => 23,
    T_Term => 24,
    T_Namespace => 25,
    T_Package => 26,
    T_Class => 27,
    T_Annotation => 28,
    T_RegOpt => 29,
    T_RegPrefix => 30,
    T_RegReplacePrefix => 31,
    T_Ref => 32,
    T_Get => 33,
    T_Set => 34,
    T_Verbose => 35,
    T_Undefined => 36
};

1;
