package Bencher::Scenario::RegexpAssemble;

our $DATE = '2016-02-10'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

$main::chars = ["a".."z"];

my $code_template_assemble_with_ra = 'my $ra = Regexp::Assemble->new; for (1.. <num> ) { $ra->add(join("", map {$main::chars->[rand @$main::chars]} 1..10)) } $ra->re';
my $code_template_assemble_raw     = 'my @strs; for (1.. <num> ) { push @strs, join("", map {$main::chars->[rand @$main::chars]} 1..10) } my $re = "\\\\A(?:".join("|", map {quotemeta} sort {length($b) <=> length($a)} @strs).")\\\\z"; $re = qr/$re/';

our $scenario = {
    summary => 'Benchmark arbitrary size floating point arithmetics',
    participants => [
        {
            name => 'assemble-with-ra',
            module=>'Regexp::Assemble',
            code_template => $code_template_assemble_with_ra,
            tags => ['assembling'],
        },
        {
            name => 'assemble-raw',
            code_template => $code_template_assemble_raw,
            tags => ['assembling'],
        },
        {
            name => 'match-with-ra',
            module=>'Regexp::Assemble',
            code_template => 'state $re = do { ' . $code_template_assemble_with_ra . ' }; state $str = join("", map {$main::chars->[rand @$main::chars]} 1..10); $str =~ $re',
            tags => ['matching'],
        },
        {
            name => 'match-raw',
            code_template => 'state $re = do { ' . $code_template_assemble_raw     . ' }; state $str = join("", map {$main::chars->[rand @$main::chars]} 1..10); $str =~ $re',
            tags => ['matching'],
        },
    ],
    datasets => [
        {name=>'10str'   , args=>{num=>10   }},
        {name=>'100str'  , args=>{num=>100  }},
        {name=>'1000str' , args=>{num=>1000 }},
        {name=>'10000str', args=>{num=>10000}},
    ],
};

1;
# ABSTRACT: Benchmark arbitrary size floating point arithmetics

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::RegexpAssemble - Benchmark arbitrary size floating point arithmetics

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::RegexpAssemble (from Perl distribution Bencher-Scenario-RegexpAssemble), released on 2016-02-10.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m RegexpAssemble

To run module startup overhead benchmark:

 % bencher --module-startup -m RegexpAssemble

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Regexp::Assemble> 0.36

=head1 BENCHMARK PARTICIPANTS

=over

=item * assemble-with-ra (perl_code) [assembling]

Code template:

 my $ra = Regexp::Assemble->new; for (1.. <num> ) { $ra->add(join("", map {$main::chars->[rand @$main::chars]} 1..10)) } $ra->re



=item * assemble-raw (perl_code) [assembling]

Code template:

 my @strs; for (1.. <num> ) { push @strs, join("", map {$main::chars->[rand @$main::chars]} 1..10) } my $re = "\\A(?:".join("|", map {quotemeta} sort {length($b) <=> length($a)} @strs).")\\z"; $re = qr/$re/



=item * match-with-ra (perl_code) [matching]

Code template:

 state $re = do { my $ra = Regexp::Assemble->new; for (1.. <num> ) { $ra->add(join("", map {$main::chars->[rand @$main::chars]} 1..10)) } $ra->re }; state $str = join("", map {$main::chars->[rand @$main::chars]} 1..10); $str =~ $re



=item * match-raw (perl_code) [matching]

Code template:

 state $re = do { my @strs; for (1.. <num> ) { push @strs, join("", map {$main::chars->[rand @$main::chars]} 1..10) } my $re = "\\A(?:".join("|", map {quotemeta} sort {length($b) <=> length($a)} @strs).")\\z"; $re = qr/$re/ }; state $str = join("", map {$main::chars->[rand @$main::chars]} 1..10); $str =~ $re



=back

=head1 BENCHMARK DATASETS

=over

=item * 10str

=item * 100str

=item * 1000str

=item * 10000str

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m RegexpAssemble >>):

 +------------------+----------+-----------+-----------+---------+---------+
 | participant      | dataset  | rate (/s) | time (ms) | errors  | samples |
 +------------------+----------+-----------+-----------+---------+---------+
 | assemble-with-ra | 10000str | 1.7       | 5.8e+02   | 0.0011  | 20      |
 | assemble-raw     | 10000str | 17        | 60        | 9.9e-05 | 20      |
 | assemble-with-ra | 1000str  | 18        | 56        | 0.0003  | 20      |
 | assemble-raw     | 1000str  | 1.8e+02   | 5.6       | 2e-05   | 20      |
 | assemble-with-ra | 100str   | 1.9e+02   | 5.2       | 9.8e-06 | 23      |
 | assemble-with-ra | 10str    | 2e+03     | 0.6       | 1.2e-05 | 20      |
 | assemble-raw     | 100str   | 1.91e+03  | 0.523     | 4.8e-07 | 20      |
 | assemble-raw     | 10str    | 1.6e+04   | 0.064     | 1.1e-07 | 20      |
 | match-with-ra    | 10000str | 3.13e+05  | 0.0032    | 1.5e-09 | 25      |
 | match-with-ra    | 1000str  | 4.2e+05   | 0.0024    | 6.7e-09 | 20      |
 | match-with-ra    | 100str   | 1.6e+06   | 0.00061   | 2.5e-09 | 20      |
 | match-with-ra    | 10str    | 1.7e+06   | 0.00058   | 7.1e-10 | 28      |
 | match-raw        | 10000str | 2.4e+06   | 0.00042   | 1e-09   | 21      |
 | match-raw        | 1000str  | 2.4e+06   | 0.00041   | 8.3e-10 | 20      |
 | match-raw        | 100str   | 2.5e+06   | 0.0004    | 8.4e-10 | 20      |
 | match-raw        | 10str    | 2.5e+06   | 0.0004    | 2.1e-10 | 20      |
 +------------------+----------+-----------+-----------+---------+---------+


Benchmark module startup overhead (C<< bencher -m RegexpAssemble --module-startup >>):

 +---------------------+-----------+------------------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | errors  | samples |
 +---------------------+-----------+------------------------+---------+---------+
 | Regexp::Assemble    | 28        | 22                     | 6.9e-05 | 20      |
 | perl -e1 (baseline) | 6         | 0                      | 3.5e-05 | 20      |
 +---------------------+-----------+------------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-RegexpAssemble>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-RegexpAssemble>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-RegexpAssemble>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
