BEGIN { $ENV{MOJO_ASSETPACK_NO_CACHE} = 1 }
use Mojo::Base -base;
use Mojolicious;
use Test::Mojo;
use Test::More;
use File::Temp 'tempdir';
use File::Path qw( make_path remove_tree );

my $tempdir = tempdir;
my $app     = Mojolicious->new(mode => 'development', home => Mojo::Home->new($tempdir));
my $t       = Test::Mojo->new($app);

plan skip_all => $@ unless eval { make_path "$tempdir/public" };
plan skip_all => 'Unable to create public dir' unless eval { $app->plugin('AssetPack', {minify => 0}) };
plan skip_all => 'Sass is required' unless $app->asset->preprocessors->can_process('scss');

eval {
  $app->plugin('bootstrap3', js => [], custom => 1);
  $app->routes->get('/test1' => 'test1');
  $t->get_ok('/test1')->status_is(200)->element_exists('style')->content_like(qr{\.popover-content});
} or do {
  is $@, undef, 'loading bootstrap3 plugin';
};

ok -d "$tempdir/public/sass",                "$tempdir/public/sass";
ok -f "$tempdir/public/sass/bootstrap.scss", "$tempdir/public/sass/bootstrap.scss";

# Modify bootstrap.scss before get_ok() below
# Works because of MOJO_ASSETPACK_NO_CACHE=1
my @bs = grep { !/popover/ } split "\n", Mojo::Util::slurp("$tempdir/public/sass/bootstrap.scss");
Mojo::Util::spurt(join("\n", @bs), "$tempdir/public/sass/bootstrap.scss");
$t->get_ok('/test1')->status_is(200)->element_exists('style')->content_unlike(qr{\.popover-content});

eval { remove_tree $tempdir };
ok !-d $tempdir, "remove_tree $tempdir" or diag $@;

done_testing;

__DATA__
@@ test1.html.ep
%= asset 'bootstrap.css' => { inline => 1 };
