# Copyright 2015 Kevin Ryde
#
# This file is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# This file is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with this file.  See the file COPYING.  If not, see
# <http://www.gnu.org/licenses/>.

use strict;
use 5.004;
use Test;
# before warnings checking since Graph.pm 0.96 is not safe to non-numeric
# version number from Storable.pm
use Graph;

use lib 't';
use MyTestHelpers;
BEGIN { MyTestHelpers::nowarnings() }

# uncomment this to run the ### lines
# use Smart::Comments;

plan tests => 323;


require Graph::Maker::StarChain;

sub stringize_sorted {
  my ($graph) = @_;
  my @edges = $graph->edges;
  if (! @edges) {
    return join(',',$graph->vertices);
  }
  @edges = map { $_->[0] > $_->[1] ? [ $_->[1], $_->[0] ] : $_ } @edges;
  @edges = sort {$a->[0] <=> $b->[0] || $a->[1] <=> $b->[1]} @edges;
  return join(',', map {$_->[0].'='.$_->[1]} @edges);
}


#------------------------------------------------------------------------------

{
  my $graph = Graph::Maker->new('star_chain', N_list => []);
  my $num_vertices = $graph->vertices;
  ok ($num_vertices, 0);
}
{
  my $graph = Graph::Maker->new('star_chain', N_list => [0]);
  my $num_vertices = $graph->vertices;
  ok ($num_vertices, 0);
}
{
  my $graph = Graph::Maker->new('star_chain', N_list => [1]);
  my $num_vertices = $graph->vertices;
  my $num_edges = $graph->edges;
  ok ("$graph", "1");
  ok ($num_vertices, 1);
  ok ($num_edges, 0);
}

{
  my $graph = Graph::Maker->new('star_chain', N_list => [2]);
  my $num_vertices = $graph->vertices;
  my $num_edges = $graph->edges;
  ok ("$graph", "1-2,2-1");
  ok ($num_vertices, 2);
  ok ($num_edges, 2);
}
{
  my $graph = Graph::Maker->new('star_chain', N_list => [2], undirected => 1);
  my $num_vertices = $graph->vertices;
  my $num_edges = $graph->edges;
  ok ("$graph", "1=2");
  ok ($num_vertices, 2);
  ok ($num_edges, 1);
}


#------------------------------------------------------------------------------
exit 0;
