# This Makefile.PL for Moose was generated by
# inc::MakeMaker <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.34.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

# Secondary compile testing via ExtUtils::CBuilder
sub can_xs {
    # Do we have the configure_requires checker?
    unless (eval 'require ExtUtils::CBuilder; ExtUtils::CBuilder->VERSION(0.27); 1') {
        # They don't obey configure_requires, so it is
        # someone old and delicate. Try to avoid hurting
        # them by falling back to an older simpler test.
        return can_cc();
    }

    return ExtUtils::CBuilder->new( quiet => 1 )->have_compiler;
}

# can we locate a (the) C compiler
sub can_cc {
  my @chunks = split(/ /, $Config::Config{cc}) or return;

  # $Config{cc} may contain args; try to find out the program part
  while (@chunks) {
    return can_run("@chunks") || (pop(@chunks), next);
  }

  return;
}

# check if we can run some command
sub can_run {
  my ($cmd) = @_;

  return $cmd if -x $cmd;
  if (my $found_cmd = MM->maybe_command($cmd)) {
    return $found_cmd;
  }

  for my $dir ((split /$Config::Config{path_sep}/, $ENV{PATH}), '.') {
    next if $dir eq '';
    my $abs = File::Spec->catfile($dir, $cmd);
    return $abs if (-x $abs or $abs = MM->maybe_command($abs));
  }

  return;
}

die 'This distribution requires a working compiler' unless can_xs();

use ExtUtils::MakeMaker;
check_conflicts();

my %WriteMakefileArgs = (
  "ABSTRACT" => "A postmodern object system for Perl 5",
  "AUTHOR" => "Stevan Little <stevan.little\@iinteractive.com>, Dave Rolsky <autarch\@urth.org>, Jesse Luehrs <doy\@tozt.net>, Shawn M Moore <code\@sartak.org>, \x{5d9}\x{5d5}\x{5d1}\x{5dc} \x{5e7}\x{5d5}\x{5d2}'\x{5de}\x{5df} (Yuval Kogman) <nothingmuch\@woobling.org>, Karen Etheridge <ether\@cpan.org>, Florian Ragwitz <rafl\@debian.org>, Hans Dieter Pearcey <hdp\@weftsoar.net>, Chris Prather <chris\@prather.org>, Matt S Trout <mst\@shadowcat.co.uk>",
  "CONFIGURE_REQUIRES" => {
    "Dist::CheckConflicts" => "0.02",
    "ExtUtils::CBuilder" => "0.27",
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0
  },
  "DISTNAME" => "Moose",
  "EXE_FILES" => [
    "bin/moose-outdated"
  ],
  "LICENSE" => "perl",
  "NAME" => "Moose",
  "OBJECT" => "xs/Attribute\$(OBJ_EXT) xs/AttributeCore\$(OBJ_EXT) xs/Class\$(OBJ_EXT) xs/Generated\$(OBJ_EXT) xs/HasAttributes\$(OBJ_EXT) xs/HasMethods\$(OBJ_EXT) xs/Inlined\$(OBJ_EXT) xs/Instance\$(OBJ_EXT) xs/Method\$(OBJ_EXT) xs/Moose\$(OBJ_EXT) xs/MOP\$(OBJ_EXT) xs/Package\$(OBJ_EXT) xs/ToInstance\$(OBJ_EXT) mop\$(OBJ_EXT)",
  "PREREQ_PM" => {
    "Carp" => "1.22",
    "Class::Load" => "0.09",
    "Class::Load::XS" => "0.01",
    "Data::OptList" => "0.107",
    "Devel::GlobalDestruction" => 0,
    "Devel::OverloadInfo" => "0.002",
    "Devel::StackTrace" => "1.33",
    "Dist::CheckConflicts" => "0.02",
    "Eval::Closure" => "0.04",
    "List::MoreUtils" => "0.28",
    "List::Util" => "1.35",
    "MRO::Compat" => "0.05",
    "Module::Runtime" => "0.014",
    "Module::Runtime::Conflicts" => "0.002",
    "Package::DeprecationManager" => "0.11",
    "Package::Stash" => "0.32",
    "Package::Stash::XS" => "0.24",
    "Params::Util" => "1.00",
    "Scalar::Util" => "1.19",
    "Sub::Exporter" => "0.980",
    "Sub::Identify" => 0,
    "Sub::Name" => "0.05",
    "Task::Weaken" => 0,
    "Try::Tiny" => "0.17",
    "parent" => "0.223",
    "strict" => "1.03",
    "warnings" => "1.03"
  },
  "TEST_REQUIRES" => {
    "CPAN::Meta::Check" => "0.007",
    "CPAN::Meta::Requirements" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Test::CleanNamespaces" => "0.13",
    "Test::Fatal" => "0.001",
    "Test::More" => "0.88",
    "Test::Requires" => "0.05",
    "Test::Warnings" => "0.016"
  },
  "VERSION" => "2.1601",
  "XS" => {
    "xs/Attribute.xs" => "xs/Attribute.c",
    "xs/AttributeCore.xs" => "xs/AttributeCore.c",
    "xs/Class.xs" => "xs/Class.c",
    "xs/Generated.xs" => "xs/Generated.c",
    "xs/HasAttributes.xs" => "xs/HasAttributes.c",
    "xs/HasMethods.xs" => "xs/HasMethods.c",
    "xs/Inlined.xs" => "xs/Inlined.c",
    "xs/Instance.xs" => "xs/Instance.c",
    "xs/MOP.xs" => "xs/MOP.c",
    "xs/Method.xs" => "xs/Method.c",
    "xs/Moose.xs" => "xs/Moose.c",
    "xs/Package.xs" => "xs/Package.c",
    "xs/ToInstance.xs" => "xs/ToInstance.c"
  },
  "clean" => {
    "FILES" => "xs/Attribute\$(OBJ_EXT) xs/AttributeCore\$(OBJ_EXT) xs/Class\$(OBJ_EXT) xs/Generated\$(OBJ_EXT) xs/HasAttributes\$(OBJ_EXT) xs/HasMethods\$(OBJ_EXT) xs/Inlined\$(OBJ_EXT) xs/Instance\$(OBJ_EXT) xs/Method\$(OBJ_EXT) xs/Moose\$(OBJ_EXT) xs/MOP\$(OBJ_EXT) xs/Package\$(OBJ_EXT) xs/ToInstance\$(OBJ_EXT) mop\$(OBJ_EXT)"
  },
  "test" => {
    "TESTS" => "t/*.t t/attributes/*.t t/basics/*.t t/bugs/*.t t/cmop/*.t t/compat/*.t t/examples/*.t t/exceptions/*.t t/immutable/*.t t/metaclasses/*.t t/moose_util/*.t t/native_traits/*.t t/recipes/*.t t/roles/*.t t/test_moose/*.t t/todo_tests/*.t t/type_constraints/*.t"
  }
);

my %FallbackPrereqs = (
  "CPAN::Meta::Check" => "0.007",
  "CPAN::Meta::Requirements" => 0,
  "Carp" => "1.22",
  "Class::Load" => "0.09",
  "Class::Load::XS" => "0.01",
  "Data::OptList" => "0.107",
  "Devel::GlobalDestruction" => 0,
  "Devel::OverloadInfo" => "0.002",
  "Devel::StackTrace" => "1.33",
  "Dist::CheckConflicts" => "0.02",
  "Eval::Closure" => "0.04",
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "List::MoreUtils" => "0.28",
  "List::Util" => "1.35",
  "MRO::Compat" => "0.05",
  "Module::Runtime" => "0.014",
  "Module::Runtime::Conflicts" => "0.002",
  "Package::DeprecationManager" => "0.11",
  "Package::Stash" => "0.32",
  "Package::Stash::XS" => "0.24",
  "Params::Util" => "1.00",
  "Scalar::Util" => "1.19",
  "Sub::Exporter" => "0.980",
  "Sub::Identify" => 0,
  "Sub::Name" => "0.05",
  "Task::Weaken" => 0,
  "Test::CleanNamespaces" => "0.13",
  "Test::Fatal" => "0.001",
  "Test::More" => "0.88",
  "Test::Requires" => "0.05",
  "Test::Warnings" => "0.016",
  "Try::Tiny" => "0.17",
  "parent" => "0.223",
  "strict" => "1.03",
  "warnings" => "1.03"
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

$WriteMakefileArgs{CCFLAGS} = ( $Config::Config{ccflags} || '' ) . ' -I.';

WriteMakefile(%WriteMakefileArgs);

{
package MY;

use Config;

sub const_cccmd {
    my $ret = shift->SUPER::const_cccmd(@_);
    return q{} unless $ret;

    if ($Config{cc} =~ /^cl\b/i) {
        warn 'you are using MSVC... we may not have gotten some options quite right.';
        $ret .= ' /Fo$@';
    }
    else {
        $ret .= ' -o $@';
    }

    return $ret;
}

sub postamble {
    return <<'EOF';
$(OBJECT) : mop.h
EOF
}
}

sub check_conflicts {
    if ( eval { require 'lib/Moose/Conflicts.pm'; 1; } ) {
        if ( eval { Moose::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually using the 'moose-outdated' script that is installed with
    this distribution once the installation finishes.
***
EOF
    }

    return if $ENV{AUTOMATED_TESTING} || $ENV{NONINTERACTIVE_TESTING};

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
