#  You may distribute under the terms of either the GNU General Public License
#  or the Artistic License (the same terms as Perl itself)
#
#  (C) Paul Evans, 2015 -- leonerd@leonerd.org.uk

package Device::BusPirate::Chip::SSD1306::I2C;

use strict;
use warnings;
use base qw( Device::BusPirate::Chip::SSD1306 );

our $VERSION = '0.01';

use constant CHIP => "SSD1306-I2C";
use constant MODE => "I2C";

use constant DEFAULT_ADDR => 0x3C;

=head1 NAME

C<Device::BusPirate::Chip::SSD1306::I2C> - use a F<SSD1306> OLED driver in I2C mode

=head1 DESCRIPTION

This L<Device::BusPirate::Chip::SSD1306> subclass provides specific
communication to an F<SSD1306> chip attached to the F<Bus Pirate> via I2C.

The chip name for this module is C<SSD1306-I2C>.

For actually interacting with the attached module, see the main
L<Device::BusPirate::Chip::SSD1306> documentation.

=cut

sub new
{
   my $class = shift;
   my ( $bp, %opts ) = @_;

   my $self = $class->SUPER::new( @_ );

   $self->{$_} = $opts{$_} for qw( address );

   $self->{address} //= DEFAULT_ADDR;

   return $self;
}

sub send_cmd
{
   my $self = shift;
   my @vals = @_;

   my $final = pop @vals;

   $self->mode->send( $self->{address}, join "", ( map { "\x80" . chr $_ } @vals ),
      "\x00" . chr $final );
}

sub send_data
{
   my $self = shift;
   my ( $bytes ) = @_;

   $self->mode->send( $self->{address}, "\x40" . $_[0] )
}

=head1 TODO

Note that this module isn't actually fully tested on real hardware, as the
author currently lacks an F<SSD1306> module with a working I2C interface.

=head1 AUTHOR

Paul Evans <leonerd@leonerd.org.uk>

=cut

0x55AA;
