=head1

Locale::CLDR::Locales::Kn - Package for language Kannada

=cut

package Locale::CLDR::Locales::Kn;
# This file auto generated from Data\common\main\kn.xml
#	on Wed 10 Feb  8:10:48 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'ಅಫಾರ್',
 				'ab' => 'ಅಬ್ಖಾಜಿಯನ್',
 				'ace' => 'ಅಛಿನೀಸ್',
 				'ach' => 'ಅಕೋಲಿ',
 				'ada' => 'ಅಡಂಗ್‌ಮೆ',
 				'ady' => 'ಅಡೈಘೆ',
 				'ae' => 'ಅವೆಸ್ಟನ್',
 				'af' => 'ಆಫ್ರಿಕಾನ್ಸ್',
 				'afh' => 'ಆಫ್ರಿಹಿಲಿ',
 				'agq' => 'ಅಘೆಮ್',
 				'ain' => 'ಐನು',
 				'ak' => 'ಅಕಾನ್',
 				'akk' => 'ಅಕ್ಕಾಡಿಯನ್',
 				'ale' => 'ಅಲೆಯುಟ್',
 				'alt' => 'ದಕ್ಷಿಣ ಅಲ್ಟಾಯ್',
 				'am' => 'ಅಂಹರಿಕ್',
 				'an' => 'ಅರಗೊನೀಸ್',
 				'ang' => 'ಪ್ರಾಚೀನ ಇಂಗ್ಲೀಷ್',
 				'anp' => 'ಆಂಗಿಕಾ',
 				'ar' => 'ಅರೇಬಿಕ್',
 				'ar_001' => 'ಆಧುನಿಕ ಪ್ರಮಾಣಿತ ಅರೇಬಿಕ್',
 				'arc' => 'ಅರಾಮಿಕ್',
 				'arn' => 'ಮಪುಚೆ',
 				'arp' => 'ಅರಪಾಹೋ',
 				'arw' => 'ಅರಾವಾಕ್',
 				'as' => 'ಅಸ್ಸಾಮೀಸ್',
 				'asa' => 'ಅಸು',
 				'ast' => 'ಆಸ್ಟುರಿಯನ್',
 				'av' => 'ಅವರಿಕ್',
 				'awa' => 'ಅವಧಿ',
 				'ay' => 'ಅಯ್ಮಾರಾ',
 				'az' => 'ಅಜೆರ್ಬೈಜಾನಿ',
 				'az@alt=short' => 'ಅಝೆರಿ',
 				'ba' => 'ಬಶ್ಕಿರ್',
 				'bal' => 'ಬಲೂಚಿ',
 				'ban' => 'ಬಲಿನೀಸ್',
 				'bas' => 'ಬಸಾ',
 				'be' => 'ಬೆಲರೂಸಿಯನ್',
 				'bej' => 'ಬೇಜಾ',
 				'bem' => 'ಬೆಂಬಾ',
 				'bez' => 'ಬೆನ',
 				'bg' => 'ಬಲ್ಗೇರಿಯನ್',
 				'bgn' => 'ಪಶ್ಚಿಮ ಬಲೊಚಿ',
 				'bho' => 'ಭೋಜಪುರಿ',
 				'bi' => 'ಬಿಸ್ಲಾಮಾ',
 				'bik' => 'ಬಿಕೊಲ್',
 				'bin' => 'ಬಿನಿ',
 				'bla' => 'ಸಿಕ್ಸಿಕಾ',
 				'bm' => 'ಬಂಬಾರಾ',
 				'bn' => 'ಬೆಂಗಾಲಿ',
 				'bo' => 'ಟಿಬೇಟಿಯನ್',
 				'br' => 'ಬ್ರೆಟನ್',
 				'bra' => 'ಬ್ರಾಜ್',
 				'brx' => 'ಬೋಡೊ',
 				'bs' => 'ಬೋಸ್ನಿಯನ್',
 				'bua' => 'ಬುರಿಯಟ್',
 				'bug' => 'ಬುಗಿನೀಸ್',
 				'byn' => 'ಬ್ಲಿನ್',
 				'ca' => 'ಕೆಟಲಾನ್',
 				'cad' => 'ಕ್ಯಾಡ್ಡೋ',
 				'car' => 'ಕಾರಿಬ್',
 				'cch' => 'ಅಟ್ಸಮ್',
 				'ce' => 'ಚೆಚನ್',
 				'ceb' => 'ಸೆಬುಆನೋ',
 				'cgg' => 'ಚಿಗಾ',
 				'ch' => 'ಕಮೊರೊ',
 				'chb' => 'ಚಿಬ್ಚಾ',
 				'chg' => 'ಚಗಟಾಯ್',
 				'chk' => 'ಚೂಕಿಸೆ',
 				'chm' => 'ಮಾರಿ',
 				'chn' => 'ಚಿನೂಕ್ ಜಾರ್ಗೋನ್',
 				'cho' => 'ಚೋಕ್ಟಾವ್',
 				'chp' => 'ಚಿಪೆವ್ಯಾನ್',
 				'chr' => 'ಚೆರೋಕೀ',
 				'chy' => 'ಚೀಯೆನ್ನೇ',
 				'ckb' => 'ಸೊರಾನಿ ಕುರ್ದಿಷ್',
 				'co' => 'ಕೋರ್ಸಿಕನ್',
 				'cop' => 'ಕೊಪ್ಟಿಕ್',
 				'cr' => 'ಕ್ರೀ',
 				'crh' => 'ಕ್ರಿಮೀಯನ್ ಟರ್ಕಿಷ್',
 				'cs' => 'ಜೆಕ್',
 				'csb' => 'ಕಶುಬಿಯನ್',
 				'cu' => 'ಚರ್ಚ್ ಸ್ಲಾವಿಕ್',
 				'cv' => 'ಚುವಾಶ್',
 				'cy' => 'ವೆಲ್ಶ್',
 				'da' => 'ಡ್ಯಾನಿಶ್',
 				'dak' => 'ಡಕೋಟ',
 				'dar' => 'ದರ್ಗ್ವಾ',
 				'dav' => 'ಟೈಟ',
 				'de' => 'ಜರ್ಮನ್',
 				'de_AT' => 'ಆಸ್ಟ್ರಿಯನ್ ಜರ್ಮನ್',
 				'de_CH' => 'ಸ್ವಿಸ್ ಹೈ ಜರ್ಮನ್',
 				'del' => 'ಡೆಲಾವೇರ್',
 				'den' => 'ಸ್ಲೇವ್',
 				'dgr' => 'ಡೋಗ್ರಿಬ್',
 				'din' => 'ಡಿಂಕಾ',
 				'dje' => 'ಜರ್ಮಾ',
 				'doi' => 'ಡೋಗ್ರಿ',
 				'dsb' => 'ಲೋವರ್ ಸೋರ್ಬಿಯನ್',
 				'dua' => 'ಡುವಾಲಾ',
 				'dum' => 'ಮಧ್ಯ ಡಚ್',
 				'dv' => 'ದಿವೆಹಿ',
 				'dyo' => 'ಜೊಲ-ಫೊನ್ಯಿ',
 				'dyu' => 'ಡ್ಯೂಲಾ',
 				'dz' => 'ಜೋಂಗ್‌ಖಾ',
 				'ebu' => 'ಎಂಬು',
 				'ee' => 'ಈವ್',
 				'efi' => 'ಎಫಿಕ್',
 				'egy' => 'ಪ್ರಾಚೀನ ಈಜಿಪ್ಟಿಯನ್',
 				'eka' => 'ಎಕಾಜುಕ್',
 				'el' => 'ಗ್ರೀಕ್',
 				'elx' => 'ಎಲಾಮೈಟ್',
 				'en' => 'ಇಂಗ್ಲೀಷ್',
 				'en_AU' => 'ಆಸ್ಟ್ರೇಲಿಯನ್ ಇಂಗ್ಲೀಷ್',
 				'en_CA' => 'ಕೆನೆಡಿಯನ್ ಇಂಗ್ಲೀಷ್',
 				'en_GB' => 'ಬ್ರಿಟಿಷ್ ಇಂಗ್ಲೀಷ್',
 				'en_GB@alt=short' => 'ಯು.ಕೆ. ಇಂಗ್ಲಿಷ್',
 				'en_US' => 'ಅಮೆರಿಕನ್ ಇಂಗ್ಲೀಷ್',
 				'en_US@alt=short' => 'ಯು.ಎಸ್. ಇಂಗ್ಲಿಷ್',
 				'enm' => 'ಮಧ್ಯ ಇಂಗ್ಲೀಷ್',
 				'eo' => 'ಎಸ್ಪೆರಾಂಟೊ',
 				'es' => 'ಸ್ಪ್ಯಾನಿಷ್',
 				'es_419' => 'ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕನ್ ಸ್ಪ್ಯಾನಿಶ್',
 				'es_ES' => 'ಯುರೋಪಿಯನ್ ಸ್ಪ್ಯಾನಿಷ್',
 				'es_MX' => 'ಮೆಕ್ಸಿಕನ್ ಸ್ಪ್ಯಾನಿಷ್',
 				'et' => 'ಎಸ್ಟೊನಿಯನ್',
 				'eu' => 'ಬಾಸ್ಕ್',
 				'ewo' => 'ಇವಾಂಡೋ',
 				'fa' => 'ಪರ್ಶಿಯನ್',
 				'fan' => 'ಫೆಂಗ್',
 				'fat' => 'ಫಾಂಟಿ',
 				'ff' => 'ಫುಲಾಹ್',
 				'fi' => 'ಫಿನ್ನಿಶ್',
 				'fil' => 'ಫಿಲಿಪಿನೊ',
 				'fj' => 'ಫಿಜಿಯನ್',
 				'fo' => 'ಫರೋಸಿ',
 				'fon' => 'ಫೋನ್',
 				'fr' => 'ಫ್ರೆಂಚ್',
 				'fr_CA' => 'ಕೆನೆಡಿಯನ್ ಫ್ರೆಂಚ್',
 				'fr_CH' => 'ಸ್ವಿಸ್ ಫ್ರೆಂಚ್',
 				'frm' => 'ಮಧ್ಯ ಫ್ರೆಂಚ್',
 				'fro' => 'ಪ್ರಾಚೀನ ಫ್ರೆಂಚ್',
 				'frr' => 'ಉತ್ತರ ಫ್ರಿಸಿಯನ್',
 				'frs' => 'ಪೂರ್ವ ಫ್ರಿಸಿಯನ್',
 				'fur' => 'ಫ್ರಿಯುಲಿಯನ್',
 				'fy' => 'ಪಶ್ಚಿಮ ಫ್ರಿಸಿಯನ್',
 				'ga' => 'ಐರಿಷ್',
 				'gaa' => 'ಗ',
 				'gag' => 'ಗಗೌಜ್',
 				'gay' => 'ಗಾಯೋ',
 				'gba' => 'ಗ್ಬಾಯಾ',
 				'gd' => 'ಸ್ಕಾಟಿಶ್ ಗ್ಯಾಲಿಕ್',
 				'gez' => 'ಗೀಝ್',
 				'gil' => 'ಗಿಲ್ಬರ್ಟೀಸ್',
 				'gl' => 'ಗ್ಯಾಲಿಶಿಯನ್',
 				'gmh' => 'ಮಧ್ಯ ಹೈ ಜರ್ಮನ್',
 				'gn' => 'ಗೌರಾನಿ',
 				'goh' => 'ಪ್ರಾಚೀನ ಹೈ ಜರ್ಮನ್',
 				'gon' => 'ಗೊಂಡಿ',
 				'gor' => 'ಗೊರೊಂಟಾಲೋ',
 				'got' => 'ಗೋಥಿಕ್',
 				'grb' => 'ಗ್ರೇಬೋ',
 				'grc' => 'ಪ್ರಾಚೀನ ಗ್ರೀಕ್',
 				'gsw' => 'ಸ್ವಿಸ್ ಜರ್ಮನ್',
 				'gu' => 'ಗುಜರಾತಿ',
 				'guz' => 'ಗುಸಿ',
 				'gv' => 'ಮ್ಯಾಂಕ್ಸ್',
 				'gwi' => 'ಗ್ವಿಚ್‌ಇನ್',
 				'ha' => 'ಹೌಸಾ',
 				'hai' => 'ಹೈಡಾ',
 				'haw' => 'ಹವಾಯಿಯನ್',
 				'he' => 'ಹೀಬ್ರ್ಯೂ',
 				'hi' => 'ಹಿಂದಿ',
 				'hil' => 'ಹಿಲಿಗೇನನ್',
 				'hit' => 'ಹಿಟ್ಟಿಟೆ',
 				'hmn' => 'ಮೋಂಗ್',
 				'ho' => 'ಹಿರಿ ಮೊಟು',
 				'hr' => 'ಕ್ರೊಯೇಶಿಯನ್',
 				'hsb' => 'ಅಪ್ಪರ್ ಸರ್ಬಿಯನ್',
 				'ht' => 'ಹೈತಿಯನ್',
 				'hu' => 'ಹಂಗೇರಿಯನ್',
 				'hup' => 'ಹೂಪಾ',
 				'hy' => 'ಅರ್ಮೇನಿಯನ್',
 				'hz' => 'ಹೆರೆರೊ',
 				'ia' => 'ಇಂಟರ್‌ಲಿಂಗ್ವಾ',
 				'iba' => 'ಇಬಾನ್',
 				'id' => 'ಇಂಡೋನೇಶಿಯನ್',
 				'ie' => 'ಇಂಟರ್ಲಿಂಗ್',
 				'ig' => 'ಇಗ್ಬೊ',
 				'ii' => 'ಸಿಚುಅನ್ ಯಿ',
 				'ik' => 'ಇನುಪಿಯಾಕ್',
 				'ilo' => 'ಇಲ್ಲಿಕೋ',
 				'inh' => 'ಇಂಗುಷ್',
 				'io' => 'ಇಡೊ',
 				'is' => 'ಐಸ್ಲಾಂಡಿಕ್',
 				'it' => 'ಇಟಾಲಿಯನ್',
 				'iu' => 'ಇನುಕ್ಟಿಟುಟ್',
 				'ja' => 'ಜಾಪನೀಸ್',
 				'jbo' => 'ಲೊಜ್ಬಾನ್',
 				'jgo' => 'ನೊಂಬಾ',
 				'jmc' => 'ಮ್ಯಕಮೆ',
 				'jpr' => 'ಜೂಡಿಯೋ-ಪರ್ಶಿಯನ್',
 				'jrb' => 'ಜೂಡಿಯೋ-ಅರೇಬಿಕ್',
 				'jv' => 'ಜಾವಾನೀಸ್',
 				'ka' => 'ಜಾರ್ಜಿಯನ್',
 				'kaa' => 'ಕಾರಾ-ಕಲ್ಪಾಕ್',
 				'kab' => 'ಕಬೈಲ್',
 				'kac' => 'ಕಚಿನ್',
 				'kaj' => 'ಜ್ಜು',
 				'kam' => 'ಕಂಬಾ',
 				'kaw' => 'ಕಾವಿ',
 				'kbd' => 'ಕಬರ್ಡಿಯನ್',
 				'kcg' => 'ಟ್ಯಾಪ್',
 				'kde' => 'ಮ್ಯಾಕೊಂಡ್',
 				'kea' => 'ಕಬುವೆರ್ಡಿಯನು',
 				'kfo' => 'ಕೋರೋ',
 				'kg' => 'ಕೊಂಗೊ',
 				'kha' => 'ಖಾಸಿ',
 				'kho' => 'ಖೋಟಾನೀಸ್',
 				'khq' => 'ಕೊಯ್ರ ಚೀನಿ',
 				'ki' => 'ಕಿಕುಯು',
 				'kj' => 'ಕ್ವಾನ್‌ಯಾಮಾ',
 				'kk' => 'ಕಝಕ್',
 				'kl' => 'ಕಲಾಲ್ಲಿಸುಟ್',
 				'kln' => 'ಕಲೆಂಜಿನ್',
 				'km' => 'ಖಮೇರ್',
 				'kmb' => 'ಕಿಂಬುಂಡು',
 				'kn' => 'ಕನ್ನಡ',
 				'ko' => 'ಕೊರಿಯನ್',
 				'koi' => 'ಕೊಮಿ-ಪರ್ಮ್ಯಕ್',
 				'kok' => 'ಕೊಂಕಣಿ',
 				'kos' => 'ಕೊಸರಿಯನ್',
 				'kpe' => 'ಕಪೆಲ್ಲೆ',
 				'kr' => 'ಕನುರಿ',
 				'krc' => 'ಕರಚಯ್-ಬಲ್ಕಾರ್',
 				'krl' => 'ಕರೇಲಿಯನ್',
 				'kru' => 'ಕುರುಖ್',
 				'ks' => 'ಕಾಶ್ಮೀರಿ',
 				'ksb' => 'ಶಂಬಲ',
 				'ksf' => 'ಬಫಿಯ',
 				'ku' => 'ಕುರ್ದಿಷ್',
 				'kum' => 'ಕುಮೈಕ್',
 				'kut' => 'ಕುಟೇನಾಯ್',
 				'kv' => 'ಕೋಮಿ',
 				'kw' => 'ಕೋರ್ನಿಷ್',
 				'ky' => 'ಕಿರ್ಗಿಜ್',
 				'la' => 'ಲ್ಯಾಟಿನ್',
 				'lad' => 'ಕಾಡಿನೋ',
 				'lag' => 'ಲಾಂಗಿ',
 				'lah' => 'ಲಹಂಡಾ',
 				'lam' => 'ಲಂಬಾ',
 				'lb' => 'ಲಕ್ಸಂಬರ್ಗ್',
 				'lez' => 'ಲೆಜ್ಘಿಯನ್',
 				'lg' => 'ಗಾಂಡಾ',
 				'li' => 'ಲಿಂಬರ್ಗಿಶ್',
 				'lkt' => 'ಲಕೊಟ',
 				'ln' => 'ಲಿಂಗಾಲ',
 				'lo' => 'ಲಾವೋ',
 				'lol' => 'ಮೊಂಗೋ',
 				'loz' => 'ಲೋಝಿ',
 				'lrc' => 'lrc',
 				'lt' => 'ಲಿಥುವೇನಿಯನ್',
 				'lu' => 'ಲೂಬಾ-ಕಟಾಂಗಾ',
 				'lua' => 'ಲುಬ-ಲುಲಾ',
 				'lui' => 'ಲೂಯಿಸೆನೋ',
 				'lun' => 'ಲುಂಡಾ',
 				'luo' => 'ಲುವೋ',
 				'lus' => 'ಲುಶಾಯ್',
 				'luy' => 'ಲುಯಿಯ',
 				'lv' => 'ಲಟ್ವಿಯನ್',
 				'mad' => 'ಮದುರೀಸ್',
 				'mag' => 'ಮಗಾಹಿ',
 				'mai' => 'ಮೈಥಿಲಿ',
 				'mak' => 'ಮಕಾಸರ್',
 				'man' => 'ಮಂಡಿಂಗೊ',
 				'mas' => 'ಮಸಾಯ್',
 				'mdf' => 'ಮೋಕ್ಷ',
 				'mdr' => 'ಮಂದಾರ್',
 				'men' => 'ಮೆಂಡೆ',
 				'mer' => 'ಮೆರು',
 				'mfe' => 'ಮೊರಿಸನ್',
 				'mg' => 'ಮಲಗಾಸಿ',
 				'mga' => 'ಮಧ್ಯ ಐರಿಷ್',
 				'mgh' => 'ಮ್ಯಖುವಾ- ಮೀಟ್ಟೊ',
 				'mgo' => 'ಮೆಟಾ',
 				'mh' => 'ಮಾರ್ಶಲ್ಲೀಸ್',
 				'mi' => 'ಮಾವೋರಿ',
 				'mic' => 'ಮಿಕ್‌ಮ್ಯಾಕ್',
 				'min' => 'ಮಿನಂಗ್‌ಕಬಾವು',
 				'mk' => 'ಮೆಸಿಡೋನಿಯನ್',
 				'ml' => 'ಮಲಯಾಳಂ',
 				'mn' => 'ಮಂಗೋಲಿಯನ್',
 				'mnc' => 'ಮಂಚು',
 				'mni' => 'ಮಣಿಪುರಿ',
 				'moh' => 'ಮೊಹಾವ್ಕ್',
 				'mos' => 'ಮೊಸ್ಸಿ',
 				'mr' => 'ಮರಾಠಿ',
 				'ms' => 'ಮಲಯ್',
 				'mt' => 'ಮಾಲ್ಟೀಸ್',
 				'mua' => 'ಮುಂಡಂಗ್',
 				'mul' => 'ಬಹುಸಂಖ್ಯೆಯ ಭಾಷೆಗಳು',
 				'mus' => 'ಕ್ರೀಕ್',
 				'mwl' => 'ಕಿರಾಂಡೀಸ್',
 				'mwr' => 'ಮಾರ್ವಾಡಿ',
 				'my' => 'ಬರ್ಮೀಸ್',
 				'myv' => 'ಎರ್‌ಝ್ಯಾ',
 				'mzn' => 'mzn',
 				'na' => 'ನೌರು',
 				'nap' => 'ನಿಯಾಪೊಲಿಟನ್',
 				'naq' => 'ನಮ',
 				'nb' => 'ನಾರ್ವೆಜಿಯನ್ ಬೊಕ್ಮಲ್',
 				'nd' => 'ಉತ್ತರ ದೆಬೆಲೆ',
 				'nds' => 'ಲೋ ಜರ್ಮನ್',
 				'ne' => 'ನೇಪಾಳಿ',
 				'new' => 'ನೇವಾರೀ',
 				'ng' => 'ಡೋಂಗಾ',
 				'nia' => 'ನಿಯಾಸ್',
 				'niu' => 'ನಿಯುವನ್',
 				'nl' => 'ಡಚ್',
 				'nl_BE' => 'ಫ್ಲೆಮಿಷ್',
 				'nmg' => 'ಖ್ವಾಸಿಯೊ',
 				'nn' => 'ನಾರ್ವೆಜಿಯನ್ ನೈನೊಸ್ಕ್',
 				'no' => 'ನಾರ್ವೇಜಿಯನ್',
 				'nog' => 'ನೊಗಾಯ್',
 				'non' => 'ಪ್ರಾಚೀನ ನೋರ್ಸ್',
 				'nqo' => 'ಎನ್‌ಕೋ',
 				'nr' => 'ದಕ್ಷಿಣ ದೆಬೆಲೆ',
 				'nso' => 'ಉತ್ತರ ಸೋಥೋ',
 				'nus' => 'ನೂಯರ್',
 				'nv' => 'ನವಾಜೊ',
 				'nwc' => 'ಶಾಸ್ತ್ರೀಯ ನೇವಾರಿ',
 				'ny' => 'ನ್ಯಾಂಜಾ',
 				'nym' => 'ನ್ಯಾಮ್‌ವೆಂಜಿ',
 				'nyn' => 'ನ್ಯಾನ್‌ಕೋಲೆ',
 				'nyo' => 'ನ್ಯೋರೋ',
 				'nzi' => 'ಜೀಮಾ',
 				'oc' => 'ಒಸಿಟನ್',
 				'oj' => 'ಒಜಿಬ್ವಾ',
 				'om' => 'ಓರೊಮೋ',
 				'or' => 'ಒರಿಯಾ',
 				'os' => 'ಒಸ್ಸೆಟಿಕ್',
 				'osa' => 'ಓಸಾಜ್',
 				'ota' => 'ಒಟ್ಟೋಮನ್ ತುರ್ಕಿಷ್',
 				'pa' => 'ಪಂಜಾಬಿ',
 				'pag' => 'ಪಂಗಾಸಿನನ್',
 				'pal' => 'ಪಹ್ಲವಿ',
 				'pam' => 'ಪಂಪಾಂಗಾ',
 				'pap' => 'ಪಾಪಿಯಮೆಂಟೋ',
 				'pau' => 'ಪಲುಆನ್',
 				'peo' => 'ಪ್ರಾಚೀನ ಪರ್ಶಿಯನ್',
 				'phn' => 'ಫೀನಿಷಿಯನ್',
 				'pi' => 'ಪಾಲಿ',
 				'pl' => 'ಪೋಲಿಶ್',
 				'pon' => 'ಪೋನ್‌‌ಪಿಯನ್',
 				'pro' => 'ಪ್ರಾಚೀನ ಪ್ರೊವೆನ್ಶಿಯಲ್',
 				'ps' => 'ಪಾಷ್ಟೋ',
 				'ps@alt=variant' => 'ಪುಶ್ತೋ',
 				'pt' => 'ಪೋರ್ಚುಗೀಸ್',
 				'pt_BR' => 'ಬ್ರೆಜಿಲಿಯನ್ ಪೋರ್ಚುಗೀಸ್',
 				'pt_PT' => 'ಯೂರೋಪಿಯನ್ ಪೋರ್ಚುಗೀಸ್',
 				'qu' => 'ಕ್ವೆಚುವಾ',
 				'quc' => 'ಕಿಷೆ',
 				'raj' => 'ರಾಜಾಸ್ಥಾನಿ',
 				'rap' => 'ರಾಪಾನುಯಿ',
 				'rar' => 'ರಾರೋಟೊಂಗನ್',
 				'rm' => 'ರೊಮಾನ್ಷ್',
 				'rn' => 'ರುಂಡಿ',
 				'ro' => 'ರೊಮೇನಿಯನ್',
 				'ro_MD' => 'ಮೊಲ್ಡೆವಿಯನ್',
 				'rof' => 'ರೊಂಬೊ',
 				'rom' => 'ರೋಮಾನಿ',
 				'root' => 'ರೂಟ್',
 				'ru' => 'ರಷ್ಯನ್',
 				'rup' => 'ಅರೋಮಾನಿಯನ್',
 				'rw' => 'ಕೀನ್ಯಾರುವಾಂಡಾ',
 				'rwk' => 'ರುವ',
 				'sa' => 'ಸಂಸ್ಕೃತ',
 				'sad' => 'ಸಂಡಾವೇ',
 				'sah' => 'ಯಾಕುಟ್',
 				'sam' => 'ಸಮರಿಟನ್ ಅರಾಮಿಕ್',
 				'saq' => 'ಸಂಬುರು',
 				'sas' => 'ಸಸಾಕ್',
 				'sat' => 'ಸಂತಾಲಿ',
 				'sbp' => 'ಸಂಗು',
 				'sc' => 'ಸರ್ಡೀನಿಯನ್',
 				'scn' => 'ಸಿಸಿಲಿಯನ್',
 				'sco' => 'ಸ್ಕೋಟ್ಸ್',
 				'sd' => 'ಸಿಂಧಿ',
 				'sdh' => 'ದಕ್ಷಿಣ ಕುರ್ದಿಶ್',
 				'se' => 'ಉತ್ತರ ಸಾಮಿ',
 				'seh' => 'ಸೆನ',
 				'sel' => 'ಸೆಲ್ಕಪ್',
 				'ses' => 'ಕೊಯ್ರಬೊರೊ ಸೆನ್ನಿ',
 				'sg' => 'ಸಾಂಗೋ',
 				'sga' => 'ಪ್ರಾಚೀನ ಐರಿಷ್',
 				'sh' => 'ಸರ್ಬೋ-ಕ್ರೊಯೇಶಿಯನ್',
 				'shi' => 'ಟಷೆಲ್‍ಹಿಟ್',
 				'shn' => 'ಶಾನ್',
 				'si' => 'ಸಿಂಹಳ',
 				'sid' => 'ಸಿಡಾಮೋ',
 				'sk' => 'ಸ್ಲೋವಾಕ್',
 				'sl' => 'ಸ್ಲೋವೇನಿಯನ್',
 				'sm' => 'ಸಮೋವನ್',
 				'sma' => 'ದಕ್ಷಿಣ ಸಾಮಿ',
 				'smj' => 'ಲೂಲ್ ಸಾಮಿ',
 				'smn' => 'ಇನರಿ ಸಾಮಿ',
 				'sms' => 'ಸ್ಕೋಟ್ ಸಾಮಿ',
 				'sn' => 'ಶೋನಾ',
 				'snk' => 'ಸೋನಿಂಕೆ',
 				'so' => 'ಸೊಮಾಲಿ',
 				'sog' => 'ಸೋಗ್ಡಿಏನ್',
 				'sq' => 'ಅಲ್ಬೇನಿಯನ್',
 				'sr' => 'ಸರ್ಬಿಯನ್',
 				'srn' => 'ಸ್ರಾನನ್ ಟೋಂಗೋ',
 				'srr' => 'ಸೇರೇರ್',
 				'ss' => 'ಸ್ವಾತಿ',
 				'st' => 'ದಕ್ಷಿಣ ಸೋಥೋ',
 				'su' => 'ಸುಂಡಾನೀಸ್',
 				'suk' => 'ಸುಕುಮಾ',
 				'sus' => 'ಸುಸು',
 				'sux' => 'ಸುಮೇರಿಯನ್',
 				'sv' => 'ಸ್ವೀಡಿಷ್',
 				'sw' => 'ಸ್ವಹಿಲಿ',
 				'swb' => 'ಕೊಮೊರಿಯನ್',
 				'swc' => 'ಕಾಂಗೊ ಸ್ವಹಿಲಿ',
 				'syc' => 'ಶಾಸ್ತ್ರೀಯ ಸಿರಿಯಕ್',
 				'syr' => 'ಸಿರಿಯಕ್',
 				'ta' => 'ತಮಿಳು',
 				'te' => 'ತೆಲುಗು',
 				'tem' => 'ಟಿಮ್ನೆ',
 				'teo' => 'ಟೆಸೊ',
 				'ter' => 'ಟೆರೆನೋ',
 				'tet' => 'ಟೇಟಮ್',
 				'tg' => 'ತಾಜಿಕ್',
 				'th' => 'ಥಾಯ್',
 				'ti' => 'ಟಿಗ್ರಿನ್ಯಾ',
 				'tig' => 'ಟೈಗ್ರೆ',
 				'tiv' => 'ಟಿವ್',
 				'tk' => 'ಟರ್ಕ್‌ಮೆನ್',
 				'tkl' => 'ಟೊಕೆಲಾವ್',
 				'tl' => 'ಟ್ಯಾಗಲೋಗ್',
 				'tlh' => 'ಕ್ಲಿಂಗನ್',
 				'tli' => 'ಟ್ಲಿಂಗಿಟ್',
 				'tmh' => 'ಟಮಾಷೆಕ್',
 				'tn' => 'ಸ್ವಾನಾ',
 				'to' => 'ಟೋಂಗನ್',
 				'tog' => 'ನ್ಯಾಸಾ ಟೋಂಗಾ',
 				'tpi' => 'ಟೋಕ್ ಪಿಸಿನ್',
 				'tr' => 'ಟರ್ಕಿಶ್',
 				'ts' => 'ಸೋಂಗಾ',
 				'tsi' => 'ಸಿಂಶಿಯನ್',
 				'tt' => 'ಟಾಟರ್',
 				'tum' => 'ತುಂಬುಕಾ',
 				'tvl' => 'ಟುವಾಲು',
 				'tw' => 'ಟ್ವಿ',
 				'twq' => 'ಟಸವಕ್',
 				'ty' => 'ತಹಿತಿಯನ್',
 				'tyv' => 'ಟುವಿನಿಯನ್',
 				'tzm' => 'ಮಧ್ಯ ಅಟ್ಲಾಸ್ ಟಮಜೈಟ್',
 				'udm' => 'ಉಡ್‌ಮುರ್ಟ್',
 				'ug' => 'ಉಯಿಘರ್',
 				'ug@alt=variant' => 'ಉಯ್‌ಗರ್',
 				'uga' => 'ಉಗಾರಿಟಿಕ್',
 				'uk' => 'ಉಕ್ರೈನಿಯನ್',
 				'umb' => 'ಉಂಬುಂಡು',
 				'und' => 'ಅಪರಿಚಿತ ಅಥವಾ ಅಮಾನ್ಯ ಭಾಷೆ',
 				'ur' => 'ಉರ್ದು',
 				'uz' => 'ಉಜ್ಬೇಕ್',
 				'vai' => 'ವಾಯಿ',
 				've' => 'ವೆಂಡಾ',
 				'vi' => 'ವಿಯೇಟ್ನಾಮೀಸ್',
 				'vo' => 'ವೋಲಾಪುಕ್',
 				'vot' => 'ವೋಟಿಕ್',
 				'vun' => 'ವುಂಜೊ',
 				'wa' => 'ವಾಲೂನ್',
 				'wal' => 'ವಲಾಮೋ',
 				'war' => 'ವರಾಯ್',
 				'was' => 'ವಾಷೋ',
 				'wbp' => 'ವಾರ್ಲ್‌ಪಿರಿ',
 				'wo' => 'ವೋಲೋಫ್',
 				'xal' => 'ಕಲ್‌ಮೈಕ್',
 				'xh' => 'ಕ್ಸೋಸ',
 				'xog' => 'ಸೊಗ',
 				'yao' => 'ಯಾಓ',
 				'yap' => 'ಯಪೀಸೆ',
 				'yi' => 'ಯಡ್ಡಿಶ್',
 				'yo' => 'ಯೊರುಬಾ',
 				'yue' => 'ಕಾಂಟೊನೀಸ್',
 				'za' => 'ಝೂವಾಂಗ್',
 				'zap' => 'ಝೋಪೊಟೆಕ್',
 				'zbl' => 'ಬ್ಲಿಸ್‌ಸಿಂಬಲ್ಸ್',
 				'zen' => 'ಝೆನಾಗಾ',
 				'zgh' => 'ಸ್ಟ್ಯಾಂಡರ್ಡ್ ಮೊರೊಕ್ಕನ್ ಟಮಜೈಟ್',
 				'zh' => 'ಚೈನೀಸ್',
 				'zh_Hans' => 'ಸರಳೀಕೃತ ಚೈನೀಸ್',
 				'zh_Hant' => 'ಸಾಂಪ್ರದಾಯಿಕ ಚೈನೀಸ್',
 				'zu' => 'ಜುಲು',
 				'zun' => 'ಝೂನಿ',
 				'zxx' => 'ಯಾವುದೇ ಭಾಷಾಸಂಬಂಧಿ ವಿಷಯವಿಲ್ಲ',
 				'zza' => 'ಜಾಝಾ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'ಅರೇಬಿಕ್',
 			'Arab@alt=variant' => 'ಪರ್ಸೊ-ಅರೇಬಿಕ್',
 			'Armi' => 'ಇಂಪೀರಿಯಲ್ ಅರೆಮಾಯಿಕ್',
 			'Armn' => 'ಅರ್ಮೇನಿಯನ್',
 			'Avst' => 'ಅವೆಸ್ತಾನ್',
 			'Bali' => 'ಬಾಲಿನೀಸ್',
 			'Batk' => 'ಬಾಟಕ್',
 			'Beng' => 'ಬೆಂಗಾಲಿ',
 			'Blis' => 'ಬ್ಲಿಸ್‌ಸಿಂಬಲ್ಸ್',
 			'Bopo' => 'ಬೋಪೊಮೋಫೋ',
 			'Brah' => 'ಬ್ರಾಹ್ಮಿ',
 			'Brai' => 'ಬ್ರೈಲ್',
 			'Bugi' => 'ಬಗಿನೀಸ್',
 			'Buhd' => 'ಬುಹಿದ್',
 			'Cakm' => 'ಕಾಕಂ',
 			'Cans' => 'ಯುನಿಟೆಡ್ ಕೆನೆಡಿಯನ್ ಅಬೊರಿಜಿನಲ್ ಸಿಲ್ಯಾಬಿಕ್ಸ್',
 			'Cari' => 'ಕರೇನ್',
 			'Cham' => 'ಚಾಮ್',
 			'Cher' => 'ಚೆರೋಕೀ',
 			'Cirt' => 'ಸಿರ್ಥ್',
 			'Copt' => 'ಕಾಪ್ಟಿಕ್',
 			'Cprt' => 'ಸಿಪ್ರಿಯಾಟ್',
 			'Cyrl' => 'ಸಿರಿಲಿಕ್',
 			'Cyrs' => 'ಪ್ರಾಚೀನ ಚರ್ಚ್ ಸ್ಲೋವಾನಿಕ್ ಸಿರಿಲಿಕ್',
 			'Deva' => 'ದೇವನಾಗರಿ',
 			'Dsrt' => 'ಡಸರ್ಟ್',
 			'Egyd' => 'ಈಜಿಪ್ಟಿಯನ್ ಡೆಮೋಟಿಕ್',
 			'Egyh' => 'ಈಜಿಪ್ಟಿಯನ್ ಹಯಾರಿಟಿಕ್',
 			'Egyp' => 'ಈಜಿಪ್ಟಿಯನ್ ಹೀರೋಗ್ಲಿಫ್ಸ್',
 			'Ethi' => 'ಇಥಿಯೋಪಿಕ್',
 			'Geok' => 'ಜಾರ್ಜಿಯನ್ ಖುಸ್ತುರಿ',
 			'Geor' => 'ಜಾರ್ಜಿಯನ್',
 			'Glag' => 'ಗ್ಲಾಗೋಲಿಟಿಕ್',
 			'Goth' => 'ಗೋತಿಕ್',
 			'Grek' => 'ಗ್ರೀಕ್',
 			'Gujr' => 'ಗುಜರಾತಿ',
 			'Guru' => 'ಗುರ್ಮುಖಿ',
 			'Hang' => 'ಹ್ಯಾಂಗುಲ್',
 			'Hani' => 'ಹಾನ್',
 			'Hano' => 'ಹನೂನೂ',
 			'Hans' => 'ಸರಳೀಕೃತ',
 			'Hans@alt=stand-alone' => 'ಸರಳೀಕೃತ ಹಾನ್',
 			'Hant' => 'ಸಾಂಪ್ರದಾಯಿಕ',
 			'Hant@alt=stand-alone' => 'ಸಾಂಪ್ರದಾಯಿಕ ಹಾನ್',
 			'Hebr' => 'ಹೀಬ್ರೂ',
 			'Hira' => 'ಹಿರಗಾನಾ',
 			'Hmng' => 'ಪಹವ್ ಹ್ಮೋಂಗ್',
 			'Hrkt' => 'ಕಟಕಾನಾ ಅಥವಾ ಹಿರಗಾನಾ',
 			'Hung' => 'ಪ್ರಾಚೀನ ಹಂಗೇರಿಯನ್',
 			'Inds' => 'ಸಿಂಧೂ',
 			'Ital' => 'ಪ್ರಾಚೀನ್ ಇಟಾಲಿಕ್',
 			'Java' => 'ಜಾವನೀಸ್',
 			'Jpan' => 'ಜಾಪನೀಸ್',
 			'Kali' => 'ಕೆಯಾ ಲಿ',
 			'Kana' => 'ಕಟಕಾನಾ',
 			'Khar' => 'ಖರೋಶ್ತಿ',
 			'Khmr' => 'ಖಮೇ',
 			'Knda' => 'ಕನ್ನಡ',
 			'Kore' => 'ಕೊರಿಯನ್',
 			'Kthi' => 'ಕೈಥಿ',
 			'Lana' => 'ಲಾನಾ',
 			'Laoo' => 'ಲಾವೋ',
 			'Latf' => 'ಫ್ರಾಕ್ತರ್ ಲ್ಯಾಟಿನ್',
 			'Latg' => 'ಗೇಲಿಕ್ ಲ್ಯಾಟಿನ್',
 			'Latn' => 'ಲ್ಯಾಟಿನ್',
 			'Lepc' => 'ಲೆಪ್ಚಾ',
 			'Limb' => 'ಲಿಂಬು',
 			'Lina' => 'ಲೀನಯರ್ ಎ',
 			'Linb' => 'ಲೀನಯರ್ ಬಿ',
 			'Lyci' => 'ಲೈಸಿಯನ್',
 			'Lydi' => 'ಲಿಡಿಯನ್',
 			'Mand' => 'ಮಂಡೇಯನ್',
 			'Mani' => 'ಮನಿಚೈಯನ್',
 			'Maya' => 'ಮಯಾನ್ ಹೀರೋಗ್ಲಿಫ್ಸ್',
 			'Mero' => 'ಮೆರೊಯಿಟಿಕ್',
 			'Mlym' => 'ಮಲಯಾಳಂ',
 			'Mong' => 'ಮಂಗೋಲಿಯನ್',
 			'Moon' => 'ಮೂನ್',
 			'Mtei' => 'ಮೈತಿ ಮಯೆಕ್',
 			'Mymr' => 'ಮ್ಯಾನ್ಮಾರ್',
 			'Nkoo' => 'ಎನ್‍ಕೋ',
 			'Ogam' => 'ಓಘಮ್',
 			'Olck' => 'ಓಲ್ ಚಿಕಿ',
 			'Orkh' => 'ಓರ್ಖೋನ್',
 			'Orya' => 'ಒರಿಯಾ',
 			'Osma' => 'ಓಸ್ಮಾನ್ಯಾ',
 			'Perm' => 'ಪ್ರಾಚೀನ ಪೆರ್ಮಿಕ್',
 			'Phag' => 'ಫಾಗ್ಸ್-ಪಾ',
 			'Phli' => 'ಇನ್ಸ್‌ಕ್ರಿಪ್ಶನಲ್ ಪಾಹ್ಲವಿ',
 			'Phlp' => 'ಸಾಲ್ಟರ್ ಪಾಹ್ಲವಿ',
 			'Phlv' => 'ಬುಕ್ ಪಾಹ್ಲವಿ',
 			'Phnx' => 'ಫೀನಿಶಿಯನ್',
 			'Plrd' => 'ಪೊಲ್ಲಾರ್ಡ್ ಫೊನೆಟಿಕ್',
 			'Prti' => 'ಇನ್ಸ್‌ಕ್ರಿಪ್ಶನಲ್ ಪಾರ್ಥಿಯನ್',
 			'Rjng' => 'ರೆಜಾಂಗ್',
 			'Roro' => 'ರೋಂಗೋರೋಂಗೋ',
 			'Runr' => 'ರೂನಿಕ್',
 			'Samr' => 'ಸಮಾರಿಟನ್',
 			'Sara' => 'ಸರಾಟಿ',
 			'Saur' => 'ಸೌರಾಷ್ಟ್ರ',
 			'Sgnw' => 'ಸೈನ್‌ರೈಟಿಂಗ್',
 			'Shaw' => 'ಶಾವಿಯಾನ್',
 			'Sinh' => 'ಸಿಂಹಳ',
 			'Sund' => 'ಸುಂಡಾನೀಸ್',
 			'Sylo' => 'ಸೈಲೋಟಿ ನಗ್ರಿ',
 			'Syrc' => 'ಸಿರಿಯಾಕ್',
 			'Syre' => 'ಎಸ್ಟ್ರಾಂಜಿಲೋ ಸಿರಿಯಾಕ್',
 			'Syrj' => 'ಪಶ್ಚಿಮ ಸಿರಿಯಾಕ್',
 			'Syrn' => 'ಪೂರ್ವ ಸಿರಿಯಾಕ್',
 			'Tagb' => 'ಟಾಗ್ಬಾನವಾ',
 			'Tale' => 'ಥಾಯ್ ಲಿ',
 			'Talu' => 'ನ್ಯೂ ಥಾಯ್ ಲುಇ',
 			'Taml' => 'ತಮಿಳು',
 			'Tavt' => 'ಥಾಯ್ ವಿಯೆಟ್',
 			'Telu' => 'ತೆಲುಗು',
 			'Teng' => 'ತೆಂಗ್‌ವಾರ್',
 			'Tfng' => 'ಟಿಫಿನಾಘ್',
 			'Tglg' => 'ಟ್ಯಾಗಲೋಗ್',
 			'Thaa' => 'ಥಾನಾ',
 			'Thai' => 'ಥಾಯ್',
 			'Tibt' => 'ಟಿಬೇಟನ್',
 			'Ugar' => 'ಉಗಾರಿಟಿಕ್',
 			'Vaii' => 'ವಾಯ್',
 			'Visp' => 'ವಿಸಿಬಲ್ ಸ್ಪೀಚ್',
 			'Xpeo' => 'ಪ್ರಾಚೀನ ಪರ್ಶಿಯನ್',
 			'Xsux' => 'ಸುಮೇರೋ-ಅಕ್ಕಾಡಿಯನ್ ಕ್ಯೂನಿಫಾರ್ಮ್',
 			'Yiii' => 'ಯಿ',
 			'Zinh' => 'ಇನ್‍ಹೆರಿಟೆಡ್',
 			'Zmth' => 'ಗಣೀತ ಸಂಕೇತಲಿಪಿ',
 			'Zsym' => 'ಸಂಕೇತಗಳು',
 			'Zxxx' => 'ಅಲಿಖಿತ',
 			'Zyyy' => 'ಸಾಮಾನ್ಯ',
 			'Zzzz' => 'ಗೊತ್ತಿಲ್ಲದ ಲಿಪಿ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ಪ್ರಪಂಚ',
 			'002' => 'ಆಫ್ರಿಕಾ',
 			'003' => 'ಉತ್ತರ ಅಮೇರಿಕಾ',
 			'005' => 'ದಕ್ಷಿಣ ಅಮೇರಿಕಾ',
 			'009' => 'ಓಶಿಯೇನಿಯಾ',
 			'011' => 'ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ',
 			'013' => 'ಮಧ್ಯ ಅಮೇರಿಕಾ',
 			'014' => 'ಪೂರ್ವ ಆಫ್ರಿಕಾ',
 			'015' => 'ಉತ್ತರ ಆಫ್ರಿಕಾ',
 			'017' => 'ಮಧ್ಯ ಆಫ್ರಿಕಾ',
 			'018' => 'ಆಫ್ರಿಕಾದ ದಕ್ಷಿಣ ಭಾಗ',
 			'019' => 'ಅಮೆರಿಕಾಸ್',
 			'021' => 'ಅಮೇರಿಕಾದ ಉತ್ತರ ಭಾಗ',
 			'029' => 'ಕೆರೀಬಿಯನ್',
 			'030' => 'ಪೂರ್ವ ಏಷ್ಯಾ',
 			'034' => 'ದಕ್ಷಿಣ ಏಷ್ಯಾ',
 			'035' => 'ಆಗ್ನೇಯ ಏಷ್ಯಾ',
 			'039' => 'ದಕ್ಷಿಣ ಯೂರೋಪ್',
 			'053' => 'ಆಸ್ಟ್ರೇಲೇಷ್ಯಾ',
 			'054' => 'ಮೆಲನೇಷಿಯಾ',
 			'057' => 'ಮೈಕ್ರೋನೇಶಿಯನ್ ಪ್ರದೇಶ',
 			'061' => 'ಪಾಲಿನೇಷ್ಯಾ',
 			'142' => 'ಏಷ್ಯಾ',
 			'143' => 'ಮಧ್ಯ ಏಷ್ಯಾ',
 			'145' => 'ಪಶ್ಚಿಮ ಏಷ್ಯಾ',
 			'150' => 'ಯೂರೋಪ್',
 			'151' => 'ಪೂರ್ವ ಯೂರೋಪ್',
 			'154' => 'ಉತ್ತರ ಯೂರೋಪ್',
 			'155' => 'ಪಶ್ಚಿಮ ಯೂರೋಪ್',
 			'419' => 'ಲ್ಯಾಟಿನ್ ಅಮೇರಿಕಾ',
 			'AC' => 'ಅಸೆನ್ಶನ್ ದ್ವೀಪ',
 			'AD' => 'ಅಂಡೋರಾ',
 			'AE' => 'ಸಂಯುಕ್ತ ಅರಬ್ ಎಮಿರೇಟಸ್',
 			'AF' => 'ಅಫಘಾನಿಸ್ಥಾನ್',
 			'AG' => 'ಆಂಟಿಗುವಾ ಮತ್ತು ಬರ್ಬುಡಾ',
 			'AI' => 'ಆಂಗುಯಿಲ್ಲಾ',
 			'AL' => 'ಅಲ್ಬೇನಿಯಾ',
 			'AM' => 'ಅರ್ಮೇನಿಯಾ',
 			'AN' => 'ನೆದರ್‌ಲ್ಯಾಂಡ್',
 			'AO' => 'ಅಂಗೋಲಾ',
 			'AQ' => 'ಅಂಟಾರ್ಟಿಕಾ',
 			'AR' => 'ಅರ್ಜೆಂಟಿನಾ',
 			'AS' => 'ಅಮೇರಿಕನ್ ಸಮೋವಾ',
 			'AT' => 'ಆಸ್ಟ್ರಿಯಾ',
 			'AU' => 'ಆಸ್ಟ್ರೇಲಿಯ',
 			'AW' => 'ಅರುಬಾ',
 			'AX' => 'ಆಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು',
 			'AZ' => 'ಅಜರ್ಬೈಜಾನ್',
 			'BA' => 'ಬೋಸ್ನಿಯಾ ಮತ್ತು ಹರ್ಜೆಗೋವಿನಾ',
 			'BB' => 'ಬಾರ್ಬಡೋಸ್',
 			'BD' => 'ಬಾಂಗ್ಲಾದೇಶ್',
 			'BE' => 'ಬೆಲ್ಜಿಯಮ್',
 			'BF' => 'ಬುರ್ಕಿನಾ ಫಾಸೋ',
 			'BG' => 'ಬಲ್ಗೇರಿಯಾ',
 			'BH' => 'ಬಹರೈನ್',
 			'BI' => 'ಬುರುಂಡಿ',
 			'BJ' => 'ಬೆನಿನ್',
 			'BL' => 'ಸೇಂಟ್ ಬಾರ್ಥೆಲೆಮಿ',
 			'BM' => 'ಬರ್ಮುಡಾ',
 			'BN' => 'ಬ್ರೂನಿ',
 			'BO' => 'ಬೊಲಿವಿಯಾ',
 			'BQ' => 'ಕೆರೀಬಿಯನ್ ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್',
 			'BR' => 'ಬ್ರೆಜಿಲ್',
 			'BS' => 'ಬಹಾಮಾಸ್',
 			'BT' => 'ಭೂತಾನ್',
 			'BV' => 'ಬೋವೆಟ್ ದ್ವೀಪ',
 			'BW' => 'ಬೋಟ್ಸ್‌ವಾನಾ',
 			'BY' => 'ಬೆಲಾರಸ್',
 			'BZ' => 'ಬೆಲಿಜ್',
 			'CA' => 'ಕೆನಡಾ',
 			'CC' => 'ಕೊಕೊಸ್ (ಕೀಲಿಂಗ್) ದ್ವೀಪಗಳು',
 			'CD' => 'ಕಾಂಗೋ - ಕಿನ್ಶಾಸಾ',
 			'CD@alt=variant' => 'ಕಾಂಗೋ (DRC)',
 			'CF' => 'ಮಧ್ಯ ಆಫ್ರಿಕಾ ಗಣರಾಜ್ಯ',
 			'CG' => 'ಕಾಂಗೋ - ಬ್ರಾಜಾವಿಲ್ಲೇ',
 			'CG@alt=variant' => 'ಕಾಂಗೋ (ಗಣರಾಜ್ಯ)',
 			'CH' => 'ಸ್ವಿಟ್ಜರ್ಲ್ಯಾಂಡ್',
 			'CI' => 'ಕೋತ್‌ ದಿವಾರ್‍',
 			'CI@alt=variant' => 'ಐವರಿ ಕೋಸ್ಟ್',
 			'CK' => 'ಕುಕ್ ದ್ವೀಪಗಳು',
 			'CL' => 'ಚಿಲಿ',
 			'CM' => 'ಕ್ಯಾಮರೋನ್',
 			'CN' => 'ಚೀನಾ',
 			'CO' => 'ಕೊಲಂಬಿಯಾ',
 			'CP' => 'ಕ್ಲಿಪ್ಪರ್‌ಟಾನ್ ದ್ವೀಪಗಳು',
 			'CR' => 'ಕೊಸ್ಟಾ ರಿಕಾ',
 			'CU' => 'ಕ್ಯೂಬಾ',
 			'CV' => 'ಕೇಪ್ ವರ್ಡೆ',
 			'CW' => 'ಕುರಾಕಾವ್',
 			'CX' => 'ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ',
 			'CY' => 'ಸೈಪ್ರಸ್',
 			'CZ' => 'ಚೆಕ್ ರಿಪಬ್ಲಿಕ್',
 			'DE' => 'ಜರ್ಮನಿ',
 			'DG' => 'ಡೈಗೋ ಗಾರ್ಸಿಯ',
 			'DJ' => 'ಜಿಬೋಟಿ',
 			'DK' => 'ಡೆನ್ಮಾರ್ಕ್',
 			'DM' => 'ಡೊಮಿನಿಕಾ',
 			'DO' => 'ಡೊಮೆನಿಕನ್ ರಿಪಬ್ಲಿಕ್',
 			'DZ' => 'ಅಲ್ಗೇರಿಯಾ',
 			'EA' => 'ಸೆಯುಟಾ ಹಾಗೂ ಮೆಲಿಲ್ಲಾ',
 			'EC' => 'ಈಕ್ವೆಡಾರ್',
 			'EE' => 'ಎಸ್ಟೋನಿಯಾ',
 			'EG' => 'ಈಜಿಪ್ಟ್',
 			'EH' => 'ಪಶ್ಚಿಮ ಸಹಾರಾ',
 			'ER' => 'ಏರಿಟ್ರಿಯಾ',
 			'ES' => 'ಸ್ಪೇನ್',
 			'ET' => 'ಇಥಿಯೋಪಿಯಾ',
 			'EU' => 'ಯುರೋಪಿಯನ್ ಯೂನಿಯನ್',
 			'FI' => 'ಫಿನ್‌ಲ್ಯಾಂಡ್',
 			'FJ' => 'ಫಿಜಿ',
 			'FK' => 'ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು',
 			'FK@alt=variant' => 'ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳು (ಇಸ್ಲಾಸ್ ಮಾಲ್ವಿನಸ್)',
 			'FM' => 'ಮೈಕ್ರೋನೇಶಿಯಾ',
 			'FO' => 'ಫರೋ ದ್ವೀಪಗಳು',
 			'FR' => 'ಫ್ರಾನ್ಸ್',
 			'GA' => 'ಗೆಬೊನ್',
 			'GB' => 'ಬ್ರಿಟನ್/ಇಂಗ್ಲೆಂಡ್',
 			'GB@alt=short' => 'ಯು.ಕೆ.',
 			'GD' => 'ಗ್ರೆನೆಡಾ',
 			'GE' => 'ಜಾರ್ಜಿಯಾ',
 			'GF' => 'ಫ್ರೆಂಚ್ ಗಯಾನಾ',
 			'GG' => 'ಗುರ್ನ್‌ಸೆ',
 			'GH' => 'ಘಾನಾ',
 			'GI' => 'ಗಿಬ್ರಾಲ್ಟರ್',
 			'GL' => 'ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್',
 			'GM' => 'ಗ್ಯಾಂಬಿಯಾ',
 			'GN' => 'ಗಿನಿ',
 			'GP' => 'ಗುಡೆಲೋಪ್',
 			'GQ' => 'ಈಕ್ವೆಟೋರಿಯಲ್ ಗಿನಿ',
 			'GR' => 'ಗ್ರೀಸ್',
 			'GS' => 'ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಮತ್ತು ದಕ್ಷಿಣ ಸ್ಯಾಂಡ್‍ವಿಚ್ ದ್ವೀಪಗಳು',
 			'GT' => 'ಗ್ವಾಟೆಮಾಲಾ',
 			'GU' => 'ಗುಯಾಮ್',
 			'GW' => 'ಗಿನಿ-ಬಿಸ್ಸಾವ್',
 			'GY' => 'ಗಯಾನಾ',
 			'HK' => 'ಹಾಂಗ್ ಕಾಂಗ್ SAR ಚೈನಾ',
 			'HK@alt=short' => 'ಹಾಂಗ್ ಕಾಂಗ್',
 			'HM' => 'ಹರ್ಡ್ ದ್ವೀಪ ಮತ್ತು ಮ್ಯಾಕ್‍ಡೊನಾಲ್ಡ್ ದ್ವೀಪಗಳು',
 			'HN' => 'ಹೊಂಡುರಾಸ್',
 			'HR' => 'ಕ್ರೊಯೇಶಿಯಾ',
 			'HT' => 'ಹೈಟಿ',
 			'HU' => 'ಹಂಗಾರಿ',
 			'IC' => 'ಕ್ಯಾನರಿ ದ್ವೀಪಗಳು',
 			'ID' => 'ಇಂಡೋನೇಶಿಯಾ',
 			'IE' => 'ಐರ್ಲೆಂಡ್',
 			'IL' => 'ಇಸ್ರೇಲ್',
 			'IM' => 'ಐಲ್ ಆಫ್ ಮ್ಯಾನ್',
 			'IN' => 'ಭಾರತ',
 			'IO' => 'ಬ್ರಿಟೀಶ್ ಇಂಡಿಯನ್ ಮಹಾಸಾಗರ ಪ್ರದೇಶ',
 			'IQ' => 'ಇರಾಕ್',
 			'IR' => 'ಇರಾನ್',
 			'IS' => 'ಐಸ್‌ಲ್ಯಾಂಡ್',
 			'IT' => 'ಇಟಲಿ',
 			'JE' => 'ಜೆರ್ಸಿ',
 			'JM' => 'ಜಮೈಕಾ',
 			'JO' => 'ಜೋರ್ಡಾನ್',
 			'JP' => 'ಜಪಾನ್',
 			'KE' => 'ಕೀನ್ಯಾ',
 			'KG' => 'ಕಿರ್ಗಿಸ್ಥಾನ್',
 			'KH' => 'ಕಾಂಬೋಡಿಯಾ',
 			'KI' => 'ಕಿರಿಬಾತಿ',
 			'KM' => 'ಕೊಮೊರೊಸ್',
 			'KN' => 'ಸೇಂಟ್ ಕಿಟ್ಸ್ ಮತ್ತು ನೆವಿಸ್',
 			'KP' => 'ಉತ್ತರ ಕೋರಿಯಾ',
 			'KR' => 'ದಕ್ಷಿಣ ಕೋರಿಯಾ',
 			'KW' => 'ಕುವೈತ್',
 			'KY' => 'ಕೇಮನ್ ದ್ವೀಪಗಳು',
 			'KZ' => 'ಕಝಾಕಿಸ್ಥಾನ್',
 			'LA' => 'ಲಾವೋಸ್',
 			'LB' => 'ಲೆಬನಾನ್',
 			'LC' => 'ಸೇಂಟ್ ಲೂಸಿಯಾ',
 			'LI' => 'ಲಿಚೆನ್‌ಸ್ಟೈನ್',
 			'LK' => 'ಶ್ರೀಲಂಕಾ',
 			'LR' => 'ಲಿಬೇರಿಯಾ',
 			'LS' => 'ಲೆಸೊಥೋ',
 			'LT' => 'ಲಿಥುವೇನಿಯಾ',
 			'LU' => 'ಲಕ್ಸಂಬರ್ಗ್',
 			'LV' => 'ಲಾಟ್ವಿಯಾ',
 			'LY' => 'ಲಿಬಿಯಾ',
 			'MA' => 'ಮೊರಾಕ್ಕೊ',
 			'MC' => 'ಮೊನಾಕೊ',
 			'MD' => 'ಮೊಲ್ಡೋವಾ',
 			'ME' => 'ಮೊಂಟೆನೆಗ್ರೋ',
 			'MF' => 'ಸೇಂಟ್ ಮಾರ್ಟಿನ್',
 			'MG' => 'ಮಡಗಾಸ್ಕರ್',
 			'MH' => 'ಮಾರ್ಷಲ್ ದ್ವೀಪಗಳು',
 			'MK' => 'ಮ್ಯಾಸಿಡೋನಿಯಾ',
 			'MK@alt=variant' => 'ಮ್ಯಾಸಿಡೋನಿಯ (FYROM)',
 			'ML' => 'ಮಾಲಿ',
 			'MM' => 'ಮಯನ್ಮಾರ್ (ಬರ್ಮಾ)',
 			'MN' => 'ಮೊಂಗೋಲಿಯಾ',
 			'MO' => 'ಮಖಾವ್ (SAR) ಚೈನಾ',
 			'MO@alt=short' => 'ಮಖಾವ್',
 			'MP' => 'ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳು',
 			'MQ' => 'ಮಾರ್ಟಿನಿಕ್',
 			'MR' => 'ಮಾರಿಟೇನಿಯಾ',
 			'MS' => 'ಮಾಂಟ್‌ಸೆರೇಟ್',
 			'MT' => 'ಮಾಲ್ಟಾ',
 			'MU' => 'ಮಾರಿಶಿಯಸ್',
 			'MV' => 'ಮಾಲ್ಡಿವ್ಸ್',
 			'MW' => 'ಮಲಾವಿ',
 			'MX' => 'ಮೆಕ್ಸಿಕೊ',
 			'MY' => 'ಮಲೇಶಿಯಾ',
 			'MZ' => 'ಮೊಜಾಂಬಿಕ್',
 			'NA' => 'ನಮೀಬಿಯಾ',
 			'NC' => 'ನ್ಯೂ ಕ್ಯಾಲಿಡೋನಿಯಾ',
 			'NE' => 'ನೈಜರ್',
 			'NF' => 'ನಾರ್ಫೋಕ್ ದ್ವೀಪ',
 			'NG' => 'ನೈಜೀರಿಯಾ',
 			'NI' => 'ನಿಕಾರಾಗುವಾ',
 			'NL' => 'ನೆದರ್‌ಲ್ಯಾಂಡ್ಸ್',
 			'NO' => 'ನಾರ್ವೇ',
 			'NP' => 'ನೇಪಾಳ',
 			'NR' => 'ನೌರು',
 			'NU' => 'ನಿಯು',
 			'NZ' => 'ನ್ಯೂಜಿಲೆಂಡ್',
 			'OM' => 'ಓಮನ್',
 			'PA' => 'ಪನಾಮಾ',
 			'PE' => 'ಪೆರು',
 			'PF' => 'ಫ್ರೆಂಚ್ ಪಾಲಿನೇಷ್ಯಾ',
 			'PG' => 'ಪಪುವಾ ನ್ಯೂಗಿನಿಯಾ',
 			'PH' => 'ಫಿಲಿಫೈನ್ಸ್',
 			'PK' => 'ಪಾಕಿಸ್ತಾನ',
 			'PL' => 'ಪೋಲ್ಯಾಂಡ್',
 			'PM' => 'ಸೇಂಟ್ ಪಿಯರೆ ಮತ್ತು ಮಿಕೆಲನ್',
 			'PN' => 'ಪಿಟ್‌ಕೈರ್ನ್ ದ್ವೀಪಗಳು',
 			'PR' => 'ಪ್ಯೂರ್ಟೋ ರಿಕೊ',
 			'PS' => 'ಪ್ಯಾಲೇಸ್ಟೇನಿಯನ್ ಪ್ರದೇಶ',
 			'PS@alt=short' => 'ಪ್ಯಾಲೆಸ್ಟೇನ್',
 			'PT' => 'ಪೋರ್ಚುಗಲ್',
 			'PW' => 'ಪಲಾವು',
 			'PY' => 'ಪರಾಗ್ವೇ',
 			'QA' => 'ಖತಾರ್',
 			'QO' => 'ಔಟ್ ಲೈಯಿಂಗ್ ಓಷಿಯಾನಿಯಾ',
 			'RE' => 'ರೀಯೂನಿಯನ್',
 			'RO' => 'ರೊಮೇನಿಯಾ',
 			'RS' => 'ಸೆರ್ಬಿಯಾ',
 			'RU' => 'ರಷ್ಯಾ',
 			'RW' => 'ರುವಾಂಡಾ',
 			'SA' => 'ಸೌದಿ ಅರೇಬಿಯಾ',
 			'SB' => 'ಸೊಲೊಮನ್ ದ್ವೀಪಗಳು',
 			'SC' => 'ಸೀಶೆಲ್ಲೆಸ್',
 			'SD' => 'ಸೂಡಾನ್',
 			'SE' => 'ಸ್ವೀಡನ್',
 			'SG' => 'ಸಿಂಗಾಪುರ್',
 			'SH' => 'ಸೇಂಟ್ ಹೆಲೆನಾ',
 			'SI' => 'ಸ್ಲೋವೇನಿಯಾ',
 			'SJ' => 'ಸ್ವಾಲ್ಬಾರ್ಡ್ ಮತ್ತು ಜಾನ್ ಮೆಯನ್',
 			'SK' => 'ಸ್ಲೋವೇಕಿಯಾ',
 			'SL' => 'ಸಿಯೆರ್ರಾ ಲಿಯೋನ್',
 			'SM' => 'ಸ್ಯಾನ್ ಮೆರಿನೋ',
 			'SN' => 'ಸೆನೆಗಲ್',
 			'SO' => 'ಸೊಮಾಲಿಯಾ',
 			'SR' => 'ಸುರಿನಾಮ',
 			'SS' => 'ದಕ್ಷಿಣ ಸೂಡಾನ್',
 			'ST' => 'ಸಾವೋ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪಿ',
 			'SV' => 'ಎಲ್ ಸಾಲ್ವೇಡಾರ್',
 			'SX' => 'ಸಿಂಟ್ ಮಾರ್ಟೆನ್',
 			'SY' => 'ಸಿರಿಯಾ',
 			'SZ' => 'ಸ್ವಾಜಿಲ್ಯಾಂಡ್',
 			'TA' => 'ಟ್ರಿಸ್ತನ್ ಡಾ ಕುನ್ಹಾ',
 			'TC' => 'ಟರ್ಕ್ಸ್ ಮತ್ತು ಕೈಕೋಸ್ ದ್ವೀಪಗಳು',
 			'TD' => 'ಚಾದ್',
 			'TF' => 'ಫ್ರೆಂಚ್ ದಕ್ಷಿಣ ಪ್ರದೇಶಗಳು',
 			'TG' => 'ಟೋಗೋ',
 			'TH' => 'ಥೈಲ್ಯಾಂಡ್',
 			'TJ' => 'ತಜಾಕಿಸ್ಥಾನ್',
 			'TK' => 'ಟೊಕೆಲಾವ್',
 			'TL' => 'ಪೂರ್ವ ತಿಮೋರ್',
 			'TL@alt=variant' => 'ಈಸ್ಟ್ ಟಿಮೋರ್',
 			'TM' => 'ತುರ್ಕ್ಮೇನಿಸ್ಥಾನ್',
 			'TN' => 'ಟುನಿಶಿಯಾ',
 			'TO' => 'ಟೊಂಗ',
 			'TR' => 'ಟರ್ಕಿ',
 			'TT' => 'ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ',
 			'TV' => 'ಟುವಾಲು',
 			'TW' => 'ಥೈವಾನ್',
 			'TZ' => 'ತಾಂಜೇನಿಯಾ',
 			'UA' => 'ಉಕ್ರೈನ್',
 			'UG' => 'ಉಗಾಂಡಾ',
 			'UM' => 'ಯುಎಸ್‌. ಔಟ್‌ಲೇಯಿಂಗ್ ದ್ವೀಪಗಳು',
 			'US' => 'ಅಮೇರಿಕಾ ಸಂಯುಕ್ತ ಸಂಸ್ಥಾನ',
 			'US@alt=short' => 'ಯು.ಎಸ್',
 			'UY' => 'ಉರುಗ್ವೇ',
 			'UZ' => 'ಉಜ್ಬೇಕಿಸ್ಥಾನ್',
 			'VA' => 'ವ್ಯಾಟಿಕನ್',
 			'VC' => 'ಸೇಂಟ್. ವಿನ್ಸೆಂಟ್ ಮತ್ತು ಗ್ರೆನೆಡೈನ್ಸ್',
 			'VE' => 'ವೆನೆಜುವೆಲಾ',
 			'VG' => 'ಬ್ರಿಟಿಷ್ ವರ್ಜಿನ್ ದ್ವೀಪಗಳು',
 			'VI' => 'ಯು.ಎಸ್. ವರ್ಜಿನ್ ದ್ವೀಪಗಳು',
 			'VN' => 'ವಿಯೇಟ್ನಾಮ್',
 			'VU' => 'ವನೌಟು',
 			'WF' => 'ವಾಲಿಸ್ ಮತ್ತು ಫುಟುನಾ',
 			'WS' => 'ಸಮೋವಾ',
 			'XK' => 'ಕೊಸೊವೊ',
 			'YE' => 'ಯೆಮನ್',
 			'YT' => 'ಮಯೊಟ್ಟೆ',
 			'ZA' => 'ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ',
 			'ZM' => 'ಝಾಂಬಿಯಾ',
 			'ZW' => 'ಜಿಂಬಾಬ್ವೆ',
 			'ZZ' => 'ಅಜ್ಞಾತ ಪ್ರದೇಶ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'ಪಿನ್‌ಯಿನ್ ರೋಮನೈಸೇಶನ್',
 			'WADEGILE' => 'ವೇಡ್-ಗೈಲ್ಸ್ ರೋಮನೈಸೇಶನ್',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ಕ್ಯಾಲೆಂಡರ್',
 			'colalternate' => 'ಸಂಕೇತಗಳ ವಿಂಗಡಣೆಯನ್ನು ಕಡೆಗಣಿಸಿ',
 			'colbackwards' => 'ತಿರುಗು ಮುರುಗಾದ ಉಚ್ಛಾರಣೆಯ ವಿಂಗಡಣೆ',
 			'colcasefirst' => 'ದೊಡ್ಡಕ್ಷರ/ಸಣ್ಣಕ್ಷರ ಕ್ರಮಗೊಳಿಸುವಿಕೆ',
 			'colcaselevel' => 'ಕೇಸ್-ಸೆನ್ಸಿಟೀವ್ ವಿಂಗಡಣೆ',
 			'colhiraganaquaternary' => 'ಕನಾ ವಿಂಗಡಣೆ',
 			'collation' => 'ವಿಂಗಡಣೆ ಕ್ರಮ',
 			'colnormalization' => 'ಸಾಮಾನ್ಯ ವಿಂಗಡಣೆ',
 			'colnumeric' => 'ಸಂಖ್ಯೆ ವಿಂಗಡಣೆ',
 			'colstrength' => 'ವಿಂಗಡಣೆ ಸಾಮರ್ಥ್ಯ',
 			'currency' => 'ಕರೆನ್ಸಿ',
 			'hc' => 'ಗಂಟೆ ಚಕ್ರ (12 ವಿರುದ್ಧ 24)',
 			'lb' => 'ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ',
 			'ms' => 'ಮಾಪನ ವ್ಯವಸ್ಥೆ',
 			'numbers' => 'ಸಂಖ್ಯೆಗಳು',
 			'timezone' => 'ಸಮಯ ವಲಯ',
 			'va' => 'ಸ್ಥಳೀಯ ಭಿನ್ನತೆ',
 			'variabletop' => 'ಚಿಹ್ನೆಗಳ ಪ್ರಕಾರವಾಗಿ ವಿಂಗಡಿಸಿ',
 			'x' => 'ಖಾಸಗಿ ಬಳಕೆ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ಬೌದ್ಧರ ಕ್ಯಾಲೆಂಡರ್},
 				'chinese' => q{ಚೈನೀಸ್ ಕ್ಯಾಲೆಂಡರ್},
 				'coptic' => q{ಕೋಪ್ಟಿಕ್ ಕ್ಯಾಲೆಂಡರ್},
 				'dangi' => q{ಡಾಂಗಿ ಕ್ಯಾಲೆಂಡರ್},
 				'ethiopic' => q{ಇಥಿಯೋಪಿಕ್ ಕ್ಯಾಲೆಂಡರ್},
 				'ethiopic-amete-alem' => q{ಇಥಿಯೋಪಿಕ್ ಅಮೆಟೆ ಅಲೆಮ್ ಕ್ಯಾಲೆಂಡರ್},
 				'gregorian' => q{ಗ್ರೆಗೋರಿಯನ್ ಕ್ಯಾಲೆಂಡರ್},
 				'hebrew' => q{ಹೀಬ್ರೂ ಕ್ಯಾಲೆಂಡರ್},
 				'indian' => q{ಭಾರತೀಯ ರಾಷ್ಟ್ರೀಯ ಕ್ಯಾಲೆಂಡರ್},
 				'islamic' => q{ಇಸ್ಲಾಮಿಕ್ ಕ್ಯಾಲೆಂಡರ್},
 				'islamic-civil' => q{ಇಸ್ಲಾಮಿಕ್-ಸಿವಿಲ್ ಕ್ಯಾಲೆಂಡರ್},
 				'iso8601' => q{ISO-8601 ಕ್ಯಾಲೆಂಡರ್},
 				'japanese' => q{ಜಪಾನೀಸ್ ಕ್ಯಾಲೆಂಡರ್},
 				'persian' => q{ಪರ್ಷಿಯನ್ ಕ್ಯಾಲೆಂಡರ್},
 				'roc' => q{ಮಿಂಗೋ ಕ್ಯಾಲೆಂಡರ್},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{ಚಿಹ್ನೆಗಳನ್ನು ವಿಂಗಡಿಸಿ},
 				'shifted' => q{ನಿರ್ಲಕ್ಷಿಸಿದ ಚಿಹ್ನೆಗಳನ್ನು ವಿಂಗಡಿಸಿ},
 			},
 			'colbackwards' => {
 				'no' => q{ಉಚ್ಛಾರಣೆಯನ್ನು ಸಾಮಾನ್ಯವಾಗಿ ವಿಂಗಡಿಸಿ},
 				'yes' => q{ತಿರುಗು ಮುರುಗಾದ ಉಚ್ಛಾರಣೆಗಳನ್ನು ವಿಂಗಡಿಸಿ},
 			},
 			'colcasefirst' => {
 				'lower' => q{ಮೊದಲು ಲೋವರ್‌ಕೇಸ್ ಅನ್ನು ವಿಂಗಡಿಸಿ},
 				'no' => q{ಸಾಮಾನ್ಯ ಕೇಸ್ ಕ್ರಮವನ್ನು ವಿಂಗಡಿಸಿ},
 				'upper' => q{ಮೊದಲು ಅಪ್ಪರ್‌ಕೇಸ್ ಅನ್ನು ವಿಂಗಡಿಸಿ},
 			},
 			'colcaselevel' => {
 				'no' => q{ಕೇಸ್ ಇನ್‌ಸೆಂಟೀವ್ ಅನ್ನು ವಿಂಗಡಿಸಿ},
 				'yes' => q{ಕೇಸ್‌ ಸೆನ್ಸಿಟೀವ್‌‌ ವಿಂಗಡಿಸಿ},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{ಕಾನಾ ಅನ್ನು ಬೇರೆಯಾಗಿ ವಿಂಗಡಿಸಿ},
 				'yes' => q{ಕಾನಾ ಅನ್ನು ಬೇರೆಯಾಗಿ ವಿಂಗಡಿಸಿ},
 			},
 			'collation' => {
 				'big5han' => q{ಸಾಂಪ್ರದಾಯಿಕ ಚೀನಾದ ಅನುಕ್ರಮ ವಿನ್ಯಾಸ - ದೊಡ್ಡ ಐದು},
 				'dictionary' => q{ಡಿಕ್ಷನರಿ ಅನುಕ್ರಮ ವಿನ್ಯಾಸ},
 				'ducet' => q{ಡೀಫಾಲ್ಟ್ ಯೂನಿಕೋಡ್ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'gb2312han' => q{ಸರಳೀಕೃತ ಚೈನೀಸ್ ವಿಂಗಡಣೆ ಕ್ರಮ - GB2312},
 				'phonebook' => q{ಫೋನ್‌ಬುಕ್ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'phonetic' => q{ಉಚ್ಛಾರಣಾನುರೂಪವಾಗಿ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'pinyin' => q{ಪಿನ್‌ಯಿನ್ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'reformed' => q{ಪರಿಷ್ಕೃತ ಅನುಕ್ರಮ ವಿನ್ಯಾಸ},
 				'search' => q{ಸಾಮಾನ್ಯ- ಉದ್ದೇಶ ಹುಡುಕಾಟ},
 				'searchjl' => q{ಹಂಗುಲ್ ಆದ್ಯಕ್ಷರ ವ್ಯಂಜನದ ಮೂಲಕ ಹುಡುಕಿ},
 				'standard' => q{ಪ್ರಮಾಣೀಕೃತ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'stroke' => q{ಸ್ಟ್ರೋಕ್ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'traditional' => q{ಸಾಂಪ್ರದಾಯಿಕ ವಿಂಗಡಣೆ ಕ್ರಮ},
 				'unihan' => q{ರ್ಯಾಡಿಕಲ್-ಸ್ಟ್ರೋಕ್ ವಿಂಗಡಣೆ ಕ್ರಮ},
 			},
 			'colnormalization' => {
 				'no' => q{ಸಾಮಾನ್ಯ ಸ್ಥಿತಿಯನ್ನು ಹೊರತುಪಡಿಸಿ ವಿಂಗಡಿಸಿ},
 				'yes' => q{ಸಾಮಾನ್ಯವಾದ ಯೂನಿಕೋಡ್ ಅನ್ನು ವಿಂಗಡಿಸಿ},
 			},
 			'colnumeric' => {
 				'no' => q{ಅಂಕೆಗಳನ್ನು ಪ್ರತ್ಯೇಕವಾಗಿ ವಿಂಗಡಿಸಿ},
 				'yes' => q{ಅಂಕೆಗಳನ್ನು ಸಂಖ್ಯಾತ್ಮಕವಾಗಿ ವಿಂಗಡಿಸಿ},
 			},
 			'colstrength' => {
 				'identical' => q{ಎಲ್ಲವನ್ನೂ ವಿಂಗಡಿಸಿ},
 				'primary' => q{ವಿಂಗಡಣೆ ಆಧರಿಸಿದ ಅಕ್ಷರಗಳನ್ನು ಮಾತ್ರ},
 				'quaternary' => q{ಉಚ್ಛಾರಣೆ/ಕೇಸ್/ಅಳತೆ/ಕಾನಾ ವಿಂಗಡಿಸಿ},
 				'secondary' => q{ಉಚ್ಛಾರಣೆಗಳನ್ನು ವಿಂಗಡಿಸಿ},
 				'tertiary' => q{ಉಚ್ಛಾರಣೆ/ಕೇಸ್/ಅಳತೆ ವಿಂಗಡಿಸಿ},
 			},
 			'hc' => {
 				'h11' => q{12 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (0–11)},
 				'h12' => q{24 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (0–23)},
 				'h23' => q{24 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (0–23)},
 				'h24' => q{24 ಗಂಟೆ ವ್ಯವಸ್ಥೆ (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ಲೂಸ್ ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ},
 				'normal' => q{ಸಾಮಾನ್ಯ ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ},
 				'strict' => q{ಕಡ್ಡಾಯ ಲೈನ್ ಬ್ರೇಕ್ ಶೈಲಿ},
 			},
 			'ms' => {
 				'metric' => q{ಮೆಟ್ರಿಕ್ ವ್ಯವಸ್ಥೆ},
 				'uksystem' => q{ಇಂಪಿರಿಯಲ್ ಮಾಪನ ವ್ಯವಸ್ಥೆ},
 				'ussystem' => q{ಯುಎಸ್ ಮಾಪನ ವ್ಯವಸ್ಥೆ},
 			},
 			'numbers' => {
 				'arab' => q{ಅರೇಬಿಕ್-ಇಂಡಿಕ್ ಅಂಕೆಗಳು},
 				'arabext' => q{ವಿಸ್ತರಿಸಲಾದ ಅರೇಬಿಕ್-ಇಂಡಿಕ್ ಅಂಕೆಗಳು},
 				'armn' => q{ಆರ್ಮೇನಿಯಾದ ಸಂಖ್ಯೆಗಳು},
 				'armnlow' => q{ಅರ್ಮೇನಿಯಾದ ಸಣ್ಣಕ್ಷರ ಸಂಖ್ಯೆಗಳು},
 				'beng' => q{ಬಂಗಾಳಿ ಅಂಕೆಗಳು},
 				'deva' => q{ದೇವನಾಗರಿ ಅಂಕೆಗಳು},
 				'ethi' => q{ಇಥಿಯೋಪಿಯಾದ ಸಂಖ್ಯೆಗಳು},
 				'finance' => q{ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು},
 				'fullwide' => q{ಪೂರ್ಣ ಅಗಲವಾದ ಸಂಖ್ಯೆಗಳು},
 				'geor' => q{ಜಾರ್ಜಿಯಾದ ಸಂಖ್ಯೆಗಳು},
 				'grek' => q{ಗ್ರೀಕ್ ಸಂಖ್ಯೆಗಳು},
 				'greklow' => q{ಗ್ರೀಕ್ ಲೋವರ್‌ಕೇಸ್ ಸಂಖ್ಯೆಗಳು},
 				'gujr' => q{ಗುಜರಾತಿ ಅಂಕೆಗಳು},
 				'guru' => q{ಗುರ್ಮುಖಿ ಅಂಕೆಗಳು},
 				'hanidec' => q{ಚೀನಾದ ದಶಮಾಂಶ ಸಂಖ್ಯೆಗಳು},
 				'hans' => q{ಸರಳೀಕೃತ ಚೀನಾದ ಸಂಖ್ಯೆಗಳು},
 				'hansfin' => q{ಸರಳೀಕೃತ ಚೀನಾದ ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು},
 				'hant' => q{ಸಾಂಪ್ರದಾಯಿಕ ಚೀನಾ ಸಂಖ್ಯೆಗಳು},
 				'hantfin' => q{ಸಾಂಪ್ರದಾಯಿಕ ಚೀನಾದ ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು},
 				'hebr' => q{ಹೀಬ್ರೂ ಸಂಖ್ಯೆಗಳು},
 				'jpan' => q{ಜಪಾನೀ ಸಂಖ್ಯೆಗಳು},
 				'jpanfin' => q{ಜಪಾನೀ ಆರ್ಥಿಕ ಸಂಖ್ಯೆಗಳು},
 				'khmr' => q{ಖಮೆ ಅಂಕೆಗಳು},
 				'knda' => q{ಕನ್ನಡ ಅಂಕೆಗಳು},
 				'laoo' => q{ಲಾವೋ ಅಂಕೆಗಳು},
 				'latn' => q{ಪಾಶ್ಚಿಮಾತ್ಯ ಅಂಕೆಗಳು},
 				'mlym' => q{ಮಲಯಾಳಂನ ಅಂಕೆಗಳು},
 				'mong' => q{ಮಂಗೋಲಿಯಾದ ಅಂಕೆಗಳು},
 				'mymr' => q{ಮ್ಯಾನ್ಮಾರ್ ಅಂಕೆಗಳು},
 				'native' => q{ಸ್ಥಳೀಯ ಅಂಕೆಗಳು},
 				'orya' => q{ಒರಿಯಾ ಅಂಕೆಗಳು},
 				'roman' => q{ರೋಮನ್ ಸಂಖ್ಯೆಗಳು},
 				'romanlow' => q{ರೋಮನ್ ಲೋವರ್‌ಕೇಸ್ ಸಂಖ್ಯೆಗಳು},
 				'taml' => q{ಸಾಂಪ್ರದಾಯಿಕ ತಮಿಳು ಸಂಖ್ಯೆಗಳು},
 				'tamldec' => q{ತಮಿಳು ಅಂಕೆಗಳು},
 				'telu' => q{ತೆಲುಗು ಅಂಕೆಗಳು},
 				'thai' => q{ಥಾಯ್ ಅಂಕೆಗಳು},
 				'tibt' => q{ಟಿಬೇಟಿಯನ್ ಅಂಕೆಗಳು},
 				'traditional' => q{ಸಾಂಪ್ರದಾಯಿಕ ಸಂಖ್ಯೆಗಳು},
 				'vaii' => q{ವಾಯ್ ಅಂಕೆಗಳು},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ಮೆಟ್ರಿಕ್},
 			'UK' => q{ಯುಕೆ},
 			'US' => q{ಯುಎಸ್},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'ಸಂಖ್ಯೆ',
 			'tone' => 'ಧ್ವನಿ',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'ಉಚ್ಚಾರಣೆಗಳು',
 			'x-fullwidth' => 'ಪೂರ್ಣಅಗಲ',
 			'x-halfwidth' => 'ಅರೆಅಗಲ',
 			'x-jamo' => 'ಹಮೋ',
 			'x-pinyin' => 'ಪಿನ್‌ಯಿನ್‌',
 			'x-publishing' => 'ಪ್ರಕಟಣೆ',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ಭಾಷೆ: {0}',
 			'script' => 'ಲಿಪಿ : {0}',
 			'region' => 'ಪ್ರದೇಶ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍ ೞ])},
			index => ['ಅ', 'ಆ', 'ಇ', 'ಈ', 'ಉ', 'ಊ', 'ಋ', 'ೠ', 'ಌ', 'ೡ', 'ಎ', 'ಏ', 'ಐ', 'ಒ', 'ಓ', 'ಔ', 'ಕ', 'ಖ', 'ಗ', 'ಘ', 'ಙ', 'ಚ', 'ಛ', 'ಜ', 'ಝ', 'ಞ', 'ಟ', 'ಠ', 'ಡ', 'ಢ', 'ಣ', 'ತ', 'ಥ', 'ದ', 'ಧ', 'ನ', 'ಪ', 'ಫ', 'ಬ', 'ಭ', 'ಮ', 'ಯ', 'ರ', 'ಱ', 'ಲ', 'ವ', 'ಶ', 'ಷ', 'ಸ', 'ಹ', 'ಳ', 'ೞ'],
			main => qr{(?^u:[಼ ೦ ೧ ೨ ೩ ೪ ೫ ೬ ೭ ೮ ೯ ಅ ಆ ಇ ಈ ಉ ಊ ಋ ೠ ಌ ೡ ಎ ಏ ಐ ಒ ಓ ಔ ಂ ಃ ಕ ಖ ಗ ಘ ಙ ಚ ಛ ಜ ಝ ಞ ಟ ಠ ಡ ಢ ಣ ತ ಥ ದ ಧ ನ ಪ ಫ ಬ ಭ ಮ ಯ ರ ಱ ಲ ವ ಶ ಷ ಸ ಹ ಳ ಽ ಾ ಿ ೀ ು ೂ ೃ ೄ ೆ ೇ ೈ ೊ ೋ ೌ ್ ೕ ೖ])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] @ * / \& # ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['ಅ', 'ಆ', 'ಇ', 'ಈ', 'ಉ', 'ಊ', 'ಋ', 'ೠ', 'ಌ', 'ೡ', 'ಎ', 'ಏ', 'ಐ', 'ಒ', 'ಓ', 'ಔ', 'ಕ', 'ಖ', 'ಗ', 'ಘ', 'ಙ', 'ಚ', 'ಛ', 'ಜ', 'ಝ', 'ಞ', 'ಟ', 'ಠ', 'ಡ', 'ಢ', 'ಣ', 'ತ', 'ಥ', 'ದ', 'ಧ', 'ನ', 'ಪ', 'ಫ', 'ಬ', 'ಭ', 'ಮ', 'ಯ', 'ರ', 'ಱ', 'ಲ', 'ವ', 'ಶ', 'ಷ', 'ಸ', 'ಹ', 'ಳ', 'ೞ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(ಎಕರೆಗಳು),
						'one' => q({0} ಎಕರೆ),
						'other' => q({0} ಎಕರೆಗಳು),
					},
					'acre-foot' => {
						'name' => q(ಎಕರೆ-ಅಡಿ),
						'one' => q({0} ಎಕರೆ-ಅಡಿ),
						'other' => q({0} ಎಕರೆ-ಅಡಿ),
					},
					'ampere' => {
						'name' => q(ಆಂಪೇರ್‌ಗಳು),
						'one' => q({0} ಆಂಪೇರ್‌),
						'other' => q({0} ಆಂಪೇರ್‌ಗಳು),
					},
					'arc-minute' => {
						'name' => q(ನಿಮಿಷಗಳು),
						'one' => q({0} ನಿಮಿಷ),
						'other' => q({0} ನಿಮಿಷಗಳು),
					},
					'arc-second' => {
						'name' => q(ಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ಸೆಕೆಂಡ್),
						'other' => q({0} ಸೆಕೆಂಡುಗಳು),
					},
					'astronomical-unit' => {
						'name' => q(ಅಸ್ಟ್ರಾನಾಮಿಕಲ್ ಯೂನಿಟ್‌ಗಳು),
						'one' => q({0} ಅಸ್ಟ್ರಾನಾಮಿಕಲ್ ಯೂನಿಟ್),
						'other' => q({0} ಅಸ್ಟ್ರಾನಾಮಿಕಲ್ ಯೂನಿಟ್‌ಗಳು),
					},
					'bit' => {
						'name' => q(ಬಿಟ್‌ಗಳು),
						'one' => q({0} ಬಿಟ್‌),
						'other' => q({0} ಬಿಟ್‍ಗಳು),
					},
					'byte' => {
						'name' => q(ಬೈಟ್‌ಗಳು),
						'one' => q({0} ಬೈಟ್‌),
						'other' => q({0} ಬೈಟ್‌ಗಳು),
					},
					'calorie' => {
						'name' => q(ಕ್ಯಾಲೋರಿಗಳು),
						'one' => q({0} ಕ್ಯಾಲೋರಿ),
						'other' => q({0} ಕ್ಯಾಲೋರಿಗಳು),
					},
					'carat' => {
						'name' => q(ಕ್ಯಾರೆಟ್‌ಗಳು),
						'one' => q({0} ಕ್ಯಾರೆಟ್‌),
						'other' => q({0} ಕ್ಯಾರೆಟ್‌ಗಳು),
					},
					'celsius' => {
						'name' => q(ಡಿಗ್ರಿ ಸೆಲ್ಶಿಯಸ್),
						'one' => q({0} ಡಿಗ್ರಿ ಸೆಲ್ಶಿಯಸ್),
						'other' => q({0} ಡಿಗ್ರಿ ಸೆಲ್ಶಿಯಸ್),
					},
					'centiliter' => {
						'name' => q(ಸೆಂಟಿಲೀಟರ್‌ಗಳು),
						'one' => q({0} ಸೆಂಟಿಲೀಟರ್),
						'other' => q({0} ಸೆಂಟಿಲೀಟರ್‌ಗಳು),
					},
					'centimeter' => {
						'name' => q(ಸೆಂಟಿಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಸೆಂಟಿಮೀಟರ್),
						'other' => q({0} ಸೆಂಟಿಮೀಟರ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಸೆಂಟಿಮೀಟರ್‌ಗೆ),
					},
					'century' => {
						'name' => q(ಶತಮಾನಗಳು),
						'one' => q({0} ಶತಮಾನ),
						'other' => q({0}ಶತಮಾನಗಳು),
					},
					'coordinate' => {
						'east' => q({0}ಪೂ),
						'north' => q({0}ಉ),
						'south' => q({0}ದ),
						'west' => q({0}ಪ),
					},
					'cubic-centimeter' => {
						'name' => q(ಕ್ಯೂಬಿಕ್ ಸೆಂಟಿಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಕ್ಯೂಬಿಕ್ ಸೆಂಟಿಮೀಟರ್),
						'other' => q({0} ಕ್ಯೂಬಿಕ್ ಸೆಂಟಿಮೀಟರ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಕ್ಯೂಬಿಕ್ ಸೆಂಟಿಮೀಟರ್‌ಗಳಿಗೆ),
					},
					'cubic-foot' => {
						'name' => q(ಘನ ಅಡಿ),
						'one' => q({0} ಘನ ಅಡಿ),
						'other' => q({0} ಘನ ಅಡಿ),
					},
					'cubic-inch' => {
						'name' => q(ಘನ ಅಂಗುಲಗಳು),
						'one' => q({0} ಘನ ಅಂಗುಲ),
						'other' => q({0} ಘನ ಅಂಗುಲಗಳು),
					},
					'cubic-kilometer' => {
						'name' => q(ಘನ ಕಿಲೋಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಘನ ಕಿಲೋಮೀಟರ್),
						'other' => q({0} ಘನ ಕಿಲೋಮೀಟರ್‌ಗಳು),
					},
					'cubic-meter' => {
						'name' => q(ಘನ ಮೀಟರುಗಳು),
						'one' => q({0} ಘನ ಮೀಟರ್),
						'other' => q({0} ಘನ ಮೀಟರುಗಳು),
						'per' => q({0} ಪ್ರತಿ ಘನ ಮೀಟರುಗಳಿಗೆ),
					},
					'cubic-mile' => {
						'name' => q(ಘನ ಮೈಲುಗಳು),
						'one' => q({0} ಘನ ಮೈಲು),
						'other' => q({0} ಘನ ಮೈಲುಗಳು),
					},
					'cubic-yard' => {
						'name' => q(ಘನ ಗಜಗಳು),
						'one' => q({0} ಘನ ಗಜ),
						'other' => q({0} ಘನ ಗಜಗಳು),
					},
					'cup' => {
						'name' => q(ಕಪ್‍ಗಳು),
						'one' => q({0} ಕಪ್‍),
						'other' => q({0} ಕಪ್‍ಗಳು),
					},
					'cup-metric' => {
						'name' => q(ಮೆಟ್ರಿಕ್‌ ಕಪ್‌),
						'one' => q({0} ಮೆಟ್ರಿಕ್‌ ಕಪ್‌),
						'other' => q({0} ಮೆಟ್ರಿಕ್‌ ಕಪ್‌ಗಳು),
					},
					'day' => {
						'name' => q(ದಿನಗಳು),
						'one' => q({0} ದಿನ),
						'other' => q({0} ದಿನಗಳು),
						'per' => q({0} ಪ್ರತಿ ದಿನಕ್ಕೆ),
					},
					'deciliter' => {
						'name' => q(ಡೆಸಿಲೀಟರ್‌ಗಳು),
						'one' => q({0} ಡೆಸಿಲೀಟರ್‌),
						'other' => q({0} ಡೆಸಿಲೀಟರ್‌‌ಗಳು),
					},
					'decimeter' => {
						'name' => q(ಡೆಸಿಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಡೆಸಿಮೀಟರ್),
						'other' => q({0} ಡೆಸಿಮೀಟರ್‌ಗಳು),
					},
					'degree' => {
						'name' => q(ಡಿಗ್ರಿಗಳು),
						'one' => q({0}ಡಿಗ್ರಿ),
						'other' => q({0}ಡಿಗ್ರಿಗಳು),
					},
					'fahrenheit' => {
						'name' => q(ಡಿಗ್ರಿ ಫ್ಯಾರೆನ್‌ಹಿಟ್),
						'one' => q({0}ಡಿಗ್ರಿ ಫ್ಯಾರೆನ್‌ಹಿಟ್),
						'other' => q({0}ಡಿಗ್ರಿ ಫ್ಯಾರೆನ್‌ಹಿಟ್),
					},
					'fluid-ounce' => {
						'name' => q(ಫ್ಲೂಡ್ ಔನ್ಸ್‌ಗಳು),
						'one' => q({0} ಫ್ಲೂಡ್ ಔನ್ಸ್‌),
						'other' => q({0} ಫ್ಲೂಡ್ ಔನ್ಸ್‌ಗಳು),
					},
					'foodcalorie' => {
						'name' => q(ಕ್ಯಾಲೋರಿಗಳು),
						'one' => q({0} ಕ್ಯಾಲೋರಿ),
						'other' => q({0} ಕ್ಯಾಲೋರಿಗಳು),
					},
					'foot' => {
						'name' => q(ಅಡಿ),
						'one' => q({0} ಅಡಿ),
						'other' => q({0} ಅಡಿ),
						'per' => q({0} ಪ್ರತಿ ಅಡಿಗೆ),
					},
					'g-force' => {
						'name' => q(ಜಿ-ಫೋರ್ಸ್),
						'one' => q({0} ಜಿ-ಫೋರ್ಸ್),
						'other' => q({0} ಜಿ-ಫೋರ್ಸ್),
					},
					'gallon' => {
						'name' => q(ಗ್ಯಾಲನ್‌‌ಗಳು),
						'one' => q({0} ಗ್ಯಾಲನ್‌),
						'other' => q({0} ಗ್ಯಾಲನ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಗ್ಯಾಲನ್‍ಗೆ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ಗಿಗಾಬಿಟ್‌ಗಳು),
						'one' => q({0} ಗಿಗಾಬಿಟ್‌),
						'other' => q({0} ಗಿಗಾಬಿಟ್‌ಗಳು),
					},
					'gigabyte' => {
						'name' => q(ಗಿಗಾಬೈಟ್‌ಗಳು),
						'one' => q({0} ಗಿಗಾಬೈಟ್‌),
						'other' => q({0} ಗಿಗಾಬೈಟ್‌ಗಳು),
					},
					'gigahertz' => {
						'name' => q(ಗಿಗಾಹರ್ಟ್ಸ್‌),
						'one' => q({0} ಗಿಗಾಹರ್ಟ್ಸ್‌),
						'other' => q({0} ಗಿಗಾಹರ್ಟ್ಸ್‌),
					},
					'gigawatt' => {
						'name' => q(ಗಿಗಾವ್ಯಾಟ್‌ಗಳು),
						'one' => q({0} ಗಿಗಾವ್ಯಾಟ್‌),
						'other' => q({0} ಗಿಗಾವ್ಯಾಟ್‌ಗಳು),
					},
					'gram' => {
						'name' => q(ಗ್ರಾಂಗಳು),
						'one' => q({0} ಗ್ರಾಂ),
						'other' => q({0} ಗ್ರಾಂಗಳು),
						'per' => q({0} ಪ್ರತಿ ಗ್ರಾಂಗೆ),
					},
					'hectare' => {
						'name' => q(ಹೆಕ್ಟೇರುಗಳು),
						'one' => q({0} ಹೆಕ್ಟೇರ್),
						'other' => q({0} ಹೆಕ್ಟೇರುಗಳು),
					},
					'hectoliter' => {
						'name' => q(ಹೆಕ್ಟೋಲೀಟರ್‌ಗಳು),
						'one' => q({0} ಹೆಕ್ಟೋಲೀಟರ್),
						'other' => q({0} ಹೆಕ್ಟೋಲೀಟರ್‌ಗಳು),
					},
					'hectopascal' => {
						'name' => q(ಹೆಕ್ಟೋಪ್ಯಾಸ್ಕಲ್‌ಗಳು),
						'one' => q({0} ಹೆಕ್ಟೋಪ್ಯಾಸ್ಕಲ್),
						'other' => q({0} ಹೆಕ್ಟೋಪ್ಯಾಸ್ಕಲ್‌ಗಳು),
					},
					'hertz' => {
						'name' => q(ಹರ್ಟ್ಸ್‌),
						'one' => q({0} ಹರ್ಟ್ಸ್‌),
						'other' => q({0} ಹರ್ಟ್ಸ್‌),
					},
					'horsepower' => {
						'name' => q(ಹಾರ್ಸ್‌ಪವರ್),
						'one' => q({0} ಹಾರ್ಸ್‌ಪವರ್),
						'other' => q({0} ಹಾರ್ಸ್‌ಪವರ್),
					},
					'hour' => {
						'name' => q(ಗಂಟೆಗಳು),
						'one' => q({0} ಗಂಟೆ),
						'other' => q({0} ಗಂಟೆಗಳು),
						'per' => q({0} ಪ್ರತಿ ಗಂಟೆ),
					},
					'inch' => {
						'name' => q(ಅಂಗುಲಗಳು),
						'one' => q({0} ಅಂಗುಲ),
						'other' => q({0} ಅಂಗುಲಗಳು),
						'per' => q({0} ಪ್ರತಿ ಅಂಗುಲಕ್ಕೆ),
					},
					'inch-hg' => {
						'name' => q(ಮರ್ಕ್ಯುರಿ ಅಂಗುಲಗಳು),
						'one' => q({0} ಮರ್ಕ್ಯುರಿ ಅಂಗುಲ),
						'other' => q({0} ಮರ್ಕ್ಯುರಿ ಅಂಗುಲಗಳು),
					},
					'joule' => {
						'name' => q(ಜೌಲ್‌ಗಳು),
						'one' => q({0} ಜೌಲ್‌),
						'other' => q({0} ಜೌಲ್‌ಗಳು),
					},
					'karat' => {
						'name' => q(ಕಾರಟ್‌ಗಳು),
						'one' => q({0} ಕಾರಟ್‌),
						'other' => q({0} ಕಾರಟ್‌ಗಳು),
					},
					'kelvin' => {
						'name' => q(ಕೆಲ್ವಿನ್‌ಗಳು),
						'one' => q({0} ಕೆಲ್ವಿನ್),
						'other' => q({0} ಕೆಲ್ವಿನ್‍ಗಳು),
					},
					'kilobit' => {
						'name' => q(ಕಿಲೋಬಿಟ್‌ಗಳು),
						'one' => q({0} ಕಿಲೋಬಿಟ್‌),
						'other' => q({0} ಕಿಲೋಬಿಟ್‌ಗಳು),
					},
					'kilobyte' => {
						'name' => q(ಕಿಲೋಬೈಟ್‌ಗಳು),
						'one' => q({0} ಕಿಲೋಬೈಟ್‌),
						'other' => q({0} ಕಿಲೋಬೈಟ್‌ಗಳು),
					},
					'kilocalorie' => {
						'name' => q(ಕಿಲೋಕ್ಯಾಲೋರಿಗಳು),
						'one' => q({0} ಕಿಲೋಕ್ಯಾಲೋರಿ),
						'other' => q({0} ಕಿಲೋಕ್ಯಾಲೋರಿಗಳು),
					},
					'kilogram' => {
						'name' => q(ಕಿಲೋಗ್ರಾಂಗಳು),
						'one' => q({0} ಕಿಲೋಗ್ರಾಂ),
						'other' => q({0} ಕಿಲೋಗ್ರಾಂಗಳು),
						'per' => q({0} ಪ್ರತಿ ಕಿಲೋಗ್ರಾಂಗೆ),
					},
					'kilohertz' => {
						'name' => q(ಕಿಲೋಹರ್ಟ್ಸ್‌),
						'one' => q({0} ಕಿಲೋಹರ್ಟ್ಸ್‌),
						'other' => q({0} ಕಿಲೋಹರ್ಟ್ಸ್‌),
					},
					'kilojoule' => {
						'name' => q(ಕಿಲೋಜೌಲ್‌‌ಗಳು),
						'one' => q({0} ಕಿಲೋಜೌಲ್‌),
						'other' => q({0} ಕಿಲೋಜೌಲ್‌ಗಳು),
					},
					'kilometer' => {
						'name' => q(ಕಿಲೋಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಕಿಲೋಮೀಟರ್),
						'other' => q({0} ಕಿಲೋಮೀಟರ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಕಿಲೋಮೀಟ‍ರ್‌ಗೆ),
					},
					'kilometer-per-hour' => {
						'name' => q(ಗಂಟೆಗೆ ಕಿಲೋಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಕಿಲೋಮಿಟರ್ ಪ್ರತಿ ಗಂಟೆಗೆ),
						'other' => q({0} ಕಿಲೋಮಿಟರ್‌ಗಳು ಪ್ರತಿ ಗಂಟೆಗೆ),
					},
					'kilowatt' => {
						'name' => q(ಕಿಲೋವ್ಯಾಟ್‌ಗಳು),
						'one' => q({0} ಕಿಲೋವ್ಯಾಟ್),
						'other' => q({0} ಕಿಲೋವ್ಯಾಟ್‌ಗಳು),
					},
					'kilowatt-hour' => {
						'name' => q(ಕಿಲೋವ್ಯಾಟ್‌-ಗಂಟೆಗಳು),
						'one' => q({0} ಕಿಲೋವ್ಯಾಟ್‌-ಗಂಟೆ),
						'other' => q({0} ಕಿಲೋವ್ಯಾಟ್‌-ಗಂಟೆಗಳು),
					},
					'knot' => {
						'name' => q(ನಾಟ್),
						'one' => q({0} ನಾಟ್),
						'other' => q({0} ನಾಟ್‌ಗಳು),
					},
					'light-year' => {
						'name' => q(ಬೆಳಕಿನ ವರ್ಷಗಳು),
						'one' => q({0} ಬೆಳಕಿನ ವರ್ಷ),
						'other' => q({0} ಬೆಳಕಿನ ವರ್ಷಗಳು),
					},
					'liter' => {
						'name' => q(ಲೀಟರ್‌‌ಗಳು),
						'one' => q({0} ಲೀಟರ್),
						'other' => q({0} ಲೀಟರ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಲೀಟರ್‌ಗೆ),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} ಲೀಟರ್‌ಗಳು ಪ್ರತಿ 100 ಕಿಲೋಮೀಟರ್‌ಗಳಿಗೆ),
						'other' => q({0} ಲೀಟರ್‌ಗಳು ಪ್ರತಿ 100 ಕಿಲೋಮೀಟರ್‌ಗಳಿಗೆ),
					},
					'liter-per-kilometer' => {
						'name' => q(ಲೀಟರ್ ಪ್ರತಿ ಕಿಲೋಮೀಟರ್‌ಗೆ),
						'one' => q({0} ಲೀಟರ್ ಪ್ರತಿ ಕಿಲೋಮೀಟರ್‌ಗೆ),
						'other' => q({0} ಪ್ರತಿ ಕಿಲೋಮೀಟರ್‌‌ಗೆ ಲೀಟರ್‌ಗಳು),
					},
					'lux' => {
						'name' => q(ಲಕ್ಸ್‌‌),
						'one' => q({0} ಲಕ್ಸ್‌‌),
						'other' => q({0} ಲಕ್ಸ್‌‌),
					},
					'megabit' => {
						'name' => q(ಮೆಗಾಬಿಟ್‌ಗಳು),
						'one' => q({0} ಮೆಗಾಬಿಟ್‌),
						'other' => q({0} ಮೆಗಾಬಿಟ್‌ಗಳು),
					},
					'megabyte' => {
						'name' => q(ಮೆಗಾಬೈಟ್‌ಗಳು),
						'one' => q({0} ಮೆಗಾಬೈಟ್‌),
						'other' => q({0} ಮೆಗಾಬೈಟ್‌ಗಳು),
					},
					'megahertz' => {
						'name' => q(ಮೆಗಾಹರ್ಟ್ಸ್),
						'one' => q({0} ಮೆಗಾಹರ್ಟ್ಸ್),
						'other' => q({0} ಮೆಗಾಹರ್ಟ್ಸ್),
					},
					'megaliter' => {
						'name' => q(ಮೆಗಾ ಲೀಟರ್‌ಗಳು),
						'one' => q({0} ಮೆಗಾ ಲೀಟರ್‌),
						'other' => q({0} ಮೆಗಾ ಲೀಟರ್‌‌ಗಳು),
					},
					'megawatt' => {
						'name' => q(ಮೆಗಾವ್ಯಾಟ್‌ಗಳು),
						'one' => q({0} ಮೆಗಾವ್ಯಾಟ್‌),
						'other' => q({0} ಮೆಗಾವ್ಯಾಟ್‌ಗಳು),
					},
					'meter' => {
						'name' => q(ಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಮೀಟರ್),
						'other' => q({0} ಮೀಟರ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಮೀಟರ್‌ಗೆ),
					},
					'meter-per-second' => {
						'name' => q(ಮೀಟರ್‌ಗಳು ಪ್ರತಿ ಸೆಕೆಂಡ್‌ಗೆ),
						'one' => q({0} ಮೀಟರ್‌ ಪ್ರತಿ ಸೆಕೆಂಡ್‌ಗೆ),
						'other' => q({0} ಮೀಟರ್‌ಗಳು ಪ್ರತಿ ಸೆಕೆಂಡ್‌ಗೆ),
					},
					'meter-per-second-squared' => {
						'name' => q(ಮೀಟರ್‌ಗಳು ಪ್ರತಿ ಸೆಕೆಂಡ್‌ ಸ್ಕ್ವೇರ್‌ಗಳಿಗೆ),
						'one' => q({0} ಮೀಟರ್‌ ಪ್ರತಿ ಸೆಕೆಂಡ್‌ ಸ್ಕ್ವೇರ್‌ಗಳಿಗೆ),
						'other' => q({0} ಮೀಟರ್‌ಗಳು ಪ್ರತಿ ಸೆಕೆಂಡ್‌ ಸ್ಕ್ವೇರ್‌ಗಳಿಗೆ),
					},
					'metric-ton' => {
						'name' => q(ಮೆಟ್ರಿಕ್‌‌ ಟನ್‌ಗಳು),
						'one' => q({0} ಮೆಟ್ರಿಕ್‌ ಟನ್‌),
						'other' => q({0} ಮೆಟ್ರಿಕ್‌‌ ಟನ್‌‌ಗಳು),
					},
					'microgram' => {
						'name' => q(ಮೈಕ್ರೋ ಗ್ರಾಂಗಳು),
						'one' => q({0} ಮೈಕ್ರೋ ಗ್ರಾಂ),
						'other' => q({0} ಮೈಕ್ರೋ ಗ್ರಾಂಗಳು),
					},
					'micrometer' => {
						'name' => q(ಮೈಕ್ರೊಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಮೈಕ್ರೊಮೀಟರ್),
						'other' => q({0} ಮೈಕ್ರೊಮೀಟರ್‌ಗಳು),
					},
					'microsecond' => {
						'name' => q(ಮೈಕ್ರೊಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ಮೈಕ್ರೊಸೆಕೆಂಡ್),
						'other' => q({0} ಮೈಕ್ರೊಸೆಕೆಂಡುಗಳು),
					},
					'mile' => {
						'name' => q(ಮೈಲುಗಳು),
						'one' => q({0} ಮೈಲು),
						'other' => q({0} ಮೈಲುಗಳು),
					},
					'mile-per-gallon' => {
						'name' => q(ಪ್ರತಿ ಗ್ಯಾಲನ್‌‌ಗೆ ಮೈಲಿಗಳು),
						'one' => q({0} ಪ್ರತಿ ಗ್ಯಾಲನ್‌‌ಗೆ ಮೈಲಿ),
						'other' => q({0} ಪ್ರತಿ ಗ್ಯಾಲನ್‌ಗೆ ಮೈಲಿಗಳು),
					},
					'mile-per-hour' => {
						'name' => q(ಮೈಲುಗಳು ಪ್ರತಿ ಗಂಟೆಗೆ),
						'one' => q({0} ಮೈಲು ಪ್ರತಿ ಗಂಟೆಗೆ),
						'other' => q({0} ಗಂಟೆಗೆ ಮೈಲುಗಳು),
					},
					'mile-scandinavian' => {
						'name' => q(ಸ್ಕ್ಯಾಂಡಿನೇವಿಯನ್-ಮೈಲು),
						'one' => q({0} ಸ್ಕ್ಯಾಂಡಿನೇವಿಯನ್-ಮೈಲು),
						'other' => q({0} ಸ್ಕ್ಯಾಂಡಿನೇವಿಯನ್-ಮೈಲುಗಳು),
					},
					'milliampere' => {
						'name' => q(ಮಿಲಿಆಂಪೇರ್‌ಗಳು),
						'one' => q({0} ಮಿಲಿಆಂಪೇರ್‌),
						'other' => q({0} ಮಿಲಿಆಂಪೇರ್‌ಗಳು),
					},
					'millibar' => {
						'name' => q(ಮಿಲಿಬಾರ್‌ಗಳು),
						'one' => q({0} ಮಿಲಿಬಾರ್),
						'other' => q({0} ಮಿಲಿಬಾರ್‌ಗಳು),
					},
					'milligram' => {
						'name' => q(ಮಿಲಿ ಗ್ರಾಂಗಳು),
						'one' => q({0} ಮಿಲಿ ಗ್ರಾಂ),
						'other' => q({0} ಮಿಲಿ ಗ್ರಾಂಗಳು),
					},
					'milliliter' => {
						'name' => q(ಮಿಲಿಲೀಟರ್‌ಗಳು),
						'one' => q({0} ಮಿಲಿಲೀಟರ್),
						'other' => q({0} ಮಿಲಿಲೀಟರ್‌ಗಳು),
					},
					'millimeter' => {
						'name' => q(ಮಿಲಿಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಮಿಲಿಮೀಟರ್),
						'other' => q({0} ಮಿಲಿಮೀಟರ್‌ಗಳು),
					},
					'millimeter-of-mercury' => {
						'name' => q(ಮರ್ಕ್ಯುರಿ ಮಿಲಿಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಮರ್ಕ್ಯುರಿ ಮಿಲಿಮೀಟರ್‌),
						'other' => q({0} ಮರ್ಕ್ಯುರಿ ಮಿಲಿಮೀಟರ್‌ಗಳು),
					},
					'millisecond' => {
						'name' => q(ಮಿಲಿಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ಮಿಲಿಸೆಕೆಂಡ್),
						'other' => q({0} ಮಿಲಿಸೆಕೆಂಡುಗಳು),
					},
					'milliwatt' => {
						'name' => q(ಮಿಲಿವ್ಯಾಟ್‌ಗಳು),
						'one' => q({0} ಮಿಲಿವ್ಯಾಟ್‌),
						'other' => q({0} ಮಿಲಿವ್ಯಾಟ್‌ಗಳು),
					},
					'minute' => {
						'name' => q(ನಿಮಿಷಗಳು),
						'one' => q({0} ನಿಮಿಷ),
						'other' => q({0} ನಿಮಿಷಗಳು),
						'per' => q({0} ಪ್ರತಿ ನಿಮಿಷಕ್ಕೆ),
					},
					'month' => {
						'name' => q(ತಿಂಗಳು),
						'one' => q({0} ತಿಂಗಳು),
						'other' => q({0} ತಿಂಗಳು),
						'per' => q({0} ಪ್ರತಿ ತಿಂಗಳಿಗೆ),
					},
					'nanometer' => {
						'name' => q(ನ್ಯಾನೊಮೀಟರ್‌‌ಗಳು),
						'one' => q({0} ನ್ಯಾನೊಮೀಟರ್‌),
						'other' => q({0} ನ್ಯಾನೊಮೀಟರ್‌‌ಗಳು),
					},
					'nanosecond' => {
						'name' => q(ನ್ಯಾನೊಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ನ್ಯಾನೊಸೆಕೆಂಡ್),
						'other' => q({0} ನ್ಯಾನೊಸೆಕೆಂಡುಗಳು),
					},
					'nautical-mile' => {
						'name' => q(ನಾಟಿಕಲ್ ಮೈಲುಗಳು),
						'one' => q({0} ನಾಟಿಕಲ್ ಮೈಲು),
						'other' => q({0} ನಾಟಿಕಲ್ ಮೈಲುಗಳು),
					},
					'ohm' => {
						'name' => q(ಓಂಗಳು),
						'one' => q({0} ಓಂ),
						'other' => q({0} ಓಂಗಳು),
					},
					'ounce' => {
						'name' => q(ಔನ್ಸ್‌ಗಳು),
						'one' => q({0} ಔನ್ಸ್),
						'other' => q({0} ಔನ್ಸ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಔನ್ಸ್‌ಗೆ),
					},
					'ounce-troy' => {
						'name' => q(ಟ್ರಾಯ್ ಔನ್ಸ್‌ಗಳು),
						'one' => q({0} ಟ್ರಾಯ್ ಔನ್ಸ್),
						'other' => q({0} ಟ್ರಾಯ್ ಔನ್ಸ್‌ಗಳು),
					},
					'parsec' => {
						'name' => q(ಪಾರ್‌‍ಸೆಕೆಂ),
						'one' => q({0} ಪಾರ್‌ಸೆಕೆಂ),
						'other' => q({0} ಪಾರ್‌ಸೆಕೆಂ),
					},
					'per' => {
						'1' => q({0} ಪ್ರತಿ {1} ಗೆ),
					},
					'picometer' => {
						'name' => q(ಪಿಕೋಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಪಿಕೋಮೀಟರ್),
						'other' => q({0} ಪಿಕೋಮೀಟರ್‌ಗಳು),
					},
					'pint' => {
						'name' => q(ಪಿಂಟ್‌ಗಳು),
						'one' => q({0} ಪಿಂಟ್‌),
						'other' => q({0} ಪಿಂಟ್‌ಗಳು),
					},
					'pint-metric' => {
						'name' => q(ಮೆಟ್ರಿಕ್ ಪಿಂಟ್‌ಗಳು),
						'one' => q({0} ಮೆಟ್ರಿಕ್ ಪಿಂಟ್),
						'other' => q({0} ಮೆಟ್ರಿಕ್ ಪಿಂಟ್‌ಗಳು),
					},
					'pound' => {
						'name' => q(ಪೌಂಡ್‌ಗಳು),
						'one' => q({0} ಪೌಂಡ್),
						'other' => q({0} ಪೌಂಡ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಪೌಂಡ್‌ಗೆ),
					},
					'pound-per-square-inch' => {
						'name' => q(ಪ್ರತಿ ಚದರ ಇಂಚಿಗೆ ಪೌಂಡ್‌ಗಳು),
						'one' => q({0} ಪ್ರತಿ ಚದರ ಇಂಚಿಗೆ ಪೌಂಡ್‌),
						'other' => q({0} ಪ್ರತಿ ಚದರ ಇಂಚಿಗೆ ಪೌಂಡ್‌ಗಳು),
					},
					'quart' => {
						'name' => q(ಕಾಲುಭಾಗಗಳು),
						'one' => q({0} ಕಾಲುಭಾಗ),
						'other' => q({0} ಕಾಲುಭಾಗಗಳು),
					},
					'radian' => {
						'name' => q(ರೇಡಿಯಾನ್‌ಗಳು),
						'one' => q({0} ರೇಡಿಯಾನ್‌),
						'other' => q({0} ರೇಡಿಯಾನ್‌ಗಳು),
					},
					'revolution' => {
						'name' => q(ಕ್ರಾಂತಿ),
						'one' => q({0} ಕ್ರಾಂತಿ),
						'other' => q({0} ಕ್ರಾಂತಿಗಳು),
					},
					'second' => {
						'name' => q(ಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ಸೆಕೆಂಡ್),
						'other' => q({0} ಸೆಕೆಂಡುಗಳು),
						'per' => q({0} ಪ್ರತಿ ಸೆಕೆಂಡ್),
					},
					'square-centimeter' => {
						'name' => q(ಚದರ ಸೆಂಟಿಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಚದರ ಸೆಂಟಿಮೀಟರ್),
						'other' => q({0} ಚದರ ಸೆಂಟಿಮೀಟರ್‌ಗಳು),
						'per' => q({0} ಪ್ರತಿ ಚದರ ಸೆಂಟಿಮೀಟರ್‌‌ಗೆ),
					},
					'square-foot' => {
						'name' => q(ಚದರಡಿ),
						'one' => q({0} ಚದರಡಿ),
						'other' => q({0} ಚದರಡಿ),
					},
					'square-inch' => {
						'name' => q(ಚದರ ಅಂಗುಲಗಳು),
						'one' => q({0} ಚದರ ಅಂಗುಲ),
						'other' => q({0} ಚದರ ಅಂಗುಲಗಳು),
						'per' => q({0} ಚದರ ಅಂಗುಲಕ್ಕೆ),
					},
					'square-kilometer' => {
						'name' => q(ಚದರ ಕಿಲೋಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಚದರ ಕಿಲೋಮೀಟರ್),
						'other' => q({0} ಚದರ ಕಿಲೋಮೀಟರ್‌ಗಳು),
					},
					'square-meter' => {
						'name' => q(ಚದರ ಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಚದರ ಮೀಟರ್),
						'other' => q({0} ಚದರ ಮೀಟರ್‌ಗಳು),
						'per' => q({0} ಚದರ ಮೀಟರ್‌ಗೆ),
					},
					'square-mile' => {
						'name' => q(ಚದರ ಮೈಲುಗಳು),
						'one' => q({0} ಚದರ ಮೈಲು),
						'other' => q({0} ಚದರ ಮೈಲುಗಳು),
					},
					'square-yard' => {
						'name' => q(ಚದರ ಗಜಗಳು),
						'one' => q({0} ಚದರ ಗಜ),
						'other' => q({0} ಚದರ ಗಜಗಳು),
					},
					'tablespoon' => {
						'name' => q(ಟೇಬಲ್ ಸ್ಪೂನ್‍ಗಳು),
						'one' => q({0} ಟೇಬಲ್ ಸ್ಪೂನ್‍),
						'other' => q({0} ಟೇಬಲ್ ಸ್ಪೂನ್‍‍ಗಳು),
					},
					'teaspoon' => {
						'name' => q(ಟೀ ಸ್ಪೂನ್‍ಗಳು),
						'one' => q({0} ಟೀ ಸ್ಪೂನ್‍),
						'other' => q({0} ಟೀ ಸ್ಪೂನ್‍ಗಳು),
					},
					'terabit' => {
						'name' => q(ಟೆರಾಬಿಟ್‌ಗಳು),
						'one' => q({0} ಟೆರಾಬಿಟ್‌),
						'other' => q({0} ಟೆರಾಬಿಟ್‌ಗಳು),
					},
					'terabyte' => {
						'name' => q(ಟೆರಾಬೈಟ್‌ಗಳು),
						'one' => q({0} ಟೆರಾಬೈಟ್‌),
						'other' => q({0} ಟೆರಾಬೈಟ್‌ಗಳು),
					},
					'ton' => {
						'name' => q(ಟನ್‌ಗಳು),
						'one' => q({0} ಟನ್‌),
						'other' => q({0} ಟನ್‌ಗಳು),
					},
					'volt' => {
						'name' => q(ವೋಲ್ಟ್‌‌ಗಳು),
						'one' => q({0} ವೋಲ್ಟ್‌),
						'other' => q({0} ವೋಲ್ಟ್‌ಗಳು),
					},
					'watt' => {
						'name' => q(ವ್ಯಾಟ್‌ಗಳು),
						'one' => q({0} ವ್ಯಾಟ್),
						'other' => q({0} ವ್ಯಾಟ್‌ಗಳು),
					},
					'week' => {
						'name' => q(ವಾರಗಳು),
						'one' => q({0} ವಾರಗಳು),
						'other' => q({0} ವಾರಗಳು),
						'per' => q({0} ಪ್ರತಿ ವಾರಕ್ಕೆ),
					},
					'yard' => {
						'name' => q(ಗಜಗಳು),
						'one' => q({0} ಗಜ),
						'other' => q({0} ಗಜಗಳು),
					},
					'year' => {
						'name' => q(ವರ್ಷಗಳು),
						'one' => q({0} ವರ್ಷ),
						'other' => q({0} ವರ್ಷಗಳು),
						'per' => q({0} ಪ್ರತಿ ವರ್ಷಕ್ಕೆ),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ಎಕ.),
						'other' => q({0} ಎಕ.),
					},
					'arc-minute' => {
						'one' => q({0}ನಿ.),
						'other' => q({0}ನಿ.),
					},
					'arc-second' => {
						'one' => q({0}ಸೆಕೆಂ),
						'other' => q({0}ಸೆಕೆಂ),
					},
					'celsius' => {
						'name' => q(°ಸೆ),
						'one' => q({0}°ಸೆ),
						'other' => q({0}°ಸೆ),
					},
					'centimeter' => {
						'name' => q(ಸೆಮೀ),
						'one' => q({0} ಸೆಮೀ),
						'other' => q({0} ಸೆಮೀ),
					},
					'coordinate' => {
						'east' => q({0}ಪೂ),
						'north' => q({0}ಉ),
						'south' => q({0}ದ),
						'west' => q({0}ಪ),
					},
					'cubic-kilometer' => {
						'one' => q({0}ಕಿಮೀ³),
						'other' => q({0}ಕಿಮೀ³),
					},
					'cubic-mile' => {
						'one' => q({0}ಮೈ³),
						'other' => q({0}ಮೈ³),
					},
					'day' => {
						'name' => q(ದಿನ),
						'one' => q({0}ದಿನ),
						'other' => q({0}ದಿನ),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°ಫ್ಯಾ),
						'other' => q({0}°ಫ್ಯಾ),
					},
					'foot' => {
						'one' => q({0} ′),
						'other' => q({0} ′),
					},
					'g-force' => {
						'one' => q({0}ಜಿ-ಫೋ.),
						'other' => q({0}ಜಿ-ಫೋ.),
					},
					'gram' => {
						'name' => q(ಗ್ರಾಂ),
						'one' => q({0}ಗ್ರಾ),
						'other' => q({0}ಗ್ರಾ),
					},
					'hectare' => {
						'one' => q({0} ಹೆ.),
						'other' => q({0} ಹೆ.),
					},
					'hectopascal' => {
						'one' => q({0}ಹೆ.ಪ್ಯಾ),
						'other' => q({0}ಹೆ.ಪ್ಯಾ),
					},
					'horsepower' => {
						'one' => q({0}ಹೆಚ್‌ಪಿ),
						'other' => q({0}ಹೆಚ್‌ಪಿ),
					},
					'hour' => {
						'name' => q(ಗಂಟೆ),
						'one' => q({0}ಗಂ.),
						'other' => q({0}ಗಂ.),
					},
					'inch' => {
						'one' => q({0} ″),
						'other' => q({0} ″),
					},
					'inch-hg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					'kilogram' => {
						'name' => q(ಕೆಜಿ),
						'one' => q({0}ಕೆಜಿ),
						'other' => q({0}ಕೆಜಿ),
					},
					'kilometer' => {
						'name' => q(ಕಿಮೀ),
						'one' => q({0}ಕಿಮೀ),
						'other' => q({0}ಕಿಮೀ),
					},
					'kilometer-per-hour' => {
						'name' => q(ಕಿ.ಮೀ/ಗಂ),
						'one' => q({0}ಕಿ.ಮೀ./ಗಂ),
						'other' => q({0}ಕಿ.ಮೀ./ಗಂ),
					},
					'kilowatt' => {
						'one' => q({0}ಕಿ.ವ್ಯಾ),
						'other' => q({0}ಕಿ.ವ್ಯಾ),
					},
					'light-year' => {
						'one' => q({0}ಹಗು. ವ.),
						'other' => q({0}ಹಗು. ವ.),
					},
					'liter' => {
						'name' => q(ಲೀಟರ್),
						'one' => q({0}ಲೀ),
						'other' => q({0}ಲೀ),
					},
					'liter-per-100kilometers' => {
						'name' => q(ಲೀ/100ಕಿ.ಮೀ),
						'one' => q({0}L/100km),
						'other' => q({0}L/100km),
					},
					'meter' => {
						'name' => q(ಮೀಟರ್‌ಗಳು),
						'one' => q({0}ಮೀ),
						'other' => q({0}ಮೀ),
					},
					'meter-per-second' => {
						'one' => q({0}ಮೀ/ಸೆ.),
						'other' => q({0}ಮೀ/ಸೆ.),
					},
					'mile' => {
						'one' => q({0}ಮೈ.),
						'other' => q({0}ಮೈ.),
					},
					'mile-per-hour' => {
						'one' => q({0}ಮೈ/ಗಂ),
						'other' => q({0}ಮೈ/ಗಂ),
					},
					'millibar' => {
						'one' => q({0}ಮಿ.ಬಾ.),
						'other' => q({0}ಮಿ.ಬಾ.),
					},
					'millimeter' => {
						'name' => q(ಮಿಮೀ),
						'one' => q({0}ಮಿಮೀ),
						'other' => q({0}ಮಿಮೀ),
					},
					'millisecond' => {
						'name' => q(ಮಿ.ಸೆ.),
						'one' => q({0}ಮಿ.ಸೆ.),
						'other' => q({0}ಮಿ.ಸೆ.),
					},
					'minute' => {
						'name' => q(ನಿಮಿಷ),
						'one' => q({0}ನಿಮಿ),
						'other' => q({0}ನಿಮಿ),
					},
					'month' => {
						'name' => q(ತಿಂಗಳು),
						'one' => q({0}ತಿಂ.),
						'other' => q({0}ತಿಂ.),
					},
					'ounce' => {
						'one' => q({0}ಔ),
						'other' => q({0}ಔ),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}ಪಿಎಂ),
						'other' => q({0}ಪಿಎಂ),
					},
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					'second' => {
						'name' => q(ಸೆಕೆಂ),
						'one' => q({0}ಸೆಕೆಂ),
						'other' => q({0} ಸೆಕೆಂ),
					},
					'square-foot' => {
						'one' => q({0}ಚ.ಅ),
						'other' => q({0}ಚ.ಅ),
					},
					'square-kilometer' => {
						'one' => q({0} ಚ.ಕಿಮೀ.),
						'other' => q({0} ಚ.ಕಿಮೀ.),
					},
					'square-meter' => {
						'one' => q({0} ಮೀ²),
						'other' => q({0} ಮೀ²),
					},
					'square-mile' => {
						'one' => q({0}ಚ.ಮೀ.),
						'other' => q({0}ಚ.ಮೀ.),
					},
					'watt' => {
						'one' => q({0}ವ್ಯಾ.),
						'other' => q({0}ವ್ಯಾ.),
					},
					'week' => {
						'name' => q(ವಾರ),
						'one' => q({0}ವಾರ),
						'other' => q({0}ವಾರ),
					},
					'yard' => {
						'one' => q({0}ಗ),
						'other' => q({0} ಗ),
					},
					'year' => {
						'name' => q(ವರ್ಷಗಳು),
						'one' => q({0}ವ),
						'other' => q({0}ವ),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(ಎಕರೆಗಳು),
						'one' => q({0} ಎಕ.),
						'other' => q({0} ಎಕ.),
					},
					'acre-foot' => {
						'name' => q(ಎಕರೆ ಅಡಿ),
						'one' => q({0} ಎ. ಅ),
						'other' => q({0} ಎ. ಅ),
					},
					'ampere' => {
						'name' => q(ಆಂ.),
						'one' => q({0} ಆಂ.),
						'other' => q({0} ಆಂ.),
					},
					'arc-minute' => {
						'name' => q(ನಿ.),
						'one' => q({0} ನಿ.),
						'other' => q({0} ನಿ.ಗಳು),
					},
					'arc-second' => {
						'name' => q(ಸೆಕೆಂ.ಗಳು),
						'one' => q({0} ಸೆಕೆಂ),
						'other' => q({0} ಸೆಕೆಂ.ಗಳು),
					},
					'astronomical-unit' => {
						'name' => q(ಅ.ಯೂ),
						'one' => q({0} ಅ.ಯೂ),
						'other' => q({0} ಅ.ಯೂ),
					},
					'bit' => {
						'name' => q(ಬಿ.),
						'one' => q({0} ಬಿ.),
						'other' => q({0} ಬಿ.),
					},
					'byte' => {
						'name' => q(ಬೈ.),
						'one' => q({0} ಬೈ.),
						'other' => q({0} ಬೈ.),
					},
					'calorie' => {
						'name' => q(ಕ್ಯಾಲೊ),
						'one' => q({0} ಕ್ಯಾಲೊ),
						'other' => q({0} ಕ್ಯಾಲೊ),
					},
					'carat' => {
						'name' => q(ಕ್ಯಾರೆಟ್‌ಗಳು),
						'one' => q({0} ಕ್ಯಾರೆ),
						'other' => q({0} ಕ್ಯಾರೆ),
					},
					'celsius' => {
						'name' => q(ಡಿ.ಸೆ.),
						'one' => q({0}°ಸೆ),
						'other' => q({0}°ಸೆ),
					},
					'centiliter' => {
						'name' => q(ಸೆಂ.ಲೀ),
						'one' => q({0} ಸೆಂ.ಲೀ),
						'other' => q({0} ಸೆಂ.ಲೀ),
					},
					'centimeter' => {
						'name' => q(ಸೆಮೀ),
						'one' => q({0} ಸೆಮೀ),
						'other' => q({0} ಸೆಮೀ),
						'per' => q({0}/ಸೆಂಮೀ),
					},
					'century' => {
						'name' => q(ಶ),
						'one' => q({0} ಶ),
						'other' => q({0} ಶ),
					},
					'coordinate' => {
						'east' => q({0}ಪೂ),
						'north' => q({0}ಉ),
						'south' => q({0}ದ),
						'west' => q({0}ಪ),
					},
					'cubic-centimeter' => {
						'name' => q(ಸೆಮೀ³),
						'one' => q({0} ಸೆಮೀ³),
						'other' => q({0} ಸೆಮೀ³),
						'per' => q({0}/ಸೆಮೀ³),
					},
					'cubic-foot' => {
						'name' => q(ಅಡಿ³),
						'one' => q({0} ಅಡಿ³),
						'other' => q({0} ಅಡಿ³),
					},
					'cubic-inch' => {
						'name' => q(ಅಂಗುಲಗಳು³),
						'one' => q({0} ಅಂ³),
						'other' => q({0} ಅಂ³),
					},
					'cubic-kilometer' => {
						'name' => q(ಕಿಮೀ³),
						'one' => q({0} ಕಿಮೀ³),
						'other' => q({0} ಕಿಮೀ³),
					},
					'cubic-meter' => {
						'name' => q(ಮೀ³),
						'one' => q({0} ಮೀ³),
						'other' => q({0} ಮೀ³),
						'per' => q({0}/ಮೀ³),
					},
					'cubic-mile' => {
						'name' => q(ಮೈ³),
						'one' => q({0} ಮೈ³),
						'other' => q({0} ಮೈ³),
					},
					'cubic-yard' => {
						'name' => q(ಗಜಗಳು³),
						'one' => q({0} ಗಜ³),
						'other' => q({0} ಗಜ³),
					},
					'cup' => {
						'name' => q(ಕಪ್‍ಗಳು),
						'one' => q({0} ಕ),
						'other' => q({0} ಕ),
					},
					'cup-metric' => {
						'name' => q(ಮೆ.ಕಪ್‌),
						'one' => q({0} ಮೆ.ಕಪ್‌),
						'other' => q({0} ಮೆ.ಕ),
					},
					'day' => {
						'name' => q(ದಿನಗಳು),
						'one' => q({0} ದಿನ),
						'other' => q({0} ದಿನಗಳು),
						'per' => q({0}/ದಿ),
					},
					'deciliter' => {
						'name' => q(ಡೆ.ಲೀ),
						'one' => q({0} ಡೆ.ಲೀ),
						'other' => q({0} ಡೆ.ಲೀ),
					},
					'decimeter' => {
						'name' => q(ಡೆಮೀ),
						'one' => q({0} ಡೆಮೀ),
						'other' => q({0} ಡೆಮೀ),
					},
					'degree' => {
						'name' => q(ಡಿಗ್ರಿಗಳು),
						'one' => q({0} ಡಿ.),
						'other' => q({0} ಡಿ.),
					},
					'fahrenheit' => {
						'name' => q(ಡಿ.ಫ್ಯಾ.),
						'one' => q({0}°ಫ್ಯಾ),
						'other' => q({0}°ಫ್ಯಾ),
					},
					'fluid-ounce' => {
						'name' => q(ಫ್ಲೂ.ಔ),
						'one' => q({0} ಫ್ಲೂ.ಔ),
						'other' => q({0} ಫ್ಲೂ.ಔ),
					},
					'foodcalorie' => {
						'name' => q(ಕ್ಯಾ),
						'one' => q({0} ಕ್ಯಾ),
						'other' => q({0} ಕ್ಯಾ),
					},
					'foot' => {
						'name' => q(ಅಡಿ),
						'one' => q({0} ಅ),
						'other' => q({0} ಅ),
						'per' => q({0}/ಅ),
					},
					'g-force' => {
						'name' => q(ಜಿ-ಫೋರ್ಸ್),
						'one' => q({0} ಜಿ-ಫೋ.),
						'other' => q({0} ಜಿ-ಫೋ.),
					},
					'gallon' => {
						'name' => q(ಗ್ಯಾ),
						'one' => q({0} ಗ್ಯಾ),
						'other' => q({0} ಗ್ಯಾ),
						'per' => q({0}/ಗ್ಯಾ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ಗಿ.ಬಿ.),
						'one' => q({0} ಗಿ.ಬಿ.),
						'other' => q({0} ಗಿ.ಬಿ.),
					},
					'gigabyte' => {
						'name' => q(ಗಿ.ಬೈ.),
						'one' => q({0} ಗಿ.ಬೈ.),
						'other' => q({0} ಗಿ.ಬೈ.),
					},
					'gigahertz' => {
						'name' => q(ಗಿ.ಹ),
						'one' => q({0} ಗಿ.ಹ),
						'other' => q({0} ಗಿ.ಹ),
					},
					'gigawatt' => {
						'name' => q(ಗಿ.ವ್ಯಾ),
						'one' => q({0} ಗಿ.ವ್ಯಾ),
						'other' => q({0} ಗಿ.ವ್ಯಾ),
					},
					'gram' => {
						'name' => q(ಗ್ರಾಂಗಳು),
						'one' => q({0} ಗ್ರಾ),
						'other' => q({0} ಗ್ರಾ),
						'per' => q({0}/ಗ್ರಾ),
					},
					'hectare' => {
						'name' => q(ಹೆಕ್ಟೇರುಗಳು),
						'one' => q({0} ಹೆ.),
						'other' => q({0} ಹೆ.),
					},
					'hectoliter' => {
						'name' => q(ಹೆ.ಲೀ),
						'one' => q({0} ಹೆ.ಲೀ),
						'other' => q({0} ಹೆ.ಲೀ),
					},
					'hectopascal' => {
						'name' => q(ಹೆ.ಪ್ಯಾ.),
						'one' => q({0} ಹೆ.ಪ್ಯಾ),
						'other' => q({0} ಹೆ.ಪ್ಯಾ),
					},
					'hertz' => {
						'name' => q(ಹರ್ಟ್ಸ್‌),
						'one' => q({0} ಹರ್ಟ್ಸ್‌),
						'other' => q({0} ಹರ್ಟ್ಸ್‌),
					},
					'horsepower' => {
						'name' => q(ಹೆಚ್‌ಪಿ),
						'one' => q({0} ಹೆಚ್‌ಪಿ),
						'other' => q({0} ಹೆಚ್‌ಪಿ),
					},
					'hour' => {
						'name' => q(ಗಂಟೆಗಳು),
						'one' => q({0} ಗಂ.),
						'other' => q({0} ಗಂ.),
						'per' => q({0}/ಗಂ),
					},
					'inch' => {
						'name' => q(ಅಂಗುಲಗಳು),
						'one' => q({0} ಅಂ),
						'other' => q({0} ಅಂ),
						'per' => q({0}/ಅಂ),
					},
					'inch-hg' => {
						'name' => q(ಮರ್ಕ್ಯು.ಅಂ.),
						'one' => q({0} ಮರ್ಕ್ಯು. ಅಂ.),
						'other' => q({0} ಮರ್ಕ್ಯು. ಅಂ.),
					},
					'joule' => {
						'name' => q(ಜೌಲ್‌ಗಳು),
						'one' => q({0} ಜೌ),
						'other' => q({0} ಜೌ),
					},
					'karat' => {
						'name' => q(ಕಾರ.),
						'one' => q({0} ಕಾರ.),
						'other' => q({0} ಕಾರ.),
					},
					'kelvin' => {
						'name' => q(ಕೆ),
						'one' => q({0} ಕೆ),
						'other' => q({0} ಕೆ),
					},
					'kilobit' => {
						'name' => q(ಕಿ.ಬಿ.),
						'one' => q({0} ಕಿ.ಬಿ.),
						'other' => q({0} ಕಿ.ಬಿ.),
					},
					'kilobyte' => {
						'name' => q(ಕಿ.ಬೈ.),
						'one' => q({0} ಕಿ.ಬೈ.),
						'other' => q({0} ಕಿ.ಬೈ.),
					},
					'kilocalorie' => {
						'name' => q(ಕಿ.ಕ್ಯಾ),
						'one' => q({0} ಕಿ.ಕ್ಯಾ),
						'other' => q({0} ಕಿ.ಕ್ಯಾ),
					},
					'kilogram' => {
						'name' => q(ಕೆಜಿ),
						'one' => q({0} ಕೆಜಿ),
						'other' => q({0} ಕೆಜಿ),
						'per' => q({0}/ಕೆಜಿ),
					},
					'kilohertz' => {
						'name' => q(ಕಿ.ಹ),
						'one' => q({0} ಕಿ.ಹ),
						'other' => q({0} ಕಿ.ಹ),
					},
					'kilojoule' => {
						'name' => q(ಕಿ.ಜೌ),
						'one' => q({0} ಕಿ.ಜೌ),
						'other' => q({0} ಕಿ.ಜೌ),
					},
					'kilometer' => {
						'name' => q(ಕಿಲೋಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಕಿಮೀ),
						'other' => q({0} ಕಿಮೀ),
						'per' => q({0}/ಕಿ.ಮೀ),
					},
					'kilometer-per-hour' => {
						'name' => q(ಕಿ.ಮೀ/ಗಂ),
						'one' => q({0} ಕಿ.ಮೀ./ಗಂ),
						'other' => q({0} ಕಿ.ಮೀ./ಗಂ),
					},
					'kilowatt' => {
						'name' => q(ಕಿ.ವ್ಯಾ),
						'one' => q({0} ಕಿ.ವ್ಯಾ),
						'other' => q({0} ಕಿ.ವ್ಯಾ),
					},
					'kilowatt-hour' => {
						'name' => q(ಕಿ.ವ್ಯಾ-ಗಂ),
						'one' => q({0} ಕಿ.ವ್ಯಾ.ಗಂ),
						'other' => q({0} ಕಿ.ವ್ಯಾ.ಗಂ),
					},
					'knot' => {
						'name' => q(ನಾ),
						'one' => q({0} ನಾ),
						'other' => q({0} ನಾ),
					},
					'light-year' => {
						'name' => q(ಬೆಳಕಿನ ವರ್ಷಗಳು),
						'one' => q({0} ಬೆ.ವರ್ಷ),
						'other' => q({0} ಬೆ.ವರ್ಷ),
					},
					'liter' => {
						'name' => q(ಲೀಟರ್‌ಗಳು),
						'one' => q({0} ಲೀ),
						'other' => q({0} ಲೀ),
						'per' => q({0}/ಲೀ),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} ಲೀ/100ಕಿ.ಮೀ),
						'other' => q({0} ಲೀ/100ಕಿ.ಮೀ),
					},
					'liter-per-kilometer' => {
						'name' => q(ಲೀ/ಕಿ.ಮೀ),
						'one' => q({0} ಲೀ/ಕಿ.ಮೀ),
						'other' => q({0} ಲೀ/ಕಿ.ಮೀ),
					},
					'lux' => {
						'name' => q(ಲ.),
						'one' => q({0} ಲ.),
						'other' => q({0} ಲ.),
					},
					'megabit' => {
						'name' => q(ಮೆ.ಬಿ.),
						'one' => q({0} ಮೆ.ಬಿ.),
						'other' => q({0} ಮೆ.ಬಿ.),
					},
					'megabyte' => {
						'name' => q(ಮೆ.ಬೈ.),
						'one' => q({0} ಮೆ.ಬೈ.),
						'other' => q({0} ಮೆ.ಬೈ.),
					},
					'megahertz' => {
						'name' => q(ಮೆ.ಹ),
						'one' => q({0} ಮೆ.ಹ),
						'other' => q({0} ಮೆ.ಹ),
					},
					'megaliter' => {
						'name' => q(ಮೆ.ಲೀ),
						'one' => q({0} ಮೆ.ಲೀ),
						'other' => q({0} ಮೆ.ಲೀ),
					},
					'megawatt' => {
						'name' => q(ಮೆ.ವ್ಯಾ),
						'one' => q({0} ಮೆ.ವ್ಯಾ),
						'other' => q({0} ಮೆ.ವ್ಯಾ),
					},
					'meter' => {
						'name' => q(ಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಮೀ),
						'other' => q({0} ಮೀ),
						'per' => q({0}/ಮೀ),
					},
					'meter-per-second' => {
						'name' => q(ಮೀ.ಗಳು/ಸೆ),
						'one' => q({0} ಮೀ/ಸೆ.),
						'other' => q({0} ಮೀ/ಸೆ.),
					},
					'meter-per-second-squared' => {
						'name' => q(ಮೀ/ಸೆ²),
						'one' => q({0} ಮೀ/ಸೆ²),
						'other' => q({0} ಮೀ/ಸೆ²),
					},
					'metric-ton' => {
						'name' => q(ಟ),
						'one' => q({0} ಮೆಟ್ರಿಕ್‌ ಟನ್‌),
						'other' => q({0} ಮೆಟ್ರಿಕ್‌‌ ಟನ್‌‌ಗಳು),
					},
					'microgram' => {
						'name' => q(ಮೈ.ಗ್ರಾಂ),
						'one' => q({0} ಮೈ.ಗ್ರಾಂ),
						'other' => q({0} ಮೈ.ಗ್ರಾಂ),
					},
					'micrometer' => {
						'name' => q(µmeters),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(μsecs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(ಮೈಲುಗಳು),
						'one' => q({0} ಮೈ.),
						'other' => q({0} ಮೈ.),
					},
					'mile-per-gallon' => {
						'name' => q(ಮೈ/ಗ್ಯಾ),
						'one' => q({0} ಪ್ರ.ಗ್ಯಾ.ಮೈ.),
						'other' => q({0} ಪ್ರ.ಗ್ಯಾ.ಮೈ.),
					},
					'mile-per-hour' => {
						'name' => q(ಮೈ/ಗಂ),
						'one' => q({0} ಮೈ/ಗಂ),
						'other' => q({0} ಮೈ/ಗಂ),
					},
					'mile-scandinavian' => {
						'name' => q(ಸ್ಕ್ಯಾಂ.ಮೈ),
						'one' => q({0} ಸ್ಕ್ಯಾಂ.ಮೈ),
						'other' => q({0} ಸ್ಕ್ಯಾಂ.ಮೈ),
					},
					'milliampere' => {
						'name' => q(ಮಿ.ಆಂ.),
						'one' => q({0} ಮಿ.ಆಂ.),
						'other' => q({0} ಮಿ.ಆಂ.),
					},
					'millibar' => {
						'name' => q(ಮಿ.ಬಾರ್‌),
						'one' => q({0} ಮಿ.ಬಾರ್),
						'other' => q({0} ಮಿ.ಬಾರ್),
					},
					'milligram' => {
						'name' => q(ಮಿ.ಗ್ರಾಂ),
						'one' => q({0} ಮಿ.ಗ್ರಾಂ),
						'other' => q({0} ಮಿ.ಗ್ರಾಂ),
					},
					'milliliter' => {
						'name' => q(ಮಿ.ಲೀ),
						'one' => q({0} ಮಿ.ಲೀ),
						'other' => q({0} ಮಿ.ಲೀ),
					},
					'millimeter' => {
						'name' => q(ಮಿಮೀ),
						'one' => q({0} ಮಿಮೀ),
						'other' => q({0} ಮಿಮೀ),
					},
					'millimeter-of-mercury' => {
						'name' => q(ಮರ್ಕ್ಯು.ಮಿ.ಮೀ.),
						'one' => q({0} ಮರ್ಕ್ಯು.ಮಿ.ಮೀ.),
						'other' => q({0} ಮರ್ಕ್ಯು.ಮಿ.ಮೀ.),
					},
					'millisecond' => {
						'name' => q(ಮಿಲಿಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ಮಿ.ಸೆ.),
						'other' => q({0} ಮಿ.ಸೆ.),
					},
					'milliwatt' => {
						'name' => q(ಮಿ.ವ್ಯಾ),
						'one' => q({0} ಮಿ.ವ್ಯಾ),
						'other' => q({0} ಮಿ.ವ್ಯಾ),
					},
					'minute' => {
						'name' => q(ನಿಮಿಷಗಳು),
						'one' => q({0} ನಿಮಿ),
						'other' => q({0} ನಿಮಿ),
						'per' => q({0}/ನಿಮಿ),
					},
					'month' => {
						'name' => q(ತಿಂಗಳು),
						'one' => q({0} ತಿಂ.),
						'other' => q({0} ತಿಂ.),
						'per' => q({0}/ತಿ),
					},
					'nanometer' => {
						'name' => q(ನ್ಯಾ.ಮೀ),
						'one' => q({0} ನ್ಯಾ.ಮೀ),
						'other' => q({0} ನ್ಯಾ.ಮೀ),
					},
					'nanosecond' => {
						'name' => q(ನ್ಯಾ.ಸೆ),
						'one' => q({0} ನ್ಯಾ.ಸೆ),
						'other' => q({0} ನ್ಯಾ.ಸೆ),
					},
					'nautical-mile' => {
						'name' => q(ನಾ.ಮೈ),
						'one' => q({0} ನಾ.ಮೈ),
						'other' => q({0} ನಾ.ಮೈ),
					},
					'ohm' => {
						'name' => q(ಓಂಗಳು),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(ಔ),
						'one' => q({0} ಔ),
						'other' => q({0} ಔ),
						'per' => q({0}/ ಔ),
					},
					'ounce-troy' => {
						'name' => q(ಟ್ರಾ.ಔ),
						'one' => q({0} ಟ್ರಾ.ಔ),
						'other' => q({0} ಟ್ರಾ.ಔ),
					},
					'parsec' => {
						'name' => q(ಪಾರ್‌ಸೆಕೆಂ.ಗಳು),
						'one' => q({0} ಪಾ.ಸೆ),
						'other' => q({0} ಪಾ.ಸೆ),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(ಪಿ.ಮೀ),
						'one' => q({0} ಪಿ.ಮೀ),
						'other' => q({0} ಪಿ.ಮೀ),
					},
					'pint' => {
						'name' => q(ಪಿಂಟ್‍ಗಳು),
						'one' => q({0} ಪಿಂಟ್‌),
						'other' => q({0} ಪಿಂಟ್‌),
					},
					'pint-metric' => {
						'name' => q(ಮೆ.ಪಿಂ),
						'one' => q({0} ಮೆ.ಪಿಂ),
						'other' => q({0} ಮೆ.ಪಿಂ),
					},
					'pound' => {
						'name' => q(ಪೌಂ),
						'one' => q({0} ಪೌಂ),
						'other' => q({0} ಪೌಂ),
						'per' => q({0}/ಪೌಂ),
					},
					'pound-per-square-inch' => {
						'name' => q(ಪ್ರ.ಚ.ಇಂ.ಪೌಂ.),
						'one' => q({0} ಪ್ರ.ಚ.ಇಂ.ಪೌಂ.),
						'other' => q({0} ಪ್ರ.ಚ.ಇಂ.ಪೌಂ.),
					},
					'quart' => {
						'name' => q(ಕಾ.ಭಾ),
						'one' => q({0} ಕಾ.ಭಾ),
						'other' => q({0} ಕಾ.ಭಾ),
					},
					'radian' => {
						'name' => q(ರೇಡಿ.),
						'one' => q({0} ರೇಡಿ.),
						'other' => q({0} ರೇಡಿ),
					},
					'revolution' => {
						'name' => q(ಕ್ರಾಂ),
						'one' => q({0} ಕ್ರಾಂ),
						'other' => q({0} ಕ್ರಾಂ),
					},
					'second' => {
						'name' => q(ಸೆಕೆಂಡುಗಳು),
						'one' => q({0} ಸೆಕೆಂ),
						'other' => q({0} ಸೆಕೆಂ),
						'per' => q({0}/ಸೆ),
					},
					'square-centimeter' => {
						'name' => q(ಸೆಂ.ಮೀ²),
						'one' => q({0} ಸೆಂ.ಮೀ²),
						'other' => q({0} ಸೆಂ.ಮೀ²),
						'per' => q({0}/ಸೆಂ.ಮೀ²),
					},
					'square-foot' => {
						'name' => q(ಚದರಡಿ),
						'one' => q({0} ಚ.ಅ),
						'other' => q({0} ಚ.ಅ),
					},
					'square-inch' => {
						'name' => q(ಅಂಗುಲಗಳು²),
						'one' => q({0} ಅಂ²),
						'other' => q({0} ಅಂ²),
						'per' => q({0}/ಅಂ²ಕ್ಕೆ),
					},
					'square-kilometer' => {
						'name' => q(ಕಿಮೀ²),
						'one' => q({0} ಕಿಮೀ²),
						'other' => q({0} ಕಿಮೀ²),
					},
					'square-meter' => {
						'name' => q(ಚದರ ಮೀಟರ್‌ಗಳು),
						'one' => q({0} ಮೀ²),
						'other' => q({0} ಮೀ²),
						'per' => q({0}/ಮೀ²ಗೆ),
					},
					'square-mile' => {
						'name' => q(ಚದರ ಮೈಲುಗಳು),
						'one' => q({0} ಚ.ಮೀ.),
						'other' => q({0} ಚ.ಮೀ.),
					},
					'square-yard' => {
						'name' => q(ಗಜಗಳು²),
						'one' => q({0} ಗ²),
						'other' => q({0} ಗ²),
					},
					'tablespoon' => {
						'name' => q(ಟೇ.ಸ್ಪೂ),
						'one' => q({0} ಟೇ.ಸ್ಪೂ),
						'other' => q({0} ಟೇ.ಸ್ಪೂ),
					},
					'teaspoon' => {
						'name' => q(ಟೀ ಸ್ಪೂ),
						'one' => q({0} ಟೀ ಸ್ಪೂ),
						'other' => q({0} ಟೀ ಸ್ಪೂ),
					},
					'terabit' => {
						'name' => q(ಟೆ.ಬಿ.),
						'one' => q({0} ಟೆ.ಬಿ.),
						'other' => q({0} ಟೆ.ಬಿ.),
					},
					'terabyte' => {
						'name' => q(ಟೆ.ಬೈ.),
						'one' => q({0} ಟೆ.ಬೈ.),
						'other' => q({0} ಟೆ.ಬೈ.),
					},
					'ton' => {
						'name' => q(ಟನ್‍ಗಳು),
						'one' => q({0} ಟನ್‌),
						'other' => q({0} ಟನ್‌),
					},
					'volt' => {
						'name' => q(ವೋ.),
						'one' => q({0} ವೋ),
						'other' => q({0} ವೋ.),
					},
					'watt' => {
						'name' => q(ವ್ಯಾಟ್‌ಗಳು),
						'one' => q({0} ವ್ಯಾ.),
						'other' => q({0} ವ್ಯಾ.),
					},
					'week' => {
						'name' => q(ವಾರಗಳು),
						'one' => q({0} ವಾರ),
						'other' => q({0} ವಾರಗಳು),
						'per' => q({0}/ವಾ),
					},
					'yard' => {
						'name' => q(ಗಜಗಳು),
						'one' => q({0} ಗ),
						'other' => q({0} ಗ),
					},
					'year' => {
						'name' => q(ವರ್ಷಗಳು),
						'one' => q({0} ವರ್ಷ),
						'other' => q({0} ವರ್ಷಗಳು),
						'per' => q({0}/ವ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ಹೌದು|ಹೌ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ಇಲ್ಲ|ಇ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, ಮತ್ತು {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'knda',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> 'Int',
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0ಸಾ',
					'other' => '0ಸಾ',
				},
				'10000' => {
					'one' => '00ಸಾ',
					'other' => '00ಸಾ',
				},
				'100000' => {
					'one' => '000ಸಾ',
					'other' => '000ಸಾ',
				},
				'1000000' => {
					'one' => '0ಮಿ',
					'other' => '0ಮಿ',
				},
				'10000000' => {
					'one' => '00ಮಿ',
					'other' => '00ಮಿ',
				},
				'100000000' => {
					'one' => '000ಮಿ',
					'other' => '000ಮಿ',
				},
				'1000000000' => {
					'one' => '0ಬಿ',
					'other' => '0ಬಿ',
				},
				'10000000000' => {
					'one' => '00ಬಿ',
					'other' => '00ಬಿ',
				},
				'100000000000' => {
					'one' => '000ಬಿ',
					'other' => '000ಬಿ',
				},
				'1000000000000' => {
					'one' => '0ಟ್ರಿ',
					'other' => '0ಟ್ರಿ',
				},
				'10000000000000' => {
					'one' => '00ಟ್ರಿ',
					'other' => '00ಟ್ರಿ',
				},
				'100000000000000' => {
					'one' => '000ಟ್ರಿ',
					'other' => '000ಟ್ರಿ',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ಸಾವಿರ',
					'other' => '0 ಸಾವಿರ',
				},
				'10000' => {
					'one' => '00 ಸಾವಿರ',
					'other' => '00 ಸಾವಿರ',
				},
				'100000' => {
					'one' => '000 ಸಾವಿರ',
					'other' => '000 ಸಾವಿರ',
				},
				'1000000' => {
					'one' => '0 ಮಿಲಿಯನ್',
					'other' => '0 ಮಿಲಿಯನ್',
				},
				'10000000' => {
					'one' => '00 ಮಿಲಿಯನ್',
					'other' => '00 ಮಿಲಿಯನ್',
				},
				'100000000' => {
					'one' => '000 ಮಿಲಿಯನ್',
					'other' => '000 ಮಿಲಿಯನ್',
				},
				'1000000000' => {
					'one' => '0 ಬಿಲಿಯನ್',
					'other' => '0 ಬಿಲಿಯನ್',
				},
				'10000000000' => {
					'one' => '00 ಬಿಲಿಯನ್',
					'other' => '00 ಬಿಲಿಯನ್',
				},
				'100000000000' => {
					'one' => '000 ಬಿಲಿಯನ್',
					'other' => '000 ಬಿಲಿಯನ್',
				},
				'1000000000000' => {
					'one' => '0 ಟ್ರಿಲಿಯನ್‌',
					'other' => '0 ಟ್ರಿಲಿಯನ್‌',
				},
				'10000000000000' => {
					'one' => '00 ಟ್ರಿಲಿಯನ್‌',
					'other' => '00 ಟ್ರಿಲಿಯನ್‌',
				},
				'100000000000000' => {
					'one' => '000 ಟ್ರಿಲಿಯನ್‌',
					'other' => '000 ಟ್ರಿಲಿಯನ್‌',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0ಸಾ',
					'other' => '0ಸಾ',
				},
				'10000' => {
					'one' => '00ಸಾ',
					'other' => '00ಸಾ',
				},
				'100000' => {
					'one' => '000ಸಾ',
					'other' => '000ಸಾ',
				},
				'1000000' => {
					'one' => '0ಮಿ',
					'other' => '0ಮಿ',
				},
				'10000000' => {
					'one' => '00ಮಿ',
					'other' => '00ಮಿ',
				},
				'100000000' => {
					'one' => '000ಮಿ',
					'other' => '000ಮಿ',
				},
				'1000000000' => {
					'one' => '0ಬಿ',
					'other' => '0ಬಿ',
				},
				'10000000000' => {
					'one' => '00ಬಿ',
					'other' => '00ಬಿ',
				},
				'100000000000' => {
					'one' => '000ಬಿ',
					'other' => '000ಬಿ',
				},
				'1000000000000' => {
					'one' => '0ಟ್ರಿ',
					'other' => '0ಟ್ರಿ',
				},
				'10000000000000' => {
					'one' => '00ಟ್ರಿ',
					'other' => '00ಟ್ರಿ',
				},
				'100000000000000' => {
					'one' => '000ಟ್ರಿ',
					'other' => '000ಟ್ರಿ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(ಸಂಯುಕ್ತ ಅರಬ್‌ ಎಮಿರೇಟ್‌‌ಗಳ ದಿರಾಮ್‌‌),
				'one' => q(ಸಂಯುಕ್ತ ಅರಬ್‌ ಎಮಿರೇಟ್‌‌ಗಳ ದಿರಾಮ್‌‌),
				'other' => q(ಸಂಯುಕ್ತ ಅರಬ್‌ ಎಮಿರೇಟ್‌‌ಗಳ ದಿರಾಮ್‌‌‍ಗಳು),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ಅಫ್‌ಘನ್ ಅಫಗಾನಿ),
				'one' => q(ಅಫ್‌ಘನ್ ಅಫಗಾನಿ),
				'other' => q(ಅಫ್‌ಘನ್ ಅಫಗಾನಿಗಳು),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ಅಲ್‌ಬೇನಿಯನ್ ಲೆಕ್),
				'one' => q(ಅಲ್‌ಬೇನಿಯನ್ ಲೆಕ್),
				'other' => q(ಅಲ್‌ಬೇನಿಯನ್ ಲೆಕ್),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ಅರ್ಮೆನಿಯನ್ ಡ್ರಾಮ್),
				'one' => q(ಅರ್ಮೆನಿಯನ್ ಡ್ರಾಮ್),
				'other' => q(ಅರ್‌ಮೇನಿಯನ್ ಡ್ರಾಮ್‌ಗಳು),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(ನೆದರ್ಲೆಂಡ್ಸ್ ಆಂಟಿಲಿಯನ್ ಗಿಲ್ಡರ್),
				'one' => q(ನೆದರ್ಲೆಂಡ್ಸ್ ಆಂಟಿಲಿಯನ್ ಗಿಲ್ಡರ್),
				'other' => q(ನೆದರ್ಲೆಂಡ್ಸ್ ಆಂಟಿಲಿಯನ್ ಗಿಲ್ಡರ್‌ಗಳು),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ಅಂಗೋಲಾದ ಕ್ವಾನ್ಝಾ),
				'one' => q(ಅಂಗೋಲಾದ ಕ್ವಾನ್ಝಾ),
				'other' => q(ಅಂಗೋಲಾದ ಕ್ವಾನ್ಝಾಗಳು),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ಅರ್ಜೆಂಟಿನಾ ಪೆಸೊ),
				'one' => q(ಅರ್ಜೆಂಟಿನಾ ಪೆಸೊ),
				'other' => q(ಅರ್ಜೆಂಟಿನಾ ಪೆಸೊಗಳು),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ಆಸ್ಟ್ರೇಲಿಯನ್ ಡಾಲರ್‌),
				'one' => q(ಆಸ್ಟ್ರೇಲಿಯನ್ ಡಾಲರ್‌),
				'other' => q(ಆಸ್ಟ್ರೇಲಿಯನ್ ಡಾಲರ್‌‌ಗಳು),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(ಅರುಬನ್ ಫ್ಲೊರೀನ್‌‌),
				'one' => q(ಅರುಬನ್ ಫ್ಲೊರೀನ್‌‌),
				'other' => q(ಅರುಬನ್ ಫ್ಲೊರೀನ್‌‌),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(ಅಝರ್‌ಬೈಜಾನಿ ಮನಾತ್),
				'one' => q(ಅಝರ್‌ಬೈಜಾನಿ ಮನಾತ್),
				'other' => q(ಅಝರ್‌ಬೈಜಾನಿ ಮನಾತ್‌ಗಳು),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ಬೋಸ್ನಿಯಾ-ಹರ್ಜ್‌ಗೋವಿನ ಪರಿವರ್ತನೀಯ ಗುರುತು),
				'one' => q(ಬೋಸ್ನಿಯಾ-ಹರ್ಜ್‌ಗೋವಿನ ಪರಿವರ್ತನೀಯ ಗುರುತು),
				'other' => q(ಬೋಸ್ನಿಯಾ-ಹರ್ಜ್‌ಗೋವಿನ ಪರಿವರ್ತನೀಯ ಗುರುತುಗಳು),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ಬರ್ಬಾಡಿಯನ್ ಡಾಲರ್),
				'one' => q(ಬರ್ಬಾಡಿಯನ್ ಡಾಲರ್),
				'other' => q(ಬರ್ಬಾಡಿಯನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ಬಾಂಗ್ಲಾದೇಶದ ಟಾಕಾ),
				'one' => q(ಬಾಂಗ್ಲಾದೇಶದ ಟಾಕಾ),
				'other' => q(ಬಾಂಗ್ಲಾದೇಶದ ಟಾಕಾಗಳು),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ಬಲ್ಗೇರಿಯನ್ ಲೆವ್),
				'one' => q(ಬಲ್ಗೇರಿಯನ್ ಲೆವ್),
				'other' => q(ಬಲ್ಗೇರಿಯನ್ ಲೀವಾ),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ಬಹ್‌‌ರೈನಿ ದಿನಾರ್),
				'one' => q(ಬಹ್‌‌ರೈನಿ ದಿನಾರ್),
				'other' => q(ಬಹ್‌‌ರೈನಿ ದಿನಾರ್‌ಗಳು),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ಬುರುಂದಿಯನ್ ಫ್ರಾಂಕ್),
				'one' => q(ಬುರುಂದಿಯನ್ ಫ್ರಾಂಕ್),
				'other' => q(ಬುರುಂದಿಯನ್ ಫ್ರಾಂಕ್‍ಗಳು),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ಬರ್ಮುಡನ್ ಡಾಲರ್),
				'one' => q(ಬರ್ಮುಡನ್ ಡಾಲರ್),
				'other' => q(ಬರ್ಮುಡನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ಬ್ರೂನಿ ಡಾಲರ್),
				'one' => q(ಬ್ರೂನಿ ಡಾಲರ್),
				'other' => q(ಬ್ರೂನಿ ಡಾಲರ್‌ಗಳು),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ಬೊಲಿವಿಯಾದ ಬೊಲಿವಿಯಾನೊ),
				'one' => q(ಬೊಲಿವಿಯಾದ ಬೊಲಿವಿಯಾನೊ),
				'other' => q(ಬೊಲಿವಿಯಾದ ಬೊಲಿವಿಯಾನೊಗಳು),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ಬ್ರೆಜಿಲಿಯನ್‌ ರಿಯಲ್),
				'one' => q(ಬ್ರೆಜಿಲಿಯನ್‌ ರಿಯಲ್),
				'other' => q(ಬ್ರೆಜಿಲಿಯನ್ ರಿಯಲ್‍ಗಳು),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ಬಹಾಮಿಯನ್ ಡಾಲರ್),
				'one' => q(ಬಹಾಮಿಯನ್ ಡಾಲರ್),
				'other' => q(ಬಹಾಮಿಯನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ಭೂತಾನೀಸ್ ನುಲ್ತರಮ್),
				'one' => q(ಭೂತಾನೀಸ್ ನುಲ್ತರಮ್),
				'other' => q(ಭೂತಾನೀಸ್ ನುಲ್ತರಮ್‌ಗಳು),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ಬೋಟ್ಸ್‌ವಾನನ್ ಪುಲಾ),
				'one' => q(ಬೋಟ್ಸ್‌ವಾನನ್ ಪುಲಾ),
				'other' => q(ಬೋಟ್ಸ್‌ವಾನನ್ ಪುಲಾಗಳು),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ಬೆಲಾರುಸಿಯನ್ ರೂಬಲ್),
				'one' => q(ಬೆಲಾರುಸಿಯನ್ ರೂಬಲ್),
				'other' => q(ಬೆಲಾರುಸಿಯನ್ ರೂಬಲ್‍ಗಳು),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ಬೆಲೀಜ್ ಡಾಲರ್),
				'one' => q(ಬೆಲೀಜ್ ಡಾಲರ್),
				'other' => q(ಬೆಲೀಜ್ ಡಾಲರ್‌‍ಗಳು),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ಕೆನಡಾದ ಡಾಲರ್),
				'one' => q(ಕೆನಡಾದ ಡಾಲರ್),
				'other' => q(ಕೆನಡಾದ ಡಾಲರ್‌ಗಳು),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(ಕಾಂಗೋಲೀಸ್ ಫ್ರಾಂಕ್),
				'one' => q(ಕಾಂಗೋಲೀಸ್ ಫ್ರಾಂಕ್),
				'other' => q(ಕಾಂಗೋಲೀಸ್ ಫ್ರಾಂಕ್‍‌ಗಳು),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ಸ್ವಿಸ್ ಫ್ರಾಂಕ್),
				'one' => q(ಸ್ವಿಸ್ ಫ್ರಾಂಕ್),
				'other' => q(ಸ್ವಿಸ್ ಫ್ರಾಂಕ್‍ಗಳು),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ಚಿಲಿಯ ಪೆಸೊ),
				'one' => q(ಚಿಲಿಯ ಪೆಸೊ),
				'other' => q(ಚಿಲಿಯ ಪೆಸೊಗಳು),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ಚೈನೀಸ್ ಯುವಾನ್),
				'one' => q(ಚೈನೀಸ್ ಯುವಾನ್),
				'other' => q(ಚೈನೀಸ್ ಯುವಾನ್),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(ಕೊಲೊಂಬಿಯೋದ ಪೆಸೊ),
				'one' => q(ಕೊಲೊಂಬಿಯೋದ ಪೆಸೊ),
				'other' => q(ಕೊಲೊಂಬಿಯೋದ ಪೆಸೊಗಳು),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(ಕೋಸ್ಟ ರಿಕನ್ ಕೊಲನ್),
				'one' => q(ಕೋಸ್ಟಾ ರಿಕಾದ ಕೊಲೊನ್‌),
				'other' => q(ಕೋಸ್ಟಾ ರಿಕಾದ ಕೊಲೊನ್‌ಗಳು),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(ಕ್ಯುಬಾದ ಪರಿವರ್ತನೀಯ ಪೆಸೊ),
				'one' => q(ಕ್ಯೂಬಾದ ಪರಿವರ್ತನೀಯ ಪೆಸೊ),
				'other' => q(ಕ್ಯೂಬಾದ ಪರಿವರ್ತನೀಯ ಪೆಸೊಗಳು),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(ಕ್ಯೂಬಾದ ಪೆಸೊ),
				'one' => q(ಕ್ಯೂಬಾದ ಪೆಸೊ),
				'other' => q(ಕ್ಯೂಬಾದ ಪೆಸೊಗಳು),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ಕೇಪ್ ವರ್ಡಿನ್ ಎಸ್‌ಕೂಡೊ),
				'one' => q(ಕೇಪ್ ವರ್ಡಿನ್ ಎಸ್‌ಕೂಡೊ),
				'other' => q(ಕೇಪ್ ವರ್ಡಿನ್ ಎಸ್‌ಕೂಡೊಗಳು),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ಝೆಕ್ ಗಣರಾಜ್ಯ ಕೊರೂನ),
				'one' => q(ಝೆಕ್ ಗಣರಾಜ್ಯ ಕೊರೂನ),
				'other' => q(ಝೆಕ್ ಗಣರಾಜ್ಯ ಕೊರೂನಗಳು),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ಜಿಬೊಟಿಯನ್ ಫ್ರಾಂಕ್),
				'one' => q(ಜಿಬೊಟಿಯನ್ ಫ್ರಾಂಕ್),
				'other' => q(ಜಿಬೊಟಿಯನ್ ಫ್ರಾಂಕ್‍ಗಳು),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ಡ್ಯಾನಿಶ್ ಕ್ರೋನ್),
				'one' => q(ಡ್ಯಾನಿಶ್ ಕ್ರೋನ್),
				'other' => q(ಡ್ಯಾನಿಶ್ ಕ್ರೋನ್),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ಡೊಮಿನಿಕನ್ ಪೆಸೊ),
				'one' => q(ಡೊಮಿನಿಕನ್ ಪೆಸೊ),
				'other' => q(ಡೊಮಿನಿಕನ್ ಪೆಸೊಗಳು),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ಅಲ್ಗೇರಿಯನ್ ದಿನಾರ್),
				'one' => q(ಅಲ್ಗೇರಿಯನ್ ದಿನಾರ್),
				'other' => q(ಅಲ್ಗೇರಿಯನ್ ದಿನಾರ್‌‍ಗಳು),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ಈಜಿಪ್ಷಿಯನ್ ಪೌಂಡ್‍),
				'one' => q(ಈಜಿಪ್ಷಿಯನ್ ಪೌಂಡ್‍),
				'other' => q(ಈಜಿಪ್ಷಿಯನ್ ಪೌಂಡ್‍ಗಳು),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ಎರಿತ್ರಿಯನ್ ನಕ್ಫಾ),
				'one' => q(ಎರಿತ್ರಿಯನ್ ನಕ್ಫಾ),
				'other' => q(ಎರಿತ್ರಿಯನ್ ನಕ್ಫಾಗಳು),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ಇಥಿಯೋಪಿಯನ್ ಬಿರ್),
				'one' => q(ಇಥಿಯೋಪಿಯನ್ ಬಿರ್),
				'other' => q(ಇಥಿಯೋಪಿಯನ್ ಬಿರ್‌ಗಳು),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ಯೂರೊ),
				'one' => q(ಯೂರೊ),
				'other' => q(ಯೂರೊ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ಫಿಜಿಯನ್ ಡಾಲರ್),
				'one' => q(ಫಿಜಿಯನ್ ಡಾಲರ್),
				'other' => q(ಫಿಜಿಯನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಪೌಂಡ್),
				'one' => q(ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಪೌಂಡ್),
				'other' => q(ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಪೌಂಡ್‍ಗಳು),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ಬ್ರಿಟೀಷ್ ಪೌಂಡ್),
				'one' => q(ಬ್ರಿಟೀಷ್ ಪೌಂಡ್ ಸ್ಟೆರ್ಲಿಂಗ್),
				'other' => q(ಬ್ರಿಟೀಷ್ ಪೌಂಡ್‍ಗಳು),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ಜಾರ್ಜಿಯಾದ ಲಾರಿ),
				'one' => q(ಜಾರ್ಜಿಯಾದ ಲಾರಿ),
				'other' => q(ಜಾರ್ಜಿಯಾದ ಲಾರಿ),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ಘಾನಾದ ಸೆದಿ),
				'one' => q(ಘಾನಾದ ಸೆದಿ),
				'other' => q(ಘಾನಾದ ಸೆದಿಗಳು),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ಗಿಬ್ರಾಲ್ಟರ್ ಪೌಂಡ್),
				'one' => q(ಗಿಬ್ರಾಲ್ಟರ್ ಪೌಂಡ್),
				'other' => q(ಗಿಬ್ರಾಲ್ಟರ್ ಪೌಂಡ್‍ಗಳು),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ಗ್ಯಾಂಬಿಯಾದ ದಲಾಸಿ),
				'one' => q(ಗ್ಯಾಂಬಿಯಾದ ದಲಾಸಿ),
				'other' => q(ಗ್ಯಾಂಬಿಯಾದ ದಲಾಸಿಗಳು),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ಗಿನಿಯನ್ ಫ್ರಾಂಕ್),
				'one' => q(ಗಿನಿಯನ್ ಫ್ರಾಂಕ್),
				'other' => q(ಗಿನಿಯನ್ ಫ್ರಾಂಕ್‌ಗಳು),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ಗ್ವಾಟೆಮಾಲಾದ ಕುಯಿಟ್ಸಲ್‌‌),
				'one' => q(ಗ್ವಾಟೆಮಾಲಾದ ಕುಯಿಟ್ಸಲ್‌‌),
				'other' => q(ಗ್ವಾಟೆಮಾಲಾದ ಕುಯಿಟ್ಸಲ್‌‌‍ಗಳು),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ಗುಯಾನೀಸ್‌ ಡಾಲರ್‌),
				'one' => q(ಗುಯಾನೀಸ್‌ ಡಾಲರ್‌),
				'other' => q(ಗುಯಾನೀಸ್‌ ಡಾಲರ್‌‌ಗಳು),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ಹಾಂಗ್ ಕಾಂಗ್ ಡಾಲರ್),
				'one' => q(ಹಾಂಗ್ ಕಾಂಗ್ ಡಾಲರ್),
				'other' => q(ಹಾಂಗ್ ಕಾಂಗ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ಹೊಂಡುರಾನ್‌ ಲೆಂಪಿರಾ),
				'one' => q(ಹೊಂಡುರಾನ್‌ ಲೆಂಪಿರಾ),
				'other' => q(ಹೊಂಡುರಾನ್‌ ಲೆಂಪಿರಾಗಳು),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ಕ್ರೊಯೆಷ್ಯಾದ ಕೂನಾ),
				'one' => q(ಕ್ರೊಯೆಷ್ಯಾದ ಕೂನಾ),
				'other' => q(ಕ್ರೊಯೆಷ್ಯಾದ ಕೂನಾಗಳು),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ಹೈಟಿಯ ಗೋರ್ದೆ),
				'one' => q(ಹೈಟಿಯ ಗೋರ್ದೆ),
				'other' => q(ಹೈಟಿಯ ಗೋರ್ದೆಗಳು),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ಹಂಗೇರಿಯನ್ ಫೋರಿಂಟ್),
				'one' => q(ಹಂಗೇರಿಯನ್ ಫೋರಿಂಟ್),
				'other' => q(ಹಂಗೇರಿಯನ್ ಫೋರಿಂಟ್‍ಗಳು),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ಇಂಡೊನೇಷ್ಯಾ ರುಪೈ),
				'one' => q(ಇಂಡೊನೇಷ್ಯಾ ರುಪೈ),
				'other' => q(ಇಂಡೊನೇಷ್ಯಾ ರುಪೈ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ಇಸ್ರೇಲಿ ನ್ಯೂ ಶೇಖಲ್),
				'one' => q(ಇಸ್ರೇಲಿ ನ್ಯೂ ಶೇಖಲ್),
				'other' => q(ಇಸ್ರೇಲಿ ನ್ಯೂ ಶೇಖಲ್‍ಗಳು),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ಭಾರತೀಯ ರೂಪಾಯಿ),
				'one' => q(ಭಾರತೀಯ ರೂಪಾಯಿ),
				'other' => q(ಭಾರತೀಯ ರೂಪಾಯಿಗಳು),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ಇರಾಖಿಯನ್ ದಿನಾರ್),
				'one' => q(ಇರಾಖಿಯನ್ ದಿನಾರ್),
				'other' => q(ಇರಾಖಿಯನ್ ದಿನಾರ್‌ಗಳು),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ಇರಾನಿಯನ್ ರಿಯಲ್),
				'one' => q(ಇರಾನಿಯನ್ ರಿಯಲ್),
				'other' => q(ಇರಾನಿಯನ್ ರಿಯಲ್‌ಗಳು),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ಐಸ್‌ಲ್ಯಾಂಡಿಕ್ ಕ್ರೋನಾ),
				'one' => q(ಐಸ್‌ಲ್ಯಾಂಡಿಕ್ ಕ್ರೋನಾ),
				'other' => q(ಐಸ್‌ಲ್ಯಾಂಡಿಕ್ ಕ್ರೋನಾ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ಜಮೈಕನ್ ಡಾಲರ್),
				'one' => q(ಜಮೈಕನ್ ಡಾಲರ್),
				'other' => q(ಜಮೈಕನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ಜೋರ್ಡಾನಿಯನ್ ದಿನಾರ್),
				'one' => q(ಜೋರ್ಡಾನಿಯನ್ ದಿನಾರ್),
				'other' => q(ಜೋರ್ಡಾನಿಯನ್ ದಿನಾರ್‌ಗಳು),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ಜಪಾನೀಸ್ ಯೆನ್),
				'one' => q(ಜಪಾನೀಸ್ ಯೆನ್),
				'other' => q(ಜಪಾನೀಸ್ ಯೆನ್),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ಕೆನ್ಯನ್ ಶಿಲ್ಲಿಂಗ್),
				'one' => q(ಕೆನ್ಯನ್ ಶಿಲ್ಲಿಂಗ್),
				'other' => q(ಕೆನ್ಯನ್ ಶಿಲ್ಲಿಂಗ್‍ಗಳು),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ಕಿರ್ಗಿಸ್ತಾನಿ ಸೋಮ್),
				'one' => q(ಕಿರ್ಗಿಸ್ತಾನಿ ಸೋಮ್),
				'other' => q(ಕಿರ್ಗಿಸ್ತಾನಿ ಸೋಮ್),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ಕಾಂಬೋಡಿಯನ್ ರಿಯಲ್),
				'one' => q(ಕಾಂಬೋಡಿಯನ್ ರಿಯಲ್),
				'other' => q(ಕಾಂಬೋಡಿಯನ್ ರಿಯಲ್‍ಗಳು),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ಕೊಮೊರಿಯನ್ ಫ್ರಾಂಕ್),
				'one' => q(ಕೊಮೊರಿಯನ್ ಫ್ರಾಂಕ್),
				'other' => q(ಕೊಮೊರಿಯನ್ ಫ್ರಾಂಕ್‍ಗಳು),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ಉತ್ತರ ಕೊರಿಯನ್ ವೋನ್),
				'one' => q(ಉತ್ತರ ಕೊರಿಯನ್ ವೋನ್),
				'other' => q(ಉತ್ತರ ಕೊರಿಯನ್ ವೋನ್),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ದಕ್ಷಿಣ ಕೊರಿಯನ್ ವೊನ್),
				'one' => q(ದಕ್ಷಿಣ ಕೊರಿಯನ್ ವೊನ್),
				'other' => q(ದಕ್ಷಿಣ ಕೊರಿಯನ್ ವೊನ್),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ಕುವೈತೀ ದಿನಾರ್),
				'one' => q(ಕುವೈತೀ ದಿನಾರ್),
				'other' => q(ಕುವೈತೀ ದಿನಾರ್‌ಗಳು),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ಕೆಮ್ಯಾನ್‌ ಐಲ್ಯಾಂಡ್‌ನ ಡಾಲರ್‌),
				'one' => q(ಕೆಮ್ಯಾನ್‌ ಐಲ್ಯಾಂಡ್‌ನ ಡಾಲರ್‌),
				'other' => q(ಕೆಮ್ಯಾನ್‌ ಐಲ್ಯಾಂಡ್‌ನ ಡಾಲರ್‌‌ಗಳು),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ಕಜಾಕಿಸ್ತಾನಿ ತೆಂಗೆ),
				'one' => q(ಕಜಕಿಸ್ತಾನ್ ತೆಂಗೇ),
				'other' => q(ಕಜಾಕಿಸ್ತಾನಿ ತೆಂಗೆಗಳು),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ಲೋಟಿಯನ್ ಕಿಪ್),
				'one' => q(ಲೋಟಿಯನ್ ಕಿಪ್),
				'other' => q(ಲೋಟಿಯನ್ ಕಿಪ್‍ಗಳು),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ಲೆಬೆನೀಸ್ ಪೌಂಡ್),
				'one' => q(ಲೆಬೆನೀಸ್ ಪೌಂಡ್),
				'other' => q(ಲೆಬೆನೀಸ್ ಪೌಂಡ್‍ಗಳು),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(ಶ್ರೀಲಂಕಾದ ರುಪೀ),
				'one' => q(ಶ್ರೀಲಂಕಾದ ರುಪೀ),
				'other' => q(ಶ್ರೀಲಂಕಾದ ರುಪೀಗಳು),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ಲಿಬೇರಿಯನ್ ಡಾಲರ್),
				'one' => q(ಲಿಬೇರಿಯನ್ ಡಾಲರ್),
				'other' => q(ಲಿಬೇರಿಯನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ಲೆಸೊತೊ ಲೊತಿ),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(ಲಿಥುನಿಯನ್‌ ಲಿತಾಸ್‌),
				'one' => q(ಲಿಥುನಿಯನ್‌ ಲಿತಾಸ್‌),
				'other' => q(ಲಿಥುನಿಯನ್‌ ಲಿತಾಯ್),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ಲ್ಯಾಟ್ವಿಯನ್ ಲ್ಯಾಟ್ಸ್),
				'one' => q(ಲ್ಯಾಟ್ವಿಯನ್ ಲ್ಯಾಟ್ಸ್),
				'other' => q(ಲ್ಯಾಟ್ವಿಯನ್ ಲ್ಯಾಟಿ),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ಲಿಬಿಯಾದ ದಿನಾರ್‌),
				'one' => q(ಲಿಬಿಯಾದ ದಿನಾರ್‌),
				'other' => q(ಲಿಬಿಯಾದ ದಿನಾರ್‌‍ಗಳು),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(ಮೊರೊಕನ್ ದಿರ್‌ಹಮ್),
				'one' => q(ಮೊರೊಕನ್ ದಿರ್‌ಹಮ್),
				'other' => q(ಮೊರೊಕನ್ ದಿರ್‌ಹಮ್‌ಗಳು),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(ಮಲ್ದೋವಾದ ಲೆವೂ),
				'one' => q(ಮಲ್ದೋವಾದ ಲೆವೂ),
				'other' => q(ಮಲ್ದೋವಾದ ಲೆಯ್),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ಮಲಗಾಸಿ ಅರಿಯಾರಿ),
				'one' => q(ಮಲಗಾಸಿ ಅರಿಯಾರಿ),
				'other' => q(ಮಲಗಾಸಿ ಅರಿಯಾರಿಗಳು),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ಮೆಸಡೋನಿಯನ್ ದಿನಾರ್),
				'one' => q(ಮೆಸಡೋನಿಯನ್ ದಿನಾರ್),
				'other' => q(ಮೆಸಡೋನಿಯನ್ ದಿನಾರಿ),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ಮ್ಯಾನ್ಮಾರ್ ಕ್ಯಾಟ್),
				'one' => q(ಮ್ಯಾನ್ಮಾರ್ ಕ್ಯಾಟ್),
				'other' => q(ಮ್ಯಾನ್ಮಾರ್ ಕ್ಯಾಟ್‍ಗಳು),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(ಮಂಗೋಲಿಯಾದ ತುಗ್ರಿಕ್‌‌),
				'one' => q(ಮಂಗೋಲಿಯಾದ ತುಗ್ರಿಕ್‌‌),
				'other' => q(ಮಂಗೋಲಿಯಾದ ತುಗ್ರಿಕ್‌‌‌ಗಳು),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ಮಕ್ಯೂದ ಪಟಕಾ),
				'one' => q(ಮಕ್ಯೂದ ಪಟಕಾ),
				'other' => q(ಮಕ್ಯೂದ ಪಟಕಾಗಳು),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ಮೌರೀಶಿಯನಿಯನ್ ಒಗಿಯ),
				'one' => q(ಮೌರೀಶಿಯನಿಯನ್ ಒಗಿಯ),
				'other' => q(ಮೌರೀಶಿಯನಿಯನ್ ಒಗಿಯಗಳು),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ಮಾರಿಷಿಯನ್ ರುಪಿ),
				'one' => q(ಮಾರಿಷಿಯನ್ ರುಪಿ),
				'other' => q(ಮಾರಿಷಿಯನ್ ರುಪಿಗಳು),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(ಮಾಲ್ಡೀವಿಯನ್ ರುಫಿಯಾ),
				'one' => q(ಮಾಲ್ಡೀವಿಯನ್ ರುಫಿಯಾ),
				'other' => q(ಮಾಲ್ಡೀವಿಯನ್ ರುಫಿಯಾಗಳು),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ಮಲಾವಿಯ ಕ್ವಾಚ),
				'one' => q(ಮಲಾವಿಯ ಕ್ವಾಚ),
				'other' => q(ಮಲಾವಿಯ ಕ್ವಾಚಗಳು),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ಮೆಕ್ಸಿಕೊದ ಪೆಸೊ),
				'one' => q(ಮೆಕ್ಸಿಕೊದ ಪೆಸೊ),
				'other' => q(ಮೆಕ್ಸಿಕೊದ ಪೆಸೊಗಳು),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ಮಲೇಶಿಯನ್ ರಿಂಗಿಟ್ಟ್),
				'one' => q(ಮಲೇಶಿಯನ್ ರಿಂಗಿಟ್ಟ್),
				'other' => q(ಮಲೇಶಿಯನ್ ರಿಂಗಿಟ್ಟ್‌ಗಳು),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(ಮೊಝಾಂಬಿಕನ್ ಮೆಟಿಕಲ್),
				'one' => q(ಮೊಝಾಂಬಿಕನ್ ಮೆಟಿಕಲ್),
				'other' => q(ಮೊಝಾಂಬಿಕನ್ ಮೆಟಿಕಲ್‍ಗಳು),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ನಮೀಬಿಯನ್ ಡಾಲರ್),
				'one' => q(ನಮೀಬಿಯನ್ ಡಾಲರ್),
				'other' => q(ನಮೀಬಿಯನ್ ಡಾಲರ್‌‍ಗಳು),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ನೈಜೀರಿಯಾದ ನೇರಾ),
				'one' => q(ನೈಜೀರಿಯಾದ ನೇರಾ),
				'other' => q(ನೈಜೀರಿಯಾದ ನೇರಾಗಳು),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ನಿಕಾರಗ್ವಾದ ಕರ್ದೊಬಾ),
				'one' => q(ನಿಕಾರಗ್ವಾದ ಕರ್ದೊಬಾ),
				'other' => q(ನಿಕಾರಗ್ವಾದ ಕರ್ದೊಬಾಗಳು),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ನಾರ್ವೇಯ ಕ್ರೋನ್),
				'one' => q(ನಾರ್ವೇಯ ಕ್ರೋನ್),
				'other' => q(ನಾರ್ವೇಯ ಕ್ರೋನರ್),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ನೇಪಾಳದ ರುಪೀ),
				'one' => q(ನೇಪಾಳದ ರುಪೀ),
				'other' => q(ನೇಪಾಳದ ರುಪೀಗಳು),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಡಾಲರ್),
				'one' => q(ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಡಾಲರ್),
				'other' => q(ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ಒಮಾನಿ ರಿಯಲ್),
				'one' => q(ಒಮಾನಿ ರಿಯಲ್),
				'other' => q(ಒಮಾನಿ ರಿಯಲ್‍ಗಳು),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(ಪನಾಮಾನಿಯನ್ ಬಲ್ಬೋವಾ),
				'one' => q(ಪನಾಮಾನಿಯನ್ ಬಲ್ಬೋವಾ),
				'other' => q(ಪನಾಮಾನಿಯನ್ ಬಲ್ಬೋವಾಗಳು),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ಪೆರುವಿಯನ್ ನುಯೆವೊ ಸೊಲ್),
				'one' => q(ಪೆರುವಿಯನ್ ನುಯೆವೊ ಸೊಲ್),
				'other' => q(ಪೆರುವಿಯನ್ ನುಯೆವೊ ಸೊಲ್‍ಗಳು),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(ಪಪುವಾ ನ್ಯೂ ಗಿನಿಯನ್ ಕಿನಾ),
				'one' => q(ಪಪುವಾ ನ್ಯೂ ಗಿನಿಯನ್ ಕಿನಾ),
				'other' => q(ಪಪುವಾ ನ್ಯೂ ಗಿನಿಯನ್ ಕಿನಾ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ಫಿಲಿಪ್ಪೈನ್ ಪೆಸೊ),
				'one' => q(ಫಿಲಿಪ್ಪೈನ್ ಪೆಸೊ),
				'other' => q(ಫಿಲಿಪ್ಪೈನ್ ಪೆಸೊಗಳು),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(ಪಾಕಿಸ್ತಾನದ ರುಪೀ),
				'one' => q(ಪಾಕಿಸ್ತಾನದ ರುಪೀ),
				'other' => q(ಪಾಕಿಸ್ತಾನದ ರುಪೀಗಳು),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ಪೊಲಿಶ್ ಝ್ಲೋಟಿ),
				'one' => q(ಪೊಲಿಶ್ ಝ್ಲೋಟಿ),
				'other' => q(ಪೊಲಿಶ್ ಝ್ಲೋಟಿಗಳು),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(ಪೆರುಗ್ವೇಯ ಗ್ವಾರನೀ),
				'one' => q(ಪೆರುಗ್ವೇಯ ಗ್ವಾರನೀ),
				'other' => q(ಪೆರುಗ್ವೇಯ ಗ್ವಾರನೀಗಳು),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(ಖತಾರಿ ರಿಯಲ್),
				'one' => q(ಖತಾರಿ ರಿಯಲ್),
				'other' => q(ಖತಾರಿ ರಿಯಲ್‍ಗಳು),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ರೊಮೇನಿಯನ್ ಲೆವು),
				'one' => q(ರೊಮೇನಿಯನ್ ಲೆವು),
				'other' => q(ರೊಮೇನಿಯನ್ ಲೆಯ್),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ಸೆರ್ಬಿಯನ್ ದಿನಾರ್),
				'one' => q(ಸೆರ್ಬಿಯನ್ ದಿನಾರ್),
				'other' => q(ಸೆರ್ಬಿಯನ್ ದಿನಾರ್‌ಗಳು),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ರಶಿಯನ್ ರೂಬಲ್),
				'one' => q(ರಶಿಯನ್ ರೂಬಲ್),
				'other' => q(ರಶಿಯನ್ ರೂಬಲ್‍ಗಳು),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ರುವಾಂಡನ್ ಫ್ರಾಂಕ್),
				'one' => q(ರುವಾಂಡನ್ ಫ್ರಾಂಕ್),
				'other' => q(ರುವಾಂಡನ್ ಫ್ರಾಂಕ್‍ಗಳು),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ಸೌದಿ ರಿಯಾಲ್),
				'one' => q(ಸೌದಿ ರಿಯಾಲ್),
				'other' => q(ಸೌದಿ ರಿಯಾಲ್‍ಗಳು),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ಸೊಲೊಮನ್ ದ್ವೀಪಗಳ ಡಾಲರ್),
				'one' => q(ಸೊಲೊಮನ್ ದ್ವೀಪಗಳ ಡಾಲರ್),
				'other' => q(ಸೊಲೊಮನ್ ದ್ವೀಪಗಳ ಡಾಲರ್‌ಗಳು),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ಸೆಚೊಲಿಯೊಸ್ ರುಪಿ),
				'one' => q(ಸೆಚೊಲಿಯೊಸ್ ರುಪಿ),
				'other' => q(ಸೆಚೊಲಿಯೊಸ್ ರುಪಿಗಳು),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(ಸುಡಾನೀಸ್ ಪೌಂಡ್),
				'one' => q(ಸುಡಾನೀಸ್ ಪೌಂಡ್),
				'other' => q(ಸೂಡಾನೀಸ್ ಪೌಂಡ್),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ಸ್ವೀಡಿಷ್ ಕ್ರೋನಾ),
				'one' => q(ಸ್ವೀಡಿಷ್ ಕ್ರೋನಾ),
				'other' => q(ಸ್ವೀಡಿಶ್ ಕ್ರೋನರ್),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(ಸಿಂಗಾಪುರ್ ಡಾಲರ್‌),
				'one' => q(ಸಿಂಗಾಪುರ್ ಡಾಲರ್‌),
				'other' => q(ಸಿಂಗಾಪುರ್ ಡಾಲರ್‌‌ಗಳು),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ಸೇಂಟ್ ಹೆಲೇನಾ ಪೌಂಡ್),
				'one' => q(ಸೇಂಟ್ ಹೆಲೇನಾ ಪೌಂಡ್),
				'other' => q(ಸೇಂಟ್ ಹೆಲೇನಾ ಪೌಂಡ್),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ಸಿಯೆರಾ ಲಿಯೋನಿಯನ್ ಲಿಯೋನ್),
				'one' => q(ಸಿಯೆರಾ ಲಿಯೋನಿಯನ್ ಲಿಯೋನ್),
				'other' => q(ಸಿಯೆರಾ ಲಿಯೋನಿಯನ್ ಲಿಯೋನ್‌ಗಳು),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ಸೊಮಾಲಿ ಶಿಲ್ಲಿಂಗ್),
				'one' => q(ಸೊಮಾಲಿ ಶಿಲ್ಲಿಂಗ್),
				'other' => q(ಸೊಮಾಲಿ ಶಿಲ್ಲಿಂಗ್‍ಗಳು),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ಸುರಿನಾಮೀಸ್ ಡಾಲರ್),
				'one' => q(ಸುರಿನಾಮೀಸ್ ಡಾಲರ್),
				'other' => q(ಸುರಿನಾಮೀಸ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(ದಕ್ಷಿಣ ಸೂಡಾನೀಸ್ ಪೌಂಡ್‍),
				'one' => q(ದಕ್ಷಿಣ ಸೂಡಾನೀಸ್ ಪೌಂಡ್‍),
				'other' => q(ದಕ್ಷಿಣ ಸೂಡಾನೀಸ್ ಪೌಂಡ್‍‍ಗಳು),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ಸಾವೊ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪ್ ದೊಬ್ರಾ),
				'one' => q(ಸಾವೊ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪ್ ದೊಬ್ರಾ),
				'other' => q(ಸಾವೊ ಟೋಮ್ ಮತ್ತು ಪ್ರಿನ್ಸಿಪ್ ದೊಬ್ರಾಗಳು),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(ಸಿರಿಯನ್ ಪೌಂಡ್),
				'one' => q(ಸಿರಿಯನ್ ಪೌಂಡ್),
				'other' => q(ಸಿರಿಯನ್ ಪೌಂಡ್‌ಗಳು),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ಸ್ವಾಜಿ ಲಿಲಂಗೆನಿ),
				'one' => q(ಸ್ವಾಜಿ ಲಿಲಂಗೆನಿ),
				'other' => q(ಸ್ವಾಜಿ ಎಮಲಂಗೆನಿ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ಥಾಯ್ ಬಹ್ತ್),
				'one' => q(ಥಾಯ್ ಬಹ್ತ್),
				'other' => q(ಥಾಯ್ ಬಹ್ತ್),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ತಜಕಿಸ್ತಾನಿ ಸೊಮೋನಿ),
				'one' => q(ತಜಕಿಸ್ತಾನಿ ಸೊಮೋನಿ),
				'other' => q(ತಜಕಿಸ್ತಾನಿ ಸೊಮೋನಿಗಳು),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ಟರ್ಕ್‍ಮೆನಿಸ್ತಾನ್ ಮನಾತ್),
				'one' => q(ಟರ್ಕ್‍ಮೆನಿಸ್ತಾನ್ ಮನಾತ್),
				'other' => q(ಟರ್ಕ್‍ಮೆನಿಸ್ತಾನ್ ಮನಾತ್),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ತುನೀಸಿಯನ್ ದಿನಾರ್),
				'one' => q(ತುನೀಸಿಯನ್ ದಿನಾರ್),
				'other' => q(ತುನೀಸಿಯನ್ ದಿನಾರ್‌ಗಳು),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ಟೊಂಗಾ ಪಾಂಗ),
				'one' => q(ಟೊಂಗಾ ಪಾಂಗ),
				'other' => q(ಟೊಂಗಾ ಪಾಂಗ),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ಟರ್ಕಿಶ್ ಲಿರಾ),
				'one' => q(ಟರ್ಕಿಶ್ ಲಿರಾ),
				'other' => q(ಟರ್ಕಿಶ್ ಲಿರಾ),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ ಡಾಲರ್),
				'one' => q(ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ ಡಾಲರ್),
				'other' => q(ಟ್ರಿನಿಡಾಡ್ ಮತ್ತು ಟೊಬಾಗೊ ಡಾಲರ್‌ಗಳು),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ನ್ಯೂ ತೈವಾನ್ ಡಾಲರ್),
				'one' => q(ನ್ಯೂ ತೈವಾನ್ ಡಾಲರ್),
				'other' => q(ನ್ಯೂ ತೈವಾನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ತಾನ್‌ಜೇನಿಯನ್ ಶಿಲ್ಲಿಂಗ್),
				'one' => q(ತಾನ್‌ಜೇನಿಯನ್ ಶಿಲ್ಲಿಂಗ್),
				'other' => q(ತಾನ್‌ಜೇನಿಯನ್ ಶಿಲ್ಲಿಂಗ್‍ಗಳು),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ಉಕ್ರೇನಿಯನ್ ಹ್ರಿವ್ನೀಯ),
				'one' => q(ಉಕ್ರೇನಿಯನ್ ಹ್ರಿವ್ನೀಯ),
				'other' => q(ಉಕ್ರೇನಿಯನ್ ಹ್ರಿವ್ನೀಯಗಳು),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ಉಗಾಂಡನ್ ಶಿಲ್ಲಿಂಗ್),
				'one' => q(ಉಗಾಂಡನ್ ಶಿಲ್ಲಿಂಗ್),
				'other' => q(ಉಗಾಂಡನ್ ಶಿಲ್ಲಿಂಗ್‍ಗಳು),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(ಅಮೆರಿಕದ ಡಾಲರ್‌),
				'one' => q(ಅಮೆರಿಕದ ಡಾಲರ್‌),
				'other' => q(ಅಮೆರಿಕದ ಡಾಲರ್‌‌ಗಳು),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ಉರುಗ್ವೆಯ ಪೆಸೊ),
				'one' => q(ಉರುಗ್ವೆಯ ಪೆಸೊ),
				'other' => q(ಉರುಗ್ವೆಯ ಪೆಸೊಗಳು),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಸೊಮ್),
				'one' => q(ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಸೊಮ್),
				'other' => q(ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಸೊಮ್),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ವೆನಿಜುಲಿಯನ್ ಬೊಲಿವರ್),
				'one' => q(ವೆನಿಜುಲಿಯನ್ ಬೊಲಿವರ್),
				'other' => q(ವೆನಿಜುಲಿಯನ್ ಬೊಲಿವರ್‌ಗಳು),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ವಿಯೆಟ್ನಾಮೀಸ್ ಡಾಂಗ್),
				'one' => q(ವಿಯೆಟ್ನಾಮೀಸ್ ಡಾಂಗ್),
				'other' => q(ವಿಯೆಟ್ನಾಮೀಸ್ ಡಾಂಗ್),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ವನೂತು ವತು),
				'one' => q(ವನೂತು ವತು),
				'other' => q(ವನೂತು ವತುಗಳು),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ಸಮೋನ್ ತಲಾ),
				'one' => q(ಸಮೋನ್ ತಲಾ),
				'other' => q(ಸಮೋನ್ ತಲಾ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA ಫ್ರಾಂಕ್ BEAC),
				'one' => q(CFA ಫ್ರಾಂಕ್ BEAC),
				'other' => q(CFA ಫ್ರಾಂಕ್ BEAC),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ಪೂರ್ವ ಕೆರೀಬಿಯನ್ ಡಾಲರ್),
				'one' => q(ಪೂರ್ವ ಕೆರೀಬಿಯನ್ ಡಾಲರ್),
				'other' => q(ಪೂರ್ವ ಕೆರೀಬಿಯನ್ ಡಾಲರ್‌ಗಳು),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(CFA ಫ್ರಾಂಕ್ BCEAO),
				'one' => q(ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾದ [CFA] ಫ್ರಾಂಕ್‌),
				'other' => q(CFA ಫ್ರಾಂಕ್ BCEAO),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q([CFP] ಫ್ರಾಂಕ್),
				'one' => q(CFP ಫ್ರಾಂಕ್),
				'other' => q(CFP ಫ್ರಾಂಕ್),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ಗೊತ್ತಿಲ್ಲದ ಕರೆನ್ಸಿ),
				'one' => q(ಗೊತ್ತಿಲ್ಲದ ಕರೆನ್ಸಿ),
				'other' => q(ಗೊತ್ತಿಲ್ಲದ ಕರೆನ್ಸಿ),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ಯೆಮೆನಿ ರಿಯಲ್),
				'one' => q(ಯೆಮೆನಿ ರಿಯಲ್),
				'other' => q(ಯೆಮೆನಿ ರಿಯಲ್‍ಗಳು),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(ದಕ್ಷಿಣ ಆಫ್ರಿಕನ್ ರಾಂಡ್),
				'one' => q(ದಕ್ಷಿಣ ಆಫ್ರಿಕನ್ ರಾಂಡ್),
				'other' => q(ದಕ್ಷಿಣ ಆಫ್ರಿಕನ್ ರಾಂಡ್),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ಜಾಂಬಿಯಾ ಕ್ವಾಚ \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ಜಾಂಬಿಯಾ ಕ್ವಾಚ),
				'one' => q(ಜಾಂಬಿಯಾ ಕ್ವಾಚ),
				'other' => q(ಜಾಂಬಿಯಾ ಕ್ವಾಚಗಳು),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ಜನ',
							'ಫೆಬ್ರ',
							'ಮಾರ್ಚ್',
							'ಏಪ್ರಿ',
							'ಮೇ',
							'ಜೂನ್',
							'ಜುಲೈ',
							'ಆಗ',
							'ಸೆಪ್ಟೆಂ',
							'ಅಕ್ಟೋ',
							'ನವೆಂ',
							'ಡಿಸೆಂ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ಜ',
							'ಫೆ',
							'ಮಾ',
							'ಏ',
							'ಮೇ',
							'ಜೂ',
							'ಜು',
							'ಆ',
							'ಸೆ',
							'ಅ',
							'ನ',
							'ಡಿ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ಜನವರಿ',
							'ಫೆಬ್ರವರಿ',
							'ಮಾರ್ಚ್',
							'ಏಪ್ರಿಲ್',
							'ಮೇ',
							'ಜೂನ್',
							'ಜುಲೈ',
							'ಆಗಸ್ಟ್',
							'ಸೆಪ್ಟೆಂಬರ್',
							'ಅಕ್ಟೋಬರ್',
							'ನವೆಂಬರ್',
							'ಡಿಸೆಂಬರ್'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ಜನ',
							'ಫೆಬ್ರ',
							'ಮಾರ್ಚ್',
							'ಏಪ್ರಿ',
							'ಮೇ',
							'ಜೂನ್',
							'ಜುಲೈ',
							'ಆಗ',
							'ಸೆಪ್ಟೆಂ',
							'ಅಕ್ಟೋ',
							'ನವೆಂ',
							'ಡಿಸೆಂ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ಜ',
							'ಫೆ',
							'ಮಾ',
							'ಏ',
							'ಮೇ',
							'ಜೂ',
							'ಜು',
							'ಆ',
							'ಸೆ',
							'ಅ',
							'ನ',
							'ಡಿ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ಜನವರಿ',
							'ಫೆಬ್ರವರಿ',
							'ಮಾರ್ಚ್',
							'ಏಪ್ರಿಲ್',
							'ಮೇ',
							'ಜೂನ್',
							'ಜುಲೈ',
							'ಆಗಸ್ಟ್',
							'ಸೆಪ್ಟೆಂಬರ್',
							'ಅಕ್ಟೋಬರ್',
							'ನವೆಂಬರ್',
							'ಡಿಸೆಂಬರ್'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ಸೋಮ',
						tue => 'ಮಂಗಳ',
						wed => 'ಬುಧ',
						thu => 'ಗುರು',
						fri => 'ಶುಕ್ರ',
						sat => 'ಶನಿ',
						sun => 'ಭಾನು'
					},
					narrow => {
						mon => 'ಸೋ',
						tue => 'ಮಂ',
						wed => 'ಬು',
						thu => 'ಗು',
						fri => 'ಶು',
						sat => 'ಶ',
						sun => 'ಭಾ'
					},
					short => {
						mon => 'ಸೋಮ',
						tue => 'ಮಂಗಳ',
						wed => 'ಬುಧ',
						thu => 'ಗುರು',
						fri => 'ಶುಕ್ರ',
						sat => 'ಶನಿ',
						sun => 'ಭಾನು'
					},
					wide => {
						mon => 'ಸೋಮವಾರ',
						tue => 'ಮಂಗಳವಾರ',
						wed => 'ಬುಧವಾರ',
						thu => 'ಗುರುವಾರ',
						fri => 'ಶುಕ್ರವಾರ',
						sat => 'ಶನಿವಾರ',
						sun => 'ಭಾನುವಾರ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ಸೋಮ',
						tue => 'ಮಂಗಳ',
						wed => 'ಬುಧ',
						thu => 'ಗುರು',
						fri => 'ಶುಕ್ರ',
						sat => 'ಶನಿ',
						sun => 'ಭಾನು'
					},
					narrow => {
						mon => 'ಸೋ',
						tue => 'ಮಂ',
						wed => 'ಬು',
						thu => 'ಗು',
						fri => 'ಶು',
						sat => 'ಶ',
						sun => 'ಭಾ'
					},
					short => {
						mon => 'ಸೋಮ',
						tue => 'ಮಂಗಳ',
						wed => 'ಬುಧ',
						thu => 'ಗುರು',
						fri => 'ಶುಕ್ರ',
						sat => 'ಶನಿ',
						sun => 'ಭಾನು'
					},
					wide => {
						mon => 'ಸೋಮವಾರ',
						tue => 'ಮಂಗಳವಾರ',
						wed => 'ಬುಧವಾರ',
						thu => 'ಗುರುವಾರ',
						fri => 'ಶುಕ್ರವಾರ',
						sat => 'ಶನಿವಾರ',
						sun => 'ಭಾನುವಾರ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ತ್ರೈ 1',
						1 => 'ತ್ರೈ 2',
						2 => 'ತ್ರೈ 3',
						3 => 'ತ್ರೈ 4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1ನೇ ತ್ರೈಮಾಸಿಕ',
						1 => '2ನೇ ತ್ರೈಮಾಸಿಕ',
						2 => '3ನೇ ತ್ರೈಮಾಸಿಕ',
						3 => '4ನೇ ತ್ರೈಮಾಸಿಕ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ತ್ರೈ 1',
						1 => 'ತ್ರೈ 2',
						2 => 'ತ್ರೈ 3',
						3 => 'ತ್ರೈ 4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1ನೇ ತ್ರೈಮಾಸಿಕ',
						1 => '2ನೇ ತ್ರೈಮಾಸಿಕ',
						2 => '3ನೇ ತ್ರೈಮಾಸಿಕ',
						3 => '4ನೇ ತ್ರೈಮಾಸಿಕ'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'midnight' if $time == 0;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
				}
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
				}
				last SWITCH;
				}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'night1' => q{ರಾತ್ರಿ},
					'afternoon1' => q{ಮಧ್ಯಾಹ್ನ},
					'evening1' => q{ಸಂಜೆ},
					'midnight' => q{ಮಧ್ಯ ರಾತ್ರಿ},
					'morning1' => q{ಬೆಳಗ್ಗೆ},
					'pm' => q{ಅಪರಾಹ್ನ},
					'am' => q{ಪೂರ್ವಾಹ್ನ},
				},
				'narrow' => {
					'morning1' => q{ಬೆಳಗ್ಗೆ},
					'midnight' => q{ಮಧ್ಯರಾತ್ರಿ},
					'evening1' => q{ಸಂಜೆ},
					'afternoon1' => q{ಮಧ್ಯಾಹ್ನ},
					'night1' => q{ರಾತ್ರಿ},
					'am' => q{ಪೂ},
					'pm' => q{ಅ},
				},
				'abbreviated' => {
					'pm' => q{PM},
					'am' => q{AM},
					'evening1' => q{ಸಂಜೆ},
					'afternoon1' => q{ಮಧ್ಯಾಹ್ನ},
					'midnight' => q{ಮಧ್ಯ ರಾತ್ರಿ},
					'night1' => q{ರಾತ್ರಿ},
					'morning1' => q{ಬೆಳಗ್ಗೆ},
				},
			},
			'stand-alone' => {
				'wide' => {
					'morning1' => q{ಬೆಳಗ್ಗೆ},
					'night1' => q{ರಾತ್ರಿ},
					'afternoon1' => q{ಮಧ್ಯಾಹ್ನ},
					'evening1' => q{ಸಂಜೆ},
					'midnight' => q{ಮಧ್ಯರಾತ್ರಿ},
					'pm' => q{ಅಪರಾಹ್ನ},
					'am' => q{ಪೂರ್ವಾಹ್ನ},
				},
				'narrow' => {
					'morning1' => q{ಬೆಳಗ್ಗೆ},
					'night1' => q{ರಾತ್ರಿ},
					'afternoon1' => q{ಮಧ್ಯಾಹ್ನ},
					'evening1' => q{ಸಂಜೆ},
					'midnight' => q{ಮಧ್ಯರಾತ್ರಿ},
					'pm' => q{PM},
					'am' => q{AM},
				},
				'abbreviated' => {
					'am' => q{AM},
					'pm' => q{PM},
					'morning1' => q{ಬೆಳಗ್ಗೆ},
					'night1' => q{ರಾತ್ರಿ},
					'evening1' => q{ಸಂಜೆ},
					'midnight' => q{ಮಧ್ಯರಾತ್ರಿ},
					'afternoon1' => q{ಮಧ್ಯಾಹ್ನ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ಕ್ರಿ.ಪೂ',
				'1' => 'ಕ್ರಿ.ಶ'
			},
			wide => {
				'0' => 'ಕ್ರಿಸ್ತ ಪೂರ್ವ',
				'1' => 'ಕ್ರಿಸ್ತ ಶಕ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y MMMM d, EEEE},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{EEEE, MMMM d, y},
			'long' => q{MMMM d, y},
			'medium' => q{MMM d, y},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{hh:mm:ss a zzzz},
			'long' => q{hh:mm:ss a z},
			'medium' => q{hh:mm:ss a},
			'short' => q{hh:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}ದಲ್ಲಿ},
			'long' => q{{1} {0}ದಲ್ಲಿ},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			E => q{ccc},
			Ed => q{d E},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{GGGGG y-MM-dd, E},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{GGGGG y-MM-dd},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{d/M, E},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{MMM d},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, M/d/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, MMM d, y},
			yMMMM => q{MMMM y},
			yMMMd => q{MMM d,y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{d/M, E – d/M, E},
				d => q{d/M, E – d/M, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d –d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{d/M/y, E – d/M/y G},
				d => q{GGGGG y-MM-dd, E – y-MM-dd, E},
				y => q{d/M/y, E – d/M/y, E G},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – MMM d, E},
				d => q{G y MMM d, E – MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM–MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d–d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, M/d – E, M/d},
				d => q{E, M/d – E, M/d},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{MMM d, E – MMM d, E},
				d => q{MMM d, E – MMM d, E},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, M/d/y – E, M/d/y},
				d => q{d/M/y,E – d/M/y,E,},
				y => q{E, M/d/y – E, M/d/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, MMM d – E, MMMM d, y},
				d => q{E, MMM d – E, MMM d,y},
				y => q{d MMM, y E – d MMM, y E},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{MMM d–d,y},
				y => q{d, MMM, y – d, MMM, y},
			},
			yMd => {
				M => q{M/d/y – M/d/y},
				d => q{M/d/y – M/d/y},
				y => q{M/d/y – M/d/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} ಸಮಯ),
		regionFormat => q({0} (+1) ದಿನದ ಸಮಯ),
		regionFormat => q({0} (+0) ಪ್ರಮಾಣಿತ ಸಮಯ),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(ಏಕರ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಏಕರ್ ಸಮಯ),
				'standard' => q(ಏಕರ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(ಅಫಘಾನಿಸ್ತಾನ ಸಮಯ),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ಅಬಿದ್‌ಜನ್#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ಅಕ್ರಾ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ಆಡಿಸ್ ಅಬಾಬಾ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ಅಲ್ಗೀರ್ಸ್#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ಅಸ್ಮಾರಾ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ಬಮಾಕೊ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ಬಾಂಗಿ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ಬಂಜುಲ್#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ಬಿಸ್ಸಾವ್#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ಬ್ಲ್ಯಾಂಟೈರ್#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ಬ್ರೆಜಾವೀಲ್#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ಬುಜುಂಬುರಾ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ಕೈರೋ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ಕ್ಯಾಸಾಬ್ಲಾಂಕಾ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ಸೆಯುಟಾ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ಕೊನಾಕ್ರಿ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ಡಾಕರ್#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ಡಾರ್ ಎಸ್ ಸಲಾಮ್#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ಡಿಬೌಟಿ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ದೌಲಾ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ಎಲ್ ಔನ್#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ಫ್ರೀಟೌನ್#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ಗ್ಯಾಬರೋನೆ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ಹರಾರೆ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ಜೋಹನ್ಸ್‌ಬರ್ಗ್#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ಜುಬಾ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ಕಂಪಾಲಾ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ಖರ್ಟೋಮ್#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ಕಿಗಾಲಿ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ಕಿನ್ಷಾಸಾ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ಲಾಗೋಸ್#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ಲಿಬ್ರೆವೀಲ್#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ಲೋಮ್#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ಲುವಾಂಡಾ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ಲುಬುಂಬಾಶಿ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ಲುಸಾಕಾ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ಮಲಾಬೋ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ಮ್ಯಾಪುಟೊ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ಮಸೇರು#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ಅಂಬಬಾನೆ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ಮೊಗಾದಿಶು#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ಮೊನ್ರೋವಿಯಾ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ನೈರೋಬಿ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ಡ್ಜಮೇನಾ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ನಿಯಾಮೆ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ನೌಕ್‌ಚೋಟ್ಟ್#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ಔಗಾಡೋಗು#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ಪೋರ್ಟೋ-ನೋವೋ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ಸಾವ್ ಟೊಮಿ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ಟ್ರೈಪೋಲಿ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ಟುನೀಸ್#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ವಿಂಡ್ಹೋಕ್#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(ಮಧ್ಯ ಆಫ್ರಿಕಾ ಸಮಯ),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(ಪೂರ್ವ ಆಫ್ರಿಕಾ ಸಮಯ),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(ದಕ್ಷಿಣ ಆಫ್ರಿಕಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ ಸಮಯ),
				'standard' => q(ಪಶ್ಚಿಮ ಆಫ್ರಿಕಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(‌ಅಲಾಸ್ಕಾ ಹಗಲು ಸಮಯ),
				'generic' => q(ಅಲಾಸ್ಕಾ ಸಮಯ),
				'standard' => q(ಅಲಸ್ಕಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(ಆಲ್ಮೇಟಿ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಆಲ್ಮೇಟಿ ಸಮಯ),
				'standard' => q(ಆಲ್ಮೇಟಿ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(ಅಮೆಜಾನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅಮೆಜಾನ್ ಸಮಯ),
				'standard' => q(ಅಮೆಜಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'America/Adak' => {
			exemplarCity => q#ಅಡಕ್‌‌#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ಆಂಕರೋಜ್#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ಅಂಗುಲ್ಲಾ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ಆಂಟಿಗುವಾ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ಅರಾಗುಯಾನಾ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ಲಾ ರಿಯೋಜಾ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ರಿಯೋ ಗಲ್ಲೆಗೊಸ್#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ಸಾಲ್ಟಾ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ಸ್ಯಾನ್ ಜುವಾನ್#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ಸ್ಯಾನ್ ಲೂಯೀಸ್#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ಟುಕುಮಾನ್#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ಉಶ್ವಾಯ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ಅರುಬಾ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ಅಸುನ್ಸಿಯಾನ್#,
		},
		'America/Bahia' => {
			exemplarCity => q#ಬಹೀಯಾ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ಬಾಹಿಯಾ ಬಂಡೇರಾಸ್#,
		},
		'America/Barbados' => {
			exemplarCity => q#ಬಾರ್ಬಡೋಸ್#,
		},
		'America/Belem' => {
			exemplarCity => q#ಬೇಲೆಂ#,
		},
		'America/Belize' => {
			exemplarCity => q#ಬೆಲೀಜ್#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ಬ್ಲಾಂಕ್-ಸಾಬ್ಲನ್#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ಬೋವಾ ವಿಸ್ಟ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ಬೊಗೋಟ#,
		},
		'America/Boise' => {
			exemplarCity => q#ಬ್ವಾಸಿ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ಬ್ಯೂನಸ್ ಐರಿಸ್#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ಕೇಮ್‌ಬ್ರಿಡ್ಜ್ ಬೇ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ಕಾಂಪೊ ಗ್ರಾಂಡೆ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ಕ್ಯಾಂಕನ್#,
		},
		'America/Caracas' => {
			exemplarCity => q#ಕ್ಯಾರಕಾಸ್#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ಕಟಮಾರ್ಕ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ಕೆಯೆನಿ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ಕೇಮನ್#,
		},
		'America/Chicago' => {
			exemplarCity => q#ಶಿಕಾಗೋ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ಚಿವಾವ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ಅಟಿಕೊಕಾನ್#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ಕೊರ್ಡೊಬಾ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ಕೋಸ್ಟಾ ರಿಕಾ#,
		},
		'America/Creston' => {
			exemplarCity => q#ಕ್ರೆಸ್ಟನ್#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ಕ್ಯೂಇಬಾ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ಕುರಾಕಾವ್#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ಡನ್‌ಮಾರ್ಕ್‌ಶ್ವಾನ್#,
		},
		'America/Dawson' => {
			exemplarCity => q#ಡಾಸನ್#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ಡಾಸನ್ ಕ್ರೀಕ್#,
		},
		'America/Denver' => {
			exemplarCity => q#ಡೆನ್ವರ್#,
		},
		'America/Detroit' => {
			exemplarCity => q#ಡೆಟ್ರಾಯ್ಟ್#,
		},
		'America/Dominica' => {
			exemplarCity => q#ಡೊಮಿನಿಕಾ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ಎಡ್ಮಂಟನ್‌#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ಇರುನಿಪೆ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ಎಲ್ ಸಾಲ್ವಡೋರ್#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ಫೊರ್ಟಲೆಜಾ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ಗ್ಲೇಸ್ ಬೇ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ನೂಕ್#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ಗೂಸ್ ಬೇ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ಗ್ರ್ಯಾಂಡ್ ಟರ್ಕ್#,
		},
		'America/Grenada' => {
			exemplarCity => q#ಗ್ರೆನಾಡ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ಗ್ವಾಡೆಲೋಪ್#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ಗ್ವಾಟೆಮಾಲಾ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ಗುಯಾಕ್ವಿಲ್#,
		},
		'America/Guyana' => {
			exemplarCity => q#ಗಯಾನಾ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ಹ್ಯಾಲಿಫೆಕ್ಸ್#,
		},
		'America/Havana' => {
			exemplarCity => q#ಹವಾನಾ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ಹರ್ಮೊಸಿಲ್ಲೋ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ನಾಕ್ಸ್, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ಮರೆಂಗೊ, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ಪೀಟರ್ಸ್‌ಬರ್ಗ್, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ಟೆಲ್ ಸಿಟಿ, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ವೇವಾಯ್, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ವಿನ್‌ಸೆನ್ನೀಸ್, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ವಿನಾಮ್ಯಾಕ್, ಇಂಡಿಯಾನಾ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ಇಂಡಿಯಾನಾಪೊಲಿಸ್#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ಇನುವಿಕ್#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ಈಕ್ವಾಲಿಟ್#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ಜಮೈಕಾ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ಜುಜೈ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ಜುನೇವ್#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ಮೊಂಟಿಸೆಲ್ಲೋ, ಕೆಂಟುಕಿ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ಕ್ರೆಲೆಂಡಿಜ್ಕ್#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ಲಾ ಪೆಜ್#,
		},
		'America/Lima' => {
			exemplarCity => q#ಲಿಮಾ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ಲಾಸ್ ಏಂಜಲೀಸ್#,
		},
		'America/Louisville' => {
			exemplarCity => q#ಲೂಯೀಸ್‌ವಿಲ್ಲೆ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ಲೋವರ್ ಪ್ರಿನ್ಸಸ್ ಕ್ವಾರ್ಟರ್#,
		},
		'America/Maceio' => {
			exemplarCity => q#ಮೆಸೀಯೊ#,
		},
		'America/Managua' => {
			exemplarCity => q#ಮನಾಗುವಾ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ಮನಾವ್ಸ್#,
		},
		'America/Marigot' => {
			exemplarCity => q#ಮರಿಗೊ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ಮಾರ್ಟಿನಿಕ್#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ಮಟಾಮೋರಸ್#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ಮಜಟ್ಲಾನ್#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ಮೆಂಡೊಜಾ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ಮೆನೊಮಿನೀ#,
		},
		'America/Merida' => {
			exemplarCity => q#ಮೆರಿದಾ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ಮೆಟ್ಲಾಕಾಟ್ಲಾ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ಮೆಕ್ಸಿಕೋ ನಗರ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ಮಿಕೆಲಾನ್#,
		},
		'America/Moncton' => {
			exemplarCity => q#ಮಾಂಕ್ಟನ್#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ಮಾಂಟೆರ್ರಿ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ಮಾಂಟಿವೀಡಿಯೊ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ಮಾಂಟ್‌ಸೆರೇಟ್#,
		},
		'America/Nassau' => {
			exemplarCity => q#ನಸ್ಸೌವ್#,
		},
		'America/New_York' => {
			exemplarCity => q#ನ್ಯೂಯಾರ್ಕ್#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ನಿಪಿಗನ್#,
		},
		'America/Nome' => {
			exemplarCity => q#ನೋಮ್#,
		},
		'America/Noronha' => {
			exemplarCity => q#ನೊರೊನ್ಹಾ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ಬ್ಯೂಲಾ, ಉತ್ತರ ಡಕೊಟ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ಸೆಂಟರ್, ಉತ್ತರ ಡಕೊಟ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ನ್ಯೂ ಸಲೇಂ, ಉತ್ತರ ಡಕೊಟ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ಓಜಿನಾಗಾ#,
		},
		'America/Panama' => {
			exemplarCity => q#ಪನಾಮಾ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ಪಂಗ್ನೀರ್‌ಟಂಗ್#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ಪರಮಾರಿಬೋ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ಫಿನಿಕ್ಸ್#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ಪೋರ್ಟ್-ಒ-ಪ್ರಿನ್ಸ್#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ಪೋರ್ಟ್ ಆಫ್ ಸ್ಪೇನ್#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ಪೋರ್ಟೊ ವೆಲ್ಹೋ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ಪ್ಯುರ್ಟೋ ರಿಕೊ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ರೈನಿ ರಿವರ್#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ರಾಂಕಿನ್ ಇನ್‌ಲೆಟ್#,
		},
		'America/Recife' => {
			exemplarCity => q#ರೆಸಿಫಿ#,
		},
		'America/Regina' => {
			exemplarCity => q#ರೆಜಿನಾ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ರೆಸೊಲ್ಯೂಟ್#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ರಿಯೋ ಬ್ರ್ಯಾಂಕೊ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ಸಾಂತಾ ಇಸಾಬೆಲ್#,
		},
		'America/Santarem' => {
			exemplarCity => q#ಸಾಂಟರೆಮ್#,
		},
		'America/Santiago' => {
			exemplarCity => q#ಸ್ಯಾಂಟಿಯಾಗೊ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ಸ್ಯಾಂಟೋ ಡೊಮಿಂಗೊ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ಸಾವ್ ಪಾಲೊ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ಇಟ್ಟೊಕ್ಕೊರ್ಟೂಮಿಯೈಟ್#,
		},
		'America/Sitka' => {
			exemplarCity => q#ಸಿತ್ಕಾ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ಸೇಂಟ್ ಬಾರ್ತೆಲೆಮಿ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ಸೇಂಟ್ ಜಾನ್ಸ್#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ಸೇಂಟ್ ಕಿಟ್ಸ್#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ಸೇಂಟ್ ಲೂಸಿಯಾ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ಸೆಂಟ್ ಥಾಮಸ್#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ಸೇಂಟ್ ವಿನ್ಸೆಂಟ್#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ಸ್ವಿಫ್ಟ್ ಕರೆಂಟ್#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ತೆಗುಸಿಗಲ್ಪಾ#,
		},
		'America/Thule' => {
			exemplarCity => q#ಥೂಲೆ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ಥಂಡರ್ ಬೇ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ತಿಜ್ವಾನಾ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ಟೊರೊಂಟೋ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ಟಾರ್ಟೊಲಾ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ವ್ಯಾಂಕೊವರ್‌#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ವೈಟ್‌ಹಾರ್ಸ್#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ವಿನ್ನಿಪೇಗ್#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ಯಾಕುಟಾಟ್#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ಯೆಲ್ಲೋ‌ನೈಫ್#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಕೇಂದ್ರೀಯ ದಿನದ ಸಮಯ),
				'generic' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಕೇಂದ್ರ ಸಮಯ),
				'standard' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಕೇಂದ್ರ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪೂರ್ವದ ದಿನದ ಸಮಯ),
				'generic' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪೂರ್ವದ ಸಮಯ),
				'standard' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪೂರ್ವದ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪರ್ವತ ದಿನದ ಸಮಯ),
				'generic' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪರ್ವತ ಸಮಯ),
				'standard' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪರ್ವತ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪೆಸಿಫಿಕ್ ದಿನದ ಸಮಯ),
				'generic' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪೆಸಿಫಿಕ್ ಸಮಯ),
				'standard' => q(ಉತ್ತರ ಅಮೆರಿಕದ ಪೆಸಿಫಿಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(ಅನಡೀರ್‌ ಹಗಲು ಸಮಯ),
				'generic' => q(ಅನಡೀರ್‌ ಸಮಯ),
				'standard' => q(ಅನಡೀರ್‌ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ಕೇಸಿ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ಡೇವೀಸ್#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ಡುಮಂಟ್ ಡಿ ಉರ್ವಿಲೆ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ಮ್ಯಾಕ್ವೆರಿ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ಮಾವ್ಸನ್#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ಮ್ಯಾಕ್‍ಮುರ್ಡೊ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ಪಾಲ್ಮರ್#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ರೊಥೇರಾ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ಸ್ಯೋವಾ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ಟ್ರಾಲ್#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ವೋಸ್ಟೋಕ್#,
		},
		'Apia' => {
			long => {
				'daylight' => q(ಅಪಿಯಾ ಹಗಲು ಸಮಯ),
				'generic' => q(ಅಪಿಯಾ ಸಮಯ),
				'standard' => q(ಅಪಿಯಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q(ಅಕ್ಟೌ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅಕ್ಟೌ ಸಮಯ),
				'standard' => q(ಅಕ್ಟೌ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(ಅಕ್ಟೋಬೆ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅಕ್ಟೋಬೆ ಸಮಯ),
				'standard' => q(ಅಕ್ಟೋಬೆ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(ಅರೇಬಿಯನ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಅರೇಬಿಯನ್ ಸಮಯ),
				'standard' => q(ಅರೇಬಿಯನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ಲಾಂಗ್‌ಇಯರ್‌ಬೇನ್#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(ಅರ್ಜೆಂಟಿನಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅರ್ಜೆಂಟಿನಾ ಸಮಯ),
				'standard' => q(ಅರ್ಜೆಂಟೀನಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(ಪಶ್ಚಿಮ ಅರ್ಜೆಂಟೀನಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪಶ್ಚಿಮ ಅರ್ಜೆಂಟೀನಾ ಸಮಯ),
				'standard' => q(ಪಶ್ಚಿಮ ಅರ್ಜೆಂಟೀನಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ಅರ್ಮೇನಿಯ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅರ್ಮೇನಿಯ ಸಮಯ),
				'standard' => q(ಅರ್ಮೇನಿಯ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ಏಡನ್#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ಅಲ್ಮಾಟಿ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ಅಮ್ಮಾನ್#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ಅನದ್ಯರ್#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ಅಕ್ತಾವ್#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ಅಕ್ಟೋಬೆ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ಅಶ್ಗಬಾತ್#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ಬಾಗ್ದಾದ್#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ಬಹ್ರೇನ್#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ಬಕು#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ಬ್ಯಾಂಕಾಕ್#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ಬೀರಟ್#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ಬಿಶ್ಕೆಕ್#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ಬ್ರೂನಿ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ಕೊಲ್ಕತ್ತಾ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ಚಿಟ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ಚೊಯ್‍ಬಾಲ್ಸನ್#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ಕೊಲಂಬೊ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ಡಮಾಸ್ಕಸ್#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ಢಾಕಾ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ದಿಲಿ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ದುಬೈ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ದುಶಾಂಬೆ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ಗಾಜಾ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ಹೆಬ್ರಾನ್#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ಹಾಂಗ್ ಕಾಂಗ್#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ಹೋವ್ಡ್#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ಇರ್‌ಕುಟ್ಸ್#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ಜಕಾರ್ತಾ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ಜಯಪುರ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ಜೆರುಸಲೆಮ್#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ಕಾಬೂಲ್#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ಕಮ್ಚತ್ಕ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ಕರಾಚಿ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ಕಠ್ಮಂಡು#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ಖಂಡ್ಯಾಗಾ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ಕ್ರಾಸ್ನೊಯಾರ್ಸ್ಕ್#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ಕೌಲಾ ಲಂಪುರ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ಕುಚಿಂಗ್#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ಕುವೈತ್#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ಮಖಾವ್#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ಮಗದನ್‌#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ಮೆಕಾಸ್ಸರ್#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ಮನಿಲಾ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ಮಸ್ಕತ್#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ನಿಕೋಸಿಯಾ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ನೋವೋಕುಜೆ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ನೊವೋಸಿಬಿಸ್ಕ್#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ಒಮ್ಸ್ಕ್#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ಒರಲ್#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ನೋಮ್ ಪೆನ್#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ಪೊಂಟಿಯಾನಕ್#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ಪ್ಯೊಂಗ್‍ಯಾಂಗ್#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ಖತಾರ್#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ಕಿಜೈಲೋರ್ದ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ರಂಗೂನ್#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ರಿಯಾದ್#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ಹೊ ಚಿ ಮಿನ್ ಸಿಟಿ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ಸಖಾಲಿನ್#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ಸಮರಖಂಡ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ಸಿಯೋಲ್#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ಶಾಂಘೈ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ಸಿಂಗಾಪೂರ್#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ಸ್ರೇದ್ನೇಕೋಲೀಮಸ್ಕ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ತೈಪೆ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ತಾಶ್ಕೆಂಟ್#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ತಿಬಿಲಿಸಿ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ತೆಹ್ರಾನ್#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ಥಿಂಪು#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ಟೋಕಿಯೊ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ಉಲಾನ್‍ಬಾತರ್#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ಉರುಮ್‍ಕಿ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ಉಸ್ತ್-ನೆರಾ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ವಿಯೆಂಟಿಯಾನ್#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ವ್ಲಾದಿವೊಸ್ಟಾಕ್‌#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ಯಕುಟ್ಸ್ಕ್#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ಎಕ್ಯಾಟೆರಿನ್ಬರ್ಗ್#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ಯೆರಿವಾನ್#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(ಅಟ್ಲಾಂಟಿಕ್ ದಿನದ ಸಮಯ),
				'generic' => q(ಅಟ್ಲಾಂಟಿಕ್ ಸಮಯ),
				'standard' => q(ಅಟ್ಲಾಂಟಿಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ಅಝೋರಿಸ್#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ಬರ್ಮುಡಾ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ಕ್ಯಾನರಿ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ಕೇಪ್ ವೆರ್ಡ್#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ಫ್ಯಾರೊ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ಮೆಡಿರಾ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ರೈಕ್ಜಾವಿಕ್#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ಸೇಂಟ್ ಹೆಲೆನಾ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ಸ್ಟಾನ್ಲಿ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ಅಡಿಲೇಡ್#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ಬ್ರಿಸ್ಬೇನ್‌#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ಬ್ರೊಕನ್ ಹಿಲ್#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ಕರೀ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ಡಾರ್ವಿನ್#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ಯುಕ್ಲಾ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ಹೋಬಾರ್ಟ್‌#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ಲಿಂಡಿಮಾನ್#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ಲಾರ್ಡ್ ಹೋ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ಮೆಲ್ಬರ್ನ್#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ಪರ್ಥ್#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ಸಿಡ್ನಿ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಕೇಂದ್ರ ಹಗಲು ಸಮಯ),
				'generic' => q(ಕೇಂದ್ರ ಆಸ್ಟ್ರೇಲಿಯಾ ಸಮಯ),
				'standard' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಕೇಂದ್ರ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಕೇಂದ್ರ ಪಶ್ಚಿಮ ಹಗಲು ಸಮಯ),
				'generic' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಕೇಂದ್ರ ಪಶ್ಚಿಮ ಸಮಯ),
				'standard' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಕೇಂದ್ರ ಪಶ್ಚಿಮ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ಪೂರ್ವ ಆಸ್ಟ್ರೇಲಿಯಾದ ಹಗಲು ಸಮಯ),
				'generic' => q(ಪೂರ್ವ ಆಸ್ಟ್ರೇಲಿಯಾ ಸಮಯ),
				'standard' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಪೂರ್ವ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಪಶ್ಚಿಮ ಹಗಲು ಸಮಯ),
				'generic' => q(ಪಶ್ಚಿಮ ಆಸ್ಟ್ರೇಲಿಯಾ ಸಮಯ),
				'standard' => q(ಆಸ್ಟ್ರೇಲಿಯಾದ ಪಶ್ಚಿಮ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(ಅಜರ್ಬೈಜಾನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅಜರ್ಬೈಜಾನ್ ಸಮಯ),
				'standard' => q(ಅಜರ್ಬೈಜಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(ಅಜೋರಸ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಅಜೋರಸ್ ಸಮಯ),
				'standard' => q(ಅಜೋರಸ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ಬಾಂಗ್ಲಾದೇಶ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಬಾಂಗ್ಲಾದೇಶ ಸಮಯ),
				'standard' => q(ಬಾಂಗ್ಲಾದೇಶ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ಭೂತಾನ್ ಸಮಯ),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ಬೊಲಿವಿಯಾ ಸಮಯ),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ಬ್ರೆಸಿಲಿಯಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಬ್ರೆಸಿಲಿಯಾದ ಸಮಯ),
				'standard' => q(ಬ್ರೆಸಿಲಿಯಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ಬ್ರೂನಿ ದಾರುಸಲೆಮ್ ಸಮಯ),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(ಕೇಪ್ ವರ್ಡ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಕೇಪ್ ವರ್ಡ್ ಸಮಯ),
				'standard' => q(ಕೇಪ್ ವರ್ಡ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(ಚಮೋರೋ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ಚಥಾಮ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಚಥಾಮ್ ಸಮಯ),
				'standard' => q(ಚಥಾಮ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ಚಿಲಿ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಚಿಲಿ ಸಮಯ),
				'standard' => q(ಚಿಲಿ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ಚೀನಾ ಹಗಲು ಸಮಯ),
				'generic' => q(ಚೀನಾ ಸಮಯ),
				'standard' => q(ಚೀನಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ಚೊಯ್‌ಬಲ್ಸಾನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಚೊಯ್‌ಬಲ್ಸಾನ್ ಸಮಯ),
				'standard' => q(ಚೊಯ್‌‌ಬಲ್ಸಾನ್‌ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ಕ್ರಿಸ್ಮಸ್ ದ್ವೀಪ ಸಮಯ),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(ಕೋಕೋಸ್ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(ಕೊಲಂಬಿಯಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಕೊಲಂಬಿಯಾ ಸಮಯ),
				'standard' => q(ಕೊಲಂಬಿಯಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(ಕುಕ್ ದ್ವೀಪಗಳ ಮಧ್ಯಕಾಲೀನ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಕುಕ್ ದ್ವೀಪಗಳ ಸಮಯ),
				'standard' => q(ಕುಕ್ ದ್ವೀಪಗಳ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ಕ್ಯೂಬಾ ದಿನದ ಸಮಯ),
				'generic' => q(ಕ್ಯೂಬಾ ಸಮಯ),
				'standard' => q(ಕ್ಯೂಬಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ಡೇವಿಸ್ ಸಮಯ),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ಡುಮಂಟ್-ಡಿ ಉರ್ವಿಲೆ ಸಮಯ),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(ಪೂರ್ವ ಟಿಮೋರ್ ಸಮಯ),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ಈಸ್ಟರ್ ದ್ವೀಪ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಈಸ್ಟರ್ ದ್ವೀಪ ಸಮಯ),
				'standard' => q(ಈಸ್ಟರ್ ದ್ವೀಪ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ಈಕ್ವೆಡಾರ್ ಸಮಯ),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ಅಜ್ಞಾತ ನಗರ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ಆಮ್‌ಸ್ಟೆರ್‌ಡ್ಯಾಂ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ಅಂಡೋರಾ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ಅಥೆನ್ಸ್#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ಬೆಲ್‌ಗ್ರೇಡ್#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ಬರ್ಲಿನ್#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ಬ್ರಾಟಿಸ್ಲಾವ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ಬ್ರಸ್ಸೆಲ್ಸ್#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ಬುಕಾರೆಸ್ಟ್#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ಬುಡಾಪೆಸ್ಟ್#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ಬುಸಿಂಜೆನ್#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ಚಿಸಿನಾವ್#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ಕೋಪೆನ್‌ಹೇಗನ್#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ಡುಬ್ಲಿನ್#,
			long => {
				'daylight' => q(ಐರಿಷ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ಜಿಬ್ರಾಲ್ಟರ್#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ಗ್ಯುರ್ನ್‍ಸೆ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ಹೆಲ್ಸಿಂಕಿ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ಐಲ್ ಆಫ್ ಮ್ಯಾನ್#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ಇಸ್ತಾನ್‌ಬುಲ್#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ಜೆರ್ಸಿ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ಕಲಿನಿನ್‌ಗ್ರಾಡ್#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ಕಿವ್#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ಲಿಸ್ಬನ್#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ಲ್ಯೂಬ್ಲ್ಯಾನಾ#,
		},
		'Europe/London' => {
			exemplarCity => q#ಲಂಡನ್#,
			long => {
				'daylight' => q(ಬ್ರಿಟಿಷ್ ಬೇಸಿಗೆ ಸಮಯ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ಲಕ್ಸೆಂಬರ್ಗ್#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ಮ್ಯಾಡ್ರಿಡ್#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ಮಾಲ್ಟಾ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ಮರಿಹಮ್ನ್#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ಮಿನ್‌ಸ್ಕ್#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ಮೊನಾಕೊ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ಮಾಸ್ಕೋ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ಓಸ್ಲೋ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ಪ್ಯಾರಿಸ್#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ಪೊಡ್ಗೊರಿಕ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ಪ್ರಾಗ್ವೆ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ರಿಗಾ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ರೋಮ್#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ಸಮರ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ಸ್ಯಾನ್ ಮರೀನೊ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ಸರಜೆವೊ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ಸಿಮ್ಫೆರೋಪೋಲ್#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ಸ್ಕಾಪಿಯಾ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ಸೋಫಿಯಾ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ಸ್ಟಾಕ್‍ಹೋಮ್#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ಟ್ಯಾಲಿನ್#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ಟಿರಾನೆ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ಉಜ್‌ಗೊರೊದ್#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ವಡೂಜ್#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ವ್ಯಾಟಿಕನ್#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ವಿಯೆನ್ನಾ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ವಿಲ್ನಿಯಸ್#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ವೊಲ್ಗೊಗ್ರಾಡ್#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ವಾರ್ಸಾ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ಜಾಗ್ರೆಬ್‌#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ಜಾಪರೀಝಿಯಾ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ಜ್ಯೂರಿಕ್#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(ಮಧ್ಯ ಯುರೋಪಿಯನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಮಧ್ಯ ಯುರೋಪಿಯನ್ ಸಮಯ),
				'standard' => q(ಮಧ್ಯ ಯುರೋಪಿಯನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(ಪೂರ್ವ ಯುರೋಪಿಯನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪೂರ್ವ ಯುರೋಪಿಯನ್ ಸಮಯ),
				'standard' => q(ಪೂರ್ವ ಯುರೋಪಿಯನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(ಮತ್ತಷ್ಟು-ಪೂರ್ವ ಯುರೋಪಿಯನ್ ಸಮಯ),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(ಪಶ್ಚಿಮ ಯುರೋಪಿಯನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪಶ್ಚಿಮ ಯುರೋಪಿಯನ್ ಸಮಯ),
				'standard' => q(ಪಶ್ಚಿಮ ಯುರೋಪಿಯನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಸಮಯ),
				'standard' => q(ಫಾಲ್ಕ್‌ಲ್ಯಾಂಡ್ ದ್ವೀಪಗಳ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ಫಿಜಿ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಫಿಜಿ ಸಮಯ),
				'standard' => q(ಫಿಜಿ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ಫ್ರೆಂಚ್ ಗಯಾನಾ ಸಮಯ),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ದಕ್ಷಿಣ ಫ್ರೆಂಚ್ ಮತ್ತು ಅಂಟಾರ್ಟಿಕಾ ಸಮಯ),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ಗ್ರೀನ್‌ವಿಚ್ ಸರಾಸರಿ ಕಾಲಮಾನ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ಗಾಲಾಪಾಗೋಸ್ ಸಮಯ),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ಗ್ಯಾಂಬಿಯರ್ ಸಮಯ),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ಜಾರ್ಜಿಯಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಜಾರ್ಜಿಯಾ ಸಮಯ),
				'standard' => q(ಜಾರ್ಜಿಯಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ಗಿಲ್ಬರ್ಟ್ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(ಪೂರ್ವ ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(*ಪೂರ್ವ ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್ ಸಮಯ),
				'standard' => q(ಪೂರ್ವ ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(ಪಶ್ಚಿಮ ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪಶ್ಚಿಮ ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್ ಸಮಯ),
				'standard' => q(ಪಶ್ಚಿಮ ಗ್ರೀನ್‌ಲ್ಯಾಂಡ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(ಗುವಾಮ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ಗಲ್ಫ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ಗಯಾನಾ ಸಮಯ),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ಹವಾಯಿ-ಅಲ್ಯುಟಿಯನ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಹವಾಯಿ-ಅಲ್ಯುಟಿಯನ್ ಸಮಯ),
				'standard' => q(ಹವಾಯಿ-ಅಲ್ಯುಟಿಯನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ಹಾಂಗ್ ಕಾಂಗ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಹಾಂಗ್ ಕಾಂಗ್ ಸಮಯ),
				'standard' => q(ಹಾಂಗ್ ಕಾಂಗ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ಹವ್ಡ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಹವ್ಡ್ ಸಮಯ),
				'standard' => q(ಹವ್ಡ್ ಸ್ಟ್ಯಾಂಡರ್ಡ್ ಸಮಯ),
			},
		},
		'India' => {
			long => {
				'standard' => q(ಭಾರತೀಯ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ಅಂಟಾನನಾರಿವೊ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ಚಾಗೊಸ್#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ಕ್ರಿಸ್ಮಸ್#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ಕೊಕೋಸ್#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ಕೊಮೋರೊ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ಕೆರ್ಗ್ಯುಲೆನ್#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ಮಾಹೆ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ಮಾಲ್ಡೀವ್ಸ್#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ಮಾರಿಷಸ್#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ಮಯೊಟ್ಟೆ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ರೀಯೂನಿಯನ್#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ಹಿಂದೂ ಮಹಾಸಾಗರ ಸಮಯ),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ಇಂಡೊಚೈನಾ ಸಮಯ),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(ಮಧ್ಯ ಇಂಡೋನೇಷಿಯಾ ಸಮಯ),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(ಪೂರ್ವ ಇಂಡೋನೇಷಿಯಾ ಸಮಯ),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(ಪಶ್ಚಿಮ ಇಂಡೋನೇಷಿಯ ಸಮಯ),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ಇರಾನ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಇರಾನ್ ಸಮಯ),
				'standard' => q(ಇರಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ಇರ್‌ಕುಟಸ್ಕ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಇರ್‌ಕುಟಸ್ಕ್ ಸಮಯ),
				'standard' => q(ಇರ್‌ಕುಟಸ್ಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ಇಸ್ರೇಲ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಇಸ್ರೇಲ್ ಸಮಯ),
				'standard' => q(ಇಸ್ರೇಲ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ಜಪಾನ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಜಪಾನ್ ಸಮಯ),
				'standard' => q(ಜಪಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(ಪೆತ್ರೋಪಾವ್ಲೋಸ್ಕ್‌‌-ಕಮ್ಚತ್ಸ್‌ಕೀ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪೆತ್ರೋಪಾವ್ಲೋಸ್ಕ್‌‌-ಕಮ್ಚತ್ಸ್‌ಕೀ ಸಮಯ),
				'standard' => q(ಪೆತ್ರೋಪಾವ್ಲೋಸ್ಕ್‌‌-ಕಮ್ಚತ್ಸ್‌ಕೀ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(ಪೂರ್ವ ಕಜಕಿಸ್ತಾನ್ ಸಮಯ),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(ಪಶ್ಚಿಮ ಕಜಕಿಸ್ತಾನ್ ಸಮಯ),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(ಕೊರಿಯನ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಕೊರಿಯನ್ ಸಮಯ),
				'standard' => q(ಕೊರಿಯನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(ಕೊಸರೆ ಸಮಯ),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ಕ್ರಾಸ್‌ನೊಯಾರ್ಸ್ಕ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಕ್ರಾಸ್‌ನೊಯಾರ್ಸ್ಕ್ ಸಮಯ),
				'standard' => q(ಕ್ರಾಸ್‌ನೊಯಾರ್ಸ್ಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(ಕಿರ್ಗಿಸ್ತಾನ್ ಸಮಯ),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(ಲಂಕಾ ಸಮಯ),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(ಲೈನ್ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(ಲಾರ್ಡ್ ಹೋವ್ ಬೆಳಗಿನ ಸಮಯ),
				'generic' => q(ಲಾರ್ಡ್ ಹೋವ್ ಸಮಯ),
				'standard' => q(ಲಾರ್ಡ್ ಹೋವ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(ಮಕಾವ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಮಕಾವ್ ಸಮಯ),
				'standard' => q(ಮಕಾವ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(ಮ್ಯಾಕ್‌ಕ್ಯುರೈ ದ್ವೀಪ ಸಮಯ),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(ಮಗಡಾನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಮಗಡಾನ್ ಸಮಯ),
				'standard' => q(ಮಗಡಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(ಮಲೇಷಿಯಾ ಸಮಯ),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(ಮಾಲ್ಡೀವ್ಸ್ ಸಮಯ),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(ಮಾರ್ಕ್ಯುಸಸ್ ಸಮಯ),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(ಮಾರ್ಷಲ್ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(ಮಾರಿಷಸ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಮಾರಿಷಸ್ ಸಮಯ),
				'standard' => q(ಮಾರಿಷಸ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(ಮಾವ್‌ಸನ್ ಸಮಯ),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(ವಾಯವ್ಯ ಮೆಕ್ಸಿಕೊ ಹಗಲು ಸಮಯ),
				'generic' => q(ವಾಯವ್ಯ ಮೆಕ್ಸಿಕೊ ಸಮಯ),
				'standard' => q(ವಾಯವ್ಯ ಮೆಕ್ಸಿಕೊ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(ಮೆಕ್ಸಿಕನ್ ಪೆಸಿಫಿಕ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಮೆಕ್ಸಿಕನ್ ಪೆಸಿಫಿಕ್ ಸಮಯ),
				'standard' => q(ಮೆಕ್ಸಿಕನ್ ಪೆಸಿಫಿಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ಉಲನ್ ಬ್ಯಾಟರ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಉಲನ್ ಬ್ಯಾಟರ್ ಸಮಯ),
				'standard' => q(ಉಲನ್ ಬ್ಯಾಟರ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(ಮಾಸ್ಕೋ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಮಾಸ್ಕೋ ಸಮಯ),
				'standard' => q(ಮಾಸ್ಕೋ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(ಮ್ಯಾನ್ಮಾರ್ ಸಮಯ),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(ನೌರು ಸಮಯ),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(ನೇಪಾಳ ಸಮಯ),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ಹೊಸ ಕ್ಯಾಲೆಡೋನಿಯಾ ಬೇಸಿಗೆಯ ಸಮಯ),
				'generic' => q(ಹೊಸ ಕ್ಯಾಲೆಡೋನಿಯಾ ಸಮಯ),
				'standard' => q(ಹೊಸ ಕ್ಯಾಲೆಡೋನಿಯಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಸಮಯ),
				'standard' => q(ನ್ಯೂಜಿಲ್ಯಾಂಡ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ನ್ಯೂಫೌಂಡ್‌ಲ್ಯಾಂಡ್ ದಿನದ ಸಮಯ),
				'generic' => q(ನ್ಯೂಫೌಂಡ್‌ಲ್ಯಾಂಡ್ ಸಮಯ),
				'standard' => q(ನ್ಯೂಫೌಂಡ್‌ಲ್ಯಾಂಡ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(ನಿಯು ಸಮಯ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(ನಾರ್ಫೋಕ್ ದ್ವೀಪ ಸಮಯ),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ಫರ್ನಾಂಡೋ ದೆ ನೊರೊನ್ಹಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಫೆರ್ನಾಂಡೋ ಡೆ ನೊರೊನ್ಹಾ ಸಮಯ),
				'standard' => q(ಫೆರ್ನಾಂಡೋ ಡೆ ನೊರೊನ್ಹಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(ಉತ್ತರ ಮರಿಯಾನಾ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(ನೊವೊಸಿಬಿರ್‌ಸ್ಕ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ನೊವೊಸಿಬಿರ್‌ಸ್ಕ್ ಸಮಯ),
				'standard' => q(ನೊವೊಸಿಬಿಸ್ಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ಒಮಾಸ್ಕ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಒಮಾಸ್ಕ್ ಸಮಯ),
				'standard' => q(ಒಮಾಸ್ಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ಅಪಿಯಾ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ಆಕ್ ಲ್ಯಾಂಡ್#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ಬೌಗೆನ್‍ವಿಲ್ಲೆ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ಚತಮ್#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ಈಸ್ಟರ್#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ಇಫೇಟ್#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ಎಂಡರ್ಬರಿ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ಫಕೋಫೋ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ಫಿಜಿ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ಫುನಾಫುಟಿ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ಗಲಾಪಗೋಸ್#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ಗ್ಯಾಂಬಿಯರ್#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ಗ್ವಾಡಲ್ಕೆನಾಲ್#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ಗ್ವಾಮ್#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ಹೊನಲುಲು#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ಜಾನ್‌ಸ್ಟನ್#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ಕಿರಿತಿಮತಿ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ಕೋಸ್ರೆ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ಕ್ವಾಜಲೇನ್#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ಮಜುರೊ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ಮಾರ್ಕ್ಯೂಸಸ್#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ಮಿಡ್‌ವೇ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ನೌರು#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ನಿಯು#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ನಾರ್ಫೋಕ್#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ನ್ಯೂಮಿಯಾ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ಪಾಗೊ ಪಾಗೊ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ಪಾಲಾವ್#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ಪಿಟ್‌ಕೈರ್ನ್#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ಪೋನ್‌ಪೆ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ಪೋರ್ಟ್ ಮೋರಿಸ್‌ಬೈ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ರರೋಟೋಂಗಾ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ಸೈಪನ್#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ತಹಿತಿ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ತರಾವಾ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ಟೊಂಗಾಟಾಪು#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ಚುಕ್#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ವೇಕ್#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ವ್ಯಾಲಿಸ್#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(ಪಾಕಿಸ್ತಾನ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪಾಕಿಸ್ತಾನ ಸಮಯ),
				'standard' => q(ಪಾಕಿಸ್ತಾನ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(ಪಾಲಾವ್ ಸಮಯ),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(ಪಪುವಾ ನ್ಯೂ ಗಿನಿಯಾ ಸಮಯ),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(ಪರಾಗ್ವೇ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪರಾಗ್ವೇ ಸಮಯ),
				'standard' => q(ಪರಾಗ್ವೇ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(ಪೆರು ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಪೆರು ಸಮಯ),
				'standard' => q(ಪೆರು ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ಫಿಲಿಫೈನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಫಿಲಿಫೈನ್ ಸಮಯ),
				'standard' => q(ಫಿಲಿಫೈನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ಫಿನಿಕ್ಸ್ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(ಸೇಂಟ್ ಪಿಯರ್ ಮತ್ತು ಮಿಕ್ವೆಲನ್ ಹಗಲು ಸಮಯ),
				'generic' => q(ಸೇಂಟ್ ಪಿಯರ್ ಮತ್ತು ಮಿಕ್ವೆಲನ್ ಸಮಯ),
				'standard' => q(ಸೇಂಟ್ ಪಿಯರ್ ಮತ್ತು ಮಿಕ್ವೆಲನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(ಪಿಟ್‌ಕೈರ್ನ್ ಸಮಯ),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(ಪೊನಾಪೆ ಸಮಯ),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(ಕೋಜಿಲೋರ್ಡಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಕೋಜಿಲೋರ್ಡಾ ಸಮಯ),
				'standard' => q(ಕೋಜಿಲೋರ್ಡಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ರಿಯೂನಿಯನ್ ಸಮಯ),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(ರೊತೇರಾ ಸಮಯ),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(ಸ್ಯಾಕ್‌ಹಲಿನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಸ್ಯಾಕ್‌ಹಲಿನ್ ಸಮಯ),
				'standard' => q(ಸ್ಯಾಕ್‌ಹಲಿನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(ಸಮರ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಸಮರ ಸಮಯ),
				'standard' => q(ಸಮರ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(ಸಮೋವಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಸಮೋವಾ ಸಮಯ),
				'standard' => q(ಸಮೋವಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(ಸೀಷೆಲ್ಸ್ ಸಮಯ),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(ಸಿಂಗಾಪುರ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(ಸಾಲಮನ್ ದ್ವೀಪಗಳ ಸಮಯ),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(ದಕ್ಷಿಣ ಜಾರ್ಜಿಯಾ ಸಮಯ),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(ಸುರಿನೇಮ್ ಸಮಯ),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(ಸ್ಯೊವಾ ಸಮಯ),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ತಾಹಿತಿ ಸಮಯ),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ತೈಪೆ ಹಗಲು ಸಮಯ),
				'generic' => q(ತೈಪೆ ಸಮಯ),
				'standard' => q(ತೈಪೆ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ತಝಕಿಸ್ತಾನ್ ಸಮಯ),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ಟೊಕೆಲಾವ್ ಸಮಯ),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ಟೊಂಗಾ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಟೊಂಗಾ ಸಮಯ),
				'standard' => q(ಟೊಂಗಾ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ಚುಕ್ ಸಮಯ),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(ತುರ್ಕ್‌ಮೇನಿಸ್ತಾನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ತುರ್ಕ್‌ಮೇನಿಸ್ತಾನ್ ಸಮಯ),
				'standard' => q(ತುರ್ಕ್‌ಮೇನಿಸ್ತಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ತುವಾಲು ಸಮಯ),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ಉರುಗ್ವೇ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಉರುಗ್ವೇ ಸಮಯ),
				'standard' => q(ಉರುಗ್ವೇ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಸಮಯ),
				'standard' => q(ಉಜ್ಬೇಕಿಸ್ತಾನ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ವನೌತು ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ವನೌತು ಸಮಯ),
				'standard' => q(ವನೌತು ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ವೆನಿಜುವೆಲಾ ಸಮಯ),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ವ್ಲಾಡಿವೋಸ್ಟೋಕ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ವ್ಲಾಡಿವೋಸ್ಟೋಕ್ ಸಮಯ),
				'standard' => q(ವ್ಲಾಡಿವೋಸ್ಟೋಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ವೋಲ್ಗೋಗಾರ್ಡ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ವೋಲ್ಗೋಗಾರ್ಡ್ ಸಮಯ),
				'standard' => q(ವೋಲ್ಗೋಗಾರ್ಡ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ವೋಸ್ಟೊಕ್ ಸಮಯ),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ವೇಕ್ ದ್ವೀಪ ಸಮಯ),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ವ್ಯಾಲೀಸ್ ಮತ್ತು ಫ್ಯುಟುನಾ ಸಮಯ),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(ಯಾಕುಟ್ಸಕ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಯಾಕುಟ್ಸಕ್ ಸಮಯ),
				'standard' => q(ಯಾಕುಟ್ಸಕ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ಯೇಕೇಟರಿನ್‍ಬರ್ಗ್ ಬೇಸಿಗೆ ಸಮಯ),
				'generic' => q(ಯೇಕಟರಿನ್‌ಬರ್ಗ್ ಸಮಯ),
				'standard' => q(ಯೇಕಟರಿನ್‌ಬರ್ಗ್ ಪ್ರಮಾಣಿತ ಸಮಯ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
