package Bencher::Scenario::DataSah::gen_validator;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

my $return_types = ['bool', 'str', 'full'];

our $scenario = {
    summary => 'Benchmark validator generation',
    participants => [
        {
            name => 'gen_validator',
            fcall_template => 'Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})',
        },
    ],
    datasets => [
        {
            name    => 'type',
            summary => '',
            args    => {
                schema => 'str',
                'return_type@' => $return_types,
            },
        },
        {
            name    => 'type+req',
            summary => '',
            args    => {
                schema => 'str*',
                'return_type@' => $return_types,
            },
        },
        {
            name    => 'type+2clause',
            summary => '',
            args    => {
                schema => ['str*', min_len=>1, max_len=>10],
                'return_type@' => $return_types,
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark validator generation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSah::gen_validator

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::DataSah::gen_validator (from Perl distribution Bencher-Scenarios-DataSah), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSah::gen_validator

To run module startup overhead benchmark:

 % bencher --module-startup -m DataSah::gen_validator

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Data::Sah> 0.74

=head1 BENCHMARK PARTICIPANTS

=over

=item * gen_validator (perl_code)

Function call template:

 Data::Sah::gen_validator(<schema>, {return_type=> <return_type>})



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+----------------------------------------------------------------------------+----------+------------+---------+---------+
 | seq | name                                                                       | rate     | time       | errors  | samples |
 +-----+----------------------------------------------------------------------------+----------+------------+---------+---------+
 | 8   | {dataset=>"type+2clause",participant=>"gen_validator",return_type=>"full"} | 735      | 1.36e+03μs | 1.1e-06 | 20      |
 | 7   | {dataset=>"type+2clause",participant=>"gen_validator",return_type=>"str"}  | 750      | 1.33e+03μs | 1.6e-06 | 20      |
 | 6   | {dataset=>"type+2clause",participant=>"gen_validator",return_type=>"bool"} | 830      | 1.2e+03μs  | 1.8e-06 | 20      |
 | 5   | {dataset=>"type+req",participant=>"gen_validator",return_type=>"full"}     | 1.18e+03 | 851μs      | 8.5e-07 | 20      |
 | 4   | {dataset=>"type+req",participant=>"gen_validator",return_type=>"str"}      | 1.19e+03 | 838μs      | 6.9e-07 | 20      |
 | 3   | {dataset=>"type+req",participant=>"gen_validator",return_type=>"bool"}     | 1.31e+03 | 761μs      | 1.1e-06 | 20      |
 | 2   | {dataset=>"type",participant=>"gen_validator",return_type=>"full"}         | 1.33e+03 | 749μs      | 1.1e-06 | 20      |
 | 1   | {dataset=>"type",participant=>"gen_validator",return_type=>"str"}          | 1.35e+03 | 740μs      | 8.5e-07 | 20      |
 | 0   | {dataset=>"type",participant=>"gen_validator",return_type=>"bool"}         | 1.47e+03 | 682μs      | 4.8e-07 | 20      |
 +-----+----------------------------------------------------------------------------+----------+------------+---------+---------+


Benchmark module startup overhead:

 +-----+---------------------+-------+-------------------+---------+---------+
 | seq | name                | time  | mod_overhead_time | errors  | samples |
 +-----+---------------------+-------+-------------------+---------+---------+
 | 1   | Data::Sah           | 12ms  | 7.2ms             | 8.2e-05 | 20      |
 | 0   | perl -e1 (baseline) | 4.7ms | 0ms               | 3.4e-05 | 21      |
 +-----+---------------------+-------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
