package Bencher::Scenario::GetoptLongComplete::Completion;

our $DATE = '2016-01-08'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

use Bencher::ScenarioUtil::Completion qw(make_completion_participant);
use File::Slurper qw(write_text);
use File::Temp qw(tempdir);

my $tempdir;

our $scenario = {
    summary => 'Benchmark completion response time of '.
        'Getopt::Long::Complete-based CLI script',
    modules => {
    },
    participants => [
    ],
    before_list_participants => sub {
        my %args = @_;

        my $sc = $args{scenario};
        my $pp = $sc->{participants};

        return if $tempdir;
        my $keep = $ENV{DEBUG_KEEP_TEMPDIR} ? 1:0;
        $tempdir = tempdir(CLEANUP => !$keep);

        my @script_content;
        push @script_content, "#!$^X\n";
        push @script_content, <<'_';
use 5.010;
use strict;
use warnings;
use Getopt::Long::Complete qw(GetOptionsWithCompletion);

GetOptionsWithCompletion(
    sub {
        require Complete::Util;
        my %args = @_;
        my $word = $args{word};
        my $type = $args{type};
        my $opt  = $args{opt};
        if ($type eq 'optval' && $opt eq '--value') {
            return Complete::Util::complete_array_elem(
                word=>$word, array=>["apple","orange","apricot"]);
        }
        [];
    },
    'help|h'    => sub { },
    'version|v' => sub { },
    'value=s'   => sub { },
    'file=s'    => sub { },
);
_
        write_text("$tempdir/cli1", join("", @script_content));
        chmod 0755, "$tempdir/cli1";

        push @$pp, make_completion_participant(
            type => 'perl_code',
            name=>"optname",
            cmdline=>"$tempdir/cli1 --hel^",
        );
        push @$pp, make_completion_participant(
            type => 'perl_code',
            name=>"optval",
            cmdline=>"$tempdir/cli1 --value a^",
        );

        my $i = 0; for (@$pp) { $_->{seq} = $i++ }
    },
    #datasets => [
    #],
};

1;
# ABSTRACT: Benchmark completion response time of Getopt::Long::Complete-based CLI script

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::GetoptLongComplete::Completion - Benchmark completion response time of Getopt::Long::Complete-based CLI script

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::GetoptLongComplete::Completion (from Perl distribution Bencher-Scenarios-GetoptLongComplete), released on 2016-01-08.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m GetoptLongComplete::Completion

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------+------+--------+---------+---------+
 | seq | name    | rate | time   | errors  | samples |
 +-----+---------+------+--------+---------+---------+
 | 0   | optname | 55   | 18ms   | 0.00013 | 22      |
 | 1   | optval  | 56.3 | 17.8ms | 2.6e-05 | 20      |
 +-----+---------+------+--------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-GetoptLongComplete>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-GetoptLongComplete>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-GetoptLongComplete>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
