use gum -isas;
use Test::More;

my @exports;
my @typelib = qw(
    aref arrayref bool boolean class classname cref coderef def defined fh
    filehandle glob globref href hashref int integer num number obj object ref
    reference rref regexpref sref scalarref str string nil null undef undefined
    val value
);

@exports = map "isa_$_", @typelib;
can_ok 'main', $_ for @exports;

ok isa_aref [];
ok !isa_aref '';
ok isa_arrayref [];
ok !isa_arrayref '';
ok isa_bool 1;
ok isa_bool 0;
ok isa_bool '';
ok isa_bool undef;
ok !isa_bool 100;
ok isa_boolean 1;
ok isa_boolean 0;
ok isa_boolean '';
ok isa_boolean undef;
ok !isa_boolean 100;
ok isa_class 'Test::More';
ok !isa_class 'Acme::Widget';
ok isa_classname 'Test::More';
ok !isa_classname 'Acme::Widget';
ok isa_cref sub {};
ok !isa_cref undef;
ok isa_coderef sub {};
ok !isa_coderef undef;
ok isa_def '';
ok isa_def 0;
ok !isa_def undef;
ok isa_defined '';
ok isa_defined 0;
ok !isa_defined undef;
ok isa_fh do { open my $fh, '<', \''; $fh };
ok !isa_fh \'';
ok isa_filehandle do { open my $fh, '<', \''; $fh };
ok !isa_filehandle \'';
ok isa_glob \*Test::More::EXPORT;
ok !isa_glob \'';
ok isa_globref \*Test::More::EXPORT;
ok !isa_globref \'';
ok isa_href {};
ok !isa_href \'';
ok isa_hashref {};
ok !isa_hashref \'';
ok isa_int 12345;
ok !isa_int 123.45;
ok isa_integer 12345;
ok !isa_integer 123.45;
ok isa_num 12345;
ok isa_num 123.45;
ok isa_num 0;
ok !isa_num '';
ok isa_number 12345;
ok isa_number 123.45;
ok isa_number 0;
ok !isa_number '';
ok isa_obj bless {}, 'main';
ok !isa_obj {};
ok isa_object bless {}, 'main';
ok !isa_object {};
ok isa_ref \'';
ok isa_ref {};
ok isa_ref [];
ok !isa_ref '';
ok isa_reference \'';
ok isa_reference {};
ok isa_reference [];
ok !isa_reference '';
ok isa_rref qr//;
ok !isa_rref \'';
ok isa_regexpref qr//;
ok !isa_regexpref \'';
ok isa_sref \'';
ok !isa_sref {};
ok !isa_sref '';
ok isa_scalarref \'';
ok !isa_scalarref {};
ok !isa_scalarref '';
ok isa_str '';
ok isa_str 0;
ok !isa_str undef;
ok isa_string '';
ok isa_string 0;
ok !isa_string undef;
ok isa_nil undef;
ok !isa_nil '';
ok !isa_nil 0;
ok isa_null undef;
ok !isa_null '';
ok !isa_null 0;
ok isa_undef undef;
ok !isa_undef '';
ok !isa_undef 0;
ok isa_undefined undef;
ok !isa_undefined '';
ok !isa_undefined 0;

@exports = map "not_$_", @typelib;
can_ok 'main', $_ for @exports;

ok !not_aref [];
ok not_aref '';
ok !not_arrayref [];
ok not_arrayref '';
ok !not_bool 1;
ok !not_bool 0;
ok !not_bool '';
ok !not_bool undef;
ok not_bool 100;
ok !not_boolean 1;
ok !not_boolean 0;
ok !not_boolean '';
ok !not_boolean undef;
ok not_boolean 100;
ok !not_class 'Test::More';
ok not_class 'Acme::Widget';
ok !not_classname 'Test::More';
ok not_classname 'Acme::Widget';
ok !not_cref sub {};
ok not_cref undef;
ok !not_coderef sub {};
ok not_coderef undef;
ok !not_def '';
ok !not_def 0;
ok not_def undef;
ok !not_defined '';
ok !not_defined 0;
ok not_defined undef;
ok !not_fh do { open my $fh, '<', \''; $fh };
ok not_fh \'';
ok !not_filehandle do { open my $fh, '<', \''; $fh };
ok not_filehandle \'';
ok !not_glob \*Test::More::EXPORT;
ok not_glob \'';
ok !not_globref \*Test::More::EXPORT;
ok not_globref \'';
ok !not_href {};
ok not_href \'';
ok !not_hashref {};
ok not_hashref \'';
ok !not_int 12345;
ok not_int 123.45;
ok !not_integer 12345;
ok not_integer 123.45;
ok !not_num 12345;
ok !not_num 123.45;
ok !not_num 0;
ok not_num '';
ok !not_number 12345;
ok !not_number 123.45;
ok !not_number 0;
ok not_number '';
ok !not_obj bless {}, 'main';
ok not_obj {};
ok !not_object bless {}, 'main';
ok not_object {};
ok !not_ref \'';
ok !not_ref {};
ok !not_ref [];
ok not_ref '';
ok !not_reference \'';
ok !not_reference {};
ok !not_reference [];
ok not_reference '';
ok !not_rref qr//;
ok not_rref \'';
ok !not_regexpref qr//;
ok not_regexpref \'';
ok !not_sref \'';
ok not_sref {};
ok not_sref '';
ok !not_scalarref \'';
ok not_scalarref {};
ok not_scalarref '';
ok !not_str '';
ok !not_str 0;
ok not_str undef;
ok !not_string '';
ok !not_string 0;
ok not_string undef;
ok !not_nil undef;
ok not_nil '';
ok not_nil 0;
ok !not_null undef;
ok not_null '';
ok not_null 0;
ok !not_undef undef;
ok not_undef '';
ok not_undef 0;
ok !not_undefined undef;
ok not_undefined '';
ok not_undefined 0;

done_testing;
