use Test::More;
use Data::Object::Prototype;

use_ok 'Data::Object::Prototype', 'object', 'extend';

my $bear = object {
    name     => 'bear',
    type     => 'black bear',
    attitude => 'indifferent',
};

$bear->package->install(responds => sub {
    'Roarrrr'
});

$bear->package->install(succeeds => sub {
    shift->isa(ref shift)
});

my $papa = extend $bear => {
    name     => 'papa bear',
    type     => 'great big papa bear',
    attitude => 'agitated',
};

$papa->package->install(responds => sub {
    "Who's been eating my porridge?"
});

my $baby = extend $papa => {
    name     => 'baby bear',
    type     => 'tiny little baby bear',
    attitude => 'baby',
};

$baby->package->install(responds => sub {
    "Who's eaten up all my porridge?"
});

my $mama = extend $bear => {
    name     => 'mama bear',
    type     => 'middle-sized mama bear',
    attitude => 'confused',
};

$mama->package->install(responds => sub {
    "Who's been eating my porridge?"
});

ok $papa && $mama, '$papa and $mama ok';
ok $baby && $baby->succeeds($papa), '$baby succeeds $papa ok';

is $papa->get('name'), 'papa bear', '$papa bear name is ok';
is $mama->get('name'), 'mama bear', '$mama bear name is ok';
is $baby->get('name'), 'baby bear', '$baby bear name is ok';

is $papa->get('name')->titlecase, 'Papa Bear', '$papa bear name titlecased ok';
is $mama->get('name')->titlecase, 'Mama Bear', '$mama bear name titlecased ok';
is $baby->get('name')->titlecase, 'Baby Bear', '$baby bear name titlecased ok';

is $papa->responds, "Who's been eating my porridge?", '$papa responds ok';
is $mama->responds, "Who's been eating my porridge?", '$mama responds ok';
is $baby->responds, "Who's eaten up all my porridge?", '$baby responds ok';
is $bear->responds, 'Roarrrr', '$bear responds ok';

ok 1 and done_testing;
