package Number::ZipCode::JP::Table::Area;

use strict;
use warnings;

our $VERSION = '0.20150731';

# Table last modified: 2015-07-31
our %ZIP_TABLE = (
    '001' => '(?:0(?:9(?:2[1-8]|1[0-25]|0[1-9]|3[0-5])|0(?:00|[1-3]\d|4[05])))',
    '002' => '(?:(?:80(?:91|3[0-8]|1[0-2]|[02][1-9]|[457][1-5]|6[1-8]|8[129])|08(?:5[1-9]|6[015])))',
    '003' => '(?:0(?:8(?:4[09]|[02][1-9]|[56][1-59]|7[1-6]|1[1-4]|3\d)|0(?:30|1[1-3]|0[0-6]|2[1-9])))',
    '004' => '(?:0(?:8(?:21|59|3[1-69]|4\d|8[0-29]|0[1-59]|7[1-9]|6[1-7]|1[1-5])|0(?:0[0-7]|[24][12]|[15][1-5]|3[1-39]|6[1-589]|7[1-6])))',
    '005' => '(?:0(?:8(?:1[0-8]|5[0-6]|3[0-2]|0[1-9]|2[1-7]|6[1-5]|4[0-49])|0(?:3\d|1[1-8]|4[01]|0[0-8]|2[12])))',
    '006' => '(?:0(?:8(?:5[1-39]|2[0-39]|0[1-7]|[13][1-9]|4[0-2]|6[01])|0(?:50|3[1-59]|4[1-39]|0[0-69]|[12][1-69])))',
    '007' => '(?:0(?:8(?:8[0-6]|5[0-2]|[06][1-9]|1[0-59]|3[4-9]|7[0-4]|9[0-5]|[24]\d)|0(?:11|3[0-4]|0[1-6])))',
    '010' => '(?:(?:0(?:9(?:[14][1-8]|5[1-6]|[67][1-7]|[023][1-5])|0(?:0[0-6]|[25][1-9]|6[1-6]|3[1-8]|[14][1-4])|8(?:2[1-6]|[35][1-4]|0[2-4]|[46][1-5]|[17][1-7])|1(?:01|[124][1-6]|3[1-8])|4(?:31|5[1-6]|[12][1-3]|0[01]|4[1-5])|6(?:6[1-5]|7[1-6]|8[1-8])|5(?:11|2[1-3]|0[0-3]|3[1-5])|3(?:4[1-7]|5[1-5])|20[12])|1(?:6(?:4[1-5]|2[1-3]|5[1-4]|[013][1-8])|4(?:0[1-8]|[12][1-9]|3[1-7])|2(?:[03][1-3]|2[1-5]|1[12])|3(?:5[12]|4[1-4])|10[1-6]|50[1-6])))',
    '011' => '(?:09(?:51|2[1-8]|[034][1-9]|1[1-7]))',
    '012' => '(?:(?:0(?:8(?:0[1-4]|3[1-8]|[14][1-5]|[25][1-7]|6[1-9])|0(?:2[1-6]|[135][1-7]|6[12]|4[1-5]|0[0-8])|1(?:83|0[4-7]))|1(?:1(?:[12][1-6]|3[1-7]|0[0-6])|24[1-3]|35[1-3])))',
    '013' => '(?:0(?:4(?:7[1-7]|[1-35][1-9]|0[24-9]|[468][1-8])|3(?:2[1-7]|[013-57][1-9]|[68][1-5])|0(?:0[0-8]|1[1-9]|[57][1-6]|6[0-689]|[2-4][1-8])|5(?:[56][12]|1[1-9]|0[1-3]|[2-4][1-6])|2(?:[01][1-8])|8(?:2[1-6]|1[1-4])|10[1-7]))',
    '014' => '(?:(?:0(?:3(?:0[0-3]|[34][1-7]|[5-7][1-9]|1[1-35-8]|2[1-8])|0(?:7[1-3]|[46][1-8]|3[1-4]|0[0-6]|[125][1-7])|1(?:[01][1-4])|20[1-7]|51[1-6]|80[1-5]|71[1-4]|60[12])|1(?:11[1-6]|20[1-5]|41[1-3])))',
    '015' => '(?:0(?:8(?:[12][1-7]|[368][1-9]|9[0-2]|0[1-47-9]|4[0-3]|[57][1-8])|0(?:00|[235][1-5]|4[1-7]|[6-8][1-9]|[19][1-4])|3(?:41|[35][1-3]|[0-26][1-4])|2(?:[12]1|4[1-3]|[03][12])|4(?:1[1-8]|0[1-4])|5(?:0[1-5]|1[1-6])|72[12]))',
    '016' => '(?:0(?:8(?:4[1-6]|0[1-8]|8[1-4]|[26][1-5]|[37][1-9]|[159][1-7])|1(?:8[1-8]|0[1-4]|1[1-6]|2[1-3]|5[1-7]|[3467][1-9])|0(?:0[0-5]|1[1-7])))',
    '017' => '(?:0(?:8(?:5[1-57]|0[1-6]|[26-8][1-8]|3[1-9]|[149][1-7])|0(?:[35][1-7]|0[0-5]|1[1245]|[24][1-6])|20[0-5]))',
    '018' => '(?:(?:0(?:1(?:6[1-7]|[0-2][1-9]|[37][1-6]|[458][1-8])|4(?:2[12]|0[0-4]|1[1-4]|3[1-6])|7(?:11|3[1-4]|2[1-6])|8(?:[45][1-5])|3(?:11|[02][12])|90[1-7]|60[1-4])|1(?:7(?:0[0-6]|[23][1-5]|4[1-7]|1[1-4])|6(?:3[1-5]|2[1-9]|0[0-6]|1[1-8])|5(?:0[0-4]|2[1-8]|1[1-6])|2(?:1[1-8]|2[1-6])|4(?:1[1-6]|0[0-3])|85[1-7]|30[1-5])|2(?:6(?:6[1-7]|[01][1-9]|[2-47][1-8]|5[1-6])|8(?:1[1-5]|0[1-6])|5(?:0\d|1[12])|40[0-7]|30[1-5]|10[1-4])|3(?:1(?:4[1-8]|3[1-5]|[05][1-7]|[12][1-9])|3(?:1[1-6]|[34][1-3]|0[0-2]|2[1-5])|20[0-5]|50[1-6]|45[1-4])|4(?:2(?:[1-5]1|[067][1-3]|8[12])|4(?:[12][1-3]|0[01]|3[12])|6(?:[02][1-4]|1[1-3])|7(?:4[1-6]|3[1-5])|51[1-6]|30[1-3])|5(?:7(?:01|[1-3][12]|4[1-5]|5[1-6])|(?:14|85|5[01])1|33[1-7]|60[1-6]|20[0-2]|42[12])))',
    '019' => '(?:(?:1(?:8(?:2[24-7]|1[1-7]|6[1-68]|[078][1-8]|3[1245]|5[1-35-8]|4[1-36-8])|9(?:[02-4][1-9]|6[1-3]|[15][1-8])|5(?:[0-24][12]|3[1-3])|6(?:1[1-6]|0[1-5])|10[1-9]|23[1-7]|40[0-4]|30[12]|70[12])|0(?:5(?:1[1-8]|0[1-35-9]|3[1-3]|2[1-9])|7(?:[01][1-5])|4(?:81|0[1-4])|20[1-5]|80[0-3]|11[1-3]|321)|2(?:6(?:01|2[1-5]|3[12]|1[1-4])|4(?:31|0[12]|[14][1-3])|1(?:03|2[1-3]|1[12])|33[1-5]|20[1245]|74[12]|521)))',
    '020' => '(?:0(?:8(?:91|[46][1-6]|[27][1-8]|[0158][1-7]|3[1-9])|6(?:2[1-7]|[15][1-9]|4[1-6]|[36-8][1-8]|0\d)|7(?:4[1-6]|[235][1-8]|1\d|[067][1-9])|5(?:3\d|7[1-4]|1[1-57]|0[0-7]|4[1-7]|5[1-9]|8[1-5]|2[0-57-9])|0(?:3[1-4]|[126][1-6]|[45][1-5]|0[0-5])|1(?:[1-3][1-7]|[04][1-8])|20[1-4]|40[1-4]|31[1-3]))',
    '021' => '(?:0(?:8(?:[067][1-7]|2[12]|[18][1-5]|3[1-6]|[459][1-4])|0(?:41|2[1-7]|0[0-8]|[16][1-4]|[35][1-6])|10[12]|90[12]|221))',
    '022' => '(?:0(?:00[0-7]|10[12]|211))',
    '023' => '(?:(?:0(?:0(?:5[1-8]|9[1-6]|1[1-9]|[2-46-8][1-7]|0[0-3])|8(?:4[12]|[5-7][1-7]|[28][1-9]|3[1-3]|[019][1-8])|1(?:32|71|0[1-8])|40[1-3])|1(?:1(?:[02][1-5]|3[1-4]|1[1-8])|(?:34|55)1|76[12])))',
    '024' => '(?:0(?:0(?:[2-49][1-5]|0[0-4]|[168][1-4]|5[1-8]|7[1-6])|3(?:41|2[1-6]|3[1-5])|10[1-5]|211))',
    '025' => '(?:0(?:0(?:[124][1-6]|[569][1-8]|0[0-8]|[378][1-9])|3(?:[01][1-5]|2[1-4])|2(?:44|5[1-3])|13[1-7]))',
    '026' => '(?:0(?:0(?:61|[24][1-6]|0[0-4]|[135][1-5])|30[1-4]|41[12]|121))',
    '027' => '(?:0(?:0(?:[69][1-7]|[238][1-9]|5[1-68]|0\d|[47][1-8])|3(?:[57][1-9]|[46][1-7]|[13][1-3]|0[1-6]|2[1-4]|8[1-8])|50[0-8]|42[1-4]|20[1-3]|11[12]|611))',
    '028' => '(?:(?:6(?:9(?:[05][1-8]|8[1-5]|[1-467][1-9])|8(?:5[1-7]|[147][1-9]|8[1-5]|2[1-6]|[36][1-8])|10[0-8]|50[0-7]|30[0-4]|72[1-4]|22[1-3]|41[1-3]|61[12])|7(?:6(?:4[1-5]|5[1-7]|[127][1-9]|[03][1-8]|6[1-4])|5(?:[2356][1-7]|4[1-5]|[01][1-6])|9(?:1[1-8]|0[0-6])|1(?:00|1[1-3])|30[1-6]|40[1-6]|801)|0(?:0(?:[479]1|8[1-3]|[56][1-6]|2[1-4]|0[01]|[13][1-5])|1(?:0[1-7]|[135][1-6]|2[1-3]|4[1-4])|5(?:3[1-4]|[45][1-5]|[12][1-7]|0[0-3])|77[1-6]|30[1-5]|66[1-4]|481)|3(?:1(?:11|[356][1-3]|[0247][12]|8[1-5])|6(?:[12][1-7]|0[0-8])|3(?:0\d|2[1-6]|1[0-8])|4(?:5[1-3]|4[1-8])|53[1-6]|20[1-4])|8(?:3(?:3[1-6]|[125][1-3]|6[1-8]|0[0-3]|4[1-5])|40[0-7]|(?:11|52)1|60[1-5]|80[1-5]|20[0-2]|71[1-3])|5(?:3(?:0[0-6]|1[1-6])|1(?:02|3[1-4])|2(?:33|2[1-4])|6(?:33|4[1-3])|7(?:02|1[1-3])|40[0-3])|1(?:3(?:[1267]1|[34][1-3]|5[12]|0[0-3])|1(?:3[1-3]|0[0-5]|1[1-7]|2[12]))|2(?:5(?:04|1[1-3])|4(?:02|2[12])|10[1-5]|30[1-4]|23[1-3]|63[1-3]|711)|4(?:1(?:3[1-6]|2[1-5])|30[0-7]|42[1-6]|211)))',
    '029' => '(?:(?:4(?:4(?:[29][1-7]|[13][1-9]|[67][1-5]|[08][1-8]|[45][1-6])|3(?:0[3-8]|[28][1-9]|1[1-7]|[56][1-5]|3[1-4]|[47][1-8])|2(?:11|0[1-9])|50[0-5]|10[0-2])|0(?:2(?:11|0[12])|(?:43|71)1|80[1-4]|30[1-3]|52[1-3]|60[1-3]|13[12])|5(?:5(?:2[1-3]|1[1-4]|0[0-7])|6(?:21|1[1-9])|70[1-3])|3(?:40[1-6]|10[1-5]|20[5-7]|52[12]|311)|2(?:20[0-8]|3(?:00|11)|50[12])|1(?:2(?:11|0[12])|111)))',
    '030' => '(?:(?:0(?:9(?:[45][1-8]|0[1-4]|6[1-6]|1[1-9]|3[1-7]|2[1-5])|8(?:6[12]|4[1-7]|[0-2][1-3]|5[1-6])|1(?:[245][1-5]|3[1-7]|1[1-3]))|1(?:7(?:01|2\d|1[1-9]|3[1-7])|2(?:0[0-3]|6[12]|7[1-3]|1[1-4])|5(?:1[1-5]|0[0-5])|4(?:0[02-5]|1[1-356])|3(?:11|0[1-9]))))',
    '031' => '(?:0(?:0(?:[38][1-9]|[47][1-7]|5[1-8]|[12][1-3]|0[0-47])|8(?:1[1-6]|[02-4][1-4])|11[1-5]|20[12]))',
    '033' => '(?:0(?:0(?:0[01]|[27][1-4]|[56][1-3]|4[1-5]|1[12]|3[1-7])|1(?:23|3[1-4]|[14][1-3]|6[1-7]|[05][1-5])))',
    '034' => '(?:0(?:0(?:[467]1|8[1-9]|1[1-7]|5[12]|9[1-5]|0[0-5]|2[1-4]|3[1-8])|10[1-7]|21[1-3]|30[1-3]))',
    '035' => '(?:0(?:0(?:6[1-8]|[3489][1-6]|7[1-9]|[12][12]|5[1-5]|0[0-5])|1(?:1[1-3]|0[34])))',
    '036' => '(?:(?:8(?:0(?:[589][1-7]|1[1-8]|[02-467][1-6])|1(?:[89][1-8]|[0346][1-4]|2[1-7]|[157][1-5])|3(?:[78][1-5]|5[1-7]|1[1-9]|6[1-8]|2[13-6]|0[1-3]|[34][1-6])|2(?:5[1-5]|[014][1-7]|7[1-9]|2[1-8]|3[1-4]|6[1-6]))|0(?:3(?:4[1-5]|[38][1-9]|5[1-7]|0[0-8]|[167][1-8]|2[1-6])|1(?:[156][1-5]|[23][12]|0[0-4]|4[1-6]|7[1-3])|5(?:4[12]|3[1-9]|[01][1-7]|2[1-4])|2(?:[0-4][1-3])|4(?:[01][1-5])|000)|1(?:3(?:61|[24][1-5]|[013][1-4])|4(?:00|[13][1-5]|2[1-4]|[45][1-3])|5(?:[01][1-6])|20[1-6])))',
    '037' => '(?:0(?:0(?:2[1-5]|[19][1-7]|[68][1-9]|3[2-6]|0[0-6]|5[1-8]|[47][1-6])|5(?:3[1-8]|1[1-4]|4[1-3]|2[1-5])|6(?:2[1-3]|1[1-4]|[034][12])|3(?:1[1-8]|0\d)|10[1-9]|20[1-8]|40[1-5]))',
    '038' => '(?:(?:3(?:1(?:2[1-8]|4[1-6]|1[1-5]|[35][1-9]|6[1-7]|0[0-7])|6(?:00|51|3[1-6]|7[1-3]|6[12]|[1248][1-5])|5(?:4[1-3]|3[12]|[12][1-5]|0[0-3])|8(?:21|74|1[1-4]|0[0-6]|3[1-7])|2(?:[78][1-8])|30[1-6])|2(?:7(?:61|5[1-4]|0[0-5]|[1-3][1-5]|4[1-7])|8(?:1[1-8]|0[13-8])|3(?:00|2[1-7])|20[1-8]|50[1-5]|41[1-3])|1(?:3(?:[24][1-5]|0[1-6]|[13][1-3])|1(?:3[1-4]|[12][1-3]|4[1-5]|0[0-4])|2(?:1[1-6]|0[1-7]))|0(?:0(?:4[1-6]|2[1-4]|0[0-46]|5[1-9]|3[12]|1[1-5])|2(?:0[0-4]|1[12]|[2-4][1-3])|10[1-3])))',
    '039' => '(?:(?:2(?:5(?:1[1-8]|[3-8][1-9]|2[1-7]|0[0-8])|6(?:3[1-6]|[46-8][1-8]|[125][1-7]|0[0-7])|8(?:[57][1-7]|[03][1-5]|2[1-8]|[146][1-6])|1(?:02|7[1-3]|3[1-6]|8\d|[15][1-8]|6[1-5]|2[1-9]|4[1-7])|7(?:4[1-8]|[36][1-3]|[28][1-6]|7[1-9]|[15][1-7])|2(?:4[1-356]|[23][1-6]|0[0-6]|1[1-7]|5[1-5])|3(?:0[02]|1[1-5]|7[12])|40[1-7])|3(?:1(?:31|[146][1-8]|0\d|[257][1-9])|3(?:21|6[1-4]|[3-57][1-3]|8[12]|1[1-5]|0[0-3])|5(?:24|0[1-7])|2(?:00|1[1-5]))|1(?:5(?:0[0-8]|[1-356][1-9]|4[1-8])|1(?:21|6\d|1[1-4]|0[1-9])|2(?:1[12]|0[0-8])|70[1-3]|80[0-2])|0(?:1(?:2[12]|3[1-5]|0[0-6]|4[1-4]|1[1-3])|8(?:[01][1-5])|6(?:06|1[1-4])|31[1-7]|50[1-7]|20[0-2]|45[1-3])|4(?:1(?:2[1-4]|3[1-8]|4[1-5]|[15][1-7]|0[0-6])|7(?:1[12]|0[01])|22[1-4]|50[0-3]|60[0-2]|40[12]|301)|5(?:3(?:04|[23][1-7]|4[1-6])|20[1-4])))',
    '040' => '(?:00(?:[35][1-7]|[126][1-5]|0[0-5]|8[1-4]|7[1-8]|4[1-6]))',
    '041' => '(?:(?:0(?:8(?:2[1-4]|4[134]|0[1-8]|[15][1-3]|3[1-7])|3(?:1[1-3]|0[1-6])|6(?:1[1-3]|0[1-6])|2(?:6[1-5]|5[1-3])|40[1-8]|52[1-6])|1(?:2(?:[035]1|1[1-5]|2[1-6]|4[1-4])|1(?:0[0-5]|[12][12]|3[1-6])|6(?:[01][1-3]|2[1-4])|40[0-5]|35[1-5])))',
    '042' => '(?:09(?:[24][1-4]|[015][1-8]|3[1-5]))',
    '043' => '(?:(?:0(?:0(?:00|[2-46][1-6]|[15][1-7])|4(?:21|1[5-9]|0[1-5])|1(?:1[1-7]|0[0-4])|5(?:[01][1-5])|33[1-5]|23[1-4])|1(?:1(?:0[0-4]|1[1-8])|3(?:51|6[1-8])|23[1-8]|40[0-6]|52[1-5])))',
    '044' => '(?:0(?:0(?:5[1-7]|0[0-7]|[248][1-5]|[13][1-6]|[67][1-8])|1(?:2[1-5]|3[12]|1[1-3]|0[01])|2(?:[12][1-5]|0[01])|4(?:[45][1-4]|6[1-3])))',
    '045' => '(?:0(?:0(?:0[0-3]|3[12]|1[1-3]|2[1-6])|20[0-5]|30[0-3]|12[1-3]))',
    '046' => '(?:0(?:5(?:[267]1|0[01]|[13-5][12])|0(?:3[1-3]|[12][1-5]|0[0-4])|1(?:21|0[0-4]|[13][1-3])|32[1-8]|20[0-2]))',
    '047' => '(?:0(?:0(?:[24][1-8]|0[0-8]|1[1-7]|3[1-9])|15[1-7]|26[1-6]))',
    '048' => '(?:(?:1(?:5(?:31|[45][1-4]|6[1-3]|[12][12]|0[0-2])|3(?:41|1[1-6]|0[0-7]|2[1-7])|6(?:31|1[1-5]|0[0-5]|2[1-4])|7(?:[34]1|00|2[1-4]|[15][12])|2(?:6[1-5]|5[1-4]))|0(?:1(?:0[01]|4[1-5]|[1-3][1-7])|6(?:[13][1-4]|2[1-3]|0[0-4])|4(?:1[1-5]|0[0-6])|351)|2(?:4(?:0[0-6]|1[1-3])|33[1-5]|14[1-3]|20[0-2]|67[1-3]|56[12])))',
    '049' => '(?:(?:0(?:1(?:[17]1|4[1-3]|3[1-6]|0[01]|5[1-8]|[26][12])|4(?:[34]1|0[0-8]|5[1-5]|[12][12])|6(?:1[1-3]|0[0-8]|2[1-7])|28[1-6]|56[1-4]|74[1-4])|4(?:3(?:1[1-8]|[23][1-7]|0[0-8])|8(?:0[1-5]|2[1-8]|1[1-6])|5(?:1[1-8]|0[01])|15[1-7]|75[1-5]|43[1-4])|1(?:5(?:2[1-4]|0[0-7]|1[1-7])|3(?:[13][12]|2[1-5]|0[0-2])|7(?:71|[68][1-4])|10[0-7]|45[1-6]|64[1-5]|221)|5(?:8(?:3[1-3]|1[1-4]|[02][12])|4(?:1[1-6]|0[0-8])|6(?:1[1-6]|0[0-5])|7(?:31|2[1-4])|33[1-3]|141)|3(?:1(?:0[0-7]|[12][1-8])|5(?:21|1[1-9]|0[0-4])|46[1-5]|34[12])|2(?:3(?:1[1-3]|2[1-7]|0[0-8])|56[1-6]|46[1-5]|67[1-5]|22[1-3]|14[12])))',
    '050' => '(?:00(?:00|[6-8][1-7]|5[1-5]))',
    '051' => '(?:00(?:2[1-8]|[013][1-6]))',
    '052' => '(?:0(?:0(?:0[0-8]|2[1-7]|[13][1-6])|1(?:1[1-6]|0[0-7])|3(?:1[1-7]|0[1-3])))',
    '053' => '(?:0(?:0(?:3[1-5]|[24][1-7]|0[0-7]|5[1-6]|1[1-8])|8(?:0[1-7]|[45][1-5]|1[1-6]|[23][1-3])))',
    '054' => '(?:0(?:0(?:0[0-5]|[3-5][12]|2[1-3]|1[1-6]|6[1-4])|2(?:11|0[1-4])|14[1-4]|36[1-4]))',
    '055' => '(?:(?:0(?:00[0-8]|10[0-7]|32[1-5]|41[1-5])|23(?:0[1-9]|1[1-6])))',
    '056' => '(?:0(?:0(?:0[0-7]|1[13-9]|2[1-8])|14[1-6]))',
    '057' => '(?:0(?:0(?:2[1-7]|0[0-7]|1[1-5]|3[1-6])|17[1-4]))',
    '058' => '(?:0(?:0(?:41|0[0-4]|2[1-7]|1[1-5]|3[1-3])|20[0-7]|34[1-3]|42[12]))',
    '059' => '(?:(?:1(?:6(?:1[1-6]|2[1-5]|0[0-6])|3(?:6[1-6]|[07][1-5])|9(?:[1-35-7]1|4[12]|8[2-7])|7(?:4[1-9]|5[1-4])|2(?:7[1-6]|6[1-5])|5(?:1[1-3]|0[0-6])|43[1-4])|0(?:0(?:2[1-8]|3[1-6]|1[1-7]|0[0-5])|9(?:1[1-6]|2[1-3]|0[0-8])|15[1-7]|46[1-6]|27[1-5]|55[1-3]|64[12])|2(?:4(?:0[0-4]|2[1-7]|1[1-8])|2(?:5[1-3]|4[1-5])|3(?:4[1-4]|3[12])|5(?:71|6[1-6])|12[1-7])|3(?:1(?:0[1-8]|1[12])|4(?:6[1-3]|5[134])|35[1-5]|23[1-3])))',
    '060' => '(?:0(?:0(?:6[1-3]|0\d|1[0-8]|5[1-7]|3[1-5]|4[12]|2[0-2])|8(?:20|1\d|0[6-9])|90[5-9]))',
    '061' => '(?:(?:1(?:1(?:5[1-4]|4[1-8]|[23][1-7]|1[1-5]|0[0-6])|4(?:3[1-5]|4[1-9]|[12][1-7]|0[0-79])|3(?:[5-7][1-6])|2(?:81|7\d|6[14-9]))|3(?:2(?:71|3[0-2]|6[12]|4[1-58]|2[0-3]|[01]\d|8[1-4]|5[13-9])|3(?:3[12]|7[1-8]|6[1-35-8])|1(?:51|0[1-9]|1[1-3])|4(?:41|8[0-4])|77[1-9]|60[1-356]|52[1-3])|0(?:2(?:0[0-8]|3[1-5]|5[1-4]|[12][1-8])|5(?:[12][1-8]|0[0-8])|6(?:1[1-8]|2[1-3]|0[0-3]))|2(?:2(?:[6-8][1-6])|30[1-3])))',
    '062' => '(?:0(?:0(?:0\d|4[1-35]|5[1-5]|1[0-2]|3[1-59]|2[0-5])|9(?:0[1-9]|[12][12]|3[1-8])))',
    '063' => '(?:0(?:8(?:[57]0|3[0-7]|[246][1-9]|[01][1-4])|0(?:4[0-49]|0[0-79]|2[1-39]|5[1-49]|3[1-9]|[16][12])))',
    '064' => '(?:0(?:9(?:4[1-6]|5[1-489]|3[01]|1[2-9]|2\d)|8(?:0[1-9]|2[0-6]|1[01])))',
    '065' => '(?:00(?:0[04-9]|3[0-3]|2[0-8]|1\d|4[1-3]))',
    '066' => '(?:0(?:0(?:0\d|7[1-8]|8[1-4]|[1-36][1-9]|[45][1-7])|2(?:71|8[1-7])))',
    '067' => '(?:00(?:6[1-6]|[12][1-8]|3[1-4]|0[0-5]|5[1-9]|7[1-5]|4[12]))',
    '068' => '(?:(?:0(?:0(?:61|1[0-6]|2[1-9]|3[0-5]|0\d|[45][1-8])|8(?:1[0-8]|4[1-7]|0[1-9]|3[0-7]|5[1-5]|2\d)|1(?:1[1-5]|2[1-7]|[03][1-6])|4(?:0\d|1[1-4]|2[1-6])|3(?:6[1-3]|5[1-8])|6(?:[67][1-5])|5(?:4\d|3[1-6])|75[1-6])|1(?:1(?:61|2[1-7]|0[0-5]|3[1-8]|5[1-3]|[14][1-6])|2(?:31|[01][1-5]))|21(?:81|[124-6][1-8]|3[1-7]|0[0-8])|31(?:8[0-35-8]|6[1-5]|[57][1-9])))',
    '069' => '(?:(?:1(?:3(?:0\d|3[1-6]|4[1-7]|1[0-8]|2[0-29])|4(?:[57][1-9]|6[0-4]|8[0-5])|5(?:0[0-8]|1[1-3]|2[1-6])|1(?:3[1-6]|[48][1-4])|2(?:1[1-9]|0[0-8]))|0(?:8(?:[023][1-6]|5[1-5]|[146][1-7])|2(?:2[01]|1\d|3[1-9]|0[07-9])|3(?:51|8[1-4]|[67][1-6]))))',
    '070' => '(?:(?:0(?:0(?:2[1-9]|[14][0-4]|7[23]|0[0-3]|5[2-9]|3\d|[68][1-3])|8(?:6[4-7]|1[0-7]|7[1-7]|2[1-5]|3[12]|4[1-3])|9(?:0[12]|7[1-3]))|80(?:61|0[1-7]|[14][1-9]|2[1-8]|[37][1-4]|5[1-3])))',
    '071' => '(?:(?:0(?:5(?:83|5[1-5]|1[0-7]|[47][1-9]|3[0-4]|[02]\d|6[1-6])|7(?:26|42|0[04-7]|5[1-5]|6[12]|3[1-7]|1[14]|7\d|8[01])|2(?:[56]1|[04]\d|[1-3][1-9])|4(?:6[12]|7[1-9])|1(?:7[1-4]|8[4-6])|35[1-35])|1(?:4(?:7[1-4]|0[02-9]|[35][1-9]|6[0-7]|[14][0-2]|2[2-6])|5(?:[06][0-5]|3[3-9]|8[12]|[12][1-5]|7[0-57]|5[0-7]|4\d)|2(?:11|0[0-2]|6[0-7]|[23][1-5]|5\d|4[7-9])|17[1-7])|81(?:71|6[0-6]|5[1-9]|4[1-5]|2[1-3]|3[1-8]|[01][1-4])))',
    '072' => '(?:0(?:8(?:4[1-4]|[02][1-8]|1[1-9]|5[1-7]|3[1-5])|0(?:[23][1-8]|0\d|5[1-9]|[14][1-7])))',
    '073' => '(?:(?:0(?:1(?:81|5[1-9]|2[1-7]|0[0-8]|[13467][1-8])|0(?:85|[34][1-6]|1[1-8]|2[1-7]|0[0-6])|2(?:0[0-6]|2[12]|1[1-3])|40[0-7])|1(?:10[0-7]|32[1-3])))',
    '074' => '(?:(?:0(?:4(?:0[0-5]|2[1-7]|1[1-5])|0(?:31|1[1-5]|2[1-8]|0\d)|14[1-7]|74[1-7])|1(?:1(?:6[1-4]|8[12])|27[1-6])))',
    '075' => '(?:0(?:0(?:[24]1|3[1-6]|1[1-9]|0[0-7])|16[1-7]|25[1-4]))',
    '076' => '(?:0(?:0(?:81|5\d|[124][1-8]|3[1-9]|0[0-8])|1(?:7[1-6]|8[1-4]|6[1-5])|20[1-4]))',
    '077' => '(?:0(?:0(?:[2-4][1-8]|1[1-6]|0[0-7])|2(?:2[1-5]|1[1-8]|0\d)|3(?:51|4[145])|46[1-6]|13[1-4]))',
    '078' => '(?:(?:8(?:3(?:[78][1-3]|[3-5]\d|6[0-8]|0[1-58]|9[12]|1[1-9]|2[0-7])|2(?:0[1-8]|2[01]|5[1-3]|4[0-6]|7[1-5]|6[12]|[13][1-9])|8(?:[0-2][1-5]))|1(?:7(?:[356][1-3]|0[01]|4[1-4]|7[1-5]|[12][12])|3(?:24|41|0[03-6]|1[3-6]|3[1-57])|4(?:1[1-5]|0[0-5])|27[1-4]|65[1-4])|3(?:7(?:1[1-7]|0[0-2])|4(?:5[1-7]|4[12])|6(?:21|3[1-8])|3(?:0\d|1[1-3])|16[1-8]|(?:54|87)1|95[1-5])|2(?:2(?:2[1-5]|0[0-6]|1[1-4])|6(?:00|51|4[12]|3[1-9])|5(?:31|0[0-3]|1[1-6])|1(?:2[1-4]|0\d|1[12]))|4(?:1(?:2[0-3]|0[0-8]|3[0-4]|4[0-5]|1\d)|4(?:00|[12][12]|3[1-3]))|0(?:3(?:00|1[01]|3[0-5]|[24][1-9])|1(?:5[1-4]|8[56]))))',
    '079' => '(?:(?:1(?:1(?:81|0[0-2]|[35][1-6]|[124][1-4])|2(?:8[1-7]|7[1-4]|6[1-8])|5(?:7[1-3]|8[12]|6[2-6])|37[12])|0(?:1(?:8[1-3]|7[1-7]|6[124-7])|3(?:1[1-7]|0[0-6])|2(?:7[1-4]|6[1-7])|5(?:0\d|1[01])|46[1-3])|84(?:31|[45][1-4]|0[1-3]|1[1-9]|2[0-4])|2(?:4(?:0[0-4]|1[12])|20[0-7]|13[1-3]|55[12])))',
    '080' => '(?:(?:0(?:8(?:5[67]|[34][1-8]|2[1-4]|[67][12]|1[0-7]|0[1-9])|3(?:51|3[0-5]|2[1-7]|0[1-9]|4[1-5]|6[1-3]|1[1-8])|1(?:51|4[1-6]|[26][1-3]|3[1-9]|1[12]|0[0-6])|0(?:00|[45][0-8]|[1-3]\d)|5(?:[67][1-8])|2(?:6[1-3]|7[12]))|1(?:2(?:0[0-4]|[1256][1-7]|3[1-6]|[478][1-8])|40[0-8]|189)|2(?:1(?:2[1-4]|0[1-6]|1[1-7])|4(?:59|7[0-6]|6[0-59])|33[1-7])))',
    '081' => '(?:0(?:0(?:0[0-35-8]|3[1-9]|1[1-5]|2[1-3])|2(?:[12][1-8]|0[0-5])|1(?:6[1-4]|5[1-6])|34[1-6]))',
    '082' => '(?:0(?:0(?:8[1-7]|7[1-9]|5[1-467]|2[0-2]|[46][0-4]|[013]\d)|8(?:[01][1-3])|38[1-5]))',
    '083' => '(?:00(?:3[1-4]|9[0-2]|4[1-7]|0[0-4]|2[0-3]))',
    '084' => '(?:09(?:[02][1-9]|1[0-8]))',
    '085' => '(?:(?:0(?:0(?:[13-5][1-8]|2[1-7]|6[1-5]|0[0-8])|2(?:0[1-6]|[13][1-8]|2[0-5]|4[1-5]|5[12])|8(?:[034][1-7]|[12][1-6])|467)|1(?:2(?:1[1-3]|6[12]|0[0-7])|1(?:3[1-4]|4[1-7]))|227[1-3]))',
    '086' => '(?:(?:1(?:1(?:1[0-2]|2[1-9]|5[0-3679]|6[03-6]|4[1-8]|0\d|3[0-79])|0(?:[04][1-9]|8[0-3]|[1-35-7]\d)|8(?:[13][1-6]|2[1-3]|4[1-4]|0[0-6])|6(?:4[1-5]|0[0-2]|2[1-356]|5[1-8]|3\d)|7(?:5[12]|3[1-3])|27[1-3]|451)|0(?:0(?:81|7[1-6]|6[1-5])|2(?:1[1-6]|0[0-5])|65[1-7]|34[1-6]|52[1-3]|131)))',
    '087' => '(?:0(?:0(?:2[1-8]|0\d|1[0-24-9]|4[1-9]|3[1-7]|5[1-5])|16[1-7]))',
    '088' => '(?:(?:0(?:1(?:81|0[1-9]|3[1-5]|2[1-6]|1[1-8])|3(?:0[0-5]|1[12]|[35][1-3]|[24][1-4])|5(?:8[1-7]|6[1-8]|7[1-4])|6(?:0\d|[12][1-8])|8(?:7[1-8]|3[1-5])|771)|1(?:1(?:51|1[1-9]|0[0-8]|[34]\d|2[04-689])|5(?:[67]1|00|3[124-8]|2[24-8]|[15][1-4])|4(?:12|0[1-9]|8[5-7])|3(?:89|6\d|7[01]|0[1-46])|64[3-9]|78[1-5])|2(?:3(?:8[0-289]|[12][1-4]|0[0-5]|3[1-9])|1(?:4[0-8]|5[1-7])|5(?:6[1-6]|7[1-8])|2(?:6[1-6]|7[1-5])|6(?:0[12]|8[1-6])|46[1-5]|72[1-5])|3(?:2(?:71|0[0-4]|1[1-5]|2[1-8])|1(?:5[1-7]|4[1-9])|3(?:[45]1|3[12])|46[1-5])))',
    '089' => '(?:(?:1(?:3(?:00|3[0-2]|[24][1-5]|1[0-3]|6[1-8]|7[1-4]|5[1-6])|5(?:[14-8][1-3]|[23][12]|0[0-2])|7(?:31|2[14-9]|1[14-7]|0[13579])|2(?:4[1-7]|5[12])|8(?:71|8[12])|18[1-4])|0(?:5(?:6[1-7]|4[1-6]|5[1-4]|[37][1-8])|1(?:0[0-7]|2[1-7]|[13][1-8])|6(?:0[0-5]|2[1-8]|1[1-6])|3(?:5[1-7]|7[1-8]|6[1-3])|78[1-8]|24[1-3])|3(?:7(?:1[1-8]|0[0-8]|[23][1-7])|3(?:[13][1-4]|0[0-8]|2[1-7])|6(?:7[1-7]|6[1-6])|5(?:8[5-7]|7[1-8])|15[1-6]|96[1-6]|87[1-5]|28[1-4]|44[23])|2(?:1(?:5[1-6]|3[1-8]|0[0-7]|[12][1-7]|4[0-35-8])|6(?:[23][1-8]|1[1-6]|0[0-5])|2(?:[67][1-3])|4(?:55|4[5-8])|77[1-6]|56[1-4])|5(?:6(?:0[0-8]|2[12]|1[1-57]|3[1-8])|5(?:[45][1-8])|2(?:3[1-5]|4[1-7])|3(?:0\d|1[1-5])|46[1-6]|86[5-9])|4(?:3(?:[35][1-7]|0[0-8]|[124][1-6])|2(?:[56][12])|14[1-4])))',
    '090' => '(?:0(?:0(?:70|3[0-7]|1[1-9]|[04][0-8]|2\d|5[1-8]|6[13-9])|8(?:[03][1-8]|2[1-7]|1[0-8])))',
    '091' => '(?:0(?:0(?:0[1-478]|2[1-9]|3[1-3]|1[16-8])|1(?:70|6[1-3]|5[13-7])|55[1-8]|47[1-3]))',
    '092' => '(?:0(?:0(?:4[1-4]|1[1-8]|2[1-7]|0[0-7]|6[1-9]|[35][0-3])|2(?:2[1-5]|3[1-6]|0[0135-7]|1[1-8])|3(?:5[1-8]|6[12])|1(?:8[134]|7[13-6])))',
    '093' => '(?:0(?:0(?:90|3[1-5]|[57][1-9]|6[0-2]|2[0-4]|[018]\d|4[1-6])|5(?:32|0[0-8])|2(?:02|41|1[03-6])|13[1-6]|33[1-6]|73[1-5]|42[1-4]|65[12]))',
    '094' => '(?:00(?:31|2[1-7]|0[0-7]|1[1-5]))',
    '095' => '(?:0(?:0(?:0[0-8]|1[1-9]|[23][1-59]|5[1-6]|6[1-4]|4[1-8])|40[1-6]|18[1-3]|371))',
    '096' => '(?:00(?:[56][1-6]|[013]\d|7[1-8]|4[0-3]|2[0-5]))',
    '097' => '(?:(?:0(?:0(?:[12][1-7]|0[0-7]|3[5-7])|10[01]|40[01]|[23]11)|1(?:20[0-2]|111)))',
    '098' => '(?:(?:5(?:7(?:1[1-47]|[4-6][1-5]|3[489]|0[0-5]|2[1-35])|8(?:2[1-7]|0[0-8]|1[4-6])|2(?:21|0[1-7]|1[1-3])|5(?:00|[56][1-5])|1(?:[01][1-3])|44[1-5]|95[1-5])|3(?:5(?:[24][1-3]|3[1-4]|0[0-4]|1[12])|2(?:1[1-7]|0[0-7]|2[1-8])|3(?:61|0[0-6]|1[1-6])|1(?:51|3[1-5]|4[1-4]))|2(?:2(?:1[1-4]|[45][1-3]|2[0-7]|[03][0-8])|9(?:51|4[1-3])|36[1-8]|80[0-6]|62[1-6]|50[0-2]|181)|1(?:6(?:0[0-7]|1[1-6]|2[1-4])|2(?:0[0-7]|1[1-6])|70[0-8]|50[0-6]|42[1-4]|94[1-4]|33[12]|821)|0(?:1(?:2[1-6]|0[0-4]|[13][1-5])|5(?:0[1-9]|1[1-6])|3(?:00|4[12]|3[1-9])|63[12]|475)|6(?:2(?:00|2[2568]|3[1-4])|5(?:6[1-5]|7[1-6])|3(?:41|8[45])|10[1-6]|75[14-8]|64[2-5])|4(?:1(?:2[1-6]|4[01]|3[1-9]|[01][0-7])|4(?:6[1-8]|5[15-7])|58[12])))',
    '099' => '(?:(?:0(?:4(?:[01][0-8]|2[1-8])|2(?:0[1-7]|1[1-6])|1(?:11|0[12]|2[1-7])|87[1-9]|34[1-7]|70[1-5]|62[1-4])|1(?:4(?:1[1-8]|[23][1-7]|0[0-7])|1(?:3[1-8]|2[1-4]|1[2-8]|0[0-6])|36[1-7]|58[1-7]|25[1-4])|3(?:6(?:3[1-7]|0[0-5]|2[1-8]|1[1-6])|2(?:0[12]|2[1-5]|[13][1-4]|4[34])|11[1-9]|45[1-4]|50[1-4])|2(?:3(?:2[1-7]|6[12]|0[0-6]|5[14-6]|1[0-2]|[78][1-3])|1(?:0[1-7]|1[12])|42[1-4]|231)|4(?:1(?:00|1[1-8]|[24][1-7]|3[1-5])|40[0-7]|35[1-7]|52[1-6])|5(?:6(?:1[1-4]|0[0-6])|3(?:[56][1-5])|5(?:4[1-4]|5[1-3])|17[1-5])|6(?:4(?:1[1-5]|0[0-4])|2(?:[47][12])|32[1-35-9]|50[13-9]|13[1-3])))',
    '100' => '(?:(?:6(?:1(?:90|[1-3]\d|0[1-9]|4[0-4])|5(?:90|[12]\d|3[0-8]|0[1-9])|3(?:90|[12]\d|0[1-9]|3[0-7])|7(?:90|[1-3]\d|0[1-9]|4[0-3])|8(?:90|[12]\d|0[1-9]|3[0-7])|0(?:90|[12]\d|0[1-9]|3[0-6])|6(?:90|[1-3]\d|4[0-2]|0[1-9])|9(?:90|0[1-9]|3[0-4]|[12]\d)|4(?:90|[12]\d|3[0-3]|0[1-9])|2(?:90|3[01]|[12]\d|0[1-9]))|0(?:0(?:0[0-6]|1[1-4])|(?:[36]0|51)1|10[0-4]|40[0-2]|21[12])|1(?:(?:[37]0|51)1|10[0-3]|21[1-3]|62[1-3]|40[01])|70(?:90|[12]\d|0[1-9]|3[0-8])|2(?:10[01]|211)))',
    '101' => '(?:00(?:03|6[1-5]|2[1-9]|5[1-4]|[34][1-8]))',
    '102' => '(?:00(?:8[1-5]|9[1-4]|7[1-6]))',
    '103' => '(?:(?:00(?:2[1-8]|1[1-6]|0[0-8])|60(?:90|[12]\d|0[1-9]|3[0-5])))',
    '104' => '(?:(?:6(?:0(?:90|4[0-4]|0[1-9]|[1-3]\d)|2(?:90|3[0-3]|0[1-9]|[12]\d)|1(?:90|0[1-9]|[1-3]\d))|00(?:28|61|3[1-3]|4[1-6]|5[1-5])))',
    '105' => '(?:(?:7(?:0(?:90|[1-3]\d|0[1-9]|4[0-7])|1(?:90|[1-3]\d|4[0-3]|0[1-9])|3(?:90|[12]\d|0[1-9]|3[0-7])|2(?:90|[12]\d|3[0-4]|0[1-9])|4(?:90|3[0-2]|0[1-9]|[12]\d))|6(?:0(?:90|[12]\d|3[0-7]|0[1-9])|2(?:90|[1-3]\d|0[1-9]|4[0-2])|3(?:90|0[1-9]|3[0-6]|[12]\d)|1(?:[49]0|[1-3]\d|0[1-9]))|00(?:0[0-4]|1[1-4]|2[1-3])))',
    '106' => '(?:(?:6(?:1(?:90|0[1-9]|5[0-4]|[1-4]\d)|0(?:90|0[1-9]|4[0-5]|[1-3]\d))|00(?:4[1-7]|3[12])))',
    '107' => '(?:(?:6(?:2(?:90|[1-3]\d|4[0-5]|0[1-9])|0(?:90|3[0-7]|0[1-9]|[12]\d)|3(?:90|[1-3]\d|0[1-9])|1(?:[39]0|[12]\d|0[1-9]))|00(?:[56][12])))',
    '108' => '(?:(?:6(?:0(?:90|[12]\d|0[1-9]|3[0-2])|1(?:90|[12]\d|3[01]|0[1-9])|2(?:90|[12]\d|3[01]|0[1-9])|3(?:[39]0|0[1-9]|[12]\d))|00(?:14|2[23]|7[1-5])))',
    '110' => '(?:00(?:1[1-6]|0[0-8]))',
    '111' => '(?:00(?:2[1-5]|[35][1-6]|4[1-3]))',
    '112' => '(?:00(?:0[0-6]|1[1-5]))',
    '113' => '(?:00(?:01|[23][1-4]))',
    '114' => '(?:00(?:1[1-6]|[23][1-4]|0[0-5]))',
    '115' => '(?:00(?:4[1-5]|5[1-6]))',
    '116' => '(?:00(?:1[1-4]|0[0-3]))',
    '120' => '(?:00(?:2[1-6]|3[1-8]|0[0-6]|1[1-5]|4[1-7]))',
    '121' => '(?:0(?:0(?:1[12]|5[1-7]|7[1-6]|6[1-4])|8(?:2[2-5]|0[17]|3[1-7]|1[2-6])))',
    '123' => '(?:08(?:5[1-7]|[46][1-5]|7[1-4]))',
    '124' => '(?:00(?:2[1-5]|0[0-6]|1[1-4]))',
    '125' => '(?:00(?:02|3[1-5]|[46][1-3]|5[1-4]))',
    '130' => '(?:00(?:2[1-6]|1[1-5]|0[0-5]))',
    '131' => '(?:00(?:3[1-4]|4[1-6]))',
    '132' => '(?:00(?:0[0-3]|[23][1-5]|1[13-5]))',
    '133' => '(?:00(?:02|7[1-3]|4[1-4]|6[1-5]|5[1-7]))',
    '134' => '(?:00(?:03|9[1-3]|8[1-8]|1[35]))',
    '135' => '(?:(?:00(?:9[12]|6[1-5]|0[0-7]|[23][1-4]|4[1-8]|5[1-3]|1[1-6])|60(?:90|[12]\d|3[0-7]|0[1-9])))',
    '136' => '(?:00(?:7[1-6]|8[1-3]))',
    '140' => '(?:00(?:1[1-5]|0[0-5]))',
    '141' => '(?:(?:60(?:[39]0|0[1-9]|[12]\d)|00(?:01|3[1-3]|2[12])))',
    '142' => '(?:00(?:4[1-3]|[56][1-4]))',
    '143' => '(?:00(?:[02][1-7]|1[1-6]))',
    '144' => '(?:00(?:00|4[1-7]|3[1-5]|5[1-6]))',
    '145' => '(?:00(?:6[1-7]|7[1-6]))',
    '146' => '(?:00(?:[89][1-5]))',
    '150' => '(?:(?:00(?:0[0-2]|4[1-7]|2[12]|3[1-6]|1[1-3])|60(?:90|[1-3]\d|0[1-9])))',
    '151' => '(?:00(?:[57][1-3]|6[1-6]))',
    '152' => '(?:00(?:[12][1-3]|3[1-5]|0[0-4]))',
    '153' => '(?:00(?:5[1-3]|4[1-4]|6[1-5]))',
    '154' => '(?:00(?:2[1-4]|1[1-7]|0[0-5]))',
    '155' => '(?:003[1-3])',
    '156' => '(?:00(?:5[1-7]|4[1-5]))',
    '157' => '(?:00(?:7[1-7]|6[1-8]))',
    '158' => '(?:00(?:9[1-8]|8[1-7]))',
    '160' => '(?:(?:00(?:1[1-8]|2[1-3]|0[0-8])|61(?:90|[1-3]\d|0[1-9])))',
    '161' => '(?:003[1-5])',
    '162' => '(?:0(?:8(?:[0-4][1-8]|5[1-7])|0(?:5[1-6]|4[1-5]|6[1-7])))',
    '163' => '(?:(?:0(?:4(?:90|5[0-5]|0[1-9]|[1-4]\d)|6(?:90|0[1-9]|5[0-4]|[1-4]\d)|2(?:90|5[0-2]|0[1-9]|[1-4]\d)|5(?:[59]0|0[1-9]|[1-4]\d)|7(?:90|1\d|0[1-9]|2[0-6])|8(?:[39]0|[12]\d|0[1-9])|9(?:[39]0|0[1-9]|[12]\d))|1(?:4(?:90|5[0-4]|0[1-9]|[1-4]\d)|0(?:90|5[0-2]|0[1-9]|[1-4]\d)|3(?:90|0[1-9]|4[0-4]|[1-3]\d)|5(?:90|3[01]|[12]\d|0[1-9])|1(?:[39]0|[12]\d|0[1-9]))|60(?:90|[12]\d|0[1-9]|3[0-8])))',
    '164' => '(?:00(?:0[0-3]|1[1-4]))',
    '165' => '(?:00(?:3[1-5]|2[1-7]))',
    '166' => '(?:00(?:1[1-6]|0[0-4]))',
    '167' => '(?:00(?:3[1-5]|5[1-4]|[24][1-3]))',
    '168' => '(?:00(?:7[1-4]|6[1-5]|8[12]))',
    '169' => '(?:00(?:7[1-5]|5[12]))',
    '170' => '(?:(?:60(?:[69]0|0[1-9]|[1-5]\d)|00(?:1[1-4]|0[0-5])))',
    '171' => '(?:00(?:14|[25][12]|3[1-3]|4[1-4]))',
    '173' => '(?:00(?:[23][1-7]|0[1-5]|1[1-6]))',
    '174' => '(?:00(?:00|6[1-5]|[457][1-6]))',
    '175' => '(?:00(?:45|8[1-5]|9[1-4]))',
    '176' => '(?:00(?:2[1-5]|0[0-6]|1[1-4]))',
    '177' => '(?:00(?:[34][1-5]|5[1-4]))',
    '178' => '(?:006[1-6])',
    '179' => '(?:00(?:8[1-5]|7[1-6]))',
    '180' => '(?:00(?:0[0-6]|1[1-4]|2[1-3]))',
    '181' => '(?:00(?:1[1-6]|0[0-5]))',
    '182' => '(?:00(?:[23][1-6]|0[0-7]|1[1-7]))',
    '183' => '(?:00(?:[25][1-7]|0[0-6]|[134][1-6]))',
    '184' => '(?:00(?:1[1-5]|0[0-5]))',
    '185' => '(?:00(?:3[1-6]|[12][1-4]|0[0-5]))',
    '186' => '(?:00(?:0[0-5]|1[1-5]))',
    '187' => '(?:00(?:1[1-3]|0[0-4]|[2-4][1-5]))',
    '188' => '(?:00(?:[01][1-4]))',
    '189' => '(?:00(?:1[1-4]|2[1-6]|0[0-3]))',
    '190' => '(?:(?:0(?:1(?:00|6[1-6]|[47][1-4]|5[1-5]|8[12])|0(?:1[1-5]|0[0-4]|3[1-4]|2[1-3])|2(?:1[1-4]|2[1-3]|0[0-5]))|12(?:[1-3][1-4]|0[0-4])))',
    '191' => '(?:00(?:[56][1-5]|0[0-3]|[23][1-4]|4[1-3]|1[1-6]))',
    '192' => '(?:0(?:0(?:0[0-5]|[278][1-5]|[14-6][1-6]|3[1-4])|3(?:[57][1-5]|6[1-4])|9(?:1[1-9]|0[2-467])|15[1-6]))',
    '193' => '(?:0(?:8(?:[1-4][1-6]|0[1-4])|9(?:3[1-5]|4[1-4])))',
    '194' => '(?:0(?:0(?:4[1-6]|2[1-3]|3[1-8]|0[0-4]|1[1-5])|2(?:1[1-5]|0[1-4])))',
    '195' => '(?:00(?:7[1-5]|5[1-7]|6[1-4]))',
    '196' => '(?:00(?:0[0-4]|[12][1-5]|3[1-4]))',
    '197' => '(?:0(?:8(?:1[1-6]|[03][1-4]|2[1-8])|0(?:0[0-5]|[12][1-4])))',
    '198' => '(?:0(?:0(?:8[1-9]|[12][1-5]|3[126]|0[0-5]|4[1-46]|6[1-4]|5[1-3])|1(?:0[1-7]|7[1-5])|2(?:2[1-5]|1[1-3])))',
    '201' => '(?:00(?:0[0-5]|1[1-6]))',
    '202' => '(?:00(?:2[1-3]|0[0-6]|1[1-5]))',
    '203' => '(?:00(?:0[0-4]|2[1-3]|[13-5][1-4]))',
    '204' => '(?:00(?:1[1-3]|2[1-4]|0[0-4]))',
    '205' => '(?:00(?:2[1-4]|1[1-7]|0[0-3]))',
    '206' => '(?:0(?:0(?:0[0-4]|[12][1-5]|4[12]|3[1-6])|8(?:1[12]|[02][1-4])))',
    '207' => '(?:00(?:0[0-5]|1[1-6]|[23][1-3]))',
    '208' => '(?:00(?:[12][1-3]|3[1-5]|0[0-4]))',
    '210' => '(?:0(?:8(?:[0-5][1-8]|6[1-9])|0(?:0[0-7]|1[1-5]|2[1-6])))',
    '211' => '(?:00(?:1[1-6]|5[1-3]|6[1-8]|0[0-7]|3[1-7]|[24][1-5]))',
    '212' => '(?:00(?:1[1-6]|3[1-3]|5[1-8]|0[0-7]|2[1-7]))',
    '213' => '(?:00(?:[13][1-5]|2[1-7]|0[0-6]))',
    '214' => '(?:00(?:1[1-4]|2[1-3]|3[1-9]|0[0-8]))',
    '215' => '(?:00(?:3[1-6]|1[1-8]|2[1-7]|0[0-7]))',
    '216' => '(?:00(?:2[1-6]|0[0-7]|[13][1-5]))',
    '220' => '(?:(?:6(?:0(?:90|[12]\d|0[1-9]|3[0-5])|1(?:90|1\d|0[1-9]|2[0-8])|2(?:90|1\d|2[01]|0[1-9]))|00(?:[35][1-5]|0[0-6]|[16][1-3]|4[1-6]|[27][1-4])|81(?:[79]0|0[1-9]|[1-6]\d)))',
    '221' => '(?:0(?:0(?:2[1-4]|[34][1-6]|[57][1-7]|[16][1-5]|0[0-5])|8(?:6[2-6]|[23][1-5]|5[1-6]|[014][1-4])))',
    '222' => '(?:00(?:0[0-4]|2[1-6]|1[1-3]|3[2-7]))',
    '223' => '(?:00(?:5[1-9]|6[1-6]))',
    '224' => '(?:00(?:[35][1-7]|[146][1-6]|2[13-9]|0[01346-8]))',
    '225' => '(?:00(?:[12][1-6]|0[1-5]))',
    '226' => '(?:00(?:0[0-6]|2[1-9]|1[1-8]))',
    '227' => '(?:00(?:00|[34][1-8]|5[1-5]|6[1-7]))',
    '230' => '(?:00(?:2[1-7]|5[1-5]|0[0-4]|[1347][1-8]|6[1-3]))',
    '231' => '(?:0(?:8(?:[3-5][1-9]|2[1-7]|6[1-8]|[01][1-6])|0(?:1[1-7]|0[0-7]|[2-5][1-8]|6[1-6])))',
    '232' => '(?:00(?:7[1-6]|1[1-8]|0[0-8]|4[1-5]|[2356][1-7]))',
    '233' => '(?:00(?:1[1-6]|0[0-8]))',
    '234' => '(?:005[1-6])',
    '235' => '(?:00(?:3[1-6]|2[1-4]|0[0-8]|4[1-5]|1[1-9]))',
    '236' => '(?:00(?:[235][1-8]|4[1-6]|0[0-7]|1[1-7]))',
    '237' => '(?:00(?:6[1-8]|7[1-9]))',
    '238' => '(?:0(?:0(?:4[1-8]|[235][1-6]|1[1-9]|0[0-8])|2(?:00|4[1-6]|2[1-5]|3[1-7])|1(?:[01][1-5])|31[1-7]))',
    '239' => '(?:08(?:2\d|0[1-8]|1[1-5]|[34][1-7]))',
    '240' => '(?:0(?:0(?:5[1-3]|[2-4][1-6]|0[0-7]|[16][1-7])|1(?:0[0-8]|1[1-6])))',
    '241' => '(?:0(?:8(?:1[1-7]|[023][1-6])|0(?:[12][1-5]|0[0-5]|3[1-4])))',
    '242' => '(?:00(?:2[1-9]|0[0-8]|1[1-8]))',
    '243' => '(?:0(?:0(?:41|3[1-9]|0[0-7]|[12][1-8])|4(?:0[0-6]|2[1-7]|3[1-6]|1\d)|2(?:1[1-7]|0[1-8])|8(?:[01][1-7])|1(?:00|1[12]|2[1-6])|30[0-8]))',
    '244' => '(?:0(?:8(?:0[1-6]|4[1-5]|1[1-7])|00[0-4]))',
    '245' => '(?:00(?:6[1-7]|[25][1-3]|1[1-8]|0\d))',
    '246' => '(?:00(?:1[1-5]|0[0-8]|3[124-8]|2[1-356]))',
    '247' => '(?:00(?:[137][1-5]|[56][1-6]|0\d|2[1-8]))',
    '248' => '(?:00(?:3[1-6]|0[0-7]|[12][1-7]))',
    '249' => '(?:000[0-8])',
    '250' => '(?:0(?:0(?:0[0-5]|[23][1-5]|[45][1-6]|1[1-4])|1(?:3[1-6]|[12][1-7]|0[0-7])|8(?:6[1-6]|[57][1-8])|2(?:[01][1-8])|5(?:00|2[1-3])|40[1-8]|31[1-5]|631))',
    '251' => '(?:0(?:0(?:[145][1-7]|0[0-4]|[23][1-8])|8(?:7[1-7]|6[12])))',
    '252' => '(?:(?:0(?:1(?:24|7[1-6]|8[1-8]|4[1-46]|6[12]|1[1-7]|3[124-7]|5[1-9]|0[0-6])|2(?:0[0-35-8]|1[1-7]|[23][1-9]|5[134]|4[1-6])|3(?:44|3[1-6]|1[1-8]|2[1-9]|0[0-7])|0(?:2[1-7]|0[0-5]|1[1-6])|8(?:0[1-7]|[12][1-6]))|11(?:1[1-6]|0[0-8]|[23][1-7])))',
    '253' => '(?:0(?:0(?:7[1-4]|[128][1-8]|5[1-6]|[46][1-5]|3[1-7]|0[0-8])|1(?:0[0-6]|1[1-4])))',
    '254' => '(?:0(?:0(?:0[0-5]|1[1-689]|[56][1-5]|[247][1-7]|3[1-6]|8[1-8])|8(?:0[1-7]|1[1-5]|2[1-6])|9(?:0[1-6]|1[1-5])))',
    '255' => '(?:000[0-5])',
    '256' => '(?:08(?:0[1-8]|1[1-7]))',
    '257' => '(?:00(?:61|0[0-7]|[35][1-7]|[124][1-8]))',
    '258' => '(?:0(?:0(?:[12][1-9]|0[0-4])|1(?:00|2[1-6]|1[1-5])|20[1-4]))',
    '259' => '(?:(?:1(?:1(?:0[0-7]|4[1-7]|[1-3][1-8])|3(?:2[1-6]|[01][1-7]|3[1-5])|2(?:20|1[1-9]|0[1-7]))|0(?:1(?:0[0-5]|2[1-5]|5[1-7]|[13][1-4]|4[1-8])|3(?:0[0-5]|1[1-46-8])|20[0-2])))',
    '260' => '(?:0(?:8(?:[12][1-6]|4[1-4]|0[1-8]|3[1-5]|5[1-7])|0(?:[12][1-8]|4[1245]|3[1-4]|0[0-7])))',
    '261' => '(?:(?:71(?:90|3[0-5]|0[1-9]|[12]\d)|00(?:2[1-6]|1[1-4]|0[0-5])))',
    '262' => '(?:00(?:0[0-7]|1[1-9]|4[1-8]|3[1-3]|2[1-6]))',
    '263' => '(?:00(?:0[0-5]|[23][1-5]|1[1-6]|[45][1-4]))',
    '264' => '(?:00(?:2[013-9]|[13][1-7]|0[0-7]))',
    '265' => '(?:00(?:[67][1-7]|4[1-6]|5[1-3]))',
    '266' => '(?:00(?:3[1-4]|2[1-6]|1[14-6]|0[0-7]))',
    '267' => '(?:00(?:[56][1-7]))',
    '270' => '(?:(?:1(?:1(?:1[1-9]|4[1-7]|0[0-8]|[235-7][1-8])|4(?:71|3[1-9]|[45][1-7]|0[0-8]|[126][1-6])|5(?:0[0-6]|[12][1-7]|[34][1-6])|3(?:00|2[1-8]|[4-6]\d|1[3568]|3[1-9])|6(?:1[1-8]|0[1-9]))|0(?:1(?:1[1-8]|6[1-4]|[47][1-6]|0[0-35-8]|[235][1-7])|0(?:3[1-6]|[12][1-8]|0[0-7])|2(?:3[1-9]|1[1-7]|0[1-6]|2[1-8]))|2(?:2(?:[025][1-5]|3[12]|6[1-7]|4[1-3]|1[1-8])|3(?:31|[12][1-9]|0[1-8]))))',
    '271' => '(?:00(?:[79][1-7]|5[1-4]|[468][1-8]))',
    '272' => '(?:0(?:1(?:4[1-6]|3[1-8]|[02][1-7]|1[1-5])|8(?:1[1-6]|[23][1-7]|0[1-5])|0(?:[13][1-5]|0[0-4]|2[1-6])))',
    '273' => '(?:0(?:0(?:3[1-9]|0[0-5]|[124][1-8])|1(?:0[0-7]|3[1-7]|1[1-9]|2[1-8])|8(?:6[1-7]|5[1-5])))',
    '274' => '(?:0(?:8(?:2[1-6]|1[1-8]|0[1-7])|0(?:6\d|5[1-6]|7[1-7]|8[12])))',
    '275' => '(?:00(?:2[1-8]|1[1-7]|0[0-6]))',
    '276' => '(?:00(?:4[1-9]|[13][1-7]|0[0-8]|2\d))',
    '277' => '(?:0(?:0(?:6[1-6]|3[1-4]|[28][1-8]|0[0-8]|1[1-7]|[457][1-5])|8(?:[67][1-3]|[48][1-6]|1[1-4]|5[1-8]|0[1-5]|[23][1-7])|9(?:[01][1-3]|2[1-4]|3[12]|4[1-5])))',
    '278' => '(?:00(?:[2-4][1-8]|[15][1-7]|0[0-7]))',
    '279' => '(?:00(?:0[0-4]|3[12]|2[1-6]|4[1-3]|1[1-4]))',
    '282' => '(?:00(?:0[1-79]|1[0-2]|2[17]|3[1-5]))',
    '283' => '(?:0(?:0(?:1[1-6]|[2-46][1-8]|0[0-6]|5[1-7])|8(?:[03][1-5]|[12][1-6])|1(?:0[0-7]|1[1-7])))',
    '284' => '(?:00(?:1[1-6]|0\d|4[1-5]|[23][1-7]))',
    '285' => '(?:0(?:0(?:[246][1-6]|0\d|7[1-8]|3[1-9]|[15][1-7])|8(?:5\d|0[1-8]|4[1-6]|2[1-5]|[36][1-7]|1[1-9])|9(?:1[1-4]|2[1-8]|0[0-7])))',
    '286' => '(?:0(?:0(?:2[1-9]|3[1-7]|0[0-7]|[14][1-8])|8(?:1[1-9]|[23][1-7]|4[1-6]|0[1-8])|1(?:[23][1-7]|[01][1-8])|2(?:0[0-5]|2[1-5]|1[1-6])))',
    '287' => '(?:0(?:0(?:5[1-6]|[134][1-8]|[26][1-7]|0[0-6])|2(?:1[1-7]|0[1-6]|3[2-7]|2[12457]|4[1-4])|8(?:[0-2][1-6])|10[1-7]))',
    '288' => '(?:0(?:0(?:0[0-7]|[27][1-7]|[15][1-6]|[346][1-8])|8(?:[56][1-8]|4[1-6]|[02][1-5]|[137][1-7])))',
    '289' => '(?:(?:1(?:7(?:0[0-8]|[125][1-7]|[34][1-9])|1(?:4[1-5]|0[0-8]|3[1-8]|[12][1-6])|3(?:[12][1-8]|0[0-6]|[34][1-5])|5(?:[0-3][1-7])|6(?:2[1-6]|1[1-9]|0[0-8])|2(?:1[1-8]|[02][1-6])|80[1-6])|2(?:1(?:3[1-6]|0[0-8]|[12][1-5]|[467][1-9]|5[1-7])|5(?:0[0-5]|[23][1-5]|1[1-6])|2(?:00|3[1-6]|[45][1-7])|3(?:0[1-6]|1[1-7]|2[1-5])|6(?:0[1-7]|1[1-6])|7(?:0[1-8]|1[1-5]))|0(?:3(?:1[1-4]|[03][1-8]|[24][1-9])|6(?:0[0-2]|[23][1-7]|1[1-9])|2(?:0[1-5]|1[1-7]|2[1-6])|4(?:2[1-6]|0[1-8]|1[1-4])|1(?:2[1-6]|0\d|1[1-7])|5(?:1[1-8]|0[1-7]))|318[1-6]))',
    '290' => '(?:0(?:0(?:81|5\d|3[1-8]|[12][1-6]|7[1-5]|6[1-9]|4[1-7]|0[0-8])|2(?:1[1-7]|[0256][1-9]|3[1-6]|4[1-4])|5(?:[02-5][1-9]|1[1-8])|1(?:5[1-7]|7\d|6[1-8]|4[1-3])))',
    '292' => '(?:(?:0(?:0(?:71|0\d|3[1-8]|1[1-6]|4[1-5]|[256][1-7])|4(?:[3-5][1-5]|0[1-4]|1[1-6]|2[1-3])|8(?:[02][1-7]|[13][1-9])|5(?:1[1-6]|0[1-3]|[23][1-7])|2(?:[01][1-7]))|11(?:7[1-9]|[56][1-8]|4\d)))',
    '293' => '(?:00(?:2[1-4]|5[1-8]|[34][1-6]|1[1-3]|0[0-6]))',
    '294' => '(?:0(?:0(?:2[1-9]|0\d|[13-5][1-8])|8(?:[02][1-6]|1[1-7])|3(?:0[1-8]|1[1-6])|2(?:2[1-6]|3[1-5])))',
    '295' => '(?:0(?:0(?:2[1-7]|0[1-6]|1[1-4])|10[1-4]))',
    '296' => '(?:0(?:0(?:0[0-4]|[2-4][1-5]|1[1-6])|1(?:1[1-5]|[02][1-6])|23[1-7]))',
    '297' => '(?:0(?:0(?:0\d|[57][1-8]|4[1-5]|6[1-7]|[1-3][1-9])|1(?:3[1-8]|0[0-5]|[1245][1-5])|2(?:0[0-7]|3[1-5]|1[1-8]|2[1-6])))',
    '298' => '(?:0(?:2(?:7[1-9]|[16][1-7]|0[0-7]|[45][1-6]|[23][1-8])|1(?:3[1-5]|1[1-7]|[02][1-6])|0(?:2[1-9]|0[0-5]|1[1-8])))',
    '299' => '(?:(?:4(?:3(?:[23][1-8]|1[1-6]|4[1-7]|0[0-6])|1(?:[12][1-8]|0[1-6])|4(?:0[0-6]|[12][1-5])|2(?:1[1-8]|0[0-6])|6(?:1[1-6]|2[1-5])|50[1-8])|2(?:8(?:5[1-8]|[46][1-7])|5(?:1[1-7]|2[1-6]|0[1-8])|7(?:0[1-5]|1[1-6]|2[1-8])|2(?:[0-2][1-6])|4(?:0[0-4]|1[1-8])|1(?:00|1[1-8]))|1(?:1(?:5[1-4]|3[1-8]|[67][1-6]|[124][1-7]|0[0-8])|7(?:5[1-9]|[34][1-7])|6(?:2[12]|0[1-9]|1[1-8])|90[1-9]|861)|0(?:2(?:71|[13-5][1-7]|0[0-5]|6[1-8]|2[1-6])|1(?:2[1-8]|[01][1-9]))|5(?:2(?:0[0-6]|6[1-7]|1[1-9]|3[1-5]|2[1-8]|7[1-4]|[45][1-6])|1(?:1[1-4]|0[0-7])|50[1-6])|32(?:5[1-6]|2[1-3]|6[1-8]|0[0-3]|[14][1-9]|3[1-7])))',
    '300' => '(?:(?:0(?:0(?:0\d|[23][1-8]|[15][1-6]|[46][1-9])|8(?:50|1\d|2[1-6]|0[1-5]|7[1-7]|[34][1-9])|6(?:3[1-8]|4[1-3]|2[1-6]|[01][1-7])|3(?:41|2[1-6]|0[0-6]|3[1-7]|1[1-5])|7(?:[23][1-7]|4[1-9])|4(?:[01]\d|2[0-8]|3[1-7])|5(?:2[1-9]|1[1-5]|0\d)|1(?:3[1-6]|2[1-7])|2(?:0[1-5]|1[1-4]))|2(?:3(?:4[1-8]|0[0-8]|[23][1-7]|5[1-9]|1[1-5])|6(?:[56][1-9]|1[1-7]|2[1-4]|[34][1-8])|4(?:[01][1-7]|[2-5][1-6])|7(?:[0-2][1-7]|4[1-8]|3[1-6])|5(?:0[1-7]|1[1-3]|2[1-6]))|1(?:2(?:5[1-9]|[13][1-7]|0[0-7]|2[1-5]|[78][1-8]|[46]\d)|5(?:2[1-5]|3[1-9]|[14][1-6]|0[1-8])|6(?:0[0-6]|[1-3][1-6])|3(?:00|[23][1-7]|1[1-6])|4(?:[12][1-7]|0[1-6])|1(?:61|5[1-9]))|4(?:2(?:51|3[1-6]|1[1-8]|2[1-4]|0[1-5]|4[1-9])|5(?:3[1-8]|4[1-6]|[01][1-7]|2[1-5])|4(?:2[1-9]|1[1-7]|0[1-8])|1(?:[01][1-8])|35[1-4])|3(?:5(?:5[1-6]|[13][1-9]|2[1-7]|7[12]|[46][1-5]|0[0-6])|2(?:[56][1-7]))))',
    '301' => '(?:0(?:8(?:[145][1-7]|3[1-9]|[02][1-6])|0(?:0[0-7]|3[1-5]|2[1-6]|[14][1-8])|90[12]))',
    '302' => '(?:0(?:0(?:[12][1-7]|0[0-7]|3[1-9])|1(?:31|2[1-8]|0\d|1[0-25-9])))',
    '303' => '(?:00(?:[24][1-6]|3[1-4]|1[1-8]|0[0-6]))',
    '304' => '(?:0(?:0(?:3[1-5]|[05][0-7]|[46][1-9]|[12][1-8]|7[1-6])|8(?:2[1-4]|0[1-6]|1[1-9])))',
    '305' => '(?:0(?:0(?:0[0-8]|[47][1-7]|[12][1-9]|[35][1-6]|6[1-8])|8(?:3[1-6]|[16][1-8]|[28][1-4]|[457][1-7]|0[1-5])|90[1-3]))',
    '306' => '(?:0(?:0(?:4[1-7]|0[0-7]|[125][1-6]|3[1-8])|6(?:2[1-6]|0[0-8]|[135][1-7]|4[1-5])|4(?:3[1-5]|[12][1-7]|0[0-7])|2(?:[0-3][1-6])|1(?:1[0-6]|0[13-9]|2[1-8])|3(?:1[1-7]|0[0-7])|5(?:[01][1-5])))',
    '307' => '(?:00(?:3[1-8]|4[1-6]|2[1-9]|1[1-7]|0[0-7]|5[1-5]))',
    '308' => '(?:0(?:8(?:1[1-6]|[34][1-8]|[0256][1-7])|0(?:[23]1|5[1-6]|0[0-7]|[167][1-7]|4[12])|1(?:0[1-8]|2[1-9]|1[1-7])))',
    '309' => '(?:1(?:2(?:4[1-6]|3[1-4]|0[0-5]|[12][1-7])|6(?:[12][1-6]|0[0-7]|3[1-7])|7(?:1[1-7]|3[1-8]|[02][1-6])|1(?:0[1-8]|[12][1-7])|3(?:[34][1-7])|4(?:6[1-6]|5[1-8])))',
    '310' => '(?:0(?:0(?:1[1-5]|0[0-5]|6[1-8]|[2-5][1-6])|8(?:1[1-8]|3[1-6]|5[1-3]|[24][1-7]|0[1-5])|9(?:0[1-5]|1[1-4])))',
    '311' => '(?:(?:1(?:2(?:[1346][1-8]|5[1-5]|2[1-9]|0[1-7])|5(?:[12][1-8]|3[1-7]|0[0-6])|4(?:2[1-7]|[01][1-6])|1(?:[12][1-5]|3[1-6])|7(?:2[1-4]|1[1-6]|0[1-5])|3(?:1[1-3]|0[0-7]))|3(?:1(?:0[0-8]|[145][1-7]|2[1-5]|3[1-8])|8(?:0[0-7]|[12][1-7]|3[1-6])|4(?:[13][1-7]|[02][1-6])|5(?:[01][1-8]))|4(?:3(?:4[1-4]|0[0-6]|1[1-7]|[23][1-5])|1(?:4[1-6]|[56][1-5])|4(?:11|0[1-7])|20[1-8]|61[1-8]|50[1-3])|2(?:4(?:3[1-7]|1[025-9]|[04]\d|2[1-6])|2(?:2[1-4]|1[1-5]|0[1-7])|1(?:1[1-8]|0[1-5]))|0(?:1(?:0\d|[23][1-6]|1[0-8])|3(?:01|2[1-5]|1[1-4])|50[1-9]|40[1-4])))',
    '312' => '(?:00(?:[145][1-8]|3[1-6]|6[1-3]|0[0-7]|2[1-7]))',
    '313' => '(?:0(?:0(?:[15][1-6]|6[1-4]|3[1-8]|0[0-8]|4[1-9]|2[1-7])|1(?:[02][1-6]|1[1-7]|3[1-5])|2(?:[12][1-5])|35[1-3]))',
    '314' => '(?:0(?:0(?:0[0-7]|1[1-7]|5[12]|[24][1-8]|3\d)|1(?:3[1-5]|0[0-3]|[24][1-8]|1[1-6])|25[2-8]|34[1-7]|40[78]))',
    '315' => '(?:0(?:0(?:3[0-8]|[26][1-9]|[457][1-8]|[01]\d)|1(?:[134][1-8]|[02][1-5]|[56][1-7])))',
    '316' => '(?:00(?:0[1-7]|1[1-5]|[23][1-6]))',
    '317' => '(?:00(?:00|7[1-7]|[56][1-6]))',
    '318' => '(?:0(?:0(?:[13][1-4]|0[0-5]|2[1-5])|10[1-6]))',
    '319' => '(?:(?:1(?:5(?:00|4[1-7]|5[1-9]|3[1-8])|7(?:2[1-7]|1[1-5]|0[1-4])|2(?:[23][1-5])|1(?:0\d|1[1-8])|30[1-8]|41[1-8])|2(?:2(?:[56][1-6]|1[1-4]|0[0-5]|2[1-7])|1(?:0[2-7]|3[1-6]|4[1-5])|4(?:0[1-5]|1[1-8])|51[1-3]|60[1-3])|3(?:5(?:00|1[1-5]|[25][1-6]|4[1-4]|3[1-8])|1(?:[01][1-7])|36[1-6]|70[1-5])|0(?:1(?:[12][1-6]|3[1-7]|0[0-8])|3(?:2[1-5]|[01][1-7])|20[1-9])))',
    '320' => '(?:0(?:0(?:[07][1-5]|[12][1-7]|4[1-9]|6[1-6]|[35][1-8])|8(?:[56][1-7]|[0-4][1-8])))',
    '321' => '(?:(?:0(?:9(?:1[1-8]|5[1-4]|0[1-6]|[2-48][1-5]|6[1-9]|7[1-7])|1(?:[015][1-8]|[24][1-7]|[36][1-9])|2(?:1[1-9]|0[0-7]|[23][1-8])|6(?:3[1-6]|1[1-8]|0[0-5]|2[1-9])|5(?:1[1-7]|[03][1-5]|2[1-8])|4(?:[01][1-7])|34[1-7]|000)|4(?:3(?:[12][1-6]|3[1-8]|0\d|6[1-9]|[45][1-7])|5(?:51|2[1-3]|0[1-8]|3[1-9]|[14][1-7])|2(?:00|1[1-8]|2[1-7])|4(?:[01][1-6])|10[1-7])|3(?:5(?:00|[45][1-7]|[36][1-6])|3(?:1[1-6]|2[1-5]|0[0-7])|4(?:1[1-5]|0[0-6]|2[1-6])|2(?:3[1-7]|2[1-6])|62[1-8]|70[1-7])|2(?:3(?:[35][1-6]|4[1-5])|4(?:1[1-4]|0[1-5]|2[1-7])|1(?:1[1-8]|0[1-5])|6(?:1[1-6]|0[1-4])|5(?:01|2[1-6])|71[1-8]|80[1-6])|1(?:4(?:0[0-7]|4[1-9]|1[1-5]|[23][1-6])|5(?:2[1-4]|0[1-8]|1[1-5])|2(?:6[1-6]|7[1-7])|1(?:11|0[1-8])|35[1-6]|66[12])))',
    '322' => '(?:0(?:0(?:[2-467][1-9]|0\d|[15][1-8])|5(?:3[1-6]|2[1-8])|3(?:4[1-6]|0[1-7])|25[1-6]|60[1-6]|10[1-3]|42[1-3]))',
    '323' => '(?:(?:0(?:0(?:4[1-6]|5[1-8]|0\d|3[1-4]|[26][1-9]|1[1-7])|1(?:5[1-8]|1[1-6]|0[1-7])|8(?:31|1[1-9]|2\d|0[1-8]))|110[1-8]))',
    '324' => '(?:0(?:0(?:[1-35][1-8]|6[1-6]|0[0-6]|4[1-7])|2(?:1[1-5]|[34][1-6]|2[1-4]|0[1-8])|6(?:0[0-8]|1[1-8])|5(?:[01][1-6])|4(?:[01][1-5])))',
    '325' => '(?:0(?:0(?:7[1-6]|[45][1-8]|0[0-3]|3[1-9]|[126][1-7])|1(?:[01][1-8])|30[1-4]))',
    '326' => '(?:0(?:0(?:[23][1-7]|0[0-7]|[4-6][1-8]|1[1-6])|8(?:0[1-8]|[24][1-6]|[13][1-7])|3(?:[23][1-8])|1(?:4[1-4]|0[1-3])))',
    '327' => '(?:0(?:8(?:1[1-8]|[02-4][1-7])|0(?:2[1-8]|4[1-6]|3[1-5]|1[1-7]|0[0-7])|3(?:1[1-8]|0[1-7]|2[1-5])|5(?:0[1-57-9]|1[1-7]|2[3-5])|10[1-4]|231))',
    '328' => '(?:0(?:0(?:[47][1-5]|[1-3][1-7]|0[0-7]|6[1-8]|5[1-4])|1(?:1[1-4]|[23][1-5]|0[1-7])|2(?:21|1[12]|0[1-6])))',
    '329' => '(?:(?:2(?:7(?:3[1-5]|0[1-7]|1[1-3]|5[1-6]|6[1-4]|[24][1-8])|1(?:00|[35][1-6]|2[1-4]|[46][1-5])|2(?:00|[12][1-6])|8(?:0[1-7]|1[1-6])|5(?:1[1-4]|0[1-6])|33[1-9]|92[1-4]|44[12])|0(?:5(?:30|0[1-7]|[12][1-9])|4(?:3[1-4]|0[0-3]|1[1-578]|2[1-5])|2(?:[01][1-7]|2[1-9])|6(?:0[0-8]|1[1-8])|1(?:1[1-5]|0[0-5])|31[1-9])|1(?:2(?:3[1-5]|1[1-7]|0[0-7]|2[1-6])|3(?:3[1-4]|1[1-6]|0[0-6]|2[1-7])|1(?:1[1-7]|0[1-8])|4(?:0[1-6]|1[1-7])|57[1-9])|3(?:1(?:[245][1-7]|3[1-6])|4(?:[34][1-7])|2(?:00|[12][1-5]))|4(?:4(?:0[1-7]|[12][1-5])|3(?:0[1-9]|1[1-6])|21[1-7])))',
    '330' => '(?:(?:0(?:0(?:00|81|[45][1-6]|[67][1-5])|8(?:0[0-5]|3[4-6]|[45][1-6]))|60(?:90|3[0-5]|0[1-9]|[12]\d)))',
    '331' => '(?:0(?:0(?:00|4[5-9]|5[2-9]|6\d|7[1-7])|8(?:[12][1-5]|0[0-5])))',
    '332' => '(?:00(?:3[1-5]|0[0-7]|1[1-7]|2[1-9]))',
    '333' => '(?:08(?:6[1-9]|[15][1-7]|[23][1-6]|[04][1-8]))',
    '334' => '(?:00(?:5[1-9]|[01][1-5]|6[1-8]|7[1-6]))',
    '335' => '(?:00(?:0[0-5]|[23][1-7]|1[1-6]))',
    '336' => '(?:0(?:9(?:[26][1-6]|3[1246]|1[1-8]|0[035-7]|7[1-7])|0(?:00|2[1-7]|1[5-8]|3[1-68]|4[1-3])))',
    '337' => '(?:00(?:3[1-6]|5[1-4]|0[0-8]|4[1-5]|[12][1-7]))',
    '338' => '(?:0(?:8(?:00|2[1-6]|[13][1-7])|0(?:0[1-7]|1[1-4])))',
    '339' => '(?:00(?:0\d|[157][1-8]|8[12]|6[1-9]|[2-4][1-7]))',
    '340' => '(?:0(?:1(?:6[1-4]|[1-5][1-6]|0[0-5])|0(?:[24][1-8]|[35][1-6]|0[0-7]|1[1-7])|8(?:0[0-8]|3[1-5]|[12][1-6])|2(?:1[1-8]|0[1-6])))',
    '341' => '(?:00(?:[05]\d|[1-3][1-8]|4[1-6]))',
    '342' => '(?:00(?:[124][1-7]|0[0-8]|5\d|3[1-8]))',
    '343' => '(?:0(?:8(?:[45][1-6]|[0-3][1-8])|0(?:0[0-8]|[2-4][1-7]|1[1-5])|1(?:1[1-7]|0[0-6])))',
    '344' => '(?:0(?:0(?:[34][1-8]|[12][1-6]|6[1-7]|5[1-9]|0[0-7])|1(?:[0-2][1-7]|3[1-6])))',
    '345' => '(?:0(?:0(?:0[0-5]|[34][1-7]|[12][1-5])|8(?:0[1-4]|3[1-6]|[12][1-7])))',
    '346' => '(?:0(?:0(?:1[1-6]|3[1-8]|2[1-9]|0[0-7])|1(?:1[1-5]|0[1-6])))',
    '347' => '(?:0(?:0(?:3[1-4]|1\d|[256][1-8]|0[0-8]|4[1-7])|1(?:0[1-8]|2[1-6]|1[1-7])))',
    '348' => '(?:00(?:71|[245][1-8]|1[1-7]|3[1-9]|6[1-5]|0[0-6]))',
    '349' => '(?:(?:1(?:1(?:0[1-6]|[45][1-8]|[23][1-5]|1[1-7])|2(?:21|1[1-6]|0[1-5]))|0(?:1(?:2[1-8]|[14][1-5]|3[1-7]|0[0-4])|2(?:2[1-6]|1[1-9]|0[0-5]))))',
    '350' => '(?:(?:0(?:2(?:[1-36][1-9]|[457][1-8]|0\d)|1(?:[2356][1-8]|[14][1-7]|0[0-7])|4(?:[45][1-6]|2[1-5]|[16][1-7]|0[0-7]|3[1-9])|0(?:[256][1-7]|1[1-8]|0[1-4]|[34][1-6])|8(?:[125][1-7]|0[1-9]|[34][1-8])|3(?:[12][1-4]|0[0-7]))|1(?:2(?:1[1-5]|4[1-9]|[23][1-7]|0[0-6]|5[1-57])|1(?:4[1-7]|2[1-689]|[015-7]\d|3[1-8])|3(?:3[1-6]|[02][0-8]|1[1-79]))|22(?:2[1-7]|1[1-9]|0[0-6])))',
    '351' => '(?:0(?:0(?:[13][1-6]|2[1-5]|0[0-7])|1(?:1[1-6]|0[0-6])))',
    '352' => '(?:00(?:0[0-6]|[23][1-5]|1[1-7]))',
    '353' => '(?:000[0-8])',
    '354' => '(?:00(?:[2-4][1-6]|1[1-8]|0[0-8]))',
    '355' => '(?:0(?:0(?:[24][1-8]|1[1-9]|[367][1-7]|5[1-5]|0[0-8])|3(?:[37][1-7]|5[1-9]|0[0-6]|4[1-4]|6[13-6]|[12][1-8])|1(?:0[0-6]|[2356][1-7]|1\d)|2(?:1[1-6]|2[1-7]|0[0-6])|8(?:0[0-8]|1[1-5])))',
    '356' => '(?:00(?:[25]\d|[03][0-8]|1[1-9]|4[1-5]))',
    '357' => '(?:0(?:0(?:[46][1-9]|2[1-5]|0[0-6]|3[1-8]|[15][1-6])|2(?:1[1-8]|0[1-6])|1(?:2[1-8]|1[12])))',
    '358' => '(?:00(?:[12][1-7]|5[1-5]|0[0-8]|4[1-8]|3[1-6]))',
    '359' => '(?:(?:11(?:6[1-7]|[124][1-8]|[05][1-6]|3[1-3])|00(?:[24][1-7]|0[0-7]|3[1-8]|1[1-6])))',
    '360' => '(?:0(?:8(?:[13-5][1-7]|[02][1-6])|0(?:[2-4][1-7]|0[0-6]|1[1-8])|2(?:0[1-4]|[13][1-8]|[24][1-5])|1(?:6[1-4]|3[1-6]|[01][1-7]|2[1-5])))',
    '361' => '(?:00(?:8[1-4]|[37][1-8]|2[1-6]|[14-6][1-7]|0[0-7]))',
    '362' => '(?:0(?:0(?:4[1-8]|[27][1-6]|5[1-9]|[136][1-7]|0[0-8])|8(?:1[1-3]|0[0-8])))',
    '363' => '(?:00(?:0\d|2[1-8]|1[1-7]))',
    '364' => '(?:00(?:3[1-5]|2[1-7]|0[0-7]|1[1-4]))',
    '365' => '(?:00(?:4[1-7]|[35][1-9]|0[0-5]|[267][1-8]|1[1-4]))',
    '366' => '(?:0(?:0(?:5[1-4]|[01]\d|2[1-9]|[46][12]|3[1-5])|8(?:1\d|0[12]|[23][1-9])))',
    '367' => '(?:0(?:0(?:5[1-6]|[14][1-8]|3\d|6[1-4]|2[1-7]|0[0-7]|7[1-5])|2(?:0[0-7]|5[1-4]|[134][1-8]|2[1-6])|1(?:0[0-8]|1[1-9])|3(?:01|1[1-3])))',
    '368' => '(?:0(?:0(?:[1245][1-6]|0[0-5]|3[1-5]|7[12]|6[1-7])|1(?:0[0-5]|1[1-5])|20[12]))',
    '369' => '(?:(?:1(?:2(?:0[0-5]|[14][1-7]|2[1-5]|3[1-6])|3(?:0[0-5]|1[1-3])|1(?:11|0[1-9])|8(?:[07][1-4])|6(?:01|2[1-6])|9(?:1[12]|0[1-3])|4(?:00|1[1-3])|50[1-6])|0(?:1(?:3[1-7]|2[1-4]|0[1-8]|1[1-6])|2(?:0[1-3]|1[1-7]|2[1-5])|3(?:1[1-8]|0[0-8]))))',
    '370' => '(?:(?:0(?:0(?:3[1-6]|[1478][1-8]|0[0-8]|[56][1-9]|2[1-7])|8(?:[1-4][1-9]|[05][1-7]|7[1-5]|6[1-8]|8[1-6])|3(?:21|4[1-7]|[13][1-4]|[05][1-6])|1(?:2[1-8]|1[1-7]|[03][1-5])|5(?:3[1-6]|1[1-8]|0[0-5]|2[1-5])|7(?:0[0-8]|2[1-7]|1[1-8])|4(?:1[1-8]|0[1-6]|2[1-7])|6(?:1[1-6]|0[0-6]))|2(?:3(?:2[1-4]|[34][1-5]|0[0-7]|1[1-7])|1(?:1[1-6]|2[1-8]|0[1-7]|3[1-9])|6(?:2[1-7]|0[0-6]|1[1-6])|4(?:5[1-6]|1[1-3]|6[1-7])|2(?:1[1-7]|0[0-6])|8(?:1[1-6]|0[0-6]))|3(?:5(?:[37][1-4]|0[0-5]|1[1-9]|2[1-5])|3(?:11|2[12]|[34][1-8])|1(?:[01][1-7])|60[0-8]|40[1-5])|1(?:1(?:0[0-5]|3[1-5]|1[1-7]|2[1-8])|2(?:1[1-4]|0[1-8])|6(?:0[0-4]|1[1-7])|5(?:0[1-6]|1[1-5])|40[1-6]|301)))',
    '371' => '(?:0(?:0(?:0[0-7]|[235][1-7]|[14][1-8])|8(?:5[1-8]|2[1-6]|[134][1-7]|0[1-5])|2(?:[04][1-7]|3[1-5]|2[1-4]|1[1-8])|1(?:2[1-5]|[01][1-7]|3[1-4])))',
    '372' => '(?:0(?:0(?:0[0-7]|3[1-46-9]|[12][1-6]|[45][1-8])|8(?:1[1-8]|[034][1-4]|2[1-7]|5[1-5])))',
    '373' => '(?:0(?:0(?:0[0-46-8]|1[1-689]|5[1-7]|2[1-9]|[47][1-5]|6[1-3]|3[1-8])|8(?:6[12]|4[1-7]|[0-2][1-9]|[35][1-3])))',
    '374' => '(?:0(?:0(?:[45][1-7]|[1-367][1-9]|0\d)|1(?:[12][1-3]|0[0-7]|3[1-5])))',
    '375' => '(?:00(?:2[1-4]|[13-5][1-7]|0[0-6]))',
    '376' => '(?:0(?:0(?:1[1-4]|3[1-8]|[45][1-6]|2[1-7]|0[0-7])|1(?:0[0-4]|[24][1-5]|3[1-7]|1[1-6])|30[1-8]|601))',
    '377' => '(?:(?:0(?:0(?:31|0[02-8]|[56][1-5]|2[4-7])|4(?:00|3[1-4]|2[1-5]|1[1-7])|8(?:0[0-7]|1[1-6])|3(?:1[12]|0[1-5])|20[1-6]|93[1-5]|54[1-4]|10[1-3]|70[0-2]|601)|1(?:5(?:00|12|2[1-8])|4(?:0[1-5]|1[12])|7(?:1[12]|0[0-4])|3(?:1[0-2]|0\d)|61[1-7])))',
    '378' => '(?:0(?:0(?:0[0-5]|3[1-5]|[25][1-6]|[1467][1-8])|3(?:2[1-6]|[01][1-7])|1(?:2[1-7]|1[1-5]|0[0-5])|4(?:1[1-5]|0\d)))',
    '379' => '(?:(?:2(?:1(?:[14][1-7]|5[1-4]|0[1-8]|2[1-3]|[36][1-6])|2(?:1[1-7]|2[1245]|[03][1-6])|3(?:0[1-6]|1[1-4]))|1(?:1(?:2[1-7]|0[1-5]|1[1-6])|3(?:1[1-5]|0[0-8])|4(?:0[1-49]|1[1-8])|6(?:01|1[1-9])|20[0-7]|72[1-8])|0(?:1(?:0\d|[13][1-6]|2[1-9])|2(?:0[1-9]|1[1-7]|2[1-6])|30[1-7])))',
    '380' => '(?:0(?:8(?:[12][1-6]|[358][1-8]|[0467][1-7])|9(?:61|[14][1-8]|2[178]|0[1-6]|5[2-8]|3[4-6])))',
    '381' => '(?:(?:0(?:0(?:3[1-8]|[267][1-6]|4[1-5]|[15][1-7]|8[1-9]|0[0-8])|2(?:0\d|1[12])|40[0-5]|10[1-4])|2(?:2(?:3[1-5]|[0-24][1-7])|4(?:0[1-7]|1[1-6]|2[1-4])|3(?:5[1-9]|4[1-7])|70[1-5])|3(?:16[1-6]|20[1-5]|30[0-4])|12(?:[13][1-5]|2[1-6])|4(?:10[1-4]|30[1-3])))',
    '382' => '(?:0(?:0(?:0[0-6]|[1578][1-7]|3[1-467]|6[1-6]|9[1247-9]|[24][1-8])|8(?:1[13-7]|0[0-6]|[23][1-7])))',
    '383' => '(?:00(?:0[0-8]|[12][1-5]|[35][1-7]|[46][1-6]))',
    '384' => '(?:(?:0(?:0(?:5[1-6]|7[124-8]|[1-4][1-8]|0[0-8]|[68][1-5]|9[1-7])|6(?:00|2[12]|1[1-4])|80[1-9]|30[1-7]|41[1-4]|70[1-4]|50[1-3])|1(?:40[0-8]|30[0-6]|10[0-5]|2[01]1)|2(?:2(?:11|0[1-6])|10[1-7]|30\d)))',
    '385' => '(?:00(?:4[1-7]|2[1-9]|3[1-5]|[15][1-6]|6[1-3]|0[0-79]))',
    '386' => '(?:(?:0(?:0(?:4[1-3]|1[1-8]|3[1-4]|2[2-7]|0[0-6])|4(?:0[1-8]|1[1-3])|50[1-8]|15[1-356]|60[0-3]|32[1-3]|701)|1(?:10[1-8]|60[0-7]|32[1-7]|43[1-7]|54[1-6]|21[1-4])|22(?:11|0[1-4])))',
    '387' => '(?:00(?:0[0-7]|2[1-4]|1[1-8]))',
    '388' => '(?:80(?:20|0[1-8]|1[1-9]))',
    '389' => '(?:(?:0(?:8(?:0[1-7]|2[1-4]|1[1-3])|5(?:1[1-9]|0[0-6])|1(?:21|1[1-5]|0[0-4])|20[0-8]|40[1-7]|60[0-6])|2(?:2(?:00|61|3[1-5]|4[1-4]|5[1-8])|3(?:71|2[12]|0[0-3])|6(?:0[12]|1[1-4])|41[1-8]|10[1-4]|50[0-3]|70[0-3])|1(?:2(?:0[0-6]|1[1-5]|2[1-7])|3(?:1[1-6]|0[0-6])|10[1-7])))',
    '390' => '(?:(?:0(?:8(?:[24][1-8]|5[12]|[01367][1-7])|3(?:0[1-6]|1[1-7])|22[12])|1(?:5(?:20|0[1-467]|1[1-6])|1(?:0[0-4]|3[12])|(?:[34]0|61)1|24[1-3]|70[1-3])))',
    '391' => '(?:0(?:0(?:21|1[1-3]|0[0-5])|1(?:0\d|1[1-6])|21[1-6]|3[02]1))',
    '392' => '(?:0(?:0(?:0\d|2[1-7]|1[0-7])|131))',
    '393' => '(?:00(?:0[0-8]|[458][1-7]|1[1-9]|3[1-5]|2[1-6]|9[1-3]|[67][1-8]))',
    '394' => '(?:00(?:[19]1|0[0-5]|3[1-5]|[28][1-9]|5[1-6]|4[1-8]))',
    '395' => '(?:(?:0(?:0(?:0[0-4]|2[1-9]|[37][1-7]|[58][1-6]|4[1-68]|[16][1-8])|8(?:1[1-7]|0[1-8]|2[1-6])|15[1-7]|30[0-5]|24[1-5]|[4-7]01)|110[0-8]))',
    '396' => '(?:0(?:0(?:2[1-9]|3[0-3]|1[0-5]|0\d)|21[1-7]|40[1-7]|30[1-5]|11[1-4]|621))',
    '397' => '(?:0(?:00[0-3]|30[12]|[12]01))',
    '398' => '(?:000[0-4])',
    '399' => '(?:(?:0(?:7(?:[14][1-6]|[23][1-8]|0[0-6])|0(?:71|3[3-9]|2[1-7]|1[1245]|0[0-24-7])|4(?:00|2[1-8])|2(?:00|1[1-4])|10[12]|51[12]|6[05]1)|7(?:4(?:0[1-5]|1[1-8])|7(?:11|0[0-2])|3(?:11|0[12])|10[1-5]|50[0-4]|20[0-2]|601)|4(?:1(?:1[1-7]|0[0-8])|(?:3[02]|5[01])1|60[0-5]|23[12]|43[12])|3(?:3(?:11|0[0-4])|10[0-7]|70[0-5]|80[0-4]|20[0-2]|50[0-2])|1(?:2(?:21|0[0-3])|6(?:01|1[12])|50[0-5]|31[1-3]|40[13]|801)|2(?:6(?:1[12]|0[1-7])|56[1-6]|43[1-4]|10[0-2]|22[1-3])|8(?:2(?:51|1[12]|0[0-5])|60[0-5]|30[1-5]|10[1-3]|501)|9(?:(?:[16]0|[25]1)1|4(?:00|2[12])|30[01])|6(?:20[0-3]|30[1-3]|46[12]|101)|5(?:50[0-4]|30[0-3]|60\d)))',
    '400' => '(?:(?:0(?:0(?:[37][1-5]|[46][1-9]|1[1-7]|0[0-8]|[25][1-8]|8[1-3])|8(?:3[1-6]|[025][1-8]|[14][1-5]|6[1-7])|2(?:[02][1-6]|3[1-4]|4[12]|1[1-5])|1(?:[12][1-8]|0[0-8])|3(?:3[1-7]|1[1-9]|0[1-68])|4(?:2[1-6]|0[0-5]|1[1-7])|5(?:1[1-5]|0[0-6])|60[1-8])|1(?:1(?:31|[12][1-7])|5(?:0[1-8]|1[1-5])|21[1-9])))',
    '401' => '(?:0(?:0(?:1[1-6]|2[1-5]|0[0-6])|3(?:[12]0|3[1-8]|0[0-5])|5(?:0[0-2]|1[12])|201))',
    '402' => '(?:0(?:0(?:[45][1-6]|[1-3][1-5]|0[0-6])|2(?:1[1-9]|0\d|2[1-8])))',
    '403' => '(?:00(?:0[0-8]|1[1-7]|2[1-3]))',
    '404' => '(?:0(?:0(?:[125][1-6]|0[0-7]|[34][1-7])|2(?:11|0[1-6])))',
    '405' => '(?:00(?:0[0-7]|[5-7][1-9]|2[1-5]|3[1-6]|[14][1-8]))',
    '406' => '(?:0(?:8(?:4[1-6]|[01][1-8]|[235][1-5])|0(?:2[1-8]|[34][1-6]|1[1-5]|0[0-5])))',
    '407' => '(?:0(?:0(?:4[1-6]|5[1-578]|[12][1-5]|3[1-7]|0[0-7])|3(?:11|[02][12])|17[1-6]|26[1-3]))',
    '408' => '(?:0(?:0(?:2[1-6]|4[1-4]|0[0-4]|1[1-9]|3[1-7])|3(?:0[1-7]|1[1-9])|1(?:1[1-7]|0[1-5])|20[1-7]))',
    '409' => '(?:(?:3(?:8(?:5[1-4]|2[1-3]|[134][1-5]|6[1-7]|0[0-4])|1(?:1[1-8]|2[1-6]|0[1-7])|6(?:0[0-7]|1[12]|2[1-6])|4(?:2[1-4]|3[1-7])|3(?:1[1-3]|0[1-7])|2(?:4[1-5]|3[1-4])|7(?:0[1-4]|1[12]))|2(?:7(?:3[1-4]|1[1-5]|2[1-7]|0[0-5])|5(?:00|2[1-4]|3[1-9])|9(?:4[1-7]|3[1-8])|4(?:1[1-5]|0[1-6])|21[1-7]|30[1-5]|10[0-3])|0(?:1(?:00|3[1-8]|2[1-6]|1[1-5]|4[12])|3(?:1[1-8]|0[0-6])|6(?:1[1-8]|2[1-7])|2(?:00|11)|50[1-6])|1(?:3(?:21|[01][1-6])|2(?:0[1-5]|1[1-3])|50[12])))',
    '410' => '(?:(?:0(?:8(?:2[1-4]|8[1-8]|[37][1-6]|[06][1-7]|[14][1-9]|[59][1-5])|0(?:[13][1-8]|[45][1-9]|0[0-7]|2[12]|6[1-5])|3(?:21|[01][1-9])|2(?:[23][1-5]|4[1-4])|10[1-6])|2(?:1(?:[03][1-3]|[124][1-4])|3(?:2[1-5]|0[1-4]|1[1-8])|5(?:[01][1-9])|2(?:2[13]|1[1-4]|0[0-5])|4(?:1[1-8]|0[0-7]))|3(?:6(?:2[1-7]|0[0-7]|1[1-8])|2(?:0[1-9]|1[1-7])|5(?:0[0-2]|1[1-5])|30[1-4]|40[12])|1(?:3(?:0[0-8]|[12][1-7])|1(?:0\d|[12][1-8])|43[12]|231)))',
    '411' => '(?:0(?:8(?:1[1-7]|2[1-4]|[03-5][1-8])|0(?:0[01]|2\d|[13][1-9]|4[1-7])|9(?:51|1[1-8]|3[1-6]|0[1-7]|4[1-5])))',
    '412' => '(?:00(?:51|[1-3][1-9]|0\d|4[1-8]))',
    '413' => '(?:0(?:0(?:[1-3][1-9]|4[12]|0[0-6])|7(?:1[1-6]|0[1-5])|5(?:1[1-6]|0\d)|1(?:11|0[1-3])|23[1-5]|30[0-4]|411))',
    '414' => '(?:00(?:4[1-6]|[1-3][1-8]|5[1-5]|0[0-6]))',
    '415' => '(?:0(?:0(?:[23][1-9]|1[1-8]|0[01])|3(?:2[1-7]|0[0-6]|1[1-4])|15[1-6]|53[1-3]))',
    '416' => '(?:09(?:2[1-4]|5[1-5]|[0134][1-9]))',
    '417' => '(?:0(?:0(?:3[1-7]|4[1-9]|[16][1-5]|0[0-4]|5[1-8]|2[1-6]|7[1-3])|8(?:4[1-8]|6[1-4]|2[1-6]|1[1-7]|0[1-9]|[35][1-5])))',
    '418' => '(?:0(?:0(?:0[0-7]|[13][1-9]|2[1-6]|[4-7][1-8])|1(?:1[1-7]|0[1-9])))',
    '419' => '(?:0(?:1(?:1[1-6]|2[1-5]|0[0-7])|3(?:1[1-7]|0[1-5])|20[1-5]))',
    '420' => '(?:0(?:8(?:1[0-356]|2[1-5]|4[1-7]|[356][1-9]|[78][1-6]|0[13-5])|0(?:[1467][1-8]|5[1-4]|[023][1-9])|9(?:[35][1-7]|4[1-9]|2[1-5]|[016][1-6])))',
    '421' => '(?:(?:0(?:1(?:[02][1-6]|[13][1-7])|5(?:0\d|[12][1-7]|3[1-5])|4(?:1[1-5]|2[12]|0[1-9])|2(?:1[1-8]|0[1-6])|30[0-5])|1(?:1(?:2[1-4]|0[1-3]|3[12]|1[1-5])|2(?:2[1-6]|0[12]|1[1-7])|3(?:1[1-6]|0[1-9])|40[1-9])|2(?:1(?:2[1-5]|0[1-9]|1[1-8])|2(?:[12][1-7]|0[1-3])|30[1-9])|3(?:1(?:0[1-7]|1[1245])|2(?:0[1-3]|1[1-5])|30[1-6])))',
    '422' => '(?:(?:80(?:[2-46][1-7]|0[1-9]|[157][1-8])|0000))',
    '424' => '(?:0(?:8(?:4[1-7]|[0-37][1-9]|[58][1-8]|6[1-6])|0(?:[1346][1-8]|[02][1-9]|5[1-7])|9(?:[2-4][1-9]|[01][1-7])|4(?:1[1-5]|0[1-6])|1(?:1[1-4]|0[1-6])|2(?:1[12]|0[1-6])|30[1-6]))',
    '425' => '(?:00(?:[258][1-8]|[34][1-6]|9[12]|6[1-9]|[17][1-7]|0[0-7]))',
    '426' => '(?:0(?:0(?:[38][1-8]|[07]\d|[12][1-9]|[4-6][1-7])|2(?:0[1-5]|2[1-4]|1[1-3])|13[1-4]))',
    '427' => '(?:0(?:0(?:61|[1-35][1-9]|4[1-8]|0\d)|1(?:0[1-8]|1[1-3])|23[1-3]))',
    '428' => '(?:0(?:0(?:[0-4][1-9])|3(?:1[1-5]|0[0-6])|4(?:0[12]|1[1-8])|10[1-6]|50[1-5]|21[12]))',
    '430' => '(?:(?:0(?:8(?:[125][1-7]|[03][1-8]|4[1-6])|9(?:2[3-9]|[34][1-9]|0[1-7]|1[1-35-9]))|77(?:90|0[1-9]|4[0-5]|[1-3]\d)))',
    '431' => '(?:(?:3(?:1(?:2[1-6]|0[1-8]|1[1-5])|3(?:1[1-5]|0[1-6])|7(?:5[1-6]|6[1-4])|42[1-8]|90[1-8]|53[1-6]|80[1-4]|64[1-3])|0(?:4(?:0[0-5]|2[1-9]|[135][12]|4[1-4])|2(?:1[1-4]|0[1-3])|30[1-4]|10[1-3])|1(?:4(?:2[1-5]|[01][1-7])|1(?:0[1-4]|1[1-5])|20[1-9]|30[1-5])|2(?:2(?:[12][1-6]|0[1-7])|53[1-7]|10[1-4])|41(?:21|1[12]|0[1-3])))',
    '432' => '(?:(?:80(?:71|[13-5][1-8]|6[1-9]|[02][1-7])|0000))',
    '433' => '(?:81(?:0[1-589]|1[1-46-9]|2[1-7]))',
    '434' => '(?:00(?:4[1-6]|3[1-8]|1[1-7]|0[0-7]|2[1-9]))',
    '435' => '(?:00(?:[0134][1-8]|5[1-7]|2[1-9]))',
    '436' => '(?:0(?:0(?:[02-47]\d|[1568][1-9]|9[0-4])|1(?:1[1-7]|0[1-6])|3(?:4[1-3]|3[1-8])|22[1-7]))',
    '437' => '(?:(?:1(?:4(?:2[1-5]|0[1-7]|3[1-9]|1[1-6])|1(?:2[1-6]|0[1-5]|1[1-9])|5(?:[12][1-4]|0[1-7])|6(?:1[1-5]|0[0-5]|2[1-3])|2(?:1[1-8]|0[1-9])|3(?:0[1-6]|1[12]))|0(?:0(?:[156][1-7]|[23][1-9]|4[0-7]|0[0-6])|2(?:0[0-8]|[12][1-7])|6(?:2[1-6]|[01][1-8])|12[1-7])))',
    '438' => '(?:0(?:0(?:0[0-8]|7[1-578]|4[1-7]|[136][1-9]|[25][1-8]|8[1-68])|8(?:[013][1-8]|2[1-5])|2(?:1[1-8]|2[1-4]|3[1-6]|0[1-7])|1(?:1[1-6]|0[1-8]|2[1-7])))',
    '439' => '(?:00(?:3[1-7]|1[1-9]|2[1-6]|0\d))',
    '440' => '(?:0(?:0(?:6[1-9]|9[1-5]|[018][1-6]|[2-57][1-8])|8(?:[01][1-6]|5[13-8]|[38][1-8]|[46][1-5]|[279][1-7])))',
    '441' => '(?:(?:1(?:3(?:5[1-5]|0[0-7]|2[1-9]|[1346-8][1-8])|6(?:93|3[1-46]|0[1-5]|1[1-6]|2[1-4])|2(?:31|1[12]|0[1-6]|2[1-3])|4(?:[0-2][1-4])|9(?:[45][1-6])|1(?:0[1-6]|1[1-5])|53[1-6])|8(?:0(?:7[1-7]|[1-3568][1-9]|9[0-3]|[04][1-8])|1(?:[23][1-5]|[04][1-9]|[15][1-7]))|3(?:1(?:[15][1-5]|4[1-7]|3[1-4]|[02][1-6])|4(?:1[1-9]|2[1-7]|0\d|3[1-6])|6(?:2[1-7]|[01][1-9])|2(?:1[1-4]|0[1-3])|50[1-5]|30[12])|0(?:3(?:0[1-4]|2[1-3]|1[1-6])|1(?:[05][1-6])|2(?:0[1-4]|1[1-5])|000)|2(?:5(?:31|1[1-7]|2[1-6])|3(?:1[1-7]|0[0-3])|22[1-4]|43[1-4]|601)))',
    '442' => '(?:0(?:8(?:[01378][1-9]|5[1-7]|6[1-3]|[24][1-8])|0(?:0[0-8]|[1-46][1-9]|5[1-5])))',
    '443' => '(?:0(?:0(?:1[1-4]|[34][1-8]|0[0-8]|2[12]|5[1-9])|10[1-6]))',
    '444' => '(?:(?:0(?:0(?:2[1-5]|[3-7][1-9]|0\d|1[1-6])|8(?:2[1-8]|[467]\d|[01][1-7]|[35][1-9])|9(?:2[1-4]|5[01]|1[1-8]|[034][1-9])|2(?:[0-2][1-6]|3[1-4]|4[1-7])|3(?:0[1-5]|2[1-8]|[13][1-6])|5(?:[13][1-7]|2[1-6]|0[1-4])|4(?:1[1-6]|2[1-9]|0[1-7])|1(?:1[13-7]|2[1-8]|0[0-4])|70[1-4])|2(?:8(?:[03][1-9]|[124][1-7])|1(?:3[1-7]|[04][1-9]|1[1-8]|2[1-3])|3(?:5[1-5]|3[1-7]|2[14-7]|1[1-4]|4[2-4]|0[1-3])|5(?:3[1-3]|0[1-6]|2[1-8]|1[0-7])|4(?:51|1[1-9]|0[1-79]|2[34])|2(?:2[1-6]|1[1-8]|0[1-7])|60[1-8])|3(?:2(?:31|42|2[1-3]|1[1-36]|0[1-35-8]|6[1245]|5[12])|5(?:0[1-8]|1[1-6]|2[1-7])|6(?:2[1-6]|1[1-7]|0[1-5])|1(?:51|6[1-8]|7[1-5])|4(?:3[1-7]|4[1-9])|3(?:3[1-5]|4[1-4]))|1(?:3(?:0[0-5]|2[1-5]|3[1-6]|1[1-4])|2(?:[12][1-5]|0[1-6])|1(?:6[1-6]|5[1-5]))))',
    '445' => '(?:0(?:8(?:7\d|9[1-4]|[16][1-6]|[02-58][1-7])|0(?:[12457][1-7]|[36][1-5]|0[0-6]|8[1-4])))',
    '446' => '(?:00(?:2[1-7]|[135][1-9]|0[0-8]|[467][1-6]))',
    '447' => '(?:0(?:8(?:[13][1-8]|[024-8][1-9])|0(?:[3-68][1-8]|0[0-8]|1[1-7]|[27][1-9])))',
    '448' => '(?:0(?:8(?:0[1-9]|6[12]|2[1-5]|1[0-6]|[3-5][1-8])|0(?:0[0-8]|[2-4][1-9]|1[1-5])))',
    '449' => '(?:0(?:2(?:0[0-6]|1[1-6])|40[0-5]))',
    '450' => '(?:(?:6(?:2(?:90|[1-3]\d|0[1-9]|4[0-7])|0(?:90|[1-4]\d|5[01]|0[1-9]))|000[1-7]))',
    '451' => '(?:(?:00(?:00|[35][1-5]|[27][1-7]|[146][1-6]|8[1-4])|60(?:[49]0|[1-3]\d|0[1-9])))',
    '452' => '(?:0(?:0(?:1[0-8]|5[1-5]|[34][1-7]|2[1-6]|0\d|6[1-8])|8(?:[03][1-9]|[14][1-8]|2[1-4])|9(?:6[1-3]|0[1-8]|1[1-9]|4[1-7]|3[1-5])))',
    '453' => '(?:0(?:8(?:2[1-8]|6[1-7]|[013-5][1-9]|7[12])|0(?:0[02]|4[1-7]|[26][1-9]|[135][1-8])))',
    '454' => '(?:0(?:9(?:[78][1-6]|[0-469][1-7]|5[1-9])|8(?:6\d|0[1-8]|[1-5][1-9]|7[1-7])|0(?:2[1-8]|1[1-6]|3[1-7]|[45][1-9]|0[0-7])))',
    '455' => '(?:0(?:0(?:6[1-9]|[3-5][1-7]|0[0-8]|[127][1-8])|8(?:[07][1-6]|[4-6][1-8]|[1-3][1-5]|8[1-7])))',
    '456' => '(?:00(?:0[0-6]|[56][1-9]|[23][1-7]|[147][1-8]))',
    '457' => '(?:0(?:0(?:[257][1-8]|1[1-6]|[346][1-9]|0[0-8])|8(?:[34][1-7]|1[1-9]|[56][1-6]|[02][1-8])))',
    '458' => '(?:0(?:0(?:1[1-6]|0\d|2[1-5]|4[1-7]|3[1-9])|8(?:[12]\d|[04][1-9]|3[0-7])|9(?:1[0-35-9]|2[124-7]|0[1-3])))',
    '459' => '(?:80(?:0[1-9]|1[1-6]))',
    '460' => '(?:00(?:3[12]|0[0-8]|1[1-8]|2[1-6]))',
    '461' => '(?:00(?:1[1-9]|2[1-7]|3[1-8]|0\d|4[03-9]))',
    '462' => '(?:0(?:8(?:2[3-9]|4[1-7]|[56][1-9]|0[1-57-9]|1[0-4689]|3[1-8])|0(?:4[1-7]|5[1-9]|[26][1-6]|0\d|[13][1-8])))',
    '463' => '(?:0(?:0(?:9[0-8]|1[0-7]|5[1-7]|[26][1-9]|[078]\d|[34][1-8])|8(?:0[1-9]|1[1-5])))',
    '464' => '(?:0(?:0(?:[5-9][1-7]|[1-3][1-9]|0[0-8]|4[1-6])|8(?:71|1[1-9]|[23][1-7]|5\d|[04][1-8])))',
    '465' => '(?:00(?:6[1-9]|[39][1-7]|0[02-9]|[124578][1-8]))',
    '466' => '(?:0(?:0(?:1[1-6]|[2-4][1-7]|5[1-9]|6[1-5]|0[0-6])|8(?:0[1-7]|[24][1-9]|1[1245]|[35][1-8])))',
    '467' => '(?:0(?:8(?:[34][1-7]|7[1-9]|[15][1-6]|[026][1-8])|0(?:[3-5][1-9]|1[1-7]|0[0-8]|[26][1-8])))',
    '468' => '(?:0(?:0(?:[02]\d|5[1-68]|3[0-57-9]|1[1-5]|[46][1-9]|7[1-7])|836))',
    '470' => '(?:(?:0(?:3(?:[57][1-6]|6[1-4]|4[1-8]|[0-2][1-9]|3[1-5])|5(?:[0-2][1-6]|[3-7][1-5])|1(?:[356][1-6]|2[1-8]|0[0-5]|1[1-7])|4(?:[1347]1|5[1-3]|[026][1-4])|2(?:0\d|3[1-3]|[12][1-7]))|2(?:3(?:6[1-6]|0\d|8[02-9]|[1-57][1-9])|5(?:21|[14][1-7]|3[12]|5[1-6]|0[1-8])|2(?:0[0-7]|1[1-7])|4(?:1[1-4]|0[1-9])|10[0-5])|1(?:1(?:5[1-4]|[46][1-8]|0\d|1[1-6]|3[1-3]|2[1-7])|2(?:1[1-9]|0[1-7]))|3(?:2(?:00|3[1-6])|3(?:00|2[12])|50[1-5]|41[12])))',
    '471' => '(?:0(?:8(?:[01467][1-9]|[235][1-8])|0(?:[124-7][1-9]|0\d|3[1-8])))',
    '472' => '(?:00(?:[35][1-8]|[124][1-7]|0[0-7]))',
    '473' => '(?:09(?:3[1-9]|[0-2][1-8]))',
    '474' => '(?:00(?:11|6[12]|2[1-7]|3[15-8]|0[0-3]|7[1-4]|4[1-8]|5[1-35-7]))',
    '475' => '(?:0(?:8(?:[02-47][1-8]|[56][1-9]|8[1-7]|1[3-79])|0(?:[1-3][1-9]|0\d|[4-8][1-8])|9(?:[467][1-8]|1[124-8]|0[1-6]|[235][1-9])))',
    '476' => '(?:00(?:0[0-6]|1[1-5]))',
    '477' => '(?:003[1-7])',
    '478' => '(?:00(?:6\d|[12][1-8]|0[0-6]|5[1-9]|[34][1-7]))',
    '479' => '(?:0(?:8(?:[0-3][1-9]|8[12]|[4-6][1-8]|7[13])|0(?:[1-46][1-9]|5[3-9]|7[1-79]|0\d)))',
    '480' => '(?:(?:1(?:1(?:8[1-4]|3[2-9]|[4-7][1-8]|[12][1-9]|0[02-8])|3(?:1[1-8]|[023][1-9]|4[1-7])|2(?:1[1-9]|0[1-7]))|0(?:1(?:51|0[0-7]|2[1-7]|[34][1-9])|30[1-6]|20[0-2])))',
    '481' => '(?:00(?:0[0-6]|3[1-9]|4[1-6]|1[1-4]))',
    '482' => '(?:00(?:0[0-7]|1[1-8]|[2-4][1-6]))',
    '483' => '(?:(?:8(?:3(?:[02][1-8]|[13-8][1-9])|1(?:[045][1-9]|7[1-7]|[1-368][1-8])|0(?:[26][1-9]|7[124-7]|[013-58][1-8])|2(?:1[1-7]|[3-57][1-9]|[02][1-8]|6[2-9])|4(?:3[1-3]|[0-2][1-9]))|0000))',
    '484' => '(?:0(?:8(?:4[1-6]|[25][1-8]|0[1-7]|[136-9][1-9])|0(?:6[1-6]|3[1-8]|[02]\d|[14579][1-9]|8[1-7])|9(?:[15][1-9]|3[1-7]|[024][1-8]|6[1-6])))',
    '485' => '(?:0(?:0(?:7[1-8]|[24-6][1-9]|1[1-7]|8[1-5]|3[1-79]|0[0-8])|8(?:0[1-6]|3[12]|1[1-5]|2[1-9])))',
    '486' => '(?:0(?:9(?:3[1-7]|[0246][1-9]|[15][1-8])|8(?:[01][1-9]|5[1-8]|[23]\d|4[124-69])|000))',
    '487' => '(?:00(?:3[1-5]|[0-2][1-7]))',
    '488' => '(?:0(?:8(?:7[1-6]|8[1-4]|6[13-6]|3[0235689]|4[0-7]|1[3-8]|2[1-7]|0[1-5]|5[1-47-9])|0(?:[145][1-7]|3[1-5]|0[0-8]|6[1-8]|7\d|2[1-4]|8[1-6])))',
    '489' => '(?:0(?:8(?:[0-24578][1-9]|[369][1-8])|9(?:3[1-8]|[18]\d|6[1-6]|[0247][1-9]|5[1-5])|0(?:3[1-7]|[267][1-9]|[145][1-8]|0\d)))',
    '490' => '(?:1(?:4(?:1[1-5]|4[1-7]|0[0-7]|[23][1-8])|1(?:1[1-6]|4[1-5]|3[1-7]|0[0-7])|2(?:2[1-6]|1[1-4]|0[0-7])|3(?:[01][1-5]|2[1-3])))',
    '491' => '(?:0(?:0(?:3[1-7]|[5-7][1-9]|1[1-5]|0[0-5]|2[1-8]|[48][1-6])|8(?:5[1-9]|[12][1-7]|0[1-6]|8[1-3]|7[1-489]|[34][1-8]|6[1-35-9])|9(?:[03][1-8]|2[1-7]|1[1-9])|1(?:3[1-6]|4[1-4]|[0-2][1-5])|3(?:[67][1-6]|5[1-4])|201))',
    '492' => '(?:(?:8(?:1(?:8[1-6]|[257][1-8]|[46][1-7]|[013][1-9])|0(?:4[1-4]|[035-7][1-8]|1[1-7]|[289][1-5])|3(?:4[124-9]|[38][1-9]|7[1-5]|6[1-6]|9[1-3]|[05][1-8]|1\d|2[1-35-9])|2(?:[06-8][1-9]|5[1-7]|[1-3]\d|4[1-6])|4(?:[023][1-9]|[46][1-8]|1\d|5[1-6]))|0000))',
    '493' => '(?:(?:000[1-7]|800[1-3]))',
    '494' => '(?:00(?:0[1-8]|1[1-9]))',
    '495' => '(?:00(?:3[1-7]|0[12]|[12][1-5]))',
    '496' => '(?:(?:0(?:8(?:[0-46][1-9]|[57][1-7])|0(?:[12][1-9]|7[12]|[34][1-8]|0\d)|9(?:2[1-4]|1[1-5]|[03][1-9]|4[1-7]))|80(?:20|0[1-9]|[134]\d)))',
    '497' => '(?:00(?:1[1-6]|[35][0-8]|0[0-6]|4[02-8]))',
    '498' => '(?:0(?:0(?:0[0-7]|6[1-9]|[1-5][1-8])|8(?:0[1-8]|2[1-3]|1[1-9])))',
    '500' => '(?:(?:8(?:8(?:91|[0-8][1-9])|0(?:[0-8][1-9])|1(?:[0-8][1-9])|4(?:[0-8][1-9])|3(?:3[1-79]|[0-24-8][1-9])|2(?:07|[25-8][1-9]|4[1-7]|1[1-3]|3[1-8]))|0000))',
    '501' => '(?:(?:3(?:8(?:5[1-7]|[1-3][1-9]|[046-8][1-8])|7(?:2[1-9]|[13][1-7]|0[0-6]|6[1-4]|8[1-8]|[45][1-6]|7[1-3])|9(?:4[1-7]|[0167][1-9]|3\d|[25][1-8])|2(?:[34][1-7]|0[0-7]|[15]\d|[26][1-8])|1(?:[35][1-6]|0[1247-9]|[124][1-7])|(?:60|5[0-2])1|30[0-7])|0(?:4(?:2[1-5]|0[0-7]|1\d|[35][1-8]|[467][1-6])|5(?:5[1-6]|0[0-4]|[1-36][1-5])|6(?:2[1-8]|0[0-7]|1[1-9]|3[1-5])|2(?:2[1-5]|[13][1-7]|0[0-6])|1(?:2[1-4]|0[1-6]|1[1-357-9])|3(?:0[1-7]|[12][1-4])|8(?:1[1-7]|0[2-5])|70[1-8]|90[1-3])|6(?:0(?:0[1-6]|[389][1-8]|6[1-5]|[125][1-9]|[47][1-7])|2(?:[56][1-7]|2[1-9]|[13][1-8]|0\d|[47][1-4])|3(?:3[0-8]|1[1-9]|0[1-4]|2[1-8])|1(?:3[1-5]|0[0-5]|1[1-35]|2[1-3]))|2(?:5(?:3[1-6]|2[1-8]|4[1-5]|[017][1-9]|[56][1-7])|1(?:0[0-5]|[1-3][1-5])|3(?:[23]1|0[1-3]|1[1-5])|8(?:1[124-7]|0[1-35-9])|25[1-9]|60[1-7]|901)|1(?:1(?:[138][1-6]|[27][1-8]|5\d|[046][1-9])|5(?:3[1-6]|1[1-8]|0[1-7]|2[1-9])|2(?:0[1-35]|3[1-6])|3(?:0[1-3]|1[1-7]))|4(?:2(?:41|1[1-9]|0[0-7]|[23][1-8])|5(?:1[0-8]|0[1-9])|6(?:1\d|0[1-8])|10[1-7]|30[1-7]|45[1-5])|5(?:4(?:1[1-7]|[02][1-6])|1(?:[12][1-6]|0[1-5])|50[1-7]|6(?:00|2\d)|30[1-5]|231)))',
    '502' => '(?:0(?:0(?:3[1-8]|5[1-6]|8[12]|2[1-9]|[01467][1-7])|8(?:1[1-7]|[24][1-9]|[78][12]|6[1-6]|0[1-3]|3[1-8]|5\d)|9(?:[023][1-9]|1[1-7])))',
    '503' => '(?:(?:0(?:8(?:6[1-5]|1[1-7]|[3489][1-9]|[0257][1-8])|9(?:[3479][1-7]|5[1-9]|6[1-5]|[28][1-6]|[01][1-8])|6(?:[13][1-8]|4[13-8]|2[1-9]|5[1-5]|0[0-68])|1(?:41|1[1-8]|0[0-6]|2[1-9])|0(?:2[1-7]|1[1-9]|3[1-6]|0\d)|2(?:0[0-6]|[13][1-6])|3(?:0[1-7]|1[1-4]|2[1-3])|4(?:0[1-8]|1[1-5])|53[1-6])|1(?:3(?:0[0-6]|[28][1-5]|1[1-7]|3[1-9])|2(?:5[1-6]|[67][1-8]|4[1-5])|5(?:0[01]|2[1-4]|[14][1-5]|3[12])|6(?:0[12]|3[1-8]|1[1-4]|2[1-6]))|2(?:3(?:41|2[1-8]|0[0-6]|1[1-9])|2(?:2[1-7]|1[1-6]|0[1-8])|4(?:[12][1-9]|0\d)|1(?:0\d|1[1-4]|2[1-5])|50[1-6])))',
    '504' => '(?:0(?:9(?:71|[26][1-8]|1[1-6]|[34][1-5]|[05][1-9])|8(?:61|[023][1-9]|4[1-7]|[15][1-6])|0(?:4[1-7]|0\d|[13][1-8]|2[1-6])))',
    '505' => '(?:0(?:0(?:7[1-7]|[1-3][1-9]|[45][1-6]|0\d)|1(?:30|[12][1-6]|0[0-8])|30[0-7]|42[1-3]|53[12]))',
    '506' => '(?:(?:0(?:8(?:4[1-7]|2[1-5]|[0135][1-8])|0(?:3[1-5]|5[1-9]|1[1-7]|2[1-6]|0\d|4[1-8])|2(?:71|0[1-7])|10[1-7])|1(?:1(?:3[1-3]|2[1-6]|1[1-4]|5[1-8]|0[0-8]|6[12]|4[1-9])|3(?:1[1-9]|0[1-8])|2(?:0[1-6]|1[1-7])|4(?:3[1-4]|2[1-9]))|2(?:1(?:1[1-8]|0[13-6]|[23][1-5])|25[1-8])))',
    '507' => '(?:0(?:0(?:[24-7][1-8]|0[0-8]|[13][1-9])|8(?:[1-4][1-8]|0[1-7])|901))',
    '508' => '(?:0(?:0(?:3[1-8]|2[1-4]|0[0-7]|[14][1-5])|(?:35|42|1[01])1|20[1-4]|50[12]))',
    '509' => '(?:(?:4(?:2(?:5[1-6]|3[1-7]|[0-2467][1-5])|1(?:0[1-8]|2[1-6]|1[1-79])|4(?:2[1-4]|0[1-6]|1[1-5])|3(?:1[1-8]|0[1-6])|5(?:[34][1-5]))|0(?:2(?:4[0-25-9]|6[1-6]|2[1-4]|1[1-8]|[35]\d|0[0-8])|1(?:3[1-6]|[124][1-7]|0[1-9])|3(?:0[0-7]|1[1-5])|40[0-3]|511)|7(?:7(?:31|[01][1-8]|2[1-6])|8(?:31|[0-2][1-6])|5(?:21|0[1-7]|1[1-3])|60[1-8]|2(?:11|0\d)|12[1-6]|40[1-3]|32[12])|3(?:3(?:0[1-6]|[12][1-7])|2(?:0[1-7]|1[1-8])|4(?:0[1-5]|1[1-9])|1(?:0[1-7]|1[1-5])|505)|5(?:1(?:[67]1|[24][1-7]|0[0-7]|1[1-8]|5[1-4]|3[1-6])|3(?:[01][12])|20[1-3]|40[1-3])|2(?:5(?:1[1-9]|0[1-8])|6(?:1[1-5]|0[1-4])|13[1-8]|20[0-7]|31[1-4]|42[1-4]|70[12])|1(?:6(?:0[1-7]|1[1-6]|2[1-4])|1(?:1[1-3]|0[0-8])|30[0-3]|22[12]|431)|6(?:1(?:1[1-6]|2[1-8]|0[0-8]|3[1-5])|36[1-3]|47[12]|251)|9(?:2(?:01|3[12])|13[12])|8(?:23[12]|301)))',
    '510' => '(?:(?:0(?:0(?:0[0-8]|2[1-7]|[568][1-9]|3[1-5]|7[1-6]|[149][1-8])|8(?:[23][1-9]|[05][1-7]|7[1-5]|1[0-5]|[46][1-8]|9[1-4]|8[1-6])|2(?:4[1-4]|0[1-8]|6[1-6]|1[1-36-9]|[23][1-7]|5[1-9])|9(?:71|6[1-3]|[45][1-8])|3(?:[01][1-8])|10[1-7])|8(?:0(?:2[1-8]|[03][1-9]|1[1-7])|1(?:2[1-5]|0[1-7]|1[1-4]))|1(?:2(?:00|5[1-3]|[2-4][1-6])|3(?:2[1-8]|1[12]))))',
    '511' => '(?:(?:0(?:0(?:0\d|5[1-8]|[1346-8][1-9]|2[1-7])|2(?:[24][1-5]|[1568][1-7]|0[0-8]|3[1-3]|7[1-6])|8(?:6[1-7]|[023][1-9]|5[1-5]|4[1-8]|1\d)|9(?:[0-2][1-4]|3[1-9]|4[1-7])|4(?:0[1-6]|[1-3][1-8])|5(?:1[1-9]|0[1-8]|2[1-4])|1(?:1[1-8]|0[1-6]|2[1-5]))|11(?:[04][1-9]|3[1-7]|1[1-6]|2[1-8])))',
    '512' => '(?:(?:1(?:2(?:0[1-8]|1[1-6])|1(?:0[1-5]|1[13-6])|30[1-6])|0(?:9(?:2[1-5]|0[1-8]|1[1-4]|3[1-6])|301)|80(?:[56][1-6]|4[1-8])))',
    '513' => '(?:(?:0(?:8(?:[24][1-8]|3[1-7]|[01][1-9]|5[1-5])|0(?:0\d|[23][1-8]|[145][1-9]))|112[1-4]))',
    '514' => '(?:(?:0(?:0(?:6[1-5]|3[1-9]|[47][1-7]|8[1-6]|[01]\d|[25][1-8])|8(?:1[1-9]|3[1-8]|[02][1-6])|1(?:31|[12][1-6]|0[1-4])|3(?:[01][1-5]|2[13-6]))|2(?:3(?:[0-2][1-8])|2(?:0[1-8]|1[1-4]|2[12])|1(?:0[1-7]|1[1-5]))|1(?:1(?:2[1-5]|[03][1-9]|1[1-8])|25[1-8])))',
    '515' => '(?:(?:0(?:0(?:[46][1-6]|[78][1-8]|5[1-7]|0[0-7]|[1-3][1-9])|3(?:[35][1-4]|2[1-5]|4[1-9]|1[1-7]|0[0-3])|8(?:[14][1-8]|0[1-4]|[23][1-5])|1(?:0[1-4]|2[1-8]|1[1-9])|2(?:1[1-7]|0[1-8])|5(?:[12]1|0[1-9]))|2(?:3(?:[023][1-5]|[15][1-7]|4[1-4])|1(?:1[1-5]|0[1-9]|3[1-3]|2[1-4])|5(?:2[1-6]|0[1-5]|1[1-7])|6(?:2[1-4]|0[1-5]|1[1-7])|4(?:1[1-4]|0[1-9]))|1(?:7(?:3[1-4]|2[1-7])|61[1-8]|10[1-7]|50[1-6]|20[1-5]|30[1-4]|41[1-3])|3(?:13[1-9]|53[1-6]|20[1-3]|31[1-3]|421)))',
    '516' => '(?:(?:0(?:0(?:[1-3][1-8]|0\d|5[1-4]|7[1-9]|[46][1-7])|1(?:1[1-8]|0\d)|80[1-6]|22[12])|1(?:2(?:4[1-7]|3[1-8])|30[1-9]|10[1-8]|53[1-6]|42[1-3])|21(?:1[1-9]|0[0-8])))',
    '517' => '(?:0(?:0(?:81|0[0-5]|[13][1-5]|4[1-7]|2[1-6])|2(?:0[1-9]|1[1-8])|50[0-7]|40[1-5]|70[1-5]|60[1-4]))',
    '518' => '(?:(?:0(?:4(?:5[3-9]|[167][1-9]|[03]\d|2[1-8]|[48][1-6])|8(?:1[0-8]|7[1-578]|[56][1-9]|0[1247-9]|[2-4]\d)|7(?:[14]\d|5[1-6]|6[1-3]|[23][1-9]|[07][1-5])|6(?:3[1-4]|1\d|2[1-8]|0[1-9]|4[1-7])|0(?:3[1-6]|0[0-8]|[12][1-7])|1(?:31|2[1-7]|0[1-8]|1[1-6])|2(?:1[1-9]|2[1-7]|0[1-6])|50[1-5])|1(?:3(?:0[1-7]|1[1-9]|2[1-6])|4(?:0[13-8]|1[2467]|2[124-9])|1(?:5[1-5]|4[1-7]))))',
    '519' => '(?:(?:0(?:1(?:[78]1|0[0-6]|[156][1-9]|[23][1-7]|4[1-8])|4(?:[23][1-8]|0[0-8]|1[1-7])|2(?:2[1-3]|1[1-5]|7[12])|3(?:2[1-4]|1[1-6])|6(?:11|0[1-9])|50[1-7])|2(?:1(?:00|4[1-8]|6[1-7]|[578][1-9])|5(?:0[1-7]|2[1-5]|1[1-8])|4(?:1[1-3]|2[1-9]|0[0-5])|7(?:0[0-4]|3[1-6])|2(?:0[1-4]|1[1-6])|63[1-4]|80[12]|911)|3(?:6(?:4[0236-8]|3[47-9]|6[3467]|2[01356]|5[1-3689]|1\d|0[0-24-69]|7[1-4])|4(?:21|1[1-5]|0[0-8])|20[1-9]|81[1-4]|92[1-4]|70[12]|111)|1(?:1(?:0[1-8]|[12][1-9])|4(?:[0-2][1-6])|7(?:11|0[1-8]))|5(?:4(?:1[1-7]|0[1-6])|7(?:1[1-8]|0[01])|2(?:11|0[0-6])|32[1-7]|83[1-5])|4(?:3(?:00|2[1-7])|44[1-9]|20[1-7]|56[1-6]|67[1-5])))',
    '520' => '(?:(?:0(?:0(?:[1-3][1-8]|[4-6][1-7]|0[0-6])|8(?:71|[023][1-7]|6\d|1[1-8]|[45][1-6])|5(?:1[1-6]|[03][1-3]|2[1-9])|2(?:2[1-7]|3[1-6]|4[1-8])|1(?:1[1-6]|0[1-7])|4(?:7[1-8]|6[1-5])|3(?:5[1-7]|6[1-3]))|1(?:6(?:4[1-8]|1[1-4]|2[1-3]|3[1-6]|[05][1-5])|4(?:01|3[1-3]|4[1-4]|[125][1-5])|8(?:3[1-7]|[02][1-6]|1[1-4])|2(?:2[1-4]|1[1-7]|[03][1-5])|1(?:[23][1-3]|4[1-4]|0[0-3]|1[12])|5(?:[12][12]|[03][1-3]))|2(?:1(?:[2-4][1-5]|0[12]|6[1-7]|1[1-8]|5[1-3])|3(?:0[0-5]|6[1-5]|[3-5][1-3]|1[1-6]|2[1-4])|5(?:31|[126][1-4]|7[1-3]|[45][12]|0[0-4])|4(?:[13][1-7]|2[1-4])|2(?:6[1-7]|7[1-9]))|3(?:0(?:0[0-6]|[1-4][1-7])|2(?:3[1-5]|0[0-3]|4[124-8]|5[1-4]|2[1-3]|1[1-6])|3(?:3[1-3]|[12][1-6]|0[1-8])|4(?:2[1-7]|[01][1-5]|3[1-6])|1(?:21|1[1-6]|0[1-9]))))',
    '521' => '(?:(?:0(?:0(?:[23][1-5]|0[0-4]|[6-8][1-4]|9[1-3]|1[1-6])|2(?:2[1-7]|1[1-9]|4[1-5]|3[1-6]|0[1-3])|3(?:2[1-7]|0[1-8]|1[1-4]))|1(?:1(?:4[1-7]|[01][1-5]|[23][1-6])|2(?:[0-4][1-5])|3(?:[015]1|2[12]|3[1-4]|4[1-6]))))',
    '522' => '(?:0(?:0(?:0\d|4[1-7]|[13568][1-9]|7[1-5]|2[1-79])|3(?:2[1-7]|1[1-9]|0[0-6]|4[1-3]|5[1-6]|3[1-8])|2(?:71|0[01]|[145][1-4]|[26][1-3]|3[1-9])))',
    '523' => '(?:0(?:8(?:[029][1-8]|[357][1-7]|[1468][1-9])|0(?:[17][1-6]|[45][1-8]|6[1-4]|0[0-5]|[238][1-7])))',
    '524' => '(?:0(?:0(?:2[12]|[56][1-5]|3[1-7]|0[0-4]|[14][1-6])|2(?:1[1-5]|0[1-3])|10[1-4]))',
    '525' => '(?:00(?:5\d|1[1-6]|7[12]|2[1-9]|[36][1-7]|0[0-7]|4[1-578]))',
    '526' => '(?:0(?:2(?:[34][1-6]|0[1-9]|[125-7][1-7])|0(?:[16][1-8]|0[0-5]|2[1-5]|5[1-9]|[34][1-7])|8(?:[14][1-7]|2[1-9]|3[1-5]|0[1-6])|1(?:3[1-5]|0[1-8]|[12][1-6])))',
    '527' => '(?:0(?:0(?:[4-68][1-7]|0[0-7]|[1-3][1-9]|9[1-3]|7[1-6])|1(?:[147][1-5]|5[1-7]|2[1-9]|[03][1-8]|6[1-6])|2(?:2[1-8]|1[1-6]|0[1-9]|3[12])))',
    '528' => '(?:0(?:0(?:2\d|[35][1-8]|7[1-4]|[46][1-9]|1[1-7]|0[0-7])|2(?:1[1-3]|2[1-4]|0[1-8]|3[1-5])))',
    '529' => '(?:(?:1(?:6(?:3[1-6]|[01]\d|[245][1-8]|6[1-5])|5(?:[45]1|3[1-7]|7[12]|6[1-6]|[0-2][1-4])|4(?:[0-4][1-5])|2(?:[02][1-8]|1[1-4]|3[1-7])|8(?:[25]1|[01][1-4]|4[1-3]|3[1-6])|1(?:00|5[1-6]|7[1-7]|6[1-9])|3(?:31|0[0-3]|[12][1-5]))|0(?:3(?:[05][1-4]|4[1-6]|2[12]|3[1-5]|[16][1-7])|2(?:41|[0167][1-5]|[25][1-3]|3[1-4])|5(?:41|0[1-6]|1[1-5]|[23][1-7])|4(?:1[1-5]|3[1-7]|0[1-4]|2[1-6])|1(?:[0-3][1-3]|4[1-4])|7(?:2[1-6]|0[1-8]|1[1-5]))))',
    '530' => '(?:(?:6(?:1(?:90|0[1-9]|3[0-5]|[12]\d)|0(?:90|[1-3]\d|0[1-9]))|00(?:[1-3][1-8]|[45][1-7]|0[0-5])))',
    '531' => '(?:(?:6(?:0(?:90|[1-3]\d|0[1-9])|1(?:90|[1-3]\d|0[1-9]))|00(?:41|6[1-4]|7[1-7])))',
    '532' => '(?:00(?:2[1-8]|1[1-3]|3[1-6]|0[0-6]))',
    '533' => '(?:00(?:1[1-5]|0[0-7]|3[1-3]|2[1-4]))',
    '534' => '(?:00(?:0[0-2]|2[1-7]|1[1-6]))',
    '535' => '(?:00(?:31|1[1-3]|0[0-5]|2[12]))',
    '536' => '(?:00(?:0[0-8]|2[1-5]|1[1-7]))',
    '537' => '(?:00(?:1[1-4]|0[0-3]|2[1-5]))',
    '538' => '(?:00(?:00|3[1-7]|[45][1-4]))',
    '539' => '(?:0000)',
    '540' => '(?:(?:6(?:1(?:90|3[0-8]|0[1-9]|[12]\d)|2(?:90|[12]\d|0[1-9]|3[0-8])|0(?:90|[12]\d|3[0-7]|0[1-9])|3(?:90|1\d|2[0-6]|0[1-9]))|00(?:1\d|0[1-8]|[23][1-9])))',
    '541' => '(?:00(?:5[1-9]|4[1-8]))',
    '542' => '(?:00(?:12|8[1-6]|[67][1-7]))',
    '543' => '(?:00(?:[57][1-6]|6[1-3]|[12][1-8]|0[0-2]|3[1-7]|4[1-5]))',
    '544' => '(?:00(?:[12][1-5]|0[0-6]|3[1-4]))',
    '545' => '(?:(?:00(?:[245][1-3]|1[1-4]|0[0-5]|3[1-7])|60(?:[69]0|[1-5]\d|0[1-9])))',
    '546' => '(?:00(?:0[0-3]|3[1-5]|[124][1-4]))',
    '547' => '(?:00(?:1[1-6]|4[1-8]|0[0-6]|2[1-7]|3[1-5]))',
    '549' => '(?:00[0-2]1)',
    '550' => '(?:00(?:1[1-5]|2[1-7]|0[0-6]))',
    '551' => '(?:00(?:[1-3][1-3]|0[0-3]))',
    '552' => '(?:00(?:1[1-6]|2[1-3]|0[0-7]))',
    '553' => '(?:000[0-7])',
    '554' => '(?:00(?:0[0-2]|5[12]|[34][1-3]|[12][1-4]))',
    '555' => '(?:00(?:0[01]|[34][1-4]|1[1-3]|2[1-5]))',
    '556' => '(?:00(?:2\d|0[0-6]|1[1-7]))',
    '557' => '(?:00(?:0[0-4]|[245][1-5]|6[1-3]|1[1-6]|3[1-4]))',
    '558' => '(?:00(?:1[1-5]|4[1-7]|0[0-4]|2[1-4]|3[1-3]|5[1-6]))',
    '559' => '(?:00(?:1[1-7]|0[0-7]|2[1-6]|3[1-4]))',
    '560' => '(?:00(?:[1-5][1-6]|0[0-5]|8[1-5]))',
    '561' => '(?:08(?:[25][1-9]|1[1-7]|[6-8][1-5]|0[1-8]|9[1-4]|[34][1-6]))',
    '562' => '(?:00(?:[34][1-6]|1[1-5]|2[1-9]|0[0-6]))',
    '563' => '(?:0(?:0(?:00|2[1-9]|1[1-7]|[34][1-8]|5\d)|3(?:00|41|6[1-8]|7[1-3]|5[1-6])|1(?:0[0-5]|3[1-5]|2[1-3]|1[1-4])|2(?:5[125-8]|1[1-9])|801))',
    '564' => '(?:00(?:4[1-5]|3[1-9]|0[0-4]|5[1-4]|[12][1-8]|[6-8][1-3]))',
    '565' => '(?:08(?:[57][1-5]|3[1-7]|6[1-3]|[02][1-6]|[14][1-8]))',
    '566' => '(?:00(?:1[1-3]|7[1-4]|0[0-2]|4[1-7]|[2356][1-5]))',
    '567' => '(?:0(?:8(?:9[1-7]|[247][1-9]|5[0-5]|1\d|[368][1-8]|0[1-6])|0(?:[36][1-7]|[25][1-9]|1[0-8]|4[1-8]|0\d|7[1-6]|8[56])))',
    '568' => '(?:00(?:9[1-8]|8[1-9]))',
    '569' => '(?:(?:0(?:0(?:0[0-7]|[24-69][1-7]|[13][1-6]|[78][1-8])|8(?:3[1-6]|1[1-8]|[0245][1-7]))|1(?:1(?:[12][1-8]|0[1-9]|[34][1-7])|0(?:4[1-7]|3[1-9]|0[1-5]|5[1-4]|1[1-8]|2\d))))',
    '570' => '(?:00(?:[18][1-7]|[237][1-9]|[56][1-6]|[49][1-8]|0\d))',
    '571' => '(?:00(?:2[1-9]|1[1-7]|[46][1-8]|[357]\d|0[0-257-9]))',
    '572' => '(?:0(?:0(?:[47][1-8]|[02358]\d|6[1-7]|1[1-9])|8(?:0[136]|[1245]\d|3[1-9]|6[1-7])))',
    '573' => '(?:(?:0(?:0(?:[1258][1-8]|[367][1-7]|0[0-7]|4[1-9]|9[1-5])|1(?:71|[03][1-7]|[1256][1-8]|4[1-6]))|11(?:[1-36-8][1-8]|[45][1-9]|[09][1-7])))',
    '574' => '(?:00(?:4[1-6]|2[1-8]|6[1-4]|0[0-8]|[1357][1-7]))',
    '575' => '(?:00(?:4[1-5]|0[0-4]|[25][1-4]|6[1-3]|[13][1-6]))',
    '576' => '(?:00(?:5[1-4]|4[1-3]|[36][1-6]|0[0-6]|2[12]|1[1-7]))',
    '577' => '(?:0(?:0(?:[16][1-7]|0[0-7]|[25][2-8]|3[2-7]|4[24-8])|8(?:1[1-8]|[04][1-9]|[23][1-7])))',
    '578' => '(?:09(?:6[13-7]|[457][1-8]|3[1-7]|[0-28][1-5]))',
    '579' => '(?:80(?:6[1-6]|[3-5][1-8]|[01][1-5]|2[1-7]))',
    '580' => '(?:00(?:[24][1-6]|3[1-4]|0[0-6]|1[1-7]))',
    '581' => '(?:0(?:0(?:[136][1-9]|7[1-7]|0[0-7]|[49][1-5]|5[1-6]|8[1-8]|2\d)|8(?:5[1-6]|[02][1-3]|1[1-8]|[34][1-7]|6[1-9]|[78][1-5])))',
    '582' => '(?:00(?:[0-2]\d))',
    '583' => '(?:0(?:8(?:[4-6][1-8]|[78][1-6])|0(?:[23][1-7]|0\d|1[1-8])|99[1-6]))',
    '584' => '(?:00(?:[18][1-6]|[25][1-8]|4\d|7[0-46-9]|0[0-8]|[36][1-9]|9[1-5]))',
    '585' => '(?:00(?:0[0-6]|[3-5][1-5]|2[1-7]|1[1-4]))',
    '586' => '(?:00(?:[36][1-9]|[27-9][1-7]|0\d|[145][1-8]))',
    '587' => '(?:00(?:0[0-3]|[23][12]|6[1-6]|4[1-3]|[15][1-4]))',
    '589' => '(?:00(?:2[1-3]|[13][1-6]|0\d))',
    '590' => '(?:0(?:0(?:0[0-8]|[35][1-7]|7[1-9]|6[1-6]|[124][1-8])|9(?:1[1-3]|[3-6]\d|[02][1-8]|[78][1-7])|1(?:[35][1-8]|[12][1-7]|4[1-5]|0[0-6])|4(?:61|5\d|3[1-6]|4[1-9]|[12][1-7]|0[0-7])|5(?:0[0-5]|[13][1-5]|2[1-6])|8(?:3[1-7]|0[1-9]|2\d|1[1-4])))',
    '591' => '(?:(?:80(?:3[1-7]|2[1-5]|4[1-6]|1[1-4]|0[1-8])|0000))',
    '592' => '(?:(?:83(?:4[1-9]|5[12]|3[1-5])|00(?:0[0-6]|1[1-4])))',
    '593' => '(?:(?:83(?:0[1-8]|1[1-7]|2[1-9])|0000))',
    '594' => '(?:(?:00(?:[67][1-6]|[128][1-3]|5[1-4]|0[0-6]|[34][12])|11(?:[03][1-6]|[12][1-8]|4[1-4]|5[1-7])))',
    '595' => '(?:0(?:0(?:81|2[1-8]|[45][1-6]|7[1-5]|0[0-7]|[16][1-7]|3[1-9])|8(?:1[1-4]|0[1-5])))',
    '596' => '(?:0(?:0(?:[12][1-6]|7[1-8]|0[0-6]|[356][1-7]|4[1-9])|8(?:[02][1-8]|[13][1-6]|4[1-5])|1(?:0[1-5]|1[1-6])|901))',
    '597' => '(?:0(?:0(?:[236][1-3]|4[1-6]|5[1-4]|0[0-5]|[17-9][1-5])|1(?:1[1-3]|0[1-7])))',
    '598' => '(?:00(?:[269][1-4]|[45][1-8]|1[1-6]|7[1-5]|3[1-7]|0[0-8]))',
    '599' => '(?:(?:8(?:2(?:7[1-6]|5[1-4]|[34][1-8]|6[1-7])|1(?:2[1-8]|1[1-6]|0[1-47]))|0(?:2(?:0[0-5]|2[1-5]|[13][1-6])|3(?:0[0-4]|1[1-4])|000)))',
    '600' => '(?:(?:8(?:8(?:1[1-6]|8[1-8]|6[1-5]|[279][1-9]|[03-5][1-7])|3(?:[1249]\d|[03][1-8]|6[1-5]|[58][1-9]|7[1-7])|2(?:[02-6][1-9]|1\d)|0(?:[24-79]\d|[0138][1-9])|4(?:[057][1-9]|[1-4689]\d)|1(?:[04][1-9]|[1-35-9]\d))|0000))',
    '601' => '(?:(?:8(?:1(?:[36][1-7]|5[1-5]|[14][1-6]|[0278][1-8])|4(?:[346][1-9]|[015][1-7]|[27][1-8])|3(?:[56][1-7]|[0247][1-9]|[1389]\d)|0(?:4[1-8]|2[1-9]|[013][1-7])|2(?:0[1-7]|1[1-3]))|1(?:3(?:[69][1-6]|[0137][1-8]|[2458][1-7])|4(?:1[1-7]|3[1-9]|6[1-4]|[0245][1-6])|2(?:4[1-8]|[35][1-5])|1(?:1[1-3]|[02][1-5]))|0(?:7(?:[24][1-4]|7[1-8]|1[1-6]|[0356][1-5])|1(?:1[1-3]|0[12]|[2-4][1-5])|2(?:5[12]|7[1-8]|6[1-6])|3(?:2[1-4]|1[1-6])|5(?:3[1-6]|4[1-3])|40[1-6]|000)))',
    '602' => '(?:(?:8(?:2(?:[03579][1-9]|[12468][1-8])|4(?:5[1-5]|[0346][1-9]|[127-9][1-8])|3(?:[034][1-8]|[278][1-7]|[156][1-9]|9[1-5])|1(?:[245][1-8]|[01367][1-9])|0(?:[3-6][1-8]|[12][1-9]|[07][1-7]))|0(?:0(?:0[0-8]|[468][1-7]|[1259][1-9]|3[1-8]|7[1-4])|8(?:81|[025-79][1-8]|[134][1-9])|9(?:[14][1-8]|2[1-6]|0[1-7]|[35][1-9]))))',
    '603' => '(?:(?:8(?:4(?:[048][1-8]|9[1-4]|[67][1-9]|[1-35][1-7])|0(?:[0-3][1-8]|[56][1-6]|[478][1-7])|1(?:2[1-6]|[05][1-8]|[347][1-9]|[16][1-7])|3(?:7[1-8]|[16][1-6]|0[1-5]|[2-5][1-7])|8(?:[2-4][1-8]|5[1-6]|6[1-3]|[01][1-7])|2(?:[02][1-8]|[134][1-7]))|0000))',
    '604' => '(?:(?:8(?:0(?:[036-8][1-6]|[1245][1-7]|9[1-5])|4(?:1[1-8]|[24][1-6]|[3569][1-7]|[078][1-5])|1(?:[248][1-7]|[035-7][1-6]|1[1-8])|2(?:[0-467][1-7]|5[1-8])|3(?:8[1-4]|[01356][1-6]|2[1-7]|[47][1-5])|8(?:[27][1-4]|5[1-6]|6[1-3]|4[1-7]|[13][12]|0[1-5]))|0(?:0(?:[2369][1-6]|[145][1-5]|[78][1-7]|0[0-5])|9(?:[01][1-7]|[23][1-5]|4[1-4]|[5-9][1-6])|8(?:[78][1-6]|[01][1-5]|[2-6][1-7]))))',
    '605' => '(?:0(?:9(?:[136][1-8]|[078][1-9]|[245][1-7]|9[1-5])|0(?:[126-8][1-9]|5[12]|4[1-6]|3[1-8]|0\d)|8(?:6[1-5]|1[1-7]|[23][1-9]|[0457][1-8])))',
    '606' => '(?:(?:8(?:2(?:0[1-6]|9[1-5]|[1-8][1-7])|3(?:[2-467][1-6]|[01589][1-7])|1(?:3[1-6]|5[1-8]|[0-246-8][1-7])|0(?:[67][1-5]|[02-5][1-7]|1[1-4]|8[1-6])|4(?:2[1-8]|5[1-5]|[0134][1-7]))|0(?:0(?:[01]\d|[4679][1-8]|3[1-7]|[258][1-9])|9(?:[0-24-6][1-7]|3[1-8])|8(?:[0-46][1-7]|5[1-6]))))',
    '607' => '(?:(?:8(?:4(?:9[1-8]|[34][1-3]|[5-7][1-6]|8[1-5]|[0-2][1-9])|0(?:91|1[1-8]|8\d|[0267][1-9]|5[12]|[34][1-5])|1(?:[08][1-9]|4[1-7]|[1-35][1-6]|9[1-4]|[67]\d)|2(?:61|0[1-4]|[1-35][1-9]|4[12])|3(?:11|[45][1-8]|3[1-7]|[02][1-9]))|0000))',
    '610' => '(?:(?:0(?:3(?:4[1-3]|2[1-6]|3[1-4]|0[0-3]|6[12]|1[1-5]|5[1-7])|2(?:[1-46]1|0[0-2]|5[1-5])|1(?:21|1[1-8]|0[0-3])|000)|11(?:[15][1-3]|[34][1-6]|2[1-8]|0[1-7])))',
    '611' => '(?:00(?:[14][1-5]|2[1-9]|0[0-3]|3[1-3]))',
    '612' => '(?:(?:8(?:2(?:[26][1-8]|[01347][1-9]|[589][1-7])|3(?:8[14-8]|7[1-79]|4[1-7]|[1256][1-9]|9[1-5]|[03][1-8])|0(?:3[1-46-9]|[0-258][1-9]|6[1-7]|[47][1-8])|4(?:9\d|2[1-35-9]|7[136-8]|[13468][1-9]|0[1-5]|5[0-24-79])|1(?:41|5[1-8]|[13][1-6]|0[1-9]|2[1-5]))|0(?:8(?:[0-46-8][1-9]|5[1-6])|0(?:0\d|[36][1-8]|7[1-4]|[12458][1-9]))))',
    '613' => '(?:0(?:0(?:00|[2-4][1-6])|9(?:0[1-7]|1[1-6])|85[1-3]))',
    '614' => '(?:(?:8(?:0(?:7[1-9]|1[1-7]|[04-68][1-8]|3\d|[29][1-6])|1(?:8[1-4]|2[1-8]|[0367][1-6]|[19][1-7]|[45][1-9])|2(?:9[1-7]|[27][1-9]|1[1-6]|[04-6][1-8]|[38]\d)|3(?:3[1-6]|5[1-3]|0[1-8]|[267][1-7]|4[1-9]|1[1-5]))|0000))',
    '615' => '(?:(?:8(?:2(?:[023][1-8]|[459][1-6]|[16-8][1-7])|1(?:[26][1-5]|[04][1-7]|[157][1-8]|[389][1-6])|0(?:6[1-5]|[23578][1-7]|[01][1-8]|4[1-6])|30[1-3])|0(?:0(?:[02369][1-7]|8[1-5]|1[1-6]|7[1-4]|[45][1-8])|8(?:4[1-6]|6[1-4]|[1357][1-8]|8[1-5]|[02][1-7])|9(?:3[1-8]|2[1-6]|[01][1-7]))))',
    '616' => '(?:(?:8(?:2(?:[35-7][1-8]|[0-28][1-9]|[49][1-7])|1(?:\d[1-7])|4(?:[0148][1-7]|3[1-9]|7[1-5]|[256][1-8]|9[1-4])|3(?:[0-689][1-7]|7[1-6])|0(?:8[1-5]|[0-79][1-7]))|00(?:0[0-7]|[12][1-7])))',
    '617' => '(?:0(?:8(?:[1-3][1-8]|[45][1-7])|00[0-6]))',
    '618' => '(?:00(?:[7-9]1|1[1-5]|0[0-4]|2[1-4]))',
    '619' => '(?:(?:1(?:1(?:[02][1-7]|[45][1-4]|1[1-3]|3[1-6])|2(?:1[1-3]|2[1-6]|0[0-5])|4(?:[12][12]|0[0-2])|30[0-4])|02(?:[13][1-8]|2[1-5]|[04][0-6])))',
    '620' => '(?:(?:0(?:8(?:[028][1-8]|[3-57][1-9]|[16][1-7]|9[1-5])|9(?:[15][1-8]|4[03-9]|7[1-4]|2[0-8]|[0368][1-9])|0(?:6[1-6]|7[1-8]|0[0-5]|[235][1-9]|[14][1-7])|3(?:[13][1-4]|5[1-6]|2[1-7]|4[12]|0[1-5])|2(?:[02]1|1[1-4]))|1(?:4(?:[2-4][1-5])|3(?:0[12]|1[1-4]))))',
    '621' => '(?:0(?:8(?:[05][1-6]|[126][1-9]|4[1-7]|3[1-5])|0(?:1[1-8]|5[1-4]|4[1-6]|2[1-9]|3[1-7]|0[0-8])|2(?:[46][1-3]|[35][1-5])|1(?:2[1-7]|1[1-5]|0[1-4])))',
    '622' => '(?:0(?:0(?:[36][1-6]|0[0-4]|5[1-9]|[14][1-7]|2[1-5])|2(?:0[0-3]|3[1-6]|[12][1-4])|3(?:2[1-5]|3[12]|0[1-4]|1[1-6])|4(?:4[1-5]|5[1-3])))',
    '623' => '(?:(?:0(?:0(?:3[1-7]|0[0-8]|5[1-4]|[1246][1-6])|3(?:6[1-4]|4[1-6]|5[1-3])|1(?:0[1-8]|1[1-7])|2(?:[23][1-6]))|11(?:[23][1-4])))',
    '624' => '(?:0(?:9(?:[02][1-9]|3[1-7]|1[1-4]|6[1-8]|[45][1-6])|8(?:4[1-3]|[0-3][1-6]|5[1-5])|1(?:1[1-8]|0[1-3]|2[1-5])))',
    '625' => '(?:0(?:0(?:4[0-5]|[57][0-8]|1[0-6]|[02368][0-7])|1(?:5[1-8]|[34][1-7])))',
    '626' => '(?:0(?:0(?:5[1-5]|1[1-9]|[347][1-7]|0[0-8]|2\d|6[1-8])|4(?:1[1-7]|2[1-5]|0[0-5]|3[1-3])|2(?:2[1-7]|0[1-6]|1[1-3])))',
    '627' => '(?:0(?:0(?:4[1-5]|2[1-7]|0[0-7]|[15][1-4]|3[1-8])|2(?:0[12]|[34][1-9]|1[1-6]|2[1-8])|1(?:[23][1-3]|[01][12]|4[1-5])))',
    '629' => '(?:(?:3(?:4(?:2[1-4]|3[1-8]|[04][1-9]|1[0-6])|1(?:2[12]|1[1-3]|3[1-6]|0[1-4])|5(?:7\d|6[1-6]|5[1-9])|24[1-6])|1(?:1(?:1[1-7]|[34][1-5]|2[12]|0[1-8])|2(?:5[1-7]|4[1-5]|[67][1-4])|3(?:2[1-3]|[01][1-5]))|2(?:5(?:1[1-5]|2[1-3]|[03][1-4])|2(?:00|51|[34][1-4]|6[1-3])|4(?:0[1-4]|[12][1-3])|3(?:0[1-3]|1[1-4]))|0(?:1(?:41|2[12]|1[1-5]|6[1-6]|[035][1-4])|3(?:41|[12][1-3]|0[12]|3[1-5])|271)))',
    '630' => '(?:(?:8(?:2(?:[0-68][1-8]|[79][1-7])|3(?:[05][1-7]|[68][1-5]|[79][1-4]|[1-4][1-8])|0(?:[24][1-5]|3[1-7]|0[1-3]|1[1-6]|5[1-4])|1(?:[23][1-7]|1[1-5]|4[1-6]|0[1-8])|4(?:[02-4][1-5]|[15][1-4]))|0(?:2(?:0[0-3]|6[1-7]|3[1-9]|7[12]|1[1-5]|[245][1-8])|1(?:01|2[1-3]|1[1-6]|3[1-8]|4[12])|000)|2(?:2(?:[02][1-5]|1[12]|3[1-4])|1(?:[67][1-8]|5[1-3])|3(?:5[1-7]|[04][1-6]))|1(?:1(?:1[1-3]|2[1-6]|0[1-5])|2(?:3[1-7]|4[1-5]))))',
    '631' => '(?:0(?:0(?:[13-6][1-6]|[07][1-8]|2[1-7])|8(?:3[1-7]|[04][1-6]|[12][1-8])))',
    '632' => '(?:0(?:0(?:[1457-9][1-8]|3[1-6]|2[1-5]|6[1-9]|0[0-7])|2(?:[25]1|3[12]|[04][1-7])|1(?:[0-2][1-3])))',
    '633' => '(?:(?:0(?:0(?:91|5[1-5]|8[1-7]|0[0-7]|7[1-9]|3[1-6]|[1246][1-8])|2(?:[12][1-8]|[34][1-6]|5[1-7]|0[0-8])|1(?:[12][12]|0[1-8]|3[1-3])|31[1-7]|42[1-5])|2(?:1(?:3[1-9]|1[1-7]|[256][1-6]|4[1-4]|7\d|0[1-8])|2(?:2[1-7]|[01][1-5])|4(?:00|[24][1-4]|3[1-3])|3(?:[01][1-4]))|1(?:2(?:1[1-6]|0[0-3])|30[0-4])))',
    '634' => '(?:0(?:0(?:4[1-6]|7[1-8]|0\d|[13][1-4]|2[1-9]|5[12]|6[1-5])|1(?:[24][1-5]|0[0-8]|[13][1-8])|8(?:2[1-9]|[134][1-7]|0[1-5])))',
    '635' => '(?:0(?:0(?:[1346-9][1-7]|5[1-9]|0[0-4]|2[1-6])|1(?:[45][1-4]|[12][1-3]|3[1-6]|0[0-4])|8(?:1[1-8]|[023][1-5])))',
    '636' => '(?:0(?:3(?:5[1-5]|[14][1-7]|0[0-7]|[23][1-9])|0(?:5[1-7]|1[1-5]|8[12]|0[0-3]|[2679][1-3])|2(?:[02][1-6]|4[1-8]|[13][1-7])|1(?:3[1-3]|1[1-6]|[245][1-4]|0[0-6])|9(?:[24][1-5]|3[1-8]|[01][1-6])|8(?:[23][1-4]|[01][1-5])))',
    '637' => '(?:(?:0(?:0(?:[58][1-4]|[26]\d|[37][1-8]|[49][1-3]|1[1-9]|0[0-6])|4(?:1[1-79]|0[1-9]|2[1-5])|1(?:1[1-7]|0[1-5])|2(?:3\d|2[1-7]))|1(?:2(?:2[1-5]|1[1-7])|5(?:00|5[1-9])|10[1-8]|66[1-8]|33[1-6]|44[1-6])))',
    '638' => '(?:0(?:0(?:2[1-6]|0[0-3]|[134][1-5])|8(?:21|[03-5][1-3]|1[12])|2(?:[125]1|[34][1-3]|0[0-3])|6(?:4[1-4]|6[1-3]|5[1-7])|3(?:0[0-5]|1[1-5]|2[12])|5(?:6[1-4]|[45][1-3])|431))',
    '639' => '(?:(?:2(?:2(?:[4-6][1-8]|1[1-7]|[237][1-9]|0[0-7])|1(?:5[1-5]|[24][1-7]|0[0-3]|3[1-8]|6[1-4]|1[1-3])|3(?:3[1-7]|[04][1-6]|[12][1-8]))|1(?:0(?:4[1-5]|[13][1-9]|6[1-6]|[025][1-8])|1(?:[14][1-9]|2[1-7]|0[0-8]|[56]\d|3[1-8]))|3(?:1(?:0[0-8]|[12][1-8])|6(?:3[1-5]|0[1-4]|[12][1-3])|5(?:00|5[1-8]|4[1-3])|4(?:4[1-6]|3[1-7])|70[0-5]|32[1-5]|80\d)|02(?:[23][1-7]|4[1-5]|0[0-6]|[5-7][1-6]|1[1-8])))',
    '640' => '(?:(?:8(?:2(?:[46][1-9]|[0157][1-6]|8[1-8]|[239]\d)|3(?:0[1-6]|[259]\d|7[1-8]|[46][1-5]|1[1-9]|[38][1-7])|0(?:[035][1-9]|[14][1-7]|7[1-8]|[26]\d)|4(?:[23][1-5]|7[12]|[58][1-3]|1[1-6]|[046][1-4])|1(?:4[1-6]|5\d|[02][1-8]|[13][1-9]))|1(?:2(?:0[1-7]|[135][1-5]|4[1-4]|2[1-3])|1(?:[2-4]1|0[0-3]|[17][1-5]|6[1-7])|3(?:6[1-6]|3[1-3]|5[1-4])|4(?:81|7[1-6]))|0(?:3(?:[26][1-4]|1[1-6]|[35][1-3]|0[1-7]|4[1-5])|4(?:[25][1-4]|[01][1-6]|4[1-3])|1(?:1[1-5]|0[1-3])|000)))',
    '641' => '(?:00(?:6[12]|[124][1-5]|[35][1-6]|0[1-8]))',
    '642' => '(?:00(?:0[0-4]|2[1-9]|1[1-7]|3[1-5]))',
    '643' => '(?:0(?:1(?:2[1-9]|3[1-7]|[67][1-6]|5[1-3]|4[1-4])|0(?:0[0-7]|[57][1-5]|[26][1-6]|3[1-4])|8(?:5[1-5]|4[1-8]|[01][1-3])|5(?:51|1[1-5]|2[12]|3[1-3]|4[1-4])|3(?:1[1-4]|6[1-6])|6(?:1[1-4]|0[1-5])))',
    '644' => '(?:(?:1(?:1(?:[01]1|[36][1-4]|[24][1-3]|5[12])|2(?:[03]1|[14][1-4]|2[12]))|0(?:0(?:[124][1-5]|0[0-5]|3[1-4])|2(?:1[1-8]|0[12]))))',
    '645' => '(?:0(?:0(?:2[1-8]|1[1-4]|0[0-6])|5(?:51|2[1-5])|20[1-8]|41[1-7]|30[1-3]))',
    '646' => '(?:(?:0(?:0(?:5[0-46-9]|[34][1-8]|6[1-3]|2[1-9]|1[1-5]|0[0-5])|3(?:0[1-5]|1[1-4])|21[1-7]|10[12])|1(?:4(?:21|3[1-9]|1[1-7]|0[12])|3(?:2[1-6]|3[1-9])|21[1-4]|101)))',
    '647' => '(?:(?:1(?:7(?:4[1-4]|5[1-3]|[23][1-6]|0[1-5]|1[1-7])|2(?:71|1[1-6]|2[1-3]|0[1-7]|3[1-5])|60[0-5]|32[1-5]|58[1-4]|10[1-3])|00(?:[68]1|7[1-3]|[35][1-4]|0[0-8]|2[0-5]|1[1-9]|4[1-5])))',
    '648' => '(?:0(?:0(?:0[0-7]|[19][1-9]|[27][1-5]|[38][1-8]|[45][1-4]|6[1-6])|2(?:[13-5]1|2[1-7]|0[0-2]|6[1-3])|1(?:[125-7]1|4[1-5]|3[1-3]|0[01])|40[1-5]|30\d))',
    '649' => '(?:(?:6(?:2(?:0[0-8]|7[1-5]|1[1-9]|3[1-6]|[25][1-8]|4[1-68]|6[1-4])|5(?:7[1-3]|2[1-6]|[01][1-4]|[34][12]|[56][1-5])|4(?:4[1-7]|0[0-7]|3[1-5]|5[12]|[12][1-8])|3(?:2[1-6]|[01][1-8]|3[1-9])|6(?:31|[01][1-6]|2[1-4])|1(?:[16][12]|[02][1-5]))|1(?:3(?:00|1[1-6]|2[1-5]|[34][12])|2(?:0[0-3]|2[1-5]|1[1-3]|3[1-4])|1(?:0[0-4]|[12][1-3]|3[1-4])|5(?:00|3[1-7]|2[1-8])|44[1-4])|0(?:1(?:01|4[1-7]|1[12]|6[1-4]|5[1-6]|[23][1-3])|3(?:0[0-7]|1[1-7])|4(?:2[12]|3[1-7]))|2(?:5(?:11|3[1-9]|2[1-5])|6(?:[23]1|1[12]|0[0-4])|3(?:3[1-4]|2[1-6])|10[0-8]|2(?:11|0[01]))|4(?:1(?:1[1-7]|0[0-6]|2[1-6])|2(?:[12][1-7]|3[1-6])|4(?:4[1-4]|5[1-5])|56[1-5])|7(?:1(?:2[1-3]|4[1-6]|0[0-4]|[157][1-5]|[36][1-7])|2(?:0[1-7]|1[1-6]))|5(?:3(?:71|3[1-9]|0[0-4]|1[1-4])|1(?:00|3[1-7]|7[12]|4[1-8])|4(?:6[1-6]|5[1-4]))|3(?:5(?:0[0-3]|1[0-8]|2[1-4])|1(?:6[1-9]|[45][1-3])|63[1-3])))',
    '650' => '(?:00(?:4[1-8]|0[0-7]|[12][1-7]|3[1-9]))',
    '651' => '(?:(?:1(?:2(?:5[1-5]|[04][1-6]|[23][1-3]|[16][1-4])|3(?:2[12]|4[1-5]|0[1-6]|1[1-3]|[35][1-4])|1(?:0[0-5]|2[1-5]|4[1-7]|3[1-3]|1[1-4])|5(?:0[1-5]|[12][1-6])|4(?:01|[13][1-3]|2[1-4])|6(?:0[1-4]|2[1-3]|1[1-6]))|2(?:2(?:4[1-4]|[26][1-8]|[0157][1-7]|3[1-9])|1(?:2\d|[34][1-8]|0[1-9]|1[1-7])|3(?:21|[03][1-4]|1[1-3])|4(?:0[1-5]|1[1-4]))|00(?:7[1-9]|9[1-7]|[568][1-8])))',
    '652' => '(?:0(?:8(?:[578][1-5]|[034][1-7]|2[1-3]|[16][1-6]|9[1-8])|0(?:71|5[1-8]|[13][1-6]|2[1-3]|4[1-7]|6[1-5]|0[0-8])))',
    '653' => '(?:0(?:8(?:1[1-4]|[38][1-8]|[05][1-6]|4[1-5]|[26][1-7]|7[1-9])|0(?:1[1-6]|[245][1-5]|3[1-9]|0[0-4])))',
    '654' => '(?:0(?:0(?:81|0\d|[126][1-8]|7[1-6]|5[1-5]|[34][1-9])|1(?:[0246][1-3]|[13][1-4]|5[1-5])))',
    '655' => '(?:0(?:0(?:1[1-8]|0\d|[2-4][1-9]|5[12])|8(?:[89][1-6]|[57][1-4]|6[1-5])))',
    '656' => '(?:(?:0(?:4(?:00|6[12]|5[1-7]|[27][1-8]|8[1-4]|1[1-3]|[34][1-6])|0(?:31|0[0-6]|2[1-7]|5[1-5]|4[1-6]|1[1-8])|5(?:[25]1|3[1-4]|1[1-8]|0[1-3]|4[1-6])|3(?:41|1[1-5]|3[12]|2[1-7]|0[1-8])|1(?:[0136]1|4[1-3]|5[1-4]|2[12])|6(?:51|6[1-3])|961)|1(?:3(?:1[1-8]|[04][1-4]|[23][1-7])|5(?:[34]1|2[1-6]|0[1-3]|5[1-8]|1[12])|7(?:3[1-6]|4[1-3]|2[1-7]|1[12])|60[1-6])|2(?:1(?:00|3[12]|4[1-4]|[25][1-6]|6[1-3])|3(?:11|3[1-4]|2[1-3]|0[1-7])|2(?:1[1-4]|2[1-5])|5(?:[34][1-3])|4[05]1)))',
    '657' => '(?:0(?:0(?:4[1-5]|[25][1-9]|0[0-2]|[136][1-8])|8(?:3[1-8]|6[1-4]|[245][1-6]|1[1-7]|0[1-5])|1(?:11|0[1-5])))',
    '658' => '(?:00(?:4[1-8]|[58][1-4]|[37][1-3]|[16][1-6]|2[1-7]|0[0-5]))',
    '659' => '(?:00(?:[38][1-7]|5[1-5]|0[0-4]|[26][1-8]|[179][1-6]|4[1-3]))',
    '660' => '(?:0(?:8(?:[18][1-5]|5[16-8]|9[1-3]|3[1-57]|4[1-6]|[0267][1-8])|0(?:00|6[1-4]|9[1-6]|5[1-5]|[78][1-7])))',
    '661' => '(?:0(?:0(?:3[1-5]|4[1-7]|1[1-4]|0[1-3]|2[1-6])|9(?:6[1-7]|8[1-5]|7\d|5[1-3])))',
    '662' => '(?:0(?:0(?:5[1-4]|[1378][1-8]|9[1-9]|[246][1-7]|0[0-6])|8(?:5[1-7]|[17][1-5]|2[2-8]|[489][1-6]|[36][1-8])|9(?:[45][1-7]|6[1-5]|[127][1-8]|3[1-4])))',
    '663' => '(?:8(?:1(?:5[1-6]|4[1-3]|1[1-4]|7[1-9]|[02368][1-7])|2(?:[03][1-4]|1[1-5]|2[1-9]|4[1-7])|0(?:0[1-6]|1[1-7]|[23][1-5])))',
    '664' => '(?:0(?:8(?:[58][1-8]|4[2-7]|[39][1-9]|[67][1-5])|0(?:31|1[1-7]|0[0-8]|2[02-9])))',
    '665' => '(?:0(?:8(?:91|[046][1-8]|5[1-6]|[1-378][1-7])|0(?:7[1-6]|[23][1-5]|0[0-7]|[14-6][1-7])))',
    '666' => '(?:0(?:1(?:6[12]|[01][1-7]|2[1-9]|[3-5][1-8])|2(?:[25][1-7]|6[12]|1[1-5]|0[0-4]|3[1-8]|4[1-6])|0(?:2[1-6]|[13][1-7]|0[0-7])))',
    '667' => '(?:(?:1(?:3(?:2[1-6]|[05][1-4]|6[1-8]|[134][1-7])|5(?:[14][1-5]|[023][1-3])|1(?:1[1-9]|0[1-5]|2[1-8]))|0(?:0(?:3[12]|4[1-5]|0[0-5]|2[1-4]|1[1-6]|5[1-3])|1(?:[14][1-5]|0[1-7]|[23][1-6])|3(?:0[1-6]|[12][1-5])|43[1-6])))',
    '668' => '(?:0(?:0(?:3[1-3]|1[1-6]|7[1-8]|[68][1-5]|[245][1-7]|0[0-6])|2(?:5[1-7]|[07][1-9]|2[1-5]|[46][1-6]|[13][1-8])|3(?:[13][1-7]|[24][1-5]|[056][1-4]|7[1-6])|8(?:[57][1-5]|[01][1-7]|6[1-6]|[2-4][1-4])))',
    '669' => '(?:(?:2(?:4(?:[01][1-8]|[256][1-5]|4[1-7]|3[1-9])|3(?:[35][1-7]|6[1-9]|1[1-8]|0\d|[24][1-6])|1(?:1[1-4]|[05][1-6]|6[1-3]|[2-4][1-5])|5(?:2[1-7]|[034][1-5]|5[1-4]|1[1-3])|7(?:0[1-4]|[12][1-8]|3[1-7])|2(?:31|[12][1-4]|0[1-6])|8(?:2[1-7]|[01][1-5])|6(?:0[1-5]|1[1-6]))|6(?:7(?:61|1[1-6]|5[1-3]|2[1-8]|0[0-2]|4[1-7]|3[12])|4(?:3[1-3]|[12][1-6]|0[1-4])|5(?:00|5[1-9]|4[1-6]|6[1-4])|8(?:3[1-3]|0[1-8]|1[1-5]|2[12])|2(?:2[1-9]|1[1-8]|0[1-3])|1(?:1[1-6]|0[1-3]|2[1-7])|3(?:[35][1-5]|4[1-4])|9(?:5[1-4]|4[1-6])|67[12])|3(?:1(?:[246][1-8]|1[1-3]|0[1-5]|3[12]|5[1-9])|6(?:[024][1-6]|[135][1-4])|8(?:[03][1-4]|4[1-3]|2[1-7]|1[12])|4(?:6[1-7]|0[1-4]|1[1-6])|5(?:7[1-5]|8[1-3])|3(?:0\d|1[1-6]))|1(?:3(?:5[1-8]|0[0-4]|[34][1-9]|1[1-7]|2[1-5])|5(?:4[1-8]|[013][1-7]|2[1-9])|1(?:0[1-4]|3[1-6]|4[1-9]|[126][12])|2(?:[13-5]1|2[12]|0[1-5])|4(?:[01][1-7]))|5(?:3(?:4[1-6]|2[1-8]|[35-7][1-9]|0[1-7]|1[1-5])|2(?:2\d|[356][1-8]|[14][1-6]|0[0-4])|1(?:[12][1-5]|3[1-6]|[45][1-3]|0[1-4]))|4(?:3(?:[13][1-7]|[24][1-5]|0[12])|2(?:5[1-3]|7[1-4]|6[1-5])|1(?:41|[23][1-5]))))',
    '670' => '(?:0(?:8(?:[1-3578][1-7]|4[1-9]|[069][1-8])|0(?:[689][1-6]|0\d|[35][1-8]|7[1-5]|1[1-7]|[24][1-9])|9(?:[079][1-6]|4\d|8[1-79]|6[124-6]|5[1-5]|[1-3][1-7])))',
    '671' => '(?:(?:1(?:2(?:4[12]|0[1-5]|5[1-7]|1[1-4]|2[1-8]|6[1-3]|3[1-6])|5(?:[16]1|0[0-4]|5[1-7]|[34][1-5]|7[1-6]|2[1-4])|1(?:2[1-5]|[13-5][1-6]|0[1-8])|6(?:[25]1|[014][1-3]|6[1-5]|3[12])|3(?:[02]1|[134][12]))|2(?:5(?:3[1-6]|[25][1-8]|[67]\d|0[0-8]|1[1-9]|4[1-5])|2(?:[14][1-7]|[23][1-4]|0[1-3])|1(?:[13][1-7]|0[1-356]|2[1-4])|4(?:01|[12][1-6]))|4(?:1(?:[12][1-5]|3[1-9]|4[1-4]|0[1-8])|2(?:21|0[1-4]|1[1-6]|4[1-5]|3[12]))|0(?:2(?:0[1-57-9]|1[124-9]|[25][1-6]|3[1-4]|4[1-8])|1(?:1[12]|[02][1-3]))|32(?:3[1-3]|[01][12]|2[1-5])))',
    '672' => '(?:(?:80(?:6[1-49]|9[0-8]|[15][1-9]|2[1-5]|4[013-9]|[378]\d|0[1-4])|010[1-3]))',
    '673' => '(?:(?:0(?:8(?:5[1-7]|4[1-9]|9[1-8]|7\d|8[1-6]|6[0-26-8])|4(?:0[0-5]|[12][1-5]|[3-5][1-6])|0(?:[24][1-9]|[13][1-8]|0\d)|7(?:1[1-5]|5[1-8]|[02][1-4]|3[1-6]|4[1-3])|5(?:[24]1|3[1-4]|5[1-3]|[01][1-6]))|1(?:4(?:3[1-4]|[15][1-6]|4[1-7]|[267][1-5]|0[0-4])|3(?:41|3[1-8]|[01][1-4]|2[1-5])|1(?:[12][1-9]|0[1-8])|2(?:4[1-4]|3[1-6]))))',
    '674' => '(?:00(?:[78][1-4]|9[1-5]|[56][1-9]))',
    '675' => '(?:(?:0(?:1(?:[24][1-8]|5[014-9]|[13][1-7]|6[02-4]|0[0-5])|0(?:[24][1-7]|3[1-9]|[01]\d|[56][1-8])|3(?:21|4[1-7]|[03][1-6]|1[1-4]))|2(?:4(?:[25][1-6]|[013][1-4]|[46][1-5])|3(?:3[1-7]|[25][1-4]|[46][1-6]|[01][1-3])|2(?:[03][1-4]|[124][1-3])|1(?:0[1-5]|1[1-4]))|1(?:3(?:7[1-9]|4[1-6]|[1-3][1-8]|[056]\d)|2(?:[023][1-6]|1[1-8])|1(?:2[1-7]|0[0-5]|1[1-6]))))',
    '676' => '(?:0(?:0(?:[2367][1-8]|5[1-6]|8[12]|[14][1-9]|0[0-8])|8(?:0[1-9]|1[1-6]|2[1-8])))',
    '677' => '(?:0(?:0(?:1[1-8]|4[1-4]|2[1-6]|0[0-6]|[36][1-9]|5[1-7])|1(?:1[1-4]|[23][12]|0[1-5])))',
    '678' => '(?:(?:0(?:0(?:31|0[0-8]|[189][12]|2[1-5]|6[1-7]|5[1-6]|[47][1-4])|2(?:0[0-8]|1[1-7]|[2-4][1-9]|5\d)|1(?:41|[67][1-6]))|1(?:2(?:7[1-8]|4[1-4]|[25][1-6]|3[1-3]|1[1-9]|6[12]|0[0-5])|18[1-6])))',
    '679' => '(?:(?:5(?:3(?:[23][1-5]|0[0-7]|1[1-9]|4[1-6])|1(?:4[1-8]|3[1-7]|[56][1-5])|5(?:[023][1-5]|1[1-4])|2(?:[02][1-7]|1[1-5])|6(?:4[1-6]|5[1-4]))|4(?:1(?:[26][1-9]|[037]\d|[145][1-6])|3(?:[14][1-6]|3[1-3]|2[1-7]|0[1-5])|0(?:0[1-8]|[12][1-7])|2(?:0[1-6]|[23][1-3]|1[1-5]))|2(?:1(?:01|6[1-7]|[15][1-5]|3[12]|[24][1-4])|3(?:1[1-8]|[23][1-7]|0[0-4])|4(?:3[1-4]|[0-2][1-5])|2(?:1[1-8]|0[0-5]))|3(?:4(?:4[12]|[12][1-4]|[035][1-3])|1(?:1[1-6]|2[1-5]|0[0-4])|3(?:[14]1|[03][12]|2[1-6]))|1(?:1(?:2[1-4]|[13][1-5]|0[0-7])|3(?:2[1-7]|3[1-8])|2(?:[01][1-5]))|0(?:3(?:[02][1-4]|1[1-6])|2(?:0[1-7]|[12][1-3])|10[1-9])))',
    '680' => '(?:(?:0(?:0(?:81|[134][1-7]|6[12]|0[0-8]|[27][1-4]|5[1-6])|4(?:6[1-3]|1[1-6]|7[1-4]|3[1-8]|0[0-8]|4[1-5]|[25][1-7])|8(?:[35-7][1-5]|4[1-7]|[12][1-4]|0[1-6])|9(?:[13][1-5]|4[1-7]|0[1-9]|2[1-4])|7(?:[13][1-5]|0[01]|2[1-8]|4[1-6])|2(?:[12][1-6]|0[1-8])|5(?:4[1-5]|[23][1-7])|1(?:[3-5][1-6])|3(?:1[1-6]|0[1-7])|6(?:1[1-4]|0[1-7]))|1(?:2(?:2[1-5]|[14][1-6]|0[1-8]|[35][1-4])|1(?:[5-7][1-7]|4[1-6]|3[1-3])|4(?:3[1-9]|4[1-4]|[12][1-8]))|80(?:2[12]|6[2-6])))',
    '681' => '(?:00(?:0[0-3]|4[1-7]|[26][1-5]|[35][1-6]|[17][1-4]))',
    '682' => '(?:0(?:8(?:7[1-5]|[013-68][1-7]|2[1-6])|1(?:00|5[1-9]|2[1-5]|[34][1-6]|7[1-36-8]|6[1-3])|9(?:[01][1-5]|[35][1-4]|4[1-8]|2[1-6])|0(?:1[1-8]|3[1-6]|[24][1-5]|0[0-6])|6(?:2[1-6]|1[1-35]|0[1-7]|[34][1-5])|4(?:[03][1-4]|[12][1-3])|7(?:1[1-5]|0[0-4]|2[1-4])|3(?:1[1-7]|7[45]|0[1-3])))',
    '683' => '(?:0(?:0(?:0\d|5[1-5]|[1-46][1-7])|3(?:2[1-3]|5[1-6]|1[12]|4[1-5]|[36][1-7]|0[0-2])|8(?:[1-4][1-6]|[05][1-5])|2(?:[25][1-7]|0[1-4]|1[1-8])|10[1-5]))',
    '684' => '(?:0(?:0(?:3[1-4]|[4-7][1-6]|0[0-6]|[12][1-7])|4(?:0[0-4]|1[1-3])|10[0-7]|30[0-3]|211))',
    '685' => '(?:0(?:0(?:[12][1-7]|0[0-7])|3(?:0[1-6]|1[1-4])|4(?:1[1-3]|3[1-5])|10[1-6]))',
    '689' => '(?:(?:0(?:7(?:2[1-9]|[03][1-7]|1[1-5])|5(?:01|[12][1-9]|3[1-7])|2(?:2[1-6]|[01][1-7])|3(?:5[1-7]|4[1-5]|3[1-4])|4(?:0[1-5]|1[1-3]|2[1-6])|1(?:1[1-7]|0[1-6])|60[1-7])|3(?:5(?:00|[34][1-7]|1[1-5]|2[1-4]|5[1-3])|3(?:2[1-7]|[01][1-9]|3[1-6])|1(?:0[1-6]|3[2-6]|[12][1-5])|2(?:1[1-4]|2[1-6]|0[0-5])|4(?:0[1-3]|1[1-8]|2[1-5]))|1(?:4(?:[13][1-7]|[45][1-5]|0[0-4]|6[1-8]|2[1-6])|1(?:[01][1-7]|2[1-6])|3(?:[12][1-6]|0[1-7])|2(?:01|2[1-9]|1[1-5]))|4(?:2(?:[24][1-6]|[013][1-7])|1(?:1[1-5]|0[0-8]|3[1-6]|2[1-3])|4(?:3[1-5]|0[0-3]|1[1-4]|2[1-6])|5(?:[12][1-7]|0[0-5]))|2(?:3(?:0[0-6]|[1-5][1-6])|5(?:4[1-4]|[01][1-3]|[23][1-5])|2(?:1[1-6]|2[134]|0[0-8])|1(?:1[1-5]|0[1-6]))|5(?:2(?:00|[12][1-6])|5(?:3[1-4]|4[1-5]|5[12])|6(?:6[1-6]|7[1-3])|13[1-7])))',
    '690' => '(?:(?:0(?:8(?:[12][1-6]|5[124-69]|0[1-4]|6\d|[478][1-8]|3[1-5])|0(?:1[1-57]|[35][1-8]|4[1-9]|2[1-7]|0[0-7]|6[1-5])|1(?:51|3[1-3]|[24][12])|3(?:2[1-4]|3[1-3])|4(?:11|0[12])|26[1-6])|2(?:5(?:1[1-3]|2[1-5])|6(?:25|3[1-4])|40[0-6]|70[1-6]|10[1-5]|31[1-4]|80[12])|1(?:1(?:0[1-4]|1[1-5])|2(?:[12][1-3])|40[1-8]|31[1-5]|50[1-5])|3(?:20[03-7]|51[1-6]|40[1-5]|31[1-4])))',
    '691' => '(?:00(?:[124][1-5]|[03][1-4]|5[1-3]|[67][1-6]))',
    '692' => '(?:0(?:0(?:[1346][1-7]|0[0-7]|[25][1-8]|7[1-57])|2(?:1[1-8]|0[1-7])|4(?:1[1-3]|0[1-5])|32[1-6]|62[1-5]|73[1-3]))',
    '693' => '(?:0(?:0(?:[56][1-8]|7[1-4]|4[1-6]|1[1-57]|3[1-7]|2[1-9]|8[12]|0[0-8])|5(?:[02][1-6]|1[12])|10[1-6]|21[1-6]))',
    '694' => '(?:0(?:0(?:[4-6][1-4]|1[1-3]|[23][1-5]|0[0-4])|30[1-5]|22[1-4]|43[1-3]))',
    '695' => '(?:0(?:0(?:0[0-7]|1[1-7]|2[1-4])|1(?:0[1-3]|5[1-6])))',
    '696' => '(?:(?:0(?:0(?:0[0-7]|1[1-3])|7(?:1[1-3]|0[1-6])|1(?:31|0[0-4])|31[1-7]|40[1-7]|50[1-6]|22[1-5]|60[1-3])|1(?:1(?:4[1-5]|3[1-7])|22[1-6])))',
    '697' => '(?:(?:0(?:0(?:6[1-5]|0[0-7]|[1-5][1-7])|3(?:0[1-5]|1[12])|4(?:31|2[1-7])|51[1-4]|12[1-3]|21[1-3]|631)|1(?:3(?:2[1-7]|3[1-8])|2(?:1[1-5]|0[1-4])|12[1-3])))',
    '698' => '(?:(?:0(?:0(?:51|4[1-4]|0[0-7]|[1-3][1-7])|2(?:1[1-4]|0[1-7])|41[1-4])|2(?:14[1-6]|25[1-5])|12(?:01|[12][1-3])))',
    '699' => '(?:(?:1(?:2(?:4[1-5]|[236][1-4]|5[1-3]|[01][1-6])|3(?:1[12]|[23][1-4]|4[1-3])|1(?:0[1-6]|[12][1-5])|8(?:[0-3][12])|5(?:00|1[1-7])|4(?:01|3[1-4])|70[1-3]|62[12]|94[12])|0(?:7(?:[145]1|[02][12]|3[1-3]|6[1-4])|6(?:31|1[1-5]|[24][1-4])|1(?:0[1-9]|1[0-2])|8(?:1[1-7]|2[1-5])|5(?:[05][1-5])|40[1-8]|90[1-6]|20[1-5])|5(?:6(?:[13][1-7]|0[0-7]|2[12])|5(?:0[0-7]|1[1-7]|2[1-5])|2(?:21|[01][1-7])|1(?:2[1-7]|3[1-4])|30[1-7])|4(?:6(?:3[1-3]|0[05]|2[1-7])|7(?:1[1-5]|0[1-467])|22[1-6]|50[1-5]|43[12]|[13]11)|3(?:2(?:1[1-7]|2[1-6])|50[1-6]|67[1-6]|76[1-6]|30[1-3]|16[12])|2(?:5(?:1[1-6]|0[1-7])|8(?:4[12]|3[1-7])|21[1-6]|30[1-5])))',
    '700' => '(?:0(?:9(?:[13568][1-6]|[027][1-7]|4[1-5])|0(?:0[0-5]|3[1-5]|[14][1-7]|[57][1-6]|8\d|[26][1-8])|8(?:[246][1-7]|5[1-6]|[013][1-8])))',
    '701' => '(?:(?:2(?:2(?:0[1-5]|[12][1-6])|6(?:2[1-5]|[01][1-6])|5(?:[12][1-5]|0[1-4])|4(?:3[1-7]|4[1-6])|1(?:4[1-4]|5[1-5]))|1(?:3(?:[35][1-7]|4[1-6])|2(?:2[1-6]|1[1-4]|0[1-5])|1(?:[35][1-4]|4[1-5])|6(?:0[1-5]|1[1-3])|52[1-7]|46[1-5])|0(?:1(?:5[1-3]|3[1-6]|[0146][1-5])|2(?:21|0[1-6]|1[1-5])|30[0-4])|4(?:2(?:00|4[13-8]|[17][1-6]|[235][1-4]|6[1-5])|30[1-4]|50[12])|320[1-4]))',
    '702' => '(?:80(?:2[1-7]|[3-5][1-8]|[01][1-6]))',
    '703' => '(?:82(?:[16][1-7]|[02-57-9][1-8]))',
    '704' => '(?:81(?:8[1-4]|3[1-8]|[679][1-6]|5[1-5]|4[1-9]|[0-2][1-7]))',
    '705' => '(?:0(?:0(?:[1-3][1-6]|0[0-3])|13[1-3]))',
    '706' => '(?:0(?:0(?:0[0-2]|1[1-4]|2[1-8])|1(?:[3-5][1-4])|3(?:1[1-7]|0[1-6])|22[1-6]))',
    '707' => '(?:0(?:0(?:[14][1-6]|[356][1-7]|2[1-5]|0[0-5])|4(?:[0-3][1-7])|1(?:[23][1-4]|1[1-3])|50[0-6]|20[1-6]))',
    '708' => '(?:(?:0(?:8(?:[6-8][1-6]|[124][1-5]|[035][1-7])|0(?:0[0-7]|[3467][1-7]|2[1-4]|1[1-6]|5[1-3])|3(?:5[1-3]|6[1-6]|0[0-5]|[2-4][1-5]|1[1-7])|4(?:3[1-5]|2[1-7])|5(?:0[1-4]|1[12])|70[1-5]|601)|1(?:5(?:[13][1-6]|[024][1-7])|3(?:2[1-6]|1[1-5]|0[0-7])|1(?:2[1-6]|1[1-7]|0[1-5])|2(?:[0-2][1-6]))))',
    '709' => '(?:(?:0(?:8(?:[12][1-7]|0[0-7]|6[1-5]|3[1-8]|[457][1-6])|4(?:[16][1-4]|[2-5][12]|0[0-4])|6(?:[23][1-6]|1[1-5]|0[1-7])|7(?:21|1[1-9]|[03][1-6])|5(?:[0-2][1-6])|2(?:2[1-6]|1[1-4])|30[1-4])|3(?:6(?:0[0-6]|[12][1-7]|3[1-6])|1(?:[1-3][1-4]|[04][1-5])|9(?:51|[13][1-5]|2[1-4]|0[1-8])|7(?:0[0-7]|1[1-7]|2[1-6])|4(?:[01][1-7]))|4(?:2(?:[13][1-6]|[245][1-7]|0[1-5])|3(?:1[1-6]|2[1-4]|0[0-7]|3[1-5])|6(?:[0-2][1-6]|3[1-5]))|2(?:1(?:[013][1-7]|2[1-6])|4(?:2[12]|1[1-3]|0[1-4])|6(?:7[1-6]|6[1-4])|3(?:3[1-4]|4[1-5])|55[1-4])|12(?:1[1-6]|0[1-4])))',
    '710' => '(?:(?:0(?:0(?:6[1-5]|0[0-7]|[25][1-7]|[34][1-8]|1[1-6])|8(?:[0134][1-7]|2[1-6])|1(?:51|4[1-6]|3[1-3])|2(?:[56][1-3]))|1(?:3(?:1[1-5]|0[1-6])|20[1-3]|10[12])))',
    '711' => '(?:09(?:[0-3][1-7]))',
    '712' => '(?:80(?:7[1-4]|[46][1-6]|[35][1-9]|[02][1-7]|1[1-5]))',
    '713' => '(?:81(?:2[1-7]|0[1-3]|1[1-6]))',
    '714' => '(?:(?:0(?:0(?:2[1-5]|5[1-7]|0[0-7]|1[1-4]|[347-9][1-8]|6[1-6])|30[12]|101)|1(?:2(?:0[0-6]|1[1-5]|2[1-7])|4(?:0[1-7]|1[1-5]))|2(?:1(?:[01][1-4]|2[1-5])|23[1-4]|341)))',
    '715' => '(?:00(?:2[1-6]|1[1-9]|0[0-6]))',
    '716' => '(?:(?:0(?:0(?:[1-3][1-9]|4[1-7]|5[1-4]|6[1-8]|0\d)|3(?:11|0[1-4]|2[1-3]|3[1-5])|2(?:0[1-7]|1[12]|2[1-3])|1(?:[02][12]|1[1-3]))|1(?:4(?:11|[03][1-3]|2[12])|1(?:31|[12][12]|0[0-2])|3(?:11|2[12])|55[1-4]|24[12])))',
    '717' => '(?:0(?:0(?:[0-2][1-7])|4(?:[0-2][1-6])|7(?:3[1-7]|4[1-6])|5(?:0[1-7]|1[1-5])|6(?:0[1-4]|1[1-3])|10[1-5]|201))',
    '718' => '(?:0(?:0(?:0[0-7]|1[1-7])|3(?:0[1-7]|1[1-3])|10[1-4]|211))',
    '719' => '(?:(?:3(?:1(?:[2-4][1-6]|[15][1-7]|0[0-7])|2(?:0[1-6]|1[1-4]|2[1-8])|50[1-7]|81[1-4]|61[12]|70[12])|1(?:1(?:[2-57][1-6]|1[1-7]|6[1-5]|0[0-6])|3(?:2[1-4]|1[1-6]))|2(?:7(?:2[1-3]|3[12])|23[1-4]|12[1-3]|34[1-3]|64[1-3]|40[12]|55[12]|80[12])|0(?:2(?:00|21|[3-5][1-4])|1(?:1[1-3]|0[1-6])|30[0-4])))',
    '720' => '(?:(?:0(?:0(?:[67][1-7]|2[1-5]|1[13-7]|[03][1-4]|[45][1-6]|[89][1-3])|8(?:[03][1-9]|[24][1-5]|1[1-8])|4(?:11|0[1-3])|5(?:51|4[1-3])|20[1-4]|31[1-3])|1(?:1(?:3[1-5]|4[1-7])|6(?:[02][1-4])|8(?:00|1[12])|41[0-6]|26[1-5]|52[1-5]|70[1-5]|90[12])|2(?:1(?:[12][1-7]|0[1-8])|41[02-9]|52[1-5]|60[12])))',
    '721' => '(?:0(?:9(?:31|2[1-79]|[47][1-5]|1[1-7]|6[1-6]|0[1-46-8]|5[1-8])|000))',
    '722' => '(?:(?:0(?:0(?:0[0-8]|6[12]|5[1-5]|4[1-7]|7[1-3]|2[1-6]|[13][1-8])|3(?:[1-3][1-6]|[45][1-5])|2(?:21|0[12]|[13][1-5])|4(?:11|3[12]|0[1-3]))|1(?:5(?:01|6[1-5]|1[1-6])|1(?:00|2[1-3]|1[1-7])|4(?:01|1[1-7])|7(?:[03][12])|62[1-7]|20[1-4]|30[1-4])|2(?:4(?:1[1-7]|0[1-5]|3[12])|6(?:41|3[1-3])|32[1-4]|21[1-3]|10[12])))',
    '723' => '(?:0(?:0(?:0[0-7]|[14][1-7]|3[1-5]|2[12]|5[1-4]|6[1-6])|1(?:3[1-4]|4[1-8])))',
    '725' => '(?:0(?:0(?:0[0-5]|2[1-6]|1[1-3])|2(?:00|31)|30[1-3]|40[1-3]))',
    '726' => '(?:00(?:3[1-6]|1[1-3]|0[0-6]|2[1-7]))',
    '727' => '(?:0(?:0(?:1[1-7]|0[0-8]|2[1-6])|4(?:2[1-5]|[01][1-3])|3(?:21|[01][12])|11[1-4]|62[1-4]|20[1-3]))',
    '728' => '(?:0(?:0(?:[12][1-7]|0[0-7])|1(?:01|[12][1-5]|3[1-3])|2(?:11|0[1-3])|40[1-7]|62[1-5]|50[1-4]))',
    '729' => '(?:(?:3(?:4(?:31|[01][1-5]|2[1-4])|7(?:2[12]|[01][1-3])|2(?:[0-2][12])|1(?:1[12]|0[1-7])|30[1-7]|51[1-6]|60[12])|5(?:1(?:[13][12]|2[1-8])|7(?:4[1-5]|[23][1-3])|6(?:[01][1-3])|45[1-6]|50[1-6]|24[1-4]|81[1-3])|6(?:2(?:1[1-6]|0[1-5])|1(?:[34][1-4])|7(?:1[1-6]|0[12])|61[1-6]|33[1-5])|0(?:1(?:0[1-6]|4[12]|1[1-5])|4(?:7[1-5]|1[1-9])|32[1-49]|25[12])|4(?:2(?:11|2[1-7]|0[1-8])|1(?:0[1-6]|1[1-3])|30[1-8])|1(?:3(?:[23][1-3])|40[1-6]|21[1-3])|2(?:3(?:61|1[1-7])|25[1-3])))',
    '730' => '(?:0(?:0(?:[24][1-9]|[13][1-7]|5[1-5]|0[0-5])|8(?:[025][1-6]|1[1-4]|[34][1-7])))',
    '731' => '(?:(?:0(?:1(?:0[0-3]|2[1-6]|1[1-3]|3[5-9]|[45][1-4])|5(?:[23][1-5]|0[0-2]|1[1-3]|4[1-4])|2(?:3[1-6]|1[1-7]|0[12]|2[1-5])|30[1-6]|70[1-3]|61[12])|3(?:8(?:01|4[2-5]|3[1-5]|1[023]|2[14])|1(?:7[1-5]|6[13-9])|5(?:61|5[12]|0[0-3])|3(?:6[1-3]|5[1-5])|6(?:64|2[12])|27[12]|41[12]|70[12])|1(?:5(?:[12][1-6]|0[0-6]|3[1-5])|7(?:1[1-4]|0[1-6])|1(?:71|4[12])|22[1-3])|2(?:3(?:1[1-7]|2[1-4])|4(?:4[12]|3[1-7])|10[1-7]|20[1-6]|55[12])|51(?:0\d|[23][1-8]|6[12]|[145][1-7])|4(?:2(?:00|31|2[1-9]|1[1-5])|3(?:31|2[1-5]|0[01]|1[1-4]))))',
    '732' => '(?:0(?:0(?:3[1-6]|0\d|[16][1-8]|[24][1-9]|5[1-7])|8(?:2[1-8]|1[14-9]|0[1-7])))',
    '733' => '(?:0(?:8(?:[35][1-4]|2[1-3]|1[1-6]|[046][1-5]|7[1-7])|0(?:3[1-7]|0[0-7]|2[1-5]|1[1-3])))',
    '734' => '(?:0(?:0(?:0[0-7]|[1-5][1-7]|6[1-4])|30[1-4]|10[1-3]))',
    '735' => '(?:00(?:2[1-9]|1[1-7]|0\d))',
    '736' => '(?:00(?:71|[245][1-6]|1[1-4]|6[1-8]|0[0-5]|3[1-5]|8[1-9]))',
    '737' => '(?:(?:0(?:8(?:8[1-5]|6[1-7]|0[1-9]|[1-37][1-8]|5[1-4]|4[1-6])|0(?:0[0-5]|[27][1-9]|[136][1-5]|[45][1-6])|1(?:[12][1-5]|[05][1-7]|6[1-3]|4[1-6]|3[1-8])|9(?:3[1-6]|2[1-4]|0[1-8]|1[1-5])|3(?:11|0[1-3])|40[1-3])|2(?:6(?:1[4-7]|3[1-7]|0[1-9])|1(?:[13][1-3]|2[1-6]|0[01])|5(?:[01][1-9])|3(?:1[1-6]|0[1-3])|21[1-5])|1(?:2(?:[01][1-7])|377)))',
    '738' => '(?:0(?:0(?:60|[12][1-7]|0[0-7]|3[1-9]|5[1-6]|4[1-3])|2(?:0[1-5]|8[12]|2[1-6])|51[1-4]|60[1-3]|72[12]|301))',
    '739' => '(?:(?:0(?:4(?:88|[24][1-6]|0[1-8]|3[2-47]|5[24-9]|1[1-4]|6[1-467]|7[1-9])|6(?:[14][1-6]|2[1-8]|6[13-57]|0[0-7]|[35][1-7])|0(?:[12][1-6]|[34][1-8]|0[0-8])|5(?:88|0[1-7]|2[1-5]|1[1-8]|5\d|3[1-6]|4[1-3])|1(?:[35][1-3]|4[124-7])|3(?:0[1-3]|2[1-4]|1[1-5])|26[1-9])|2(?:1(?:0[1-6]|2[1-5]|1[1-7])|6(?:31|[12][1-9])|3(?:0[1-4]|1[1-8])|2(?:11|0[1-9])|40[1-5]|50[1-4]|73[12])|1(?:7(?:00|4[1-3]|[35][1-4])|10[1-8]|80[1-7]|20[1-5]|41[1-4]|30[1-3]|521)))',
    '740' => '(?:(?:0(?:0(?:51|0[0-4]|4[1-5]|3[1-7]|1[1-9]|6[1-3]|2[1-8])|3(?:[12][1-7]|0[1-6])|50[1-5]|60[1-5]|72[1-5]|90[1-4]|81[12])|1(?:4(?:41|88|2[4-68]|1[1-3]|5[1245]|3[12]|0[1-7])|2(?:1[1-9]|2[1-5]|[034][12]))))',
    '741' => '(?:00(?:9[1-4]|6[1-3]|[78][1-5]))',
    '742' => '(?:(?:0(?:3(?:01|1[1-5]|2[1-6]|4[1-4]|3[1-8])|0(?:41|1[0-2]|3[1-6]|2[1-4]|0\d)|4(?:[12][1-7])|(?:11|20)1)|2(?:10[0-8]|51[1-8]|80[1-7]|71[1-6]|92[1-4]|30[12]|60[12])|1(?:1(?:1[1-4]|0[0-7])|5(?:1[1-7]|0[0-4])|40[0-4]|35[1-3])))',
    '743' => '(?:0(?:0(?:31|[12][1-3]|0\d|4[1-8]|[67][1-5]|5[12])|10[1-5]))',
    '744' => '(?:0(?:0(?:6[1-35]|[3-5][1-3]|[12][1-57-9]|7[1-5]|0[0-8])|27[1-6]))',
    '745' => '(?:(?:0(?:8(?:[057][1-8]|[1-48][1-7]|6[1-9])|0(?:[67][1-6]|[1-5][1-7]|0[0-7])|6(?:3[12]|5[1-4]|1[1-8]|[246][1-3])|5(?:01|1[12])|12[1-5]|30[1-4]|24[12]|40[12])|113[12]))',
    '746' => '(?:0(?:0(?:[0-2][1-9]|[46][1-5]|5[1-6]|3[1-8]|8[1-4])|10[1-5]))',
    '747' => '(?:(?:0(?:0(?:[346][1-7]|2[1-9]|0[0-6]|5[1-6]|1[1-4])|8(?:[014][1-9]|2[1-5]|3[1-6])|6(?:21|1[12])|10[1-7]|23[1-5]|34[1-4]|52[1-4]|40[12])|1(?:2(?:21|3[12])|111)))',
    '749' => '(?:010[1-3])',
    '750' => '(?:(?:0(?:0(?:[1245][1-9]|[68][1-7]|9[1-5]|3[1-6]|7[1-8]|0\d)|4(?:[025][1-5]|3[1-3]|[14][1-6])|3(?:[01][1-7]|2[1-5])|60[1-6]|25[1-3])|11(?:71|[26][1-4]|[15][1-6]|[34][1-7]|0[12])))',
    '751' => '(?:08(?:8[1-8]|2\d|[013-7][1-9]))',
    '752' => '(?:09(?:1[1-6]|[78]\d|[2469][1-8]|5[1-9]|[03][1-7]))',
    '753' => '(?:0(?:0(?:[29][1-5]|8[1-9]|7\d|0[01]|[3-6][1-8]|1[125-8])|8(?:[03-69]1|2[1-6]|1[1-8]|7[12])|2(?:31|2[12]|1[1-5])|30[1-3]|101))',
    '754' => '(?:(?:0(?:0(?:2\d|0[1-8]|3[1-3]|1[1-5])|89[1-7]|21[1-4]|51[1-4]|12[1-3]|60[1-3]|30[12]|411)|1(?:31[1-5]|10[12]|277)))',
    '755' => '(?:0(?:0(?:8[1-6]|[5-7][1-8]|0\d|[1-4][1-9]|9[1-7])|8(?:10|0[1-9])|15[1-5]|241))',
    '756' => '(?:0(?:8(?:[47][1-8]|6[1-6]|2[1-5]|[135][1-7]|[08][1-9])|0(?:[24][1-9]|8[06-8]|[57][1-7]|9[1-5]|6[037]|0[013-57-9]|[13]\d)))',
    '757' => '(?:0(?:0(?:0[1-6]|1[1-3])|21[1-7]|40[12]))',
    '758' => '(?:0(?:0(?:11|6[1-3]|0[0-4]|7[1-467]|[2-5][1-7])|(?:[57]0|14)1|30[1-5]|21[1-3]|61[1-3]))',
    '759' => '(?:(?:6(?:5(?:3[1-4]|4[12]|2[1-5])|3(?:1[1-7]|0[1-3])|6(?:[01][1-4])|12[12])|3(?:6(?:00|11|2[12])|(?:41|72)1|20[1-4]|11[1-3]|30[1-3]|80[1-3]|50[12])|4(?:10[0-7]|40[1-5]|50[1-5]|62[1-3]|71[1-3]|211)|2(?:2(?:00|2[1-3]|1[1-4])|1(?:31|[45][12])|30[12])|0(?:2(?:0[1-9]|1[1-3])|1(?:2[1-4]|3[1-6]))|1(?:34[1-3]|51[1-3]|23[12]|42[12]|60[12])|5(?:(?:10|24)1|51[1-3]|33[12])))',
    '760' => '(?:00(?:80|[356][0-8]|[17][1-9]|9[1-3]|[024]\d))',
    '761' => '(?:(?:0(?:1(?:30|0[1-4]|[12][1-3])|3(?:[0-2][1-3])|4(?:50|4[1-6]|3[1-4])|70[0-5]|61[1-5]|90[1-5]|82[1-3])|4(?:1(?:2[12]|[15][1-5]|0[0-6]|3[1-4]|4[1-6])|4(?:3[1-4]|2[1-6]|1[12]|0[1-5])|30[0-8]|66[1-4])|80(?:4[1-7]|7[1-9]|[018][1-5]|2[1-6]|3[1-3]|5[1-8]|6[1-4])|2(?:20[1-8]|40[1-8]|30[04-8]|10[1-3])|1(?:70[1-8]|40[1-6]|61[1-6]|50[1-4])|3110))',
    '762' => '(?:00(?:7[1-3]|[135][1-8]|[2468][1-7]|0[0-7]))',
    '763' => '(?:0(?:0(?:[68][1-6]|4[1-8]|3[0-4]|[1579][1-5]|0[0-7]|2[1-9])|1(?:11|0[1-8])|2(?:31|2[1-8])))',
    '764' => '(?:00(?:[45]0|0[0-6]|[1-3][1-8]))',
    '765' => '(?:00(?:40|[357][1-3]|1[1-4]|0[0-4]|[26][12]))',
    '766' => '(?:0(?:0(?:[12][1-7]|0[0-7])|20[1-4]))',
    '767' => '(?:00(?:3[1-3]|1[1-4]|0[0-4]|2[12]))',
    '768' => '(?:0(?:0(?:40|0[0-2]|7[0-6]|5[12]|3[1-3]|6\d|[12][1-4])|10[1-5]))',
    '769' => '(?:(?:2(?:3(?:2[1-3]|0[0-6]|1[1-5])|5(?:2[01]|1[1-9])|7(?:0[0-5]|1[1-5])|90[1-8]|60[1-6]|10[1-5]|40[12])|1(?:6(?:2[1-5]|1[1-7]|0[1-4])|4(?:10|0[1-8])|10[1-9]|50[1-8])|0(?:2(?:1[0-3]|2[1-8]|0\d)|3(?:0[1-3]|1[1-9])|10[1-5]|40[12])))',
    '770' => '(?:(?:0(?:8(?:4[1-7]|3[1-5]|[15][1-6]|[27][1-4]|[06][1-8])|0(?:0[0-6]|1[12]|3[1-9]|[24][1-8]|6[1-4]|5[1-3])|9(?:4[1-4]|1[1-8]|[023][1-9]))|80(?:3[1-3]|5[1-6]|7\d|4[01]|0[1-8]|6[134]|8[1-4]|1[12]|2[1-5])))',
    '771' => '(?:(?:1(?:2(?:40|[13][0-2]|[057][0-3]|2[0-4]|6[0-24-7])|3(?:[235]0|0[0-2]|4[1-7]|1[01])|6(?:2[1-7]|1[0-6]|0[1-4])|7(?:14|0[0-6])|50[1-9]|15[1-6]|40[1-3])|0(?:1(?:1[1-7]|2[1-9]|4[1-4]|3\d|0[1-6])|2(?:20|1[1-9]|0[0-7])|3(?:7[1-8]|6\d))|5(?:5(?:3[12]|[01][1-8])|4(?:1[0-3]|0[1-9])|17\d|20\d|32\d)|6(?:1(?:0[1-7]|1[1-8])|32[1-8]|40[1-5]|51[12])|4(?:30[0-8]|26[1-7]|50[0-5]|10[0-2])|2(?:10[1-7]|30[1-6]|50[1-3])|3(?:20[0-3]|31[01]|42[12])))',
    '772' => '(?:00(?:60|0[0-4]|1[1-7]|3[1-5]|2[12]|5[1-3]|4[1-4]))',
    '773' => '(?:00(?:31|70|[01]\d|2[0-5]))',
    '774' => '(?:(?:00(?:30|0\d|2[1-3]|4[1-9]|1[1-7])|1760))',
    '775' => '(?:0(?:5(?:1[0-3]|0[1-9])|0(?:0[0-7]|1[0-3])|3(?:10|0[1-9])|20[02-6]|41[1-5]|101))',
    '776' => '(?:00(?:20|1[0-5]|0[0-7]|3[1-7]))',
    '777' => '(?:0(?:00[1-7]|30[1-3]))',
    '778' => '(?:(?:0(?:0(?:[24]0|0\d|1[0-4]|3[12])|1(?:65|0[1-5])|20[1-6])|525[1-4]))',
    '779' => '(?:(?:3(?:2(?:[23][1-6]|[14][1-5]|0[0-8])|1(?:2[0-8]|1[1-9]|3[1-3]|0[1-6])|6(?:10|0[0-4]|2[05]|3[1-9])|30[1-7]|40[1-7]|50[1-5]|74[1-5])|1(?:1(?:2[1-3]|[01][1-9])|2(?:[34][1-6])|(?:51|7[45])0|6(?:20|3[01])|40[1-4])|5(?:3(?:2[1-8]|1[1-6]|[034][1-7])|1(?:7[1-3]|6[1-6])|4(?:22|5[1-3]))|0(?:1(?:0[0-8]|1[1-9])|2(?:3[0-8]|2[1-5])|3(?:[01][1-5]))|4(?:70[0-7]|30[1-7]|40[1-7]|80[1-7]|10\d)|2(?:10[1-9]|30[0-7])))',
    '780' => '(?:(?:0(?:9(?:[24][1-9]|[5-7][1-7]|8[1-5]|3[1-8]|0[1-4]|[19][1-6])|0(?:[48][1-8]|[37][1-4]|[56][1-6]|2[1-7]|0[0-4])|8(?:[57]0|2[1-5]|[346][1-4]|1[1-8]|0[1-6]))|80(?:[49]0|6[1-6]|1\d|[02][1-8]|5[0-2]|[38][1-9]|7[1-7])))',
    '781' => '(?:(?:1(?:1(?:[26][1-5]|0[0-5]|[15][1-4]|4[1-3]|3[1-6])|3(?:0[0-8]|1[1-5]|[23][1-8])|5(?:0[0-6]|3[1-5]|2[0-4]|1[1-8])|7(?:5[1-8]|[46][1-6])|6(?:0[1-9]|2[0-8]|1\d)|91[1-5]|80[1-4])|3(?:7(?:0[0-5]|1[1-7]|4[12]|2[1-5])|1(?:[12][1-5]|0[1-8])|6(?:0\d|1[0-57-9]|2[0-4])|2(?:1[1-4]|[02][1-3])|33[1-7]|52[1-6]|40\d)|5(?:2(?:1[1-3]|2[1-4]|4[12]|3[1-5]|0[0-6])|6(?:2[12]|[01][1-6])|4(?:5[1-5]|6[1-9])|3(?:10|3[12])|70[0-8]|10[1-8])|2(?:1(?:[34][1-6]|1\d|2[0-46-8]|0[0-8]|5[1-5]|6[1-7])|6(?:0[1-5]|1[1-6])|3(?:[23][1-5])|40[12]|51[12])|4(?:2(?:0[1-8]|3[1-6]|[124][1-7])|4(?:0[1-6]|1[1-5])|5(?:2[1-9]|3[01])|64[1-5])|0(?:2(?:5[0-3]|4[0-5]|6[12]|7[01])|3(?:0[1-4]|1[1-6]|2[1-5])|01[0-5]|11[1-4])|6(?:4(?:[16]0|0[0-3]|2[1-7]|4[1-9]|[35]\d)|20[0-2]|83[1-3]|74[12])|81(?:0[1-5]|3[0-6]|2[1-6]|1[1-4])|7(?:30[0-4]|41[1-4]|10\d|220)))',
    '782' => '(?:00(?:5[14-9]|[37][1-9]|4[1-7]|2[1-5]|[01]\d|6[1-4]))',
    '783' => '(?:00(?:9[1-6]|[57][1-8]|4\d|1[1-4]|[06][0-8]|2[1-9]|[38][1-7]))',
    '784' => '(?:0(?:0(?:10|4[1-6]|2\d|5[1-8]|3[1-4]|0[0-8]|6[1-5])|27[1-8]))',
    '785' => '(?:0(?:6(?:[36][1-6]|[45][1-8]|0[0-8]|1[0-3]|2[1-7])|0(?:1[0-8]|5[1-9]|4[1-7]|3[0-7]|0\d|2[1-8])|1(?:6[1-7]|7[1-4])|2(?:[01]\d)|77[1-6]|50[1-5]|41[1-3]))',
    '786' => '(?:0(?:0(?:[235-9][1-8]|[01][0-8]|4[1-9])|5(?:[23][1-5]|1[1-7]|0[1-4])|3(?:0[1-8]|1[1-6]|2[1-7])))',
    '787' => '(?:(?:0(?:3(?:3[1-9]|[0-2][0-8])|0(?:[0-2]\d|3[0-8]|5[0-2])|8(?:1[1-6]|0[0-7])|5(?:5[6-9]|6[0-3])|4(?:4[5-7]|5[0-3])|1(?:6[0-3]|5\d)|77[1-6]|24[0-4]|66[5-9])|1(?:6(?:1[1-8]|0[1-7])|10[1-9]|32[1-6]|44[1-4]|22\d|55\d)))',
    '788' => '(?:0(?:3(?:[4-6][1-3]|[1-3][1-5]|0[02])|0(?:[03]\d|2[1-8]|5[1-4]|4[1-9]|1[0-5])|2(?:7[1-4]|6[1-8])|78[1-6]|67[7-9]))',
    '789' => '(?:(?:1(?:2(?:0[0-5]|[23][1-5]|1[1-8])|9(?:0[0-5]|2[1-5]|1[1-3]|3[1-6])|7(?:2[0-5]|0[1-8]|1[1-6])|4(?:0[1-9]|1\d)|30[0-4])|0(?:2(?:5[0-5]|3[1-7]|4[1-8])|3(?:1[1-6]|0[0-7]|2[1-5])|1(?:7[0-4]|5[6-9]|6\d)|58[1-7]|42[6-8])))',
    '790' => '(?:0(?:8(?:1[1-4]|[03-57][1-8]|[26][1-7])|0(?:6[1-7]|[25][1-6]|1[1-4]|[034][1-8])|9(?:6[1-7]|[02][1-5]|5[12]|4[1-8]|3[1-4]|1[1-6])))',
    '791' => '(?:(?:0(?:5(?:10|62|4[1-3]|[03][1-8]|2[1-7])|2(?:4[1-5]|0[0-5]|2[1-3]|1[1-6])|1(?:50|1[1-4]|2\d|[03][1-5])|3(?:1[1-5]|[02][1-3])|0(?:00|54))|3(?:1(?:[12]0|4[1-3]|[36][1-4]|0[0-2]|5[1-5])|3(?:10|4[1-3]|0[01]|6[0-4]|[235][12])|5(?:[12][1-4]|0[1-6])|20[1-6])|1(?:1(?:[0-3][1-6])|2(?:[12][1-3]|0[0-7])|5(?:[01][1-5])|7(?:10|0[1-9])|80[1-3])|80(?:3[124-6]|[028][1-7]|[17][1-9]|9[1-3]|6\d|5[1-8]|4[1-4])|2(?:1(?:[34][1-5]|1[1-7]|2[0-6]|0[0-3])|20[1-7])|4(?:5(?:1[01]|0[1-9])|32[1-4]|43[12])))',
    '792' => '(?:0(?:8(?:9[0-8]|[01][1-5]|[35][1-7]|2[1-9]|[468][1-8]|7[1-4])|0(?:[568]0|[14][1-7]|7[12]|3[1-5]|0\d|2[1-6])))',
    '793' => '(?:0(?:0(?:4[1-6]|2[1-8]|1[067]|7[1-5]|0[0-7]|[56][1-7]|3[04-9])|21[1-6]|10[1-3]))',
    '794' => '(?:(?:0(?:0(?:[1-3][1-8]|[47][1-4]|[56][1-9]|8[1-7]|0[0-7])|8(?:[45]0|6[1-3]|[01][1-5]|3[12]|2[1-7])|1(?:0[1-9]|1[1-7]|2[1-5]))|2(?:5(?:[235]0|1[0-3]|4[0-2]|0\d)|1(?:1\d|0[1-4])|30[1-5]|20[1-4]|410)|1(?:30[1-9]|40[1-4]|10[1-3])))',
    '795' => '(?:0(?:0(?:1[1-3]|4[1-6]|0\d|5[1-4]|7[0-8]|6[1-59]|3[12]|2[1-5]|8[1-9])|30[1-9]))',
    '796' => '(?:(?:0(?:0(?:5[1-6]|[478][1-8]|1[0-4]|0[0-5]|[26][1-9]|3[1-7])|8(?:0[1-5]|1[1-6]|2[1-3])|9(?:1[0-5]|0[1-9])|3(?:1[1-3]|0[0-8])|1(?:70|1[12])|50[1-6]|20[1-5]|61[1-5]|42[12])|80(?:60|3[05-9]|1[015]|4[01]|0[1-8]|5[0-4]|2[05])))',
    '797' => '(?:(?:1(?:7(?:0[1-5]|1[1-7])|32[1-8]|50[1-8]|60[1-8]|10[1-7]|21[1-7]|43[1-4])|0(?:0(?:4[1-6]|2\d|[01][0-8]|3[0-7])|11[1-3]|20[1-3])))',
    '798' => '(?:(?:1(?:3(?:0[0-3]|6[1-7]|[47][1-5]|5[1-6]|3[1-3]|[12][1-4])|1(?:4[1-3]|1[1-6]|[02][1-5]|3[1-9])|50[1-7])|0(?:0(?:[39]\d|[6-8][0-8]|4[0-5]|5[0-4]|[0-2][0-7])|10[1-4]|21[12])|4(?:1(?:10|[23][1-6]|0[0-5])|2(?:[01][1-9])|3(?:5[1-3]|4[1-9])|40[1-8])|3(?:3(?:[0-2][1-3]|4[1-6]|[35][1-8]|6[1-4])|70[1-8]|27[12])|21(?:46|0[0-6]|1[1-3])))',
    '799' => '(?:(?:3(?:4(?:70|2[12]|0[1-7]|[13][1-3]|5[1-6]|[46][1-4])|7(?:[1-3]0|[57][12]|0[1-7]|[46][1-3])|1(?:1[1-5]|0[0-5]|2[1-8]|3[1-6])|31[1-4]|20[127])|2(?:4(?:4[1-7]|[136]\d|[05][1-8]|2[1-6])|1(?:1[0-8]|0[1-9]|2[1-3])|6(?:6[12]|4[1-9]|5[1-6])|3(?:1[0-2]|0[1-9])|20[1-9])|1(?:3(?:1[1-7]|[24][1-5]|7[12]|3[1-6]|[056][1-4])|5(?:[023][1-7]|1[1-4])|1(?:0[1-8]|1[12])|60[1-7])|0(?:4(?:0[0-5]|[12][1-3]|3[1-6])|1(?:[01][1-3]|2[1-8])|7(?:0[1-5]|[12][1-4])|6(?:50|4[1-5])|30[1-4])))',
    '800' => '(?:0(?:0(?:[14][1-8]|3\d|6[1-4]|0[0-8]|2[1-9]|5[1-7])|3(?:0[0-6]|5[1-7]|[14][1-5]|3[1-8]|2[1-4]|6[1-6])|2(?:[12]\d|[45][1-8]|3[1-7]|0[1-9])|1(?:1[1-8]|0[12])))',
    '801' => '(?:08(?:0[1-58]|6[1-5]|4[12]|[2578][1-6]|[13][1-4]))',
    '802' => '(?:0(?:0(?:[13][1-8]|[256][1-6]|7[1-7]|9[12]|[48][1-5]|0[0-8])|8(?:3[1-8]|[12][1-6]|0[1-5]|4[12])|9(?:7[1-9]|8[1-6])))',
    '803' => '(?:0(?:8(?:[1-3][1-8]|[45][1-6]|[06][1-5])|2(?:6[1-8]|7[1-9])|18\d))',
    '804' => '(?:00(?:[4589][1-4]|3[1-3]|[12][1-5]|[67][1-7]|0[0-4]))',
    '805' => '(?:00(?:71|[05]\d|3[1-8]|2[1-7]|[146][1-9]))',
    '806' => '(?:00(?:3\d|[12][1-8]|0[0-6]|[4-6][1-9]))',
    '807' => '(?:(?:0(?:8(?:6[1-8]|1[1-5]|[27][1-9]|[03-5][1-7])|0(?:31|[47][1-8]|5[1-6]|0[0-7]|[28][1-5]|1[12])|1(?:0[0-2]|[1-4][1-3]))|1(?:1(?:[12][1-5]|[34][1-6]|0[1-3]|5[1-4])|3(?:0[0-8]|1[1-5])|26[1-5])))',
    '808' => '(?:0(?:0(?:[36][1-6]|5[1-5]|[1247][1-7]|0[0-8])|1(?:75|0[1-689]|3[1-9]|1[1-3]|2[1-4]|4[1-8])))',
    '809' => '(?:00(?:41|1[1-9]|0[0-4]|3\d|2[1-8]))',
    '810' => '(?:0(?:0(?:0[0-5]|2[1-9]|[36][1-7]|[45][1-5]|7[1-6]|1[1-8])|80[12]))',
    '811' => '(?:(?:5(?:1(?:4[1-4]|6[1-3]|3[1-6]|[25][1-5]|1[1-7]|0[0-7])|5(?:01|[45][1-6]|[1-3][1-3])|2(?:0[1-4]|2[1-6]|1[1-5])|7(?:[34][1-4]|5[1-7])|3(?:01|[12][1-6])|46[1-8])|3(?:1(?:1[1-8]|0[0-7]|[23][1-7])|4(?:40|2[1-5]|0[0-8]|3\d|1[1-6])|5(?:1[1-6]|2[12]|0[1-7])|2(?:[02]\d|1[1-9])|3(?:1[12]|0[1-9])|701)|4(?:1(?:13|8[1-5]|[57][1-7]|4[1-35-8]|6[1-6])|2(?:0[0-5]|4[12]|3[1-9]|2\d|1[1-8])|3(?:[14][1-3]|[23][1-4]|0[0-7]))|1(?:2(?:0[0-4]|2[1-4]|[13-5][1-6])|3(?:4[3-7]|0[23]|6[1245]|[12][1-4]|5[1-6])|1(?:0[1-3]|[1-3][1-4]))|2(?:1(?:2[1-8]|0\d|1[1-5]|3[12])|2(?:21|0\d|4[1-8]|3[1-3])|4(?:1[1-6]|0[0-5])|3(?:1[0-8]|0\d)|50[0-3])|0(?:1(?:1\d|2[0-2]|0[0-4])|2(?:[01][1-6])|32[1-5])))',
    '812' => '(?:0(?:0(?:4[1-6]|1[1-8]|2\d|0[0-8]|[36][1-9]|5[1-5])|8(?:8[1-8]|6[1-3]|9[1-7]|7[1-9]|5[1-578])))',
    '813' => '(?:00(?:62|2[13-5]|0[0-58]|3[1-6]|1[1-9]|4[1-5]))',
    '814' => '(?:0(?:1(?:0[0-6]|7[1-7]|[56][1-5]|[134][1-4]|2[1-3])|0(?:[13][1-5]|0[0-6]|2[1-3])))',
    '815' => '(?:00(?:63|0[014]|7[1-5]|3[1-8]|4[128]|8[1-4]))',
    '816' => '(?:0(?:8(?:2[1-6]|3[1-3]|[167][1-4]|4[1-9]|0[1-7]|5[1-5])|9(?:[26][1-4]|[478][1-3]|[05][1-6]|3[1-5]|1[12])|000))',
    '817' => '(?:(?:1(?:2(?:23|4[156]|5[1-7]|0[12]|1[2-4]|3[1-4])|7(?:[12][1-5]|0[1-4])|5(?:2[1-5]|[13][1-3])|10[1-7]|30[1-7]|41[1-3]|60[1-3])|0(?:0(?:3[1-5]|0[0-356]|2[1-4]|1[1-6])|24[1-8]|15[1-7]|32[1-6]|43[1-5]|51[1-4])|2(?:24[1-3]|33[1-3])))',
    '818' => '(?:0(?:0(?:0[0-7]|4[1-7]|5[1-9]|8[1-5]|[23][1-6]|6[13-8]|[17][1-4])|1(?:0[0-5]|1[01457-9]|2[1-5]|3[1-9])))',
    '819' => '(?:(?:1(?:1(?:5[1-6]|0[0-8]|[1-3][1-9]|4[1-7])|3(?:[12][1-5]|[03][1-6])|6(?:[03]1|1[1-6]|2[1-7]|4[12])|5(?:7[1-5]|6[1-4]|8[1-3]))|0(?:0(?:0[0-25-7]|[125][1-5]|3\d|4[1-6])|3(?:7[1-9]|8[1-8]|6[67])|16[1-9]|20[1-5])))',
    '820' => '(?:(?:0(?:0(?:0[0-5]|2[12]|[68][1-9]|3[1-3]|[47]\d|1[1-8]|5[1-4])|3(?:3[1-7]|1[1-4]|2[1-3]|0[1-6])|1(?:[01][1-6])|7(?:1[1-3]|0[1-9])|20[0-7]|50[1-6]|60\d)|11(?:0[0-6]|1[1-4])))',
    '821' => '(?:00(?:1[1-4]|0[24]))',
    '822' => '(?:(?:0(?:0(?:3[1-4]|[12][1-7]|0[0-8])|1(?:01|4[1-6]|[15][1-3]|[23][1-4]))|1(?:3(?:1[1-8]|2[1-6]|0[0-7])|2(?:0[0-2]|1[12])|40[0-6]|10[1-3])))',
    '823' => '(?:00(?:1[1-7]|0[0-5]))',
    '824' => '(?:0(?:0(?:[47][1-9]|0[0-8]|[1-356][1-8])|2(?:[01][1-7]|3[1-5]|2[1-6]|[45][1-4])|1(?:[12][1-5]|0[1-7])|8(?:0[0-2]|2[12]|1[1-8])|4(?:00|11|3[12])|5(?:00|1[12])|60[0-4]|72[1-3]))',
    '825' => '(?:00(?:0[0-5]|1[1-8]))',
    '826' => '(?:00(?:02|2[1-7]|4[1-5]|3[1-3]))',
    '827' => '(?:000[0-4])',
    '828' => '(?:00(?:1[1-3]|[3568][1-6]|2[1-8]|0[0-5]|4[1-9]|7[1-7]))',
    '829' => '(?:0(?:3(?:[013][1-5]|[24][1-3])|1(?:51|2[1-5]|1[1-7]|0[0-8])))',
    '830' => '(?:(?:0(?:0(?:[06][1-6]|1[1-8]|7\d|[2-5][1-9])|2(?:0[1-7]|[12][1-6])|4(?:1[1-7]|2[1-5]|0[0-6])|1(?:1[1-6]|0[1-5]))|1(?:1(?:[0-2][1-7])|2(?:1[1-4]|2[1-6]|0[0-6]))))',
    '831' => '(?:00(?:2[1-8]|0[0-8]|[34][1-5]|1[1-7]))',
    '832' => '(?:0(?:0(?:[37][1-7]|0[0-7]|[268][1-9]|1[1-8]|5\d|4[1-6])|8(?:2[1-8]|1[1-6]|0[1-7])))',
    '833' => '(?:00(?:5[1-6]|[1-4][1-7]|0[0-7]))',
    '834' => '(?:(?:0(?:0(?:[578][1-5]|[46][1-7]|0[0-6]|3[1-4]|[12][1-6])|1(?:1[1-5]|0[0-5]|2[1-3])|201)|1(?:2(?:1[1-7]|2[12]|0[1-5])|10[1-4]|40[12])))',
    '835' => '(?:0(?:0(?:0[0-7]|1[1-9]|2[1-5])|1(?:1[1-5]|3[1-6]|0[1-4])))',
    '836' => '(?:0(?:0(?:0[0-7]|[1-9][1-7])|8(?:[0-79][1-7]|8[1-6])))',
    '837' => '(?:09(?:0[1-7]|1[0-7]|2[1-8]))',
    '838' => '(?:(?:0(?:0(?:0[0-5]|[1356][1-9]|7[12]|4[1-8]|2\d)|1(?:1[1-6]|[23][1-8]|4[1-4]|0[0-8])|2(?:2[1-8]|0[1-7]|1[1-5])|8(?:2[1-5]|1[1-7]|0[1-4]))|1(?:5(?:21|1[1-5]|0[1-7])|3(?:[01][1-7])|70[0-2]|60[12])))',
    '839' => '(?:(?:0(?:8(?:[45][1-3]|6[1-5]|[1-3][1-7]|0[1-9])|2(?:[4-6][1-4]|[0-2][1-5])|000)|1(?:2(?:[01][1-6]|3[1-4]|2[1-8])|3(?:21|1[12]|3[1-3]|0[1-8]|4[1-4])|4(?:21|1[1-5]|0[0-8]))))',
    '840' => '(?:(?:0(?:0(?:5[1-6]|1[1-35-7]|0[1-8]|[2-4][1-7])|8(?:4[1-5]|[0-2][1-6]|5\d|[36][1-4])|5(?:2[12]|4[1-5]|3[1-7]|1[1-6]|0[1-4])|2(?:[01][1-5]))|2(?:2(?:0[1-5]|2[1-3]|1[1-4])|10[1-6])|110[1-6]))',
    '841' => '(?:0(?:0(?:0[0-5]|2[1-7]|[38][1-9]|[57][1-6]|[146][1-8])|20[0-5]))',
    '842' => '(?:0(?:0(?:0[0-7]|[13][1-5]|6[1-8]|5[1-6])|1(?:0[1-47]|2[1-3])|20[1-3]|30[1-3]))',
    '843' => '(?:0(?:0(?:[12][1-4]|0[0-3])|30[0-5]|23[1-4]|15[1-3]))',
    '844' => '(?:00(?:0\d|[12][1-8]))',
    '845' => '(?:00(?:1[1-4]|[23][1-5]|0[0-5]))',
    '846' => '(?:00(?:[34]1|2[1-5]|0[0-7]|1[1-4]))',
    '847' => '(?:(?:0(?:0(?:2[1-8]|3[1-4]|5[1-6]|[146][1-7]|[78][1-5]|0[0-5])|8(?:[034][1-4]|6[1-3]|7[1-6]|[258][1-5]|1[1-7])|1(?:[02][1-4]|3[1-6]|1[1-5])|3(?:[12][1-7]|0[1-6])|40[1-6])|1(?:4(?:0[0-5]|[23][1-5]|[14][1-6])|5(?:[0-2][1-7])|2(?:1[1-4]|0[1-3]|2[1-5])|10[1-8])))',
    '848' => '(?:0(?:0(?:2[1-8]|1[1-6]|3[1-5]|4[1-7]|0[0-7])|1(?:3[1-4]|4[1-6]|1[1-7]|[02][1-5])|40[1-8]))',
    '849' => '(?:(?:0(?:9(?:1[1-9]|0[1-6]|[23][1-8])|1(?:0[0-2]|[12][1-4])|3(?:[01][1-6])|50[0-6]|20[1-5]|40[1-3]|000)|1(?:4(?:0[1-4]|[12][1-6])|3(?:2[1-4]|1[1-5]|0[0-4])|1(?:0[0-6]|1[1-6])|6(?:1[1-6]|0[0-3])|2(?:21|0[1-8]))|4(?:1(?:[4-7][1-6])|2(?:[58][1-6]|[67][1-4]))|3(?:2(?:1[1-9]|2[1-4]|[03][1-3])|1(?:1[1-5]|0[1-4]|[23][1-3]))|5(?:1(?:31|0[1-5]|2[1-4]|1[1-3])|2(?:6[1-4]|5[1-7]))|2(?:3(?:0[1-5]|4[12])|20[1-4]|10[0-2])))',
    '850' => '(?:0(?:9(?:[256][1-4]|1[1-8]|9[1-6]|8[1-5]|[347][1-7]|0[1-9])|0(?:[14-6][1-8]|0[0-7]|3[1-7]|[27][1-9])|8(?:[37][1-7]|6[12]|5[1-5]|[14][1-3]|[02][1-4])))',
    '851' => '(?:(?:0(?:1(?:[12][1-6]|0[1-4]|3[1-7])|2(?:[45][1-5])|3(?:10|0[12])|40[1-8]|50[1-7])|2(?:1(?:11|30|2[1-9]|0[0-8])|4(?:1[13]|0[13-5]|2[1-7])|2(?:0[1-7]|1[1-6])|32[1-7])|3(?:3(?:0[1-6]|1[1-5])|4(?:06|2[1-5])|5(?:11|0\d)|21[1-5]|10[1-3])|1(?:1(?:3[1-7]|2[1-5])|201|315)))',
    '852' => '(?:8(?:0(?:6[1-5]|[124][1-7]|0[1-8]|[35][1-6])|1(?:[235][1-7]|4[1-6]|[01][1-8])))',
    '853' => '(?:(?:0(?:0(?:0[0-7]|2[1-7]|3[1-3]|6[1-6]|[45][1-4]|1[1-8])|2(?:0[1-8]|1[1-5])|6(?:0[1-9]|1[1-3])|50[1-8]|70[1-6]|31[1-3]|41[1-3])|2(?:3(?:[01][1-5])|17[1-4]|20[1-4]|48[12])|3(?:32[1-3]|10[12])))',
    '854' => '(?:(?:0(?:0(?:[24578][1-7]|0[0-7]|6[1-9]|3[1-8]|[19][1-6])|5(?:0[0-5]|1[1-7])|20[1-9]|40[1-7]|12[1-6]|70[1-3]|30[12]|621)|11(?:1[1-4]|[02][1-5])))',
    '855' => '(?:0(?:8(?:[168][1-7]|[07][1-9]|2[1-5]|[35][1-6]|4[1-3])|0(?:3[1-68]|[167][1-8]|[24][1-6]|5[1-9]|0[0-8])))',
    '856' => '(?:0(?:8(?:1[1-8]|2\d|[34][1-7]|0[1-9])|0(?:1[1-9]|3[1-5]|4[1-8]|[02]\d)))',
    '857' => '(?:(?:0(?:0(?:71|[56][1-9]|[1-3][1-8]|0[01]|4\d)|8(?:0[1-6]|[14][1-3]|[36][1-4]|7[1-9]|2[12]|5[1-5])|3(?:00|61|1[1-5]|[24][1-4]|3[1-8]|5[1-3])|1(?:[02-4][1-6]|1[1-5])|4(?:31|0[1-6]|1[1-4]))|4(?:4(?:1[1-6]|0[0-245])|7(?:0\d|1[12])|81[1-6]|21[1-4]|51[1-4]|60[1-4]|90[1-4]|10[1-3])|2(?:3(?:2[1-8]|1[12]|0[1-7])|4(?:0[1-35]|1[1-37-9]|2[1-7])|22[1-3]|53[12])|1(?:1(?:[67][1-6]|5[1-3])|23[1-5])|3(?:(?:27|31)1|10[1-3])))',
    '858' => '(?:09(?:31|65|[01][1-8]|2[1-6]))',
    '859' => '(?:(?:3(?:2(?:4[1-4]|[12][1-6]|0[1-5]|3[1-7])|7(?:0[0-6]|2[1-8]|1[1-6])|6(?:0[0-8]|1[1-9])|1(?:5[1-8]|6[1-6])|9(?:2[1-9]|3[1-3])|8(?:1[12]|0\d)|45[1-4])|5(?:1(?:4[1-5]|0[0-4]|1[1-8]|3[1-4]|[25][1-3])|5(?:1[1-6]|2[1-7]|[03][1-5])|3(?:8[1-4]|[67][1-6])|70[1-7]|80[1-6])|4(?:5(?:0[0-7]|2[1-9]|3[1-6]|1[1-8])|7(?:[57][1-8]|4[1-5]|6[1-9])|8(?:1[1-5]|[02][1-7])|30[1-9])|0(?:1(?:71|0[1-6]|3[1-3]|5[1-4]|[1246][1-7])|4(?:0[1-7]|1[1-8])|3(?:1[1-5]|0[1-7]))|6(?:1(?:[14][1-5]|3[1-4]|[02][1-6])|3(?:2[1-6]|1[1-7]|0[1-5])|4(?:1[1-5]|0[1-9])|20[1-7])|1(?:3(?:0[1-8]|2[1-5]|1[1-7])|1(?:1[1-6]|0[1-7])|2(?:[01][1-6])|4(?:1[1-5]|0[1-4])|50[1-5])|2(?:2(?:[01][1-6])|1(?:[12][1-3])|3(?:16|0[1-6])|60[0-6]|41[1-6]|50[1-4])))',
    '860' => '(?:0(?:0(?:[1-357][1-9]|[0468][1-8])|8(?:3[1-4]|[014][1-8]|6[1-3]|[25][1-6])))',
    '861' => '(?:(?:0(?:5(?:[36][1-5]|1[1-9]|2[1-7]|4[1-8]|0[01]|[57][1-6])|1(?:[03-5][1-6]|[12][1-7]|6[1-5])|8(?:1[1-5]|3[1-7]|0[0-5]|2[1-3])|3(?:31|1[1-6]|[02][1-4]|8[12])|4(?:1[1-4]|[02][1-6])|9(?:0[1-6]|[12][1-5])|60[1-5]|000)|4(?:1(?:7[1-3]|[1-6][1-7]|0[1-689])|7(?:1[1-6]|2[1-35-7]|0[0-7]|3[1-7])|2(?:[02][1-6]|1[1-5]|3[1-7])|4(?:[0-2][1-7])|6(?:1[1-8]|0\d|2[1-3]|3[1-5])|30[1-7])|3(?:5(?:2[1-6]|3[1-4]|1[1-8]|0[0-3]|4[1-7])|9(?:3[1-7]|[02][1-8]|1[1-6])|8(?:[34][1-5]|0[1-6]|1[1-3])|2(?:11|4[1-5]|0[0-8])|6(?:6[1-5]|7[1-3])|4(?:21|5[1-5])|78[1-9]|1(?:31|0\d)|32[1-3])|1(?:3(?:31|[24][1-6]|0\d|6[1-8]|[15][1-7])|1(?:1[1-6]|0[0-5])|2(?:1[1-4]|0[1-5])|6(?:8[1-6]|7[1-3])|44[12])|5(?:5(?:[13][1-7]|0[1-4]|2[1-6])|2(?:7[1-4]|8[0-24-9]|[56][1-5])|34[1-8]|40[1-6])|2(?:2(?:[24][1-4]|3[1-6]|1[12]|0[0-6])|1(?:18|0[1-8])|40[0-5])|80(?:7[1-5]|3[01457-9]|1[0-79]|8[1-4]|2[89]|0[1-35-7]|6[4-68]|4[1-6])|6(?:10[1-5]|30[1-5]|40[1-3]|551)|7(?:20[1-4]|31[1-4])))',
    '862' => '(?:09(?:33|1[0-8]|6[0-35-9]|[04][1-9]|2[0-6]|7[0-356]|5\d))',
    '863' => '(?:(?:0(?:0(?:50|3[1-8]|2[1-5]|[14][1-9]|0[0-7])|10[1-3])|1(?:2(?:1[1-6]|0[1-5])|4(?:3[12]|0[134])|1(?:61|1[12])|(?:51|72)1|90[12])|2(?:(?:20|33|61)1|1(?:14|7[12])|50[0-7]|80[1-6]|42[14])))',
    '864' => '(?:0(?:0(?:3[1-3]|2[1-35-7]|0[0-6]|1[1-5]|4[12]|5[1-7])|1(?:31|6[1-6])))',
    '865' => '(?:0(?:0(?:2[1-7]|3[1-5]|[145][1-8]|0\d|6[1-6]|7[1-3])|1(?:[23][1-6]|1[1-7]|0[0-4])))',
    '866' => '(?:0(?:8(?:[257][1-7]|[018][1-5]|[46][1-6]|3[1-4]|9[1-8])|0(?:1[1-7]|[3-68][1-5]|0[0-8]|[27][1-4])|3(?:[01]3|34)|20[1-3]|10[12]))',
    '867' => '(?:0(?:0(?:[45][1-9]|2[1-5]|6[1-8]|0\d|[13][1-6])|1(?:16|7[1-4])|28[1-4]))',
    '868' => '(?:0(?:0(?:9[1-5]|[238][1-7]|0[0-8]|[457][1-8]|[16][1-6])|4(?:15|51|0[08]|2[1-5]|3[12]|4[1-4])|6(?:1[1-6]|0[0-7]|2[1-5])|8(?:[01][1-3]|2[1-5])|50[0-5]|20[0-3]|30[0-3]|70[0-3]|101))',
    '869' => '(?:(?:0(?:4(?:1\d|[23][1-6]|5[1-7]|[46][1-5]|0[0-8])|5(?:0[0-3]|[235][1-4]|4[1-6]|[16][1-3])|6(?:2[1-4]|[013][1-6])|2(?:2[1-4]|3[1-68]|[01][1-3])|1(?:[12][1-3]|0[0-6])|3(?:1[1-3]|2[12]|0[0-5]))|5(?:1(?:[57][1-5]|[34][1-8]|6[1-6])|4(?:00|61|[235][1-4]|4[1-3])|5(?:7[1-6]|6[1-4])|30[1-7]|60[0-5]|22[1-5])|4(?:2(?:[0-2][1-5])|6(?:0[0-8]|1[1-6])|8(?:0[1-6]|1[1-5])|7(?:0[1-4]|2[1-3])|5(?:01|1[1-5])|30[1-4]|40[1-3])|1(?:2(?:0[0-8]|1[1-9]|[23][1-7])|8(?:1[1-5]|2[1-6])|4(?:1[12]|0[0-4])|1(?:1[0-5]|0\d)|50[1-5]|60[0-3])|2(?:2(?:05|2[1-6]|3[1-7])|3(?:0[1-7]|1[1-6])|6(?:21|0[0-4]|1[1-3])|4(?:13|0[0-3])|50[0-6]|80[1-7]|70[0-5])|6(?:1(?:[01][1-5])|2(?:0[45]|1[1-6])|30[1-8]|40[0-5])|3(?:4(?:[17][1-3])|20[1-7]|17[1-5]|60[0-4]|711)))',
    '870' => '(?:(?:0(?:8(?:[01346][1-9]|[2578]\d)|9(?:[1-5][1-9]|0[1-8])|1(?:7[1-4]|[025]\d|[16][1-8]|[34][1-9])|0(?:1[1-8]|3\d|[024][1-9])|3(?:[01][1-9]|2[1-7])|2(?:5[1-4]|7\d|6[135-8]|4[1-5]))|1(?:1(?:[03][1-9]|7[1-467]|2[0-68]|[46][1-8]|[15]\d)|2(?:2[1-3]|[01][1-5]))))',
    '871' => '(?:0(?:0(?:1[1-6]|5[013-9]|[03689]\d|[247][1-9])|1(?:22|0[1-5]|5[1-7]|[16][1-4])|4(?:2[12]|[13][1-4]|0[1-8])|9(?:1[1-4]|2[1-8]|0[0-7])|8(?:11|3[1-4]|2[1-3]|0[12])|7(?:0[1-4]|1[1-6])|2(?:26|0[1-8])|31[1-5]))',
    '872' => '(?:(?:0(?:3(?:66|4[1-6]|[12][1-8]|3[1-4]|0[12])|0(?:4[1-7]|[23][1-3]|1[1-6]|0[01])|4(?:5[1-9]|7[1-3]|6[1-6]|8[1-4])|8(?:6[1-5]|5[1-8]|[47][1-3])|5(?:4[1-3]|1\d|[02][1-7])|7(?:2[1-4]|[03][1-3]|1[12])|6(?:6[1-4]|[57][1-5])|1(?:[01][1-4]))|1(?:6(?:5[1-3]|1[1-4])|10[1-7]|20[1-7]|40[1-6]|32[1-4]|501)))',
    '873' => '(?:0(?:0(?:41|53|0[0-8]|[12][1-5]|3[1-4])|5(?:0[0-4]|3[1-5]|[12][1-4])|2(?:[13][12]|0[1-7]|2[1-4])|4(?:32|0[124-7]|1[245]|2[1-4])|35[1-6]|64[1-6]))',
    '874' => '(?:0(?:0(?:[14][1-6]|3[1-7]|2[1-5]|0[0-5])|8(?:[13][1-9]|0[1-5]|[24]\d)|9(?:[1-3]\d|0[1-9]|4[1-7])))',
    '875' => '(?:0(?:0(?:6[1-5]|0[0-4]|7\d|[38][1-4]|[1245][1-3])|2(?:3[1-7]|0[1-3]|1[1-6]|2[1-4])|3(?:23|5[1-3]|4[1-4])))',
    '876' => '(?:(?:0(?:0(?:0[0-8]|[2-4][1-7]|5[1-3]|1[1-8]|6[1-4])|8(?:3[1-6]|4[1-9]|[05][1-7]|[12][1-5])|1(?:[01][1-3]|2[1-6])|2(?:[01][1-6]))|1(?:3(?:1[1-3]|0[16])|10[1-6]|20[1-6]|40[1-5]|51[1-3])|2(?:40[1-7]|20[1-3]|30[12]|121)))',
    '877' => '(?:(?:0(?:0(?:0[0-8]|[358][1-9]|[14][1-7]|2[1-6]|[67][1-8])|2(?:21|[01][12])|3(?:[01][12])|11[1-4])|1(?:3(?:[67][1-5]|[58][1-4])|2(?:2[1-5]|[34][1-4])|1(?:21|1[1-3]|0[1-7]))))',
    '878' => '(?:0(?:0(?:1[1-3]|2[1-8]|0[0-7]|3[1-5])|1(?:6[1-4]|[45][1-6])|2(?:56|0[1-6])|57[1-6]|40[1-4]))',
    '879' => '(?:(?:0(?:1(?:[26][1-4]|[15][1-3]|0[1-7])|4(?:[56][1-7]|[47][1-4])|6(?:0\d|2[1-8]|1[1-9])|3(?:0[1-9]|1[1-7])|2(?:2[1-5]|3[1-7])|5(?:1[1-6]|0[1-4])|7(?:2[1-4]|3[1-5])|8(?:5[1-5]|4[1-4])|9(?:41|1[12]|0[1-4]))|6(?:1(?:2[1-8]|1[1-356]|[08][1-4]|3[1-5])|6(?:3[1-5]|0[12]|4[1-3]|[12][1-6])|4(?:0[1-8]|2[1-6]|[34][1-5])|9(?:1[1-4]|2[12]|0[1-5])|2(?:0[12]|1[1-3]|2[1-4])|75[1-9]|86[1-5]|33[1-4])|7(?:1(?:[13]1|0[0-8]|[25][1-5]|4[1-4])|3(?:1[1-6]|0[1-7])|8(?:[78][1-5])|4(?:[01][1-4])|76[1-5]|26[1-4]|50[1-4])|2(?:4(?:61|0[01]|1[1-3]|[347][1-6]|2[12]|5[1-9])|6(?:[08][1-3])|11[1-5]|20[1-3]|501)|4(?:4(?:1[1-4]|0[0-6])|7(?:32|2[1-4])|3(?:01|3[12])|6(?:01|3[12])|80[0-3]|12[1-3]|20[1-3]|52[1-3]|91[12])|5(?:4(?:0[0-8]|3[1-7]|2[1-5]|1[1-3])|5(?:0[1-46]|[35][12]|2[1-5]|1\d)|1(?:[01][1-4]))|1(?:1(?:[23][1-8])|3(?:1[1-6]|0[1-7])|50\d)|3(?:10[1-5]|20[1-5]|30[12]|40[12])))',
    '880' => '(?:(?:0(?:8(?:3[1-7]|7[1-9]|4[1-5]|[156][1-8]|[02][1-6])|0(?:0[0-7]|[1-5][1-7])|9(?:3\d|5[1-6]|[02][1-9]|[14][1-7])|3(?:4[145]|0[1-3])|2(?:04|1[1-4])|12[1-5])|2(?:2(?:[23][1-4]|1[1-5])|1(?:0[1-5]|1[1-6])|3(?:03|2[1-35]))|1(?:1(?:21|1[1-4]|0[0-8])|22[1-4]|30[0-3])))',
    '881' => '(?:(?:0(?:0(?:1[1-6]|0[0-6]|[23][1-7])|1(?:[01][1-6]))|1(?:4(?:00|1[1-4])|12[1-3]|23[1-3]|30[1-3])))',
    '882' => '(?:(?:0(?:0(?:0[0-7]|[1-57-9][1-7]|6[1-6])|8(?:[08][1-5]|[2-7][1-7]|1[1-6])|1(?:0[1467]|2[1-9])|2(?:3[1-8]|4[1-5])|40[0-3]|30[124])|1(?:41[1-5]|10[0-3]|20[0-3]|62[12])))',
    '883' => '(?:(?:0(?:0(?:0[0-6]|1[1-5]|[36][1-8]|2[1-4]|5[1-3]|4[1-6])|10[1-9]|30[1-6]|21[1-3]|402)|1(?:60[0-4]|10[0-2]|30[0-2]|21[12]|402)))',
    '884' => '(?:0(?:00[0-6]|10[0-5]))',
    '885' => '(?:(?:0(?:0(?:[46][1-4]|[28][1-6]|[59][1-5]|[17][1-9]|3[1-7]|0[0-6])|22[1-5]|11[1-4])|1(?:10[1-5]|20[1-5]|31[12])))',
    '886' => '(?:0(?:1(?:01|1[1-5])|2(?:03|1[1-3])|00\d))',
    '887' => '(?:0(?:0(?:41|[23][1-4]|1[1-7]|0[0-7])|10[12]))',
    '888' => '(?:0(?:0(?:0\d|1[1-3])|22[12]))',
    '889' => '(?:(?:1(?:4(?:1[1-5]|0[0-6])|6(?:1[1-3]|0[1-9])|9(?:1[1-4]|0[0-7])|7(?:1[36]|0[1-3])|1(?:[02]1|1[12])|30[0-2]|80[1-3]|20[01])|4(?:2(?:[34][1-4]|2[12])|3(?:1[1-4]|0[0-6])|1(?:[56][1-5])|4(?:00|1[1-4])|50[1-6]|60[12])|0(?:6(?:2[1-6]|0[0-5]|1[1-7])|5(?:[01][1-7])|3(?:0[1-4]|2[12])|90[1-3]|10[12])|2(?:5(?:41|3[1-6]|1[1-4]|2[1-5])|1(?:5[1-6]|6[1-4])|40[1-3]|3[01]1)|3(?:2(?:[01][1-7])|1(?:4[1-3]|5[1-6])|53[1-4]|311)))',
    '890' => '(?:0(?:0(?:[12578][1-6]|3[1-8]|0[0-8]|4[1-7]|6[1-9])|90[1-3]))',
    '891' => '(?:(?:0(?:1(?:75|1[1-7]|0[1-9]|2[23]|4[13-6]|5[01]|3[1-3])|5(?:0[1-7]|1[1-6])|6(?:14|21|0[1-4])|3(?:04|1[1-5])|40[0-6]|20[1-6]|70[1-5]|91[12])|1(?:4(?:20|0[1-3]|1[1-9])|2(?:22|31|0[1-6]|7[45])|5(?:01|4[1-5])|10[1-8]|30[1-6])|9(?:1(?:[13][1-6]|0[0-4]|2[1-5])|2(?:[23][1-4]|0[0-7]|1[1-5])|30\d)|6(?:2(?:2[1-9]|1[1-7]|0[0-3]|3[1-3])|1(?:[4-6][1-4]))|3(?:1(?:0[0-4]|1[1-8])|2(?:02|2[12])|60[0-7]|70[0-6]|43[12])|7(?:6(?:1[12]|0[0-5]|2[1-4])|1(?:0[0-5]|1[1-6])|42[1-6]|731)|2(?:1(?:[12][1-7]|0[0-6])|3(?:2[12]|1[1-4]|0[1-6]))|8(?:3(?:00|2[1-9])|2(?:[02]1|16)|11[1-7])|4(?:20[0-8]|40[1-9]|31[12])|5(?:20[0-5]|[13]01)))',
    '892' => '(?:08(?:5[1-5]|[07][1-7]|1[1-9]|6[1-3]|[2-4][1-8]))',
    '893' => '(?:(?:0(?:0(?:[2-6][1-7]|0\d|1[1-6])|20[1-3]|13[12])|1(?:6(?:0[0-5]|1[1-5])|20[0-7]|10[1-3]|40[12]|511)|2(?:50[0-5]|30[0-3]|60[1-4]|40[12])))',
    '894' => '(?:(?:0(?:0(?:[12][1-7]|6[1-38]|3[1-6]|4[1-8]|0\d)|3(?:5[12]|2[1-4]|3[1-3])|5(?:1[1-3]|0[1-8])|10[0-8]|62[1-7]|77[1-6]|41[12])|1(?:5(?:31|0\d|2[1-4]|1[0-5])|11[1-6]|3(?:04|21)|74[1-6]|20[1-5]|85[1-5])|2(?:4(?:0[1-4]|1[1-7])|23[1-7]|14[1-4]|32[1-3]|50[12]|601)|3(?:10[0-7]|30[0-5]|21[1-4]|41[1-3]|52[1-3]|63[1-3])))',
    '895' => '(?:(?:0(?:0(?:0[0-7]|[267][1-7]|[35][1-6]|1[1-3]|4[1-4])|21[1-4]|13[1-3])|2(?:5(?:0[0-7]|2[1-9]|1[1-3])|1(?:31|0[1-4])|70[1-8]|63[1-5]|20[1-3]|81[1-3]|44[12])|1(?:8(?:0[0-7]|1[1-7])|10[1-6]|50[1-4]|20[1-3]|72[1-3]|40[12])))',
    '896' => '(?:(?:00(?:[67][1-9]|[13][1-7]|0[0-6]|5[124-8]|2[1-8]|4[1-6])|1(?:2(?:81|0[1-6])|5(?:12|21)|41[12]|60[12]|[13]01)))',
    '897' => '(?:(?:0(?:2(?:2[1-4]|0[0-5]|1[1-5])|0(?:31|0\d)|30[1-6]|13[1-3])|1(?:12[1-5]|30[12]|201)))',
    '898' => '(?:0(?:0(?:[08]\d|[135][1-8]|[67][1-6]|[249][1-9])|2(?:21|1[12])|10[12]))',
    '899' => '(?:(?:5(?:4(?:3[1-3]|1[1-4]|0[0-5]|2[12])|2(?:[34]1|2[1-3]|0[1-4]|1[1-5])|1(?:21|1[1-8]|0[1-6])|30[1-8]|65[1-6]|54[1-5])|4(?:3(?:1[1-8]|[45][1-6]|2[1-5]|3[12]|0[0-5])|20[1-4]|50[1-4]|10[1-3]|46[1-3]|63[1-3])|1(?:6(?:0[0-4]|2[1-9]|1[1-7])|3(?:21|0[1-4])|(?:13|50|74)1|92[1-5]|40[0-3]|21[12]|80[12])|2(?:5(?:31|0[0-6]|2[1-4]|1[1-6])|4(?:21|3[1-4]|4[1-3])|70[1-9]|20[1-4]|10[1-3]|311)|0(?:2(?:1[1-7]|0[0-8])|1(?:2[1-6]|3[1-46-8])|4(?:35|0[1-7])|34[12]|50[12])|3(?:3(?:11|0[1-9])|1(?:21|0[1-3])|2(?:21|0[36])|51[1-6]|40[1-5]|611)|6(?:20[0-7]|50[1-7]|10[1-5]|40[1-5]|60[1-4]|30[1-3])|7(?:5(?:03|1[1-3])|10[0-4]|40[1-3]|60[1-3]|21[12]|30\d)|8(?:10[1-6]|42[1-4]|21[1-3]|31[1-3]|51[12]|60\d)))',
    '900' => '(?:00(?:3[1-7]|2[1-9]|0[0-6]|1[1-6]))',
    '901' => '(?:(?:0(?:3(?:[124][1-5]|0[0-6]|3[1-6]|[56][1-4])|2(?:0[0-5]|[1-3][1-5]|4[1-4])|6(?:0[1-8]|1[1-9])|1(?:5[1-6]|4[1-8])|4(?:0[0-6]|1[1-7])|5(?:0[1-4]|1[1-6]))|2(?:1(?:[13][1-4]|2[1-8]|0[0-4])|2(?:0[0-7]|2[1-7]|1[1-6])|4(?:2[1-4]|1[1-7]|0[0-7])|3(?:21|1[1-7]|0[0-5]))|3(?:1(?:[12][1-5]|0[0-8]|3[1-8])|80[0-6]|40[0-3]|70[0-3]|90[0-3]|50[0-2]|31[12]|601)|1(?:1(?:1[1-7]|0[0-5])|4(?:1[1-5]|0[0-7])|5(?:0[1-5]|1[1-6])|20[1-8]|30[0-4])))',
    '902' => '(?:00(?:7[1-8]|6[1-9]))',
    '903' => '(?:0(?:1(?:2[1-9]|0[0-5]|1[1-8])|8(?:0[1-7]|[12][1-6])))',
    '904' => '(?:(?:0(?:0(?:1[1-4]|2[1-3]|0[0-6]|3[1-5])|3(?:1[1-6]|2[1-8]|0[0-5])|1(?:0[0-7]|1[1-7])|4(?:0[0-4]|1[1-7])|20[0-5])|2(?:2(?:[23][1-6]|0[0-5]|[14][1-5])|1(?:[46][1-5]|5[1-6]|7[1-4])|3(?:[01][1-7])|42[1-8])|1(?:1(?:0[1-8]|1[1-5])|30[0-4]|20[0-3])))',
    '905' => '(?:(?:0(?:4(?:1[1-5]|0[0-6]|2[1-8])|2(?:0\d|[12][1-9])|0(?:1[1-9]|0\d|2[1-6])|50[0-5]|60[0-5]|70[0-5])|1(?:4(?:00|1[1-7]|2[1-9])|3(?:0[0-8]|1[1-9])|1(?:4[1-7]|5[1-6])|20[0-6]|63[1-5]|50[1-4])|2(?:26[1-9]|17[1-3])))',
    '906' => '(?:0(?:0(?:1[1-5]|0[0-8])|10[1-9]|50[1-7]|30[1-6]|20[1-4]|60[0-3]|42[12]))',
    '907' => '(?:(?:0(?:0(?:[12][1-4]|0[0-4])|24[1-4]|33[1-3]|45[1-3])|1(?:(?:10|22|31|75)1|43[1-5]|54[1-4]|80[01])))',
    '910' => '(?:(?:0(?:3(?:8[1-4]|2[1-6]|1[1-7]|[346][1-9]|5[0-7]|[07][1-5])|0(?:70|5[1-7]|[1-46][1-9]|0[1-6])|2(?:5[1-4]|4[1-6]|[16][1-5]|[237][1-7]|0[0-8])|8(?:[025][1-9]|4[1-6]|[13][1-8])|1(?:0[1-9]|[34][1-7]|5[1-8]|2[1-4]))|3(?:1(?:0[1-7]|[1-4][1-8])|6(?:0[1-8]|2[1-3]|[34][1-6]|1[1-7])|5(?:2[1-6]|[15][1-8])|2(?:6[1-8]|5[1-6])|3(?:8[1-6]|7[1-8])|40[1-5])|2(?:5(?:[1-35][1-7]|0[0-8])|1(?:[56][1-7]|[47][1-8])|3(?:4[1-8]|5[1-7]|3[1-9])|2(?:2[1-7]|1[1-4]|0[1-8])|4(?:7[1-5]|6[1-6]))|1(?:1(?:4[1-4]|1[1-8]|3[1-9]|2[1-7]|0[0-6])|2(?:0[1-6]|[12][1-8])|3(?:0[1-5]|[12][1-6]))|4(?:1(?:1[1-35]|3[1-478]|2[1-7]|4[124-7]|0[2-5])|27[1-7])))',
    '911' => '(?:0(?:0(?:[25][1-6]|4[1-8]|3[1-5]|1[1-7]|0[0-6])|8(?:1[1-7]|[24][1-8]|[03][1-6])))',
    '912' => '(?:0(?:0(?:0[0-8]|[124][1-7]|[59][1-5]|[37][1-6]|[68][1-8])|4(?:[23][1-7]|0[1-5]|1[1-6])|1(?:[34][1-9]|5[1-5])|2(?:1[1-8]|0[1-7]|2[12])|8(?:2[1-7]|[01][1-5])))',
    '913' => '(?:00(?:[12][1-7]|[06][1-5]|[3-5][1-8]))',
    '914' => '(?:0(?:0(?:[357][1-9]|4[1-7]|0[0-7]|[12][1-8]|6[1-6])|8(?:[1-4][1-5]|0[1-35-7])|1(?:4[1-7]|2[1-5]|3[1-8])|3(?:1[1-7]|0[1-6])|2(?:7[1-4]|6[1-8])))',
    '915' => '(?:(?:0(?:0(?:[1247][1-6]|0[0-7]|[359][1-7]|6[1-9]|8[1-5])|8(?:[013][1-6]|8[1-8]|6[1-5]|[24579][1-7])|2(?:[01][1-9]|[36][1-5]|4[1-4]|2[1-8]|5[1-6]))|1(?:2(?:[013][1-5]|[24][1-6])|1(?:0[1-6]|1[1-4]))))',
    '916' => '(?:(?:0(?:0(?:[36-8][1-8]|[12][1-9]|[45][1-7]|0[0-8])|1(?:0[1-8]|5[1-6]|[1-4][1-7])|2(?:6[1-8]|7[1-6]|5[1-5]|2[1-7]|1[1-9]|0[0-6])|3(?:1[1-6]|0[1-4])|42[1-8])|1(?:1(?:33|0[1-7]|1[1-68])|2(?:2[1-5]|3[1-7]))))',
    '917' => '(?:0(?:0(?:[278][1-8]|[156][1-9]|[349][1-7]|0[0-8])|3(?:[67][1-5]|[58][1-7])|2(?:2[1-6]|3[1-8]|4[1-9])|1(?:[01][1-7])))',
    '918' => '(?:(?:8(?:0(?:[15-7][1-8]|8[1-3]|0[1-9]|[2-4][1-7])|1(?:[135-7][1-6]|[08][1-8])|2(?:3[1-9]|0[1-7]|[12][1-8]))|0000))',
    '919' => '(?:(?:0(?:4(?:2[1-6]|[18][1-8]|7[1-79]|[56][1-5]|[04][1-9]|3[1-7])|5(?:[0-4][1-7])|1(?:3[1-356]|0[1-4]|[12][1-9])|3(?:73|0[1-5]|[12][1-8])|7(?:4[1-9]|[23][1-7])|6(?:0[0-4]|3[1-4]|2[138]|1[1-6])|2(?:[12][1-7]|0[0-6])|8(?:[01][1-7]))|1(?:5(?:4[1-5]|0[1-7]|5[1-9]|[13][1-6]|2[1-8])|3(?:0[0-6]|[13][1-6]|2[1-8])|1(?:00|3[1-8]|2[1-6]|4[1-7])|4(?:6[1-4]|5[1-5])|2(?:79|0[1-8]))|2(?:1(?:1[1-6]|3[1-5]|0[0-7]|2[1-9])|3(?:8[1-7]|[5-7][1-6])|2(?:1[1-6]|2[1-9]|0[0-7]))))',
    '920' => '(?:(?:0(?:9(?:[26-8][1-8]|1\d|[45][1-7]|[039][1-9])|1(?:1[1-6]|[467][1-8]|2[1-9]|[035][1-7])|8(?:2[1-7]|[046][1-9]|[135][1-8])|0(?:[24][1-7]|5[1-9]|6[1-57-9]|0[0-8]|1[1-8]|3[1-6])|3(?:81|5[1-7]|3[1-9]|[46][1-8]|7\d)|2(?:31|0\d|2[3-7]|1[1-59]|6[1-9]|7[1-7]))|2(?:3(?:3[1-9]|[245][1-7]|[16][1-8]|[07][1-6])|1(?:1[1-6]|4[1-8]|[03][1-4]|6[1-7]|2[1-9]|5[1-5])|50[1-3])|1(?:1(?:[35][1-8]|6[1-7]|[0-24][1-9])|3(?:[124][1-6]|0[1-4]|3[1-7]))|31(?:3[1-5]|[01][1-7]|2[1-6])|82(?:0[1-5]|2[12]|1[6-8])))',
    '921' => '(?:(?:8(?:1(?:[35][1-5]|1[124-7]|4[1-9]|0[1-6]|[26][1-4]|7[1-8])|0(?:[01356][1-6]|[24][1-7])|8(?:[04][1-8]|2[1-5]|[13][1-7]))|0000))',
    '922' => '(?:0(?:0(?:[2-46][1-8]|0[0-7]|5[1-7]|1[1-5])|8(?:[05][1-7]|[26][1-5]|[13][1-6]|4[1-4])|1(?:1[1-8]|[023][1-9])|4(?:3[1-7]|[04][1-6]|1[1-4]|2[1-8])|2(?:22|[46][1-7]|5[0-8]|7[1-8])|3(?:[12][1-6]|[03][1-7])|5(?:5[1-4]|6[1-6])|67[1-39]))',
    '923' => '(?:(?:0(?:9(?:8[1-5]|1[1-9]|[27][1-7]|[03-69][1-8])|0(?:4[1-4]|[27][1-8]|[156][1-6]|3[1-7]|0[0-5])|8(?:[145][1-4]|[023][1-6]|6[1-9])|3(?:4[1-5]|2[1-8]|[013][1-6])|1(?:[578][1-7]|6[1-6]))|1(?:2(?:0[0-8]|6[1-9]|[124][1-7]|5[1-4]|[37][1-8])|1(?:2[1-4]|1[1-7]|0[0-7]))))',
    '924' => '(?:0(?:8(?:[03-578][1-8]|2[0-8]|1[1-9]|6[1-7])|0(?:81|7[1-6]|4[1-8]|[23]\d|[156][1-9]|0[0-7])))',
    '925' => '(?:0(?:0(?:0[0-5]|4[1-9]|3[1-6]|[12][1-8]|5[1-4])|1(?:00|[46][1-8]|[35][1-7]|2[1-5])|4(?:[34][1-8]|[25][1-7])|3(?:45|7[1-6]|0[1-7]|[18][1-5])|6(?:1[1-7]|0[1-8]|2[1-6])|5(?:6[1-6]|7[1-8])|2(?:1[1-5]|0[1-7])))',
    '926' => '(?:0(?:8(?:5[1-5]|6[1-7]|2[1-9]|4[1-6]|[013][1-8])|0(?:1[1-6]|[2-5][1-8]|0[0-7])|3(?:6[1-7]|8[1-9]|7[1-6])|2(?:[02][1-7]|1[1-6])|17[1-9]))',
    '927' => '(?:(?:0(?:0(?:5[1-8]|0\d|[12][1-7]|[34][1-9])|2(?:[1-3][1-5]|0[1-7])|6(?:0[1-9]|2[1-7]|1[1-5])|4(?:00|[45][1-4]|3[1-5])|3(?:[0-2][1-5])|5(?:[56][1-5]))|2(?:1(?:[57][1-6]|[03][1-8]|[246][1-7]|1[1-5])|3(?:[36][1-6]|1[1-4]|[0245][1-5])|2(?:7[1-7]|8[1-6]))|1(?:2(?:0[0-7]|1[1-7]|3[1-9]|2[1-8])|4(?:[45][1-7]|6[1-8])|3(?:0[1-4]|2[1-6]|1[1-9]))))',
    '928' => '(?:0(?:0(?:[3-5][1-7]|7[1-9]|0[0-8]|[26][1-8]|1[1-6])|2(?:1[1-8]|[02-5][1-6])|3(?:[23][1-6]|1[1-4]|0[1-8])))',
    '929' => '(?:(?:1(?:3(?:0[0-5]|2[1-7]|4[1-5]|1[1-6]|3[1-3])|1(?:[17][1-7]|0[0-5]|2[1-35-7])|7(?:0[0-6]|1[1-7]|2[1-6])|4(?:[0-2][1-6])|2(?:1[0-5]|0[1-8])|6(?:3[1-7]|0[1-6])|8(?:0[1-5]|1[1-8])|5(?:21|7[1-7]))|0(?:4(?:5[1-6]|[0-46][1-7])|3(?:1[1-9]|3[1-5]|4[1-6]|2[1-8]|0\d)|2(?:0[1-6]|2[1-4]|3[1-5]|1[1-7])|1(?:0[1-8]|[12][1-6]))|2(?:2(?:0[1-9]|[24][1-7]|1[1-8]|3[1-4])|1(?:0[1-5]|[12][1-6])|3(?:7[1-9]|6[1-7]))))',
    '930' => '(?:(?:0(?:0(?:1[024-9]|[79][1-8]|[02-68][1-9])|8(?:[268][1-7]|[015][1-9]|3\d|9[1-8]|4[1-35-9]|7[1-6])|3(?:[168][1-8]|[23][1-6]|[57][1-9]|4[1-7]|0[0-5])|9(?:[01356][1-6]|2[1-8]|4[1-4]|9[1-7]|[78][1-5])|2(?:[168][1-9]|[35][1-7]|[02]\d|4[1-8]|7[1-6])|1(?:[16][1-6]|4[1-4]|[035][1-8]|[27][1-7])|4(?:[16][1-7]|[24][1-5]|7[1-4]|[35][1-8]|0[1-6]))|1(?:3(?:77|6[1-9]|0[1-5]|[23][1-8]|1[1-6])|4(?:6[1-6]|[01][1-8]|5[1-9])|2(?:7[1-6]|6[1-8]|8[1-7]))|2(?:2(?:[045][1-8]|1[1-5]|3[1-9]|2[1-7])|1(?:1[1-7]|[02][1-8]))|32(?:77|5[1-5]|[16][1-7]|3[1-9]|4[1-8]|0[1-68]|2[1-4])))',
    '931' => '(?:8(?:3(?:[01][1-6]|[27][1-8]|[346][1-7]|5[1-9])|4(?:2[1-35-8]|5[1-6]|0[1-9]|[13][1-7]|4[1-5])))',
    '932' => '(?:0(?:0(?:[67][1-5]|[23][1-7]|0[0-8]|[145][1-8])|8(?:1[1-7]|[245][1-6]|[03][1-8]|6[1-4])|2(?:[1-5][1-8]|0[1-7])|1(?:[01][1-6]|2[1-9]|3[1-7])|3(?:71|1[1-7]|0[1-5])))',
    '933' => '(?:0(?:9(?:[0245][1-9]|8[1-7]|[367][1-8]|1\d)|8(?:[15][1-8]|6\d|[02-47][1-9])|0(?:0[0-8]|2[1-9]|[46][1-7]|3\d|[157][1-8])|3(?:[03][1-8]|4[1-5]|[12][1-9]|5[1-7])|2(?:[03][1-9]|5[1-3]|4\d|2[1-8])|1(?:[0-2][1-6]|3[1-8])))',
    '934' => '(?:00(?:2[1-7]|[39][1-9]|0[1-5]|5[1-8]|4\d|1[1-6]))',
    '935' => '(?:0(?:0(?:[1-6][1-7]|0[0-7])|2(?:6[1-9]|[57][1-8])|4(?:[02][1-6]|1[1-7])|1(?:[01][1-7])|3(?:3[1-8]|4[1-6])))',
    '936' => '(?:0(?:8(?:91|[0136][1-8]|[257][1-7]|4[1-9]|8[1-5])|0(?:0[0-7]|2[1-7]|[135][1-9]|7[0-8]|6\d|4[1-8])))',
    '937' => '(?:0(?:0(?:4[1-7]|[35][1-9]|1[0-8]|0\d|[26][1-8])|8(?:[26][1-8]|1[1-6]|[03-5][1-7])))',
    '938' => '(?:0(?:0(?:[6-8][1-6]|2[1-8]|1[1-5]|[3-5][1-9]|0[0-6])|8(?:1[1-6]|6[1-4]|[023][1-7])|1(?:0[1-6]|[67][1-9])|2(?:74|8[1-3])))',
    '939' => '(?:(?:1(?:3(?:0[0-8]|7[1-9]|[1-68][1-8])|5(?:5[1-5]|4[1-9]|[07][1-7]|[1-36][1-8])|8(?:7[1-9]|[03][1-7]|[126][1-8]|[45][1-6])|6(?:[247][1-6]|1[0-5]|6[124-7]|3[1-7]|8[124]|5[1-5]|0[0-6])|7(?:0[1-4]|5[124-8]|[16][1-6]|3[2-5]|2[1-5]|4[1-7])|9(?:[67][1-9]|1[1-6]|[02][1-8])|4(?:1[1-7]|2[1-9]|[03][1-8])|1(?:3[1-6]|0[1-5]|1[1-9]|2[0-5])|2(?:[57][1-5]|6[1-7]))|0(?:6(?:00|2[1-8]|[13-6][1-7]|7[1-9])|5(?:4[1-7]|0[1-9]|1[1-5]|3[1-6]|[256][1-8])|1(?:71|[05][1-6]|2[1-8]|1[1-35-9]|[34][1-5])|7(?:51|0[0-5]|[13][1-7]|[24][1-9])|2(?:8[1-8]|7[1-6]|[45][1-7]|3[1-5])|3(?:[45]1|6[1-4]|2[1-3]|3[12]|1[1-9]|0[0-7])|4(?:[01][1-8])|000)|2(?:4(?:[013467][1-7]|[25][1-6])|3(?:[1-36][1-7]|[45][1-5]|[07][1-6])|7(?:3[1-8]|[0-245][1-9])|2(?:0[1-9]|[45][1-7]|[12][1-6]|3[1-8])|6(?:49|3[1-9]|[0-2][1-7])|1(?:7[1-6]|6[1-5]|8[1-9])|5(?:[01][1-9]))|8(?:0(?:[236][1-6]|[05][1-8]|[17-9][1-7]|4[1-9])|1(?:[46][1-6]|[02][1-4]|7[1-8]|3[1-9]|[59][1-7]|[18][1-5])|2(?:2[1-5]|[78][12]|0[1-8]|[3-6][1-4]|1[1-6]))|35(?:5[1-7]|[0-3][1-6]|4[1-8])))',
    '940' => '(?:(?:0(?:0(?:[57][1-6]|[3489][1-8]|0[0-46-8]|[16][1-7]|2[1-9])|8(?:2[124-9]|7[1-7]|5[1-467]|6[14-8]|9[1-8]|4[24-9]|8[1-4]|[03][1-6]|1[124679])|1(?:5[1-5]|3[1-7]|[24][1-9]|[01][1-6])|2(?:[15][1-8]|[23][1-7]|[04][1-5]))|2(?:1(?:[2-5][1-8]|0[1-68]|1[1-7])|0(?:[24][1-6]|[01][1-5]|[35][1-9])|4(?:[67][1-5]|[01][1-7])|5(?:2[1-9]|[01][1-8])|3(?:[01][1-6]|2[1-5]))|11(?:0[1-6]|2[1-3]|[34][1-9]|[16][1-7]|5[1-5]|7[12])))',
    '941' => '(?:00(?:1[1-69]|[57][1-8]|0[0-8]|6[1-9]|[2-4][1-7]))',
    '942' => '(?:(?:0(?:0(?:91|[01][1-4]|[45][1-6]|7[124]|6[1-5]|2[1-7]|[38][1-9])|1(?:81|7[1-3]|5[1-8]|6[1-5]|[023][1-9]|[14][1-7])|2(?:[47][1-7]|[25][1-5]|3[1-48]|[06][1-8]|1[1-6])|3(?:[13][1-9]|2[1-7]|0[1-8])|5(?:4[1-4]|3[1-9]|2[1-5])|4(?:[01][1-5]))|1(?:5(?:2[1-7]|1[1-5]|0[1-6]|3[1-8]|4[1-4])|4(?:[12][1-9]|0[1-6]|3[1245])|3(?:5[1-6]|4[12])|10[1-7]|21[1-6])))',
    '943' => '(?:0(?:8(?:7[1-8]|1\d|6[1-6]|[02-589][1-9])|1(?:8[1-7]|[0-3][1-9]|5[1-5]|[467][1-8])|6(?:[013][1-7]|[24][1-8])|5(?:0[1-9]|2[1-7]|3[1-5]|1[0-6])|2(?:0[12]|3[1-6]|2[1-8])|3(?:1[1-8]|0[1-7])|4(?:[12][1-7])|000))',
    '944' => '(?:0(?:0(?:[37][1-7]|1[1346-9]|2[0-8]|6[1-4]|0\d|[4589][1-8])|1(?:5[01]|[0-4][1-9])|2(?:1[1-7]|0[1-5]|2[1-6])|3(?:[34][1-5])))',
    '945' => '(?:(?:0(?:0(?:00|[124][1-7]|[357][1-6]|6[1-8])|8(?:5[1-578]|[124][1-7]|3[1-8])|3(?:0[0-8]|1[1-7]|2[1-5])|1(?:0[1-6]|1[1-4])|21[1-9]|40[1-3])|1(?:1(?:1[1-8]|[02][1-6])|2(?:5[1-3]|4[1-8])|5(?:[01][1-5])|3(?:5[1-5]|4[13-5])|43[1-8])))',
    '946' => '(?:0(?:0(?:4[1-3]|6[1-6]|7[1-356]|[358][1-8]|2[1-5]|1[12]|0[0-7])|1(?:[12][1-5]|0[1-9])|2(?:[12][1-6]|0[1-7])|30[1-7]))',
    '947' => '(?:0(?:0(?:0[0-5]|[34][1-5]|5[1-4]|[12][1-8])|2(?:0[1-5]|1[1-3])|10[1-3]))',
    '948' => '(?:0(?:0(?:0[0-8]|[1-47][1-9]|9[1-3]|[568][1-8])|1(?:[34][1-6]|1[1-4]|2[1-5]|0[1-7])|21[1-9]|30[1-6]))',
    '949' => '(?:(?:3(?:4(?:[0-4][1-9])|2(?:01|[34][1-7]|[125][1-6])|1(?:0[1-3]|[13][1-7]|2[1-5])|3(?:6[1-7]|7[1-9])|5(?:6[1-5]|5[1-7])|7(?:3[1-5]|2[1-6])|6(?:6[1-4]|7[1-5]))|8(?:4(?:1[2-9]|4[1-6]|[23][1-7]|0[1-9])|5(?:3[1-4]|5[124-8]|6[12]|4[1-5]|0[2-5]|2[1-7])|6(?:0[1-4]|1[1-8])|7(?:31|2[1-8])|3(?:21|1[1-7])|20[0-7]|12[1-7])|1(?:3(?:[12][1-9]|0[1-6]|[45][1-4]|3[1-8])|7(?:2[1-7]|3[1-9]|4[12]|[01][1-6])|6(?:[01][1-9]|2[1-6])|2(?:0[1-8]|2[1-6]|1[1-5]))|6(?:4(?:[0-3][1-8])|7(?:[46][1-6]|5[13-7]|7[1-5])|6(?:36|1[125]|8[0-2]|0[0-357-9])|5(?:5[1-7]|4[1-5])|3(?:7[1-3]|6[1-6])|10[0-3]|21[12])|7(?:1(?:4[1-5]|[12][1-7]|3[1-8]|0[1-4])|2(?:4[1-8]|[35][1-6]|2[1-9])|4(?:2[1-4]|1[1-8]|0[1-5])|3(?:1[1-9]|0[12])|5(?:1[1-3]|0[1-8]))|4(?:3(?:0\d|[12][1-8]|5[1-3]|4[1-6]|3[1-7])|1(?:1[1-4]|2[1-8]|3[1-6]|4[1-9])|5(?:2[1-5]|[01][1-7])|20[1-6])|2(?:2(?:[01][1-9]|3[1-5]|2[1-6])|3(?:1[1-8]|0[1-6]|2[12])|1(?:41|0[1-6]|1[1-3]))|5(?:4(?:0[1-9]|1[1-6])|2(?:01|1[1-7]|2[1-3])|3(?:4[1-7]|3[1-6])|12[1-4])|0(?:5(?:5[1-8]|3[1-6]|4[1-5])|30[1-8]|46[1-4]|11[12])))',
    '950' => '(?:(?:0(?:0(?:0[0-5]|[14-6][1-7]|3[1-6]|[278][1-8])|9(?:[04][1-9]|1[1-7]|6[1-5]|5[0-4]|9[1-4]|[28][1-6]|[37][1-3])|8(?:7[12]|[25][1-5]|3[1-7]|0[1-9]|[49][1-3]|8[1-6]|1[1-4]|6[1-8])|1(?:1[1-6]|[34]\d|2[1-79]|5[0-7]|0[1-7]|6[1-9])|2(?:0[1-9]|1[0-578])|32[1-9])|1(?:4(?:2[1-68]|[013-7][1-7])|2(?:6[12]|0[0-489]|[2-4][1-7]|[15][1-8])|1(?:51|1[1-5]|2[1-7]|4[1-8]|[03][1-6])|3(?:[13][1-4]|2[1-8]|0[1-5]|4[1-9]))|2(?:0(?:[07][1-6]|[23][1-8]|6[1-4]|[145][1-5])|1(?:[47][1-7]|0[12]|[25][1-6]|1[1-3]|3[1-8]|6[1-4])|2(?:01|5[1-6]|6[1-4]))|3(?:3(?:81|[17][1-7]|[03][1-9]|4[1-6]|[56]\d|2[1-8])|1(?:1[1-6]|2[1-8]|[03][1-5]))))',
    '951' => '(?:8(?:0(?:[0-8][1-8])|1(?:5[1-6]|[01][1-8]|[2-46][1-7])))',
    '952' => '(?:(?:0(?:0(?:0[0-7]|2[1-8]|1[1-6])|3(?:2[12]|0[1-7]|1[1-8])|6(?:[02][1-6]|1[1-5])|1(?:1[1-6]|0[1-9])|2(?:1[1-6]|0[1-7])|7(?:[01][1-6])|8(?:5[1-7]|2[1-4])|5(?:[01][1-5])|4(?:2[12]|3[1-5]))|1(?:5(?:8[1-4]|[0-24-6][1-8]|7[1-5]|3[1-9])|3(?:1[1-5]|0[1-8]|2[1-6])|2(?:1[1-3]|0[1-9])|64[1-6]|43[1-5])|3(?:4(?:[23][1-5])|11[1-9]|20[1-7]|54[1-6])|2(?:2(?:1[1-5]|[02][1-6])|13[1-6])))',
    '953' => '(?:0(?:0(?:[13][1-6]|7[1-8]|[45][1-5]|[26][1-7])|1(?:3[1-6]|4[1-4]|1[1-7]|[02][1-5])))',
    '954' => '(?:0(?:0(?:0[0-24-8]|3[1-8]|4[1-6]|[578][1-9]|2[1-7]|1[1-467]|6[1-478])|1(?:81|[0457][1-7]|1[12]|3[1-8]|[26][1-6])|2(?:2[12]|0[1-7]|1[1-8])))',
    '955' => '(?:0(?:0(?:0[0-4]|[49][1-7]|8[1-5]|[136][1-6]|7[1-3]|5[13-7]|2[1245])|1(?:3[1-7]|[0-24-6][1-8])|8(?:4[1-5]|3[1-3]|0[13-8]|1[1-68]|[256][1-4])))',
    '956' => '(?:0(?:8(?:[12][1-8]|0[1-6]|5[1-5]|[346][1-7])|0(?:[1-35][1-7]|0[0-7]|4[13-6])|1(?:01|1[1-7]|2[1-3])))',
    '957' => '(?:0(?:0(?:[368][1-7]|0[0-7]|9[12]|[12457][1-8])|2(?:1[2-7]|[23][1-6]|0[1-7])|1(?:0[0-6]|[12][1-7])|3(?:3[1-6]|[45][1-7])|46[1-6]))',
    '958' => '(?:0(?:8(?:2[1-4]|1[1-8]|[04][1-9]|[35-7][1-7])|2(?:70|[15][1-5]|6[1-9]|[02-4][1-6])|0(?:61|[3-5][1-8]|1[1-4]|2[1-6]|0[0-8])))',
    '959' => '(?:(?:1(?:3(?:[247][1-8]|1[1-6]|6[1-3]|[358][1-7]|0[0-7])|9(?:[67][1-8]|1\d|3[0-8]|[0245][1-9])|2(?:6[1-5]|0[0-7]|[17][1-7]|8[0146-9]|4[1246]|2[1-68]|3[2-4]|5[1-8])|7(?:0[13-9]|1[1-8]|[3-5][1-9]|[26][1-7])|8(?:7[1-6]|1[1-4]|4[1-8]|[0356][1-7]|2[1-5])|1(?:[235][1-6]|4[1-8]|[01][1-9])|6(?:4[1-4]|[12][1-5]|3[1-7]|0[0-4])|5(?:1[1-4]|0[0-3]|2[1-5]))|2(?:0(?:8[1-356]|[26][1-6]|[17][1-5]|4[1-9]|[35][1-7]|0[0-7])|6(?:[34][1-8]|0\d|[1256][1-9]|7[1-7])|4(?:2[1256]|6[1-58]|4[1-5]|[07][1-9]|[135][1-7])|1(?:2[1-6]|4[1-8]|[01][1-7]|3[0-6])|3(?:81|3[1-8]|[01][1-5]|2[1-9])|5(?:[12][1-8]|0[1-7])|8(?:0[1-9]|[12][1-7])|2(?:0[1-6]|[12][1-7])|7(?:2[1-4]|1[2-6]|0[1-9]))|3(?:2(?:0[0-8]|3[1-7]|5[1-9]|[67][1-5]|[14][1-6]|2[1-8])|9(?:1[1-9]|0[1-7]|[2-4][1-8])|4(?:2[1-8]|4[1-9]|[013][1-7])|1(?:3[1-4]|0[1-8]|2[1-6]|1[1-7])|6(?:5[1-3]|6[1-6]))|0(?:1(?:5[1-7]|[014][1-9]|6[1-5]|7[12]|[23]\d|8[1-3])|2(?:[46][1-8]|0[1-35-8]|[13][1-7]|5[0-7]|2[1-578])|4(?:0[1-7]|2[1-6]|[13][1-8])|5(?:21|1[1-9]|0[1-8])|3(?:2[1-3]|[01]\d))|4(?:5(?:2[1-6]|1[1-5]|3[1-9]|0[1-7])|6(?:3[1-6]|0[1-68]|1[12478]|2[1-7])|4(?:41|1[0-8]|0\d)|30[1-4])))',
    '960' => '(?:(?:0(?:4(?:[03-6][1-8]|[1278][1-9])|7(?:[48][1-7]|[025][1-9]|3[1-6]|7[2-8]|6[02-9]|1[1-35-9])|6(?:[1-467][1-9]|[05]\d|8[1-8])|1(?:1[1-6]|0[1-3])|2(?:[0-467]1|5[12])|8(?:11|0[1-9])|90[1-6]|50[12]|000)|8(?:0(?:5[1-7]|4[1-4]|[16][1-8]|[237][1-6]|0[1-3])|1(?:6[1-6]|4[1-3]|[0135][1-7]|2[1-5])|2(?:[12][1-8]|[045][1-4]|3[1-7]))|1(?:4(?:[268][1-9]|1[1-7]|0\d|7[1-8]|[3-5][1-6])|2(?:3[12]|4[1-8])|8(?:1[1-5]|0[1-4])|6(?:00|3[1-6])|3(?:21|0[1-4])|10[1-8]|72[1-4]|501)|2(?:1(?:0[12]|5[1-8])|2(?:51|6[1-3]))))',
    '961' => '(?:(?:0(?:0(?:0[0-5]|[1248][1-7]|3[1-9]|6[1-6]|7[1-8]|[59][1-4])|9(?:0[1-8]|[289][1-6]|[67][1-5]|[13-5][1-7])|8(?:4[1-6]|[38][1-8]|2[1-9]|[156][1-7]|[07][1-5])|4(?:0[1-9]|1[1-6])|30[1-9]|10[0-6])|80(?:[1-36-9]1|5[1-6]|0[12]|4[1-7])))',
    '962' => '(?:0(?:8(?:[35][1-9]|[02][1-7]|[146][1-8])|0(?:[14][1-7]|5[1-9]|0[0-7]|2[1-8]|3[1-6])|7(?:1[1-4]|2[1-8])|5(?:1[1-6]|0[0-4])|3(?:[01][1-5])|2(?:11|0[1-5])|12[1-6]|40[1-6]|62[1-3]))',
    '963' => '(?:(?:8(?:8(?:5[12]|[06][1-7]|2[1-9]|4[1-6]|[137][1-8])|0(?:[67]1|[01][1-8]|[24][1-6]|5[12]|3[1-9])|1(?:00|1[1-6])|30[0-8]|40[0-8]|20[1-7])|7(?:8(?:[1-3][1-8]|[78][1-6]|[45][1-9]|6[1-7]|0[0-8])|7(?:[14-6][1-9]|0\d|[37][1-3]|[28][1-6]))|0(?:1(?:1[1-5]|[02][1-9])|2(?:21|1[1-6]|0[1-9]|3[12])|7(?:[01][1-4]|2[1-6])|9(?:2[1-5]|[01][1-4])|5(?:51|4[1-7]|3[1-4])|6(?:7[1-3]|6[1-7])|83[1-7]|000)|5(?:6(?:6[1-4]|8[1-5]|7[12])|5(?:05|2[12]|3[1-9])|1(?:00|1[1-9])|4(?:11|0[0-8])|3(?:4[1-4]|2[1-3])|20[1-3])|6(?:1(?:31|[25][1-3]|4[1-7]|1[1-5]|0[0-6])|2(?:0[0-8]|1[1-8])|3(?:1[1-6]|0[0-6]))|4(?:3(?:00|1[1-8]|2[1-4])|6(?:1[1-4]|0[1-6])|43[1-6]|11[1-5]|20[1-5]|54[1-5]|70[12])|1(?:1(?:5[1-6]|6[1-5])|30[1-9]|24[1-8]|41[1-4]|63[1-3]|52[12])|3(?:40[0-6]|31[1-6]|52[1-5]|60[1-3])))',
    '964' => '(?:0(?:8(?:8[1-7]|[24-6][1-9]|[0139][1-8]|7[1-6])|9(?:[24][1-9]|[0189][1-7]|[67][1-6]|[35][1-8])|0(?:91|6[1-6]|[58][1-8]|0[0-8]|[2-4][1-9]|[17][1-7])|3(?:21|1[1-6]|0[1-4])|20[1-3]|43[1-3]|111))',
    '965' => '(?:0(?:8(?:[46][1-7]|[05][1-9]|[127][1-8]|3\d)|0(?:[57][1-9]|2[1-7]|[068]\d|[34][1-8]|1[1-6])|1(?:0[1-37]|1[0-8]|2[146-9]|3[1-6])|20[1-5]))',
    '966' => '(?:0(?:0(?:[27][1-4]|5[1-8]|0[0-7]|[189][1-7]|[346][1-9])|8(?:[1346][1-9]|2[1-7]|8[1247]|9[1-689]|5\d|0[1-6]|7[1-57])|9(?:3[1-3]|[02][1-4]|1[1-5])|10[1-8]|40[0-5]|501))',
    '967' => '(?:0(?:3(?:1[1-57-9]|[04][1-7]|2[1-4]|3[1-6])|5(?:2[1-8]|0[0-7]|1[1-5]|3[12])|0(?:[12][1-6]|0[0-7])|6(?:11|[24][12]|0[1-5]|3[1-4])))',
    '968' => '(?:0(?:4(?:00|[14][1-5]|3[1-4]|2[1-3])|0(?:0[0-6]|1[1-6])|60[1-7]|32[1-6]|10[0-4]|21[1-5]))',
    '969' => '(?:(?:6(?:0(?:[25-7][1-9]|[48][1-7]|1[1-35]|[03][1-8])|5(?:7[1-6]|2[1-8]|[134][1-9]|[568][1-7]|0[0-7])|1(?:5[124-9]|7[1-7]|[0-2][1-9]|3[1-5]|[46][1-6]|8[02-689])|2(?:6[1-8]|7[1-4]|[25][1-6]|0[0-7]|[14][1-5]|3[12])|3(?:0[1-7]|[1-3][1-8]|5[1-6]|4[1-3])|4(?:11|0[1-9]))|1(?:1(?:[1-6][1-9]|7[1-6]|0[013-9])|6(?:[46][1-3]|5[1-4]|0[0-8]|3[1-5]|[12][1-9])|7(?:[3-7]1|2[12]|1[1-4]|8\d|0[01])|20[1-6]|40[1-5]|30[0-2]|51[1-3])|3(?:5(?:0[0-6]|2[1-7]|3[1-9]|1[1-5]|[45][1-6])|4(?:[3-57]1|6[1-4]|[0-28][12])|1(?:41|[1-3][1-3]|0[0-3])|28[1-8]|30[0-4])|4(?:1(?:[0134][1-9]|[256][1-7])|3(?:1[1-6]|0[1-4])|40[0-6]|73[1-7]|51[1-5]|62[1-4])|0(?:2(?:1[1-3]|[3-68][1-8]|2[1-7]|7[12]|0[0-6])|30[1-9]|10[0-6]|40[0-4])|5(?:3(?:00|1[1-8]|2[1-6]|[34][1-5])|1(?:4[1-7]|1[1-4]|[23][1-3])|20[1-8])|7(?:3(?:2[1-6]|1[1-5])|5(?:00|1[1-9])|4(?:13|0[1-7])|20\d)|2(?:7(?:01|5[12])|27[1-5]|66[1-3])))',
    '970' => '(?:(?:80(?:3[1-6]|5[1-4]|[0-2][1-8]|4[1-7])|0(?:1(?:1[1-6]|0[1-7])|22[1-8]|31[1-7]|000)|1(?:1(?:5[1-3]|4[1-7])|3(?:61|7[1-7])|26[1-4])))',
    '971' => '(?:81(?:4[1-6]|8[1-8]|[36][1-9]|2[1-7]|[0157][12]))',
    '972' => '(?:(?:83(?:01|2[1-6]|[13][1-8])|0(?:16[1-4]|25[1-3])))',
    '973' => '(?:84(?:1[12]|0[1-9]))',
    '974' => '(?:(?:82(?:61|[45][12]|[1-3][1-3]|0[1-4])|0(?:2(?:52|4[1-3])|15[1-3])))',
    '975' => '(?:00(?:0[0-8]|[3-57][1-9]|2[1-7]|6[1-4]|1[1-8]))',
    '976' => '(?:0(?:0(?:5[1-3]|[12][1-6]|4[12]|3[1-7]|0[0-7])|15[1-4]))',
    '979' => '(?:(?:1(?:4(?:[2356][1-3]|[147][12]|0[0-2])|5(?:[23][1-6]|1[1-3]|4[1-5]|0[0-6])|1(?:[47]1|0[01]|[1-356][12])|7(?:06|5[1-7])|30[0-8]|60[0-4]|20[0-2])|2(?:1(?:[023][1-4]|[167][1-5]|[45][1-7])|3(?:3[1-6]|[12][1-4]|0[1-5])|5(?:01|[124][12]|3[1-3])|4(?:[4-6][1-4])|70[0-8]|611)|0(?:2(?:[02][1-7]|1[1-6])|1(?:4[1-7]|5[1-5])|6(?:22|0[0-6])|40[0-8]|33[1-8]|51[1-5])|3(?:1(?:[12][1-5]|3[12])|20[1-4])))',
    '980' => '(?:(?:0(?:8(?:45|5[1-6]|[27][1-4]|[01][1-5]|6[1-7])|0(?:65|2[1-3]|1[1-4]|0[0-5]))|6(?:1(?:90|0[1-9]|[12]\d|3[01])|0(?:[39]0|[12]\d|0[1-9]))))',
    '981' => '(?:(?:4(?:3(?:6[1-8]|5[1-6]|7[1-5]|2[1-9]|[0134][1-7])|2(?:1[1-3]|5[1-6]|0[0-3]|[36][1-5]|4[12]|2[1-9]|7[1-7])|1(?:[3-5]1|[12][12]|0[0-5])|4(?:1[1-9]|0[1-3]))|3(?:3(?:41|2[1-9]|[135][12]|0[0-6]|6[1-3])|1(?:[13][1-7]|2[1-6]|0\d)|2(?:71|[02][1-6]|1[1-7])|4(?:[01][1-9])|5(?:2[1-4]|0[0-3]|1[1-5])|6(?:11|0\d|2[1-9]))|0(?:9(?:[16][1-7]|4[1-5]|3[1-6]|0[1-8]|[25][1-4])|1(?:0[0-5]|1[1-3]|3[1-6]|2[1-4])|2(?:0[0-5]|1[1-5])|30[1-9]|50[0-5]|41[1-5])|2(?:1(?:0[0-6]|[128][1-7]|[45][1-6]|6[1-8]|[37][1-4])|30[1-3]|40[12]|[25]01)|1(?:2(?:51|2[1-7]|3\d|[14][1-8]|0[01])|5(?:0[0-5]|2[1-6]|3[1-4]|1[1-8])|10[1-7])|800[1-7]))',
    '982' => '(?:0(?:8(?:2[1-6]|[14][1-8]|[03][1-7])|0(?:0[0-7]|2[1-7]|1[1-5]|3[1-6])|2(?:31|6[1-3]|[14][1-5]|[25][12])))',
    '983' => '(?:0(?:8(?:03|6[1-6]|2[1-68]|4[1-5]|[15][1-7]|3[1-9])|0(?:1[1-4]|2[13-6]|4[1-7]|3[1-9]|0[0-7])))',
    '984' => '(?:0(?:0(?:22|0[0-4]|[167][1-5]|[3-5][1-8])|8(?:4[1-5]|[01][1-7]|[23][1-8])))',
    '985' => '(?:0(?:0(?:0[0-6]|[5-7][1-7]|[1-4][1-6]|8[1-8])|8(?:1[1-3]|4[1-6]|[257][1-4]|[036][1-5])|19[1-5]|901))',
    '986' => '(?:(?:0(?:8(?:[45][1-9]|1[1-5]|0[1-356]|[2367][1-8])|7(?:0\d|[16][1-8]|5[1-4]|[34][1-3]|8[12]|[27][1-9])|0(?:0[0-6]|[34][1-3]|1[135-7]|2[1-8])|1(?:0[1-6]|2[1-4]|3[12]|1[1-5])|3(?:0[1-5]|[12][1-4])|20[1-4]|40[12])|2(?:2(?:[5-7]1|2[1-6]|4[1-5]|[138][12]|0[0-5])|1(?:2[1-3]|[13][1-6]|0[1-5])|3(?:4[1-7]|5[1-5])|4(?:1[1-5]|0[1-6])|52[1-7])|1(?:3(?:0[1-4]|1[1-3]|3[1-6]|2[12])|111)))',
    '987' => '(?:(?:2(?:3(?:7[1-4]|[0-6][1-9])|1(?:[47][1-7]|[58][1-9]|3[1-3]|1[1-6]|6[1-4]|2[1-8])|2(?:0[0-5]|4[1-7]|[67][1-5]|[13][1-6]|5[1-3]|2[1-8])|0(?:[045][1-5]|[12][1-8]|3[1-6])|51[12])|0(?:0(?:2[124-6]|[56][1-9]|1[1-5]|0[0-6]|4[1-6]|3[1-8])|3(?:[1-3]1|8[1-5]|[057][1-9]|6[1-8]|4[1-6])|1(?:[25]1|0[0-7]|[16][1-5]|7[12]|[34]\d)|4(?:[01][1-5]|4[1-7]|3[1-3]|2[1-6])|6(?:11|2[1-3]|0[12])|5(?:00|1[1-3])|28[1-6]|70[1-4]|90[1-3])|1(?:30[1-6]|10[1-3]|22[12])))',
    '988' => '(?:0(?:3(?:[124][1-8]|7[1-5]|[0358][1-9]|6[1-7])|2(?:[0248][1-7]|[67][1-9]|1[1-5]|3[1-8]|5[1-6])|0(?:[78][1-7]|3[1-467]|0[0-8]|[15][1-8]|[246][1-6])|4(?:[47][1-8]|[0235][1-6]|6[1-7]|1[1-5])|1(?:[1-47][1-4]|[08][1-5]|5[1-7]|6[1-9])|8(?:[16][1-8]|2[1-9]|[034][1-7]|5[1-5])|5(?:[145][1-4]|0[1-6]|6[1-3]|2[1-7]|[78][12]|3[1-5])|6(?:3[1-4]|[12][1-3]|0[1-7])|927))',
    '989' => '(?:(?:6(?:1(?:0[0-6]|[47][1-5]|[156][1-7]|3[1-6]|2[1-8])|2(?:5[1-5]|1[1-7]|[02][1-8]|4[1-4]|[36][1-6])|4(?:71|[01][1-5]|[34][1-7]|[26][1-6])|8(?:11|3[1-8]|[02][1-7])|3(?:0[1-6]|1[1-7]|2[12])|7(?:01|1[12])|941)|0(?:2(?:3[1-3]|[1467][1-8]|2\d|0[0-8]|5[1-9])|5(?:61|0[0-8]|[35][1-7]|[124][1-9])|6(?:[16][1-7]|0[12]|3[1-6]|4[1-4]|[25][1-8])|9(?:21|1[1-6]|0[18])|8(?:[235]1|00|4[1-3])|7(?:01|3[1-4])|11[1-3])|1(?:2(?:2[1-5]|[13][1-7]|0[0-7]|[45][1-9]|7[1-4]|6[13467])|7(?:31|6[1-5]|4[1-6]|5[1-8])|6(?:31|0[0-8]|[12][1-3])|3(?:11|0[0-5]|2[1-3])|5(?:11|0[0-7])|10[1-4])|5(?:1(?:1[1-9]|5[1-5]|[46][1-6]|7[1-3]|2[1-8]|3\d|8[13-5])|3(?:[04-6]1|2[1-4]|[178][12]|3[1-5])|6(?:1\d|2[1-7]|0[1-9])|50[1-8]|40[1-3])|4(?:5(?:6[0-24-9]|[23][1-9]|5[1-7]|0[3-9]|[1478]\d)|20[1-9]|41[1-9]|30[1-8]|10[1-6]|80[235-8]|70[1-3]|601)|2(?:4(?:[24][1-8]|0[01]|1[12]|6[1-5]|[37][1-7]|5[1-9])|3(?:[1346]1|[57][12]|8[1-5]|0[0-3]|2[1-4])|20[0-7]|11[12])|3(?:2(?:0[1-7]|1[1-6])|12[1-8]|43[1-4])))',
    '990' => '(?:(?:0(?:8(?:7[0-24-9]|1[0-57-9]|[02459][1-9]|[38][1-6]|6\d)|0(?:[16][1-8]|2[1-5]|3[1-9]|[457][1-7]|0[0-8])|3(?:61|[23][1-3]|0[0-3]|[145][12])|7(?:21|1[1-4]|4[1-3]|3[1-5]|0[0-3])|5(?:61|[02][1-5]|1[1-3])|4(?:11|0\d))|2(?:3(?:2[1-4]|[07][1-8]|[48][1-6]|5[1-5]|[16][1-7]|3[1-57-9])|4(?:0[1-6]|2[1-3]|[18][1-4]|5[135]|[47][1-7]|[369][1-5])|2(?:51|3[1-5]|4[12]|2[1-7]|1[1-6])|1(?:6[1-4]|7[1-5]))|1(?:1(?:4[1-6]|0[01]|[135][1-4]|6[1-5]|2[12])|4(?:00|[24][1-4]|3[1-3]|1[12])|5(?:[56][1-3]|7[1-4])|27[1-6]|30[1-6])))',
    '991' => '(?:0(?:0(?:3[1-5]|4[1-9]|5[1-7]|0[0-8]|2[1-8]|1[1-3]|6[1-6])|801))',
    '992' => '(?:(?:0(?:0(?:[69][1-6]|[35][1-9]|[12478][1-7]|0[0-5])|3(?:0[0-2]|[1-3][1-5]|5[12]|4[1-4])|8(?:[24]1|6[1-4]|[135][12]|0[0-2])|11[1-9]|47[1-9]|77[1-9]|26[1-5]|58[1-4]|60[1-3])|1(?:4(?:06|6[12]|5[1-5]|7[1-4]|4[1-6])|12[1-8]|20[1-6]|3(?:03|31)|58[1-3])))',
    '993' => '(?:00(?:0[0-7]|[18][1-7]|4[12]|[37][1-5]|[256][1-4]))',
    '994' => '(?:0(?:0(?:81|[467][1-9]|5[1-7]|0[0-7]|3[1-4]|2[1-8]|1[1-6])|10[1-4]))',
    '995' => '(?:0(?:0(?:0[0-6]|2[1-5]|4[12]|5[1-6]|[13][1-8])|20[1-9]|11[1-3]))',
    '996' => '(?:0(?:0(?:[1469]1|[28][1-8]|5[1-4]|0[0-2]|7[1-9]|3[1-5])|2(?:1[1-3]|0[01])|11[12]|301))',
    '997' => '(?:(?:0(?:8(?:[013][1-9]|[25][1-7]|6[12]|4[1-8])|1(?:17|31|[05][1-8]|4[1-3]|[26][1-7])|0(?:[24][1-9]|3[1-7]|[01]\d|5[1-8])|3(?:[15]1|6[1-9]|4[1-6]|[02][1-3]|3[1-4])|4(?:[01][1-5])|75[1-8]|62[1-6]|53[12]|211)|1(?:3(?:2[12]|1[1-7]|3[1-9]|0[01])|1(?:56|1[1-7]|[23][1-5])|20[1-6])))',
    '998' => '(?:0(?:8(?:6[1-5]|[15][1-9]|2[1-46-9]|4[1-3]|0[1-6]|[37][1-8])|0(?:[57][1-5]|2[1-9]|3[1-7]|0[0-6]|4[1-6]|6[1-4]|1[1-8])|1(?:25|0[1-5]|1[1-4])|281))',
    '999' => '(?:(?:3(?:1(?:5[1-8]|[24][1-6]|[13][1-5]|7[12]|6[1-7]|0[0-7])|7(?:[68][1-6]|[0-27]\d|3[0-8]|4[1-9]|5[1-7])|2(?:[13][1-7]|[24][1-6]|0[1-4])|5(?:3[1-3]|1[1-5]|2[12]|0[0-3])|301)|7(?:7(?:1[1-5]|8[12]|4[1-9]|[2357][1-7]|0[0-7]|6[1-8])|6(?:11|4[1-6]|5[1-3]|3[1-8]|6[1-4]|7[1-7]|8[1-5]|2[12]|0[124])|54[1-8]|20[1-7]|12[1-6]|31[1-6]|46[1-4])|1(?:3(?:[12][1-4]|[45][1-6]|6[1-3]|3[1-9]|0[0-3])|4(?:[025][12]|3[1-6]|4[1-3]|1[1-4])|5(?:0[1-7]|2[12]|1[1-4])|2(?:1[1-6]|0[1-3])|11[1-3])|6(?:8(?:01|6[12]|3[1-9]|2[1-7]|5[1-3]|1[1-6]|4[1-8])|7(?:41|1[12]|3[1-5]|2[1-7]|0[1-8])|6(?:52|0[1-9])|10[0-7]|21[1-5]|31[1-5]|40[0-3])|8(?:2(?:[02][1-7]|[13][1-5]|4[1-6])|1(?:[56][1-8]|3[1-4]|4[1-5])|3(?:1[1-7]|0[0-4])|4(?:3[1-8]|2[1-3])|5(?:31|2[1-5]))|4(?:2(?:2[1-9]|3[12]|0[0-8]|1[1-4])|1(?:41|1[1-6]|3[1-4]|0[0-3]|2[12])|3(?:04|3[1-7])|55[1-7]|60[0-5]|44[1-5])|0(?:1(?:00|2[12]|4[1-5]|5[1-3]|3[1-4])|4(?:2[1-7]|3[1-6])|60[0-6]|21[1-4]|361)|5(?:4(?:1[1-5]|0[0-6])|3(?:1[1-4]|0[01])|1(?:91|0[1-3])|20[0-8]|60[1-4]|52[12])|2(?:2(?:0[0-5]|6[1-7]|5[1-6]|1[1-3]|[2-4][1-4])|17[1-9])))',
);

1;
__END__
