use strict;
use Test::More tests => 124771;

use_ok('Number::ZipCode::JP', 'area');

my $zip = Number::ZipCode::JP->new;
ok($zip->set_number('0010000')->is_valid_number, '北海道札幌市北区以下に掲載がない場合');
ok($zip->set_number('0010010')->is_valid_number, '北海道札幌市北区北十条西(1~4丁目)');
ok($zip->set_number('0010011')->is_valid_number, '北海道札幌市北区北十一条西(1~4丁目)');
ok($zip->set_number('0010012')->is_valid_number, '北海道札幌市北区北十二条西(1~4丁目)');
ok($zip->set_number('0010013')->is_valid_number, '北海道札幌市北区北十三条西(1~4丁目)');
ok($zip->set_number('0010014')->is_valid_number, '北海道札幌市北区北十四条西(1~4丁目)');
ok($zip->set_number('0010015')->is_valid_number, '北海道札幌市北区北十五条西(1~5丁目)');
ok($zip->set_number('0010016')->is_valid_number, '北海道札幌市北区北十六条西(1~6丁目)');
ok($zip->set_number('0010017')->is_valid_number, '北海道札幌市北区北十七条西(1~6丁目)');
ok($zip->set_number('0010018')->is_valid_number, '北海道札幌市北区北十八条西(1~7丁目)');
ok($zip->set_number('0010019')->is_valid_number, '北海道札幌市北区北十九条西(2~7丁目)');
ok($zip->set_number('0010020')->is_valid_number, '北海道札幌市北区北二十条西(2~10丁目)');
ok($zip->set_number('0010021')->is_valid_number, '北海道札幌市北区北二十一条西');
ok($zip->set_number('0010022')->is_valid_number, '北海道札幌市北区北二十二条西');
ok($zip->set_number('0010023')->is_valid_number, '北海道札幌市北区北二十三条西');
ok($zip->set_number('0010024')->is_valid_number, '北海道札幌市北区北二十四条西');
ok($zip->set_number('0010025')->is_valid_number, '北海道札幌市北区北二十五条西');
ok($zip->set_number('0010026')->is_valid_number, '北海道札幌市北区北二十六条西');
ok($zip->set_number('0010027')->is_valid_number, '北海道札幌市北区北二十七条西');
ok($zip->set_number('0010028')->is_valid_number, '北海道札幌市北区北二十八条西');
ok($zip->set_number('0010029')->is_valid_number, '北海道札幌市北区北二十九条西');
ok($zip->set_number('0010030')->is_valid_number, '北海道札幌市北区北三十条西');
ok($zip->set_number('0010031')->is_valid_number, '北海道札幌市北区北三十一条西');
ok($zip->set_number('0010032')->is_valid_number, '北海道札幌市北区北三十二条西');
ok($zip->set_number('0010033')->is_valid_number, '北海道札幌市北区北三十三条西');
ok($zip->set_number('0010034')->is_valid_number, '北海道札幌市北区北三十四条西');
ok($zip->set_number('0010035')->is_valid_number, '北海道札幌市北区北三十五条西');
ok($zip->set_number('0010036')->is_valid_number, '北海道札幌市北区北三十六条西');
ok($zip->set_number('0010037')->is_valid_number, '北海道札幌市北区北三十七条西');
ok($zip->set_number('0010038')->is_valid_number, '北海道札幌市北区北三十八条西');
ok($zip->set_number('0010039')->is_valid_number, '北海道札幌市北区北三十九条西');
ok($zip->set_number('0010040')->is_valid_number, '北海道札幌市北区北四十条西');
ok($zip->set_number('0010045')->is_valid_number, '北海道札幌市北区麻生町');
ok($zip->set_number('0010901')->is_valid_number, '北海道札幌市北区新琴似一条');
ok($zip->set_number('0010902')->is_valid_number, '北海道札幌市北区新琴似二条');
ok($zip->set_number('0010903')->is_valid_number, '北海道札幌市北区新琴似三条');
ok($zip->set_number('0010904')->is_valid_number, '北海道札幌市北区新琴似四条');
ok($zip->set_number('0010905')->is_valid_number, '北海道札幌市北区新琴似五条');
ok($zip->set_number('0010906')->is_valid_number, '北海道札幌市北区新琴似六条');
ok($zip->set_number('0010907')->is_valid_number, '北海道札幌市北区新琴似七条');
ok($zip->set_number('0010908')->is_valid_number, '北海道札幌市北区新琴似八条');
ok($zip->set_number('0010909')->is_valid_number, '北海道札幌市北区新琴似九条');
ok($zip->set_number('0010910')->is_valid_number, '北海道札幌市北区新琴似十条');
ok($zip->set_number('0010911')->is_valid_number, '北海道札幌市北区新琴似十一条');
ok($zip->set_number('0010912')->is_valid_number, '北海道札幌市北区新琴似十二条');
ok($zip->set_number('0010915')->is_valid_number, '北海道札幌市北区新琴似町');
ok($zip->set_number('0010921')->is_valid_number, '北海道札幌市北区新川一条');
ok($zip->set_number('0010922')->is_valid_number, '北海道札幌市北区新川二条');
ok($zip->set_number('0010923')->is_valid_number, '北海道札幌市北区新川三条');
ok($zip->set_number('0010924')->is_valid_number, '北海道札幌市北区新川四条');
ok($zip->set_number('0010925')->is_valid_number, '北海道札幌市北区新川五条');
ok($zip->set_number('0010926')->is_valid_number, '北海道札幌市北区新川六条');
ok($zip->set_number('0010927')->is_valid_number, '北海道札幌市北区新川七条');
ok($zip->set_number('0010928')->is_valid_number, '北海道札幌市北区新川八条');
ok($zip->set_number('0010930')->is_valid_number, '北海道札幌市北区新川');
ok($zip->set_number('0010931')->is_valid_number, '北海道札幌市北区新川西一条');
ok($zip->set_number('0010932')->is_valid_number, '北海道札幌市北区新川西二条');
ok($zip->set_number('0010933')->is_valid_number, '北海道札幌市北区新川西三条');
ok($zip->set_number('0010934')->is_valid_number, '北海道札幌市北区新川西四条');
ok($zip->set_number('0010935')->is_valid_number, '北海道札幌市北区新川西五条');
ok($zip->set_number('0020851')->is_valid_number, '北海道札幌市北区屯田一条');
ok($zip->set_number('0020852')->is_valid_number, '北海道札幌市北区屯田二条');
ok($zip->set_number('0020853')->is_valid_number, '北海道札幌市北区屯田三条');
ok($zip->set_number('0020854')->is_valid_number, '北海道札幌市北区屯田四条');
ok($zip->set_number('0020855')->is_valid_number, '北海道札幌市北区屯田五条');
ok($zip->set_number('0020856')->is_valid_number, '北海道札幌市北区屯田六条');
ok($zip->set_number('0020857')->is_valid_number, '北海道札幌市北区屯田七条');
ok($zip->set_number('0020858')->is_valid_number, '北海道札幌市北区屯田八条');
ok($zip->set_number('0020859')->is_valid_number, '北海道札幌市北区屯田九条');
ok($zip->set_number('0020860')->is_valid_number, '北海道札幌市北区屯田十条');
ok($zip->set_number('0020861')->is_valid_number, '北海道札幌市北区屯田十一条');
ok($zip->set_number('0020865')->is_valid_number, '北海道札幌市北区屯田町');
ok($zip->set_number('0028001')->is_valid_number, '北海道札幌市北区太平一条');
ok($zip->set_number('0028002')->is_valid_number, '北海道札幌市北区太平二条');
ok($zip->set_number('0028003')->is_valid_number, '北海道札幌市北区太平三条');
ok($zip->set_number('0028004')->is_valid_number, '北海道札幌市北区太平四条');
ok($zip->set_number('0028005')->is_valid_number, '北海道札幌市北区太平五条');
ok($zip->set_number('0028006')->is_valid_number, '北海道札幌市北区太平六条');
ok($zip->set_number('0028007')->is_valid_number, '北海道札幌市北区太平七条');
ok($zip->set_number('0028008')->is_valid_number, '北海道札幌市北区太平八条');
ok($zip->set_number('0028009')->is_valid_number, '北海道札幌市北区太平九条');
ok($zip->set_number('0028010')->is_valid_number, '北海道札幌市北区太平十条');
ok($zip->set_number('0028011')->is_valid_number, '北海道札幌市北区太平十一条');
ok($zip->set_number('0028012')->is_valid_number, '北海道札幌市北区太平十二条');
ok($zip->set_number('0028021')->is_valid_number, '北海道札幌市北区篠路一条');
ok($zip->set_number('0028022')->is_valid_number, '北海道札幌市北区篠路二条');
ok($zip->set_number('0028023')->is_valid_number, '北海道札幌市北区篠路三条');
ok($zip->set_number('0028024')->is_valid_number, '北海道札幌市北区篠路四条');
ok($zip->set_number('0028025')->is_valid_number, '北海道札幌市北区篠路五条');
ok($zip->set_number('0028026')->is_valid_number, '北海道札幌市北区篠路六条');
ok($zip->set_number('0028027')->is_valid_number, '北海道札幌市北区篠路七条');
ok($zip->set_number('0028028')->is_valid_number, '北海道札幌市北区篠路八条');
ok($zip->set_number('0028029')->is_valid_number, '北海道札幌市北区篠路九条');
ok($zip->set_number('0028030')->is_valid_number, '北海道札幌市北区篠路十条');
ok($zip->set_number('0028031')->is_valid_number, '北海道札幌市北区西茨戸一条');
ok($zip->set_number('0028032')->is_valid_number, '北海道札幌市北区西茨戸二条');
ok($zip->set_number('0028033')->is_valid_number, '北海道札幌市北区西茨戸三条');
ok($zip->set_number('0028034')->is_valid_number, '北海道札幌市北区西茨戸四条');
ok($zip->set_number('0028035')->is_valid_number, '北海道札幌市北区西茨戸五条');
ok($zip->set_number('0028036')->is_valid_number, '北海道札幌市北区西茨戸六条');
ok($zip->set_number('0028037')->is_valid_number, '北海道札幌市北区西茨戸七条');
ok($zip->set_number('0028038')->is_valid_number, '北海道札幌市北区西茨戸');
ok($zip->set_number('0028041')->is_valid_number, '北海道札幌市北区東茨戸一条');
ok($zip->set_number('0028042')->is_valid_number, '北海道札幌市北区東茨戸二条');
ok($zip->set_number('0028043')->is_valid_number, '北海道札幌市北区東茨戸');
ok($zip->set_number('0028044')->is_valid_number, '北海道札幌市北区東茨戸三条');
ok($zip->set_number('0028045')->is_valid_number, '北海道札幌市北区東茨戸四条');
ok($zip->set_number('0028051')->is_valid_number, '北海道札幌市北区篠路町太平');
ok($zip->set_number('0028052')->is_valid_number, '北海道札幌市北区篠路町上篠路');
ok($zip->set_number('0028053')->is_valid_number, '北海道札幌市北区篠路町篠路');
ok($zip->set_number('0028054')->is_valid_number, '北海道札幌市北区篠路町拓北');
ok($zip->set_number('0028055')->is_valid_number, '北海道札幌市北区篠路町福移');
ok($zip->set_number('0028061')->is_valid_number, '北海道札幌市北区拓北一条');
ok($zip->set_number('0028062')->is_valid_number, '北海道札幌市北区拓北二条');
ok($zip->set_number('0028063')->is_valid_number, '北海道札幌市北区拓北三条');
ok($zip->set_number('0028064')->is_valid_number, '北海道札幌市北区拓北四条');
ok($zip->set_number('0028065')->is_valid_number, '北海道札幌市北区拓北五条');
ok($zip->set_number('0028066')->is_valid_number, '北海道札幌市北区拓北六条');
ok($zip->set_number('0028067')->is_valid_number, '北海道札幌市北区拓北七条');
ok($zip->set_number('0028068')->is_valid_number, '北海道札幌市北区拓北八条');
ok($zip->set_number('0028071')->is_valid_number, '北海道札幌市北区あいの里一条');
ok($zip->set_number('0028072')->is_valid_number, '北海道札幌市北区あいの里二条');
ok($zip->set_number('0028073')->is_valid_number, '北海道札幌市北区あいの里三条');
ok($zip->set_number('0028074')->is_valid_number, '北海道札幌市北区あいの里四条');
ok($zip->set_number('0028075')->is_valid_number, '北海道札幌市北区あいの里五条');
ok($zip->set_number('0028081')->is_valid_number, '北海道札幌市北区百合が原');
ok($zip->set_number('0028082')->is_valid_number, '北海道札幌市北区百合が原公園');
ok($zip->set_number('0028089')->is_valid_number, '北海道石狩郡当別町ビトエ(中島)');
ok($zip->set_number('0028091')->is_valid_number, '北海道札幌市北区南あいの里');
ok($zip->set_number('0030000')->is_valid_number, '北海道札幌市白石区以下に掲載がない場合');
ok($zip->set_number('0030001')->is_valid_number, '北海道札幌市白石区東札幌一条');
ok($zip->set_number('0030002')->is_valid_number, '北海道札幌市白石区東札幌二条');
ok($zip->set_number('0030003')->is_valid_number, '北海道札幌市白石区東札幌三条');
ok($zip->set_number('0030004')->is_valid_number, '北海道札幌市白石区東札幌四条');
ok($zip->set_number('0030005')->is_valid_number, '北海道札幌市白石区東札幌五条');
ok($zip->set_number('0030006')->is_valid_number, '北海道札幌市白石区東札幌六条');
ok($zip->set_number('0030011')->is_valid_number, '北海道札幌市白石区中央一条');
ok($zip->set_number('0030012')->is_valid_number, '北海道札幌市白石区中央二条');
ok($zip->set_number('0030013')->is_valid_number, '北海道札幌市白石区中央三条');
ok($zip->set_number('0030021')->is_valid_number, '北海道札幌市白石区栄通');
ok($zip->set_number('0030022')->is_valid_number, '北海道札幌市白石区南郷通(南)');
ok($zip->set_number('0030023')->is_valid_number, '北海道札幌市白石区南郷通(北)');
ok($zip->set_number('0030024')->is_valid_number, '北海道札幌市白石区本郷通(南)');
ok($zip->set_number('0030025')->is_valid_number, '北海道札幌市白石区本郷通(北)');
ok($zip->set_number('0030026')->is_valid_number, '北海道札幌市白石区本通(南)');
ok($zip->set_number('0030027')->is_valid_number, '北海道札幌市白石区本通(北)');
ok($zip->set_number('0030028')->is_valid_number, '北海道札幌市白石区平和通(南)');
ok($zip->set_number('0030029')->is_valid_number, '北海道札幌市白石区平和通(北)');
ok($zip->set_number('0030030')->is_valid_number, '北海道札幌市白石区流通センター');
ok($zip->set_number('0030801')->is_valid_number, '北海道札幌市白石区菊水一条');
ok($zip->set_number('0030802')->is_valid_number, '北海道札幌市白石区菊水二条');
ok($zip->set_number('0030803')->is_valid_number, '北海道札幌市白石区菊水三条');
ok($zip->set_number('0030804')->is_valid_number, '北海道札幌市白石区菊水四条');
ok($zip->set_number('0030805')->is_valid_number, '北海道札幌市白石区菊水五条');
ok($zip->set_number('0030806')->is_valid_number, '北海道札幌市白石区菊水六条');
ok($zip->set_number('0030807')->is_valid_number, '北海道札幌市白石区菊水七条');
ok($zip->set_number('0030808')->is_valid_number, '北海道札幌市白石区菊水八条');
ok($zip->set_number('0030809')->is_valid_number, '北海道札幌市白石区菊水九条');
ok($zip->set_number('0030811')->is_valid_number, '北海道札幌市白石区菊水上町一条');
ok($zip->set_number('0030812')->is_valid_number, '北海道札幌市白石区菊水上町二条');
ok($zip->set_number('0030813')->is_valid_number, '北海道札幌市白石区菊水上町三条');
ok($zip->set_number('0030814')->is_valid_number, '北海道札幌市白石区菊水上町四条');
ok($zip->set_number('0030821')->is_valid_number, '北海道札幌市白石区菊水元町一条');
ok($zip->set_number('0030822')->is_valid_number, '北海道札幌市白石区菊水元町二条');
ok($zip->set_number('0030823')->is_valid_number, '北海道札幌市白石区菊水元町三条');
ok($zip->set_number('0030824')->is_valid_number, '北海道札幌市白石区菊水元町四条');
ok($zip->set_number('0030825')->is_valid_number, '北海道札幌市白石区菊水元町五条');
ok($zip->set_number('0030826')->is_valid_number, '北海道札幌市白石区菊水元町六条');
ok($zip->set_number('0030827')->is_valid_number, '北海道札幌市白石区菊水元町七条');
ok($zip->set_number('0030828')->is_valid_number, '北海道札幌市白石区菊水元町八条');
ok($zip->set_number('0030829')->is_valid_number, '北海道札幌市白石区菊水元町九条');
ok($zip->set_number('0030830')->is_valid_number, '北海道札幌市白石区菊水元町十条');
ok($zip->set_number('0030831')->is_valid_number, '北海道札幌市白石区北郷一条');
ok($zip->set_number('0030832')->is_valid_number, '北海道札幌市白石区北郷二条');
ok($zip->set_number('0030833')->is_valid_number, '北海道札幌市白石区北郷三条');
ok($zip->set_number('0030834')->is_valid_number, '北海道札幌市白石区北郷四条');
ok($zip->set_number('0030835')->is_valid_number, '北海道札幌市白石区北郷五条');
ok($zip->set_number('0030836')->is_valid_number, '北海道札幌市白石区北郷六条');
ok($zip->set_number('0030837')->is_valid_number, '北海道札幌市白石区北郷七条');
ok($zip->set_number('0030838')->is_valid_number, '北海道札幌市白石区北郷八条');
ok($zip->set_number('0030839')->is_valid_number, '北海道札幌市白石区北郷九条');
ok($zip->set_number('0030840')->is_valid_number, '北海道札幌市白石区北郷十条');
ok($zip->set_number('0030849')->is_valid_number, '北海道札幌市白石区北郷');
ok($zip->set_number('0030851')->is_valid_number, '北海道札幌市白石区川北一条');
ok($zip->set_number('0030852')->is_valid_number, '北海道札幌市白石区川北二条');
ok($zip->set_number('0030853')->is_valid_number, '北海道札幌市白石区川北三条');
ok($zip->set_number('0030854')->is_valid_number, '北海道札幌市白石区川北四条');
ok($zip->set_number('0030855')->is_valid_number, '北海道札幌市白石区川北五条');
ok($zip->set_number('0030859')->is_valid_number, '北海道札幌市白石区川北');
ok($zip->set_number('0030861')->is_valid_number, '北海道札幌市白石区川下一条');
ok($zip->set_number('0030862')->is_valid_number, '北海道札幌市白石区川下二条');
ok($zip->set_number('0030863')->is_valid_number, '北海道札幌市白石区川下三条');
ok($zip->set_number('0030864')->is_valid_number, '北海道札幌市白石区川下四条');
ok($zip->set_number('0030865')->is_valid_number, '北海道札幌市白石区川下五条');
ok($zip->set_number('0030869')->is_valid_number, '北海道札幌市白石区川下');
ok($zip->set_number('0030871')->is_valid_number, '北海道札幌市白石区米里一条');
ok($zip->set_number('0030872')->is_valid_number, '北海道札幌市白石区米里二条');
ok($zip->set_number('0030873')->is_valid_number, '北海道札幌市白石区米里三条');
ok($zip->set_number('0030874')->is_valid_number, '北海道札幌市白石区米里四条');
ok($zip->set_number('0030875')->is_valid_number, '北海道札幌市白石区米里五条');
ok($zip->set_number('0030876')->is_valid_number, '北海道札幌市白石区東米里');
ok($zip->set_number('0040000')->is_valid_number, '北海道札幌市厚別区以下に掲載がない場合');
ok($zip->set_number('0040000')->is_valid_number, '北海道札幌市清田区以下に掲載がない場合');
ok($zip->set_number('0040001')->is_valid_number, '北海道札幌市厚別区厚別東一条');
ok($zip->set_number('0040002')->is_valid_number, '北海道札幌市厚別区厚別東二条');
ok($zip->set_number('0040003')->is_valid_number, '北海道札幌市厚別区厚別東三条');
ok($zip->set_number('0040004')->is_valid_number, '北海道札幌市厚別区厚別東四条');
ok($zip->set_number('0040005')->is_valid_number, '北海道札幌市厚別区厚別東五条');
ok($zip->set_number('0040006')->is_valid_number, '北海道札幌市厚別区厚別町小野幌');
ok($zip->set_number('0040007')->is_valid_number, '北海道札幌市厚別区厚別町下野幌');
ok($zip->set_number('0040011')->is_valid_number, '北海道札幌市厚別区もみじ台東');
ok($zip->set_number('0040012')->is_valid_number, '北海道札幌市厚別区もみじ台南');
ok($zip->set_number('0040013')->is_valid_number, '北海道札幌市厚別区もみじ台西');
ok($zip->set_number('0040014')->is_valid_number, '北海道札幌市厚別区もみじ台北');
ok($zip->set_number('0040015')->is_valid_number, '北海道札幌市厚別区下野幌テクノパーク');
ok($zip->set_number('0040021')->is_valid_number, '北海道札幌市厚別区青葉町');
ok($zip->set_number('0040022')->is_valid_number, '北海道札幌市厚別区厚別南');
ok($zip->set_number('0040031')->is_valid_number, '北海道札幌市厚別区上野幌一条');
ok($zip->set_number('0040032')->is_valid_number, '北海道札幌市厚別区上野幌二条');
ok($zip->set_number('0040033')->is_valid_number, '北海道札幌市厚別区上野幌三条');
ok($zip->set_number('0040039')->is_valid_number, '北海道札幌市厚別区厚別町上野幌');
ok($zip->set_number('0040041')->is_valid_number, '北海道札幌市厚別区大谷地東');
ok($zip->set_number('0040042')->is_valid_number, '北海道札幌市厚別区大谷地西');
ok($zip->set_number('0040051')->is_valid_number, '北海道札幌市厚別区厚別中央一条');
ok($zip->set_number('0040052')->is_valid_number, '北海道札幌市厚別区厚別中央二条');
ok($zip->set_number('0040053')->is_valid_number, '北海道札幌市厚別区厚別中央三条');
ok($zip->set_number('0040054')->is_valid_number, '北海道札幌市厚別区厚別中央四条');
ok($zip->set_number('0040055')->is_valid_number, '北海道札幌市厚別区厚別中央五条');
ok($zip->set_number('0040061')->is_valid_number, '北海道札幌市厚別区厚別西一条');
ok($zip->set_number('0040062')->is_valid_number, '北海道札幌市厚別区厚別西二条');
ok($zip->set_number('0040063')->is_valid_number, '北海道札幌市厚別区厚別西三条');
ok($zip->set_number('0040064')->is_valid_number, '北海道札幌市厚別区厚別西四条');
ok($zip->set_number('0040065')->is_valid_number, '北海道札幌市厚別区厚別西五条');
ok($zip->set_number('0040068')->is_valid_number, '北海道札幌市厚別区厚別西');
ok($zip->set_number('0040069')->is_valid_number, '北海道札幌市厚別区厚別町山本');
ok($zip->set_number('0040071')->is_valid_number, '北海道札幌市厚別区厚別北一条');
ok($zip->set_number('0040072')->is_valid_number, '北海道札幌市厚別区厚別北二条');
ok($zip->set_number('0040073')->is_valid_number, '北海道札幌市厚別区厚別北三条');
ok($zip->set_number('0040074')->is_valid_number, '北海道札幌市厚別区厚別北四条');
ok($zip->set_number('0040075')->is_valid_number, '北海道札幌市厚別区厚別北五条');
ok($zip->set_number('0040076')->is_valid_number, '北海道札幌市厚別区厚別北六条');
ok($zip->set_number('0040801')->is_valid_number, '北海道札幌市清田区里塚一条');
ok($zip->set_number('0040802')->is_valid_number, '北海道札幌市清田区里塚二条');
ok($zip->set_number('0040803')->is_valid_number, '北海道札幌市清田区里塚三条');
ok($zip->set_number('0040804')->is_valid_number, '北海道札幌市清田区里塚四条');
ok($zip->set_number('0040805')->is_valid_number, '北海道札幌市清田区里塚緑ケ丘');
ok($zip->set_number('0040809')->is_valid_number, '北海道札幌市清田区里塚');
ok($zip->set_number('0040811')->is_valid_number, '北海道札幌市清田区美しが丘一条');
ok($zip->set_number('0040812')->is_valid_number, '北海道札幌市清田区美しが丘二条');
ok($zip->set_number('0040813')->is_valid_number, '北海道札幌市清田区美しが丘三条');
ok($zip->set_number('0040814')->is_valid_number, '北海道札幌市清田区美しが丘四条');
ok($zip->set_number('0040815')->is_valid_number, '北海道札幌市清田区美しが丘五条');
ok($zip->set_number('0040821')->is_valid_number, '北海道札幌市清田区有明');
ok($zip->set_number('0040831')->is_valid_number, '北海道札幌市清田区真栄一条');
ok($zip->set_number('0040832')->is_valid_number, '北海道札幌市清田区真栄二条');
ok($zip->set_number('0040833')->is_valid_number, '北海道札幌市清田区真栄三条');
ok($zip->set_number('0040834')->is_valid_number, '北海道札幌市清田区真栄四条');
ok($zip->set_number('0040835')->is_valid_number, '北海道札幌市清田区真栄五条');
ok($zip->set_number('0040836')->is_valid_number, '北海道札幌市清田区真栄六条');
ok($zip->set_number('0040839')->is_valid_number, '北海道札幌市清田区真栄');
ok($zip->set_number('0040840')->is_valid_number, '北海道札幌市清田区清田十条');
ok($zip->set_number('0040841')->is_valid_number, '北海道札幌市清田区清田一条');
ok($zip->set_number('0040842')->is_valid_number, '北海道札幌市清田区清田二条');
ok($zip->set_number('0040843')->is_valid_number, '北海道札幌市清田区清田三条');
ok($zip->set_number('0040844')->is_valid_number, '北海道札幌市清田区清田四条');
ok($zip->set_number('0040845')->is_valid_number, '北海道札幌市清田区清田五条');
ok($zip->set_number('0040846')->is_valid_number, '北海道札幌市清田区清田六条');
ok($zip->set_number('0040847')->is_valid_number, '北海道札幌市清田区清田七条');
ok($zip->set_number('0040848')->is_valid_number, '北海道札幌市清田区清田八条');
ok($zip->set_number('0040849')->is_valid_number, '北海道札幌市清田区清田九条');
ok($zip->set_number('0040859')->is_valid_number, '北海道札幌市清田区清田');
ok($zip->set_number('0040861')->is_valid_number, '北海道札幌市清田区北野一条');
ok($zip->set_number('0040862')->is_valid_number, '北海道札幌市清田区北野二条');
ok($zip->set_number('0040863')->is_valid_number, '北海道札幌市清田区北野三条');
ok($zip->set_number('0040864')->is_valid_number, '北海道札幌市清田区北野四条');
ok($zip->set_number('0040865')->is_valid_number, '北海道札幌市清田区北野五条');
ok($zip->set_number('0040866')->is_valid_number, '北海道札幌市清田区北野六条');
ok($zip->set_number('0040867')->is_valid_number, '北海道札幌市清田区北野七条');
ok($zip->set_number('0040871')->is_valid_number, '北海道札幌市清田区平岡一条');
ok($zip->set_number('0040872')->is_valid_number, '北海道札幌市清田区平岡二条');
ok($zip->set_number('0040873')->is_valid_number, '北海道札幌市清田区平岡三条');
ok($zip->set_number('0040874')->is_valid_number, '北海道札幌市清田区平岡四条');
ok($zip->set_number('0040875')->is_valid_number, '北海道札幌市清田区平岡五条');
ok($zip->set_number('0040876')->is_valid_number, '北海道札幌市清田区平岡六条');
ok($zip->set_number('0040877')->is_valid_number, '北海道札幌市清田区平岡七条');
ok($zip->set_number('0040878')->is_valid_number, '北海道札幌市清田区平岡八条');
ok($zip->set_number('0040879')->is_valid_number, '北海道札幌市清田区平岡九条');
ok($zip->set_number('0040880')->is_valid_number, '北海道札幌市清田区平岡十条');
ok($zip->set_number('0040881')->is_valid_number, '北海道札幌市清田区平岡公園');
ok($zip->set_number('0040882')->is_valid_number, '北海道札幌市清田区平岡公園東');
ok($zip->set_number('0040889')->is_valid_number, '北海道札幌市清田区平岡');
ok($zip->set_number('0050000')->is_valid_number, '北海道札幌市南区以下に掲載がない場合');
ok($zip->set_number('0050001')->is_valid_number, '北海道札幌市南区澄川一条');
ok($zip->set_number('0050002')->is_valid_number, '北海道札幌市南区澄川二条');
ok($zip->set_number('0050003')->is_valid_number, '北海道札幌市南区澄川三条');
ok($zip->set_number('0050004')->is_valid_number, '北海道札幌市南区澄川四条');
ok($zip->set_number('0050005')->is_valid_number, '北海道札幌市南区澄川五条');
ok($zip->set_number('0050006')->is_valid_number, '北海道札幌市南区澄川六条');
ok($zip->set_number('0050007')->is_valid_number, '北海道札幌市南区澄川');
ok($zip->set_number('0050008')->is_valid_number, '北海道札幌市南区真駒内(17番地)');
ok($zip->set_number('0050011')->is_valid_number, '北海道札幌市南区真駒内東町');
ok($zip->set_number('0050012')->is_valid_number, '北海道札幌市南区真駒内上町');
ok($zip->set_number('0050013')->is_valid_number, '北海道札幌市南区真駒内緑町');
ok($zip->set_number('0050014')->is_valid_number, '北海道札幌市南区真駒内幸町');
ok($zip->set_number('0050015')->is_valid_number, '北海道札幌市南区真駒内泉町');
ok($zip->set_number('0050016')->is_valid_number, '北海道札幌市南区真駒内南町');
ok($zip->set_number('0050017')->is_valid_number, '北海道札幌市南区真駒内公園');
ok($zip->set_number('0050018')->is_valid_number, '北海道札幌市南区真駒内曙町');
ok($zip->set_number('0050021')->is_valid_number, '北海道札幌市南区真駒内本町');
ok($zip->set_number('0050022')->is_valid_number, '北海道札幌市南区真駒内柏丘');
ok($zip->set_number('0050030')->is_valid_number, '北海道札幌市南区南三十条西(8丁目)');
ok($zip->set_number('0050031')->is_valid_number, '北海道札幌市南区南三十一条西');
ok($zip->set_number('0050032')->is_valid_number, '北海道札幌市南区南三十二条西');
ok($zip->set_number('0050033')->is_valid_number, '北海道札幌市南区南三十三条西');
ok($zip->set_number('0050034')->is_valid_number, '北海道札幌市南区南三十四条西');
ok($zip->set_number('0050035')->is_valid_number, '北海道札幌市南区南三十五条西');
ok($zip->set_number('0050036')->is_valid_number, '北海道札幌市南区南三十六条西');
ok($zip->set_number('0050037')->is_valid_number, '北海道札幌市南区南三十七条西');
ok($zip->set_number('0050038')->is_valid_number, '北海道札幌市南区南三十八条西');
ok($zip->set_number('0050039')->is_valid_number, '北海道札幌市南区南三十九条西');
ok($zip->set_number('0050040')->is_valid_number, '北海道札幌市南区藻岩下');
ok($zip->set_number('0050041')->is_valid_number, '北海道札幌市南区藻岩山');
ok($zip->set_number('0050801')->is_valid_number, '北海道札幌市南区川沿一条');
ok($zip->set_number('0050802')->is_valid_number, '北海道札幌市南区川沿二条');
ok($zip->set_number('0050803')->is_valid_number, '北海道札幌市南区川沿三条');
ok($zip->set_number('0050804')->is_valid_number, '北海道札幌市南区川沿四条');
ok($zip->set_number('0050805')->is_valid_number, '北海道札幌市南区川沿五条');
ok($zip->set_number('0050806')->is_valid_number, '北海道札幌市南区川沿六条');
ok($zip->set_number('0050807')->is_valid_number, '北海道札幌市南区川沿七条');
ok($zip->set_number('0050808')->is_valid_number, '北海道札幌市南区川沿八条');
ok($zip->set_number('0050809')->is_valid_number, '北海道札幌市南区川沿九条');
ok($zip->set_number('0050810')->is_valid_number, '北海道札幌市南区川沿十条');
ok($zip->set_number('0050811')->is_valid_number, '北海道札幌市南区川沿十一条');
ok($zip->set_number('0050812')->is_valid_number, '北海道札幌市南区川沿十二条');
ok($zip->set_number('0050813')->is_valid_number, '北海道札幌市南区川沿十三条');
ok($zip->set_number('0050814')->is_valid_number, '北海道札幌市南区川沿十四条');
ok($zip->set_number('0050815')->is_valid_number, '北海道札幌市南区川沿十五条');
ok($zip->set_number('0050816')->is_valid_number, '北海道札幌市南区川沿十六条');
ok($zip->set_number('0050817')->is_valid_number, '北海道札幌市南区川沿十七条');
ok($zip->set_number('0050818')->is_valid_number, '北海道札幌市南区川沿十八条');
ok($zip->set_number('0050821')->is_valid_number, '北海道札幌市南区南沢一条');
ok($zip->set_number('0050822')->is_valid_number, '北海道札幌市南区南沢二条');
ok($zip->set_number('0050823')->is_valid_number, '北海道札幌市南区南沢三条');
ok($zip->set_number('0050824')->is_valid_number, '北海道札幌市南区南沢四条');
ok($zip->set_number('0050825')->is_valid_number, '北海道札幌市南区南沢五条');
ok($zip->set_number('0050826')->is_valid_number, '北海道札幌市南区南沢六条');
ok($zip->set_number('0050827')->is_valid_number, '北海道札幌市南区南沢');
ok($zip->set_number('0050830')->is_valid_number, '北海道札幌市南区砥石山');
ok($zip->set_number('0050831')->is_valid_number, '北海道札幌市南区中ノ沢');
ok($zip->set_number('0050832')->is_valid_number, '北海道札幌市南区北ノ沢');
ok($zip->set_number('0050840')->is_valid_number, '北海道札幌市南区藤野(400、400-2番地)');
ok($zip->set_number('0050841')->is_valid_number, '北海道札幌市南区石山一条');
ok($zip->set_number('0050842')->is_valid_number, '北海道札幌市南区石山二条');
ok($zip->set_number('0050843')->is_valid_number, '北海道札幌市南区石山三条');
ok($zip->set_number('0050844')->is_valid_number, '北海道札幌市南区石山四条');
ok($zip->set_number('0050849')->is_valid_number, '北海道札幌市南区石山');
ok($zip->set_number('0050850')->is_valid_number, '北海道札幌市南区石山東');
ok($zip->set_number('0050851')->is_valid_number, '北海道札幌市南区常盤一条');
ok($zip->set_number('0050852')->is_valid_number, '北海道札幌市南区常盤二条');
ok($zip->set_number('0050853')->is_valid_number, '北海道札幌市南区常盤三条');
ok($zip->set_number('0050854')->is_valid_number, '北海道札幌市南区常盤四条');
ok($zip->set_number('0050855')->is_valid_number, '北海道札幌市南区常盤五条');
ok($zip->set_number('0050856')->is_valid_number, '北海道札幌市南区常盤六条');
ok($zip->set_number('0050861')->is_valid_number, '北海道札幌市南区真駒内(その他)');
ok($zip->set_number('0050862')->is_valid_number, '北海道札幌市南区滝野');
ok($zip->set_number('0050863')->is_valid_number, '北海道札幌市南区常盤(その他)');
ok($zip->set_number('0050864')->is_valid_number, '北海道札幌市南区芸術の森');
ok($zip->set_number('0050865')->is_valid_number, '北海道札幌市南区常盤(1~131番地)');
ok($zip->set_number('0060000')->is_valid_number, '北海道札幌市手稲区以下に掲載がない場合');
ok($zip->set_number('0060001')->is_valid_number, '北海道札幌市手稲区西宮の沢一条');
ok($zip->set_number('0060002')->is_valid_number, '北海道札幌市手稲区西宮の沢二条');
ok($zip->set_number('0060003')->is_valid_number, '北海道札幌市手稲区西宮の沢三条');
ok($zip->set_number('0060004')->is_valid_number, '北海道札幌市手稲区西宮の沢四条');
ok($zip->set_number('0060005')->is_valid_number, '北海道札幌市手稲区西宮の沢五条');
ok($zip->set_number('0060006')->is_valid_number, '北海道札幌市手稲区西宮の沢六条');
ok($zip->set_number('0060009')->is_valid_number, '北海道札幌市手稲区西宮の沢');
ok($zip->set_number('0060011')->is_valid_number, '北海道札幌市手稲区富丘一条');
ok($zip->set_number('0060012')->is_valid_number, '北海道札幌市手稲区富丘二条');
ok($zip->set_number('0060013')->is_valid_number, '北海道札幌市手稲区富丘三条');
ok($zip->set_number('0060014')->is_valid_number, '北海道札幌市手稲区富丘四条');
ok($zip->set_number('0060015')->is_valid_number, '北海道札幌市手稲区富丘五条');
ok($zip->set_number('0060016')->is_valid_number, '北海道札幌市手稲区富丘六条');
ok($zip->set_number('0060019')->is_valid_number, '北海道札幌市手稲区手稲富丘');
ok($zip->set_number('0060021')->is_valid_number, '北海道札幌市手稲区手稲本町一条');
ok($zip->set_number('0060022')->is_valid_number, '北海道札幌市手稲区手稲本町二条');
ok($zip->set_number('0060023')->is_valid_number, '北海道札幌市手稲区手稲本町三条');
ok($zip->set_number('0060024')->is_valid_number, '北海道札幌市手稲区手稲本町四条');
ok($zip->set_number('0060025')->is_valid_number, '北海道札幌市手稲区手稲本町五条');
ok($zip->set_number('0060026')->is_valid_number, '北海道札幌市手稲区手稲本町六条');
ok($zip->set_number('0060029')->is_valid_number, '北海道札幌市手稲区手稲本町');
ok($zip->set_number('0060031')->is_valid_number, '北海道札幌市手稲区稲穂一条');
ok($zip->set_number('0060032')->is_valid_number, '北海道札幌市手稲区稲穂二条');
ok($zip->set_number('0060033')->is_valid_number, '北海道札幌市手稲区稲穂三条');
ok($zip->set_number('0060034')->is_valid_number, '北海道札幌市手稲区稲穂四条');
ok($zip->set_number('0060035')->is_valid_number, '北海道札幌市手稲区稲穂五条');
ok($zip->set_number('0060039')->is_valid_number, '北海道札幌市手稲区手稲稲穂');
ok($zip->set_number('0060041')->is_valid_number, '北海道札幌市手稲区金山一条');
ok($zip->set_number('0060042')->is_valid_number, '北海道札幌市手稲区金山二条');
ok($zip->set_number('0060043')->is_valid_number, '北海道札幌市手稲区金山三条');
ok($zip->set_number('0060049')->is_valid_number, '北海道札幌市手稲区手稲金山');
ok($zip->set_number('0060050')->is_valid_number, '北海道札幌市手稲区星置南');
ok($zip->set_number('0060801')->is_valid_number, '北海道札幌市手稲区新発寒一条');
ok($zip->set_number('0060802')->is_valid_number, '北海道札幌市手稲区新発寒二条');
ok($zip->set_number('0060803')->is_valid_number, '北海道札幌市手稲区新発寒三条');
ok($zip->set_number('0060804')->is_valid_number, '北海道札幌市手稲区新発寒四条');
ok($zip->set_number('0060805')->is_valid_number, '北海道札幌市手稲区新発寒五条');
ok($zip->set_number('0060806')->is_valid_number, '北海道札幌市手稲区新発寒六条');
ok($zip->set_number('0060807')->is_valid_number, '北海道札幌市手稲区新発寒七条');
ok($zip->set_number('0060811')->is_valid_number, '北海道札幌市手稲区前田一条');
ok($zip->set_number('0060812')->is_valid_number, '北海道札幌市手稲区前田二条');
ok($zip->set_number('0060813')->is_valid_number, '北海道札幌市手稲区前田三条');
ok($zip->set_number('0060814')->is_valid_number, '北海道札幌市手稲区前田四条');
ok($zip->set_number('0060815')->is_valid_number, '北海道札幌市手稲区前田五条');
ok($zip->set_number('0060816')->is_valid_number, '北海道札幌市手稲区前田六条');
ok($zip->set_number('0060817')->is_valid_number, '北海道札幌市手稲区前田七条');
ok($zip->set_number('0060818')->is_valid_number, '北海道札幌市手稲区前田八条');
ok($zip->set_number('0060819')->is_valid_number, '北海道札幌市手稲区前田九条');
ok($zip->set_number('0060820')->is_valid_number, '北海道札幌市手稲区前田十条');
ok($zip->set_number('0060821')->is_valid_number, '北海道札幌市手稲区前田十一条');
ok($zip->set_number('0060822')->is_valid_number, '北海道札幌市手稲区前田十二条');
ok($zip->set_number('0060823')->is_valid_number, '北海道札幌市手稲区前田十三条');
ok($zip->set_number('0060829')->is_valid_number, '北海道札幌市手稲区手稲前田');
ok($zip->set_number('0060831')->is_valid_number, '北海道札幌市手稲区曙一条');
ok($zip->set_number('0060832')->is_valid_number, '北海道札幌市手稲区曙二条');
ok($zip->set_number('0060833')->is_valid_number, '北海道札幌市手稲区曙三条');
ok($zip->set_number('0060834')->is_valid_number, '北海道札幌市手稲区曙四条');
ok($zip->set_number('0060835')->is_valid_number, '北海道札幌市手稲区曙五条');
ok($zip->set_number('0060836')->is_valid_number, '北海道札幌市手稲区曙六条');
ok($zip->set_number('0060837')->is_valid_number, '北海道札幌市手稲区曙七条');
ok($zip->set_number('0060838')->is_valid_number, '北海道札幌市手稲区曙八条');
ok($zip->set_number('0060839')->is_valid_number, '北海道札幌市手稲区曙九条');
ok($zip->set_number('0060840')->is_valid_number, '北海道札幌市手稲区曙十条');
ok($zip->set_number('0060841')->is_valid_number, '北海道札幌市手稲区曙十一条');
ok($zip->set_number('0060842')->is_valid_number, '北海道札幌市手稲区曙十二条');
ok($zip->set_number('0060851')->is_valid_number, '北海道札幌市手稲区星置一条');
ok($zip->set_number('0060852')->is_valid_number, '北海道札幌市手稲区星置二条');
ok($zip->set_number('0060853')->is_valid_number, '北海道札幌市手稲区星置三条');
ok($zip->set_number('0060859')->is_valid_number, '北海道札幌市手稲区手稲星置');
ok($zip->set_number('0060860')->is_valid_number, '北海道札幌市手稲区手稲山口');
ok($zip->set_number('0060861')->is_valid_number, '北海道札幌市手稲区明日風');
ok($zip->set_number('0070001')->is_valid_number, '北海道札幌市東区中沼一条');
ok($zip->set_number('0070002')->is_valid_number, '北海道札幌市東区中沼二条');
ok($zip->set_number('0070003')->is_valid_number, '北海道札幌市東区中沼三条');
ok($zip->set_number('0070004')->is_valid_number, '北海道札幌市東区中沼四条');
ok($zip->set_number('0070005')->is_valid_number, '北海道札幌市東区中沼五条');
ok($zip->set_number('0070006')->is_valid_number, '北海道札幌市東区中沼六条');
ok($zip->set_number('0070011')->is_valid_number, '北海道札幌市東区モエレ沼公園');
ok($zip->set_number('0070030')->is_valid_number, '北海道札幌市東区東雁来十条');
ok($zip->set_number('0070031')->is_valid_number, '北海道札幌市東区東雁来十一条');
ok($zip->set_number('0070032')->is_valid_number, '北海道札幌市東区東雁来十二条');
ok($zip->set_number('0070033')->is_valid_number, '北海道札幌市東区東雁来十三条');
ok($zip->set_number('0070034')->is_valid_number, '北海道札幌市東区東雁来十四条');
ok($zip->set_number('0070801')->is_valid_number, '北海道札幌市東区東苗穂一条');
ok($zip->set_number('0070802')->is_valid_number, '北海道札幌市東区東苗穂二条');
ok($zip->set_number('0070803')->is_valid_number, '北海道札幌市東区東苗穂三条');
ok($zip->set_number('0070804')->is_valid_number, '北海道札幌市東区東苗穂四条');
ok($zip->set_number('0070805')->is_valid_number, '北海道札幌市東区東苗穂五条');
ok($zip->set_number('0070806')->is_valid_number, '北海道札幌市東区東苗穂六条');
ok($zip->set_number('0070807')->is_valid_number, '北海道札幌市東区東苗穂七条');
ok($zip->set_number('0070808')->is_valid_number, '北海道札幌市東区東苗穂八条');
ok($zip->set_number('0070809')->is_valid_number, '北海道札幌市東区東苗穂九条');
ok($zip->set_number('0070810')->is_valid_number, '北海道札幌市東区東苗穂十条');
ok($zip->set_number('0070811')->is_valid_number, '北海道札幌市東区東苗穂十一条');
ok($zip->set_number('0070812')->is_valid_number, '北海道札幌市東区東苗穂十二条');
ok($zip->set_number('0070813')->is_valid_number, '北海道札幌市東区東苗穂十三条');
ok($zip->set_number('0070814')->is_valid_number, '北海道札幌市東区東苗穂十四条');
ok($zip->set_number('0070815')->is_valid_number, '北海道札幌市東区東苗穂十五条');
ok($zip->set_number('0070819')->is_valid_number, '北海道札幌市東区東苗穂町');
ok($zip->set_number('0070820')->is_valid_number, '北海道札幌市東区東雁来町');
ok($zip->set_number('0070821')->is_valid_number, '北海道札幌市東区東雁来一条');
ok($zip->set_number('0070822')->is_valid_number, '北海道札幌市東区東雁来二条');
ok($zip->set_number('0070823')->is_valid_number, '北海道札幌市東区東雁来三条');
ok($zip->set_number('0070824')->is_valid_number, '北海道札幌市東区東雁来四条');
ok($zip->set_number('0070825')->is_valid_number, '北海道札幌市東区東雁来五条');
ok($zip->set_number('0070826')->is_valid_number, '北海道札幌市東区東雁来六条');
ok($zip->set_number('0070827')->is_valid_number, '北海道札幌市東区東雁来七条');
ok($zip->set_number('0070828')->is_valid_number, '北海道札幌市東区東雁来八条');
ok($zip->set_number('0070829')->is_valid_number, '北海道札幌市東区東雁来九条');
ok($zip->set_number('0070834')->is_valid_number, '北海道札幌市東区北三十四条東');
ok($zip->set_number('0070835')->is_valid_number, '北海道札幌市東区北三十五条東');
ok($zip->set_number('0070836')->is_valid_number, '北海道札幌市東区北三十六条東');
ok($zip->set_number('0070837')->is_valid_number, '北海道札幌市東区北三十七条東');
ok($zip->set_number('0070838')->is_valid_number, '北海道札幌市東区北三十八条東');
ok($zip->set_number('0070839')->is_valid_number, '北海道札幌市東区北三十九条東');
ok($zip->set_number('0070840')->is_valid_number, '北海道札幌市東区北四十条東');
ok($zip->set_number('0070841')->is_valid_number, '北海道札幌市東区北四十一条東');
ok($zip->set_number('0070842')->is_valid_number, '北海道札幌市東区北四十二条東');
ok($zip->set_number('0070843')->is_valid_number, '北海道札幌市東区北四十三条東');
ok($zip->set_number('0070844')->is_valid_number, '北海道札幌市東区北四十四条東');
ok($zip->set_number('0070845')->is_valid_number, '北海道札幌市東区北四十五条東');
ok($zip->set_number('0070846')->is_valid_number, '北海道札幌市東区北四十六条東');
ok($zip->set_number('0070847')->is_valid_number, '北海道札幌市東区北四十七条東');
ok($zip->set_number('0070848')->is_valid_number, '北海道札幌市東区北四十八条東');
ok($zip->set_number('0070849')->is_valid_number, '北海道札幌市東区北四十九条東');
ok($zip->set_number('0070850')->is_valid_number, '北海道札幌市東区北五十条東');
ok($zip->set_number('0070851')->is_valid_number, '北海道札幌市東区北五十一条東');
ok($zip->set_number('0070852')->is_valid_number, '北海道札幌市東区栄町');
ok($zip->set_number('0070861')->is_valid_number, '北海道札幌市東区伏古一条');
ok($zip->set_number('0070862')->is_valid_number, '北海道札幌市東区伏古二条');
ok($zip->set_number('0070863')->is_valid_number, '北海道札幌市東区伏古三条');
ok($zip->set_number('0070864')->is_valid_number, '北海道札幌市東区伏古四条');
ok($zip->set_number('0070865')->is_valid_number, '北海道札幌市東区伏古五条');
ok($zip->set_number('0070866')->is_valid_number, '北海道札幌市東区伏古六条');
ok($zip->set_number('0070867')->is_valid_number, '北海道札幌市東区伏古七条');
ok($zip->set_number('0070868')->is_valid_number, '北海道札幌市東区伏古八条');
ok($zip->set_number('0070869')->is_valid_number, '北海道札幌市東区伏古九条');
ok($zip->set_number('0070870')->is_valid_number, '北海道札幌市東区伏古十条');
ok($zip->set_number('0070871')->is_valid_number, '北海道札幌市東区伏古十一条');
ok($zip->set_number('0070872')->is_valid_number, '北海道札幌市東区伏古十二条');
ok($zip->set_number('0070873')->is_valid_number, '北海道札幌市東区伏古十三条');
ok($zip->set_number('0070874')->is_valid_number, '北海道札幌市東区伏古十四条');
ok($zip->set_number('0070880')->is_valid_number, '北海道札幌市東区丘珠町');
ok($zip->set_number('0070881')->is_valid_number, '北海道札幌市東区北丘珠一条');
ok($zip->set_number('0070882')->is_valid_number, '北海道札幌市東区北丘珠二条');
ok($zip->set_number('0070883')->is_valid_number, '北海道札幌市東区北丘珠三条');
ok($zip->set_number('0070884')->is_valid_number, '北海道札幌市東区北丘珠四条');
ok($zip->set_number('0070885')->is_valid_number, '北海道札幌市東区北丘珠五条');
ok($zip->set_number('0070886')->is_valid_number, '北海道札幌市東区北丘珠六条');
ok($zip->set_number('0070890')->is_valid_number, '北海道札幌市東区中沼町');
ok($zip->set_number('0070891')->is_valid_number, '北海道札幌市東区中沼西一条');
ok($zip->set_number('0070892')->is_valid_number, '北海道札幌市東区中沼西二条');
ok($zip->set_number('0070893')->is_valid_number, '北海道札幌市東区中沼西三条');
ok($zip->set_number('0070894')->is_valid_number, '北海道札幌市東区中沼西四条');
ok($zip->set_number('0070895')->is_valid_number, '北海道札幌市東区中沼西五条');
ok($zip->set_number('0100000')->is_valid_number, '秋田県秋田市以下に掲載がない場合');
ok($zip->set_number('0100001')->is_valid_number, '秋田県秋田市中通');
ok($zip->set_number('0100002')->is_valid_number, '秋田県秋田市東通仲町');
ok($zip->set_number('0100003')->is_valid_number, '秋田県秋田市東通');
ok($zip->set_number('0100004')->is_valid_number, '秋田県秋田市東通観音前');
ok($zip->set_number('0100005')->is_valid_number, '秋田県秋田市東通明田');
ok($zip->set_number('0100006')->is_valid_number, '秋田県秋田市東通館ノ越');
ok($zip->set_number('0100011')->is_valid_number, '秋田県秋田市南通亀の町');
ok($zip->set_number('0100012')->is_valid_number, '秋田県秋田市南通みその町');
ok($zip->set_number('0100013')->is_valid_number, '秋田県秋田市南通築地');
ok($zip->set_number('0100014')->is_valid_number, '秋田県秋田市南通宮田');
ok($zip->set_number('0100021')->is_valid_number, '秋田県秋田市楢山登町');
ok($zip->set_number('0100022')->is_valid_number, '秋田県秋田市楢山南中町');
ok($zip->set_number('0100023')->is_valid_number, '秋田県秋田市楢山本町');
ok($zip->set_number('0100024')->is_valid_number, '秋田県秋田市楢山南新町上丁');
ok($zip->set_number('0100025')->is_valid_number, '秋田県秋田市楢山佐竹町');
ok($zip->set_number('0100026')->is_valid_number, '秋田県秋田市楢山古川新町');
ok($zip->set_number('0100027')->is_valid_number, '秋田県秋田市楢山南新町下丁');
ok($zip->set_number('0100028')->is_valid_number, '秋田県秋田市楢山共和町');
ok($zip->set_number('0100029')->is_valid_number, '秋田県秋田市楢山川口境');
ok($zip->set_number('0100031')->is_valid_number, '秋田県秋田市楢山大元町');
ok($zip->set_number('0100032')->is_valid_number, '秋田県秋田市楢山太田町');
ok($zip->set_number('0100033')->is_valid_number, '秋田県秋田市楢山石塚町');
ok($zip->set_number('0100034')->is_valid_number, '秋田県秋田市楢山');
ok($zip->set_number('0100035')->is_valid_number, '秋田県秋田市楢山城南町');
ok($zip->set_number('0100036')->is_valid_number, '秋田県秋田市楢山金照町');
ok($zip->set_number('0100037')->is_valid_number, '秋田県秋田市楢山愛宕下');
ok($zip->set_number('0100038')->is_valid_number, '秋田県秋田市楢山城南新町');
ok($zip->set_number('0100041')->is_valid_number, '秋田県秋田市広面');
ok($zip->set_number('0100042')->is_valid_number, '秋田県秋田市桜');
ok($zip->set_number('0100043')->is_valid_number, '秋田県秋田市桜ガ丘');
ok($zip->set_number('0100044')->is_valid_number, '秋田県秋田市横森');
ok($zip->set_number('0100051')->is_valid_number, '秋田県秋田市下北手松崎');
ok($zip->set_number('0100052')->is_valid_number, '秋田県秋田市下北手柳舘');
ok($zip->set_number('0100053')->is_valid_number, '秋田県秋田市下北手寒川');
ok($zip->set_number('0100054')->is_valid_number, '秋田県秋田市下北手宝川');
ok($zip->set_number('0100055')->is_valid_number, '秋田県秋田市下北手通沢');
ok($zip->set_number('0100056')->is_valid_number, '秋田県秋田市下北手黒川');
ok($zip->set_number('0100057')->is_valid_number, '秋田県秋田市下北手梨平');
ok($zip->set_number('0100058')->is_valid_number, '秋田県秋田市下北手桜');
ok($zip->set_number('0100059')->is_valid_number, '秋田県秋田市桜台');
ok($zip->set_number('0100061')->is_valid_number, '秋田県秋田市卸町');
ok($zip->set_number('0100062')->is_valid_number, '秋田県秋田市牛島東');
ok($zip->set_number('0100063')->is_valid_number, '秋田県秋田市牛島西');
ok($zip->set_number('0100064')->is_valid_number, '秋田県秋田市牛島');
ok($zip->set_number('0100065')->is_valid_number, '秋田県秋田市茨島');
ok($zip->set_number('0100066')->is_valid_number, '秋田県秋田市牛島南');
ok($zip->set_number('0100101')->is_valid_number, '秋田県潟上市天王(追分、追分西、上北野、長沼)');
ok($zip->set_number('0100111')->is_valid_number, '秋田県秋田市金足岩瀬');
ok($zip->set_number('0100112')->is_valid_number, '秋田県秋田市金足堀内');
ok($zip->set_number('0100113')->is_valid_number, '秋田県秋田市金足浦山');
ok($zip->set_number('0100114')->is_valid_number, '秋田県秋田市金足下刈');
ok($zip->set_number('0100115')->is_valid_number, '秋田県秋田市金足大清水');
ok($zip->set_number('0100116')->is_valid_number, '秋田県秋田市金足小泉');
ok($zip->set_number('0100121')->is_valid_number, '秋田県秋田市金足黒川');
ok($zip->set_number('0100122')->is_valid_number, '秋田県秋田市金足吉田');
ok($zip->set_number('0100123')->is_valid_number, '秋田県秋田市金足片田');
ok($zip->set_number('0100124')->is_valid_number, '秋田県秋田市金足鳰崎');
ok($zip->set_number('0100125')->is_valid_number, '秋田県秋田市金足高岡');
ok($zip->set_number('0100126')->is_valid_number, '秋田県秋田市金足追分');
ok($zip->set_number('0100131')->is_valid_number, '秋田県秋田市上新城白山');
ok($zip->set_number('0100132')->is_valid_number, '秋田県秋田市上新城小又');
ok($zip->set_number('0100133')->is_valid_number, '秋田県秋田市上新城湯ノ里');
ok($zip->set_number('0100134')->is_valid_number, '秋田県秋田市上新城道川');
ok($zip->set_number('0100135')->is_valid_number, '秋田県秋田市上新城五十丁');
ok($zip->set_number('0100136')->is_valid_number, '秋田県秋田市上新城中');
ok($zip->set_number('0100137')->is_valid_number, '秋田県秋田市上新城石名坂');
ok($zip->set_number('0100138')->is_valid_number, '秋田県秋田市上新城保多野');
ok($zip->set_number('0100141')->is_valid_number, '秋田県秋田市下新城長岡');
ok($zip->set_number('0100142')->is_valid_number, '秋田県秋田市下新城青崎');
ok($zip->set_number('0100143')->is_valid_number, '秋田県秋田市下新城小友');
ok($zip->set_number('0100144')->is_valid_number, '秋田県秋田市下新城岩城');
ok($zip->set_number('0100145')->is_valid_number, '秋田県秋田市下新城笠岡');
ok($zip->set_number('0100146')->is_valid_number, '秋田県秋田市下新城中野');
ok($zip->set_number('0100201')->is_valid_number, '秋田県潟上市天王(その他)');
ok($zip->set_number('0100202')->is_valid_number, '秋田県潟上市天王大崎');
ok($zip->set_number('0100341')->is_valid_number, '秋田県男鹿市船越');
ok($zip->set_number('0100342')->is_valid_number, '秋田県男鹿市脇本脇本');
ok($zip->set_number('0100343')->is_valid_number, '秋田県男鹿市脇本田谷沢');
ok($zip->set_number('0100344')->is_valid_number, '秋田県男鹿市脇本富永');
ok($zip->set_number('0100345')->is_valid_number, '秋田県男鹿市脇本浦田');
ok($zip->set_number('0100346')->is_valid_number, '秋田県男鹿市脇本樽沢');
ok($zip->set_number('0100347')->is_valid_number, '秋田県男鹿市脇本百川');
ok($zip->set_number('0100351')->is_valid_number, '秋田県男鹿市五里合箱井');
ok($zip->set_number('0100352')->is_valid_number, '秋田県男鹿市五里合琴川');
ok($zip->set_number('0100353')->is_valid_number, '秋田県男鹿市五里合神谷');
ok($zip->set_number('0100354')->is_valid_number, '秋田県男鹿市五里合中石');
ok($zip->set_number('0100355')->is_valid_number, '秋田県男鹿市五里合鮪川');
ok($zip->set_number('0100400')->is_valid_number, '秋田県南秋田郡大潟村以下に掲載がない場合');
ok($zip->set_number('0100401')->is_valid_number, '秋田県男鹿市野石');
ok($zip->set_number('0100411')->is_valid_number, '秋田県男鹿市福米沢');
ok($zip->set_number('0100412')->is_valid_number, '秋田県男鹿市本内');
ok($zip->set_number('0100413')->is_valid_number, '秋田県男鹿市松木沢');
ok($zip->set_number('0100421')->is_valid_number, '秋田県男鹿市鵜木');
ok($zip->set_number('0100422')->is_valid_number, '秋田県男鹿市角間崎');
ok($zip->set_number('0100423')->is_valid_number, '秋田県男鹿市福川');
ok($zip->set_number('0100431')->is_valid_number, '秋田県男鹿市払戸');
ok($zip->set_number('0100441')->is_valid_number, '秋田県南秋田郡大潟村北');
ok($zip->set_number('0100442')->is_valid_number, '秋田県南秋田郡大潟村東');
ok($zip->set_number('0100443')->is_valid_number, '秋田県南秋田郡大潟村中央');
ok($zip->set_number('0100444')->is_valid_number, '秋田県南秋田郡大潟村南');
ok($zip->set_number('0100445')->is_valid_number, '秋田県南秋田郡大潟村西');
ok($zip->set_number('0100451')->is_valid_number, '秋田県南秋田郡大潟村大潟');
ok($zip->set_number('0100452')->is_valid_number, '秋田県南秋田郡大潟村方上');
ok($zip->set_number('0100453')->is_valid_number, '秋田県南秋田郡大潟村方口');
ok($zip->set_number('0100454')->is_valid_number, '秋田県南秋田郡大潟村中野');
ok($zip->set_number('0100455')->is_valid_number, '秋田県南秋田郡大潟村西野');
ok($zip->set_number('0100456')->is_valid_number, '秋田県南秋田郡大潟村東野');
ok($zip->set_number('0100500')->is_valid_number, '秋田県男鹿市以下に掲載がない場合');
ok($zip->set_number('0100501')->is_valid_number, '秋田県男鹿市船川港仁井山');
ok($zip->set_number('0100502')->is_valid_number, '秋田県男鹿市船川港比詰');
ok($zip->set_number('0100503')->is_valid_number, '秋田県男鹿市船川港金川');
ok($zip->set_number('0100511')->is_valid_number, '秋田県男鹿市船川港船川');
ok($zip->set_number('0100521')->is_valid_number, '秋田県男鹿市船川港南平沢');
ok($zip->set_number('0100522')->is_valid_number, '秋田県男鹿市船川港増川');
ok($zip->set_number('0100523')->is_valid_number, '秋田県男鹿市船川港女川');
ok($zip->set_number('0100531')->is_valid_number, '秋田県男鹿市船川港台島');
ok($zip->set_number('0100532')->is_valid_number, '秋田県男鹿市船川港椿');
ok($zip->set_number('0100533')->is_valid_number, '秋田県男鹿市船川港双六');
ok($zip->set_number('0100534')->is_valid_number, '秋田県男鹿市船川港小浜');
ok($zip->set_number('0100535')->is_valid_number, '秋田県男鹿市船川港本山門前');
ok($zip->set_number('0100661')->is_valid_number, '秋田県男鹿市男鹿中浜間口');
ok($zip->set_number('0100662')->is_valid_number, '秋田県男鹿市男鹿中中間口');
ok($zip->set_number('0100663')->is_valid_number, '秋田県男鹿市男鹿中滝川');
ok($zip->set_number('0100664')->is_valid_number, '秋田県男鹿市男鹿中国有地内');
ok($zip->set_number('0100665')->is_valid_number, '秋田県男鹿市男鹿中山町');
ok($zip->set_number('0100671')->is_valid_number, '秋田県男鹿市戸賀加茂青砂');
ok($zip->set_number('0100672')->is_valid_number, '秋田県男鹿市戸賀浜塩谷');
ok($zip->set_number('0100673')->is_valid_number, '秋田県男鹿市戸賀塩浜');
ok($zip->set_number('0100674')->is_valid_number, '秋田県男鹿市戸賀戸賀');
ok($zip->set_number('0100675')->is_valid_number, '秋田県男鹿市北浦入道崎');
ok($zip->set_number('0100676')->is_valid_number, '秋田県男鹿市北浦西黒沢');
ok($zip->set_number('0100681')->is_valid_number, '秋田県男鹿市北浦相川');
ok($zip->set_number('0100682')->is_valid_number, '秋田県男鹿市北浦表町');
ok($zip->set_number('0100683')->is_valid_number, '秋田県男鹿市北浦北浦');
ok($zip->set_number('0100684')->is_valid_number, '秋田県男鹿市北浦安全寺');
ok($zip->set_number('0100685')->is_valid_number, '秋田県男鹿市北浦真山');
ok($zip->set_number('0100686')->is_valid_number, '秋田県男鹿市北浦西水口');
ok($zip->set_number('0100687')->is_valid_number, '秋田県男鹿市北浦湯本');
ok($zip->set_number('0100688')->is_valid_number, '秋田県男鹿市北浦野村');
ok($zip->set_number('0100802')->is_valid_number, '秋田県秋田市外旭川');
ok($zip->set_number('0100803')->is_valid_number, '秋田県秋田市外旭川八柳');
ok($zip->set_number('0100804')->is_valid_number, '秋田県秋田市外旭川八幡田(丁目)');
ok($zip->set_number('0100811')->is_valid_number, '秋田県秋田市泉釜ノ町');
ok($zip->set_number('0100812')->is_valid_number, '秋田県秋田市泉三嶽根');
ok($zip->set_number('0100813')->is_valid_number, '秋田県秋田市泉一ノ坪');
ok($zip->set_number('0100814')->is_valid_number, '秋田県秋田市泉東町');
ok($zip->set_number('0100815')->is_valid_number, '秋田県秋田市泉馬場');
ok($zip->set_number('0100816')->is_valid_number, '秋田県秋田市泉');
ok($zip->set_number('0100817')->is_valid_number, '秋田県秋田市泉菅野(丁目)');
ok($zip->set_number('0100821')->is_valid_number, '秋田県秋田市濁川');
ok($zip->set_number('0100822')->is_valid_number, '秋田県秋田市添川');
ok($zip->set_number('0100823')->is_valid_number, '秋田県秋田市山内');
ok($zip->set_number('0100824')->is_valid_number, '秋田県秋田市仁別');
ok($zip->set_number('0100825')->is_valid_number, '秋田県秋田市柳田');
ok($zip->set_number('0100826')->is_valid_number, '秋田県秋田市新藤田');
ok($zip->set_number('0100831')->is_valid_number, '秋田県秋田市旭川清澄町');
ok($zip->set_number('0100832')->is_valid_number, '秋田県秋田市旭川新藤田西町');
ok($zip->set_number('0100833')->is_valid_number, '秋田県秋田市旭川新藤田東町');
ok($zip->set_number('0100834')->is_valid_number, '秋田県秋田市旭川南町');
ok($zip->set_number('0100841')->is_valid_number, '秋田県秋田市手形山西町');
ok($zip->set_number('0100842')->is_valid_number, '秋田県秋田市手形山北町');
ok($zip->set_number('0100843')->is_valid_number, '秋田県秋田市手形山東町');
ok($zip->set_number('0100844')->is_valid_number, '秋田県秋田市手形山中町');
ok($zip->set_number('0100845')->is_valid_number, '秋田県秋田市手形山南町');
ok($zip->set_number('0100851')->is_valid_number, '秋田県秋田市手形');
ok($zip->set_number('0100852')->is_valid_number, '秋田県秋田市手形学園町');
ok($zip->set_number('0100853')->is_valid_number, '秋田県秋田市蛇野');
ok($zip->set_number('0100854')->is_valid_number, '秋田県秋田市手形山崎町');
ok($zip->set_number('0100861')->is_valid_number, '秋田県秋田市手形からみでん');
ok($zip->set_number('0100862')->is_valid_number, '秋田県秋田市手形田中');
ok($zip->set_number('0100863')->is_valid_number, '秋田県秋田市手形休下町');
ok($zip->set_number('0100864')->is_valid_number, '秋田県秋田市手形住吉町');
ok($zip->set_number('0100865')->is_valid_number, '秋田県秋田市手形新栄町');
ok($zip->set_number('0100871')->is_valid_number, '秋田県秋田市千秋中島町');
ok($zip->set_number('0100872')->is_valid_number, '秋田県秋田市千秋北の丸');
ok($zip->set_number('0100873')->is_valid_number, '秋田県秋田市千秋城下町');
ok($zip->set_number('0100874')->is_valid_number, '秋田県秋田市千秋久保田町');
ok($zip->set_number('0100875')->is_valid_number, '秋田県秋田市千秋明徳町');
ok($zip->set_number('0100876')->is_valid_number, '秋田県秋田市千秋公園');
ok($zip->set_number('0100877')->is_valid_number, '秋田県秋田市千秋矢留町');
ok($zip->set_number('0100901')->is_valid_number, '秋田県秋田市保戸野桜町');
ok($zip->set_number('0100902')->is_valid_number, '秋田県秋田市保戸野金砂町');
ok($zip->set_number('0100903')->is_valid_number, '秋田県秋田市保戸野八丁');
ok($zip->set_number('0100904')->is_valid_number, '秋田県秋田市保戸野原の町');
ok($zip->set_number('0100905')->is_valid_number, '秋田県秋田市保戸野中町');
ok($zip->set_number('0100911')->is_valid_number, '秋田県秋田市保戸野すわ町');
ok($zip->set_number('0100912')->is_valid_number, '秋田県秋田市保戸野通町');
ok($zip->set_number('0100913')->is_valid_number, '秋田県秋田市保戸野鉄砲町');
ok($zip->set_number('0100914')->is_valid_number, '秋田県秋田市保戸野千代田町');
ok($zip->set_number('0100915')->is_valid_number, '秋田県秋田市保戸野');
ok($zip->set_number('0100916')->is_valid_number, '秋田県秋田市泉北');
ok($zip->set_number('0100917')->is_valid_number, '秋田県秋田市泉中央');
ok($zip->set_number('0100918')->is_valid_number, '秋田県秋田市泉南');
ok($zip->set_number('0100921')->is_valid_number, '秋田県秋田市大町');
ok($zip->set_number('0100922')->is_valid_number, '秋田県秋田市旭北栄町');
ok($zip->set_number('0100923')->is_valid_number, '秋田県秋田市旭北錦町');
ok($zip->set_number('0100924')->is_valid_number, '秋田県秋田市旭北寺町');
ok($zip->set_number('0100925')->is_valid_number, '秋田県秋田市旭南');
ok($zip->set_number('0100931')->is_valid_number, '秋田県秋田市川元山下町');
ok($zip->set_number('0100932')->is_valid_number, '秋田県秋田市川元開和町');
ok($zip->set_number('0100933')->is_valid_number, '秋田県秋田市川元松丘町');
ok($zip->set_number('0100934')->is_valid_number, '秋田県秋田市川元むつみ町');
ok($zip->set_number('0100935')->is_valid_number, '秋田県秋田市川元小川町');
ok($zip->set_number('0100941')->is_valid_number, '秋田県秋田市川尻町');
ok($zip->set_number('0100942')->is_valid_number, '秋田県秋田市川尻大川町');
ok($zip->set_number('0100943')->is_valid_number, '秋田県秋田市川尻御休町');
ok($zip->set_number('0100944')->is_valid_number, '秋田県秋田市川尻若葉町');
ok($zip->set_number('0100945')->is_valid_number, '秋田県秋田市川尻みよし町');
ok($zip->set_number('0100946')->is_valid_number, '秋田県秋田市川尻総社町');
ok($zip->set_number('0100947')->is_valid_number, '秋田県秋田市川尻上野町');
ok($zip->set_number('0100948')->is_valid_number, '秋田県秋田市川尻新川町');
ok($zip->set_number('0100951')->is_valid_number, '秋田県秋田市山王');
ok($zip->set_number('0100952')->is_valid_number, '秋田県秋田市山王新町');
ok($zip->set_number('0100953')->is_valid_number, '秋田県秋田市山王中園町');
ok($zip->set_number('0100954')->is_valid_number, '秋田県秋田市山王沼田町');
ok($zip->set_number('0100955')->is_valid_number, '秋田県秋田市山王中島町');
ok($zip->set_number('0100956')->is_valid_number, '秋田県秋田市山王臨海町');
ok($zip->set_number('0100961')->is_valid_number, '秋田県秋田市八橋イサノ');
ok($zip->set_number('0100962')->is_valid_number, '秋田県秋田市八橋大畑');
ok($zip->set_number('0100963')->is_valid_number, '秋田県秋田市八橋大沼町');
ok($zip->set_number('0100964')->is_valid_number, '秋田県秋田市八橋鯲沼町');
ok($zip->set_number('0100965')->is_valid_number, '秋田県秋田市八橋新川向');
ok($zip->set_number('0100966')->is_valid_number, '秋田県秋田市高陽青柳町');
ok($zip->set_number('0100967')->is_valid_number, '秋田県秋田市高陽幸町');
ok($zip->set_number('0100971')->is_valid_number, '秋田県秋田市八橋三和町');
ok($zip->set_number('0100972')->is_valid_number, '秋田県秋田市八橋田五郎');
ok($zip->set_number('0100973')->is_valid_number, '秋田県秋田市八橋本町');
ok($zip->set_number('0100974')->is_valid_number, '秋田県秋田市八橋運動公園');
ok($zip->set_number('0100975')->is_valid_number, '秋田県秋田市八橋');
ok($zip->set_number('0100976')->is_valid_number, '秋田県秋田市八橋南');
ok($zip->set_number('0100977')->is_valid_number, '秋田県秋田市八橋大道東');
ok($zip->set_number('0101101')->is_valid_number, '秋田県秋田市太平八田');
ok($zip->set_number('0101102')->is_valid_number, '秋田県秋田市太平目長崎');
ok($zip->set_number('0101103')->is_valid_number, '秋田県秋田市太平中関');
ok($zip->set_number('0101104')->is_valid_number, '秋田県秋田市太平寺庭');
ok($zip->set_number('0101105')->is_valid_number, '秋田県秋田市太平黒沢');
ok($zip->set_number('0101106')->is_valid_number, '秋田県秋田市太平山谷');
ok($zip->set_number('0101201')->is_valid_number, '秋田県秋田市雄和田草川');
ok($zip->set_number('0101202')->is_valid_number, '秋田県秋田市雄和芝野新田');
ok($zip->set_number('0101203')->is_valid_number, '秋田県秋田市雄和下黒瀬');
ok($zip->set_number('0101211')->is_valid_number, '秋田県秋田市雄和椿川');
ok($zip->set_number('0101212')->is_valid_number, '秋田県秋田市雄和平尾鳥');
ok($zip->set_number('0101221')->is_valid_number, '秋田県秋田市雄和平沢');
ok($zip->set_number('0101222')->is_valid_number, '秋田県秋田市雄和石田');
ok($zip->set_number('0101223')->is_valid_number, '秋田県秋田市雄和妙法');
ok($zip->set_number('0101224')->is_valid_number, '秋田県秋田市雄和種沢');
ok($zip->set_number('0101225')->is_valid_number, '秋田県秋田市雄和左手子');
ok($zip->set_number('0101231')->is_valid_number, '秋田県秋田市雄和相川');
ok($zip->set_number('0101232')->is_valid_number, '秋田県秋田市雄和戸賀沢');
ok($zip->set_number('0101233')->is_valid_number, '秋田県秋田市雄和女米木');
ok($zip->set_number('0101341')->is_valid_number, '秋田県秋田市雄和新波');
ok($zip->set_number('0101342')->is_valid_number, '秋田県秋田市雄和神ケ村');
ok($zip->set_number('0101343')->is_valid_number, '秋田県秋田市雄和繋');
ok($zip->set_number('0101344')->is_valid_number, '秋田県秋田市雄和向野');
ok($zip->set_number('0101351')->is_valid_number, '秋田県秋田市雄和碇田');
ok($zip->set_number('0101352')->is_valid_number, '秋田県秋田市雄和萱ケ沢');
ok($zip->set_number('0101401')->is_valid_number, '秋田県秋田市上北手大杉沢');
ok($zip->set_number('0101402')->is_valid_number, '秋田県秋田市上北手小山田');
ok($zip->set_number('0101403')->is_valid_number, '秋田県秋田市上北手荒巻');
ok($zip->set_number('0101404')->is_valid_number, '秋田県秋田市上北手古野');
ok($zip->set_number('0101405')->is_valid_number, '秋田県秋田市上北手大山田');
ok($zip->set_number('0101406')->is_valid_number, '秋田県秋田市上北手猿田');
ok($zip->set_number('0101407')->is_valid_number, '秋田県秋田市上北手百崎');
ok($zip->set_number('0101408')->is_valid_number, '秋田県秋田市上北手大戸');
ok($zip->set_number('0101411')->is_valid_number, '秋田県秋田市上北手御所野');
ok($zip->set_number('0101412')->is_valid_number, '秋田県秋田市御所野下堤');
ok($zip->set_number('0101413')->is_valid_number, '秋田県秋田市御所野地蔵田');
ok($zip->set_number('0101414')->is_valid_number, '秋田県秋田市御所野元町');
ok($zip->set_number('0101415')->is_valid_number, '秋田県秋田市御所野湯本');
ok($zip->set_number('0101416')->is_valid_number, '秋田県秋田市四ツ小屋末戸松本');
ok($zip->set_number('0101417')->is_valid_number, '秋田県秋田市四ツ小屋');
ok($zip->set_number('0101418')->is_valid_number, '秋田県秋田市四ツ小屋小阿地');
ok($zip->set_number('0101419')->is_valid_number, '秋田県秋田市御所野堤台');
ok($zip->set_number('0101421')->is_valid_number, '秋田県秋田市仁井田本町');
ok($zip->set_number('0101422')->is_valid_number, '秋田県秋田市仁井田目長田');
ok($zip->set_number('0101423')->is_valid_number, '秋田県秋田市仁井田');
ok($zip->set_number('0101424')->is_valid_number, '秋田県秋田市御野場');
ok($zip->set_number('0101425')->is_valid_number, '秋田県秋田市御野場新町');
ok($zip->set_number('0101426')->is_valid_number, '秋田県秋田市仁井田小中島');
ok($zip->set_number('0101427')->is_valid_number, '秋田県秋田市仁井田新田');
ok($zip->set_number('0101428')->is_valid_number, '秋田県秋田市大平台');
ok($zip->set_number('0101429')->is_valid_number, '秋田県秋田市山手台');
ok($zip->set_number('0101431')->is_valid_number, '秋田県秋田市仁井田二ツ屋');
ok($zip->set_number('0101432')->is_valid_number, '秋田県秋田市仁井田福島');
ok($zip->set_number('0101433')->is_valid_number, '秋田県秋田市仁井田栄町');
ok($zip->set_number('0101434')->is_valid_number, '秋田県秋田市仁井田蕗見町');
ok($zip->set_number('0101435')->is_valid_number, '秋田県秋田市仁井田潟中町');
ok($zip->set_number('0101436')->is_valid_number, '秋田県秋田市大住');
ok($zip->set_number('0101437')->is_valid_number, '秋田県秋田市仁井田緑町');
ok($zip->set_number('0101501')->is_valid_number, '秋田県秋田市下浜桂根');
ok($zip->set_number('0101502')->is_valid_number, '秋田県秋田市下浜長浜');
ok($zip->set_number('0101503')->is_valid_number, '秋田県秋田市下浜羽川');
ok($zip->set_number('0101504')->is_valid_number, '秋田県秋田市下浜名ケ沢');
ok($zip->set_number('0101505')->is_valid_number, '秋田県秋田市下浜八田');
ok($zip->set_number('0101506')->is_valid_number, '秋田県秋田市下浜楢田');
ok($zip->set_number('0101601')->is_valid_number, '秋田県秋田市向浜');
ok($zip->set_number('0101602')->is_valid_number, '秋田県秋田市新屋下川原町');
ok($zip->set_number('0101603')->is_valid_number, '秋田県秋田市新屋勝平台');
ok($zip->set_number('0101604')->is_valid_number, '秋田県秋田市新屋松美町');
ok($zip->set_number('0101605')->is_valid_number, '秋田県秋田市新屋勝平町');
ok($zip->set_number('0101606')->is_valid_number, '秋田県秋田市新屋寿町');
ok($zip->set_number('0101607')->is_valid_number, '秋田県秋田市新屋南浜町');
ok($zip->set_number('0101608')->is_valid_number, '秋田県秋田市新屋北浜町');
ok($zip->set_number('0101611')->is_valid_number, '秋田県秋田市新屋天秤野');
ok($zip->set_number('0101612')->is_valid_number, '秋田県秋田市新屋豊町');
ok($zip->set_number('0101613')->is_valid_number, '秋田県秋田市新屋朝日町');
ok($zip->set_number('0101614')->is_valid_number, '秋田県秋田市新屋割山町');
ok($zip->set_number('0101615')->is_valid_number, '秋田県秋田市新屋船場町');
ok($zip->set_number('0101616')->is_valid_number, '秋田県秋田市新屋松美ガ丘南町');
ok($zip->set_number('0101617')->is_valid_number, '秋田県秋田市新屋松美ガ丘東町');
ok($zip->set_number('0101618')->is_valid_number, '秋田県秋田市新屋松美ガ丘北町');
ok($zip->set_number('0101621')->is_valid_number, '秋田県秋田市新屋栗田町');
ok($zip->set_number('0101622')->is_valid_number, '秋田県秋田市新屋日吉町');
ok($zip->set_number('0101623')->is_valid_number, '秋田県秋田市新屋町');
ok($zip->set_number('0101631')->is_valid_number, '秋田県秋田市新屋元町');
ok($zip->set_number('0101632')->is_valid_number, '秋田県秋田市新屋大川町');
ok($zip->set_number('0101633')->is_valid_number, '秋田県秋田市新屋鳥木町');
ok($zip->set_number('0101634')->is_valid_number, '秋田県秋田市新屋沖田町');
ok($zip->set_number('0101635')->is_valid_number, '秋田県秋田市新屋前野町');
ok($zip->set_number('0101636')->is_valid_number, '秋田県秋田市新屋比内町');
ok($zip->set_number('0101637')->is_valid_number, '秋田県秋田市新屋扇町');
ok($zip->set_number('0101638')->is_valid_number, '秋田県秋田市新屋表町');
ok($zip->set_number('0101641')->is_valid_number, '秋田県秋田市新屋高美町');
ok($zip->set_number('0101642')->is_valid_number, '秋田県秋田市新屋渋谷町');
ok($zip->set_number('0101643')->is_valid_number, '秋田県秋田市新屋田尻沢東町');
ok($zip->set_number('0101644')->is_valid_number, '秋田県秋田市新屋田尻沢中町');
ok($zip->set_number('0101645')->is_valid_number, '秋田県秋田市新屋田尻沢西町');
ok($zip->set_number('0101651')->is_valid_number, '秋田県秋田市豊岩石田坂');
ok($zip->set_number('0101652')->is_valid_number, '秋田県秋田市豊岩豊巻');
ok($zip->set_number('0101653')->is_valid_number, '秋田県秋田市豊岩小山');
ok($zip->set_number('0101654')->is_valid_number, '秋田県秋田市浜田');
ok($zip->set_number('0110901')->is_valid_number, '秋田県秋田市寺内');
ok($zip->set_number('0110902')->is_valid_number, '秋田県秋田市寺内堂ノ沢');
ok($zip->set_number('0110903')->is_valid_number, '秋田県秋田市寺内油田');
ok($zip->set_number('0110904')->is_valid_number, '秋田県秋田市寺内蛭根');
ok($zip->set_number('0110905')->is_valid_number, '秋田県秋田市寺内神屋敷');
ok($zip->set_number('0110906')->is_valid_number, '秋田県秋田市寺内後城');
ok($zip->set_number('0110907')->is_valid_number, '秋田県秋田市寺内焼山');
ok($zip->set_number('0110908')->is_valid_number, '秋田県秋田市寺内大小路');
ok($zip->set_number('0110909')->is_valid_number, '秋田県秋田市寺内児桜');
ok($zip->set_number('0110911')->is_valid_number, '秋田県秋田市飯島');
ok($zip->set_number('0110912')->is_valid_number, '秋田県秋田市飯島川端');
ok($zip->set_number('0110913')->is_valid_number, '秋田県秋田市飯島鼠田');
ok($zip->set_number('0110914')->is_valid_number, '秋田県秋田市飯島美砂町');
ok($zip->set_number('0110915')->is_valid_number, '秋田県秋田市飯島緑丘町');
ok($zip->set_number('0110916')->is_valid_number, '秋田県秋田市飯島穀丁');
ok($zip->set_number('0110917')->is_valid_number, '秋田県秋田市飯島道東');
ok($zip->set_number('0110921')->is_valid_number, '秋田県秋田市飯島松根西町');
ok($zip->set_number('0110922')->is_valid_number, '秋田県秋田市飯島松根東町');
ok($zip->set_number('0110923')->is_valid_number, '秋田県秋田市飯島文京町');
ok($zip->set_number('0110924')->is_valid_number, '秋田県秋田市飯島長野本町');
ok($zip->set_number('0110925')->is_valid_number, '秋田県秋田市飯島長野中町');
ok($zip->set_number('0110926')->is_valid_number, '秋田県秋田市港北松野町');
ok($zip->set_number('0110927')->is_valid_number, '秋田県秋田市港北新町');
ok($zip->set_number('0110928')->is_valid_number, '秋田県秋田市飯島長野上町');
ok($zip->set_number('0110931')->is_valid_number, '秋田県秋田市将軍野東');
ok($zip->set_number('0110932')->is_valid_number, '秋田県秋田市将軍野青山町');
ok($zip->set_number('0110933')->is_valid_number, '秋田県秋田市将軍野堰越');
ok($zip->set_number('0110934')->is_valid_number, '秋田県秋田市将軍野桂町');
ok($zip->set_number('0110935')->is_valid_number, '秋田県秋田市将軍野向山');
ok($zip->set_number('0110936')->is_valid_number, '秋田県秋田市将軍野南');
ok($zip->set_number('0110937')->is_valid_number, '秋田県秋田市寺内高野');
ok($zip->set_number('0110938')->is_valid_number, '秋田県秋田市寺内鵜ノ木');
ok($zip->set_number('0110939')->is_valid_number, '秋田県秋田市寺内大畑');
ok($zip->set_number('0110941')->is_valid_number, '秋田県秋田市土崎港北');
ok($zip->set_number('0110942')->is_valid_number, '秋田県秋田市土崎港東');
ok($zip->set_number('0110943')->is_valid_number, '秋田県秋田市土崎港南');
ok($zip->set_number('0110944')->is_valid_number, '秋田県秋田市土崎港穀保町');
ok($zip->set_number('0110945')->is_valid_number, '秋田県秋田市土崎港西');
ok($zip->set_number('0110946')->is_valid_number, '秋田県秋田市土崎港中央');
ok($zip->set_number('0110947')->is_valid_number, '秋田県秋田市飯島新町');
ok($zip->set_number('0110948')->is_valid_number, '秋田県秋田市飯島西袋');
ok($zip->set_number('0110949')->is_valid_number, '秋田県秋田市飯島飯田');
ok($zip->set_number('0110951')->is_valid_number, '秋田県秋田市土崎港相染町');
ok($zip->set_number('0110951')->is_valid_number, '秋田県秋田市土崎港古川町');
ok($zip->set_number('0120000')->is_valid_number, '秋田県湯沢市以下に掲載がない場合');
ok($zip->set_number('0120001')->is_valid_number, '秋田県湯沢市角間');
ok($zip->set_number('0120002')->is_valid_number, '秋田県湯沢市下二井田');
ok($zip->set_number('0120003')->is_valid_number, '秋田県湯沢市上二井田');
ok($zip->set_number('0120004')->is_valid_number, '秋田県湯沢市二井田');
ok($zip->set_number('0120005')->is_valid_number, '秋田県湯沢市金谷');
ok($zip->set_number('0120006')->is_valid_number, '秋田県湯沢市柳田');
ok($zip->set_number('0120007')->is_valid_number, '秋田県湯沢市八幡');
ok($zip->set_number('0120008')->is_valid_number, '秋田県湯沢市高前');
ok($zip->set_number('0120011')->is_valid_number, '秋田県湯沢市森');
ok($zip->set_number('0120012')->is_valid_number, '秋田県湯沢市大森');
ok($zip->set_number('0120013')->is_valid_number, '秋田県湯沢市栄田');
ok($zip->set_number('0120014')->is_valid_number, '秋田県湯沢市大倉谷地');
ok($zip->set_number('0120015')->is_valid_number, '秋田県湯沢市倉内');
ok($zip->set_number('0120016')->is_valid_number, '秋田県湯沢市千刈');
ok($zip->set_number('0120017')->is_valid_number, '秋田県湯沢市富士見');
ok($zip->set_number('0120021')->is_valid_number, '秋田県湯沢市黄金原');
ok($zip->set_number('0120022')->is_valid_number, '秋田県湯沢市祝田');
ok($zip->set_number('0120023')->is_valid_number, '秋田県湯沢市沖田');
ok($zip->set_number('0120024')->is_valid_number, '秋田県湯沢市赤土');
ok($zip->set_number('0120025')->is_valid_number, '秋田県湯沢市前島');
ok($zip->set_number('0120026')->is_valid_number, '秋田県湯沢市大島');
ok($zip->set_number('0120031')->is_valid_number, '秋田県湯沢市鶴館');
ok($zip->set_number('0120032')->is_valid_number, '秋田県湯沢市元清水');
ok($zip->set_number('0120033')->is_valid_number, '秋田県湯沢市清水町');
ok($zip->set_number('0120034')->is_valid_number, '秋田県湯沢市西新町');
ok($zip->set_number('0120035')->is_valid_number, '秋田県湯沢市幸町');
ok($zip->set_number('0120036')->is_valid_number, '秋田県湯沢市両神');
ok($zip->set_number('0120037')->is_valid_number, '秋田県湯沢市沖鶴');
ok($zip->set_number('0120041')->is_valid_number, '秋田県湯沢市中野');
ok($zip->set_number('0120042')->is_valid_number, '秋田県湯沢市小豆田');
ok($zip->set_number('0120043')->is_valid_number, '秋田県湯沢市万石');
ok($zip->set_number('0120044')->is_valid_number, '秋田県湯沢市中野々目');
ok($zip->set_number('0120045')->is_valid_number, '秋田県湯沢市岡田町');
ok($zip->set_number('0120051')->is_valid_number, '秋田県湯沢市深堀');
ok($zip->set_number('0120052')->is_valid_number, '秋田県湯沢市下中川原');
ok($zip->set_number('0120053')->is_valid_number, '秋田県湯沢市中川原');
ok($zip->set_number('0120054')->is_valid_number, '秋田県湯沢市西中川原');
ok($zip->set_number('0120055')->is_valid_number, '秋田県湯沢市山田');
ok($zip->set_number('0120056')->is_valid_number, '秋田県湯沢市藤花');
ok($zip->set_number('0120057')->is_valid_number, '秋田県湯沢市雄勝田');
ok($zip->set_number('0120061')->is_valid_number, '秋田県湯沢市松岡');
ok($zip->set_number('0120062')->is_valid_number, '秋田県湯沢市石塚');
ok($zip->set_number('0120104')->is_valid_number, '秋田県湯沢市駒形町');
ok($zip->set_number('0120105')->is_valid_number, '秋田県湯沢市川連町');
ok($zip->set_number('0120106')->is_valid_number, '秋田県湯沢市三梨町');
ok($zip->set_number('0120107')->is_valid_number, '秋田県湯沢市稲庭町');
ok($zip->set_number('0120183')->is_valid_number, '秋田県湯沢市皆瀬(その他)');
ok($zip->set_number('0120801')->is_valid_number, '秋田県湯沢市岩崎');
ok($zip->set_number('0120802')->is_valid_number, '秋田県湯沢市成沢');
ok($zip->set_number('0120803')->is_valid_number, '秋田県湯沢市杉沢新所');
ok($zip->set_number('0120804')->is_valid_number, '秋田県湯沢市杉沢');
ok($zip->set_number('0120811')->is_valid_number, '秋田県湯沢市桜通り');
ok($zip->set_number('0120812')->is_valid_number, '秋田県湯沢市東赤土山');
ok($zip->set_number('0120813')->is_valid_number, '秋田県湯沢市前森');
ok($zip->set_number('0120814')->is_valid_number, '秋田県湯沢市大工町');
ok($zip->set_number('0120815')->is_valid_number, '秋田県湯沢市古館町');
ok($zip->set_number('0120821')->is_valid_number, '秋田県湯沢市山谷');
ok($zip->set_number('0120822')->is_valid_number, '秋田県湯沢市下山谷');
ok($zip->set_number('0120823')->is_valid_number, '秋田県湯沢市湯ノ上山');
ok($zip->set_number('0120823')->is_valid_number, '秋田県湯沢市湯ノ原');
ok($zip->set_number('0120824')->is_valid_number, '秋田県湯沢市裏門');
ok($zip->set_number('0120824')->is_valid_number, '秋田県湯沢市佐竹町');
ok($zip->set_number('0120825')->is_valid_number, '秋田県湯沢市北荒町');
ok($zip->set_number('0120826')->is_valid_number, '秋田県湯沢市柳町');
ok($zip->set_number('0120827')->is_valid_number, '秋田県湯沢市表町');
ok($zip->set_number('0120831')->is_valid_number, '秋田県湯沢市角間沢');
ok($zip->set_number('0120832')->is_valid_number, '秋田県湯沢市広沢山');
ok($zip->set_number('0120833')->is_valid_number, '秋田県湯沢市カツクイ沢山');
ok($zip->set_number('0120834')->is_valid_number, '秋田県湯沢市岩ノ沢山');
ok($zip->set_number('0120835')->is_valid_number, '秋田県湯沢市鉦打沢');
ok($zip->set_number('0120836')->is_valid_number, '秋田県湯沢市金堀沢山');
ok($zip->set_number('0120837')->is_valid_number, '秋田県湯沢市西金堀沢山');
ok($zip->set_number('0120838')->is_valid_number, '秋田県湯沢市蛇野');
ok($zip->set_number('0120841')->is_valid_number, '秋田県湯沢市大町');
ok($zip->set_number('0120842')->is_valid_number, '秋田県湯沢市内舘町');
ok($zip->set_number('0120843')->is_valid_number, '秋田県湯沢市内町');
ok($zip->set_number('0120844')->is_valid_number, '秋田県湯沢市田町');
ok($zip->set_number('0120845')->is_valid_number, '秋田県湯沢市材木町');
ok($zip->set_number('0120851')->is_valid_number, '秋田県湯沢市吹張');
ok($zip->set_number('0120852')->is_valid_number, '秋田県湯沢市荒町');
ok($zip->set_number('0120853')->is_valid_number, '秋田県湯沢市新町');
ok($zip->set_number('0120854')->is_valid_number, '秋田県湯沢市鳶ケ沢山');
ok($zip->set_number('0120855')->is_valid_number, '秋田県湯沢市愛宕町');
ok($zip->set_number('0120856')->is_valid_number, '秋田県湯沢市御囲地町');
ok($zip->set_number('0120857')->is_valid_number, '秋田県湯沢市千石町');
ok($zip->set_number('0120861')->is_valid_number, '秋田県湯沢市東松沢');
ok($zip->set_number('0120862')->is_valid_number, '秋田県湯沢市関口');
ok($zip->set_number('0120863')->is_valid_number, '秋田県湯沢市下関');
ok($zip->set_number('0120864')->is_valid_number, '秋田県湯沢市上関');
ok($zip->set_number('0120865')->is_valid_number, '秋田県湯沢市沼樋');
ok($zip->set_number('0120866')->is_valid_number, '秋田県湯沢市西松沢');
ok($zip->set_number('0120867')->is_valid_number, '秋田県湯沢市南台');
ok($zip->set_number('0120868')->is_valid_number, '秋田県湯沢市西愛宕町');
ok($zip->set_number('0120869')->is_valid_number, '秋田県湯沢市若葉町');
ok($zip->set_number('0121100')->is_valid_number, '秋田県雄勝郡羽後町以下に掲載がない場合');
ok($zip->set_number('0121101')->is_valid_number, '秋田県雄勝郡羽後町大沢');
ok($zip->set_number('0121102')->is_valid_number, '秋田県雄勝郡羽後町新町');
ok($zip->set_number('0121103')->is_valid_number, '秋田県雄勝郡羽後町林崎');
ok($zip->set_number('0121104')->is_valid_number, '秋田県雄勝郡羽後町堀内');
ok($zip->set_number('0121105')->is_valid_number, '秋田県雄勝郡羽後町水沢');
ok($zip->set_number('0121106')->is_valid_number, '秋田県雄勝郡羽後町払体');
ok($zip->set_number('0121111')->is_valid_number, '秋田県雄勝郡羽後町嶋田新田');
ok($zip->set_number('0121112')->is_valid_number, '秋田県雄勝郡羽後町睦合');
ok($zip->set_number('0121113')->is_valid_number, '秋田県雄勝郡羽後町郡山');
ok($zip->set_number('0121114')->is_valid_number, '秋田県雄勝郡羽後町糠塚');
ok($zip->set_number('0121115')->is_valid_number, '秋田県雄勝郡羽後町足田');
ok($zip->set_number('0121116')->is_valid_number, '秋田県雄勝郡羽後町高尾田');
ok($zip->set_number('0121121')->is_valid_number, '秋田県雄勝郡羽後町大久保');
ok($zip->set_number('0121122')->is_valid_number, '秋田県雄勝郡羽後町柏原');
ok($zip->set_number('0121123')->is_valid_number, '秋田県雄勝郡羽後町貝沢');
ok($zip->set_number('0121124')->is_valid_number, '秋田県雄勝郡羽後町赤袴');
ok($zip->set_number('0121125')->is_valid_number, '秋田県雄勝郡羽後町野中');
ok($zip->set_number('0121126')->is_valid_number, '秋田県雄勝郡羽後町杉宮');
ok($zip->set_number('0121131')->is_valid_number, '秋田県雄勝郡羽後町西馬音内');
ok($zip->set_number('0121132')->is_valid_number, '秋田県雄勝郡羽後町大戸');
ok($zip->set_number('0121133')->is_valid_number, '秋田県雄勝郡羽後町床舞');
ok($zip->set_number('0121134')->is_valid_number, '秋田県雄勝郡羽後町田沢');
ok($zip->set_number('0121135')->is_valid_number, '秋田県雄勝郡羽後町鹿内');
ok($zip->set_number('0121136')->is_valid_number, '秋田県雄勝郡羽後町飯沢');
ok($zip->set_number('0121137')->is_valid_number, '秋田県雄勝郡羽後町西馬音内堀回');
ok($zip->set_number('0121241')->is_valid_number, '秋田県雄勝郡羽後町田代');
ok($zip->set_number('0121242')->is_valid_number, '秋田県雄勝郡羽後町上到米');
ok($zip->set_number('0121243')->is_valid_number, '秋田県雄勝郡羽後町軽井沢');
ok($zip->set_number('0121351')->is_valid_number, '秋田県雄勝郡羽後町下仙道');
ok($zip->set_number('0121352')->is_valid_number, '秋田県雄勝郡羽後町中仙道');
ok($zip->set_number('0121353')->is_valid_number, '秋田県雄勝郡羽後町上仙道');
ok($zip->set_number('0130000')->is_valid_number, '秋田県横手市以下に掲載がない場合');
ok($zip->set_number('0130001')->is_valid_number, '秋田県横手市杉沢');
ok($zip->set_number('0130002')->is_valid_number, '秋田県横手市追廻');
ok($zip->set_number('0130003')->is_valid_number, '秋田県横手市台所町');
ok($zip->set_number('0130004')->is_valid_number, '秋田県横手市明永町');
ok($zip->set_number('0130005')->is_valid_number, '秋田県横手市幸町');
ok($zip->set_number('0130006')->is_valid_number, '秋田県横手市新坂町');
ok($zip->set_number('0130007')->is_valid_number, '秋田県横手市大鳥町');
ok($zip->set_number('0130008')->is_valid_number, '秋田県横手市睦成');
ok($zip->set_number('0130011')->is_valid_number, '秋田県横手市城西町');
ok($zip->set_number('0130012')->is_valid_number, '秋田県横手市城山町');
ok($zip->set_number('0130013')->is_valid_number, '秋田県横手市城南町');
ok($zip->set_number('0130014')->is_valid_number, '秋田県横手市上内町');
ok($zip->set_number('0130015')->is_valid_number, '秋田県横手市羽黒町');
ok($zip->set_number('0130016')->is_valid_number, '秋田県横手市根岸町');
ok($zip->set_number('0130017')->is_valid_number, '秋田県横手市蛇の崎町');
ok($zip->set_number('0130018')->is_valid_number, '秋田県横手市本町');
ok($zip->set_number('0130019')->is_valid_number, '秋田県横手市二葉町');
ok($zip->set_number('0130021')->is_valid_number, '秋田県横手市大町');
ok($zip->set_number('0130022')->is_valid_number, '秋田県横手市四日町');
ok($zip->set_number('0130023')->is_valid_number, '秋田県横手市中央町');
ok($zip->set_number('0130024')->is_valid_number, '秋田県横手市田中町');
ok($zip->set_number('0130025')->is_valid_number, '秋田県横手市寿町');
ok($zip->set_number('0130026')->is_valid_number, '秋田県横手市大水戸町');
ok($zip->set_number('0130027')->is_valid_number, '秋田県横手市平城町');
ok($zip->set_number('0130028')->is_valid_number, '秋田県横手市朝倉町');
ok($zip->set_number('0130031')->is_valid_number, '秋田県横手市鍛冶町');
ok($zip->set_number('0130032')->is_valid_number, '秋田県横手市清川町');
ok($zip->set_number('0130033')->is_valid_number, '秋田県横手市旭川');
ok($zip->set_number('0130034')->is_valid_number, '秋田県横手市本郷町');
ok($zip->set_number('0130035')->is_valid_number, '秋田県横手市平和町');
ok($zip->set_number('0130036')->is_valid_number, '秋田県横手市駅前町');
ok($zip->set_number('0130037')->is_valid_number, '秋田県横手市前郷二番町');
ok($zip->set_number('0130038')->is_valid_number, '秋田県横手市前郷一番町');
ok($zip->set_number('0130041')->is_valid_number, '秋田県横手市大沢');
ok($zip->set_number('0130042')->is_valid_number, '秋田県横手市前郷');
ok($zip->set_number('0130043')->is_valid_number, '秋田県横手市安田');
ok($zip->set_number('0130044')->is_valid_number, '秋田県横手市横山町');
ok($zip->set_number('0130045')->is_valid_number, '秋田県横手市南町');
ok($zip->set_number('0130046')->is_valid_number, '秋田県横手市神明町');
ok($zip->set_number('0130047')->is_valid_number, '秋田県横手市松原町');
ok($zip->set_number('0130048')->is_valid_number, '秋田県横手市安田原町');
ok($zip->set_number('0130051')->is_valid_number, '秋田県横手市大屋新町');
ok($zip->set_number('0130052')->is_valid_number, '秋田県横手市大屋寺内');
ok($zip->set_number('0130053')->is_valid_number, '秋田県横手市外目');
ok($zip->set_number('0130054')->is_valid_number, '秋田県横手市柳田');
ok($zip->set_number('0130055')->is_valid_number, '秋田県横手市朝日が丘');
ok($zip->set_number('0130056')->is_valid_number, '秋田県横手市清水町新田');
ok($zip->set_number('0130060')->is_valid_number, '秋田県横手市条里');
ok($zip->set_number('0130061')->is_valid_number, '秋田県横手市横手町');
ok($zip->set_number('0130062')->is_valid_number, '秋田県横手市駅南');
ok($zip->set_number('0130063')->is_valid_number, '秋田県横手市婦気大堤');
ok($zip->set_number('0130064')->is_valid_number, '秋田県横手市赤坂');
ok($zip->set_number('0130065')->is_valid_number, '秋田県横手市猪岡');
ok($zip->set_number('0130066')->is_valid_number, '秋田県横手市塚堀');
ok($zip->set_number('0130068')->is_valid_number, '秋田県横手市梅の木町');
ok($zip->set_number('0130069')->is_valid_number, '秋田県横手市三枚橋');
ok($zip->set_number('0130071')->is_valid_number, '秋田県横手市八幡');
ok($zip->set_number('0130072')->is_valid_number, '秋田県横手市卸町');
ok($zip->set_number('0130073')->is_valid_number, '秋田県横手市赤川');
ok($zip->set_number('0130074')->is_valid_number, '秋田県横手市三本柳');
ok($zip->set_number('0130075')->is_valid_number, '秋田県横手市静町');
ok($zip->set_number('0130076')->is_valid_number, '秋田県横手市杉目');
ok($zip->set_number('0130101')->is_valid_number, '秋田県横手市平鹿町上吉田');
ok($zip->set_number('0130102')->is_valid_number, '秋田県横手市平鹿町醍醐');
ok($zip->set_number('0130103')->is_valid_number, '秋田県横手市平鹿町下鍋倉');
ok($zip->set_number('0130104')->is_valid_number, '秋田県横手市平鹿町樽見内');
ok($zip->set_number('0130105')->is_valid_number, '秋田県横手市平鹿町浅舞');
ok($zip->set_number('0130106')->is_valid_number, '秋田県横手市平鹿町中吉田');
ok($zip->set_number('0130107')->is_valid_number, '秋田県横手市平鹿町下吉田');
ok($zip->set_number('0130201')->is_valid_number, '秋田県横手市雄物川町会塚');
ok($zip->set_number('0130202')->is_valid_number, '秋田県横手市雄物川町砂子田');
ok($zip->set_number('0130203')->is_valid_number, '秋田県横手市雄物川町東里');
ok($zip->set_number('0130204')->is_valid_number, '秋田県横手市雄物川町谷地新田');
ok($zip->set_number('0130205')->is_valid_number, '秋田県横手市雄物川町今宿');
ok($zip->set_number('0130206')->is_valid_number, '秋田県横手市雄物川町二井山');
ok($zip->set_number('0130207')->is_valid_number, '秋田県横手市雄物川町矢神');
ok($zip->set_number('0130208')->is_valid_number, '秋田県横手市雄物川町沼館');
ok($zip->set_number('0130211')->is_valid_number, '秋田県横手市雄物川町深井');
ok($zip->set_number('0130212')->is_valid_number, '秋田県横手市雄物川町造山');
ok($zip->set_number('0130213')->is_valid_number, '秋田県横手市雄物川町南形');
ok($zip->set_number('0130214')->is_valid_number, '秋田県横手市雄物川町柏木');
ok($zip->set_number('0130215')->is_valid_number, '秋田県横手市雄物川町常野');
ok($zip->set_number('0130216')->is_valid_number, '秋田県横手市雄物川町西野');
ok($zip->set_number('0130217')->is_valid_number, '秋田県横手市雄物川町道地');
ok($zip->set_number('0130218')->is_valid_number, '秋田県横手市雄物川町大沢');
ok($zip->set_number('0130301')->is_valid_number, '秋田県横手市大雄福島');
ok($zip->set_number('0130302')->is_valid_number, '秋田県横手市大雄新町北');
ok($zip->set_number('0130303')->is_valid_number, '秋田県横手市大雄福島南');
ok($zip->set_number('0130304')->is_valid_number, '秋田県横手市大雄新町南');
ok($zip->set_number('0130305')->is_valid_number, '秋田県横手市大雄柏木南');
ok($zip->set_number('0130306')->is_valid_number, '秋田県横手市大雄田村');
ok($zip->set_number('0130307')->is_valid_number, '秋田県横手市大雄新町東');
ok($zip->set_number('0130308')->is_valid_number, '秋田県横手市大雄佐加里');
ok($zip->set_number('0130309')->is_valid_number, '秋田県横手市大雄佐加里南');
ok($zip->set_number('0130311')->is_valid_number, '秋田県横手市大雄中野東');
ok($zip->set_number('0130312')->is_valid_number, '秋田県横手市大雄中野');
ok($zip->set_number('0130313')->is_valid_number, '秋田県横手市大雄大森道北');
ok($zip->set_number('0130314')->is_valid_number, '秋田県横手市大雄傾城塚');
ok($zip->set_number('0130315')->is_valid_number, '秋田県横手市大雄下根田谷地');
ok($zip->set_number('0130316')->is_valid_number, '秋田県横手市大雄潤井谷地');
ok($zip->set_number('0130317')->is_valid_number, '秋田県横手市大雄大戸川端');
ok($zip->set_number('0130318')->is_valid_number, '秋田県横手市大雄根田谷地南');
ok($zip->set_number('0130319')->is_valid_number, '秋田県横手市大雄四ツ屋東');
ok($zip->set_number('0130321')->is_valid_number, '秋田県横手市大雄根田谷地西');
ok($zip->set_number('0130322')->is_valid_number, '秋田県横手市大雄伝蔵村');
ok($zip->set_number('0130323')->is_valid_number, '秋田県横手市大雄根田谷地東');
ok($zip->set_number('0130324')->is_valid_number, '秋田県横手市大雄根田谷地');
ok($zip->set_number('0130325')->is_valid_number, '秋田県横手市大雄田根森東');
ok($zip->set_number('0130326')->is_valid_number, '秋田県横手市大雄上田村東');
ok($zip->set_number('0130327')->is_valid_number, '秋田県横手市大雄焼野');
ok($zip->set_number('0130331')->is_valid_number, '秋田県横手市大雄東高津野');
ok($zip->set_number('0130332')->is_valid_number, '秋田県横手市大雄新町西野添');
ok($zip->set_number('0130333')->is_valid_number, '秋田県横手市大雄新町西');
ok($zip->set_number('0130334')->is_valid_number, '秋田県横手市大雄新町');
ok($zip->set_number('0130335')->is_valid_number, '秋田県横手市大雄折橋');
ok($zip->set_number('0130336')->is_valid_number, '秋田県横手市大雄傾城塚南');
ok($zip->set_number('0130337')->is_valid_number, '秋田県横手市大雄折橋南');
ok($zip->set_number('0130338')->is_valid_number, '秋田県横手市大雄耳取西');
ok($zip->set_number('0130339')->is_valid_number, '秋田県横手市大雄耳取');
ok($zip->set_number('0130341')->is_valid_number, '秋田県横手市大雄四ッ屋');
ok($zip->set_number('0130342')->is_valid_number, '秋田県横手市大雄精兵村');
ok($zip->set_number('0130343')->is_valid_number, '秋田県横手市大雄田根森西');
ok($zip->set_number('0130344')->is_valid_number, '秋田県横手市大雄精兵西');
ok($zip->set_number('0130345')->is_valid_number, '秋田県横手市大雄本庄道北堰間');
ok($zip->set_number('0130346')->is_valid_number, '秋田県横手市大雄四ツ屋西');
ok($zip->set_number('0130347')->is_valid_number, '秋田県横手市大雄本庄道南');
ok($zip->set_number('0130348')->is_valid_number, '秋田県横手市大雄田根森');
ok($zip->set_number('0130349')->is_valid_number, '秋田県横手市大雄上田村西');
ok($zip->set_number('0130351')->is_valid_number, '秋田県横手市大雄上田村');
ok($zip->set_number('0130352')->is_valid_number, '秋田県横手市大雄一ノ関東');
ok($zip->set_number('0130353')->is_valid_number, '秋田県横手市大雄一ノ関');
ok($zip->set_number('0130354')->is_valid_number, '秋田県横手市大雄狐塚');
ok($zip->set_number('0130355')->is_valid_number, '秋田県横手市大雄上桜森');
ok($zip->set_number('0130356')->is_valid_number, '秋田県横手市大雄一ノ関南');
ok($zip->set_number('0130357')->is_valid_number, '秋田県横手市大雄向東');
ok($zip->set_number('0130358')->is_valid_number, '秋田県横手市大雄向');
ok($zip->set_number('0130359')->is_valid_number, '秋田県横手市大雄柏木');
ok($zip->set_number('0130361')->is_valid_number, '秋田県横手市大雄柏木西');
ok($zip->set_number('0130362')->is_valid_number, '秋田県横手市大雄柏木下');
ok($zip->set_number('0130363')->is_valid_number, '秋田県横手市大雄桜森西');
ok($zip->set_number('0130364')->is_valid_number, '秋田県横手市大雄袋谷地');
ok($zip->set_number('0130365')->is_valid_number, '秋田県横手市大雄鍛治村');
ok($zip->set_number('0130371')->is_valid_number, '秋田県横手市大雄文蔵開');
ok($zip->set_number('0130372')->is_valid_number, '秋田県横手市大雄上田村南');
ok($zip->set_number('0130373')->is_valid_number, '秋田県横手市大雄八柏谷地');
ok($zip->set_number('0130374')->is_valid_number, '秋田県横手市大雄八柏中村東');
ok($zip->set_number('0130375')->is_valid_number, '秋田県横手市大雄八柏釜蓋');
ok($zip->set_number('0130376')->is_valid_number, '秋田県横手市大雄八柏馬道添');
ok($zip->set_number('0130377')->is_valid_number, '秋田県横手市大雄八柏中村');
ok($zip->set_number('0130378')->is_valid_number, '秋田県横手市大雄八柏街道添');
ok($zip->set_number('0130379')->is_valid_number, '秋田県横手市大雄八柏家間');
ok($zip->set_number('0130381')->is_valid_number, '秋田県横手市大雄八柏下村');
ok($zip->set_number('0130382')->is_valid_number, '秋田県横手市大雄上堰東');
ok($zip->set_number('0130383')->is_valid_number, '秋田県横手市大雄八柏村西');
ok($zip->set_number('0130384')->is_valid_number, '秋田県横手市大雄八柏村表');
ok($zip->set_number('0130385')->is_valid_number, '秋田県横手市大雄万貝');
ok($zip->set_number('0130402')->is_valid_number, '秋田県横手市大雄八柏');
ok($zip->set_number('0130404')->is_valid_number, '秋田県横手市大雄上柏木');
ok($zip->set_number('0130405')->is_valid_number, '秋田県横手市大雄南四津屋');
ok($zip->set_number('0130406')->is_valid_number, '秋田県横手市大雄西四津屋');
ok($zip->set_number('0130407')->is_valid_number, '秋田県横手市大雄四津屋下');
ok($zip->set_number('0130408')->is_valid_number, '秋田県横手市大雄北四津屋');
ok($zip->set_number('0130409')->is_valid_number, '秋田県横手市大雄東四津屋');
ok($zip->set_number('0130411')->is_valid_number, '秋田県横手市大雄剰水東');
ok($zip->set_number('0130412')->is_valid_number, '秋田県横手市大雄剰水');
ok($zip->set_number('0130413')->is_valid_number, '秋田県横手市大雄宮田');
ok($zip->set_number('0130414')->is_valid_number, '秋田県横手市大雄藤巻');
ok($zip->set_number('0130415')->is_valid_number, '秋田県横手市大雄藤巻西');
ok($zip->set_number('0130416')->is_valid_number, '秋田県横手市大雄藤巻中島');
ok($zip->set_number('0130417')->is_valid_number, '秋田県横手市大雄六町下');
ok($zip->set_number('0130418')->is_valid_number, '秋田県横手市大雄六町東');
ok($zip->set_number('0130419')->is_valid_number, '秋田県横手市大雄六町');
ok($zip->set_number('0130421')->is_valid_number, '秋田県横手市大雄江原');
ok($zip->set_number('0130422')->is_valid_number, '秋田県横手市大雄南阿気');
ok($zip->set_number('0130423')->is_valid_number, '秋田県横手市大雄土井尻');
ok($zip->set_number('0130424')->is_valid_number, '秋田県横手市大雄中館合');
ok($zip->set_number('0130425')->is_valid_number, '秋田県横手市大雄西館合');
ok($zip->set_number('0130426')->is_valid_number, '秋田県横手市大雄木戸口');
ok($zip->set_number('0130427')->is_valid_number, '秋田県横手市大雄阿気');
ok($zip->set_number('0130428')->is_valid_number, '秋田県横手市大雄鶴巻田');
ok($zip->set_number('0130429')->is_valid_number, '秋田県横手市大雄宮小路');
ok($zip->set_number('0130431')->is_valid_number, '秋田県横手市大雄牛中島');
ok($zip->set_number('0130432')->is_valid_number, '秋田県横手市大雄東中島');
ok($zip->set_number('0130433')->is_valid_number, '秋田県横手市大雄西中島');
ok($zip->set_number('0130434')->is_valid_number, '秋田県横手市大雄山王');
ok($zip->set_number('0130435')->is_valid_number, '秋田県横手市大雄木戸口西');
ok($zip->set_number('0130436')->is_valid_number, '秋田県横手市大雄小林西');
ok($zip->set_number('0130437')->is_valid_number, '秋田県横手市大雄小林');
ok($zip->set_number('0130438')->is_valid_number, '秋田県横手市大雄木戸口下');
ok($zip->set_number('0130439')->is_valid_number, '秋田県横手市大雄山王西');
ok($zip->set_number('0130441')->is_valid_number, '秋田県横手市大雄野中');
ok($zip->set_number('0130442')->is_valid_number, '秋田県横手市大雄高津野下');
ok($zip->set_number('0130443')->is_valid_number, '秋田県横手市大雄高津野');
ok($zip->set_number('0130444')->is_valid_number, '秋田県横手市大雄向田東');
ok($zip->set_number('0130445')->is_valid_number, '秋田県横手市大雄向田');
ok($zip->set_number('0130446')->is_valid_number, '秋田県横手市大雄乗阿気');
ok($zip->set_number('0130447')->is_valid_number, '秋田県横手市大雄阿久戸');
ok($zip->set_number('0130448')->is_valid_number, '秋田県横手市大雄乗阿気下');
ok($zip->set_number('0130451')->is_valid_number, '秋田県横手市大雄折橋西');
ok($zip->set_number('0130452')->is_valid_number, '秋田県横手市大雄大関');
ok($zip->set_number('0130453')->is_valid_number, '秋田県横手市大雄三村北');
ok($zip->set_number('0130454')->is_valid_number, '秋田県横手市大雄大谷地');
ok($zip->set_number('0130455')->is_valid_number, '秋田県横手市大雄大谷地西');
ok($zip->set_number('0130456')->is_valid_number, '秋田県横手市大雄大慈寺前');
ok($zip->set_number('0130457')->is_valid_number, '秋田県横手市大雄大慈寺東');
ok($zip->set_number('0130458')->is_valid_number, '秋田県横手市大雄大慈寺谷地');
ok($zip->set_number('0130459')->is_valid_number, '秋田県横手市大雄赤沼');
ok($zip->set_number('0130461')->is_valid_number, '秋田県横手市大雄三村東');
ok($zip->set_number('0130462')->is_valid_number, '秋田県横手市大雄樋脇');
ok($zip->set_number('0130463')->is_valid_number, '秋田県横手市大雄石持前');
ok($zip->set_number('0130464')->is_valid_number, '秋田県横手市大雄石持');
ok($zip->set_number('0130465')->is_valid_number, '秋田県横手市大雄石持下');
ok($zip->set_number('0130466')->is_valid_number, '秋田県横手市大雄三村');
ok($zip->set_number('0130467')->is_valid_number, '秋田県横手市大雄三村西');
ok($zip->set_number('0130468')->is_valid_number, '秋田県横手市大雄中谷地');
ok($zip->set_number('0130471')->is_valid_number, '秋田県横手市大雄板橋堰添');
ok($zip->set_number('0130472')->is_valid_number, '秋田県横手市大雄東阿気');
ok($zip->set_number('0130473')->is_valid_number, '秋田県横手市大雄東桜森');
ok($zip->set_number('0130474')->is_valid_number, '秋田県横手市大雄桜森');
ok($zip->set_number('0130475')->is_valid_number, '秋田県横手市大雄桜森前');
ok($zip->set_number('0130476')->is_valid_number, '秋田県横手市大雄西桜森');
ok($zip->set_number('0130477')->is_valid_number, '秋田県横手市大雄桜森東');
ok($zip->set_number('0130481')->is_valid_number, '秋田県横手市雄物川町薄井');
ok($zip->set_number('0130482')->is_valid_number, '秋田県横手市大雄平柳');
ok($zip->set_number('0130483')->is_valid_number, '秋田県横手市大雄島田');
ok($zip->set_number('0130484')->is_valid_number, '秋田県横手市大雄新処');
ok($zip->set_number('0130485')->is_valid_number, '秋田県横手市大雄下新処');
ok($zip->set_number('0130486')->is_valid_number, '秋田県横手市大雄田町');
ok($zip->set_number('0130487')->is_valid_number, '秋田県横手市大雄下田町');
ok($zip->set_number('0130488')->is_valid_number, '秋田県横手市大雄東館合');
ok($zip->set_number('0130501')->is_valid_number, '秋田県横手市大森町板井田');
ok($zip->set_number('0130502')->is_valid_number, '秋田県横手市大森町袴形');
ok($zip->set_number('0130503')->is_valid_number, '秋田県横手市大森町十日町');
ok($zip->set_number('0130511')->is_valid_number, '秋田県横手市大森町牛中島');
ok($zip->set_number('0130512')->is_valid_number, '秋田県横手市大森町湯ノ沢');
ok($zip->set_number('0130513')->is_valid_number, '秋田県横手市大森町湯ノ島');
ok($zip->set_number('0130514')->is_valid_number, '秋田県横手市大森町大中島');
ok($zip->set_number('0130515')->is_valid_number, '秋田県横手市大森町西中島');
ok($zip->set_number('0130516')->is_valid_number, '秋田県横手市大森町東中島');
ok($zip->set_number('0130517')->is_valid_number, '秋田県横手市大森町高口下水戸堤');
ok($zip->set_number('0130518')->is_valid_number, '秋田県横手市大森町文天鏡田');
ok($zip->set_number('0130519')->is_valid_number, '秋田県横手市大森町持向');
ok($zip->set_number('0130521')->is_valid_number, '秋田県横手市大森町大森');
ok($zip->set_number('0130522')->is_valid_number, '秋田県横手市大森町町回');
ok($zip->set_number('0130523')->is_valid_number, '秋田県横手市大森町堂林');
ok($zip->set_number('0130524')->is_valid_number, '秋田県横手市大森町清水上');
ok($zip->set_number('0130525')->is_valid_number, '秋田県横手市大森町菅生田');
ok($zip->set_number('0130526')->is_valid_number, '秋田県横手市大森町西野');
ok($zip->set_number('0130531')->is_valid_number, '秋田県横手市大森町佐渡');
ok($zip->set_number('0130532')->is_valid_number, '秋田県横手市大森町久保');
ok($zip->set_number('0130533')->is_valid_number, '秋田県横手市大森町中田');
ok($zip->set_number('0130534')->is_valid_number, '秋田県横手市大森町峠町頭');
ok($zip->set_number('0130535')->is_valid_number, '秋田県横手市大森町町田');
ok($zip->set_number('0130536')->is_valid_number, '秋田県横手市大森町真山');
ok($zip->set_number('0130541')->is_valid_number, '秋田県横手市大森町中嶋');
ok($zip->set_number('0130542')->is_valid_number, '秋田県横手市大森町高野中島');
ok($zip->set_number('0130543')->is_valid_number, '秋田県横手市大森町本郷');
ok($zip->set_number('0130544')->is_valid_number, '秋田県横手市大森町長助巻');
ok($zip->set_number('0130545')->is_valid_number, '秋田県横手市大森町鯲沼');
ok($zip->set_number('0130546')->is_valid_number, '秋田県横手市大森町牛ケ沢');
ok($zip->set_number('0130551')->is_valid_number, '秋田県横手市大森町猿田');
ok($zip->set_number('0130552')->is_valid_number, '秋田県横手市大森町上溝');
ok($zip->set_number('0130561')->is_valid_number, '秋田県横手市大森町八沢木');
ok($zip->set_number('0130562')->is_valid_number, '秋田県横手市大森町坂部');
ok($zip->set_number('0130811')->is_valid_number, '秋田県横手市安本');
ok($zip->set_number('0130812')->is_valid_number, '秋田県横手市金沢本町');
ok($zip->set_number('0130813')->is_valid_number, '秋田県横手市金沢');
ok($zip->set_number('0130814')->is_valid_number, '秋田県横手市金沢中野');
ok($zip->set_number('0130821')->is_valid_number, '秋田県横手市上境');
ok($zip->set_number('0130822')->is_valid_number, '秋田県横手市上八丁');
ok($zip->set_number('0130823')->is_valid_number, '秋田県横手市下八丁');
ok($zip->set_number('0130824')->is_valid_number, '秋田県横手市下境');
ok($zip->set_number('0130825')->is_valid_number, '秋田県横手市百万刈');
ok($zip->set_number('0130826')->is_valid_number, '秋田県横手市黒川');
ok($zip->set_number('0140000')->is_valid_number, '秋田県大仙市以下に掲載がない場合');
ok($zip->set_number('0140001')->is_valid_number, '秋田県大仙市花館');
ok($zip->set_number('0140002')->is_valid_number, '秋田県大仙市花館上町');
ok($zip->set_number('0140003')->is_valid_number, '秋田県大仙市美原町');
ok($zip->set_number('0140004')->is_valid_number, '秋田県大仙市泉町');
ok($zip->set_number('0140005')->is_valid_number, '秋田県大仙市花館柳町');
ok($zip->set_number('0140006')->is_valid_number, '秋田県大仙市花館中町');
ok($zip->set_number('0140011')->is_valid_number, '秋田県大仙市富士見町');
ok($zip->set_number('0140012')->is_valid_number, '秋田県大仙市幸町');
ok($zip->set_number('0140013')->is_valid_number, '秋田県大仙市朝日町');
ok($zip->set_number('0140014')->is_valid_number, '秋田県大仙市大曲福住町');
ok($zip->set_number('0140015')->is_valid_number, '秋田県大仙市大曲白金町');
ok($zip->set_number('0140016')->is_valid_number, '秋田県大仙市若竹町');
ok($zip->set_number('0140017')->is_valid_number, '秋田県大仙市佐野町');
ok($zip->set_number('0140021')->is_valid_number, '秋田県大仙市福田町');
ok($zip->set_number('0140022')->is_valid_number, '秋田県大仙市大花町');
ok($zip->set_number('0140023')->is_valid_number, '秋田県大仙市大曲黒瀬町');
ok($zip->set_number('0140024')->is_valid_number, '秋田県大仙市大曲中通町');
ok($zip->set_number('0140025')->is_valid_number, '秋田県大仙市大曲大町');
ok($zip->set_number('0140026')->is_valid_number, '秋田県大仙市大曲丸の内町');
ok($zip->set_number('0140027')->is_valid_number, '秋田県大仙市大曲通町');
ok($zip->set_number('0140031')->is_valid_number, '秋田県大仙市大曲');
ok($zip->set_number('0140032')->is_valid_number, '秋田県大仙市東川');
ok($zip->set_number('0140033')->is_valid_number, '秋田県大仙市和合');
ok($zip->set_number('0140034')->is_valid_number, '秋田県大仙市大曲住吉町');
ok($zip->set_number('0140041')->is_valid_number, '秋田県大仙市大曲丸子町');
ok($zip->set_number('0140042')->is_valid_number, '秋田県大仙市大曲福見町');
ok($zip->set_number('0140043')->is_valid_number, '秋田県大仙市大曲戸巻町');
ok($zip->set_number('0140044')->is_valid_number, '秋田県大仙市戸蒔');
ok($zip->set_number('0140045')->is_valid_number, '秋田県大仙市大曲若葉町');
ok($zip->set_number('0140046')->is_valid_number, '秋田県大仙市大曲田町');
ok($zip->set_number('0140047')->is_valid_number, '秋田県大仙市大曲須和町');
ok($zip->set_number('0140048')->is_valid_number, '秋田県大仙市大曲上大町');
ok($zip->set_number('0140051')->is_valid_number, '秋田県大仙市大曲浜町');
ok($zip->set_number('0140052')->is_valid_number, '秋田県大仙市大曲川原町');
ok($zip->set_number('0140053')->is_valid_number, '秋田県大仙市大曲花園町');
ok($zip->set_number('0140054')->is_valid_number, '秋田県大仙市大曲金谷町');
ok($zip->set_number('0140055')->is_valid_number, '秋田県大仙市大曲あけぼの町');
ok($zip->set_number('0140056')->is_valid_number, '秋田県大仙市大曲緑町');
ok($zip->set_number('0140057')->is_valid_number, '秋田県大仙市大曲船場町');
ok($zip->set_number('0140061')->is_valid_number, '秋田県大仙市大曲栄町');
ok($zip->set_number('0140062')->is_valid_number, '秋田県大仙市大曲上栄町');
ok($zip->set_number('0140063')->is_valid_number, '秋田県大仙市大曲日の出町');
ok($zip->set_number('0140064')->is_valid_number, '秋田県大仙市小貫高畑');
ok($zip->set_number('0140065')->is_valid_number, '秋田県大仙市下深井');
ok($zip->set_number('0140066')->is_valid_number, '秋田県大仙市川目');
ok($zip->set_number('0140067')->is_valid_number, '秋田県大仙市飯田');
ok($zip->set_number('0140068')->is_valid_number, '秋田県大仙市大曲飯田町');
ok($zip->set_number('0140071')->is_valid_number, '秋田県大仙市蛭川');
ok($zip->set_number('0140072')->is_valid_number, '秋田県大仙市大曲西根');
ok($zip->set_number('0140073')->is_valid_number, '秋田県大仙市内小友');
ok($zip->set_number('0140101')->is_valid_number, '秋田県大仙市松倉');
ok($zip->set_number('0140102')->is_valid_number, '秋田県大仙市四ツ屋');
ok($zip->set_number('0140103')->is_valid_number, '秋田県大仙市高関上郷');
ok($zip->set_number('0140104')->is_valid_number, '秋田県大仙市新谷地');
ok($zip->set_number('0140111')->is_valid_number, '秋田県大仙市横堀');
ok($zip->set_number('0140112')->is_valid_number, '秋田県大仙市板見内');
ok($zip->set_number('0140113')->is_valid_number, '秋田県大仙市堀見内');
ok($zip->set_number('0140114')->is_valid_number, '秋田県大仙市福田');
ok($zip->set_number('0140201')->is_valid_number, '秋田県大仙市下鶯野');
ok($zip->set_number('0140202')->is_valid_number, '秋田県大仙市上鶯野');
ok($zip->set_number('0140203')->is_valid_number, '秋田県大仙市北長野');
ok($zip->set_number('0140204')->is_valid_number, '秋田県大仙市清水');
ok($zip->set_number('0140205')->is_valid_number, '秋田県大仙市鑓見内');
ok($zip->set_number('0140206')->is_valid_number, '秋田県大仙市長戸呂');
ok($zip->set_number('0140207')->is_valid_number, '秋田県大仙市長野');
ok($zip->set_number('0140300')->is_valid_number, '秋田県仙北市以下に掲載がない場合');
ok($zip->set_number('0140301')->is_valid_number, '秋田県仙北市角館町広久内');
ok($zip->set_number('0140302')->is_valid_number, '秋田県仙北市角館町白岩');
ok($zip->set_number('0140303')->is_valid_number, '秋田県仙北市角館町薗田');
ok($zip->set_number('0140311')->is_valid_number, '秋田県仙北市角館町田町上丁');
ok($zip->set_number('0140312')->is_valid_number, '秋田県仙北市角館町田町下丁');
ok($zip->set_number('0140313')->is_valid_number, '秋田県仙北市角館町下岩瀬町');
ok($zip->set_number('0140315')->is_valid_number, '秋田県仙北市角館町下新町');
ok($zip->set_number('0140316')->is_valid_number, '秋田県仙北市角館町岩瀬町');
ok($zip->set_number('0140317')->is_valid_number, '秋田県仙北市角館町下中町');
ok($zip->set_number('0140318')->is_valid_number, '秋田県仙北市角館町中町');
ok($zip->set_number('0140321')->is_valid_number, '秋田県仙北市角館町西勝楽町');
ok($zip->set_number('0140322')->is_valid_number, '秋田県仙北市角館町七日町');
ok($zip->set_number('0140323')->is_valid_number, '秋田県仙北市角館町横町');
ok($zip->set_number('0140324')->is_valid_number, '秋田県仙北市角館町小人町');
ok($zip->set_number('0140325')->is_valid_number, '秋田県仙北市角館町東勝楽丁');
ok($zip->set_number('0140326')->is_valid_number, '秋田県仙北市角館町山根町');
ok($zip->set_number('0140327')->is_valid_number, '秋田県仙北市角館町上新町');
ok($zip->set_number('0140328')->is_valid_number, '秋田県仙北市角館町竹原町');
ok($zip->set_number('0140331')->is_valid_number, '秋田県仙北市角館町表町下丁');
ok($zip->set_number('0140332')->is_valid_number, '秋田県仙北市角館町歩行町');
ok($zip->set_number('0140333')->is_valid_number, '秋田県仙北市角館町川原町');
ok($zip->set_number('0140334')->is_valid_number, '秋田県仙北市角館町表町上丁');
ok($zip->set_number('0140335')->is_valid_number, '秋田県仙北市角館町細越町');
ok($zip->set_number('0140336')->is_valid_number, '秋田県仙北市角館町裏町');
ok($zip->set_number('0140337')->is_valid_number, '秋田県仙北市角館町古城');
ok($zip->set_number('0140341')->is_valid_number, '秋田県仙北市角館町雲然');
ok($zip->set_number('0140342')->is_valid_number, '秋田県仙北市角館町八割');
ok($zip->set_number('0140343')->is_valid_number, '秋田県仙北市角館町下延');
ok($zip->set_number('0140344')->is_valid_number, '秋田県仙北市角館町西長野');
ok($zip->set_number('0140345')->is_valid_number, '秋田県仙北市角館町山谷川崎');
ok($zip->set_number('0140346')->is_valid_number, '秋田県仙北市角館町川原');
ok($zip->set_number('0140347')->is_valid_number, '秋田県仙北市角館町小勝田');
ok($zip->set_number('0140351')->is_valid_number, '秋田県仙北市角館町古城山');
ok($zip->set_number('0140352')->is_valid_number, '秋田県仙北市角館町外ノ山');
ok($zip->set_number('0140353')->is_valid_number, '秋田県仙北市角館町西菅沢');
ok($zip->set_number('0140354')->is_valid_number, '秋田県仙北市角館町水ノ目沢');
ok($zip->set_number('0140355')->is_valid_number, '秋田県仙北市角館町外ノ山官有地');
ok($zip->set_number('0140356')->is_valid_number, '秋田県仙北市角館町花場');
ok($zip->set_number('0140357')->is_valid_number, '秋田県仙北市角館町花場下');
ok($zip->set_number('0140358')->is_valid_number, '秋田県仙北市角館町川原町後');
ok($zip->set_number('0140359')->is_valid_number, '秋田県仙北市角館町北野');
ok($zip->set_number('0140361')->is_valid_number, '秋田県仙北市角館町鳥木沢');
ok($zip->set_number('0140362')->is_valid_number, '秋田県仙北市角館町金山下');
ok($zip->set_number('0140363')->is_valid_number, '秋田県仙北市角館町下川原');
ok($zip->set_number('0140364')->is_valid_number, '秋田県仙北市角館町大中嶋');
ok($zip->set_number('0140365')->is_valid_number, '秋田県仙北市角館町菅沢');
ok($zip->set_number('0140366')->is_valid_number, '秋田県仙北市角館町下菅沢');
ok($zip->set_number('0140367')->is_valid_number, '秋田県仙北市角館町勝楽');
ok($zip->set_number('0140368')->is_valid_number, '秋田県仙北市角館町中菅沢');
ok($zip->set_number('0140369')->is_valid_number, '秋田県仙北市角館町上菅沢');
ok($zip->set_number('0140371')->is_valid_number, '秋田県仙北市角館町大風呂');
ok($zip->set_number('0140372')->is_valid_number, '秋田県仙北市角館町小館');
ok($zip->set_number('0140373')->is_valid_number, '秋田県仙北市角館町岩瀬');
ok($zip->set_number('0140374')->is_valid_number, '秋田県仙北市角館町上野');
ok($zip->set_number('0140375')->is_valid_number, '秋田県仙北市角館町岩瀬下タ野');
ok($zip->set_number('0140376')->is_valid_number, '秋田県仙北市角館町西下タ野');
ok($zip->set_number('0140377')->is_valid_number, '秋田県仙北市角館町西田');
ok($zip->set_number('0140378')->is_valid_number, '秋田県仙北市角館町西野川原');
ok($zip->set_number('0140379')->is_valid_number, '秋田県仙北市角館町西北野');
ok($zip->set_number('0140511')->is_valid_number, '秋田県仙北市西木町西明寺');
ok($zip->set_number('0140512')->is_valid_number, '秋田県仙北市西木町上荒井');
ok($zip->set_number('0140513')->is_valid_number, '秋田県仙北市西木町小渕野');
ok($zip->set_number('0140514')->is_valid_number, '秋田県仙北市西木町西荒井');
ok($zip->set_number('0140515')->is_valid_number, '秋田県仙北市西木町門屋');
ok($zip->set_number('0140516')->is_valid_number, '秋田県仙北市西木町小山田');
ok($zip->set_number('0140601')->is_valid_number, '秋田県仙北市西木町上桧木内');
ok($zip->set_number('0140602')->is_valid_number, '秋田県仙北市西木町桧木内');
ok($zip->set_number('0140711')->is_valid_number, '秋田県大仙市豊川');
ok($zip->set_number('0140712')->is_valid_number, '秋田県大仙市豊岡');
ok($zip->set_number('0140713')->is_valid_number, '秋田県大仙市栗沢');
ok($zip->set_number('0140714')->is_valid_number, '秋田県大仙市大神成');
ok($zip->set_number('0140801')->is_valid_number, '秋田県大仙市戸地谷');
ok($zip->set_number('0140802')->is_valid_number, '秋田県大仙市払田');
ok($zip->set_number('0140803')->is_valid_number, '秋田県大仙市上野田');
ok($zip->set_number('0140804')->is_valid_number, '秋田県大仙市橋本');
ok($zip->set_number('0140805')->is_valid_number, '秋田県大仙市高梨');
ok($zip->set_number('0141111')->is_valid_number, '秋田県仙北市田沢湖岡崎');
ok($zip->set_number('0141112')->is_valid_number, '秋田県仙北市田沢湖梅沢');
ok($zip->set_number('0141113')->is_valid_number, '秋田県仙北市田沢湖卒田');
ok($zip->set_number('0141114')->is_valid_number, '秋田県仙北市田沢湖神代');
ok($zip->set_number('0141115')->is_valid_number, '秋田県仙北市田沢湖小松');
ok($zip->set_number('0141116')->is_valid_number, '秋田県仙北市田沢湖角館東前郷');
ok($zip->set_number('0141201')->is_valid_number, '秋田県仙北市田沢湖生保内');
ok($zip->set_number('0141202')->is_valid_number, '秋田県仙北市田沢湖刺巻');
ok($zip->set_number('0141203')->is_valid_number, '秋田県仙北市田沢湖潟');
ok($zip->set_number('0141204')->is_valid_number, '秋田県仙北市田沢湖田沢');
ok($zip->set_number('0141205')->is_valid_number, '秋田県仙北市田沢湖玉川');
ok($zip->set_number('0141411')->is_valid_number, '秋田県大仙市六郷西根');
ok($zip->set_number('0141412')->is_valid_number, '秋田県大仙市藤木');
ok($zip->set_number('0141413')->is_valid_number, '秋田県大仙市角間川町');
ok($zip->set_number('0150000')->is_valid_number, '秋田県由利本荘市以下に掲載がない場合');
ok($zip->set_number('0150011')->is_valid_number, '秋田県由利本荘市石脇(その他)');
ok($zip->set_number('0150012')->is_valid_number, '秋田県由利本荘市石脇(田尻)');
ok($zip->set_number('0150013')->is_valid_number, '秋田県由利本荘市石脇(田尻野)');
ok($zip->set_number('0150014')->is_valid_number, '秋田県由利本荘市石脇(山ノ神)');
ok($zip->set_number('0150021')->is_valid_number, '秋田県由利本荘市大浦');
ok($zip->set_number('0150022')->is_valid_number, '秋田県由利本荘市内黒瀬');
ok($zip->set_number('0150023')->is_valid_number, '秋田県由利本荘市赤田');
ok($zip->set_number('0150024')->is_valid_number, '秋田県由利本荘市内越');
ok($zip->set_number('0150025')->is_valid_number, '秋田県由利本荘市山田');
ok($zip->set_number('0150031')->is_valid_number, '秋田県由利本荘市浜三川');
ok($zip->set_number('0150032')->is_valid_number, '秋田県由利本荘市松ケ崎');
ok($zip->set_number('0150033')->is_valid_number, '秋田県由利本荘市神沢');
ok($zip->set_number('0150034')->is_valid_number, '秋田県由利本荘市芦川');
ok($zip->set_number('0150035')->is_valid_number, '秋田県由利本荘市親川');
ok($zip->set_number('0150041')->is_valid_number, '秋田県由利本荘市薬師堂');
ok($zip->set_number('0150042')->is_valid_number, '秋田県由利本荘市埋田');
ok($zip->set_number('0150043')->is_valid_number, '秋田県由利本荘市宮内');
ok($zip->set_number('0150044')->is_valid_number, '秋田県由利本荘市玉ノ池');
ok($zip->set_number('0150045')->is_valid_number, '秋田県由利本荘市葛法');
ok($zip->set_number('0150046')->is_valid_number, '秋田県由利本荘市船岡');
ok($zip->set_number('0150047')->is_valid_number, '秋田県由利本荘市藤崎');
ok($zip->set_number('0150051')->is_valid_number, '秋田県由利本荘市川口');
ok($zip->set_number('0150052')->is_valid_number, '秋田県由利本荘市畑谷');
ok($zip->set_number('0150053')->is_valid_number, '秋田県由利本荘市福山');
ok($zip->set_number('0150054')->is_valid_number, '秋田県由利本荘市土谷(谷地)');
ok($zip->set_number('0150055')->is_valid_number, '秋田県由利本荘市土谷(その他)');
ok($zip->set_number('0150061')->is_valid_number, '秋田県由利本荘市二十六木');
ok($zip->set_number('0150062')->is_valid_number, '秋田県由利本荘市大中ノ沢');
ok($zip->set_number('0150063')->is_valid_number, '秋田県由利本荘市舘前');
ok($zip->set_number('0150064')->is_valid_number, '秋田県由利本荘市万願寺');
ok($zip->set_number('0150065')->is_valid_number, '秋田県由利本荘市荒町');
ok($zip->set_number('0150066')->is_valid_number, '秋田県由利本荘市金山');
ok($zip->set_number('0150067')->is_valid_number, '秋田県由利本荘市三条');
ok($zip->set_number('0150068')->is_valid_number, '秋田県由利本荘市南ノ股');
ok($zip->set_number('0150069')->is_valid_number, '秋田県由利本荘市北ノ股');
ok($zip->set_number('0150071')->is_valid_number, '秋田県由利本荘市赤沼町');
ok($zip->set_number('0150072')->is_valid_number, '秋田県由利本荘市裏尾崎町');
ok($zip->set_number('0150073')->is_valid_number, '秋田県由利本荘市笹道');
ok($zip->set_number('0150074')->is_valid_number, '秋田県由利本荘市桜小路');
ok($zip->set_number('0150075')->is_valid_number, '秋田県由利本荘市花畑町');
ok($zip->set_number('0150076')->is_valid_number, '秋田県由利本荘市東町');
ok($zip->set_number('0150077')->is_valid_number, '秋田県由利本荘市本田仲町');
ok($zip->set_number('0150078')->is_valid_number, '秋田県由利本荘市谷地町');
ok($zip->set_number('0150079')->is_valid_number, '秋田県由利本荘市赤沼下道');
ok($zip->set_number('0150081')->is_valid_number, '秋田県由利本荘市雪車町');
ok($zip->set_number('0150082')->is_valid_number, '秋田県由利本荘市宮沢');
ok($zip->set_number('0150083')->is_valid_number, '秋田県由利本荘市滝ノ沢');
ok($zip->set_number('0150084')->is_valid_number, '秋田県由利本荘市鮎瀬');
ok($zip->set_number('0150085')->is_valid_number, '秋田県由利本荘市烏川');
ok($zip->set_number('0150086')->is_valid_number, '秋田県由利本荘市舘');
ok($zip->set_number('0150087')->is_valid_number, '秋田県由利本荘市湯沢');
ok($zip->set_number('0150088')->is_valid_number, '秋田県由利本荘市柳生');
ok($zip->set_number('0150089')->is_valid_number, '秋田県由利本荘市鳥田目');
ok($zip->set_number('0150091')->is_valid_number, '秋田県由利本荘市大簗');
ok($zip->set_number('0150092')->is_valid_number, '秋田県由利本荘市山内(その他)');
ok($zip->set_number('0150093')->is_valid_number, '秋田県由利本荘市大沢');
ok($zip->set_number('0150094')->is_valid_number, '秋田県由利本荘市上野');
ok($zip->set_number('0150201')->is_valid_number, '秋田県由利本荘市東由利法内');
ok($zip->set_number('0150202')->is_valid_number, '秋田県由利本荘市東由利蔵');
ok($zip->set_number('0150211')->is_valid_number, '秋田県由利本荘市東由利老方');
ok($zip->set_number('0150221')->is_valid_number, '秋田県由利本荘市東由利舘合');
ok($zip->set_number('0150231')->is_valid_number, '秋田県由利本荘市東由利黒渕');
ok($zip->set_number('0150232')->is_valid_number, '秋田県由利本荘市東由利田代');
ok($zip->set_number('0150241')->is_valid_number, '秋田県由利本荘市東由利宿');
ok($zip->set_number('0150242')->is_valid_number, '秋田県由利本荘市東由利杉森');
ok($zip->set_number('0150243')->is_valid_number, '秋田県由利本荘市山内(三ツ方森)');
ok($zip->set_number('0150301')->is_valid_number, '秋田県由利本荘市飯沢');
ok($zip->set_number('0150302')->is_valid_number, '秋田県由利本荘市久保田');
ok($zip->set_number('0150303')->is_valid_number, '秋田県由利本荘市陳ケ森');
ok($zip->set_number('0150304')->is_valid_number, '秋田県由利本荘市曲沢');
ok($zip->set_number('0150311')->is_valid_number, '秋田県由利本荘市五十土');
ok($zip->set_number('0150312')->is_valid_number, '秋田県由利本荘市大水口');
ok($zip->set_number('0150313')->is_valid_number, '秋田県由利本荘市小菅野');
ok($zip->set_number('0150314')->is_valid_number, '秋田県由利本荘市東中沢');
ok($zip->set_number('0150321')->is_valid_number, '秋田県由利本荘市蟹沢');
ok($zip->set_number('0150322')->is_valid_number, '秋田県由利本荘市新上条');
ok($zip->set_number('0150323')->is_valid_number, '秋田県由利本荘市土倉');
ok($zip->set_number('0150324')->is_valid_number, '秋田県由利本荘市吉沢');
ok($zip->set_number('0150331')->is_valid_number, '秋田県由利本荘市川西');
ok($zip->set_number('0150332')->is_valid_number, '秋田県由利本荘市森子');
ok($zip->set_number('0150333')->is_valid_number, '秋田県由利本荘市山本');
ok($zip->set_number('0150341')->is_valid_number, '秋田県由利本荘市前郷');
ok($zip->set_number('0150351')->is_valid_number, '秋田県由利本荘市堰口');
ok($zip->set_number('0150352')->is_valid_number, '秋田県由利本荘市西沢');
ok($zip->set_number('0150353')->is_valid_number, '秋田県由利本荘市平石');
ok($zip->set_number('0150361')->is_valid_number, '秋田県由利本荘市黒沢');
ok($zip->set_number('0150362')->is_valid_number, '秋田県由利本荘市東鮎川');
ok($zip->set_number('0150363')->is_valid_number, '秋田県由利本荘市町村');
ok($zip->set_number('0150364')->is_valid_number, '秋田県由利本荘市南福田');
ok($zip->set_number('0150401')->is_valid_number, '秋田県由利本荘市矢島町田中町');
ok($zip->set_number('0150402')->is_valid_number, '秋田県由利本荘市矢島町矢島町');
ok($zip->set_number('0150403')->is_valid_number, '秋田県由利本荘市矢島町舘町');
ok($zip->set_number('0150404')->is_valid_number, '秋田県由利本荘市矢島町七日町');
ok($zip->set_number('0150411')->is_valid_number, '秋田県由利本荘市矢島町城内');
ok($zip->set_number('0150412')->is_valid_number, '秋田県由利本荘市矢島町川辺');
ok($zip->set_number('0150413')->is_valid_number, '秋田県由利本荘市矢島町木在');
ok($zip->set_number('0150414')->is_valid_number, '秋田県由利本荘市矢島町立石');
ok($zip->set_number('0150415')->is_valid_number, '秋田県由利本荘市矢島町新荘');
ok($zip->set_number('0150416')->is_valid_number, '秋田県由利本荘市矢島町坂之下');
ok($zip->set_number('0150417')->is_valid_number, '秋田県由利本荘市矢島町元町');
ok($zip->set_number('0150418')->is_valid_number, '秋田県由利本荘市矢島町荒沢');
ok($zip->set_number('0150501')->is_valid_number, '秋田県由利本荘市鳥海町伏見');
ok($zip->set_number('0150502')->is_valid_number, '秋田県由利本荘市鳥海町下川内');
ok($zip->set_number('0150503')->is_valid_number, '秋田県由利本荘市鳥海町栗沢');
ok($zip->set_number('0150504')->is_valid_number, '秋田県由利本荘市鳥海町上川内');
ok($zip->set_number('0150505')->is_valid_number, '秋田県由利本荘市鳥海町小川');
ok($zip->set_number('0150511')->is_valid_number, '秋田県由利本荘市鳥海町戈之神');
ok($zip->set_number('0150512')->is_valid_number, '秋田県由利本荘市鳥海町猿倉');
ok($zip->set_number('0150513')->is_valid_number, '秋田県由利本荘市鳥海町下直根');
ok($zip->set_number('0150514')->is_valid_number, '秋田県由利本荘市鳥海町中直根');
ok($zip->set_number('0150515')->is_valid_number, '秋田県由利本荘市鳥海町上直根');
ok($zip->set_number('0150516')->is_valid_number, '秋田県由利本荘市鳥海町百宅');
ok($zip->set_number('0150721')->is_valid_number, '秋田県由利本荘市鳥海町上笹子');
ok($zip->set_number('0150722')->is_valid_number, '秋田県由利本荘市鳥海町下笹子');
ok($zip->set_number('0150801')->is_valid_number, '秋田県由利本荘市美倉町');
ok($zip->set_number('0150802')->is_valid_number, '秋田県由利本荘市表尾崎町');
ok($zip->set_number('0150803')->is_valid_number, '秋田県由利本荘市中竪町');
ok($zip->set_number('0150804')->is_valid_number, '秋田県由利本荘市谷山小路');
ok($zip->set_number('0150807')->is_valid_number, '秋田県由利本荘市中横町');
ok($zip->set_number('0150808')->is_valid_number, '秋田県由利本荘市大門');
ok($zip->set_number('0150809')->is_valid_number, '秋田県由利本荘市本荘');
ok($zip->set_number('0150811')->is_valid_number, '秋田県由利本荘市桶屋町');
ok($zip->set_number('0150812')->is_valid_number, '秋田県由利本荘市鍛治町');
ok($zip->set_number('0150813')->is_valid_number, '秋田県由利本荘市日役町');
ok($zip->set_number('0150814')->is_valid_number, '秋田県由利本荘市後町');
ok($zip->set_number('0150815')->is_valid_number, '秋田県由利本荘市猟師町');
ok($zip->set_number('0150816')->is_valid_number, '秋田県由利本荘市大町');
ok($zip->set_number('0150817')->is_valid_number, '秋田県由利本荘市中町');
ok($zip->set_number('0150821')->is_valid_number, '秋田県由利本荘市肴町');
ok($zip->set_number('0150822')->is_valid_number, '秋田県由利本荘市田町');
ok($zip->set_number('0150823')->is_valid_number, '秋田県由利本荘市和泉町');
ok($zip->set_number('0150824')->is_valid_number, '秋田県由利本荘市古雪町');
ok($zip->set_number('0150825')->is_valid_number, '秋田県由利本荘市観音町');
ok($zip->set_number('0150826')->is_valid_number, '秋田県由利本荘市片町');
ok($zip->set_number('0150827')->is_valid_number, '秋田県由利本荘市浜ノ町');
ok($zip->set_number('0150831')->is_valid_number, '秋田県由利本荘市北裏地');
ok($zip->set_number('0150832')->is_valid_number, '秋田県由利本荘市下川原中島');
ok($zip->set_number('0150833')->is_valid_number, '秋田県由利本荘市巣組');
ok($zip->set_number('0150834')->is_valid_number, '秋田県由利本荘市岩渕下');
ok($zip->set_number('0150835')->is_valid_number, '秋田県由利本荘市八幡下');
ok($zip->set_number('0150836')->is_valid_number, '秋田県由利本荘市赤沼下');
ok($zip->set_number('0150837')->is_valid_number, '秋田県由利本荘市出戸町(赤沼下道)');
ok($zip->set_number('0150838')->is_valid_number, '秋田県由利本荘市梵天谷地');
ok($zip->set_number('0150839')->is_valid_number, '秋田県由利本荘市古川端');
ok($zip->set_number('0150840')->is_valid_number, '秋田県由利本荘市瀬越場');
ok($zip->set_number('0150841')->is_valid_number, '秋田県由利本荘市下大野');
ok($zip->set_number('0150842')->is_valid_number, '秋田県由利本荘市出戸上野');
ok($zip->set_number('0150843')->is_valid_number, '秋田県由利本荘市東梵天');
ok($zip->set_number('0150851')->is_valid_number, '秋田県由利本荘市中梵天');
ok($zip->set_number('0150852')->is_valid_number, '秋田県由利本荘市一番堰');
ok($zip->set_number('0150853')->is_valid_number, '秋田県由利本荘市松街道');
ok($zip->set_number('0150854')->is_valid_number, '秋田県由利本荘市上大野');
ok($zip->set_number('0150855')->is_valid_number, '秋田県由利本荘市二番堰');
ok($zip->set_number('0150856')->is_valid_number, '秋田県由利本荘市円正脇');
ok($zip->set_number('0150857')->is_valid_number, '秋田県由利本荘市寺後');
ok($zip->set_number('0150858')->is_valid_number, '秋田県由利本荘市西梵天');
ok($zip->set_number('0150861')->is_valid_number, '秋田県由利本荘市御門');
ok($zip->set_number('0150862')->is_valid_number, '秋田県由利本荘市小人町');
ok($zip->set_number('0150863')->is_valid_number, '秋田県由利本荘市不戻沢');
ok($zip->set_number('0150864')->is_valid_number, '秋田県由利本荘市大鍬町');
ok($zip->set_number('0150865')->is_valid_number, '秋田県由利本荘市西大鍬町');
ok($zip->set_number('0150866')->is_valid_number, '秋田県由利本荘市堤脇');
ok($zip->set_number('0150867')->is_valid_number, '秋田県由利本荘市千刈');
ok($zip->set_number('0150868')->is_valid_number, '秋田県由利本荘市大堤下');
ok($zip->set_number('0150869')->is_valid_number, '秋田県由利本荘市陣場岱');
ok($zip->set_number('0150871')->is_valid_number, '秋田県由利本荘市尾崎');
ok($zip->set_number('0150872')->is_valid_number, '秋田県由利本荘市瓦谷地');
ok($zip->set_number('0150873')->is_valid_number, '秋田県由利本荘市鶴沼');
ok($zip->set_number('0150874')->is_valid_number, '秋田県由利本荘市給人町');
ok($zip->set_number('0150875')->is_valid_number, '秋田県由利本荘市砂子下');
ok($zip->set_number('0150876')->is_valid_number, '秋田県由利本荘市井戸尻');
ok($zip->set_number('0150877')->is_valid_number, '秋田県由利本荘市濡浜北');
ok($zip->set_number('0150878')->is_valid_number, '秋田県由利本荘市観音森');
ok($zip->set_number('0150881')->is_valid_number, '秋田県由利本荘市切通');
ok($zip->set_number('0150882')->is_valid_number, '秋田県由利本荘市西小人町');
ok($zip->set_number('0150883')->is_valid_number, '秋田県由利本荘市下地ケ沢');
ok($zip->set_number('0150884')->is_valid_number, '秋田県由利本荘市狐森');
ok($zip->set_number('0150885')->is_valid_number, '秋田県由利本荘市水林');
ok($zip->set_number('0150886')->is_valid_number, '秋田県由利本荘市調練場');
ok($zip->set_number('0150887')->is_valid_number, '秋田県由利本荘市今野谷地');
ok($zip->set_number('0150888')->is_valid_number, '秋田県由利本荘市新組町');
ok($zip->set_number('0150889')->is_valid_number, '秋田県由利本荘市砂糖畑');
ok($zip->set_number('0150890')->is_valid_number, '秋田県由利本荘市船ケ台');
ok($zip->set_number('0150891')->is_valid_number, '秋田県由利本荘市小防ケ沢');
ok($zip->set_number('0150892')->is_valid_number, '秋田県由利本荘市蟻山');
ok($zip->set_number('0160000')->is_valid_number, '秋田県能代市以下に掲載がない場合');
ok($zip->set_number('0160001')->is_valid_number, '秋田県能代市外荒巻');
ok($zip->set_number('0160002')->is_valid_number, '秋田県能代市朴瀬');
ok($zip->set_number('0160003')->is_valid_number, '秋田県能代市荷八田');
ok($zip->set_number('0160004')->is_valid_number, '秋田県能代市吹越');
ok($zip->set_number('0160005')->is_valid_number, '秋田県能代市真壁地');
ok($zip->set_number('0160011')->is_valid_number, '秋田県能代市坂形');
ok($zip->set_number('0160012')->is_valid_number, '秋田県能代市比八田');
ok($zip->set_number('0160013')->is_valid_number, '秋田県能代市向能代');
ok($zip->set_number('0160014')->is_valid_number, '秋田県能代市落合');
ok($zip->set_number('0160015')->is_valid_number, '秋田県能代市須田');
ok($zip->set_number('0160016')->is_valid_number, '秋田県能代市竹生');
ok($zip->set_number('0160017')->is_valid_number, '秋田県能代市磐');
ok($zip->set_number('0160101')->is_valid_number, '秋田県能代市中関');
ok($zip->set_number('0160102')->is_valid_number, '秋田県能代市一本木');
ok($zip->set_number('0160103')->is_valid_number, '秋田県能代市宮ノ前');
ok($zip->set_number('0160104')->is_valid_number, '秋田県能代市下関');
ok($zip->set_number('0160111')->is_valid_number, '秋田県能代市仁井田白山');
ok($zip->set_number('0160112')->is_valid_number, '秋田県能代市中嶋(その他)');
ok($zip->set_number('0160113')->is_valid_number, '秋田県能代市下悪戸');
ok($zip->set_number('0160114')->is_valid_number, '秋田県能代市中悪戸');
ok($zip->set_number('0160115')->is_valid_number, '秋田県能代市悪戸');
ok($zip->set_number('0160116')->is_valid_number, '秋田県能代市機織轌ノ目');
ok($zip->set_number('0160121')->is_valid_number, '秋田県能代市鰄渕');
ok($zip->set_number('0160122')->is_valid_number, '秋田県能代市扇田');
ok($zip->set_number('0160123')->is_valid_number, '秋田県能代市田床内');
ok($zip->set_number('0160131')->is_valid_number, '秋田県能代市鶴形');
ok($zip->set_number('0160132')->is_valid_number, '秋田県能代市町後');
ok($zip->set_number('0160133')->is_valid_number, '秋田県能代市向田表');
ok($zip->set_number('0160134')->is_valid_number, '秋田県能代市戸草沢');
ok($zip->set_number('0160135')->is_valid_number, '秋田県能代市姥懐');
ok($zip->set_number('0160136')->is_valid_number, '秋田県能代市鵜鳥');
ok($zip->set_number('0160137')->is_valid_number, '秋田県能代市鵜鳥悪戸');
ok($zip->set_number('0160138')->is_valid_number, '秋田県能代市鵜鳥川原');
ok($zip->set_number('0160139')->is_valid_number, '秋田県能代市谷地上');
ok($zip->set_number('0160141')->is_valid_number, '秋田県能代市鵜ノ沢');
ok($zip->set_number('0160142')->is_valid_number, '秋田県能代市半戸沢');
ok($zip->set_number('0160143')->is_valid_number, '秋田県能代市上ノ山');
ok($zip->set_number('0160144')->is_valid_number, '秋田県能代市上ノ山台');
ok($zip->set_number('0160145')->is_valid_number, '秋田県能代市若田');
ok($zip->set_number('0160146')->is_valid_number, '秋田県能代市外堤');
ok($zip->set_number('0160147')->is_valid_number, '秋田県能代市鳥矢場');
ok($zip->set_number('0160148')->is_valid_number, '秋田県能代市冷清水');
ok($zip->set_number('0160149')->is_valid_number, '秋田県能代市田中谷地');
ok($zip->set_number('0160151')->is_valid_number, '秋田県能代市檜山');
ok($zip->set_number('0160152')->is_valid_number, '秋田県能代市母体');
ok($zip->set_number('0160153')->is_valid_number, '秋田県能代市上関');
ok($zip->set_number('0160154')->is_valid_number, '秋田県能代市上谷地');
ok($zip->set_number('0160155')->is_valid_number, '秋田県能代市大森');
ok($zip->set_number('0160156')->is_valid_number, '秋田県能代市中沢');
ok($zip->set_number('0160157')->is_valid_number, '秋田県能代市腹鞁ノ沢');
ok($zip->set_number('0160161')->is_valid_number, '秋田県能代市松長布');
ok($zip->set_number('0160162')->is_valid_number, '秋田県能代市大内田');
ok($zip->set_number('0160163')->is_valid_number, '秋田県能代市袖又');
ok($zip->set_number('0160164')->is_valid_number, '秋田県能代市大塚');
ok($zip->set_number('0160165')->is_valid_number, '秋田県能代市田屋');
ok($zip->set_number('0160166')->is_valid_number, '秋田県能代市柏子所');
ok($zip->set_number('0160167')->is_valid_number, '秋田県能代市塩干田');
ok($zip->set_number('0160167')->is_valid_number, '秋田県能代市塩干田前');
ok($zip->set_number('0160168')->is_valid_number, '秋田県能代市十洲崎');
ok($zip->set_number('0160169')->is_valid_number, '秋田県能代市坊ケ崎');
ok($zip->set_number('0160171')->is_valid_number, '秋田県能代市河戸川');
ok($zip->set_number('0160172')->is_valid_number, '秋田県能代市上古川布');
ok($zip->set_number('0160173')->is_valid_number, '秋田県能代市下古川布');
ok($zip->set_number('0160174')->is_valid_number, '秋田県能代市新山前');
ok($zip->set_number('0160175')->is_valid_number, '秋田県能代市古屋布');
ok($zip->set_number('0160176')->is_valid_number, '秋田県能代市戸川向');
ok($zip->set_number('0160177')->is_valid_number, '秋田県能代市権現台');
ok($zip->set_number('0160178')->is_valid_number, '秋田県能代市九郎左衛門笹台');
ok($zip->set_number('0160179')->is_valid_number, '秋田県能代市浅内');
ok($zip->set_number('0160181')->is_valid_number, '秋田県能代市大瀬儘下');
ok($zip->set_number('0160182')->is_valid_number, '秋田県能代市上柳');
ok($zip->set_number('0160183')->is_valid_number, '秋田県能代市中柳');
ok($zip->set_number('0160184')->is_valid_number, '秋田県能代市高塙');
ok($zip->set_number('0160185')->is_valid_number, '秋田県能代市下瀬');
ok($zip->set_number('0160186')->is_valid_number, '秋田県能代市下野');
ok($zip->set_number('0160187')->is_valid_number, '秋田県能代市下柳');
ok($zip->set_number('0160188')->is_valid_number, '秋田県能代市寺向');
ok($zip->set_number('0160801')->is_valid_number, '秋田県能代市浜通町');
ok($zip->set_number('0160802')->is_valid_number, '秋田県能代市川反町');
ok($zip->set_number('0160803')->is_valid_number, '秋田県能代市大町');
ok($zip->set_number('0160804')->is_valid_number, '秋田県能代市万町');
ok($zip->set_number('0160805')->is_valid_number, '秋田県能代市大手町');
ok($zip->set_number('0160806')->is_valid_number, '秋田県能代市清助町');
ok($zip->set_number('0160807')->is_valid_number, '秋田県能代市大森山');
ok($zip->set_number('0160808')->is_valid_number, '秋田県能代市日和山下');
ok($zip->set_number('0160811')->is_valid_number, '秋田県能代市日吉町');
ok($zip->set_number('0160812')->is_valid_number, '秋田県能代市中嶋(1-97~116)');
ok($zip->set_number('0160813')->is_valid_number, '秋田県能代市能代町');
ok($zip->set_number('0160814')->is_valid_number, '秋田県能代市中川原');
ok($zip->set_number('0160815')->is_valid_number, '秋田県能代市御指南町');
ok($zip->set_number('0160816')->is_valid_number, '秋田県能代市富町');
ok($zip->set_number('0160817')->is_valid_number, '秋田県能代市上町');
ok($zip->set_number('0160821')->is_valid_number, '秋田県能代市畠町');
ok($zip->set_number('0160822')->is_valid_number, '秋田県能代市東町');
ok($zip->set_number('0160823')->is_valid_number, '秋田県能代市若松町');
ok($zip->set_number('0160824')->is_valid_number, '秋田県能代市住吉町');
ok($zip->set_number('0160825')->is_valid_number, '秋田県能代市柳町');
ok($zip->set_number('0160831')->is_valid_number, '秋田県能代市元町');
ok($zip->set_number('0160832')->is_valid_number, '秋田県能代市南元町');
ok($zip->set_number('0160833')->is_valid_number, '秋田県能代市明治町');
ok($zip->set_number('0160834')->is_valid_number, '秋田県能代市下内崎');
ok($zip->set_number('0160835')->is_valid_number, '秋田県能代市赤沼');
ok($zip->set_number('0160836')->is_valid_number, '秋田県能代市東赤沼');
ok($zip->set_number('0160837')->is_valid_number, '秋田県能代市西赤沼');
ok($zip->set_number('0160838')->is_valid_number, '秋田県能代市養蚕脇');
ok($zip->set_number('0160839')->is_valid_number, '秋田県能代市東大瀬');
ok($zip->set_number('0160841')->is_valid_number, '秋田県能代市養蚕');
ok($zip->set_number('0160842')->is_valid_number, '秋田県能代市追分町');
ok($zip->set_number('0160843')->is_valid_number, '秋田県能代市中和');
ok($zip->set_number('0160844')->is_valid_number, '秋田県能代市花園町');
ok($zip->set_number('0160845')->is_valid_number, '秋田県能代市通町');
ok($zip->set_number('0160846')->is_valid_number, '秋田県能代市栄町');
ok($zip->set_number('0160851')->is_valid_number, '秋田県能代市緑町');
ok($zip->set_number('0160852')->is_valid_number, '秋田県能代市出戸本町');
ok($zip->set_number('0160853')->is_valid_number, '秋田県能代市出戸後');
ok($zip->set_number('0160854')->is_valid_number, '秋田県能代市豊祥岱');
ok($zip->set_number('0160855')->is_valid_number, '秋田県能代市西大瀬');
ok($zip->set_number('0160856')->is_valid_number, '秋田県能代市藤山');
ok($zip->set_number('0160857')->is_valid_number, '秋田県能代市田子向');
ok($zip->set_number('0160861')->is_valid_number, '秋田県能代市彩霞長根');
ok($zip->set_number('0160862')->is_valid_number, '秋田県能代市寿域長根');
ok($zip->set_number('0160863')->is_valid_number, '秋田県能代市後谷地');
ok($zip->set_number('0160864')->is_valid_number, '秋田県能代市鳥小屋');
ok($zip->set_number('0160865')->is_valid_number, '秋田県能代市青葉町');
ok($zip->set_number('0160871')->is_valid_number, '秋田県能代市昇平岱');
ok($zip->set_number('0160872')->is_valid_number, '秋田県能代市芝童森');
ok($zip->set_number('0160873')->is_valid_number, '秋田県能代市長崎');
ok($zip->set_number('0160874')->is_valid_number, '秋田県能代市沼ノ上');
ok($zip->set_number('0160875')->is_valid_number, '秋田県能代市南陽崎');
ok($zip->set_number('0160876')->is_valid_number, '秋田県能代市海詠坂');
ok($zip->set_number('0160877')->is_valid_number, '秋田県能代市仙遊長根');
ok($zip->set_number('0160878')->is_valid_number, '秋田県能代市臥竜山');
ok($zip->set_number('0160879')->is_valid_number, '秋田県能代市不老岱');
ok($zip->set_number('0160881')->is_valid_number, '秋田県能代市砂留山');
ok($zip->set_number('0160882')->is_valid_number, '秋田県能代市鳳凰岱');
ok($zip->set_number('0160883')->is_valid_number, '秋田県能代市五雲岱');
ok($zip->set_number('0160884')->is_valid_number, '秋田県能代市卸町');
ok($zip->set_number('0160891')->is_valid_number, '秋田県能代市西通町');
ok($zip->set_number('0160892')->is_valid_number, '秋田県能代市景林町');
ok($zip->set_number('0160893')->is_valid_number, '秋田県能代市松美町');
ok($zip->set_number('0160894')->is_valid_number, '秋田県能代市萩の台');
ok($zip->set_number('0160895')->is_valid_number, '秋田県能代市末広町');
ok($zip->set_number('0160896')->is_valid_number, '秋田県能代市盤若町');
ok($zip->set_number('0160897')->is_valid_number, '秋田県能代市昭南町');
ok($zip->set_number('0170000')->is_valid_number, '秋田県大館市以下に掲載がない場合');
ok($zip->set_number('0170001')->is_valid_number, '秋田県大館市長走');
ok($zip->set_number('0170002')->is_valid_number, '秋田県大館市白沢');
ok($zip->set_number('0170003')->is_valid_number, '秋田県大館市橋桁');
ok($zip->set_number('0170004')->is_valid_number, '秋田県大館市粕田');
ok($zip->set_number('0170005')->is_valid_number, '秋田県大館市花岡町');
ok($zip->set_number('0170011')->is_valid_number, '秋田県大館市商人留');
ok($zip->set_number('0170012')->is_valid_number, '秋田県大館市釈迦内');
ok($zip->set_number('0170014')->is_valid_number, '秋田県大館市小釈迦内道上');
ok($zip->set_number('0170015')->is_valid_number, '秋田県大館市小釈迦内道下');
ok($zip->set_number('0170021')->is_valid_number, '秋田県大館市雪沢');
ok($zip->set_number('0170022')->is_valid_number, '秋田県大館市茂内');
ok($zip->set_number('0170023')->is_valid_number, '秋田県大館市東');
ok($zip->set_number('0170024')->is_valid_number, '秋田県大館市大茂内');
ok($zip->set_number('0170025')->is_valid_number, '秋田県大館市芦田子');
ok($zip->set_number('0170026')->is_valid_number, '秋田県大館市二ツ屋境');
ok($zip->set_number('0170031')->is_valid_number, '秋田県大館市上代野');
ok($zip->set_number('0170032')->is_valid_number, '秋田県大館市新綱');
ok($zip->set_number('0170033')->is_valid_number, '秋田県大館市下綱');
ok($zip->set_number('0170034')->is_valid_number, '秋田県大館市下代野');
ok($zip->set_number('0170035')->is_valid_number, '秋田県大館市代野');
ok($zip->set_number('0170036')->is_valid_number, '秋田県大館市二本杉後');
ok($zip->set_number('0170037')->is_valid_number, '秋田県大館市清水堰合');
ok($zip->set_number('0170041')->is_valid_number, '秋田県大館市大田面');
ok($zip->set_number('0170042')->is_valid_number, '秋田県大館市観音堂');
ok($zip->set_number('0170043')->is_valid_number, '秋田県大館市有浦');
ok($zip->set_number('0170044')->is_valid_number, '秋田県大館市御成町');
ok($zip->set_number('0170045')->is_valid_number, '秋田県大館市中道');
ok($zip->set_number('0170046')->is_valid_number, '秋田県大館市清水');
ok($zip->set_number('0170051')->is_valid_number, '秋田県大館市松峰');
ok($zip->set_number('0170052')->is_valid_number, '秋田県大館市松木');
ok($zip->set_number('0170053')->is_valid_number, '秋田県大館市板子石境');
ok($zip->set_number('0170054')->is_valid_number, '秋田県大館市松館');
ok($zip->set_number('0170055')->is_valid_number, '秋田県大館市沼館道上');
ok($zip->set_number('0170056')->is_valid_number, '秋田県大館市沼館道南');
ok($zip->set_number('0170057')->is_valid_number, '秋田県大館市沼館');
ok($zip->set_number('0170200')->is_valid_number, '秋田県鹿角郡小坂町以下に掲載がない場合');
ok($zip->set_number('0170201')->is_valid_number, '秋田県鹿角郡小坂町小坂');
ok($zip->set_number('0170202')->is_valid_number, '秋田県鹿角郡小坂町小坂鉱山');
ok($zip->set_number('0170203')->is_valid_number, '秋田県鹿角郡小坂町上向');
ok($zip->set_number('0170204')->is_valid_number, '秋田県鹿角郡小坂町荒谷');
ok($zip->set_number('0170205')->is_valid_number, '秋田県鹿角郡小坂町大地');
ok($zip->set_number('0170801')->is_valid_number, '秋田県大館市一本杉');
ok($zip->set_number('0170802')->is_valid_number, '秋田県大館市長根山下');
ok($zip->set_number('0170803')->is_valid_number, '秋田県大館市東台');
ok($zip->set_number('0170804')->is_valid_number, '秋田県大館市柄沢');
ok($zip->set_number('0170805')->is_valid_number, '秋田県大館市扇田道下');
ok($zip->set_number('0170806')->is_valid_number, '秋田県大館市相染沢中岱');
ok($zip->set_number('0170811')->is_valid_number, '秋田県大館市八幡');
ok($zip->set_number('0170812')->is_valid_number, '秋田県大館市金坂');
ok($zip->set_number('0170813')->is_valid_number, '秋田県大館市金坂後');
ok($zip->set_number('0170814')->is_valid_number, '秋田県大館市赤館町');
ok($zip->set_number('0170815')->is_valid_number, '秋田県大館市部垂町');
ok($zip->set_number('0170816')->is_valid_number, '秋田県大館市赤館');
ok($zip->set_number('0170817')->is_valid_number, '秋田県大館市上町');
ok($zip->set_number('0170821')->is_valid_number, '秋田県大館市桜町');
ok($zip->set_number('0170822')->is_valid_number, '秋田県大館市桜町南');
ok($zip->set_number('0170823')->is_valid_number, '秋田県大館市八幡沢岱');
ok($zip->set_number('0170824')->is_valid_number, '秋田県大館市七曲岱');
ok($zip->set_number('0170825')->is_valid_number, '秋田県大館市一心院南');
ok($zip->set_number('0170826')->is_valid_number, '秋田県大館市谷地町後');
ok($zip->set_number('0170827')->is_valid_number, '秋田県大館市谷地町');
ok($zip->set_number('0170828')->is_valid_number, '秋田県大館市向町');
ok($zip->set_number('0170831')->is_valid_number, '秋田県大館市青葉町');
ok($zip->set_number('0170832')->is_valid_number, '秋田県大館市池内道下');
ok($zip->set_number('0170833')->is_valid_number, '秋田県大館市象ケ鼻');
ok($zip->set_number('0170834')->is_valid_number, '秋田県大館市池内道上');
ok($zip->set_number('0170835')->is_valid_number, '秋田県大館市小館花');
ok($zip->set_number('0170836')->is_valid_number, '秋田県大館市池内');
ok($zip->set_number('0170837')->is_valid_number, '秋田県大館市餌釣');
ok($zip->set_number('0170838')->is_valid_number, '秋田県大館市山館');
ok($zip->set_number('0170839')->is_valid_number, '秋田県大館市中山');
ok($zip->set_number('0170841')->is_valid_number, '秋田県大館市大町');
ok($zip->set_number('0170842')->is_valid_number, '秋田県大館市馬喰町');
ok($zip->set_number('0170843')->is_valid_number, '秋田県大館市中町');
ok($zip->set_number('0170844')->is_valid_number, '秋田県大館市新町');
ok($zip->set_number('0170845')->is_valid_number, '秋田県大館市泉町');
ok($zip->set_number('0170846')->is_valid_number, '秋田県大館市常盤木町');
ok($zip->set_number('0170847')->is_valid_number, '秋田県大館市幸町');
ok($zip->set_number('0170851')->is_valid_number, '秋田県大館市大披');
ok($zip->set_number('0170852')->is_valid_number, '秋田県大館市小袴');
ok($zip->set_number('0170853')->is_valid_number, '秋田県大館市板沢');
ok($zip->set_number('0170854')->is_valid_number, '秋田県大館市赤石');
ok($zip->set_number('0170855')->is_valid_number, '秋田県大館市櫃崎');
ok($zip->set_number('0170857')->is_valid_number, '秋田県大館市出川');
ok($zip->set_number('0170861')->is_valid_number, '秋田県大館市小館町');
ok($zip->set_number('0170862')->is_valid_number, '秋田県大館市根下戸');
ok($zip->set_number('0170863')->is_valid_number, '秋田県大館市根下戸町');
ok($zip->set_number('0170864')->is_valid_number, '秋田県大館市根下戸新町');
ok($zip->set_number('0170865')->is_valid_number, '秋田県大館市城西町');
ok($zip->set_number('0170866')->is_valid_number, '秋田県大館市北神明町');
ok($zip->set_number('0170867')->is_valid_number, '秋田県大館市中神明町');
ok($zip->set_number('0170868')->is_valid_number, '秋田県大館市南神明町');
ok($zip->set_number('0170871')->is_valid_number, '秋田県大館市片山');
ok($zip->set_number('0170872')->is_valid_number, '秋田県大館市片山町');
ok($zip->set_number('0170873')->is_valid_number, '秋田県大館市御坂');
ok($zip->set_number('0170874')->is_valid_number, '秋田県大館市美園町');
ok($zip->set_number('0170875')->is_valid_number, '秋田県大館市住吉町');
ok($zip->set_number('0170876')->is_valid_number, '秋田県大館市餅田');
ok($zip->set_number('0170877')->is_valid_number, '秋田県大館市立花');
ok($zip->set_number('0170878')->is_valid_number, '秋田県大館市川口');
ok($zip->set_number('0170881')->is_valid_number, '秋田県大館市長木川南');
ok($zip->set_number('0170882')->is_valid_number, '秋田県大館市鉄砲場');
ok($zip->set_number('0170883')->is_valid_number, '秋田県大館市古川町');
ok($zip->set_number('0170884')->is_valid_number, '秋田県大館市土飛山下');
ok($zip->set_number('0170885')->is_valid_number, '秋田県大館市豊町');
ok($zip->set_number('0170886')->is_valid_number, '秋田県大館市館下');
ok($zip->set_number('0170887')->is_valid_number, '秋田県大館市水門町');
ok($zip->set_number('0170888')->is_valid_number, '秋田県大館市水門前');
ok($zip->set_number('0170891')->is_valid_number, '秋田県大館市中城');
ok($zip->set_number('0170892')->is_valid_number, '秋田県大館市片町');
ok($zip->set_number('0170893')->is_valid_number, '秋田県大館市桂城');
ok($zip->set_number('0170894')->is_valid_number, '秋田県大館市裏町');
ok($zip->set_number('0170895')->is_valid_number, '秋田県大館市長倉');
ok($zip->set_number('0170896')->is_valid_number, '秋田県大館市大館');
ok($zip->set_number('0170897')->is_valid_number, '秋田県大館市三ノ丸');
ok($zip->set_number('0180101')->is_valid_number, '秋田県にかほ市象潟町浜山');
ok($zip->set_number('0180102')->is_valid_number, '秋田県にかほ市象潟町木戸口');
ok($zip->set_number('0180103')->is_valid_number, '秋田県にかほ市象潟町上狐森');
ok($zip->set_number('0180104')->is_valid_number, '秋田県にかほ市象潟町狐森');
ok($zip->set_number('0180105')->is_valid_number, '秋田県にかほ市象潟町荒屋妻');
ok($zip->set_number('0180106')->is_valid_number, '秋田県にかほ市象潟町5丁目塩越');
ok($zip->set_number('0180107')->is_valid_number, '秋田県にかほ市象潟町荒屋下');
ok($zip->set_number('0180108')->is_valid_number, '秋田県にかほ市象潟町入湖の澗');
ok($zip->set_number('0180109')->is_valid_number, '秋田県にかほ市象潟町冠石下');
ok($zip->set_number('0180111')->is_valid_number, '秋田県にかほ市象潟町武道島');
ok($zip->set_number('0180112')->is_valid_number, '秋田県にかほ市象潟町家の後');
ok($zip->set_number('0180113')->is_valid_number, '秋田県にかほ市象潟町浜の田');
ok($zip->set_number('0180114')->is_valid_number, '秋田県にかほ市象潟町沖の田');
ok($zip->set_number('0180115')->is_valid_number, '秋田県にかほ市象潟町後田');
ok($zip->set_number('0180116')->is_valid_number, '秋田県にかほ市象潟町4丁目塩越');
ok($zip->set_number('0180117')->is_valid_number, '秋田県にかほ市象潟町浜畑');
ok($zip->set_number('0180118')->is_valid_number, '秋田県にかほ市象潟町2丁目塩越');
ok($zip->set_number('0180119')->is_valid_number, '秋田県にかほ市象潟町3丁目塩越');
ok($zip->set_number('0180121')->is_valid_number, '秋田県にかほ市象潟町大塩越');
ok($zip->set_number('0180122')->is_valid_number, '秋田県にかほ市象潟町象潟島');
ok($zip->set_number('0180123')->is_valid_number, '秋田県にかほ市象潟町妙見下');
ok($zip->set_number('0180124')->is_valid_number, '秋田県にかほ市象潟町入道島');
ok($zip->set_number('0180125')->is_valid_number, '秋田県にかほ市象潟町二の丸');
ok($zip->set_number('0180126')->is_valid_number, '秋田県にかほ市象潟町1丁目塩越');
ok($zip->set_number('0180127')->is_valid_number, '秋田県にかほ市象潟町中橋町');
ok($zip->set_number('0180128')->is_valid_number, '秋田県にかほ市象潟町太郎島');
ok($zip->set_number('0180129')->is_valid_number, '秋田県にかほ市象潟町才の神');
ok($zip->set_number('0180131')->is_valid_number, '秋田県にかほ市象潟町大谷地');
ok($zip->set_number('0180132')->is_valid_number, '秋田県にかほ市象潟町鳥の海');
ok($zip->set_number('0180133')->is_valid_number, '秋田県にかほ市象潟町関');
ok($zip->set_number('0180134')->is_valid_number, '秋田県にかほ市象潟町西中野沢');
ok($zip->set_number('0180135')->is_valid_number, '秋田県にかほ市象潟町洗釜');
ok($zip->set_number('0180136')->is_valid_number, '秋田県にかほ市象潟町大砂川');
ok($zip->set_number('0180141')->is_valid_number, '秋田県にかほ市象潟町川袋');
ok($zip->set_number('0180142')->is_valid_number, '秋田県にかほ市象潟町大須郷');
ok($zip->set_number('0180143')->is_valid_number, '秋田県にかほ市象潟町小砂川');
ok($zip->set_number('0180144')->is_valid_number, '秋田県にかほ市象潟町中谷地');
ok($zip->set_number('0180145')->is_valid_number, '秋田県にかほ市象潟町源蔵潟');
ok($zip->set_number('0180146')->is_valid_number, '秋田県にかほ市象潟町蒲谷池');
ok($zip->set_number('0180147')->is_valid_number, '秋田県にかほ市象潟町立石');
ok($zip->set_number('0180148')->is_valid_number, '秋田県にかほ市象潟町下浜山');
ok($zip->set_number('0180151')->is_valid_number, '秋田県にかほ市象潟町横岡');
ok($zip->set_number('0180152')->is_valid_number, '秋田県にかほ市象潟町本郷');
ok($zip->set_number('0180153')->is_valid_number, '秋田県にかほ市象潟町小滝');
ok($zip->set_number('0180154')->is_valid_number, '秋田県にかほ市象潟町二階谷地');
ok($zip->set_number('0180155')->is_valid_number, '秋田県にかほ市象潟町弁天島');
ok($zip->set_number('0180156')->is_valid_number, '秋田県にかほ市象潟町大門先');
ok($zip->set_number('0180157')->is_valid_number, '秋田県にかほ市象潟町鷹放');
ok($zip->set_number('0180158')->is_valid_number, '秋田県にかほ市象潟町琴和喜');
ok($zip->set_number('0180161')->is_valid_number, '秋田県にかほ市象潟町大飯郷');
ok($zip->set_number('0180162')->is_valid_number, '秋田県にかほ市象潟町大森');
ok($zip->set_number('0180163')->is_valid_number, '秋田県にかほ市象潟町長岡');
ok($zip->set_number('0180164')->is_valid_number, '秋田県にかほ市象潟町丸山');
ok($zip->set_number('0180165')->is_valid_number, '秋田県にかほ市象潟町狸森');
ok($zip->set_number('0180166')->is_valid_number, '秋田県にかほ市象潟町高田');
ok($zip->set_number('0180167')->is_valid_number, '秋田県にかほ市象潟町田の神');
ok($zip->set_number('0180171')->is_valid_number, '秋田県にかほ市象潟町続島');
ok($zip->set_number('0180172')->is_valid_number, '秋田県にかほ市象潟町小才の神');
ok($zip->set_number('0180173')->is_valid_number, '秋田県にかほ市象潟町四隅池');
ok($zip->set_number('0180174')->is_valid_number, '秋田県にかほ市象潟町林の下');
ok($zip->set_number('0180175')->is_valid_number, '秋田県にかほ市象潟町坂の下');
ok($zip->set_number('0180176')->is_valid_number, '秋田県にかほ市象潟町横山');
ok($zip->set_number('0180181')->is_valid_number, '秋田県にかほ市象潟町白山堂');
ok($zip->set_number('0180182')->is_valid_number, '秋田県にかほ市象潟町不動沢');
ok($zip->set_number('0180183')->is_valid_number, '秋田県にかほ市象潟町小坂');
ok($zip->set_number('0180184')->is_valid_number, '秋田県にかほ市象潟町上小坂');
ok($zip->set_number('0180185')->is_valid_number, '秋田県にかほ市象潟町屋敷田');
ok($zip->set_number('0180186')->is_valid_number, '秋田県にかほ市象潟町能因島');
ok($zip->set_number('0180187')->is_valid_number, '秋田県にかほ市象潟町小烏島');
ok($zip->set_number('0180188')->is_valid_number, '秋田県にかほ市象潟町烏島');
ok($zip->set_number('0180301')->is_valid_number, '秋田県にかほ市飛');
ok($zip->set_number('0180302')->is_valid_number, '秋田県にかほ市黒川');
ok($zip->set_number('0180311')->is_valid_number, '秋田県にかほ市金浦');
ok($zip->set_number('0180321')->is_valid_number, '秋田県にかほ市前川');
ok($zip->set_number('0180322')->is_valid_number, '秋田県にかほ市大竹');
ok($zip->set_number('0180400')->is_valid_number, '秋田県にかほ市以下に掲載がない場合');
ok($zip->set_number('0180401')->is_valid_number, '秋田県にかほ市両前寺');
ok($zip->set_number('0180402')->is_valid_number, '秋田県にかほ市平沢');
ok($zip->set_number('0180403')->is_valid_number, '秋田県にかほ市三森');
ok($zip->set_number('0180404')->is_valid_number, '秋田県にかほ市芹田');
ok($zip->set_number('0180411')->is_valid_number, '秋田県にかほ市院内');
ok($zip->set_number('0180412')->is_valid_number, '秋田県にかほ市小国');
ok($zip->set_number('0180413')->is_valid_number, '秋田県にかほ市馬場');
ok($zip->set_number('0180414')->is_valid_number, '秋田県にかほ市田抓');
ok($zip->set_number('0180421')->is_valid_number, '秋田県にかほ市釜ケ台');
ok($zip->set_number('0180422')->is_valid_number, '秋田県にかほ市冬師');
ok($zip->set_number('0180431')->is_valid_number, '秋田県にかほ市伊勢居地');
ok($zip->set_number('0180432')->is_valid_number, '秋田県にかほ市水沢');
ok($zip->set_number('0180433')->is_valid_number, '秋田県にかほ市畑');
ok($zip->set_number('0180434')->is_valid_number, '秋田県にかほ市寺田');
ok($zip->set_number('0180435')->is_valid_number, '秋田県にかほ市中三地');
ok($zip->set_number('0180436')->is_valid_number, '秋田県にかほ市樋目野');
ok($zip->set_number('0180601')->is_valid_number, '秋田県由利本荘市西目町海士剥');
ok($zip->set_number('0180602')->is_valid_number, '秋田県由利本荘市西目町出戸');
ok($zip->set_number('0180603')->is_valid_number, '秋田県由利本荘市西目町西目');
ok($zip->set_number('0180604')->is_valid_number, '秋田県由利本荘市西目町沼田');
ok($zip->set_number('0180711')->is_valid_number, '秋田県由利本荘市岩谷町');
ok($zip->set_number('0180721')->is_valid_number, '秋田県由利本荘市大谷');
ok($zip->set_number('0180722')->is_valid_number, '秋田県由利本荘市中館');
ok($zip->set_number('0180723')->is_valid_number, '秋田県由利本荘市牛寺');
ok($zip->set_number('0180724')->is_valid_number, '秋田県由利本荘市深沢');
ok($zip->set_number('0180725')->is_valid_number, '秋田県由利本荘市米坂');
ok($zip->set_number('0180726')->is_valid_number, '秋田県由利本荘市岩谷麓');
ok($zip->set_number('0180731')->is_valid_number, '秋田県由利本荘市大内三川');
ok($zip->set_number('0180732')->is_valid_number, '秋田県由利本荘市徳沢');
ok($zip->set_number('0180733')->is_valid_number, '秋田県由利本荘市大倉沢');
ok($zip->set_number('0180734')->is_valid_number, '秋田県由利本荘市北福田');
ok($zip->set_number('0180841')->is_valid_number, '秋田県由利本荘市加賀沢');
ok($zip->set_number('0180842')->is_valid_number, '秋田県由利本荘市新沢');
ok($zip->set_number('0180843')->is_valid_number, '秋田県由利本荘市中帳');
ok($zip->set_number('0180844')->is_valid_number, '秋田県由利本荘市高尾');
ok($zip->set_number('0180845')->is_valid_number, '秋田県由利本荘市中俣');
ok($zip->set_number('0180851')->is_valid_number, '秋田県由利本荘市平岫');
ok($zip->set_number('0180852')->is_valid_number, '秋田県由利本荘市葛岡');
ok($zip->set_number('0180853')->is_valid_number, '秋田県由利本荘市長坂');
ok($zip->set_number('0180854')->is_valid_number, '秋田県由利本荘市及位');
ok($zip->set_number('0180855')->is_valid_number, '秋田県由利本荘市松本');
ok($zip->set_number('0180901')->is_valid_number, '秋田県由利本荘市中田代');
ok($zip->set_number('0180902')->is_valid_number, '秋田県由利本荘市新田');
ok($zip->set_number('0180903')->is_valid_number, '秋田県由利本荘市小栗山');
ok($zip->set_number('0180904')->is_valid_number, '秋田県由利本荘市岩野目沢');
ok($zip->set_number('0180905')->is_valid_number, '秋田県由利本荘市滝');
ok($zip->set_number('0180906')->is_valid_number, '秋田県由利本荘市羽広');
ok($zip->set_number('0180907')->is_valid_number, '秋田県由利本荘市坂部');
ok($zip->set_number('0181211')->is_valid_number, '秋田県由利本荘市岩城滝俣');
ok($zip->set_number('0181212')->is_valid_number, '秋田県由利本荘市岩城福俣');
ok($zip->set_number('0181213')->is_valid_number, '秋田県由利本荘市岩城泉田');
ok($zip->set_number('0181214')->is_valid_number, '秋田県由利本荘市岩城富田');
ok($zip->set_number('0181215')->is_valid_number, '秋田県由利本荘市岩城赤平');
ok($zip->set_number('0181216')->is_valid_number, '秋田県由利本荘市岩城亀田愛宕町');
ok($zip->set_number('0181217')->is_valid_number, '秋田県由利本荘市岩城亀田亀田町');
ok($zip->set_number('0181218')->is_valid_number, '秋田県由利本荘市岩城亀田大町');
ok($zip->set_number('0181221')->is_valid_number, '秋田県由利本荘市岩城亀田最上町');
ok($zip->set_number('0181222')->is_valid_number, '秋田県由利本荘市岩城上蛇田');
ok($zip->set_number('0181223')->is_valid_number, '秋田県由利本荘市岩城下蛇田');
ok($zip->set_number('0181224')->is_valid_number, '秋田県由利本荘市岩城六呂田');
ok($zip->set_number('0181225')->is_valid_number, '秋田県由利本荘市岩城上黒川');
ok($zip->set_number('0181226')->is_valid_number, '秋田県由利本荘市岩城下黒川');
ok($zip->set_number('0181301')->is_valid_number, '秋田県由利本荘市岩城内道川');
ok($zip->set_number('0181302')->is_valid_number, '秋田県由利本荘市岩城勝手');
ok($zip->set_number('0181303')->is_valid_number, '秋田県由利本荘市岩城君ケ野');
ok($zip->set_number('0181304')->is_valid_number, '秋田県由利本荘市岩城道川');
ok($zip->set_number('0181305')->is_valid_number, '秋田県由利本荘市岩城二古');
ok($zip->set_number('0181400')->is_valid_number, '秋田県潟上市以下に掲載がない場合');
ok($zip->set_number('0181401')->is_valid_number, '秋田県潟上市昭和大久保');
ok($zip->set_number('0181402')->is_valid_number, '秋田県潟上市昭和乱橋');
ok($zip->set_number('0181403')->is_valid_number, '秋田県潟上市昭和八丁目');
ok($zip->set_number('0181411')->is_valid_number, '秋田県潟上市昭和豊川上虻川');
ok($zip->set_number('0181412')->is_valid_number, '秋田県潟上市昭和豊川岡井戸');
ok($zip->set_number('0181413')->is_valid_number, '秋田県潟上市昭和豊川船橋');
ok($zip->set_number('0181414')->is_valid_number, '秋田県潟上市昭和豊川槻木');
ok($zip->set_number('0181415')->is_valid_number, '秋田県潟上市昭和豊川竜毛');
ok($zip->set_number('0181416')->is_valid_number, '秋田県潟上市昭和豊川山田');
ok($zip->set_number('0181500')->is_valid_number, '秋田県南秋田郡井川町以下に掲載がない場合');
ok($zip->set_number('0181501')->is_valid_number, '秋田県潟上市飯田川金山');
ok($zip->set_number('0181502')->is_valid_number, '秋田県潟上市飯田川下虻川');
ok($zip->set_number('0181503')->is_valid_number, '秋田県潟上市飯田川和田妹川');
ok($zip->set_number('0181504')->is_valid_number, '秋田県潟上市飯田川飯塚');
ok($zip->set_number('0181511')->is_valid_number, '秋田県南秋田郡井川町今戸');
ok($zip->set_number('0181512')->is_valid_number, '秋田県南秋田郡井川町北川尻');
ok($zip->set_number('0181513')->is_valid_number, '秋田県南秋田郡井川町黒坪');
ok($zip->set_number('0181514')->is_valid_number, '秋田県南秋田郡井川町宇治木');
ok($zip->set_number('0181515')->is_valid_number, '秋田県南秋田郡井川町小竹花');
ok($zip->set_number('0181516')->is_valid_number, '秋田県南秋田郡井川町浜井川');
ok($zip->set_number('0181521')->is_valid_number, '秋田県南秋田郡井川町八田大倉');
ok($zip->set_number('0181522')->is_valid_number, '秋田県南秋田郡井川町保野子');
ok($zip->set_number('0181523')->is_valid_number, '秋田県南秋田郡井川町坂本');
ok($zip->set_number('0181524')->is_valid_number, '秋田県南秋田郡井川町大麦');
ok($zip->set_number('0181525')->is_valid_number, '秋田県南秋田郡井川町赤沢');
ok($zip->set_number('0181526')->is_valid_number, '秋田県南秋田郡井川町寺沢');
ok($zip->set_number('0181527')->is_valid_number, '秋田県南秋田郡井川町井内');
ok($zip->set_number('0181528')->is_valid_number, '秋田県南秋田郡井川町葹田');
ok($zip->set_number('0181600')->is_valid_number, '秋田県南秋田郡八郎潟町以下に掲載がない場合');
ok($zip->set_number('0181601')->is_valid_number, '秋田県南秋田郡八郎潟町真坂');
ok($zip->set_number('0181602')->is_valid_number, '秋田県南秋田郡八郎潟町浦大町');
ok($zip->set_number('0181603')->is_valid_number, '秋田県南秋田郡八郎潟町小池');
ok($zip->set_number('0181604')->is_valid_number, '秋田県南秋田郡八郎潟町野田');
ok($zip->set_number('0181605')->is_valid_number, '秋田県南秋田郡八郎潟町川崎');
ok($zip->set_number('0181606')->is_valid_number, '秋田県南秋田郡八郎潟町夜叉袋');
ok($zip->set_number('0181611')->is_valid_number, '秋田県南秋田郡八郎潟町上沖谷地');
ok($zip->set_number('0181612')->is_valid_number, '秋田県南秋田郡八郎潟町昼根下');
ok($zip->set_number('0181613')->is_valid_number, '秋田県南秋田郡八郎潟町上昼根');
ok($zip->set_number('0181614')->is_valid_number, '秋田県南秋田郡八郎潟町中田');
ok($zip->set_number('0181615')->is_valid_number, '秋田県南秋田郡八郎潟町蒲沼');
ok($zip->set_number('0181616')->is_valid_number, '秋田県南秋田郡八郎潟町大道');
ok($zip->set_number('0181617')->is_valid_number, '秋田県南秋田郡八郎潟町イカリ');
ok($zip->set_number('0181618')->is_valid_number, '秋田県南秋田郡八郎潟町川口');
ok($zip->set_number('0181621')->is_valid_number, '秋田県南秋田郡八郎潟町家の後');
ok($zip->set_number('0181622')->is_valid_number, '秋田県南秋田郡八郎潟町一日市');
ok($zip->set_number('0181623')->is_valid_number, '秋田県南秋田郡八郎潟町下川原');
ok($zip->set_number('0181624')->is_valid_number, '秋田県南秋田郡八郎潟町中久保');
ok($zip->set_number('0181625')->is_valid_number, '秋田県南秋田郡八郎潟町久保見');
ok($zip->set_number('0181626')->is_valid_number, '秋田県南秋田郡八郎潟町細川');
ok($zip->set_number('0181627')->is_valid_number, '秋田県南秋田郡八郎潟町押切');
ok($zip->set_number('0181628')->is_valid_number, '秋田県南秋田郡八郎潟町島ノ内');
ok($zip->set_number('0181629')->is_valid_number, '秋田県南秋田郡八郎潟町中嶋');
ok($zip->set_number('0181631')->is_valid_number, '秋田県南秋田郡八郎潟町八幡沼');
ok($zip->set_number('0181632')->is_valid_number, '秋田県南秋田郡八郎潟町長沼');
ok($zip->set_number('0181633')->is_valid_number, '秋田県南秋田郡八郎潟町中谷地');
ok($zip->set_number('0181634')->is_valid_number, '秋田県南秋田郡八郎潟町軒嶋');
ok($zip->set_number('0181635')->is_valid_number, '秋田県南秋田郡八郎潟町洲先');
ok($zip->set_number('0181700')->is_valid_number, '秋田県南秋田郡五城目町以下に掲載がない場合');
ok($zip->set_number('0181701')->is_valid_number, '秋田県南秋田郡五城目町兎品沢');
ok($zip->set_number('0181702')->is_valid_number, '秋田県南秋田郡五城目町杉ケ崎');
ok($zip->set_number('0181703')->is_valid_number, '秋田県南秋田郡五城目町羽黒前');
ok($zip->set_number('0181704')->is_valid_number, '秋田県南秋田郡五城目町石田六ケ村堰添');
ok($zip->set_number('0181705')->is_valid_number, '秋田県南秋田郡五城目町上町');
ok($zip->set_number('0181706')->is_valid_number, '秋田県南秋田郡五城目町下タ町');
ok($zip->set_number('0181711')->is_valid_number, '秋田県南秋田郡五城目町高崎');
ok($zip->set_number('0181712')->is_valid_number, '秋田県南秋田郡五城目町久保');
ok($zip->set_number('0181713')->is_valid_number, '秋田県南秋田郡五城目町馬場目');
ok($zip->set_number('0181714')->is_valid_number, '秋田県南秋田郡五城目町舘越');
ok($zip->set_number('0181721')->is_valid_number, '秋田県南秋田郡五城目町七倉');
ok($zip->set_number('0181722')->is_valid_number, '秋田県南秋田郡五城目町鵜ノ木');
ok($zip->set_number('0181723')->is_valid_number, '秋田県南秋田郡五城目町上樋口');
ok($zip->set_number('0181724')->is_valid_number, '秋田県南秋田郡五城目町東磯ノ目');
ok($zip->set_number('0181725')->is_valid_number, '秋田県南秋田郡五城目町西磯ノ目');
ok($zip->set_number('0181731')->is_valid_number, '秋田県南秋田郡五城目町大川石崎');
ok($zip->set_number('0181732')->is_valid_number, '秋田県南秋田郡五城目町大川西野');
ok($zip->set_number('0181733')->is_valid_number, '秋田県南秋田郡五城目町大川谷地中');
ok($zip->set_number('0181734')->is_valid_number, '秋田県南秋田郡五城目町大川大川');
ok($zip->set_number('0181735')->is_valid_number, '秋田県南秋田郡五城目町大川下樋口');
ok($zip->set_number('0181741')->is_valid_number, '秋田県南秋田郡五城目町浦大町');
ok($zip->set_number('0181742')->is_valid_number, '秋田県南秋田郡五城目町浦横町');
ok($zip->set_number('0181743')->is_valid_number, '秋田県南秋田郡五城目町稲荷前');
ok($zip->set_number('0181744')->is_valid_number, '秋田県南秋田郡五城目町神明前');
ok($zip->set_number('0181745')->is_valid_number, '秋田県南秋田郡五城目町川崎');
ok($zip->set_number('0181746')->is_valid_number, '秋田県南秋田郡五城目町小池');
ok($zip->set_number('0181747')->is_valid_number, '秋田県南秋田郡五城目町野田');
ok($zip->set_number('0181851')->is_valid_number, '秋田県南秋田郡五城目町内川浅見内');
ok($zip->set_number('0181852')->is_valid_number, '秋田県南秋田郡五城目町内川湯ノ又');
ok($zip->set_number('0181853')->is_valid_number, '秋田県南秋田郡五城目町富津内中津又');
ok($zip->set_number('0181854')->is_valid_number, '秋田県南秋田郡五城目町内川黒土');
ok($zip->set_number('0181855')->is_valid_number, '秋田県南秋田郡五城目町富津内富田');
ok($zip->set_number('0181856')->is_valid_number, '秋田県南秋田郡五城目町富津内下山内');
ok($zip->set_number('0181857')->is_valid_number, '秋田県南秋田郡五城目町内川小倉');
ok($zip->set_number('0182101')->is_valid_number, '秋田県山本郡三種町上岩川');
ok($zip->set_number('0182102')->is_valid_number, '秋田県山本郡三種町天瀬川');
ok($zip->set_number('0182103')->is_valid_number, '秋田県山本郡三種町鯉川');
ok($zip->set_number('0182104')->is_valid_number, '秋田県山本郡三種町鹿渡');
ok($zip->set_number('0182301')->is_valid_number, '秋田県山本郡三種町志戸橋');
ok($zip->set_number('0182302')->is_valid_number, '秋田県山本郡三種町下岩川');
ok($zip->set_number('0182303')->is_valid_number, '秋田県山本郡三種町森岳');
ok($zip->set_number('0182304')->is_valid_number, '秋田県山本郡三種町豊岡金田');
ok($zip->set_number('0182305')->is_valid_number, '秋田県山本郡三種町外岡');
ok($zip->set_number('0182400')->is_valid_number, '秋田県山本郡三種町以下に掲載がない場合');
ok($zip->set_number('0182401')->is_valid_number, '秋田県山本郡三種町鵜川');
ok($zip->set_number('0182402')->is_valid_number, '秋田県山本郡三種町川尻');
ok($zip->set_number('0182403')->is_valid_number, '秋田県山本郡三種町久米岡新田');
ok($zip->set_number('0182404')->is_valid_number, '秋田県山本郡三種町富岡新田');
ok($zip->set_number('0182405')->is_valid_number, '秋田県山本郡三種町芦崎');
ok($zip->set_number('0182406')->is_valid_number, '秋田県山本郡三種町大口');
ok($zip->set_number('0182407')->is_valid_number, '秋田県山本郡三種町浜田');
ok($zip->set_number('0182500')->is_valid_number, '秋田県山本郡八峰町以下に掲載がない場合');
ok($zip->set_number('0182501')->is_valid_number, '秋田県山本郡八峰町峰浜水沢');
ok($zip->set_number('0182502')->is_valid_number, '秋田県山本郡八峰町峰浜目名潟');
ok($zip->set_number('0182503')->is_valid_number, '秋田県山本郡八峰町峰浜塙');
ok($zip->set_number('0182504')->is_valid_number, '秋田県山本郡八峰町峰浜石川');
ok($zip->set_number('0182505')->is_valid_number, '秋田県山本郡八峰町峰浜内荒巻');
ok($zip->set_number('0182506')->is_valid_number, '秋田県山本郡八峰町峰浜小手萩');
ok($zip->set_number('0182507')->is_valid_number, '秋田県山本郡八峰町峰浜田中');
ok($zip->set_number('0182508')->is_valid_number, '秋田県山本郡八峰町峰浜坂形');
ok($zip->set_number('0182509')->is_valid_number, '秋田県山本郡八峰町峰浜沼田');
ok($zip->set_number('0182511')->is_valid_number, '秋田県山本郡八峰町峰浜高野々');
ok($zip->set_number('0182512')->is_valid_number, '秋田県山本郡八峰町峰浜畑谷');
ok($zip->set_number('0182601')->is_valid_number, '秋田県山本郡八峰町八森乙の水');
ok($zip->set_number('0182602')->is_valid_number, '秋田県山本郡八峰町八森チゴキ');
ok($zip->set_number('0182603')->is_valid_number, '秋田県山本郡八峰町八森物見');
ok($zip->set_number('0182604')->is_valid_number, '秋田県山本郡八峰町八森和田表');
ok($zip->set_number('0182605')->is_valid_number, '秋田県山本郡八峰町八森岩館塚の台');
ok($zip->set_number('0182606')->is_valid_number, '秋田県山本郡八峰町八森釜の上');
ok($zip->set_number('0182607')->is_valid_number, '秋田県山本郡八峰町八森林の沢');
ok($zip->set_number('0182608')->is_valid_number, '秋田県山本郡八峰町八森岩館向台');
ok($zip->set_number('0182609')->is_valid_number, '秋田県山本郡八峰町八森門の沢');
ok($zip->set_number('0182611')->is_valid_number, '秋田県山本郡八峰町八森岩館');
ok($zip->set_number('0182612')->is_valid_number, '秋田県山本郡八峰町八森ノケソリ');
ok($zip->set_number('0182613')->is_valid_number, '秋田県山本郡八峰町八森鉱山');
ok($zip->set_number('0182614')->is_valid_number, '秋田県山本郡八峰町八森小入川家の上');
ok($zip->set_number('0182615')->is_valid_number, '秋田県山本郡八峰町八森伊勢鉢台');
ok($zip->set_number('0182616')->is_valid_number, '秋田県山本郡八峰町八森三沢');
ok($zip->set_number('0182617')->is_valid_number, '秋田県山本郡八峰町八森御所の台');
ok($zip->set_number('0182618')->is_valid_number, '秋田県山本郡八峰町八森木戸の沢');
ok($zip->set_number('0182619')->is_valid_number, '秋田県山本郡八峰町八森長坂');
ok($zip->set_number('0182621')->is_valid_number, '秋田県山本郡八峰町八森茶の沢');
ok($zip->set_number('0182622')->is_valid_number, '秋田県山本郡八峰町八森家の向');
ok($zip->set_number('0182623')->is_valid_number, '秋田県山本郡八峰町八森滝ノ間');
ok($zip->set_number('0182624')->is_valid_number, '秋田県山本郡八峰町八森横間台');
ok($zip->set_number('0182625')->is_valid_number, '秋田県山本郡八峰町八森山内台');
ok($zip->set_number('0182626')->is_valid_number, '秋田県山本郡八峰町八森横間');
ok($zip->set_number('0182627')->is_valid_number, '秋田県山本郡八峰町八森山内');
ok($zip->set_number('0182628')->is_valid_number, '秋田県山本郡八峰町八森立石');
ok($zip->set_number('0182631')->is_valid_number, '秋田県山本郡八峰町八森五輪台下段');
ok($zip->set_number('0182632')->is_valid_number, '秋田県山本郡八峰町八森三十釜');
ok($zip->set_number('0182633')->is_valid_number, '秋田県山本郡八峰町八森五輪台上段');
ok($zip->set_number('0182634')->is_valid_number, '秋田県山本郡八峰町八森滝の上');
ok($zip->set_number('0182635')->is_valid_number, '秋田県山本郡八峰町八森下嘉治助台');
ok($zip->set_number('0182636')->is_valid_number, '秋田県山本郡八峰町八森上嘉治助台');
ok($zip->set_number('0182637')->is_valid_number, '秋田県山本郡八峰町八森家の後');
ok($zip->set_number('0182638')->is_valid_number, '秋田県山本郡八峰町八森茂浦');
ok($zip->set_number('0182641')->is_valid_number, '秋田県山本郡八峰町八森中浜');
ok($zip->set_number('0182642')->is_valid_number, '秋田県山本郡八峰町八森椿');
ok($zip->set_number('0182643')->is_valid_number, '秋田県山本郡八峰町八森家の上');
ok($zip->set_number('0182644')->is_valid_number, '秋田県山本郡八峰町八森椿台');
ok($zip->set_number('0182645')->is_valid_number, '秋田県山本郡八峰町八森中嶋');
ok($zip->set_number('0182646')->is_valid_number, '秋田県山本郡八峰町八森塚の台');
ok($zip->set_number('0182647')->is_valid_number, '秋田県山本郡八峰町八森鹿の浦');
ok($zip->set_number('0182648')->is_valid_number, '秋田県山本郡八峰町八森泊台');
ok($zip->set_number('0182651')->is_valid_number, '秋田県山本郡八峰町八森下館下');
ok($zip->set_number('0182652')->is_valid_number, '秋田県山本郡八峰町八森本館中台');
ok($zip->set_number('0182653')->is_valid_number, '秋田県山本郡八峰町八森倉の沢');
ok($zip->set_number('0182654')->is_valid_number, '秋田県山本郡八峰町八森諸沢口');
ok($zip->set_number('0182655')->is_valid_number, '秋田県山本郡八峰町八森本館');
ok($zip->set_number('0182656')->is_valid_number, '秋田県山本郡八峰町八森諸沢下脇');
ok($zip->set_number('0182661')->is_valid_number, '秋田県山本郡八峰町八森浜田');
ok($zip->set_number('0182662')->is_valid_number, '秋田県山本郡八峰町八森新浜田');
ok($zip->set_number('0182663')->is_valid_number, '秋田県山本郡八峰町八森樋長');
ok($zip->set_number('0182664')->is_valid_number, '秋田県山本郡八峰町八森古屋敷');
ok($zip->set_number('0182665')->is_valid_number, '秋田県山本郡八峰町八森寺の後川向');
ok($zip->set_number('0182666')->is_valid_number, '秋田県山本郡八峰町八森寺の後');
ok($zip->set_number('0182667')->is_valid_number, '秋田県山本郡八峰町八森八森家後');
ok($zip->set_number('0182671')->is_valid_number, '秋田県山本郡八峰町八森湯の尻');
ok($zip->set_number('0182672')->is_valid_number, '秋田県山本郡八峰町八森下家後');
ok($zip->set_number('0182673')->is_valid_number, '秋田県山本郡八峰町八森中家後');
ok($zip->set_number('0182674')->is_valid_number, '秋田県山本郡八峰町八森上家後');
ok($zip->set_number('0182675')->is_valid_number, '秋田県山本郡八峰町八森篭田');
ok($zip->set_number('0182676')->is_valid_number, '秋田県山本郡八峰町八森磯村');
ok($zip->set_number('0182677')->is_valid_number, '秋田県山本郡八峰町八森八森後');
ok($zip->set_number('0182678')->is_valid_number, '秋田県山本郡八峰町八森八森');
ok($zip->set_number('0182801')->is_valid_number, '秋田県能代市常盤');
ok($zip->set_number('0182802')->is_valid_number, '秋田県能代市天内');
ok($zip->set_number('0182803')->is_valid_number, '秋田県能代市外割田');
ok($zip->set_number('0182804')->is_valid_number, '秋田県能代市槐');
ok($zip->set_number('0182805')->is_valid_number, '秋田県能代市轟');
ok($zip->set_number('0182806')->is_valid_number, '秋田県能代市久喜沢');
ok($zip->set_number('0182811')->is_valid_number, '秋田県能代市産物');
ok($zip->set_number('0182812')->is_valid_number, '秋田県能代市大曲');
ok($zip->set_number('0182813')->is_valid_number, '秋田県能代市上悪土');
ok($zip->set_number('0182814')->is_valid_number, '秋田県能代市狐森');
ok($zip->set_number('0182815')->is_valid_number, '秋田県能代市東面');
ok($zip->set_number('0183101')->is_valid_number, '秋田県能代市二ツ井町麻生');
ok($zip->set_number('0183102')->is_valid_number, '秋田県能代市二ツ井町小繋');
ok($zip->set_number('0183103')->is_valid_number, '秋田県能代市二ツ井町荷上場');
ok($zip->set_number('0183104')->is_valid_number, '秋田県能代市二ツ井町沢口');
ok($zip->set_number('0183105')->is_valid_number, '秋田県能代市二ツ井町上山崎');
ok($zip->set_number('0183106')->is_valid_number, '秋田県能代市二ツ井町濁川');
ok($zip->set_number('0183107')->is_valid_number, '秋田県能代市二ツ井町苅又石');
ok($zip->set_number('0183111')->is_valid_number, '秋田県能代市二ツ井町田代');
ok($zip->set_number('0183112')->is_valid_number, '秋田県能代市二ツ井町小掛');
ok($zip->set_number('0183113')->is_valid_number, '秋田県能代市二ツ井町仁鮒');
ok($zip->set_number('0183114')->is_valid_number, '秋田県能代市二ツ井町桜台');
ok($zip->set_number('0183115')->is_valid_number, '秋田県能代市二ツ井町海道上');
ok($zip->set_number('0183116')->is_valid_number, '秋田県能代市二ツ井町家後');
ok($zip->set_number('0183117')->is_valid_number, '秋田県能代市二ツ井町塚台');
ok($zip->set_number('0183118')->is_valid_number, '秋田県能代市二ツ井町上台');
ok($zip->set_number('0183119')->is_valid_number, '秋田県能代市二ツ井町薄井');
ok($zip->set_number('0183121')->is_valid_number, '秋田県能代市二ツ井町飛根(富根)');
ok($zip->set_number('0183122')->is_valid_number, '秋田県能代市二ツ井町飛根(その他)');
ok($zip->set_number('0183123')->is_valid_number, '秋田県能代市二ツ井町駒形');
ok($zip->set_number('0183124')->is_valid_number, '秋田県能代市二ツ井町切石');
ok($zip->set_number('0183125')->is_valid_number, '秋田県能代市二ツ井町茶屋下');
ok($zip->set_number('0183126')->is_valid_number, '秋田県能代市二ツ井町狐台');
ok($zip->set_number('0183127')->is_valid_number, '秋田県能代市二ツ井町稗川原');
ok($zip->set_number('0183128')->is_valid_number, '秋田県能代市二ツ井町下稗柄');
ok($zip->set_number('0183129')->is_valid_number, '秋田県能代市二ツ井町稗柄');
ok($zip->set_number('0183131')->is_valid_number, '秋田県能代市二ツ井町梅内');
ok($zip->set_number('0183132')->is_valid_number, '秋田県能代市二ツ井町種(その他)');
ok($zip->set_number('0183133')->is_valid_number, '秋田県能代市二ツ井町種(竹原)');
ok($zip->set_number('0183134')->is_valid_number, '秋田県能代市二ツ井町高関');
ok($zip->set_number('0183135')->is_valid_number, '秋田県能代市二ツ井町山根');
ok($zip->set_number('0183141')->is_valid_number, '秋田県能代市二ツ井町五千苅');
ok($zip->set_number('0183142')->is_valid_number, '秋田県能代市二ツ井町上野');
ok($zip->set_number('0183143')->is_valid_number, '秋田県能代市二ツ井町太田面');
ok($zip->set_number('0183144')->is_valid_number, '秋田県能代市二ツ井町中坪');
ok($zip->set_number('0183145')->is_valid_number, '秋田県能代市二ツ井町道上中坪');
ok($zip->set_number('0183146')->is_valid_number, '秋田県能代市二ツ井町中坪道下');
ok($zip->set_number('0183147')->is_valid_number, '秋田県能代市二ツ井町小槻木');
ok($zip->set_number('0183148')->is_valid_number, '秋田県能代市二ツ井町槻ノ木');
ok($zip->set_number('0183151')->is_valid_number, '秋田県能代市二ツ井町三千苅');
ok($zip->set_number('0183152')->is_valid_number, '秋田県能代市二ツ井町下野家後');
ok($zip->set_number('0183153')->is_valid_number, '秋田県能代市二ツ井町滑良子川端');
ok($zip->set_number('0183154')->is_valid_number, '秋田県能代市二ツ井町町尻');
ok($zip->set_number('0183155')->is_valid_number, '秋田県能代市二ツ井町比井野');
ok($zip->set_number('0183156')->is_valid_number, '秋田県能代市二ツ井町下野川端');
ok($zip->set_number('0183157')->is_valid_number, '秋田県能代市二ツ井町下野');
ok($zip->set_number('0183200')->is_valid_number, '秋田県山本郡藤里町以下に掲載がない場合');
ok($zip->set_number('0183201')->is_valid_number, '秋田県山本郡藤里町藤琴');
ok($zip->set_number('0183202')->is_valid_number, '秋田県山本郡藤里町太良');
ok($zip->set_number('0183203')->is_valid_number, '秋田県山本郡藤里町大沢');
ok($zip->set_number('0183204')->is_valid_number, '秋田県山本郡藤里町矢坂');
ok($zip->set_number('0183205')->is_valid_number, '秋田県山本郡藤里町粕毛');
ok($zip->set_number('0183300')->is_valid_number, '秋田県北秋田市以下に掲載がない場合');
ok($zip->set_number('0183301')->is_valid_number, '秋田県北秋田市綴子');
ok($zip->set_number('0183302')->is_valid_number, '秋田県北秋田市栄');
ok($zip->set_number('0183311')->is_valid_number, '秋田県北秋田市材木町');
ok($zip->set_number('0183312')->is_valid_number, '秋田県北秋田市花園町');
ok($zip->set_number('0183313')->is_valid_number, '秋田県北秋田市旭町');
ok($zip->set_number('0183314')->is_valid_number, '秋田県北秋田市伊勢町');
ok($zip->set_number('0183315')->is_valid_number, '秋田県北秋田市宮前町');
ok($zip->set_number('0183316')->is_valid_number, '秋田県北秋田市東横町');
ok($zip->set_number('0183321')->is_valid_number, '秋田県北秋田市松葉町');
ok($zip->set_number('0183322')->is_valid_number, '秋田県北秋田市住吉町');
ok($zip->set_number('0183323')->is_valid_number, '秋田県北秋田市米代町');
ok($zip->set_number('0183324')->is_valid_number, '秋田県北秋田市大町');
ok($zip->set_number('0183325')->is_valid_number, '秋田県北秋田市元町');
ok($zip->set_number('0183331')->is_valid_number, '秋田県北秋田市鷹巣(その他)');
ok($zip->set_number('0183332')->is_valid_number, '秋田県北秋田市鷹巣(平崎上岱)');
ok($zip->set_number('0183333')->is_valid_number, '秋田県北秋田市坊沢');
ok($zip->set_number('0183341')->is_valid_number, '秋田県北秋田市黒沢');
ok($zip->set_number('0183342')->is_valid_number, '秋田県北秋田市前山');
ok($zip->set_number('0183343')->is_valid_number, '秋田県北秋田市今泉');
ok($zip->set_number('0183451')->is_valid_number, '秋田県北秋田市小森');
ok($zip->set_number('0183452')->is_valid_number, '秋田県北秋田市七日市');
ok($zip->set_number('0183453')->is_valid_number, '秋田県北秋田市中屋敷');
ok($zip->set_number('0183454')->is_valid_number, '秋田県北秋田市脇神');
ok($zip->set_number('0183501')->is_valid_number, '秋田県大館市岩瀬');
ok($zip->set_number('0183502')->is_valid_number, '秋田県大館市山田');
ok($zip->set_number('0183503')->is_valid_number, '秋田県大館市外川原');
ok($zip->set_number('0183504')->is_valid_number, '秋田県大館市長坂');
ok($zip->set_number('0183505')->is_valid_number, '秋田県大館市早口');
ok($zip->set_number('0183506')->is_valid_number, '秋田県大館市山瀬');
ok($zip->set_number('0184201')->is_valid_number, '秋田県北秋田市増沢');
ok($zip->set_number('0184202')->is_valid_number, '秋田県北秋田市八幡岱新田');
ok($zip->set_number('0184203')->is_valid_number, '秋田県北秋田市木戸石');
ok($zip->set_number('0184211')->is_valid_number, '秋田県北秋田市川井');
ok($zip->set_number('0184221')->is_valid_number, '秋田県北秋田市下杉');
ok($zip->set_number('0184231')->is_valid_number, '秋田県北秋田市上杉');
ok($zip->set_number('0184241')->is_valid_number, '秋田県北秋田市道城');
ok($zip->set_number('0184251')->is_valid_number, '秋田県北秋田市鎌沢');
ok($zip->set_number('0184261')->is_valid_number, '秋田県北秋田市芹沢');
ok($zip->set_number('0184262')->is_valid_number, '秋田県北秋田市三里');
ok($zip->set_number('0184263')->is_valid_number, '秋田県北秋田市三木田');
ok($zip->set_number('0184271')->is_valid_number, '秋田県北秋田市福田');
ok($zip->set_number('0184272')->is_valid_number, '秋田県北秋田市新田目');
ok($zip->set_number('0184273')->is_valid_number, '秋田県北秋田市根田');
ok($zip->set_number('0184281')->is_valid_number, '秋田県北秋田市羽根山');
ok($zip->set_number('0184282')->is_valid_number, '秋田県北秋田市李岱');
ok($zip->set_number('0184301')->is_valid_number, '秋田県北秋田市米内沢');
ok($zip->set_number('0184302')->is_valid_number, '秋田県北秋田市浦田');
ok($zip->set_number('0184303')->is_valid_number, '秋田県北秋田市本城');
ok($zip->set_number('0184400')->is_valid_number, '秋田県北秋田郡上小阿仁村以下に掲載がない場合');
ok($zip->set_number('0184401')->is_valid_number, '秋田県北秋田郡上小阿仁村沖田面');
ok($zip->set_number('0184411')->is_valid_number, '秋田県北秋田郡上小阿仁村福舘');
ok($zip->set_number('0184412')->is_valid_number, '秋田県北秋田郡上小阿仁村五反沢');
ok($zip->set_number('0184413')->is_valid_number, '秋田県北秋田郡上小阿仁村杉花');
ok($zip->set_number('0184421')->is_valid_number, '秋田県北秋田郡上小阿仁村小沢田');
ok($zip->set_number('0184422')->is_valid_number, '秋田県北秋田郡上小阿仁村堂川');
ok($zip->set_number('0184423')->is_valid_number, '秋田県北秋田郡上小阿仁村仏社');
ok($zip->set_number('0184431')->is_valid_number, '秋田県北秋田郡上小阿仁村大林');
ok($zip->set_number('0184432')->is_valid_number, '秋田県北秋田郡上小阿仁村南沢');
ok($zip->set_number('0184511')->is_valid_number, '秋田県北秋田市森吉');
ok($zip->set_number('0184512')->is_valid_number, '秋田県北秋田市根森田');
ok($zip->set_number('0184513')->is_valid_number, '秋田県北秋田市小又');
ok($zip->set_number('0184514')->is_valid_number, '秋田県北秋田市五味堀');
ok($zip->set_number('0184515')->is_valid_number, '秋田県北秋田市阿仁前田');
ok($zip->set_number('0184516')->is_valid_number, '秋田県北秋田市桂瀬');
ok($zip->set_number('0184601')->is_valid_number, '秋田県北秋田市阿仁吉田');
ok($zip->set_number('0184602')->is_valid_number, '秋田県北秋田市阿仁小渕');
ok($zip->set_number('0184603')->is_valid_number, '秋田県北秋田市阿仁小様');
ok($zip->set_number('0184604')->is_valid_number, '秋田県北秋田市阿仁三枚鉱山');
ok($zip->set_number('0184611')->is_valid_number, '秋田県北秋田市阿仁水無');
ok($zip->set_number('0184612')->is_valid_number, '秋田県北秋田市阿仁真木沢鉱山');
ok($zip->set_number('0184613')->is_valid_number, '秋田県北秋田市阿仁銀山');
ok($zip->set_number('0184621')->is_valid_number, '秋田県北秋田市阿仁荒瀬');
ok($zip->set_number('0184622')->is_valid_number, '秋田県北秋田市阿仁小沢鉱山');
ok($zip->set_number('0184623')->is_valid_number, '秋田県北秋田市阿仁荒瀬川櫃畑');
ok($zip->set_number('0184624')->is_valid_number, '秋田県北秋田市阿仁鍵ノ滝');
ok($zip->set_number('0184731')->is_valid_number, '秋田県北秋田市阿仁打当');
ok($zip->set_number('0184732')->is_valid_number, '秋田県北秋田市阿仁中村');
ok($zip->set_number('0184733')->is_valid_number, '秋田県北秋田市阿仁戸鳥内');
ok($zip->set_number('0184734')->is_valid_number, '秋田県北秋田市阿仁長畑');
ok($zip->set_number('0184735')->is_valid_number, '秋田県北秋田市阿仁比立内');
ok($zip->set_number('0184741')->is_valid_number, '秋田県北秋田市阿仁幸屋');
ok($zip->set_number('0184742')->is_valid_number, '秋田県北秋田市阿仁幸屋渡');
ok($zip->set_number('0184743')->is_valid_number, '秋田県北秋田市阿仁笑内');
ok($zip->set_number('0184744')->is_valid_number, '秋田県北秋田市阿仁根子');
ok($zip->set_number('0184745')->is_valid_number, '秋田県北秋田市阿仁萱草');
ok($zip->set_number('0184746')->is_valid_number, '秋田県北秋田市阿仁伏影');
ok($zip->set_number('0185141')->is_valid_number, '秋田県鹿角市八幡平');
ok($zip->set_number('0185200')->is_valid_number, '秋田県鹿角市以下に掲載がない場合');
ok($zip->set_number('0185201')->is_valid_number, '秋田県鹿角市花輪');
ok($zip->set_number('0185202')->is_valid_number, '秋田県鹿角市尾去沢');
ok($zip->set_number('0185331')->is_valid_number, '秋田県鹿角市十和田山根');
ok($zip->set_number('0185332')->is_valid_number, '秋田県鹿角市十和田上向');
ok($zip->set_number('0185333')->is_valid_number, '秋田県鹿角市十和田岡田');
ok($zip->set_number('0185334')->is_valid_number, '秋田県鹿角市十和田毛馬内');
ok($zip->set_number('0185335')->is_valid_number, '秋田県鹿角市十和田瀬田石');
ok($zip->set_number('0185336')->is_valid_number, '秋田県鹿角市十和田錦木');
ok($zip->set_number('0185337')->is_valid_number, '秋田県鹿角市十和田末広');
ok($zip->set_number('0185421')->is_valid_number, '秋田県鹿角市十和田大湯');
ok($zip->set_number('0185422')->is_valid_number, '秋田県鹿角市十和田草木');
ok($zip->set_number('0185501')->is_valid_number, '青森県十和田市奥瀬(青撫、小畳石、十和田、十和田湖畔宇樽部、十和田湖畔子ノ口、');
ok($zip->set_number('0185501')->is_valid_number, '青森県十和田市十和田湖畔休屋)');
ok($zip->set_number('0185511')->is_valid_number, '秋田県鹿角郡小坂町十和田湖');
ok($zip->set_number('0185601')->is_valid_number, '秋田県大館市十二所');
ok($zip->set_number('0185602')->is_valid_number, '秋田県大館市道目木');
ok($zip->set_number('0185603')->is_valid_number, '秋田県大館市曲田');
ok($zip->set_number('0185604')->is_valid_number, '秋田県大館市軽井沢');
ok($zip->set_number('0185605')->is_valid_number, '秋田県大館市猿間');
ok($zip->set_number('0185606')->is_valid_number, '秋田県大館市葛原');
ok($zip->set_number('0185701')->is_valid_number, '秋田県大館市比内町扇田');
ok($zip->set_number('0185711')->is_valid_number, '秋田県大館市比内町味噌内');
ok($zip->set_number('0185712')->is_valid_number, '秋田県大館市比内町新館');
ok($zip->set_number('0185721')->is_valid_number, '秋田県大館市比内町独鈷');
ok($zip->set_number('0185722')->is_valid_number, '秋田県大館市比内町中野');
ok($zip->set_number('0185731')->is_valid_number, '秋田県大館市比内町笹館');
ok($zip->set_number('0185732')->is_valid_number, '秋田県大館市比内町谷地中');
ok($zip->set_number('0185741')->is_valid_number, '秋田県大館市比内町達子');
ok($zip->set_number('0185742')->is_valid_number, '秋田県大館市比内町白沢水沢');
ok($zip->set_number('0185743')->is_valid_number, '秋田県大館市比内町小坪沢');
ok($zip->set_number('0185744')->is_valid_number, '秋田県大館市比内町八木橋');
ok($zip->set_number('0185745')->is_valid_number, '秋田県大館市比内町片貝');
ok($zip->set_number('0185751')->is_valid_number, '秋田県大館市二井田');
ok($zip->set_number('0185752')->is_valid_number, '秋田県大館市本宮');
ok($zip->set_number('0185753')->is_valid_number, '秋田県大館市比内前田');
ok($zip->set_number('0185754')->is_valid_number, '秋田県大館市大子内');
ok($zip->set_number('0185755')->is_valid_number, '秋田県大館市杉沢');
ok($zip->set_number('0185756')->is_valid_number, '秋田県大館市下川原');
ok($zip->set_number('0185851')->is_valid_number, '秋田県大館市比内町大葛');
ok($zip->set_number('0190111')->is_valid_number, '秋田県湯沢市上院内');
ok($zip->set_number('0190112')->is_valid_number, '秋田県湯沢市下院内');
ok($zip->set_number('0190113')->is_valid_number, '秋田県湯沢市院内銀山町');
ok($zip->set_number('0190201')->is_valid_number, '秋田県湯沢市泉沢');
ok($zip->set_number('0190202')->is_valid_number, '秋田県湯沢市桑崎');
ok($zip->set_number('0190203')->is_valid_number, '秋田県湯沢市寺沢');
ok($zip->set_number('0190204')->is_valid_number, '秋田県湯沢市横堀');
ok($zip->set_number('0190205')->is_valid_number, '秋田県湯沢市小野');
ok($zip->set_number('0190321')->is_valid_number, '秋田県湯沢市秋ノ宮');
ok($zip->set_number('0190401')->is_valid_number, '秋田県湯沢市酒蒔');
ok($zip->set_number('0190402')->is_valid_number, '秋田県湯沢市相川');
ok($zip->set_number('0190403')->is_valid_number, '秋田県湯沢市宇留院内');
ok($zip->set_number('0190404')->is_valid_number, '秋田県湯沢市高松');
ok($zip->set_number('0190481')->is_valid_number, '秋田県湯沢市皆瀬(水上沢)');
ok($zip->set_number('0190501')->is_valid_number, '秋田県横手市十文字町腕越');
ok($zip->set_number('0190502')->is_valid_number, '秋田県横手市十文字町西原2番町');
ok($zip->set_number('0190503')->is_valid_number, '秋田県横手市十文字町西原1番町');
ok($zip->set_number('0190505')->is_valid_number, '秋田県横手市十文字町仁井田');
ok($zip->set_number('0190506')->is_valid_number, '秋田県横手市十文字町佐賀会');
ok($zip->set_number('0190507')->is_valid_number, '秋田県横手市十文字町上鍋倉');
ok($zip->set_number('0190508')->is_valid_number, '秋田県横手市十文字町十五野新田');
ok($zip->set_number('0190509')->is_valid_number, '秋田県横手市十文字町梨木');
ok($zip->set_number('0190511')->is_valid_number, '秋田県横手市十文字町鼎');
ok($zip->set_number('0190512')->is_valid_number, '秋田県横手市十文字町越前');
ok($zip->set_number('0190513')->is_valid_number, '秋田県横手市十文字町植田');
ok($zip->set_number('0190514')->is_valid_number, '秋田県横手市十文字町睦合');
ok($zip->set_number('0190515')->is_valid_number, '秋田県横手市十文字町谷地新田');
ok($zip->set_number('0190516')->is_valid_number, '秋田県横手市十文字町源太左馬');
ok($zip->set_number('0190517')->is_valid_number, '秋田県横手市十文字町木下');
ok($zip->set_number('0190518')->is_valid_number, '秋田県横手市十文字町宝竜');
ok($zip->set_number('0190521')->is_valid_number, '秋田県横手市十文字町西下');
ok($zip->set_number('0190522')->is_valid_number, '秋田県横手市十文字町西上');
ok($zip->set_number('0190523')->is_valid_number, '秋田県横手市十文字町十文字');
ok($zip->set_number('0190524')->is_valid_number, '秋田県横手市十文字町本町');
ok($zip->set_number('0190525')->is_valid_number, '秋田県横手市十文字町曙町');
ok($zip->set_number('0190526')->is_valid_number, '秋田県横手市十文字町通町');
ok($zip->set_number('0190527')->is_valid_number, '秋田県横手市十文字町大道東');
ok($zip->set_number('0190528')->is_valid_number, '秋田県横手市十文字町栄町');
ok($zip->set_number('0190529')->is_valid_number, '秋田県横手市十文字町海道下');
ok($zip->set_number('0190531')->is_valid_number, '秋田県横手市十文字町上佐吉開');
ok($zip->set_number('0190532')->is_valid_number, '秋田県横手市十文字町麻当');
ok($zip->set_number('0190533')->is_valid_number, '秋田県横手市十文字町下佐吉開');
ok($zip->set_number('0190701')->is_valid_number, '秋田県横手市増田町増田');
ok($zip->set_number('0190702')->is_valid_number, '秋田県横手市増田町亀田');
ok($zip->set_number('0190703')->is_valid_number, '秋田県横手市増田町吉野');
ok($zip->set_number('0190704')->is_valid_number, '秋田県横手市増田町湯野沢');
ok($zip->set_number('0190705')->is_valid_number, '秋田県横手市増田町狙半内');
ok($zip->set_number('0190711')->is_valid_number, '秋田県横手市増田町荻袋');
ok($zip->set_number('0190712')->is_valid_number, '秋田県横手市増田町熊渕');
ok($zip->set_number('0190713')->is_valid_number, '秋田県横手市増田町三又');
ok($zip->set_number('0190714')->is_valid_number, '秋田県横手市増田町戸波');
ok($zip->set_number('0190715')->is_valid_number, '秋田県横手市増田町八木');
ok($zip->set_number('0190800')->is_valid_number, '秋田県雄勝郡東成瀬村以下に掲載がない場合');
ok($zip->set_number('0190801')->is_valid_number, '秋田県雄勝郡東成瀬村田子内');
ok($zip->set_number('0190802')->is_valid_number, '秋田県雄勝郡東成瀬村岩井川');
ok($zip->set_number('0190803')->is_valid_number, '秋田県雄勝郡東成瀬村椿川');
ok($zip->set_number('0191101')->is_valid_number, '秋田県横手市山内大松川');
ok($zip->set_number('0191102')->is_valid_number, '秋田県横手市山内小松川');
ok($zip->set_number('0191103')->is_valid_number, '秋田県横手市山内黒沢');
ok($zip->set_number('0191104')->is_valid_number, '秋田県横手市山内三又');
ok($zip->set_number('0191105')->is_valid_number, '秋田県横手市山内南郷');
ok($zip->set_number('0191106')->is_valid_number, '秋田県横手市山内平野沢');
ok($zip->set_number('0191107')->is_valid_number, '秋田県横手市山内筏');
ok($zip->set_number('0191108')->is_valid_number, '秋田県横手市山内土渕');
ok($zip->set_number('0191109')->is_valid_number, '秋田県横手市山内大沢');
ok($zip->set_number('0191231')->is_valid_number, '秋田県仙北郡美郷町南町');
ok($zip->set_number('0191232')->is_valid_number, '秋田県仙北郡美郷町天神堂');
ok($zip->set_number('0191233')->is_valid_number, '秋田県仙北郡美郷町境田');
ok($zip->set_number('0191234')->is_valid_number, '秋田県仙北郡美郷町飯詰');
ok($zip->set_number('0191235')->is_valid_number, '秋田県仙北郡美郷町金沢西根');
ok($zip->set_number('0191236')->is_valid_number, '秋田県仙北郡美郷町上深井');
ok($zip->set_number('0191237')->is_valid_number, '秋田県仙北郡美郷町佐野');
ok($zip->set_number('0191301')->is_valid_number, '秋田県仙北郡美郷町野荒町');
ok($zip->set_number('0191302')->is_valid_number, '秋田県仙北郡美郷町金沢');
ok($zip->set_number('0191400')->is_valid_number, '秋田県仙北郡美郷町以下に掲載がない場合');
ok($zip->set_number('0191401')->is_valid_number, '秋田県仙北郡美郷町鑓田');
ok($zip->set_number('0191402')->is_valid_number, '秋田県仙北郡美郷町野中');
ok($zip->set_number('0191403')->is_valid_number, '秋田県仙北郡美郷町六郷東根');
ok($zip->set_number('0191404')->is_valid_number, '秋田県仙北郡美郷町六郷');
ok($zip->set_number('0191501')->is_valid_number, '秋田県仙北郡美郷町浪花');
ok($zip->set_number('0191502')->is_valid_number, '秋田県仙北郡美郷町千屋');
ok($zip->set_number('0191511')->is_valid_number, '秋田県仙北郡美郷町黒沢');
ok($zip->set_number('0191512')->is_valid_number, '秋田県仙北郡美郷町本堂城回');
ok($zip->set_number('0191521')->is_valid_number, '秋田県仙北郡美郷町中野');
ok($zip->set_number('0191522')->is_valid_number, '秋田県仙北郡美郷町金沢東根');
ok($zip->set_number('0191531')->is_valid_number, '秋田県仙北郡美郷町畑屋');
ok($zip->set_number('0191532')->is_valid_number, '秋田県仙北郡美郷町羽貫谷地');
ok($zip->set_number('0191533')->is_valid_number, '秋田県仙北郡美郷町安城寺');
ok($zip->set_number('0191541')->is_valid_number, '秋田県仙北郡美郷町土崎');
ok($zip->set_number('0191542')->is_valid_number, '秋田県仙北郡美郷町小荒川');
ok($zip->set_number('0191601')->is_valid_number, '秋田県大仙市太田町横沢');
ok($zip->set_number('0191602')->is_valid_number, '秋田県大仙市太田町三本扇');
ok($zip->set_number('0191603')->is_valid_number, '秋田県大仙市太田町中里');
ok($zip->set_number('0191604')->is_valid_number, '秋田県大仙市太田町駒場');
ok($zip->set_number('0191605')->is_valid_number, '秋田県大仙市太田町国見');
ok($zip->set_number('0191611')->is_valid_number, '秋田県大仙市太田町斉内');
ok($zip->set_number('0191612')->is_valid_number, '秋田県大仙市太田町小神成');
ok($zip->set_number('0191613')->is_valid_number, '秋田県大仙市太田町太田');
ok($zip->set_number('0191614')->is_valid_number, '秋田県大仙市太田町東今泉');
ok($zip->set_number('0191615')->is_valid_number, '秋田県大仙市太田町川口');
ok($zip->set_number('0191616')->is_valid_number, '秋田県大仙市太田町永代');
ok($zip->set_number('0191701')->is_valid_number, '秋田県大仙市神宮寺');
ok($zip->set_number('0191702')->is_valid_number, '秋田県大仙市北楢岡');
ok($zip->set_number('0191801')->is_valid_number, '秋田県大仙市南外物渡台');
ok($zip->set_number('0191802')->is_valid_number, '秋田県大仙市南外小春木沢');
ok($zip->set_number('0191803')->is_valid_number, '秋田県大仙市南外坊田石兀ノ下');
ok($zip->set_number('0191804')->is_valid_number, '秋田県大仙市南外西野');
ok($zip->set_number('0191805')->is_valid_number, '秋田県大仙市南外西板戸');
ok($zip->set_number('0191806')->is_valid_number, '秋田県大仙市南外十二袋');
ok($zip->set_number('0191807')->is_valid_number, '秋田県大仙市南外川口本町');
ok($zip->set_number('0191808')->is_valid_number, '秋田県大仙市南外川口');
ok($zip->set_number('0191811')->is_valid_number, '秋田県大仙市南外本宿');
ok($zip->set_number('0191812')->is_valid_number, '秋田県大仙市南外沖田');
ok($zip->set_number('0191813')->is_valid_number, '秋田県大仙市南外猿ケ瀬出野');
ok($zip->set_number('0191814')->is_valid_number, '秋田県大仙市南外下木直');
ok($zip->set_number('0191815')->is_valid_number, '秋田県大仙市南外平形');
ok($zip->set_number('0191816')->is_valid_number, '秋田県大仙市南外上木直');
ok($zip->set_number('0191817')->is_valid_number, '秋田県大仙市南外木直沢');
ok($zip->set_number('0191822')->is_valid_number, '秋田県大仙市南外田屋村');
ok($zip->set_number('0191824')->is_valid_number, '秋田県大仙市南外宮田');
ok($zip->set_number('0191825')->is_valid_number, '秋田県大仙市南外坊田');
ok($zip->set_number('0191826')->is_valid_number, '秋田県大仙市南外田中田');
ok($zip->set_number('0191827')->is_valid_number, '秋田県大仙市南外田中田山根');
ok($zip->set_number('0191831')->is_valid_number, '秋田県大仙市南外壇ノ平山');
ok($zip->set_number('0191832')->is_valid_number, '秋田県大仙市南外北田山田ケ沢');
ok($zip->set_number('0191834')->is_valid_number, '秋田県大仙市南外揚土山');
ok($zip->set_number('0191834')->is_valid_number, '秋田県大仙市南外北田黒瀬');
ok($zip->set_number('0191835')->is_valid_number, '秋田県大仙市南外揚土');
ok($zip->set_number('0191841')->is_valid_number, '秋田県大仙市南外大杉山岸');
ok($zip->set_number('0191842')->is_valid_number, '秋田県大仙市南外大杉');
ok($zip->set_number('0191843')->is_valid_number, '秋田県大仙市南外大杉二タ又杉');
ok($zip->set_number('0191846')->is_valid_number, '秋田県大仙市南外梨木田');
ok($zip->set_number('0191847')->is_valid_number, '秋田県大仙市南外小出');
ok($zip->set_number('0191848')->is_valid_number, '秋田県大仙市南外鞦田');
ok($zip->set_number('0191851')->is_valid_number, '秋田県大仙市南外山王台');
ok($zip->set_number('0191852')->is_valid_number, '秋田県大仙市南外太田');
ok($zip->set_number('0191853')->is_valid_number, '秋田県大仙市南外坊田黒沢');
ok($zip->set_number('0191855')->is_valid_number, '秋田県大仙市南外大畑');
ok($zip->set_number('0191856')->is_valid_number, '秋田県大仙市南外大畑深山');
ok($zip->set_number('0191857')->is_valid_number, '秋田県大仙市南外大畑潜沢');
ok($zip->set_number('0191858')->is_valid_number, '秋田県大仙市南外赤平六郎沢');
ok($zip->set_number('0191861')->is_valid_number, '秋田県大仙市南外寺沢');
ok($zip->set_number('0191862')->is_valid_number, '秋田県大仙市南外和合');
ok($zip->set_number('0191863')->is_valid_number, '秋田県大仙市南外赤平貝沼');
ok($zip->set_number('0191864')->is_valid_number, '秋田県大仙市南外赤平大道東');
ok($zip->set_number('0191865')->is_valid_number, '秋田県大仙市南外赤平後野');
ok($zip->set_number('0191866')->is_valid_number, '秋田県大仙市南外赤平台野');
ok($zip->set_number('0191868')->is_valid_number, '秋田県大仙市南外赤平平家');
ok($zip->set_number('0191871')->is_valid_number, '秋田県大仙市南外谷地田');
ok($zip->set_number('0191872')->is_valid_number, '秋田県大仙市南外上中宿');
ok($zip->set_number('0191873')->is_valid_number, '秋田県大仙市南外田中');
ok($zip->set_number('0191874')->is_valid_number, '秋田県大仙市南外中宿');
ok($zip->set_number('0191875')->is_valid_number, '秋田県大仙市南外落合');
ok($zip->set_number('0191876')->is_valid_number, '秋田県大仙市南外新屋布');
ok($zip->set_number('0191877')->is_valid_number, '秋田県大仙市南外水沢');
ok($zip->set_number('0191878')->is_valid_number, '秋田県大仙市南外及位');
ok($zip->set_number('0191881')->is_valid_number, '秋田県大仙市南外葎沢');
ok($zip->set_number('0191882')->is_valid_number, '秋田県大仙市南外大和野');
ok($zip->set_number('0191883')->is_valid_number, '秋田県大仙市南外平沢');
ok($zip->set_number('0191884')->is_valid_number, '秋田県大仙市南外林ノ沢');
ok($zip->set_number('0191885')->is_valid_number, '秋田県大仙市南外無尻橋');
ok($zip->set_number('0191886')->is_valid_number, '秋田県大仙市南外西ノ又');
ok($zip->set_number('0191887')->is_valid_number, '秋田県大仙市南外中渡');
ok($zip->set_number('0191888')->is_valid_number, '秋田県大仙市南外土場');
ok($zip->set_number('0191901')->is_valid_number, '秋田県大仙市南外悪戸野');
ok($zip->set_number('0191902')->is_valid_number, '秋田県大仙市南外下袋');
ok($zip->set_number('0191903')->is_valid_number, '秋田県大仙市南外下鎌田');
ok($zip->set_number('0191904')->is_valid_number, '秋田県大仙市南外中袋');
ok($zip->set_number('0191905')->is_valid_number, '秋田県大仙市南外大向');
ok($zip->set_number('0191906')->is_valid_number, '秋田県大仙市南外金屋');
ok($zip->set_number('0191907')->is_valid_number, '秋田県大仙市南外上鎌田');
ok($zip->set_number('0191908')->is_valid_number, '秋田県大仙市南外上野');
ok($zip->set_number('0191909')->is_valid_number, '秋田県大仙市南外杉橋');
ok($zip->set_number('0191911')->is_valid_number, '秋田県大仙市南外坊村');
ok($zip->set_number('0191912')->is_valid_number, '秋田県大仙市南外丸木橋');
ok($zip->set_number('0191913')->is_valid_number, '秋田県大仙市南外湯神台');
ok($zip->set_number('0191914')->is_valid_number, '秋田県大仙市南外湯ノ又');
ok($zip->set_number('0191915')->is_valid_number, '秋田県大仙市南外下湯ノ又');
ok($zip->set_number('0191916')->is_valid_number, '秋田県大仙市南外石仏');
ok($zip->set_number('0191917')->is_valid_number, '秋田県大仙市南外薬師堂');
ok($zip->set_number('0191918')->is_valid_number, '秋田県大仙市南外広表');
ok($zip->set_number('0191921')->is_valid_number, '秋田県大仙市南外中野');
ok($zip->set_number('0191922')->is_valid_number, '秋田県大仙市南外上中野');
ok($zip->set_number('0191923')->is_valid_number, '秋田県大仙市南外巣ノ沢');
ok($zip->set_number('0191924')->is_valid_number, '秋田県大仙市南外巣ノ沢石切場');
ok($zip->set_number('0191925')->is_valid_number, '秋田県大仙市南外上巣ノ沢');
ok($zip->set_number('0191926')->is_valid_number, '秋田県大仙市南外上桑台');
ok($zip->set_number('0191927')->is_valid_number, '秋田県大仙市南外中桑台');
ok($zip->set_number('0191928')->is_valid_number, '秋田県大仙市南外滝中田表');
ok($zip->set_number('0191929')->is_valid_number, '秋田県大仙市南外中野山');
ok($zip->set_number('0191931')->is_valid_number, '秋田県大仙市南外下滝');
ok($zip->set_number('0191932')->is_valid_number, '秋田県大仙市南外大黒森');
ok($zip->set_number('0191933')->is_valid_number, '秋田県大仙市南外滝ノ沢');
ok($zip->set_number('0191934')->is_valid_number, '秋田県大仙市南外田尻');
ok($zip->set_number('0191935')->is_valid_number, '秋田県大仙市南外大平');
ok($zip->set_number('0191936')->is_valid_number, '秋田県大仙市南外中荒沢');
ok($zip->set_number('0191937')->is_valid_number, '秋田県大仙市南外小荒沢');
ok($zip->set_number('0191938')->is_valid_number, '秋田県大仙市南外下荒沢');
ok($zip->set_number('0191939')->is_valid_number, '秋田県大仙市南外水上沢');
ok($zip->set_number('0191941')->is_valid_number, '秋田県大仙市南外松木田');
ok($zip->set_number('0191942')->is_valid_number, '秋田県大仙市南外岩倉');
ok($zip->set_number('0191943')->is_valid_number, '秋田県大仙市南外一ト刎');
ok($zip->set_number('0191944')->is_valid_number, '秋田県大仙市南外湯元');
ok($zip->set_number('0191945')->is_valid_number, '秋田県大仙市南外岩瀬');
ok($zip->set_number('0191946')->is_valid_number, '秋田県大仙市南外十二ノ前');
ok($zip->set_number('0191947')->is_valid_number, '秋田県大仙市南外下釜坂');
ok($zip->set_number('0191948')->is_valid_number, '秋田県大仙市南外上釜坂');
ok($zip->set_number('0191949')->is_valid_number, '秋田県大仙市南外赤畑');
ok($zip->set_number('0191951')->is_valid_number, '秋田県大仙市南外黒滝');
ok($zip->set_number('0191952')->is_valid_number, '秋田県大仙市南外下荒又');
ok($zip->set_number('0191953')->is_valid_number, '秋田県大仙市南外外小友');
ok($zip->set_number('0191954')->is_valid_number, '秋田県大仙市南外中荒又');
ok($zip->set_number('0191955')->is_valid_number, '秋田県大仙市南外外山');
ok($zip->set_number('0191956')->is_valid_number, '秋田県大仙市南外上荒又');
ok($zip->set_number('0191957')->is_valid_number, '秋田県大仙市南外小浪滝');
ok($zip->set_number('0191958')->is_valid_number, '秋田県大仙市南外向ノ沢');
ok($zip->set_number('0191961')->is_valid_number, '秋田県大仙市南外大柳');
ok($zip->set_number('0191962')->is_valid_number, '秋田県大仙市南外若林');
ok($zip->set_number('0191963')->is_valid_number, '秋田県大仙市南外西ノ又滝ノ沢');
ok($zip->set_number('0192103')->is_valid_number, '秋田県大仙市大沢郷寺');
ok($zip->set_number('0192111')->is_valid_number, '秋田県大仙市土川');
ok($zip->set_number('0192112')->is_valid_number, '秋田県大仙市刈和野');
ok($zip->set_number('0192121')->is_valid_number, '秋田県大仙市北野目');
ok($zip->set_number('0192122')->is_valid_number, '秋田県大仙市高城');
ok($zip->set_number('0192123')->is_valid_number, '秋田県大仙市寺館');
ok($zip->set_number('0192201')->is_valid_number, '秋田県大仙市円行寺');
ok($zip->set_number('0192202')->is_valid_number, '秋田県大仙市大沢郷宿');
ok($zip->set_number('0192204')->is_valid_number, '秋田県大仙市正手沢');
ok($zip->set_number('0192205')->is_valid_number, '秋田県大仙市杉山田');
ok($zip->set_number('0192331')->is_valid_number, '秋田県大仙市大巻');
ok($zip->set_number('0192332')->is_valid_number, '秋田県大仙市九升田');
ok($zip->set_number('0192333')->is_valid_number, '秋田県大仙市金山沢');
ok($zip->set_number('0192334')->is_valid_number, '秋田県大仙市木原田');
ok($zip->set_number('0192335')->is_valid_number, '秋田県大仙市強首');
ok($zip->set_number('0192401')->is_valid_number, '秋田県大仙市協和船岡');
ok($zip->set_number('0192402')->is_valid_number, '秋田県大仙市協和船沢');
ok($zip->set_number('0192411')->is_valid_number, '秋田県大仙市協和境');
ok($zip->set_number('0192412')->is_valid_number, '秋田県大仙市協和荒川');
ok($zip->set_number('0192413')->is_valid_number, '秋田県大仙市協和上淀川');
ok($zip->set_number('0192431')->is_valid_number, '秋田県大仙市協和峰吉川');
ok($zip->set_number('0192441')->is_valid_number, '秋田県大仙市協和小種');
ok($zip->set_number('0192442')->is_valid_number, '秋田県大仙市協和下淀川');
ok($zip->set_number('0192443')->is_valid_number, '秋田県大仙市協和中淀川');
ok($zip->set_number('0192521')->is_valid_number, '秋田県大仙市協和稲沢');
ok($zip->set_number('0192601')->is_valid_number, '秋田県秋田市河辺和田');
ok($zip->set_number('0192611')->is_valid_number, '秋田県秋田市河辺戸島');
ok($zip->set_number('0192612')->is_valid_number, '秋田県秋田市河辺畑谷');
ok($zip->set_number('0192613')->is_valid_number, '秋田県秋田市河辺松渕');
ok($zip->set_number('0192614')->is_valid_number, '秋田県秋田市河辺豊成');
ok($zip->set_number('0192621')->is_valid_number, '秋田県秋田市河辺諸井');
ok($zip->set_number('0192622')->is_valid_number, '秋田県秋田市河辺高岡');
ok($zip->set_number('0192623')->is_valid_number, '秋田県秋田市河辺赤平');
ok($zip->set_number('0192624')->is_valid_number, '秋田県秋田市河辺大沢');
ok($zip->set_number('0192625')->is_valid_number, '秋田県秋田市河辺北野田高屋');
ok($zip->set_number('0192631')->is_valid_number, '秋田県秋田市河辺神内');
ok($zip->set_number('0192632')->is_valid_number, '秋田県秋田市河辺大張野');
ok($zip->set_number('0192741')->is_valid_number, '秋田県秋田市河辺岩見');
ok($zip->set_number('0192742')->is_valid_number, '秋田県秋田市河辺三内');
ok($zip->set_number('0200000')->is_valid_number, '岩手県盛岡市以下に掲載がない場合');
ok($zip->set_number('0200001')->is_valid_number, '岩手県盛岡市上米内');
ok($zip->set_number('0200002')->is_valid_number, '岩手県盛岡市桜台');
ok($zip->set_number('0200003')->is_valid_number, '岩手県盛岡市下米内');
ok($zip->set_number('0200004')->is_valid_number, '岩手県盛岡市山岸');
ok($zip->set_number('0200005')->is_valid_number, '岩手県盛岡市紅葉が丘');
ok($zip->set_number('0200011')->is_valid_number, '岩手県盛岡市三ツ割');
ok($zip->set_number('0200012')->is_valid_number, '岩手県盛岡市岩清水');
ok($zip->set_number('0200013')->is_valid_number, '岩手県盛岡市愛宕町');
ok($zip->set_number('0200014')->is_valid_number, '岩手県盛岡市愛宕下');
ok($zip->set_number('0200015')->is_valid_number, '岩手県盛岡市本町通');
ok($zip->set_number('0200016')->is_valid_number, '岩手県盛岡市名須川町');
ok($zip->set_number('0200021')->is_valid_number, '岩手県盛岡市中央通');
ok($zip->set_number('0200022')->is_valid_number, '岩手県盛岡市大通');
ok($zip->set_number('0200023')->is_valid_number, '岩手県盛岡市内丸');
ok($zip->set_number('0200024')->is_valid_number, '岩手県盛岡市菜園');
ok($zip->set_number('0200025')->is_valid_number, '岩手県盛岡市大沢川原');
ok($zip->set_number('0200026')->is_valid_number, '岩手県盛岡市開運橋通');
ok($zip->set_number('0200031')->is_valid_number, '岩手県盛岡市北夕顔瀬町');
ok($zip->set_number('0200032')->is_valid_number, '岩手県盛岡市夕顔瀬町');
ok($zip->set_number('0200033')->is_valid_number, '岩手県盛岡市盛岡駅前北通');
ok($zip->set_number('0200034')->is_valid_number, '岩手県盛岡市盛岡駅前通');
ok($zip->set_number('0200041')->is_valid_number, '岩手県盛岡市境田町');
ok($zip->set_number('0200042')->is_valid_number, '岩手県盛岡市新田町');
ok($zip->set_number('0200043')->is_valid_number, '岩手県盛岡市中川町');
ok($zip->set_number('0200044')->is_valid_number, '岩手県盛岡市城西町');
ok($zip->set_number('0200045')->is_valid_number, '岩手県盛岡市盛岡駅西通');
ok($zip->set_number('0200051')->is_valid_number, '岩手県盛岡市下太田');
ok($zip->set_number('0200052')->is_valid_number, '岩手県盛岡市中太田');
ok($zip->set_number('0200053')->is_valid_number, '岩手県盛岡市上太田');
ok($zip->set_number('0200054')->is_valid_number, '岩手県盛岡市猪去');
ok($zip->set_number('0200055')->is_valid_number, '岩手県盛岡市繋');
ok($zip->set_number('0200061')->is_valid_number, '岩手県盛岡市北山');
ok($zip->set_number('0200062')->is_valid_number, '岩手県盛岡市長田町');
ok($zip->set_number('0200063')->is_valid_number, '岩手県盛岡市材木町');
ok($zip->set_number('0200064')->is_valid_number, '岩手県盛岡市梨木町');
ok($zip->set_number('0200065')->is_valid_number, '岩手県盛岡市西下台町');
ok($zip->set_number('0200066')->is_valid_number, '岩手県盛岡市上田(1~4丁目、北山)');
ok($zip->set_number('0200101')->is_valid_number, '岩手県盛岡市岩脇町');
ok($zip->set_number('0200102')->is_valid_number, '岩手県盛岡市上田(その他)');
ok($zip->set_number('0200103')->is_valid_number, '岩手県盛岡市西松園');
ok($zip->set_number('0200104')->is_valid_number, '岩手県盛岡市小鳥沢');
ok($zip->set_number('0200105')->is_valid_number, '岩手県盛岡市北松園');
ok($zip->set_number('0200106')->is_valid_number, '岩手県盛岡市東松園');
ok($zip->set_number('0200107')->is_valid_number, '岩手県盛岡市松園');
ok($zip->set_number('0200108')->is_valid_number, '岩手県盛岡市東黒石野');
ok($zip->set_number('0200111')->is_valid_number, '岩手県盛岡市黒石野');
ok($zip->set_number('0200112')->is_valid_number, '岩手県盛岡市東緑が丘');
ok($zip->set_number('0200113')->is_valid_number, '岩手県盛岡市上田堤');
ok($zip->set_number('0200114')->is_valid_number, '岩手県盛岡市高松');
ok($zip->set_number('0200115')->is_valid_number, '岩手県盛岡市館向町');
ok($zip->set_number('0200116')->is_valid_number, '岩手県盛岡市箱清水');
ok($zip->set_number('0200117')->is_valid_number, '岩手県盛岡市緑が丘');
ok($zip->set_number('0200121')->is_valid_number, '岩手県盛岡市月が丘');
ok($zip->set_number('0200122')->is_valid_number, '岩手県盛岡市みたけ');
ok($zip->set_number('0200123')->is_valid_number, '岩手県盛岡市下厨川');
ok($zip->set_number('0200124')->is_valid_number, '岩手県盛岡市厨川');
ok($zip->set_number('0200125')->is_valid_number, '岩手県盛岡市上堂');
ok($zip->set_number('0200126')->is_valid_number, '岩手県盛岡市安倍館町');
ok($zip->set_number('0200127')->is_valid_number, '岩手県盛岡市前九年');
ok($zip->set_number('0200131')->is_valid_number, '岩手県盛岡市中堤町');
ok($zip->set_number('0200132')->is_valid_number, '岩手県盛岡市西青山');
ok($zip->set_number('0200133')->is_valid_number, '岩手県盛岡市青山');
ok($zip->set_number('0200134')->is_valid_number, '岩手県盛岡市南青山町');
ok($zip->set_number('0200135')->is_valid_number, '岩手県盛岡市大新町');
ok($zip->set_number('0200136')->is_valid_number, '岩手県盛岡市北天昌寺町');
ok($zip->set_number('0200137')->is_valid_number, '岩手県盛岡市天昌寺町');
ok($zip->set_number('0200141')->is_valid_number, '岩手県盛岡市中屋敷町');
ok($zip->set_number('0200142')->is_valid_number, '岩手県盛岡市稲荷町');
ok($zip->set_number('0200143')->is_valid_number, '岩手県盛岡市上厨川');
ok($zip->set_number('0200144')->is_valid_number, '岩手県盛岡市土淵');
ok($zip->set_number('0200145')->is_valid_number, '岩手県盛岡市平賀新田');
ok($zip->set_number('0200146')->is_valid_number, '岩手県盛岡市長橋町');
ok($zip->set_number('0200147')->is_valid_number, '岩手県盛岡市大館町');
ok($zip->set_number('0200148')->is_valid_number, '岩手県盛岡市前潟');
ok($zip->set_number('0200201')->is_valid_number, '岩手県盛岡市玉山区日戸');
ok($zip->set_number('0200202')->is_valid_number, '岩手県盛岡市玉山区玉山');
ok($zip->set_number('0200203')->is_valid_number, '岩手県盛岡市玉山区川又');
ok($zip->set_number('0200204')->is_valid_number, '岩手県盛岡市玉山区上田');
ok($zip->set_number('0200311')->is_valid_number, '岩手県盛岡市簗川');
ok($zip->set_number('0200312')->is_valid_number, '岩手県盛岡市砂子沢');
ok($zip->set_number('0200313')->is_valid_number, '岩手県盛岡市根田茂');
ok($zip->set_number('0200401')->is_valid_number, '岩手県盛岡市手代森');
ok($zip->set_number('0200402')->is_valid_number, '岩手県盛岡市黒川');
ok($zip->set_number('0200403')->is_valid_number, '岩手県盛岡市乙部');
ok($zip->set_number('0200404')->is_valid_number, '岩手県盛岡市大ケ生');
ok($zip->set_number('0200500')->is_valid_number, '岩手県岩手郡雫石町以下に掲載がない場合');
ok($zip->set_number('0200501')->is_valid_number, '岩手県岩手郡雫石町仁佐瀬');
ok($zip->set_number('0200502')->is_valid_number, '岩手県岩手郡雫石町板橋');
ok($zip->set_number('0200503')->is_valid_number, '岩手県岩手郡雫石町七ツ森');
ok($zip->set_number('0200504')->is_valid_number, '岩手県岩手郡雫石町中沼');
ok($zip->set_number('0200505')->is_valid_number, '岩手県岩手郡雫石町中黒沢川');
ok($zip->set_number('0200506')->is_valid_number, '岩手県岩手郡雫石町沼返');
ok($zip->set_number('0200507')->is_valid_number, '岩手県岩手郡雫石町丸谷地');
ok($zip->set_number('0200511')->is_valid_number, '岩手県岩手郡雫石町長畑');
ok($zip->set_number('0200512')->is_valid_number, '岩手県岩手郡雫石町塩ケ森');
ok($zip->set_number('0200513')->is_valid_number, '岩手県岩手郡雫石町下兎野');
ok($zip->set_number('0200514')->is_valid_number, '岩手県岩手郡雫石町野中');
ok($zip->set_number('0200515')->is_valid_number, '岩手県岩手郡雫石町下長根');
ok($zip->set_number('0200517')->is_valid_number, '岩手県岩手郡雫石町黒沢川');
ok($zip->set_number('0200520')->is_valid_number, '岩手県岩手郡雫石町下町東');
ok($zip->set_number('0200521')->is_valid_number, '岩手県岩手郡雫石町麁津田');
ok($zip->set_number('0200522')->is_valid_number, '岩手県岩手郡雫石町下久保');
ok($zip->set_number('0200523')->is_valid_number, '岩手県岩手郡雫石町根堀');
ok($zip->set_number('0200524')->is_valid_number, '岩手県岩手郡雫石町寺の下');
ok($zip->set_number('0200525')->is_valid_number, '岩手県岩手郡雫石町源大堂');
ok($zip->set_number('0200527')->is_valid_number, '岩手県岩手郡雫石町中町');
ok($zip->set_number('0200528')->is_valid_number, '岩手県岩手郡雫石町下町');
ok($zip->set_number('0200529')->is_valid_number, '岩手県岩手郡雫石町下町西');
ok($zip->set_number('0200530')->is_valid_number, '岩手県岩手郡雫石町上町南');
ok($zip->set_number('0200531')->is_valid_number, '岩手県岩手郡雫石町麻見田');
ok($zip->set_number('0200532')->is_valid_number, '岩手県岩手郡雫石町払川');
ok($zip->set_number('0200533')->is_valid_number, '岩手県岩手郡雫石町林');
ok($zip->set_number('0200534')->is_valid_number, '岩手県岩手郡雫石町川原');
ok($zip->set_number('0200535')->is_valid_number, '岩手県岩手郡雫石町小日谷地');
ok($zip->set_number('0200536')->is_valid_number, '岩手県岩手郡雫石町八卦');
ok($zip->set_number('0200537')->is_valid_number, '岩手県岩手郡雫石町上町西');
ok($zip->set_number('0200538')->is_valid_number, '岩手県岩手郡雫石町上町北');
ok($zip->set_number('0200539')->is_valid_number, '岩手県岩手郡雫石町上町東');
ok($zip->set_number('0200541')->is_valid_number, '岩手県岩手郡雫石町千刈田');
ok($zip->set_number('0200542')->is_valid_number, '岩手県岩手郡雫石町万田渡');
ok($zip->set_number('0200543')->is_valid_number, '岩手県岩手郡雫石町高前田');
ok($zip->set_number('0200544')->is_valid_number, '岩手県岩手郡雫石町柿木');
ok($zip->set_number('0200545')->is_valid_number, '岩手県岩手郡雫石町谷地');
ok($zip->set_number('0200546')->is_valid_number, '岩手県岩手郡雫石町稲荷下');
ok($zip->set_number('0200547')->is_valid_number, '岩手県岩手郡雫石町晴山');
ok($zip->set_number('0200551')->is_valid_number, '岩手県岩手郡雫石町笹森');
ok($zip->set_number('0200552')->is_valid_number, '岩手県岩手郡雫石町下平');
ok($zip->set_number('0200553')->is_valid_number, '岩手県岩手郡雫石町下曽根田');
ok($zip->set_number('0200554')->is_valid_number, '岩手県岩手郡雫石町町裏');
ok($zip->set_number('0200555')->is_valid_number, '岩手県岩手郡雫石町上曽根田');
ok($zip->set_number('0200556')->is_valid_number, '岩手県岩手郡雫石町名子');
ok($zip->set_number('0200557')->is_valid_number, '岩手県岩手郡雫石町上平');
ok($zip->set_number('0200558')->is_valid_number, '岩手県岩手郡雫石町下笹森');
ok($zip->set_number('0200559')->is_valid_number, '岩手県岩手郡雫石町上笹森');
ok($zip->set_number('0200571')->is_valid_number, '岩手県岩手郡雫石町繋');
ok($zip->set_number('0200572')->is_valid_number, '岩手県岩手郡雫石町西安庭');
ok($zip->set_number('0200573')->is_valid_number, '岩手県岩手郡雫石町南畑');
ok($zip->set_number('0200574')->is_valid_number, '岩手県岩手郡雫石町鴬宿');
ok($zip->set_number('0200581')->is_valid_number, '岩手県岩手郡雫石町御明神');
ok($zip->set_number('0200582')->is_valid_number, '岩手県岩手郡雫石町橋場');
ok($zip->set_number('0200583')->is_valid_number, '岩手県岩手郡雫石町上野');
ok($zip->set_number('0200584')->is_valid_number, '岩手県岩手郡雫石町西根');
ok($zip->set_number('0200585')->is_valid_number, '岩手県岩手郡雫石町長山');
ok($zip->set_number('0200600')->is_valid_number, '岩手県滝沢市以下に掲載がない場合');
ok($zip->set_number('0200601')->is_valid_number, '岩手県滝沢市後');
ok($zip->set_number('0200602')->is_valid_number, '岩手県滝沢市大森平');
ok($zip->set_number('0200603')->is_valid_number, '岩手県滝沢市留が森');
ok($zip->set_number('0200604')->is_valid_number, '岩手県滝沢市一本木');
ok($zip->set_number('0200605')->is_valid_number, '岩手県滝沢市砂込');
ok($zip->set_number('0200606')->is_valid_number, '岩手県滝沢市加賀内');
ok($zip->set_number('0200607')->is_valid_number, '岩手県滝沢市弥兵エ林');
ok($zip->set_number('0200608')->is_valid_number, '岩手県滝沢市長太郎林');
ok($zip->set_number('0200609')->is_valid_number, '岩手県滝沢市柳原');
ok($zip->set_number('0200611')->is_valid_number, '岩手県滝沢市巣子');
ok($zip->set_number('0200612')->is_valid_number, '岩手県滝沢市柳沢');
ok($zip->set_number('0200613')->is_valid_number, '岩手県滝沢市大石渡');
ok($zip->set_number('0200614')->is_valid_number, '岩手県滝沢市上中村');
ok($zip->set_number('0200615')->is_valid_number, '岩手県滝沢市卯遠坂');
ok($zip->set_number('0200616')->is_valid_number, '岩手県滝沢市木賊川');
ok($zip->set_number('0200617')->is_valid_number, '岩手県滝沢市湯舟沢');
ok($zip->set_number('0200618')->is_valid_number, '岩手県滝沢市岩手山');
ok($zip->set_number('0200619')->is_valid_number, '岩手県滝沢市上岩手山');
ok($zip->set_number('0200621')->is_valid_number, '岩手県滝沢市大崎');
ok($zip->set_number('0200622')->is_valid_number, '岩手県滝沢市野沢');
ok($zip->set_number('0200623')->is_valid_number, '岩手県滝沢市楢の木沢');
ok($zip->set_number('0200624')->is_valid_number, '岩手県滝沢市妻の神');
ok($zip->set_number('0200625')->is_valid_number, '岩手県滝沢市葉の木沢山');
ok($zip->set_number('0200626')->is_valid_number, '岩手県滝沢市明神平');
ok($zip->set_number('0200627')->is_valid_number, '岩手県滝沢市狼久保');
ok($zip->set_number('0200631')->is_valid_number, '岩手県滝沢市根堀坂');
ok($zip->set_number('0200632')->is_valid_number, '岩手県滝沢市牧野林');
ok($zip->set_number('0200633')->is_valid_number, '岩手県滝沢市穴口');
ok($zip->set_number('0200634')->is_valid_number, '岩手県滝沢市室小路');
ok($zip->set_number('0200635')->is_valid_number, '岩手県滝沢市耳取山');
ok($zip->set_number('0200636')->is_valid_number, '岩手県滝沢市大久保');
ok($zip->set_number('0200637')->is_valid_number, '岩手県滝沢市高屋敷平');
ok($zip->set_number('0200638')->is_valid_number, '岩手県滝沢市土沢');
ok($zip->set_number('0200641')->is_valid_number, '岩手県滝沢市祢宜屋敷');
ok($zip->set_number('0200642')->is_valid_number, '岩手県滝沢市中村');
ok($zip->set_number('0200643')->is_valid_number, '岩手県滝沢市外山');
ok($zip->set_number('0200644')->is_valid_number, '岩手県滝沢市平蔵沢');
ok($zip->set_number('0200645')->is_valid_number, '岩手県滝沢市高屋敷');
ok($zip->set_number('0200646')->is_valid_number, '岩手県滝沢市黒沢');
ok($zip->set_number('0200651')->is_valid_number, '岩手県滝沢市鵜飼細谷地');
ok($zip->set_number('0200652')->is_valid_number, '岩手県滝沢市鵜飼洞畑');
ok($zip->set_number('0200653')->is_valid_number, '岩手県滝沢市鵜飼迫');
ok($zip->set_number('0200654')->is_valid_number, '岩手県滝沢市中鵜飼');
ok($zip->set_number('0200655')->is_valid_number, '岩手県滝沢市鵜飼御庭田');
ok($zip->set_number('0200656')->is_valid_number, '岩手県滝沢市鵜飼上山');
ok($zip->set_number('0200657')->is_valid_number, '岩手県滝沢市鵜飼鰍森');
ok($zip->set_number('0200658')->is_valid_number, '岩手県滝沢市鵜飼清水沢');
ok($zip->set_number('0200659')->is_valid_number, '岩手県滝沢市鵜飼外久保');
ok($zip->set_number('0200661')->is_valid_number, '岩手県滝沢市鵜飼白石');
ok($zip->set_number('0200662')->is_valid_number, '岩手県滝沢市鵜飼大緩');
ok($zip->set_number('0200663')->is_valid_number, '岩手県滝沢市鵜飼諸葛川');
ok($zip->set_number('0200664')->is_valid_number, '岩手県滝沢市鵜飼笹森');
ok($zip->set_number('0200665')->is_valid_number, '岩手県滝沢市下鵜飼');
ok($zip->set_number('0200666')->is_valid_number, '岩手県滝沢市鵜飼先古川');
ok($zip->set_number('0200667')->is_valid_number, '岩手県滝沢市鵜飼向新田');
ok($zip->set_number('0200668')->is_valid_number, '岩手県滝沢市鵜飼狐洞');
ok($zip->set_number('0200671')->is_valid_number, '岩手県滝沢市鵜飼上高柳');
ok($zip->set_number('0200672')->is_valid_number, '岩手県滝沢市鵜飼下高柳');
ok($zip->set_number('0200673')->is_valid_number, '岩手県滝沢市鵜飼石留');
ok($zip->set_number('0200674')->is_valid_number, '岩手県滝沢市鵜飼高柳');
ok($zip->set_number('0200675')->is_valid_number, '岩手県滝沢市鵜飼滝向');
ok($zip->set_number('0200676')->is_valid_number, '岩手県滝沢市鵜飼八人打');
ok($zip->set_number('0200677')->is_valid_number, '岩手県滝沢市鵜飼樋の口');
ok($zip->set_number('0200678')->is_valid_number, '岩手県滝沢市鵜飼年毛');
ok($zip->set_number('0200681')->is_valid_number, '岩手県滝沢市鵜飼姥屋敷');
ok($zip->set_number('0200682')->is_valid_number, '岩手県滝沢市鵜飼臨安');
ok($zip->set_number('0200683')->is_valid_number, '岩手県滝沢市鵜飼花平');
ok($zip->set_number('0200684')->is_valid_number, '岩手県滝沢市鵜飼沼森');
ok($zip->set_number('0200685')->is_valid_number, '岩手県滝沢市鵜飼安達');
ok($zip->set_number('0200686')->is_valid_number, '岩手県滝沢市鵜飼鬼越');
ok($zip->set_number('0200687')->is_valid_number, '岩手県滝沢市上鵜飼');
ok($zip->set_number('0200688')->is_valid_number, '岩手県滝沢市鵜飼上前田');
ok($zip->set_number('0200701')->is_valid_number, '岩手県滝沢市大沢籠屋敷');
ok($zip->set_number('0200702')->is_valid_number, '岩手県滝沢市大沢上鶴子');
ok($zip->set_number('0200703')->is_valid_number, '岩手県滝沢市大沢堰合');
ok($zip->set_number('0200704')->is_valid_number, '岩手県滝沢市大沢谷地中');
ok($zip->set_number('0200705')->is_valid_number, '岩手県滝沢市大沢二タ又');
ok($zip->set_number('0200706')->is_valid_number, '岩手県滝沢市大沢割田');
ok($zip->set_number('0200707')->is_valid_number, '岩手県滝沢市大沢館');
ok($zip->set_number('0200708')->is_valid_number, '岩手県滝沢市大沢箸木平');
ok($zip->set_number('0200709')->is_valid_number, '岩手県滝沢市大沢外山野');
ok($zip->set_number('0200710')->is_valid_number, '岩手県滝沢市大沢弥作畑');
ok($zip->set_number('0200711')->is_valid_number, '岩手県滝沢市大沢谷地上');
ok($zip->set_number('0200712')->is_valid_number, '岩手県滝沢市大沢長坪');
ok($zip->set_number('0200713')->is_valid_number, '岩手県滝沢市大沢新道');
ok($zip->set_number('0200714')->is_valid_number, '岩手県滝沢市大沢舛村');
ok($zip->set_number('0200715')->is_valid_number, '岩手県滝沢市大沢下屋敷');
ok($zip->set_number('0200716')->is_valid_number, '岩手県滝沢市大沢米倉');
ok($zip->set_number('0200717')->is_valid_number, '岩手県滝沢市大沢四つ家');
ok($zip->set_number('0200718')->is_valid_number, '岩手県滝沢市大沢小谷地');
ok($zip->set_number('0200719')->is_valid_number, '岩手県滝沢市大沢鶴子');
ok($zip->set_number('0200721')->is_valid_number, '岩手県滝沢市篠木中村');
ok($zip->set_number('0200722')->is_valid_number, '岩手県滝沢市篠木上綾織');
ok($zip->set_number('0200723')->is_valid_number, '岩手県滝沢市篠木綾織');
ok($zip->set_number('0200724')->is_valid_number, '岩手県滝沢市篠木小谷地');
ok($zip->set_number('0200725')->is_valid_number, '岩手県滝沢市篠木中屋敷');
ok($zip->set_number('0200726')->is_valid_number, '岩手県滝沢市篠木荒屋');
ok($zip->set_number('0200727')->is_valid_number, '岩手県滝沢市篠木鳥谷平');
ok($zip->set_number('0200728')->is_valid_number, '岩手県滝沢市篠木上篠木');
ok($zip->set_number('0200731')->is_valid_number, '岩手県滝沢市篠木明法');
ok($zip->set_number('0200732')->is_valid_number, '岩手県滝沢市篠木樋の口');
ok($zip->set_number('0200733')->is_valid_number, '岩手県滝沢市篠木待場');
ok($zip->set_number('0200734')->is_valid_number, '岩手県滝沢市篠木上黒畑');
ok($zip->set_number('0200735')->is_valid_number, '岩手県滝沢市篠木黒畑');
ok($zip->set_number('0200736')->is_valid_number, '岩手県滝沢市篠木参郷');
ok($zip->set_number('0200737')->is_valid_number, '岩手県滝沢市篠木堤');
ok($zip->set_number('0200738')->is_valid_number, '岩手県滝沢市篠木参郷の森');
ok($zip->set_number('0200741')->is_valid_number, '岩手県滝沢市篠木矢取森');
ok($zip->set_number('0200742')->is_valid_number, '岩手県滝沢市篠木苧桶沢');
ok($zip->set_number('0200743')->is_valid_number, '岩手県滝沢市篠木外山');
ok($zip->set_number('0200744')->is_valid_number, '岩手県滝沢市篠木館が沢');
ok($zip->set_number('0200745')->is_valid_number, '岩手県滝沢市篠木大寺沢');
ok($zip->set_number('0200746')->is_valid_number, '岩手県滝沢市篠木仁沢瀬');
ok($zip->set_number('0200751')->is_valid_number, '岩手県滝沢市大釜千が窪');
ok($zip->set_number('0200752')->is_valid_number, '岩手県滝沢市大釜白山');
ok($zip->set_number('0200753')->is_valid_number, '岩手県滝沢市大釜細屋');
ok($zip->set_number('0200754')->is_valid_number, '岩手県滝沢市大釜上釜');
ok($zip->set_number('0200755')->is_valid_number, '岩手県滝沢市大釜釜口');
ok($zip->set_number('0200756')->is_valid_number, '岩手県滝沢市大釜高森');
ok($zip->set_number('0200757')->is_valid_number, '岩手県滝沢市大釜風林');
ok($zip->set_number('0200758')->is_valid_number, '岩手県滝沢市大釜大清水');
ok($zip->set_number('0200761')->is_valid_number, '岩手県滝沢市大釜田の尻');
ok($zip->set_number('0200762')->is_valid_number, '岩手県滝沢市大釜外館');
ok($zip->set_number('0200763')->is_valid_number, '岩手県滝沢市大釜大畑');
ok($zip->set_number('0200764')->is_valid_number, '岩手県滝沢市大釜土井尻');
ok($zip->set_number('0200765')->is_valid_number, '岩手県滝沢市大釜小屋敷');
ok($zip->set_number('0200766')->is_valid_number, '岩手県滝沢市大釜八幡前');
ok($zip->set_number('0200767')->is_valid_number, '岩手県滝沢市大釜中道');
ok($zip->set_number('0200768')->is_valid_number, '岩手県滝沢市大釜和田');
ok($zip->set_number('0200769')->is_valid_number, '岩手県滝沢市大釜荒屋敷');
ok($zip->set_number('0200771')->is_valid_number, '岩手県滝沢市大釜竹鼻');
ok($zip->set_number('0200772')->is_valid_number, '岩手県滝沢市大釜中瀬');
ok($zip->set_number('0200773')->is_valid_number, '岩手県滝沢市大釜上竹鼻');
ok($zip->set_number('0200774')->is_valid_number, '岩手県滝沢市大釜塩の森');
ok($zip->set_number('0200775')->is_valid_number, '岩手県滝沢市大釜沼袋');
ok($zip->set_number('0200776')->is_valid_number, '岩手県滝沢市大釜鬼が滝');
ok($zip->set_number('0200777')->is_valid_number, '岩手県滝沢市大釜仁沢瀬');
ok($zip->set_number('0200778')->is_valid_number, '岩手県滝沢市大釜吉水');
ok($zip->set_number('0200779')->is_valid_number, '岩手県滝沢市大釜吉清水');
ok($zip->set_number('0200801')->is_valid_number, '岩手県盛岡市浅岸');
ok($zip->set_number('0200802')->is_valid_number, '岩手県盛岡市つつじが丘');
ok($zip->set_number('0200803')->is_valid_number, '岩手県盛岡市新庄');
ok($zip->set_number('0200804')->is_valid_number, '岩手県盛岡市東桜山');
ok($zip->set_number('0200805')->is_valid_number, '岩手県盛岡市東新庄');
ok($zip->set_number('0200806')->is_valid_number, '岩手県盛岡市新庄町');
ok($zip->set_number('0200807')->is_valid_number, '岩手県盛岡市加賀野');
ok($zip->set_number('0200811')->is_valid_number, '岩手県盛岡市川目町');
ok($zip->set_number('0200812')->is_valid_number, '岩手県盛岡市川目');
ok($zip->set_number('0200813')->is_valid_number, '岩手県盛岡市東山');
ok($zip->set_number('0200814')->is_valid_number, '岩手県盛岡市東中野町');
ok($zip->set_number('0200815')->is_valid_number, '岩手県盛岡市小杉山');
ok($zip->set_number('0200816')->is_valid_number, '岩手県盛岡市中野');
ok($zip->set_number('0200817')->is_valid_number, '岩手県盛岡市東中野');
ok($zip->set_number('0200821')->is_valid_number, '岩手県盛岡市山王町');
ok($zip->set_number('0200822')->is_valid_number, '岩手県盛岡市茶畑');
ok($zip->set_number('0200823')->is_valid_number, '岩手県盛岡市門');
ok($zip->set_number('0200824')->is_valid_number, '岩手県盛岡市東安庭');
ok($zip->set_number('0200825')->is_valid_number, '岩手県盛岡市高崩');
ok($zip->set_number('0200826')->is_valid_number, '岩手県盛岡市神子田町');
ok($zip->set_number('0200827')->is_valid_number, '岩手県盛岡市鉈屋町');
ok($zip->set_number('0200828')->is_valid_number, '岩手県盛岡市大慈寺町');
ok($zip->set_number('0200831')->is_valid_number, '岩手県盛岡市三本柳');
ok($zip->set_number('0200832')->is_valid_number, '岩手県盛岡市東見前');
ok($zip->set_number('0200833')->is_valid_number, '岩手県盛岡市西見前');
ok($zip->set_number('0200834')->is_valid_number, '岩手県盛岡市永井');
ok($zip->set_number('0200835')->is_valid_number, '岩手県盛岡市津志田');
ok($zip->set_number('0200836')->is_valid_number, '岩手県盛岡市津志田西');
ok($zip->set_number('0200837')->is_valid_number, '岩手県盛岡市津志田町');
ok($zip->set_number('0200838')->is_valid_number, '岩手県盛岡市津志田中央');
ok($zip->set_number('0200839')->is_valid_number, '岩手県盛岡市津志田南');
ok($zip->set_number('0200841')->is_valid_number, '岩手県盛岡市羽場');
ok($zip->set_number('0200842')->is_valid_number, '岩手県盛岡市湯沢');
ok($zip->set_number('0200843')->is_valid_number, '岩手県盛岡市湯沢西');
ok($zip->set_number('0200844')->is_valid_number, '岩手県盛岡市湯沢東');
ok($zip->set_number('0200845')->is_valid_number, '岩手県盛岡市湯沢南');
ok($zip->set_number('0200846')->is_valid_number, '岩手県盛岡市流通センター北');
ok($zip->set_number('0200851')->is_valid_number, '岩手県盛岡市向中野');
ok($zip->set_number('0200852')->is_valid_number, '岩手県盛岡市飯岡新田');
ok($zip->set_number('0200853')->is_valid_number, '岩手県盛岡市下飯岡');
ok($zip->set_number('0200854')->is_valid_number, '岩手県盛岡市上飯岡');
ok($zip->set_number('0200855')->is_valid_number, '岩手県盛岡市上鹿妻');
ok($zip->set_number('0200856')->is_valid_number, '岩手県盛岡市下鹿妻');
ok($zip->set_number('0200857')->is_valid_number, '岩手県盛岡市北飯岡');
ok($zip->set_number('0200861')->is_valid_number, '岩手県盛岡市仙北');
ok($zip->set_number('0200862')->is_valid_number, '岩手県盛岡市東仙北');
ok($zip->set_number('0200863')->is_valid_number, '岩手県盛岡市南仙北');
ok($zip->set_number('0200864')->is_valid_number, '岩手県盛岡市西仙北');
ok($zip->set_number('0200865')->is_valid_number, '岩手県盛岡市仙北町');
ok($zip->set_number('0200866')->is_valid_number, '岩手県盛岡市本宮');
ok($zip->set_number('0200871')->is_valid_number, '岩手県盛岡市中ノ橋通');
ok($zip->set_number('0200872')->is_valid_number, '岩手県盛岡市八幡町');
ok($zip->set_number('0200873')->is_valid_number, '岩手県盛岡市松尾町');
ok($zip->set_number('0200874')->is_valid_number, '岩手県盛岡市南大通');
ok($zip->set_number('0200875')->is_valid_number, '岩手県盛岡市清水町');
ok($zip->set_number('0200876')->is_valid_number, '岩手県盛岡市馬場町');
ok($zip->set_number('0200877')->is_valid_number, '岩手県盛岡市下ノ橋町');
ok($zip->set_number('0200878')->is_valid_number, '岩手県盛岡市肴町');
ok($zip->set_number('0200881')->is_valid_number, '岩手県盛岡市天神町');
ok($zip->set_number('0200882')->is_valid_number, '岩手県盛岡市住吉町');
ok($zip->set_number('0200883')->is_valid_number, '岩手県盛岡市志家町');
ok($zip->set_number('0200884')->is_valid_number, '岩手県盛岡市神明町');
ok($zip->set_number('0200885')->is_valid_number, '岩手県盛岡市紺屋町');
ok($zip->set_number('0200886')->is_valid_number, '岩手県盛岡市若園町');
ok($zip->set_number('0200887')->is_valid_number, '岩手県盛岡市上ノ橋町');
ok($zip->set_number('0200891')->is_valid_number, '岩手県紫波郡矢巾町流通センター南');
ok($zip->set_number('0210000')->is_valid_number, '岩手県一関市以下に掲載がない場合');
ok($zip->set_number('0210001')->is_valid_number, '岩手県一関市新町');
ok($zip->set_number('0210002')->is_valid_number, '岩手県一関市中里(その他)');
ok($zip->set_number('0210003')->is_valid_number, '岩手県一関市東五代');
ok($zip->set_number('0210004')->is_valid_number, '岩手県一関市町浦');
ok($zip->set_number('0210005')->is_valid_number, '岩手県一関市中里(沢田)');
ok($zip->set_number('0210006')->is_valid_number, '岩手県一関市上坊');
ok($zip->set_number('0210007')->is_valid_number, '岩手県一関市上日照');
ok($zip->set_number('0210008')->is_valid_number, '岩手県一関市石畑');
ok($zip->set_number('0210011')->is_valid_number, '岩手県一関市山目町');
ok($zip->set_number('0210012')->is_valid_number, '岩手県一関市宮前町');
ok($zip->set_number('0210013')->is_valid_number, '岩手県一関市宮下町');
ok($zip->set_number('0210014')->is_valid_number, '岩手県一関市蘭梅町');
ok($zip->set_number('0210021')->is_valid_number, '岩手県一関市中央町');
ok($zip->set_number('0210022')->is_valid_number, '岩手県一関市五代町');
ok($zip->set_number('0210023')->is_valid_number, '岩手県一関市銅谷町');
ok($zip->set_number('0210024')->is_valid_number, '岩手県一関市幸町');
ok($zip->set_number('0210025')->is_valid_number, '岩手県一関市山目(向野)');
ok($zip->set_number('0210026')->is_valid_number, '岩手県一関市山目(前田)');
ok($zip->set_number('0210027')->is_valid_number, '岩手県一関市竹山町');
ok($zip->set_number('0210031')->is_valid_number, '岩手県一関市青葉');
ok($zip->set_number('0210032')->is_valid_number, '岩手県一関市末広');
ok($zip->set_number('0210033')->is_valid_number, '岩手県一関市山目(里前)');
ok($zip->set_number('0210034')->is_valid_number, '岩手県一関市山目(立沢)');
ok($zip->set_number('0210035')->is_valid_number, '岩手県一関市山目(才天)');
ok($zip->set_number('0210036')->is_valid_number, '岩手県一関市山目(十二神)');
ok($zip->set_number('0210041')->is_valid_number, '岩手県一関市赤荻');
ok($zip->set_number('0210051')->is_valid_number, '岩手県一関市山目(三反田)');
ok($zip->set_number('0210052')->is_valid_number, '岩手県一関市寿町');
ok($zip->set_number('0210053')->is_valid_number, '岩手県一関市山目(中野)');
ok($zip->set_number('0210054')->is_valid_number, '岩手県一関市山目(境)');
ok($zip->set_number('0210055')->is_valid_number, '岩手県一関市山目(泥田)');
ok($zip->set_number('0210056')->is_valid_number, '岩手県一関市山目(泥田山下)');
ok($zip->set_number('0210061')->is_valid_number, '岩手県一関市山目(館)');
ok($zip->set_number('0210062')->is_valid_number, '岩手県一関市山目(寺前)');
ok($zip->set_number('0210063')->is_valid_number, '岩手県一関市山目(大槻)');
ok($zip->set_number('0210064')->is_valid_number, '岩手県一関市山目(沢内)');
ok($zip->set_number('0210101')->is_valid_number, '岩手県一関市厳美町');
ok($zip->set_number('0210102')->is_valid_number, '岩手県一関市萩荘(赤猪子、芦ノ口、甘蕨、老流、大沢、上宇津野、上本郷、上要害、化粧');
ok($zip->set_number('0210102')->is_valid_number, '岩手県一関市坂、三月田、下宇津野、下本郷、外山、堂の沢、栃倉、栃倉南、長倉、中沢、');
ok($zip->set_number('0210102')->is_valid_number, '岩手県一関市八森、馬場、広面、平場、古釜場、曲淵、松原、南沢、谷起、焼切、八瀬、');
ok($zip->set_number('0210102')->is_valid_number, '岩手県一関市八幡、山ノ沢)');
ok($zip->set_number('0210221')->is_valid_number, '岩手県一関市舞川');
ok($zip->set_number('0210801')->is_valid_number, '岩手県一関市桜街');
ok($zip->set_number('0210802')->is_valid_number, '岩手県一関市北十軒街');
ok($zip->set_number('0210803')->is_valid_number, '岩手県一関市南十軒街');
ok($zip->set_number('0210804')->is_valid_number, '岩手県一関市五十人町');
ok($zip->set_number('0210805')->is_valid_number, '岩手県一関市豊町');
ok($zip->set_number('0210806')->is_valid_number, '岩手県一関市下大槻街');
ok($zip->set_number('0210807')->is_valid_number, '岩手県一関市東花王町');
ok($zip->set_number('0210811')->is_valid_number, '岩手県一関市久保');
ok($zip->set_number('0210812')->is_valid_number, '岩手県一関市樋渡');
ok($zip->set_number('0210813')->is_valid_number, '岩手県一関市南ほうりょう');
ok($zip->set_number('0210814')->is_valid_number, '岩手県一関市北ほうりょう');
ok($zip->set_number('0210815')->is_valid_number, '岩手県一関市要害');
ok($zip->set_number('0210821')->is_valid_number, '岩手県一関市三関');
ok($zip->set_number('0210822')->is_valid_number, '岩手県一関市東台');
ok($zip->set_number('0210831')->is_valid_number, '岩手県一関市沼田');
ok($zip->set_number('0210832')->is_valid_number, '岩手県一関市散田');
ok($zip->set_number('0210833')->is_valid_number, '岩手県一関市柄貝');
ok($zip->set_number('0210834')->is_valid_number, '岩手県一関市宇南');
ok($zip->set_number('0210835')->is_valid_number, '岩手県一関市二本木');
ok($zip->set_number('0210836')->is_valid_number, '岩手県一関市鳴神');
ok($zip->set_number('0210841')->is_valid_number, '岩手県一関市吸川街');
ok($zip->set_number('0210842')->is_valid_number, '岩手県一関市柳町');
ok($zip->set_number('0210843')->is_valid_number, '岩手県一関市深町');
ok($zip->set_number('0210844')->is_valid_number, '岩手県一関市反町');
ok($zip->set_number('0210851')->is_valid_number, '岩手県一関市関が丘');
ok($zip->set_number('0210852')->is_valid_number, '岩手県一関市沢');
ok($zip->set_number('0210853')->is_valid_number, '岩手県一関市相去');
ok($zip->set_number('0210854')->is_valid_number, '岩手県一関市西沢');
ok($zip->set_number('0210861')->is_valid_number, '岩手県一関市機織山');
ok($zip->set_number('0210862')->is_valid_number, '岩手県一関市千代田町');
ok($zip->set_number('0210863')->is_valid_number, '岩手県一関市南町');
ok($zip->set_number('0210864')->is_valid_number, '岩手県一関市旭町');
ok($zip->set_number('0210865')->is_valid_number, '岩手県一関市新山');
ok($zip->set_number('0210866')->is_valid_number, '岩手県一関市南新町');
ok($zip->set_number('0210867')->is_valid_number, '岩手県一関市駅前');
ok($zip->set_number('0210871')->is_valid_number, '岩手県一関市八幡町');
ok($zip->set_number('0210872')->is_valid_number, '岩手県一関市宮坂町');
ok($zip->set_number('0210873')->is_valid_number, '岩手県一関市台町');
ok($zip->set_number('0210874')->is_valid_number, '岩手県一関市釣山');
ok($zip->set_number('0210875')->is_valid_number, '岩手県一関市高崎町');
ok($zip->set_number('0210876')->is_valid_number, '岩手県一関市広街');
ok($zip->set_number('0210877')->is_valid_number, '岩手県一関市城内');
ok($zip->set_number('0210881')->is_valid_number, '岩手県一関市大町');
ok($zip->set_number('0210882')->is_valid_number, '岩手県一関市上大槻街');
ok($zip->set_number('0210883')->is_valid_number, '岩手県一関市新大町');
ok($zip->set_number('0210884')->is_valid_number, '岩手県一関市大手町');
ok($zip->set_number('0210885')->is_valid_number, '岩手県一関市田村町');
ok($zip->set_number('0210891')->is_valid_number, '岩手県一関市桜木町');
ok($zip->set_number('0210892')->is_valid_number, '岩手県一関市東地主町');
ok($zip->set_number('0210893')->is_valid_number, '岩手県一関市地主町');
ok($zip->set_number('0210894')->is_valid_number, '岩手県一関市磐井町');
ok($zip->set_number('0210901')->is_valid_number, '岩手県一関市真柴');
ok($zip->set_number('0210902')->is_valid_number, '岩手県一関市萩荘(その他)');
ok($zip->set_number('0220000')->is_valid_number, '岩手県大船渡市以下に掲載がない場合');
ok($zip->set_number('0220001')->is_valid_number, '岩手県大船渡市末崎町');
ok($zip->set_number('0220002')->is_valid_number, '岩手県大船渡市大船渡町');
ok($zip->set_number('0220003')->is_valid_number, '岩手県大船渡市盛町');
ok($zip->set_number('0220004')->is_valid_number, '岩手県大船渡市猪川町');
ok($zip->set_number('0220005')->is_valid_number, '岩手県大船渡市日頃市町');
ok($zip->set_number('0220006')->is_valid_number, '岩手県大船渡市立根町');
ok($zip->set_number('0220007')->is_valid_number, '岩手県大船渡市赤崎町');
ok($zip->set_number('0220101')->is_valid_number, '岩手県大船渡市三陸町越喜来');
ok($zip->set_number('0220102')->is_valid_number, '岩手県大船渡市三陸町吉浜');
ok($zip->set_number('0220211')->is_valid_number, '岩手県大船渡市三陸町綾里');
ok($zip->set_number('0230000')->is_valid_number, '岩手県奥州市以下に掲載がない場合');
ok($zip->set_number('0230001')->is_valid_number, '岩手県奥州市水沢区卸町');
ok($zip->set_number('0230002')->is_valid_number, '岩手県奥州市水沢区水沢工業団地');
ok($zip->set_number('0230003')->is_valid_number, '岩手県奥州市水沢区佐倉河');
ok($zip->set_number('0230011')->is_valid_number, '岩手県奥州市水沢区稲荷田');
ok($zip->set_number('0230012')->is_valid_number, '岩手県奥州市水沢区斉勝田');
ok($zip->set_number('0230013')->is_valid_number, '岩手県奥州市水沢区一本柳');
ok($zip->set_number('0230014')->is_valid_number, '岩手県奥州市水沢区地蔵田');
ok($zip->set_number('0230015')->is_valid_number, '岩手県奥州市水沢区五千刈');
ok($zip->set_number('0230016')->is_valid_number, '岩手県奥州市水沢区平沢');
ok($zip->set_number('0230017')->is_valid_number, '岩手県奥州市水沢区渋田');
ok($zip->set_number('0230018')->is_valid_number, '岩手県奥州市水沢区小中');
ok($zip->set_number('0230019')->is_valid_number, '岩手県奥州市水沢区築舘');
ok($zip->set_number('0230021')->is_valid_number, '岩手県奥州市水沢区欠ノ下');
ok($zip->set_number('0230022')->is_valid_number, '岩手県奥州市水沢区中城');
ok($zip->set_number('0230023')->is_valid_number, '岩手県奥州市水沢区八反町');
ok($zip->set_number('0230024')->is_valid_number, '岩手県奥州市水沢区名残');
ok($zip->set_number('0230025')->is_valid_number, '岩手県奥州市水沢区高網');
ok($zip->set_number('0230026')->is_valid_number, '岩手県奥州市水沢区里鎗');
ok($zip->set_number('0230027')->is_valid_number, '岩手県奥州市水沢区幅下');
ok($zip->set_number('0230031')->is_valid_number, '岩手県奥州市水沢区北丑沢');
ok($zip->set_number('0230032')->is_valid_number, '岩手県奥州市水沢区多賀');
ok($zip->set_number('0230033')->is_valid_number, '岩手県奥州市水沢区不断町');
ok($zip->set_number('0230034')->is_valid_number, '岩手県奥州市水沢区川口町');
ok($zip->set_number('0230035')->is_valid_number, '岩手県奥州市水沢区赤土田');
ok($zip->set_number('0230036')->is_valid_number, '岩手県奥州市水沢区北栗林');
ok($zip->set_number('0230037')->is_valid_number, '岩手県奥州市水沢区南丑沢');
ok($zip->set_number('0230041')->is_valid_number, '岩手県奥州市水沢区秋葉町');
ok($zip->set_number('0230042')->is_valid_number, '岩手県奥州市水沢区柳町');
ok($zip->set_number('0230043')->is_valid_number, '岩手県奥州市水沢区道合');
ok($zip->set_number('0230044')->is_valid_number, '岩手県奥州市水沢区三本木');
ok($zip->set_number('0230045')->is_valid_number, '岩手県奥州市水沢区大町');
ok($zip->set_number('0230046')->is_valid_number, '岩手県奥州市水沢区川原小路');
ok($zip->set_number('0230047')->is_valid_number, '岩手県奥州市水沢区立町');
ok($zip->set_number('0230051')->is_valid_number, '岩手県奥州市水沢区勝手町');
ok($zip->set_number('0230052')->is_valid_number, '岩手県奥州市水沢区搦手丁');
ok($zip->set_number('0230053')->is_valid_number, '岩手県奥州市水沢区大手町');
ok($zip->set_number('0230054')->is_valid_number, '岩手県奥州市水沢区吉小路');
ok($zip->set_number('0230055')->is_valid_number, '岩手県奥州市水沢区虚空蔵小路');
ok($zip->set_number('0230056')->is_valid_number, '岩手県奥州市水沢区久田');
ok($zip->set_number('0230057')->is_valid_number, '岩手県奥州市水沢区上町');
ok($zip->set_number('0230058')->is_valid_number, '岩手県奥州市水沢区堀ノ内');
ok($zip->set_number('0230061')->is_valid_number, '岩手県奥州市水沢区長町');
ok($zip->set_number('0230062')->is_valid_number, '岩手県奥州市水沢区小石田');
ok($zip->set_number('0230063')->is_valid_number, '岩手県奥州市水沢区聖天');
ok($zip->set_number('0230064')->is_valid_number, '岩手県奥州市水沢区土器田');
ok($zip->set_number('0230065')->is_valid_number, '岩手県奥州市水沢区水山');
ok($zip->set_number('0230066')->is_valid_number, '岩手県奥州市水沢区前田袋');
ok($zip->set_number('0230067')->is_valid_number, '岩手県奥州市水沢区二反田');
ok($zip->set_number('0230071')->is_valid_number, '岩手県奥州市水沢区黒子');
ok($zip->set_number('0230072')->is_valid_number, '岩手県奥州市水沢区樋渡');
ok($zip->set_number('0230073')->is_valid_number, '岩手県奥州市水沢区寺領');
ok($zip->set_number('0230074')->is_valid_number, '岩手県奥州市水沢区極楽');
ok($zip->set_number('0230075')->is_valid_number, '岩手県奥州市水沢区水ノ口');
ok($zip->set_number('0230076')->is_valid_number, '岩手県奥州市水沢区造道');
ok($zip->set_number('0230077')->is_valid_number, '岩手県奥州市水沢区桑畑');
ok($zip->set_number('0230081')->is_valid_number, '岩手県奥州市水沢区橇町');
ok($zip->set_number('0230082')->is_valid_number, '岩手県奥州市水沢区東半郷');
ok($zip->set_number('0230083')->is_valid_number, '岩手県奥州市水沢区前郷');
ok($zip->set_number('0230084')->is_valid_number, '岩手県奥州市水沢区大上');
ok($zip->set_number('0230085')->is_valid_number, '岩手県奥州市水沢区踊子');
ok($zip->set_number('0230086')->is_valid_number, '岩手県奥州市水沢区谷地中');
ok($zip->set_number('0230087')->is_valid_number, '岩手県奥州市水沢区高谷宿');
ok($zip->set_number('0230091')->is_valid_number, '岩手県奥州市水沢区高山');
ok($zip->set_number('0230092')->is_valid_number, '岩手県奥州市水沢区北半郷');
ok($zip->set_number('0230093')->is_valid_number, '岩手県奥州市水沢区水神');
ok($zip->set_number('0230094')->is_valid_number, '岩手県奥州市水沢区五輪');
ok($zip->set_number('0230095')->is_valid_number, '岩手県奥州市水沢区雀田');
ok($zip->set_number('0230096')->is_valid_number, '岩手県奥州市水沢区向田');
ok($zip->set_number('0230101')->is_valid_number, '岩手県奥州市水沢区黒石町');
ok($zip->set_number('0230102')->is_valid_number, '岩手県奥州市水沢区羽田町駅東');
ok($zip->set_number('0230103')->is_valid_number, '岩手県奥州市水沢区羽田町駅南');
ok($zip->set_number('0230104')->is_valid_number, '岩手県奥州市水沢区羽田町駅前');
ok($zip->set_number('0230105')->is_valid_number, '岩手県奥州市水沢区羽田町宝生');
ok($zip->set_number('0230106')->is_valid_number, '岩手県奥州市水沢区羽田町久保');
ok($zip->set_number('0230107')->is_valid_number, '岩手県奥州市水沢区羽田町宝柳木');
ok($zip->set_number('0230108')->is_valid_number, '岩手県奥州市水沢区羽田町向畑');
ok($zip->set_number('0230132')->is_valid_number, '岩手県奥州市水沢区羽田町(その他)');
ok($zip->set_number('0230171')->is_valid_number, '岩手県奥州市江刺区田原');
ok($zip->set_number('0230401')->is_valid_number, '岩手県奥州市胆沢区南都田');
ok($zip->set_number('0230402')->is_valid_number, '岩手県奥州市胆沢区小山');
ok($zip->set_number('0230403')->is_valid_number, '岩手県奥州市胆沢区若柳');
ok($zip->set_number('0230801')->is_valid_number, '岩手県奥州市水沢区横町');
ok($zip->set_number('0230802')->is_valid_number, '岩手県奥州市水沢区大畑小路');
ok($zip->set_number('0230803')->is_valid_number, '岩手県奥州市水沢区田小路');
ok($zip->set_number('0230804')->is_valid_number, '岩手県奥州市水沢区谷地明円');
ok($zip->set_number('0230805')->is_valid_number, '岩手県奥州市水沢区斉の神');
ok($zip->set_number('0230806')->is_valid_number, '岩手県奥州市水沢区日高西');
ok($zip->set_number('0230807')->is_valid_number, '岩手県奥州市水沢区新小路');
ok($zip->set_number('0230808')->is_valid_number, '岩手県奥州市水沢区日高小路');
ok($zip->set_number('0230811')->is_valid_number, '岩手県奥州市水沢区寺小路');
ok($zip->set_number('0230812')->is_valid_number, '岩手県奥州市水沢区寺脇');
ok($zip->set_number('0230813')->is_valid_number, '岩手県奥州市水沢区中町');
ok($zip->set_number('0230814')->is_valid_number, '岩手県奥州市水沢区袋町');
ok($zip->set_number('0230815')->is_valid_number, '岩手県奥州市水沢区天文台通り');
ok($zip->set_number('0230816')->is_valid_number, '岩手県奥州市水沢区西町');
ok($zip->set_number('0230817')->is_valid_number, '岩手県奥州市水沢区宮下町');
ok($zip->set_number('0230818')->is_valid_number, '岩手県奥州市水沢区東町');
ok($zip->set_number('0230821')->is_valid_number, '岩手県奥州市水沢区神明町');
ok($zip->set_number('0230822')->is_valid_number, '岩手県奥州市水沢区東中通り');
ok($zip->set_number('0230823')->is_valid_number, '岩手県奥州市水沢区朝日町');
ok($zip->set_number('0230824')->is_valid_number, '岩手県奥州市水沢区泉町');
ok($zip->set_number('0230825')->is_valid_number, '岩手県奥州市水沢区台町');
ok($zip->set_number('0230826')->is_valid_number, '岩手県奥州市水沢区中田町');
ok($zip->set_number('0230827')->is_valid_number, '岩手県奥州市水沢区太日通り');
ok($zip->set_number('0230828')->is_valid_number, '岩手県奥州市水沢区東大通り');
ok($zip->set_number('0230829')->is_valid_number, '岩手県奥州市水沢区花園町');
ok($zip->set_number('0230831')->is_valid_number, '岩手県奥州市水沢区姉体町');
ok($zip->set_number('0230832')->is_valid_number, '岩手県奥州市水沢区羽田町(草井沼、下沼、谷木、元谷木)');
ok($zip->set_number('0230833')->is_valid_number, '岩手県奥州市水沢区上姉体');
ok($zip->set_number('0230841')->is_valid_number, '岩手県奥州市水沢区真城');
ok($zip->set_number('0230842')->is_valid_number, '岩手県奥州市水沢区真城が丘');
ok($zip->set_number('0230851')->is_valid_number, '岩手県奥州市水沢区南町');
ok($zip->set_number('0230852')->is_valid_number, '岩手県奥州市水沢区山崎町');
ok($zip->set_number('0230853')->is_valid_number, '岩手県奥州市水沢区東上野町');
ok($zip->set_number('0230854')->is_valid_number, '岩手県奥州市水沢区大鐘町');
ok($zip->set_number('0230855')->is_valid_number, '岩手県奥州市水沢区南大鐘');
ok($zip->set_number('0230856')->is_valid_number, '岩手県奥州市水沢区西上野町');
ok($zip->set_number('0230857')->is_valid_number, '岩手県奥州市水沢区中上野町');
ok($zip->set_number('0230861')->is_valid_number, '岩手県奥州市水沢区星ガ丘町');
ok($zip->set_number('0230862')->is_valid_number, '岩手県奥州市水沢区福吉町');
ok($zip->set_number('0230863')->is_valid_number, '岩手県奥州市水沢区川端');
ok($zip->set_number('0230864')->is_valid_number, '岩手県奥州市水沢区龍ケ馬場');
ok($zip->set_number('0230865')->is_valid_number, '岩手県奥州市水沢区桜屋敷');
ok($zip->set_number('0230866')->is_valid_number, '岩手県奥州市水沢区堰合');
ok($zip->set_number('0230867')->is_valid_number, '岩手県奥州市水沢区大橋');
ok($zip->set_number('0230871')->is_valid_number, '岩手県奥州市水沢区外谷地');
ok($zip->set_number('0230872')->is_valid_number, '岩手県奥州市水沢区桜屋敷西');
ok($zip->set_number('0230873')->is_valid_number, '岩手県奥州市水沢区笹森谷地');
ok($zip->set_number('0230874')->is_valid_number, '岩手県奥州市水沢区見分森');
ok($zip->set_number('0230875')->is_valid_number, '岩手県奥州市水沢区森下');
ok($zip->set_number('0230876')->is_valid_number, '岩手県奥州市水沢区鶴淵');
ok($zip->set_number('0230877')->is_valid_number, '岩手県奥州市水沢区袖谷地');
ok($zip->set_number('0230881')->is_valid_number, '岩手県奥州市水沢区北田');
ok($zip->set_number('0230882')->is_valid_number, '岩手県奥州市水沢区福原');
ok($zip->set_number('0230883')->is_valid_number, '岩手県奥州市水沢区町裏');
ok($zip->set_number('0230884')->is_valid_number, '岩手県奥州市水沢区前谷地');
ok($zip->set_number('0230885')->is_valid_number, '岩手県奥州市水沢区西田');
ok($zip->set_number('0230886')->is_valid_number, '岩手県奥州市水沢区南矢中');
ok($zip->set_number('0230887')->is_valid_number, '岩手県奥州市水沢区矢中');
ok($zip->set_number('0230888')->is_valid_number, '岩手県奥州市水沢区八反田');
ok($zip->set_number('0230889')->is_valid_number, '岩手県奥州市水沢区高屋敷');
ok($zip->set_number('0230891')->is_valid_number, '岩手県奥州市水沢区内匠田');
ok($zip->set_number('0230892')->is_valid_number, '岩手県奥州市水沢区釜田');
ok($zip->set_number('0230893')->is_valid_number, '岩手県奥州市水沢区蓬田');
ok($zip->set_number('0230894')->is_valid_number, '岩手県奥州市水沢区大明神');
ok($zip->set_number('0230895')->is_valid_number, '岩手県奥州市水沢区足袋針');
ok($zip->set_number('0230896')->is_valid_number, '岩手県奥州市水沢区西光田');
ok($zip->set_number('0230897')->is_valid_number, '岩手県奥州市水沢区桜川');
ok($zip->set_number('0230898')->is_valid_number, '岩手県奥州市水沢区後田');
ok($zip->set_number('0231101')->is_valid_number, '岩手県奥州市江刺区岩谷堂');
ok($zip->set_number('0231102')->is_valid_number, '岩手県奥州市江刺区八日町');
ok($zip->set_number('0231103')->is_valid_number, '岩手県奥州市江刺区西大通り');
ok($zip->set_number('0231104')->is_valid_number, '岩手県奥州市江刺区豊田町');
ok($zip->set_number('0231105')->is_valid_number, '岩手県奥州市江刺区杉ノ町');
ok($zip->set_number('0231111')->is_valid_number, '岩手県奥州市江刺区大通り');
ok($zip->set_number('0231112')->is_valid_number, '岩手県奥州市江刺区南大通り');
ok($zip->set_number('0231113')->is_valid_number, '岩手県奥州市江刺区中町');
ok($zip->set_number('0231114')->is_valid_number, '岩手県奥州市江刺区川原町');
ok($zip->set_number('0231115')->is_valid_number, '岩手県奥州市江刺区本町');
ok($zip->set_number('0231116')->is_valid_number, '岩手県奥州市江刺区重染寺');
ok($zip->set_number('0231117')->is_valid_number, '岩手県奥州市江刺区南町');
ok($zip->set_number('0231118')->is_valid_number, '岩手県奥州市江刺区栄町');
ok($zip->set_number('0231121')->is_valid_number, '岩手県奥州市江刺区男石');
ok($zip->set_number('0231122')->is_valid_number, '岩手県奥州市江刺区舘山');
ok($zip->set_number('0231123')->is_valid_number, '岩手県奥州市江刺区前田町');
ok($zip->set_number('0231124')->is_valid_number, '岩手県奥州市江刺区六日町');
ok($zip->set_number('0231125')->is_valid_number, '岩手県奥州市江刺区銭町');
ok($zip->set_number('0231131')->is_valid_number, '岩手県奥州市江刺区愛宕');
ok($zip->set_number('0231132')->is_valid_number, '岩手県奥州市江刺区稲瀬');
ok($zip->set_number('0231133')->is_valid_number, '岩手県奥州市江刺区広瀬');
ok($zip->set_number('0231134')->is_valid_number, '岩手県奥州市江刺区玉里');
ok($zip->set_number('0231341')->is_valid_number, '岩手県奥州市江刺区梁川');
ok($zip->set_number('0231551')->is_valid_number, '岩手県奥州市江刺区米里');
ok($zip->set_number('0231761')->is_valid_number, '岩手県奥州市江刺区伊手');
ok($zip->set_number('0231762')->is_valid_number, '岩手県奥州市江刺区藤里');
ok($zip->set_number('0240000')->is_valid_number, '岩手県北上市以下に掲載がない場合');
ok($zip->set_number('0240001')->is_valid_number, '岩手県北上市飯豊');
ok($zip->set_number('0240002')->is_valid_number, '岩手県北上市北工業団地(その他)');
ok($zip->set_number('0240003')->is_valid_number, '岩手県北上市成田');
ok($zip->set_number('0240004')->is_valid_number, '岩手県北上市村崎野');
ok($zip->set_number('0240011')->is_valid_number, '岩手県北上市堤ケ丘');
ok($zip->set_number('0240012')->is_valid_number, '岩手県北上市常盤台');
ok($zip->set_number('0240013')->is_valid_number, '岩手県北上市藤沢');
ok($zip->set_number('0240014')->is_valid_number, '岩手県北上市流通センター');
ok($zip->set_number('0240021')->is_valid_number, '岩手県北上市上野町');
ok($zip->set_number('0240022')->is_valid_number, '岩手県北上市黒沢尻');
ok($zip->set_number('0240023')->is_valid_number, '岩手県北上市里分');
ok($zip->set_number('0240024')->is_valid_number, '岩手県北上市中野町');
ok($zip->set_number('0240025')->is_valid_number, '岩手県北上市孫屋敷');
ok($zip->set_number('0240031')->is_valid_number, '岩手県北上市青柳町');
ok($zip->set_number('0240032')->is_valid_number, '岩手県北上市川岸');
ok($zip->set_number('0240033')->is_valid_number, '岩手県北上市幸町');
ok($zip->set_number('0240034')->is_valid_number, '岩手県北上市諏訪町');
ok($zip->set_number('0240035')->is_valid_number, '岩手県北上市花園町');
ok($zip->set_number('0240041')->is_valid_number, '岩手県北上市稲瀬町');
ok($zip->set_number('0240042')->is_valid_number, '岩手県北上市黒岩');
ok($zip->set_number('0240043')->is_valid_number, '岩手県北上市立花');
ok($zip->set_number('0240044')->is_valid_number, '岩手県北上市平沢');
ok($zip->set_number('0240045')->is_valid_number, '岩手県北上市湯沢');
ok($zip->set_number('0240051')->is_valid_number, '岩手県北上市相去町');
ok($zip->set_number('0240052')->is_valid_number, '岩手県北上市大堤北');
ok($zip->set_number('0240053')->is_valid_number, '岩手県北上市大堤西');
ok($zip->set_number('0240054')->is_valid_number, '岩手県北上市大堤東');
ok($zip->set_number('0240055')->is_valid_number, '岩手県北上市大堤南');
ok($zip->set_number('0240056')->is_valid_number, '岩手県北上市鬼柳町');
ok($zip->set_number('0240057')->is_valid_number, '岩手県北上市上鬼柳');
ok($zip->set_number('0240058')->is_valid_number, '岩手県北上市下鬼柳');
ok($zip->set_number('0240061')->is_valid_number, '岩手県北上市大通り');
ok($zip->set_number('0240062')->is_valid_number, '岩手県北上市鍛冶町');
ok($zip->set_number('0240063')->is_valid_number, '岩手県北上市九年橋');
ok($zip->set_number('0240064')->is_valid_number, '岩手県北上市若宮町');
ok($zip->set_number('0240071')->is_valid_number, '岩手県北上市上江釣子');
ok($zip->set_number('0240072')->is_valid_number, '岩手県北上市北鬼柳');
ok($zip->set_number('0240073')->is_valid_number, '岩手県北上市下江釣子');
ok($zip->set_number('0240074')->is_valid_number, '岩手県北上市滑田');
ok($zip->set_number('0240075')->is_valid_number, '岩手県北上市新平');
ok($zip->set_number('0240076')->is_valid_number, '岩手県北上市鳩岡崎');
ok($zip->set_number('0240081')->is_valid_number, '岩手県北上市有田町');
ok($zip->set_number('0240082')->is_valid_number, '岩手県北上市町分');
ok($zip->set_number('0240083')->is_valid_number, '岩手県北上市柳原町');
ok($zip->set_number('0240084')->is_valid_number, '岩手県北上市さくら通り');
ok($zip->set_number('0240091')->is_valid_number, '岩手県北上市大曲町');
ok($zip->set_number('0240092')->is_valid_number, '岩手県北上市新穀町');
ok($zip->set_number('0240093')->is_valid_number, '岩手県北上市本石町');
ok($zip->set_number('0240094')->is_valid_number, '岩手県北上市本通り');
ok($zip->set_number('0240095')->is_valid_number, '岩手県北上市芳町');
ok($zip->set_number('0240101')->is_valid_number, '岩手県北上市臥牛');
ok($zip->set_number('0240102')->is_valid_number, '岩手県北上市北工業団地(3、5番地)');
ok($zip->set_number('0240103')->is_valid_number, '岩手県北上市更木');
ok($zip->set_number('0240104')->is_valid_number, '岩手県北上市二子町');
ok($zip->set_number('0240105')->is_valid_number, '岩手県北上市小鳥崎');
ok($zip->set_number('0240211')->is_valid_number, '岩手県北上市口内町');
ok($zip->set_number('0240321')->is_valid_number, '岩手県北上市和賀町岩崎');
ok($zip->set_number('0240322')->is_valid_number, '岩手県北上市和賀町岩崎新田');
ok($zip->set_number('0240323')->is_valid_number, '岩手県北上市和賀町煤孫');
ok($zip->set_number('0240324')->is_valid_number, '岩手県北上市和賀町山口');
ok($zip->set_number('0240325')->is_valid_number, '岩手県北上市和賀町岩沢');
ok($zip->set_number('0240326')->is_valid_number, '岩手県北上市和賀町仙人');
ok($zip->set_number('0240331')->is_valid_number, '岩手県北上市和賀町横川目');
ok($zip->set_number('0240332')->is_valid_number, '岩手県北上市和賀町竪川目');
ok($zip->set_number('0240333')->is_valid_number, '岩手県北上市和賀町長沼');
ok($zip->set_number('0240334')->is_valid_number, '岩手県北上市和賀町藤根');
ok($zip->set_number('0240335')->is_valid_number, '岩手県北上市和賀町後藤');
ok($zip->set_number('0240341')->is_valid_number, '岩手県和賀郡西和賀町杉名畑44地割(湯田ダム管理事務所、後口山、当楽)');
ok($zip->set_number('0250000')->is_valid_number, '岩手県花巻市以下に掲載がない場合');
ok($zip->set_number('0250001')->is_valid_number, '岩手県花巻市天下田');
ok($zip->set_number('0250002')->is_valid_number, '岩手県花巻市西宮野目');
ok($zip->set_number('0250003')->is_valid_number, '岩手県花巻市東宮野目');
ok($zip->set_number('0250004')->is_valid_number, '岩手県花巻市葛');
ok($zip->set_number('0250005')->is_valid_number, '岩手県花巻市田力');
ok($zip->set_number('0250006')->is_valid_number, '岩手県花巻市下似内');
ok($zip->set_number('0250007')->is_valid_number, '岩手県花巻市上似内');
ok($zip->set_number('0250008')->is_valid_number, '岩手県花巻市空港南');
ok($zip->set_number('0250011')->is_valid_number, '岩手県花巻市矢沢');
ok($zip->set_number('0250012')->is_valid_number, '岩手県花巻市胡四王');
ok($zip->set_number('0250013')->is_valid_number, '岩手県花巻市幸田');
ok($zip->set_number('0250014')->is_valid_number, '岩手県花巻市高松');
ok($zip->set_number('0250015')->is_valid_number, '岩手県花巻市東十二丁目');
ok($zip->set_number('0250016')->is_valid_number, '岩手県花巻市高木');
ok($zip->set_number('0250021')->is_valid_number, '岩手県花巻市南城');
ok($zip->set_number('0250022')->is_valid_number, '岩手県花巻市十二丁目');
ok($zip->set_number('0250023')->is_valid_number, '岩手県花巻市成田');
ok($zip->set_number('0250024')->is_valid_number, '岩手県花巻市山の神');
ok($zip->set_number('0250025')->is_valid_number, '岩手県花巻市下根子');
ok($zip->set_number('0250026')->is_valid_number, '岩手県花巻市大谷地');
ok($zip->set_number('0250031')->is_valid_number, '岩手県花巻市不動');
ok($zip->set_number('0250032')->is_valid_number, '岩手県花巻市上諏訪');
ok($zip->set_number('0250033')->is_valid_number, '岩手県花巻市諏訪');
ok($zip->set_number('0250034')->is_valid_number, '岩手県花巻市南諏訪町');
ok($zip->set_number('0250035')->is_valid_number, '岩手県花巻市実相寺');
ok($zip->set_number('0250036')->is_valid_number, '岩手県花巻市中根子');
ok($zip->set_number('0250037')->is_valid_number, '岩手県花巻市太田');
ok($zip->set_number('0250038')->is_valid_number, '岩手県花巻市不動町');
ok($zip->set_number('0250039')->is_valid_number, '岩手県花巻市諏訪町');
ok($zip->set_number('0250041')->is_valid_number, '岩手県花巻市膝立');
ok($zip->set_number('0250042')->is_valid_number, '岩手県花巻市円万寺');
ok($zip->set_number('0250043')->is_valid_number, '岩手県花巻市上根子');
ok($zip->set_number('0250044')->is_valid_number, '岩手県花巻市湯口(石川原、田屋、二ツ堰、的場)');
ok($zip->set_number('0250045')->is_valid_number, '岩手県花巻市西晴山');
ok($zip->set_number('0250046')->is_valid_number, '岩手県花巻市鍋倉');
ok($zip->set_number('0250051')->is_valid_number, '岩手県花巻市南新田');
ok($zip->set_number('0250052')->is_valid_number, '岩手県花巻市野田');
ok($zip->set_number('0250053')->is_valid_number, '岩手県花巻市中北万丁目');
ok($zip->set_number('0250054')->is_valid_number, '岩手県花巻市下北万丁目');
ok($zip->set_number('0250055')->is_valid_number, '岩手県花巻市南万丁目');
ok($zip->set_number('0250056')->is_valid_number, '岩手県花巻市上北万丁目');
ok($zip->set_number('0250057')->is_valid_number, '岩手県花巻市新田');
ok($zip->set_number('0250058')->is_valid_number, '岩手県花巻市一本杉');
ok($zip->set_number('0250061')->is_valid_number, '岩手県花巻市本館');
ok($zip->set_number('0250062')->is_valid_number, '岩手県花巻市上小舟渡');
ok($zip->set_number('0250063')->is_valid_number, '岩手県花巻市下小舟渡');
ok($zip->set_number('0250064')->is_valid_number, '岩手県花巻市桜台');
ok($zip->set_number('0250065')->is_valid_number, '岩手県花巻市星が丘');
ok($zip->set_number('0250066')->is_valid_number, '岩手県花巻市松園町');
ok($zip->set_number('0250067')->is_valid_number, '岩手県花巻市浅沢');
ok($zip->set_number('0250068')->is_valid_number, '岩手県花巻市下幅');
ok($zip->set_number('0250071')->is_valid_number, '岩手県花巻市愛宕町');
ok($zip->set_number('0250072')->is_valid_number, '岩手県花巻市四日町');
ok($zip->set_number('0250073')->is_valid_number, '岩手県花巻市一日市');
ok($zip->set_number('0250074')->is_valid_number, '岩手県花巻市坂本町');
ok($zip->set_number('0250075')->is_valid_number, '岩手県花巻市花城町');
ok($zip->set_number('0250076')->is_valid_number, '岩手県花巻市城内');
ok($zip->set_number('0250077')->is_valid_number, '岩手県花巻市仲町');
ok($zip->set_number('0250078')->is_valid_number, '岩手県花巻市吹張町');
ok($zip->set_number('0250079')->is_valid_number, '岩手県花巻市末広町');
ok($zip->set_number('0250081')->is_valid_number, '岩手県花巻市里川口町');
ok($zip->set_number('0250082')->is_valid_number, '岩手県花巻市御田屋町');
ok($zip->set_number('0250083')->is_valid_number, '岩手県花巻市高田');
ok($zip->set_number('0250084')->is_valid_number, '岩手県花巻市桜町');
ok($zip->set_number('0250085')->is_valid_number, '岩手県花巻市双葉町');
ok($zip->set_number('0250086')->is_valid_number, '岩手県花巻市鍛治町');
ok($zip->set_number('0250087')->is_valid_number, '岩手県花巻市上町');
ok($zip->set_number('0250088')->is_valid_number, '岩手県花巻市東町');
ok($zip->set_number('0250089')->is_valid_number, '岩手県花巻市豊沢町');
ok($zip->set_number('0250091')->is_valid_number, '岩手県花巻市西大通り');
ok($zip->set_number('0250092')->is_valid_number, '岩手県花巻市大通り');
ok($zip->set_number('0250093')->is_valid_number, '岩手県花巻市南川原町');
ok($zip->set_number('0250094')->is_valid_number, '岩手県花巻市桜木町');
ok($zip->set_number('0250095')->is_valid_number, '岩手県花巻市石神町');
ok($zip->set_number('0250096')->is_valid_number, '岩手県花巻市藤沢町');
ok($zip->set_number('0250097')->is_valid_number, '岩手県花巻市若葉町');
ok($zip->set_number('0250098')->is_valid_number, '岩手県花巻市材木町');
ok($zip->set_number('0250131')->is_valid_number, '岩手県花巻市轟木');
ok($zip->set_number('0250132')->is_valid_number, '岩手県花巻市北笹間');
ok($zip->set_number('0250133')->is_valid_number, '岩手県花巻市中笹間');
ok($zip->set_number('0250134')->is_valid_number, '岩手県花巻市南笹間');
ok($zip->set_number('0250135')->is_valid_number, '岩手県花巻市栃内');
ok($zip->set_number('0250136')->is_valid_number, '岩手県花巻市横志田');
ok($zip->set_number('0250137')->is_valid_number, '岩手県花巻市尻平川');
ok($zip->set_number('0250244')->is_valid_number, '岩手県花巻市湯口(その他)');
ok($zip->set_number('0250251')->is_valid_number, '岩手県花巻市豊沢');
ok($zip->set_number('0250252')->is_valid_number, '岩手県花巻市鉛');
ok($zip->set_number('0250253')->is_valid_number, '岩手県花巻市下シ沢');
ok($zip->set_number('0250301')->is_valid_number, '岩手県花巻市北湯口');
ok($zip->set_number('0250302')->is_valid_number, '岩手県花巻市糠塚');
ok($zip->set_number('0250303')->is_valid_number, '岩手県花巻市大畑');
ok($zip->set_number('0250304')->is_valid_number, '岩手県花巻市湯本');
ok($zip->set_number('0250305')->is_valid_number, '岩手県花巻市台');
ok($zip->set_number('0250311')->is_valid_number, '岩手県花巻市卸町');
ok($zip->set_number('0250312')->is_valid_number, '岩手県花巻市二枚橋');
ok($zip->set_number('0250313')->is_valid_number, '岩手県花巻市二枚橋町北');
ok($zip->set_number('0250314')->is_valid_number, '岩手県花巻市二枚橋町大通り');
ok($zip->set_number('0250315')->is_valid_number, '岩手県花巻市二枚橋町南');
ok($zip->set_number('0250321')->is_valid_number, '岩手県花巻市金矢');
ok($zip->set_number('0250322')->is_valid_number, '岩手県花巻市狼沢');
ok($zip->set_number('0250323')->is_valid_number, '岩手県花巻市椚ノ目');
ok($zip->set_number('0250324')->is_valid_number, '岩手県花巻市小瀬川');
ok($zip->set_number('0260000')->is_valid_number, '岩手県釜石市以下に掲載がない場合');
ok($zip->set_number('0260001')->is_valid_number, '岩手県釜石市平田');
ok($zip->set_number('0260002')->is_valid_number, '岩手県釜石市大平町');
ok($zip->set_number('0260003')->is_valid_number, '岩手県釜石市嬉石町');
ok($zip->set_number('0260004')->is_valid_number, '岩手県釜石市松原町');
ok($zip->set_number('0260011')->is_valid_number, '岩手県釜石市港町');
ok($zip->set_number('0260012')->is_valid_number, '岩手県釜石市魚河岸');
ok($zip->set_number('0260013')->is_valid_number, '岩手県釜石市浜町');
ok($zip->set_number('0260014')->is_valid_number, '岩手県釜石市東前町');
ok($zip->set_number('0260015')->is_valid_number, '岩手県釜石市新浜町');
ok($zip->set_number('0260021')->is_valid_number, '岩手県釜石市只越町');
ok($zip->set_number('0260022')->is_valid_number, '岩手県釜石市大只越町');
ok($zip->set_number('0260023')->is_valid_number, '岩手県釜石市天神町');
ok($zip->set_number('0260024')->is_valid_number, '岩手県釜石市大町');
ok($zip->set_number('0260025')->is_valid_number, '岩手県釜石市大渡町');
ok($zip->set_number('0260026')->is_valid_number, '岩手県釜石市釜石');
ok($zip->set_number('0260031')->is_valid_number, '岩手県釜石市鈴子町');
ok($zip->set_number('0260032')->is_valid_number, '岩手県釜石市千鳥町');
ok($zip->set_number('0260033')->is_valid_number, '岩手県釜石市駒木町');
ok($zip->set_number('0260034')->is_valid_number, '岩手県釜石市中妻町');
ok($zip->set_number('0260035')->is_valid_number, '岩手県釜石市八雲町');
ok($zip->set_number('0260041')->is_valid_number, '岩手県釜石市上中島町');
ok($zip->set_number('0260042')->is_valid_number, '岩手県釜石市源太沢町');
ok($zip->set_number('0260043')->is_valid_number, '岩手県釜石市新町');
ok($zip->set_number('0260044')->is_valid_number, '岩手県釜石市住吉町');
ok($zip->set_number('0260045')->is_valid_number, '岩手県釜石市小川町');
ok($zip->set_number('0260046')->is_valid_number, '岩手県釜石市桜木町');
ok($zip->set_number('0260051')->is_valid_number, '岩手県釜石市礼ケ口町');
ok($zip->set_number('0260052')->is_valid_number, '岩手県釜石市小佐野町');
ok($zip->set_number('0260053')->is_valid_number, '岩手県釜石市定内町');
ok($zip->set_number('0260054')->is_valid_number, '岩手県釜石市野田町');
ok($zip->set_number('0260055')->is_valid_number, '岩手県釜石市甲子町');
ok($zip->set_number('0260061')->is_valid_number, '岩手県釜石市唐丹町(鍋倉)');
ok($zip->set_number('0260121')->is_valid_number, '岩手県釜石市唐丹町(その他)');
ok($zip->set_number('0260301')->is_valid_number, '岩手県釜石市鵜住居町');
ok($zip->set_number('0260302')->is_valid_number, '岩手県釜石市片岸町');
ok($zip->set_number('0260303')->is_valid_number, '岩手県釜石市箱崎町');
ok($zip->set_number('0260304')->is_valid_number, '岩手県釜石市両石町');
ok($zip->set_number('0260411')->is_valid_number, '岩手県釜石市橋野町');
ok($zip->set_number('0260412')->is_valid_number, '岩手県釜石市栗林町');
ok($zip->set_number('0270000')->is_valid_number, '岩手県宮古市以下に掲載がない場合');
ok($zip->set_number('0270001')->is_valid_number, '岩手県宮古市日立浜町');
ok($zip->set_number('0270002')->is_valid_number, '岩手県宮古市山根町');
ok($zip->set_number('0270003')->is_valid_number, '岩手県宮古市港町');
ok($zip->set_number('0270004')->is_valid_number, '岩手県宮古市臨港通');
ok($zip->set_number('0270005')->is_valid_number, '岩手県宮古市光岸地');
ok($zip->set_number('0270006')->is_valid_number, '岩手県宮古市鍬ケ崎');
ok($zip->set_number('0270007')->is_valid_number, '岩手県宮古市日影町');
ok($zip->set_number('0270008')->is_valid_number, '岩手県宮古市熊野町');
ok($zip->set_number('0270009')->is_valid_number, '岩手県宮古市蛸の浜町');
ok($zip->set_number('0270021')->is_valid_number, '岩手県宮古市藤原');
ok($zip->set_number('0270021')->is_valid_number, '岩手県宮古市藤原上町');
ok($zip->set_number('0270022')->is_valid_number, '岩手県宮古市磯鶏石崎');
ok($zip->set_number('0270023')->is_valid_number, '岩手県宮古市磯鶏沖');
ok($zip->set_number('0270024')->is_valid_number, '岩手県宮古市磯鶏');
ok($zip->set_number('0270025')->is_valid_number, '岩手県宮古市実田');
ok($zip->set_number('0270026')->is_valid_number, '岩手県宮古市上村');
ok($zip->set_number('0270027')->is_valid_number, '岩手県宮古市磯鶏西');
ok($zip->set_number('0270028')->is_valid_number, '岩手県宮古市神林');
ok($zip->set_number('0270029')->is_valid_number, '岩手県宮古市藤の川');
ok($zip->set_number('0270031')->is_valid_number, '岩手県宮古市八木沢');
ok($zip->set_number('0270032')->is_valid_number, '岩手県宮古市高浜');
ok($zip->set_number('0270033')->is_valid_number, '岩手県宮古市金浜');
ok($zip->set_number('0270034')->is_valid_number, '岩手県宮古市長沢');
ok($zip->set_number('0270035')->is_valid_number, '岩手県宮古市花輪');
ok($zip->set_number('0270036')->is_valid_number, '岩手県宮古市田鎖');
ok($zip->set_number('0270037')->is_valid_number, '岩手県宮古市松山');
ok($zip->set_number('0270038')->is_valid_number, '岩手県宮古市小山田');
ok($zip->set_number('0270039')->is_valid_number, '岩手県宮古市河南');
ok($zip->set_number('0270041')->is_valid_number, '岩手県宮古市西ケ丘');
ok($zip->set_number('0270042')->is_valid_number, '岩手県宮古市神田沢町');
ok($zip->set_number('0270043')->is_valid_number, '岩手県宮古市千徳町');
ok($zip->set_number('0270044')->is_valid_number, '岩手県宮古市上鼻');
ok($zip->set_number('0270045')->is_valid_number, '岩手県宮古市老木');
ok($zip->set_number('0270046')->is_valid_number, '岩手県宮古市花原市');
ok($zip->set_number('0270047')->is_valid_number, '岩手県宮古市根市');
ok($zip->set_number('0270048')->is_valid_number, '岩手県宮古市板屋');
ok($zip->set_number('0270051')->is_valid_number, '岩手県宮古市南町');
ok($zip->set_number('0270052')->is_valid_number, '岩手県宮古市宮町');
ok($zip->set_number('0270053')->is_valid_number, '岩手県宮古市長町');
ok($zip->set_number('0270054')->is_valid_number, '岩手県宮古市太田');
ok($zip->set_number('0270055')->is_valid_number, '岩手県宮古市長根');
ok($zip->set_number('0270056')->is_valid_number, '岩手県宮古市近内');
ok($zip->set_number('0270058')->is_valid_number, '岩手県宮古市千徳');
ok($zip->set_number('0270061')->is_valid_number, '岩手県宮古市西町');
ok($zip->set_number('0270062')->is_valid_number, '岩手県宮古市泉町');
ok($zip->set_number('0270063')->is_valid_number, '岩手県宮古市山口');
ok($zip->set_number('0270064')->is_valid_number, '岩手県宮古市宮園');
ok($zip->set_number('0270065')->is_valid_number, '岩手県宮古市黒森町');
ok($zip->set_number('0270066')->is_valid_number, '岩手県宮古市田の神');
ok($zip->set_number('0270067')->is_valid_number, '岩手県宮古市田代');
ok($zip->set_number('0270071')->is_valid_number, '岩手県宮古市小沢');
ok($zip->set_number('0270072')->is_valid_number, '岩手県宮古市五月町');
ok($zip->set_number('0270073')->is_valid_number, '岩手県宮古市緑ケ丘');
ok($zip->set_number('0270074')->is_valid_number, '岩手県宮古市保久田');
ok($zip->set_number('0270075')->is_valid_number, '岩手県宮古市和見町');
ok($zip->set_number('0270076')->is_valid_number, '岩手県宮古市栄町');
ok($zip->set_number('0270077')->is_valid_number, '岩手県宮古市舘合町');
ok($zip->set_number('0270078')->is_valid_number, '岩手県宮古市鴨崎町');
ok($zip->set_number('0270081')->is_valid_number, '岩手県宮古市新川町');
ok($zip->set_number('0270082')->is_valid_number, '岩手県宮古市向町');
ok($zip->set_number('0270083')->is_valid_number, '岩手県宮古市大通');
ok($zip->set_number('0270084')->is_valid_number, '岩手県宮古市末広町');
ok($zip->set_number('0270085')->is_valid_number, '岩手県宮古市黒田町');
ok($zip->set_number('0270086')->is_valid_number, '岩手県宮古市新町');
ok($zip->set_number('0270087')->is_valid_number, '岩手県宮古市横町');
ok($zip->set_number('0270088')->is_valid_number, '岩手県宮古市沢田');
ok($zip->set_number('0270089')->is_valid_number, '岩手県宮古市本町');
ok($zip->set_number('0270091')->is_valid_number, '岩手県宮古市築地');
ok($zip->set_number('0270092')->is_valid_number, '岩手県宮古市愛宕');
ok($zip->set_number('0270093')->is_valid_number, '岩手県宮古市中里団地');
ok($zip->set_number('0270094')->is_valid_number, '岩手県宮古市日の出町');
ok($zip->set_number('0270095')->is_valid_number, '岩手県宮古市佐原');
ok($zip->set_number('0270096')->is_valid_number, '岩手県宮古市崎鍬ケ崎');
ok($zip->set_number('0270097')->is_valid_number, '岩手県宮古市崎山');
ok($zip->set_number('0270111')->is_valid_number, '岩手県宮古市重茂');
ok($zip->set_number('0270112')->is_valid_number, '岩手県宮古市音部');
ok($zip->set_number('0270201')->is_valid_number, '岩手県宮古市白浜');
ok($zip->set_number('0270202')->is_valid_number, '岩手県宮古市赤前');
ok($zip->set_number('0270203')->is_valid_number, '岩手県宮古市津軽石');
ok($zip->set_number('0270301')->is_valid_number, '岩手県宮古市田老館が森');
ok($zip->set_number('0270302')->is_valid_number, '岩手県宮古市田老田中');
ok($zip->set_number('0270303')->is_valid_number, '岩手県宮古市田老田の沢');
ok($zip->set_number('0270304')->is_valid_number, '岩手県宮古市田老ケラス');
ok($zip->set_number('0270305')->is_valid_number, '岩手県宮古市田老荒谷');
ok($zip->set_number('0270306')->is_valid_number, '岩手県宮古市田老川向');
ok($zip->set_number('0270311')->is_valid_number, '岩手県宮古市田老和野');
ok($zip->set_number('0270312')->is_valid_number, '岩手県宮古市田老越田');
ok($zip->set_number('0270313')->is_valid_number, '岩手県宮古市田老駿達');
ok($zip->set_number('0270321')->is_valid_number, '岩手県宮古市田老乙部');
ok($zip->set_number('0270322')->is_valid_number, '岩手県宮古市田老青砂里');
ok($zip->set_number('0270323')->is_valid_number, '岩手県宮古市田老野原');
ok($zip->set_number('0270324')->is_valid_number, '岩手県宮古市田老向山');
ok($zip->set_number('0270331')->is_valid_number, '岩手県宮古市田老西向山');
ok($zip->set_number('0270332')->is_valid_number, '岩手県宮古市田老樫内');
ok($zip->set_number('0270333')->is_valid_number, '岩手県宮古市田老古田');
ok($zip->set_number('0270341')->is_valid_number, '岩手県宮古市田老養呂地');
ok($zip->set_number('0270342')->is_valid_number, '岩手県宮古市田老小田代');
ok($zip->set_number('0270343')->is_valid_number, '岩手県宮古市田老上小田代');
ok($zip->set_number('0270344')->is_valid_number, '岩手県宮古市田老辰の口');
ok($zip->set_number('0270345')->is_valid_number, '岩手県宮古市田老篠倉');
ok($zip->set_number('0270346')->is_valid_number, '岩手県宮古市田老七滝');
ok($zip->set_number('0270347')->is_valid_number, '岩手県宮古市田老笹見平');
ok($zip->set_number('0270351')->is_valid_number, '岩手県宮古市田老小林');
ok($zip->set_number('0270352')->is_valid_number, '岩手県宮古市田老八幡水神');
ok($zip->set_number('0270353')->is_valid_number, '岩手県宮古市田老和蒔');
ok($zip->set_number('0270354')->is_valid_number, '岩手県宮古市田老森崎');
ok($zip->set_number('0270355')->is_valid_number, '岩手県宮古市田老末前');
ok($zip->set_number('0270356')->is_valid_number, '岩手県宮古市田老和山');
ok($zip->set_number('0270357')->is_valid_number, '岩手県宮古市田老向桑畑');
ok($zip->set_number('0270358')->is_valid_number, '岩手県宮古市田老立腰');
ok($zip->set_number('0270359')->is_valid_number, '岩手県宮古市田老青倉');
ok($zip->set_number('0270361')->is_valid_number, '岩手県宮古市田老小堀内');
ok($zip->set_number('0270362')->is_valid_number, '岩手県宮古市田老小堀内南');
ok($zip->set_number('0270363')->is_valid_number, '岩手県宮古市田老長畑');
ok($zip->set_number('0270364')->is_valid_number, '岩手県宮古市田老新田');
ok($zip->set_number('0270365')->is_valid_number, '岩手県宮古市田老滝の沢');
ok($zip->set_number('0270366')->is_valid_number, '岩手県宮古市田老新田平');
ok($zip->set_number('0270367')->is_valid_number, '岩手県宮古市田老鈴子沢');
ok($zip->set_number('0270371')->is_valid_number, '岩手県宮古市田老水沢');
ok($zip->set_number('0270372')->is_valid_number, '岩手県宮古市田老水沢南');
ok($zip->set_number('0270373')->is_valid_number, '岩手県宮古市田老向新田');
ok($zip->set_number('0270374')->is_valid_number, '岩手県宮古市田老青野滝北');
ok($zip->set_number('0270375')->is_valid_number, '岩手県宮古市田老青野滝');
ok($zip->set_number('0270376')->is_valid_number, '岩手県宮古市田老青野滝南');
ok($zip->set_number('0270377')->is_valid_number, '岩手県宮古市田老重津部北');
ok($zip->set_number('0270378')->is_valid_number, '岩手県宮古市田老重津部');
ok($zip->set_number('0270379')->is_valid_number, '岩手県宮古市田老乙部野');
ok($zip->set_number('0270381')->is_valid_number, '岩手県宮古市田老星山');
ok($zip->set_number('0270382')->is_valid_number, '岩手県宮古市田老片巻');
ok($zip->set_number('0270383')->is_valid_number, '岩手県宮古市田老上摂待');
ok($zip->set_number('0270384')->is_valid_number, '岩手県宮古市田老摂待');
ok($zip->set_number('0270385')->is_valid_number, '岩手県宮古市田老下摂待');
ok($zip->set_number('0270386')->is_valid_number, '岩手県宮古市田老胡桃畑');
ok($zip->set_number('0270387')->is_valid_number, '岩手県宮古市田老畑');
ok($zip->set_number('0270388')->is_valid_number, '岩手県宮古市田老上沖');
ok($zip->set_number('0270421')->is_valid_number, '岩手県下閉伊郡岩泉町小本');
ok($zip->set_number('0270422')->is_valid_number, '岩手県下閉伊郡岩泉町中島');
ok($zip->set_number('0270423')->is_valid_number, '岩手県下閉伊郡岩泉町中里');
ok($zip->set_number('0270424')->is_valid_number, '岩手県下閉伊郡岩泉町袰野');
ok($zip->set_number('0270500')->is_valid_number, '岩手県下閉伊郡岩泉町以下に掲載がない場合');
ok($zip->set_number('0270501')->is_valid_number, '岩手県下閉伊郡岩泉町岩泉');
ok($zip->set_number('0270502')->is_valid_number, '岩手県下閉伊郡岩泉町乙茂');
ok($zip->set_number('0270503')->is_valid_number, '岩手県下閉伊郡岩泉町猿沢');
ok($zip->set_number('0270504')->is_valid_number, '岩手県下閉伊郡岩泉町下有芸');
ok($zip->set_number('0270505')->is_valid_number, '岩手県下閉伊郡岩泉町上有芸');
ok($zip->set_number('0270506')->is_valid_number, '岩手県下閉伊郡岩泉町鼠入');
ok($zip->set_number('0270507')->is_valid_number, '岩手県下閉伊郡岩泉町二升石');
ok($zip->set_number('0270508')->is_valid_number, '岩手県下閉伊郡岩泉町尼額');
ok($zip->set_number('0270611')->is_valid_number, '岩手県下閉伊郡岩泉町安家');
ok($zip->set_number('0280000')->is_valid_number, '岩手県久慈市以下に掲載がない場合');
ok($zip->set_number('0280001')->is_valid_number, '岩手県久慈市夏井町');
ok($zip->set_number('0280011')->is_valid_number, '岩手県久慈市湊町');
ok($zip->set_number('0280012')->is_valid_number, '岩手県久慈市新井田');
ok($zip->set_number('0280013')->is_valid_number, '岩手県久慈市京の森');
ok($zip->set_number('0280014')->is_valid_number, '岩手県久慈市旭町');
ok($zip->set_number('0280015')->is_valid_number, '岩手県久慈市源道');
ok($zip->set_number('0280021')->is_valid_number, '岩手県久慈市門前');
ok($zip->set_number('0280022')->is_valid_number, '岩手県久慈市田屋町');
ok($zip->set_number('0280023')->is_valid_number, '岩手県久慈市新中の橋');
ok($zip->set_number('0280024')->is_valid_number, '岩手県久慈市栄町');
ok($zip->set_number('0280031')->is_valid_number, '岩手県久慈市天神堂');
ok($zip->set_number('0280032')->is_valid_number, '岩手県久慈市寺里');
ok($zip->set_number('0280033')->is_valid_number, '岩手県久慈市畑田');
ok($zip->set_number('0280034')->is_valid_number, '岩手県久慈市枝成沢');
ok($zip->set_number('0280035')->is_valid_number, '岩手県久慈市沢里');
ok($zip->set_number('0280041')->is_valid_number, '岩手県久慈市長内町');
ok($zip->set_number('0280051')->is_valid_number, '岩手県久慈市川崎町');
ok($zip->set_number('0280052')->is_valid_number, '岩手県久慈市本町');
ok($zip->set_number('0280053')->is_valid_number, '岩手県久慈市田高');
ok($zip->set_number('0280054')->is_valid_number, '岩手県久慈市柏崎');
ok($zip->set_number('0280055')->is_valid_number, '岩手県久慈市巽町');
ok($zip->set_number('0280056')->is_valid_number, '岩手県久慈市中町');
ok($zip->set_number('0280061')->is_valid_number, '岩手県久慈市中央');
ok($zip->set_number('0280062')->is_valid_number, '岩手県久慈市二十八日町');
ok($zip->set_number('0280063')->is_valid_number, '岩手県久慈市荒町');
ok($zip->set_number('0280064')->is_valid_number, '岩手県久慈市八日町');
ok($zip->set_number('0280065')->is_valid_number, '岩手県久慈市十八日町');
ok($zip->set_number('0280066')->is_valid_number, '岩手県久慈市中の橋');
ok($zip->set_number('0280071')->is_valid_number, '岩手県久慈市小久慈町');
ok($zip->set_number('0280081')->is_valid_number, '岩手県久慈市西の沢');
ok($zip->set_number('0280082')->is_valid_number, '岩手県久慈市川貫');
ok($zip->set_number('0280083')->is_valid_number, '岩手県久慈市大沢');
ok($zip->set_number('0280091')->is_valid_number, '岩手県久慈市大川目町');
ok($zip->set_number('0280101')->is_valid_number, '岩手県花巻市東和町北前田');
ok($zip->set_number('0280102')->is_valid_number, '岩手県花巻市東和町北川目');
ok($zip->set_number('0280103')->is_valid_number, '岩手県花巻市東和町石鳩岡');
ok($zip->set_number('0280104')->is_valid_number, '岩手県花巻市東和町南川目');
ok($zip->set_number('0280105')->is_valid_number, '岩手県花巻市東和町前田');
ok($zip->set_number('0280106')->is_valid_number, '岩手県花巻市東和町外谷地');
ok($zip->set_number('0280107')->is_valid_number, '岩手県花巻市東和町北小山田');
ok($zip->set_number('0280111')->is_valid_number, '岩手県花巻市東和町百ノ沢');
ok($zip->set_number('0280112')->is_valid_number, '岩手県花巻市東和町新地');
ok($zip->set_number('0280113')->is_valid_number, '岩手県花巻市東和町東晴山');
ok($zip->set_number('0280114')->is_valid_number, '岩手県花巻市東和町土沢');
ok($zip->set_number('0280115')->is_valid_number, '岩手県花巻市東和町安俵');
ok($zip->set_number('0280116')->is_valid_number, '岩手県花巻市東和町北成島');
ok($zip->set_number('0280121')->is_valid_number, '岩手県花巻市東和町小友');
ok($zip->set_number('0280122')->is_valid_number, '岩手県花巻市東和町谷内');
ok($zip->set_number('0280123')->is_valid_number, '岩手県花巻市東和町田瀬');
ok($zip->set_number('0280131')->is_valid_number, '岩手県花巻市東和町町井');
ok($zip->set_number('0280132')->is_valid_number, '岩手県花巻市東和町舘迫');
ok($zip->set_number('0280133')->is_valid_number, '岩手県花巻市東和町鷹巣堂');
ok($zip->set_number('0280134')->is_valid_number, '岩手県花巻市東和町砂子');
ok($zip->set_number('0280135')->is_valid_number, '岩手県花巻市東和町倉沢');
ok($zip->set_number('0280136')->is_valid_number, '岩手県花巻市東和町小原');
ok($zip->set_number('0280141')->is_valid_number, '岩手県花巻市東和町下浮田');
ok($zip->set_number('0280142')->is_valid_number, '岩手県花巻市東和町駒籠');
ok($zip->set_number('0280143')->is_valid_number, '岩手県花巻市東和町上浮田');
ok($zip->set_number('0280144')->is_valid_number, '岩手県花巻市東和町宮田');
ok($zip->set_number('0280151')->is_valid_number, '岩手県花巻市東和町落合');
ok($zip->set_number('0280152')->is_valid_number, '岩手県花巻市東和町毒沢');
ok($zip->set_number('0280153')->is_valid_number, '岩手県花巻市東和町中内');
ok($zip->set_number('0280154')->is_valid_number, '岩手県花巻市東和町石持');
ok($zip->set_number('0280155')->is_valid_number, '岩手県花巻市東和町南成島');
ok($zip->set_number('0280156')->is_valid_number, '岩手県花巻市東和町小通');
ok($zip->set_number('0280301')->is_valid_number, '岩手県遠野市宮守町上宮守');
ok($zip->set_number('0280302')->is_valid_number, '岩手県遠野市宮守町上鱒沢');
ok($zip->set_number('0280303')->is_valid_number, '岩手県遠野市宮守町下鱒沢');
ok($zip->set_number('0280304')->is_valid_number, '岩手県遠野市宮守町下宮守');
ok($zip->set_number('0280305')->is_valid_number, '岩手県遠野市宮守町達曽部');
ok($zip->set_number('0280481')->is_valid_number, '岩手県遠野市小友町');
ok($zip->set_number('0280500')->is_valid_number, '岩手県遠野市以下に掲載がない場合');
ok($zip->set_number('0280501')->is_valid_number, '岩手県遠野市青笹町糠前');
ok($zip->set_number('0280502')->is_valid_number, '岩手県遠野市青笹町中沢');
ok($zip->set_number('0280503')->is_valid_number, '岩手県遠野市青笹町青笹');
ok($zip->set_number('0280511')->is_valid_number, '岩手県遠野市鶯崎町');
ok($zip->set_number('0280512')->is_valid_number, '岩手県遠野市東上組町');
ok($zip->set_number('0280513')->is_valid_number, '岩手県遠野市東穀町');
ok($zip->set_number('0280514')->is_valid_number, '岩手県遠野市遠野町');
ok($zip->set_number('0280515')->is_valid_number, '岩手県遠野市東舘町');
ok($zip->set_number('0280516')->is_valid_number, '岩手県遠野市穀町');
ok($zip->set_number('0280517')->is_valid_number, '岩手県遠野市上組町');
ok($zip->set_number('0280521')->is_valid_number, '岩手県遠野市材木町');
ok($zip->set_number('0280522')->is_valid_number, '岩手県遠野市新穀町');
ok($zip->set_number('0280523')->is_valid_number, '岩手県遠野市中央通り');
ok($zip->set_number('0280524')->is_valid_number, '岩手県遠野市新町');
ok($zip->set_number('0280525')->is_valid_number, '岩手県遠野市六日町');
ok($zip->set_number('0280526')->is_valid_number, '岩手県遠野市下組町');
ok($zip->set_number('0280527')->is_valid_number, '岩手県遠野市大工町');
ok($zip->set_number('0280531')->is_valid_number, '岩手県遠野市綾織町新里');
ok($zip->set_number('0280532')->is_valid_number, '岩手県遠野市綾織町下綾織');
ok($zip->set_number('0280533')->is_valid_number, '岩手県遠野市綾織町上綾織');
ok($zip->set_number('0280534')->is_valid_number, '岩手県遠野市綾織町みさ崎');
ok($zip->set_number('0280541')->is_valid_number, '岩手県遠野市松崎町白岩');
ok($zip->set_number('0280542')->is_valid_number, '岩手県遠野市早瀬町');
ok($zip->set_number('0280543')->is_valid_number, '岩手県遠野市松崎町光興寺');
ok($zip->set_number('0280544')->is_valid_number, '岩手県遠野市松崎町松崎');
ok($zip->set_number('0280545')->is_valid_number, '岩手県遠野市松崎町駒木');
ok($zip->set_number('0280551')->is_valid_number, '岩手県遠野市土淵町栃内');
ok($zip->set_number('0280552')->is_valid_number, '岩手県遠野市土淵町山口');
ok($zip->set_number('0280553')->is_valid_number, '岩手県遠野市土淵町柏崎');
ok($zip->set_number('0280554')->is_valid_number, '岩手県遠野市土淵町飯豊');
ok($zip->set_number('0280555')->is_valid_number, '岩手県遠野市土淵町土淵');
ok($zip->set_number('0280661')->is_valid_number, '岩手県遠野市附馬牛町上附馬牛');
ok($zip->set_number('0280662')->is_valid_number, '岩手県遠野市附馬牛町安居台');
ok($zip->set_number('0280663')->is_valid_number, '岩手県遠野市附馬牛町下附馬牛');
ok($zip->set_number('0280664')->is_valid_number, '岩手県遠野市附馬牛町東禅寺');
ok($zip->set_number('0280771')->is_valid_number, '岩手県遠野市上郷町佐比内');
ok($zip->set_number('0280772')->is_valid_number, '岩手県遠野市上郷町細越');
ok($zip->set_number('0280773')->is_valid_number, '岩手県遠野市上郷町平野原');
ok($zip->set_number('0280774')->is_valid_number, '岩手県遠野市上郷町来内');
ok($zip->set_number('0280775')->is_valid_number, '岩手県遠野市上郷町平倉');
ok($zip->set_number('0280776')->is_valid_number, '岩手県遠野市上郷町板沢');
ok($zip->set_number('0281100')->is_valid_number, '岩手県上閉伊郡大槌町以下に掲載がない場合');
ok($zip->set_number('0281101')->is_valid_number, '岩手県上閉伊郡大槌町吉里吉里');
ok($zip->set_number('0281102')->is_valid_number, '岩手県上閉伊郡大槌町赤浜');
ok($zip->set_number('0281103')->is_valid_number, '岩手県上閉伊郡大槌町港町');
ok($zip->set_number('0281104')->is_valid_number, '岩手県上閉伊郡大槌町新港町');
ok($zip->set_number('0281105')->is_valid_number, '岩手県上閉伊郡大槌町安渡');
ok($zip->set_number('0281111')->is_valid_number, '岩手県上閉伊郡大槌町新町');
ok($zip->set_number('0281112')->is_valid_number, '岩手県上閉伊郡大槌町大町');
ok($zip->set_number('0281113')->is_valid_number, '岩手県上閉伊郡大槌町須賀町');
ok($zip->set_number('0281114')->is_valid_number, '岩手県上閉伊郡大槌町栄町');
ok($zip->set_number('0281115')->is_valid_number, '岩手県上閉伊郡大槌町上町');
ok($zip->set_number('0281116')->is_valid_number, '岩手県上閉伊郡大槌町本町');
ok($zip->set_number('0281117')->is_valid_number, '岩手県上閉伊郡大槌町末広町');
ok($zip->set_number('0281121')->is_valid_number, '岩手県上閉伊郡大槌町小鎚');
ok($zip->set_number('0281122')->is_valid_number, '岩手県上閉伊郡大槌町桜木町');
ok($zip->set_number('0281131')->is_valid_number, '岩手県上閉伊郡大槌町大槌');
ok($zip->set_number('0281132')->is_valid_number, '岩手県上閉伊郡大槌町大ケ口');
ok($zip->set_number('0281133')->is_valid_number, '岩手県上閉伊郡大槌町金沢');
ok($zip->set_number('0281300')->is_valid_number, '岩手県下閉伊郡山田町以下に掲載がない場合');
ok($zip->set_number('0281301')->is_valid_number, '岩手県下閉伊郡山田町石峠');
ok($zip->set_number('0281302')->is_valid_number, '岩手県下閉伊郡山田町豊間根');
ok($zip->set_number('0281303')->is_valid_number, '岩手県下閉伊郡山田町荒川');
ok($zip->set_number('0281311')->is_valid_number, '岩手県下閉伊郡山田町大沢');
ok($zip->set_number('0281321')->is_valid_number, '岩手県下閉伊郡山田町山田');
ok($zip->set_number('0281331')->is_valid_number, '岩手県下閉伊郡山田町北浜町');
ok($zip->set_number('0281332')->is_valid_number, '岩手県下閉伊郡山田町中央町');
ok($zip->set_number('0281333')->is_valid_number, '岩手県下閉伊郡山田町後楽町');
ok($zip->set_number('0281341')->is_valid_number, '岩手県下閉伊郡山田町八幡町');
ok($zip->set_number('0281342')->is_valid_number, '岩手県下閉伊郡山田町川向町');
ok($zip->set_number('0281343')->is_valid_number, '岩手県下閉伊郡山田町境田町');
ok($zip->set_number('0281351')->is_valid_number, '岩手県下閉伊郡山田町長崎');
ok($zip->set_number('0281352')->is_valid_number, '岩手県下閉伊郡山田町飯岡');
ok($zip->set_number('0281361')->is_valid_number, '岩手県下閉伊郡山田町織笠');
ok($zip->set_number('0281371')->is_valid_number, '岩手県下閉伊郡山田町船越');
ok($zip->set_number('0282101')->is_valid_number, '岩手県宮古市茂市');
ok($zip->set_number('0282102')->is_valid_number, '岩手県宮古市蟇目');
ok($zip->set_number('0282103')->is_valid_number, '岩手県宮古市腹帯');
ok($zip->set_number('0282104')->is_valid_number, '岩手県宮古市刈屋');
ok($zip->set_number('0282105')->is_valid_number, '岩手県宮古市和井内');
ok($zip->set_number('0282231')->is_valid_number, '岩手県下閉伊郡岩泉町浅内');
ok($zip->set_number('0282232')->is_valid_number, '岩手県下閉伊郡岩泉町大川');
ok($zip->set_number('0282233')->is_valid_number, '岩手県下閉伊郡岩泉町釜津田(その他)');
ok($zip->set_number('0282301')->is_valid_number, '岩手県宮古市古田');
ok($zip->set_number('0282302')->is_valid_number, '岩手県宮古市川井(その他)');
ok($zip->set_number('0282303')->is_valid_number, '岩手県宮古市片巣');
ok($zip->set_number('0282304')->is_valid_number, '岩手県宮古市箱石(その他)');
ok($zip->set_number('0282402')->is_valid_number, '岩手県宮古市川井(第9地割~第11地割)');
ok($zip->set_number('0282421')->is_valid_number, '岩手県宮古市江繋');
ok($zip->set_number('0282422')->is_valid_number, '岩手県宮古市小国');
ok($zip->set_number('0282504')->is_valid_number, '岩手県宮古市箱石(第2地割「70~136」~第4地割「3~11」)');
ok($zip->set_number('0282511')->is_valid_number, '岩手県宮古市夏屋');
ok($zip->set_number('0282512')->is_valid_number, '岩手県宮古市鈴久名');
ok($zip->set_number('0282513')->is_valid_number, '岩手県宮古市川内');
ok($zip->set_number('0282631')->is_valid_number, '岩手県宮古市区界');
ok($zip->set_number('0282632')->is_valid_number, '岩手県宮古市門馬');
ok($zip->set_number('0282633')->is_valid_number, '岩手県宮古市平津戸');
ok($zip->set_number('0282711')->is_valid_number, '岩手県盛岡市玉山区薮川');
ok($zip->set_number('0283101')->is_valid_number, '岩手県花巻市石鳥谷町好地');
ok($zip->set_number('0283102')->is_valid_number, '岩手県花巻市石鳥谷町上口');
ok($zip->set_number('0283111')->is_valid_number, '岩手県花巻市石鳥谷町新堀');
ok($zip->set_number('0283121')->is_valid_number, '岩手県花巻市石鳥谷町戸塚');
ok($zip->set_number('0283122')->is_valid_number, '岩手県花巻市石鳥谷町滝田');
ok($zip->set_number('0283131')->is_valid_number, '岩手県花巻市石鳥谷町猪鼻');
ok($zip->set_number('0283132')->is_valid_number, '岩手県花巻市石鳥谷町東中島');
ok($zip->set_number('0283133')->is_valid_number, '岩手県花巻市石鳥谷町関口');
ok($zip->set_number('0283141')->is_valid_number, '岩手県花巻市石鳥谷町五大堂');
ok($zip->set_number('0283142')->is_valid_number, '岩手県花巻市石鳥谷町八重畑');
ok($zip->set_number('0283151')->is_valid_number, '岩手県花巻市石鳥谷町江曽');
ok($zip->set_number('0283152')->is_valid_number, '岩手県花巻市石鳥谷町南寺林');
ok($zip->set_number('0283153')->is_valid_number, '岩手県花巻市石鳥谷町小森林');
ok($zip->set_number('0283161')->is_valid_number, '岩手県花巻市石鳥谷町黒沼');
ok($zip->set_number('0283162')->is_valid_number, '岩手県花巻市石鳥谷町西中島');
ok($zip->set_number('0283163')->is_valid_number, '岩手県花巻市石鳥谷町八幡');
ok($zip->set_number('0283171')->is_valid_number, '岩手県花巻市石鳥谷町中寺林');
ok($zip->set_number('0283172')->is_valid_number, '岩手県花巻市石鳥谷町北寺林');
ok($zip->set_number('0283181')->is_valid_number, '岩手県花巻市石鳥谷町大興寺');
ok($zip->set_number('0283182')->is_valid_number, '岩手県花巻市石鳥谷町松林寺');
ok($zip->set_number('0283183')->is_valid_number, '岩手県花巻市石鳥谷町長谷堂');
ok($zip->set_number('0283184')->is_valid_number, '岩手県花巻市石鳥谷町富沢');
ok($zip->set_number('0283185')->is_valid_number, '岩手県花巻市石鳥谷町大瀬川');
ok($zip->set_number('0283201')->is_valid_number, '岩手県花巻市大迫町内川目');
ok($zip->set_number('0283202')->is_valid_number, '岩手県花巻市大迫町外川目');
ok($zip->set_number('0283203')->is_valid_number, '岩手県花巻市大迫町大迫');
ok($zip->set_number('0283204')->is_valid_number, '岩手県花巻市大迫町亀ケ森');
ok($zip->set_number('0283300')->is_valid_number, '岩手県紫波郡紫波町以下に掲載がない場合');
ok($zip->set_number('0283301')->is_valid_number, '岩手県紫波郡紫波町中島');
ok($zip->set_number('0283302')->is_valid_number, '岩手県紫波郡紫波町陣ケ岡');
ok($zip->set_number('0283303')->is_valid_number, '岩手県紫波郡紫波町高水寺');
ok($zip->set_number('0283304')->is_valid_number, '岩手県紫波郡紫波町二日町');
ok($zip->set_number('0283305')->is_valid_number, '岩手県紫波郡紫波町日詰');
ok($zip->set_number('0283306')->is_valid_number, '岩手県紫波郡紫波町日詰西');
ok($zip->set_number('0283307')->is_valid_number, '岩手県紫波郡紫波町桜町');
ok($zip->set_number('0283308')->is_valid_number, '岩手県紫波郡紫波町平沢');
ok($zip->set_number('0283309')->is_valid_number, '岩手県紫波郡紫波町北日詰');
ok($zip->set_number('0283310')->is_valid_number, '岩手県紫波郡紫波町日詰駅前');
ok($zip->set_number('0283311')->is_valid_number, '岩手県紫波郡紫波町犬渕');
ok($zip->set_number('0283312')->is_valid_number, '岩手県紫波郡紫波町犬吠森');
ok($zip->set_number('0283313')->is_valid_number, '岩手県紫波郡紫波町星山');
ok($zip->set_number('0283314')->is_valid_number, '岩手県紫波郡紫波町大巻');
ok($zip->set_number('0283315')->is_valid_number, '岩手県紫波郡紫波町彦部');
ok($zip->set_number('0283316')->is_valid_number, '岩手県紫波郡紫波町佐比内');
ok($zip->set_number('0283317')->is_valid_number, '岩手県紫波郡紫波町南日詰');
ok($zip->set_number('0283318')->is_valid_number, '岩手県紫波郡紫波町紫波中央駅前');
ok($zip->set_number('0283321')->is_valid_number, '岩手県紫波郡紫波町江柄');
ok($zip->set_number('0283322')->is_valid_number, '岩手県紫波郡紫波町栃内');
ok($zip->set_number('0283323')->is_valid_number, '岩手県紫波郡紫波町北沢');
ok($zip->set_number('0283324')->is_valid_number, '岩手県紫波郡紫波町東長岡');
ok($zip->set_number('0283325')->is_valid_number, '岩手県紫波郡紫波町草刈');
ok($zip->set_number('0283326')->is_valid_number, '岩手県紫波郡紫波町西長岡');
ok($zip->set_number('0283441')->is_valid_number, '岩手県紫波郡紫波町上平沢');
ok($zip->set_number('0283442')->is_valid_number, '岩手県紫波郡紫波町升沢');
ok($zip->set_number('0283443')->is_valid_number, '岩手県紫波郡紫波町上松本');
ok($zip->set_number('0283444')->is_valid_number, '岩手県紫波郡紫波町小屋敷');
ok($zip->set_number('0283445')->is_valid_number, '岩手県紫波郡紫波町南伝法寺');
ok($zip->set_number('0283446')->is_valid_number, '岩手県紫波郡紫波町下松本');
ok($zip->set_number('0283447')->is_valid_number, '岩手県紫波郡紫波町宮手');
ok($zip->set_number('0283448')->is_valid_number, '岩手県紫波郡紫波町吉水');
ok($zip->set_number('0283451')->is_valid_number, '岩手県紫波郡紫波町稲藤');
ok($zip->set_number('0283452')->is_valid_number, '岩手県紫波郡紫波町片寄');
ok($zip->set_number('0283453')->is_valid_number, '岩手県紫波郡紫波町土舘');
ok($zip->set_number('0283531')->is_valid_number, '岩手県紫波郡紫波町山屋');
ok($zip->set_number('0283532')->is_valid_number, '岩手県紫波郡紫波町船久保');
ok($zip->set_number('0283533')->is_valid_number, '岩手県紫波郡紫波町赤沢');
ok($zip->set_number('0283534')->is_valid_number, '岩手県紫波郡紫波町紫野');
ok($zip->set_number('0283535')->is_valid_number, '岩手県紫波郡紫波町遠山');
ok($zip->set_number('0283536')->is_valid_number, '岩手県紫波郡紫波町北田');
ok($zip->set_number('0283600')->is_valid_number, '岩手県紫波郡矢巾町以下に掲載がない場合');
ok($zip->set_number('0283601')->is_valid_number, '岩手県紫波郡矢巾町高田');
ok($zip->set_number('0283602')->is_valid_number, '岩手県紫波郡矢巾町藤沢');
ok($zip->set_number('0283603')->is_valid_number, '岩手県紫波郡矢巾町西徳田');
ok($zip->set_number('0283604')->is_valid_number, '岩手県紫波郡矢巾町東徳田');
ok($zip->set_number('0283605')->is_valid_number, '岩手県紫波郡矢巾町間野々');
ok($zip->set_number('0283606')->is_valid_number, '岩手県紫波郡矢巾町土橋');
ok($zip->set_number('0283607')->is_valid_number, '岩手県紫波郡矢巾町高水寺');
ok($zip->set_number('0283608')->is_valid_number, '岩手県紫波郡矢巾町北郡山');
ok($zip->set_number('0283611')->is_valid_number, '岩手県紫波郡矢巾町赤林');
ok($zip->set_number('0283612')->is_valid_number, '岩手県紫波郡矢巾町下矢次');
ok($zip->set_number('0283613')->is_valid_number, '岩手県紫波郡矢巾町北矢幅');
ok($zip->set_number('0283614')->is_valid_number, '岩手県紫波郡矢巾町又兵エ新田');
ok($zip->set_number('0283615')->is_valid_number, '岩手県紫波郡矢巾町南矢幅');
ok($zip->set_number('0283616')->is_valid_number, '岩手県紫波郡矢巾町白沢');
ok($zip->set_number('0283617')->is_valid_number, '岩手県紫波郡矢巾町太田');
ok($zip->set_number('0283621')->is_valid_number, '岩手県紫波郡矢巾町広宮沢');
ok($zip->set_number('0283622')->is_valid_number, '岩手県紫波郡矢巾町上矢次');
ok($zip->set_number('0283623')->is_valid_number, '岩手県紫波郡矢巾町煙山');
ok($zip->set_number('0283624')->is_valid_number, '岩手県紫波郡矢巾町北伝法寺');
ok($zip->set_number('0283625')->is_valid_number, '岩手県紫波郡矢巾町室岡');
ok($zip->set_number('0283626')->is_valid_number, '岩手県紫波郡矢巾町岩清水');
ok($zip->set_number('0283627')->is_valid_number, '岩手県紫波郡矢巾町和味');
ok($zip->set_number('0284121')->is_valid_number, '岩手県盛岡市玉山区永井');
ok($zip->set_number('0284122')->is_valid_number, '岩手県盛岡市玉山区寺林');
ok($zip->set_number('0284123')->is_valid_number, '岩手県盛岡市玉山区巻堀');
ok($zip->set_number('0284124')->is_valid_number, '岩手県盛岡市玉山区馬場');
ok($zip->set_number('0284125')->is_valid_number, '岩手県盛岡市玉山区好摩');
ok($zip->set_number('0284131')->is_valid_number, '岩手県盛岡市玉山区芋田');
ok($zip->set_number('0284132')->is_valid_number, '岩手県盛岡市玉山区渋民');
ok($zip->set_number('0284133')->is_valid_number, '岩手県盛岡市玉山区門前寺');
ok($zip->set_number('0284134')->is_valid_number, '岩手県盛岡市玉山区下田');
ok($zip->set_number('0284135')->is_valid_number, '岩手県盛岡市玉山区川崎');
ok($zip->set_number('0284136')->is_valid_number, '岩手県盛岡市玉山区松内');
ok($zip->set_number('0284211')->is_valid_number, '岩手県岩手郡岩手町川口');
ok($zip->set_number('0284300')->is_valid_number, '岩手県岩手郡岩手町以下に掲載がない場合');
ok($zip->set_number('0284301')->is_valid_number, '岩手県岩手郡岩手町沼宮内');
ok($zip->set_number('0284302')->is_valid_number, '岩手県岩手郡岩手町大坊');
ok($zip->set_number('0284303')->is_valid_number, '岩手県岩手郡岩手町江刈内');
ok($zip->set_number('0284304')->is_valid_number, '岩手県岩手郡岩手町子抱');
ok($zip->set_number('0284305')->is_valid_number, '岩手県岩手郡岩手町久保');
ok($zip->set_number('0284306')->is_valid_number, '岩手県岩手郡岩手町御堂');
ok($zip->set_number('0284307')->is_valid_number, '岩手県岩手郡岩手町五日市');
ok($zip->set_number('0284421')->is_valid_number, '岩手県岩手郡岩手町一方井');
ok($zip->set_number('0284422')->is_valid_number, '岩手県岩手郡岩手町坊');
ok($zip->set_number('0284423')->is_valid_number, '岩手県岩手郡岩手町土川');
ok($zip->set_number('0284424')->is_valid_number, '岩手県岩手郡岩手町黒石');
ok($zip->set_number('0284425')->is_valid_number, '岩手県岩手郡岩手町葉木田');
ok($zip->set_number('0284426')->is_valid_number, '岩手県岩手郡岩手町黒内');
ok($zip->set_number('0285102')->is_valid_number, '岩手県岩手郡葛巻町葛巻(第40地割「57番地125、176を除く」~第45');
ok($zip->set_number('0285102')->is_valid_number, '岩手県岩手郡葛巻町地割)');
ok($zip->set_number('0285131')->is_valid_number, '岩手県二戸郡一戸町宇別');
ok($zip->set_number('0285132')->is_valid_number, '岩手県二戸郡一戸町小繋');
ok($zip->set_number('0285133')->is_valid_number, '岩手県二戸郡一戸町中山(その他)');
ok($zip->set_number('0285134')->is_valid_number, '岩手県二戸郡一戸町奥中山');
ok($zip->set_number('0285221')->is_valid_number, '岩手県二戸郡一戸町小鳥谷');
ok($zip->set_number('0285222')->is_valid_number, '岩手県二戸郡一戸町姉帯');
ok($zip->set_number('0285223')->is_valid_number, '岩手県二戸郡一戸町面岸');
ok($zip->set_number('0285224')->is_valid_number, '岩手県二戸郡一戸町平糠');
ok($zip->set_number('0285233')->is_valid_number, '岩手県二戸郡一戸町中山(新田17-2、37番地、東火行1番地)');
ok($zip->set_number('0285300')->is_valid_number, '岩手県二戸郡一戸町以下に掲載がない場合');
ok($zip->set_number('0285301')->is_valid_number, '岩手県二戸郡一戸町西法寺');
ok($zip->set_number('0285302')->is_valid_number, '岩手県二戸郡一戸町女鹿');
ok($zip->set_number('0285303')->is_valid_number, '岩手県二戸郡一戸町小友');
ok($zip->set_number('0285304')->is_valid_number, '岩手県二戸郡一戸町出ル町');
ok($zip->set_number('0285305')->is_valid_number, '岩手県二戸郡一戸町月舘');
ok($zip->set_number('0285306')->is_valid_number, '岩手県二戸郡一戸町中里');
ok($zip->set_number('0285311')->is_valid_number, '岩手県二戸郡一戸町高善寺');
ok($zip->set_number('0285312')->is_valid_number, '岩手県二戸郡一戸町一戸');
ok($zip->set_number('0285313')->is_valid_number, '岩手県二戸郡一戸町鳥越');
ok($zip->set_number('0285314')->is_valid_number, '岩手県二戸郡一戸町楢山');
ok($zip->set_number('0285315')->is_valid_number, '岩手県二戸郡一戸町根反');
ok($zip->set_number('0285316')->is_valid_number, '岩手県二戸郡一戸町岩舘');
ok($zip->set_number('0285400')->is_valid_number, '岩手県岩手郡葛巻町以下に掲載がない場合');
ok($zip->set_number('0285401')->is_valid_number, '岩手県岩手郡葛巻町田部');
ok($zip->set_number('0285402')->is_valid_number, '岩手県岩手郡葛巻町葛巻(その他)');
ok($zip->set_number('0285403')->is_valid_number, '岩手県岩手郡葛巻町江刈');
ok($zip->set_number('0285633')->is_valid_number, '岩手県下閉伊郡岩泉町釜津田(上栗宿、栗宿、権現)');
ok($zip->set_number('0285641')->is_valid_number, '岩手県下閉伊郡岩泉町門');
ok($zip->set_number('0285642')->is_valid_number, '岩手県下閉伊郡岩泉町穴沢');
ok($zip->set_number('0285643')->is_valid_number, '岩手県下閉伊郡岩泉町袰綿');
ok($zip->set_number('0285702')->is_valid_number, '岩手県二戸市下斗米(外芹沢、月折、土橋)');
ok($zip->set_number('0285711')->is_valid_number, '岩手県二戸市金田一');
ok($zip->set_number('0285712')->is_valid_number, '岩手県二戸市野々上');
ok($zip->set_number('0285713')->is_valid_number, '岩手県二戸市釜沢');
ok($zip->set_number('0286100')->is_valid_number, '岩手県二戸市以下に掲載がない場合');
ok($zip->set_number('0286101')->is_valid_number, '岩手県二戸市福岡');
ok($zip->set_number('0286102')->is_valid_number, '岩手県二戸市下斗米(その他)');
ok($zip->set_number('0286103')->is_valid_number, '岩手県二戸市石切所');
ok($zip->set_number('0286104')->is_valid_number, '岩手県二戸市米沢');
ok($zip->set_number('0286105')->is_valid_number, '岩手県二戸市堀野');
ok($zip->set_number('0286106')->is_valid_number, '岩手県二戸市仁左平');
ok($zip->set_number('0286107')->is_valid_number, '岩手県二戸市白鳥');
ok($zip->set_number('0286108')->is_valid_number, '岩手県二戸市上斗米');
ok($zip->set_number('0286221')->is_valid_number, '岩手県九戸郡軽米町晴山');
ok($zip->set_number('0286222')->is_valid_number, '岩手県九戸郡軽米町山内');
ok($zip->set_number('0286223')->is_valid_number, '岩手県九戸郡軽米町狄塚');
ok($zip->set_number('0286300')->is_valid_number, '岩手県九戸郡軽米町以下に掲載がない場合');
ok($zip->set_number('0286301')->is_valid_number, '岩手県九戸郡軽米町上舘');
ok($zip->set_number('0286302')->is_valid_number, '岩手県九戸郡軽米町軽米');
ok($zip->set_number('0286303')->is_valid_number, '岩手県九戸郡軽米町高家');
ok($zip->set_number('0286304')->is_valid_number, '岩手県九戸郡軽米町長倉');
ok($zip->set_number('0286411')->is_valid_number, '岩手県九戸郡軽米町小軽米');
ok($zip->set_number('0286412')->is_valid_number, '岩手県九戸郡軽米町蛇口');
ok($zip->set_number('0286413')->is_valid_number, '岩手県九戸郡軽米町円子');
ok($zip->set_number('0286500')->is_valid_number, '岩手県九戸郡九戸村以下に掲載がない場合');
ok($zip->set_number('0286501')->is_valid_number, '岩手県九戸郡九戸村荒谷');
ok($zip->set_number('0286502')->is_valid_number, '岩手県九戸郡九戸村伊保内');
ok($zip->set_number('0286503')->is_valid_number, '岩手県九戸郡九戸村小倉');
ok($zip->set_number('0286504')->is_valid_number, '岩手県九戸郡九戸村長興寺');
ok($zip->set_number('0286505')->is_valid_number, '岩手県九戸郡九戸村江刺家');
ok($zip->set_number('0286506')->is_valid_number, '岩手県九戸郡九戸村山屋');
ok($zip->set_number('0286507')->is_valid_number, '岩手県九戸郡九戸村雪屋');
ok($zip->set_number('0286611')->is_valid_number, '岩手県九戸郡九戸村山根');
ok($zip->set_number('0286612')->is_valid_number, '岩手県九戸郡九戸村戸田');
ok($zip->set_number('0286721')->is_valid_number, '岩手県二戸市似鳥');
ok($zip->set_number('0286722')->is_valid_number, '岩手県二戸市福田');
ok($zip->set_number('0286723')->is_valid_number, '岩手県二戸市安比');
ok($zip->set_number('0286724')->is_valid_number, '岩手県二戸市足沢');
ok($zip->set_number('0286811')->is_valid_number, '岩手県二戸市浄法寺町手倉森');
ok($zip->set_number('0286812')->is_valid_number, '岩手県二戸市浄法寺町下沢');
ok($zip->set_number('0286813')->is_valid_number, '岩手県二戸市浄法寺町大平');
ok($zip->set_number('0286814')->is_valid_number, '岩手県二戸市浄法寺町北村');
ok($zip->set_number('0286815')->is_valid_number, '岩手県二戸市浄法寺町八方口');
ok($zip->set_number('0286816')->is_valid_number, '岩手県二戸市浄法寺町上谷地');
ok($zip->set_number('0286817')->is_valid_number, '岩手県二戸市浄法寺町漆沢大久保');
ok($zip->set_number('0286818')->is_valid_number, '岩手県二戸市浄法寺町鏡田');
ok($zip->set_number('0286819')->is_valid_number, '岩手県二戸市浄法寺町馬洗場');
ok($zip->set_number('0286821')->is_valid_number, '岩手県二戸市浄法寺町小平');
ok($zip->set_number('0286822')->is_valid_number, '岩手県二戸市浄法寺町漆沢舘');
ok($zip->set_number('0286823')->is_valid_number, '岩手県二戸市浄法寺町宮沢');
ok($zip->set_number('0286824')->is_valid_number, '岩手県二戸市浄法寺町西ノ沢');
ok($zip->set_number('0286825')->is_valid_number, '岩手県二戸市浄法寺町長坂');
ok($zip->set_number('0286826')->is_valid_number, '岩手県二戸市浄法寺町川又');
ok($zip->set_number('0286831')->is_valid_number, '岩手県二戸市浄法寺町漆沢下平');
ok($zip->set_number('0286832')->is_valid_number, '岩手県二戸市浄法寺町漆沢上平');
ok($zip->set_number('0286833')->is_valid_number, '岩手県二戸市浄法寺町漆沢');
ok($zip->set_number('0286834')->is_valid_number, '岩手県二戸市浄法寺町細田');
ok($zip->set_number('0286835')->is_valid_number, '岩手県二戸市浄法寺町漆沢下モ前田');
ok($zip->set_number('0286836')->is_valid_number, '岩手県二戸市浄法寺町関田');
ok($zip->set_number('0286837')->is_valid_number, '岩手県二戸市浄法寺町荒屋敷');
ok($zip->set_number('0286838')->is_valid_number, '岩手県二戸市浄法寺町向田');
ok($zip->set_number('0286841')->is_valid_number, '岩手県二戸市浄法寺町松岡');
ok($zip->set_number('0286842')->is_valid_number, '岩手県二戸市浄法寺町漆沢中前田');
ok($zip->set_number('0286843')->is_valid_number, '岩手県二戸市浄法寺町堤口');
ok($zip->set_number('0286844')->is_valid_number, '岩手県二戸市浄法寺町岡本前田');
ok($zip->set_number('0286845')->is_valid_number, '岩手県二戸市浄法寺町漆沢上前田');
ok($zip->set_number('0286846')->is_valid_number, '岩手県二戸市浄法寺町下タ前田');
ok($zip->set_number('0286847')->is_valid_number, '岩手県二戸市浄法寺町岩渕');
ok($zip->set_number('0286848')->is_valid_number, '岩手県二戸市浄法寺町ウト坂');
ok($zip->set_number('0286849')->is_valid_number, '岩手県二戸市浄法寺町岡本');
ok($zip->set_number('0286851')->is_valid_number, '岩手県二戸市浄法寺町小池');
ok($zip->set_number('0286852')->is_valid_number, '岩手県二戸市浄法寺町樋田');
ok($zip->set_number('0286853')->is_valid_number, '岩手県二戸市浄法寺町サイカツ田');
ok($zip->set_number('0286854')->is_valid_number, '岩手県二戸市浄法寺町下前田');
ok($zip->set_number('0286855')->is_valid_number, '岩手県二戸市浄法寺町浄法寺');
ok($zip->set_number('0286856')->is_valid_number, '岩手県二戸市浄法寺町上外野');
ok($zip->set_number('0286857')->is_valid_number, '岩手県二戸市浄法寺町合名沢');
ok($zip->set_number('0286861')->is_valid_number, '岩手県二戸市浄法寺町上野');
ok($zip->set_number('0286862')->is_valid_number, '岩手県二戸市浄法寺町寺ノ上');
ok($zip->set_number('0286863')->is_valid_number, '岩手県二戸市浄法寺町八幡舘');
ok($zip->set_number('0286864')->is_valid_number, '岩手県二戸市浄法寺町門前向');
ok($zip->set_number('0286865')->is_valid_number, '岩手県二戸市浄法寺町野田');
ok($zip->set_number('0286866')->is_valid_number, '岩手県二戸市浄法寺町飯近');
ok($zip->set_number('0286867')->is_valid_number, '岩手県二戸市浄法寺町焼場');
ok($zip->set_number('0286868')->is_valid_number, '岩手県二戸市浄法寺町長者花');
ok($zip->set_number('0286871')->is_valid_number, '岩手県二戸市浄法寺町安戸');
ok($zip->set_number('0286872')->is_valid_number, '岩手県二戸市浄法寺町里川目');
ok($zip->set_number('0286873')->is_valid_number, '岩手県二戸市浄法寺町大志田');
ok($zip->set_number('0286874')->is_valid_number, '岩手県二戸市浄法寺町一反田');
ok($zip->set_number('0286875')->is_valid_number, '岩手県二戸市浄法寺町舘');
ok($zip->set_number('0286876')->is_valid_number, '岩手県二戸市浄法寺町田子内沢');
ok($zip->set_number('0286877')->is_valid_number, '岩手県二戸市浄法寺町伊崎沢');
ok($zip->set_number('0286878')->is_valid_number, '岩手県二戸市浄法寺町漆原');
ok($zip->set_number('0286879')->is_valid_number, '岩手県二戸市浄法寺町梅ノ木');
ok($zip->set_number('0286881')->is_valid_number, '岩手県二戸市浄法寺町渡ノ羽');
ok($zip->set_number('0286882')->is_valid_number, '岩手県二戸市浄法寺町羽余内');
ok($zip->set_number('0286883')->is_valid_number, '岩手県二戸市浄法寺町荒谷');
ok($zip->set_number('0286884')->is_valid_number, '岩手県二戸市浄法寺町新山');
ok($zip->set_number('0286885')->is_valid_number, '岩手県二戸市浄法寺町森越');
ok($zip->set_number('0286901')->is_valid_number, '岩手県二戸市浄法寺町深堀');
ok($zip->set_number('0286902')->is_valid_number, '岩手県二戸市浄法寺町明神沢');
ok($zip->set_number('0286903')->is_valid_number, '岩手県二戸市浄法寺町坂本');
ok($zip->set_number('0286904')->is_valid_number, '岩手県二戸市浄法寺町里代');
ok($zip->set_number('0286905')->is_valid_number, '岩手県二戸市浄法寺町空久保');
ok($zip->set_number('0286906')->is_valid_number, '岩手県二戸市浄法寺町上杉沢');
ok($zip->set_number('0286907')->is_valid_number, '岩手県二戸市浄法寺町季ケ平');
ok($zip->set_number('0286908')->is_valid_number, '岩手県二戸市浄法寺町野黒沢');
ok($zip->set_number('0286911')->is_valid_number, '岩手県二戸市浄法寺町上前田');
ok($zip->set_number('0286912')->is_valid_number, '岩手県二戸市浄法寺町中前田');
ok($zip->set_number('0286913')->is_valid_number, '岩手県二戸市浄法寺町下ノ沢');
ok($zip->set_number('0286914')->is_valid_number, '岩手県二戸市浄法寺町和泉田');
ok($zip->set_number('0286915')->is_valid_number, '岩手県二戸市浄法寺町霜屋敷');
ok($zip->set_number('0286916')->is_valid_number, '岩手県二戸市浄法寺町大清水下モ平');
ok($zip->set_number('0286917')->is_valid_number, '岩手県二戸市浄法寺町大清水前田');
ok($zip->set_number('0286918')->is_valid_number, '岩手県二戸市浄法寺町サイカツ平');
ok($zip->set_number('0286919')->is_valid_number, '岩手県二戸市浄法寺町大清水荒屋');
ok($zip->set_number('0286921')->is_valid_number, '岩手県二戸市浄法寺町小泉');
ok($zip->set_number('0286922')->is_valid_number, '岩手県二戸市浄法寺町下谷地');
ok($zip->set_number('0286923')->is_valid_number, '岩手県二戸市浄法寺町下村');
ok($zip->set_number('0286924')->is_valid_number, '岩手県二戸市浄法寺町家ノ上');
ok($zip->set_number('0286925')->is_valid_number, '岩手県二戸市浄法寺町梅田');
ok($zip->set_number('0286926')->is_valid_number, '岩手県二戸市浄法寺町門崎');
ok($zip->set_number('0286927')->is_valid_number, '岩手県二戸市浄法寺町湯沢');
ok($zip->set_number('0286928')->is_valid_number, '岩手県二戸市浄法寺町山内');
ok($zip->set_number('0286929')->is_valid_number, '岩手県二戸市浄法寺町大清水空久保');
ok($zip->set_number('0286931')->is_valid_number, '岩手県二戸市浄法寺町尻平');
ok($zip->set_number('0286932')->is_valid_number, '岩手県二戸市浄法寺町松畑');
ok($zip->set_number('0286933')->is_valid_number, '岩手県二戸市浄法寺町御山上野');
ok($zip->set_number('0286934')->is_valid_number, '岩手県二戸市浄法寺町沢田');
ok($zip->set_number('0286935')->is_valid_number, '岩手県二戸市浄法寺町御山下前田');
ok($zip->set_number('0286936')->is_valid_number, '岩手県二戸市浄法寺町長渡路');
ok($zip->set_number('0286937')->is_valid_number, '岩手県二戸市浄法寺町大畑');
ok($zip->set_number('0286938')->is_valid_number, '岩手県二戸市浄法寺町御山上平');
ok($zip->set_number('0286939')->is_valid_number, '岩手県二戸市浄法寺町長流部');
ok($zip->set_number('0286941')->is_valid_number, '岩手県二戸市浄法寺町御山中前田');
ok($zip->set_number('0286942')->is_valid_number, '岩手県二戸市浄法寺町御山久保');
ok($zip->set_number('0286943')->is_valid_number, '岩手県二戸市浄法寺町後久保');
ok($zip->set_number('0286944')->is_valid_number, '岩手県二戸市浄法寺町飛鳥');
ok($zip->set_number('0286945')->is_valid_number, '岩手県二戸市浄法寺町飛鳥谷地');
ok($zip->set_number('0286946')->is_valid_number, '岩手県二戸市浄法寺町安比内');
ok($zip->set_number('0286947')->is_valid_number, '岩手県二戸市浄法寺町安比内沢');
ok($zip->set_number('0286948')->is_valid_number, '岩手県二戸市浄法寺町御山舘');
ok($zip->set_number('0286949')->is_valid_number, '岩手県二戸市浄法寺町御山前田');
ok($zip->set_number('0286951')->is_valid_number, '岩手県二戸市浄法寺町清水尻');
ok($zip->set_number('0286952')->is_valid_number, '岩手県二戸市浄法寺町御山大久保');
ok($zip->set_number('0286953')->is_valid_number, '岩手県二戸市浄法寺町木沢畑向');
ok($zip->set_number('0286954')->is_valid_number, '岩手県二戸市浄法寺町早坂');
ok($zip->set_number('0286955')->is_valid_number, '岩手県二戸市浄法寺町桂平');
ok($zip->set_number('0286956')->is_valid_number, '岩手県二戸市浄法寺町大坊');
ok($zip->set_number('0286957')->is_valid_number, '岩手県二戸市浄法寺町海上田');
ok($zip->set_number('0286958')->is_valid_number, '岩手県二戸市浄法寺町大手');
ok($zip->set_number('0286961')->is_valid_number, '岩手県二戸市浄法寺町滝見橋');
ok($zip->set_number('0286962')->is_valid_number, '岩手県二戸市浄法寺町馬場向');
ok($zip->set_number('0286963')->is_valid_number, '岩手県二戸市浄法寺町小又');
ok($zip->set_number('0286964')->is_valid_number, '岩手県二戸市浄法寺町沼久保');
ok($zip->set_number('0286965')->is_valid_number, '岩手県二戸市浄法寺町谷地屋敷');
ok($zip->set_number('0286966')->is_valid_number, '岩手県二戸市浄法寺町海上');
ok($zip->set_number('0286967')->is_valid_number, '岩手県二戸市浄法寺町惣川原田');
ok($zip->set_number('0286968')->is_valid_number, '岩手県二戸市浄法寺町海上前田');
ok($zip->set_number('0286969')->is_valid_number, '岩手県二戸市浄法寺町端保口');
ok($zip->set_number('0286971')->is_valid_number, '岩手県二戸市浄法寺町向川原');
ok($zip->set_number('0286972')->is_valid_number, '岩手県二戸市浄法寺町桜田');
ok($zip->set_number('0286973')->is_valid_number, '岩手県二戸市浄法寺町駒ケ嶺舘');
ok($zip->set_number('0286974')->is_valid_number, '岩手県二戸市浄法寺町中畑');
ok($zip->set_number('0286975')->is_valid_number, '岩手県二戸市浄法寺町田余内');
ok($zip->set_number('0286976')->is_valid_number, '岩手県二戸市浄法寺町樋口');
ok($zip->set_number('0286977')->is_valid_number, '岩手県二戸市浄法寺町駒ケ嶺');
ok($zip->set_number('0286978')->is_valid_number, '岩手県二戸市浄法寺町駒ケ嶺前田');
ok($zip->set_number('0286979')->is_valid_number, '岩手県二戸市浄法寺町駒ケ嶺野田');
ok($zip->set_number('0286981')->is_valid_number, '岩手県二戸市浄法寺町五庵');
ok($zip->set_number('0286982')->is_valid_number, '岩手県二戸市浄法寺町焼切');
ok($zip->set_number('0286983')->is_valid_number, '岩手県二戸市浄法寺町下藤');
ok($zip->set_number('0286984')->is_valid_number, '岩手県二戸市浄法寺町柿ノ木平');
ok($zip->set_number('0286985')->is_valid_number, '岩手県二戸市浄法寺町漆畑');
ok($zip->set_number('0287100')->is_valid_number, '岩手県八幡平市以下に掲載がない場合');
ok($zip->set_number('0287111')->is_valid_number, '岩手県八幡平市大更');
ok($zip->set_number('0287112')->is_valid_number, '岩手県八幡平市田頭');
ok($zip->set_number('0287113')->is_valid_number, '岩手県八幡平市平笠');
ok($zip->set_number('0287301')->is_valid_number, '岩手県八幡平市野駄');
ok($zip->set_number('0287302')->is_valid_number, '岩手県八幡平市八幡平温泉郷');
ok($zip->set_number('0287302')->is_valid_number, '岩手県八幡平市松尾寄木');
ok($zip->set_number('0287302')->is_valid_number, '岩手県八幡平市松川温泉');
ok($zip->set_number('0287303')->is_valid_number, '岩手県八幡平市柏台');
ok($zip->set_number('0287303')->is_valid_number, '岩手県八幡平市藤七温泉');
ok($zip->set_number('0287304')->is_valid_number, '岩手県八幡平市緑ガ丘');
ok($zip->set_number('0287305')->is_valid_number, '岩手県八幡平市松尾');
ok($zip->set_number('0287306')->is_valid_number, '岩手県八幡平市安比高原');
ok($zip->set_number('0287401')->is_valid_number, '岩手県八幡平市西根寺田');
ok($zip->set_number('0287402')->is_valid_number, '岩手県八幡平市帷子');
ok($zip->set_number('0287403')->is_valid_number, '岩手県八幡平市上関');
ok($zip->set_number('0287404')->is_valid_number, '岩手県八幡平市堀切');
ok($zip->set_number('0287405')->is_valid_number, '岩手県八幡平市平舘');
ok($zip->set_number('0287406')->is_valid_number, '岩手県八幡平市荒木田');
ok($zip->set_number('0287501')->is_valid_number, '岩手県八幡平市岩木向');
ok($zip->set_number('0287502')->is_valid_number, '岩手県八幡平市上岩木');
ok($zip->set_number('0287503')->is_valid_number, '岩手県八幡平市中田');
ok($zip->set_number('0287504')->is_valid_number, '岩手県八幡平市前田');
ok($zip->set_number('0287505')->is_valid_number, '岩手県八幡平市岩屋');
ok($zip->set_number('0287506')->is_valid_number, '岩手県八幡平市安代寺田');
ok($zip->set_number('0287511')->is_valid_number, '岩手県八幡平市下の田');
ok($zip->set_number('0287512')->is_valid_number, '岩手県八幡平市山岸');
ok($zip->set_number('0287513')->is_valid_number, '岩手県八幡平市土沢');
ok($zip->set_number('0287514')->is_valid_number, '岩手県八幡平市中佐井');
ok($zip->set_number('0287515')->is_valid_number, '岩手県八幡平市古屋敷');
ok($zip->set_number('0287516')->is_valid_number, '岩手県八幡平市関沢口');
ok($zip->set_number('0287521')->is_valid_number, '岩手県八幡平市石神');
ok($zip->set_number('0287522')->is_valid_number, '岩手県八幡平市山口');
ok($zip->set_number('0287523')->is_valid_number, '岩手県八幡平市繋沢');
ok($zip->set_number('0287524')->is_valid_number, '岩手県八幡平市湯の沢');
ok($zip->set_number('0287525')->is_valid_number, '岩手県八幡平市日影');
ok($zip->set_number('0287526')->is_valid_number, '岩手県八幡平市赤子平');
ok($zip->set_number('0287527')->is_valid_number, '岩手県八幡平市川原');
ok($zip->set_number('0287531')->is_valid_number, '岩手県八幡平市上の山');
ok($zip->set_number('0287532')->is_valid_number, '岩手県八幡平市小柳田');
ok($zip->set_number('0287533')->is_valid_number, '岩手県八幡平市叺田');
ok($zip->set_number('0287534')->is_valid_number, '岩手県八幡平市荒屋新町');
ok($zip->set_number('0287535')->is_valid_number, '岩手県八幡平市清水');
ok($zip->set_number('0287536')->is_valid_number, '岩手県八幡平市打田内');
ok($zip->set_number('0287537')->is_valid_number, '岩手県八幡平市曲田');
ok($zip->set_number('0287541')->is_valid_number, '岩手県八幡平市寺志田');
ok($zip->set_number('0287542')->is_valid_number, '岩手県八幡平市高畑');
ok($zip->set_number('0287543')->is_valid_number, '岩手県八幡平市小屋畑');
ok($zip->set_number('0287544')->is_valid_number, '岩手県八幡平市保戸坂');
ok($zip->set_number('0287545')->is_valid_number, '岩手県八幡平市松木田');
ok($zip->set_number('0287551')->is_valid_number, '岩手県八幡平市新田');
ok($zip->set_number('0287552')->is_valid_number, '岩手県八幡平市安代寄木');
ok($zip->set_number('0287553')->is_valid_number, '岩手県八幡平市扇畑');
ok($zip->set_number('0287554')->is_valid_number, '岩手県八幡平市赤坂田');
ok($zip->set_number('0287555')->is_valid_number, '岩手県八幡平市黒沢');
ok($zip->set_number('0287556')->is_valid_number, '岩手県八幡平市星沢');
ok($zip->set_number('0287557')->is_valid_number, '岩手県八幡平市細野');
ok($zip->set_number('0287561')->is_valid_number, '岩手県八幡平市下町');
ok($zip->set_number('0287562')->is_valid_number, '岩手県八幡平市五日市');
ok($zip->set_number('0287563')->is_valid_number, '岩手県八幡平市田の沢');
ok($zip->set_number('0287564')->is_valid_number, '岩手県八幡平市谷地田');
ok($zip->set_number('0287565')->is_valid_number, '岩手県八幡平市目名市');
ok($zip->set_number('0287566')->is_valid_number, '岩手県八幡平市滝沢');
ok($zip->set_number('0287567')->is_valid_number, '岩手県八幡平市戸沢');
ok($zip->set_number('0287601')->is_valid_number, '岩手県八幡平市田沢');
ok($zip->set_number('0287602')->is_valid_number, '岩手県八幡平市丑山');
ok($zip->set_number('0287603')->is_valid_number, '岩手県八幡平市矢神');
ok($zip->set_number('0287604')->is_valid_number, '岩手県八幡平市丑山口');
ok($zip->set_number('0287605')->is_valid_number, '岩手県八幡平市鵜谷地');
ok($zip->set_number('0287606')->is_valid_number, '岩手県八幡平市姥子石');
ok($zip->set_number('0287607')->is_valid_number, '岩手県八幡平市大面平');
ok($zip->set_number('0287608')->is_valid_number, '岩手県八幡平市谷地中');
ok($zip->set_number('0287611')->is_valid_number, '岩手県八幡平市沖田表');
ok($zip->set_number('0287612')->is_valid_number, '岩手県八幡平市欠田');
ok($zip->set_number('0287613')->is_valid_number, '岩手県八幡平市亦戸川原');
ok($zip->set_number('0287614')->is_valid_number, '岩手県八幡平市石名坂下タ');
ok($zip->set_number('0287615')->is_valid_number, '岩手県八幡平市石名坂');
ok($zip->set_number('0287616')->is_valid_number, '岩手県八幡平市二タ子');
ok($zip->set_number('0287617')->is_valid_number, '岩手県八幡平市折壁');
ok($zip->set_number('0287618')->is_valid_number, '岩手県八幡平市蛇石');
ok($zip->set_number('0287619')->is_valid_number, '岩手県八幡平市相沢');
ok($zip->set_number('0287621')->is_valid_number, '岩手県八幡平市兄川');
ok($zip->set_number('0287621')->is_valid_number, '岩手県八幡平市作平');
ok($zip->set_number('0287622')->is_valid_number, '岩手県八幡平市兄畑中川原');
ok($zip->set_number('0287623')->is_valid_number, '岩手県八幡平市舘市');
ok($zip->set_number('0287624')->is_valid_number, '岩手県八幡平市大又沢口');
ok($zip->set_number('0287625')->is_valid_number, '岩手県八幡平市沖ノ平');
ok($zip->set_number('0287626')->is_valid_number, '岩手県八幡平市戸鎖');
ok($zip->set_number('0287627')->is_valid_number, '岩手県八幡平市佐比内');
ok($zip->set_number('0287628')->is_valid_number, '岩手県八幡平市小岩井');
ok($zip->set_number('0287629')->is_valid_number, '岩手県八幡平市白沢口');
ok($zip->set_number('0287631')->is_valid_number, '岩手県八幡平市瀬ノ沢');
ok($zip->set_number('0287632')->is_valid_number, '岩手県八幡平市小原道ノ上');
ok($zip->set_number('0287633')->is_valid_number, '岩手県八幡平市日泥道ノ上');
ok($zip->set_number('0287634')->is_valid_number, '岩手県八幡平市和屋敷道ノ上');
ok($zip->set_number('0287635')->is_valid_number, '岩手県八幡平市愛の山');
ok($zip->set_number('0287636')->is_valid_number, '岩手県八幡平市和屋敷道ノ下');
ok($zip->set_number('0287637')->is_valid_number, '岩手県八幡平市日泥道ノ下');
ok($zip->set_number('0287638')->is_valid_number, '岩手県八幡平市小原道ノ下');
ok($zip->set_number('0287641')->is_valid_number, '岩手県八幡平市比路平');
ok($zip->set_number('0287642')->is_valid_number, '岩手県八幡平市勝善川原');
ok($zip->set_number('0287643')->is_valid_number, '岩手県八幡平市切通');
ok($zip->set_number('0287644')->is_valid_number, '岩手県八幡平市雀長根');
ok($zip->set_number('0287645')->is_valid_number, '岩手県八幡平市下タ川原');
ok($zip->set_number('0287651')->is_valid_number, '岩手県八幡平市長者前');
ok($zip->set_number('0287652')->is_valid_number, '岩手県八幡平市根石');
ok($zip->set_number('0287653')->is_valid_number, '岩手県八幡平市平又');
ok($zip->set_number('0287654')->is_valid_number, '岩手県八幡平市小峠');
ok($zip->set_number('0287655')->is_valid_number, '岩手県八幡平市馬揚沢');
ok($zip->set_number('0287656')->is_valid_number, '岩手県八幡平市左妻');
ok($zip->set_number('0287657')->is_valid_number, '岩手県八幡平市栗木田');
ok($zip->set_number('0287661')->is_valid_number, '岩手県八幡平市大沢');
ok($zip->set_number('0287662')->is_valid_number, '岩手県八幡平市杉沢');
ok($zip->set_number('0287663')->is_valid_number, '岩手県八幡平市石森');
ok($zip->set_number('0287664')->is_valid_number, '岩手県八幡平市大沢田');
ok($zip->set_number('0287671')->is_valid_number, '岩手県八幡平市馬場下');
ok($zip->set_number('0287672')->is_valid_number, '岩手県八幡平市田中下タ');
ok($zip->set_number('0287673')->is_valid_number, '岩手県八幡平市殿坂下タ');
ok($zip->set_number('0287674')->is_valid_number, '岩手県八幡平市家ノ裏');
ok($zip->set_number('0287675')->is_valid_number, '岩手県八幡平市下モ川原');
ok($zip->set_number('0287676')->is_valid_number, '岩手県八幡平市沢口');
ok($zip->set_number('0287677')->is_valid_number, '岩手県八幡平市田山');
ok($zip->set_number('0287678')->is_valid_number, '岩手県八幡平市小森');
ok($zip->set_number('0287679')->is_valid_number, '岩手県八幡平市足深');
ok($zip->set_number('0287801')->is_valid_number, '岩手県久慈市侍浜町');
ok($zip->set_number('0287900')->is_valid_number, '岩手県九戸郡洋野町以下に掲載がない場合');
ok($zip->set_number('0287901')->is_valid_number, '岩手県九戸郡洋野町種市第8地割~第14地割(玉川、戸類家)');
ok($zip->set_number('0287902')->is_valid_number, '岩手県九戸郡洋野町種市第4地割~第7地割(宿戸)');
ok($zip->set_number('0287903')->is_valid_number, '岩手県九戸郡洋野町種市第1地割~第3地割(八木南町、八木北町)');
ok($zip->set_number('0287904')->is_valid_number, '岩手県九戸郡洋野町小子内');
ok($zip->set_number('0287905')->is_valid_number, '岩手県九戸郡洋野町有家');
ok($zip->set_number('0287906')->is_valid_number, '岩手県九戸郡洋野町中野');
ok($zip->set_number('0287911')->is_valid_number, '岩手県九戸郡洋野町種市第39地割~第45地割(角浜、伝吉)');
ok($zip->set_number('0287912')->is_valid_number, '岩手県九戸郡洋野町種市第26地割~第38地割(川尻、平内)');
ok($zip->set_number('0287913')->is_valid_number, '岩手県九戸郡洋野町種市第24地割~第25地割(緑ケ丘町、横手)');
ok($zip->set_number('0287914')->is_valid_number, '岩手県九戸郡洋野町種市第22地割~第23地割(一区、二区、三区、四区、大町、小橋、住吉町)');
ok($zip->set_number('0287915')->is_valid_number, '岩手県九戸郡洋野町種市第15地割~第21地割(鹿糠、小路合、緑町、大久保、高取)');
ok($zip->set_number('0287916')->is_valid_number, '岩手県九戸郡洋野町種市第71地割~第74地割(大谷、和座)');
ok($zip->set_number('0287917')->is_valid_number, '岩手県九戸郡洋野町種市第50地割~第70地割(大沢、城内、滝沢)');
ok($zip->set_number('0287918')->is_valid_number, '岩手県九戸郡洋野町種市第46地割~第49地割(麦沢)');
ok($zip->set_number('0288111')->is_valid_number, '岩手県久慈市宇部町');
ok($zip->set_number('0288200')->is_valid_number, '岩手県九戸郡野田村以下に掲載がない場合');
ok($zip->set_number('0288201')->is_valid_number, '岩手県九戸郡野田村野田');
ok($zip->set_number('0288202')->is_valid_number, '岩手県九戸郡野田村玉川');
ok($zip->set_number('0288300')->is_valid_number, '岩手県下閉伊郡普代村以下に掲載がない場合');
ok($zip->set_number('0288301')->is_valid_number, '岩手県下閉伊郡普代村馬場野');
ok($zip->set_number('0288302')->is_valid_number, '岩手県下閉伊郡普代村堀内');
ok($zip->set_number('0288303')->is_valid_number, '岩手県下閉伊郡普代村沢向');
ok($zip->set_number('0288311')->is_valid_number, '岩手県下閉伊郡普代村白井');
ok($zip->set_number('0288312')->is_valid_number, '岩手県下閉伊郡普代村小谷地');
ok($zip->set_number('0288313')->is_valid_number, '岩手県下閉伊郡普代村土取場');
ok($zip->set_number('0288321')->is_valid_number, '岩手県下閉伊郡普代村野胡桃');
ok($zip->set_number('0288322')->is_valid_number, '岩手県下閉伊郡普代村天拝坂');
ok($zip->set_number('0288323')->is_valid_number, '岩手県下閉伊郡普代村鳥居');
ok($zip->set_number('0288331')->is_valid_number, '岩手県下閉伊郡普代村宇留部');
ok($zip->set_number('0288332')->is_valid_number, '岩手県下閉伊郡普代村銅屋');
ok($zip->set_number('0288333')->is_valid_number, '岩手県下閉伊郡普代村羅賀');
ok($zip->set_number('0288334')->is_valid_number, '岩手県下閉伊郡普代村中村');
ok($zip->set_number('0288335')->is_valid_number, '岩手県下閉伊郡普代村普代');
ok($zip->set_number('0288336')->is_valid_number, '岩手県下閉伊郡普代村堤');
ok($zip->set_number('0288341')->is_valid_number, '岩手県下閉伊郡普代村明神');
ok($zip->set_number('0288342')->is_valid_number, '岩手県下閉伊郡普代村和野山');
ok($zip->set_number('0288343')->is_valid_number, '岩手県下閉伊郡普代村上の山');
ok($zip->set_number('0288344')->is_valid_number, '岩手県下閉伊郡普代村中山');
ok($zip->set_number('0288345')->is_valid_number, '岩手県下閉伊郡普代村太田名部');
ok($zip->set_number('0288351')->is_valid_number, '岩手県下閉伊郡普代村下村');
ok($zip->set_number('0288352')->is_valid_number, '岩手県下閉伊郡普代村上村');
ok($zip->set_number('0288353')->is_valid_number, '岩手県下閉伊郡普代村黒崎');
ok($zip->set_number('0288361')->is_valid_number, '岩手県下閉伊郡普代村北ノ股');
ok($zip->set_number('0288362')->is_valid_number, '岩手県下閉伊郡普代村卯子酉');
ok($zip->set_number('0288363')->is_valid_number, '岩手県下閉伊郡普代村茂市');
ok($zip->set_number('0288364')->is_valid_number, '岩手県下閉伊郡普代村南股');
ok($zip->set_number('0288365')->is_valid_number, '岩手県下閉伊郡普代村芦渡');
ok($zip->set_number('0288366')->is_valid_number, '岩手県下閉伊郡普代村芦生');
ok($zip->set_number('0288367')->is_valid_number, '岩手県下閉伊郡普代村萩牛');
ok($zip->set_number('0288368')->is_valid_number, '岩手県下閉伊郡普代村柏木平');
ok($zip->set_number('0288400')->is_valid_number, '岩手県下閉伊郡田野畑村以下に掲載がない場合');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村一の渡');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村蝦夷森');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村大森');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村尾肝要');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村奥地');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村奥地向');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村茅刈沢');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村巣合');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村千丈');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村千足');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村滝ノ沢');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村田代');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村長根');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村沼袋');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村子木地');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村子木屋敷');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村萩牛');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村日蔭');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村姫松');
ok($zip->set_number('0288401')->is_valid_number, '岩手県下閉伊郡田野畑村三沢');
ok($zip->set_number('0288402')->is_valid_number, '岩手県下閉伊郡田野畑村明戸');
ok($zip->set_number('0288402')->is_valid_number, '岩手県下閉伊郡田野畑村北山');
ok($zip->set_number('0288402')->is_valid_number, '岩手県下閉伊郡田野畑村机');
ok($zip->set_number('0288403')->is_valid_number, '岩手県下閉伊郡田野畑村羅賀');
ok($zip->set_number('0288404')->is_valid_number, '岩手県下閉伊郡田野畑村島越');
ok($zip->set_number('0288404')->is_valid_number, '岩手県下閉伊郡田野畑村松前沢');
ok($zip->set_number('0288405')->is_valid_number, '岩手県下閉伊郡田野畑村大芦');
ok($zip->set_number('0288405')->is_valid_number, '岩手県下閉伊郡田野畑村切牛');
ok($zip->set_number('0288405')->is_valid_number, '岩手県下閉伊郡田野畑村浜岩泉');
ok($zip->set_number('0288405')->is_valid_number, '岩手県下閉伊郡田野畑村真木沢');
ok($zip->set_number('0288405')->is_valid_number, '岩手県下閉伊郡田野畑村南大芦');
ok($zip->set_number('0288406')->is_valid_number, '岩手県下閉伊郡田野畑村猿山');
ok($zip->set_number('0288406')->is_valid_number, '岩手県下閉伊郡田野畑村年呂部');
ok($zip->set_number('0288406')->is_valid_number, '岩手県下閉伊郡田野畑村七滝');
ok($zip->set_number('0288406')->is_valid_number, '岩手県下閉伊郡田野畑村室場');
ok($zip->set_number('0288406')->is_valid_number, '岩手県下閉伊郡田野畑村目名');
ok($zip->set_number('0288407')->is_valid_number, '岩手県下閉伊郡田野畑村川平');
ok($zip->set_number('0288407')->is_valid_number, '岩手県下閉伊郡田野畑村菅窪');
ok($zip->set_number('0288407')->is_valid_number, '岩手県下閉伊郡田野畑村田野畑');
ok($zip->set_number('0288407')->is_valid_number, '岩手県下閉伊郡田野畑村和野');
ok($zip->set_number('0288521')->is_valid_number, '岩手県久慈市山根町');
ok($zip->set_number('0288601')->is_valid_number, '岩手県久慈市山形町戸呂町');
ok($zip->set_number('0288602')->is_valid_number, '岩手県久慈市山形町川井');
ok($zip->set_number('0288603')->is_valid_number, '岩手県久慈市山形町荷軽部');
ok($zip->set_number('0288604')->is_valid_number, '岩手県久慈市山形町日野沢');
ok($zip->set_number('0288605')->is_valid_number, '岩手県久慈市山形町来内');
ok($zip->set_number('0288711')->is_valid_number, '岩手県久慈市山形町繋');
ok($zip->set_number('0288712')->is_valid_number, '岩手県久慈市山形町小国');
ok($zip->set_number('0288713')->is_valid_number, '岩手県久慈市山形町霜畑');
ok($zip->set_number('0288801')->is_valid_number, '岩手県九戸郡洋野町上館');
ok($zip->set_number('0288802')->is_valid_number, '岩手県九戸郡洋野町大野');
ok($zip->set_number('0288803')->is_valid_number, '岩手県九戸郡洋野町阿子木');
ok($zip->set_number('0288804')->is_valid_number, '岩手県九戸郡洋野町帯島');
ok($zip->set_number('0288805')->is_valid_number, '岩手県九戸郡洋野町水沢');
ok($zip->set_number('0290131')->is_valid_number, '岩手県一関市狐禅寺');
ok($zip->set_number('0290132')->is_valid_number, '岩手県一関市滝沢');
ok($zip->set_number('0290201')->is_valid_number, '岩手県一関市川崎町門崎');
ok($zip->set_number('0290202')->is_valid_number, '岩手県一関市川崎町薄衣');
ok($zip->set_number('0290211')->is_valid_number, '岩手県一関市弥栄');
ok($zip->set_number('0290301')->is_valid_number, '岩手県一関市東山町田河津');
ok($zip->set_number('0290302')->is_valid_number, '岩手県一関市東山町長坂');
ok($zip->set_number('0290303')->is_valid_number, '岩手県一関市東山町松川');
ok($zip->set_number('0290431')->is_valid_number, '岩手県一関市大東町猿沢');
ok($zip->set_number('0290521')->is_valid_number, '岩手県一関市大東町渋民');
ok($zip->set_number('0290522')->is_valid_number, '岩手県一関市大東町曽慶');
ok($zip->set_number('0290523')->is_valid_number, '岩手県一関市大東町摺沢');
ok($zip->set_number('0290601')->is_valid_number, '岩手県一関市大東町中川');
ok($zip->set_number('0290602')->is_valid_number, '岩手県一関市大東町鳥海');
ok($zip->set_number('0290603')->is_valid_number, '岩手県一関市大東町沖田');
ok($zip->set_number('0290711')->is_valid_number, '岩手県一関市大東町大原');
ok($zip->set_number('0290801')->is_valid_number, '岩手県一関市千厩町清田');
ok($zip->set_number('0290802')->is_valid_number, '岩手県一関市千厩町小梨');
ok($zip->set_number('0290803')->is_valid_number, '岩手県一関市千厩町千厩');
ok($zip->set_number('0290804')->is_valid_number, '岩手県一関市千厩町磐清水');
ok($zip->set_number('0291111')->is_valid_number, '岩手県一関市千厩町奥玉');
ok($zip->set_number('0291201')->is_valid_number, '岩手県一関市室根町折壁');
ok($zip->set_number('0291202')->is_valid_number, '岩手県一関市室根町矢越');
ok($zip->set_number('0291211')->is_valid_number, '岩手県一関市室根町津谷川');
ok($zip->set_number('0292200')->is_valid_number, '岩手県陸前高田市以下に掲載がない場合');
ok($zip->set_number('0292201')->is_valid_number, '岩手県陸前高田市矢作町');
ok($zip->set_number('0292202')->is_valid_number, '岩手県陸前高田市横田町');
ok($zip->set_number('0292203')->is_valid_number, '岩手県陸前高田市竹駒町');
ok($zip->set_number('0292204')->is_valid_number, '岩手県陸前高田市気仙町');
ok($zip->set_number('0292205')->is_valid_number, '岩手県陸前高田市高田町');
ok($zip->set_number('0292206')->is_valid_number, '岩手県陸前高田市米崎町');
ok($zip->set_number('0292207')->is_valid_number, '岩手県陸前高田市小友町');
ok($zip->set_number('0292208')->is_valid_number, '岩手県陸前高田市広田町');
ok($zip->set_number('0292300')->is_valid_number, '岩手県気仙郡住田町以下に掲載がない場合');
ok($zip->set_number('0292311')->is_valid_number, '岩手県気仙郡住田町世田米');
ok($zip->set_number('0292501')->is_valid_number, '岩手県気仙郡住田町上有住');
ok($zip->set_number('0292502')->is_valid_number, '岩手県気仙郡住田町下有住');
ok($zip->set_number('0293101')->is_valid_number, '岩手県一関市花泉町花泉');
ok($zip->set_number('0293102')->is_valid_number, '岩手県一関市花泉町金沢');
ok($zip->set_number('0293103')->is_valid_number, '岩手県一関市花泉町老松');
ok($zip->set_number('0293104')->is_valid_number, '岩手県一関市花泉町日形');
ok($zip->set_number('0293105')->is_valid_number, '岩手県一関市花泉町涌津(一ノ町、二ノ町、上原、境、古川、道下)');
ok($zip->set_number('0293205')->is_valid_number, '岩手県一関市花泉町涌津(その他)');
ok($zip->set_number('0293206')->is_valid_number, '岩手県一関市花泉町永井');
ok($zip->set_number('0293207')->is_valid_number, '岩手県一関市花泉町油島');
ok($zip->set_number('0293311')->is_valid_number, '岩手県一関市藤沢町黄海');
ok($zip->set_number('0293401')->is_valid_number, '岩手県一関市藤沢町増沢');
ok($zip->set_number('0293402')->is_valid_number, '岩手県一関市藤沢町新沼');
ok($zip->set_number('0293403')->is_valid_number, '岩手県一関市藤沢町砂子田');
ok($zip->set_number('0293404')->is_valid_number, '岩手県一関市藤沢町徳田');
ok($zip->set_number('0293405')->is_valid_number, '岩手県一関市藤沢町藤沢');
ok($zip->set_number('0293406')->is_valid_number, '岩手県一関市藤沢町西口');
ok($zip->set_number('0293521')->is_valid_number, '岩手県一関市藤沢町保呂羽');
ok($zip->set_number('0293522')->is_valid_number, '岩手県一関市藤沢町大籠');
ok($zip->set_number('0294100')->is_valid_number, '岩手県西磐井郡平泉町以下に掲載がない場合');
ok($zip->set_number('0294101')->is_valid_number, '岩手県西磐井郡平泉町長島');
ok($zip->set_number('0294102')->is_valid_number, '岩手県西磐井郡平泉町平泉');
ok($zip->set_number('0294201')->is_valid_number, '岩手県奥州市前沢区阿部舘');
ok($zip->set_number('0294201')->is_valid_number, '岩手県奥州市前沢区久田');
ok($zip->set_number('0294201')->is_valid_number, '岩手県奥州市前沢区源氏ケ崎');
ok($zip->set_number('0294201')->is_valid_number, '岩手県奥州市前沢区古城');
ok($zip->set_number('0294202')->is_valid_number, '岩手県奥州市前沢区白山');
ok($zip->set_number('0294203')->is_valid_number, '岩手県奥州市前沢区北久保');
ok($zip->set_number('0294203')->is_valid_number, '岩手県奥州市前沢区狐堂');
ok($zip->set_number('0294203')->is_valid_number, '岩手県奥州市前沢区生母');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区下谷起');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区島');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区宿');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区高畑');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区田中');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区道場');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区鳥待小屋');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区中久保');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区長檀');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区中村');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区古川');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区南前沢');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区向田');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区本杉');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区谷地');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区八幡');
ok($zip->set_number('0294204')->is_valid_number, '岩手県奥州市前沢区八幡前');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区合ノ沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区安寺沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区石田');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区一ノ沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区鵜ノ木');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区鵜ノ木田');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区うるし野');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区大袋');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区沖田');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区小沢口');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区川内');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区衣関');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区里');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区清水');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区蛇ノ鼻');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区白鳥舘');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区新城');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区堤田');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区照井舘');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区徳沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区永沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区長根');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区中屋敷');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区浪洗');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区二ノ沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区沼尻');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区沼ノ沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区日向');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区福養');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区干場');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区前野');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区南陣場');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区南塔ヶ崎');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区南中島');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区箕輪');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区両手沢');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区谷記');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区谷起');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区谷記田');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区谷起田');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区櫓前');
ok($zip->set_number('0294205')->is_valid_number, '岩手県奥州市前沢区六本松');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区赤坂');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区裏新田');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区狐石');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区駒水');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区陣場');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区太郎ケ沢');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区日除松');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区簾森');
ok($zip->set_number('0294206')->is_valid_number, '岩手県奥州市前沢区養ケ森');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区赤面');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区一本杉');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区大桜');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区五十人町');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区下小路');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区平小路');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区平前');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区塔ケ崎');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区泊ケ崎');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区三日町');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区三日町浦');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区三日町新裏');
ok($zip->set_number('0294207')->is_valid_number, '岩手県奥州市前沢区屋敷');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区粟ケ島');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区河ノ畑');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区株樹');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区五合田');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区新町');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区新町裏');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区大林寺下');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区竹沢');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区立石');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区田畠');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区中田');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区七日町');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区七日町裏');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区二十人町');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区二十人町裏');
ok($zip->set_number('0294208')->is_valid_number, '岩手県奥州市前沢区山下');
ok($zip->set_number('0294209')->is_valid_number, '岩手県奥州市前沢区あすか通');
ok($zip->set_number('0294211')->is_valid_number, '岩手県奥州市前沢区駅東');
ok($zip->set_number('0294303')->is_valid_number, '岩手県奥州市衣川区衣原');
ok($zip->set_number('0294304')->is_valid_number, '岩手県奥州市衣川区外の沢');
ok($zip->set_number('0294305')->is_valid_number, '岩手県奥州市衣川区長袋');
ok($zip->set_number('0294306')->is_valid_number, '岩手県奥州市衣川区小田');
ok($zip->set_number('0294307')->is_valid_number, '岩手県奥州市衣川区有浦');
ok($zip->set_number('0294308')->is_valid_number, '岩手県奥州市衣川区大平');
ok($zip->set_number('0294311')->is_valid_number, '岩手県奥州市衣川区古館');
ok($zip->set_number('0294312')->is_valid_number, '岩手県奥州市衣川区西窪');
ok($zip->set_number('0294313')->is_valid_number, '岩手県奥州市衣川区石生');
ok($zip->set_number('0294314')->is_valid_number, '岩手県奥州市衣川区中屋敷');
ok($zip->set_number('0294315')->is_valid_number, '岩手県奥州市衣川区天田');
ok($zip->set_number('0294316')->is_valid_number, '岩手県奥州市衣川区苗代沢');
ok($zip->set_number('0294317')->is_valid_number, '岩手県奥州市衣川区桑畑');
ok($zip->set_number('0294321')->is_valid_number, '岩手県奥州市衣川区雲南田');
ok($zip->set_number('0294322')->is_valid_number, '岩手県奥州市衣川区板倉');
ok($zip->set_number('0294323')->is_valid_number, '岩手県奥州市衣川区小安代');
ok($zip->set_number('0294324')->is_valid_number, '岩手県奥州市衣川区正板');
ok($zip->set_number('0294325')->is_valid_number, '岩手県奥州市衣川区小正板');
ok($zip->set_number('0294326')->is_valid_number, '岩手県奥州市衣川区懸田');
ok($zip->set_number('0294327')->is_valid_number, '岩手県奥州市衣川区馬懸');
ok($zip->set_number('0294328')->is_valid_number, '岩手県奥州市衣川区下寺田');
ok($zip->set_number('0294329')->is_valid_number, '岩手県奥州市衣川区上寺田');
ok($zip->set_number('0294331')->is_valid_number, '岩手県奥州市衣川区深沢');
ok($zip->set_number('0294332')->is_valid_number, '岩手県奥州市衣川区古戸');
ok($zip->set_number('0294333')->is_valid_number, '岩手県奥州市衣川区駒場');
ok($zip->set_number('0294334')->is_valid_number, '岩手県奥州市衣川区百ケ袋');
ok($zip->set_number('0294341')->is_valid_number, '岩手県奥州市衣川区六道');
ok($zip->set_number('0294342')->is_valid_number, '岩手県奥州市衣川区高保呂');
ok($zip->set_number('0294343')->is_valid_number, '岩手県奥州市衣川区能登屋敷');
ok($zip->set_number('0294344')->is_valid_number, '岩手県奥州市衣川区沢田');
ok($zip->set_number('0294345')->is_valid_number, '岩手県奥州市衣川区館城');
ok($zip->set_number('0294346')->is_valid_number, '岩手県奥州市衣川区豊巻');
ok($zip->set_number('0294347')->is_valid_number, '岩手県奥州市衣川区大西');
ok($zip->set_number('0294348')->is_valid_number, '岩手県奥州市衣川区杉野');
ok($zip->set_number('0294351')->is_valid_number, '岩手県奥州市衣川区夏秋');
ok($zip->set_number('0294352')->is_valid_number, '岩手県奥州市衣川区岩の上');
ok($zip->set_number('0294353')->is_valid_number, '岩手県奥州市衣川区旧殿');
ok($zip->set_number('0294354')->is_valid_number, '岩手県奥州市衣川区除');
ok($zip->set_number('0294355')->is_valid_number, '岩手県奥州市衣川区山岸');
ok($zip->set_number('0294361')->is_valid_number, '岩手県奥州市衣川区長嚢');
ok($zip->set_number('0294362')->is_valid_number, '岩手県奥州市衣川区小林山');
ok($zip->set_number('0294363')->is_valid_number, '岩手県奥州市衣川区夏梨');
ok($zip->set_number('0294364')->is_valid_number, '岩手県奥州市衣川区西風山');
ok($zip->set_number('0294365')->is_valid_number, '岩手県奥州市衣川区天土');
ok($zip->set_number('0294371')->is_valid_number, '岩手県奥州市衣川区桧山沢');
ok($zip->set_number('0294372')->is_valid_number, '岩手県奥州市衣川区松林');
ok($zip->set_number('0294373')->is_valid_number, '岩手県奥州市衣川区山田');
ok($zip->set_number('0294374')->is_valid_number, '岩手県奥州市衣川区桧山沢山');
ok($zip->set_number('0294375')->is_valid_number, '岩手県奥州市衣川区鞍掛');
ok($zip->set_number('0294376')->is_valid_number, '岩手県奥州市衣川区本巻');
ok($zip->set_number('0294377')->is_valid_number, '岩手県奥州市衣川区後山');
ok($zip->set_number('0294378')->is_valid_number, '岩手県奥州市衣川区菖蒲平');
ok($zip->set_number('0294381')->is_valid_number, '岩手県奥州市衣川区石ケ沢');
ok($zip->set_number('0294382')->is_valid_number, '岩手県奥州市衣川区関袋');
ok($zip->set_number('0294383')->is_valid_number, '岩手県奥州市衣川区沖の野');
ok($zip->set_number('0294384')->is_valid_number, '岩手県奥州市衣川区石神');
ok($zip->set_number('0294385')->is_valid_number, '岩手県奥州市衣川区富沢');
ok($zip->set_number('0294386')->is_valid_number, '岩手県奥州市衣川区女石');
ok($zip->set_number('0294387')->is_valid_number, '岩手県奥州市衣川区下大森');
ok($zip->set_number('0294388')->is_valid_number, '岩手県奥州市衣川区上大森');
ok($zip->set_number('0294389')->is_valid_number, '岩手県奥州市衣川区長板沢');
ok($zip->set_number('0294401')->is_valid_number, '岩手県奥州市衣川区張山');
ok($zip->set_number('0294402')->is_valid_number, '岩手県奥州市衣川区星屋');
ok($zip->set_number('0294403')->is_valid_number, '岩手県奥州市衣川区本田原');
ok($zip->set_number('0294404')->is_valid_number, '岩手県奥州市衣川区寺袋');
ok($zip->set_number('0294405')->is_valid_number, '岩手県奥州市衣川区桑木谷地');
ok($zip->set_number('0294406')->is_valid_number, '岩手県奥州市衣川区大坂');
ok($zip->set_number('0294407')->is_valid_number, '岩手県奥州市衣川区金成');
ok($zip->set_number('0294408')->is_valid_number, '岩手県奥州市衣川区土屋');
ok($zip->set_number('0294411')->is_valid_number, '岩手県奥州市衣川区上小路');
ok($zip->set_number('0294412')->is_valid_number, '岩手県奥州市衣川区富田');
ok($zip->set_number('0294413')->is_valid_number, '岩手県奥州市衣川区堰下');
ok($zip->set_number('0294414')->is_valid_number, '岩手県奥州市衣川区野田');
ok($zip->set_number('0294415')->is_valid_number, '岩手県奥州市衣川区向館谷起');
ok($zip->set_number('0294416')->is_valid_number, '岩手県奥州市衣川区向館');
ok($zip->set_number('0294417')->is_valid_number, '岩手県奥州市衣川区富田前');
ok($zip->set_number('0294418')->is_valid_number, '岩手県奥州市衣川区杉林');
ok($zip->set_number('0294419')->is_valid_number, '岩手県奥州市衣川区大面');
ok($zip->set_number('0294421')->is_valid_number, '岩手県奥州市衣川区日向');
ok($zip->set_number('0294422')->is_valid_number, '岩手県奥州市衣川区瀬原');
ok($zip->set_number('0294423')->is_valid_number, '岩手県奥州市衣川区瀬原西浦');
ok($zip->set_number('0294424')->is_valid_number, '岩手県奥州市衣川区九輪堂');
ok($zip->set_number('0294425')->is_valid_number, '岩手県奥州市衣川区采女沢');
ok($zip->set_number('0294426')->is_valid_number, '岩手県奥州市衣川区愛宕下');
ok($zip->set_number('0294427')->is_valid_number, '岩手県奥州市衣川区陣場下');
ok($zip->set_number('0294431')->is_valid_number, '岩手県奥州市衣川区田中');
ok($zip->set_number('0294432')->is_valid_number, '岩手県奥州市衣川区小林');
ok($zip->set_number('0294433')->is_valid_number, '岩手県奥州市衣川区池田西');
ok($zip->set_number('0294434')->is_valid_number, '岩手県奥州市衣川区池田');
ok($zip->set_number('0294435')->is_valid_number, '岩手県奥州市衣川区押切');
ok($zip->set_number('0294436')->is_valid_number, '岩手県奥州市衣川区大石ケ沢');
ok($zip->set_number('0294437')->is_valid_number, '岩手県奥州市衣川区唐金');
ok($zip->set_number('0294438')->is_valid_number, '岩手県奥州市衣川区室の木');
ok($zip->set_number('0294439')->is_valid_number, '岩手県奥州市衣川区田中西');
ok($zip->set_number('0294441')->is_valid_number, '岩手県奥州市衣川区並木前');
ok($zip->set_number('0294442')->is_valid_number, '岩手県奥州市衣川区上野');
ok($zip->set_number('0294443')->is_valid_number, '岩手県奥州市衣川区六日市場');
ok($zip->set_number('0294444')->is_valid_number, '岩手県奥州市衣川区清水の上');
ok($zip->set_number('0294445')->is_valid_number, '岩手県奥州市衣川区七日市場');
ok($zip->set_number('0294446')->is_valid_number, '岩手県奥州市衣川区川端');
ok($zip->set_number('0294451')->is_valid_number, '岩手県奥州市衣川区東裏');
ok($zip->set_number('0294452')->is_valid_number, '岩手県奥州市衣川区月山');
ok($zip->set_number('0294453')->is_valid_number, '岩手県奥州市衣川区山口');
ok($zip->set_number('0294454')->is_valid_number, '岩手県奥州市衣川区表');
ok($zip->set_number('0294455')->is_valid_number, '岩手県奥州市衣川区横道下');
ok($zip->set_number('0294456')->is_valid_number, '岩手県奥州市衣川区西裏');
ok($zip->set_number('0294461')->is_valid_number, '岩手県奥州市衣川区平');
ok($zip->set_number('0294462')->is_valid_number, '岩手県奥州市衣川区八千');
ok($zip->set_number('0294463')->is_valid_number, '岩手県奥州市衣川区葭ケ沢');
ok($zip->set_number('0294464')->is_valid_number, '岩手県奥州市衣川区前滝の沢');
ok($zip->set_number('0294465')->is_valid_number, '岩手県奥州市衣川区後滝の沢');
ok($zip->set_number('0294471')->is_valid_number, '岩手県奥州市衣川区下河内');
ok($zip->set_number('0294472')->is_valid_number, '岩手県奥州市衣川区中河内');
ok($zip->set_number('0294473')->is_valid_number, '岩手県奥州市衣川区向');
ok($zip->set_number('0294474')->is_valid_number, '岩手県奥州市衣川区上河内');
ok($zip->set_number('0294475')->is_valid_number, '岩手県奥州市衣川区中山');
ok($zip->set_number('0294481')->is_valid_number, '岩手県奥州市衣川区畦畑山');
ok($zip->set_number('0294482')->is_valid_number, '岩手県奥州市衣川区畦畑');
ok($zip->set_number('0294483')->is_valid_number, '岩手県奥州市衣川区沼野');
ok($zip->set_number('0294484')->is_valid_number, '岩手県奥州市衣川区噌味');
ok($zip->set_number('0294485')->is_valid_number, '岩手県奥州市衣川区宝塔谷地');
ok($zip->set_number('0294486')->is_valid_number, '岩手県奥州市衣川区鷹の巣');
ok($zip->set_number('0294487')->is_valid_number, '岩手県奥州市衣川区大原山');
ok($zip->set_number('0294488')->is_valid_number, '岩手県奥州市衣川区大原');
ok($zip->set_number('0294491')->is_valid_number, '岩手県奥州市衣川区上立沢');
ok($zip->set_number('0294492')->is_valid_number, '岩手県奥州市衣川区下立沢');
ok($zip->set_number('0294493')->is_valid_number, '岩手県奥州市衣川区野崎');
ok($zip->set_number('0294494')->is_valid_number, '岩手県奥州市衣川区楢原山');
ok($zip->set_number('0294495')->is_valid_number, '岩手県奥州市衣川区楢原');
ok($zip->set_number('0294496')->is_valid_number, '岩手県奥州市衣川区真打');
ok($zip->set_number('0294497')->is_valid_number, '岩手県奥州市衣川区餅転');
ok($zip->set_number('0294500')->is_valid_number, '岩手県胆沢郡金ケ崎町以下に掲載がない場合');
ok($zip->set_number('0294501')->is_valid_number, '岩手県胆沢郡金ケ崎町六原');
ok($zip->set_number('0294502')->is_valid_number, '岩手県胆沢郡金ケ崎町三ケ尻');
ok($zip->set_number('0294503')->is_valid_number, '岩手県胆沢郡金ケ崎町西根');
ok($zip->set_number('0294504')->is_valid_number, '岩手県胆沢郡金ケ崎町永沢');
ok($zip->set_number('0294505')->is_valid_number, '岩手県胆沢郡金ケ崎町永栄');
ok($zip->set_number('0295500')->is_valid_number, '岩手県和賀郡西和賀町以下に掲載がない場合');
ok($zip->set_number('0295501')->is_valid_number, '岩手県和賀郡西和賀町左草1地割~左草6地割');
ok($zip->set_number('0295501')->is_valid_number, '岩手県和賀郡西和賀町下左草77地割~下左草80地割');
ok($zip->set_number('0295502')->is_valid_number, '岩手県和賀郡西和賀町樺沢16地割、樺沢17地割');
ok($zip->set_number('0295502')->is_valid_number, '岩手県和賀郡西和賀町下前7地割~下前14地割');
ok($zip->set_number('0295502')->is_valid_number, '岩手県和賀郡西和賀町寅沢15地割');
ok($zip->set_number('0295503')->is_valid_number, '岩手県和賀郡西和賀町穴明22地割、穴明23地割');
ok($zip->set_number('0295503')->is_valid_number, '岩手県和賀郡西和賀町清水ケ野18地割');
ok($zip->set_number('0295503')->is_valid_number, '岩手県和賀郡西和賀町間木野24地割');
ok($zip->set_number('0295503')->is_valid_number, '岩手県和賀郡西和賀町湯田19地割~湯田21地割');
ok($zip->set_number('0295504')->is_valid_number, '岩手県和賀郡西和賀町槻沢25地割~槻沢28地割');
ok($zip->set_number('0295505')->is_valid_number, '岩手県和賀郡西和賀町湯本29地割、湯本30地割');
ok($zip->set_number('0295506')->is_valid_number, '岩手県和賀郡西和賀町湯之沢31地割~湯之沢35地割');
ok($zip->set_number('0295507')->is_valid_number, '岩手県和賀郡西和賀町大沓36地割');
ok($zip->set_number('0295511')->is_valid_number, '岩手県和賀郡西和賀町上野々39地割');
ok($zip->set_number('0295512')->is_valid_number, '岩手県和賀郡西和賀町川尻40地割、川尻41地割');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町甲子51地割');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町草井沢47地割');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町杉名畑44地割(その他)');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町本内46地割');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町耳取49地割');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町本屋敷48地割');
ok($zip->set_number('0295513')->is_valid_number, '岩手県和賀郡西和賀町鷲之巣50地割');
ok($zip->set_number('0295514')->is_valid_number, '岩手県和賀郡西和賀町湯川52地割、湯川53地割');
ok($zip->set_number('0295521')->is_valid_number, '岩手県和賀郡西和賀町大渡57地割');
ok($zip->set_number('0295521')->is_valid_number, '岩手県和賀郡西和賀町小繋沢54地割~小繋沢56地割');
ok($zip->set_number('0295522')->is_valid_number, '岩手県和賀郡西和賀町巣郷63地割');
ok($zip->set_number('0295522')->is_valid_number, '岩手県和賀郡西和賀町中村58地割、中村59地割');
ok($zip->set_number('0295522')->is_valid_number, '岩手県和賀郡西和賀町野々宿60地割~野々宿62地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町越中畑64地割~越中畑66地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町桂子沢75地割、桂子沢76地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町沢中73地割、沢中74地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町白木野67地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町細内68地割、細内69地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町柳沢70地割、柳沢71地割');
ok($zip->set_number('0295523')->is_valid_number, '岩手県和賀郡西和賀町芦ケ沢72地割');
ok($zip->set_number('0295611')->is_valid_number, '岩手県和賀郡西和賀町沢内新町');
ok($zip->set_number('0295612')->is_valid_number, '岩手県和賀郡西和賀町沢内大野');
ok($zip->set_number('0295613')->is_valid_number, '岩手県和賀郡西和賀町沢内前郷');
ok($zip->set_number('0295614')->is_valid_number, '岩手県和賀郡西和賀町沢内太田');
ok($zip->set_number('0295615')->is_valid_number, '岩手県和賀郡西和賀町沢内猿橋');
ok($zip->set_number('0295616')->is_valid_number, '岩手県和賀郡西和賀町沢内泉沢');
ok($zip->set_number('0295617')->is_valid_number, '岩手県和賀郡西和賀町沢内長瀬野');
ok($zip->set_number('0295618')->is_valid_number, '岩手県和賀郡西和賀町沢内両沢');
ok($zip->set_number('0295619')->is_valid_number, '岩手県和賀郡西和賀町沢内弁天');
ok($zip->set_number('0295621')->is_valid_number, '岩手県和賀郡西和賀町沢内鍵飯');
ok($zip->set_number('0295701')->is_valid_number, '岩手県和賀郡西和賀町沢内川舟');
ok($zip->set_number('0295702')->is_valid_number, '岩手県和賀郡西和賀町沢内若畑');
ok($zip->set_number('0295703')->is_valid_number, '岩手県和賀郡西和賀町沢内貝沢');
ok($zip->set_number('0300111')->is_valid_number, '青森県青森市荒川');
ok($zip->set_number('0300112')->is_valid_number, '青森県青森市八ツ役');
ok($zip->set_number('0300113')->is_valid_number, '青森県青森市第二問屋町');
ok($zip->set_number('0300121')->is_valid_number, '青森県青森市妙見');
ok($zip->set_number('0300122')->is_valid_number, '青森県青森市野尻');
ok($zip->set_number('0300123')->is_valid_number, '青森県青森市大矢沢');
ok($zip->set_number('0300124')->is_valid_number, '青森県青森市田茂木野');
ok($zip->set_number('0300125')->is_valid_number, '青森県青森市四ツ石');
ok($zip->set_number('0300131')->is_valid_number, '青森県青森市問屋町');
ok($zip->set_number('0300132')->is_valid_number, '青森県青森市横内');
ok($zip->set_number('0300133')->is_valid_number, '青森県青森市雲谷');
ok($zip->set_number('0300134')->is_valid_number, '青森県青森市合子沢');
ok($zip->set_number('0300135')->is_valid_number, '青森県青森市新町野');
ok($zip->set_number('0300136')->is_valid_number, '青森県青森市牛館');
ok($zip->set_number('0300137')->is_valid_number, '青森県青森市卸町');
ok($zip->set_number('0300141')->is_valid_number, '青森県青森市上野');
ok($zip->set_number('0300142')->is_valid_number, '青森県青森市野木');
ok($zip->set_number('0300143')->is_valid_number, '青森県青森市小畑沢');
ok($zip->set_number('0300144')->is_valid_number, '青森県青森市大別内');
ok($zip->set_number('0300145')->is_valid_number, '青森県青森市金浜');
ok($zip->set_number('0300151')->is_valid_number, '青森県青森市高田');
ok($zip->set_number('0300152')->is_valid_number, '青森県青森市野沢');
ok($zip->set_number('0300153')->is_valid_number, '青森県青森市小館');
ok($zip->set_number('0300154')->is_valid_number, '青森県青森市入内');
ok($zip->set_number('0300155')->is_valid_number, '青森県青森市大谷');
ok($zip->set_number('0300801')->is_valid_number, '青森県青森市新町');
ok($zip->set_number('0300802')->is_valid_number, '青森県青森市本町');
ok($zip->set_number('0300803')->is_valid_number, '青森県青森市安方');
ok($zip->set_number('0300811')->is_valid_number, '青森県青森市青柳');
ok($zip->set_number('0300812')->is_valid_number, '青森県青森市堤町');
ok($zip->set_number('0300813')->is_valid_number, '青森県青森市松原');
ok($zip->set_number('0300821')->is_valid_number, '青森県青森市勝田');
ok($zip->set_number('0300822')->is_valid_number, '青森県青森市中央');
ok($zip->set_number('0300823')->is_valid_number, '青森県青森市橋本');
ok($zip->set_number('0300841')->is_valid_number, '青森県青森市奥野');
ok($zip->set_number('0300842')->is_valid_number, '青森県青森市浦町');
ok($zip->set_number('0300843')->is_valid_number, '青森県青森市浜田');
ok($zip->set_number('0300844')->is_valid_number, '青森県青森市桂木');
ok($zip->set_number('0300845')->is_valid_number, '青森県青森市緑');
ok($zip->set_number('0300846')->is_valid_number, '青森県青森市青葉');
ok($zip->set_number('0300847')->is_valid_number, '青森県青森市東大野');
ok($zip->set_number('0300851')->is_valid_number, '青森県青森市旭町');
ok($zip->set_number('0300852')->is_valid_number, '青森県青森市大野');
ok($zip->set_number('0300853')->is_valid_number, '青森県青森市金沢');
ok($zip->set_number('0300854')->is_valid_number, '青森県青森市千富町');
ok($zip->set_number('0300855')->is_valid_number, '青森県青森市北金沢');
ok($zip->set_number('0300856')->is_valid_number, '青森県青森市西大野');
ok($zip->set_number('0300861')->is_valid_number, '青森県青森市長島');
ok($zip->set_number('0300862')->is_valid_number, '青森県青森市古川');
ok($zip->set_number('0300901')->is_valid_number, '青森県青森市港町');
ok($zip->set_number('0300902')->is_valid_number, '青森県青森市合浦');
ok($zip->set_number('0300903')->is_valid_number, '青森県青森市栄町');
ok($zip->set_number('0300904')->is_valid_number, '青森県青森市茶屋町');
ok($zip->set_number('0300911')->is_valid_number, '青森県青森市造道');
ok($zip->set_number('0300912')->is_valid_number, '青森県青森市八重田');
ok($zip->set_number('0300913')->is_valid_number, '青森県青森市東造道');
ok($zip->set_number('0300914')->is_valid_number, '青森県青森市岡造道');
ok($zip->set_number('0300915')->is_valid_number, '青森県青森市小柳');
ok($zip->set_number('0300916')->is_valid_number, '青森県青森市田屋敷');
ok($zip->set_number('0300917')->is_valid_number, '青森県青森市矢作');
ok($zip->set_number('0300918')->is_valid_number, '青森県青森市けやき');
ok($zip->set_number('0300919')->is_valid_number, '青森県青森市はまなす');
ok($zip->set_number('0300921')->is_valid_number, '青森県青森市原別');
ok($zip->set_number('0300922')->is_valid_number, '青森県青森市泉野');
ok($zip->set_number('0300923')->is_valid_number, '青森県青森市八幡林');
ok($zip->set_number('0300924')->is_valid_number, '青森県青森市滝沢(下川原190-1)');
ok($zip->set_number('0300925')->is_valid_number, '青森県青森市築木館');
ok($zip->set_number('0300931')->is_valid_number, '青森県青森市平新田');
ok($zip->set_number('0300932')->is_valid_number, '青森県青森市後萢');
ok($zip->set_number('0300933')->is_valid_number, '青森県青森市諏訪沢');
ok($zip->set_number('0300934')->is_valid_number, '青森県青森市戸崎');
ok($zip->set_number('0300935')->is_valid_number, '青森県青森市桑原');
ok($zip->set_number('0300936')->is_valid_number, '青森県青森市矢田前');
ok($zip->set_number('0300937')->is_valid_number, '青森県青森市本泉');
ok($zip->set_number('0300941')->is_valid_number, '青森県青森市自由ケ丘');
ok($zip->set_number('0300942')->is_valid_number, '青森県青森市沢山');
ok($zip->set_number('0300943')->is_valid_number, '青森県青森市幸畑');
ok($zip->set_number('0300944')->is_valid_number, '青森県青森市筒井');
ok($zip->set_number('0300945')->is_valid_number, '青森県青森市桜川');
ok($zip->set_number('0300946')->is_valid_number, '青森県青森市古館');
ok($zip->set_number('0300947')->is_valid_number, '青森県青森市浜館');
ok($zip->set_number('0300948')->is_valid_number, '青森県青森市虹ケ丘');
ok($zip->set_number('0300951')->is_valid_number, '青森県青森市戸山(その他)');
ok($zip->set_number('0300952')->is_valid_number, '青森県青森市戸山(赤坂)');
ok($zip->set_number('0300953')->is_valid_number, '青森県青森市駒込(蛍沢)');
ok($zip->set_number('0300954')->is_valid_number, '青森県青森市駒込(月見野)');
ok($zip->set_number('0300955')->is_valid_number, '青森県青森市駒込(その他)');
ok($zip->set_number('0300956')->is_valid_number, '青森県青森市赤坂');
ok($zip->set_number('0300957')->is_valid_number, '青森県青森市蛍沢');
ok($zip->set_number('0300958')->is_valid_number, '青森県青森市月見野');
ok($zip->set_number('0300961')->is_valid_number, '青森県青森市浪打');
ok($zip->set_number('0300962')->is_valid_number, '青森県青森市佃');
ok($zip->set_number('0300963')->is_valid_number, '青森県青森市中佃');
ok($zip->set_number('0300964')->is_valid_number, '青森県青森市南佃');
ok($zip->set_number('0300965')->is_valid_number, '青森県青森市松森');
ok($zip->set_number('0300966')->is_valid_number, '青森県青森市花園');
ok($zip->set_number('0301200')->is_valid_number, '青森県東津軽郡蓬田村以下に掲載がない場合');
ok($zip->set_number('0301201')->is_valid_number, '青森県東津軽郡蓬田村広瀬');
ok($zip->set_number('0301202')->is_valid_number, '青森県東津軽郡蓬田村瀬辺地');
ok($zip->set_number('0301203')->is_valid_number, '青森県東津軽郡蓬田村郷沢');
ok($zip->set_number('0301211')->is_valid_number, '青森県東津軽郡蓬田村蓬田');
ok($zip->set_number('0301212')->is_valid_number, '青森県東津軽郡蓬田村阿弥陀川');
ok($zip->set_number('0301213')->is_valid_number, '青森県東津軽郡蓬田村長科');
ok($zip->set_number('0301214')->is_valid_number, '青森県東津軽郡蓬田村中沢');
ok($zip->set_number('0301261')->is_valid_number, '青森県青森市四戸橋');
ok($zip->set_number('0301262')->is_valid_number, '青森県青森市後潟');
ok($zip->set_number('0301271')->is_valid_number, '青森県青森市六枚橋');
ok($zip->set_number('0301272')->is_valid_number, '青森県青森市小橋');
ok($zip->set_number('0301273')->is_valid_number, '青森県青森市左堰');
ok($zip->set_number('0301301')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田石浜');
ok($zip->set_number('0301302')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田中師');
ok($zip->set_number('0301303')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田');
ok($zip->set_number('0301304')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田南沢');
ok($zip->set_number('0301305')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田小国');
ok($zip->set_number('0301306')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田山本');
ok($zip->set_number('0301307')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田大平');
ok($zip->set_number('0301308')->is_valid_number, '青森県東津軽郡外ヶ浜町下蟹田');
ok($zip->set_number('0301309')->is_valid_number, '青森県東津軽郡外ヶ浜町上蟹田');
ok($zip->set_number('0301311')->is_valid_number, '青森県東津軽郡外ヶ浜町蟹田塩越');
ok($zip->set_number('0301400')->is_valid_number, '青森県東津軽郡外ヶ浜町以下に掲載がない場合');
ok($zip->set_number('0301402')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘');
ok($zip->set_number('0301403')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘元宇田');
ok($zip->set_number('0301404')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘弥蔵釜');
ok($zip->set_number('0301405')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘石崎沢');
ok($zip->set_number('0301411')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘根岸');
ok($zip->set_number('0301412')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘野田');
ok($zip->set_number('0301413')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘今津');
ok($zip->set_number('0301415')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘舟岡');
ok($zip->set_number('0301416')->is_valid_number, '青森県東津軽郡外ヶ浜町平舘磯山');
ok($zip->set_number('0301500')->is_valid_number, '青森県東津軽郡今別町以下に掲載がない場合');
ok($zip->set_number('0301501')->is_valid_number, '青森県東津軽郡今別町浜名');
ok($zip->set_number('0301502')->is_valid_number, '青森県東津軽郡今別町今別');
ok($zip->set_number('0301503')->is_valid_number, '青森県東津軽郡今別町村元');
ok($zip->set_number('0301504')->is_valid_number, '青森県東津軽郡今別町鍋田');
ok($zip->set_number('0301505')->is_valid_number, '青森県東津軽郡今別町大川平');
ok($zip->set_number('0301511')->is_valid_number, '青森県東津軽郡今別町山崎');
ok($zip->set_number('0301512')->is_valid_number, '青森県東津軽郡今別町大泊');
ok($zip->set_number('0301513')->is_valid_number, '青森県東津軽郡今別町袰月');
ok($zip->set_number('0301514')->is_valid_number, '青森県東津軽郡今別町砂ケ森');
ok($zip->set_number('0301515')->is_valid_number, '青森県東津軽郡今別町奥平部');
ok($zip->set_number('0301701')->is_valid_number, '青森県北津軽郡中泊町小泊袰内');
ok($zip->set_number('0301711')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩源兵衛間');
ok($zip->set_number('0301711')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩龍浜');
ok($zip->set_number('0301712')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩木落');
ok($zip->set_number('0301713')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩鎧嶋');
ok($zip->set_number('0301714')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩梹榔');
ok($zip->set_number('0301715')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩鳴神');
ok($zip->set_number('0301716')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩尻神');
ok($zip->set_number('0301717')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩川柱');
ok($zip->set_number('0301718')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩梨ノ木間');
ok($zip->set_number('0301719')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩宇鉄山');
ok($zip->set_number('0301720')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩四枚橋');
ok($zip->set_number('0301721')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩鐇泊');
ok($zip->set_number('0301722')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩上宇鉄');
ok($zip->set_number('0301723')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩元宇鉄');
ok($zip->set_number('0301724')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩釜野澤');
ok($zip->set_number('0301725')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩藤嶋');
ok($zip->set_number('0301726')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩六條間');
ok($zip->set_number('0301727')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩算用師');
ok($zip->set_number('0301728')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩中浜');
ok($zip->set_number('0301729')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩下平');
ok($zip->set_number('0301731')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩本町');
ok($zip->set_number('0301732')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩家ノ上');
ok($zip->set_number('0301733')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩新町');
ok($zip->set_number('0301734')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩増川');
ok($zip->set_number('0301735')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩緑ケ丘');
ok($zip->set_number('0301736')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩桃ケ丘');
ok($zip->set_number('0301737')->is_valid_number, '青森県東津軽郡外ヶ浜町三厩東町');
ok($zip->set_number('0310000')->is_valid_number, '青森県八戸市以下に掲載がない場合');
ok($zip->set_number('0310001')->is_valid_number, '青森県八戸市類家');
ok($zip->set_number('0310002')->is_valid_number, '青森県八戸市中居林');
ok($zip->set_number('0310003')->is_valid_number, '青森県八戸市吹上');
ok($zip->set_number('0310004')->is_valid_number, '青森県八戸市南類家');
ok($zip->set_number('0310007')->is_valid_number, '青森県八戸市櫛引(土橋)');
ok($zip->set_number('0310011')->is_valid_number, '青森県八戸市田向');
ok($zip->set_number('0310012')->is_valid_number, '青森県八戸市十日市');
ok($zip->set_number('0310013')->is_valid_number, '青森県八戸市石手洗');
ok($zip->set_number('0310021')->is_valid_number, '青森県八戸市長者');
ok($zip->set_number('0310022')->is_valid_number, '青森県八戸市糠塚');
ok($zip->set_number('0310023')->is_valid_number, '青森県八戸市是川');
ok($zip->set_number('0310031')->is_valid_number, '青森県八戸市番町');
ok($zip->set_number('0310032')->is_valid_number, '青森県八戸市三日町');
ok($zip->set_number('0310033')->is_valid_number, '青森県八戸市六日町');
ok($zip->set_number('0310034')->is_valid_number, '青森県八戸市鷹匠小路');
ok($zip->set_number('0310035')->is_valid_number, '青森県八戸市寺横町');
ok($zip->set_number('0310036')->is_valid_number, '青森県八戸市大工町');
ok($zip->set_number('0310037')->is_valid_number, '青森県八戸市鍛冶町');
ok($zip->set_number('0310038')->is_valid_number, '青森県八戸市山伏小路');
ok($zip->set_number('0310039')->is_valid_number, '青森県八戸市鳥屋部町');
ok($zip->set_number('0310041')->is_valid_number, '青森県八戸市廿三日町');
ok($zip->set_number('0310042')->is_valid_number, '青森県八戸市十三日町');
ok($zip->set_number('0310043')->is_valid_number, '青森県八戸市十六日町');
ok($zip->set_number('0310044')->is_valid_number, '青森県八戸市廿六日町');
ok($zip->set_number('0310045')->is_valid_number, '青森県八戸市本鍛冶町');
ok($zip->set_number('0310046')->is_valid_number, '青森県八戸市町組町');
ok($zip->set_number('0310047')->is_valid_number, '青森県八戸市常番町');
ok($zip->set_number('0310051')->is_valid_number, '青森県八戸市堤町');
ok($zip->set_number('0310052')->is_valid_number, '青森県八戸市本徒士町');
ok($zip->set_number('0310053')->is_valid_number, '青森県八戸市徒士町');
ok($zip->set_number('0310054')->is_valid_number, '青森県八戸市稲荷町');
ok($zip->set_number('0310055')->is_valid_number, '青森県八戸市荒町');
ok($zip->set_number('0310056')->is_valid_number, '青森県八戸市新荒町');
ok($zip->set_number('0310057')->is_valid_number, '青森県八戸市上徒士町');
ok($zip->set_number('0310058')->is_valid_number, '青森県八戸市上組町');
ok($zip->set_number('0310071')->is_valid_number, '青森県八戸市沼館');
ok($zip->set_number('0310072')->is_valid_number, '青森県八戸市城下');
ok($zip->set_number('0310073')->is_valid_number, '青森県八戸市売市');
ok($zip->set_number('0310074')->is_valid_number, '青森県八戸市馬場町');
ok($zip->set_number('0310075')->is_valid_number, '青森県八戸市内丸');
ok($zip->set_number('0310076')->is_valid_number, '青森県八戸市堀端町');
ok($zip->set_number('0310077')->is_valid_number, '青森県八戸市長根');
ok($zip->set_number('0310081')->is_valid_number, '青森県八戸市柏崎');
ok($zip->set_number('0310082')->is_valid_number, '青森県八戸市常海町');
ok($zip->set_number('0310083')->is_valid_number, '青森県八戸市窪町');
ok($zip->set_number('0310084')->is_valid_number, '青森県八戸市十八日町');
ok($zip->set_number('0310085')->is_valid_number, '青森県八戸市十一日町');
ok($zip->set_number('0310086')->is_valid_number, '青森県八戸市八日町');
ok($zip->set_number('0310087')->is_valid_number, '青森県八戸市朔日町');
ok($zip->set_number('0310088')->is_valid_number, '青森県八戸市岩泉町');
ok($zip->set_number('0310089')->is_valid_number, '青森県八戸市長横町');
ok($zip->set_number('0310111')->is_valid_number, '青森県八戸市南郷市野沢');
ok($zip->set_number('0310112')->is_valid_number, '青森県八戸市南郷大森');
ok($zip->set_number('0310113')->is_valid_number, '青森県八戸市南郷泉清水');
ok($zip->set_number('0310114')->is_valid_number, '青森県八戸市南郷中野');
ok($zip->set_number('0310115')->is_valid_number, '青森県八戸市南郷泥障作');
ok($zip->set_number('0310201')->is_valid_number, '青森県八戸市南郷頃巻沢');
ok($zip->set_number('0310202')->is_valid_number, '青森県八戸市南郷島守');
ok($zip->set_number('0310801')->is_valid_number, '青森県八戸市江陽');
ok($zip->set_number('0310802')->is_valid_number, '青森県八戸市小中野');
ok($zip->set_number('0310803')->is_valid_number, '青森県八戸市諏訪');
ok($zip->set_number('0310804')->is_valid_number, '青森県八戸市青葉');
ok($zip->set_number('0310811')->is_valid_number, '青森県八戸市新湊');
ok($zip->set_number('0310812')->is_valid_number, '青森県八戸市湊町');
ok($zip->set_number('0310813')->is_valid_number, '青森県八戸市新井田');
ok($zip->set_number('0310814')->is_valid_number, '青森県八戸市妙');
ok($zip->set_number('0310815')->is_valid_number, '青森県八戸市松館');
ok($zip->set_number('0310816')->is_valid_number, '青森県八戸市新井田西');
ok($zip->set_number('0310821')->is_valid_number, '青森県八戸市白銀');
ok($zip->set_number('0310822')->is_valid_number, '青森県八戸市白銀町');
ok($zip->set_number('0310823')->is_valid_number, '青森県八戸市湊高台');
ok($zip->set_number('0310824')->is_valid_number, '青森県八戸市旭ケ丘');
ok($zip->set_number('0310831')->is_valid_number, '青森県八戸市築港街');
ok($zip->set_number('0310832')->is_valid_number, '青森県八戸市白銀台');
ok($zip->set_number('0310833')->is_valid_number, '青森県八戸市大久保');
ok($zip->set_number('0310834')->is_valid_number, '青森県八戸市桜ケ丘');
ok($zip->set_number('0310841')->is_valid_number, '青森県八戸市鮫町');
ok($zip->set_number('0310842')->is_valid_number, '青森県八戸市岬台');
ok($zip->set_number('0310843')->is_valid_number, '青森県八戸市金浜');
ok($zip->set_number('0310844')->is_valid_number, '青森県八戸市美保野');
ok($zip->set_number('0330000')->is_valid_number, '青森県三沢市以下に掲載がない場合');
ok($zip->set_number('0330001')->is_valid_number, '青森県三沢市中央町');
ok($zip->set_number('0330011')->is_valid_number, '青森県三沢市幸町');
ok($zip->set_number('0330012')->is_valid_number, '青森県三沢市平畑');
ok($zip->set_number('0330021')->is_valid_number, '青森県三沢市岡三沢');
ok($zip->set_number('0330022')->is_valid_number, '青森県三沢市三沢');
ok($zip->set_number('0330023')->is_valid_number, '青森県三沢市下久保');
ok($zip->set_number('0330024')->is_valid_number, '青森県三沢市東岡三沢');
ok($zip->set_number('0330031')->is_valid_number, '青森県三沢市桜町');
ok($zip->set_number('0330032')->is_valid_number, '青森県三沢市緑町');
ok($zip->set_number('0330033')->is_valid_number, '青森県三沢市美野原');
ok($zip->set_number('0330034')->is_valid_number, '青森県三沢市東町');
ok($zip->set_number('0330035')->is_valid_number, '青森県三沢市松原町');
ok($zip->set_number('0330036')->is_valid_number, '青森県三沢市南町');
ok($zip->set_number('0330037')->is_valid_number, '青森県三沢市松園町');
ok($zip->set_number('0330041')->is_valid_number, '青森県三沢市大町');
ok($zip->set_number('0330042')->is_valid_number, '青森県三沢市栄町');
ok($zip->set_number('0330043')->is_valid_number, '青森県三沢市千代田町');
ok($zip->set_number('0330044')->is_valid_number, '青森県三沢市古間木山');
ok($zip->set_number('0330045')->is_valid_number, '青森県三沢市薬師町');
ok($zip->set_number('0330051')->is_valid_number, '青森県三沢市古間木');
ok($zip->set_number('0330052')->is_valid_number, '青森県三沢市本町');
ok($zip->set_number('0330053')->is_valid_number, '青森県三沢市春日台');
ok($zip->set_number('0330061')->is_valid_number, '青森県三沢市花園町');
ok($zip->set_number('0330062')->is_valid_number, '青森県三沢市新町');
ok($zip->set_number('0330063')->is_valid_number, '青森県三沢市上久保');
ok($zip->set_number('0330071')->is_valid_number, '青森県上北郡六戸町犬落瀬(内金矢、内山、岡沼、金沢、金矢、上淋代、木越、権現沢、');
ok($zip->set_number('0330071')->is_valid_number, '青森県上北郡六戸町四木、七百、下久保「174を除く」、下淋代、高森、通目木、坪毛沢「2');
ok($zip->set_number('0330071')->is_valid_number, '青森県上北郡六戸町5、637、641、643、647を除く」、中屋敷、沼久保、根古橋、堀切');
ok($zip->set_number('0330071')->is_valid_number, '青森県上北郡六戸町沢、南平、柳沢、大曲)');
ok($zip->set_number('0330072')->is_valid_number, '青森県上北郡六戸町折茂(今熊「213~234、240、247、262、266、27');
ok($zip->set_number('0330072')->is_valid_number, '青森県上北郡六戸町5、277、280、295、1199、1206、1504を除く」、');
ok($zip->set_number('0330072')->is_valid_number, '青森県上北郡六戸町大原、沖山、上折茂「1-13、71-192を除く」)');
ok($zip->set_number('0330073')->is_valid_number, '青森県上北郡六戸町金矢');
ok($zip->set_number('0330074')->is_valid_number, '青森県上北郡六戸町小松ケ丘');
ok($zip->set_number('0330101')->is_valid_number, '青森県三沢市天ケ森');
ok($zip->set_number('0330102')->is_valid_number, '青森県三沢市砂森');
ok($zip->set_number('0330103')->is_valid_number, '青森県三沢市塩釜');
ok($zip->set_number('0330104')->is_valid_number, '青森県三沢市織笠');
ok($zip->set_number('0330105')->is_valid_number, '青森県三沢市新森');
ok($zip->set_number('0330111')->is_valid_number, '青森県三沢市六川目');
ok($zip->set_number('0330112')->is_valid_number, '青森県三沢市細谷');
ok($zip->set_number('0330113')->is_valid_number, '青森県三沢市淋代');
ok($zip->set_number('0330123')->is_valid_number, '青森県三沢市堀口');
ok($zip->set_number('0330131')->is_valid_number, '青森県三沢市五川目');
ok($zip->set_number('0330132')->is_valid_number, '青森県三沢市四川目');
ok($zip->set_number('0330133')->is_valid_number, '青森県三沢市鹿中');
ok($zip->set_number('0330134')->is_valid_number, '青森県三沢市大津');
ok($zip->set_number('0330141')->is_valid_number, '青森県三沢市港町');
ok($zip->set_number('0330142')->is_valid_number, '青森県三沢市三川目');
ok($zip->set_number('0330143')->is_valid_number, '青森県三沢市前平');
ok($zip->set_number('0330151')->is_valid_number, '青森県三沢市南山');
ok($zip->set_number('0330152')->is_valid_number, '青森県三沢市深谷');
ok($zip->set_number('0330153')->is_valid_number, '青森県三沢市泉町');
ok($zip->set_number('0330154')->is_valid_number, '青森県三沢市日の出');
ok($zip->set_number('0330155')->is_valid_number, '青森県三沢市さつきヶ丘');
ok($zip->set_number('0330161')->is_valid_number, '青森県三沢市八幡');
ok($zip->set_number('0330162')->is_valid_number, '青森県三沢市越下');
ok($zip->set_number('0330163')->is_valid_number, '青森県三沢市富崎');
ok($zip->set_number('0330164')->is_valid_number, '青森県三沢市谷地頭');
ok($zip->set_number('0330165')->is_valid_number, '青森県三沢市高野沢');
ok($zip->set_number('0330166')->is_valid_number, '青森県三沢市朝日');
ok($zip->set_number('0330167')->is_valid_number, '青森県三沢市根井');
ok($zip->set_number('0340000')->is_valid_number, '青森県十和田市以下に掲載がない場合');
ok($zip->set_number('0340001')->is_valid_number, '青森県十和田市三本木');
ok($zip->set_number('0340002')->is_valid_number, '青森県十和田市元町西');
ok($zip->set_number('0340003')->is_valid_number, '青森県十和田市元町東');
ok($zip->set_number('0340004')->is_valid_number, '青森県十和田市ひがしの');
ok($zip->set_number('0340005')->is_valid_number, '青森県十和田市一本木沢');
ok($zip->set_number('0340011')->is_valid_number, '青森県十和田市稲生町');
ok($zip->set_number('0340012')->is_valid_number, '青森県十和田市東一番町');
ok($zip->set_number('0340013')->is_valid_number, '青森県十和田市東十一番町');
ok($zip->set_number('0340014')->is_valid_number, '青森県十和田市東二十一番町');
ok($zip->set_number('0340015')->is_valid_number, '青森県十和田市東二十二番町');
ok($zip->set_number('0340016')->is_valid_number, '青森県十和田市東十二番町');
ok($zip->set_number('0340017')->is_valid_number, '青森県十和田市東二番町');
ok($zip->set_number('0340021')->is_valid_number, '青森県十和田市東二十三番町');
ok($zip->set_number('0340022')->is_valid_number, '青森県十和田市東二十四番町');
ok($zip->set_number('0340023')->is_valid_number, '青森県十和田市東十三番町');
ok($zip->set_number('0340024')->is_valid_number, '青森県十和田市東十四番町');
ok($zip->set_number('0340031')->is_valid_number, '青森県十和田市東三番町');
ok($zip->set_number('0340032')->is_valid_number, '青森県十和田市東四番町');
ok($zip->set_number('0340033')->is_valid_number, '青森県十和田市東五番町');
ok($zip->set_number('0340034')->is_valid_number, '青森県十和田市東十五番町');
ok($zip->set_number('0340035')->is_valid_number, '青森県十和田市東十六番町');
ok($zip->set_number('0340036')->is_valid_number, '青森県十和田市東六番町');
ok($zip->set_number('0340037')->is_valid_number, '青森県十和田市穂並町');
ok($zip->set_number('0340038')->is_valid_number, '青森県十和田市西六番町');
ok($zip->set_number('0340041')->is_valid_number, '青森県十和田市相坂');
ok($zip->set_number('0340051')->is_valid_number, '青森県十和田市伝法寺');
ok($zip->set_number('0340052')->is_valid_number, '青森県十和田市藤島');
ok($zip->set_number('0340061')->is_valid_number, '青森県十和田市切田');
ok($zip->set_number('0340071')->is_valid_number, '青森県十和田市赤沼');
ok($zip->set_number('0340081')->is_valid_number, '青森県十和田市西十三番町');
ok($zip->set_number('0340082')->is_valid_number, '青森県十和田市西二番町');
ok($zip->set_number('0340083')->is_valid_number, '青森県十和田市西三番町');
ok($zip->set_number('0340084')->is_valid_number, '青森県十和田市西四番町');
ok($zip->set_number('0340085')->is_valid_number, '青森県十和田市西五番町');
ok($zip->set_number('0340086')->is_valid_number, '青森県十和田市西十六番町');
ok($zip->set_number('0340087')->is_valid_number, '青森県十和田市西十五番町');
ok($zip->set_number('0340088')->is_valid_number, '青森県十和田市西十四番町');
ok($zip->set_number('0340089')->is_valid_number, '青森県十和田市西二十三番町');
ok($zip->set_number('0340091')->is_valid_number, '青森県十和田市西十一番町');
ok($zip->set_number('0340092')->is_valid_number, '青森県十和田市西一番町');
ok($zip->set_number('0340093')->is_valid_number, '青森県十和田市西十二番町');
ok($zip->set_number('0340094')->is_valid_number, '青森県十和田市西二十二番町');
ok($zip->set_number('0340095')->is_valid_number, '青森県十和田市西二十一番町');
ok($zip->set_number('0340101')->is_valid_number, '青森県十和田市馬洗場');
ok($zip->set_number('0340102')->is_valid_number, '青森県十和田市大沢田');
ok($zip->set_number('0340103')->is_valid_number, '青森県十和田市立崎');
ok($zip->set_number('0340104')->is_valid_number, '青森県十和田市豊ケ岡');
ok($zip->set_number('0340105')->is_valid_number, '青森県十和田市八斗沢');
ok($zip->set_number('0340106')->is_valid_number, '青森県十和田市深持');
ok($zip->set_number('0340107')->is_valid_number, '青森県十和田市洞内');
ok($zip->set_number('0340211')->is_valid_number, '青森県十和田市大不動');
ok($zip->set_number('0340212')->is_valid_number, '青森県十和田市米田');
ok($zip->set_number('0340213')->is_valid_number, '青森県十和田市滝沢');
ok($zip->set_number('0340301')->is_valid_number, '青森県十和田市奥瀬(その他)');
ok($zip->set_number('0340302')->is_valid_number, '青森県十和田市沢田');
ok($zip->set_number('0340303')->is_valid_number, '青森県十和田市法量');
ok($zip->set_number('0350000')->is_valid_number, '青森県むつ市以下に掲載がない場合');
ok($zip->set_number('0350000')->is_valid_number, '青森県下北郡東通村以下に掲載がない場合');
ok($zip->set_number('0350001')->is_valid_number, '青森県下北郡東通村大利');
ok($zip->set_number('0350002')->is_valid_number, '青森県下北郡東通村目名');
ok($zip->set_number('0350003')->is_valid_number, '青森県下北郡東通村野牛(稲崎平302番地・315番地、トクサ沢)');
ok($zip->set_number('0350004')->is_valid_number, '青森県下北郡東通村蒲野沢(その他)');
ok($zip->set_number('0350005')->is_valid_number, '青森県下北郡東通村田屋');
ok($zip->set_number('0350011')->is_valid_number, '青森県むつ市奥内');
ok($zip->set_number('0350012')->is_valid_number, '青森県むつ市中野沢');
ok($zip->set_number('0350021')->is_valid_number, '青森県むつ市田名部');
ok($zip->set_number('0350022')->is_valid_number, '青森県むつ市関根');
ok($zip->set_number('0350031')->is_valid_number, '青森県むつ市柳町');
ok($zip->set_number('0350032')->is_valid_number, '青森県むつ市上川町');
ok($zip->set_number('0350033')->is_valid_number, '青森県むつ市横迎町');
ok($zip->set_number('0350034')->is_valid_number, '青森県むつ市田名部町');
ok($zip->set_number('0350035')->is_valid_number, '青森県むつ市本町');
ok($zip->set_number('0350036')->is_valid_number, '青森県むつ市栗山町');
ok($zip->set_number('0350041')->is_valid_number, '青森県むつ市金曲');
ok($zip->set_number('0350042')->is_valid_number, '青森県むつ市大曲');
ok($zip->set_number('0350043')->is_valid_number, '青森県むつ市南赤川町');
ok($zip->set_number('0350044')->is_valid_number, '青森県むつ市赤川町');
ok($zip->set_number('0350045')->is_valid_number, '青森県むつ市松原町');
ok($zip->set_number('0350046')->is_valid_number, '青森県むつ市南町');
ok($zip->set_number('0350051')->is_valid_number, '青森県むつ市新町');
ok($zip->set_number('0350052')->is_valid_number, '青森県むつ市昭和町');
ok($zip->set_number('0350053')->is_valid_number, '青森県むつ市緑町');
ok($zip->set_number('0350054')->is_valid_number, '青森県むつ市海老川町');
ok($zip->set_number('0350055')->is_valid_number, '青森県むつ市苫生町');
ok($zip->set_number('0350061')->is_valid_number, '青森県むつ市下北町');
ok($zip->set_number('0350062')->is_valid_number, '青森県むつ市仲町');
ok($zip->set_number('0350063')->is_valid_number, '青森県むつ市若松町');
ok($zip->set_number('0350064')->is_valid_number, '青森県むつ市港町');
ok($zip->set_number('0350065')->is_valid_number, '青森県むつ市松山町');
ok($zip->set_number('0350066')->is_valid_number, '青森県むつ市緑ヶ丘');
ok($zip->set_number('0350067')->is_valid_number, '青森県むつ市十二林');
ok($zip->set_number('0350068')->is_valid_number, '青森県むつ市美里町');
ok($zip->set_number('0350071')->is_valid_number, '青森県むつ市小川町');
ok($zip->set_number('0350072')->is_valid_number, '青森県むつ市金谷');
ok($zip->set_number('0350073')->is_valid_number, '青森県むつ市中央');
ok($zip->set_number('0350074')->is_valid_number, '青森県むつ市大平');
ok($zip->set_number('0350075')->is_valid_number, '青森県むつ市真砂町');
ok($zip->set_number('0350076')->is_valid_number, '青森県むつ市旭町');
ok($zip->set_number('0350077')->is_valid_number, '青森県むつ市山田町');
ok($zip->set_number('0350078')->is_valid_number, '青森県むつ市松森町');
ok($zip->set_number('0350079')->is_valid_number, '青森県むつ市荒川町');
ok($zip->set_number('0350081')->is_valid_number, '青森県むつ市並川町');
ok($zip->set_number('0350082')->is_valid_number, '青森県むつ市文京町');
ok($zip->set_number('0350083')->is_valid_number, '青森県むつ市大平町');
ok($zip->set_number('0350084')->is_valid_number, '青森県むつ市大湊新町');
ok($zip->set_number('0350085')->is_valid_number, '青森県むつ市大湊浜町');
ok($zip->set_number('0350086')->is_valid_number, '青森県むつ市大湊上町');
ok($zip->set_number('0350091')->is_valid_number, '青森県むつ市川守町');
ok($zip->set_number('0350092')->is_valid_number, '青森県むつ市宇田町');
ok($zip->set_number('0350093')->is_valid_number, '青森県むつ市大湊町');
ok($zip->set_number('0350094')->is_valid_number, '青森県むつ市桜木町');
ok($zip->set_number('0350095')->is_valid_number, '青森県むつ市城ケ沢');
ok($zip->set_number('0350096')->is_valid_number, '青森県むつ市大湊');
ok($zip->set_number('0350103')->is_valid_number, '青森県下北郡東通村野牛(その他)');
ok($zip->set_number('0350104')->is_valid_number, '青森県下北郡東通村蒲野沢(稲崎、浜の平)');
ok($zip->set_number('0350111')->is_valid_number, '青森県下北郡東通村尻屋');
ok($zip->set_number('0350112')->is_valid_number, '青森県下北郡東通村尻労');
ok($zip->set_number('0350113')->is_valid_number, '青森県下北郡東通村岩屋');
ok($zip->set_number('0360000')->is_valid_number, '青森県弘前市以下に掲載がない場合');
ok($zip->set_number('0360100')->is_valid_number, '青森県平川市以下に掲載がない場合');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺一滝本');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺一村井');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺一早稲田');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺稲田');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺稲村');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺川原田');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺三滝本');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺三村井');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺三早稲田');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺釈迦口');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺白山');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺種元');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺西稲村');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺二滝本');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺二村井');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺二早稲田');
ok($zip->set_number('0360101')->is_valid_number, '青森県平川市大光寺四滝本');
ok($zip->set_number('0360102')->is_valid_number, '青森県平川市光城');
ok($zip->set_number('0360103')->is_valid_number, '青森県平川市本町北柳田');
ok($zip->set_number('0360103')->is_valid_number, '青森県平川市本町富岡');
ok($zip->set_number('0360103')->is_valid_number, '青森県平川市本町西宮');
ok($zip->set_number('0360103')->is_valid_number, '青森県平川市本町平野');
ok($zip->set_number('0360103')->is_valid_number, '青森県平川市本町南柳田');
ok($zip->set_number('0360103')->is_valid_number, '青森県平川市本町村元');
ok($zip->set_number('0360104')->is_valid_number, '青森県平川市柏木町東田');
ok($zip->set_number('0360104')->is_valid_number, '青森県平川市柏木町広田');
ok($zip->set_number('0360104')->is_valid_number, '青森県平川市柏木町藤山');
ok($zip->set_number('0360104')->is_valid_number, '青森県平川市柏木町柳田');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森上田川');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森上平田');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森上松岡');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森下田川');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森下平田');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森下松岡');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森種取');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森中松岡');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森福田');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森松川');
ok($zip->set_number('0360111')->is_valid_number, '青森県平川市小和森松村');
ok($zip->set_number('0360112')->is_valid_number, '青森県平川市荒田上駒田');
ok($zip->set_number('0360112')->is_valid_number, '青森県平川市荒田北稲村');
ok($zip->set_number('0360112')->is_valid_number, '青森県平川市荒田北岡部');
ok($zip->set_number('0360112')->is_valid_number, '青森県平川市荒田下駒田');
ok($zip->set_number('0360112')->is_valid_number, '青森県平川市荒田南稲村');
ok($zip->set_number('0360112')->is_valid_number, '青森県平川市荒田南岡部');
ok($zip->set_number('0360113')->is_valid_number, '青森県平川市平田森稲村');
ok($zip->set_number('0360113')->is_valid_number, '青森県平川市平田森上宮本');
ok($zip->set_number('0360113')->is_valid_number, '青森県平川市平田森下宮本');
ok($zip->set_number('0360113')->is_valid_number, '青森県平川市平田森前田');
ok($zip->set_number('0360113')->is_valid_number, '青森県平川市平田森若松');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居稲村');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居稲元');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居西田');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居南田');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居山下');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居山元');
ok($zip->set_number('0360114')->is_valid_number, '青森県平川市町居横山');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館後野');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館柏崎');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館駒泊');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館島村');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館野木和');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館東山');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館藤巻');
ok($zip->set_number('0360115')->is_valid_number, '青森県平川市新館藤山');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋稲村');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋長田');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋栄館');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋滝の沢');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋富山');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋平岡');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋平野');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋福嶋');
ok($zip->set_number('0360121')->is_valid_number, '青森県平川市新屋山下');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎浅井');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎稲元');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎岡田');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎川合');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎木戸口');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎里見');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎沢部');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎平山');
ok($zip->set_number('0360122')->is_valid_number, '青森県平川市尾崎安田');
ok($zip->set_number('0360131')->is_valid_number, '青森県平川市広船広沢');
ok($zip->set_number('0360131')->is_valid_number, '青森県平川市広船福田');
ok($zip->set_number('0360131')->is_valid_number, '青森県平川市広船山下');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹芦毛沢');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹阿蘇獄');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹井沢');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹苺原');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹川原田');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹小金森');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹小松原');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹高田');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹平山');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹堀合');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹水上');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹向川原田');
ok($zip->set_number('0360132')->is_valid_number, '青森県平川市唐竹薬師沢');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館長田');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館沢田');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館高田');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館永田');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館西田');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館比山館');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館宮崎');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館向野');
ok($zip->set_number('0360141')->is_valid_number, '青森県平川市沖館和田');
ok($zip->set_number('0360142')->is_valid_number, '青森県平川市高畑熊沢');
ok($zip->set_number('0360142')->is_valid_number, '青森県平川市高畑高田');
ok($zip->set_number('0360142')->is_valid_number, '青森県平川市高畑前田');
ok($zip->set_number('0360143')->is_valid_number, '青森県平川市吹上高田');
ok($zip->set_number('0360143')->is_valid_number, '青森県平川市吹上平岡');
ok($zip->set_number('0360143')->is_valid_number, '青森県平川市吹上安田');
ok($zip->set_number('0360144')->is_valid_number, '青森県平川市原田稲元');
ok($zip->set_number('0360144')->is_valid_number, '青森県平川市原田今井');
ok($zip->set_number('0360144')->is_valid_number, '青森県平川市原田沢田');
ok($zip->set_number('0360144')->is_valid_number, '青森県平川市原田村元');
ok($zip->set_number('0360145')->is_valid_number, '青森県平川市岩館長田');
ok($zip->set_number('0360145')->is_valid_number, '青森県平川市岩館下り松');
ok($zip->set_number('0360145')->is_valid_number, '青森県平川市岩館藤巻');
ok($zip->set_number('0360145')->is_valid_number, '青森県平川市岩館村元');
ok($zip->set_number('0360145')->is_valid_number, '青森県平川市岩館山の井');
ok($zip->set_number('0360146')->is_valid_number, '青森県平川市大坊竹内');
ok($zip->set_number('0360146')->is_valid_number, '青森県平川市大坊竹原');
ok($zip->set_number('0360146')->is_valid_number, '青森県平川市大坊福田');
ok($zip->set_number('0360146')->is_valid_number, '青森県平川市大坊前田');
ok($zip->set_number('0360151')->is_valid_number, '青森県平川市石郷沖中');
ok($zip->set_number('0360151')->is_valid_number, '青森県平川市石郷村元');
ok($zip->set_number('0360151')->is_valid_number, '青森県平川市石郷柳田');
ok($zip->set_number('0360152')->is_valid_number, '青森県平川市石畑岡元');
ok($zip->set_number('0360153')->is_valid_number, '青森県平川市小杉稲村');
ok($zip->set_number('0360153')->is_valid_number, '青森県平川市小杉扇田');
ok($zip->set_number('0360153')->is_valid_number, '青森県平川市小杉川崎');
ok($zip->set_number('0360153')->is_valid_number, '青森県平川市小杉竹内');
ok($zip->set_number('0360153')->is_valid_number, '青森県平川市小杉西田');
ok($zip->set_number('0360154')->is_valid_number, '青森県平川市四ツ屋亀田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田稲村');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田中前田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田西川原田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田西和田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田東稲村');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田東前田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田東和田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田前田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田南川原田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田元川原田');
ok($zip->set_number('0360155')->is_valid_number, '青森県平川市館田柳原');
ok($zip->set_number('0360161')->is_valid_number, '青森県平川市杉館滝元');
ok($zip->set_number('0360161')->is_valid_number, '青森県平川市杉館松橋');
ok($zip->set_number('0360161')->is_valid_number, '青森県平川市杉館宮元');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山板橋');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山上扇田');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山上亀岡');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山川合');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山下扇田');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山下亀岡');
ok($zip->set_number('0360162')->is_valid_number, '青森県平川市館山前田');
ok($zip->set_number('0360163')->is_valid_number, '青森県平川市苗生松一本柳');
ok($zip->set_number('0360163')->is_valid_number, '青森県平川市苗生松上東田');
ok($zip->set_number('0360163')->is_valid_number, '青森県平川市苗生松川崎');
ok($zip->set_number('0360163')->is_valid_number, '青森県平川市苗生松川原田');
ok($zip->set_number('0360163')->is_valid_number, '青森県平川市苗生松下東田');
ok($zip->set_number('0360163')->is_valid_number, '青森県平川市苗生松元東田');
ok($zip->set_number('0360164')->is_valid_number, '青森県平川市松崎亀井');
ok($zip->set_number('0360164')->is_valid_number, '青森県平川市松崎西田');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館浅井');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館井ノ上');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館西稲村');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館西川原田');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館東稲村');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館東川原田');
ok($zip->set_number('0360165')->is_valid_number, '青森県平川市松館松元');
ok($zip->set_number('0360171')->is_valid_number, '青森県平川市小国浅瀬石山');
ok($zip->set_number('0360171')->is_valid_number, '青森県平川市小国川辺');
ok($zip->set_number('0360171')->is_valid_number, '青森県平川市小国川原田');
ok($zip->set_number('0360171')->is_valid_number, '青森県平川市小国深沢');
ok($zip->set_number('0360171')->is_valid_number, '青森県平川市小国山下');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川浅瀬石山');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川一本木平');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川大川添');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川折戸');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川上の平');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川唐川平');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川葛川沢');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川葛川平');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川葛川出口');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川毛無森');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川砂子沢');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川田の沢口');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川長小股');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川平六沢上');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川平六村下');
ok($zip->set_number('0360172')->is_valid_number, '青森県平川市葛川家岸');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明浅瀬石山');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明上井戸');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明誉田邸');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明坂本');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明滝の森');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明滝候沢');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明津根川森');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明温川沢');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明温川森');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明螢沢');
ok($zip->set_number('0360173')->is_valid_number, '青森県平川市切明山下');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平上安原');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平上山崎');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平北豊田');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平下安原');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平西豊田');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平西山崎');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平西和田');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平東豊田');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平東和田');
ok($zip->set_number('0360201')->is_valid_number, '青森県平川市李平南豊田');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋上松元');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋上早稲田');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋下松元');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋下早稲田');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋中松元');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋中早稲田');
ok($zip->set_number('0360202')->is_valid_number, '青森県平川市金屋西松元');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中北林元');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中北原');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中北細田');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中北村井');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中中村井');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中西林元');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中西原');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中東林元');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中南林元');
ok($zip->set_number('0360203')->is_valid_number, '青森県平川市南田中村内');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木岡崎');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木岡田');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木岡部');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木豊岡');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木豊田');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木原田');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木原富');
ok($zip->set_number('0360211')->is_valid_number, '青森県平川市高木松元');
ok($zip->set_number('0360212')->is_valid_number, '青森県平川市尾上栄松');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町上沢田');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町北鶉野');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町下沢田');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町田川');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町松居');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町松下');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町松久');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町道ノ下');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町南鶉野');
ok($zip->set_number('0360213')->is_valid_number, '青森県平川市新屋町村元');
ok($zip->set_number('0360221')->is_valid_number, '青森県平川市中佐渡石田');
ok($zip->set_number('0360221')->is_valid_number, '青森県平川市中佐渡鎌田');
ok($zip->set_number('0360221')->is_valid_number, '青森県平川市中佐渡前田');
ok($zip->set_number('0360221')->is_valid_number, '青森県平川市中佐渡南田');
ok($zip->set_number('0360221')->is_valid_number, '青森県平川市中佐渡村元');
ok($zip->set_number('0360222')->is_valid_number, '青森県平川市長田沼田');
ok($zip->set_number('0360222')->is_valid_number, '青森県平川市長田野田');
ok($zip->set_number('0360222')->is_valid_number, '青森県平川市長田村下');
ok($zip->set_number('0360222')->is_valid_number, '青森県平川市長田元村');
ok($zip->set_number('0360223')->is_valid_number, '青森県平川市西野曽江川崎');
ok($zip->set_number('0360223')->is_valid_number, '青森県平川市西野曽江橋元');
ok($zip->set_number('0360223')->is_valid_number, '青森県平川市西野曽江広田');
ok($zip->set_number('0360231')->is_valid_number, '青森県平川市新山岡部');
ok($zip->set_number('0360231')->is_valid_number, '青森県平川市新山松橋');
ok($zip->set_number('0360231')->is_valid_number, '青森県平川市新山村元');
ok($zip->set_number('0360231')->is_valid_number, '青森県平川市新山柳田');
ok($zip->set_number('0360231')->is_valid_number, '青森県平川市新山早稲田');
ok($zip->set_number('0360232')->is_valid_number, '青森県平川市蒲田一本松');
ok($zip->set_number('0360232')->is_valid_number, '青森県平川市蒲田玉田');
ok($zip->set_number('0360232')->is_valid_number, '青森県平川市蒲田豊田');
ok($zip->set_number('0360232')->is_valid_number, '青森県平川市蒲田豊富');
ok($zip->set_number('0360232')->is_valid_number, '青森県平川市蒲田三原');
ok($zip->set_number('0360232')->is_valid_number, '青森県平川市蒲田元宮');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼一本柳');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼河原田');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼下川原');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼下袋');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼李田');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼高田');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼塚越');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼樋田');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼富田');
ok($zip->set_number('0360233')->is_valid_number, '青森県平川市日沼富岳');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎高野');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎高原');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎本林');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎松枝');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎松橋');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎宮田');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎宮本');
ok($zip->set_number('0360241')->is_valid_number, '青森県平川市八幡崎本宮');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀浅井');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀浅田');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀池上');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀池田');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀石林');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀上岡');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀上川');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀下岡');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀下川');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀下野');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀遠林');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀富岡');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀平塚');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀松枝');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀南田');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀南野');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀明堂');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀安岡');
ok($zip->set_number('0360242')->is_valid_number, '青森県平川市猿賀安田');
ok($zip->set_number('0360243')->is_valid_number, '青森県平川市原大野');
ok($zip->set_number('0360243')->is_valid_number, '青森県平川市原上原');
ok($zip->set_number('0360243')->is_valid_number, '青森県平川市原北原');
ok($zip->set_number('0360300')->is_valid_number, '青森県黒石市以下に掲載がない場合');
ok($zip->set_number('0360301')->is_valid_number, '青森県黒石市一番町');
ok($zip->set_number('0360302')->is_valid_number, '青森県黒石市油横丁');
ok($zip->set_number('0360303')->is_valid_number, '青森県黒石市株梗木横丁');
ok($zip->set_number('0360304')->is_valid_number, '青森県黒石市甲徳兵衛町');
ok($zip->set_number('0360305')->is_valid_number, '青森県黒石市乙徳兵衛町');
ok($zip->set_number('0360306')->is_valid_number, '青森県黒石市内町');
ok($zip->set_number('0360307')->is_valid_number, '青森県黒石市市ノ町');
ok($zip->set_number('0360308')->is_valid_number, '青森県黒石市寺小路');
ok($zip->set_number('0360311')->is_valid_number, '青森県黒石市吉乃町');
ok($zip->set_number('0360312')->is_valid_number, '青森県黒石市昭和町');
ok($zip->set_number('0360313')->is_valid_number, '青森県黒石市松葉町');
ok($zip->set_number('0360314')->is_valid_number, '青森県黒石市道北町');
ok($zip->set_number('0360315')->is_valid_number, '青森県黒石市寿町');
ok($zip->set_number('0360316')->is_valid_number, '青森県黒石市ぐみの木');
ok($zip->set_number('0360317')->is_valid_number, '青森県黒石市住吉町');
ok($zip->set_number('0360318')->is_valid_number, '青森県黒石市岩木町');
ok($zip->set_number('0360321')->is_valid_number, '青森県黒石市あけぼの町');
ok($zip->set_number('0360322')->is_valid_number, '青森県黒石市竹田町');
ok($zip->set_number('0360323')->is_valid_number, '青森県黒石市上十川');
ok($zip->set_number('0360324')->is_valid_number, '青森県黒石市東野添');
ok($zip->set_number('0360325')->is_valid_number, '青森県黒石市青山');
ok($zip->set_number('0360326')->is_valid_number, '青森県黒石市野添町');
ok($zip->set_number('0360331')->is_valid_number, '青森県黒石市八甲');
ok($zip->set_number('0360332')->is_valid_number, '青森県黒石市牡丹平');
ok($zip->set_number('0360333')->is_valid_number, '青森県黒石市柵ノ木');
ok($zip->set_number('0360334')->is_valid_number, '青森県黒石市東新町');
ok($zip->set_number('0360335')->is_valid_number, '青森県黒石市幸町');
ok($zip->set_number('0360336')->is_valid_number, '青森県黒石市桜木町');
ok($zip->set_number('0360337')->is_valid_number, '青森県黒石市角田');
ok($zip->set_number('0360338')->is_valid_number, '青森県黒石市春日町');
ok($zip->set_number('0360339')->is_valid_number, '青森県黒石市美原町');
ok($zip->set_number('0360341')->is_valid_number, '青森県黒石市豊岡');
ok($zip->set_number('0360342')->is_valid_number, '青森県黒石市石名坂');
ok($zip->set_number('0360343')->is_valid_number, '青森県黒石市浅瀬石');
ok($zip->set_number('0360344')->is_valid_number, '青森県黒石市高賀野');
ok($zip->set_number('0360345')->is_valid_number, '青森県黒石市中川');
ok($zip->set_number('0360351')->is_valid_number, '青森県黒石市黒石');
ok($zip->set_number('0360352')->is_valid_number, '青森県黒石市甲大工町');
ok($zip->set_number('0360353')->is_valid_number, '青森県黒石市乙大工町');
ok($zip->set_number('0360354')->is_valid_number, '青森県黒石市後大工町');
ok($zip->set_number('0360355')->is_valid_number, '青森県黒石市袋井');
ok($zip->set_number('0360356')->is_valid_number, '青森県黒石市ちとせ');
ok($zip->set_number('0360357')->is_valid_number, '青森県黒石市追子野木');
ok($zip->set_number('0360361')->is_valid_number, '青森県黒石市弥生町');
ok($zip->set_number('0360362')->is_valid_number, '青森県黒石市京町');
ok($zip->set_number('0360363')->is_valid_number, '青森県黒石市鍛治町');
ok($zip->set_number('0360364')->is_valid_number, '青森県黒石市山形町');
ok($zip->set_number('0360365')->is_valid_number, '青森県黒石市長崎');
ok($zip->set_number('0360366')->is_valid_number, '青森県黒石市浦町');
ok($zip->set_number('0360367')->is_valid_number, '青森県黒石市前町');
ok($zip->set_number('0360368')->is_valid_number, '青森県黒石市横町');
ok($zip->set_number('0360371')->is_valid_number, '青森県黒石市花園町');
ok($zip->set_number('0360372')->is_valid_number, '青森県黒石市錦町');
ok($zip->set_number('0360373')->is_valid_number, '青森県黒石市東町');
ok($zip->set_number('0360374')->is_valid_number, '青森県黒石市泉町');
ok($zip->set_number('0360375')->is_valid_number, '青森県黒石市若葉町');
ok($zip->set_number('0360376')->is_valid_number, '青森県黒石市旭町');
ok($zip->set_number('0360377')->is_valid_number, '青森県黒石市中町');
ok($zip->set_number('0360378')->is_valid_number, '青森県黒石市浜町');
ok($zip->set_number('0360381')->is_valid_number, '青森県黒石市株梗木');
ok($zip->set_number('0360382')->is_valid_number, '青森県黒石市作場町');
ok($zip->set_number('0360383')->is_valid_number, '青森県黒石市緑町');
ok($zip->set_number('0360384')->is_valid_number, '青森県黒石市大町');
ok($zip->set_number('0360385')->is_valid_number, '青森県黒石市大板町');
ok($zip->set_number('0360386')->is_valid_number, '青森県黒石市上町');
ok($zip->set_number('0360387')->is_valid_number, '青森県黒石市元町');
ok($zip->set_number('0360388')->is_valid_number, '青森県黒石市西ケ丘');
ok($zip->set_number('0360389')->is_valid_number, '青森県黒石市境松');
ok($zip->set_number('0360401')->is_valid_number, '青森県黒石市大川原');
ok($zip->set_number('0360402')->is_valid_number, '青森県黒石市沖浦');
ok($zip->set_number('0360403')->is_valid_number, '青森県黒石市二庄内');
ok($zip->set_number('0360404')->is_valid_number, '青森県黒石市板留');
ok($zip->set_number('0360405')->is_valid_number, '青森県黒石市南中野');
ok($zip->set_number('0360411')->is_valid_number, '青森県黒石市温湯');
ok($zip->set_number('0360412')->is_valid_number, '青森県黒石市袋');
ok($zip->set_number('0360413')->is_valid_number, '青森県黒石市花巻');
ok($zip->set_number('0360414')->is_valid_number, '青森県黒石市下山形');
ok($zip->set_number('0360415')->is_valid_number, '青森県黒石市上山形');
ok($zip->set_number('0360501')->is_valid_number, '青森県黒石市東馬場尻');
ok($zip->set_number('0360502')->is_valid_number, '青森県黒石市馬場尻北');
ok($zip->set_number('0360503')->is_valid_number, '青森県黒石市馬場尻下');
ok($zip->set_number('0360504')->is_valid_number, '青森県黒石市馬場尻東');
ok($zip->set_number('0360505')->is_valid_number, '青森県黒石市馬場尻南');
ok($zip->set_number('0360506')->is_valid_number, '青森県黒石市馬場尻西');
ok($zip->set_number('0360507')->is_valid_number, '青森県黒石市西馬場尻');
ok($zip->set_number('0360511')->is_valid_number, '青森県黒石市小屋敷');
ok($zip->set_number('0360512')->is_valid_number, '青森県黒石市小屋敷南');
ok($zip->set_number('0360513')->is_valid_number, '青森県黒石市小屋敷西');
ok($zip->set_number('0360514')->is_valid_number, '青森県黒石市富田');
ok($zip->set_number('0360515')->is_valid_number, '青森県黒石市富士見');
ok($zip->set_number('0360516')->is_valid_number, '青森県黒石市相野');
ok($zip->set_number('0360517')->is_valid_number, '青森県黒石市松原');
ok($zip->set_number('0360521')->is_valid_number, '青森県黒石市末広');
ok($zip->set_number('0360522')->is_valid_number, '青森県黒石市田中');
ok($zip->set_number('0360523')->is_valid_number, '青森県黒石市北田中');
ok($zip->set_number('0360524')->is_valid_number, '青森県黒石市緑ケ丘');
ok($zip->set_number('0360531')->is_valid_number, '青森県黒石市飛内');
ok($zip->set_number('0360532')->is_valid_number, '青森県黒石市飛内北');
ok($zip->set_number('0360533')->is_valid_number, '青森県黒石市二双子');
ok($zip->set_number('0360534')->is_valid_number, '青森県黒石市竹鼻');
ok($zip->set_number('0360535')->is_valid_number, '青森県黒石市高舘');
ok($zip->set_number('0360536')->is_valid_number, '青森県黒石市三島');
ok($zip->set_number('0360537')->is_valid_number, '青森県黒石市赤坂');
ok($zip->set_number('0360538')->is_valid_number, '青森県黒石市上目内澤');
ok($zip->set_number('0360539')->is_valid_number, '青森県黒石市下目内澤');
ok($zip->set_number('0360541')->is_valid_number, '青森県黒石市北美町');
ok($zip->set_number('0360542')->is_valid_number, '青森県黒石市野際');
ok($zip->set_number('0361201')->is_valid_number, '青森県弘前市十腰内');
ok($zip->set_number('0361202')->is_valid_number, '青森県弘前市十面沢');
ok($zip->set_number('0361203')->is_valid_number, '青森県弘前市大森');
ok($zip->set_number('0361204')->is_valid_number, '青森県弘前市貝沢');
ok($zip->set_number('0361205')->is_valid_number, '青森県弘前市鬼沢');
ok($zip->set_number('0361206')->is_valid_number, '青森県弘前市楢木');
ok($zip->set_number('0361301')->is_valid_number, '青森県弘前市鼻和');
ok($zip->set_number('0361302')->is_valid_number, '青森県弘前市愛宕');
ok($zip->set_number('0361303')->is_valid_number, '青森県弘前市葛原');
ok($zip->set_number('0361304')->is_valid_number, '青森県弘前市新岡');
ok($zip->set_number('0361311')->is_valid_number, '青森県弘前市横町');
ok($zip->set_number('0361312')->is_valid_number, '青森県弘前市高屋');
ok($zip->set_number('0361313')->is_valid_number, '青森県弘前市賀田');
ok($zip->set_number('0361314')->is_valid_number, '青森県弘前市八幡');
ok($zip->set_number('0361321')->is_valid_number, '青森県弘前市熊嶋');
ok($zip->set_number('0361322')->is_valid_number, '青森県弘前市駒越');
ok($zip->set_number('0361323')->is_valid_number, '青森県弘前市真土');
ok($zip->set_number('0361324')->is_valid_number, '青森県弘前市龍ノ口');
ok($zip->set_number('0361325')->is_valid_number, '青森県弘前市一町田');
ok($zip->set_number('0361331')->is_valid_number, '青森県弘前市五代');
ok($zip->set_number('0361332')->is_valid_number, '青森県弘前市兼平');
ok($zip->set_number('0361333')->is_valid_number, '青森県弘前市鳥井野');
ok($zip->set_number('0361334')->is_valid_number, '青森県弘前市如来瀬');
ok($zip->set_number('0361341')->is_valid_number, '青森県弘前市宮地');
ok($zip->set_number('0361342')->is_valid_number, '青森県弘前市新法師');
ok($zip->set_number('0361343')->is_valid_number, '青森県弘前市百沢');
ok($zip->set_number('0361344')->is_valid_number, '青森県弘前市高岡');
ok($zip->set_number('0361345')->is_valid_number, '青森県弘前市常盤野');
ok($zip->set_number('0361361')->is_valid_number, '青森県弘前市弥生');
ok($zip->set_number('0361400')->is_valid_number, '青森県中津軽郡西目屋村以下に掲載がない場合');
ok($zip->set_number('0361411')->is_valid_number, '青森県中津軽郡西目屋村田代');
ok($zip->set_number('0361412')->is_valid_number, '青森県中津軽郡西目屋村杉ケ沢');
ok($zip->set_number('0361413')->is_valid_number, '青森県中津軽郡西目屋村大秋');
ok($zip->set_number('0361414')->is_valid_number, '青森県中津軽郡西目屋村白沢');
ok($zip->set_number('0361415')->is_valid_number, '青森県中津軽郡西目屋村村市');
ok($zip->set_number('0361421')->is_valid_number, '青森県中津軽郡西目屋村藤川');
ok($zip->set_number('0361422')->is_valid_number, '青森県中津軽郡西目屋村居森平');
ok($zip->set_number('0361423')->is_valid_number, '青森県中津軽郡西目屋村砂子瀬');
ok($zip->set_number('0361424')->is_valid_number, '青森県中津軽郡西目屋村川原平');
ok($zip->set_number('0361431')->is_valid_number, '青森県弘前市高野');
ok($zip->set_number('0361432')->is_valid_number, '青森県弘前市館後');
ok($zip->set_number('0361433')->is_valid_number, '青森県弘前市国吉');
ok($zip->set_number('0361434')->is_valid_number, '青森県弘前市黒土');
ok($zip->set_number('0361435')->is_valid_number, '青森県弘前市吉川');
ok($zip->set_number('0361441')->is_valid_number, '青森県弘前市桜庭');
ok($zip->set_number('0361442')->is_valid_number, '青森県弘前市平山');
ok($zip->set_number('0361443')->is_valid_number, '青森県弘前市米ケ袋');
ok($zip->set_number('0361451')->is_valid_number, '青森県弘前市中野(その他)');
ok($zip->set_number('0361452')->is_valid_number, '青森県弘前市中畑');
ok($zip->set_number('0361453')->is_valid_number, '青森県弘前市番館');
ok($zip->set_number('0361501')->is_valid_number, '青森県弘前市湯口');
ok($zip->set_number('0361502')->is_valid_number, '青森県弘前市黒滝');
ok($zip->set_number('0361503')->is_valid_number, '青森県弘前市五所');
ok($zip->set_number('0361504')->is_valid_number, '青森県弘前市紙漉沢');
ok($zip->set_number('0361505')->is_valid_number, '青森県弘前市水木在家');
ok($zip->set_number('0361506')->is_valid_number, '青森県弘前市昴');
ok($zip->set_number('0361511')->is_valid_number, '青森県弘前市坂市');
ok($zip->set_number('0361512')->is_valid_number, '青森県弘前市藤沢');
ok($zip->set_number('0361513')->is_valid_number, '青森県弘前市大助');
ok($zip->set_number('0361514')->is_valid_number, '青森県弘前市沢田');
ok($zip->set_number('0361515')->is_valid_number, '青森県弘前市相馬');
ok($zip->set_number('0361516')->is_valid_number, '青森県弘前市藍内');
ok($zip->set_number('0368001')->is_valid_number, '青森県弘前市代官町');
ok($zip->set_number('0368002')->is_valid_number, '青森県弘前市駅前');
ok($zip->set_number('0368003')->is_valid_number, '青森県弘前市駅前町');
ok($zip->set_number('0368004')->is_valid_number, '青森県弘前市大町');
ok($zip->set_number('0368005')->is_valid_number, '青森県弘前市楮町');
ok($zip->set_number('0368006')->is_valid_number, '青森県弘前市南大町');
ok($zip->set_number('0368011')->is_valid_number, '青森県弘前市山下町');
ok($zip->set_number('0368012')->is_valid_number, '青森県弘前市北瓦ケ町');
ok($zip->set_number('0368013')->is_valid_number, '青森県弘前市上瓦ケ町');
ok($zip->set_number('0368014')->is_valid_number, '青森県弘前市南瓦ケ町');
ok($zip->set_number('0368015')->is_valid_number, '青森県弘前市中瓦ケ町');
ok($zip->set_number('0368016')->is_valid_number, '青森県弘前市坂本町');
ok($zip->set_number('0368017')->is_valid_number, '青森県弘前市西川岸町');
ok($zip->set_number('0368018')->is_valid_number, '青森県弘前市田代町');
ok($zip->set_number('0368021')->is_valid_number, '青森県弘前市和徳町');
ok($zip->set_number('0368022')->is_valid_number, '青森県弘前市萱町');
ok($zip->set_number('0368023')->is_valid_number, '青森県弘前市植田町');
ok($zip->set_number('0368024')->is_valid_number, '青森県弘前市緑町');
ok($zip->set_number('0368025')->is_valid_number, '青森県弘前市南柳町');
ok($zip->set_number('0368026')->is_valid_number, '青森県弘前市南横町');
ok($zip->set_number('0368031')->is_valid_number, '青森県弘前市北柳町');
ok($zip->set_number('0368032')->is_valid_number, '青森県弘前市徳田町');
ok($zip->set_number('0368033')->is_valid_number, '青森県弘前市徒町川端町');
ok($zip->set_number('0368034')->is_valid_number, '青森県弘前市徒町');
ok($zip->set_number('0368035')->is_valid_number, '青森県弘前市百石町');
ok($zip->set_number('0368036')->is_valid_number, '青森県弘前市鉄砲町');
ok($zip->set_number('0368041')->is_valid_number, '青森県弘前市俵元');
ok($zip->set_number('0368042')->is_valid_number, '青森県弘前市松ケ枝');
ok($zip->set_number('0368043')->is_valid_number, '青森県弘前市東和徳町');
ok($zip->set_number('0368044')->is_valid_number, '青森県弘前市茶畑町');
ok($zip->set_number('0368045')->is_valid_number, '青森県弘前市野田');
ok($zip->set_number('0368046')->is_valid_number, '青森県弘前市北横町');
ok($zip->set_number('0368051')->is_valid_number, '青森県弘前市宮川');
ok($zip->set_number('0368052')->is_valid_number, '青森県弘前市堅田');
ok($zip->set_number('0368053')->is_valid_number, '青森県弘前市和泉');
ok($zip->set_number('0368054')->is_valid_number, '青森県弘前市田町');
ok($zip->set_number('0368055')->is_valid_number, '青森県弘前市田茂木町');
ok($zip->set_number('0368056')->is_valid_number, '青森県弘前市禰宜町');
ok($zip->set_number('0368057')->is_valid_number, '青森県弘前市八幡町');
ok($zip->set_number('0368061')->is_valid_number, '青森県弘前市神田');
ok($zip->set_number('0368062')->is_valid_number, '青森県弘前市青山');
ok($zip->set_number('0368063')->is_valid_number, '青森県弘前市宮園');
ok($zip->set_number('0368064')->is_valid_number, '青森県弘前市東城北');
ok($zip->set_number('0368065')->is_valid_number, '青森県弘前市西城北');
ok($zip->set_number('0368066')->is_valid_number, '青森県弘前市向外瀬');
ok($zip->set_number('0368071')->is_valid_number, '青森県弘前市大久保');
ok($zip->set_number('0368072')->is_valid_number, '青森県弘前市清野袋');
ok($zip->set_number('0368073')->is_valid_number, '青森県弘前市岩賀');
ok($zip->set_number('0368074')->is_valid_number, '青森県弘前市津賀野(瀬ノ上)');
ok($zip->set_number('0368075')->is_valid_number, '青森県弘前市撫牛子');
ok($zip->set_number('0368076')->is_valid_number, '青森県弘前市境関');
ok($zip->set_number('0368081')->is_valid_number, '青森県弘前市福田');
ok($zip->set_number('0368082')->is_valid_number, '青森県弘前市福村');
ok($zip->set_number('0368083')->is_valid_number, '青森県弘前市新里');
ok($zip->set_number('0368084')->is_valid_number, '青森県弘前市高田');
ok($zip->set_number('0368085')->is_valid_number, '青森県弘前市末広');
ok($zip->set_number('0368086')->is_valid_number, '青森県弘前市田園');
ok($zip->set_number('0368087')->is_valid_number, '青森県弘前市早稲田');
ok($zip->set_number('0368091')->is_valid_number, '青森県弘前市高崎');
ok($zip->set_number('0368092')->is_valid_number, '青森県弘前市城東北');
ok($zip->set_number('0368093')->is_valid_number, '青森県弘前市城東中央');
ok($zip->set_number('0368094')->is_valid_number, '青森県弘前市外崎');
ok($zip->set_number('0368095')->is_valid_number, '青森県弘前市城東');
ok($zip->set_number('0368096')->is_valid_number, '青森県弘前市表町');
ok($zip->set_number('0368097')->is_valid_number, '青森県弘前市稲田');
ok($zip->set_number('0368101')->is_valid_number, '青森県弘前市豊田');
ok($zip->set_number('0368102')->is_valid_number, '青森県弘前市小比内');
ok($zip->set_number('0368103')->is_valid_number, '青森県弘前市川先');
ok($zip->set_number('0368104')->is_valid_number, '青森県弘前市扇町');
ok($zip->set_number('0368111')->is_valid_number, '青森県弘前市門外');
ok($zip->set_number('0368112')->is_valid_number, '青森県弘前市堀越');
ok($zip->set_number('0368113')->is_valid_number, '青森県弘前市清水森');
ok($zip->set_number('0368114')->is_valid_number, '青森県弘前市川合');
ok($zip->set_number('0368115')->is_valid_number, '青森県弘前市広野');
ok($zip->set_number('0368121')->is_valid_number, '青森県弘前市薬師堂');
ok($zip->set_number('0368122')->is_valid_number, '青森県弘前市乳井');
ok($zip->set_number('0368123')->is_valid_number, '青森県弘前市小金崎');
ok($zip->set_number('0368124')->is_valid_number, '青森県弘前市石川');
ok($zip->set_number('0368125')->is_valid_number, '青森県弘前市大沢');
ok($zip->set_number('0368126')->is_valid_number, '青森県弘前市松木平');
ok($zip->set_number('0368127')->is_valid_number, '青森県弘前市小栗山');
ok($zip->set_number('0368131')->is_valid_number, '青森県弘前市千年');
ok($zip->set_number('0368132')->is_valid_number, '青森県弘前市狼森');
ok($zip->set_number('0368133')->is_valid_number, '青森県弘前市大和沢');
ok($zip->set_number('0368134')->is_valid_number, '青森県弘前市一野渡');
ok($zip->set_number('0368141')->is_valid_number, '青森県弘前市松原東');
ok($zip->set_number('0368142')->is_valid_number, '青森県弘前市松原西');
ok($zip->set_number('0368143')->is_valid_number, '青森県弘前市富士見台');
ok($zip->set_number('0368144')->is_valid_number, '青森県弘前市原ケ平');
ok($zip->set_number('0368151')->is_valid_number, '青森県弘前市北園');
ok($zip->set_number('0368152')->is_valid_number, '青森県弘前市学園町');
ok($zip->set_number('0368153')->is_valid_number, '青森県弘前市三岳町');
ok($zip->set_number('0368154')->is_valid_number, '青森県弘前市豊原');
ok($zip->set_number('0368155')->is_valid_number, '青森県弘前市中野(丁目)');
ok($zip->set_number('0368161')->is_valid_number, '青森県弘前市大清水');
ok($zip->set_number('0368162')->is_valid_number, '青森県弘前市安原');
ok($zip->set_number('0368163')->is_valid_number, '青森県弘前市清原');
ok($zip->set_number('0368164')->is_valid_number, '青森県弘前市泉野');
ok($zip->set_number('0368171')->is_valid_number, '青森県弘前市取上');
ok($zip->set_number('0368172')->is_valid_number, '青森県弘前市南富田町');
ok($zip->set_number('0368173')->is_valid_number, '青森県弘前市富田町');
ok($zip->set_number('0368174')->is_valid_number, '青森県弘前市富野町');
ok($zip->set_number('0368175')->is_valid_number, '青森県弘前市大富町');
ok($zip->set_number('0368181')->is_valid_number, '青森県弘前市山道町');
ok($zip->set_number('0368182')->is_valid_number, '青森県弘前市土手町');
ok($zip->set_number('0368183')->is_valid_number, '青森県弘前市品川町');
ok($zip->set_number('0368184')->is_valid_number, '青森県弘前市松森町');
ok($zip->set_number('0368185')->is_valid_number, '青森県弘前市御幸町');
ok($zip->set_number('0368186')->is_valid_number, '青森県弘前市富田');
ok($zip->set_number('0368187')->is_valid_number, '青森県弘前市住吉町');
ok($zip->set_number('0368188')->is_valid_number, '青森県弘前市吉野町');
ok($zip->set_number('0368191')->is_valid_number, '青森県弘前市親方町');
ok($zip->set_number('0368192')->is_valid_number, '青森県弘前市鍛冶町');
ok($zip->set_number('0368193')->is_valid_number, '青森県弘前市新鍛冶町');
ok($zip->set_number('0368194')->is_valid_number, '青森県弘前市北川端町');
ok($zip->set_number('0368195')->is_valid_number, '青森県弘前市南川端町');
ok($zip->set_number('0368196')->is_valid_number, '青森県弘前市銅屋町');
ok($zip->set_number('0368197')->is_valid_number, '青森県弘前市桶屋町');
ok($zip->set_number('0368198')->is_valid_number, '青森県弘前市元長町');
ok($zip->set_number('0368201')->is_valid_number, '青森県弘前市一番町');
ok($zip->set_number('0368202')->is_valid_number, '青森県弘前市元大工町');
ok($zip->set_number('0368203')->is_valid_number, '青森県弘前市本町');
ok($zip->set_number('0368204')->is_valid_number, '青森県弘前市覚仙町');
ok($zip->set_number('0368205')->is_valid_number, '青森県弘前市森町');
ok($zip->set_number('0368206')->is_valid_number, '青森県弘前市塩分町');
ok($zip->set_number('0368207')->is_valid_number, '青森県弘前市上白銀町');
ok($zip->set_number('0368211')->is_valid_number, '青森県弘前市相良町');
ok($zip->set_number('0368212')->is_valid_number, '青森県弘前市南塘町');
ok($zip->set_number('0368213')->is_valid_number, '青森県弘前市北新寺町');
ok($zip->set_number('0368214')->is_valid_number, '青森県弘前市新寺町');
ok($zip->set_number('0368215')->is_valid_number, '青森県弘前市新寺町新割町');
ok($zip->set_number('0368216')->is_valid_number, '青森県弘前市在府町');
ok($zip->set_number('0368217')->is_valid_number, '青森県弘前市茂森町');
ok($zip->set_number('0368221')->is_valid_number, '青森県弘前市紙漉町');
ok($zip->set_number('0368222')->is_valid_number, '青森県弘前市桜林町');
ok($zip->set_number('0368223')->is_valid_number, '青森県弘前市富士見町');
ok($zip->set_number('0368224')->is_valid_number, '青森県弘前市文京町');
ok($zip->set_number('0368225')->is_valid_number, '青森県弘前市西ケ丘町');
ok($zip->set_number('0368226')->is_valid_number, '青森県弘前市寒沢町');
ok($zip->set_number('0368227')->is_valid_number, '青森県弘前市桔梗野');
ok($zip->set_number('0368228')->is_valid_number, '青森県弘前市樹木');
ok($zip->set_number('0368231')->is_valid_number, '青森県弘前市稔町');
ok($zip->set_number('0368232')->is_valid_number, '青森県弘前市城南');
ok($zip->set_number('0368233')->is_valid_number, '青森県弘前市山崎');
ok($zip->set_number('0368234')->is_valid_number, '青森県弘前市館野');
ok($zip->set_number('0368241')->is_valid_number, '青森県弘前市桜ケ丘');
ok($zip->set_number('0368242')->is_valid_number, '青森県弘前市大原');
ok($zip->set_number('0368243')->is_valid_number, '青森県弘前市小沢');
ok($zip->set_number('0368244')->is_valid_number, '青森県弘前市坂元');
ok($zip->set_number('0368245')->is_valid_number, '青森県弘前市金属町');
ok($zip->set_number('0368246')->is_valid_number, '青森県弘前市青樹町');
ok($zip->set_number('0368247')->is_valid_number, '青森県弘前市大開');
ok($zip->set_number('0368251')->is_valid_number, '青森県弘前市清富町');
ok($zip->set_number('0368252')->is_valid_number, '青森県弘前市旭ケ丘');
ok($zip->set_number('0368253')->is_valid_number, '青森県弘前市緑ケ丘');
ok($zip->set_number('0368254')->is_valid_number, '青森県弘前市清水');
ok($zip->set_number('0368255')->is_valid_number, '青森県弘前市若葉');
ok($zip->set_number('0368261')->is_valid_number, '青森県弘前市茂森新町');
ok($zip->set_number('0368262')->is_valid_number, '青森県弘前市清水富田');
ok($zip->set_number('0368263')->is_valid_number, '青森県弘前市常盤坂');
ok($zip->set_number('0368264')->is_valid_number, '青森県弘前市悪戸');
ok($zip->set_number('0368265')->is_valid_number, '青森県弘前市下湯口');
ok($zip->set_number('0368266')->is_valid_number, '青森県弘前市自由ケ丘');
ok($zip->set_number('0368271')->is_valid_number, '青森県弘前市鷹匠町');
ok($zip->set_number('0368272')->is_valid_number, '青森県弘前市南袋町');
ok($zip->set_number('0368273')->is_valid_number, '青森県弘前市西茂森');
ok($zip->set_number('0368274')->is_valid_number, '青森県弘前市南城西');
ok($zip->set_number('0368275')->is_valid_number, '青森県弘前市城西');
ok($zip->set_number('0368276')->is_valid_number, '青森県弘前市樋の口町');
ok($zip->set_number('0368277')->is_valid_number, '青森県弘前市河原町');
ok($zip->set_number('0368278')->is_valid_number, '青森県弘前市樋の口');
ok($zip->set_number('0368279')->is_valid_number, '青森県弘前市茜町');
ok($zip->set_number('0368301')->is_valid_number, '青森県弘前市糠坪');
ok($zip->set_number('0368302')->is_valid_number, '青森県弘前市高杉');
ok($zip->set_number('0368303')->is_valid_number, '青森県弘前市前坂');
ok($zip->set_number('0368311')->is_valid_number, '青森県弘前市大川');
ok($zip->set_number('0368312')->is_valid_number, '青森県弘前市三世寺');
ok($zip->set_number('0368313')->is_valid_number, '青森県弘前市中崎');
ok($zip->set_number('0368314')->is_valid_number, '青森県弘前市町田');
ok($zip->set_number('0368315')->is_valid_number, '青森県弘前市船水');
ok($zip->set_number('0368316')->is_valid_number, '青森県弘前市石渡');
ok($zip->set_number('0368317')->is_valid_number, '青森県弘前市外瀬');
ok($zip->set_number('0368318')->is_valid_number, '青森県弘前市八代町');
ok($zip->set_number('0368319')->is_valid_number, '青森県弘前市藤内町');
ok($zip->set_number('0368321')->is_valid_number, '青森県弘前市萢中');
ok($zip->set_number('0368323')->is_valid_number, '青森県弘前市浜の町東');
ok($zip->set_number('0368324')->is_valid_number, '青森県弘前市浜の町西');
ok($zip->set_number('0368325')->is_valid_number, '青森県弘前市浜の町北');
ok($zip->set_number('0368326')->is_valid_number, '青森県弘前市藤野');
ok($zip->set_number('0368331')->is_valid_number, '青森県弘前市小人町');
ok($zip->set_number('0368332')->is_valid_number, '青森県弘前市亀甲町');
ok($zip->set_number('0368333')->is_valid_number, '青森県弘前市若党町');
ok($zip->set_number('0368334')->is_valid_number, '青森県弘前市馬喰町');
ok($zip->set_number('0368335')->is_valid_number, '青森県弘前市春日町');
ok($zip->set_number('0368336')->is_valid_number, '青森県弘前市栄町');
ok($zip->set_number('0368341')->is_valid_number, '青森県弘前市山王町');
ok($zip->set_number('0368342')->is_valid_number, '青森県弘前市笹森町');
ok($zip->set_number('0368343')->is_valid_number, '青森県弘前市東長町');
ok($zip->set_number('0368344')->is_valid_number, '青森県弘前市長坂町');
ok($zip->set_number('0368345')->is_valid_number, '青森県弘前市蔵主町');
ok($zip->set_number('0368346')->is_valid_number, '青森県弘前市大浦町');
ok($zip->set_number('0368351')->is_valid_number, '青森県弘前市百石町小路');
ok($zip->set_number('0368352')->is_valid_number, '青森県弘前市元寺町小路');
ok($zip->set_number('0368353')->is_valid_number, '青森県弘前市下鞘師町');
ok($zip->set_number('0368354')->is_valid_number, '青森県弘前市上鞘師町');
ok($zip->set_number('0368355')->is_valid_number, '青森県弘前市元寺町');
ok($zip->set_number('0368356')->is_valid_number, '青森県弘前市下白銀町');
ok($zip->set_number('0368357')->is_valid_number, '青森県弘前市馬屋町');
ok($zip->set_number('0368361')->is_valid_number, '青森県弘前市紺屋町');
ok($zip->set_number('0368362')->is_valid_number, '青森県弘前市五十石町');
ok($zip->set_number('0368363')->is_valid_number, '青森県弘前市袋町');
ok($zip->set_number('0368364')->is_valid_number, '青森県弘前市新町');
ok($zip->set_number('0368365')->is_valid_number, '青森県弘前市西大工町');
ok($zip->set_number('0368366')->is_valid_number, '青森県弘前市駒越町');
ok($zip->set_number('0368367')->is_valid_number, '青森県弘前市平岡町');
ok($zip->set_number('0368368')->is_valid_number, '青森県弘前市和田町');
ok($zip->set_number('0368371')->is_valid_number, '青森県弘前市蒔苗');
ok($zip->set_number('0368372')->is_valid_number, '青森県弘前市元薬師堂');
ok($zip->set_number('0368373')->is_valid_number, '青森県弘前市藤代');
ok($zip->set_number('0368374')->is_valid_number, '青森県弘前市土堂');
ok($zip->set_number('0368375')->is_valid_number, '青森県弘前市細越');
ok($zip->set_number('0368381')->is_valid_number, '青森県弘前市独狐');
ok($zip->set_number('0368382')->is_valid_number, '青森県弘前市富栄');
ok($zip->set_number('0368383')->is_valid_number, '青森県弘前市折笠');
ok($zip->set_number('0368384')->is_valid_number, '青森県弘前市宮舘');
ok($zip->set_number('0368385')->is_valid_number, '青森県弘前市中別所');
ok($zip->set_number('0370000')->is_valid_number, '青森県五所川原市以下に掲載がない場合');
ok($zip->set_number('0370001')->is_valid_number, '青森県五所川原市下岩崎');
ok($zip->set_number('0370002')->is_valid_number, '青森県五所川原市飯詰');
ok($zip->set_number('0370003')->is_valid_number, '青森県五所川原市吹畑');
ok($zip->set_number('0370004')->is_valid_number, '青森県五所川原市唐笠柳');
ok($zip->set_number('0370005')->is_valid_number, '青森県五所川原市石岡');
ok($zip->set_number('0370006')->is_valid_number, '青森県五所川原市松島町');
ok($zip->set_number('0370011')->is_valid_number, '青森県五所川原市金山');
ok($zip->set_number('0370012')->is_valid_number, '青森県五所川原市水野尾');
ok($zip->set_number('0370013')->is_valid_number, '青森県五所川原市米田');
ok($zip->set_number('0370014')->is_valid_number, '青森県五所川原市稲実');
ok($zip->set_number('0370015')->is_valid_number, '青森県五所川原市姥萢');
ok($zip->set_number('0370016')->is_valid_number, '青森県五所川原市一ツ谷');
ok($zip->set_number('0370017')->is_valid_number, '青森県五所川原市漆川');
ok($zip->set_number('0370021')->is_valid_number, '青森県五所川原市中泉');
ok($zip->set_number('0370022')->is_valid_number, '青森県五所川原市梅田');
ok($zip->set_number('0370023')->is_valid_number, '青森県五所川原市広田');
ok($zip->set_number('0370024')->is_valid_number, '青森県五所川原市みどり町');
ok($zip->set_number('0370025')->is_valid_number, '青森県五所川原市七ツ館');
ok($zip->set_number('0370032')->is_valid_number, '青森県五所川原市烏森');
ok($zip->set_number('0370033')->is_valid_number, '青森県五所川原市鎌谷町');
ok($zip->set_number('0370034')->is_valid_number, '青森県五所川原市八重菊');
ok($zip->set_number('0370035')->is_valid_number, '青森県五所川原市湊');
ok($zip->set_number('0370036')->is_valid_number, '青森県五所川原市中央');
ok($zip->set_number('0370041')->is_valid_number, '青森県五所川原市田町');
ok($zip->set_number('0370042')->is_valid_number, '青森県五所川原市不魚住');
ok($zip->set_number('0370043')->is_valid_number, '青森県五所川原市蓮沼');
ok($zip->set_number('0370044')->is_valid_number, '青森県五所川原市元町');
ok($zip->set_number('0370045')->is_valid_number, '青森県五所川原市新町');
ok($zip->set_number('0370046')->is_valid_number, '青森県五所川原市栄町');
ok($zip->set_number('0370051')->is_valid_number, '青森県五所川原市弥生町');
ok($zip->set_number('0370052')->is_valid_number, '青森県五所川原市東町');
ok($zip->set_number('0370053')->is_valid_number, '青森県五所川原市布屋町');
ok($zip->set_number('0370054')->is_valid_number, '青森県五所川原市上平井町');
ok($zip->set_number('0370055')->is_valid_number, '青森県五所川原市柏原町');
ok($zip->set_number('0370056')->is_valid_number, '青森県五所川原市末広町');
ok($zip->set_number('0370057')->is_valid_number, '青森県五所川原市幾島町');
ok($zip->set_number('0370058')->is_valid_number, '青森県五所川原市錦町');
ok($zip->set_number('0370061')->is_valid_number, '青森県五所川原市雛田');
ok($zip->set_number('0370062')->is_valid_number, '青森県五所川原市旭町');
ok($zip->set_number('0370063')->is_valid_number, '青森県五所川原市大町');
ok($zip->set_number('0370064')->is_valid_number, '青森県五所川原市下平井町');
ok($zip->set_number('0370065')->is_valid_number, '青森県五所川原市幾世森');
ok($zip->set_number('0370066')->is_valid_number, '青森県五所川原市中平井町');
ok($zip->set_number('0370067')->is_valid_number, '青森県五所川原市敷島町');
ok($zip->set_number('0370068')->is_valid_number, '青森県五所川原市長橋');
ok($zip->set_number('0370069')->is_valid_number, '青森県五所川原市若葉');
ok($zip->set_number('0370071')->is_valid_number, '青森県五所川原市本町');
ok($zip->set_number('0370072')->is_valid_number, '青森県五所川原市川端町');
ok($zip->set_number('0370073')->is_valid_number, '青森県五所川原市柳町');
ok($zip->set_number('0370074')->is_valid_number, '青森県五所川原市岩木町');
ok($zip->set_number('0370075')->is_valid_number, '青森県五所川原市寺町');
ok($zip->set_number('0370076')->is_valid_number, '青森県五所川原市小曲');
ok($zip->set_number('0370081')->is_valid_number, '青森県五所川原市新宮');
ok($zip->set_number('0370082')->is_valid_number, '青森県五所川原市種井');
ok($zip->set_number('0370083')->is_valid_number, '青森県五所川原市新宮町');
ok($zip->set_number('0370084')->is_valid_number, '青森県五所川原市蘇鉄');
ok($zip->set_number('0370085')->is_valid_number, '青森県五所川原市芭蕉');
ok($zip->set_number('0370086')->is_valid_number, '青森県五所川原市田川');
ok($zip->set_number('0370087')->is_valid_number, '青森県五所川原市高瀬');
ok($zip->set_number('0370088')->is_valid_number, '青森県五所川原市鶴ケ岡');
ok($zip->set_number('0370089')->is_valid_number, '青森県五所川原市藻川');
ok($zip->set_number('0370091')->is_valid_number, '青森県五所川原市太刀打');
ok($zip->set_number('0370092')->is_valid_number, '青森県五所川原市沖飯詰');
ok($zip->set_number('0370093')->is_valid_number, '青森県五所川原市一野坪');
ok($zip->set_number('0370094')->is_valid_number, '青森県五所川原市川山');
ok($zip->set_number('0370095')->is_valid_number, '青森県五所川原市桜田');
ok($zip->set_number('0370096')->is_valid_number, '青森県五所川原市毘沙門');
ok($zip->set_number('0370097')->is_valid_number, '青森県五所川原市長富');
ok($zip->set_number('0370101')->is_valid_number, '青森県つがる市稲垣町下繁田');
ok($zip->set_number('0370102')->is_valid_number, '青森県つがる市稲垣町繁田');
ok($zip->set_number('0370103')->is_valid_number, '青森県つがる市稲垣町穂積');
ok($zip->set_number('0370104')->is_valid_number, '青森県つがる市稲垣町豊川');
ok($zip->set_number('0370105')->is_valid_number, '青森県つがる市稲垣町福富');
ok($zip->set_number('0370106')->is_valid_number, '青森県つがる市稲垣町沼崎');
ok($zip->set_number('0370107')->is_valid_number, '青森県つがる市稲垣町沼舘');
ok($zip->set_number('0370108')->is_valid_number, '青森県つがる市稲垣町吉出');
ok($zip->set_number('0370109')->is_valid_number, '青森県つがる市稲垣町千年');
ok($zip->set_number('0370201')->is_valid_number, '青森県五所川原市金木町川倉');
ok($zip->set_number('0370202')->is_valid_number, '青森県五所川原市金木町');
ok($zip->set_number('0370203')->is_valid_number, '青森県五所川原市金木町喜良市');
ok($zip->set_number('0370204')->is_valid_number, '青森県五所川原市金木町嘉瀬');
ok($zip->set_number('0370205')->is_valid_number, '青森県五所川原市金木町中柏木');
ok($zip->set_number('0370206')->is_valid_number, '青森県五所川原市金木町神原');
ok($zip->set_number('0370207')->is_valid_number, '青森県五所川原市金木町蒔田');
ok($zip->set_number('0370208')->is_valid_number, '青森県五所川原市金木町藤枝');
ok($zip->set_number('0370300')->is_valid_number, '青森県北津軽郡中泊町以下に掲載がない場合');
ok($zip->set_number('0370301')->is_valid_number, '青森県北津軽郡中泊町今泉');
ok($zip->set_number('0370302')->is_valid_number, '青森県北津軽郡中泊町薄市');
ok($zip->set_number('0370303')->is_valid_number, '青森県北津軽郡中泊町高根');
ok($zip->set_number('0370304')->is_valid_number, '青森県北津軽郡中泊町尾別');
ok($zip->set_number('0370305')->is_valid_number, '青森県北津軽郡中泊町中里');
ok($zip->set_number('0370306')->is_valid_number, '青森県北津軽郡中泊町宮川');
ok($zip->set_number('0370307')->is_valid_number, '青森県北津軽郡中泊町宮野沢');
ok($zip->set_number('0370308')->is_valid_number, '青森県北津軽郡中泊町深郷田');
ok($zip->set_number('0370309')->is_valid_number, '青森県北津軽郡中泊町八幡');
ok($zip->set_number('0370311')->is_valid_number, '青森県北津軽郡中泊町大沢内');
ok($zip->set_number('0370312')->is_valid_number, '青森県北津軽郡中泊町豊島');
ok($zip->set_number('0370313')->is_valid_number, '青森県北津軽郡中泊町富野');
ok($zip->set_number('0370314')->is_valid_number, '青森県北津軽郡中泊町福浦');
ok($zip->set_number('0370315')->is_valid_number, '青森県北津軽郡中泊町豊岡');
ok($zip->set_number('0370316')->is_valid_number, '青森県北津軽郡中泊町芦野');
ok($zip->set_number('0370317')->is_valid_number, '青森県北津軽郡中泊町長泥');
ok($zip->set_number('0370318')->is_valid_number, '青森県北津軽郡中泊町田茂木');
ok($zip->set_number('0370401')->is_valid_number, '青森県五所川原市相内');
ok($zip->set_number('0370402')->is_valid_number, '青森県五所川原市太田');
ok($zip->set_number('0370403')->is_valid_number, '青森県五所川原市十三');
ok($zip->set_number('0370404')->is_valid_number, '青森県五所川原市磯松');
ok($zip->set_number('0370405')->is_valid_number, '青森県五所川原市脇元');
ok($zip->set_number('0370511')->is_valid_number, '青森県北津軽郡中泊町小泊砂山');
ok($zip->set_number('0370512')->is_valid_number, '青森県北津軽郡中泊町小泊朝間');
ok($zip->set_number('0370513')->is_valid_number, '青森県北津軽郡中泊町小泊割長根');
ok($zip->set_number('0370514')->is_valid_number, '青森県北津軽郡中泊町小泊浜野');
ok($zip->set_number('0370521')->is_valid_number, '青森県北津軽郡中泊町小泊折戸');
ok($zip->set_number('0370522')->is_valid_number, '青森県北津軽郡中泊町小泊小泊');
ok($zip->set_number('0370523')->is_valid_number, '青森県北津軽郡中泊町小泊稲荷');
ok($zip->set_number('0370524')->is_valid_number, '青森県北津軽郡中泊町小泊水澗');
ok($zip->set_number('0370525')->is_valid_number, '青森県北津軽郡中泊町小泊鮫貝');
ok($zip->set_number('0370531')->is_valid_number, '青森県北津軽郡中泊町小泊長坂');
ok($zip->set_number('0370532')->is_valid_number, '青森県北津軽郡中泊町小泊梨子木平');
ok($zip->set_number('0370533')->is_valid_number, '青森県北津軽郡中泊町小泊白倉');
ok($zip->set_number('0370534')->is_valid_number, '青森県北津軽郡中泊町小泊漆流');
ok($zip->set_number('0370535')->is_valid_number, '青森県北津軽郡中泊町小泊尾崎道');
ok($zip->set_number('0370536')->is_valid_number, '青森県北津軽郡中泊町小泊中間');
ok($zip->set_number('0370537')->is_valid_number, '青森県北津軽郡中泊町小泊渕岩');
ok($zip->set_number('0370538')->is_valid_number, '青森県北津軽郡中泊町小泊下前');
ok($zip->set_number('0370541')->is_valid_number, '青森県北津軽郡中泊町小泊嗽沢');
ok($zip->set_number('0370542')->is_valid_number, '青森県北津軽郡中泊町小泊大山長根');
ok($zip->set_number('0370543')->is_valid_number, '青森県北津軽郡中泊町小泊坊主沢');
ok($zip->set_number('0370601')->is_valid_number, '青森県五所川原市戸沢');
ok($zip->set_number('0370602')->is_valid_number, '青森県五所川原市松野木');
ok($zip->set_number('0370611')->is_valid_number, '青森県五所川原市神山');
ok($zip->set_number('0370612')->is_valid_number, '青森県五所川原市福山');
ok($zip->set_number('0370613')->is_valid_number, '青森県五所川原市浅井');
ok($zip->set_number('0370614')->is_valid_number, '青森県五所川原市野里');
ok($zip->set_number('0370621')->is_valid_number, '青森県五所川原市豊成');
ok($zip->set_number('0370622')->is_valid_number, '青森県五所川原市原子');
ok($zip->set_number('0370623')->is_valid_number, '青森県五所川原市俵元');
ok($zip->set_number('0370631')->is_valid_number, '青森県五所川原市前田野目');
ok($zip->set_number('0370632')->is_valid_number, '青森県五所川原市高野');
ok($zip->set_number('0370641')->is_valid_number, '青森県五所川原市羽野木沢');
ok($zip->set_number('0370642')->is_valid_number, '青森県五所川原市持子沢');
ok($zip->set_number('0380000')->is_valid_number, '青森県青森市以下に掲載がない場合');
ok($zip->set_number('0380001')->is_valid_number, '青森県青森市新田');
ok($zip->set_number('0380002')->is_valid_number, '青森県青森市沖館');
ok($zip->set_number('0380003')->is_valid_number, '青森県青森市石江');
ok($zip->set_number('0380004')->is_valid_number, '青森県青森市富田');
ok($zip->set_number('0380006')->is_valid_number, '青森県青森市三好');
ok($zip->set_number('0380011')->is_valid_number, '青森県青森市篠田');
ok($zip->set_number('0380012')->is_valid_number, '青森県青森市柳川');
ok($zip->set_number('0380013')->is_valid_number, '青森県青森市久須志');
ok($zip->set_number('0380014')->is_valid_number, '青森県青森市西滝');
ok($zip->set_number('0380015')->is_valid_number, '青森県青森市千刈');
ok($zip->set_number('0380021')->is_valid_number, '青森県青森市安田');
ok($zip->set_number('0380022')->is_valid_number, '青森県青森市浪館');
ok($zip->set_number('0380023')->is_valid_number, '青森県青森市細越');
ok($zip->set_number('0380024')->is_valid_number, '青森県青森市浪館前田');
ok($zip->set_number('0380031')->is_valid_number, '青森県青森市三内');
ok($zip->set_number('0380032')->is_valid_number, '青森県青森市里見');
ok($zip->set_number('0380041')->is_valid_number, '青森県青森市岡町');
ok($zip->set_number('0380042')->is_valid_number, '青森県青森市新城');
ok($zip->set_number('0380043')->is_valid_number, '青森県青森市岩渡');
ok($zip->set_number('0380044')->is_valid_number, '青森県青森市孫内');
ok($zip->set_number('0380045')->is_valid_number, '青森県青森市鶴ケ坂');
ok($zip->set_number('0380046')->is_valid_number, '青森県青森市戸門');
ok($zip->set_number('0380051')->is_valid_number, '青森県青森市内真部');
ok($zip->set_number('0380052')->is_valid_number, '青森県青森市清水');
ok($zip->set_number('0380053')->is_valid_number, '青森県青森市前田');
ok($zip->set_number('0380054')->is_valid_number, '青森県青森市奥内');
ok($zip->set_number('0380055')->is_valid_number, '青森県青森市瀬戸子');
ok($zip->set_number('0380056')->is_valid_number, '青森県青森市飛鳥');
ok($zip->set_number('0380057')->is_valid_number, '青森県青森市西田沢');
ok($zip->set_number('0380058')->is_valid_number, '青森県青森市羽白');
ok($zip->set_number('0380059')->is_valid_number, '青森県青森市油川');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関相沢');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関阿原');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関雷林');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関碇石');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関岩井');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関大葉平');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関大落前');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関折橋');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関鯨森');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関小落前');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関山神堂');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関白沢');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関諏訪平');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関外白沢');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関高田');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関樋ケ沢');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関西碇ケ関山');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関東碇ケ関山');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関樋ノ口');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関船岡');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関踏田切');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関三笠山');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関水溜');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関湯向川添');
ok($zip->set_number('0380101')->is_valid_number, '青森県平川市碇ケ関横町');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸上程森');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸沢田');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸樋ケ沢');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸堂ノ上');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸鳥井');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸西不動野');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸東不動野');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸不動沢大石');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸不動野');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸南不動野');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸向安田');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸門前');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸門前屋岸');
ok($zip->set_number('0380102')->is_valid_number, '青森県平川市碇ケ関古懸安田');
ok($zip->set_number('0380103')->is_valid_number, '青森県平川市碇ケ関久吉蕷ケ平');
ok($zip->set_number('0380103')->is_valid_number, '青森県平川市碇ケ関久吉二ノ渡');
ok($zip->set_number('0380103')->is_valid_number, '青森県平川市碇ケ関久吉山岸');
ok($zip->set_number('0380200')->is_valid_number, '青森県南津軽郡大鰐町以下に掲載がない場合');
ok($zip->set_number('0380201')->is_valid_number, '青森県南津軽郡大鰐町苦木');
ok($zip->set_number('0380202')->is_valid_number, '青森県南津軽郡大鰐町長峰');
ok($zip->set_number('0380203')->is_valid_number, '青森県南津軽郡大鰐町駒木');
ok($zip->set_number('0380204')->is_valid_number, '青森県南津軽郡大鰐町唐牛');
ok($zip->set_number('0380211')->is_valid_number, '青森県南津軽郡大鰐町大鰐');
ok($zip->set_number('0380212')->is_valid_number, '青森県南津軽郡大鰐町蔵館');
ok($zip->set_number('0380221')->is_valid_number, '青森県南津軽郡大鰐町虹貝');
ok($zip->set_number('0380222')->is_valid_number, '青森県南津軽郡大鰐町早瀬野');
ok($zip->set_number('0380223')->is_valid_number, '青森県南津軽郡大鰐町島田');
ok($zip->set_number('0380231')->is_valid_number, '青森県南津軽郡大鰐町宿川原');
ok($zip->set_number('0380232')->is_valid_number, '青森県南津軽郡大鰐町三ツ目内');
ok($zip->set_number('0380233')->is_valid_number, '青森県南津軽郡大鰐町居土');
ok($zip->set_number('0380241')->is_valid_number, '青森県南津軽郡大鰐町鯖石');
ok($zip->set_number('0380242')->is_valid_number, '青森県南津軽郡大鰐町森山');
ok($zip->set_number('0380243')->is_valid_number, '青森県南津軽郡大鰐町八幡館');
ok($zip->set_number('0381100')->is_valid_number, '青森県南津軽郡田舎館村以下に掲載がない場合');
ok($zip->set_number('0381101')->is_valid_number, '青森県南津軽郡田舎館村東光寺');
ok($zip->set_number('0381102')->is_valid_number, '青森県南津軽郡田舎館村堂野前');
ok($zip->set_number('0381103')->is_valid_number, '青森県南津軽郡田舎館村十二川原');
ok($zip->set_number('0381104')->is_valid_number, '青森県南津軽郡田舎館村枝川');
ok($zip->set_number('0381111')->is_valid_number, '青森県南津軽郡田舎館村高樋');
ok($zip->set_number('0381112')->is_valid_number, '青森県南津軽郡田舎館村垂柳');
ok($zip->set_number('0381113')->is_valid_number, '青森県南津軽郡田舎館村田舎舘');
ok($zip->set_number('0381121')->is_valid_number, '青森県南津軽郡田舎館村畑中');
ok($zip->set_number('0381122')->is_valid_number, '青森県南津軽郡田舎館村八反田');
ok($zip->set_number('0381123')->is_valid_number, '青森県南津軽郡田舎館村大曲');
ok($zip->set_number('0381131')->is_valid_number, '青森県南津軽郡田舎館村大袋');
ok($zip->set_number('0381132')->is_valid_number, '青森県南津軽郡田舎館村諏訪堂');
ok($zip->set_number('0381133')->is_valid_number, '青森県南津軽郡田舎館村大根子');
ok($zip->set_number('0381134')->is_valid_number, '青森県南津軽郡田舎館村豊蒔');
ok($zip->set_number('0381141')->is_valid_number, '青森県南津軽郡田舎館村川部');
ok($zip->set_number('0381142')->is_valid_number, '青森県南津軽郡田舎館村和泉');
ok($zip->set_number('0381143')->is_valid_number, '青森県南津軽郡田舎館村境森');
ok($zip->set_number('0381144')->is_valid_number, '青森県南津軽郡田舎館村前田屋敷');
ok($zip->set_number('0381145')->is_valid_number, '青森県南津軽郡田舎館村土矢倉');
ok($zip->set_number('0381201')->is_valid_number, '青森県南津軽郡藤崎町福舘');
ok($zip->set_number('0381202')->is_valid_number, '青森県南津軽郡藤崎町富柳');
ok($zip->set_number('0381203')->is_valid_number, '青森県南津軽郡藤崎町久井名舘');
ok($zip->set_number('0381204')->is_valid_number, '青森県南津軽郡藤崎町水木');
ok($zip->set_number('0381205')->is_valid_number, '青森県南津軽郡藤崎町吉野田');
ok($zip->set_number('0381206')->is_valid_number, '青森県南津軽郡藤崎町郷山前');
ok($zip->set_number('0381207')->is_valid_number, '青森県南津軽郡藤崎町増館');
ok($zip->set_number('0381211')->is_valid_number, '青森県南津軽郡藤崎町福島');
ok($zip->set_number('0381212')->is_valid_number, '青森県南津軽郡藤崎町三ツ屋');
ok($zip->set_number('0381213')->is_valid_number, '青森県南津軽郡藤崎町徳下');
ok($zip->set_number('0381214')->is_valid_number, '青森県南津軽郡藤崎町常盤');
ok($zip->set_number('0381215')->is_valid_number, '青森県南津軽郡藤崎町若松');
ok($zip->set_number('0381216')->is_valid_number, '青森県南津軽郡藤崎町榊');
ok($zip->set_number('0381301')->is_valid_number, '青森県青森市浪岡大釈迦');
ok($zip->set_number('0381302')->is_valid_number, '青森県青森市浪岡長沼');
ok($zip->set_number('0381303')->is_valid_number, '青森県青森市浪岡徳才子');
ok($zip->set_number('0381304')->is_valid_number, '青森県青森市浪岡高屋敷');
ok($zip->set_number('0381305')->is_valid_number, '青森県青森市浪岡杉沢');
ok($zip->set_number('0381306')->is_valid_number, '青森県青森市浪岡福田');
ok($zip->set_number('0381311')->is_valid_number, '青森県青森市浪岡浪岡');
ok($zip->set_number('0381312')->is_valid_number, '青森県青森市浪岡五本松');
ok($zip->set_number('0381313')->is_valid_number, '青森県青森市浪岡王余魚沢');
ok($zip->set_number('0381321')->is_valid_number, '青森県青森市浪岡相沢');
ok($zip->set_number('0381322')->is_valid_number, '青森県青森市浪岡細野');
ok($zip->set_number('0381323')->is_valid_number, '青森県青森市浪岡本郷');
ok($zip->set_number('0381324')->is_valid_number, '青森県青森市浪岡吉内');
ok($zip->set_number('0381325')->is_valid_number, '青森県青森市浪岡北中野');
ok($zip->set_number('0381331')->is_valid_number, '青森県青森市浪岡女鹿沢');
ok($zip->set_number('0381332')->is_valid_number, '青森県青森市浪岡下十川');
ok($zip->set_number('0381333')->is_valid_number, '青森県青森市浪岡増館');
ok($zip->set_number('0381341')->is_valid_number, '青森県青森市浪岡銀');
ok($zip->set_number('0381342')->is_valid_number, '青森県青森市浪岡樽沢');
ok($zip->set_number('0381343')->is_valid_number, '青森県青森市浪岡郷山前');
ok($zip->set_number('0381344')->is_valid_number, '青森県青森市浪岡吉野田');
ok($zip->set_number('0381345')->is_valid_number, '青森県青森市浪岡下石川');
ok($zip->set_number('0382201')->is_valid_number, '青森県西津軽郡深浦町沢辺');
ok($zip->set_number('0382202')->is_valid_number, '青森県西津軽郡深浦町岩崎');
ok($zip->set_number('0382203')->is_valid_number, '青森県西津軽郡深浦町正道尻');
ok($zip->set_number('0382204')->is_valid_number, '青森県西津軽郡深浦町久田');
ok($zip->set_number('0382205')->is_valid_number, '青森県西津軽郡深浦町森山');
ok($zip->set_number('0382206')->is_valid_number, '青森県西津軽郡深浦町松神');
ok($zip->set_number('0382207')->is_valid_number, '青森県西津軽郡深浦町黒崎');
ok($zip->set_number('0382208')->is_valid_number, '青森県西津軽郡深浦町大間越');
ok($zip->set_number('0382300')->is_valid_number, '青森県西津軽郡深浦町以下に掲載がない場合');
ok($zip->set_number('0382321')->is_valid_number, '青森県西津軽郡深浦町広戸');
ok($zip->set_number('0382322')->is_valid_number, '青森県西津軽郡深浦町長慶平');
ok($zip->set_number('0382323')->is_valid_number, '青森県西津軽郡深浦町上長慶平');
ok($zip->set_number('0382324')->is_valid_number, '青森県西津軽郡深浦町深浦');
ok($zip->set_number('0382325')->is_valid_number, '青森県西津軽郡深浦町横磯');
ok($zip->set_number('0382326')->is_valid_number, '青森県西津軽郡深浦町月屋');
ok($zip->set_number('0382327')->is_valid_number, '青森県西津軽郡深浦町舮作');
ok($zip->set_number('0382411')->is_valid_number, '青森県西津軽郡深浦町風合瀬');
ok($zip->set_number('0382412')->is_valid_number, '青森県西津軽郡深浦町驫木');
ok($zip->set_number('0382413')->is_valid_number, '青森県西津軽郡深浦町追良瀬');
ok($zip->set_number('0382501')->is_valid_number, '青森県西津軽郡深浦町柳田');
ok($zip->set_number('0382502')->is_valid_number, '青森県西津軽郡深浦町岩坂');
ok($zip->set_number('0382503')->is_valid_number, '青森県西津軽郡深浦町関');
ok($zip->set_number('0382504')->is_valid_number, '青森県西津軽郡深浦町北金ケ沢');
ok($zip->set_number('0382505')->is_valid_number, '青森県西津軽郡深浦町田野沢');
ok($zip->set_number('0382700')->is_valid_number, '青森県西津軽郡鰺ヶ沢町以下に掲載がない場合');
ok($zip->set_number('0382701')->is_valid_number, '青森県西津軽郡鰺ヶ沢町北浮田町');
ok($zip->set_number('0382702')->is_valid_number, '青森県西津軽郡鰺ヶ沢町建石町');
ok($zip->set_number('0382703')->is_valid_number, '青森県西津軽郡鰺ヶ沢町小屋敷町');
ok($zip->set_number('0382704')->is_valid_number, '青森県西津軽郡鰺ヶ沢町湯舟町');
ok($zip->set_number('0382705')->is_valid_number, '青森県西津軽郡鰺ヶ沢町南浮田町');
ok($zip->set_number('0382711')->is_valid_number, '青森県西津軽郡鰺ヶ沢町中村町');
ok($zip->set_number('0382712')->is_valid_number, '青森県西津軽郡鰺ヶ沢町長平町');
ok($zip->set_number('0382713')->is_valid_number, '青森県西津軽郡鰺ヶ沢町松代町');
ok($zip->set_number('0382714')->is_valid_number, '青森県西津軽郡鰺ヶ沢町芦萢町');
ok($zip->set_number('0382715')->is_valid_number, '青森県西津軽郡鰺ヶ沢町浜横沢町');
ok($zip->set_number('0382721')->is_valid_number, '青森県西津軽郡鰺ヶ沢町深谷町');
ok($zip->set_number('0382722')->is_valid_number, '青森県西津軽郡鰺ヶ沢町小森町');
ok($zip->set_number('0382723')->is_valid_number, '青森県西津軽郡鰺ヶ沢町一ツ森町');
ok($zip->set_number('0382724')->is_valid_number, '青森県西津軽郡鰺ヶ沢町鬼袋町');
ok($zip->set_number('0382725')->is_valid_number, '青森県西津軽郡鰺ヶ沢町種里町');
ok($zip->set_number('0382731')->is_valid_number, '青森県西津軽郡鰺ヶ沢町赤石町');
ok($zip->set_number('0382732')->is_valid_number, '青森県西津軽郡鰺ヶ沢町日照田町');
ok($zip->set_number('0382733')->is_valid_number, '青森県西津軽郡鰺ヶ沢町館前町');
ok($zip->set_number('0382734')->is_valid_number, '青森県西津軽郡鰺ヶ沢町南金沢町');
ok($zip->set_number('0382735')->is_valid_number, '青森県西津軽郡鰺ヶ沢町姥袋町');
ok($zip->set_number('0382741')->is_valid_number, '青森県西津軽郡鰺ヶ沢町浜町');
ok($zip->set_number('0382742')->is_valid_number, '青森県西津軽郡鰺ヶ沢町新町');
ok($zip->set_number('0382743')->is_valid_number, '青森県西津軽郡鰺ヶ沢町釣町');
ok($zip->set_number('0382744')->is_valid_number, '青森県西津軽郡鰺ヶ沢町漁師町');
ok($zip->set_number('0382745')->is_valid_number, '青森県西津軽郡鰺ヶ沢町新地町');
ok($zip->set_number('0382746')->is_valid_number, '青森県西津軽郡鰺ヶ沢町富根町');
ok($zip->set_number('0382747')->is_valid_number, '青森県西津軽郡鰺ヶ沢町淀町');
ok($zip->set_number('0382751')->is_valid_number, '青森県西津軽郡鰺ヶ沢町田中町');
ok($zip->set_number('0382752')->is_valid_number, '青森県西津軽郡鰺ヶ沢町七ツ石町');
ok($zip->set_number('0382753')->is_valid_number, '青森県西津軽郡鰺ヶ沢町本町');
ok($zip->set_number('0382754')->is_valid_number, '青森県西津軽郡鰺ヶ沢町米町');
ok($zip->set_number('0382761')->is_valid_number, '青森県西津軽郡鰺ヶ沢町舞戸町');
ok($zip->set_number('0382801')->is_valid_number, '青森県つがる市木造丸山');
ok($zip->set_number('0382803')->is_valid_number, '青森県つがる市木造下福原');
ok($zip->set_number('0382804')->is_valid_number, '青森県つがる市木造三ツ館');
ok($zip->set_number('0382805')->is_valid_number, '青森県つがる市木造広岡');
ok($zip->set_number('0382806')->is_valid_number, '青森県つがる市木造越水');
ok($zip->set_number('0382807')->is_valid_number, '青森県つがる市木造駒田');
ok($zip->set_number('0382808')->is_valid_number, '青森県つがる市木造吹原');
ok($zip->set_number('0382811')->is_valid_number, '青森県つがる市森田町上相野');
ok($zip->set_number('0382812')->is_valid_number, '青森県つがる市森田町下相野');
ok($zip->set_number('0382813')->is_valid_number, '青森県つがる市森田町妙堂崎');
ok($zip->set_number('0382814')->is_valid_number, '青森県つがる市森田町中田');
ok($zip->set_number('0382815')->is_valid_number, '青森県つがる市森田町山田');
ok($zip->set_number('0382816')->is_valid_number, '青森県つがる市森田町森田');
ok($zip->set_number('0382817')->is_valid_number, '青森県つがる市森田町床舞');
ok($zip->set_number('0382818')->is_valid_number, '青森県つがる市森田町大館');
ok($zip->set_number('0383100')->is_valid_number, '青森県つがる市以下に掲載がない場合');
ok($zip->set_number('0383101')->is_valid_number, '青森県つがる市柏鷺坂');
ok($zip->set_number('0383102')->is_valid_number, '青森県つがる市柏下古川');
ok($zip->set_number('0383103')->is_valid_number, '青森県つがる市柏上古川');
ok($zip->set_number('0383104')->is_valid_number, '青森県つがる市柏桑野木田');
ok($zip->set_number('0383105')->is_valid_number, '青森県つがる市柏広須');
ok($zip->set_number('0383106')->is_valid_number, '青森県つがる市柏玉水');
ok($zip->set_number('0383107')->is_valid_number, '青森県つがる市柏稲盛');
ok($zip->set_number('0383111')->is_valid_number, '青森県つがる市木造豊田');
ok($zip->set_number('0383112')->is_valid_number, '青森県つがる市木造川除');
ok($zip->set_number('0383113')->is_valid_number, '青森県つがる市木造芦沼');
ok($zip->set_number('0383114')->is_valid_number, '青森県つがる市木造成田');
ok($zip->set_number('0383115')->is_valid_number, '青森県つがる市木造蓮川');
ok($zip->set_number('0383121')->is_valid_number, '青森県つがる市木造早田');
ok($zip->set_number('0383122')->is_valid_number, '青森県つがる市木造追広');
ok($zip->set_number('0383123')->is_valid_number, '青森県つがる市木造藤田');
ok($zip->set_number('0383124')->is_valid_number, '青森県つがる市木造朝日');
ok($zip->set_number('0383125')->is_valid_number, '青森県つがる市木造鶴泊');
ok($zip->set_number('0383126')->is_valid_number, '青森県つがる市木造森内');
ok($zip->set_number('0383127')->is_valid_number, '青森県つがる市木造森山');
ok($zip->set_number('0383128')->is_valid_number, '青森県つがる市木造森本');
ok($zip->set_number('0383131')->is_valid_number, '青森県つがる市木造千年');
ok($zip->set_number('0383132')->is_valid_number, '青森県つがる市木造清水');
ok($zip->set_number('0383133')->is_valid_number, '青森県つがる市木造末広');
ok($zip->set_number('0383134')->is_valid_number, '青森県つがる市木造種取');
ok($zip->set_number('0383135')->is_valid_number, '青森県つがる市木造有楽町');
ok($zip->set_number('0383136')->is_valid_number, '青森県つがる市木造萩野');
ok($zip->set_number('0383137')->is_valid_number, '青森県つがる市木造若宮');
ok($zip->set_number('0383138')->is_valid_number, '青森県つがる市木造若緑');
ok($zip->set_number('0383139')->is_valid_number, '青森県つがる市木造萩流');
ok($zip->set_number('0383141')->is_valid_number, '青森県つがる市木造浮巣');
ok($zip->set_number('0383142')->is_valid_number, '青森県つがる市木造赤根');
ok($zip->set_number('0383143')->is_valid_number, '青森県つがる市木造日向');
ok($zip->set_number('0383144')->is_valid_number, '青森県つがる市木造曙');
ok($zip->set_number('0383145')->is_valid_number, '青森県つがる市木造千代町');
ok($zip->set_number('0383146')->is_valid_number, '青森県つがる市木造桜木');
ok($zip->set_number('0383151')->is_valid_number, '青森県つがる市木造若竹');
ok($zip->set_number('0383152')->is_valid_number, '青森県つがる市木造藤岡');
ok($zip->set_number('0383153')->is_valid_number, '青森県つがる市木造野宮');
ok($zip->set_number('0383154')->is_valid_number, '青森県つがる市木造照日');
ok($zip->set_number('0383155')->is_valid_number, '青森県つがる市木造増田');
ok($zip->set_number('0383156')->is_valid_number, '青森県つがる市木造宮井');
ok($zip->set_number('0383157')->is_valid_number, '青森県つがる市木造宮崎');
ok($zip->set_number('0383158')->is_valid_number, '青森県つがる市木造房松');
ok($zip->set_number('0383159')->is_valid_number, '青森県つがる市木造桜川');
ok($zip->set_number('0383161')->is_valid_number, '青森県つがる市木造濁川');
ok($zip->set_number('0383162')->is_valid_number, '青森県つがる市木造浦船');
ok($zip->set_number('0383163')->is_valid_number, '青森県つがる市木造中館');
ok($zip->set_number('0383164')->is_valid_number, '青森県つがる市木造柴田');
ok($zip->set_number('0383165')->is_valid_number, '青森県つがる市木造菊川');
ok($zip->set_number('0383166')->is_valid_number, '青森県つがる市木造福原');
ok($zip->set_number('0383167')->is_valid_number, '青森県つがる市木造千代田');
ok($zip->set_number('0383271')->is_valid_number, '青森県つがる市木造善積');
ok($zip->set_number('0383272')->is_valid_number, '青森県つがる市木造兼館');
ok($zip->set_number('0383273')->is_valid_number, '青森県つがる市木造出野里');
ok($zip->set_number('0383274')->is_valid_number, '青森県つがる市木造蓮花田');
ok($zip->set_number('0383275')->is_valid_number, '青森県つがる市木造永田');
ok($zip->set_number('0383276')->is_valid_number, '青森県つがる市木造林');
ok($zip->set_number('0383277')->is_valid_number, '青森県つがる市木造大畑');
ok($zip->set_number('0383278')->is_valid_number, '青森県つがる市木造土滝');
ok($zip->set_number('0383281')->is_valid_number, '青森県つがる市木造平滝');
ok($zip->set_number('0383282')->is_valid_number, '青森県つがる市木造筒木坂');
ok($zip->set_number('0383283')->is_valid_number, '青森県つがる市木造館岡');
ok($zip->set_number('0383284')->is_valid_number, '青森県つがる市木造亀ケ岡');
ok($zip->set_number('0383285')->is_valid_number, '青森県つがる市木造大湯町');
ok($zip->set_number('0383286')->is_valid_number, '青森県つがる市木造菰槌');
ok($zip->set_number('0383287')->is_valid_number, '青森県つがる市木造下遠山里');
ok($zip->set_number('0383288')->is_valid_number, '青森県つがる市木造出来島');
ok($zip->set_number('0383301')->is_valid_number, '青森県つがる市富萢町');
ok($zip->set_number('0383302')->is_valid_number, '青森県つがる市豊富町');
ok($zip->set_number('0383303')->is_valid_number, '青森県つがる市車力町');
ok($zip->set_number('0383304')->is_valid_number, '青森県つがる市下車力町');
ok($zip->set_number('0383305')->is_valid_number, '青森県つがる市牛潟町');
ok($zip->set_number('0383306')->is_valid_number, '青森県つがる市下牛潟町');
ok($zip->set_number('0383500')->is_valid_number, '青森県北津軽郡鶴田町以下に掲載がない場合');
ok($zip->set_number('0383501')->is_valid_number, '青森県北津軽郡鶴田町大巻');
ok($zip->set_number('0383502')->is_valid_number, '青森県北津軽郡鶴田町強巻');
ok($zip->set_number('0383503')->is_valid_number, '青森県北津軽郡鶴田町鶴田');
ok($zip->set_number('0383511')->is_valid_number, '青森県北津軽郡鶴田町横萢');
ok($zip->set_number('0383512')->is_valid_number, '青森県北津軽郡鶴田町瀬良沢');
ok($zip->set_number('0383513')->is_valid_number, '青森県北津軽郡鶴田町沖');
ok($zip->set_number('0383514')->is_valid_number, '青森県北津軽郡鶴田町中野');
ok($zip->set_number('0383515')->is_valid_number, '青森県北津軽郡鶴田町山道');
ok($zip->set_number('0383521')->is_valid_number, '青森県北津軽郡鶴田町菖蒲川');
ok($zip->set_number('0383522')->is_valid_number, '青森県北津軽郡鶴田町鶴泊');
ok($zip->set_number('0383523')->is_valid_number, '青森県北津軽郡鶴田町胡桃舘');
ok($zip->set_number('0383524')->is_valid_number, '青森県北津軽郡鶴田町境');
ok($zip->set_number('0383525')->is_valid_number, '青森県北津軽郡鶴田町大性');
ok($zip->set_number('0383531')->is_valid_number, '青森県北津軽郡鶴田町木筒');
ok($zip->set_number('0383532')->is_valid_number, '青森県北津軽郡鶴田町野木');
ok($zip->set_number('0383541')->is_valid_number, '青森県北津軽郡鶴田町尾原');
ok($zip->set_number('0383542')->is_valid_number, '青森県北津軽郡鶴田町廻堰');
ok($zip->set_number('0383543')->is_valid_number, '青森県北津軽郡鶴田町妙堂崎');
ok($zip->set_number('0383600')->is_valid_number, '青森県北津軽郡板柳町以下に掲載がない場合');
ok($zip->set_number('0383611')->is_valid_number, '青森県弘前市三和');
ok($zip->set_number('0383612')->is_valid_number, '青森県弘前市笹舘');
ok($zip->set_number('0383613')->is_valid_number, '青森県弘前市小友');
ok($zip->set_number('0383614')->is_valid_number, '青森県弘前市種市');
ok($zip->set_number('0383615')->is_valid_number, '青森県弘前市青女子');
ok($zip->set_number('0383621')->is_valid_number, '青森県北津軽郡板柳町五林平');
ok($zip->set_number('0383622')->is_valid_number, '青森県北津軽郡板柳町夕顔関');
ok($zip->set_number('0383623')->is_valid_number, '青森県北津軽郡板柳町常海橋');
ok($zip->set_number('0383624')->is_valid_number, '青森県北津軽郡板柳町滝井');
ok($zip->set_number('0383625')->is_valid_number, '青森県北津軽郡板柳町舘野越');
ok($zip->set_number('0383631')->is_valid_number, '青森県北津軽郡板柳町牡丹森');
ok($zip->set_number('0383632')->is_valid_number, '青森県北津軽郡板柳町柏木');
ok($zip->set_number('0383633')->is_valid_number, '青森県北津軽郡板柳町狐森');
ok($zip->set_number('0383634')->is_valid_number, '青森県北津軽郡板柳町高増');
ok($zip->set_number('0383635')->is_valid_number, '青森県北津軽郡板柳町大俵');
ok($zip->set_number('0383636')->is_valid_number, '青森県北津軽郡板柳町五幾形');
ok($zip->set_number('0383641')->is_valid_number, '青森県北津軽郡板柳町深味');
ok($zip->set_number('0383642')->is_valid_number, '青森県北津軽郡板柳町太田');
ok($zip->set_number('0383643')->is_valid_number, '青森県北津軽郡板柳町長野');
ok($zip->set_number('0383644')->is_valid_number, '青森県北津軽郡板柳町横沢');
ok($zip->set_number('0383645')->is_valid_number, '青森県北津軽郡板柳町辻');
ok($zip->set_number('0383651')->is_valid_number, '青森県北津軽郡板柳町飯田');
ok($zip->set_number('0383661')->is_valid_number, '青森県北津軽郡板柳町福野田');
ok($zip->set_number('0383662')->is_valid_number, '青森県北津軽郡板柳町板柳');
ok($zip->set_number('0383671')->is_valid_number, '青森県北津軽郡板柳町掛落林');
ok($zip->set_number('0383672')->is_valid_number, '青森県北津軽郡板柳町灰沼');
ok($zip->set_number('0383673')->is_valid_number, '青森県北津軽郡板柳町小幡');
ok($zip->set_number('0383681')->is_valid_number, '青森県北津軽郡板柳町野中');
ok($zip->set_number('0383682')->is_valid_number, '青森県北津軽郡板柳町石野');
ok($zip->set_number('0383683')->is_valid_number, '青森県北津軽郡板柳町赤田');
ok($zip->set_number('0383684')->is_valid_number, '青森県北津軽郡板柳町三千石');
ok($zip->set_number('0383685')->is_valid_number, '青森県北津軽郡板柳町いたや町');
ok($zip->set_number('0383800')->is_valid_number, '青森県南津軽郡藤崎町以下に掲載がない場合');
ok($zip->set_number('0383801')->is_valid_number, '青森県南津軽郡藤崎町藤越');
ok($zip->set_number('0383802')->is_valid_number, '青森県南津軽郡藤崎町藤崎');
ok($zip->set_number('0383803')->is_valid_number, '青森県南津軽郡藤崎町西豊田');
ok($zip->set_number('0383804')->is_valid_number, '青森県南津軽郡藤崎町葛野');
ok($zip->set_number('0383805')->is_valid_number, '青森県南津軽郡藤崎町五林');
ok($zip->set_number('0383806')->is_valid_number, '青森県南津軽郡藤崎町林崎');
ok($zip->set_number('0383811')->is_valid_number, '青森県南津軽郡藤崎町中島');
ok($zip->set_number('0383812')->is_valid_number, '青森県南津軽郡藤崎町小畑');
ok($zip->set_number('0383813')->is_valid_number, '青森県南津軽郡藤崎町矢沢');
ok($zip->set_number('0383814')->is_valid_number, '青森県南津軽郡藤崎町水沼');
ok($zip->set_number('0383821')->is_valid_number, '青森県弘前市百田');
ok($zip->set_number('0383831')->is_valid_number, '青森県南津軽郡藤崎町中野目');
ok($zip->set_number('0383832')->is_valid_number, '青森県南津軽郡藤崎町吉向');
ok($zip->set_number('0383833')->is_valid_number, '青森県南津軽郡藤崎町亀岡');
ok($zip->set_number('0383834')->is_valid_number, '青森県南津軽郡藤崎町西中野目');
ok($zip->set_number('0383835')->is_valid_number, '青森県南津軽郡藤崎町俵舛');
ok($zip->set_number('0383836')->is_valid_number, '青森県南津軽郡藤崎町下俵舛');
ok($zip->set_number('0383837')->is_valid_number, '青森県南津軽郡藤崎町柏木堰');
ok($zip->set_number('0383874')->is_valid_number, '青森県弘前市津賀野(その他)');
ok($zip->set_number('0390100')->is_valid_number, '青森県三戸郡三戸町以下に掲載がない場合');
ok($zip->set_number('0390100')->is_valid_number, '青森県三戸郡南部町以下に掲載がない場合');
ok($zip->set_number('0390101')->is_valid_number, '青森県三戸郡南部町玉掛');
ok($zip->set_number('0390102')->is_valid_number, '青森県三戸郡南部町赤石');
ok($zip->set_number('0390103')->is_valid_number, '青森県三戸郡南部町大向');
ok($zip->set_number('0390104')->is_valid_number, '青森県三戸郡南部町小向');
ok($zip->set_number('0390105')->is_valid_number, '青森県三戸郡南部町沖田面');
ok($zip->set_number('0390106')->is_valid_number, '青森県三戸郡南部町相内(その他)');
ok($zip->set_number('0390111')->is_valid_number, '青森県三戸郡三戸町泉山');
ok($zip->set_number('0390112')->is_valid_number, '青森県三戸郡三戸町梅内');
ok($zip->set_number('0390113')->is_valid_number, '青森県三戸郡三戸町目時');
ok($zip->set_number('0390121')->is_valid_number, '青森県三戸郡三戸町豊川');
ok($zip->set_number('0390122')->is_valid_number, '青森県三戸郡三戸町斗内');
ok($zip->set_number('0390131')->is_valid_number, '青森県三戸郡三戸町二日町');
ok($zip->set_number('0390132')->is_valid_number, '青森県三戸郡三戸町在府小路町');
ok($zip->set_number('0390133')->is_valid_number, '青森県三戸郡三戸町馬喰町');
ok($zip->set_number('0390134')->is_valid_number, '青森県三戸郡三戸町同心町');
ok($zip->set_number('0390135')->is_valid_number, '青森県三戸郡三戸町八日町');
ok($zip->set_number('0390141')->is_valid_number, '青森県三戸郡三戸町川守田');
ok($zip->set_number('0390142')->is_valid_number, '青森県三戸郡三戸町久慈町');
ok($zip->set_number('0390143')->is_valid_number, '青森県三戸郡三戸町川守田町');
ok($zip->set_number('0390144')->is_valid_number, '青森県三戸郡三戸町六日町');
ok($zip->set_number('0390200')->is_valid_number, '青森県三戸郡田子町以下に掲載がない場合');
ok($zip->set_number('0390201')->is_valid_number, '青森県三戸郡田子町田子');
ok($zip->set_number('0390202')->is_valid_number, '青森県三戸郡田子町相米');
ok($zip->set_number('0390311')->is_valid_number, '青森県三戸郡田子町原');
ok($zip->set_number('0390312')->is_valid_number, '青森県三戸郡田子町石亀');
ok($zip->set_number('0390313')->is_valid_number, '青森県三戸郡田子町茂市');
ok($zip->set_number('0390314')->is_valid_number, '青森県三戸郡田子町遠瀬');
ok($zip->set_number('0390315')->is_valid_number, '青森県三戸郡田子町夏坂');
ok($zip->set_number('0390316')->is_valid_number, '青森県三戸郡田子町関');
ok($zip->set_number('0390317')->is_valid_number, '青森県三戸郡田子町山口');
ok($zip->set_number('0390451')->is_valid_number, '青森県三戸郡三戸町蛇沼');
ok($zip->set_number('0390452')->is_valid_number, '青森県三戸郡三戸町袴田');
ok($zip->set_number('0390453')->is_valid_number, '青森県三戸郡三戸町貝守');
ok($zip->set_number('0390501')->is_valid_number, '青森県三戸郡南部町上名久井');
ok($zip->set_number('0390502')->is_valid_number, '青森県三戸郡南部町下名久井');
ok($zip->set_number('0390503')->is_valid_number, '青森県三戸郡南部町平');
ok($zip->set_number('0390504')->is_valid_number, '青森県三戸郡南部町鳥舌内');
ok($zip->set_number('0390505')->is_valid_number, '青森県三戸郡南部町鳥谷');
ok($zip->set_number('0390506')->is_valid_number, '青森県三戸郡南部町法光寺');
ok($zip->set_number('0390507')->is_valid_number, '青森県三戸郡南部町高瀬');
ok($zip->set_number('0390606')->is_valid_number, '青森県三戸郡南部町相内(柏木久保、鴨ノ首、留ノ沢、沼久保、屋敷久保)');
ok($zip->set_number('0390611')->is_valid_number, '青森県三戸郡南部町斗賀');
ok($zip->set_number('0390612')->is_valid_number, '青森県三戸郡南部町剣吉');
ok($zip->set_number('0390613')->is_valid_number, '青森県三戸郡南部町森越');
ok($zip->set_number('0390614')->is_valid_number, '青森県三戸郡南部町虎渡');
ok($zip->set_number('0390801')->is_valid_number, '青森県三戸郡南部町片岸');
ok($zip->set_number('0390802')->is_valid_number, '青森県三戸郡南部町苫米地');
ok($zip->set_number('0390803')->is_valid_number, '青森県三戸郡南部町麦沢');
ok($zip->set_number('0390804')->is_valid_number, '青森県三戸郡南部町高橋');
ok($zip->set_number('0390805')->is_valid_number, '青森県三戸郡南部町小泉');
ok($zip->set_number('0390811')->is_valid_number, '青森県三戸郡南部町法師岡');
ok($zip->set_number('0390812')->is_valid_number, '青森県三戸郡南部町椛木');
ok($zip->set_number('0390813')->is_valid_number, '青森県三戸郡南部町杉沢');
ok($zip->set_number('0390814')->is_valid_number, '青森県三戸郡南部町埖渡');
ok($zip->set_number('0390815')->is_valid_number, '青森県三戸郡南部町福田');
ok($zip->set_number('0391101')->is_valid_number, '青森県八戸市尻内町');
ok($zip->set_number('0391102')->is_valid_number, '青森県八戸市一番町');
ok($zip->set_number('0391103')->is_valid_number, '青森県八戸市長苗代');
ok($zip->set_number('0391104')->is_valid_number, '青森県八戸市田面木');
ok($zip->set_number('0391105')->is_valid_number, '青森県八戸市八幡');
ok($zip->set_number('0391106')->is_valid_number, '青森県八戸市坂牛');
ok($zip->set_number('0391107')->is_valid_number, '青森県八戸市櫛引(その他)');
ok($zip->set_number('0391108')->is_valid_number, '青森県八戸市上野');
ok($zip->set_number('0391109')->is_valid_number, '青森県八戸市豊崎町');
ok($zip->set_number('0391111')->is_valid_number, '青森県八戸市東白山台');
ok($zip->set_number('0391112')->is_valid_number, '青森県八戸市南白山台');
ok($zip->set_number('0391113')->is_valid_number, '青森県八戸市西白山台');
ok($zip->set_number('0391114')->is_valid_number, '青森県八戸市北白山台');
ok($zip->set_number('0391121')->is_valid_number, '青森県八戸市卸センター');
ok($zip->set_number('0391160')->is_valid_number, '青森県八戸市小田');
ok($zip->set_number('0391161')->is_valid_number, '青森県八戸市河原木');
ok($zip->set_number('0391162')->is_valid_number, '青森県八戸市豊洲');
ok($zip->set_number('0391163')->is_valid_number, '青森県八戸市高州');
ok($zip->set_number('0391164')->is_valid_number, '青森県八戸市下長');
ok($zip->set_number('0391165')->is_valid_number, '青森県八戸市石堂');
ok($zip->set_number('0391166')->is_valid_number, '青森県八戸市根城');
ok($zip->set_number('0391167')->is_valid_number, '青森県八戸市沢里');
ok($zip->set_number('0391168')->is_valid_number, '青森県八戸市八太郎');
ok($zip->set_number('0391169')->is_valid_number, '青森県八戸市日計');
ok($zip->set_number('0391200')->is_valid_number, '青森県三戸郡階上町以下に掲載がない場合');
ok($zip->set_number('0391201')->is_valid_number, '青森県三戸郡階上町道仏');
ok($zip->set_number('0391202')->is_valid_number, '青森県三戸郡階上町赤保内');
ok($zip->set_number('0391203')->is_valid_number, '青森県三戸郡階上町鳥屋部');
ok($zip->set_number('0391204')->is_valid_number, '青森県三戸郡階上町平内');
ok($zip->set_number('0391205')->is_valid_number, '青森県三戸郡階上町晴山沢');
ok($zip->set_number('0391206')->is_valid_number, '青森県三戸郡階上町田代');
ok($zip->set_number('0391207')->is_valid_number, '青森県三戸郡階上町金山沢');
ok($zip->set_number('0391208')->is_valid_number, '青森県三戸郡階上町角柄折');
ok($zip->set_number('0391211')->is_valid_number, '青森県三戸郡階上町蒼前東');
ok($zip->set_number('0391212')->is_valid_number, '青森県三戸郡階上町蒼前西');
ok($zip->set_number('0391500')->is_valid_number, '青森県三戸郡五戸町以下に掲載がない場合');
ok($zip->set_number('0391501')->is_valid_number, '青森県三戸郡五戸町上市川');
ok($zip->set_number('0391502')->is_valid_number, '青森県三戸郡五戸町切谷内(その他)');
ok($zip->set_number('0391503')->is_valid_number, '青森県三戸郡五戸町大久保');
ok($zip->set_number('0391503')->is_valid_number, '青森県三戸郡五戸町佐野上谷地');
ok($zip->set_number('0391503')->is_valid_number, '青森県三戸郡五戸町鮫ノ口');
ok($zip->set_number('0391504')->is_valid_number, '青森県三戸郡五戸町兎内');
ok($zip->set_number('0391504')->is_valid_number, '青森県三戸郡五戸町兎内上保土沢');
ok($zip->set_number('0391504')->is_valid_number, '青森県三戸郡五戸町兎内下保土沢');
ok($zip->set_number('0391504')->is_valid_number, '青森県三戸郡五戸町兎内下川原');
ok($zip->set_number('0391504')->is_valid_number, '青森県三戸郡五戸町兎内下谷地');
ok($zip->set_number('0391504')->is_valid_number, '青森県三戸郡五戸町上兎内');
ok($zip->set_number('0391505')->is_valid_number, '青森県三戸郡五戸町石仏');
ok($zip->set_number('0391505')->is_valid_number, '青森県三戸郡五戸町石仏上川原');
ok($zip->set_number('0391505')->is_valid_number, '青森県三戸郡五戸町石仏下川原');
ok($zip->set_number('0391505')->is_valid_number, '青森県三戸郡五戸町石仏前');
ok($zip->set_number('0391506')->is_valid_number, '青森県三戸郡五戸町熊野林');
ok($zip->set_number('0391506')->is_valid_number, '青森県三戸郡五戸町熊野林後');
ok($zip->set_number('0391506')->is_valid_number, '青森県三戸郡五戸町熊野林前');
ok($zip->set_number('0391507')->is_valid_number, '青森県三戸郡五戸町蛯川後');
ok($zip->set_number('0391507')->is_valid_number, '青森県三戸郡五戸町蛯川前川原');
ok($zip->set_number('0391507')->is_valid_number, '青森県三戸郡五戸町蛯川村');
ok($zip->set_number('0391507')->is_valid_number, '青森県三戸郡五戸町上谷地');
ok($zip->set_number('0391507')->is_valid_number, '青森県三戸郡五戸町中森');
ok($zip->set_number('0391508')->is_valid_number, '青森県三戸郡五戸町赤川');
ok($zip->set_number('0391508')->is_valid_number, '青森県三戸郡五戸町赤川前');
ok($zip->set_number('0391508')->is_valid_number, '青森県三戸郡五戸町上新道');
ok($zip->set_number('0391508')->is_valid_number, '青森県三戸郡五戸町下新道');
ok($zip->set_number('0391508')->is_valid_number, '青森県三戸郡五戸町土取場');
ok($zip->set_number('0391508')->is_valid_number, '青森県三戸郡五戸町中寄');
ok($zip->set_number('0391511')->is_valid_number, '青森県三戸郡五戸町鍜冶屋窪');
ok($zip->set_number('0391511')->is_valid_number, '青森県三戸郡五戸町鍜冶屋窪上ミ');
ok($zip->set_number('0391511')->is_valid_number, '青森県三戸郡五戸町鍜冶屋敷');
ok($zip->set_number('0391511')->is_valid_number, '青森県三戸郡五戸町丁塚');
ok($zip->set_number('0391512')->is_valid_number, '青森県三戸郡五戸町西ノ沢');
ok($zip->set_number('0391513')->is_valid_number, '青森県三戸郡五戸町古館');
ok($zip->set_number('0391513')->is_valid_number, '青森県三戸郡五戸町古館向');
ok($zip->set_number('0391513')->is_valid_number, '青森県三戸郡五戸町古館向川原');
ok($zip->set_number('0391513')->is_valid_number, '青森県三戸郡五戸町古館脇');
ok($zip->set_number('0391514')->is_valid_number, '青森県三戸郡五戸町下中崎');
ok($zip->set_number('0391514')->is_valid_number, '青森県三戸郡五戸町中崎');
ok($zip->set_number('0391515')->is_valid_number, '青森県三戸郡五戸町熊ノ沢');
ok($zip->set_number('0391515')->is_valid_number, '青森県三戸郡五戸町熊ノ沢頭');
ok($zip->set_number('0391515')->is_valid_number, '青森県三戸郡五戸町治郎左エ門長根');
ok($zip->set_number('0391516')->is_valid_number, '青森県三戸郡五戸町市川道十文字');
ok($zip->set_number('0391517')->is_valid_number, '青森県三戸郡五戸町沢向');
ok($zip->set_number('0391518')->is_valid_number, '青森県三戸郡五戸町下モ沢向');
ok($zip->set_number('0391519')->is_valid_number, '青森県三戸郡五戸町天満');
ok($zip->set_number('0391519')->is_valid_number, '青森県三戸郡五戸町天満後');
ok($zip->set_number('0391519')->is_valid_number, '青森県三戸郡五戸町天満下川原');
ok($zip->set_number('0391521')->is_valid_number, '青森県三戸郡五戸町五百窪');
ok($zip->set_number('0391521')->is_valid_number, '青森県三戸郡五戸町泉窪');
ok($zip->set_number('0391521')->is_valid_number, '青森県三戸郡五戸町大渡');
ok($zip->set_number('0391521')->is_valid_number, '青森県三戸郡五戸町大渡道ノ下');
ok($zip->set_number('0391521')->is_valid_number, '青森県三戸郡五戸町久蔵窪');
ok($zip->set_number('0391522')->is_valid_number, '青森県三戸郡五戸町小渡');
ok($zip->set_number('0391522')->is_valid_number, '青森県三戸郡五戸町小渡頭');
ok($zip->set_number('0391522')->is_valid_number, '青森県三戸郡五戸町徳良窪');
ok($zip->set_number('0391522')->is_valid_number, '青森県三戸郡五戸町苗代沢');
ok($zip->set_number('0391523')->is_valid_number, '青森県三戸郡五戸町上保土沢');
ok($zip->set_number('0391523')->is_valid_number, '青森県三戸郡五戸町下保土沢');
ok($zip->set_number('0391523')->is_valid_number, '青森県三戸郡五戸町新蔵長根');
ok($zip->set_number('0391524')->is_valid_number, '青森県三戸郡五戸町豊間内');
ok($zip->set_number('0391525')->is_valid_number, '青森県三戸郡五戸町地蔵岱');
ok($zip->set_number('0391526')->is_valid_number, '青森県三戸郡五戸町上長下');
ok($zip->set_number('0391526')->is_valid_number, '青森県三戸郡五戸町下長下');
ok($zip->set_number('0391526')->is_valid_number, '青森県三戸郡五戸町惣林橋');
ok($zip->set_number('0391527')->is_valid_number, '青森県三戸郡五戸町扇田');
ok($zip->set_number('0391528')->is_valid_number, '青森県三戸郡五戸町浅水');
ok($zip->set_number('0391529')->is_valid_number, '青森県三戸郡五戸町手倉橋');
ok($zip->set_number('0391531')->is_valid_number, '青森県三戸郡五戸町狐森');
ok($zip->set_number('0391531')->is_valid_number, '青森県三戸郡五戸町狐森北');
ok($zip->set_number('0391532')->is_valid_number, '青森県三戸郡五戸町観音堂');
ok($zip->set_number('0391533')->is_valid_number, '青森県三戸郡五戸町上大町');
ok($zip->set_number('0391533')->is_valid_number, '青森県三戸郡五戸町野月');
ok($zip->set_number('0391534')->is_valid_number, '青森県三戸郡五戸町荒町');
ok($zip->set_number('0391535')->is_valid_number, '青森県三戸郡五戸町新丁');
ok($zip->set_number('0391536')->is_valid_number, '青森県三戸郡五戸町愛宕後');
ok($zip->set_number('0391536')->is_valid_number, '青森県三戸郡五戸町愛宕下タ');
ok($zip->set_number('0391536')->is_valid_number, '青森県三戸郡五戸町愛宕丁');
ok($zip->set_number('0391537')->is_valid_number, '青森県三戸郡五戸町ウルエ長根');
ok($zip->set_number('0391537')->is_valid_number, '青森県三戸郡五戸町ウルエ長根下');
ok($zip->set_number('0391537')->is_valid_number, '青森県三戸郡五戸町追分');
ok($zip->set_number('0391537')->is_valid_number, '青森県三戸郡五戸町二本柳');
ok($zip->set_number('0391537')->is_valid_number, '青森県三戸郡五戸町二本柳向');
ok($zip->set_number('0391538')->is_valid_number, '青森県三戸郡五戸町塚無岱');
ok($zip->set_number('0391538')->is_valid_number, '青森県三戸郡五戸町古街道長根');
ok($zip->set_number('0391539')->is_valid_number, '青森県三戸郡五戸町石沢境');
ok($zip->set_number('0391539')->is_valid_number, '青森県三戸郡五戸町中ノ沢');
ok($zip->set_number('0391539')->is_valid_number, '青森県三戸郡五戸町中ノ沢西張');
ok($zip->set_number('0391541')->is_valid_number, '青森県三戸郡五戸町新田窪');
ok($zip->set_number('0391542')->is_valid_number, '青森県三戸郡五戸町中道');
ok($zip->set_number('0391542')->is_valid_number, '青森県三戸郡五戸町中道十文字');
ok($zip->set_number('0391543')->is_valid_number, '青森県三戸郡五戸町竹原');
ok($zip->set_number('0391544')->is_valid_number, '青森県三戸郡五戸町二階平');
ok($zip->set_number('0391544')->is_valid_number, '青森県三戸郡五戸町二階平下タ');
ok($zip->set_number('0391545')->is_valid_number, '青森県三戸郡五戸町正場沢');
ok($zip->set_number('0391545')->is_valid_number, '青森県三戸郡五戸町正場沢長根');
ok($zip->set_number('0391546')->is_valid_number, '青森県三戸郡五戸町下タノ沢');
ok($zip->set_number('0391546')->is_valid_number, '青森県三戸郡五戸町下タノ沢頭');
ok($zip->set_number('0391546')->is_valid_number, '青森県三戸郡五戸町土井頭');
ok($zip->set_number('0391547')->is_valid_number, '青森県三戸郡五戸町神明後');
ok($zip->set_number('0391548')->is_valid_number, '青森県三戸郡五戸町新町');
ok($zip->set_number('0391551')->is_valid_number, '青森県三戸郡五戸町上新井田');
ok($zip->set_number('0391551')->is_valid_number, '青森県三戸郡五戸町上新井田前');
ok($zip->set_number('0391552')->is_valid_number, '青森県三戸郡五戸町姥堤');
ok($zip->set_number('0391552')->is_valid_number, '青森県三戸郡五戸町上高田');
ok($zip->set_number('0391552')->is_valid_number, '青森県三戸郡五戸町筒口川原');
ok($zip->set_number('0391552')->is_valid_number, '青森県三戸郡五戸町中高田');
ok($zip->set_number('0391553')->is_valid_number, '青森県三戸郡五戸町川原町下裏');
ok($zip->set_number('0391553')->is_valid_number, '青森県三戸郡五戸町川原町西裏');
ok($zip->set_number('0391554')->is_valid_number, '青森県三戸郡五戸町川原町');
ok($zip->set_number('0391554')->is_valid_number, '青森県三戸郡五戸町川原町裏');
ok($zip->set_number('0391554')->is_valid_number, '青森県三戸郡五戸町傳兵ヱ丁');
ok($zip->set_number('0391555')->is_valid_number, '青森県三戸郡五戸町下高田');
ok($zip->set_number('0391555')->is_valid_number, '青森県三戸郡五戸町古堂');
ok($zip->set_number('0391555')->is_valid_number, '青森県三戸郡五戸町古堂後');
ok($zip->set_number('0391556')->is_valid_number, '青森県三戸郡五戸町油出');
ok($zip->set_number('0391557')->is_valid_number, '青森県三戸郡五戸町上川原');
ok($zip->set_number('0391557')->is_valid_number, '青森県三戸郡五戸町八景');
ok($zip->set_number('0391558')->is_valid_number, '青森県三戸郡五戸町沢');
ok($zip->set_number('0391558')->is_valid_number, '青森県三戸郡五戸町館');
ok($zip->set_number('0391558')->is_valid_number, '青森県三戸郡五戸町博労町');
ok($zip->set_number('0391558')->is_valid_number, '青森県三戸郡五戸町堀合');
ok($zip->set_number('0391559')->is_valid_number, '青森県三戸郡五戸町下大町');
ok($zip->set_number('0391559')->is_valid_number, '青森県三戸郡五戸町横丁');
ok($zip->set_number('0391561')->is_valid_number, '青森県三戸郡五戸町赤坂');
ok($zip->set_number('0391561')->is_valid_number, '青森県三戸郡五戸町越掛沢');
ok($zip->set_number('0391561')->is_valid_number, '青森県三戸郡五戸町越掛沢前');
ok($zip->set_number('0391561')->is_valid_number, '青森県三戸郡五戸町越掛沢道下モ');
ok($zip->set_number('0391562')->is_valid_number, '青森県三戸郡五戸町鹿内');
ok($zip->set_number('0391562')->is_valid_number, '青森県三戸郡五戸町鹿内沖');
ok($zip->set_number('0391562')->is_valid_number, '青森県三戸郡五戸町鹿内下モ');
ok($zip->set_number('0391562')->is_valid_number, '青森県三戸郡五戸町鹿内前');
ok($zip->set_number('0391562')->is_valid_number, '青森県三戸郡五戸町白山');
ok($zip->set_number('0391562')->is_valid_number, '青森県三戸郡五戸町白山前');
ok($zip->set_number('0391563')->is_valid_number, '青森県三戸郡五戸町岡谷地');
ok($zip->set_number('0391563')->is_valid_number, '青森県三戸郡五戸町毛無森');
ok($zip->set_number('0391563')->is_valid_number, '青森県三戸郡五戸町大学沢');
ok($zip->set_number('0391563')->is_valid_number, '青森県三戸郡五戸町大学沢向');
ok($zip->set_number('0391563')->is_valid_number, '青森県三戸郡五戸町大工窪');
ok($zip->set_number('0391563')->is_valid_number, '青森県三戸郡五戸町平佐窪');
ok($zip->set_number('0391564')->is_valid_number, '青森県三戸郡五戸町古館下川原');
ok($zip->set_number('0391564')->is_valid_number, '青森県三戸郡五戸町六角');
ok($zip->set_number('0391565')->is_valid_number, '青森県三戸郡五戸町下新井田');
ok($zip->set_number('0391565')->is_valid_number, '青森県三戸郡五戸町下新井田前');
ok($zip->set_number('0391565')->is_valid_number, '青森県三戸郡五戸町花道川原');
ok($zip->set_number('0391566')->is_valid_number, '青森県三戸郡五戸町幸ノ神');
ok($zip->set_number('0391566')->is_valid_number, '青森県三戸郡五戸町幸ノ神前');
ok($zip->set_number('0391567')->is_valid_number, '青森県三戸郡五戸町上大平楽');
ok($zip->set_number('0391567')->is_valid_number, '青森県三戸郡五戸町下大平楽');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町銀杏木');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町銀杏木前');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町一本木');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町一本木前');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町應田');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町傘松');
ok($zip->set_number('0391568')->is_valid_number, '青森県三戸郡五戸町傘松前');
ok($zip->set_number('0391569')->is_valid_number, '青森県三戸郡五戸町根岸');
ok($zip->set_number('0391569')->is_valid_number, '青森県三戸郡五戸町虫追塚前');
ok($zip->set_number('0391701')->is_valid_number, '青森県三戸郡五戸町倉石石沢');
ok($zip->set_number('0391702')->is_valid_number, '青森県三戸郡五戸町倉石中市');
ok($zip->set_number('0391703')->is_valid_number, '青森県三戸郡五戸町倉石又重');
ok($zip->set_number('0391800')->is_valid_number, '青森県三戸郡新郷村以下に掲載がない場合');
ok($zip->set_number('0391801')->is_valid_number, '青森県三戸郡新郷村戸来');
ok($zip->set_number('0391802')->is_valid_number, '青森県三戸郡新郷村西越');
ok($zip->set_number('0392102')->is_valid_number, '青森県上北郡おいらせ町豊栄');
ok($zip->set_number('0392111')->is_valid_number, '青森県上北郡おいらせ町西後谷地');
ok($zip->set_number('0392112')->is_valid_number, '青森県上北郡おいらせ町中野平');
ok($zip->set_number('0392113')->is_valid_number, '青森県上北郡おいらせ町犬毛谷地');
ok($zip->set_number('0392114')->is_valid_number, '青森県上北郡おいらせ町高田');
ok($zip->set_number('0392115')->is_valid_number, '青森県上北郡おいらせ町菜飯');
ok($zip->set_number('0392116')->is_valid_number, '青森県上北郡おいらせ町秋堂');
ok($zip->set_number('0392117')->is_valid_number, '青森県上北郡おいらせ町川端');
ok($zip->set_number('0392118')->is_valid_number, '青森県上北郡おいらせ町彦七川原');
ok($zip->set_number('0392121')->is_valid_number, '青森県上北郡おいらせ町下境');
ok($zip->set_number('0392122')->is_valid_number, '青森県上北郡おいらせ町沼小屋');
ok($zip->set_number('0392123')->is_valid_number, '青森県上北郡おいらせ町西下谷地');
ok($zip->set_number('0392124')->is_valid_number, '青森県上北郡おいらせ町境田');
ok($zip->set_number('0392125')->is_valid_number, '青森県上北郡おいらせ町三本木');
ok($zip->set_number('0392126')->is_valid_number, '青森県上北郡おいらせ町間木');
ok($zip->set_number('0392127')->is_valid_number, '青森県上北郡おいらせ町木崎');
ok($zip->set_number('0392128')->is_valid_number, '青森県上北郡おいらせ町染屋');
ok($zip->set_number('0392129')->is_valid_number, '青森県上北郡おいらせ町中平下長根山');
ok($zip->set_number('0392131')->is_valid_number, '青森県上北郡おいらせ町向川原');
ok($zip->set_number('0392132')->is_valid_number, '青森県上北郡おいらせ町西前川原');
ok($zip->set_number('0392133')->is_valid_number, '青森県上北郡おいらせ町上川原');
ok($zip->set_number('0392134')->is_valid_number, '青森県上北郡おいらせ町馳下り');
ok($zip->set_number('0392135')->is_valid_number, '青森県上北郡おいらせ町立蛇');
ok($zip->set_number('0392136')->is_valid_number, '青森県上北郡おいらせ町中下田');
ok($zip->set_number('0392141')->is_valid_number, '青森県上北郡おいらせ町明土');
ok($zip->set_number('0392142')->is_valid_number, '青森県上北郡おいらせ町小前谷地');
ok($zip->set_number('0392143')->is_valid_number, '青森県上北郡おいらせ町上水下');
ok($zip->set_number('0392144')->is_valid_number, '青森県上北郡おいらせ町丈の端');
ok($zip->set_number('0392145')->is_valid_number, '青森県上北郡おいらせ町上谷地');
ok($zip->set_number('0392146')->is_valid_number, '青森県上北郡おいらせ町中谷地');
ok($zip->set_number('0392147')->is_valid_number, '青森県上北郡おいらせ町赤田前');
ok($zip->set_number('0392151')->is_valid_number, '青森県上北郡おいらせ町向山');
ok($zip->set_number('0392152')->is_valid_number, '青森県上北郡おいらせ町向山東');
ok($zip->set_number('0392153')->is_valid_number, '青森県上北郡おいらせ町山崎');
ok($zip->set_number('0392154')->is_valid_number, '青森県上北郡おいらせ町豊原');
ok($zip->set_number('0392155')->is_valid_number, '青森県上北郡おいらせ町木ノ下西');
ok($zip->set_number('0392156')->is_valid_number, '青森県上北郡おいらせ町木ノ下南');
ok($zip->set_number('0392157')->is_valid_number, '青森県上北郡おいらせ町木ノ下東');
ok($zip->set_number('0392158')->is_valid_number, '青森県上北郡おいらせ町向山南');
ok($zip->set_number('0392161')->is_valid_number, '青森県上北郡おいらせ町西下川原');
ok($zip->set_number('0392162')->is_valid_number, '青森県上北郡おいらせ町南下田');
ok($zip->set_number('0392163')->is_valid_number, '青森県上北郡おいらせ町館越');
ok($zip->set_number('0392164')->is_valid_number, '青森県上北郡おいらせ町神明前');
ok($zip->set_number('0392165')->is_valid_number, '青森県上北郡おいらせ町阿光坊');
ok($zip->set_number('0392171')->is_valid_number, '青森県上北郡おいらせ町新敷');
ok($zip->set_number('0392172')->is_valid_number, '青森県上北郡おいらせ町洗平');
ok($zip->set_number('0392173')->is_valid_number, '青森県上北郡おいらせ町瓢');
ok($zip->set_number('0392180')->is_valid_number, '青森県上北郡おいらせ町住吉');
ok($zip->set_number('0392181')->is_valid_number, '青森県上北郡おいらせ町古間木山');
ok($zip->set_number('0392182')->is_valid_number, '青森県上北郡おいらせ町鶉久保');
ok($zip->set_number('0392183')->is_valid_number, '青森県上北郡おいらせ町鶉久保山');
ok($zip->set_number('0392184')->is_valid_number, '青森県上北郡おいらせ町浜道');
ok($zip->set_number('0392185')->is_valid_number, '青森県上北郡おいらせ町上久保');
ok($zip->set_number('0392186')->is_valid_number, '青森県上北郡おいらせ町北下田');
ok($zip->set_number('0392187')->is_valid_number, '青森県上北郡おいらせ町緑ケ丘');
ok($zip->set_number('0392188')->is_valid_number, '青森県上北郡おいらせ町若葉');
ok($zip->set_number('0392189')->is_valid_number, '青森県上北郡おいらせ町青葉');
ok($zip->set_number('0392200')->is_valid_number, '青森県上北郡おいらせ町以下に掲載がない場合');
ok($zip->set_number('0392201')->is_valid_number, '青森県上北郡おいらせ町二川目');
ok($zip->set_number('0392202')->is_valid_number, '青森県上北郡おいらせ町向平');
ok($zip->set_number('0392203')->is_valid_number, '青森県上北郡おいらせ町一川目');
ok($zip->set_number('0392204')->is_valid_number, '青森県上北郡おいらせ町深沢');
ok($zip->set_number('0392205')->is_valid_number, '青森県上北郡おいらせ町深沢平');
ok($zip->set_number('0392206')->is_valid_number, '青森県上北郡おいらせ町松原');
ok($zip->set_number('0392211')->is_valid_number, '青森県上北郡おいらせ町新田');
ok($zip->set_number('0392212')->is_valid_number, '青森県上北郡おいらせ町東下川原');
ok($zip->set_number('0392213')->is_valid_number, '青森県上北郡おいらせ町堀ノ内');
ok($zip->set_number('0392214')->is_valid_number, '青森県上北郡おいらせ町東前川原');
ok($zip->set_number('0392215')->is_valid_number, '青森県上北郡おいらせ町下屋敷');
ok($zip->set_number('0392216')->is_valid_number, '青森県上北郡おいらせ町後田');
ok($zip->set_number('0392217')->is_valid_number, '青森県上北郡おいらせ町牛込平');
ok($zip->set_number('0392221')->is_valid_number, '青森県上北郡おいらせ町上前田');
ok($zip->set_number('0392222')->is_valid_number, '青森県上北郡おいらせ町下前田');
ok($zip->set_number('0392223')->is_valid_number, '青森県上北郡おいらせ町苗平谷地');
ok($zip->set_number('0392224')->is_valid_number, '青森県上北郡おいらせ町下明堂');
ok($zip->set_number('0392225')->is_valid_number, '青森県上北郡おいらせ町上明堂');
ok($zip->set_number('0392226')->is_valid_number, '青森県上北郡おいらせ町新助川原');
ok($zip->set_number('0392231')->is_valid_number, '青森県上北郡おいらせ町東下谷地');
ok($zip->set_number('0392232')->is_valid_number, '青森県上北郡おいらせ町東後谷地');
ok($zip->set_number('0392233')->is_valid_number, '青森県上北郡おいらせ町沼端');
ok($zip->set_number('0392234')->is_valid_number, '青森県上北郡おいらせ町堤田');
ok($zip->set_number('0392235')->is_valid_number, '青森県上北郡おいらせ町千刈田');
ok($zip->set_number('0392236')->is_valid_number, '青森県上北郡おいらせ町洋光台');
ok($zip->set_number('0392241')->is_valid_number, '青森県八戸市市川町');
ok($zip->set_number('0392242')->is_valid_number, '青森県八戸市多賀台');
ok($zip->set_number('0392243')->is_valid_number, '青森県八戸市松ケ丘');
ok($zip->set_number('0392245')->is_valid_number, '青森県八戸市北インター工業団地');
ok($zip->set_number('0392246')->is_valid_number, '青森県八戸市桔梗野工業団地');
ok($zip->set_number('0392251')->is_valid_number, '青森県上北郡おいらせ町向坂');
ok($zip->set_number('0392252')->is_valid_number, '青森県上北郡おいらせ町黒坂谷地');
ok($zip->set_number('0392253')->is_valid_number, '青森県上北郡おいらせ町獺野');
ok($zip->set_number('0392254')->is_valid_number, '青森県上北郡おいらせ町苗振谷地');
ok($zip->set_number('0392255')->is_valid_number, '青森県上北郡おいらせ町土取');
ok($zip->set_number('0392300')->is_valid_number, '青森県上北郡六戸町以下に掲載がない場合');
ok($zip->set_number('0392302')->is_valid_number, '青森県三戸郡五戸町切谷内(北田ノ沢)');
ok($zip->set_number('0392311')->is_valid_number, '青森県上北郡六戸町上吉田');
ok($zip->set_number('0392312')->is_valid_number, '青森県上北郡六戸町下吉田');
ok($zip->set_number('0392313')->is_valid_number, '青森県上北郡六戸町鶴喰');
ok($zip->set_number('0392314')->is_valid_number, '青森県上北郡六戸町小平');
ok($zip->set_number('0392315')->is_valid_number, '青森県上北郡六戸町柳町');
ok($zip->set_number('0392371')->is_valid_number, '青森県上北郡六戸町犬落瀬(その他)');
ok($zip->set_number('0392372')->is_valid_number, '青森県上北郡六戸町折茂(その他)');
ok($zip->set_number('0392401')->is_valid_number, '青森県上北郡東北町上野');
ok($zip->set_number('0392402')->is_valid_number, '青森県上北郡東北町大浦');
ok($zip->set_number('0392403')->is_valid_number, '青森県上北郡東北町新舘');
ok($zip->set_number('0392404')->is_valid_number, '青森県上北郡東北町上北北');
ok($zip->set_number('0392405')->is_valid_number, '青森県上北郡東北町上北南');
ok($zip->set_number('0392406')->is_valid_number, '青森県上北郡東北町旭北');
ok($zip->set_number('0392407')->is_valid_number, '青森県上北郡東北町旭南');
ok($zip->set_number('0392500')->is_valid_number, '青森県上北郡七戸町以下に掲載がない場合');
ok($zip->set_number('0392501')->is_valid_number, '青森県上北郡七戸町荒熊内');
ok($zip->set_number('0392502')->is_valid_number, '青森県上北郡七戸町大沢');
ok($zip->set_number('0392503')->is_valid_number, '青森県上北郡七戸町豊間内');
ok($zip->set_number('0392504')->is_valid_number, '青森県上北郡七戸町寒水');
ok($zip->set_number('0392505')->is_valid_number, '青森県上北郡七戸町立野頭');
ok($zip->set_number('0392506')->is_valid_number, '青森県上北郡七戸町膝森');
ok($zip->set_number('0392507')->is_valid_number, '青森県上北郡七戸町えぞ花');
ok($zip->set_number('0392508')->is_valid_number, '青森県上北郡七戸町大池');
ok($zip->set_number('0392511')->is_valid_number, '青森県上北郡七戸町笊田川久保');
ok($zip->set_number('0392512')->is_valid_number, '青森県上北郡七戸町笊田');
ok($zip->set_number('0392513')->is_valid_number, '青森県上北郡七戸町東槻木');
ok($zip->set_number('0392514')->is_valid_number, '青森県上北郡七戸町太田野');
ok($zip->set_number('0392515')->is_valid_number, '青森県上北郡七戸町蒼前');
ok($zip->set_number('0392516')->is_valid_number, '青森県上北郡七戸町舘野');
ok($zip->set_number('0392517')->is_valid_number, '青森県上北郡七戸町夏焼');
ok($zip->set_number('0392518')->is_valid_number, '青森県上北郡七戸町天神林');
ok($zip->set_number('0392521')->is_valid_number, '青森県上北郡七戸町天王');
ok($zip->set_number('0392522')->is_valid_number, '青森県上北郡七戸町倉越');
ok($zip->set_number('0392523')->is_valid_number, '青森県上北郡七戸町影津内');
ok($zip->set_number('0392524')->is_valid_number, '青森県上北郡七戸町寺裏');
ok($zip->set_number('0392525')->is_valid_number, '青森県上北郡七戸町七戸');
ok($zip->set_number('0392526')->is_valid_number, '青森県上北郡七戸町上町野');
ok($zip->set_number('0392527')->is_valid_number, '青森県上北郡七戸町町');
ok($zip->set_number('0392531')->is_valid_number, '青森県上北郡七戸町太田');
ok($zip->set_number('0392532')->is_valid_number, '青森県上北郡七戸町大林');
ok($zip->set_number('0392533')->is_valid_number, '青森県上北郡七戸町川去');
ok($zip->set_number('0392534')->is_valid_number, '青森県上北郡七戸町荒屋');
ok($zip->set_number('0392535')->is_valid_number, '青森県上北郡七戸町沼ノ沢');
ok($zip->set_number('0392536')->is_valid_number, '青森県上北郡七戸町野佐掛');
ok($zip->set_number('0392537')->is_valid_number, '青森県上北郡七戸町賽ノ神');
ok($zip->set_number('0392538')->is_valid_number, '青森県上北郡七戸町寺下');
ok($zip->set_number('0392539')->is_valid_number, '青森県上北郡七戸町中村');
ok($zip->set_number('0392541')->is_valid_number, '青森県上北郡七戸町都平');
ok($zip->set_number('0392542')->is_valid_number, '青森県上北郡七戸町萩ノ沢');
ok($zip->set_number('0392543')->is_valid_number, '青森県上北郡七戸町有田沢');
ok($zip->set_number('0392544')->is_valid_number, '青森県上北郡七戸町八栗平');
ok($zip->set_number('0392545')->is_valid_number, '青森県上北郡七戸町別曽');
ok($zip->set_number('0392546')->is_valid_number, '青森県上北郡七戸町清水頭');
ok($zip->set_number('0392547')->is_valid_number, '青森県上北郡七戸町矢倉');
ok($zip->set_number('0392548')->is_valid_number, '青森県上北郡七戸町見町');
ok($zip->set_number('0392549')->is_valid_number, '青森県上北郡七戸町下見町');
ok($zip->set_number('0392551')->is_valid_number, '青森県上北郡七戸町薬師平');
ok($zip->set_number('0392552')->is_valid_number, '青森県上北郡七戸町鶴打田');
ok($zip->set_number('0392553')->is_valid_number, '青森県上北郡七戸町八尺堂');
ok($zip->set_number('0392554')->is_valid_number, '青森県上北郡七戸町中岫');
ok($zip->set_number('0392555')->is_valid_number, '青森県上北郡七戸町前田');
ok($zip->set_number('0392556')->is_valid_number, '青森県上北郡七戸町西槻木');
ok($zip->set_number('0392557')->is_valid_number, '青森県上北郡七戸町西野');
ok($zip->set_number('0392558')->is_valid_number, '青森県上北郡七戸町高屋敷');
ok($zip->set_number('0392559')->is_valid_number, '青森県上北郡七戸町山屋');
ok($zip->set_number('0392561')->is_valid_number, '青森県上北郡七戸町銀南木');
ok($zip->set_number('0392562')->is_valid_number, '青森県上北郡七戸町倉岡');
ok($zip->set_number('0392563')->is_valid_number, '青森県上北郡七戸町向平');
ok($zip->set_number('0392564')->is_valid_number, '青森県上北郡七戸町古屋敷');
ok($zip->set_number('0392565')->is_valid_number, '青森県上北郡七戸町治部袋');
ok($zip->set_number('0392566')->is_valid_number, '青森県上北郡七戸町放森');
ok($zip->set_number('0392567')->is_valid_number, '青森県上北郡七戸町鶴児平');
ok($zip->set_number('0392568')->is_valid_number, '青森県上北郡七戸町左組');
ok($zip->set_number('0392569')->is_valid_number, '青森県上北郡七戸町馬門川原');
ok($zip->set_number('0392571')->is_valid_number, '青森県上北郡七戸町蛇坂');
ok($zip->set_number('0392572')->is_valid_number, '青森県上北郡七戸町城ノ後');
ok($zip->set_number('0392573')->is_valid_number, '青森県上北郡七戸町野続');
ok($zip->set_number('0392574')->is_valid_number, '青森県上北郡七戸町宇道坂');
ok($zip->set_number('0392575')->is_valid_number, '青森県上北郡七戸町作田');
ok($zip->set_number('0392576')->is_valid_number, '青森県上北郡七戸町桜田');
ok($zip->set_number('0392577')->is_valid_number, '青森県上北郡七戸町鍛治林');
ok($zip->set_number('0392578')->is_valid_number, '青森県上北郡七戸町貝ノ口');
ok($zip->set_number('0392579')->is_valid_number, '青森県上北郡七戸町十役野');
ok($zip->set_number('0392581')->is_valid_number, '青森県上北郡七戸町東上川原');
ok($zip->set_number('0392582')->is_valid_number, '青森県上北郡七戸町西上川原');
ok($zip->set_number('0392583')->is_valid_number, '青森県上北郡七戸町前川原');
ok($zip->set_number('0392584')->is_valid_number, '青森県上北郡七戸町後川原');
ok($zip->set_number('0392585')->is_valid_number, '青森県上北郡七戸町上ノ山');
ok($zip->set_number('0392586')->is_valid_number, '青森県上北郡七戸町海内');
ok($zip->set_number('0392587')->is_valid_number, '青森県上北郡七戸町上屋田');
ok($zip->set_number('0392588')->is_valid_number, '青森県上北郡七戸町和田下');
ok($zip->set_number('0392589')->is_valid_number, '青森県上北郡七戸町和田');
ok($zip->set_number('0392600')->is_valid_number, '青森県上北郡東北町以下に掲載がない場合');
ok($zip->set_number('0392601')->is_valid_number, '青森県上北郡東北町ガス平');
ok($zip->set_number('0392602')->is_valid_number, '青森県上北郡東北町五十嵐');
ok($zip->set_number('0392602')->is_valid_number, '青森県上北郡東北町細津橋ノ上');
ok($zip->set_number('0392603')->is_valid_number, '青森県上北郡東北町横沢山');
ok($zip->set_number('0392604')->is_valid_number, '青森県上北郡東北町空久保');
ok($zip->set_number('0392604')->is_valid_number, '青森県上北郡東北町饅頭長根');
ok($zip->set_number('0392604')->is_valid_number, '青森県上北郡東北町水流');
ok($zip->set_number('0392604')->is_valid_number, '青森県上北郡東北町横沢');
ok($zip->set_number('0392604')->is_valid_number, '青森県上北郡東北町横沢頭');
ok($zip->set_number('0392605')->is_valid_number, '青森県上北郡東北町淋代');
ok($zip->set_number('0392605')->is_valid_number, '青森県上北郡東北町高森');
ok($zip->set_number('0392606')->is_valid_number, '青森県上北郡東北町数牛');
ok($zip->set_number('0392606')->is_valid_number, '青森県上北郡東北町谷地頭');
ok($zip->set_number('0392607')->is_valid_number, '青森県上北郡東北町姥沢');
ok($zip->set_number('0392611')->is_valid_number, '青森県上北郡東北町中村道ノ上');
ok($zip->set_number('0392611')->is_valid_number, '青森県上北郡東北町中村道ノ下');
ok($zip->set_number('0392612')->is_valid_number, '青森県上北郡東北町狼ノ沢');
ok($zip->set_number('0392612')->is_valid_number, '青森県上北郡東北町沼添左ノ平');
ok($zip->set_number('0392612')->is_valid_number, '青森県上北郡東北町浜台');
ok($zip->set_number('0392613')->is_valid_number, '青森県上北郡東北町子ノ鳥平');
ok($zip->set_number('0392613')->is_valid_number, '青森県上北郡東北町野田頭');
ok($zip->set_number('0392613')->is_valid_number, '青森県上北郡東北町野田頭山');
ok($zip->set_number('0392613')->is_valid_number, '青森県上北郡東北町野田尻');
ok($zip->set_number('0392614')->is_valid_number, '青森県上北郡東北町切左坂道ノ下');
ok($zip->set_number('0392615')->is_valid_number, '青森県上北郡東北町細津');
ok($zip->set_number('0392615')->is_valid_number, '青森県上北郡東北町萌出道ノ上');
ok($zip->set_number('0392615')->is_valid_number, '青森県上北郡東北町萌出道ノ下');
ok($zip->set_number('0392616')->is_valid_number, '青森県上北郡東北町切左坂道ノ上');
ok($zip->set_number('0392617')->is_valid_number, '青森県上北郡東北町水喰');
ok($zip->set_number('0392617')->is_valid_number, '青森県上北郡東北町水喰向');
ok($zip->set_number('0392621')->is_valid_number, '青森県上北郡東北町田ノ沢');
ok($zip->set_number('0392622')->is_valid_number, '青森県上北郡東北町浜家苫');
ok($zip->set_number('0392622')->is_valid_number, '青森県上北郡東北町船ケ沢');
ok($zip->set_number('0392623')->is_valid_number, '青森県上北郡東北町大久保');
ok($zip->set_number('0392623')->is_valid_number, '青森県上北郡東北町鶴ケ崎');
ok($zip->set_number('0392623')->is_valid_number, '青森県上北郡東北町横志多');
ok($zip->set_number('0392624')->is_valid_number, '青森県上北郡東北町蓼内久保');
ok($zip->set_number('0392624')->is_valid_number, '青森県上北郡東北町古屋敷');
ok($zip->set_number('0392624')->is_valid_number, '青森県上北郡東北町道ノ北');
ok($zip->set_number('0392625')->is_valid_number, '青森県上北郡東北町長久保');
ok($zip->set_number('0392626')->is_valid_number, '青森県上北郡東北町後久保');
ok($zip->set_number('0392626')->is_valid_number, '青森県上北郡東北町上久保');
ok($zip->set_number('0392626')->is_valid_number, '青森県上北郡東北町堤尻');
ok($zip->set_number('0392627')->is_valid_number, '青森県上北郡東北町漆玉');
ok($zip->set_number('0392631')->is_valid_number, '青森県上北郡東北町滝沢平');
ok($zip->set_number('0392632')->is_valid_number, '青森県上北郡東北町日影林ノ上山');
ok($zip->set_number('0392633')->is_valid_number, '青森県上北郡東北町素柄邸');
ok($zip->set_number('0392633')->is_valid_number, '青森県上北郡東北町和山平');
ok($zip->set_number('0392634')->is_valid_number, '青森県上北郡東北町往来ノ下');
ok($zip->set_number('0392635')->is_valid_number, '青森県上北郡東北町乙越');
ok($zip->set_number('0392635')->is_valid_number, '青森県上北郡東北町舘');
ok($zip->set_number('0392635')->is_valid_number, '青森県上北郡東北町鳥口平');
ok($zip->set_number('0392636')->is_valid_number, '青森県上北郡東北町往来ノ上');
ok($zip->set_number('0392641')->is_valid_number, '青森県上北郡東北町枋木');
ok($zip->set_number('0392642')->is_valid_number, '青森県上北郡東北町寒水');
ok($zip->set_number('0392642')->is_valid_number, '青森県上北郡東北町寒水下');
ok($zip->set_number('0392642')->is_valid_number, '青森県上北郡東北町寒水山');
ok($zip->set_number('0392643')->is_valid_number, '青森県上北郡東北町乙部道ノ上');
ok($zip->set_number('0392643')->is_valid_number, '青森県上北郡東北町乙部道ノ下');
ok($zip->set_number('0392644')->is_valid_number, '青森県上北郡東北町保戸沢家ノ上');
ok($zip->set_number('0392644')->is_valid_number, '青森県上北郡東北町保戸沢家ノ前');
ok($zip->set_number('0392644')->is_valid_number, '青森県上北郡東北町保戸沢家ノ後');
ok($zip->set_number('0392645')->is_valid_number, '青森県上北郡東北町外蛯沢前平');
ok($zip->set_number('0392646')->is_valid_number, '青森県上北郡東北町外蛯沢西平');
ok($zip->set_number('0392647')->is_valid_number, '青森県上北郡東北町外蛯沢後久保');
ok($zip->set_number('0392648')->is_valid_number, '青森県上北郡東北町外蛯沢北久保');
ok($zip->set_number('0392651')->is_valid_number, '青森県上北郡東北町大沢');
ok($zip->set_number('0392652')->is_valid_number, '青森県上北郡東北町ほとけ沢');
ok($zip->set_number('0392653')->is_valid_number, '青森県上北郡東北町下山');
ok($zip->set_number('0392654')->is_valid_number, '青森県上北郡東北町塔ノ沢山');
ok($zip->set_number('0392655')->is_valid_number, '青森県上北郡東北町内蛯沢道ノ上');
ok($zip->set_number('0392656')->is_valid_number, '青森県上北郡東北町内蛯沢向');
ok($zip->set_number('0392657')->is_valid_number, '青森県上北郡東北町赤川道');
ok($zip->set_number('0392661')->is_valid_number, '青森県上北郡東北町上笹橋');
ok($zip->set_number('0392662')->is_valid_number, '青森県上北郡東北町下笹橋');
ok($zip->set_number('0392663')->is_valid_number, '青森県上北郡東北町舘花');
ok($zip->set_number('0392664')->is_valid_number, '青森県上北郡東北町乙供');
ok($zip->set_number('0392665')->is_valid_number, '青森県上北郡東北町柳沢');
ok($zip->set_number('0392666')->is_valid_number, '青森県上北郡東北町乙供山');
ok($zip->set_number('0392667')->is_valid_number, '青森県上北郡東北町膳前');
ok($zip->set_number('0392668')->is_valid_number, '青森県上北郡東北町北膳前');
ok($zip->set_number('0392668')->is_valid_number, '青森県上北郡東北町篠内平');
ok($zip->set_number('0392671')->is_valid_number, '青森県上北郡東北町小沢');
ok($zip->set_number('0392672')->is_valid_number, '青森県上北郡東北町栗山添');
ok($zip->set_number('0392672')->is_valid_number, '青森県上北郡東北町向籏屋');
ok($zip->set_number('0392673')->is_valid_number, '青森県上北郡東北町馬尻');
ok($zip->set_number('0392673')->is_valid_number, '青森県上北郡東北町大籏屋');
ok($zip->set_number('0392673')->is_valid_number, '青森県上北郡東北町向屋敷');
ok($zip->set_number('0392673')->is_valid_number, '青森県上北郡東北町山ノ下');
ok($zip->set_number('0392674')->is_valid_number, '青森県上北郡東北町千曳下山');
ok($zip->set_number('0392674')->is_valid_number, '青森県上北郡東北町夫雑原');
ok($zip->set_number('0392675')->is_valid_number, '青森県上北郡東北町千曳');
ok($zip->set_number('0392676')->is_valid_number, '青森県上北郡東北町下板橋');
ok($zip->set_number('0392677')->is_valid_number, '青森県上北郡東北町夫雑原下山');
ok($zip->set_number('0392678')->is_valid_number, '青森県上北郡東北町狐沢山');
ok($zip->set_number('0392678')->is_valid_number, '青森県上北郡東北町坂ノ下');
ok($zip->set_number('0392678')->is_valid_number, '青森県上北郡東北町田面木');
ok($zip->set_number('0392678')->is_valid_number, '青森県上北郡東北町長者久保');
ok($zip->set_number('0392681')->is_valid_number, '青森県上北郡東北町家ノ前');
ok($zip->set_number('0392681')->is_valid_number, '青森県上北郡東北町山添');
ok($zip->set_number('0392682')->is_valid_number, '青森県上北郡東北町石坂');
ok($zip->set_number('0392682')->is_valid_number, '青森県上北郡東北町湯沢');
ok($zip->set_number('0392683')->is_valid_number, '青森県上北郡東北町板橋山');
ok($zip->set_number('0392683')->is_valid_number, '青森県上北郡東北町大平');
ok($zip->set_number('0392684')->is_valid_number, '青森県上北郡東北町向平');
ok($zip->set_number('0392685')->is_valid_number, '青森県上北郡東北町家ノ下タ');
ok($zip->set_number('0392685')->is_valid_number, '青森県上北郡東北町上板橋家ノ後');
ok($zip->set_number('0392686')->is_valid_number, '青森県上北郡東北町宇道坂');
ok($zip->set_number('0392686')->is_valid_number, '青森県上北郡東北町塞ノ神');
ok($zip->set_number('0392686')->is_valid_number, '青森県上北郡東北町添ノ沢');
ok($zip->set_number('0392687')->is_valid_number, '青森県上北郡東北町上清水目');
ok($zip->set_number('0392687')->is_valid_number, '青森県上北郡東北町林ノ下');
ok($zip->set_number('0392688')->is_valid_number, '青森県上北郡東北町大撫沢');
ok($zip->set_number('0392711')->is_valid_number, '青森県上北郡七戸町中天間舘');
ok($zip->set_number('0392712')->is_valid_number, '青森県上北郡七戸町北天間舘');
ok($zip->set_number('0392713')->is_valid_number, '青森県上北郡七戸町東天間舘');
ok($zip->set_number('0392714')->is_valid_number, '青森県上北郡七戸町上志多');
ok($zip->set_number('0392715')->is_valid_number, '青森県上北郡七戸町尾山頭');
ok($zip->set_number('0392716')->is_valid_number, '青森県上北郡七戸町菩提木');
ok($zip->set_number('0392717')->is_valid_number, '青森県上北郡七戸町柳平');
ok($zip->set_number('0392721')->is_valid_number, '青森県上北郡七戸町志茂川原');
ok($zip->set_number('0392722')->is_valid_number, '青森県上北郡七戸町向川原');
ok($zip->set_number('0392723')->is_valid_number, '青森県上北郡七戸町下志多');
ok($zip->set_number('0392724')->is_valid_number, '青森県上北郡七戸町上平');
ok($zip->set_number('0392725')->is_valid_number, '青森県上北郡七戸町上川原');
ok($zip->set_number('0392726')->is_valid_number, '青森県上北郡七戸町李川原');
ok($zip->set_number('0392731')->is_valid_number, '青森県上北郡七戸町後平');
ok($zip->set_number('0392732')->is_valid_number, '青森県上北郡七戸町卒古沢');
ok($zip->set_number('0392733')->is_valid_number, '青森県上北郡七戸町天間舘前川原');
ok($zip->set_number('0392741')->is_valid_number, '青森県上北郡七戸町猪ノ鼻');
ok($zip->set_number('0392742')->is_valid_number, '青森県上北郡七戸町舟場向川久保');
ok($zip->set_number('0392743')->is_valid_number, '青森県上北郡七戸町寺沢前');
ok($zip->set_number('0392744')->is_valid_number, '青森県上北郡七戸町塚長根');
ok($zip->set_number('0392745')->is_valid_number, '青森県上北郡七戸町夷堂');
ok($zip->set_number('0392746')->is_valid_number, '青森県上北郡七戸町附田川目');
ok($zip->set_number('0392747')->is_valid_number, '青森県上北郡七戸町附田家ノ前');
ok($zip->set_number('0392748')->is_valid_number, '青森県上北郡七戸町南舘向');
ok($zip->set_number('0392751')->is_valid_number, '青森県上北郡七戸町貝塚家ノ前');
ok($zip->set_number('0392752')->is_valid_number, '青森県上北郡七戸町鉢森平');
ok($zip->set_number('0392753')->is_valid_number, '青森県上北郡七戸町竿打川原');
ok($zip->set_number('0392754')->is_valid_number, '青森県上北郡七戸町地蔵堂');
ok($zip->set_number('0392755')->is_valid_number, '青森県上北郡七戸町榎林家ノ前');
ok($zip->set_number('0392756')->is_valid_number, '青森県上北郡七戸町榎林家ノ後');
ok($zip->set_number('0392757')->is_valid_number, '青森県上北郡七戸町卒古沢南平');
ok($zip->set_number('0392761')->is_valid_number, '青森県上北郡七戸町二ツ森家ノ後');
ok($zip->set_number('0392762')->is_valid_number, '青森県上北郡七戸町二ツ森家ノ下');
ok($zip->set_number('0392763')->is_valid_number, '青森県上北郡七戸町二ツ森家ノ表');
ok($zip->set_number('0392771')->is_valid_number, '青森県上北郡七戸町姥沢');
ok($zip->set_number('0392772')->is_valid_number, '青森県上北郡七戸町下田坪');
ok($zip->set_number('0392773')->is_valid_number, '青森県上北郡七戸町前左野');
ok($zip->set_number('0392774')->is_valid_number, '青森県上北郡七戸町柴舘道ノ下');
ok($zip->set_number('0392775')->is_valid_number, '青森県上北郡七戸町李沢道ノ下');
ok($zip->set_number('0392776')->is_valid_number, '青森県上北郡七戸町李沢家ノ前');
ok($zip->set_number('0392777')->is_valid_number, '青森県上北郡七戸町李沢家ノ後');
ok($zip->set_number('0392778')->is_valid_number, '青森県上北郡七戸町坂ノ外');
ok($zip->set_number('0392779')->is_valid_number, '青森県上北郡七戸町榎林古屋敷');
ok($zip->set_number('0392781')->is_valid_number, '青森県上北郡七戸町花松林ノ根');
ok($zip->set_number('0392782')->is_valid_number, '青森県上北郡七戸町中岫太田嶋');
ok($zip->set_number('0392783')->is_valid_number, '青森県上北郡七戸町中岫番屋');
ok($zip->set_number('0392784')->is_valid_number, '青森県上北郡七戸町中岫長沢下');
ok($zip->set_number('0392785')->is_valid_number, '青森県上北郡七戸町中岫村ノ上');
ok($zip->set_number('0392786')->is_valid_number, '青森県上北郡七戸町中岫東道添');
ok($zip->set_number('0392801')->is_valid_number, '青森県上北郡七戸町野崎');
ok($zip->set_number('0392802')->is_valid_number, '青森県上北郡七戸町野崎前平');
ok($zip->set_number('0392803')->is_valid_number, '青森県上北郡七戸町野崎森ノ下');
ok($zip->set_number('0392804')->is_valid_number, '青森県上北郡七戸町野崎狐久保');
ok($zip->set_number('0392805')->is_valid_number, '青森県上北郡七戸町原久保');
ok($zip->set_number('0392811')->is_valid_number, '青森県上北郡七戸町天間舘荒谷');
ok($zip->set_number('0392812')->is_valid_number, '青森県上北郡七戸町小田下');
ok($zip->set_number('0392813')->is_valid_number, '青森県上北郡七戸町小田平');
ok($zip->set_number('0392814')->is_valid_number, '青森県上北郡七戸町道ノ下');
ok($zip->set_number('0392815')->is_valid_number, '青森県上北郡七戸町森ノ下');
ok($zip->set_number('0392816')->is_valid_number, '青森県上北郡七戸町家ノ裏');
ok($zip->set_number('0392821')->is_valid_number, '青森県上北郡七戸町大平');
ok($zip->set_number('0392822')->is_valid_number, '青森県上北郡七戸町小又');
ok($zip->set_number('0392823')->is_valid_number, '青森県上北郡七戸町館ノ下');
ok($zip->set_number('0392824')->is_valid_number, '青森県上北郡七戸町家ノ下');
ok($zip->set_number('0392825')->is_valid_number, '青森県上北郡七戸町家ノ上');
ok($zip->set_number('0392826')->is_valid_number, '青森県上北郡七戸町中野');
ok($zip->set_number('0392827')->is_valid_number, '青森県上北郡七戸町森ノ上');
ok($zip->set_number('0392828')->is_valid_number, '青森県上北郡七戸町森ケ沢');
ok($zip->set_number('0392831')->is_valid_number, '青森県上北郡七戸町金沢平');
ok($zip->set_number('0392832')->is_valid_number, '青森県上北郡七戸町道ノ上');
ok($zip->set_number('0392833')->is_valid_number, '青森県上北郡七戸町家ノ前');
ok($zip->set_number('0392834')->is_valid_number, '青森県上北郡七戸町向中野川向');
ok($zip->set_number('0392835')->is_valid_number, '青森県上北郡七戸町松ケ沢');
ok($zip->set_number('0392841')->is_valid_number, '青森県上北郡七戸町下鳥谷部');
ok($zip->set_number('0392842')->is_valid_number, '青森県上北郡七戸町中鳥谷');
ok($zip->set_number('0392843')->is_valid_number, '青森県上北郡七戸町橋ノ上');
ok($zip->set_number('0392844')->is_valid_number, '青森県上北郡七戸町手代森');
ok($zip->set_number('0392845')->is_valid_number, '青森県上北郡七戸町作田道');
ok($zip->set_number('0392846')->is_valid_number, '青森県上北郡七戸町鳥谷部');
ok($zip->set_number('0392851')->is_valid_number, '青森県上北郡七戸町堰根');
ok($zip->set_number('0392852')->is_valid_number, '青森県上北郡七戸町さそう');
ok($zip->set_number('0392853')->is_valid_number, '青森県上北郡七戸町さそう平');
ok($zip->set_number('0392854')->is_valid_number, '青森県上北郡七戸町高井名');
ok($zip->set_number('0392855')->is_valid_number, '青森県上北郡七戸町底田');
ok($zip->set_number('0392856')->is_valid_number, '青森県上北郡七戸町古和備');
ok($zip->set_number('0392857')->is_valid_number, '青森県上北郡七戸町天間舘倉越');
ok($zip->set_number('0392861')->is_valid_number, '青森県上北郡七戸町天間舘大沢');
ok($zip->set_number('0392862')->is_valid_number, '青森県上北郡七戸町夏間木');
ok($zip->set_number('0392863')->is_valid_number, '青森県上北郡七戸町十枝内');
ok($zip->set_number('0392864')->is_valid_number, '青森県上北郡七戸町下モ川原');
ok($zip->set_number('0392865')->is_valid_number, '青森県上北郡七戸町市ノ渡');
ok($zip->set_number('0392866')->is_valid_number, '青森県上北郡七戸町栗ノ木沢');
ok($zip->set_number('0392871')->is_valid_number, '青森県上北郡七戸町白石');
ok($zip->set_number('0392872')->is_valid_number, '青森県上北郡七戸町下タ川原');
ok($zip->set_number('0392873')->is_valid_number, '青森県上北郡七戸町天間舘寒水');
ok($zip->set_number('0392874')->is_valid_number, '青森県上北郡七戸町坪川原');
ok($zip->set_number('0392875')->is_valid_number, '青森県上北郡七戸町淋代');
ok($zip->set_number('0392876')->is_valid_number, '青森県上北郡七戸町堰代');
ok($zip->set_number('0392877')->is_valid_number, '青森県上北郡七戸町五庵ノ下');
ok($zip->set_number('0393100')->is_valid_number, '青森県上北郡野辺地町以下に掲載がない場合');
ok($zip->set_number('0393101')->is_valid_number, '青森県上北郡野辺地町浜掛');
ok($zip->set_number('0393102')->is_valid_number, '青森県上北郡野辺地町米内沢');
ok($zip->set_number('0393103')->is_valid_number, '青森県上北郡野辺地町田名部道');
ok($zip->set_number('0393104')->is_valid_number, '青森県上北郡野辺地町大月平');
ok($zip->set_number('0393105')->is_valid_number, '青森県上北郡野辺地町有戸鳥井平');
ok($zip->set_number('0393105')->is_valid_number, '青森県上北郡野辺地町木明');
ok($zip->set_number('0393105')->is_valid_number, '青森県上北郡野辺地町東太田沢');
ok($zip->set_number('0393105')->is_valid_number, '青森県上北郡野辺地町干草橋');
ok($zip->set_number('0393106')->is_valid_number, '青森県上北郡野辺地町蟹田');
ok($zip->set_number('0393106')->is_valid_number, '青森県上北郡野辺地町古明前');
ok($zip->set_number('0393106')->is_valid_number, '青森県上北郡野辺地町明前');
ok($zip->set_number('0393107')->is_valid_number, '青森県上北郡野辺地町小沢平');
ok($zip->set_number('0393108')->is_valid_number, '青森県上北郡野辺地町有戸');
ok($zip->set_number('0393108')->is_valid_number, '青森県上北郡野辺地町下道');
ok($zip->set_number('0393108')->is_valid_number, '青森県上北郡野辺地町中田');
ok($zip->set_number('0393109')->is_valid_number, '青森県上北郡野辺地町向田');
ok($zip->set_number('0393111')->is_valid_number, '青森県上北郡野辺地町石神裏');
ok($zip->set_number('0393112')->is_valid_number, '青森県上北郡野辺地町中道');
ok($zip->set_number('0393113')->is_valid_number, '青森県上北郡野辺地町田狭沢');
ok($zip->set_number('0393114')->is_valid_number, '青森県上北郡野辺地町助佐小路');
ok($zip->set_number('0393115')->is_valid_number, '青森県上北郡野辺地町タラノ木');
ok($zip->set_number('0393116')->is_valid_number, '青森県上北郡野辺地町赤坂');
ok($zip->set_number('0393117')->is_valid_number, '青森県上北郡野辺地町下坂');
ok($zip->set_number('0393118')->is_valid_number, '青森県上北郡野辺地町寺ノ沢');
ok($zip->set_number('0393121')->is_valid_number, '青森県上北郡野辺地町船橋');
ok($zip->set_number('0393122')->is_valid_number, '青森県上北郡野辺地町雑吉沢');
ok($zip->set_number('0393123')->is_valid_number, '青森県上北郡野辺地町種川');
ok($zip->set_number('0393124')->is_valid_number, '青森県上北郡野辺地町白岩');
ok($zip->set_number('0393125')->is_valid_number, '青森県上北郡野辺地町坊ノ塚');
ok($zip->set_number('0393126')->is_valid_number, '青森県上北郡野辺地町下前田');
ok($zip->set_number('0393127')->is_valid_number, '青森県上北郡野辺地町上川原');
ok($zip->set_number('0393128')->is_valid_number, '青森県上北郡野辺地町上前田');
ok($zip->set_number('0393128')->is_valid_number, '青森県上北郡野辺地町昼場');
ok($zip->set_number('0393129')->is_valid_number, '青森県上北郡野辺地町新田');
ok($zip->set_number('0393129')->is_valid_number, '青森県上北郡野辺地町戸田ノ沢');
ok($zip->set_number('0393129')->is_valid_number, '青森県上北郡野辺地町餅粟川原');
ok($zip->set_number('0393131')->is_valid_number, '青森県上北郡野辺地町野辺地');
ok($zip->set_number('0393141')->is_valid_number, '青森県上北郡野辺地町鳴沢');
ok($zip->set_number('0393142')->is_valid_number, '青森県上北郡野辺地町久田');
ok($zip->set_number('0393143')->is_valid_number, '青森県上北郡野辺地町川目');
ok($zip->set_number('0393143')->is_valid_number, '青森県上北郡野辺地町中屋敷');
ok($zip->set_number('0393144')->is_valid_number, '青森県上北郡野辺地町一ノ渡');
ok($zip->set_number('0393145')->is_valid_number, '青森県上北郡野辺地町松ノ木平');
ok($zip->set_number('0393146')->is_valid_number, '青森県上北郡野辺地町下松ノ木平');
ok($zip->set_number('0393147')->is_valid_number, '青森県上北郡野辺地町下与田川');
ok($zip->set_number('0393148')->is_valid_number, '青森県上北郡野辺地町与田川尻');
ok($zip->set_number('0393151')->is_valid_number, '青森県上北郡野辺地町白岩向');
ok($zip->set_number('0393152')->is_valid_number, '青森県上北郡野辺地町下小中野');
ok($zip->set_number('0393153')->is_valid_number, '青森県上北郡野辺地町中小中野');
ok($zip->set_number('0393154')->is_valid_number, '青森県上北郡野辺地町上小中野');
ok($zip->set_number('0393155')->is_valid_number, '青森県上北郡野辺地町切明');
ok($zip->set_number('0393156')->is_valid_number, '青森県上北郡野辺地町枇杷野');
ok($zip->set_number('0393157')->is_valid_number, '青森県上北郡野辺地町獅子沢');
ok($zip->set_number('0393157')->is_valid_number, '青森県上北郡野辺地町松ノ木');
ok($zip->set_number('0393158')->is_valid_number, '青森県上北郡野辺地町観音林後');
ok($zip->set_number('0393159')->is_valid_number, '青森県上北郡野辺地町観音林脇');
ok($zip->set_number('0393161')->is_valid_number, '青森県上北郡野辺地町馬門道');
ok($zip->set_number('0393162')->is_valid_number, '青森県上北郡野辺地町笹館');
ok($zip->set_number('0393163')->is_valid_number, '青森県上北郡野辺地町新町裏');
ok($zip->set_number('0393164')->is_valid_number, '青森県上北郡野辺地町前田');
ok($zip->set_number('0393165')->is_valid_number, '青森県上北郡野辺地町観音林前田');
ok($zip->set_number('0393166')->is_valid_number, '青森県上北郡野辺地町二本木向前田');
ok($zip->set_number('0393167')->is_valid_number, '青森県上北郡野辺地町二本木向');
ok($zip->set_number('0393168')->is_valid_number, '青森県上北郡野辺地町前平');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町上御手洗瀬');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町下御手洗瀬');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町滝田');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町槻ノ木');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町二本木');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町二十平');
ok($zip->set_number('0393171')->is_valid_number, '青森県上北郡野辺地町御手洗瀬');
ok($zip->set_number('0393172')->is_valid_number, '青森県上北郡野辺地町鳥井平');
ok($zip->set_number('0393173')->is_valid_number, '青森県上北郡野辺地町陣場川原');
ok($zip->set_number('0393174')->is_valid_number, '青森県上北郡野辺地町大平下');
ok($zip->set_number('0393174')->is_valid_number, '青森県上北郡野辺地町上河渡頭');
ok($zip->set_number('0393174')->is_valid_number, '青森県上北郡野辺地町下河渡頭');
ok($zip->set_number('0393174')->is_valid_number, '青森県上北郡野辺地町田端');
ok($zip->set_number('0393175')->is_valid_number, '青森県上北郡野辺地町地続山');
ok($zip->set_number('0393175')->is_valid_number, '青森県上北郡野辺地町湯沢');
ok($zip->set_number('0393175')->is_valid_number, '青森県上北郡野辺地町湯沢尻');
ok($zip->set_number('0393176')->is_valid_number, '青森県上北郡野辺地町中渡');
ok($zip->set_number('0393177')->is_valid_number, '青森県上北郡野辺地町柴崎');
ok($zip->set_number('0393177')->is_valid_number, '青森県上北郡野辺地町八ノ木谷地');
ok($zip->set_number('0393178')->is_valid_number, '青森県上北郡野辺地町家ノ上');
ok($zip->set_number('0393179')->is_valid_number, '青森県上北郡野辺地町馬門');
ok($zip->set_number('0393200')->is_valid_number, '青森県上北郡六ヶ所村以下に掲載がない場合');
ok($zip->set_number('0393211')->is_valid_number, '青森県上北郡六ヶ所村出戸');
ok($zip->set_number('0393212')->is_valid_number, '青森県上北郡六ヶ所村尾駮');
ok($zip->set_number('0393213')->is_valid_number, '青森県上北郡六ヶ所村鷹架');
ok($zip->set_number('0393214')->is_valid_number, '青森県上北郡六ヶ所村平沼');
ok($zip->set_number('0393215')->is_valid_number, '青森県上北郡六ヶ所村倉内');
ok($zip->set_number('0393300')->is_valid_number, '青森県東津軽郡平内町以下に掲載がない場合');
ok($zip->set_number('0393301')->is_valid_number, '青森県東津軽郡平内町東田沢');
ok($zip->set_number('0393302')->is_valid_number, '青森県東津軽郡平内町白砂');
ok($zip->set_number('0393303')->is_valid_number, '青森県東津軽郡平内町東滝');
ok($zip->set_number('0393311')->is_valid_number, '青森県東津軽郡平内町福館');
ok($zip->set_number('0393312')->is_valid_number, '青森県東津軽郡平内町浅所');
ok($zip->set_number('0393313')->is_valid_number, '青森県東津軽郡平内町沼館');
ok($zip->set_number('0393314')->is_valid_number, '青森県東津軽郡平内町盛田');
ok($zip->set_number('0393315')->is_valid_number, '青森県東津軽郡平内町福島');
ok($zip->set_number('0393321')->is_valid_number, '青森県東津軽郡平内町小湊');
ok($zip->set_number('0393331')->is_valid_number, '青森県東津軽郡平内町浜子');
ok($zip->set_number('0393332')->is_valid_number, '青森県東津軽郡平内町清水川');
ok($zip->set_number('0393333')->is_valid_number, '青森県東津軽郡平内町松野木');
ok($zip->set_number('0393341')->is_valid_number, '青森県東津軽郡平内町薬師野');
ok($zip->set_number('0393342')->is_valid_number, '青森県東津軽郡平内町口広');
ok($zip->set_number('0393343')->is_valid_number, '青森県東津軽郡平内町狩場沢');
ok($zip->set_number('0393351')->is_valid_number, '青森県東津軽郡平内町外童子');
ok($zip->set_number('0393352')->is_valid_number, '青森県東津軽郡平内町内童子');
ok($zip->set_number('0393353')->is_valid_number, '青森県東津軽郡平内町田茂木');
ok($zip->set_number('0393361')->is_valid_number, '青森県東津軽郡平内町藤沢');
ok($zip->set_number('0393362')->is_valid_number, '青森県東津軽郡平内町増田');
ok($zip->set_number('0393363')->is_valid_number, '青森県東津軽郡平内町山口');
ok($zip->set_number('0393364')->is_valid_number, '青森県東津軽郡平内町小豆沢');
ok($zip->set_number('0393371')->is_valid_number, '青森県東津軽郡平内町中野');
ok($zip->set_number('0393372')->is_valid_number, '青森県東津軽郡平内町土屋');
ok($zip->set_number('0393373')->is_valid_number, '青森県東津軽郡平内町浪打');
ok($zip->set_number('0393381')->is_valid_number, '青森県東津軽郡平内町茂浦');
ok($zip->set_number('0393382')->is_valid_number, '青森県東津軽郡平内町稲生');
ok($zip->set_number('0393501')->is_valid_number, '青森県青森市浅虫');
ok($zip->set_number('0393502')->is_valid_number, '青森県青森市久栗坂');
ok($zip->set_number('0393503')->is_valid_number, '青森県青森市野内');
ok($zip->set_number('0393504')->is_valid_number, '青森県青森市矢田');
ok($zip->set_number('0393505')->is_valid_number, '青森県青森市宮田');
ok($zip->set_number('0393506')->is_valid_number, '青森県青森市三本木');
ok($zip->set_number('0393507')->is_valid_number, '青森県青森市馬屋尻');
ok($zip->set_number('0393524')->is_valid_number, '青森県青森市滝沢(その他)');
ok($zip->set_number('0394100')->is_valid_number, '青森県上北郡横浜町以下に掲載がない場合');
ok($zip->set_number('0394101')->is_valid_number, '青森県上北郡横浜町林尻');
ok($zip->set_number('0394102')->is_valid_number, '青森県上北郡横浜町浜田');
ok($zip->set_number('0394103')->is_valid_number, '青森県上北郡横浜町川太郎川目');
ok($zip->set_number('0394104')->is_valid_number, '青森県上北郡横浜町下苗代川目');
ok($zip->set_number('0394105')->is_valid_number, '青森県上北郡横浜町苗代川目');
ok($zip->set_number('0394106')->is_valid_number, '青森県上北郡横浜町有畑');
ok($zip->set_number('0394111')->is_valid_number, '青森県上北郡横浜町大畑');
ok($zip->set_number('0394112')->is_valid_number, '青森県上北郡横浜町夷ケ沢平');
ok($zip->set_number('0394113')->is_valid_number, '青森県上北郡横浜町家ノ前川目');
ok($zip->set_number('0394114')->is_valid_number, '青森県上北郡横浜町大豆田');
ok($zip->set_number('0394115')->is_valid_number, '青森県上北郡横浜町稲荷平');
ok($zip->set_number('0394116')->is_valid_number, '青森県上北郡横浜町中畑');
ok($zip->set_number('0394117')->is_valid_number, '青森県上北郡横浜町鶏沢');
ok($zip->set_number('0394121')->is_valid_number, '青森県上北郡横浜町桧木');
ok($zip->set_number('0394122')->is_valid_number, '青森県上北郡横浜町鶏ケ唄');
ok($zip->set_number('0394123')->is_valid_number, '青森県上北郡横浜町茅平');
ok($zip->set_number('0394124')->is_valid_number, '青森県上北郡横浜町川尻');
ok($zip->set_number('0394131')->is_valid_number, '青森県上北郡横浜町椛名木');
ok($zip->set_number('0394132')->is_valid_number, '青森県上北郡横浜町太郎須田');
ok($zip->set_number('0394133')->is_valid_number, '青森県上北郡横浜町舘の後');
ok($zip->set_number('0394134')->is_valid_number, '青森県上北郡横浜町林の脇');
ok($zip->set_number('0394135')->is_valid_number, '青森県上北郡横浜町林の後');
ok($zip->set_number('0394136')->is_valid_number, '青森県上北郡横浜町横浜');
ok($zip->set_number('0394137')->is_valid_number, '青森県上北郡横浜町下川原');
ok($zip->set_number('0394138')->is_valid_number, '青森県上北郡横浜町塚名平');
ok($zip->set_number('0394141')->is_valid_number, '青森県上北郡横浜町三保野');
ok($zip->set_number('0394142')->is_valid_number, '青森県上北郡横浜町上イタヤノ木');
ok($zip->set_number('0394143')->is_valid_number, '青森県上北郡横浜町屋敷形');
ok($zip->set_number('0394144')->is_valid_number, '青森県上北郡横浜町浜懸');
ok($zip->set_number('0394145')->is_valid_number, '青森県上北郡横浜町寺下');
ok($zip->set_number('0394151')->is_valid_number, '青森県上北郡横浜町向平');
ok($zip->set_number('0394152')->is_valid_number, '青森県上北郡横浜町百目木');
ok($zip->set_number('0394153')->is_valid_number, '青森県上北郡横浜町吹越');
ok($zip->set_number('0394154')->is_valid_number, '青森県上北郡横浜町明神平');
ok($zip->set_number('0394155')->is_valid_number, '青森県上北郡横浜町豊栄平');
ok($zip->set_number('0394156')->is_valid_number, '青森県上北郡横浜町雲雀平');
ok($zip->set_number('0394157')->is_valid_number, '青森県上北郡横浜町二又');
ok($zip->set_number('0394221')->is_valid_number, '青森県下北郡東通村猿ケ森');
ok($zip->set_number('0394222')->is_valid_number, '青森県下北郡東通村砂子又');
ok($zip->set_number('0394223')->is_valid_number, '青森県下北郡東通村小田野沢');
ok($zip->set_number('0394224')->is_valid_number, '青森県下北郡東通村白糠');
ok($zip->set_number('0394301')->is_valid_number, '青森県上北郡六ヶ所村泊');
ok($zip->set_number('0394401')->is_valid_number, '青森県むつ市大畑町');
ok($zip->set_number('0394402')->is_valid_number, '青森県むつ市大畑町正津川');
ok($zip->set_number('0394500')->is_valid_number, '青森県下北郡風間浦村以下に掲載がない場合');
ok($zip->set_number('0394501')->is_valid_number, '青森県下北郡風間浦村下風呂');
ok($zip->set_number('0394502')->is_valid_number, '青森県下北郡風間浦村易国間');
ok($zip->set_number('0394503')->is_valid_number, '青森県下北郡風間浦村蛇浦');
ok($zip->set_number('0394600')->is_valid_number, '青森県下北郡大間町以下に掲載がない場合');
ok($zip->set_number('0394601')->is_valid_number, '青森県下北郡大間町大間');
ok($zip->set_number('0394602')->is_valid_number, '青森県下北郡大間町奥戸');
ok($zip->set_number('0394700')->is_valid_number, '青森県下北郡佐井村以下に掲載がない場合');
ok($zip->set_number('0394701')->is_valid_number, '青森県むつ市川内町(板家戸、野平、福浦山)');
ok($zip->set_number('0394711')->is_valid_number, '青森県下北郡佐井村佐井');
ok($zip->set_number('0394712')->is_valid_number, '青森県下北郡佐井村長後');
ok($zip->set_number('0395201')->is_valid_number, '青森県むつ市川内町(その他)');
ok($zip->set_number('0395202')->is_valid_number, '青森県むつ市川内町桧川');
ok($zip->set_number('0395203')->is_valid_number, '青森県むつ市川内町宿野部');
ok($zip->set_number('0395204')->is_valid_number, '青森県むつ市川内町蛎崎(その他)');
ok($zip->set_number('0395304')->is_valid_number, '青森県むつ市川内町蛎崎(半右エ門沢)');
ok($zip->set_number('0395321')->is_valid_number, '青森県むつ市脇野沢源藤城');
ok($zip->set_number('0395322')->is_valid_number, '青森県むつ市脇野沢滝山');
ok($zip->set_number('0395323')->is_valid_number, '青森県むつ市脇野沢七引');
ok($zip->set_number('0395324')->is_valid_number, '青森県むつ市脇野沢田ノ頭');
ok($zip->set_number('0395325')->is_valid_number, '青森県むつ市脇野沢辰内');
ok($zip->set_number('0395326')->is_valid_number, '青森県むつ市脇野沢桂沢');
ok($zip->set_number('0395327')->is_valid_number, '青森県むつ市脇野沢本村');
ok($zip->set_number('0395331')->is_valid_number, '青森県むつ市脇野沢渡向');
ok($zip->set_number('0395332')->is_valid_number, '青森県むつ市脇野沢瀬野川目');
ok($zip->set_number('0395333')->is_valid_number, '青森県むつ市脇野沢黒岩');
ok($zip->set_number('0395334')->is_valid_number, '青森県むつ市脇野沢新井田');
ok($zip->set_number('0395335')->is_valid_number, '青森県むつ市脇野沢寄浪');
ok($zip->set_number('0395336')->is_valid_number, '青森県むつ市脇野沢蛸田');
ok($zip->set_number('0395337')->is_valid_number, '青森県むつ市脇野沢九艘泊');
ok($zip->set_number('0395341')->is_valid_number, '青森県むつ市脇野沢鹿間平');
ok($zip->set_number('0395342')->is_valid_number, '青森県むつ市脇野沢小沢');
ok($zip->set_number('0395343')->is_valid_number, '青森県むつ市脇野沢小サ沢');
ok($zip->set_number('0395344')->is_valid_number, '青森県むつ市脇野沢稲平');
ok($zip->set_number('0395345')->is_valid_number, '青森県むつ市脇野沢赤坂');
ok($zip->set_number('0395346')->is_valid_number, '青森県むつ市脇野沢口広');
ok($zip->set_number('0400000')->is_valid_number, '北海道函館市以下に掲載がない場合');
ok($zip->set_number('0400001')->is_valid_number, '北海道函館市五稜郭町');
ok($zip->set_number('0400002')->is_valid_number, '北海道函館市柳町');
ok($zip->set_number('0400003')->is_valid_number, '北海道函館市松陰町');
ok($zip->set_number('0400004')->is_valid_number, '北海道函館市杉並町');
ok($zip->set_number('0400005')->is_valid_number, '北海道函館市人見町');
ok($zip->set_number('0400011')->is_valid_number, '北海道函館市本町');
ok($zip->set_number('0400012')->is_valid_number, '北海道函館市時任町');
ok($zip->set_number('0400013')->is_valid_number, '北海道函館市千代台町');
ok($zip->set_number('0400014')->is_valid_number, '北海道函館市中島町');
ok($zip->set_number('0400015')->is_valid_number, '北海道函館市梁川町');
ok($zip->set_number('0400021')->is_valid_number, '北海道函館市的場町');
ok($zip->set_number('0400022')->is_valid_number, '北海道函館市日乃出町');
ok($zip->set_number('0400023')->is_valid_number, '北海道函館市宇賀浦町');
ok($zip->set_number('0400024')->is_valid_number, '北海道函館市高盛町');
ok($zip->set_number('0400025')->is_valid_number, '北海道函館市堀川町');
ok($zip->set_number('0400031')->is_valid_number, '北海道函館市上新川町');
ok($zip->set_number('0400032')->is_valid_number, '北海道函館市新川町');
ok($zip->set_number('0400033')->is_valid_number, '北海道函館市千歳町');
ok($zip->set_number('0400034')->is_valid_number, '北海道函館市大森町');
ok($zip->set_number('0400035')->is_valid_number, '北海道函館市松風町');
ok($zip->set_number('0400036')->is_valid_number, '北海道函館市東雲町');
ok($zip->set_number('0400037')->is_valid_number, '北海道函館市旭町');
ok($zip->set_number('0400041')->is_valid_number, '北海道函館市栄町');
ok($zip->set_number('0400042')->is_valid_number, '北海道函館市東川町');
ok($zip->set_number('0400043')->is_valid_number, '北海道函館市宝来町');
ok($zip->set_number('0400044')->is_valid_number, '北海道函館市青柳町');
ok($zip->set_number('0400045')->is_valid_number, '北海道函館市住吉町');
ok($zip->set_number('0400046')->is_valid_number, '北海道函館市谷地頭町');
ok($zip->set_number('0400051')->is_valid_number, '北海道函館市弁天町');
ok($zip->set_number('0400052')->is_valid_number, '北海道函館市大町');
ok($zip->set_number('0400053')->is_valid_number, '北海道函館市末広町');
ok($zip->set_number('0400054')->is_valid_number, '北海道函館市元町');
ok($zip->set_number('0400055')->is_valid_number, '北海道函館市船見町');
ok($zip->set_number('0400056')->is_valid_number, '北海道函館市弥生町');
ok($zip->set_number('0400057')->is_valid_number, '北海道函館市入舟町');
ok($zip->set_number('0400061')->is_valid_number, '北海道函館市海岸町');
ok($zip->set_number('0400062')->is_valid_number, '北海道函館市大縄町');
ok($zip->set_number('0400063')->is_valid_number, '北海道函館市若松町');
ok($zip->set_number('0400064')->is_valid_number, '北海道函館市大手町');
ok($zip->set_number('0400065')->is_valid_number, '北海道函館市豊川町');
ok($zip->set_number('0400071')->is_valid_number, '北海道函館市追分町');
ok($zip->set_number('0400072')->is_valid_number, '北海道函館市亀田町');
ok($zip->set_number('0400073')->is_valid_number, '北海道函館市宮前町');
ok($zip->set_number('0400074')->is_valid_number, '北海道函館市松川町');
ok($zip->set_number('0400075')->is_valid_number, '北海道函館市万代町');
ok($zip->set_number('0400076')->is_valid_number, '北海道函館市浅野町');
ok($zip->set_number('0400077')->is_valid_number, '北海道函館市吉川町');
ok($zip->set_number('0400078')->is_valid_number, '北海道函館市北浜町');
ok($zip->set_number('0400081')->is_valid_number, '北海道函館市田家町');
ok($zip->set_number('0400082')->is_valid_number, '北海道函館市白鳥町');
ok($zip->set_number('0400083')->is_valid_number, '北海道函館市八幡町');
ok($zip->set_number('0400084')->is_valid_number, '北海道函館市大川町');
ok($zip->set_number('0410251')->is_valid_number, '北海道函館市小安町');
ok($zip->set_number('0410252')->is_valid_number, '北海道函館市釜谷町');
ok($zip->set_number('0410253')->is_valid_number, '北海道函館市小安山町');
ok($zip->set_number('0410261')->is_valid_number, '北海道函館市石崎町');
ok($zip->set_number('0410262')->is_valid_number, '北海道函館市古川町');
ok($zip->set_number('0410263')->is_valid_number, '北海道函館市豊原町');
ok($zip->set_number('0410264')->is_valid_number, '北海道函館市鶴野町');
ok($zip->set_number('0410265')->is_valid_number, '北海道函館市白石町');
ok($zip->set_number('0410301')->is_valid_number, '北海道函館市汐首町');
ok($zip->set_number('0410302')->is_valid_number, '北海道函館市瀬田来町');
ok($zip->set_number('0410303')->is_valid_number, '北海道函館市弁才町');
ok($zip->set_number('0410304')->is_valid_number, '北海道函館市泊町');
ok($zip->set_number('0410305')->is_valid_number, '北海道函館市館町');
ok($zip->set_number('0410306')->is_valid_number, '北海道函館市丸山町');
ok($zip->set_number('0410311')->is_valid_number, '北海道函館市浜町');
ok($zip->set_number('0410312')->is_valid_number, '北海道函館市新二見町');
ok($zip->set_number('0410313')->is_valid_number, '北海道函館市原木町');
ok($zip->set_number('0410401')->is_valid_number, '北海道函館市日浦町');
ok($zip->set_number('0410402')->is_valid_number, '北海道函館市豊浦町');
ok($zip->set_number('0410403')->is_valid_number, '北海道函館市大澗町');
ok($zip->set_number('0410404')->is_valid_number, '北海道函館市中浜町');
ok($zip->set_number('0410405')->is_valid_number, '北海道函館市川上町');
ok($zip->set_number('0410406')->is_valid_number, '北海道函館市女那川町');
ok($zip->set_number('0410407')->is_valid_number, '北海道函館市日和山町');
ok($zip->set_number('0410408')->is_valid_number, '北海道函館市吉畑町');
ok($zip->set_number('0410521')->is_valid_number, '北海道函館市御崎町');
ok($zip->set_number('0410522')->is_valid_number, '北海道函館市恵山町');
ok($zip->set_number('0410523')->is_valid_number, '北海道函館市柏野町');
ok($zip->set_number('0410524')->is_valid_number, '北海道函館市古武井町');
ok($zip->set_number('0410525')->is_valid_number, '北海道函館市日ノ浜町');
ok($zip->set_number('0410526')->is_valid_number, '北海道函館市高岱町');
ok($zip->set_number('0410601')->is_valid_number, '北海道函館市新八幡町');
ok($zip->set_number('0410602')->is_valid_number, '北海道函館市島泊町');
ok($zip->set_number('0410603')->is_valid_number, '北海道函館市富浦町');
ok($zip->set_number('0410604')->is_valid_number, '北海道函館市元村町');
ok($zip->set_number('0410605')->is_valid_number, '北海道函館市恵山岬町');
ok($zip->set_number('0410606')->is_valid_number, '北海道函館市新恵山町');
ok($zip->set_number('0410611')->is_valid_number, '北海道函館市新浜町');
ok($zip->set_number('0410612')->is_valid_number, '北海道函館市銚子町');
ok($zip->set_number('0410613')->is_valid_number, '北海道函館市絵紙山町');
ok($zip->set_number('0410801')->is_valid_number, '北海道函館市桔梗町');
ok($zip->set_number('0410802')->is_valid_number, '北海道函館市石川町');
ok($zip->set_number('0410803')->is_valid_number, '北海道函館市亀田中野町');
ok($zip->set_number('0410804')->is_valid_number, '北海道函館市赤川町');
ok($zip->set_number('0410805')->is_valid_number, '北海道函館市赤川');
ok($zip->set_number('0410806')->is_valid_number, '北海道函館市美原');
ok($zip->set_number('0410807')->is_valid_number, '北海道函館市北美原');
ok($zip->set_number('0410808')->is_valid_number, '北海道函館市桔梗');
ok($zip->set_number('0410811')->is_valid_number, '北海道函館市富岡町');
ok($zip->set_number('0410812')->is_valid_number, '北海道函館市昭和');
ok($zip->set_number('0410813')->is_valid_number, '北海道函館市亀田本町');
ok($zip->set_number('0410821')->is_valid_number, '北海道函館市港町');
ok($zip->set_number('0410822')->is_valid_number, '北海道函館市亀田港町');
ok($zip->set_number('0410823')->is_valid_number, '北海道函館市昭和町');
ok($zip->set_number('0410824')->is_valid_number, '北海道函館市西桔梗町');
ok($zip->set_number('0410831')->is_valid_number, '北海道函館市神山町');
ok($zip->set_number('0410832')->is_valid_number, '北海道函館市神山');
ok($zip->set_number('0410833')->is_valid_number, '北海道函館市陣川町');
ok($zip->set_number('0410834')->is_valid_number, '北海道函館市東山町');
ok($zip->set_number('0410835')->is_valid_number, '北海道函館市東山');
ok($zip->set_number('0410836')->is_valid_number, '北海道函館市山の手');
ok($zip->set_number('0410837')->is_valid_number, '北海道函館市陣川');
ok($zip->set_number('0410841')->is_valid_number, '北海道函館市日吉町');
ok($zip->set_number('0410843')->is_valid_number, '北海道函館市花園町');
ok($zip->set_number('0410844')->is_valid_number, '北海道函館市川原町');
ok($zip->set_number('0410851')->is_valid_number, '北海道函館市本通');
ok($zip->set_number('0410852')->is_valid_number, '北海道函館市鍛治');
ok($zip->set_number('0410853')->is_valid_number, '北海道函館市中道');
ok($zip->set_number('0411100')->is_valid_number, '北海道亀田郡七飯町以下に掲載がない場合');
ok($zip->set_number('0411101')->is_valid_number, '北海道亀田郡七飯町仁山');
ok($zip->set_number('0411102')->is_valid_number, '北海道亀田郡七飯町峠下');
ok($zip->set_number('0411103')->is_valid_number, '北海道亀田郡七飯町藤城');
ok($zip->set_number('0411104')->is_valid_number, '北海道亀田郡七飯町上藤城');
ok($zip->set_number('0411105')->is_valid_number, '北海道亀田郡七飯町桜町');
ok($zip->set_number('0411111')->is_valid_number, '北海道亀田郡七飯町本町');
ok($zip->set_number('0411112')->is_valid_number, '北海道亀田郡七飯町鳴川');
ok($zip->set_number('0411112')->is_valid_number, '北海道亀田郡七飯町鳴川町');
ok($zip->set_number('0411121')->is_valid_number, '北海道亀田郡七飯町大中山');
ok($zip->set_number('0411122')->is_valid_number, '北海道亀田郡七飯町大川');
ok($zip->set_number('0411131')->is_valid_number, '北海道亀田郡七飯町中野');
ok($zip->set_number('0411132')->is_valid_number, '北海道亀田郡七飯町豊田');
ok($zip->set_number('0411133')->is_valid_number, '北海道亀田郡七飯町中島');
ok($zip->set_number('0411134')->is_valid_number, '北海道亀田郡七飯町鶴野');
ok($zip->set_number('0411135')->is_valid_number, '北海道亀田郡七飯町緑町');
ok($zip->set_number('0411136')->is_valid_number, '北海道亀田郡七飯町飯田町');
ok($zip->set_number('0411201')->is_valid_number, '北海道北斗市本町');
ok($zip->set_number('0411211')->is_valid_number, '北海道北斗市白川');
ok($zip->set_number('0411212')->is_valid_number, '北海道北斗市細入');
ok($zip->set_number('0411213')->is_valid_number, '北海道北斗市開発');
ok($zip->set_number('0411214')->is_valid_number, '北海道北斗市東前');
ok($zip->set_number('0411215')->is_valid_number, '北海道北斗市萩野');
ok($zip->set_number('0411221')->is_valid_number, '北海道北斗市清水川');
ok($zip->set_number('0411222')->is_valid_number, '北海道北斗市千代田');
ok($zip->set_number('0411223')->is_valid_number, '北海道北斗市一本木');
ok($zip->set_number('0411224')->is_valid_number, '北海道北斗市南大野');
ok($zip->set_number('0411225')->is_valid_number, '北海道北斗市文月');
ok($zip->set_number('0411226')->is_valid_number, '北海道北斗市村内');
ok($zip->set_number('0411231')->is_valid_number, '北海道北斗市向野');
ok($zip->set_number('0411241')->is_valid_number, '北海道北斗市稲里');
ok($zip->set_number('0411242')->is_valid_number, '北海道北斗市市渡');
ok($zip->set_number('0411243')->is_valid_number, '北海道北斗市中山');
ok($zip->set_number('0411244')->is_valid_number, '北海道北斗市村山');
ok($zip->set_number('0411251')->is_valid_number, '北海道北斗市本郷');
ok($zip->set_number('0411351')->is_valid_number, '北海道亀田郡七飯町東大沼');
ok($zip->set_number('0411352')->is_valid_number, '北海道亀田郡七飯町軍川');
ok($zip->set_number('0411353')->is_valid_number, '北海道亀田郡七飯町上軍川');
ok($zip->set_number('0411354')->is_valid_number, '北海道亀田郡七飯町大沼町');
ok($zip->set_number('0411355')->is_valid_number, '北海道亀田郡七飯町西大沼');
ok($zip->set_number('0411400')->is_valid_number, '北海道茅部郡鹿部町以下に掲載がない場合');
ok($zip->set_number('0411401')->is_valid_number, '北海道茅部郡鹿部町大岩');
ok($zip->set_number('0411402')->is_valid_number, '北海道茅部郡鹿部町鹿部');
ok($zip->set_number('0411403')->is_valid_number, '北海道茅部郡鹿部町宮浜');
ok($zip->set_number('0411404')->is_valid_number, '北海道茅部郡鹿部町本別');
ok($zip->set_number('0411405')->is_valid_number, '北海道茅部郡鹿部町駒見');
ok($zip->set_number('0411601')->is_valid_number, '北海道函館市古部町');
ok($zip->set_number('0411602')->is_valid_number, '北海道函館市木直町');
ok($zip->set_number('0411603')->is_valid_number, '北海道函館市尾札部町');
ok($zip->set_number('0411611')->is_valid_number, '北海道函館市川汲町');
ok($zip->set_number('0411612')->is_valid_number, '北海道函館市安浦町');
ok($zip->set_number('0411613')->is_valid_number, '北海道函館市臼尻町');
ok($zip->set_number('0411621')->is_valid_number, '北海道函館市豊崎町');
ok($zip->set_number('0411622')->is_valid_number, '北海道函館市大船町');
ok($zip->set_number('0411623')->is_valid_number, '北海道函館市双見町');
ok($zip->set_number('0411624')->is_valid_number, '北海道函館市岩戸町');
ok($zip->set_number('0420901')->is_valid_number, '北海道函館市蛾眉野町');
ok($zip->set_number('0420902')->is_valid_number, '北海道函館市鉄山町');
ok($zip->set_number('0420903')->is_valid_number, '北海道函館市東畑町');
ok($zip->set_number('0420904')->is_valid_number, '北海道函館市庵原町');
ok($zip->set_number('0420905')->is_valid_number, '北海道函館市紅葉山町');
ok($zip->set_number('0420906')->is_valid_number, '北海道函館市三森町');
ok($zip->set_number('0420907')->is_valid_number, '北海道函館市鱒川町');
ok($zip->set_number('0420908')->is_valid_number, '北海道函館市銅山町');
ok($zip->set_number('0420911')->is_valid_number, '北海道函館市石倉町');
ok($zip->set_number('0420912')->is_valid_number, '北海道函館市中野町');
ok($zip->set_number('0420913')->is_valid_number, '北海道函館市赤坂町');
ok($zip->set_number('0420914')->is_valid_number, '北海道函館市上湯川町');
ok($zip->set_number('0420915')->is_valid_number, '北海道函館市西旭岡町');
ok($zip->set_number('0420916')->is_valid_number, '北海道函館市旭岡町');
ok($zip->set_number('0420917')->is_valid_number, '北海道函館市亀尾町');
ok($zip->set_number('0420918')->is_valid_number, '北海道函館市米原町');
ok($zip->set_number('0420921')->is_valid_number, '北海道函館市新湊町');
ok($zip->set_number('0420922')->is_valid_number, '北海道函館市銭亀町');
ok($zip->set_number('0420923')->is_valid_number, '北海道函館市志海苔町');
ok($zip->set_number('0420924')->is_valid_number, '北海道函館市根崎町');
ok($zip->set_number('0420931')->is_valid_number, '北海道函館市榎本町');
ok($zip->set_number('0420932')->is_valid_number, '北海道函館市湯川町');
ok($zip->set_number('0420933')->is_valid_number, '北海道函館市湯浜町');
ok($zip->set_number('0420934')->is_valid_number, '北海道函館市広野町');
ok($zip->set_number('0420935')->is_valid_number, '北海道函館市駒場町');
ok($zip->set_number('0420941')->is_valid_number, '北海道函館市深堀町');
ok($zip->set_number('0420942')->is_valid_number, '北海道函館市柏木町');
ok($zip->set_number('0420943')->is_valid_number, '北海道函館市乃木町');
ok($zip->set_number('0420944')->is_valid_number, '北海道函館市金堀町');
ok($zip->set_number('0420951')->is_valid_number, '北海道函館市瀬戸川町');
ok($zip->set_number('0420952')->is_valid_number, '北海道函館市高松町');
ok($zip->set_number('0420953')->is_valid_number, '北海道函館市戸倉町');
ok($zip->set_number('0420954')->is_valid_number, '北海道函館市上野町');
ok($zip->set_number('0420955')->is_valid_number, '北海道函館市高丘町');
ok($zip->set_number('0420956')->is_valid_number, '北海道函館市見晴町');
ok($zip->set_number('0420957')->is_valid_number, '北海道函館市滝沢町');
ok($zip->set_number('0420958')->is_valid_number, '北海道函館市鈴蘭丘町');
ok($zip->set_number('0430000')->is_valid_number, '北海道檜山郡江差町以下に掲載がない場合');
ok($zip->set_number('0430011')->is_valid_number, '北海道檜山郡江差町五厘沢町');
ok($zip->set_number('0430012')->is_valid_number, '北海道檜山郡江差町鰔川町');
ok($zip->set_number('0430013')->is_valid_number, '北海道檜山郡江差町朝日町');
ok($zip->set_number('0430014')->is_valid_number, '北海道檜山郡江差町小黒部町');
ok($zip->set_number('0430015')->is_valid_number, '北海道檜山郡江差町中網町');
ok($zip->set_number('0430016')->is_valid_number, '北海道檜山郡江差町越前町');
ok($zip->set_number('0430017')->is_valid_number, '北海道檜山郡江差町水堀町');
ok($zip->set_number('0430021')->is_valid_number, '北海道檜山郡江差町柳崎町');
ok($zip->set_number('0430022')->is_valid_number, '北海道檜山郡江差町伏木戸町');
ok($zip->set_number('0430023')->is_valid_number, '北海道檜山郡江差町田沢町');
ok($zip->set_number('0430024')->is_valid_number, '北海道檜山郡江差町尾山町');
ok($zip->set_number('0430025')->is_valid_number, '北海道檜山郡江差町泊町');
ok($zip->set_number('0430026')->is_valid_number, '北海道檜山郡江差町大澗町');
ok($zip->set_number('0430031')->is_valid_number, '北海道檜山郡江差町愛宕町');
ok($zip->set_number('0430032')->is_valid_number, '北海道檜山郡江差町新栄町');
ok($zip->set_number('0430033')->is_valid_number, '北海道檜山郡江差町豊川町');
ok($zip->set_number('0430034')->is_valid_number, '北海道檜山郡江差町中歌町');
ok($zip->set_number('0430035')->is_valid_number, '北海道檜山郡江差町桧岱');
ok($zip->set_number('0430036')->is_valid_number, '北海道檜山郡江差町東山');
ok($zip->set_number('0430041')->is_valid_number, '北海道檜山郡江差町姥神町');
ok($zip->set_number('0430042')->is_valid_number, '北海道檜山郡江差町上野町');
ok($zip->set_number('0430043')->is_valid_number, '北海道檜山郡江差町本町');
ok($zip->set_number('0430044')->is_valid_number, '北海道檜山郡江差町橋本町');
ok($zip->set_number('0430045')->is_valid_number, '北海道檜山郡江差町鴎島');
ok($zip->set_number('0430046')->is_valid_number, '北海道檜山郡江差町江差港北埠頭');
ok($zip->set_number('0430051')->is_valid_number, '北海道檜山郡江差町津花町');
ok($zip->set_number('0430052')->is_valid_number, '北海道檜山郡江差町茂尻町');
ok($zip->set_number('0430053')->is_valid_number, '北海道檜山郡江差町新地町');
ok($zip->set_number('0430054')->is_valid_number, '北海道檜山郡江差町緑丘');
ok($zip->set_number('0430055')->is_valid_number, '北海道檜山郡江差町円山');
ok($zip->set_number('0430056')->is_valid_number, '北海道檜山郡江差町陣屋町');
ok($zip->set_number('0430057')->is_valid_number, '北海道檜山郡江差町海岸町');
ok($zip->set_number('0430061')->is_valid_number, '北海道檜山郡江差町南が丘');
ok($zip->set_number('0430062')->is_valid_number, '北海道檜山郡江差町萩の岱');
ok($zip->set_number('0430063')->is_valid_number, '北海道檜山郡江差町南浜町');
ok($zip->set_number('0430064')->is_valid_number, '北海道檜山郡江差町柏町');
ok($zip->set_number('0430065')->is_valid_number, '北海道檜山郡江差町砂川');
ok($zip->set_number('0430066')->is_valid_number, '北海道檜山郡江差町とど川町');
ok($zip->set_number('0430100')->is_valid_number, '北海道爾志郡乙部町以下に掲載がない場合');
ok($zip->set_number('0430101')->is_valid_number, '北海道爾志郡乙部町滝瀬');
ok($zip->set_number('0430102')->is_valid_number, '北海道爾志郡乙部町元町');
ok($zip->set_number('0430103')->is_valid_number, '北海道爾志郡乙部町緑町');
ok($zip->set_number('0430104')->is_valid_number, '北海道爾志郡乙部町館浦');
ok($zip->set_number('0430111')->is_valid_number, '北海道爾志郡乙部町鳥山');
ok($zip->set_number('0430112')->is_valid_number, '北海道爾志郡乙部町栄野');
ok($zip->set_number('0430113')->is_valid_number, '北海道爾志郡乙部町栄浜');
ok($zip->set_number('0430114')->is_valid_number, '北海道爾志郡乙部町元和');
ok($zip->set_number('0430115')->is_valid_number, '北海道爾志郡乙部町富岡');
ok($zip->set_number('0430116')->is_valid_number, '北海道爾志郡乙部町旭岱');
ok($zip->set_number('0430117')->is_valid_number, '北海道爾志郡乙部町姫川');
ok($zip->set_number('0430231')->is_valid_number, '北海道爾志郡乙部町豊浜');
ok($zip->set_number('0430232')->is_valid_number, '北海道爾志郡乙部町花磯');
ok($zip->set_number('0430233')->is_valid_number, '北海道爾志郡乙部町潮見');
ok($zip->set_number('0430234')->is_valid_number, '北海道爾志郡乙部町三ツ谷');
ok($zip->set_number('0430331')->is_valid_number, '北海道二海郡八雲町熊石折戸町');
ok($zip->set_number('0430332')->is_valid_number, '北海道二海郡八雲町熊石相沼町');
ok($zip->set_number('0430333')->is_valid_number, '北海道二海郡八雲町熊石館平町');
ok($zip->set_number('0430334')->is_valid_number, '北海道二海郡八雲町熊石泊川町');
ok($zip->set_number('0430335')->is_valid_number, '北海道二海郡八雲町熊石黒岩町');
ok($zip->set_number('0430401')->is_valid_number, '北海道二海郡八雲町熊石見日町');
ok($zip->set_number('0430402')->is_valid_number, '北海道二海郡八雲町熊石鮎川町');
ok($zip->set_number('0430403')->is_valid_number, '北海道二海郡八雲町熊石平町');
ok($zip->set_number('0430404')->is_valid_number, '北海道二海郡八雲町熊石畳岩町');
ok($zip->set_number('0430405')->is_valid_number, '北海道二海郡八雲町熊石大谷町');
ok($zip->set_number('0430415')->is_valid_number, '北海道二海郡八雲町熊石根崎町');
ok($zip->set_number('0430416')->is_valid_number, '北海道二海郡八雲町熊石雲石町');
ok($zip->set_number('0430417')->is_valid_number, '北海道二海郡八雲町熊石鳴神町');
ok($zip->set_number('0430418')->is_valid_number, '北海道二海郡八雲町熊石関内町');
ok($zip->set_number('0430419')->is_valid_number, '北海道二海郡八雲町熊石西浜町');
ok($zip->set_number('0430421')->is_valid_number, '北海道久遠郡せたな町大成区長磯');
ok($zip->set_number('0430501')->is_valid_number, '北海道久遠郡せたな町大成区太田');
ok($zip->set_number('0430502')->is_valid_number, '北海道久遠郡せたな町大成区富磯');
ok($zip->set_number('0430503')->is_valid_number, '北海道久遠郡せたな町大成区上浦');
ok($zip->set_number('0430504')->is_valid_number, '北海道久遠郡せたな町大成区都');
ok($zip->set_number('0430505')->is_valid_number, '北海道久遠郡せたな町大成区本陣');
ok($zip->set_number('0430511')->is_valid_number, '北海道久遠郡せたな町大成区久遠');
ok($zip->set_number('0430512')->is_valid_number, '北海道久遠郡せたな町大成区花歌');
ok($zip->set_number('0430513')->is_valid_number, '北海道久遠郡せたな町大成区宮野');
ok($zip->set_number('0430514')->is_valid_number, '北海道久遠郡せたな町大成区平浜');
ok($zip->set_number('0430515')->is_valid_number, '北海道久遠郡せたな町大成区貝取澗');
ok($zip->set_number('0431100')->is_valid_number, '北海道檜山郡厚沢部町以下に掲載がない場合');
ok($zip->set_number('0431101')->is_valid_number, '北海道檜山郡厚沢部町清水');
ok($zip->set_number('0431102')->is_valid_number, '北海道檜山郡厚沢部町稲見');
ok($zip->set_number('0431103')->is_valid_number, '北海道檜山郡厚沢部町滝野');
ok($zip->set_number('0431104')->is_valid_number, '北海道檜山郡厚沢部町上里');
ok($zip->set_number('0431111')->is_valid_number, '北海道檜山郡厚沢部町赤沼町');
ok($zip->set_number('0431112')->is_valid_number, '北海道檜山郡厚沢部町緑町');
ok($zip->set_number('0431113')->is_valid_number, '北海道檜山郡厚沢部町新町');
ok($zip->set_number('0431114')->is_valid_number, '北海道檜山郡厚沢部町本町');
ok($zip->set_number('0431115')->is_valid_number, '北海道檜山郡厚沢部町松園町');
ok($zip->set_number('0431116')->is_valid_number, '北海道檜山郡厚沢部町上の山');
ok($zip->set_number('0431117')->is_valid_number, '北海道檜山郡厚沢部町美和');
ok($zip->set_number('0431118')->is_valid_number, '北海道檜山郡厚沢部町富栄');
ok($zip->set_number('0431231')->is_valid_number, '北海道檜山郡厚沢部町共和');
ok($zip->set_number('0431232')->is_valid_number, '北海道檜山郡厚沢部町相生');
ok($zip->set_number('0431233')->is_valid_number, '北海道檜山郡厚沢部町旭丘');
ok($zip->set_number('0431234')->is_valid_number, '北海道檜山郡厚沢部町木間内');
ok($zip->set_number('0431235')->is_valid_number, '北海道檜山郡厚沢部町峠下');
ok($zip->set_number('0431236')->is_valid_number, '北海道檜山郡厚沢部町社の山(その他)');
ok($zip->set_number('0431237')->is_valid_number, '北海道檜山郡厚沢部町鶉町');
ok($zip->set_number('0431238')->is_valid_number, '北海道檜山郡厚沢部町鶉');
ok($zip->set_number('0431351')->is_valid_number, '北海道檜山郡厚沢部町館町');
ok($zip->set_number('0431361')->is_valid_number, '北海道檜山郡厚沢部町社の山(中の沢)');
ok($zip->set_number('0431362')->is_valid_number, '北海道檜山郡厚沢部町須賀');
ok($zip->set_number('0431363')->is_valid_number, '北海道檜山郡厚沢部町富里');
ok($zip->set_number('0431364')->is_valid_number, '北海道檜山郡厚沢部町城丘');
ok($zip->set_number('0431365')->is_valid_number, '北海道檜山郡厚沢部町南館町');
ok($zip->set_number('0431366')->is_valid_number, '北海道檜山郡厚沢部町当路');
ok($zip->set_number('0431367')->is_valid_number, '北海道檜山郡厚沢部町新栄');
ok($zip->set_number('0431368')->is_valid_number, '北海道檜山郡厚沢部町中館');
ok($zip->set_number('0431400')->is_valid_number, '北海道奥尻郡奥尻町以下に掲載がない場合');
ok($zip->set_number('0431401')->is_valid_number, '北海道奥尻郡奥尻町奥尻');
ok($zip->set_number('0431402')->is_valid_number, '北海道奥尻郡奥尻町赤石');
ok($zip->set_number('0431403')->is_valid_number, '北海道奥尻郡奥尻町球浦');
ok($zip->set_number('0431404')->is_valid_number, '北海道奥尻郡奥尻町宮津');
ok($zip->set_number('0431405')->is_valid_number, '北海道奥尻郡奥尻町稲穂');
ok($zip->set_number('0431406')->is_valid_number, '北海道奥尻郡奥尻町湯浜(その他)');
ok($zip->set_number('0431521')->is_valid_number, '北海道奥尻郡奥尻町青苗');
ok($zip->set_number('0431522')->is_valid_number, '北海道奥尻郡奥尻町富里');
ok($zip->set_number('0431523')->is_valid_number, '北海道奥尻郡奥尻町松江');
ok($zip->set_number('0431524')->is_valid_number, '北海道奥尻郡奥尻町米岡');
ok($zip->set_number('0431525')->is_valid_number, '北海道奥尻郡奥尻町湯浜(神威脇、幌内)');
ok($zip->set_number('0440000')->is_valid_number, '北海道虻田郡倶知安町以下に掲載がない場合');
ok($zip->set_number('0440001')->is_valid_number, '北海道虻田郡倶知安町北一条東');
ok($zip->set_number('0440002')->is_valid_number, '北海道虻田郡倶知安町北二条東');
ok($zip->set_number('0440003')->is_valid_number, '北海道虻田郡倶知安町北三条東');
ok($zip->set_number('0440004')->is_valid_number, '北海道虻田郡倶知安町北四条東');
ok($zip->set_number('0440005')->is_valid_number, '北海道虻田郡倶知安町北五条東');
ok($zip->set_number('0440006')->is_valid_number, '北海道虻田郡倶知安町北六条東');
ok($zip->set_number('0440007')->is_valid_number, '北海道虻田郡倶知安町北七条東');
ok($zip->set_number('0440011')->is_valid_number, '北海道虻田郡倶知安町南一条東');
ok($zip->set_number('0440012')->is_valid_number, '北海道虻田郡倶知安町南二条東');
ok($zip->set_number('0440013')->is_valid_number, '北海道虻田郡倶知安町南三条東');
ok($zip->set_number('0440014')->is_valid_number, '北海道虻田郡倶知安町南四条東');
ok($zip->set_number('0440015')->is_valid_number, '北海道虻田郡倶知安町南五条東');
ok($zip->set_number('0440016')->is_valid_number, '北海道虻田郡倶知安町南六条東');
ok($zip->set_number('0440021')->is_valid_number, '北海道虻田郡倶知安町南七条東');
ok($zip->set_number('0440022')->is_valid_number, '北海道虻田郡倶知安町南八条東');
ok($zip->set_number('0440023')->is_valid_number, '北海道虻田郡倶知安町南九条東');
ok($zip->set_number('0440024')->is_valid_number, '北海道虻田郡倶知安町南十条東');
ok($zip->set_number('0440025')->is_valid_number, '北海道虻田郡倶知安町南十一条東');
ok($zip->set_number('0440031')->is_valid_number, '北海道虻田郡倶知安町南一条西');
ok($zip->set_number('0440032')->is_valid_number, '北海道虻田郡倶知安町南二条西');
ok($zip->set_number('0440033')->is_valid_number, '北海道虻田郡倶知安町南三条西');
ok($zip->set_number('0440034')->is_valid_number, '北海道虻田郡倶知安町南四条西');
ok($zip->set_number('0440035')->is_valid_number, '北海道虻田郡倶知安町南五条西');
ok($zip->set_number('0440036')->is_valid_number, '北海道虻田郡倶知安町南六条西');
ok($zip->set_number('0440041')->is_valid_number, '北海道虻田郡倶知安町南七条西');
ok($zip->set_number('0440042')->is_valid_number, '北海道虻田郡倶知安町南八条西');
ok($zip->set_number('0440043')->is_valid_number, '北海道虻田郡倶知安町南九条西');
ok($zip->set_number('0440044')->is_valid_number, '北海道虻田郡倶知安町南十条西');
ok($zip->set_number('0440045')->is_valid_number, '北海道虻田郡倶知安町南十一条西');
ok($zip->set_number('0440051')->is_valid_number, '北海道虻田郡倶知安町北一条西');
ok($zip->set_number('0440052')->is_valid_number, '北海道虻田郡倶知安町北二条西');
ok($zip->set_number('0440053')->is_valid_number, '北海道虻田郡倶知安町北三条西');
ok($zip->set_number('0440054')->is_valid_number, '北海道虻田郡倶知安町北四条西');
ok($zip->set_number('0440055')->is_valid_number, '北海道虻田郡倶知安町北五条西');
ok($zip->set_number('0440056')->is_valid_number, '北海道虻田郡倶知安町北六条西');
ok($zip->set_number('0440057')->is_valid_number, '北海道虻田郡倶知安町北七条西');
ok($zip->set_number('0440061')->is_valid_number, '北海道虻田郡倶知安町大和');
ok($zip->set_number('0440062')->is_valid_number, '北海道虻田郡倶知安町扶桑');
ok($zip->set_number('0440063')->is_valid_number, '北海道虻田郡倶知安町末広');
ok($zip->set_number('0440064')->is_valid_number, '北海道虻田郡倶知安町出雲');
ok($zip->set_number('0440065')->is_valid_number, '北海道虻田郡倶知安町高見');
ok($zip->set_number('0440066')->is_valid_number, '北海道虻田郡倶知安町琴平');
ok($zip->set_number('0440067')->is_valid_number, '北海道虻田郡倶知安町瑞穂');
ok($zip->set_number('0440068')->is_valid_number, '北海道虻田郡倶知安町緑');
ok($zip->set_number('0440071')->is_valid_number, '北海道虻田郡倶知安町寒別');
ok($zip->set_number('0440072')->is_valid_number, '北海道虻田郡倶知安町八幡');
ok($zip->set_number('0440073')->is_valid_number, '北海道虻田郡倶知安町豊岡');
ok($zip->set_number('0440074')->is_valid_number, '北海道虻田郡倶知安町巽');
ok($zip->set_number('0440075')->is_valid_number, '北海道虻田郡倶知安町富士見');
ok($zip->set_number('0440076')->is_valid_number, '北海道虻田郡倶知安町高砂');
ok($zip->set_number('0440077')->is_valid_number, '北海道虻田郡倶知安町比羅夫');
ok($zip->set_number('0440078')->is_valid_number, '北海道虻田郡倶知安町樺山');
ok($zip->set_number('0440081')->is_valid_number, '北海道虻田郡倶知安町山田');
ok($zip->set_number('0440082')->is_valid_number, '北海道虻田郡倶知安町岩尾別');
ok($zip->set_number('0440083')->is_valid_number, '北海道虻田郡倶知安町旭');
ok($zip->set_number('0440084')->is_valid_number, '北海道虻田郡倶知安町花園');
ok($zip->set_number('0440085')->is_valid_number, '北海道虻田郡倶知安町峠下');
ok($zip->set_number('0440100')->is_valid_number, '北海道虻田郡京極町以下に掲載がない場合');
ok($zip->set_number('0440101')->is_valid_number, '北海道虻田郡京極町京極');
ok($zip->set_number('0440111')->is_valid_number, '北海道虻田郡京極町北岡');
ok($zip->set_number('0440112')->is_valid_number, '北海道虻田郡京極町春日');
ok($zip->set_number('0440113')->is_valid_number, '北海道虻田郡京極町松川');
ok($zip->set_number('0440121')->is_valid_number, '北海道虻田郡京極町三崎');
ok($zip->set_number('0440122')->is_valid_number, '北海道虻田郡京極町大富');
ok($zip->set_number('0440123')->is_valid_number, '北海道虻田郡京極町脇方');
ok($zip->set_number('0440124')->is_valid_number, '北海道虻田郡京極町錦');
ok($zip->set_number('0440125')->is_valid_number, '北海道虻田郡京極町東花');
ok($zip->set_number('0440131')->is_valid_number, '北海道虻田郡京極町川西');
ok($zip->set_number('0440132')->is_valid_number, '北海道虻田郡京極町更進');
ok($zip->set_number('0440200')->is_valid_number, '北海道虻田郡喜茂別町以下に掲載がない場合');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町旭町');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町大町');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町喜茂別');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町幸町');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町末広町');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町本町');
ok($zip->set_number('0440201')->is_valid_number, '北海道虻田郡喜茂別町緑町');
ok($zip->set_number('0440211')->is_valid_number, '北海道虻田郡喜茂別町富士見台');
ok($zip->set_number('0440212')->is_valid_number, '北海道虻田郡喜茂別町留産');
ok($zip->set_number('0440213')->is_valid_number, '北海道虻田郡喜茂別町比羅岡');
ok($zip->set_number('0440214')->is_valid_number, '北海道虻田郡喜茂別町尻別');
ok($zip->set_number('0440215')->is_valid_number, '北海道虻田郡喜茂別町相川');
ok($zip->set_number('0440221')->is_valid_number, '北海道虻田郡喜茂別町伏見');
ok($zip->set_number('0440222')->is_valid_number, '北海道虻田郡喜茂別町栄');
ok($zip->set_number('0440223')->is_valid_number, '北海道虻田郡喜茂別町川上');
ok($zip->set_number('0440224')->is_valid_number, '北海道虻田郡喜茂別町知来別');
ok($zip->set_number('0440225')->is_valid_number, '北海道虻田郡喜茂別町福島');
ok($zip->set_number('0440441')->is_valid_number, '北海道伊達市大滝区愛地町');
ok($zip->set_number('0440442')->is_valid_number, '北海道伊達市大滝区宮城町');
ok($zip->set_number('0440443')->is_valid_number, '北海道伊達市大滝区清原町');
ok($zip->set_number('0440444')->is_valid_number, '北海道伊達市大滝区豊里町');
ok($zip->set_number('0440451')->is_valid_number, '北海道虻田郡喜茂別町上尻別');
ok($zip->set_number('0440451')->is_valid_number, '北海道虻田郡喜茂別町鈴川');
ok($zip->set_number('0440452')->is_valid_number, '北海道虻田郡喜茂別町福丘');
ok($zip->set_number('0440453')->is_valid_number, '北海道虻田郡喜茂別町共栄');
ok($zip->set_number('0440453')->is_valid_number, '北海道虻田郡喜茂別町御園');
ok($zip->set_number('0440454')->is_valid_number, '北海道虻田郡喜茂別町金山');
ok($zip->set_number('0440461')->is_valid_number, '北海道虻田郡喜茂別町中里');
ok($zip->set_number('0440461')->is_valid_number, '北海道虻田郡喜茂別町福里');
ok($zip->set_number('0440462')->is_valid_number, '北海道虻田郡喜茂別町花丘');
ok($zip->set_number('0440463')->is_valid_number, '北海道虻田郡喜茂別町双葉');
ok($zip->set_number('0450000')->is_valid_number, '北海道岩内郡岩内町以下に掲載がない場合');
ok($zip->set_number('0450001')->is_valid_number, '北海道岩内郡岩内町大浜');
ok($zip->set_number('0450002')->is_valid_number, '北海道岩内郡岩内町東山');
ok($zip->set_number('0450003')->is_valid_number, '北海道岩内郡岩内町万代');
ok($zip->set_number('0450011')->is_valid_number, '北海道岩内郡岩内町栄');
ok($zip->set_number('0450012')->is_valid_number, '北海道岩内郡岩内町宮園');
ok($zip->set_number('0450013')->is_valid_number, '北海道岩内郡岩内町高台');
ok($zip->set_number('0450021')->is_valid_number, '北海道岩内郡岩内町大和');
ok($zip->set_number('0450022')->is_valid_number, '北海道岩内郡岩内町清住');
ok($zip->set_number('0450023')->is_valid_number, '北海道岩内郡岩内町相生');
ok($zip->set_number('0450024')->is_valid_number, '北海道岩内郡岩内町野束');
ok($zip->set_number('0450025')->is_valid_number, '北海道岩内郡岩内町敷島内');
ok($zip->set_number('0450026')->is_valid_number, '北海道岩内郡岩内町御崎');
ok($zip->set_number('0450031')->is_valid_number, '北海道岩内郡共和町梨野舞納');
ok($zip->set_number('0450032')->is_valid_number, '北海道岩内郡共和町老古美');
ok($zip->set_number('0450121')->is_valid_number, '北海道岩内郡共和町幌似');
ok($zip->set_number('0450122')->is_valid_number, '北海道岩内郡共和町発足');
ok($zip->set_number('0450123')->is_valid_number, '北海道岩内郡共和町宮丘');
ok($zip->set_number('0450200')->is_valid_number, '北海道古宇郡泊村以下に掲載がない場合');
ok($zip->set_number('0450201')->is_valid_number, '北海道古宇郡泊村堀株村');
ok($zip->set_number('0450202')->is_valid_number, '北海道古宇郡泊村茅沼村');
ok($zip->set_number('0450203')->is_valid_number, '北海道古宇郡泊村泊村');
ok($zip->set_number('0450204')->is_valid_number, '北海道古宇郡泊村盃村');
ok($zip->set_number('0450205')->is_valid_number, '北海道古宇郡泊村興志内村');
ok($zip->set_number('0450300')->is_valid_number, '北海道古宇郡神恵内村以下に掲載がない場合');
ok($zip->set_number('0450301')->is_valid_number, '北海道古宇郡神恵内村神恵内村');
ok($zip->set_number('0450302')->is_valid_number, '北海道古宇郡神恵内村赤石村');
ok($zip->set_number('0450303')->is_valid_number, '北海道古宇郡神恵内村珊内村');
ok($zip->set_number('0460000')->is_valid_number, '北海道余市郡余市町以下に掲載がない場合');
ok($zip->set_number('0460001')->is_valid_number, '北海道余市郡余市町栄町');
ok($zip->set_number('0460002')->is_valid_number, '北海道余市郡余市町登町');
ok($zip->set_number('0460003')->is_valid_number, '北海道余市郡余市町黒川町');
ok($zip->set_number('0460004')->is_valid_number, '北海道余市郡余市町大川町');
ok($zip->set_number('0460011')->is_valid_number, '北海道余市郡余市町入舟町');
ok($zip->set_number('0460012')->is_valid_number, '北海道余市郡余市町山田町');
ok($zip->set_number('0460013')->is_valid_number, '北海道余市郡余市町豊丘町');
ok($zip->set_number('0460014')->is_valid_number, '北海道余市郡余市町美園町');
ok($zip->set_number('0460015')->is_valid_number, '北海道余市郡余市町朝日町');
ok($zip->set_number('0460021')->is_valid_number, '北海道余市郡余市町浜中町');
ok($zip->set_number('0460022')->is_valid_number, '北海道余市郡余市町沢町');
ok($zip->set_number('0460023')->is_valid_number, '北海道余市郡余市町梅川町');
ok($zip->set_number('0460024')->is_valid_number, '北海道余市郡余市町港町');
ok($zip->set_number('0460025')->is_valid_number, '北海道余市郡余市町富沢町');
ok($zip->set_number('0460031')->is_valid_number, '北海道余市郡余市町白岩町');
ok($zip->set_number('0460032')->is_valid_number, '北海道余市郡余市町豊浜町');
ok($zip->set_number('0460033')->is_valid_number, '北海道余市郡余市町潮見町');
ok($zip->set_number('0460100')->is_valid_number, '北海道古平郡古平町以下に掲載がない場合');
ok($zip->set_number('0460101')->is_valid_number, '北海道古平郡古平町御崎町');
ok($zip->set_number('0460102')->is_valid_number, '北海道古平郡古平町丸山町');
ok($zip->set_number('0460103')->is_valid_number, '北海道古平郡古平町本町');
ok($zip->set_number('0460104')->is_valid_number, '北海道古平郡古平町入船町');
ok($zip->set_number('0460111')->is_valid_number, '北海道古平郡古平町群来町');
ok($zip->set_number('0460112')->is_valid_number, '北海道古平郡古平町新地町');
ok($zip->set_number('0460113')->is_valid_number, '北海道古平郡古平町港町');
ok($zip->set_number('0460121')->is_valid_number, '北海道古平郡古平町浜町');
ok($zip->set_number('0460131')->is_valid_number, '北海道古平郡古平町沢江町');
ok($zip->set_number('0460132')->is_valid_number, '北海道古平郡古平町歌棄町');
ok($zip->set_number('0460133')->is_valid_number, '北海道古平郡古平町沖町');
ok($zip->set_number('0460200')->is_valid_number, '北海道積丹郡積丹町以下に掲載がない場合');
ok($zip->set_number('0460201')->is_valid_number, '北海道積丹郡積丹町美国町');
ok($zip->set_number('0460202')->is_valid_number, '北海道積丹郡積丹町婦美町');
ok($zip->set_number('0460321')->is_valid_number, '北海道積丹郡積丹町神岬町');
ok($zip->set_number('0460322')->is_valid_number, '北海道積丹郡積丹町余別町');
ok($zip->set_number('0460323')->is_valid_number, '北海道積丹郡積丹町来岸町');
ok($zip->set_number('0460324')->is_valid_number, '北海道積丹郡積丹町西河町');
ok($zip->set_number('0460325')->is_valid_number, '北海道積丹郡積丹町野塚町');
ok($zip->set_number('0460326')->is_valid_number, '北海道積丹郡積丹町日司町');
ok($zip->set_number('0460327')->is_valid_number, '北海道積丹郡積丹町入舸町');
ok($zip->set_number('0460328')->is_valid_number, '北海道積丹郡積丹町幌武意町');
ok($zip->set_number('0460500')->is_valid_number, '北海道余市郡赤井川村以下に掲載がない場合');
ok($zip->set_number('0460501')->is_valid_number, '北海道余市郡赤井川村赤井川');
ok($zip->set_number('0460511')->is_valid_number, '北海道余市郡赤井川村日ノ出');
ok($zip->set_number('0460512')->is_valid_number, '北海道余市郡赤井川村山梨');
ok($zip->set_number('0460521')->is_valid_number, '北海道余市郡赤井川村池田');
ok($zip->set_number('0460531')->is_valid_number, '北海道余市郡赤井川村旭丘');
ok($zip->set_number('0460532')->is_valid_number, '北海道余市郡赤井川村富田');
ok($zip->set_number('0460541')->is_valid_number, '北海道余市郡赤井川村都');
ok($zip->set_number('0460542')->is_valid_number, '北海道余市郡赤井川村曲川');
ok($zip->set_number('0460551')->is_valid_number, '北海道余市郡赤井川村轟');
ok($zip->set_number('0460552')->is_valid_number, '北海道余市郡赤井川村明治');
ok($zip->set_number('0460561')->is_valid_number, '北海道余市郡赤井川村落合');
ok($zip->set_number('0460571')->is_valid_number, '北海道余市郡赤井川村常盤');
ok($zip->set_number('0470000')->is_valid_number, '北海道小樽市以下に掲載がない場合');
ok($zip->set_number('0470001')->is_valid_number, '北海道小樽市若竹町');
ok($zip->set_number('0470002')->is_valid_number, '北海道小樽市潮見台');
ok($zip->set_number('0470003')->is_valid_number, '北海道小樽市真栄');
ok($zip->set_number('0470004')->is_valid_number, '北海道小樽市新富町');
ok($zip->set_number('0470005')->is_valid_number, '北海道小樽市勝納町');
ok($zip->set_number('0470006')->is_valid_number, '北海道小樽市有幌町');
ok($zip->set_number('0470007')->is_valid_number, '北海道小樽市港町');
ok($zip->set_number('0470008')->is_valid_number, '北海道小樽市築港');
ok($zip->set_number('0470011')->is_valid_number, '北海道小樽市天神');
ok($zip->set_number('0470012')->is_valid_number, '北海道小樽市天狗山');
ok($zip->set_number('0470013')->is_valid_number, '北海道小樽市奥沢');
ok($zip->set_number('0470014')->is_valid_number, '北海道小樽市住ノ江');
ok($zip->set_number('0470015')->is_valid_number, '北海道小樽市住吉町');
ok($zip->set_number('0470016')->is_valid_number, '北海道小樽市信香町');
ok($zip->set_number('0470017')->is_valid_number, '北海道小樽市若松');
ok($zip->set_number('0470021')->is_valid_number, '北海道小樽市入船');
ok($zip->set_number('0470022')->is_valid_number, '北海道小樽市松ケ枝');
ok($zip->set_number('0470023')->is_valid_number, '北海道小樽市最上');
ok($zip->set_number('0470024')->is_valid_number, '北海道小樽市花園');
ok($zip->set_number('0470025')->is_valid_number, '北海道小樽市山田町');
ok($zip->set_number('0470026')->is_valid_number, '北海道小樽市東雲町');
ok($zip->set_number('0470027')->is_valid_number, '北海道小樽市堺町');
ok($zip->set_number('0470028')->is_valid_number, '北海道小樽市相生町');
ok($zip->set_number('0470031')->is_valid_number, '北海道小樽市色内');
ok($zip->set_number('0470032')->is_valid_number, '北海道小樽市稲穂');
ok($zip->set_number('0470033')->is_valid_number, '北海道小樽市富岡');
ok($zip->set_number('0470034')->is_valid_number, '北海道小樽市緑');
ok($zip->set_number('0470035')->is_valid_number, '北海道小樽市旭町');
ok($zip->set_number('0470036')->is_valid_number, '北海道小樽市長橋');
ok($zip->set_number('0470037')->is_valid_number, '北海道小樽市幸');
ok($zip->set_number('0470038')->is_valid_number, '北海道小樽市石山町');
ok($zip->set_number('0470039')->is_valid_number, '北海道小樽市錦町');
ok($zip->set_number('0470041')->is_valid_number, '北海道小樽市手宮');
ok($zip->set_number('0470042')->is_valid_number, '北海道小樽市末広町');
ok($zip->set_number('0470043')->is_valid_number, '北海道小樽市豊川町');
ok($zip->set_number('0470044')->is_valid_number, '北海道小樽市梅ケ枝町');
ok($zip->set_number('0470045')->is_valid_number, '北海道小樽市清水町');
ok($zip->set_number('0470046')->is_valid_number, '北海道小樽市赤岩');
ok($zip->set_number('0470047')->is_valid_number, '北海道小樽市祝津');
ok($zip->set_number('0470048')->is_valid_number, '北海道小樽市高島');
ok($zip->set_number('0470151')->is_valid_number, '北海道小樽市朝里');
ok($zip->set_number('0470152')->is_valid_number, '北海道小樽市新光');
ok($zip->set_number('0470153')->is_valid_number, '北海道小樽市新光町');
ok($zip->set_number('0470154')->is_valid_number, '北海道小樽市朝里川温泉');
ok($zip->set_number('0470155')->is_valid_number, '北海道小樽市望洋台');
ok($zip->set_number('0470156')->is_valid_number, '北海道小樽市桜');
ok($zip->set_number('0470157')->is_valid_number, '北海道小樽市船浜町');
ok($zip->set_number('0470261')->is_valid_number, '北海道小樽市銭函(1~3丁目)');
ok($zip->set_number('0470262')->is_valid_number, '北海道小樽市星野町');
ok($zip->set_number('0470263')->is_valid_number, '北海道小樽市見晴町');
ok($zip->set_number('0470264')->is_valid_number, '北海道小樽市桂岡町');
ok($zip->set_number('0470265')->is_valid_number, '北海道小樽市春香町');
ok($zip->set_number('0470266')->is_valid_number, '北海道小樽市張碓町');
ok($zip->set_number('0480100')->is_valid_number, '北海道寿都郡黒松内町以下に掲載がない場合');
ok($zip->set_number('0480101')->is_valid_number, '北海道寿都郡黒松内町黒松内');
ok($zip->set_number('0480111')->is_valid_number, '北海道寿都郡黒松内町中里');
ok($zip->set_number('0480112')->is_valid_number, '北海道寿都郡黒松内町貝殻');
ok($zip->set_number('0480113')->is_valid_number, '北海道寿都郡黒松内町豊幌');
ok($zip->set_number('0480114')->is_valid_number, '北海道寿都郡黒松内町歌才');
ok($zip->set_number('0480115')->is_valid_number, '北海道寿都郡黒松内町西沢');
ok($zip->set_number('0480116')->is_valid_number, '北海道寿都郡黒松内町旭野');
ok($zip->set_number('0480117')->is_valid_number, '北海道寿都郡黒松内町添別');
ok($zip->set_number('0480121')->is_valid_number, '北海道寿都郡黒松内町熱郛');
ok($zip->set_number('0480122')->is_valid_number, '北海道寿都郡黒松内町白炭');
ok($zip->set_number('0480123')->is_valid_number, '北海道寿都郡黒松内町中ノ川');
ok($zip->set_number('0480124')->is_valid_number, '北海道寿都郡黒松内町五十嵐');
ok($zip->set_number('0480125')->is_valid_number, '北海道寿都郡黒松内町目名');
ok($zip->set_number('0480126')->is_valid_number, '北海道寿都郡黒松内町北作開');
ok($zip->set_number('0480127')->is_valid_number, '北海道寿都郡黒松内町南作開');
ok($zip->set_number('0480131')->is_valid_number, '北海道寿都郡黒松内町西熱郛原野');
ok($zip->set_number('0480132')->is_valid_number, '北海道寿都郡黒松内町チョポシナイ');
ok($zip->set_number('0480133')->is_valid_number, '北海道寿都郡黒松内町大谷地');
ok($zip->set_number('0480134')->is_valid_number, '北海道寿都郡黒松内町白井川');
ok($zip->set_number('0480135')->is_valid_number, '北海道寿都郡黒松内町角十');
ok($zip->set_number('0480136')->is_valid_number, '北海道寿都郡黒松内町赤井川');
ok($zip->set_number('0480137')->is_valid_number, '北海道寿都郡黒松内町婆沢');
ok($zip->set_number('0480141')->is_valid_number, '北海道寿都郡黒松内町上豊幌');
ok($zip->set_number('0480142')->is_valid_number, '北海道寿都郡黒松内町東栄');
ok($zip->set_number('0480143')->is_valid_number, '北海道寿都郡黒松内町大成');
ok($zip->set_number('0480144')->is_valid_number, '北海道寿都郡黒松内町東川');
ok($zip->set_number('0480145')->is_valid_number, '北海道寿都郡黒松内町上大成');
ok($zip->set_number('0480351')->is_valid_number, '北海道寿都郡寿都町磯谷町');
ok($zip->set_number('0480400')->is_valid_number, '北海道寿都郡寿都町以下に掲載がない場合');
ok($zip->set_number('0480401')->is_valid_number, '北海道寿都郡寿都町新栄町');
ok($zip->set_number('0480402')->is_valid_number, '北海道寿都郡寿都町矢追町');
ok($zip->set_number('0480403')->is_valid_number, '北海道寿都郡寿都町政泊町');
ok($zip->set_number('0480404')->is_valid_number, '北海道寿都郡寿都町大磯町');
ok($zip->set_number('0480405')->is_valid_number, '北海道寿都郡寿都町開進町');
ok($zip->set_number('0480406')->is_valid_number, '北海道寿都郡寿都町渡島町');
ok($zip->set_number('0480411')->is_valid_number, '北海道寿都郡寿都町六条町');
ok($zip->set_number('0480412')->is_valid_number, '北海道寿都郡寿都町岩崎町');
ok($zip->set_number('0480413')->is_valid_number, '北海道寿都郡寿都町樽岸町');
ok($zip->set_number('0480414')->is_valid_number, '北海道寿都郡寿都町湯別町');
ok($zip->set_number('0480415')->is_valid_number, '北海道寿都郡寿都町歌棄町');
ok($zip->set_number('0480600')->is_valid_number, '北海道島牧郡島牧村以下に掲載がない場合');
ok($zip->set_number('0480601')->is_valid_number, '北海道島牧郡島牧村富浦');
ok($zip->set_number('0480602')->is_valid_number, '北海道島牧郡島牧村歌島');
ok($zip->set_number('0480603')->is_valid_number, '北海道島牧郡島牧村本目');
ok($zip->set_number('0480604')->is_valid_number, '北海道島牧郡島牧村港');
ok($zip->set_number('0480611')->is_valid_number, '北海道島牧郡島牧村栄磯');
ok($zip->set_number('0480612')->is_valid_number, '北海道島牧郡島牧村豊浜');
ok($zip->set_number('0480613')->is_valid_number, '北海道島牧郡島牧村大平');
ok($zip->set_number('0480614')->is_valid_number, '北海道島牧郡島牧村永豊町');
ok($zip->set_number('0480621')->is_valid_number, '北海道島牧郡島牧村泊');
ok($zip->set_number('0480622')->is_valid_number, '北海道島牧郡島牧村豊平');
ok($zip->set_number('0480623')->is_valid_number, '北海道島牧郡島牧村江の島');
ok($zip->set_number('0480631')->is_valid_number, '北海道島牧郡島牧村千走');
ok($zip->set_number('0480632')->is_valid_number, '北海道島牧郡島牧村元町');
ok($zip->set_number('0480633')->is_valid_number, '北海道島牧郡島牧村原歌町');
ok($zip->set_number('0480634')->is_valid_number, '北海道島牧郡島牧村栄浜');
ok($zip->set_number('0481251')->is_valid_number, '北海道磯谷郡蘭越町相生');
ok($zip->set_number('0481252')->is_valid_number, '北海道磯谷郡蘭越町讃岐');
ok($zip->set_number('0481253')->is_valid_number, '北海道磯谷郡蘭越町田下');
ok($zip->set_number('0481254')->is_valid_number, '北海道磯谷郡蘭越町上目名');
ok($zip->set_number('0481261')->is_valid_number, '北海道磯谷郡蘭越町目名町');
ok($zip->set_number('0481262')->is_valid_number, '北海道磯谷郡蘭越町貝川');
ok($zip->set_number('0481263')->is_valid_number, '北海道磯谷郡蘭越町三笠');
ok($zip->set_number('0481264')->is_valid_number, '北海道磯谷郡蘭越町清水');
ok($zip->set_number('0481265')->is_valid_number, '北海道磯谷郡蘭越町鮎川');
ok($zip->set_number('0481300')->is_valid_number, '北海道磯谷郡蘭越町以下に掲載がない場合');
ok($zip->set_number('0481301')->is_valid_number, '北海道磯谷郡蘭越町蘭越町');
ok($zip->set_number('0481302')->is_valid_number, '北海道磯谷郡蘭越町昆布町');
ok($zip->set_number('0481303')->is_valid_number, '北海道磯谷郡蘭越町立川');
ok($zip->set_number('0481304')->is_valid_number, '北海道磯谷郡蘭越町水上');
ok($zip->set_number('0481305')->is_valid_number, '北海道磯谷郡蘭越町大谷');
ok($zip->set_number('0481306')->is_valid_number, '北海道磯谷郡蘭越町淀川');
ok($zip->set_number('0481307')->is_valid_number, '北海道磯谷郡蘭越町トンカラ');
ok($zip->set_number('0481307')->is_valid_number, '北海道磯谷郡蘭越町名駒町');
ok($zip->set_number('0481311')->is_valid_number, '北海道磯谷郡蘭越町吉国');
ok($zip->set_number('0481312')->is_valid_number, '北海道磯谷郡蘭越町冷水');
ok($zip->set_number('0481312')->is_valid_number, '北海道磯谷郡蘭越町三和');
ok($zip->set_number('0481313')->is_valid_number, '北海道磯谷郡蘭越町上里');
ok($zip->set_number('0481314')->is_valid_number, '北海道磯谷郡蘭越町御成');
ok($zip->set_number('0481315')->is_valid_number, '北海道磯谷郡蘭越町共栄');
ok($zip->set_number('0481316')->is_valid_number, '北海道磯谷郡蘭越町大曲');
ok($zip->set_number('0481316')->is_valid_number, '北海道磯谷郡蘭越町初田');
ok($zip->set_number('0481321')->is_valid_number, '北海道磯谷郡蘭越町昆布温泉');
ok($zip->set_number('0481321')->is_valid_number, '北海道磯谷郡蘭越町湯里');
ok($zip->set_number('0481322')->is_valid_number, '北海道磯谷郡蘭越町日出');
ok($zip->set_number('0481323')->is_valid_number, '北海道磯谷郡蘭越町黄金');
ok($zip->set_number('0481324')->is_valid_number, '北海道磯谷郡蘭越町豊国');
ok($zip->set_number('0481325')->is_valid_number, '北海道磯谷郡蘭越町栄');
ok($zip->set_number('0481326')->is_valid_number, '北海道磯谷郡蘭越町富岡');
ok($zip->set_number('0481327')->is_valid_number, '北海道磯谷郡蘭越町新見');
ok($zip->set_number('0481341')->is_valid_number, '北海道磯谷郡蘭越町港町');
ok($zip->set_number('0481500')->is_valid_number, '北海道虻田郡ニセコ町以下に掲載がない場合');
ok($zip->set_number('0481501')->is_valid_number, '北海道虻田郡ニセコ町富士見');
ok($zip->set_number('0481502')->is_valid_number, '北海道虻田郡ニセコ町本通');
ok($zip->set_number('0481511')->is_valid_number, '北海道虻田郡ニセコ町ニセコ');
ok($zip->set_number('0481512')->is_valid_number, '北海道虻田郡ニセコ町中央通');
ok($zip->set_number('0481521')->is_valid_number, '北海道虻田郡ニセコ町東山');
ok($zip->set_number('0481522')->is_valid_number, '北海道虻田郡ニセコ町曽我');
ok($zip->set_number('0481531')->is_valid_number, '北海道虻田郡ニセコ町有島');
ok($zip->set_number('0481541')->is_valid_number, '北海道虻田郡ニセコ町羊蹄');
ok($zip->set_number('0481542')->is_valid_number, '北海道虻田郡ニセコ町近藤');
ok($zip->set_number('0481543')->is_valid_number, '北海道虻田郡ニセコ町豊里');
ok($zip->set_number('0481544')->is_valid_number, '北海道虻田郡ニセコ町元町');
ok($zip->set_number('0481551')->is_valid_number, '北海道虻田郡ニセコ町里見');
ok($zip->set_number('0481552')->is_valid_number, '北海道虻田郡ニセコ町宮田');
ok($zip->set_number('0481553')->is_valid_number, '北海道虻田郡ニセコ町黒川');
ok($zip->set_number('0481554')->is_valid_number, '北海道虻田郡ニセコ町富川');
ok($zip->set_number('0481561')->is_valid_number, '北海道虻田郡ニセコ町福井');
ok($zip->set_number('0481562')->is_valid_number, '北海道虻田郡ニセコ町桂台');
ok($zip->set_number('0481563')->is_valid_number, '北海道虻田郡ニセコ町西富');
ok($zip->set_number('0481600')->is_valid_number, '北海道虻田郡真狩村以下に掲載がない場合');
ok($zip->set_number('0481601')->is_valid_number, '北海道虻田郡真狩村美原');
ok($zip->set_number('0481602')->is_valid_number, '北海道虻田郡真狩村泉');
ok($zip->set_number('0481603')->is_valid_number, '北海道虻田郡真狩村共明');
ok($zip->set_number('0481604')->is_valid_number, '北海道虻田郡真狩村富里');
ok($zip->set_number('0481605')->is_valid_number, '北海道虻田郡真狩村社');
ok($zip->set_number('0481611')->is_valid_number, '北海道虻田郡真狩村光');
ok($zip->set_number('0481612')->is_valid_number, '北海道虻田郡真狩村見晴');
ok($zip->set_number('0481613')->is_valid_number, '北海道虻田郡真狩村南部');
ok($zip->set_number('0481614')->is_valid_number, '北海道虻田郡真狩村桜川');
ok($zip->set_number('0481615')->is_valid_number, '北海道虻田郡真狩村緑岡');
ok($zip->set_number('0481621')->is_valid_number, '北海道虻田郡真狩村豊川');
ok($zip->set_number('0481622')->is_valid_number, '北海道虻田郡真狩村加野');
ok($zip->set_number('0481623')->is_valid_number, '北海道虻田郡真狩村川崎');
ok($zip->set_number('0481624')->is_valid_number, '北海道虻田郡真狩村神里');
ok($zip->set_number('0481631')->is_valid_number, '北海道虻田郡真狩村真狩');
ok($zip->set_number('0481700')->is_valid_number, '北海道虻田郡留寿都村以下に掲載がない場合');
ok($zip->set_number('0481711')->is_valid_number, '北海道虻田郡留寿都村泉川');
ok($zip->set_number('0481712')->is_valid_number, '北海道虻田郡留寿都村豊岡');
ok($zip->set_number('0481721')->is_valid_number, '北海道虻田郡留寿都村向丘');
ok($zip->set_number('0481722')->is_valid_number, '北海道虻田郡留寿都村黒田');
ok($zip->set_number('0481723')->is_valid_number, '北海道虻田郡留寿都村三ノ原');
ok($zip->set_number('0481724')->is_valid_number, '北海道虻田郡留寿都村三豊');
ok($zip->set_number('0481731')->is_valid_number, '北海道虻田郡留寿都村留寿都');
ok($zip->set_number('0481741')->is_valid_number, '北海道虻田郡留寿都村西ノ原');
ok($zip->set_number('0481751')->is_valid_number, '北海道虻田郡留寿都村登');
ok($zip->set_number('0481752')->is_valid_number, '北海道虻田郡留寿都村旭野');
ok($zip->set_number('0482141')->is_valid_number, '北海道岩内郡共和町ワイス');
ok($zip->set_number('0482142')->is_valid_number, '北海道岩内郡共和町小沢');
ok($zip->set_number('0482143')->is_valid_number, '北海道岩内郡共和町国富');
ok($zip->set_number('0482200')->is_valid_number, '北海道岩内郡共和町以下に掲載がない場合');
ok($zip->set_number('0482201')->is_valid_number, '北海道岩内郡共和町前田');
ok($zip->set_number('0482202')->is_valid_number, '北海道岩内郡共和町南幌似');
ok($zip->set_number('0482331')->is_valid_number, '北海道余市郡仁木町大江(2丁目651、662、668番地、3丁目103、118、');
ok($zip->set_number('0482331')->is_valid_number, '北海道余市郡仁木町210、254、267、372、444、469番地)');
ok($zip->set_number('0482332')->is_valid_number, '北海道余市郡仁木町長沢西');
ok($zip->set_number('0482333')->is_valid_number, '北海道余市郡仁木町長沢南');
ok($zip->set_number('0482334')->is_valid_number, '北海道余市郡仁木町尾根内');
ok($zip->set_number('0482335')->is_valid_number, '北海道余市郡仁木町銀山');
ok($zip->set_number('0482400')->is_valid_number, '北海道余市郡仁木町以下に掲載がない場合');
ok($zip->set_number('0482401')->is_valid_number, '北海道余市郡仁木町旭台');
ok($zip->set_number('0482402')->is_valid_number, '北海道余市郡仁木町大江(1丁目、2丁目「651、662、668番地」以外、3丁目5、1');
ok($zip->set_number('0482402')->is_valid_number, '北海道余市郡仁木町3-4、20、678、687番地)');
ok($zip->set_number('0482403')->is_valid_number, '北海道余市郡仁木町然別');
ok($zip->set_number('0482404')->is_valid_number, '北海道余市郡仁木町砥の川');
ok($zip->set_number('0482405')->is_valid_number, '北海道余市郡仁木町北町');
ok($zip->set_number('0482406')->is_valid_number, '北海道余市郡仁木町西町');
ok($zip->set_number('0482411')->is_valid_number, '北海道余市郡仁木町東町');
ok($zip->set_number('0482412')->is_valid_number, '北海道余市郡仁木町東町緑ケ丘');
ok($zip->set_number('0482413')->is_valid_number, '北海道余市郡仁木町南町');
ok($zip->set_number('0482561')->is_valid_number, '北海道小樽市忍路');
ok($zip->set_number('0482562')->is_valid_number, '北海道小樽市蘭島');
ok($zip->set_number('0482671')->is_valid_number, '北海道小樽市オタモイ');
ok($zip->set_number('0482672')->is_valid_number, '北海道小樽市塩谷');
ok($zip->set_number('0482673')->is_valid_number, '北海道小樽市桃内');
ok($zip->set_number('0490100')->is_valid_number, '北海道北斗市以下に掲載がない場合');
ok($zip->set_number('0490101')->is_valid_number, '北海道北斗市追分');
ok($zip->set_number('0490111')->is_valid_number, '北海道北斗市七重浜');
ok($zip->set_number('0490121')->is_valid_number, '北海道北斗市久根別');
ok($zip->set_number('0490122')->is_valid_number, '北海道北斗市東浜');
ok($zip->set_number('0490131')->is_valid_number, '北海道北斗市富川');
ok($zip->set_number('0490132')->is_valid_number, '北海道北斗市館野');
ok($zip->set_number('0490133')->is_valid_number, '北海道北斗市柳沢');
ok($zip->set_number('0490134')->is_valid_number, '北海道北斗市三好');
ok($zip->set_number('0490135')->is_valid_number, '北海道北斗市水無');
ok($zip->set_number('0490136')->is_valid_number, '北海道北斗市峨朗');
ok($zip->set_number('0490141')->is_valid_number, '北海道北斗市谷好');
ok($zip->set_number('0490142')->is_valid_number, '北海道北斗市昭和');
ok($zip->set_number('0490143')->is_valid_number, '北海道北斗市公園通');
ok($zip->set_number('0490151')->is_valid_number, '北海道北斗市桜岱');
ok($zip->set_number('0490152')->is_valid_number, '北海道北斗市押上');
ok($zip->set_number('0490153')->is_valid_number, '北海道北斗市大工川');
ok($zip->set_number('0490154')->is_valid_number, '北海道北斗市添山');
ok($zip->set_number('0490155')->is_valid_number, '北海道北斗市中野');
ok($zip->set_number('0490156')->is_valid_number, '北海道北斗市中野通');
ok($zip->set_number('0490157')->is_valid_number, '北海道北斗市清川');
ok($zip->set_number('0490158')->is_valid_number, '北海道北斗市野崎');
ok($zip->set_number('0490161')->is_valid_number, '北海道北斗市飯生');
ok($zip->set_number('0490162')->is_valid_number, '北海道北斗市中央');
ok($zip->set_number('0490171')->is_valid_number, '北海道北斗市常盤');
ok($zip->set_number('0490281')->is_valid_number, '北海道北斗市茂辺地');
ok($zip->set_number('0490282')->is_valid_number, '北海道北斗市当別');
ok($zip->set_number('0490283')->is_valid_number, '北海道北斗市三ツ石');
ok($zip->set_number('0490284')->is_valid_number, '北海道北斗市湯ノ沢');
ok($zip->set_number('0490285')->is_valid_number, '北海道北斗市茂辺地市ノ渡');
ok($zip->set_number('0490286')->is_valid_number, '北海道北斗市矢不来');
ok($zip->set_number('0490400')->is_valid_number, '北海道上磯郡木古内町以下に掲載がない場合');
ok($zip->set_number('0490401')->is_valid_number, '北海道上磯郡木古内町大釜谷');
ok($zip->set_number('0490402')->is_valid_number, '北海道上磯郡木古内町御宮野');
ok($zip->set_number('0490403')->is_valid_number, '北海道上磯郡木古内町釜谷');
ok($zip->set_number('0490404')->is_valid_number, '北海道上磯郡木古内町亀川');
ok($zip->set_number('0490405')->is_valid_number, '北海道上磯郡木古内町泉沢');
ok($zip->set_number('0490406')->is_valid_number, '北海道上磯郡木古内町二乃岱');
ok($zip->set_number('0490407')->is_valid_number, '北海道上磯郡木古内町橋呉');
ok($zip->set_number('0490408')->is_valid_number, '北海道上磯郡木古内町幸連');
ok($zip->set_number('0490411')->is_valid_number, '北海道上磯郡木古内町札苅');
ok($zip->set_number('0490412')->is_valid_number, '北海道上磯郡木古内町大平');
ok($zip->set_number('0490421')->is_valid_number, '北海道上磯郡木古内町前浜');
ok($zip->set_number('0490422')->is_valid_number, '北海道上磯郡木古内町本町');
ok($zip->set_number('0490431')->is_valid_number, '北海道上磯郡木古内町木古内');
ok($zip->set_number('0490441')->is_valid_number, '北海道上磯郡木古内町中野');
ok($zip->set_number('0490451')->is_valid_number, '北海道上磯郡木古内町新道');
ok($zip->set_number('0490452')->is_valid_number, '北海道上磯郡木古内町建川');
ok($zip->set_number('0490453')->is_valid_number, '北海道上磯郡木古内町大川');
ok($zip->set_number('0490454')->is_valid_number, '北海道上磯郡木古内町瓜谷');
ok($zip->set_number('0490455')->is_valid_number, '北海道上磯郡木古内町鶴岡');
ok($zip->set_number('0490561')->is_valid_number, '北海道檜山郡上ノ国町神明');
ok($zip->set_number('0490562')->is_valid_number, '北海道檜山郡上ノ国町湯ノ岱');
ok($zip->set_number('0490563')->is_valid_number, '北海道檜山郡上ノ国町宮越');
ok($zip->set_number('0490564')->is_valid_number, '北海道檜山郡上ノ国町早瀬');
ok($zip->set_number('0490600')->is_valid_number, '北海道檜山郡上ノ国町以下に掲載がない場合');
ok($zip->set_number('0490601')->is_valid_number, '北海道檜山郡上ノ国町勝山');
ok($zip->set_number('0490602')->is_valid_number, '北海道檜山郡上ノ国町原歌');
ok($zip->set_number('0490603')->is_valid_number, '北海道檜山郡上ノ国町大崎');
ok($zip->set_number('0490604')->is_valid_number, '北海道檜山郡上ノ国町大安在');
ok($zip->set_number('0490605')->is_valid_number, '北海道檜山郡上ノ国町小安在');
ok($zip->set_number('0490606')->is_valid_number, '北海道檜山郡上ノ国町木ノ子');
ok($zip->set_number('0490607')->is_valid_number, '北海道檜山郡上ノ国町扇石');
ok($zip->set_number('0490608')->is_valid_number, '北海道檜山郡上ノ国町汐吹');
ok($zip->set_number('0490611')->is_valid_number, '北海道檜山郡上ノ国町大留');
ok($zip->set_number('0490612')->is_valid_number, '北海道檜山郡上ノ国町上ノ国');
ok($zip->set_number('0490613')->is_valid_number, '北海道檜山郡上ノ国町向浜');
ok($zip->set_number('0490621')->is_valid_number, '北海道檜山郡上ノ国町内郷');
ok($zip->set_number('0490622')->is_valid_number, '北海道檜山郡上ノ国町北村');
ok($zip->set_number('0490623')->is_valid_number, '北海道檜山郡上ノ国町新村');
ok($zip->set_number('0490624')->is_valid_number, '北海道檜山郡上ノ国町中須田');
ok($zip->set_number('0490625')->is_valid_number, '北海道檜山郡上ノ国町豊田');
ok($zip->set_number('0490626')->is_valid_number, '北海道檜山郡上ノ国町桂岡');
ok($zip->set_number('0490627')->is_valid_number, '北海道檜山郡上ノ国町小森');
ok($zip->set_number('0490741')->is_valid_number, '北海道檜山郡上ノ国町石崎');
ok($zip->set_number('0490742')->is_valid_number, '北海道檜山郡上ノ国町館野');
ok($zip->set_number('0490743')->is_valid_number, '北海道檜山郡上ノ国町小砂子');
ok($zip->set_number('0490744')->is_valid_number, '北海道檜山郡上ノ国町早川');
ok($zip->set_number('0491100')->is_valid_number, '北海道上磯郡知内町以下に掲載がない場合');
ok($zip->set_number('0491101')->is_valid_number, '北海道上磯郡知内町中ノ川');
ok($zip->set_number('0491102')->is_valid_number, '北海道上磯郡知内町森越');
ok($zip->set_number('0491103')->is_valid_number, '北海道上磯郡知内町重内');
ok($zip->set_number('0491104')->is_valid_number, '北海道上磯郡知内町涌元');
ok($zip->set_number('0491105')->is_valid_number, '北海道上磯郡知内町小谷石');
ok($zip->set_number('0491106')->is_valid_number, '北海道上磯郡知内町元町');
ok($zip->set_number('0491107')->is_valid_number, '北海道上磯郡知内町上雷');
ok($zip->set_number('0491221')->is_valid_number, '北海道上磯郡知内町湯ノ里');
ok($zip->set_number('0491300')->is_valid_number, '北海道松前郡福島町以下に掲載がない場合');
ok($zip->set_number('0491301')->is_valid_number, '北海道松前郡福島町白符');
ok($zip->set_number('0491302')->is_valid_number, '北海道松前郡福島町日向');
ok($zip->set_number('0491311')->is_valid_number, '北海道松前郡福島町桧倉');
ok($zip->set_number('0491312')->is_valid_number, '北海道松前郡福島町上町');
ok($zip->set_number('0491312')->is_valid_number, '北海道松前郡福島町川原町');
ok($zip->set_number('0491312')->is_valid_number, '北海道松前郡福島町館古');
ok($zip->set_number('0491312')->is_valid_number, '北海道松前郡福島町福島');
ok($zip->set_number('0491312')->is_valid_number, '北海道松前郡福島町本町');
ok($zip->set_number('0491312')->is_valid_number, '北海道松前郡福島町吉田町');
ok($zip->set_number('0491321')->is_valid_number, '北海道松前郡福島町月崎');
ok($zip->set_number('0491321')->is_valid_number, '北海道松前郡福島町丸山団地');
ok($zip->set_number('0491321')->is_valid_number, '北海道松前郡福島町緑町');
ok($zip->set_number('0491322')->is_valid_number, '北海道松前郡福島町塩釜');
ok($zip->set_number('0491323')->is_valid_number, '北海道松前郡福島町浦和');
ok($zip->set_number('0491324')->is_valid_number, '北海道松前郡福島町日の出');
ok($zip->set_number('0491325')->is_valid_number, '北海道松前郡福島町岩部');
ok($zip->set_number('0491331')->is_valid_number, '北海道松前郡福島町新栄町');
ok($zip->set_number('0491331')->is_valid_number, '北海道松前郡福島町三岳');
ok($zip->set_number('0491332')->is_valid_number, '北海道松前郡福島町千軒');
ok($zip->set_number('0491451')->is_valid_number, '北海道松前郡福島町宮歌');
ok($zip->set_number('0491452')->is_valid_number, '北海道松前郡福島町豊浜');
ok($zip->set_number('0491453')->is_valid_number, '北海道松前郡福島町美山');
ok($zip->set_number('0491453')->is_valid_number, '北海道松前郡福島町吉岡');
ok($zip->set_number('0491454')->is_valid_number, '北海道松前郡福島町館崎');
ok($zip->set_number('0491455')->is_valid_number, '北海道松前郡福島町吉野');
ok($zip->set_number('0491456')->is_valid_number, '北海道松前郡福島町松浦');
ok($zip->set_number('0491500')->is_valid_number, '北海道松前郡松前町以下に掲載がない場合');
ok($zip->set_number('0491501')->is_valid_number, '北海道松前郡松前町建石');
ok($zip->set_number('0491502')->is_valid_number, '北海道松前郡松前町弁天');
ok($zip->set_number('0491503')->is_valid_number, '北海道松前郡松前町大磯');
ok($zip->set_number('0491504')->is_valid_number, '北海道松前郡松前町愛宕');
ok($zip->set_number('0491505')->is_valid_number, '北海道松前郡松前町博多');
ok($zip->set_number('0491506')->is_valid_number, '北海道松前郡松前町唐津');
ok($zip->set_number('0491507')->is_valid_number, '北海道松前郡松前町西館');
ok($zip->set_number('0491511')->is_valid_number, '北海道松前郡松前町松城');
ok($zip->set_number('0491512')->is_valid_number, '北海道松前郡松前町福山');
ok($zip->set_number('0491513')->is_valid_number, '北海道松前郡松前町神明');
ok($zip->set_number('0491514')->is_valid_number, '北海道松前郡松前町豊岡');
ok($zip->set_number('0491515')->is_valid_number, '北海道松前郡松前町月島');
ok($zip->set_number('0491516')->is_valid_number, '北海道松前郡松前町東山');
ok($zip->set_number('0491517')->is_valid_number, '北海道松前郡松前町朝日');
ok($zip->set_number('0491521')->is_valid_number, '北海道松前郡松前町上川');
ok($zip->set_number('0491522')->is_valid_number, '北海道松前郡松前町大沢');
ok($zip->set_number('0491523')->is_valid_number, '北海道松前郡松前町荒谷');
ok($zip->set_number('0491524')->is_valid_number, '北海道松前郡松前町白神');
ok($zip->set_number('0491641')->is_valid_number, '北海道松前郡松前町館浜');
ok($zip->set_number('0491642')->is_valid_number, '北海道松前郡松前町札前');
ok($zip->set_number('0491643')->is_valid_number, '北海道松前郡松前町赤神');
ok($zip->set_number('0491644')->is_valid_number, '北海道松前郡松前町静浦');
ok($zip->set_number('0491645')->is_valid_number, '北海道松前郡松前町茂草');
ok($zip->set_number('0491761')->is_valid_number, '北海道松前郡松前町神山');
ok($zip->set_number('0491762')->is_valid_number, '北海道松前郡松前町原口');
ok($zip->set_number('0491763')->is_valid_number, '北海道松前郡松前町白坂');
ok($zip->set_number('0491764')->is_valid_number, '北海道松前郡松前町二越');
ok($zip->set_number('0491771')->is_valid_number, '北海道松前郡松前町江良');
ok($zip->set_number('0491781')->is_valid_number, '北海道松前郡松前町大津');
ok($zip->set_number('0491782')->is_valid_number, '北海道松前郡松前町高野');
ok($zip->set_number('0491783')->is_valid_number, '北海道松前郡松前町清部');
ok($zip->set_number('0491784')->is_valid_number, '北海道松前郡松前町小浜');
ok($zip->set_number('0492141')->is_valid_number, '北海道茅部郡森町駒ケ岳');
ok($zip->set_number('0492142')->is_valid_number, '北海道茅部郡森町赤井川');
ok($zip->set_number('0492221')->is_valid_number, '北海道茅部郡森町砂原西');
ok($zip->set_number('0492222')->is_valid_number, '北海道茅部郡森町砂原');
ok($zip->set_number('0492223')->is_valid_number, '北海道茅部郡森町砂原東');
ok($zip->set_number('0492300')->is_valid_number, '北海道茅部郡森町以下に掲載がない場合');
ok($zip->set_number('0492301')->is_valid_number, '北海道茅部郡森町尾白内町');
ok($zip->set_number('0492302')->is_valid_number, '北海道茅部郡森町港町');
ok($zip->set_number('0492303')->is_valid_number, '北海道茅部郡森町東森町');
ok($zip->set_number('0492304')->is_valid_number, '北海道茅部郡森町新川町');
ok($zip->set_number('0492305')->is_valid_number, '北海道茅部郡森町常盤町');
ok($zip->set_number('0492306')->is_valid_number, '北海道茅部郡森町姫川');
ok($zip->set_number('0492307')->is_valid_number, '北海道茅部郡森町白川');
ok($zip->set_number('0492308')->is_valid_number, '北海道茅部郡森町栄町');
ok($zip->set_number('0492311')->is_valid_number, '北海道茅部郡森町上台町');
ok($zip->set_number('0492312')->is_valid_number, '北海道茅部郡森町霞台');
ok($zip->set_number('0492313')->is_valid_number, '北海道茅部郡森町森川町');
ok($zip->set_number('0492321')->is_valid_number, '北海道茅部郡森町鷲ノ木町');
ok($zip->set_number('0492322')->is_valid_number, '北海道茅部郡森町富士見町');
ok($zip->set_number('0492323')->is_valid_number, '北海道茅部郡森町鳥崎町');
ok($zip->set_number('0492324')->is_valid_number, '北海道茅部郡森町栗ケ丘');
ok($zip->set_number('0492325')->is_valid_number, '北海道茅部郡森町本町');
ok($zip->set_number('0492326')->is_valid_number, '北海道茅部郡森町御幸町');
ok($zip->set_number('0492327')->is_valid_number, '北海道茅部郡森町清澄町');
ok($zip->set_number('0492461')->is_valid_number, '北海道茅部郡森町三岱');
ok($zip->set_number('0492462')->is_valid_number, '北海道茅部郡森町濁川');
ok($zip->set_number('0492463')->is_valid_number, '北海道茅部郡森町石倉町');
ok($zip->set_number('0492464')->is_valid_number, '北海道茅部郡森町本茅部町');
ok($zip->set_number('0492465')->is_valid_number, '北海道茅部郡森町蛯谷町');
ok($zip->set_number('0492561')->is_valid_number, '北海道二海郡八雲町旭丘');
ok($zip->set_number('0492562')->is_valid_number, '北海道二海郡八雲町落部');
ok($zip->set_number('0492563')->is_valid_number, '北海道二海郡八雲町栄浜');
ok($zip->set_number('0492564')->is_valid_number, '北海道二海郡八雲町入沢');
ok($zip->set_number('0492565')->is_valid_number, '北海道二海郡八雲町下の湯');
ok($zip->set_number('0492566')->is_valid_number, '北海道二海郡八雲町上の湯');
ok($zip->set_number('0492671')->is_valid_number, '北海道二海郡八雲町山越');
ok($zip->set_number('0492672')->is_valid_number, '北海道二海郡八雲町野田生');
ok($zip->set_number('0492673')->is_valid_number, '北海道二海郡八雲町東野');
ok($zip->set_number('0492674')->is_valid_number, '北海道二海郡八雲町わらび野');
ok($zip->set_number('0492675')->is_valid_number, '北海道二海郡八雲町桜野');
ok($zip->set_number('0493100')->is_valid_number, '北海道二海郡八雲町以下に掲載がない場合');
ok($zip->set_number('0493101')->is_valid_number, '北海道二海郡八雲町元町');
ok($zip->set_number('0493102')->is_valid_number, '北海道二海郡八雲町東町');
ok($zip->set_number('0493103')->is_valid_number, '北海道二海郡八雲町豊河町');
ok($zip->set_number('0493104')->is_valid_number, '北海道二海郡八雲町内浦町');
ok($zip->set_number('0493105')->is_valid_number, '北海道二海郡八雲町東雲町');
ok($zip->set_number('0493106')->is_valid_number, '北海道二海郡八雲町富士見町');
ok($zip->set_number('0493107')->is_valid_number, '北海道二海郡八雲町本町');
ok($zip->set_number('0493111')->is_valid_number, '北海道二海郡八雲町住初町');
ok($zip->set_number('0493112')->is_valid_number, '北海道二海郡八雲町末広町');
ok($zip->set_number('0493113')->is_valid_number, '北海道二海郡八雲町相生町');
ok($zip->set_number('0493114')->is_valid_number, '北海道二海郡八雲町三杉町');
ok($zip->set_number('0493115')->is_valid_number, '北海道二海郡八雲町出雲町');
ok($zip->set_number('0493116')->is_valid_number, '北海道二海郡八雲町宮園町');
ok($zip->set_number('0493117')->is_valid_number, '北海道二海郡八雲町栄町');
ok($zip->set_number('0493118')->is_valid_number, '北海道二海郡八雲町緑町');
ok($zip->set_number('0493121')->is_valid_number, '北海道二海郡八雲町上八雲');
ok($zip->set_number('0493121')->is_valid_number, '北海道二海郡八雲町富咲');
ok($zip->set_number('0493122')->is_valid_number, '北海道二海郡八雲町花浦');
ok($zip->set_number('0493123')->is_valid_number, '北海道二海郡八雲町立岩');
ok($zip->set_number('0493124')->is_valid_number, '北海道二海郡八雲町浜松');
ok($zip->set_number('0493125')->is_valid_number, '北海道二海郡八雲町熱田');
ok($zip->set_number('0493126')->is_valid_number, '北海道二海郡八雲町大新');
ok($zip->set_number('0493127')->is_valid_number, '北海道二海郡八雲町春日');
ok($zip->set_number('0493128')->is_valid_number, '北海道二海郡八雲町鉛川');
ok($zip->set_number('0493341')->is_valid_number, '北海道二海郡八雲町黒岩');
ok($zip->set_number('0493342')->is_valid_number, '北海道二海郡八雲町山崎');
ok($zip->set_number('0493461')->is_valid_number, '北海道山越郡長万部町花岡');
ok($zip->set_number('0493462')->is_valid_number, '北海道山越郡長万部町国縫');
ok($zip->set_number('0493463')->is_valid_number, '北海道山越郡長万部町豊野');
ok($zip->set_number('0493464')->is_valid_number, '北海道山越郡長万部町豊津');
ok($zip->set_number('0493465')->is_valid_number, '北海道山越郡長万部町茶屋川');
ok($zip->set_number('0493500')->is_valid_number, '北海道山越郡長万部町以下に掲載がない場合');
ok($zip->set_number('0493501')->is_valid_number, '北海道山越郡長万部町大峰');
ok($zip->set_number('0493501')->is_valid_number, '北海道山越郡長万部町双葉');
ok($zip->set_number('0493502')->is_valid_number, '北海道山越郡長万部町知来');
ok($zip->set_number('0493503')->is_valid_number, '北海道山越郡長万部町蕨岱');
ok($zip->set_number('0493504')->is_valid_number, '北海道山越郡長万部町美畑');
ok($zip->set_number('0493511')->is_valid_number, '北海道山越郡長万部町大浜');
ok($zip->set_number('0493512')->is_valid_number, '北海道山越郡長万部町中の沢');
ok($zip->set_number('0493513')->is_valid_number, '北海道山越郡長万部町平里');
ok($zip->set_number('0493514')->is_valid_number, '北海道山越郡長万部町富野');
ok($zip->set_number('0493515')->is_valid_number, '北海道山越郡長万部町栗岡');
ok($zip->set_number('0493516')->is_valid_number, '北海道山越郡長万部町栄原');
ok($zip->set_number('0493517')->is_valid_number, '北海道山越郡長万部町共立');
ok($zip->set_number('0493518')->is_valid_number, '北海道山越郡長万部町静狩(3-1番地)');
ok($zip->set_number('0493519')->is_valid_number, '北海道山越郡長万部町旭浜');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町曙町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町大町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町長万部');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町温泉町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町新開町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町陣屋町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町住吉町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町高砂町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町本町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町南栄町');
ok($zip->set_number('0493521')->is_valid_number, '北海道山越郡長万部町元町');
ok($zip->set_number('0494151')->is_valid_number, '北海道瀬棚郡今金町美利河');
ok($zip->set_number('0494152')->is_valid_number, '北海道瀬棚郡今金町宮島');
ok($zip->set_number('0494153')->is_valid_number, '北海道瀬棚郡今金町花石');
ok($zip->set_number('0494154')->is_valid_number, '北海道瀬棚郡今金町中里');
ok($zip->set_number('0494155')->is_valid_number, '北海道瀬棚郡今金町奥沢');
ok($zip->set_number('0494156')->is_valid_number, '北海道瀬棚郡今金町住吉');
ok($zip->set_number('0494157')->is_valid_number, '北海道瀬棚郡今金町上種川');
ok($zip->set_number('0494300')->is_valid_number, '北海道瀬棚郡今金町以下に掲載がない場合');
ok($zip->set_number('0494301')->is_valid_number, '北海道瀬棚郡今金町東町');
ok($zip->set_number('0494302')->is_valid_number, '北海道瀬棚郡今金町日の出町');
ok($zip->set_number('0494303')->is_valid_number, '北海道瀬棚郡今金町曙町');
ok($zip->set_number('0494304')->is_valid_number, '北海道瀬棚郡今金町寒昇');
ok($zip->set_number('0494305')->is_valid_number, '北海道瀬棚郡今金町南栄町');
ok($zip->set_number('0494306')->is_valid_number, '北海道瀬棚郡今金町高美町');
ok($zip->set_number('0494307')->is_valid_number, '北海道瀬棚郡今金町八幡町');
ok($zip->set_number('0494308')->is_valid_number, '北海道瀬棚郡今金町今金');
ok($zip->set_number('0494311')->is_valid_number, '北海道瀬棚郡今金町栄町');
ok($zip->set_number('0494312')->is_valid_number, '北海道瀬棚郡今金町旭町');
ok($zip->set_number('0494313')->is_valid_number, '北海道瀬棚郡今金町本町');
ok($zip->set_number('0494314')->is_valid_number, '北海道瀬棚郡今金町昭和町');
ok($zip->set_number('0494315')->is_valid_number, '北海道瀬棚郡今金町末広町');
ok($zip->set_number('0494316')->is_valid_number, '北海道瀬棚郡今金町南町');
ok($zip->set_number('0494317')->is_valid_number, '北海道瀬棚郡今金町緑町');
ok($zip->set_number('0494318')->is_valid_number, '北海道瀬棚郡今金町大和町');
ok($zip->set_number('0494321')->is_valid_number, '北海道瀬棚郡今金町鈴岡');
ok($zip->set_number('0494322')->is_valid_number, '北海道瀬棚郡今金町御影');
ok($zip->set_number('0494323')->is_valid_number, '北海道瀬棚郡今金町光台');
ok($zip->set_number('0494324')->is_valid_number, '北海道瀬棚郡今金町種川');
ok($zip->set_number('0494325')->is_valid_number, '北海道瀬棚郡今金町稲穂');
ok($zip->set_number('0494326')->is_valid_number, '北海道瀬棚郡今金町商工団地');
ok($zip->set_number('0494327')->is_valid_number, '北海道瀬棚郡今金町神丘');
ok($zip->set_number('0494331')->is_valid_number, '北海道瀬棚郡今金町田代');
ok($zip->set_number('0494332')->is_valid_number, '北海道瀬棚郡今金町白石');
ok($zip->set_number('0494333')->is_valid_number, '北海道瀬棚郡今金町日進');
ok($zip->set_number('0494334')->is_valid_number, '北海道瀬棚郡今金町八束');
ok($zip->set_number('0494335')->is_valid_number, '北海道瀬棚郡今金町金原');
ok($zip->set_number('0494336')->is_valid_number, '北海道瀬棚郡今金町鈴金');
ok($zip->set_number('0494337')->is_valid_number, '北海道瀬棚郡今金町豊田');
ok($zip->set_number('0494431')->is_valid_number, '北海道久遠郡せたな町北檜山区小倉山');
ok($zip->set_number('0494432')->is_valid_number, '北海道久遠郡せたな町北檜山区東丹羽');
ok($zip->set_number('0494433')->is_valid_number, '北海道久遠郡せたな町北檜山区丹羽');
ok($zip->set_number('0494434')->is_valid_number, '北海道久遠郡せたな町北檜山区西丹羽');
ok($zip->set_number('0494500')->is_valid_number, '北海道久遠郡せたな町以下に掲載がない場合');
ok($zip->set_number('0494501')->is_valid_number, '北海道久遠郡せたな町北檜山区北檜山');
ok($zip->set_number('0494511')->is_valid_number, '北海道久遠郡せたな町北檜山区松岡');
ok($zip->set_number('0494512')->is_valid_number, '北海道久遠郡せたな町北檜山区徳島');
ok($zip->set_number('0494513')->is_valid_number, '北海道久遠郡せたな町北檜山区愛知');
ok($zip->set_number('0494514')->is_valid_number, '北海道久遠郡せたな町北檜山区豊岡');
ok($zip->set_number('0494515')->is_valid_number, '北海道久遠郡せたな町北檜山区兜野');
ok($zip->set_number('0494516')->is_valid_number, '北海道久遠郡せたな町北檜山区共和');
ok($zip->set_number('0494517')->is_valid_number, '北海道久遠郡せたな町北檜山区太櫓');
ok($zip->set_number('0494518')->is_valid_number, '北海道久遠郡せたな町北檜山区新成');
ok($zip->set_number('0494751')->is_valid_number, '北海道久遠郡せたな町北檜山区栄');
ok($zip->set_number('0494752')->is_valid_number, '北海道久遠郡せたな町北檜山区若松');
ok($zip->set_number('0494753')->is_valid_number, '北海道久遠郡せたな町北檜山区小川');
ok($zip->set_number('0494754')->is_valid_number, '北海道久遠郡せたな町北檜山区二俣');
ok($zip->set_number('0494755')->is_valid_number, '北海道久遠郡せたな町北檜山区富里');
ok($zip->set_number('0494801')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(1区)');
ok($zip->set_number('0494802')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(2区)');
ok($zip->set_number('0494803')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(3区)');
ok($zip->set_number('0494804')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(4区)');
ok($zip->set_number('0494805')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(5区)');
ok($zip->set_number('0494811')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(6区)');
ok($zip->set_number('0494812')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(7区)');
ok($zip->set_number('0494813')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(8区)');
ok($zip->set_number('0494814')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(9区)');
ok($zip->set_number('0494815')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町(10区)');
ok($zip->set_number('0494816')->is_valid_number, '北海道久遠郡せたな町瀬棚区本町');
ok($zip->set_number('0494821')->is_valid_number, '北海道久遠郡せたな町瀬棚区三本杉');
ok($zip->set_number('0494822')->is_valid_number, '北海道久遠郡せたな町瀬棚区元浦');
ok($zip->set_number('0494823')->is_valid_number, '北海道久遠郡せたな町瀬棚区島歌');
ok($zip->set_number('0494824')->is_valid_number, '北海道久遠郡せたな町瀬棚区北島歌');
ok($zip->set_number('0494825')->is_valid_number, '北海道久遠郡せたな町瀬棚区西大里');
ok($zip->set_number('0494826')->is_valid_number, '北海道久遠郡せたな町瀬棚区東大里');
ok($zip->set_number('0494827')->is_valid_number, '北海道久遠郡せたな町瀬棚区共和');
ok($zip->set_number('0494828')->is_valid_number, '北海道久遠郡せたな町瀬棚区南川');
ok($zip->set_number('0495141')->is_valid_number, '北海道山越郡長万部町静狩(その他)');
ok($zip->set_number('0495331')->is_valid_number, '北海道虻田郡豊浦町豊泉');
ok($zip->set_number('0495332')->is_valid_number, '北海道虻田郡豊浦町大岸');
ok($zip->set_number('0495333')->is_valid_number, '北海道虻田郡豊浦町礼文華');
ok($zip->set_number('0495400')->is_valid_number, '北海道虻田郡豊浦町以下に掲載がない場合');
ok($zip->set_number('0495401')->is_valid_number, '北海道虻田郡豊浦町山梨');
ok($zip->set_number('0495402')->is_valid_number, '北海道虻田郡豊浦町大和');
ok($zip->set_number('0495403')->is_valid_number, '北海道虻田郡豊浦町美和');
ok($zip->set_number('0495404')->is_valid_number, '北海道虻田郡豊浦町桜');
ok($zip->set_number('0495405')->is_valid_number, '北海道虻田郡豊浦町高岡');
ok($zip->set_number('0495406')->is_valid_number, '北海道虻田郡豊浦町新山梨');
ok($zip->set_number('0495407')->is_valid_number, '北海道虻田郡豊浦町上泉');
ok($zip->set_number('0495408')->is_valid_number, '北海道虻田郡豊浦町新富');
ok($zip->set_number('0495411')->is_valid_number, '北海道虻田郡豊浦町東雲町');
ok($zip->set_number('0495412')->is_valid_number, '北海道虻田郡豊浦町旭町');
ok($zip->set_number('0495413')->is_valid_number, '北海道虻田郡豊浦町海岸町');
ok($zip->set_number('0495414')->is_valid_number, '北海道虻田郡豊浦町幸町');
ok($zip->set_number('0495415')->is_valid_number, '北海道虻田郡豊浦町浜町');
ok($zip->set_number('0495416')->is_valid_number, '北海道虻田郡豊浦町船見町');
ok($zip->set_number('0495600')->is_valid_number, '北海道虻田郡洞爺湖町以下に掲載がない場合');
ok($zip->set_number('0495601')->is_valid_number, '北海道虻田郡洞爺湖町青葉町');
ok($zip->set_number('0495602')->is_valid_number, '北海道虻田郡洞爺湖町泉');
ok($zip->set_number('0495603')->is_valid_number, '北海道虻田郡洞爺湖町入江');
ok($zip->set_number('0495604')->is_valid_number, '北海道虻田郡洞爺湖町栄町');
ok($zip->set_number('0495605')->is_valid_number, '北海道虻田郡洞爺湖町高砂町');
ok($zip->set_number('0495611')->is_valid_number, '北海道虻田郡洞爺湖町旭町');
ok($zip->set_number('0495612')->is_valid_number, '北海道虻田郡洞爺湖町大磯町');
ok($zip->set_number('0495613')->is_valid_number, '北海道虻田郡洞爺湖町清水(その他)');
ok($zip->set_number('0495614')->is_valid_number, '北海道虻田郡洞爺湖町浜町');
ok($zip->set_number('0495615')->is_valid_number, '北海道虻田郡洞爺湖町本町');
ok($zip->set_number('0495616')->is_valid_number, '北海道虻田郡洞爺湖町三豊');
ok($zip->set_number('0495721')->is_valid_number, '北海道虻田郡洞爺湖町洞爺湖温泉');
ok($zip->set_number('0495722')->is_valid_number, '北海道虻田郡洞爺湖町清水(336番地)');
ok($zip->set_number('0495723')->is_valid_number, '北海道虻田郡洞爺湖町月浦');
ok($zip->set_number('0495724')->is_valid_number, '北海道虻田郡洞爺湖町花和');
ok($zip->set_number('0495731')->is_valid_number, '北海道有珠郡壮瞥町洞爺湖温泉(1~7番地)');
ok($zip->set_number('0495801')->is_valid_number, '北海道虻田郡洞爺湖町旭浦');
ok($zip->set_number('0495802')->is_valid_number, '北海道虻田郡洞爺湖町洞爺町');
ok($zip->set_number('0495811')->is_valid_number, '北海道虻田郡洞爺湖町岩屋');
ok($zip->set_number('0495812')->is_valid_number, '北海道虻田郡洞爺湖町川東');
ok($zip->set_number('0495813')->is_valid_number, '北海道虻田郡洞爺湖町財田');
ok($zip->set_number('0495814')->is_valid_number, '北海道虻田郡洞爺湖町早月');
ok($zip->set_number('0495821')->is_valid_number, '北海道虻田郡洞爺湖町大原');
ok($zip->set_number('0495822')->is_valid_number, '北海道虻田郡洞爺湖町富丘');
ok($zip->set_number('0495831')->is_valid_number, '北海道虻田郡洞爺湖町香川');
ok($zip->set_number('0495832')->is_valid_number, '北海道虻田郡洞爺湖町成香');
ok($zip->set_number('0495833')->is_valid_number, '北海道虻田郡洞爺湖町伏見');
ok($zip->set_number('0500000')->is_valid_number, '北海道室蘭市以下に掲載がない場合');
ok($zip->set_number('0500051')->is_valid_number, '北海道室蘭市石川町');
ok($zip->set_number('0500052')->is_valid_number, '北海道室蘭市香川町');
ok($zip->set_number('0500053')->is_valid_number, '北海道室蘭市神代町');
ok($zip->set_number('0500054')->is_valid_number, '北海道室蘭市白鳥台');
ok($zip->set_number('0500055')->is_valid_number, '北海道室蘭市崎守町');
ok($zip->set_number('0500061')->is_valid_number, '北海道室蘭市八丁平');
ok($zip->set_number('0500062')->is_valid_number, '北海道室蘭市高平町');
ok($zip->set_number('0500063')->is_valid_number, '北海道室蘭市港北町');
ok($zip->set_number('0500064')->is_valid_number, '北海道室蘭市柏木町');
ok($zip->set_number('0500065')->is_valid_number, '北海道室蘭市本輪西町');
ok($zip->set_number('0500066')->is_valid_number, '北海道室蘭市幌萌町');
ok($zip->set_number('0500067')->is_valid_number, '北海道室蘭市陣屋町');
ok($zip->set_number('0500071')->is_valid_number, '北海道室蘭市水元町');
ok($zip->set_number('0500072')->is_valid_number, '北海道室蘭市高砂町');
ok($zip->set_number('0500073')->is_valid_number, '北海道室蘭市宮の森町');
ok($zip->set_number('0500074')->is_valid_number, '北海道室蘭市中島町');
ok($zip->set_number('0500075')->is_valid_number, '北海道室蘭市中島本町');
ok($zip->set_number('0500076')->is_valid_number, '北海道室蘭市知利別町');
ok($zip->set_number('0500077')->is_valid_number, '北海道室蘭市天神町');
ok($zip->set_number('0500081')->is_valid_number, '北海道室蘭市日の出町');
ok($zip->set_number('0500082')->is_valid_number, '北海道室蘭市寿町');
ok($zip->set_number('0500083')->is_valid_number, '北海道室蘭市東町');
ok($zip->set_number('0500084')->is_valid_number, '北海道室蘭市みゆき町');
ok($zip->set_number('0500085')->is_valid_number, '北海道室蘭市輪西町');
ok($zip->set_number('0500086')->is_valid_number, '北海道室蘭市大沢町');
ok($zip->set_number('0500087')->is_valid_number, '北海道室蘭市仲町');
ok($zip->set_number('0510001')->is_valid_number, '北海道室蘭市御崎町');
ok($zip->set_number('0510002')->is_valid_number, '北海道室蘭市御前水町');
ok($zip->set_number('0510003')->is_valid_number, '北海道室蘭市母恋南町');
ok($zip->set_number('0510004')->is_valid_number, '北海道室蘭市母恋北町');
ok($zip->set_number('0510005')->is_valid_number, '北海道室蘭市新富町');
ok($zip->set_number('0510006')->is_valid_number, '北海道室蘭市茶津町');
ok($zip->set_number('0510011')->is_valid_number, '北海道室蘭市中央町');
ok($zip->set_number('0510012')->is_valid_number, '北海道室蘭市山手町');
ok($zip->set_number('0510013')->is_valid_number, '北海道室蘭市舟見町');
ok($zip->set_number('0510014')->is_valid_number, '北海道室蘭市栄町');
ok($zip->set_number('0510015')->is_valid_number, '北海道室蘭市本町');
ok($zip->set_number('0510016')->is_valid_number, '北海道室蘭市幸町');
ok($zip->set_number('0510021')->is_valid_number, '北海道室蘭市緑町');
ok($zip->set_number('0510022')->is_valid_number, '北海道室蘭市海岸町');
ok($zip->set_number('0510023')->is_valid_number, '北海道室蘭市入江町');
ok($zip->set_number('0510024')->is_valid_number, '北海道室蘭市幕西町');
ok($zip->set_number('0510025')->is_valid_number, '北海道室蘭市常盤町');
ok($zip->set_number('0510026')->is_valid_number, '北海道室蘭市清水町');
ok($zip->set_number('0510027')->is_valid_number, '北海道室蘭市沢町');
ok($zip->set_number('0510028')->is_valid_number, '北海道室蘭市西小路町');
ok($zip->set_number('0510031')->is_valid_number, '北海道室蘭市築地町');
ok($zip->set_number('0510032')->is_valid_number, '北海道室蘭市港南町');
ok($zip->set_number('0510033')->is_valid_number, '北海道室蘭市小橋内町');
ok($zip->set_number('0510034')->is_valid_number, '北海道室蘭市増市町');
ok($zip->set_number('0510035')->is_valid_number, '北海道室蘭市絵鞆町');
ok($zip->set_number('0510036')->is_valid_number, '北海道室蘭市祝津町');
ok($zip->set_number('0520000')->is_valid_number, '北海道伊達市以下に掲載がない場合');
ok($zip->set_number('0520001')->is_valid_number, '北海道伊達市喜門別町');
ok($zip->set_number('0520001')->is_valid_number, '北海道伊達市志門気町');
ok($zip->set_number('0520002')->is_valid_number, '北海道伊達市乾町');
ok($zip->set_number('0520003')->is_valid_number, '北海道伊達市幌美内町');
ok($zip->set_number('0520004')->is_valid_number, '北海道伊達市萩原町');
ok($zip->set_number('0520005')->is_valid_number, '北海道伊達市清住町');
ok($zip->set_number('0520006')->is_valid_number, '北海道伊達市東関内町');
ok($zip->set_number('0520007')->is_valid_number, '北海道伊達市西関内町');
ok($zip->set_number('0520008')->is_valid_number, '北海道伊達市上館山町');
ok($zip->set_number('0520011')->is_valid_number, '北海道伊達市竹原町');
ok($zip->set_number('0520012')->is_valid_number, '北海道伊達市松ケ枝町');
ok($zip->set_number('0520013')->is_valid_number, '北海道伊達市弄月町');
ok($zip->set_number('0520014')->is_valid_number, '北海道伊達市舟岡町');
ok($zip->set_number('0520015')->is_valid_number, '北海道伊達市旭町');
ok($zip->set_number('0520016')->is_valid_number, '北海道伊達市東浜町');
ok($zip->set_number('0520021')->is_valid_number, '北海道伊達市末永町');
ok($zip->set_number('0520022')->is_valid_number, '北海道伊達市梅本町');
ok($zip->set_number('0520023')->is_valid_number, '北海道伊達市元町');
ok($zip->set_number('0520024')->is_valid_number, '北海道伊達市鹿島町');
ok($zip->set_number('0520025')->is_valid_number, '北海道伊達市網代町');
ok($zip->set_number('0520026')->is_valid_number, '北海道伊達市錦町');
ok($zip->set_number('0520027')->is_valid_number, '北海道伊達市大町');
ok($zip->set_number('0520031')->is_valid_number, '北海道伊達市館山町');
ok($zip->set_number('0520032')->is_valid_number, '北海道伊達市山下町');
ok($zip->set_number('0520033')->is_valid_number, '北海道伊達市西浜町');
ok($zip->set_number('0520034')->is_valid_number, '北海道伊達市館山下町');
ok($zip->set_number('0520035')->is_valid_number, '北海道伊達市長和町');
ok($zip->set_number('0520036')->is_valid_number, '北海道伊達市上長和町');
ok($zip->set_number('0520100')->is_valid_number, '北海道有珠郡壮瞥町以下に掲載がない場合');
ok($zip->set_number('0520101')->is_valid_number, '北海道有珠郡壮瞥町滝之町');
ok($zip->set_number('0520102')->is_valid_number, '北海道有珠郡壮瞥町昭和新山');
ok($zip->set_number('0520103')->is_valid_number, '北海道有珠郡壮瞥町壮瞥温泉');
ok($zip->set_number('0520104')->is_valid_number, '北海道有珠郡壮瞥町東湖畔');
ok($zip->set_number('0520105')->is_valid_number, '北海道有珠郡壮瞥町仲洞爺');
ok($zip->set_number('0520106')->is_valid_number, '北海道有珠郡壮瞥町立香');
ok($zip->set_number('0520107')->is_valid_number, '北海道有珠郡壮瞥町洞爺湖温泉(その他)');
ok($zip->set_number('0520111')->is_valid_number, '北海道有珠郡壮瞥町上久保内');
ok($zip->set_number('0520112')->is_valid_number, '北海道有珠郡壮瞥町久保内');
ok($zip->set_number('0520113')->is_valid_number, '北海道有珠郡壮瞥町蟠渓');
ok($zip->set_number('0520114')->is_valid_number, '北海道有珠郡壮瞥町幸内');
ok($zip->set_number('0520115')->is_valid_number, '北海道有珠郡壮瞥町弁景');
ok($zip->set_number('0520116')->is_valid_number, '北海道有珠郡壮瞥町南久保内');
ok($zip->set_number('0520301')->is_valid_number, '北海道伊達市大滝区本町');
ok($zip->set_number('0520302')->is_valid_number, '北海道伊達市大滝区清陵町');
ok($zip->set_number('0520303')->is_valid_number, '北海道伊達市大滝区三階滝町');
ok($zip->set_number('0520311')->is_valid_number, '北海道伊達市大滝区本郷町');
ok($zip->set_number('0520312')->is_valid_number, '北海道伊達市大滝区上野町');
ok($zip->set_number('0520313')->is_valid_number, '北海道伊達市大滝区大成町');
ok($zip->set_number('0520314')->is_valid_number, '北海道伊達市大滝区円山町');
ok($zip->set_number('0520315')->is_valid_number, '北海道伊達市大滝区昭園町');
ok($zip->set_number('0520316')->is_valid_number, '北海道伊達市大滝区北湯沢温泉町');
ok($zip->set_number('0520317')->is_valid_number, '北海道伊達市大滝区優徳町');
ok($zip->set_number('0530000')->is_valid_number, '北海道苫小牧市以下に掲載がない場合');
ok($zip->set_number('0530001')->is_valid_number, '北海道苫小牧市一本松町(6~15番地)');
ok($zip->set_number('0530002')->is_valid_number, '北海道苫小牧市晴海町(43番地)');
ok($zip->set_number('0530003')->is_valid_number, '北海道苫小牧市入船町');
ok($zip->set_number('0530004')->is_valid_number, '北海道苫小牧市港町');
ok($zip->set_number('0530005')->is_valid_number, '北海道苫小牧市元中野町');
ok($zip->set_number('0530006')->is_valid_number, '北海道苫小牧市新中野町');
ok($zip->set_number('0530007')->is_valid_number, '北海道苫小牧市船見町');
ok($zip->set_number('0530011')->is_valid_number, '北海道苫小牧市末広町');
ok($zip->set_number('0530012')->is_valid_number, '北海道苫小牧市汐見町');
ok($zip->set_number('0530013')->is_valid_number, '北海道苫小牧市高砂町');
ok($zip->set_number('0530014')->is_valid_number, '北海道苫小牧市浜町');
ok($zip->set_number('0530015')->is_valid_number, '北海道苫小牧市本幸町');
ok($zip->set_number('0530016')->is_valid_number, '北海道苫小牧市寿町');
ok($zip->set_number('0530017')->is_valid_number, '北海道苫小牧市栄町');
ok($zip->set_number('0530018')->is_valid_number, '北海道苫小牧市旭町');
ok($zip->set_number('0530021')->is_valid_number, '北海道苫小牧市若草町');
ok($zip->set_number('0530022')->is_valid_number, '北海道苫小牧市表町');
ok($zip->set_number('0530023')->is_valid_number, '北海道苫小牧市錦町');
ok($zip->set_number('0530024')->is_valid_number, '北海道苫小牧市大町');
ok($zip->set_number('0530025')->is_valid_number, '北海道苫小牧市本町');
ok($zip->set_number('0530026')->is_valid_number, '北海道苫小牧市幸町');
ok($zip->set_number('0530027')->is_valid_number, '北海道苫小牧市王子町');
ok($zip->set_number('0530031')->is_valid_number, '北海道苫小牧市春日町');
ok($zip->set_number('0530032')->is_valid_number, '北海道苫小牧市緑町');
ok($zip->set_number('0530033')->is_valid_number, '北海道苫小牧市木場町');
ok($zip->set_number('0530034')->is_valid_number, '北海道苫小牧市清水町');
ok($zip->set_number('0530035')->is_valid_number, '北海道苫小牧市高丘');
ok($zip->set_number('0530041')->is_valid_number, '北海道苫小牧市美園町');
ok($zip->set_number('0530042')->is_valid_number, '北海道苫小牧市三光町');
ok($zip->set_number('0530043')->is_valid_number, '北海道苫小牧市日の出町');
ok($zip->set_number('0530044')->is_valid_number, '北海道苫小牧市音羽町');
ok($zip->set_number('0530045')->is_valid_number, '北海道苫小牧市双葉町');
ok($zip->set_number('0530046')->is_valid_number, '北海道苫小牧市住吉町');
ok($zip->set_number('0530047')->is_valid_number, '北海道苫小牧市泉町');
ok($zip->set_number('0530051')->is_valid_number, '北海道苫小牧市明野元町');
ok($zip->set_number('0530052')->is_valid_number, '北海道苫小牧市新開町');
ok($zip->set_number('0530053')->is_valid_number, '北海道苫小牧市柳町');
ok($zip->set_number('0530054')->is_valid_number, '北海道苫小牧市明野新町');
ok($zip->set_number('0530055')->is_valid_number, '北海道苫小牧市新明町');
ok($zip->set_number('0530056')->is_valid_number, '北海道苫小牧市あけぼの町(3~5丁目)');
ok($zip->set_number('0530801')->is_valid_number, '北海道苫小牧市白金町');
ok($zip->set_number('0530802')->is_valid_number, '北海道苫小牧市弥生町');
ok($zip->set_number('0530803')->is_valid_number, '北海道苫小牧市矢代町');
ok($zip->set_number('0530804')->is_valid_number, '北海道苫小牧市元町');
ok($zip->set_number('0530805')->is_valid_number, '北海道苫小牧市新富町');
ok($zip->set_number('0530806')->is_valid_number, '北海道苫小牧市大成町');
ok($zip->set_number('0530807')->is_valid_number, '北海道苫小牧市青葉町');
ok($zip->set_number('0530811')->is_valid_number, '北海道苫小牧市光洋町');
ok($zip->set_number('0530812')->is_valid_number, '北海道苫小牧市有明町');
ok($zip->set_number('0530813')->is_valid_number, '北海道苫小牧市小糸井町');
ok($zip->set_number('0530814')->is_valid_number, '北海道苫小牧市糸井');
ok($zip->set_number('0530815')->is_valid_number, '北海道苫小牧市永福町');
ok($zip->set_number('0530816')->is_valid_number, '北海道苫小牧市日吉町');
ok($zip->set_number('0530821')->is_valid_number, '北海道苫小牧市しらかば町');
ok($zip->set_number('0530822')->is_valid_number, '北海道苫小牧市川沿町');
ok($zip->set_number('0530823')->is_valid_number, '北海道苫小牧市柏木町');
ok($zip->set_number('0530831')->is_valid_number, '北海道苫小牧市豊川町');
ok($zip->set_number('0530832')->is_valid_number, '北海道苫小牧市桜木町');
ok($zip->set_number('0530833')->is_valid_number, '北海道苫小牧市日新町');
ok($zip->set_number('0530841')->is_valid_number, '北海道苫小牧市松風町');
ok($zip->set_number('0530842')->is_valid_number, '北海道苫小牧市有珠の沢町');
ok($zip->set_number('0530843')->is_valid_number, '北海道苫小牧市桜坂町');
ok($zip->set_number('0530844')->is_valid_number, '北海道苫小牧市宮の森町');
ok($zip->set_number('0530845')->is_valid_number, '北海道苫小牧市はまなす町(1丁目)');
ok($zip->set_number('0530851')->is_valid_number, '北海道苫小牧市山手町');
ok($zip->set_number('0530852')->is_valid_number, '北海道苫小牧市北光町');
ok($zip->set_number('0530853')->is_valid_number, '北海道苫小牧市花園町');
ok($zip->set_number('0530854')->is_valid_number, '北海道苫小牧市啓北町');
ok($zip->set_number('0530855')->is_valid_number, '北海道苫小牧市見山町');
ok($zip->set_number('0540000')->is_valid_number, '北海道勇払郡むかわ町以下に掲載がない場合');
ok($zip->set_number('0540001')->is_valid_number, '北海道勇払郡むかわ町旭岡');
ok($zip->set_number('0540002')->is_valid_number, '北海道勇払郡むかわ町春日');
ok($zip->set_number('0540003')->is_valid_number, '北海道勇払郡むかわ町豊城');
ok($zip->set_number('0540004')->is_valid_number, '北海道勇払郡むかわ町田浦');
ok($zip->set_number('0540005')->is_valid_number, '北海道勇払郡むかわ町二宮');
ok($zip->set_number('0540011')->is_valid_number, '北海道勇払郡むかわ町有明');
ok($zip->set_number('0540012')->is_valid_number, '北海道勇払郡むかわ町生田');
ok($zip->set_number('0540013')->is_valid_number, '北海道勇払郡むかわ町花岡');
ok($zip->set_number('0540014')->is_valid_number, '北海道勇払郡むかわ町米原');
ok($zip->set_number('0540015')->is_valid_number, '北海道勇払郡むかわ町汐見');
ok($zip->set_number('0540016')->is_valid_number, '北海道勇払郡むかわ町宮戸');
ok($zip->set_number('0540021')->is_valid_number, '北海道勇払郡むかわ町大原');
ok($zip->set_number('0540022')->is_valid_number, '北海道勇払郡むかわ町花園');
ok($zip->set_number('0540023')->is_valid_number, '北海道勇払郡むかわ町末広');
ok($zip->set_number('0540031')->is_valid_number, '北海道勇払郡むかわ町青葉');
ok($zip->set_number('0540032')->is_valid_number, '北海道勇払郡むかわ町福住');
ok($zip->set_number('0540041')->is_valid_number, '北海道勇払郡むかわ町松風');
ok($zip->set_number('0540042')->is_valid_number, '北海道勇払郡むかわ町美幸');
ok($zip->set_number('0540051')->is_valid_number, '北海道勇払郡むかわ町文京');
ok($zip->set_number('0540052')->is_valid_number, '北海道勇払郡むかわ町大成');
ok($zip->set_number('0540061')->is_valid_number, '北海道勇払郡むかわ町洋光');
ok($zip->set_number('0540062')->is_valid_number, '北海道勇払郡むかわ町若草');
ok($zip->set_number('0540063')->is_valid_number, '北海道勇払郡むかわ町駒場');
ok($zip->set_number('0540064')->is_valid_number, '北海道勇払郡むかわ町晴海');
ok($zip->set_number('0540141')->is_valid_number, '北海道勇払郡むかわ町穂別栄');
ok($zip->set_number('0540142')->is_valid_number, '北海道勇払郡むかわ町穂別仁和');
ok($zip->set_number('0540143')->is_valid_number, '北海道勇払郡むかわ町穂別和泉');
ok($zip->set_number('0540144')->is_valid_number, '北海道勇払郡むかわ町穂別豊田(その他)');
ok($zip->set_number('0540201')->is_valid_number, '北海道勇払郡むかわ町穂別稲里');
ok($zip->set_number('0540202')->is_valid_number, '北海道勇払郡むかわ町穂別長和');
ok($zip->set_number('0540203')->is_valid_number, '北海道勇払郡むかわ町穂別豊田(新興)');
ok($zip->set_number('0540204')->is_valid_number, '北海道勇払郡むかわ町穂別平丘(川向)');
ok($zip->set_number('0540211')->is_valid_number, '北海道勇払郡むかわ町穂別');
ok($zip->set_number('0540361')->is_valid_number, '北海道勇払郡むかわ町穂別福山');
ok($zip->set_number('0540362')->is_valid_number, '北海道勇払郡むかわ町穂別安住');
ok($zip->set_number('0540363')->is_valid_number, '北海道勇払郡むかわ町穂別平丘(その他)');
ok($zip->set_number('0540364')->is_valid_number, '北海道勇払郡むかわ町穂別富内');
ok($zip->set_number('0550000')->is_valid_number, '北海道沙流郡日高町以下に掲載がない場合');
ok($zip->set_number('0550001')->is_valid_number, '北海道沙流郡日高町富川北');
ok($zip->set_number('0550002')->is_valid_number, '北海道沙流郡日高町平賀');
ok($zip->set_number('0550003')->is_valid_number, '北海道沙流郡日高町福満');
ok($zip->set_number('0550004')->is_valid_number, '北海道沙流郡日高町富川東');
ok($zip->set_number('0550005')->is_valid_number, '北海道沙流郡日高町富浜');
ok($zip->set_number('0550006')->is_valid_number, '北海道沙流郡日高町富川南');
ok($zip->set_number('0550007')->is_valid_number, '北海道沙流郡日高町富川西');
ok($zip->set_number('0550008')->is_valid_number, '北海道沙流郡日高町富川駒丘');
ok($zip->set_number('0550100')->is_valid_number, '北海道沙流郡平取町以下に掲載がない場合');
ok($zip->set_number('0550101')->is_valid_number, '北海道沙流郡平取町二風谷');
ok($zip->set_number('0550102')->is_valid_number, '北海道沙流郡平取町小平');
ok($zip->set_number('0550103')->is_valid_number, '北海道沙流郡平取町川向');
ok($zip->set_number('0550104')->is_valid_number, '北海道沙流郡平取町紫雲古津');
ok($zip->set_number('0550105')->is_valid_number, '北海道沙流郡平取町去場');
ok($zip->set_number('0550106')->is_valid_number, '北海道沙流郡平取町荷菜');
ok($zip->set_number('0550107')->is_valid_number, '北海道沙流郡平取町本町');
ok($zip->set_number('0550321')->is_valid_number, '北海道沙流郡平取町貫気別');
ok($zip->set_number('0550322')->is_valid_number, '北海道沙流郡平取町旭');
ok($zip->set_number('0550323')->is_valid_number, '北海道沙流郡平取町芽生');
ok($zip->set_number('0550324')->is_valid_number, '北海道沙流郡平取町荷負');
ok($zip->set_number('0550325')->is_valid_number, '北海道沙流郡平取町長知内');
ok($zip->set_number('0550411')->is_valid_number, '北海道沙流郡平取町振内町');
ok($zip->set_number('0550412')->is_valid_number, '北海道沙流郡平取町幌毛志');
ok($zip->set_number('0550413')->is_valid_number, '北海道沙流郡平取町仁世宇');
ok($zip->set_number('0550414')->is_valid_number, '北海道沙流郡平取町岩知志');
ok($zip->set_number('0550415')->is_valid_number, '北海道沙流郡平取町豊糠');
ok($zip->set_number('0552301')->is_valid_number, '北海道沙流郡日高町本町東');
ok($zip->set_number('0552302')->is_valid_number, '北海道沙流郡日高町本町西');
ok($zip->set_number('0552303')->is_valid_number, '北海道沙流郡日高町栄町東');
ok($zip->set_number('0552304')->is_valid_number, '北海道沙流郡日高町栄町西');
ok($zip->set_number('0552305')->is_valid_number, '北海道沙流郡日高町新町');
ok($zip->set_number('0552306')->is_valid_number, '北海道沙流郡日高町宮下町');
ok($zip->set_number('0552307')->is_valid_number, '北海道沙流郡日高町松風町');
ok($zip->set_number('0552308')->is_valid_number, '北海道沙流郡日高町山手町');
ok($zip->set_number('0552309')->is_valid_number, '北海道沙流郡日高町若葉町');
ok($zip->set_number('0552311')->is_valid_number, '北海道沙流郡日高町日高(1区)');
ok($zip->set_number('0552312')->is_valid_number, '北海道沙流郡日高町日高(2区)');
ok($zip->set_number('0552313')->is_valid_number, '北海道沙流郡日高町日高(3区)');
ok($zip->set_number('0552314')->is_valid_number, '北海道沙流郡日高町千栄');
ok($zip->set_number('0552315')->is_valid_number, '北海道沙流郡日高町富岡');
ok($zip->set_number('0552316')->is_valid_number, '北海道沙流郡日高町三岩');
ok($zip->set_number('0560000')->is_valid_number, '北海道日高郡新ひだか町以下に掲載がない場合');
ok($zip->set_number('0560001')->is_valid_number, '北海道日高郡新ひだか町静内目名(その他)');
ok($zip->set_number('0560002')->is_valid_number, '北海道日高郡新ひだか町静内神森');
ok($zip->set_number('0560003')->is_valid_number, '北海道日高郡新ひだか町静内旭町');
ok($zip->set_number('0560004')->is_valid_number, '北海道日高郡新ひだか町静内緑町');
ok($zip->set_number('0560005')->is_valid_number, '北海道日高郡新ひだか町静内こうせい町');
ok($zip->set_number('0560006')->is_valid_number, '北海道日高郡新ひだか町静内中野町');
ok($zip->set_number('0560007')->is_valid_number, '北海道日高郡新ひだか町静内清水丘');
ok($zip->set_number('0560011')->is_valid_number, '北海道日高郡新ひだか町静内真歌');
ok($zip->set_number('0560013')->is_valid_number, '北海道日高郡新ひだか町静内入船町');
ok($zip->set_number('0560014')->is_valid_number, '北海道日高郡新ひだか町静内古川町');
ok($zip->set_number('0560015')->is_valid_number, '北海道日高郡新ひだか町静内海岸町');
ok($zip->set_number('0560016')->is_valid_number, '北海道日高郡新ひだか町静内本町');
ok($zip->set_number('0560017')->is_valid_number, '北海道日高郡新ひだか町静内御幸町');
ok($zip->set_number('0560018')->is_valid_number, '北海道日高郡新ひだか町静内吉野町');
ok($zip->set_number('0560019')->is_valid_number, '北海道日高郡新ひだか町静内青柳町');
ok($zip->set_number('0560021')->is_valid_number, '北海道日高郡新ひだか町静内花園');
ok($zip->set_number('0560022')->is_valid_number, '北海道日高郡新ひだか町静内高砂町');
ok($zip->set_number('0560023')->is_valid_number, '北海道日高郡新ひだか町静内ときわ町');
ok($zip->set_number('0560024')->is_valid_number, '北海道日高郡新ひだか町静内山手町');
ok($zip->set_number('0560025')->is_valid_number, '北海道日高郡新ひだか町静内木場町');
ok($zip->set_number('0560026')->is_valid_number, '北海道日高郡新ひだか町静内末広町');
ok($zip->set_number('0560027')->is_valid_number, '北海道日高郡新ひだか町静内駒場');
ok($zip->set_number('0560028')->is_valid_number, '北海道日高郡新ひだか町静内柏台');
ok($zip->set_number('0560141')->is_valid_number, '北海道日高郡新ひだか町静内御園');
ok($zip->set_number('0560142')->is_valid_number, '北海道日高郡新ひだか町静内農屋');
ok($zip->set_number('0560143')->is_valid_number, '北海道日高郡新ひだか町静内豊畑');
ok($zip->set_number('0560144')->is_valid_number, '北海道日高郡新ひだか町静内田原');
ok($zip->set_number('0560145')->is_valid_number, '北海道日高郡新ひだか町静内目名(18、127、453、465-2、466、480番地)');
ok($zip->set_number('0560146')->is_valid_number, '北海道日高郡新ひだか町静内高見');
ok($zip->set_number('0570000')->is_valid_number, '北海道浦河郡浦河町以下に掲載がない場合');
ok($zip->set_number('0570001')->is_valid_number, '北海道浦河郡浦河町東幌別(1~131番地)');
ok($zip->set_number('0570002')->is_valid_number, '北海道浦河郡浦河町西幌別');
ok($zip->set_number('0570003')->is_valid_number, '北海道浦河郡浦河町白泉');
ok($zip->set_number('0570004')->is_valid_number, '北海道浦河郡浦河町月寒');
ok($zip->set_number('0570005')->is_valid_number, '北海道浦河郡浦河町東町うしお');
ok($zip->set_number('0570006')->is_valid_number, '北海道浦河郡浦河町東町かしわ');
ok($zip->set_number('0570007')->is_valid_number, '北海道浦河郡浦河町東町ちのみ');
ok($zip->set_number('0570011')->is_valid_number, '北海道浦河郡浦河町旭町');
ok($zip->set_number('0570012')->is_valid_number, '北海道浦河郡浦河町常盤町');
ok($zip->set_number('0570013')->is_valid_number, '北海道浦河郡浦河町大通');
ok($zip->set_number('0570014')->is_valid_number, '北海道浦河郡浦河町入船町');
ok($zip->set_number('0570015')->is_valid_number, '北海道浦河郡浦河町浜町');
ok($zip->set_number('0570021')->is_valid_number, '北海道浦河郡浦河町潮見町');
ok($zip->set_number('0570022')->is_valid_number, '北海道浦河郡浦河町昌平町');
ok($zip->set_number('0570023')->is_valid_number, '北海道浦河郡浦河町栄丘');
ok($zip->set_number('0570024')->is_valid_number, '北海道浦河郡浦河町築地');
ok($zip->set_number('0570025')->is_valid_number, '北海道浦河郡浦河町緑町');
ok($zip->set_number('0570026')->is_valid_number, '北海道浦河郡浦河町向別');
ok($zip->set_number('0570027')->is_valid_number, '北海道浦河郡浦河町上向別');
ok($zip->set_number('0570031')->is_valid_number, '北海道浦河郡浦河町向が丘東');
ok($zip->set_number('0570032')->is_valid_number, '北海道浦河郡浦河町向が丘西');
ok($zip->set_number('0570033')->is_valid_number, '北海道浦河郡浦河町堺町東');
ok($zip->set_number('0570034')->is_valid_number, '北海道浦河郡浦河町堺町西');
ok($zip->set_number('0570035')->is_valid_number, '北海道浦河郡浦河町井寒台');
ok($zip->set_number('0570036')->is_valid_number, '北海道浦河郡浦河町絵笛');
ok($zip->set_number('0570171')->is_valid_number, '北海道浦河郡浦河町西舎');
ok($zip->set_number('0570172')->is_valid_number, '北海道浦河郡浦河町杵臼');
ok($zip->set_number('0570173')->is_valid_number, '北海道浦河郡浦河町上杵臼');
ok($zip->set_number('0570174')->is_valid_number, '北海道浦河郡浦河町上西舎');
ok($zip->set_number('0580000')->is_valid_number, '北海道様似郡様似町以下に掲載がない場合');
ok($zip->set_number('0580001')->is_valid_number, '北海道様似郡様似町旭');
ok($zip->set_number('0580002')->is_valid_number, '北海道様似郡様似町幌満');
ok($zip->set_number('0580003')->is_valid_number, '北海道様似郡様似町冬島');
ok($zip->set_number('0580004')->is_valid_number, '北海道様似郡様似町平宇');
ok($zip->set_number('0580011')->is_valid_number, '北海道様似郡様似町田代');
ok($zip->set_number('0580012')->is_valid_number, '北海道様似郡様似町朝日丘');
ok($zip->set_number('0580013')->is_valid_number, '北海道様似郡様似町緑町');
ok($zip->set_number('0580014')->is_valid_number, '北海道様似郡様似町大通');
ok($zip->set_number('0580015')->is_valid_number, '北海道様似郡様似町錦町');
ok($zip->set_number('0580021')->is_valid_number, '北海道様似郡様似町新富');
ok($zip->set_number('0580022')->is_valid_number, '北海道様似郡様似町岡田');
ok($zip->set_number('0580023')->is_valid_number, '北海道様似郡様似町栄町');
ok($zip->set_number('0580024')->is_valid_number, '北海道様似郡様似町会所町');
ok($zip->set_number('0580025')->is_valid_number, '北海道様似郡様似町港町');
ok($zip->set_number('0580026')->is_valid_number, '北海道様似郡様似町本町');
ok($zip->set_number('0580027')->is_valid_number, '北海道様似郡様似町潮見台');
ok($zip->set_number('0580031')->is_valid_number, '北海道様似郡様似町西様似');
ok($zip->set_number('0580032')->is_valid_number, '北海道様似郡様似町西町');
ok($zip->set_number('0580033')->is_valid_number, '北海道様似郡様似町鵜苫');
ok($zip->set_number('0580041')->is_valid_number, '北海道浦河郡浦河町東幌別(その他)');
ok($zip->set_number('0580200')->is_valid_number, '北海道幌泉郡えりも町以下に掲載がない場合');
ok($zip->set_number('0580201')->is_valid_number, '北海道幌泉郡えりも町東洋(歌露、坂岸、エンドモ、エンドマカゲ)');
ok($zip->set_number('0580202')->is_valid_number, '北海道幌泉郡えりも町歌別');
ok($zip->set_number('0580203')->is_valid_number, '北海道幌泉郡えりも町新浜');
ok($zip->set_number('0580204')->is_valid_number, '北海道幌泉郡えりも町本町');
ok($zip->set_number('0580205')->is_valid_number, '北海道幌泉郡えりも町大和');
ok($zip->set_number('0580206')->is_valid_number, '北海道幌泉郡えりも町笛舞');
ok($zip->set_number('0580207')->is_valid_number, '北海道幌泉郡えりも町近浦');
ok($zip->set_number('0580341')->is_valid_number, '北海道幌泉郡えりも町苫別');
ok($zip->set_number('0580342')->is_valid_number, '北海道幌泉郡えりも町えりも岬');
ok($zip->set_number('0580343')->is_valid_number, '北海道幌泉郡えりも町東洋(油駒、南東洋、132~156、158~354、366、367番地)');
ok($zip->set_number('0580421')->is_valid_number, '北海道幌泉郡えりも町庶野');
ok($zip->set_number('0580422')->is_valid_number, '北海道幌泉郡えりも町目黒');
ok($zip->set_number('0590000')->is_valid_number, '北海道登別市以下に掲載がない場合');
ok($zip->set_number('0590001')->is_valid_number, '北海道登別市新栄町');
ok($zip->set_number('0590002')->is_valid_number, '北海道登別市幸町');
ok($zip->set_number('0590003')->is_valid_number, '北海道登別市千歳町');
ok($zip->set_number('0590004')->is_valid_number, '北海道登別市来馬町');
ok($zip->set_number('0590005')->is_valid_number, '北海道登別市札内町(5、9、11-12、36、42-2、62、80、95、');
ok($zip->set_number('0590005')->is_valid_number, '北海道登別市184、231、389-2、499、500番地)');
ok($zip->set_number('0590011')->is_valid_number, '北海道登別市常盤町');
ok($zip->set_number('0590012')->is_valid_number, '北海道登別市中央町');
ok($zip->set_number('0590013')->is_valid_number, '北海道登別市幌別町');
ok($zip->set_number('0590014')->is_valid_number, '北海道登別市富士町');
ok($zip->set_number('0590015')->is_valid_number, '北海道登別市新川町');
ok($zip->set_number('0590016')->is_valid_number, '北海道登別市片倉町');
ok($zip->set_number('0590017')->is_valid_number, '北海道登別市柏木町');
ok($zip->set_number('0590021')->is_valid_number, '北海道登別市鉱山町');
ok($zip->set_number('0590022')->is_valid_number, '北海道登別市川上町');
ok($zip->set_number('0590023')->is_valid_number, '北海道登別市桜木町');
ok($zip->set_number('0590024')->is_valid_number, '北海道登別市緑町');
ok($zip->set_number('0590025')->is_valid_number, '北海道登別市大和町');
ok($zip->set_number('0590026')->is_valid_number, '北海道登別市若山町');
ok($zip->set_number('0590027')->is_valid_number, '北海道登別市青葉町');
ok($zip->set_number('0590028')->is_valid_number, '北海道登別市富岸町');
ok($zip->set_number('0590031')->is_valid_number, '北海道登別市上鷲別町');
ok($zip->set_number('0590032')->is_valid_number, '北海道登別市新生町');
ok($zip->set_number('0590033')->is_valid_number, '北海道登別市栄町');
ok($zip->set_number('0590034')->is_valid_number, '北海道登別市鷲別町');
ok($zip->set_number('0590035')->is_valid_number, '北海道登別市若草町');
ok($zip->set_number('0590036')->is_valid_number, '北海道登別市美園町');
ok($zip->set_number('0590151')->is_valid_number, '北海道伊達市有珠町');
ok($zip->set_number('0590152')->is_valid_number, '北海道伊達市北有珠町');
ok($zip->set_number('0590153')->is_valid_number, '北海道伊達市大平町');
ok($zip->set_number('0590154')->is_valid_number, '北海道伊達市東有珠町');
ok($zip->set_number('0590155')->is_valid_number, '北海道伊達市若生町');
ok($zip->set_number('0590156')->is_valid_number, '北海道伊達市南有珠町');
ok($zip->set_number('0590157')->is_valid_number, '北海道伊達市向有珠町');
ok($zip->set_number('0590271')->is_valid_number, '北海道伊達市南黄金町');
ok($zip->set_number('0590272')->is_valid_number, '北海道伊達市北黄金町');
ok($zip->set_number('0590273')->is_valid_number, '北海道伊達市南稀府町');
ok($zip->set_number('0590274')->is_valid_number, '北海道伊達市中稀府町');
ok($zip->set_number('0590275')->is_valid_number, '北海道伊達市北稀府町');
ok($zip->set_number('0590461')->is_valid_number, '北海道登別市札内町(その他)');
ok($zip->set_number('0590462')->is_valid_number, '北海道登別市富浦町');
ok($zip->set_number('0590463')->is_valid_number, '北海道登別市中登別町');
ok($zip->set_number('0590464')->is_valid_number, '北海道登別市登別東町');
ok($zip->set_number('0590465')->is_valid_number, '北海道登別市登別本町');
ok($zip->set_number('0590466')->is_valid_number, '北海道登別市登別港町');
ok($zip->set_number('0590551')->is_valid_number, '北海道登別市登別温泉町');
ok($zip->set_number('0590552')->is_valid_number, '北海道登別市上登別町');
ok($zip->set_number('0590553')->is_valid_number, '北海道登別市カルルス町');
ok($zip->set_number('0590641')->is_valid_number, '北海道白老郡白老町虎杖浜');
ok($zip->set_number('0590642')->is_valid_number, '北海道白老郡白老町竹浦');
ok($zip->set_number('0590900')->is_valid_number, '北海道白老郡白老町以下に掲載がない場合');
ok($zip->set_number('0590901')->is_valid_number, '北海道白老郡白老町社台');
ok($zip->set_number('0590902')->is_valid_number, '北海道白老郡白老町若草町');
ok($zip->set_number('0590903')->is_valid_number, '北海道白老郡白老町日の出町');
ok($zip->set_number('0590904')->is_valid_number, '北海道白老郡白老町東町');
ok($zip->set_number('0590905')->is_valid_number, '北海道白老郡白老町大町');
ok($zip->set_number('0590906')->is_valid_number, '北海道白老郡白老町本町');
ok($zip->set_number('0590907')->is_valid_number, '北海道白老郡白老町末広町');
ok($zip->set_number('0590908')->is_valid_number, '北海道白老郡白老町緑丘');
ok($zip->set_number('0590911')->is_valid_number, '北海道白老郡白老町森野');
ok($zip->set_number('0590912')->is_valid_number, '北海道白老郡白老町陣屋町');
ok($zip->set_number('0590913')->is_valid_number, '北海道白老郡白老町緑町');
ok($zip->set_number('0590914')->is_valid_number, '北海道白老郡白老町栄町');
ok($zip->set_number('0590915')->is_valid_number, '北海道白老郡白老町川沿');
ok($zip->set_number('0590916')->is_valid_number, '北海道白老郡白老町高砂町');
ok($zip->set_number('0590921')->is_valid_number, '北海道白老郡白老町石山');
ok($zip->set_number('0590922')->is_valid_number, '北海道白老郡白老町萩野');
ok($zip->set_number('0590923')->is_valid_number, '北海道白老郡白老町北吉原');
ok($zip->set_number('0591261')->is_valid_number, '北海道苫小牧市ときわ町');
ok($zip->set_number('0591262')->is_valid_number, '北海道苫小牧市美原町');
ok($zip->set_number('0591263')->is_valid_number, '北海道苫小牧市青雲町');
ok($zip->set_number('0591264')->is_valid_number, '北海道苫小牧市宮前町');
ok($zip->set_number('0591265')->is_valid_number, '北海道苫小牧市樽前');
ok($zip->set_number('0591271')->is_valid_number, '北海道苫小牧市澄川町');
ok($zip->set_number('0591272')->is_valid_number, '北海道苫小牧市のぞみ町');
ok($zip->set_number('0591273')->is_valid_number, '北海道苫小牧市明徳町');
ok($zip->set_number('0591274')->is_valid_number, '北海道苫小牧市もえぎ町');
ok($zip->set_number('0591275')->is_valid_number, '北海道苫小牧市錦岡');
ok($zip->set_number('0591276')->is_valid_number, '北海道苫小牧市はまなす町(2丁目)');
ok($zip->set_number('0591301')->is_valid_number, '北海道苫小牧市東開町');
ok($zip->set_number('0591302')->is_valid_number, '北海道苫小牧市拓勇西町');
ok($zip->set_number('0591303')->is_valid_number, '北海道苫小牧市拓勇東町');
ok($zip->set_number('0591304')->is_valid_number, '北海道苫小牧市北栄町');
ok($zip->set_number('0591305')->is_valid_number, '北海道苫小牧市沼ノ端中央');
ok($zip->set_number('0591361')->is_valid_number, '北海道苫小牧市美沢');
ok($zip->set_number('0591362')->is_valid_number, '北海道苫小牧市柏原');
ok($zip->set_number('0591363')->is_valid_number, '北海道苫小牧市静川');
ok($zip->set_number('0591364')->is_valid_number, '北海道苫小牧市沼ノ端');
ok($zip->set_number('0591365')->is_valid_number, '北海道苫小牧市植苗');
ok($zip->set_number('0591366')->is_valid_number, '北海道苫小牧市あけぼの町(1、2丁目)');
ok($zip->set_number('0591371')->is_valid_number, '北海道苫小牧市弁天');
ok($zip->set_number('0591372')->is_valid_number, '北海道苫小牧市勇払');
ok($zip->set_number('0591373')->is_valid_number, '北海道苫小牧市真砂町');
ok($zip->set_number('0591374')->is_valid_number, '北海道苫小牧市晴海町(1~42番地)');
ok($zip->set_number('0591375')->is_valid_number, '北海道苫小牧市一本松町(1~5番地)');
ok($zip->set_number('0591431')->is_valid_number, '北海道勇払郡安平町早来新栄');
ok($zip->set_number('0591432')->is_valid_number, '北海道勇払郡安平町早来源武');
ok($zip->set_number('0591433')->is_valid_number, '北海道勇払郡安平町遠浅');
ok($zip->set_number('0591434')->is_valid_number, '北海道勇払郡安平町早来富岡');
ok($zip->set_number('0591500')->is_valid_number, '北海道勇払郡安平町以下に掲載がない場合');
ok($zip->set_number('0591501')->is_valid_number, '北海道勇払郡安平町早来大町');
ok($zip->set_number('0591502')->is_valid_number, '北海道勇払郡安平町早来北進');
ok($zip->set_number('0591503')->is_valid_number, '北海道勇払郡安平町東早来');
ok($zip->set_number('0591504')->is_valid_number, '北海道勇払郡安平町早来守田');
ok($zip->set_number('0591505')->is_valid_number, '北海道勇払郡安平町早来栄町');
ok($zip->set_number('0591506')->is_valid_number, '北海道勇払郡安平町早来北町');
ok($zip->set_number('0591511')->is_valid_number, '北海道勇払郡安平町安平');
ok($zip->set_number('0591512')->is_valid_number, '北海道勇払郡安平町早来瑞穂');
ok($zip->set_number('0591513')->is_valid_number, '北海道勇払郡安平町早来緑丘');
ok($zip->set_number('0591600')->is_valid_number, '北海道勇払郡厚真町以下に掲載がない場合');
ok($zip->set_number('0591601')->is_valid_number, '北海道勇払郡厚真町京町');
ok($zip->set_number('0591602')->is_valid_number, '北海道勇払郡厚真町表町');
ok($zip->set_number('0591603')->is_valid_number, '北海道勇払郡厚真町本町');
ok($zip->set_number('0591604')->is_valid_number, '北海道勇払郡厚真町錦町');
ok($zip->set_number('0591605')->is_valid_number, '北海道勇払郡厚真町本郷');
ok($zip->set_number('0591606')->is_valid_number, '北海道勇払郡厚真町朝日');
ok($zip->set_number('0591611')->is_valid_number, '北海道勇払郡厚真町幌里');
ok($zip->set_number('0591612')->is_valid_number, '北海道勇払郡厚真町桜丘');
ok($zip->set_number('0591613')->is_valid_number, '北海道勇払郡厚真町吉野');
ok($zip->set_number('0591614')->is_valid_number, '北海道勇払郡厚真町富里');
ok($zip->set_number('0591615')->is_valid_number, '北海道勇払郡厚真町高丘');
ok($zip->set_number('0591616')->is_valid_number, '北海道勇払郡厚真町幌内');
ok($zip->set_number('0591621')->is_valid_number, '北海道勇払郡厚真町東和');
ok($zip->set_number('0591622')->is_valid_number, '北海道勇払郡厚真町宇隆');
ok($zip->set_number('0591623')->is_valid_number, '北海道勇払郡厚真町新町');
ok($zip->set_number('0591624')->is_valid_number, '北海道勇払郡厚真町豊沢');
ok($zip->set_number('0591625')->is_valid_number, '北海道勇払郡厚真町美里');
ok($zip->set_number('0591741')->is_valid_number, '北海道勇払郡厚真町上厚真');
ok($zip->set_number('0591742')->is_valid_number, '北海道勇払郡厚真町浜厚真');
ok($zip->set_number('0591743')->is_valid_number, '北海道勇払郡厚真町共和');
ok($zip->set_number('0591744')->is_valid_number, '北海道勇払郡厚真町共栄');
ok($zip->set_number('0591745')->is_valid_number, '北海道勇払郡厚真町豊川');
ok($zip->set_number('0591746')->is_valid_number, '北海道勇払郡厚真町上野');
ok($zip->set_number('0591747')->is_valid_number, '北海道勇払郡厚真町富野');
ok($zip->set_number('0591748')->is_valid_number, '北海道勇払郡厚真町厚和');
ok($zip->set_number('0591749')->is_valid_number, '北海道勇払郡厚真町清住');
ok($zip->set_number('0591751')->is_valid_number, '北海道勇払郡厚真町鯉沼');
ok($zip->set_number('0591752')->is_valid_number, '北海道勇払郡厚真町軽舞');
ok($zip->set_number('0591753')->is_valid_number, '北海道勇払郡厚真町豊丘');
ok($zip->set_number('0591754')->is_valid_number, '北海道勇払郡厚真町鹿沼');
ok($zip->set_number('0591911')->is_valid_number, '北海道勇払郡安平町追分本町');
ok($zip->set_number('0591921')->is_valid_number, '北海道勇払郡安平町追分柏が丘');
ok($zip->set_number('0591931')->is_valid_number, '北海道勇払郡安平町追分中央');
ok($zip->set_number('0591941')->is_valid_number, '北海道勇払郡安平町追分青葉');
ok($zip->set_number('0591942')->is_valid_number, '北海道勇払郡安平町追分白樺');
ok($zip->set_number('0591951')->is_valid_number, '北海道勇払郡安平町追分若草');
ok($zip->set_number('0591961')->is_valid_number, '北海道勇払郡安平町追分花園');
ok($zip->set_number('0591971')->is_valid_number, '北海道勇払郡安平町追分緑が丘');
ok($zip->set_number('0591982')->is_valid_number, '北海道勇払郡安平町追分美園');
ok($zip->set_number('0591983')->is_valid_number, '北海道勇払郡安平町追分旭');
ok($zip->set_number('0591984')->is_valid_number, '北海道勇払郡安平町追分向陽');
ok($zip->set_number('0591985')->is_valid_number, '北海道勇払郡安平町追分春日');
ok($zip->set_number('0591986')->is_valid_number, '北海道勇払郡安平町追分弥生');
ok($zip->set_number('0591987')->is_valid_number, '北海道勇払郡安平町追分豊栄');
ok($zip->set_number('0592121')->is_valid_number, '北海道沙流郡日高町門別本町');
ok($zip->set_number('0592122')->is_valid_number, '北海道沙流郡日高町緑町');
ok($zip->set_number('0592123')->is_valid_number, '北海道沙流郡日高町幾千世');
ok($zip->set_number('0592124')->is_valid_number, '北海道沙流郡日高町庫富');
ok($zip->set_number('0592125')->is_valid_number, '北海道沙流郡日高町広富');
ok($zip->set_number('0592126')->is_valid_number, '北海道沙流郡日高町豊郷');
ok($zip->set_number('0592127')->is_valid_number, '北海道沙流郡日高町旭町');
ok($zip->set_number('0592241')->is_valid_number, '北海道沙流郡日高町豊田');
ok($zip->set_number('0592242')->is_valid_number, '北海道沙流郡日高町美原');
ok($zip->set_number('0592243')->is_valid_number, '北海道沙流郡日高町厚賀町');
ok($zip->set_number('0592244')->is_valid_number, '北海道沙流郡日高町賀張');
ok($zip->set_number('0592245')->is_valid_number, '北海道沙流郡日高町清畠');
ok($zip->set_number('0592251')->is_valid_number, '北海道新冠郡新冠町共栄');
ok($zip->set_number('0592252')->is_valid_number, '北海道新冠郡新冠町東川');
ok($zip->set_number('0592253')->is_valid_number, '北海道新冠郡新冠町大狩部(436、516、567番地)');
ok($zip->set_number('0592331')->is_valid_number, '北海道沙流郡日高町正和');
ok($zip->set_number('0592332')->is_valid_number, '北海道沙流郡日高町三和');
ok($zip->set_number('0592341')->is_valid_number, '北海道新冠郡新冠町新和');
ok($zip->set_number('0592342')->is_valid_number, '北海道新冠郡新冠町里平');
ok($zip->set_number('0592343')->is_valid_number, '北海道新冠郡新冠町太陽');
ok($zip->set_number('0592344')->is_valid_number, '北海道新冠郡新冠町美宇');
ok($zip->set_number('0592400')->is_valid_number, '北海道新冠郡新冠町以下に掲載がない場合');
ok($zip->set_number('0592401')->is_valid_number, '北海道新冠郡新冠町本町');
ok($zip->set_number('0592402')->is_valid_number, '北海道新冠郡新冠町中央町');
ok($zip->set_number('0592403')->is_valid_number, '北海道新冠郡新冠町北星町');
ok($zip->set_number('0592404')->is_valid_number, '北海道新冠郡新冠町東町');
ok($zip->set_number('0592411')->is_valid_number, '北海道新冠郡新冠町大狩部(その他)');
ok($zip->set_number('0592412')->is_valid_number, '北海道新冠郡新冠町節婦町');
ok($zip->set_number('0592413')->is_valid_number, '北海道新冠郡新冠町高江');
ok($zip->set_number('0592414')->is_valid_number, '北海道新冠郡新冠町朝日');
ok($zip->set_number('0592415')->is_valid_number, '北海道新冠郡新冠町緑丘');
ok($zip->set_number('0592416')->is_valid_number, '北海道新冠郡新冠町古岸');
ok($zip->set_number('0592417')->is_valid_number, '北海道新冠郡新冠町東泊津');
ok($zip->set_number('0592418')->is_valid_number, '北海道新冠郡新冠町西泊津');
ok($zip->set_number('0592421')->is_valid_number, '北海道新冠郡新冠町若園');
ok($zip->set_number('0592422')->is_valid_number, '北海道新冠郡新冠町岩清水');
ok($zip->set_number('0592423')->is_valid_number, '北海道新冠郡新冠町泉');
ok($zip->set_number('0592424')->is_valid_number, '北海道新冠郡新冠町新栄');
ok($zip->set_number('0592425')->is_valid_number, '北海道新冠郡新冠町明和');
ok($zip->set_number('0592426')->is_valid_number, '北海道新冠郡新冠町万世');
ok($zip->set_number('0592427')->is_valid_number, '北海道新冠郡新冠町大富');
ok($zip->set_number('0592561')->is_valid_number, '北海道日高郡新ひだか町東静内');
ok($zip->set_number('0592562')->is_valid_number, '北海道日高郡新ひだか町静内浦和');
ok($zip->set_number('0592563')->is_valid_number, '北海道日高郡新ひだか町静内川合');
ok($zip->set_number('0592564')->is_valid_number, '北海道日高郡新ひだか町静内西川');
ok($zip->set_number('0592565')->is_valid_number, '北海道日高郡新ひだか町静内春立');
ok($zip->set_number('0592566')->is_valid_number, '北海道日高郡新ひだか町静内東別');
ok($zip->set_number('0592571')->is_valid_number, '北海道日高郡新ひだか町三石西端');
ok($zip->set_number('0593101')->is_valid_number, '北海道日高郡新ひだか町三石富沢');
ok($zip->set_number('0593102')->is_valid_number, '北海道日高郡新ひだか町三石福畑');
ok($zip->set_number('0593103')->is_valid_number, '北海道日高郡新ひだか町三石豊岡');
ok($zip->set_number('0593104')->is_valid_number, '北海道日高郡新ひだか町三石蓬栄');
ok($zip->set_number('0593105')->is_valid_number, '北海道日高郡新ひだか町三石東蓬莱');
ok($zip->set_number('0593106')->is_valid_number, '北海道日高郡新ひだか町三石西蓬莱');
ok($zip->set_number('0593107')->is_valid_number, '北海道日高郡新ひだか町三石旭町');
ok($zip->set_number('0593108')->is_valid_number, '北海道日高郡新ひだか町三石本町');
ok($zip->set_number('0593111')->is_valid_number, '北海道日高郡新ひだか町三石越海町');
ok($zip->set_number('0593112')->is_valid_number, '北海道日高郡新ひだか町三石港町');
ok($zip->set_number('0593231')->is_valid_number, '北海道日高郡新ひだか町三石本桐');
ok($zip->set_number('0593232')->is_valid_number, '北海道日高郡新ひだか町三石美野和');
ok($zip->set_number('0593233')->is_valid_number, '北海道日高郡新ひだか町三石鳧舞');
ok($zip->set_number('0593351')->is_valid_number, '北海道日高郡新ひだか町三石歌笛');
ok($zip->set_number('0593352')->is_valid_number, '北海道日高郡新ひだか町三石稲見');
ok($zip->set_number('0593353')->is_valid_number, '北海道日高郡新ひだか町三石清瀬');
ok($zip->set_number('0593354')->is_valid_number, '北海道日高郡新ひだか町三石川上');
ok($zip->set_number('0593355')->is_valid_number, '北海道日高郡新ひだか町三石美河');
ok($zip->set_number('0593451')->is_valid_number, '北海道浦河郡浦河町荻伏町');
ok($zip->set_number('0593453')->is_valid_number, '北海道浦河郡浦河町瑞穂');
ok($zip->set_number('0593454')->is_valid_number, '北海道浦河郡浦河町野深');
ok($zip->set_number('0593461')->is_valid_number, '北海道浦河郡浦河町東栄');
ok($zip->set_number('0593462')->is_valid_number, '北海道浦河郡浦河町富里');
ok($zip->set_number('0593463')->is_valid_number, '北海道浦河郡浦河町姉茶');
ok($zip->set_number('0600000')->is_valid_number, '北海道札幌市中央区以下に掲載がない場合');
ok($zip->set_number('0600001')->is_valid_number, '北海道札幌市中央区北一条西(1~19丁目)');
ok($zip->set_number('0600002')->is_valid_number, '北海道札幌市中央区北二条西(1~19丁目)');
ok($zip->set_number('0600003')->is_valid_number, '北海道札幌市中央区北三条西(1~19丁目)');
ok($zip->set_number('0600004')->is_valid_number, '北海道札幌市中央区北四条西(1~19丁目)');
ok($zip->set_number('0600005')->is_valid_number, '北海道札幌市中央区北五条西(1~24丁目)');
ok($zip->set_number('0600006')->is_valid_number, '北海道札幌市中央区北六条西(10~25丁目)');
ok($zip->set_number('0600007')->is_valid_number, '北海道札幌市中央区北七条西');
ok($zip->set_number('0600008')->is_valid_number, '北海道札幌市中央区北八条西');
ok($zip->set_number('0600009')->is_valid_number, '北海道札幌市中央区北九条西');
ok($zip->set_number('0600010')->is_valid_number, '北海道札幌市中央区北十条西');
ok($zip->set_number('0600011')->is_valid_number, '北海道札幌市中央区北十一条西');
ok($zip->set_number('0600012')->is_valid_number, '北海道札幌市中央区北十二条西');
ok($zip->set_number('0600013')->is_valid_number, '北海道札幌市中央区北十三条西');
ok($zip->set_number('0600014')->is_valid_number, '北海道札幌市中央区北十四条西');
ok($zip->set_number('0600015')->is_valid_number, '北海道札幌市中央区北十五条西');
ok($zip->set_number('0600016')->is_valid_number, '北海道札幌市中央区北十六条西');
ok($zip->set_number('0600017')->is_valid_number, '北海道札幌市中央区北十七条西');
ok($zip->set_number('0600018')->is_valid_number, '北海道札幌市中央区北十八条西');
ok($zip->set_number('0600020')->is_valid_number, '北海道札幌市中央区北二十条西');
ok($zip->set_number('0600021')->is_valid_number, '北海道札幌市中央区北二十一条西');
ok($zip->set_number('0600022')->is_valid_number, '北海道札幌市中央区北二十二条西');
ok($zip->set_number('0600031')->is_valid_number, '北海道札幌市中央区北一条東');
ok($zip->set_number('0600032')->is_valid_number, '北海道札幌市中央区北二条東');
ok($zip->set_number('0600033')->is_valid_number, '北海道札幌市中央区北三条東');
ok($zip->set_number('0600034')->is_valid_number, '北海道札幌市中央区北四条東(1~8丁目)');
ok($zip->set_number('0600035')->is_valid_number, '北海道札幌市中央区北五条東');
ok($zip->set_number('0600041')->is_valid_number, '北海道札幌市中央区大通東');
ok($zip->set_number('0600042')->is_valid_number, '北海道札幌市中央区大通西(1~19丁目)');
ok($zip->set_number('0600051')->is_valid_number, '北海道札幌市中央区南一条東');
ok($zip->set_number('0600052')->is_valid_number, '北海道札幌市中央区南二条東');
ok($zip->set_number('0600053')->is_valid_number, '北海道札幌市中央区南三条東');
ok($zip->set_number('0600054')->is_valid_number, '北海道札幌市中央区南四条東');
ok($zip->set_number('0600055')->is_valid_number, '北海道札幌市中央区南五条東');
ok($zip->set_number('0600056')->is_valid_number, '北海道札幌市中央区南六条東');
ok($zip->set_number('0600057')->is_valid_number, '北海道札幌市中央区南七条東');
ok($zip->set_number('0600061')->is_valid_number, '北海道札幌市中央区南一条西(1~19丁目)');
ok($zip->set_number('0600062')->is_valid_number, '北海道札幌市中央区南二条西(1~19丁目)');
ok($zip->set_number('0600063')->is_valid_number, '北海道札幌市中央区南三条西(1~18丁目)');
ok($zip->set_number('0600806')->is_valid_number, '北海道札幌市北区北六条西');
ok($zip->set_number('0600807')->is_valid_number, '北海道札幌市北区北七条西');
ok($zip->set_number('0600808')->is_valid_number, '北海道札幌市北区北八条西');
ok($zip->set_number('0600809')->is_valid_number, '北海道札幌市北区北九条西');
ok($zip->set_number('0600810')->is_valid_number, '北海道札幌市北区北十条西(5~11丁目)');
ok($zip->set_number('0600811')->is_valid_number, '北海道札幌市北区北十一条西(5~11丁目)');
ok($zip->set_number('0600812')->is_valid_number, '北海道札幌市北区北十二条西(5~12丁目)');
ok($zip->set_number('0600813')->is_valid_number, '北海道札幌市北区北十三条西(5~12丁目)');
ok($zip->set_number('0600814')->is_valid_number, '北海道札幌市北区北十四条西(5~13丁目)');
ok($zip->set_number('0600815')->is_valid_number, '北海道札幌市北区北十五条西(6~13丁目)');
ok($zip->set_number('0600816')->is_valid_number, '北海道札幌市北区北十六条西(7~13丁目)');
ok($zip->set_number('0600817')->is_valid_number, '北海道札幌市北区北十七条西(7~13丁目)');
ok($zip->set_number('0600818')->is_valid_number, '北海道札幌市北区北十八条西(8~13丁目)');
ok($zip->set_number('0600819')->is_valid_number, '北海道札幌市北区北十九条西(8~13丁目)');
ok($zip->set_number('0600820')->is_valid_number, '北海道札幌市北区北二十条西(11~13丁目)');
ok($zip->set_number('0600905')->is_valid_number, '北海道札幌市東区北五条東(4~7丁目)');
ok($zip->set_number('0600906')->is_valid_number, '北海道札幌市東区北六条東(1~7丁目)');
ok($zip->set_number('0600907')->is_valid_number, '北海道札幌市東区北七条東(1~7丁目)');
ok($zip->set_number('0600908')->is_valid_number, '北海道札幌市東区北八条東(1~7丁目)');
ok($zip->set_number('0600909')->is_valid_number, '北海道札幌市東区北九条東(1~7丁目)');
ok($zip->set_number('0610200')->is_valid_number, '北海道石狩郡当別町以下に掲載がない場合');
ok($zip->set_number('0610201')->is_valid_number, '北海道石狩郡当別町青山');
ok($zip->set_number('0610202')->is_valid_number, '北海道石狩郡当別町茂平沢');
ok($zip->set_number('0610203')->is_valid_number, '北海道石狩郡当別町みどり野');
ok($zip->set_number('0610204')->is_valid_number, '北海道石狩郡当別町若葉');
ok($zip->set_number('0610205')->is_valid_number, '北海道石狩郡当別町下川町');
ok($zip->set_number('0610206')->is_valid_number, '北海道石狩郡当別町川下(その他)');
ok($zip->set_number('0610207')->is_valid_number, '北海道石狩郡当別町上当別');
ok($zip->set_number('0610208')->is_valid_number, '北海道石狩郡当別町弁華別');
ok($zip->set_number('0610211')->is_valid_number, '北海道石狩郡当別町中小屋');
ok($zip->set_number('0610212')->is_valid_number, '北海道石狩郡当別町金沢');
ok($zip->set_number('0610213')->is_valid_number, '北海道石狩郡当別町東裏');
ok($zip->set_number('0610214')->is_valid_number, '北海道石狩郡当別町蕨岱');
ok($zip->set_number('0610215')->is_valid_number, '北海道石狩郡当別町対雁');
ok($zip->set_number('0610216')->is_valid_number, '北海道石狩郡当別町栄町');
ok($zip->set_number('0610217')->is_valid_number, '北海道石狩郡当別町幸町');
ok($zip->set_number('0610218')->is_valid_number, '北海道石狩郡当別町樺戸町');
ok($zip->set_number('0610221')->is_valid_number, '北海道石狩郡当別町東町');
ok($zip->set_number('0610222')->is_valid_number, '北海道石狩郡当別町元町');
ok($zip->set_number('0610223')->is_valid_number, '北海道石狩郡当別町弥生');
ok($zip->set_number('0610224')->is_valid_number, '北海道石狩郡当別町末広');
ok($zip->set_number('0610225')->is_valid_number, '北海道石狩郡当別町美里');
ok($zip->set_number('0610226')->is_valid_number, '北海道石狩郡当別町錦町');
ok($zip->set_number('0610227')->is_valid_number, '北海道石狩郡当別町園生');
ok($zip->set_number('0610228')->is_valid_number, '北海道石狩郡当別町緑町');
ok($zip->set_number('0610231')->is_valid_number, '北海道石狩郡当別町六軒町');
ok($zip->set_number('0610232')->is_valid_number, '北海道石狩郡当別町春日町');
ok($zip->set_number('0610233')->is_valid_number, '北海道石狩郡当別町白樺町');
ok($zip->set_number('0610234')->is_valid_number, '北海道石狩郡当別町西町');
ok($zip->set_number('0610235')->is_valid_number, '北海道石狩郡当別町北栄町');
ok($zip->set_number('0610251')->is_valid_number, '北海道石狩郡当別町青山奥四番川');
ok($zip->set_number('0610252')->is_valid_number, '北海道石狩郡当別町青山奥三番川');
ok($zip->set_number('0610253')->is_valid_number, '北海道石狩郡当別町青山奥二番川');
ok($zip->set_number('0610254')->is_valid_number, '北海道石狩郡当別町青山中央(青山奥)');
ok($zip->set_number('0610500')->is_valid_number, '北海道樺戸郡月形町以下に掲載がない場合');
ok($zip->set_number('0610501')->is_valid_number, '北海道樺戸郡月形町新生');
ok($zip->set_number('0610502')->is_valid_number, '北海道樺戸郡月形町北農場');
ok($zip->set_number('0610503')->is_valid_number, '北海道樺戸郡月形町豊ケ丘');
ok($zip->set_number('0610504')->is_valid_number, '北海道樺戸郡月形町新富');
ok($zip->set_number('0610505')->is_valid_number, '北海道樺戸郡月形町札比内');
ok($zip->set_number('0610506')->is_valid_number, '北海道樺戸郡月形町新宮');
ok($zip->set_number('0610507')->is_valid_number, '北海道樺戸郡月形町南札比内');
ok($zip->set_number('0610508')->is_valid_number, '北海道樺戸郡月形町厚栄');
ok($zip->set_number('0610511')->is_valid_number, '北海道樺戸郡月形町市北');
ok($zip->set_number('0610512')->is_valid_number, '北海道樺戸郡月形町市南');
ok($zip->set_number('0610513')->is_valid_number, '北海道樺戸郡月形町農事会');
ok($zip->set_number('0610514')->is_valid_number, '北海道樺戸郡月形町麻生');
ok($zip->set_number('0610515')->is_valid_number, '北海道樺戸郡月形町五耕地山');
ok($zip->set_number('0610516')->is_valid_number, '北海道樺戸郡月形町知来乙');
ok($zip->set_number('0610517')->is_valid_number, '北海道樺戸郡月形町北郷');
ok($zip->set_number('0610518')->is_valid_number, '北海道樺戸郡月形町赤川');
ok($zip->set_number('0610521')->is_valid_number, '北海道樺戸郡月形町南耕地');
ok($zip->set_number('0610522')->is_valid_number, '北海道樺戸郡月形町月浜');
ok($zip->set_number('0610523')->is_valid_number, '北海道樺戸郡月形町昭栄');
ok($zip->set_number('0610524')->is_valid_number, '北海道樺戸郡月形町南新田');
ok($zip->set_number('0610525')->is_valid_number, '北海道樺戸郡月形町新栄');
ok($zip->set_number('0610526')->is_valid_number, '北海道樺戸郡月形町新田');
ok($zip->set_number('0610527')->is_valid_number, '北海道樺戸郡月形町共和');
ok($zip->set_number('0610528')->is_valid_number, '北海道樺戸郡月形町月ケ岡');
ok($zip->set_number('0610600')->is_valid_number, '北海道樺戸郡浦臼町以下に掲載がない場合');
ok($zip->set_number('0610601')->is_valid_number, '北海道樺戸郡浦臼町鶴沼第1');
ok($zip->set_number('0610602')->is_valid_number, '北海道樺戸郡浦臼町鶴沼第2');
ok($zip->set_number('0610603')->is_valid_number, '北海道樺戸郡浦臼町鶴沼第3');
ok($zip->set_number('0610611')->is_valid_number, '北海道樺戸郡浦臼町浦臼第1');
ok($zip->set_number('0610612')->is_valid_number, '北海道樺戸郡浦臼町浦臼第2');
ok($zip->set_number('0610613')->is_valid_number, '北海道樺戸郡浦臼町浦臼第3');
ok($zip->set_number('0610614')->is_valid_number, '北海道樺戸郡浦臼町浦臼第4');
ok($zip->set_number('0610615')->is_valid_number, '北海道樺戸郡浦臼町浦臼第5');
ok($zip->set_number('0610616')->is_valid_number, '北海道樺戸郡浦臼町浦臼第6');
ok($zip->set_number('0610617')->is_valid_number, '北海道樺戸郡浦臼町浦臼第7');
ok($zip->set_number('0610618')->is_valid_number, '北海道樺戸郡浦臼町浦臼第8');
ok($zip->set_number('0610621')->is_valid_number, '北海道樺戸郡浦臼町晩生内第1');
ok($zip->set_number('0610622')->is_valid_number, '北海道樺戸郡浦臼町晩生内第2');
ok($zip->set_number('0610623')->is_valid_number, '北海道樺戸郡浦臼町晩生内第3');
ok($zip->set_number('0611100')->is_valid_number, '北海道北広島市以下に掲載がない場合');
ok($zip->set_number('0611101')->is_valid_number, '北海道北広島市中の沢(その他)');
ok($zip->set_number('0611102')->is_valid_number, '北海道北広島市西の里');
ok($zip->set_number('0611103')->is_valid_number, '北海道北広島市虹ケ丘');
ok($zip->set_number('0611104')->is_valid_number, '北海道北広島市西の里北');
ok($zip->set_number('0611105')->is_valid_number, '北海道北広島市西の里東');
ok($zip->set_number('0611106')->is_valid_number, '北海道北広島市西の里南');
ok($zip->set_number('0611111')->is_valid_number, '北海道北広島市北の里');
ok($zip->set_number('0611112')->is_valid_number, '北海道北広島市共栄');
ok($zip->set_number('0611113')->is_valid_number, '北海道北広島市共栄町');
ok($zip->set_number('0611114')->is_valid_number, '北海道北広島市東共栄');
ok($zip->set_number('0611115')->is_valid_number, '北海道北広島市美咲き野');
ok($zip->set_number('0611121')->is_valid_number, '北海道北広島市中央');
ok($zip->set_number('0611122')->is_valid_number, '北海道北広島市広島');
ok($zip->set_number('0611123')->is_valid_number, '北海道北広島市朝日町');
ok($zip->set_number('0611124')->is_valid_number, '北海道北広島市稲穂町西');
ok($zip->set_number('0611125')->is_valid_number, '北海道北広島市稲穂町東');
ok($zip->set_number('0611126')->is_valid_number, '北海道北広島市新富町東');
ok($zip->set_number('0611127')->is_valid_number, '北海道北広島市新富町西');
ok($zip->set_number('0611131')->is_valid_number, '北海道北広島市美沢');
ok($zip->set_number('0611132')->is_valid_number, '北海道北広島市北進町');
ok($zip->set_number('0611133')->is_valid_number, '北海道北広島市栄町');
ok($zip->set_number('0611134')->is_valid_number, '北海道北広島市広葉町');
ok($zip->set_number('0611135')->is_valid_number, '北海道北広島市輝美町');
ok($zip->set_number('0611136')->is_valid_number, '北海道北広島市松葉町');
ok($zip->set_number('0611137')->is_valid_number, '北海道北広島市緑陽町');
ok($zip->set_number('0611141')->is_valid_number, '北海道北広島市青葉町');
ok($zip->set_number('0611142')->is_valid_number, '北海道北広島市若葉町');
ok($zip->set_number('0611143')->is_valid_number, '北海道北広島市南町');
ok($zip->set_number('0611144')->is_valid_number, '北海道北広島市白樺町');
ok($zip->set_number('0611145')->is_valid_number, '北海道北広島市泉町');
ok($zip->set_number('0611146')->is_valid_number, '北海道北広島市高台町');
ok($zip->set_number('0611147')->is_valid_number, '北海道北広島市里見町');
ok($zip->set_number('0611148')->is_valid_number, '北海道北広島市山手町');
ok($zip->set_number('0611151')->is_valid_number, '北海道北広島市東の里');
ok($zip->set_number('0611152')->is_valid_number, '北海道北広島市中の沢(557~736番地)');
ok($zip->set_number('0611153')->is_valid_number, '北海道北広島市富ケ岡');
ok($zip->set_number('0611154')->is_valid_number, '北海道北広島市南の里');
ok($zip->set_number('0611261')->is_valid_number, '北海道北広島市希望ケ丘');
ok($zip->set_number('0611264')->is_valid_number, '北海道北広島市輪厚');
ok($zip->set_number('0611265')->is_valid_number, '北海道北広島市島松');
ok($zip->set_number('0611266')->is_valid_number, '北海道北広島市三島');
ok($zip->set_number('0611267')->is_valid_number, '北海道北広島市仁別');
ok($zip->set_number('0611268')->is_valid_number, '北海道北広島市輪厚中央');
ok($zip->set_number('0611269')->is_valid_number, '北海道北広島市輪厚元町');
ok($zip->set_number('0611270')->is_valid_number, '北海道北広島市大曲');
ok($zip->set_number('0611271')->is_valid_number, '北海道北広島市大曲中央');
ok($zip->set_number('0611272')->is_valid_number, '北海道北広島市大曲末広');
ok($zip->set_number('0611273')->is_valid_number, '北海道北広島市大曲柏葉');
ok($zip->set_number('0611274')->is_valid_number, '北海道北広島市大曲工業団地');
ok($zip->set_number('0611275')->is_valid_number, '北海道北広島市大曲南ケ丘');
ok($zip->set_number('0611276')->is_valid_number, '北海道北広島市大曲緑ケ丘');
ok($zip->set_number('0611277')->is_valid_number, '北海道北広島市大曲光');
ok($zip->set_number('0611278')->is_valid_number, '北海道北広島市大曲幸町');
ok($zip->set_number('0611279')->is_valid_number, '北海道北広島市大曲並木');
ok($zip->set_number('0611281')->is_valid_number, '北海道北広島市輪厚工業団地');
ok($zip->set_number('0611351')->is_valid_number, '北海道恵庭市島松東町');
ok($zip->set_number('0611352')->is_valid_number, '北海道恵庭市島松仲町');
ok($zip->set_number('0611353')->is_valid_number, '北海道恵庭市島松本町');
ok($zip->set_number('0611354')->is_valid_number, '北海道恵庭市島松旭町');
ok($zip->set_number('0611355')->is_valid_number, '北海道恵庭市島松寿町');
ok($zip->set_number('0611356')->is_valid_number, '北海道恵庭市西島松');
ok($zip->set_number('0611361')->is_valid_number, '北海道恵庭市林田');
ok($zip->set_number('0611362')->is_valid_number, '北海道恵庭市中島松');
ok($zip->set_number('0611363')->is_valid_number, '北海道恵庭市桜森');
ok($zip->set_number('0611363')->is_valid_number, '北海道恵庭市島松沢');
ok($zip->set_number('0611364')->is_valid_number, '北海道恵庭市下島松');
ok($zip->set_number('0611365')->is_valid_number, '北海道恵庭市穂栄');
ok($zip->set_number('0611366')->is_valid_number, '北海道恵庭市北島');
ok($zip->set_number('0611371')->is_valid_number, '北海道恵庭市恵み野東');
ok($zip->set_number('0611372')->is_valid_number, '北海道恵庭市恵み野南');
ok($zip->set_number('0611373')->is_valid_number, '北海道恵庭市恵み野西');
ok($zip->set_number('0611374')->is_valid_number, '北海道恵庭市恵み野北');
ok($zip->set_number('0611375')->is_valid_number, '北海道恵庭市南島松');
ok($zip->set_number('0611376')->is_valid_number, '北海道恵庭市恵み野里美');
ok($zip->set_number('0611400')->is_valid_number, '北海道恵庭市以下に掲載がない場合');
ok($zip->set_number('0611401')->is_valid_number, '北海道恵庭市漁太');
ok($zip->set_number('0611402')->is_valid_number, '北海道恵庭市春日');
ok($zip->set_number('0611403')->is_valid_number, '北海道恵庭市中央');
ok($zip->set_number('0611404')->is_valid_number, '北海道恵庭市上山口');
ok($zip->set_number('0611405')->is_valid_number, '北海道恵庭市戸磯');
ok($zip->set_number('0611406')->is_valid_number, '北海道恵庭市和光町');
ok($zip->set_number('0611407')->is_valid_number, '北海道恵庭市黄金北');
ok($zip->set_number('0611409')->is_valid_number, '北海道恵庭市黄金南');
ok($zip->set_number('0611411')->is_valid_number, '北海道恵庭市恵南');
ok($zip->set_number('0611412')->is_valid_number, '北海道恵庭市白樺町');
ok($zip->set_number('0611413')->is_valid_number, '北海道恵庭市本町');
ok($zip->set_number('0611414')->is_valid_number, '北海道恵庭市漁町');
ok($zip->set_number('0611415')->is_valid_number, '北海道恵庭市泉町');
ok($zip->set_number('0611416')->is_valid_number, '北海道恵庭市桜町');
ok($zip->set_number('0611417')->is_valid_number, '北海道恵庭市駒場町');
ok($zip->set_number('0611421')->is_valid_number, '北海道恵庭市牧場');
ok($zip->set_number('0611422')->is_valid_number, '北海道恵庭市盤尻');
ok($zip->set_number('0611423')->is_valid_number, '北海道恵庭市柏木町');
ok($zip->set_number('0611424')->is_valid_number, '北海道恵庭市大町');
ok($zip->set_number('0611425')->is_valid_number, '北海道恵庭市文京町');
ok($zip->set_number('0611426')->is_valid_number, '北海道恵庭市幸町');
ok($zip->set_number('0611427')->is_valid_number, '北海道恵庭市美咲野');
ok($zip->set_number('0611431')->is_valid_number, '北海道恵庭市有明町');
ok($zip->set_number('0611432')->is_valid_number, '北海道恵庭市恵央町');
ok($zip->set_number('0611433')->is_valid_number, '北海道恵庭市北柏木町');
ok($zip->set_number('0611434')->is_valid_number, '北海道恵庭市柏陽町');
ok($zip->set_number('0611435')->is_valid_number, '北海道恵庭市中島町');
ok($zip->set_number('0611441')->is_valid_number, '北海道恵庭市住吉町');
ok($zip->set_number('0611442')->is_valid_number, '北海道恵庭市緑町');
ok($zip->set_number('0611443')->is_valid_number, '北海道恵庭市栄恵町');
ok($zip->set_number('0611444')->is_valid_number, '北海道恵庭市京町');
ok($zip->set_number('0611445')->is_valid_number, '北海道恵庭市新町');
ok($zip->set_number('0611446')->is_valid_number, '北海道恵庭市末広町');
ok($zip->set_number('0611447')->is_valid_number, '北海道恵庭市福住町');
ok($zip->set_number('0611448')->is_valid_number, '北海道恵庭市相生町');
ok($zip->set_number('0611449')->is_valid_number, '北海道恵庭市黄金中央');
ok($zip->set_number('0612261')->is_valid_number, '北海道札幌市南区簾舞一条');
ok($zip->set_number('0612262')->is_valid_number, '北海道札幌市南区簾舞二条');
ok($zip->set_number('0612263')->is_valid_number, '北海道札幌市南区簾舞三条');
ok($zip->set_number('0612264')->is_valid_number, '北海道札幌市南区簾舞四条');
ok($zip->set_number('0612265')->is_valid_number, '北海道札幌市南区簾舞五条');
ok($zip->set_number('0612266')->is_valid_number, '北海道札幌市南区簾舞六条');
ok($zip->set_number('0612271')->is_valid_number, '北海道札幌市南区藤野(その他)');
ok($zip->set_number('0612272')->is_valid_number, '北海道札幌市南区簾舞(その他)');
ok($zip->set_number('0612273')->is_valid_number, '北海道札幌市南区豊滝');
ok($zip->set_number('0612274')->is_valid_number, '北海道札幌市南区小金湯');
ok($zip->set_number('0612275')->is_valid_number, '北海道札幌市南区砥山');
ok($zip->set_number('0612276')->is_valid_number, '北海道札幌市南区白川');
ok($zip->set_number('0612281')->is_valid_number, '北海道札幌市南区藤野一条');
ok($zip->set_number('0612282')->is_valid_number, '北海道札幌市南区藤野二条');
ok($zip->set_number('0612283')->is_valid_number, '北海道札幌市南区藤野三条');
ok($zip->set_number('0612284')->is_valid_number, '北海道札幌市南区藤野四条');
ok($zip->set_number('0612285')->is_valid_number, '北海道札幌市南区藤野五条');
ok($zip->set_number('0612286')->is_valid_number, '北海道札幌市南区藤野六条');
ok($zip->set_number('0612301')->is_valid_number, '北海道札幌市南区定山渓');
ok($zip->set_number('0612302')->is_valid_number, '北海道札幌市南区定山渓温泉東');
ok($zip->set_number('0612303')->is_valid_number, '北海道札幌市南区定山渓温泉西');
ok($zip->set_number('0613101')->is_valid_number, '北海道石狩市浜益区浜益');
ok($zip->set_number('0613102')->is_valid_number, '北海道石狩市浜益区群別');
ok($zip->set_number('0613103')->is_valid_number, '北海道石狩市浜益区幌');
ok($zip->set_number('0613104')->is_valid_number, '北海道石狩市浜益区床丹');
ok($zip->set_number('0613105')->is_valid_number, '北海道石狩市浜益区千代志別');
ok($zip->set_number('0613106')->is_valid_number, '北海道石狩市浜益区川下');
ok($zip->set_number('0613107')->is_valid_number, '北海道石狩市浜益区柏木');
ok($zip->set_number('0613108')->is_valid_number, '北海道石狩市浜益区実田');
ok($zip->set_number('0613109')->is_valid_number, '北海道石狩市浜益区御料地');
ok($zip->set_number('0613111')->is_valid_number, '北海道石狩市浜益区毘砂別');
ok($zip->set_number('0613112')->is_valid_number, '北海道石狩市浜益区送毛');
ok($zip->set_number('0613113')->is_valid_number, '北海道石狩市浜益区濃昼');
ok($zip->set_number('0613151')->is_valid_number, '北海道石狩市厚田区濃昼');
ok($zip->set_number('0613200')->is_valid_number, '北海道石狩市以下に掲載がない場合');
ok($zip->set_number('0613201')->is_valid_number, '北海道石狩市花川南一条');
ok($zip->set_number('0613202')->is_valid_number, '北海道石狩市花川南二条');
ok($zip->set_number('0613203')->is_valid_number, '北海道石狩市花川南三条');
ok($zip->set_number('0613204')->is_valid_number, '北海道石狩市花川南四条');
ok($zip->set_number('0613205')->is_valid_number, '北海道石狩市花川南五条');
ok($zip->set_number('0613206')->is_valid_number, '北海道石狩市花川南六条');
ok($zip->set_number('0613207')->is_valid_number, '北海道石狩市花川南七条');
ok($zip->set_number('0613208')->is_valid_number, '北海道石狩市花川南八条');
ok($zip->set_number('0613209')->is_valid_number, '北海道石狩市花川南九条');
ok($zip->set_number('0613210')->is_valid_number, '北海道石狩市花川南十条');
ok($zip->set_number('0613211')->is_valid_number, '北海道石狩市花川北一条');
ok($zip->set_number('0613212')->is_valid_number, '北海道石狩市花川北二条');
ok($zip->set_number('0613213')->is_valid_number, '北海道石狩市花川北三条');
ok($zip->set_number('0613214')->is_valid_number, '北海道石狩市花川北四条');
ok($zip->set_number('0613215')->is_valid_number, '北海道石狩市花川北五条');
ok($zip->set_number('0613216')->is_valid_number, '北海道石狩市花川北六条');
ok($zip->set_number('0613217')->is_valid_number, '北海道石狩市花川北七条');
ok($zip->set_number('0613218')->is_valid_number, '北海道石狩市花畔(その他)');
ok($zip->set_number('0613219')->is_valid_number, '北海道石狩市花川');
ok($zip->set_number('0613220')->is_valid_number, '北海道石狩市志美');
ok($zip->set_number('0613221')->is_valid_number, '北海道石狩市緑苑台東一条');
ok($zip->set_number('0613222')->is_valid_number, '北海道石狩市緑苑台東二条');
ok($zip->set_number('0613223')->is_valid_number, '北海道石狩市緑苑台東三条');
ok($zip->set_number('0613230')->is_valid_number, '北海道石狩市緑苑台中央');
ok($zip->set_number('0613231')->is_valid_number, '北海道石狩市緑苑台西一条');
ok($zip->set_number('0613232')->is_valid_number, '北海道石狩市緑苑台西二条');
ok($zip->set_number('0613241')->is_valid_number, '北海道石狩市新港西');
ok($zip->set_number('0613242')->is_valid_number, '北海道石狩市新港中央');
ok($zip->set_number('0613243')->is_valid_number, '北海道石狩市新港東');
ok($zip->set_number('0613244')->is_valid_number, '北海道石狩市新港南');
ok($zip->set_number('0613245')->is_valid_number, '北海道石狩市生振');
ok($zip->set_number('0613248')->is_valid_number, '北海道石狩市花川東');
ok($zip->set_number('0613251')->is_valid_number, '北海道石狩市樽川(その他)');
ok($zip->set_number('0613253')->is_valid_number, '北海道石狩市樽川三条');
ok($zip->set_number('0613254')->is_valid_number, '北海道石狩市樽川四条');
ok($zip->set_number('0613255')->is_valid_number, '北海道石狩市樽川五条');
ok($zip->set_number('0613256')->is_valid_number, '北海道石狩市樽川六条');
ok($zip->set_number('0613257')->is_valid_number, '北海道石狩市樽川七条');
ok($zip->set_number('0613258')->is_valid_number, '北海道石狩市樽川八条');
ok($zip->set_number('0613259')->is_valid_number, '北海道石狩市樽川九条');
ok($zip->set_number('0613261')->is_valid_number, '北海道石狩市花川東一条');
ok($zip->set_number('0613262')->is_valid_number, '北海道石狩市花川東二条');
ok($zip->set_number('0613271')->is_valid_number, '北海道小樽市銭函(4~5丁目)');
ok($zip->set_number('0613281')->is_valid_number, '北海道石狩市花畔一条');
ok($zip->set_number('0613282')->is_valid_number, '北海道石狩市花畔二条');
ok($zip->set_number('0613283')->is_valid_number, '北海道石狩市花畔三条');
ok($zip->set_number('0613284')->is_valid_number, '北海道石狩市花畔四条');
ok($zip->set_number('0613331')->is_valid_number, '北海道石狩市厚田区聚富(中央、シラツカリ)');
ok($zip->set_number('0613332')->is_valid_number, '北海道石狩市厚田区虹が原');
ok($zip->set_number('0613361')->is_valid_number, '北海道石狩市八幡(その他)');
ok($zip->set_number('0613362')->is_valid_number, '北海道石狩市北生振');
ok($zip->set_number('0613363')->is_valid_number, '北海道石狩市若生町');
ok($zip->set_number('0613365')->is_valid_number, '北海道石狩市親船東一条');
ok($zip->set_number('0613366')->is_valid_number, '北海道石狩市親船東二条');
ok($zip->set_number('0613367')->is_valid_number, '北海道石狩市親船東三条');
ok($zip->set_number('0613368')->is_valid_number, '北海道石狩市美登位');
ok($zip->set_number('0613371')->is_valid_number, '北海道石狩市浜町');
ok($zip->set_number('0613372')->is_valid_number, '北海道石狩市弁天町');
ok($zip->set_number('0613373')->is_valid_number, '北海道石狩市新町');
ok($zip->set_number('0613374')->is_valid_number, '北海道石狩市仲町');
ok($zip->set_number('0613375')->is_valid_number, '北海道石狩市本町');
ok($zip->set_number('0613376')->is_valid_number, '北海道石狩市横町');
ok($zip->set_number('0613377')->is_valid_number, '北海道石狩市親船町');
ok($zip->set_number('0613378')->is_valid_number, '北海道石狩市船場町');
ok($zip->set_number('0613441')->is_valid_number, '北海道石狩市厚田区聚富(その他)');
ok($zip->set_number('0613480')->is_valid_number, '北海道石狩市八幡町(五の沢)');
ok($zip->set_number('0613481')->is_valid_number, '北海道石狩市八幡町(高岡)');
ok($zip->set_number('0613482')->is_valid_number, '北海道石狩市八幡町(その他)');
ok($zip->set_number('0613483')->is_valid_number, '北海道石狩市緑ケ原');
ok($zip->set_number('0613484')->is_valid_number, '北海道石狩市八幡(5丁目1番地)');
ok($zip->set_number('0613521')->is_valid_number, '北海道石狩市厚田区古潭');
ok($zip->set_number('0613522')->is_valid_number, '北海道石狩市厚田区嶺泊');
ok($zip->set_number('0613523')->is_valid_number, '北海道石狩市厚田区望来');
ok($zip->set_number('0613601')->is_valid_number, '北海道石狩市厚田区厚田');
ok($zip->set_number('0613602')->is_valid_number, '北海道石狩市厚田区押琴');
ok($zip->set_number('0613603')->is_valid_number, '北海道石狩市厚田区小谷');
ok($zip->set_number('0613605')->is_valid_number, '北海道石狩市厚田区別狩');
ok($zip->set_number('0613606')->is_valid_number, '北海道石狩市厚田区安瀬');
ok($zip->set_number('0613771')->is_valid_number, '北海道石狩郡当別町高岡');
ok($zip->set_number('0613772')->is_valid_number, '北海道石狩郡当別町獅子内');
ok($zip->set_number('0613773')->is_valid_number, '北海道石狩郡当別町当別太');
ok($zip->set_number('0613774')->is_valid_number, '北海道石狩郡当別町川下(782-13、5363-7~8、5382-3、5405');
ok($zip->set_number('0613774')->is_valid_number, '北海道石狩郡当別町-4、5407-5、5445~5446-4番地)');
ok($zip->set_number('0613775')->is_valid_number, '北海道石狩郡当別町ビトエ(その他)');
ok($zip->set_number('0613776')->is_valid_number, '北海道石狩郡当別町太美町');
ok($zip->set_number('0613777')->is_valid_number, '北海道石狩郡当別町スウェーデンヒルズ');
ok($zip->set_number('0613778')->is_valid_number, '北海道石狩郡当別町太美南');
ok($zip->set_number('0613779')->is_valid_number, '北海道石狩郡当別町太美スターライト');
ok($zip->set_number('0620000')->is_valid_number, '北海道札幌市豊平区以下に掲載がない場合');
ok($zip->set_number('0620001')->is_valid_number, '北海道札幌市豊平区美園一条');
ok($zip->set_number('0620002')->is_valid_number, '北海道札幌市豊平区美園二条');
ok($zip->set_number('0620003')->is_valid_number, '北海道札幌市豊平区美園三条');
ok($zip->set_number('0620004')->is_valid_number, '北海道札幌市豊平区美園四条');
ok($zip->set_number('0620005')->is_valid_number, '北海道札幌市豊平区美園五条');
ok($zip->set_number('0620006')->is_valid_number, '北海道札幌市豊平区美園六条');
ok($zip->set_number('0620007')->is_valid_number, '北海道札幌市豊平区美園七条');
ok($zip->set_number('0620008')->is_valid_number, '北海道札幌市豊平区美園八条');
ok($zip->set_number('0620009')->is_valid_number, '北海道札幌市豊平区美園九条');
ok($zip->set_number('0620010')->is_valid_number, '北海道札幌市豊平区美園十条');
ok($zip->set_number('0620011')->is_valid_number, '北海道札幌市豊平区美園十一条');
ok($zip->set_number('0620012')->is_valid_number, '北海道札幌市豊平区美園十二条');
ok($zip->set_number('0620020')->is_valid_number, '北海道札幌市豊平区月寒中央通');
ok($zip->set_number('0620021')->is_valid_number, '北海道札幌市豊平区月寒西一条');
ok($zip->set_number('0620022')->is_valid_number, '北海道札幌市豊平区月寒西二条');
ok($zip->set_number('0620023')->is_valid_number, '北海道札幌市豊平区月寒西三条');
ok($zip->set_number('0620024')->is_valid_number, '北海道札幌市豊平区月寒西四条');
ok($zip->set_number('0620025')->is_valid_number, '北海道札幌市豊平区月寒西五条');
ok($zip->set_number('0620031')->is_valid_number, '北海道札幌市豊平区西岡一条');
ok($zip->set_number('0620032')->is_valid_number, '北海道札幌市豊平区西岡二条');
ok($zip->set_number('0620033')->is_valid_number, '北海道札幌市豊平区西岡三条');
ok($zip->set_number('0620034')->is_valid_number, '北海道札幌市豊平区西岡四条');
ok($zip->set_number('0620035')->is_valid_number, '北海道札幌市豊平区西岡五条');
ok($zip->set_number('0620039')->is_valid_number, '北海道札幌市豊平区西岡');
ok($zip->set_number('0620041')->is_valid_number, '北海道札幌市豊平区福住一条');
ok($zip->set_number('0620042')->is_valid_number, '北海道札幌市豊平区福住二条');
ok($zip->set_number('0620043')->is_valid_number, '北海道札幌市豊平区福住三条');
ok($zip->set_number('0620045')->is_valid_number, '北海道札幌市豊平区羊ケ丘');
ok($zip->set_number('0620051')->is_valid_number, '北海道札幌市豊平区月寒東一条');
ok($zip->set_number('0620052')->is_valid_number, '北海道札幌市豊平区月寒東二条');
ok($zip->set_number('0620053')->is_valid_number, '北海道札幌市豊平区月寒東三条');
ok($zip->set_number('0620054')->is_valid_number, '北海道札幌市豊平区月寒東四条');
ok($zip->set_number('0620055')->is_valid_number, '北海道札幌市豊平区月寒東五条');
ok($zip->set_number('0620901')->is_valid_number, '北海道札幌市豊平区豊平一条');
ok($zip->set_number('0620902')->is_valid_number, '北海道札幌市豊平区豊平二条');
ok($zip->set_number('0620903')->is_valid_number, '北海道札幌市豊平区豊平三条');
ok($zip->set_number('0620904')->is_valid_number, '北海道札幌市豊平区豊平四条');
ok($zip->set_number('0620905')->is_valid_number, '北海道札幌市豊平区豊平五条');
ok($zip->set_number('0620906')->is_valid_number, '北海道札幌市豊平区豊平六条');
ok($zip->set_number('0620907')->is_valid_number, '北海道札幌市豊平区豊平七条');
ok($zip->set_number('0620908')->is_valid_number, '北海道札幌市豊平区豊平八条');
ok($zip->set_number('0620909')->is_valid_number, '北海道札幌市豊平区豊平九条');
ok($zip->set_number('0620911')->is_valid_number, '北海道札幌市豊平区旭町');
ok($zip->set_number('0620912')->is_valid_number, '北海道札幌市豊平区水車町');
ok($zip->set_number('0620921')->is_valid_number, '北海道札幌市豊平区中の島一条');
ok($zip->set_number('0620922')->is_valid_number, '北海道札幌市豊平区中の島二条');
ok($zip->set_number('0620931')->is_valid_number, '北海道札幌市豊平区平岸一条');
ok($zip->set_number('0620932')->is_valid_number, '北海道札幌市豊平区平岸二条');
ok($zip->set_number('0620933')->is_valid_number, '北海道札幌市豊平区平岸三条');
ok($zip->set_number('0620934')->is_valid_number, '北海道札幌市豊平区平岸四条');
ok($zip->set_number('0620935')->is_valid_number, '北海道札幌市豊平区平岸五条');
ok($zip->set_number('0620936')->is_valid_number, '北海道札幌市豊平区平岸六条');
ok($zip->set_number('0620937')->is_valid_number, '北海道札幌市豊平区平岸七条');
ok($zip->set_number('0620938')->is_valid_number, '北海道札幌市豊平区平岸八条');
ok($zip->set_number('0630000')->is_valid_number, '北海道札幌市西区以下に掲載がない場合');
ok($zip->set_number('0630001')->is_valid_number, '北海道札幌市西区山の手一条');
ok($zip->set_number('0630002')->is_valid_number, '北海道札幌市西区山の手二条');
ok($zip->set_number('0630003')->is_valid_number, '北海道札幌市西区山の手三条');
ok($zip->set_number('0630004')->is_valid_number, '北海道札幌市西区山の手四条');
ok($zip->set_number('0630005')->is_valid_number, '北海道札幌市西区山の手五条');
ok($zip->set_number('0630006')->is_valid_number, '北海道札幌市西区山の手六条');
ok($zip->set_number('0630007')->is_valid_number, '北海道札幌市西区山の手七条');
ok($zip->set_number('0630009')->is_valid_number, '北海道札幌市西区山の手');
ok($zip->set_number('0630011')->is_valid_number, '北海道札幌市西区小別沢');
ok($zip->set_number('0630012')->is_valid_number, '北海道札幌市西区福井');
ok($zip->set_number('0630021')->is_valid_number, '北海道札幌市西区平和一条');
ok($zip->set_number('0630022')->is_valid_number, '北海道札幌市西区平和二条');
ok($zip->set_number('0630023')->is_valid_number, '北海道札幌市西区平和三条');
ok($zip->set_number('0630029')->is_valid_number, '北海道札幌市西区平和');
ok($zip->set_number('0630031')->is_valid_number, '北海道札幌市西区西野一条');
ok($zip->set_number('0630032')->is_valid_number, '北海道札幌市西区西野二条');
ok($zip->set_number('0630033')->is_valid_number, '北海道札幌市西区西野三条');
ok($zip->set_number('0630034')->is_valid_number, '北海道札幌市西区西野四条');
ok($zip->set_number('0630035')->is_valid_number, '北海道札幌市西区西野五条');
ok($zip->set_number('0630036')->is_valid_number, '北海道札幌市西区西野六条');
ok($zip->set_number('0630037')->is_valid_number, '北海道札幌市西区西野七条');
ok($zip->set_number('0630038')->is_valid_number, '北海道札幌市西区西野八条');
ok($zip->set_number('0630039')->is_valid_number, '北海道札幌市西区西野九条');
ok($zip->set_number('0630040')->is_valid_number, '北海道札幌市西区西野十条');
ok($zip->set_number('0630041')->is_valid_number, '北海道札幌市西区西野十一条');
ok($zip->set_number('0630042')->is_valid_number, '北海道札幌市西区西野十二条');
ok($zip->set_number('0630043')->is_valid_number, '北海道札幌市西区西野十三条');
ok($zip->set_number('0630044')->is_valid_number, '北海道札幌市西区西野十四条');
ok($zip->set_number('0630049')->is_valid_number, '北海道札幌市西区西野');
ok($zip->set_number('0630051')->is_valid_number, '北海道札幌市西区宮の沢一条');
ok($zip->set_number('0630052')->is_valid_number, '北海道札幌市西区宮の沢二条');
ok($zip->set_number('0630053')->is_valid_number, '北海道札幌市西区宮の沢三条');
ok($zip->set_number('0630054')->is_valid_number, '北海道札幌市西区宮の沢四条');
ok($zip->set_number('0630059')->is_valid_number, '北海道札幌市西区宮の沢');
ok($zip->set_number('0630061')->is_valid_number, '北海道札幌市西区西町北');
ok($zip->set_number('0630062')->is_valid_number, '北海道札幌市西区西町南');
ok($zip->set_number('0630801')->is_valid_number, '北海道札幌市西区二十四軒一条');
ok($zip->set_number('0630802')->is_valid_number, '北海道札幌市西区二十四軒二条');
ok($zip->set_number('0630803')->is_valid_number, '北海道札幌市西区二十四軒三条');
ok($zip->set_number('0630804')->is_valid_number, '北海道札幌市西区二十四軒四条');
ok($zip->set_number('0630811')->is_valid_number, '北海道札幌市西区琴似一条');
ok($zip->set_number('0630812')->is_valid_number, '北海道札幌市西区琴似二条');
ok($zip->set_number('0630813')->is_valid_number, '北海道札幌市西区琴似三条');
ok($zip->set_number('0630814')->is_valid_number, '北海道札幌市西区琴似四条');
ok($zip->set_number('0630821')->is_valid_number, '北海道札幌市西区発寒一条');
ok($zip->set_number('0630822')->is_valid_number, '北海道札幌市西区発寒二条');
ok($zip->set_number('0630823')->is_valid_number, '北海道札幌市西区発寒三条');
ok($zip->set_number('0630824')->is_valid_number, '北海道札幌市西区発寒四条');
ok($zip->set_number('0630825')->is_valid_number, '北海道札幌市西区発寒五条');
ok($zip->set_number('0630826')->is_valid_number, '北海道札幌市西区発寒六条');
ok($zip->set_number('0630827')->is_valid_number, '北海道札幌市西区発寒七条');
ok($zip->set_number('0630828')->is_valid_number, '北海道札幌市西区発寒八条');
ok($zip->set_number('0630829')->is_valid_number, '北海道札幌市西区発寒九条');
ok($zip->set_number('0630830')->is_valid_number, '北海道札幌市西区発寒十条');
ok($zip->set_number('0630831')->is_valid_number, '北海道札幌市西区発寒十一条');
ok($zip->set_number('0630832')->is_valid_number, '北海道札幌市西区発寒十二条');
ok($zip->set_number('0630833')->is_valid_number, '北海道札幌市西区発寒十三条');
ok($zip->set_number('0630834')->is_valid_number, '北海道札幌市西区発寒十四条');
ok($zip->set_number('0630835')->is_valid_number, '北海道札幌市西区発寒十五条');
ok($zip->set_number('0630836')->is_valid_number, '北海道札幌市西区発寒十六条');
ok($zip->set_number('0630837')->is_valid_number, '北海道札幌市西区発寒十七条');
ok($zip->set_number('0630841')->is_valid_number, '北海道札幌市西区八軒一条西');
ok($zip->set_number('0630842')->is_valid_number, '北海道札幌市西区八軒二条西');
ok($zip->set_number('0630843')->is_valid_number, '北海道札幌市西区八軒三条西');
ok($zip->set_number('0630844')->is_valid_number, '北海道札幌市西区八軒四条西');
ok($zip->set_number('0630845')->is_valid_number, '北海道札幌市西区八軒五条西');
ok($zip->set_number('0630846')->is_valid_number, '北海道札幌市西区八軒六条西');
ok($zip->set_number('0630847')->is_valid_number, '北海道札幌市西区八軒七条西');
ok($zip->set_number('0630848')->is_valid_number, '北海道札幌市西区八軒八条西');
ok($zip->set_number('0630849')->is_valid_number, '北海道札幌市西区八軒九条西');
ok($zip->set_number('0630850')->is_valid_number, '北海道札幌市西区八軒十条西');
ok($zip->set_number('0630861')->is_valid_number, '北海道札幌市西区八軒一条東');
ok($zip->set_number('0630862')->is_valid_number, '北海道札幌市西区八軒二条東');
ok($zip->set_number('0630863')->is_valid_number, '北海道札幌市西区八軒三条東');
ok($zip->set_number('0630864')->is_valid_number, '北海道札幌市西区八軒四条東');
ok($zip->set_number('0630865')->is_valid_number, '北海道札幌市西区八軒五条東');
ok($zip->set_number('0630866')->is_valid_number, '北海道札幌市西区八軒六条東');
ok($zip->set_number('0630867')->is_valid_number, '北海道札幌市西区八軒七条東');
ok($zip->set_number('0630868')->is_valid_number, '北海道札幌市西区八軒八条東');
ok($zip->set_number('0630869')->is_valid_number, '北海道札幌市西区八軒九条東');
ok($zip->set_number('0630870')->is_valid_number, '北海道札幌市西区八軒十条東');
ok($zip->set_number('0640801')->is_valid_number, '北海道札幌市中央区南一条西(20~28丁目)');
ok($zip->set_number('0640802')->is_valid_number, '北海道札幌市中央区南二条西(20~28丁目)');
ok($zip->set_number('0640803')->is_valid_number, '北海道札幌市中央区南三条西(20~28丁目)');
ok($zip->set_number('0640804')->is_valid_number, '北海道札幌市中央区南四条西');
ok($zip->set_number('0640805')->is_valid_number, '北海道札幌市中央区南五条西');
ok($zip->set_number('0640806')->is_valid_number, '北海道札幌市中央区南六条西');
ok($zip->set_number('0640807')->is_valid_number, '北海道札幌市中央区南七条西');
ok($zip->set_number('0640808')->is_valid_number, '北海道札幌市中央区南八条西');
ok($zip->set_number('0640809')->is_valid_number, '北海道札幌市中央区南九条西');
ok($zip->set_number('0640810')->is_valid_number, '北海道札幌市中央区南十条西');
ok($zip->set_number('0640811')->is_valid_number, '北海道札幌市中央区南十一条西');
ok($zip->set_number('0640820')->is_valid_number, '北海道札幌市中央区大通西(20~28丁目)');
ok($zip->set_number('0640821')->is_valid_number, '北海道札幌市中央区北一条西(20~28丁目)');
ok($zip->set_number('0640822')->is_valid_number, '北海道札幌市中央区北二条西(20~28丁目)');
ok($zip->set_number('0640823')->is_valid_number, '北海道札幌市中央区北三条西(20~30丁目)');
ok($zip->set_number('0640824')->is_valid_number, '北海道札幌市中央区北四条西(20~30丁目)');
ok($zip->set_number('0640825')->is_valid_number, '北海道札幌市中央区北五条西(25~29丁目)');
ok($zip->set_number('0640826')->is_valid_number, '北海道札幌市中央区北六条西(26~28丁目)');
ok($zip->set_number('0640912')->is_valid_number, '北海道札幌市中央区南十二条西');
ok($zip->set_number('0640913')->is_valid_number, '北海道札幌市中央区南十三条西');
ok($zip->set_number('0640914')->is_valid_number, '北海道札幌市中央区南十四条西');
ok($zip->set_number('0640915')->is_valid_number, '北海道札幌市中央区南十五条西');
ok($zip->set_number('0640916')->is_valid_number, '北海道札幌市中央区南十六条西');
ok($zip->set_number('0640917')->is_valid_number, '北海道札幌市中央区南十七条西');
ok($zip->set_number('0640918')->is_valid_number, '北海道札幌市中央区南十八条西');
ok($zip->set_number('0640919')->is_valid_number, '北海道札幌市中央区南十九条西');
ok($zip->set_number('0640920')->is_valid_number, '北海道札幌市中央区南二十条西');
ok($zip->set_number('0640921')->is_valid_number, '北海道札幌市中央区南二十一条西');
ok($zip->set_number('0640922')->is_valid_number, '北海道札幌市中央区南二十二条西');
ok($zip->set_number('0640923')->is_valid_number, '北海道札幌市中央区南二十三条西');
ok($zip->set_number('0640924')->is_valid_number, '北海道札幌市中央区南二十四条西');
ok($zip->set_number('0640925')->is_valid_number, '北海道札幌市中央区南二十五条西');
ok($zip->set_number('0640926')->is_valid_number, '北海道札幌市中央区南二十六条西');
ok($zip->set_number('0640927')->is_valid_number, '北海道札幌市中央区南二十七条西');
ok($zip->set_number('0640928')->is_valid_number, '北海道札幌市中央区南二十八条西');
ok($zip->set_number('0640929')->is_valid_number, '北海道札幌市中央区南二十九条西');
ok($zip->set_number('0640930')->is_valid_number, '北海道札幌市中央区南三十条西(9~11丁目)');
ok($zip->set_number('0640931')->is_valid_number, '北海道札幌市中央区中島公園');
ok($zip->set_number('0640941')->is_valid_number, '北海道札幌市中央区旭ケ丘');
ok($zip->set_number('0640942')->is_valid_number, '北海道札幌市中央区伏見');
ok($zip->set_number('0640943')->is_valid_number, '北海道札幌市中央区界川');
ok($zip->set_number('0640944')->is_valid_number, '北海道札幌市中央区円山西町');
ok($zip->set_number('0640945')->is_valid_number, '北海道札幌市中央区盤渓');
ok($zip->set_number('0640946')->is_valid_number, '北海道札幌市中央区双子山');
ok($zip->set_number('0640951')->is_valid_number, '北海道札幌市中央区宮の森一条');
ok($zip->set_number('0640952')->is_valid_number, '北海道札幌市中央区宮の森二条');
ok($zip->set_number('0640953')->is_valid_number, '北海道札幌市中央区宮の森三条');
ok($zip->set_number('0640954')->is_valid_number, '北海道札幌市中央区宮の森四条');
ok($zip->set_number('0640958')->is_valid_number, '北海道札幌市中央区宮の森');
ok($zip->set_number('0640959')->is_valid_number, '北海道札幌市中央区宮ケ丘');
ok($zip->set_number('0650000')->is_valid_number, '北海道札幌市東区以下に掲載がない場合');
ok($zip->set_number('0650004')->is_valid_number, '北海道札幌市東区北四条東(9~16丁目)');
ok($zip->set_number('0650005')->is_valid_number, '北海道札幌市東区北五条東(8~17丁目)');
ok($zip->set_number('0650006')->is_valid_number, '北海道札幌市東区北六条東(8~20丁目)');
ok($zip->set_number('0650007')->is_valid_number, '北海道札幌市東区北七条東(8~20丁目)');
ok($zip->set_number('0650008')->is_valid_number, '北海道札幌市東区北八条東(8~19丁目)');
ok($zip->set_number('0650009')->is_valid_number, '北海道札幌市東区北九条東(8~16丁目)');
ok($zip->set_number('0650010')->is_valid_number, '北海道札幌市東区北十条東');
ok($zip->set_number('0650011')->is_valid_number, '北海道札幌市東区北十一条東');
ok($zip->set_number('0650012')->is_valid_number, '北海道札幌市東区北十二条東');
ok($zip->set_number('0650013')->is_valid_number, '北海道札幌市東区北十三条東');
ok($zip->set_number('0650014')->is_valid_number, '北海道札幌市東区北十四条東');
ok($zip->set_number('0650015')->is_valid_number, '北海道札幌市東区北十五条東');
ok($zip->set_number('0650016')->is_valid_number, '北海道札幌市東区北十六条東');
ok($zip->set_number('0650017')->is_valid_number, '北海道札幌市東区北十七条東');
ok($zip->set_number('0650018')->is_valid_number, '北海道札幌市東区北十八条東');
ok($zip->set_number('0650019')->is_valid_number, '北海道札幌市東区北十九条東');
ok($zip->set_number('0650020')->is_valid_number, '北海道札幌市東区北二十条東');
ok($zip->set_number('0650021')->is_valid_number, '北海道札幌市東区北二十一条東');
ok($zip->set_number('0650022')->is_valid_number, '北海道札幌市東区北二十二条東');
ok($zip->set_number('0650023')->is_valid_number, '北海道札幌市東区北二十三条東');
ok($zip->set_number('0650024')->is_valid_number, '北海道札幌市東区北二十四条東');
ok($zip->set_number('0650025')->is_valid_number, '北海道札幌市東区北二十五条東');
ok($zip->set_number('0650026')->is_valid_number, '北海道札幌市東区北二十六条東');
ok($zip->set_number('0650027')->is_valid_number, '北海道札幌市東区北二十七条東');
ok($zip->set_number('0650028')->is_valid_number, '北海道札幌市東区北二十八条東');
ok($zip->set_number('0650030')->is_valid_number, '北海道札幌市東区北三十条東');
ok($zip->set_number('0650031')->is_valid_number, '北海道札幌市東区北三十一条東');
ok($zip->set_number('0650032')->is_valid_number, '北海道札幌市東区北三十二条東');
ok($zip->set_number('0650033')->is_valid_number, '北海道札幌市東区北三十三条東');
ok($zip->set_number('0650041')->is_valid_number, '北海道札幌市東区本町一条');
ok($zip->set_number('0650042')->is_valid_number, '北海道札幌市東区本町二条');
ok($zip->set_number('0650043')->is_valid_number, '北海道札幌市東区苗穂町');
ok($zip->set_number('0660000')->is_valid_number, '北海道千歳市以下に掲載がない場合');
ok($zip->set_number('0660001')->is_valid_number, '北海道千歳市長都');
ok($zip->set_number('0660002')->is_valid_number, '北海道千歳市釜加');
ok($zip->set_number('0660003')->is_valid_number, '北海道千歳市都');
ok($zip->set_number('0660004')->is_valid_number, '北海道千歳市泉郷');
ok($zip->set_number('0660005')->is_valid_number, '北海道千歳市協和(88-2、271-10、343-2、404-1、427-');
ok($zip->set_number('0660005')->is_valid_number, '北海道千歳市3、431-12、443-6、608-2、641-8、814、842-');
ok($zip->set_number('0660005')->is_valid_number, '北海道千歳市5、1137-3、1392、1657、1752番地)');
ok($zip->set_number('0660006')->is_valid_number, '北海道千歳市祝梅');
ok($zip->set_number('0660007')->is_valid_number, '北海道千歳市中央');
ok($zip->set_number('0660008')->is_valid_number, '北海道千歳市根志越');
ok($zip->set_number('0660009')->is_valid_number, '北海道千歳市柏台南');
ok($zip->set_number('0660011')->is_valid_number, '北海道千歳市駒里');
ok($zip->set_number('0660012')->is_valid_number, '北海道千歳市美々');
ok($zip->set_number('0660013')->is_valid_number, '北海道千歳市柏台');
ok($zip->set_number('0660014')->is_valid_number, '北海道千歳市青葉丘');
ok($zip->set_number('0660015')->is_valid_number, '北海道千歳市青葉');
ok($zip->set_number('0660016')->is_valid_number, '北海道千歳市日の出丘');
ok($zip->set_number('0660017')->is_valid_number, '北海道千歳市日の出');
ok($zip->set_number('0660018')->is_valid_number, '北海道千歳市旭ケ丘');
ok($zip->set_number('0660019')->is_valid_number, '北海道千歳市流通');
ok($zip->set_number('0660021')->is_valid_number, '北海道千歳市東郊');
ok($zip->set_number('0660022')->is_valid_number, '北海道千歳市豊里');
ok($zip->set_number('0660023')->is_valid_number, '北海道千歳市寿');
ok($zip->set_number('0660024')->is_valid_number, '北海道千歳市弥生');
ok($zip->set_number('0660025')->is_valid_number, '北海道千歳市梅ケ丘');
ok($zip->set_number('0660026')->is_valid_number, '北海道千歳市住吉');
ok($zip->set_number('0660027')->is_valid_number, '北海道千歳市末広');
ok($zip->set_number('0660028')->is_valid_number, '北海道千歳市花園');
ok($zip->set_number('0660029')->is_valid_number, '北海道千歳市稲穂');
ok($zip->set_number('0660031')->is_valid_number, '北海道千歳市長都駅前');
ok($zip->set_number('0660032')->is_valid_number, '北海道千歳市北陽');
ok($zip->set_number('0660033')->is_valid_number, '北海道千歳市北光');
ok($zip->set_number('0660034')->is_valid_number, '北海道千歳市富丘');
ok($zip->set_number('0660035')->is_valid_number, '北海道千歳市高台');
ok($zip->set_number('0660036')->is_valid_number, '北海道千歳市北栄');
ok($zip->set_number('0660037')->is_valid_number, '北海道千歳市新富');
ok($zip->set_number('0660038')->is_valid_number, '北海道千歳市信濃');
ok($zip->set_number('0660039')->is_valid_number, '北海道千歳市富士');
ok($zip->set_number('0660041')->is_valid_number, '北海道千歳市清水町');
ok($zip->set_number('0660042')->is_valid_number, '北海道千歳市東雲町');
ok($zip->set_number('0660043')->is_valid_number, '北海道千歳市朝日町');
ok($zip->set_number('0660044')->is_valid_number, '北海道千歳市平和');
ok($zip->set_number('0660045')->is_valid_number, '北海道千歳市真々地');
ok($zip->set_number('0660046')->is_valid_number, '北海道千歳市真町');
ok($zip->set_number('0660047')->is_valid_number, '北海道千歳市本町');
ok($zip->set_number('0660051')->is_valid_number, '北海道千歳市泉沢');
ok($zip->set_number('0660052')->is_valid_number, '北海道千歳市文京');
ok($zip->set_number('0660053')->is_valid_number, '北海道千歳市福住');
ok($zip->set_number('0660054')->is_valid_number, '北海道千歳市柏陽');
ok($zip->set_number('0660055')->is_valid_number, '北海道千歳市里美');
ok($zip->set_number('0660056')->is_valid_number, '北海道千歳市白樺');
ok($zip->set_number('0660057')->is_valid_number, '北海道千歳市若草');
ok($zip->set_number('0660061')->is_valid_number, '北海道千歳市栄町');
ok($zip->set_number('0660062')->is_valid_number, '北海道千歳市千代田町');
ok($zip->set_number('0660063')->is_valid_number, '北海道千歳市幸町');
ok($zip->set_number('0660064')->is_valid_number, '北海道千歳市錦町');
ok($zip->set_number('0660065')->is_valid_number, '北海道千歳市春日町');
ok($zip->set_number('0660066')->is_valid_number, '北海道千歳市大和');
ok($zip->set_number('0660067')->is_valid_number, '北海道千歳市桂木');
ok($zip->set_number('0660068')->is_valid_number, '北海道千歳市蘭越');
ok($zip->set_number('0660069')->is_valid_number, '北海道千歳市新星');
ok($zip->set_number('0660071')->is_valid_number, '北海道千歳市桜木');
ok($zip->set_number('0660072')->is_valid_number, '北海道千歳市自由ケ丘');
ok($zip->set_number('0660073')->is_valid_number, '北海道千歳市北斗');
ok($zip->set_number('0660074')->is_valid_number, '北海道千歳市緑町');
ok($zip->set_number('0660075')->is_valid_number, '北海道千歳市北信濃');
ok($zip->set_number('0660076')->is_valid_number, '北海道千歳市あずさ');
ok($zip->set_number('0660077')->is_valid_number, '北海道千歳市上長都');
ok($zip->set_number('0660078')->is_valid_number, '北海道千歳市勇舞');
ok($zip->set_number('0660081')->is_valid_number, '北海道千歳市清流');
ok($zip->set_number('0660082')->is_valid_number, '北海道千歳市幸福');
ok($zip->set_number('0660083')->is_valid_number, '北海道千歳市みどり台北');
ok($zip->set_number('0660084')->is_valid_number, '北海道千歳市みどり台南');
ok($zip->set_number('0660271')->is_valid_number, '北海道苫小牧市丸山');
ok($zip->set_number('0660281')->is_valid_number, '北海道千歳市支笏湖温泉');
ok($zip->set_number('0660282')->is_valid_number, '北海道千歳市水明郷');
ok($zip->set_number('0660283')->is_valid_number, '北海道千歳市モラップ');
ok($zip->set_number('0660284')->is_valid_number, '北海道千歳市支寒内');
ok($zip->set_number('0660285')->is_valid_number, '北海道千歳市美笛');
ok($zip->set_number('0660286')->is_valid_number, '北海道千歳市奥潭');
ok($zip->set_number('0660287')->is_valid_number, '北海道千歳市幌美内');
ok($zip->set_number('0670000')->is_valid_number, '北海道江別市以下に掲載がない場合');
ok($zip->set_number('0670001')->is_valid_number, '北海道江別市王子');
ok($zip->set_number('0670002')->is_valid_number, '北海道江別市緑町西');
ok($zip->set_number('0670003')->is_valid_number, '北海道江別市緑町東');
ok($zip->set_number('0670004')->is_valid_number, '北海道江別市若草町');
ok($zip->set_number('0670005')->is_valid_number, '北海道江別市牧場町');
ok($zip->set_number('0670011')->is_valid_number, '北海道江別市1条');
ok($zip->set_number('0670012')->is_valid_number, '北海道江別市2条');
ok($zip->set_number('0670013')->is_valid_number, '北海道江別市3条');
ok($zip->set_number('0670014')->is_valid_number, '北海道江別市4条');
ok($zip->set_number('0670015')->is_valid_number, '北海道江別市5条');
ok($zip->set_number('0670016')->is_valid_number, '北海道江別市6条');
ok($zip->set_number('0670017')->is_valid_number, '北海道江別市7条');
ok($zip->set_number('0670018')->is_valid_number, '北海道江別市8条');
ok($zip->set_number('0670021')->is_valid_number, '北海道江別市豊幌');
ok($zip->set_number('0670022')->is_valid_number, '北海道江別市江別太');
ok($zip->set_number('0670023')->is_valid_number, '北海道江別市東光町');
ok($zip->set_number('0670024')->is_valid_number, '北海道江別市朝日町');
ok($zip->set_number('0670025')->is_valid_number, '北海道江別市あけぼの町');
ok($zip->set_number('0670026')->is_valid_number, '北海道江別市豊幌花園町');
ok($zip->set_number('0670027')->is_valid_number, '北海道江別市豊幌美咲町');
ok($zip->set_number('0670028')->is_valid_number, '北海道江別市豊幌はみんぐ町');
ok($zip->set_number('0670031')->is_valid_number, '北海道江別市元町');
ok($zip->set_number('0670032')->is_valid_number, '北海道江別市元江別');
ok($zip->set_number('0670033')->is_valid_number, '北海道江別市対雁');
ok($zip->set_number('0670034')->is_valid_number, '北海道江別市いずみ野');
ok($zip->set_number('0670041')->is_valid_number, '北海道江別市元江別本町');
ok($zip->set_number('0670042')->is_valid_number, '北海道江別市見晴台');
ok($zip->set_number('0670051')->is_valid_number, '北海道江別市工栄町');
ok($zip->set_number('0670052')->is_valid_number, '北海道江別市角山');
ok($zip->set_number('0670053')->is_valid_number, '北海道江別市中島');
ok($zip->set_number('0670054')->is_valid_number, '北海道江別市八幡');
ok($zip->set_number('0670055')->is_valid_number, '北海道江別市篠津');
ok($zip->set_number('0670056')->is_valid_number, '北海道江別市美原');
ok($zip->set_number('0670057')->is_valid_number, '北海道江別市萌えぎ野東');
ok($zip->set_number('0670058')->is_valid_number, '北海道江別市萌えぎ野中央');
ok($zip->set_number('0670059')->is_valid_number, '北海道江別市萌えぎ野西');
ok($zip->set_number('0670061')->is_valid_number, '北海道江別市上江別東町');
ok($zip->set_number('0670062')->is_valid_number, '北海道江別市上江別南町');
ok($zip->set_number('0670063')->is_valid_number, '北海道江別市上江別西町');
ok($zip->set_number('0670064')->is_valid_number, '北海道江別市上江別');
ok($zip->set_number('0670065')->is_valid_number, '北海道江別市ゆめみ野東町');
ok($zip->set_number('0670066')->is_valid_number, '北海道江別市ゆめみ野南町');
ok($zip->set_number('0670071')->is_valid_number, '北海道江別市萩ケ岡');
ok($zip->set_number('0670072')->is_valid_number, '北海道江別市一番町');
ok($zip->set_number('0670073')->is_valid_number, '北海道江別市弥生町');
ok($zip->set_number('0670074')->is_valid_number, '北海道江別市高砂町');
ok($zip->set_number('0670075')->is_valid_number, '北海道江別市向ケ丘');
ok($zip->set_number('0680000')->is_valid_number, '北海道岩見沢市以下に掲載がない場合');
ok($zip->set_number('0680001')->is_valid_number, '北海道岩見沢市一条東');
ok($zip->set_number('0680002')->is_valid_number, '北海道岩見沢市二条東');
ok($zip->set_number('0680003')->is_valid_number, '北海道岩見沢市三条東');
ok($zip->set_number('0680004')->is_valid_number, '北海道岩見沢市四条東');
ok($zip->set_number('0680005')->is_valid_number, '北海道岩見沢市五条東');
ok($zip->set_number('0680006')->is_valid_number, '北海道岩見沢市六条東');
ok($zip->set_number('0680007')->is_valid_number, '北海道岩見沢市七条東');
ok($zip->set_number('0680008')->is_valid_number, '北海道岩見沢市八条東');
ok($zip->set_number('0680009')->is_valid_number, '北海道岩見沢市九条東');
ok($zip->set_number('0680010')->is_valid_number, '北海道岩見沢市十条東');
ok($zip->set_number('0680011')->is_valid_number, '北海道岩見沢市十一条東');
ok($zip->set_number('0680012')->is_valid_number, '北海道岩見沢市十二条東');
ok($zip->set_number('0680013')->is_valid_number, '北海道岩見沢市東町一条');
ok($zip->set_number('0680014')->is_valid_number, '北海道岩見沢市東町二条');
ok($zip->set_number('0680015')->is_valid_number, '北海道岩見沢市東町');
ok($zip->set_number('0680016')->is_valid_number, '北海道岩見沢市稔町');
ok($zip->set_number('0680021')->is_valid_number, '北海道岩見沢市一条西');
ok($zip->set_number('0680022')->is_valid_number, '北海道岩見沢市二条西');
ok($zip->set_number('0680023')->is_valid_number, '北海道岩見沢市三条西');
ok($zip->set_number('0680024')->is_valid_number, '北海道岩見沢市四条西');
ok($zip->set_number('0680025')->is_valid_number, '北海道岩見沢市五条西');
ok($zip->set_number('0680026')->is_valid_number, '北海道岩見沢市六条西');
ok($zip->set_number('0680027')->is_valid_number, '北海道岩見沢市七条西');
ok($zip->set_number('0680028')->is_valid_number, '北海道岩見沢市八条西');
ok($zip->set_number('0680029')->is_valid_number, '北海道岩見沢市九条西');
ok($zip->set_number('0680030')->is_valid_number, '北海道岩見沢市十条西');
ok($zip->set_number('0680031')->is_valid_number, '北海道岩見沢市十一条西');
ok($zip->set_number('0680032')->is_valid_number, '北海道岩見沢市十二条西');
ok($zip->set_number('0680033')->is_valid_number, '北海道岩見沢市十三条西');
ok($zip->set_number('0680034')->is_valid_number, '北海道岩見沢市有明町南');
ok($zip->set_number('0680035')->is_valid_number, '北海道岩見沢市有明町中央');
ok($zip->set_number('0680041')->is_valid_number, '北海道岩見沢市北一条西');
ok($zip->set_number('0680042')->is_valid_number, '北海道岩見沢市北二条西');
ok($zip->set_number('0680043')->is_valid_number, '北海道岩見沢市北三条西');
ok($zip->set_number('0680044')->is_valid_number, '北海道岩見沢市北四条西');
ok($zip->set_number('0680045')->is_valid_number, '北海道岩見沢市北五条西');
ok($zip->set_number('0680046')->is_valid_number, '北海道岩見沢市緑町');
ok($zip->set_number('0680047')->is_valid_number, '北海道岩見沢市若松町');
ok($zip->set_number('0680048')->is_valid_number, '北海道岩見沢市西川町');
ok($zip->set_number('0680051')->is_valid_number, '北海道岩見沢市元町一条西');
ok($zip->set_number('0680052')->is_valid_number, '北海道岩見沢市元町二条西');
ok($zip->set_number('0680053')->is_valid_number, '北海道岩見沢市北本町西');
ok($zip->set_number('0680054')->is_valid_number, '北海道岩見沢市元町一条東');
ok($zip->set_number('0680055')->is_valid_number, '北海道岩見沢市元町二条東');
ok($zip->set_number('0680056')->is_valid_number, '北海道岩見沢市元町三条東');
ok($zip->set_number('0680057')->is_valid_number, '北海道岩見沢市北本町東');
ok($zip->set_number('0680058')->is_valid_number, '北海道岩見沢市桜木一条');
ok($zip->set_number('0680061')->is_valid_number, '北海道岩見沢市北六条西');
ok($zip->set_number('0680101')->is_valid_number, '北海道岩見沢市栗沢町北斗');
ok($zip->set_number('0680102')->is_valid_number, '北海道岩見沢市栗沢町栗部');
ok($zip->set_number('0680103')->is_valid_number, '北海道岩見沢市栗沢町砺波');
ok($zip->set_number('0680104')->is_valid_number, '北海道岩見沢市栗沢町耕成');
ok($zip->set_number('0680105')->is_valid_number, '北海道岩見沢市栗沢町自協');
ok($zip->set_number('0680106')->is_valid_number, '北海道岩見沢市栗沢町越前');
ok($zip->set_number('0680111')->is_valid_number, '北海道岩見沢市栗沢町由良');
ok($zip->set_number('0680112')->is_valid_number, '北海道岩見沢市栗沢町上幌');
ok($zip->set_number('0680113')->is_valid_number, '北海道岩見沢市栗沢町宮村(その他)');
ok($zip->set_number('0680114')->is_valid_number, '北海道岩見沢市栗沢町茂世丑');
ok($zip->set_number('0680115')->is_valid_number, '北海道岩見沢市栗沢町最上');
ok($zip->set_number('0680121')->is_valid_number, '北海道岩見沢市栗沢町北本町');
ok($zip->set_number('0680122')->is_valid_number, '北海道岩見沢市栗沢町北幸穂');
ok($zip->set_number('0680123')->is_valid_number, '北海道岩見沢市栗沢町東本町');
ok($zip->set_number('0680124')->is_valid_number, '北海道岩見沢市栗沢町幸穂町');
ok($zip->set_number('0680125')->is_valid_number, '北海道岩見沢市栗沢町南本町');
ok($zip->set_number('0680126')->is_valid_number, '北海道岩見沢市栗沢町西本町');
ok($zip->set_number('0680127')->is_valid_number, '北海道岩見沢市栗沢町本町');
ok($zip->set_number('0680131')->is_valid_number, '北海道岩見沢市栗沢町小西');
ok($zip->set_number('0680132')->is_valid_number, '北海道岩見沢市栗沢町南幸穂');
ok($zip->set_number('0680133')->is_valid_number, '北海道岩見沢市栗沢町加茂川');
ok($zip->set_number('0680134')->is_valid_number, '北海道岩見沢市栗沢町栗丘');
ok($zip->set_number('0680135')->is_valid_number, '北海道岩見沢市栗沢町岐阜');
ok($zip->set_number('0680136')->is_valid_number, '北海道岩見沢市栗沢町必成');
ok($zip->set_number('0680351')->is_valid_number, '北海道夕張郡栗山町阿野呂');
ok($zip->set_number('0680352')->is_valid_number, '北海道夕張郡栗山町大井分');
ok($zip->set_number('0680353')->is_valid_number, '北海道夕張郡栗山町継立');
ok($zip->set_number('0680354')->is_valid_number, '北海道夕張郡栗山町日出');
ok($zip->set_number('0680355')->is_valid_number, '北海道夕張郡栗山町御園');
ok($zip->set_number('0680356')->is_valid_number, '北海道夕張郡栗山町南角田');
ok($zip->set_number('0680357')->is_valid_number, '北海道夕張郡栗山町南学田');
ok($zip->set_number('0680358')->is_valid_number, '北海道夕張郡栗山町桜山(200、269番地)');
ok($zip->set_number('0680361')->is_valid_number, '北海道夕張郡栗山町滝下');
ok($zip->set_number('0680362')->is_valid_number, '北海道夕張郡栗山町円山');
ok($zip->set_number('0680363')->is_valid_number, '北海道夕張郡栗山町円山東山');
ok($zip->set_number('0680400')->is_valid_number, '北海道夕張市以下に掲載がない場合');
ok($zip->set_number('0680401')->is_valid_number, '北海道夕張市高松');
ok($zip->set_number('0680402')->is_valid_number, '北海道夕張市社光');
ok($zip->set_number('0680403')->is_valid_number, '北海道夕張市本町');
ok($zip->set_number('0680404')->is_valid_number, '北海道夕張市昭和');
ok($zip->set_number('0680405')->is_valid_number, '北海道夕張市旭町');
ok($zip->set_number('0680406')->is_valid_number, '北海道夕張市住初');
ok($zip->set_number('0680407')->is_valid_number, '北海道夕張市福住');
ok($zip->set_number('0680408')->is_valid_number, '北海道夕張市富岡');
ok($zip->set_number('0680409')->is_valid_number, '北海道夕張市丁未');
ok($zip->set_number('0680411')->is_valid_number, '北海道夕張市末広');
ok($zip->set_number('0680412')->is_valid_number, '北海道夕張市鹿の谷東丘町');
ok($zip->set_number('0680413')->is_valid_number, '北海道夕張市鹿の谷');
ok($zip->set_number('0680414')->is_valid_number, '北海道夕張市鹿の谷山手町');
ok($zip->set_number('0680421')->is_valid_number, '北海道夕張市常盤');
ok($zip->set_number('0680422')->is_valid_number, '北海道夕張市日吉');
ok($zip->set_number('0680423')->is_valid_number, '北海道夕張市平和');
ok($zip->set_number('0680424')->is_valid_number, '北海道夕張市千代田');
ok($zip->set_number('0680425')->is_valid_number, '北海道夕張市若菜');
ok($zip->set_number('0680426')->is_valid_number, '北海道夕張市富野');
ok($zip->set_number('0680531')->is_valid_number, '北海道夕張市清水沢');
ok($zip->set_number('0680532')->is_valid_number, '北海道夕張市清水沢清栄町');
ok($zip->set_number('0680533')->is_valid_number, '北海道夕張市清水沢清湖町');
ok($zip->set_number('0680534')->is_valid_number, '北海道夕張市清水沢宮前町');
ok($zip->set_number('0680535')->is_valid_number, '北海道夕張市清水沢清陵町');
ok($zip->set_number('0680536')->is_valid_number, '北海道夕張市南清水沢');
ok($zip->set_number('0680540')->is_valid_number, '北海道夕張市南部住の江町');
ok($zip->set_number('0680541')->is_valid_number, '北海道夕張市南部遠幌町');
ok($zip->set_number('0680542')->is_valid_number, '北海道夕張市南部夕南町');
ok($zip->set_number('0680543')->is_valid_number, '北海道夕張市南部若美町');
ok($zip->set_number('0680544')->is_valid_number, '北海道夕張市南部大宮町');
ok($zip->set_number('0680545')->is_valid_number, '北海道夕張市南部東町');
ok($zip->set_number('0680546')->is_valid_number, '北海道夕張市南部青葉町');
ok($zip->set_number('0680546')->is_valid_number, '北海道夕張市南部菊水町');
ok($zip->set_number('0680547')->is_valid_number, '北海道夕張市南部新光町');
ok($zip->set_number('0680548')->is_valid_number, '北海道夕張市南部幌南町');
ok($zip->set_number('0680549')->is_valid_number, '北海道夕張市南部岳見町');
ok($zip->set_number('0680661')->is_valid_number, '北海道夕張市鹿島白金');
ok($zip->set_number('0680662')->is_valid_number, '北海道夕張市鹿島明石町');
ok($zip->set_number('0680663')->is_valid_number, '北海道夕張市鹿島千年町');
ok($zip->set_number('0680664')->is_valid_number, '北海道夕張市鹿島錦町');
ok($zip->set_number('0680665')->is_valid_number, '北海道夕張市鹿島宝町');
ok($zip->set_number('0680671')->is_valid_number, '北海道夕張市鹿島緑町');
ok($zip->set_number('0680672')->is_valid_number, '北海道夕張市鹿島富士見町');
ok($zip->set_number('0680673')->is_valid_number, '北海道夕張市鹿島栄町');
ok($zip->set_number('0680674')->is_valid_number, '北海道夕張市鹿島代々木町');
ok($zip->set_number('0680675')->is_valid_number, '北海道夕張市鹿島北栄町');
ok($zip->set_number('0680751')->is_valid_number, '北海道夕張市沼ノ沢');
ok($zip->set_number('0680752')->is_valid_number, '北海道夕張市真谷地');
ok($zip->set_number('0680753')->is_valid_number, '北海道夕張市登川');
ok($zip->set_number('0680754')->is_valid_number, '北海道夕張市楓');
ok($zip->set_number('0680755')->is_valid_number, '北海道夕張市紅葉山');
ok($zip->set_number('0680756')->is_valid_number, '北海道夕張市滝ノ上');
ok($zip->set_number('0680801')->is_valid_number, '北海道岩見沢市南町一条');
ok($zip->set_number('0680802')->is_valid_number, '北海道岩見沢市南町二条');
ok($zip->set_number('0680803')->is_valid_number, '北海道岩見沢市南町三条');
ok($zip->set_number('0680804')->is_valid_number, '北海道岩見沢市南町四条');
ok($zip->set_number('0680805')->is_valid_number, '北海道岩見沢市南町五条');
ok($zip->set_number('0680806')->is_valid_number, '北海道岩見沢市南町六条');
ok($zip->set_number('0680807')->is_valid_number, '北海道岩見沢市南町七条');
ok($zip->set_number('0680808')->is_valid_number, '北海道岩見沢市南町八条');
ok($zip->set_number('0680809')->is_valid_number, '北海道岩見沢市南町九条');
ok($zip->set_number('0680810')->is_valid_number, '北海道岩見沢市南町');
ok($zip->set_number('0680811')->is_valid_number, '北海道岩見沢市美園一条');
ok($zip->set_number('0680812')->is_valid_number, '北海道岩見沢市美園二条');
ok($zip->set_number('0680813')->is_valid_number, '北海道岩見沢市美園三条');
ok($zip->set_number('0680814')->is_valid_number, '北海道岩見沢市美園四条');
ok($zip->set_number('0680815')->is_valid_number, '北海道岩見沢市美園五条');
ok($zip->set_number('0680816')->is_valid_number, '北海道岩見沢市美園六条');
ok($zip->set_number('0680817')->is_valid_number, '北海道岩見沢市美園七条');
ok($zip->set_number('0680818')->is_valid_number, '北海道岩見沢市並木町');
ok($zip->set_number('0680820')->is_valid_number, '北海道岩見沢市東山');
ok($zip->set_number('0680821')->is_valid_number, '北海道岩見沢市栄町');
ok($zip->set_number('0680822')->is_valid_number, '北海道岩見沢市日の出台');
ok($zip->set_number('0680823')->is_valid_number, '北海道岩見沢市日の出南');
ok($zip->set_number('0680824')->is_valid_number, '北海道岩見沢市日の出北');
ok($zip->set_number('0680825')->is_valid_number, '北海道岩見沢市日の出町');
ok($zip->set_number('0680826')->is_valid_number, '北海道岩見沢市東山町');
ok($zip->set_number('0680827')->is_valid_number, '北海道岩見沢市春日町');
ok($zip->set_number('0680828')->is_valid_number, '北海道岩見沢市鳩が丘');
ok($zip->set_number('0680829')->is_valid_number, '北海道岩見沢市かえで町');
ok($zip->set_number('0680830')->is_valid_number, '北海道岩見沢市若駒');
ok($zip->set_number('0680831')->is_valid_number, '北海道岩見沢市ふじ町一条');
ok($zip->set_number('0680832')->is_valid_number, '北海道岩見沢市ふじ町二条');
ok($zip->set_number('0680833')->is_valid_number, '北海道岩見沢市志文町');
ok($zip->set_number('0680834')->is_valid_number, '北海道岩見沢市駒園');
ok($zip->set_number('0680835')->is_valid_number, '北海道岩見沢市緑が丘');
ok($zip->set_number('0680836')->is_valid_number, '北海道岩見沢市上志文町');
ok($zip->set_number('0680837')->is_valid_number, '北海道岩見沢市宝水町');
ok($zip->set_number('0680841')->is_valid_number, '北海道岩見沢市志文本町一条');
ok($zip->set_number('0680842')->is_valid_number, '北海道岩見沢市志文本町二条');
ok($zip->set_number('0680843')->is_valid_number, '北海道岩見沢市志文本町三条');
ok($zip->set_number('0680844')->is_valid_number, '北海道岩見沢市志文本町四条');
ok($zip->set_number('0680845')->is_valid_number, '北海道岩見沢市志文本町五条');
ok($zip->set_number('0680846')->is_valid_number, '北海道岩見沢市下志文町');
ok($zip->set_number('0680847')->is_valid_number, '北海道岩見沢市金子町');
ok($zip->set_number('0680851')->is_valid_number, '北海道岩見沢市大和一条');
ok($zip->set_number('0680852')->is_valid_number, '北海道岩見沢市大和二条');
ok($zip->set_number('0680853')->is_valid_number, '北海道岩見沢市大和三条');
ok($zip->set_number('0680854')->is_valid_number, '北海道岩見沢市大和四条');
ok($zip->set_number('0680855')->is_valid_number, '北海道岩見沢市大和町');
ok($zip->set_number('0681100')->is_valid_number, '北海道石狩郡新篠津村以下に掲載がない場合');
ok($zip->set_number('0681101')->is_valid_number, '北海道石狩郡新篠津村萌出');
ok($zip->set_number('0681102')->is_valid_number, '北海道石狩郡新篠津村いなほ');
ok($zip->set_number('0681103')->is_valid_number, '北海道石狩郡新篠津村西の里');
ok($zip->set_number('0681104')->is_valid_number, '北海道石狩郡新篠津村かつら');
ok($zip->set_number('0681105')->is_valid_number, '北海道石狩郡新篠津村みのり');
ok($zip->set_number('0681111')->is_valid_number, '北海道石狩郡新篠津村東明');
ok($zip->set_number('0681112')->is_valid_number, '北海道石狩郡新篠津村あけぼの');
ok($zip->set_number('0681113')->is_valid_number, '北海道石狩郡新篠津村ふらわ');
ok($zip->set_number('0681114')->is_valid_number, '北海道石狩郡新篠津村南ケ丘');
ok($zip->set_number('0681115')->is_valid_number, '北海道石狩郡新篠津村みずほ');
ok($zip->set_number('0681116')->is_valid_number, '北海道石狩郡新篠津村上達布');
ok($zip->set_number('0681121')->is_valid_number, '北海道石狩郡新篠津村新湧');
ok($zip->set_number('0681122')->is_valid_number, '北海道石狩郡新篠津村北新');
ok($zip->set_number('0681123')->is_valid_number, '北海道石狩郡新篠津村川上');
ok($zip->set_number('0681124')->is_valid_number, '北海道石狩郡新篠津村高倉');
ok($zip->set_number('0681125')->is_valid_number, '北海道石狩郡新篠津村上篠津');
ok($zip->set_number('0681126')->is_valid_number, '北海道石狩郡新篠津村豊ケ丘');
ok($zip->set_number('0681127')->is_valid_number, '北海道石狩郡新篠津村沼之端');
ok($zip->set_number('0681131')->is_valid_number, '北海道石狩郡新篠津村基線');
ok($zip->set_number('0681132')->is_valid_number, '北海道石狩郡新篠津村豊野');
ok($zip->set_number('0681133')->is_valid_number, '北海道石狩郡新篠津村平安');
ok($zip->set_number('0681134')->is_valid_number, '北海道石狩郡新篠津村宍粟');
ok($zip->set_number('0681135')->is_valid_number, '北海道石狩郡新篠津村袋達布');
ok($zip->set_number('0681136')->is_valid_number, '北海道石狩郡新篠津村下達布');
ok($zip->set_number('0681137')->is_valid_number, '北海道石狩郡新篠津村中篠津');
ok($zip->set_number('0681138')->is_valid_number, '北海道石狩郡新篠津村新西篠津');
ok($zip->set_number('0681141')->is_valid_number, '北海道石狩郡新篠津村西篠津');
ok($zip->set_number('0681142')->is_valid_number, '北海道石狩郡新篠津村新樺');
ok($zip->set_number('0681143')->is_valid_number, '北海道石狩郡新篠津村武田');
ok($zip->set_number('0681144')->is_valid_number, '北海道石狩郡新篠津村拓新');
ok($zip->set_number('0681145')->is_valid_number, '北海道石狩郡新篠津村西高倉');
ok($zip->set_number('0681146')->is_valid_number, '北海道石狩郡新篠津村新高倉');
ok($zip->set_number('0681151')->is_valid_number, '北海道石狩郡新篠津村西原');
ok($zip->set_number('0681152')->is_valid_number, '北海道石狩郡新篠津村川下');
ok($zip->set_number('0681153')->is_valid_number, '北海道石狩郡新篠津村中原');
ok($zip->set_number('0681161')->is_valid_number, '北海道岩見沢市北村北都(新中島)');
ok($zip->set_number('0681201')->is_valid_number, '北海道岩見沢市北村豊正');
ok($zip->set_number('0681202')->is_valid_number, '北海道岩見沢市北村中小屋');
ok($zip->set_number('0681203')->is_valid_number, '北海道岩見沢市北村大願');
ok($zip->set_number('0681204')->is_valid_number, '北海道岩見沢市北村栄町');
ok($zip->set_number('0681205')->is_valid_number, '北海道岩見沢市北村豊里');
ok($zip->set_number('0681211')->is_valid_number, '北海道岩見沢市北村北都(その他)');
ok($zip->set_number('0681212')->is_valid_number, '北海道岩見沢市北村中央');
ok($zip->set_number('0681213')->is_valid_number, '北海道岩見沢市北村赤川');
ok($zip->set_number('0681214')->is_valid_number, '北海道岩見沢市北村美唄達布');
ok($zip->set_number('0681215')->is_valid_number, '北海道岩見沢市北村幌達布');
ok($zip->set_number('0681231')->is_valid_number, '北海道樺戸郡月形町雁里');
ok($zip->set_number('0682100')->is_valid_number, '北海道三笠市以下に掲載がない場合');
ok($zip->set_number('0682101')->is_valid_number, '北海道三笠市桂沢');
ok($zip->set_number('0682102')->is_valid_number, '北海道三笠市西桂沢');
ok($zip->set_number('0682103')->is_valid_number, '北海道三笠市奔別新町');
ok($zip->set_number('0682104')->is_valid_number, '北海道三笠市東清住町');
ok($zip->set_number('0682105')->is_valid_number, '北海道三笠市清住町');
ok($zip->set_number('0682106')->is_valid_number, '北海道三笠市美園町');
ok($zip->set_number('0682107')->is_valid_number, '北海道三笠市若草町');
ok($zip->set_number('0682108')->is_valid_number, '北海道三笠市柏町');
ok($zip->set_number('0682111')->is_valid_number, '北海道三笠市幾春別錦町');
ok($zip->set_number('0682112')->is_valid_number, '北海道三笠市幾春別川向町');
ok($zip->set_number('0682113')->is_valid_number, '北海道三笠市幾春別山手町');
ok($zip->set_number('0682114')->is_valid_number, '北海道三笠市幾春別栗丘町');
ok($zip->set_number('0682115')->is_valid_number, '北海道三笠市幾春別滝見町');
ok($zip->set_number('0682116')->is_valid_number, '北海道三笠市幾春別町');
ok($zip->set_number('0682117')->is_valid_number, '北海道三笠市幾春別中島町');
ok($zip->set_number('0682118')->is_valid_number, '北海道三笠市幾春別千住町');
ok($zip->set_number('0682121')->is_valid_number, '北海道三笠市弥生桜木町');
ok($zip->set_number('0682122')->is_valid_number, '北海道三笠市弥生並木町');
ok($zip->set_number('0682123')->is_valid_number, '北海道三笠市弥生桃山町');
ok($zip->set_number('0682124')->is_valid_number, '北海道三笠市弥生花園町');
ok($zip->set_number('0682125')->is_valid_number, '北海道三笠市弥生橘町');
ok($zip->set_number('0682126')->is_valid_number, '北海道三笠市弥生町');
ok($zip->set_number('0682127')->is_valid_number, '北海道三笠市弥生柳町');
ok($zip->set_number('0682128')->is_valid_number, '北海道三笠市弥生藤枝町');
ok($zip->set_number('0682131')->is_valid_number, '北海道三笠市唐松春光町');
ok($zip->set_number('0682132')->is_valid_number, '北海道三笠市唐松緑町');
ok($zip->set_number('0682133')->is_valid_number, '北海道三笠市唐松常盤町');
ok($zip->set_number('0682134')->is_valid_number, '北海道三笠市唐松千代田町');
ok($zip->set_number('0682135')->is_valid_number, '北海道三笠市唐松町');
ok($zip->set_number('0682136')->is_valid_number, '北海道三笠市唐松栄町');
ok($zip->set_number('0682137')->is_valid_number, '北海道三笠市唐松青山町');
ok($zip->set_number('0682141')->is_valid_number, '北海道三笠市本町');
ok($zip->set_number('0682142')->is_valid_number, '北海道三笠市幌内住吉町');
ok($zip->set_number('0682143')->is_valid_number, '北海道三笠市幌内北星町');
ok($zip->set_number('0682144')->is_valid_number, '北海道三笠市幌内金谷町');
ok($zip->set_number('0682145')->is_valid_number, '北海道三笠市幌内町');
ok($zip->set_number('0682146')->is_valid_number, '北海道三笠市幌内春日町');
ok($zip->set_number('0682147')->is_valid_number, '北海道三笠市幌内新栄町');
ok($zip->set_number('0682148')->is_valid_number, '北海道三笠市幌内初音町');
ok($zip->set_number('0682151')->is_valid_number, '北海道三笠市有明町');
ok($zip->set_number('0682152')->is_valid_number, '北海道三笠市多賀町');
ok($zip->set_number('0682153')->is_valid_number, '北海道三笠市幸町');
ok($zip->set_number('0682154')->is_valid_number, '北海道三笠市高美町');
ok($zip->set_number('0682155')->is_valid_number, '北海道三笠市榊町');
ok($zip->set_number('0682156')->is_valid_number, '北海道三笠市宮本町');
ok($zip->set_number('0682157')->is_valid_number, '北海道三笠市若松町');
ok($zip->set_number('0682158')->is_valid_number, '北海道三笠市堤町');
ok($zip->set_number('0682161')->is_valid_number, '北海道三笠市本郷町');
ok($zip->set_number('0682162')->is_valid_number, '北海道三笠市川内');
ok($zip->set_number('0682163')->is_valid_number, '北海道三笠市達布');
ok($zip->set_number('0682164')->is_valid_number, '北海道三笠市いちきしり');
ok($zip->set_number('0682165')->is_valid_number, '北海道三笠市岡山');
ok($zip->set_number('0682166')->is_valid_number, '北海道三笠市萱野');
ok($zip->set_number('0682167')->is_valid_number, '北海道三笠市大里');
ok($zip->set_number('0682168')->is_valid_number, '北海道三笠市美和');
ok($zip->set_number('0682181')->is_valid_number, '北海道美唄市光珠内町南(2794-12番地)');
ok($zip->set_number('0683151')->is_valid_number, '北海道岩見沢市栗沢町万字大平');
ok($zip->set_number('0683152')->is_valid_number, '北海道岩見沢市栗沢町万字幸町');
ok($zip->set_number('0683153')->is_valid_number, '北海道岩見沢市栗沢町万字仲町');
ok($zip->set_number('0683154')->is_valid_number, '北海道岩見沢市栗沢町万字曙町');
ok($zip->set_number('0683155')->is_valid_number, '北海道岩見沢市栗沢町万字寿町');
ok($zip->set_number('0683156')->is_valid_number, '北海道岩見沢市栗沢町万字英町');
ok($zip->set_number('0683157')->is_valid_number, '北海道岩見沢市栗沢町万字睦町');
ok($zip->set_number('0683158')->is_valid_number, '北海道岩見沢市栗沢町万字巴町');
ok($zip->set_number('0683159')->is_valid_number, '北海道岩見沢市栗沢町万字二見町');
ok($zip->set_number('0683161')->is_valid_number, '北海道岩見沢市栗沢町宮村(248、339、726、780、800、806番地)');
ok($zip->set_number('0683162')->is_valid_number, '北海道岩見沢市栗沢町万字旭町');
ok($zip->set_number('0683163')->is_valid_number, '北海道岩見沢市栗沢町万字西原町');
ok($zip->set_number('0683164')->is_valid_number, '北海道岩見沢市栗沢町万字錦町');
ok($zip->set_number('0683165')->is_valid_number, '北海道岩見沢市栗沢町西万字');
ok($zip->set_number('0683171')->is_valid_number, '北海道岩見沢市栗沢町美流渡本町');
ok($zip->set_number('0683172')->is_valid_number, '北海道岩見沢市栗沢町美流渡栄町');
ok($zip->set_number('0683173')->is_valid_number, '北海道岩見沢市栗沢町美流渡若葉町');
ok($zip->set_number('0683174')->is_valid_number, '北海道岩見沢市栗沢町美流渡吉野町');
ok($zip->set_number('0683175')->is_valid_number, '北海道岩見沢市栗沢町美流渡西町');
ok($zip->set_number('0683176')->is_valid_number, '北海道岩見沢市栗沢町美流渡東栄町');
ok($zip->set_number('0683177')->is_valid_number, '北海道岩見沢市栗沢町美流渡末広町');
ok($zip->set_number('0683178')->is_valid_number, '北海道岩見沢市栗沢町美流渡錦町');
ok($zip->set_number('0683179')->is_valid_number, '北海道岩見沢市栗沢町美流渡桜町');
ok($zip->set_number('0683180')->is_valid_number, '北海道岩見沢市栗沢町美流渡東町');
ok($zip->set_number('0683181')->is_valid_number, '北海道岩見沢市栗沢町美流渡南町');
ok($zip->set_number('0683182')->is_valid_number, '北海道岩見沢市栗沢町美流渡緑町');
ok($zip->set_number('0683183')->is_valid_number, '北海道岩見沢市栗沢町美流渡楓町');
ok($zip->set_number('0683185')->is_valid_number, '北海道岩見沢市朝日町');
ok($zip->set_number('0683186')->is_valid_number, '北海道岩見沢市清水町');
ok($zip->set_number('0683187')->is_valid_number, '北海道岩見沢市奈良町');
ok($zip->set_number('0683188')->is_valid_number, '北海道岩見沢市毛陽町');
ok($zip->set_number('0690200')->is_valid_number, '北海道空知郡南幌町以下に掲載がない場合');
ok($zip->set_number('0690207')->is_valid_number, '北海道空知郡南幌町南7線西');
ok($zip->set_number('0690208')->is_valid_number, '北海道空知郡南幌町南8線西');
ok($zip->set_number('0690209')->is_valid_number, '北海道空知郡南幌町南9線西');
ok($zip->set_number('0690210')->is_valid_number, '北海道空知郡南幌町南10線西');
ok($zip->set_number('0690211')->is_valid_number, '北海道空知郡南幌町南11線西');
ok($zip->set_number('0690212')->is_valid_number, '北海道空知郡南幌町南12線西');
ok($zip->set_number('0690213')->is_valid_number, '北海道空知郡南幌町南13線西');
ok($zip->set_number('0690214')->is_valid_number, '北海道空知郡南幌町南14線西');
ok($zip->set_number('0690215')->is_valid_number, '北海道空知郡南幌町南15線西');
ok($zip->set_number('0690216')->is_valid_number, '北海道空知郡南幌町南16線西');
ok($zip->set_number('0690217')->is_valid_number, '北海道空知郡南幌町南17線西');
ok($zip->set_number('0690218')->is_valid_number, '北海道空知郡南幌町南18線西');
ok($zip->set_number('0690219')->is_valid_number, '北海道空知郡南幌町南19線西');
ok($zip->set_number('0690220')->is_valid_number, '北海道空知郡南幌町南20線西');
ok($zip->set_number('0690221')->is_valid_number, '北海道空知郡南幌町南21線西');
ok($zip->set_number('0690231')->is_valid_number, '北海道空知郡南幌町北町');
ok($zip->set_number('0690232')->is_valid_number, '北海道空知郡南幌町緑町');
ok($zip->set_number('0690233')->is_valid_number, '北海道空知郡南幌町東町');
ok($zip->set_number('0690234')->is_valid_number, '北海道空知郡南幌町美園');
ok($zip->set_number('0690235')->is_valid_number, '北海道空知郡南幌町中央');
ok($zip->set_number('0690236')->is_valid_number, '北海道空知郡南幌町西町');
ok($zip->set_number('0690237')->is_valid_number, '北海道空知郡南幌町栄町');
ok($zip->set_number('0690238')->is_valid_number, '北海道空知郡南幌町元町');
ok($zip->set_number('0690239')->is_valid_number, '北海道空知郡南幌町稲穂');
ok($zip->set_number('0690351')->is_valid_number, '北海道岩見沢市北村砂浜');
ok($zip->set_number('0690361')->is_valid_number, '北海道岩見沢市上幌向北一条');
ok($zip->set_number('0690362')->is_valid_number, '北海道岩見沢市上幌向南一条');
ok($zip->set_number('0690363')->is_valid_number, '北海道岩見沢市上幌向南二条');
ok($zip->set_number('0690364')->is_valid_number, '北海道岩見沢市上幌向南三条');
ok($zip->set_number('0690365')->is_valid_number, '北海道岩見沢市上幌向町');
ok($zip->set_number('0690366')->is_valid_number, '北海道岩見沢市双葉町');
ok($zip->set_number('0690371')->is_valid_number, '北海道岩見沢市幌向南一条');
ok($zip->set_number('0690372')->is_valid_number, '北海道岩見沢市幌向南二条');
ok($zip->set_number('0690373')->is_valid_number, '北海道岩見沢市幌向南三条');
ok($zip->set_number('0690374')->is_valid_number, '北海道岩見沢市幌向南四条');
ok($zip->set_number('0690375')->is_valid_number, '北海道岩見沢市幌向南五条');
ok($zip->set_number('0690376')->is_valid_number, '北海道岩見沢市中幌向町');
ok($zip->set_number('0690381')->is_valid_number, '北海道岩見沢市幌向北一条');
ok($zip->set_number('0690382')->is_valid_number, '北海道岩見沢市幌向北二条');
ok($zip->set_number('0690383')->is_valid_number, '北海道岩見沢市幌向町');
ok($zip->set_number('0690384')->is_valid_number, '北海道岩見沢市御茶の水町');
ok($zip->set_number('0690801')->is_valid_number, '北海道江別市中央町');
ok($zip->set_number('0690802')->is_valid_number, '北海道江別市野幌寿町');
ok($zip->set_number('0690803')->is_valid_number, '北海道江別市野幌屯田町');
ok($zip->set_number('0690804')->is_valid_number, '北海道江別市野幌美幸町');
ok($zip->set_number('0690805')->is_valid_number, '北海道江別市元野幌(その他)');
ok($zip->set_number('0690806')->is_valid_number, '北海道江別市新栄台');
ok($zip->set_number('0690811')->is_valid_number, '北海道江別市錦町');
ok($zip->set_number('0690812')->is_valid_number, '北海道江別市幸町');
ok($zip->set_number('0690813')->is_valid_number, '北海道江別市野幌町');
ok($zip->set_number('0690814')->is_valid_number, '北海道江別市野幌松並町');
ok($zip->set_number('0690815')->is_valid_number, '北海道江別市野幌末広町');
ok($zip->set_number('0690816')->is_valid_number, '北海道江別市野幌住吉町');
ok($zip->set_number('0690817')->is_valid_number, '北海道江別市野幌代々木町');
ok($zip->set_number('0690821')->is_valid_number, '北海道江別市東野幌町');
ok($zip->set_number('0690822')->is_valid_number, '北海道江別市東野幌');
ok($zip->set_number('0690823')->is_valid_number, '北海道江別市緑ケ丘');
ok($zip->set_number('0690824')->is_valid_number, '北海道江別市東野幌本町');
ok($zip->set_number('0690825')->is_valid_number, '北海道江別市野幌東町');
ok($zip->set_number('0690826')->is_valid_number, '北海道江別市あさひが丘');
ok($zip->set_number('0690831')->is_valid_number, '北海道江別市野幌若葉町');
ok($zip->set_number('0690832')->is_valid_number, '北海道江別市西野幌');
ok($zip->set_number('0690833')->is_valid_number, '北海道江別市文京台');
ok($zip->set_number('0690834')->is_valid_number, '北海道江別市文京台東町');
ok($zip->set_number('0690835')->is_valid_number, '北海道江別市文京台南町');
ok($zip->set_number('0690836')->is_valid_number, '北海道江別市文京台緑町');
ok($zip->set_number('0690841')->is_valid_number, '北海道江別市大麻元町');
ok($zip->set_number('0690842')->is_valid_number, '北海道江別市大麻沢町');
ok($zip->set_number('0690843')->is_valid_number, '北海道江別市大麻扇町');
ok($zip->set_number('0690844')->is_valid_number, '北海道江別市大麻西町');
ok($zip->set_number('0690845')->is_valid_number, '北海道江別市大麻');
ok($zip->set_number('0690846')->is_valid_number, '北海道江別市大麻桜木町');
ok($zip->set_number('0690847')->is_valid_number, '北海道江別市大麻ひかり町');
ok($zip->set_number('0690851')->is_valid_number, '北海道江別市大麻園町');
ok($zip->set_number('0690852')->is_valid_number, '北海道江別市大麻東町');
ok($zip->set_number('0690853')->is_valid_number, '北海道江別市大麻高町');
ok($zip->set_number('0690854')->is_valid_number, '北海道江別市大麻中町');
ok($zip->set_number('0690855')->is_valid_number, '北海道江別市大麻宮町');
ok($zip->set_number('0690861')->is_valid_number, '北海道江別市大麻北町');
ok($zip->set_number('0690862')->is_valid_number, '北海道江別市大麻栄町');
ok($zip->set_number('0690863')->is_valid_number, '北海道江別市大麻新町');
ok($zip->set_number('0690864')->is_valid_number, '北海道江別市大麻泉町');
ok($zip->set_number('0690865')->is_valid_number, '北海道江別市大麻南樹町');
ok($zip->set_number('0690866')->is_valid_number, '北海道江別市大麻晴美町');
ok($zip->set_number('0690867')->is_valid_number, '北海道江別市元野幌(1~440番地)');
ok($zip->set_number('0691131')->is_valid_number, '北海道夕張郡由仁町三川泉町');
ok($zip->set_number('0691132')->is_valid_number, '北海道夕張郡由仁町三川錦町');
ok($zip->set_number('0691133')->is_valid_number, '北海道夕張郡由仁町三川旭町');
ok($zip->set_number('0691134')->is_valid_number, '北海道夕張郡由仁町三川緑町');
ok($zip->set_number('0691135')->is_valid_number, '北海道夕張郡由仁町西三川(その他)');
ok($zip->set_number('0691136')->is_valid_number, '北海道夕張郡由仁町熊本(その他)');
ok($zip->set_number('0691141')->is_valid_number, '北海道夕張郡由仁町川端');
ok($zip->set_number('0691142')->is_valid_number, '北海道夕張郡由仁町東三川');
ok($zip->set_number('0691143')->is_valid_number, '北海道夕張郡由仁町中三川');
ok($zip->set_number('0691144')->is_valid_number, '北海道夕張郡由仁町本三川(その他)');
ok($zip->set_number('0691181')->is_valid_number, '北海道千歳市東丘');
ok($zip->set_number('0691182')->is_valid_number, '北海道千歳市協和(その他)');
ok($zip->set_number('0691183')->is_valid_number, '北海道千歳市幌加');
ok($zip->set_number('0691184')->is_valid_number, '北海道千歳市新川');
ok($zip->set_number('0691200')->is_valid_number, '北海道夕張郡由仁町以下に掲載がない場合');
ok($zip->set_number('0691201')->is_valid_number, '北海道夕張郡由仁町北栄');
ok($zip->set_number('0691202')->is_valid_number, '北海道夕張郡由仁町古川');
ok($zip->set_number('0691203')->is_valid_number, '北海道夕張郡由仁町東栄');
ok($zip->set_number('0691204')->is_valid_number, '北海道夕張郡由仁町新光');
ok($zip->set_number('0691205')->is_valid_number, '北海道夕張郡由仁町中央');
ok($zip->set_number('0691206')->is_valid_number, '北海道夕張郡由仁町本町');
ok($zip->set_number('0691207')->is_valid_number, '北海道夕張郡由仁町馬追');
ok($zip->set_number('0691208')->is_valid_number, '北海道夕張郡由仁町山形');
ok($zip->set_number('0691211')->is_valid_number, '北海道夕張郡由仁町岩内');
ok($zip->set_number('0691212')->is_valid_number, '北海道夕張郡由仁町山桝');
ok($zip->set_number('0691213')->is_valid_number, '北海道夕張郡由仁町本三川(89、210、212番地)');
ok($zip->set_number('0691214')->is_valid_number, '北海道夕張郡由仁町西三川(1、17番地)');
ok($zip->set_number('0691215')->is_valid_number, '北海道夕張郡由仁町熊本(10、38、314、623、626番地)');
ok($zip->set_number('0691216')->is_valid_number, '北海道夕張郡由仁町古山');
ok($zip->set_number('0691217')->is_valid_number, '北海道夕張郡由仁町光栄');
ok($zip->set_number('0691218')->is_valid_number, '北海道夕張郡由仁町伏見');
ok($zip->set_number('0691219')->is_valid_number, '北海道夕張郡由仁町東光');
ok($zip->set_number('0691300')->is_valid_number, '北海道夕張郡長沼町以下に掲載がない場合');
ok($zip->set_number('0691301')->is_valid_number, '北海道夕張郡長沼町1区');
ok($zip->set_number('0691302')->is_valid_number, '北海道夕張郡長沼町2区');
ok($zip->set_number('0691303')->is_valid_number, '北海道夕張郡長沼町3区');
ok($zip->set_number('0691304')->is_valid_number, '北海道夕張郡長沼町北市区');
ok($zip->set_number('0691304')->is_valid_number, '北海道夕張郡長沼町4区');
ok($zip->set_number('0691305')->is_valid_number, '北海道夕張郡長沼町5区');
ok($zip->set_number('0691306')->is_valid_number, '北海道夕張郡長沼町6区');
ok($zip->set_number('0691307')->is_valid_number, '北海道夕張郡長沼町7区');
ok($zip->set_number('0691308')->is_valid_number, '北海道夕張郡長沼町8区');
ok($zip->set_number('0691309')->is_valid_number, '北海道夕張郡長沼町9区');
ok($zip->set_number('0691310')->is_valid_number, '北海道夕張郡長沼町10区');
ok($zip->set_number('0691311')->is_valid_number, '北海道夕張郡長沼町フシコ');
ok($zip->set_number('0691311')->is_valid_number, '北海道夕張郡長沼町11区');
ok($zip->set_number('0691312')->is_valid_number, '北海道夕張郡長沼町12区');
ok($zip->set_number('0691313')->is_valid_number, '北海道夕張郡長沼町13区');
ok($zip->set_number('0691314')->is_valid_number, '北海道夕張郡長沼町14区');
ok($zip->set_number('0691315')->is_valid_number, '北海道夕張郡長沼町南町');
ok($zip->set_number('0691315')->is_valid_number, '北海道夕張郡長沼町15区');
ok($zip->set_number('0691316')->is_valid_number, '北海道夕張郡長沼町加賀団体');
ok($zip->set_number('0691316')->is_valid_number, '北海道夕張郡長沼町16区');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東1線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東2線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東3線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東4線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東5線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東6線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東7線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東8線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東9線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東10線北');
ok($zip->set_number('0691317')->is_valid_number, '北海道夕張郡長沼町東11線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西1線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西2線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西3線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西4線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西5線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西6線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西7線北');
ok($zip->set_number('0691318')->is_valid_number, '北海道夕張郡長沼町西8線北');
ok($zip->set_number('0691320')->is_valid_number, '北海道夕張郡長沼町市街地');
ok($zip->set_number('0691321')->is_valid_number, '北海道夕張郡長沼町馬追');
ok($zip->set_number('0691322')->is_valid_number, '北海道夕張郡長沼町馬追原野');
ok($zip->set_number('0691329')->is_valid_number, '北海道夕張郡長沼町木詰');
ok($zip->set_number('0691329')->is_valid_number, '北海道夕張郡長沼町幌向原野');
ok($zip->set_number('0691329')->is_valid_number, '北海道夕張郡長沼町29区');
ok($zip->set_number('0691331')->is_valid_number, '北海道夕張郡長沼町銀座');
ok($zip->set_number('0691332')->is_valid_number, '北海道夕張郡長沼町中央');
ok($zip->set_number('0691333')->is_valid_number, '北海道夕張郡長沼町本町');
ok($zip->set_number('0691334')->is_valid_number, '北海道夕張郡長沼町錦町北');
ok($zip->set_number('0691334')->is_valid_number, '北海道夕張郡長沼町錦町南');
ok($zip->set_number('0691335')->is_valid_number, '北海道夕張郡長沼町あかね');
ok($zip->set_number('0691336')->is_valid_number, '北海道夕張郡長沼町川沿');
ok($zip->set_number('0691336')->is_valid_number, '北海道夕張郡長沼町栄町');
ok($zip->set_number('0691341')->is_valid_number, '北海道夕張郡長沼町宮下');
ok($zip->set_number('0691342')->is_valid_number, '北海道夕張郡長沼町東町');
ok($zip->set_number('0691343')->is_valid_number, '北海道夕張郡長沼町旭町');
ok($zip->set_number('0691344')->is_valid_number, '北海道夕張郡長沼町曙町');
ok($zip->set_number('0691345')->is_valid_number, '北海道夕張郡長沼町しらかば');
ok($zip->set_number('0691346')->is_valid_number, '北海道夕張郡長沼町西町');
ok($zip->set_number('0691347')->is_valid_number, '北海道夕張郡長沼町北町');
ok($zip->set_number('0691451')->is_valid_number, '北海道夕張郡長沼町東1線南');
ok($zip->set_number('0691452')->is_valid_number, '北海道夕張郡長沼町東2線南');
ok($zip->set_number('0691453')->is_valid_number, '北海道夕張郡長沼町東3線南');
ok($zip->set_number('0691454')->is_valid_number, '北海道夕張郡長沼町東4線南');
ok($zip->set_number('0691455')->is_valid_number, '北海道夕張郡長沼町東5線南');
ok($zip->set_number('0691456')->is_valid_number, '北海道夕張郡長沼町東6線南');
ok($zip->set_number('0691457')->is_valid_number, '北海道夕張郡長沼町東7線南');
ok($zip->set_number('0691458')->is_valid_number, '北海道夕張郡長沼町東8線南');
ok($zip->set_number('0691459')->is_valid_number, '北海道夕張郡長沼町東9線南');
ok($zip->set_number('0691460')->is_valid_number, '北海道夕張郡長沼町東10線南');
ok($zip->set_number('0691461')->is_valid_number, '北海道夕張郡長沼町東11線南');
ok($zip->set_number('0691462')->is_valid_number, '北海道夕張郡長沼町東12線南');
ok($zip->set_number('0691463')->is_valid_number, '北海道夕張郡長沼町東13線南');
ok($zip->set_number('0691464')->is_valid_number, '北海道夕張郡長沼町幌内');
ok($zip->set_number('0691471')->is_valid_number, '北海道夕張郡長沼町西1線南');
ok($zip->set_number('0691472')->is_valid_number, '北海道夕張郡長沼町西2線南');
ok($zip->set_number('0691473')->is_valid_number, '北海道夕張郡長沼町西3線南');
ok($zip->set_number('0691474')->is_valid_number, '北海道夕張郡長沼町西4線南');
ok($zip->set_number('0691475')->is_valid_number, '北海道夕張郡長沼町西5線南');
ok($zip->set_number('0691476')->is_valid_number, '北海道夕張郡長沼町西6線南');
ok($zip->set_number('0691477')->is_valid_number, '北海道夕張郡長沼町西7線南');
ok($zip->set_number('0691478')->is_valid_number, '北海道夕張郡長沼町西8線南');
ok($zip->set_number('0691479')->is_valid_number, '北海道夕張郡長沼町西9線南');
ok($zip->set_number('0691480')->is_valid_number, '北海道夕張郡長沼町西10線南');
ok($zip->set_number('0691481')->is_valid_number, '北海道夕張郡長沼町西11線南');
ok($zip->set_number('0691482')->is_valid_number, '北海道夕張郡長沼町西12線南');
ok($zip->set_number('0691483')->is_valid_number, '北海道夕張郡長沼町西13線南');
ok($zip->set_number('0691484')->is_valid_number, '北海道夕張郡長沼町西14線南');
ok($zip->set_number('0691485')->is_valid_number, '北海道夕張郡長沼町30区');
ok($zip->set_number('0691500')->is_valid_number, '北海道夕張郡栗山町以下に掲載がない場合');
ok($zip->set_number('0691501')->is_valid_number, '北海道夕張郡栗山町桜丘');
ok($zip->set_number('0691502')->is_valid_number, '北海道夕張郡栗山町鳩山');
ok($zip->set_number('0691502')->is_valid_number, '北海道夕張郡栗山町森');
ok($zip->set_number('0691503')->is_valid_number, '北海道夕張郡栗山町雨煙別');
ok($zip->set_number('0691503')->is_valid_number, '北海道夕張郡栗山町緑丘');
ok($zip->set_number('0691504')->is_valid_number, '北海道夕張郡栗山町北学田');
ok($zip->set_number('0691505')->is_valid_number, '北海道夕張郡栗山町桜山(その他)');
ok($zip->set_number('0691505')->is_valid_number, '北海道夕張郡栗山町本沢');
ok($zip->set_number('0691506')->is_valid_number, '北海道夕張郡栗山町杵臼');
ok($zip->set_number('0691507')->is_valid_number, '北海道夕張郡栗山町旭台');
ok($zip->set_number('0691508')->is_valid_number, '北海道夕張郡栗山町湯地');
ok($zip->set_number('0691511')->is_valid_number, '北海道夕張郡栗山町中央');
ok($zip->set_number('0691512')->is_valid_number, '北海道夕張郡栗山町松風');
ok($zip->set_number('0691513')->is_valid_number, '北海道夕張郡栗山町朝日');
ok($zip->set_number('0691521')->is_valid_number, '北海道夕張郡栗山町錦');
ok($zip->set_number('0691522')->is_valid_number, '北海道夕張郡栗山町中里');
ok($zip->set_number('0691523')->is_valid_number, '北海道夕張郡栗山町共和');
ok($zip->set_number('0691524')->is_valid_number, '北海道夕張郡栗山町角田');
ok($zip->set_number('0691525')->is_valid_number, '北海道夕張郡栗山町三日月');
ok($zip->set_number('0691526')->is_valid_number, '北海道夕張郡栗山町富士');
ok($zip->set_number('0700000')->is_valid_number, '北海道旭川市以下に掲載がない場合');
ok($zip->set_number('0700001')->is_valid_number, '北海道旭川市新富1条');
ok($zip->set_number('0700002')->is_valid_number, '北海道旭川市新富2条');
ok($zip->set_number('0700003')->is_valid_number, '北海道旭川市新富3条');
ok($zip->set_number('0700010')->is_valid_number, '北海道旭川市大雪通');
ok($zip->set_number('0700011')->is_valid_number, '北海道旭川市パルプ町1条');
ok($zip->set_number('0700012')->is_valid_number, '北海道旭川市パルプ町2条');
ok($zip->set_number('0700013')->is_valid_number, '北海道旭川市パルプ町');
ok($zip->set_number('0700014')->is_valid_number, '北海道旭川市新星町');
ok($zip->set_number('0700021')->is_valid_number, '北海道旭川市東1条');
ok($zip->set_number('0700022')->is_valid_number, '北海道旭川市東2条');
ok($zip->set_number('0700023')->is_valid_number, '北海道旭川市東3条');
ok($zip->set_number('0700024')->is_valid_number, '北海道旭川市東4条');
ok($zip->set_number('0700025')->is_valid_number, '北海道旭川市東5条');
ok($zip->set_number('0700026')->is_valid_number, '北海道旭川市東6条');
ok($zip->set_number('0700027')->is_valid_number, '北海道旭川市東7条');
ok($zip->set_number('0700028')->is_valid_number, '北海道旭川市東8条');
ok($zip->set_number('0700029')->is_valid_number, '北海道旭川市金星町');
ok($zip->set_number('0700030')->is_valid_number, '北海道旭川市宮下通(1~17丁目)');
ok($zip->set_number('0700031')->is_valid_number, '北海道旭川市1条通(1~17丁目)');
ok($zip->set_number('0700032')->is_valid_number, '北海道旭川市2条通(1~17丁目)');
ok($zip->set_number('0700033')->is_valid_number, '北海道旭川市3条通(1~17丁目)');
ok($zip->set_number('0700034')->is_valid_number, '北海道旭川市4条通(1~17丁目)');
ok($zip->set_number('0700035')->is_valid_number, '北海道旭川市5条通(1~17丁目)');
ok($zip->set_number('0700036')->is_valid_number, '北海道旭川市6条通(1~17丁目)');
ok($zip->set_number('0700037')->is_valid_number, '北海道旭川市7条通(1~17丁目)');
ok($zip->set_number('0700038')->is_valid_number, '北海道旭川市8条通(1~17丁目)');
ok($zip->set_number('0700039')->is_valid_number, '北海道旭川市9条通(1~17丁目)');
ok($zip->set_number('0700040')->is_valid_number, '北海道旭川市10条通(8~17丁目)');
ok($zip->set_number('0700041')->is_valid_number, '北海道旭川市上常盤町');
ok($zip->set_number('0700042')->is_valid_number, '北海道旭川市中常盤町');
ok($zip->set_number('0700043')->is_valid_number, '北海道旭川市常盤通');
ok($zip->set_number('0700044')->is_valid_number, '北海道旭川市常磐公園');
ok($zip->set_number('0700052')->is_valid_number, '北海道旭川市2条西');
ok($zip->set_number('0700053')->is_valid_number, '北海道旭川市3条西');
ok($zip->set_number('0700054')->is_valid_number, '北海道旭川市4条西');
ok($zip->set_number('0700055')->is_valid_number, '北海道旭川市5条西');
ok($zip->set_number('0700056')->is_valid_number, '北海道旭川市6条西');
ok($zip->set_number('0700057')->is_valid_number, '北海道旭川市7条西');
ok($zip->set_number('0700058')->is_valid_number, '北海道旭川市8条西');
ok($zip->set_number('0700059')->is_valid_number, '北海道旭川市9条西');
ok($zip->set_number('0700061')->is_valid_number, '北海道旭川市曙1条');
ok($zip->set_number('0700062')->is_valid_number, '北海道旭川市曙2条');
ok($zip->set_number('0700063')->is_valid_number, '北海道旭川市曙3条');
ok($zip->set_number('0700072')->is_valid_number, '北海道旭川市曙北2条');
ok($zip->set_number('0700073')->is_valid_number, '北海道旭川市曙北3条');
ok($zip->set_number('0700081')->is_valid_number, '北海道旭川市亀吉1条');
ok($zip->set_number('0700082')->is_valid_number, '北海道旭川市亀吉2条');
ok($zip->set_number('0700083')->is_valid_number, '北海道旭川市亀吉3条');
ok($zip->set_number('0700810')->is_valid_number, '北海道旭川市本町');
ok($zip->set_number('0700811')->is_valid_number, '北海道旭川市川端町1条');
ok($zip->set_number('0700812')->is_valid_number, '北海道旭川市川端町2条');
ok($zip->set_number('0700813')->is_valid_number, '北海道旭川市川端町3条');
ok($zip->set_number('0700814')->is_valid_number, '北海道旭川市川端町4条');
ok($zip->set_number('0700815')->is_valid_number, '北海道旭川市川端町5条');
ok($zip->set_number('0700816')->is_valid_number, '北海道旭川市川端町6条');
ok($zip->set_number('0700817')->is_valid_number, '北海道旭川市川端町7条');
ok($zip->set_number('0700821')->is_valid_number, '北海道旭川市近文町');
ok($zip->set_number('0700822')->is_valid_number, '北海道旭川市旭岡');
ok($zip->set_number('0700823')->is_valid_number, '北海道旭川市緑町');
ok($zip->set_number('0700824')->is_valid_number, '北海道旭川市錦町');
ok($zip->set_number('0700825')->is_valid_number, '北海道旭川市北門町');
ok($zip->set_number('0700831')->is_valid_number, '北海道旭川市旭町1条');
ok($zip->set_number('0700832')->is_valid_number, '北海道旭川市旭町2条');
ok($zip->set_number('0700841')->is_valid_number, '北海道旭川市大町1条');
ok($zip->set_number('0700842')->is_valid_number, '北海道旭川市大町2条');
ok($zip->set_number('0700843')->is_valid_number, '北海道旭川市大町3条');
ok($zip->set_number('0700864')->is_valid_number, '北海道旭川市住吉4条');
ok($zip->set_number('0700865')->is_valid_number, '北海道旭川市住吉5条');
ok($zip->set_number('0700866')->is_valid_number, '北海道旭川市住吉6条');
ok($zip->set_number('0700867')->is_valid_number, '北海道旭川市住吉7条');
ok($zip->set_number('0700871')->is_valid_number, '北海道旭川市春光1条');
ok($zip->set_number('0700872')->is_valid_number, '北海道旭川市春光2条');
ok($zip->set_number('0700873')->is_valid_number, '北海道旭川市春光3条');
ok($zip->set_number('0700874')->is_valid_number, '北海道旭川市春光4条');
ok($zip->set_number('0700875')->is_valid_number, '北海道旭川市春光5条');
ok($zip->set_number('0700876')->is_valid_number, '北海道旭川市春光6条');
ok($zip->set_number('0700877')->is_valid_number, '北海道旭川市春光7条');
ok($zip->set_number('0700901')->is_valid_number, '北海道旭川市花咲町');
ok($zip->set_number('0700902')->is_valid_number, '北海道旭川市春光町');
ok($zip->set_number('0700971')->is_valid_number, '北海道旭川市4区1条');
ok($zip->set_number('0700972')->is_valid_number, '北海道旭川市4区2条');
ok($zip->set_number('0700973')->is_valid_number, '北海道旭川市4区3条');
ok($zip->set_number('0708001')->is_valid_number, '北海道旭川市神楽1条');
ok($zip->set_number('0708002')->is_valid_number, '北海道旭川市神楽2条');
ok($zip->set_number('0708003')->is_valid_number, '北海道旭川市神楽3条');
ok($zip->set_number('0708004')->is_valid_number, '北海道旭川市神楽4条');
ok($zip->set_number('0708005')->is_valid_number, '北海道旭川市神楽5条');
ok($zip->set_number('0708006')->is_valid_number, '北海道旭川市神楽6条');
ok($zip->set_number('0708007')->is_valid_number, '北海道旭川市神楽7条');
ok($zip->set_number('0708011')->is_valid_number, '北海道旭川市神居1条');
ok($zip->set_number('0708012')->is_valid_number, '北海道旭川市神居2条');
ok($zip->set_number('0708013')->is_valid_number, '北海道旭川市神居3条');
ok($zip->set_number('0708014')->is_valid_number, '北海道旭川市神居4条');
ok($zip->set_number('0708015')->is_valid_number, '北海道旭川市神居5条');
ok($zip->set_number('0708016')->is_valid_number, '北海道旭川市神居6条');
ok($zip->set_number('0708017')->is_valid_number, '北海道旭川市神居7条');
ok($zip->set_number('0708018')->is_valid_number, '北海道旭川市神居8条');
ok($zip->set_number('0708019')->is_valid_number, '北海道旭川市神居9条');
ok($zip->set_number('0708021')->is_valid_number, '北海道旭川市神居町忠和');
ok($zip->set_number('0708022')->is_valid_number, '北海道旭川市神居町台場');
ok($zip->set_number('0708023')->is_valid_number, '北海道旭川市神居町春志内');
ok($zip->set_number('0708024')->is_valid_number, '北海道旭川市神居町富沢');
ok($zip->set_number('0708025')->is_valid_number, '北海道旭川市神居町富岡');
ok($zip->set_number('0708026')->is_valid_number, '北海道旭川市神居町神岡');
ok($zip->set_number('0708027')->is_valid_number, '北海道旭川市台場東');
ok($zip->set_number('0708028')->is_valid_number, '北海道旭川市南が丘');
ok($zip->set_number('0708031')->is_valid_number, '北海道旭川市神居町神華');
ok($zip->set_number('0708032')->is_valid_number, '北海道旭川市神居町共栄');
ok($zip->set_number('0708033')->is_valid_number, '北海道旭川市神居町雨紛');
ok($zip->set_number('0708034')->is_valid_number, '北海道旭川市神居町上雨紛');
ok($zip->set_number('0708041')->is_valid_number, '北海道旭川市忠和1条');
ok($zip->set_number('0708042')->is_valid_number, '北海道旭川市忠和2条');
ok($zip->set_number('0708043')->is_valid_number, '北海道旭川市忠和3条');
ok($zip->set_number('0708044')->is_valid_number, '北海道旭川市忠和4条');
ok($zip->set_number('0708045')->is_valid_number, '北海道旭川市忠和5条');
ok($zip->set_number('0708046')->is_valid_number, '北海道旭川市忠和6条');
ok($zip->set_number('0708047')->is_valid_number, '北海道旭川市忠和7条');
ok($zip->set_number('0708048')->is_valid_number, '北海道旭川市忠和8条');
ok($zip->set_number('0708049')->is_valid_number, '北海道旭川市忠和9条');
ok($zip->set_number('0708051')->is_valid_number, '北海道旭川市江丹別町嵐山');
ok($zip->set_number('0708052')->is_valid_number, '北海道旭川市江丹別町春日');
ok($zip->set_number('0708053')->is_valid_number, '北海道旭川市江丹別町共和');
ok($zip->set_number('0708061')->is_valid_number, '北海道旭川市高砂台');
ok($zip->set_number('0708071')->is_valid_number, '北海道旭川市台場1条');
ok($zip->set_number('0708072')->is_valid_number, '北海道旭川市台場2条');
ok($zip->set_number('0708073')->is_valid_number, '北海道旭川市台場3条');
ok($zip->set_number('0708074')->is_valid_number, '北海道旭川市台場4条');
ok($zip->set_number('0710171')->is_valid_number, '北海道旭川市西神楽南1条');
ok($zip->set_number('0710172')->is_valid_number, '北海道旭川市西神楽南2条');
ok($zip->set_number('0710173')->is_valid_number, '北海道旭川市西神楽北1条');
ok($zip->set_number('0710174')->is_valid_number, '北海道旭川市西神楽北2条');
ok($zip->set_number('0710184')->is_valid_number, '北海道旭川市西神楽4線');
ok($zip->set_number('0710185')->is_valid_number, '北海道旭川市西神楽5線');
ok($zip->set_number('0710186')->is_valid_number, '北海道旭川市西神楽南');
ok($zip->set_number('0710200')->is_valid_number, '北海道上川郡美瑛町以下に掲載がない場合');
ok($zip->set_number('0710201')->is_valid_number, '北海道上川郡美瑛町丸山');
ok($zip->set_number('0710202')->is_valid_number, '北海道上川郡美瑛町南町');
ok($zip->set_number('0710203')->is_valid_number, '北海道上川郡美瑛町西町');
ok($zip->set_number('0710204')->is_valid_number, '北海道上川郡美瑛町大町');
ok($zip->set_number('0710205')->is_valid_number, '北海道上川郡美瑛町栄町');
ok($zip->set_number('0710206')->is_valid_number, '北海道上川郡美瑛町北町');
ok($zip->set_number('0710207')->is_valid_number, '北海道上川郡美瑛町中町');
ok($zip->set_number('0710208')->is_valid_number, '北海道上川郡美瑛町本町');
ok($zip->set_number('0710209')->is_valid_number, '北海道上川郡美瑛町寿町');
ok($zip->set_number('0710211')->is_valid_number, '北海道上川郡美瑛町錦町');
ok($zip->set_number('0710212')->is_valid_number, '北海道上川郡美瑛町旭町');
ok($zip->set_number('0710213')->is_valid_number, '北海道上川郡美瑛町東町');
ok($zip->set_number('0710214')->is_valid_number, '北海道上川郡美瑛町幸町');
ok($zip->set_number('0710215')->is_valid_number, '北海道上川郡美瑛町扇町');
ok($zip->set_number('0710216')->is_valid_number, '北海道上川郡美瑛町大村(大久保)');
ok($zip->set_number('0710217')->is_valid_number, '北海道上川郡美瑛町大村(石山)');
ok($zip->set_number('0710218')->is_valid_number, '北海道上川郡美瑛町大村(村山)');
ok($zip->set_number('0710219')->is_valid_number, '北海道上川郡美瑛町大村(中本)');
ok($zip->set_number('0710221')->is_valid_number, '北海道上川郡美瑛町美田(夕張)');
ok($zip->set_number('0710222')->is_valid_number, '北海道上川郡美瑛町美田');
ok($zip->set_number('0710223')->is_valid_number, '北海道上川郡美瑛町五稜');
ok($zip->set_number('0710224')->is_valid_number, '北海道上川郡美瑛町北瑛');
ok($zip->set_number('0710225')->is_valid_number, '北海道上川郡美瑛町明治(大三)');
ok($zip->set_number('0710226')->is_valid_number, '北海道上川郡美瑛町下宇莫別');
ok($zip->set_number('0710227')->is_valid_number, '北海道上川郡美瑛町中宇莫別(赤羽)');
ok($zip->set_number('0710228')->is_valid_number, '北海道上川郡美瑛町中宇莫別');
ok($zip->set_number('0710229')->is_valid_number, '北海道上川郡美瑛町上宇莫別');
ok($zip->set_number('0710231')->is_valid_number, '北海道上川郡美瑛町明治');
ok($zip->set_number('0710232')->is_valid_number, '北海道上川郡美瑛町明治(沼崎)');
ok($zip->set_number('0710233')->is_valid_number, '北海道上川郡美瑛町新区画');
ok($zip->set_number('0710234')->is_valid_number, '北海道上川郡美瑛町置杵牛');
ok($zip->set_number('0710235')->is_valid_number, '北海道上川郡美瑛町白金');
ok($zip->set_number('0710236')->is_valid_number, '北海道上川郡美瑛町美沢');
ok($zip->set_number('0710237')->is_valid_number, '北海道上川郡美瑛町福富(豊栄)');
ok($zip->set_number('0710238')->is_valid_number, '北海道上川郡美瑛町藤野');
ok($zip->set_number('0710239')->is_valid_number, '北海道上川郡美瑛町美瑛原野(原野)');
ok($zip->set_number('0710240')->is_valid_number, '北海道上川郡美瑛町三愛(緑)');
ok($zip->set_number('0710241')->is_valid_number, '北海道上川郡美瑛町水沢(水上)');
ok($zip->set_number('0710242')->is_valid_number, '北海道上川郡美瑛町水沢');
ok($zip->set_number('0710243')->is_valid_number, '北海道上川郡美瑛町福富(間宮)');
ok($zip->set_number('0710244')->is_valid_number, '北海道上川郡美瑛町福富(福美沢)');
ok($zip->set_number('0710245')->is_valid_number, '北海道上川郡美瑛町福富(福富瑛進)');
ok($zip->set_number('0710246')->is_valid_number, '北海道上川郡美瑛町福富(福富憩)');
ok($zip->set_number('0710247')->is_valid_number, '北海道上川郡美瑛町三愛(大曲)');
ok($zip->set_number('0710248')->is_valid_number, '北海道上川郡美瑛町花園');
ok($zip->set_number('0710249')->is_valid_number, '北海道上川郡美瑛町憩町');
ok($zip->set_number('0710251')->is_valid_number, '北海道上川郡美瑛町憩が丘');
ok($zip->set_number('0710261')->is_valid_number, '北海道上川郡美瑛町旭');
ok($zip->set_number('0710351')->is_valid_number, '北海道上川郡美瑛町横牛');
ok($zip->set_number('0710352')->is_valid_number, '北海道上川郡美瑛町朗根内');
ok($zip->set_number('0710353')->is_valid_number, '北海道上川郡美瑛町俵真布');
ok($zip->set_number('0710355')->is_valid_number, '北海道上川郡美瑛町天人峡');
ok($zip->set_number('0710461')->is_valid_number, '北海道上川郡美瑛町美馬牛北');
ok($zip->set_number('0710462')->is_valid_number, '北海道上川郡美瑛町美馬牛南');
ok($zip->set_number('0710471')->is_valid_number, '北海道上川郡美瑛町美馬牛');
ok($zip->set_number('0710472')->is_valid_number, '北海道上川郡美瑛町美馬牛市街地');
ok($zip->set_number('0710473')->is_valid_number, '北海道上川郡美瑛町新星');
ok($zip->set_number('0710474')->is_valid_number, '北海道上川郡美瑛町拓進');
ok($zip->set_number('0710475')->is_valid_number, '北海道上川郡美瑛町常盤');
ok($zip->set_number('0710476')->is_valid_number, '北海道上川郡美瑛町御牧');
ok($zip->set_number('0710477')->is_valid_number, '北海道上川郡美瑛町二股');
ok($zip->set_number('0710478')->is_valid_number, '北海道上川郡美瑛町瑠辺蘂');
ok($zip->set_number('0710479')->is_valid_number, '北海道上川郡美瑛町美園');
ok($zip->set_number('0710500')->is_valid_number, '北海道空知郡上富良野町以下に掲載がない場合');
ok($zip->set_number('0710501')->is_valid_number, '北海道空知郡上富良野町西1線北');
ok($zip->set_number('0710502')->is_valid_number, '北海道空知郡上富良野町西2線北');
ok($zip->set_number('0710503')->is_valid_number, '北海道空知郡上富良野町西3線北');
ok($zip->set_number('0710504')->is_valid_number, '北海道空知郡上富良野町西4線北');
ok($zip->set_number('0710505')->is_valid_number, '北海道空知郡上富良野町西5線北');
ok($zip->set_number('0710506')->is_valid_number, '北海道空知郡上富良野町西6線北');
ok($zip->set_number('0710507')->is_valid_number, '北海道空知郡上富良野町西7線北');
ok($zip->set_number('0710508')->is_valid_number, '北海道空知郡上富良野町西8線北');
ok($zip->set_number('0710509')->is_valid_number, '北海道空知郡上富良野町西9線北');
ok($zip->set_number('0710510')->is_valid_number, '北海道空知郡上富良野町西10線北');
ok($zip->set_number('0710511')->is_valid_number, '北海道空知郡上富良野町西11線北');
ok($zip->set_number('0710512')->is_valid_number, '北海道空知郡上富良野町西12線北');
ok($zip->set_number('0710513')->is_valid_number, '北海道空知郡上富良野町西13線北');
ok($zip->set_number('0710514')->is_valid_number, '北海道空知郡上富良野町西14線北');
ok($zip->set_number('0710515')->is_valid_number, '北海道空知郡上富良野町西15線北');
ok($zip->set_number('0710516')->is_valid_number, '北海道空知郡上富良野町西16線北');
ok($zip->set_number('0710517')->is_valid_number, '北海道空知郡上富良野町沼崎農場');
ok($zip->set_number('0710520')->is_valid_number, '北海道空知郡上富良野町基線北');
ok($zip->set_number('0710521')->is_valid_number, '北海道空知郡上富良野町東1線北');
ok($zip->set_number('0710522')->is_valid_number, '北海道空知郡上富良野町東2線北');
ok($zip->set_number('0710523')->is_valid_number, '北海道空知郡上富良野町東3線北');
ok($zip->set_number('0710524')->is_valid_number, '北海道空知郡上富良野町東4線北');
ok($zip->set_number('0710525')->is_valid_number, '北海道空知郡上富良野町東5線北');
ok($zip->set_number('0710526')->is_valid_number, '北海道空知郡上富良野町東6線北');
ok($zip->set_number('0710527')->is_valid_number, '北海道空知郡上富良野町東7線北');
ok($zip->set_number('0710528')->is_valid_number, '北海道空知郡上富良野町東8線北');
ok($zip->set_number('0710529')->is_valid_number, '北海道空知郡上富良野町東9線北');
ok($zip->set_number('0710530')->is_valid_number, '北海道空知郡上富良野町東10線北');
ok($zip->set_number('0710531')->is_valid_number, '北海道空知郡上富良野町東11線北');
ok($zip->set_number('0710532')->is_valid_number, '北海道空知郡上富良野町東12線北');
ok($zip->set_number('0710533')->is_valid_number, '北海道空知郡上富良野町倍本農場');
ok($zip->set_number('0710534')->is_valid_number, '北海道空知郡上富良野町西谷牧場');
ok($zip->set_number('0710541')->is_valid_number, '北海道空知郡上富良野町富町');
ok($zip->set_number('0710542')->is_valid_number, '北海道空知郡上富良野町錦町');
ok($zip->set_number('0710543')->is_valid_number, '北海道空知郡上富良野町中町');
ok($zip->set_number('0710544')->is_valid_number, '北海道空知郡上富良野町栄町');
ok($zip->set_number('0710545')->is_valid_number, '北海道空知郡上富良野町光町');
ok($zip->set_number('0710546')->is_valid_number, '北海道空知郡上富良野町西町');
ok($zip->set_number('0710547')->is_valid_number, '北海道空知郡上富良野町泉町');
ok($zip->set_number('0710548')->is_valid_number, '北海道空知郡上富良野町扇町');
ok($zip->set_number('0710549')->is_valid_number, '北海道空知郡上富良野町北町');
ok($zip->set_number('0710551')->is_valid_number, '北海道空知郡上富良野町本町');
ok($zip->set_number('0710552')->is_valid_number, '北海道空知郡上富良野町宮町');
ok($zip->set_number('0710553')->is_valid_number, '北海道空知郡上富良野町旭町');
ok($zip->set_number('0710554')->is_valid_number, '北海道空知郡上富良野町新町');
ok($zip->set_number('0710555')->is_valid_number, '北海道空知郡上富良野町東町');
ok($zip->set_number('0710561')->is_valid_number, '北海道空知郡上富良野町大町');
ok($zip->set_number('0710562')->is_valid_number, '北海道空知郡上富良野町南町');
ok($zip->set_number('0710563')->is_valid_number, '北海道空知郡上富良野町緑町');
ok($zip->set_number('0710564')->is_valid_number, '北海道空知郡上富良野町桜町');
ok($zip->set_number('0710565')->is_valid_number, '北海道空知郡上富良野町丘町');
ok($zip->set_number('0710566')->is_valid_number, '北海道空知郡上富良野町向町');
ok($zip->set_number('0710571')->is_valid_number, '北海道空知郡上富良野町新井牧場');
ok($zip->set_number('0710572')->is_valid_number, '北海道空知郡上富良野町細野農場');
ok($zip->set_number('0710573')->is_valid_number, '北海道空知郡上富良野町松井牧場');
ok($zip->set_number('0710574')->is_valid_number, '北海道空知郡上富良野町第1安井牧場');
ok($zip->set_number('0710575')->is_valid_number, '北海道空知郡上富良野町第2安井牧場');
ok($zip->set_number('0710576')->is_valid_number, '北海道空知郡上富良野町十人牧場');
ok($zip->set_number('0710577')->is_valid_number, '北海道空知郡上富良野町中の沢');
ok($zip->set_number('0710578')->is_valid_number, '北海道空知郡上富良野町山加農場');
ok($zip->set_number('0710579')->is_valid_number, '北海道空知郡上富良野町吹上');
ok($zip->set_number('0710583')->is_valid_number, '北海道空知郡上富良野町津郷農場');
ok($zip->set_number('0710700')->is_valid_number, '北海道空知郡中富良野町以下に掲載がない場合');
ok($zip->set_number('0710704')->is_valid_number, '北海道空知郡中富良野町基線北');
ok($zip->set_number('0710705')->is_valid_number, '北海道空知郡中富良野町西1線北');
ok($zip->set_number('0710706')->is_valid_number, '北海道空知郡中富良野町西2線北');
ok($zip->set_number('0710707')->is_valid_number, '北海道空知郡中富良野町西3線北');
ok($zip->set_number('0710711')->is_valid_number, '北海道空知郡中富良野町ベベルイ(本幸、北13号沢)');
ok($zip->set_number('0710714')->is_valid_number, '北海道空知郡中富良野町宮町');
ok($zip->set_number('0710726')->is_valid_number, '北海道空知郡中富良野町東町');
ok($zip->set_number('0710731')->is_valid_number, '北海道空知郡中富良野町新田中農場');
ok($zip->set_number('0710732')->is_valid_number, '北海道空知郡中富良野町田中農場(鈴和、山仁農場、山仁牧場)');
ok($zip->set_number('0710733')->is_valid_number, '北海道空知郡中富良野町伊藤農場(渋毛牛)');
ok($zip->set_number('0710734')->is_valid_number, '北海道空知郡中富良野町鹿討農場(鹿討)');
ok($zip->set_number('0710735')->is_valid_number, '北海道空知郡中富良野町日進');
ok($zip->set_number('0710736')->is_valid_number, '北海道空知郡中富良野町吉井農場(吉井)');
ok($zip->set_number('0710737')->is_valid_number, '北海道空知郡中富良野町奈江');
ok($zip->set_number('0710742')->is_valid_number, '北海道空知郡中富良野町福原農場(福原)');
ok($zip->set_number('0710751')->is_valid_number, '北海道空知郡中富良野町北町');
ok($zip->set_number('0710752')->is_valid_number, '北海道空知郡中富良野町本町');
ok($zip->set_number('0710753')->is_valid_number, '北海道空知郡中富良野町南町');
ok($zip->set_number('0710754')->is_valid_number, '北海道空知郡中富良野町新町');
ok($zip->set_number('0710755')->is_valid_number, '北海道空知郡中富良野町旭町');
ok($zip->set_number('0710761')->is_valid_number, '北海道空知郡中富良野町西町');
ok($zip->set_number('0710762')->is_valid_number, '北海道空知郡中富良野町丘町');
ok($zip->set_number('0710770')->is_valid_number, '北海道空知郡中富良野町暁町');
ok($zip->set_number('0710771')->is_valid_number, '北海道空知郡中富良野町東1線北');
ok($zip->set_number('0710772')->is_valid_number, '北海道空知郡中富良野町東2線北');
ok($zip->set_number('0710773')->is_valid_number, '北海道空知郡中富良野町東3線北');
ok($zip->set_number('0710774')->is_valid_number, '北海道空知郡中富良野町東4線北');
ok($zip->set_number('0710775')->is_valid_number, '北海道空知郡中富良野町東5線北');
ok($zip->set_number('0710776')->is_valid_number, '北海道空知郡中富良野町東6線北');
ok($zip->set_number('0710777')->is_valid_number, '北海道空知郡中富良野町東7線北');
ok($zip->set_number('0710778')->is_valid_number, '北海道空知郡中富良野町東8線北');
ok($zip->set_number('0710779')->is_valid_number, '北海道空知郡中富良野町東9線北');
ok($zip->set_number('0710780')->is_valid_number, '北海道空知郡中富良野町東10線北');
ok($zip->set_number('0710781')->is_valid_number, '北海道空知郡中富良野町東11線北');
ok($zip->set_number('0711171')->is_valid_number, '北海道旭川市江丹別町清水');
ok($zip->set_number('0711172')->is_valid_number, '北海道旭川市江丹別町拓北');
ok($zip->set_number('0711173')->is_valid_number, '北海道旭川市江丹別町中央');
ok($zip->set_number('0711174')->is_valid_number, '北海道旭川市江丹別町富原');
ok($zip->set_number('0711175')->is_valid_number, '北海道旭川市江丹別町中園');
ok($zip->set_number('0711176')->is_valid_number, '北海道旭川市江丹別町西里');
ok($zip->set_number('0711177')->is_valid_number, '北海道旭川市江丹別町芳野');
ok($zip->set_number('0711200')->is_valid_number, '北海道上川郡鷹栖町以下に掲載がない場合');
ok($zip->set_number('0711201')->is_valid_number, '北海道上川郡鷹栖町南一条');
ok($zip->set_number('0711202')->is_valid_number, '北海道上川郡鷹栖町南二条');
ok($zip->set_number('0711211')->is_valid_number, '北海道上川郡鷹栖町北一条');
ok($zip->set_number('0711221')->is_valid_number, '北海道上川郡鷹栖町北野東一条');
ok($zip->set_number('0711222')->is_valid_number, '北海道上川郡鷹栖町北野東二条');
ok($zip->set_number('0711223')->is_valid_number, '北海道上川郡鷹栖町北野東三条');
ok($zip->set_number('0711224')->is_valid_number, '北海道上川郡鷹栖町北野東四条');
ok($zip->set_number('0711225')->is_valid_number, '北海道上川郡鷹栖町北野東五条');
ok($zip->set_number('0711231')->is_valid_number, '北海道上川郡鷹栖町北野西一条');
ok($zip->set_number('0711232')->is_valid_number, '北海道上川郡鷹栖町北野西二条');
ok($zip->set_number('0711233')->is_valid_number, '北海道上川郡鷹栖町北野西三条');
ok($zip->set_number('0711234')->is_valid_number, '北海道上川郡鷹栖町北野西四条');
ok($zip->set_number('0711235')->is_valid_number, '北海道上川郡鷹栖町北野西五条');
ok($zip->set_number('0711247')->is_valid_number, '北海道上川郡鷹栖町7線');
ok($zip->set_number('0711248')->is_valid_number, '北海道上川郡鷹栖町8線');
ok($zip->set_number('0711249')->is_valid_number, '北海道上川郡鷹栖町9線');
ok($zip->set_number('0711250')->is_valid_number, '北海道上川郡鷹栖町10線');
ok($zip->set_number('0711251')->is_valid_number, '北海道上川郡鷹栖町11線');
ok($zip->set_number('0711252')->is_valid_number, '北海道上川郡鷹栖町12線');
ok($zip->set_number('0711253')->is_valid_number, '北海道上川郡鷹栖町13線');
ok($zip->set_number('0711254')->is_valid_number, '北海道上川郡鷹栖町14線');
ok($zip->set_number('0711255')->is_valid_number, '北海道上川郡鷹栖町15線');
ok($zip->set_number('0711256')->is_valid_number, '北海道上川郡鷹栖町16線');
ok($zip->set_number('0711257')->is_valid_number, '北海道上川郡鷹栖町17線');
ok($zip->set_number('0711258')->is_valid_number, '北海道上川郡鷹栖町18線');
ok($zip->set_number('0711259')->is_valid_number, '北海道上川郡鷹栖町19線');
ok($zip->set_number('0711260')->is_valid_number, '北海道上川郡鷹栖町20線');
ok($zip->set_number('0711261')->is_valid_number, '北海道上川郡鷹栖町21線');
ok($zip->set_number('0711262')->is_valid_number, '北海道上川郡鷹栖町22線');
ok($zip->set_number('0711263')->is_valid_number, '北海道上川郡鷹栖町23線');
ok($zip->set_number('0711264')->is_valid_number, '北海道上川郡鷹栖町24線');
ok($zip->set_number('0711265')->is_valid_number, '北海道上川郡鷹栖町25線');
ok($zip->set_number('0711266')->is_valid_number, '北海道上川郡鷹栖町26線');
ok($zip->set_number('0711267')->is_valid_number, '北海道上川郡鷹栖町27線');
ok($zip->set_number('0711400')->is_valid_number, '北海道上川郡東川町以下に掲載がない場合');
ok($zip->set_number('0711402')->is_valid_number, '北海道上川郡東川町西2号北');
ok($zip->set_number('0711403')->is_valid_number, '北海道上川郡東川町西3号北');
ok($zip->set_number('0711404')->is_valid_number, '北海道上川郡東川町西4号北');
ok($zip->set_number('0711405')->is_valid_number, '北海道上川郡東川町西5号北');
ok($zip->set_number('0711406')->is_valid_number, '北海道上川郡東川町西6号北');
ok($zip->set_number('0711407')->is_valid_number, '北海道上川郡東川町西7号北');
ok($zip->set_number('0711408')->is_valid_number, '北海道上川郡東川町西8号北');
ok($zip->set_number('0711409')->is_valid_number, '北海道上川郡東川町西9号北');
ok($zip->set_number('0711410')->is_valid_number, '北海道上川郡東川町西10号北');
ok($zip->set_number('0711411')->is_valid_number, '北海道上川郡東川町西11号北');
ok($zip->set_number('0711412')->is_valid_number, '北海道上川郡東川町西12号北');
ok($zip->set_number('0711422')->is_valid_number, '北海道上川郡東川町西2号南');
ok($zip->set_number('0711423')->is_valid_number, '北海道上川郡東川町東町');
ok($zip->set_number('0711424')->is_valid_number, '北海道上川郡東川町南町');
ok($zip->set_number('0711425')->is_valid_number, '北海道上川郡東川町西町');
ok($zip->set_number('0711426')->is_valid_number, '北海道上川郡東川町北町');
ok($zip->set_number('0711431')->is_valid_number, '北海道上川郡東川町1号北');
ok($zip->set_number('0711432')->is_valid_number, '北海道上川郡東川町東2号北');
ok($zip->set_number('0711433')->is_valid_number, '北海道上川郡東川町東3号北');
ok($zip->set_number('0711434')->is_valid_number, '北海道上川郡東川町東4号北');
ok($zip->set_number('0711435')->is_valid_number, '北海道上川郡東川町東5号北');
ok($zip->set_number('0711436')->is_valid_number, '北海道上川郡東川町東6号北');
ok($zip->set_number('0711437')->is_valid_number, '北海道上川郡東川町東7号北');
ok($zip->set_number('0711438')->is_valid_number, '北海道上川郡東川町東8号北');
ok($zip->set_number('0711439')->is_valid_number, '北海道上川郡東川町東9号北');
ok($zip->set_number('0711440')->is_valid_number, '北海道上川郡東川町東10号北');
ok($zip->set_number('0711441')->is_valid_number, '北海道上川郡東川町東11号北');
ok($zip->set_number('0711442')->is_valid_number, '北海道上川郡東川町東12号北');
ok($zip->set_number('0711451')->is_valid_number, '北海道上川郡東川町1号南');
ok($zip->set_number('0711452')->is_valid_number, '北海道上川郡東川町東2号南');
ok($zip->set_number('0711453')->is_valid_number, '北海道上川郡東川町東3号南');
ok($zip->set_number('0711454')->is_valid_number, '北海道上川郡東川町東4号南');
ok($zip->set_number('0711455')->is_valid_number, '北海道上川郡東川町東5号南');
ok($zip->set_number('0711456')->is_valid_number, '北海道上川郡東川町東6号南');
ok($zip->set_number('0711457')->is_valid_number, '北海道上川郡東川町東7号南');
ok($zip->set_number('0711458')->is_valid_number, '北海道上川郡東川町東8号南');
ok($zip->set_number('0711459')->is_valid_number, '北海道上川郡東川町東9号南');
ok($zip->set_number('0711460')->is_valid_number, '北海道上川郡東川町東10号南');
ok($zip->set_number('0711461')->is_valid_number, '北海道上川郡東川町東11号南');
ok($zip->set_number('0711462')->is_valid_number, '北海道上川郡東川町北2線東');
ok($zip->set_number('0711463')->is_valid_number, '北海道上川郡東川町北3線東');
ok($zip->set_number('0711464')->is_valid_number, '北海道上川郡東川町進化台');
ok($zip->set_number('0711465')->is_valid_number, '北海道上川郡東川町北5線');
ok($zip->set_number('0711466')->is_valid_number, '北海道上川郡東川町北7線');
ok($zip->set_number('0711467')->is_valid_number, '北海道上川郡東川町北7線東');
ok($zip->set_number('0711471')->is_valid_number, '北海道上川郡東川町ノカナン');
ok($zip->set_number('0711472')->is_valid_number, '北海道上川郡東川町勇駒別');
ok($zip->set_number('0711473')->is_valid_number, '北海道上川郡東川町松山温泉');
ok($zip->set_number('0711474')->is_valid_number, '北海道上川郡美瑛町忠別');
ok($zip->set_number('0711500')->is_valid_number, '北海道上川郡東神楽町以下に掲載がない場合');
ok($zip->set_number('0711501')->is_valid_number, '北海道上川郡東神楽町南一条西');
ok($zip->set_number('0711502')->is_valid_number, '北海道上川郡東神楽町南一条東');
ok($zip->set_number('0711503')->is_valid_number, '北海道上川郡東神楽町南二条西');
ok($zip->set_number('0711504')->is_valid_number, '北海道上川郡東神楽町南二条東');
ok($zip->set_number('0711505')->is_valid_number, '北海道上川郡東神楽町南三条東');
ok($zip->set_number('0711511')->is_valid_number, '北海道上川郡東神楽町北一条西');
ok($zip->set_number('0711512')->is_valid_number, '北海道上川郡東神楽町北一条東');
ok($zip->set_number('0711513')->is_valid_number, '北海道上川郡東神楽町北二条西');
ok($zip->set_number('0711514')->is_valid_number, '北海道上川郡東神楽町北二条東');
ok($zip->set_number('0711515')->is_valid_number, '北海道上川郡東神楽町北三条東');
ok($zip->set_number('0711521')->is_valid_number, '北海道上川郡東神楽町ひじり野北一条');
ok($zip->set_number('0711522')->is_valid_number, '北海道上川郡東神楽町ひじり野北二条');
ok($zip->set_number('0711523')->is_valid_number, '北海道上川郡東神楽町ひじり野南一条');
ok($zip->set_number('0711524')->is_valid_number, '北海道上川郡東神楽町ひじり野南二条');
ok($zip->set_number('0711525')->is_valid_number, '北海道上川郡東神楽町ひじり野南三条');
ok($zip->set_number('0711533')->is_valid_number, '北海道上川郡東神楽町3号');
ok($zip->set_number('0711534')->is_valid_number, '北海道上川郡東神楽町4号');
ok($zip->set_number('0711535')->is_valid_number, '北海道上川郡東神楽町5号');
ok($zip->set_number('0711536')->is_valid_number, '北海道上川郡東神楽町6号');
ok($zip->set_number('0711537')->is_valid_number, '北海道上川郡東神楽町7号');
ok($zip->set_number('0711538')->is_valid_number, '北海道上川郡東神楽町8号');
ok($zip->set_number('0711539')->is_valid_number, '北海道上川郡東神楽町9号');
ok($zip->set_number('0711540')->is_valid_number, '北海道上川郡東神楽町10号');
ok($zip->set_number('0711541')->is_valid_number, '北海道上川郡東神楽町11号');
ok($zip->set_number('0711542')->is_valid_number, '北海道上川郡東神楽町12号');
ok($zip->set_number('0711543')->is_valid_number, '北海道上川郡東神楽町13号');
ok($zip->set_number('0711544')->is_valid_number, '北海道上川郡東神楽町14号');
ok($zip->set_number('0711545')->is_valid_number, '北海道上川郡東神楽町15号');
ok($zip->set_number('0711546')->is_valid_number, '北海道上川郡東神楽町16号');
ok($zip->set_number('0711547')->is_valid_number, '北海道上川郡東神楽町17号');
ok($zip->set_number('0711548')->is_valid_number, '北海道上川郡東神楽町18号');
ok($zip->set_number('0711549')->is_valid_number, '北海道上川郡東神楽町19号');
ok($zip->set_number('0711550')->is_valid_number, '北海道上川郡東神楽町20号');
ok($zip->set_number('0711551')->is_valid_number, '北海道上川郡東神楽町21号');
ok($zip->set_number('0711552')->is_valid_number, '北海道上川郡東神楽町22号');
ok($zip->set_number('0711553')->is_valid_number, '北海道上川郡東神楽町23号');
ok($zip->set_number('0711554')->is_valid_number, '北海道上川郡東神楽町24号');
ok($zip->set_number('0711555')->is_valid_number, '北海道上川郡東神楽町25号');
ok($zip->set_number('0711556')->is_valid_number, '北海道上川郡東神楽町26号');
ok($zip->set_number('0711557')->is_valid_number, '北海道上川郡東神楽町27号');
ok($zip->set_number('0711560')->is_valid_number, '北海道上川郡東神楽町基線');
ok($zip->set_number('0711561')->is_valid_number, '北海道上川郡東神楽町東一線');
ok($zip->set_number('0711562')->is_valid_number, '北海道上川郡東神楽町東二線');
ok($zip->set_number('0711563')->is_valid_number, '北海道上川郡東神楽町東三線');
ok($zip->set_number('0711564')->is_valid_number, '北海道上川郡東神楽町東四線');
ok($zip->set_number('0711565')->is_valid_number, '北海道上川郡東神楽町東五線');
ok($zip->set_number('0711570')->is_valid_number, '北海道上川郡東神楽町南13号');
ok($zip->set_number('0711571')->is_valid_number, '北海道上川郡東神楽町南1番通');
ok($zip->set_number('0711572')->is_valid_number, '北海道上川郡東神楽町南2線');
ok($zip->set_number('0711573')->is_valid_number, '北海道上川郡東神楽町南3線');
ok($zip->set_number('0711574')->is_valid_number, '北海道上川郡東神楽町南4線');
ok($zip->set_number('0711575')->is_valid_number, '北海道上川郡東神楽町南5線');
ok($zip->set_number('0711577')->is_valid_number, '北海道上川郡東神楽町八千代ケ岡');
ok($zip->set_number('0711581')->is_valid_number, '北海道上川郡東神楽町栄岡');
ok($zip->set_number('0711582')->is_valid_number, '北海道上川郡東神楽町志比内');
ok($zip->set_number('0718101')->is_valid_number, '北海道旭川市東鷹栖1条');
ok($zip->set_number('0718102')->is_valid_number, '北海道旭川市東鷹栖2条');
ok($zip->set_number('0718103')->is_valid_number, '北海道旭川市東鷹栖3条');
ok($zip->set_number('0718104')->is_valid_number, '北海道旭川市東鷹栖4条');
ok($zip->set_number('0718111')->is_valid_number, '北海道旭川市東鷹栖東1条');
ok($zip->set_number('0718112')->is_valid_number, '北海道旭川市東鷹栖東2条');
ok($zip->set_number('0718113')->is_valid_number, '北海道旭川市東鷹栖東3条');
ok($zip->set_number('0718114')->is_valid_number, '北海道旭川市東鷹栖東1線');
ok($zip->set_number('0718121')->is_valid_number, '北海道旭川市末広東1条');
ok($zip->set_number('0718122')->is_valid_number, '北海道旭川市末広東2条');
ok($zip->set_number('0718123')->is_valid_number, '北海道旭川市末広東3条');
ok($zip->set_number('0718131')->is_valid_number, '北海道旭川市末広1条');
ok($zip->set_number('0718132')->is_valid_number, '北海道旭川市末広2条');
ok($zip->set_number('0718133')->is_valid_number, '北海道旭川市末広3条');
ok($zip->set_number('0718134')->is_valid_number, '北海道旭川市末広4条');
ok($zip->set_number('0718135')->is_valid_number, '北海道旭川市末広5条');
ok($zip->set_number('0718136')->is_valid_number, '北海道旭川市末広6条');
ok($zip->set_number('0718137')->is_valid_number, '北海道旭川市末広7条');
ok($zip->set_number('0718138')->is_valid_number, '北海道旭川市末広8条');
ok($zip->set_number('0718141')->is_valid_number, '北海道旭川市春光台1条');
ok($zip->set_number('0718142')->is_valid_number, '北海道旭川市春光台2条');
ok($zip->set_number('0718143')->is_valid_number, '北海道旭川市春光台3条');
ok($zip->set_number('0718144')->is_valid_number, '北海道旭川市春光台4条');
ok($zip->set_number('0718145')->is_valid_number, '北海道旭川市春光台5条');
ok($zip->set_number('0718151')->is_valid_number, '北海道旭川市東鷹栖1線');
ok($zip->set_number('0718152')->is_valid_number, '北海道旭川市東鷹栖2線');
ok($zip->set_number('0718153')->is_valid_number, '北海道旭川市東鷹栖3線');
ok($zip->set_number('0718154')->is_valid_number, '北海道旭川市東鷹栖4線');
ok($zip->set_number('0718155')->is_valid_number, '北海道旭川市東鷹栖5線');
ok($zip->set_number('0718156')->is_valid_number, '北海道旭川市東鷹栖6線');
ok($zip->set_number('0718157')->is_valid_number, '北海道旭川市東鷹栖7線');
ok($zip->set_number('0718158')->is_valid_number, '北海道旭川市東鷹栖8線');
ok($zip->set_number('0718159')->is_valid_number, '北海道旭川市東鷹栖9線');
ok($zip->set_number('0718160')->is_valid_number, '北海道旭川市東鷹栖10線');
ok($zip->set_number('0718161')->is_valid_number, '北海道旭川市東鷹栖11線');
ok($zip->set_number('0718162')->is_valid_number, '北海道旭川市東鷹栖12線');
ok($zip->set_number('0718163')->is_valid_number, '北海道旭川市東鷹栖13線');
ok($zip->set_number('0718164')->is_valid_number, '北海道旭川市東鷹栖14線');
ok($zip->set_number('0718165')->is_valid_number, '北海道旭川市東鷹栖15線');
ok($zip->set_number('0718166')->is_valid_number, '北海道旭川市緑台');
ok($zip->set_number('0718171')->is_valid_number, '北海道旭川市東山');
ok($zip->set_number('0720000')->is_valid_number, '北海道美唄市以下に掲載がない場合');
ok($zip->set_number('0720001')->is_valid_number, '北海道美唄市大通東一条北');
ok($zip->set_number('0720002')->is_valid_number, '北海道美唄市東一条北');
ok($zip->set_number('0720003')->is_valid_number, '北海道美唄市東二条北');
ok($zip->set_number('0720004')->is_valid_number, '北海道美唄市東三条北');
ok($zip->set_number('0720005')->is_valid_number, '北海道美唄市東四条北');
ok($zip->set_number('0720006')->is_valid_number, '北海道美唄市東五条北');
ok($zip->set_number('0720007')->is_valid_number, '北海道美唄市東六条北');
ok($zip->set_number('0720008')->is_valid_number, '北海道美唄市癸巳町奔美唄');
ok($zip->set_number('0720009')->is_valid_number, '北海道美唄市癸巳町');
ok($zip->set_number('0720011')->is_valid_number, '北海道美唄市大通東一条南');
ok($zip->set_number('0720012')->is_valid_number, '北海道美唄市東一条南');
ok($zip->set_number('0720013')->is_valid_number, '北海道美唄市東二条南');
ok($zip->set_number('0720014')->is_valid_number, '北海道美唄市東三条南');
ok($zip->set_number('0720015')->is_valid_number, '北海道美唄市東四条南');
ok($zip->set_number('0720016')->is_valid_number, '北海道美唄市東五条南');
ok($zip->set_number('0720017')->is_valid_number, '北海道美唄市東六条南');
ok($zip->set_number('0720021')->is_valid_number, '北海道美唄市大通西一条北');
ok($zip->set_number('0720022')->is_valid_number, '北海道美唄市西一条北');
ok($zip->set_number('0720023')->is_valid_number, '北海道美唄市大通西一条南');
ok($zip->set_number('0720024')->is_valid_number, '北海道美唄市西一条南');
ok($zip->set_number('0720025')->is_valid_number, '北海道美唄市西二条南');
ok($zip->set_number('0720026')->is_valid_number, '北海道美唄市西三条南');
ok($zip->set_number('0720027')->is_valid_number, '北海道美唄市西四条南');
ok($zip->set_number('0720028')->is_valid_number, '北海道美唄市西五条南');
ok($zip->set_number('0720031')->is_valid_number, '北海道美唄市西二条北');
ok($zip->set_number('0720032')->is_valid_number, '北海道美唄市西三条北');
ok($zip->set_number('0720033')->is_valid_number, '北海道美唄市西四条北');
ok($zip->set_number('0720034')->is_valid_number, '北海道美唄市西五条北');
ok($zip->set_number('0720035')->is_valid_number, '北海道美唄市沼の内町中央');
ok($zip->set_number('0720036')->is_valid_number, '北海道美唄市沼の内町南');
ok($zip->set_number('0720037')->is_valid_number, '北海道美唄市沼の内町北');
ok($zip->set_number('0720038')->is_valid_number, '北海道美唄市沼の内町西');
ok($zip->set_number('0720041')->is_valid_number, '北海道美唄市進徳町東');
ok($zip->set_number('0720042')->is_valid_number, '北海道美唄市進徳町');
ok($zip->set_number('0720043')->is_valid_number, '北海道美唄市進徳町西');
ok($zip->set_number('0720044')->is_valid_number, '北海道美唄市一心町');
ok($zip->set_number('0720045')->is_valid_number, '北海道美唄市開発町南');
ok($zip->set_number('0720046')->is_valid_number, '北海道美唄市開発町北');
ok($zip->set_number('0720047')->is_valid_number, '北海道美唄市開発町親和');
ok($zip->set_number('0720051')->is_valid_number, '北海道美唄市上美唄町');
ok($zip->set_number('0720052')->is_valid_number, '北海道美唄市上美唄町東');
ok($zip->set_number('0720053')->is_valid_number, '北海道美唄市上美唄町中央');
ok($zip->set_number('0720054')->is_valid_number, '北海道美唄市上美唄町沼の端');
ok($zip->set_number('0720055')->is_valid_number, '北海道美唄市西美唄町元村');
ok($zip->set_number('0720056')->is_valid_number, '北海道美唄市西美唄町山形');
ok($zip->set_number('0720057')->is_valid_number, '北海道美唄市西美唄町大曲');
ok($zip->set_number('0720058')->is_valid_number, '北海道美唄市西美唄町富樫');
ok($zip->set_number('0720059')->is_valid_number, '北海道美唄市西美唄町元村美富');
ok($zip->set_number('0720801')->is_valid_number, '北海道美唄市東七条北');
ok($zip->set_number('0720802')->is_valid_number, '北海道美唄市東八条北');
ok($zip->set_number('0720803')->is_valid_number, '北海道美唄市東明一条');
ok($zip->set_number('0720804')->is_valid_number, '北海道美唄市東明二条');
ok($zip->set_number('0720805')->is_valid_number, '北海道美唄市東明三条');
ok($zip->set_number('0720806')->is_valid_number, '北海道美唄市東明四条');
ok($zip->set_number('0720807')->is_valid_number, '北海道美唄市東明五条');
ok($zip->set_number('0720808')->is_valid_number, '北海道美唄市東明町');
ok($zip->set_number('0720811')->is_valid_number, '北海道美唄市東七条南');
ok($zip->set_number('0720812')->is_valid_number, '北海道美唄市東八条南');
ok($zip->set_number('0720813')->is_valid_number, '北海道美唄市南美唄町旭町');
ok($zip->set_number('0720814')->is_valid_number, '北海道美唄市南美唄町山の手');
ok($zip->set_number('0720815')->is_valid_number, '北海道美唄市南美唄町南町');
ok($zip->set_number('0720816')->is_valid_number, '北海道美唄市南美唄町仲町');
ok($zip->set_number('0720817')->is_valid_number, '北海道美唄市南美唄町北町');
ok($zip->set_number('0720818')->is_valid_number, '北海道美唄市南美唄町中央通り');
ok($zip->set_number('0720819')->is_valid_number, '北海道美唄市共練町東');
ok($zip->set_number('0720819')->is_valid_number, '北海道美唄市共練町西');
ok($zip->set_number('0720821')->is_valid_number, '北海道美唄市南美唄町上');
ok($zip->set_number('0720822')->is_valid_number, '北海道美唄市南美唄町大通り');
ok($zip->set_number('0720823')->is_valid_number, '北海道美唄市南美唄町下');
ok($zip->set_number('0720824')->is_valid_number, '北海道美唄市南美唄町新富町');
ok($zip->set_number('0720825')->is_valid_number, '北海道美唄市南美唄町桜井町');
ok($zip->set_number('0720826')->is_valid_number, '北海道美唄市南美唄町栄町南');
ok($zip->set_number('0720827')->is_valid_number, '北海道美唄市南美唄町栄町北');
ok($zip->set_number('0720828')->is_valid_number, '北海道美唄市南美唄町西町');
ok($zip->set_number('0720831')->is_valid_number, '北海道美唄市落合町栄町');
ok($zip->set_number('0720832')->is_valid_number, '北海道美唄市落合町本町');
ok($zip->set_number('0720833')->is_valid_number, '北海道美唄市落合町緑が丘');
ok($zip->set_number('0720834')->is_valid_number, '北海道美唄市落合町住吉');
ok($zip->set_number('0720835')->is_valid_number, '北海道美唄市落合町入初');
ok($zip->set_number('0720841')->is_valid_number, '北海道美唄市盤の沢町滝の上');
ok($zip->set_number('0720842')->is_valid_number, '北海道美唄市盤の沢町本町');
ok($zip->set_number('0720843')->is_valid_number, '北海道美唄市盤の沢町高台');
ok($zip->set_number('0720844')->is_valid_number, '北海道美唄市盤の沢町桜が丘');
ok($zip->set_number('0720851')->is_valid_number, '北海道美唄市我路町一条');
ok($zip->set_number('0720852')->is_valid_number, '北海道美唄市我路町二条');
ok($zip->set_number('0720853')->is_valid_number, '北海道美唄市我路町三条');
ok($zip->set_number('0720854')->is_valid_number, '北海道美唄市我路町四条');
ok($zip->set_number('0720855')->is_valid_number, '北海道美唄市我路町公園通り');
ok($zip->set_number('0720856')->is_valid_number, '北海道美唄市我路町新町');
ok($zip->set_number('0720857')->is_valid_number, '北海道美唄市我路町菊水');
ok($zip->set_number('0730000')->is_valid_number, '北海道滝川市以下に掲載がない場合');
ok($zip->set_number('0730001')->is_valid_number, '北海道滝川市北滝の川');
ok($zip->set_number('0730002')->is_valid_number, '北海道滝川市屯田町西');
ok($zip->set_number('0730003')->is_valid_number, '北海道滝川市滝の川町西');
ok($zip->set_number('0730004')->is_valid_number, '北海道滝川市滝の川町東');
ok($zip->set_number('0730005')->is_valid_number, '北海道滝川市二の坂町東');
ok($zip->set_number('0730006')->is_valid_number, '北海道滝川市二の坂町西');
ok($zip->set_number('0730011')->is_valid_number, '北海道滝川市黄金町西');
ok($zip->set_number('0730012')->is_valid_number, '北海道滝川市黄金町東');
ok($zip->set_number('0730013')->is_valid_number, '北海道滝川市南滝の川');
ok($zip->set_number('0730014')->is_valid_number, '北海道滝川市文京町');
ok($zip->set_number('0730015')->is_valid_number, '北海道滝川市朝日町東');
ok($zip->set_number('0730016')->is_valid_number, '北海道滝川市一の坂町東');
ok($zip->set_number('0730017')->is_valid_number, '北海道滝川市一の坂町西');
ok($zip->set_number('0730018')->is_valid_number, '北海道滝川市朝日町西');
ok($zip->set_number('0730021')->is_valid_number, '北海道滝川市本町');
ok($zip->set_number('0730022')->is_valid_number, '北海道滝川市大町');
ok($zip->set_number('0730023')->is_valid_number, '北海道滝川市緑町');
ok($zip->set_number('0730024')->is_valid_number, '北海道滝川市東町');
ok($zip->set_number('0730025')->is_valid_number, '北海道滝川市流通団地');
ok($zip->set_number('0730026')->is_valid_number, '北海道滝川市東滝川');
ok($zip->set_number('0730027')->is_valid_number, '北海道滝川市東滝川町');
ok($zip->set_number('0730031')->is_valid_number, '北海道滝川市栄町');
ok($zip->set_number('0730032')->is_valid_number, '北海道滝川市明神町');
ok($zip->set_number('0730033')->is_valid_number, '北海道滝川市新町');
ok($zip->set_number('0730034')->is_valid_number, '北海道滝川市空知町');
ok($zip->set_number('0730035')->is_valid_number, '北海道滝川市中島町');
ok($zip->set_number('0730036')->is_valid_number, '北海道滝川市花月町');
ok($zip->set_number('0730041')->is_valid_number, '北海道滝川市西滝川');
ok($zip->set_number('0730042')->is_valid_number, '北海道滝川市泉町');
ok($zip->set_number('0730043')->is_valid_number, '北海道滝川市幸町');
ok($zip->set_number('0730044')->is_valid_number, '北海道滝川市西町');
ok($zip->set_number('0730045')->is_valid_number, '北海道滝川市有明町');
ok($zip->set_number('0730046')->is_valid_number, '北海道滝川市扇町');
ok($zip->set_number('0730085')->is_valid_number, '北海道砂川市富平(その他)');
ok($zip->set_number('0730100')->is_valid_number, '北海道砂川市以下に掲載がない場合');
ok($zip->set_number('0730101')->is_valid_number, '北海道砂川市空知太東一条');
ok($zip->set_number('0730102')->is_valid_number, '北海道砂川市空知太東二条');
ok($zip->set_number('0730103')->is_valid_number, '北海道砂川市空知太東三条');
ok($zip->set_number('0730104')->is_valid_number, '北海道砂川市空知太東四条');
ok($zip->set_number('0730105')->is_valid_number, '北海道砂川市空知太東五条');
ok($zip->set_number('0730106')->is_valid_number, '北海道砂川市空知太(その他)');
ok($zip->set_number('0730107')->is_valid_number, '北海道砂川市一の沢');
ok($zip->set_number('0730108')->is_valid_number, '北海道砂川市北光');
ok($zip->set_number('0730111')->is_valid_number, '北海道砂川市晴見一条北');
ok($zip->set_number('0730112')->is_valid_number, '北海道砂川市晴見二条北');
ok($zip->set_number('0730113')->is_valid_number, '北海道砂川市晴見三条北');
ok($zip->set_number('0730114')->is_valid_number, '北海道砂川市晴見四条北');
ok($zip->set_number('0730115')->is_valid_number, '北海道砂川市焼山');
ok($zip->set_number('0730116')->is_valid_number, '北海道砂川市鶉');
ok($zip->set_number('0730117')->is_valid_number, '北海道砂川市南吉野町');
ok($zip->set_number('0730118')->is_valid_number, '北海道砂川市北吉野町');
ok($zip->set_number('0730121')->is_valid_number, '北海道砂川市吉野一条南');
ok($zip->set_number('0730122')->is_valid_number, '北海道砂川市吉野二条南');
ok($zip->set_number('0730123')->is_valid_number, '北海道砂川市吉野三条南');
ok($zip->set_number('0730124')->is_valid_number, '北海道砂川市吉野四条南');
ok($zip->set_number('0730125')->is_valid_number, '北海道砂川市宮城の沢');
ok($zip->set_number('0730126')->is_valid_number, '北海道砂川市東豊沼');
ok($zip->set_number('0730127')->is_valid_number, '北海道砂川市日の出一条南');
ok($zip->set_number('0730131')->is_valid_number, '北海道砂川市東一条南');
ok($zip->set_number('0730132')->is_valid_number, '北海道砂川市東二条南');
ok($zip->set_number('0730133')->is_valid_number, '北海道砂川市東三条南');
ok($zip->set_number('0730134')->is_valid_number, '北海道砂川市東四条南');
ok($zip->set_number('0730135')->is_valid_number, '北海道砂川市東五条南');
ok($zip->set_number('0730136')->is_valid_number, '北海道砂川市東六条南');
ok($zip->set_number('0730137')->is_valid_number, '北海道砂川市東七条南');
ok($zip->set_number('0730138')->is_valid_number, '北海道砂川市豊沼町');
ok($zip->set_number('0730141')->is_valid_number, '北海道砂川市西一条南');
ok($zip->set_number('0730142')->is_valid_number, '北海道砂川市西二条南');
ok($zip->set_number('0730143')->is_valid_number, '北海道砂川市西三条南');
ok($zip->set_number('0730144')->is_valid_number, '北海道砂川市西四条南');
ok($zip->set_number('0730145')->is_valid_number, '北海道砂川市西五条南');
ok($zip->set_number('0730146')->is_valid_number, '北海道砂川市西六条南');
ok($zip->set_number('0730147')->is_valid_number, '北海道砂川市西七条南');
ok($zip->set_number('0730148')->is_valid_number, '北海道砂川市西豊沼');
ok($zip->set_number('0730151')->is_valid_number, '北海道砂川市東一条北');
ok($zip->set_number('0730152')->is_valid_number, '北海道砂川市東二条北');
ok($zip->set_number('0730153')->is_valid_number, '北海道砂川市東三条北');
ok($zip->set_number('0730154')->is_valid_number, '北海道砂川市東四条北');
ok($zip->set_number('0730155')->is_valid_number, '北海道砂川市東五条北');
ok($zip->set_number('0730156')->is_valid_number, '北海道砂川市東六条北');
ok($zip->set_number('0730157')->is_valid_number, '北海道砂川市三砂町');
ok($zip->set_number('0730158')->is_valid_number, '北海道砂川市吉野一条北');
ok($zip->set_number('0730159')->is_valid_number, '北海道砂川市吉野二条北');
ok($zip->set_number('0730161')->is_valid_number, '北海道砂川市西一条北');
ok($zip->set_number('0730162')->is_valid_number, '北海道砂川市西二条北');
ok($zip->set_number('0730163')->is_valid_number, '北海道砂川市西三条北');
ok($zip->set_number('0730164')->is_valid_number, '北海道砂川市西四条北');
ok($zip->set_number('0730165')->is_valid_number, '北海道砂川市西五条北');
ok($zip->set_number('0730166')->is_valid_number, '北海道砂川市西六条北');
ok($zip->set_number('0730167')->is_valid_number, '北海道砂川市西七条北');
ok($zip->set_number('0730168')->is_valid_number, '北海道砂川市西八条北');
ok($zip->set_number('0730171')->is_valid_number, '北海道砂川市空知太西一条');
ok($zip->set_number('0730172')->is_valid_number, '北海道砂川市空知太西二条');
ok($zip->set_number('0730173')->is_valid_number, '北海道砂川市空知太西三条');
ok($zip->set_number('0730174')->is_valid_number, '北海道砂川市空知太西四条');
ok($zip->set_number('0730175')->is_valid_number, '北海道砂川市空知太西五条');
ok($zip->set_number('0730176')->is_valid_number, '北海道砂川市空知太西六条');
ok($zip->set_number('0730177')->is_valid_number, '北海道砂川市空知太(1~349番地)');
ok($zip->set_number('0730178')->is_valid_number, '北海道砂川市袋地');
ok($zip->set_number('0730181')->is_valid_number, '北海道樺戸郡新十津川町弥生(堤防用地)');
ok($zip->set_number('0730200')->is_valid_number, '北海道空知郡上砂川町以下に掲載がない場合');
ok($zip->set_number('0730201')->is_valid_number, '北海道空知郡上砂川町中央');
ok($zip->set_number('0730202')->is_valid_number, '北海道空知郡上砂川町東町');
ok($zip->set_number('0730203')->is_valid_number, '北海道空知郡上砂川町中町');
ok($zip->set_number('0730204')->is_valid_number, '北海道空知郡上砂川町本町');
ok($zip->set_number('0730205')->is_valid_number, '北海道空知郡上砂川町朝駒');
ok($zip->set_number('0730206')->is_valid_number, '北海道空知郡上砂川町東山');
ok($zip->set_number('0730211')->is_valid_number, '北海道空知郡上砂川町東鶉');
ok($zip->set_number('0730212')->is_valid_number, '北海道空知郡上砂川町鶉');
ok($zip->set_number('0730213')->is_valid_number, '北海道空知郡上砂川町緑が丘');
ok($zip->set_number('0730221')->is_valid_number, '北海道空知郡上砂川町鶉本町');
ok($zip->set_number('0730222')->is_valid_number, '北海道空知郡上砂川町下鶉');
ok($zip->set_number('0730400')->is_valid_number, '北海道歌志内市以下に掲載がない場合');
ok($zip->set_number('0730401')->is_valid_number, '北海道歌志内市上歌');
ok($zip->set_number('0730402')->is_valid_number, '北海道歌志内市東光');
ok($zip->set_number('0730403')->is_valid_number, '北海道歌志内市本町');
ok($zip->set_number('0730404')->is_valid_number, '北海道歌志内市歌神');
ok($zip->set_number('0730405')->is_valid_number, '北海道歌志内市神威');
ok($zip->set_number('0730406')->is_valid_number, '北海道歌志内市中村');
ok($zip->set_number('0730407')->is_valid_number, '北海道歌志内市文珠');
ok($zip->set_number('0731100')->is_valid_number, '北海道樺戸郡新十津川町以下に掲載がない場合');
ok($zip->set_number('0731101')->is_valid_number, '北海道樺戸郡新十津川町士寸');
ok($zip->set_number('0731102')->is_valid_number, '北海道樺戸郡新十津川町大和');
ok($zip->set_number('0731103')->is_valid_number, '北海道樺戸郡新十津川町中央');
ok($zip->set_number('0731104')->is_valid_number, '北海道樺戸郡新十津川町弥生(その他)');
ok($zip->set_number('0731105')->is_valid_number, '北海道樺戸郡新十津川町花月');
ok($zip->set_number('0731106')->is_valid_number, '北海道樺戸郡新十津川町総進');
ok($zip->set_number('0731107')->is_valid_number, '北海道樺戸郡新十津川町トップ');
ok($zip->set_number('0731321')->is_valid_number, '北海道樺戸郡新十津川町学園');
ok($zip->set_number('0731322')->is_valid_number, '北海道樺戸郡新十津川町吉野');
ok($zip->set_number('0731323')->is_valid_number, '北海道樺戸郡新十津川町幌加');
ok($zip->set_number('0740000')->is_valid_number, '北海道深川市以下に掲載がない場合');
ok($zip->set_number('0740001')->is_valid_number, '北海道深川市一条');
ok($zip->set_number('0740002')->is_valid_number, '北海道深川市二条');
ok($zip->set_number('0740003')->is_valid_number, '北海道深川市三条');
ok($zip->set_number('0740004')->is_valid_number, '北海道深川市四条');
ok($zip->set_number('0740005')->is_valid_number, '北海道深川市五条');
ok($zip->set_number('0740006')->is_valid_number, '北海道深川市六条');
ok($zip->set_number('0740007')->is_valid_number, '北海道深川市七条');
ok($zip->set_number('0740008')->is_valid_number, '北海道深川市八条');
ok($zip->set_number('0740009')->is_valid_number, '北海道深川市九条');
ok($zip->set_number('0740011')->is_valid_number, '北海道深川市緑町');
ok($zip->set_number('0740012')->is_valid_number, '北海道深川市西町');
ok($zip->set_number('0740013')->is_valid_number, '北海道深川市文光町');
ok($zip->set_number('0740014')->is_valid_number, '北海道深川市開西町');
ok($zip->set_number('0740015')->is_valid_number, '北海道深川市メム(芽生)');
ok($zip->set_number('0740021')->is_valid_number, '北海道深川市稲穂町');
ok($zip->set_number('0740022')->is_valid_number, '北海道深川市北光町');
ok($zip->set_number('0740023')->is_valid_number, '北海道深川市太子町');
ok($zip->set_number('0740024')->is_valid_number, '北海道深川市新光町');
ok($zip->set_number('0740025')->is_valid_number, '北海道深川市錦町');
ok($zip->set_number('0740026')->is_valid_number, '北海道深川市錦町西');
ok($zip->set_number('0740027')->is_valid_number, '北海道深川市錦町北');
ok($zip->set_number('0740028')->is_valid_number, '北海道深川市一已町');
ok($zip->set_number('0740031')->is_valid_number, '北海道深川市あけぼの町');
ok($zip->set_number('0740141')->is_valid_number, '北海道深川市多度志');
ok($zip->set_number('0740142')->is_valid_number, '北海道深川市宇摩');
ok($zip->set_number('0740143')->is_valid_number, '北海道深川市ウッカ');
ok($zip->set_number('0740144')->is_valid_number, '北海道深川市鷹泊');
ok($zip->set_number('0740145')->is_valid_number, '北海道深川市幌内');
ok($zip->set_number('0740146')->is_valid_number, '北海道深川市湯内');
ok($zip->set_number('0740147')->is_valid_number, '北海道深川市多度志南');
ok($zip->set_number('0740400')->is_valid_number, '北海道雨竜郡幌加内町以下に掲載がない場合');
ok($zip->set_number('0740401')->is_valid_number, '北海道雨竜郡幌加内町平和');
ok($zip->set_number('0740402')->is_valid_number, '北海道雨竜郡幌加内町新成生');
ok($zip->set_number('0740403')->is_valid_number, '北海道雨竜郡幌加内町下幌加内');
ok($zip->set_number('0740404')->is_valid_number, '北海道雨竜郡幌加内町沼牛');
ok($zip->set_number('0740405')->is_valid_number, '北海道雨竜郡幌加内町弥運内');
ok($zip->set_number('0740411')->is_valid_number, '北海道雨竜郡幌加内町幌加内');
ok($zip->set_number('0740412')->is_valid_number, '北海道雨竜郡幌加内町親和');
ok($zip->set_number('0740413')->is_valid_number, '北海道雨竜郡幌加内町雨煙内');
ok($zip->set_number('0740414')->is_valid_number, '北海道雨竜郡幌加内町清月');
ok($zip->set_number('0740415')->is_valid_number, '北海道雨竜郡幌加内町長留内');
ok($zip->set_number('0740421')->is_valid_number, '北海道雨竜郡幌加内町東栄');
ok($zip->set_number('0740422')->is_valid_number, '北海道雨竜郡幌加内町振興');
ok($zip->set_number('0740423')->is_valid_number, '北海道雨竜郡幌加内町上幌加内');
ok($zip->set_number('0740424')->is_valid_number, '北海道雨竜郡幌加内町雨煙別');
ok($zip->set_number('0740425')->is_valid_number, '北海道雨竜郡幌加内町政和第一');
ok($zip->set_number('0740426')->is_valid_number, '北海道雨竜郡幌加内町政和第二');
ok($zip->set_number('0740427')->is_valid_number, '北海道雨竜郡幌加内町政和第三');
ok($zip->set_number('0740741')->is_valid_number, '北海道雨竜郡幌加内町母子里');
ok($zip->set_number('0740742')->is_valid_number, '北海道雨竜郡幌加内町朱鞠内');
ok($zip->set_number('0740743')->is_valid_number, '北海道雨竜郡幌加内町共栄');
ok($zip->set_number('0740744')->is_valid_number, '北海道雨竜郡幌加内町大曲');
ok($zip->set_number('0740745')->is_valid_number, '北海道雨竜郡幌加内町北星');
ok($zip->set_number('0740746')->is_valid_number, '北海道雨竜郡幌加内町添牛内');
ok($zip->set_number('0740747')->is_valid_number, '北海道雨竜郡幌加内町新富');
ok($zip->set_number('0741161')->is_valid_number, '北海道深川市音江町(更進)');
ok($zip->set_number('0741162')->is_valid_number, '北海道深川市音江町(菊丘)');
ok($zip->set_number('0741163')->is_valid_number, '北海道深川市音江町(吉住)');
ok($zip->set_number('0741164')->is_valid_number, '北海道深川市音江町(国見23~298番地)');
ok($zip->set_number('0741181')->is_valid_number, '北海道旭川市神居町西丘(その他)');
ok($zip->set_number('0741182')->is_valid_number, '北海道旭川市神居町豊里');
ok($zip->set_number('0741271')->is_valid_number, '北海道深川市音江町(広里)');
ok($zip->set_number('0741271')->is_valid_number, '北海道深川市広里町(1~5丁目)');
ok($zip->set_number('0741272')->is_valid_number, '北海道深川市音江町(国見その他)');
ok($zip->set_number('0741273')->is_valid_number, '北海道深川市音江町(1~2丁目)');
ok($zip->set_number('0741273')->is_valid_number, '北海道深川市音江町(音江)');
ok($zip->set_number('0741274')->is_valid_number, '北海道深川市音江町(豊泉)');
ok($zip->set_number('0741275')->is_valid_number, '北海道深川市音江町(向陽)');
ok($zip->set_number('0741276')->is_valid_number, '北海道深川市音江町(稲田)');
ok($zip->set_number('0750000')->is_valid_number, '北海道芦別市以下に掲載がない場合');
ok($zip->set_number('0750001')->is_valid_number, '北海道芦別市北一条西');
ok($zip->set_number('0750002')->is_valid_number, '北海道芦別市北二条西');
ok($zip->set_number('0750003')->is_valid_number, '北海道芦別市北三条西');
ok($zip->set_number('0750004')->is_valid_number, '北海道芦別市北四条西');
ok($zip->set_number('0750005')->is_valid_number, '北海道芦別市北五条西');
ok($zip->set_number('0750006')->is_valid_number, '北海道芦別市北六条西');
ok($zip->set_number('0750007')->is_valid_number, '北海道芦別市北七条西');
ok($zip->set_number('0750011')->is_valid_number, '北海道芦別市北一条東');
ok($zip->set_number('0750012')->is_valid_number, '北海道芦別市北二条東');
ok($zip->set_number('0750013')->is_valid_number, '北海道芦別市北三条東');
ok($zip->set_number('0750014')->is_valid_number, '北海道芦別市北四条東');
ok($zip->set_number('0750015')->is_valid_number, '北海道芦別市北五条東');
ok($zip->set_number('0750016')->is_valid_number, '北海道芦別市北六条東');
ok($zip->set_number('0750017')->is_valid_number, '北海道芦別市福住町');
ok($zip->set_number('0750018')->is_valid_number, '北海道芦別市常磐町');
ok($zip->set_number('0750019')->is_valid_number, '北海道芦別市高根町');
ok($zip->set_number('0750021')->is_valid_number, '北海道芦別市南一条西');
ok($zip->set_number('0750031')->is_valid_number, '北海道芦別市南一条東');
ok($zip->set_number('0750032')->is_valid_number, '北海道芦別市南二条東');
ok($zip->set_number('0750033')->is_valid_number, '北海道芦別市南三条東');
ok($zip->set_number('0750034')->is_valid_number, '北海道芦別市幌内');
ok($zip->set_number('0750035')->is_valid_number, '北海道芦別市旭町油谷');
ok($zip->set_number('0750036')->is_valid_number, '北海道芦別市旭町');
ok($zip->set_number('0750041')->is_valid_number, '北海道芦別市本町');
ok($zip->set_number('0750161')->is_valid_number, '北海道芦別市西芦別町');
ok($zip->set_number('0750162')->is_valid_number, '北海道芦別市東頼城町');
ok($zip->set_number('0750163')->is_valid_number, '北海道芦別市緑泉町');
ok($zip->set_number('0750164')->is_valid_number, '北海道芦別市頼城町');
ok($zip->set_number('0750165')->is_valid_number, '北海道芦別市青木沢');
ok($zip->set_number('0750166')->is_valid_number, '北海道芦別市川岸');
ok($zip->set_number('0750167')->is_valid_number, '北海道芦別市中の丘町');
ok($zip->set_number('0750251')->is_valid_number, '北海道芦別市新城町');
ok($zip->set_number('0750252')->is_valid_number, '北海道芦別市黄金町');
ok($zip->set_number('0750253')->is_valid_number, '北海道芦別市豊岡町');
ok($zip->set_number('0750254')->is_valid_number, '北海道芦別市豊岡');
ok($zip->set_number('0760000')->is_valid_number, '北海道富良野市以下に掲載がない場合');
ok($zip->set_number('0760001')->is_valid_number, '北海道富良野市北扇山');
ok($zip->set_number('0760002')->is_valid_number, '北海道富良野市南扇山');
ok($zip->set_number('0760003')->is_valid_number, '北海道富良野市布部石綿');
ok($zip->set_number('0760004')->is_valid_number, '北海道富良野市布部市街地');
ok($zip->set_number('0760005')->is_valid_number, '北海道富良野市布部一');
ok($zip->set_number('0760006')->is_valid_number, '北海道富良野市西扇山');
ok($zip->set_number('0760007')->is_valid_number, '北海道富良野市南町');
ok($zip->set_number('0760008')->is_valid_number, '北海道富良野市扇町');
ok($zip->set_number('0760011')->is_valid_number, '北海道富良野市末広町');
ok($zip->set_number('0760012')->is_valid_number, '北海道富良野市下五区');
ok($zip->set_number('0760013')->is_valid_number, '北海道富良野市中五区');
ok($zip->set_number('0760014')->is_valid_number, '北海道富良野市上五区');
ok($zip->set_number('0760015')->is_valid_number, '北海道富良野市上御料');
ok($zip->set_number('0760016')->is_valid_number, '北海道富良野市中御料');
ok($zip->set_number('0760017')->is_valid_number, '北海道富良野市下御料');
ok($zip->set_number('0760018')->is_valid_number, '北海道富良野市弥生町');
ok($zip->set_number('0760021')->is_valid_number, '北海道富良野市緑町');
ok($zip->set_number('0760022')->is_valid_number, '北海道富良野市若葉町');
ok($zip->set_number('0760023')->is_valid_number, '北海道富良野市栄町');
ok($zip->set_number('0760024')->is_valid_number, '北海道富良野市幸町');
ok($zip->set_number('0760025')->is_valid_number, '北海道富良野市日の出町');
ok($zip->set_number('0760026')->is_valid_number, '北海道富良野市朝日町');
ok($zip->set_number('0760027')->is_valid_number, '北海道富良野市花園町');
ok($zip->set_number('0760028')->is_valid_number, '北海道富良野市錦町');
ok($zip->set_number('0760031')->is_valid_number, '北海道富良野市本町');
ok($zip->set_number('0760032')->is_valid_number, '北海道富良野市若松町');
ok($zip->set_number('0760033')->is_valid_number, '北海道富良野市新富町');
ok($zip->set_number('0760034')->is_valid_number, '北海道富良野市北の峰町');
ok($zip->set_number('0760035')->is_valid_number, '北海道富良野市学田三区');
ok($zip->set_number('0760036')->is_valid_number, '北海道富良野市島ノ下');
ok($zip->set_number('0760037')->is_valid_number, '北海道富良野市西町');
ok($zip->set_number('0760038')->is_valid_number, '北海道富良野市桂木町');
ok($zip->set_number('0760039')->is_valid_number, '北海道富良野市信濃沢');
ok($zip->set_number('0760041')->is_valid_number, '北海道富良野市東鳥沼');
ok($zip->set_number('0760042')->is_valid_number, '北海道富良野市西鳥沼');
ok($zip->set_number('0760043')->is_valid_number, '北海道富良野市南大沼');
ok($zip->set_number('0760044')->is_valid_number, '北海道富良野市北大沼');
ok($zip->set_number('0760045')->is_valid_number, '北海道富良野市東学田二区');
ok($zip->set_number('0760046')->is_valid_number, '北海道富良野市北斗町');
ok($zip->set_number('0760047')->is_valid_number, '北海道富良野市西学田二区');
ok($zip->set_number('0760048')->is_valid_number, '北海道富良野市清水山');
ok($zip->set_number('0760050')->is_valid_number, '北海道富良野市東雲町');
ok($zip->set_number('0760051')->is_valid_number, '北海道富良野市東麻町');
ok($zip->set_number('0760052')->is_valid_number, '北海道富良野市南麻町');
ok($zip->set_number('0760053')->is_valid_number, '北海道富良野市東町');
ok($zip->set_number('0760054')->is_valid_number, '北海道富良野市春日町');
ok($zip->set_number('0760055')->is_valid_number, '北海道富良野市西麻町');
ok($zip->set_number('0760056')->is_valid_number, '北海道富良野市瑞穂町');
ok($zip->set_number('0760057')->is_valid_number, '北海道富良野市住吉町');
ok($zip->set_number('0760058')->is_valid_number, '北海道富良野市新光町');
ok($zip->set_number('0760059')->is_valid_number, '北海道富良野市北麻町');
ok($zip->set_number('0760081')->is_valid_number, '北海道芦別市泉');
ok($zip->set_number('0760161')->is_valid_number, '北海道富良野市麓郷市街地');
ok($zip->set_number('0760162')->is_valid_number, '北海道富良野市東麓郷');
ok($zip->set_number('0760163')->is_valid_number, '北海道富良野市西麓郷');
ok($zip->set_number('0760164')->is_valid_number, '北海道富良野市南麓郷');
ok($zip->set_number('0760165')->is_valid_number, '北海道富良野市北麓郷');
ok($zip->set_number('0760171')->is_valid_number, '北海道富良野市布礼別市街地');
ok($zip->set_number('0760172')->is_valid_number, '北海道富良野市東布礼別');
ok($zip->set_number('0760173')->is_valid_number, '北海道富良野市西布礼別');
ok($zip->set_number('0760174')->is_valid_number, '北海道富良野市南布礼別');
ok($zip->set_number('0760175')->is_valid_number, '北海道富良野市北布礼別');
ok($zip->set_number('0760176')->is_valid_number, '北海道富良野市中布礼別');
ok($zip->set_number('0760181')->is_valid_number, '北海道富良野市東富丘');
ok($zip->set_number('0760182')->is_valid_number, '北海道富良野市西富丘');
ok($zip->set_number('0760183')->is_valid_number, '北海道富良野市富丘更生');
ok($zip->set_number('0760184')->is_valid_number, '北海道富良野市八幡丘');
ok($zip->set_number('0760201')->is_valid_number, '北海道富良野市西達布');
ok($zip->set_number('0760202')->is_valid_number, '北海道富良野市東山(その他)');
ok($zip->set_number('0760203')->is_valid_number, '北海道富良野市老節布');
ok($zip->set_number('0760204')->is_valid_number, '北海道富良野市平沢');
ok($zip->set_number('0770000')->is_valid_number, '北海道留萌市以下に掲載がない場合');
ok($zip->set_number('0770001')->is_valid_number, '北海道留萌市三泊町');
ok($zip->set_number('0770002')->is_valid_number, '北海道留萌市塩見町');
ok($zip->set_number('0770003')->is_valid_number, '北海道留萌市春日町');
ok($zip->set_number('0770004')->is_valid_number, '北海道留萌市元町');
ok($zip->set_number('0770005')->is_valid_number, '北海道留萌市船場町');
ok($zip->set_number('0770006')->is_valid_number, '北海道留萌市末広町');
ok($zip->set_number('0770007')->is_valid_number, '北海道留萌市栄町');
ok($zip->set_number('0770011')->is_valid_number, '北海道留萌市東雲町');
ok($zip->set_number('0770012')->is_valid_number, '北海道留萌市大和田');
ok($zip->set_number('0770013')->is_valid_number, '北海道留萌市潮静');
ok($zip->set_number('0770013')->is_valid_number, '北海道留萌市留萌原野(1~12線)');
ok($zip->set_number('0770014')->is_valid_number, '北海道留萌市南町');
ok($zip->set_number('0770015')->is_valid_number, '北海道留萌市緑ケ丘町');
ok($zip->set_number('0770016')->is_valid_number, '北海道留萌市元川町');
ok($zip->set_number('0770021')->is_valid_number, '北海道留萌市高砂町');
ok($zip->set_number('0770022')->is_valid_number, '北海道留萌市堀川町');
ok($zip->set_number('0770023')->is_valid_number, '北海道留萌市五十嵐町');
ok($zip->set_number('0770024')->is_valid_number, '北海道留萌市千鳥町');
ok($zip->set_number('0770025')->is_valid_number, '北海道留萌市野本町');
ok($zip->set_number('0770026')->is_valid_number, '北海道留萌市泉町');
ok($zip->set_number('0770027')->is_valid_number, '北海道留萌市住之江町');
ok($zip->set_number('0770028')->is_valid_number, '北海道留萌市花園町');
ok($zip->set_number('0770031')->is_valid_number, '北海道留萌市幸町');
ok($zip->set_number('0770032')->is_valid_number, '北海道留萌市宮園町');
ok($zip->set_number('0770033')->is_valid_number, '北海道留萌市見晴町');
ok($zip->set_number('0770034')->is_valid_number, '北海道留萌市平和台');
ok($zip->set_number('0770035')->is_valid_number, '北海道留萌市礼受町');
ok($zip->set_number('0770036')->is_valid_number, '北海道留萌市浜中町');
ok($zip->set_number('0770037')->is_valid_number, '北海道留萌市沖見町');
ok($zip->set_number('0770038')->is_valid_number, '北海道留萌市寿町');
ok($zip->set_number('0770041')->is_valid_number, '北海道留萌市明元町');
ok($zip->set_number('0770042')->is_valid_number, '北海道留萌市開運町');
ok($zip->set_number('0770043')->is_valid_number, '北海道留萌市旭町');
ok($zip->set_number('0770044')->is_valid_number, '北海道留萌市錦町');
ok($zip->set_number('0770045')->is_valid_number, '北海道留萌市本町');
ok($zip->set_number('0770046')->is_valid_number, '北海道留萌市港町');
ok($zip->set_number('0770047')->is_valid_number, '北海道留萌市瀬越町');
ok($zip->set_number('0770048')->is_valid_number, '北海道留萌市大町');
ok($zip->set_number('0770131')->is_valid_number, '北海道増毛郡増毛町阿分');
ok($zip->set_number('0770132')->is_valid_number, '北海道増毛郡増毛町舎熊(その他)');
ok($zip->set_number('0770133')->is_valid_number, '北海道増毛郡増毛町信砂');
ok($zip->set_number('0770134')->is_valid_number, '北海道増毛郡増毛町御料');
ok($zip->set_number('0770200')->is_valid_number, '北海道増毛郡増毛町以下に掲載がない場合');
ok($zip->set_number('0770201')->is_valid_number, '北海道増毛郡増毛町永寿町');
ok($zip->set_number('0770202')->is_valid_number, '北海道増毛郡増毛町野塚町');
ok($zip->set_number('0770203')->is_valid_number, '北海道増毛郡増毛町稲葉海岸町');
ok($zip->set_number('0770204')->is_valid_number, '北海道増毛郡増毛町稲葉町');
ok($zip->set_number('0770205')->is_valid_number, '北海道増毛郡増毛町弁天町');
ok($zip->set_number('0770206')->is_valid_number, '北海道増毛郡増毛町中歌');
ok($zip->set_number('0770207')->is_valid_number, '北海道増毛郡増毛町箸別');
ok($zip->set_number('0770208')->is_valid_number, '北海道増毛郡増毛町湯の沢');
ok($zip->set_number('0770209')->is_valid_number, '北海道増毛郡増毛町舎熊(917番地)');
ok($zip->set_number('0770211')->is_valid_number, '北海道増毛郡増毛町暑寒海岸町');
ok($zip->set_number('0770212')->is_valid_number, '北海道増毛郡増毛町七源町');
ok($zip->set_number('0770213')->is_valid_number, '北海道増毛郡増毛町畠中北町');
ok($zip->set_number('0770214')->is_valid_number, '北海道増毛郡増毛町畠中町');
ok($zip->set_number('0770215')->is_valid_number, '北海道増毛郡増毛町暑寒町');
ok($zip->set_number('0770216')->is_valid_number, '北海道増毛郡増毛町暑寒沢');
ok($zip->set_number('0770217')->is_valid_number, '北海道増毛郡増毛町別苅');
ok($zip->set_number('0770218')->is_valid_number, '北海道増毛郡増毛町栄町');
ok($zip->set_number('0770221')->is_valid_number, '北海道増毛郡増毛町港町');
ok($zip->set_number('0770222')->is_valid_number, '北海道増毛郡増毛町見晴町');
ok($zip->set_number('0770223')->is_valid_number, '北海道増毛郡増毛町南永寿町');
ok($zip->set_number('0770224')->is_valid_number, '北海道増毛郡増毛町南畠中町');
ok($zip->set_number('0770225')->is_valid_number, '北海道増毛郡増毛町南暑寒町');
ok($zip->set_number('0770341')->is_valid_number, '北海道増毛郡増毛町雄冬');
ok($zip->set_number('0770344')->is_valid_number, '北海道増毛郡増毛町岩老');
ok($zip->set_number('0770345')->is_valid_number, '北海道増毛郡増毛町岩尾');
ok($zip->set_number('0770351')->is_valid_number, '北海道石狩市浜益区雄冬');
ok($zip->set_number('0770461')->is_valid_number, '北海道留萌郡小平町川上');
ok($zip->set_number('0770462')->is_valid_number, '北海道留萌郡小平町滝下');
ok($zip->set_number('0770463')->is_valid_number, '北海道留萌郡小平町達布');
ok($zip->set_number('0770464')->is_valid_number, '北海道留萌郡小平町住吉');
ok($zip->set_number('0770465')->is_valid_number, '北海道留萌郡小平町寧楽');
ok($zip->set_number('0770466')->is_valid_number, '北海道留萌郡小平町平和(2区)');
ok($zip->set_number('0780151')->is_valid_number, '北海道深川市納内町');
ok($zip->set_number('0780152')->is_valid_number, '北海道深川市音江町(内園)');
ok($zip->set_number('0780153')->is_valid_number, '北海道深川市納内町北');
ok($zip->set_number('0780154')->is_valid_number, '北海道深川市納内町グリーンタウン');
ok($zip->set_number('0780185')->is_valid_number, '北海道旭川市神居町神居古潭');
ok($zip->set_number('0780186')->is_valid_number, '北海道旭川市神居町西丘(8~22番地)');
ok($zip->set_number('0780300')->is_valid_number, '北海道上川郡比布町以下に掲載がない場合');
ok($zip->set_number('0780310')->is_valid_number, '北海道上川郡比布町基線');
ok($zip->set_number('0780311')->is_valid_number, '北海道上川郡比布町南1線');
ok($zip->set_number('0780321')->is_valid_number, '北海道上川郡比布町北1線');
ok($zip->set_number('0780322')->is_valid_number, '北海道上川郡比布町北2線');
ok($zip->set_number('0780323')->is_valid_number, '北海道上川郡比布町北3線');
ok($zip->set_number('0780324')->is_valid_number, '北海道上川郡比布町北4線');
ok($zip->set_number('0780325')->is_valid_number, '北海道上川郡比布町北5線');
ok($zip->set_number('0780326')->is_valid_number, '北海道上川郡比布町北6線');
ok($zip->set_number('0780327')->is_valid_number, '北海道上川郡比布町北7線');
ok($zip->set_number('0780328')->is_valid_number, '北海道上川郡比布町北8線');
ok($zip->set_number('0780329')->is_valid_number, '北海道上川郡比布町北9線');
ok($zip->set_number('0780330')->is_valid_number, '北海道上川郡比布町北10線');
ok($zip->set_number('0780331')->is_valid_number, '北海道上川郡比布町北11線');
ok($zip->set_number('0780332')->is_valid_number, '北海道上川郡比布町北12線');
ok($zip->set_number('0780333')->is_valid_number, '北海道上川郡比布町北13線');
ok($zip->set_number('0780334')->is_valid_number, '北海道上川郡比布町北14線');
ok($zip->set_number('0780335')->is_valid_number, '北海道上川郡比布町北15線');
ok($zip->set_number('0780341')->is_valid_number, '北海道上川郡比布町市街地');
ok($zip->set_number('0780342')->is_valid_number, '北海道上川郡比布町西町');
ok($zip->set_number('0780343')->is_valid_number, '北海道上川郡比布町中町');
ok($zip->set_number('0780344')->is_valid_number, '北海道上川郡比布町緑町');
ok($zip->set_number('0780345')->is_valid_number, '北海道上川郡比布町南町');
ok($zip->set_number('0780346')->is_valid_number, '北海道上川郡比布町新町');
ok($zip->set_number('0780347')->is_valid_number, '北海道上川郡比布町東町');
ok($zip->set_number('0780348')->is_valid_number, '北海道上川郡比布町北町');
ok($zip->set_number('0780349')->is_valid_number, '北海道上川郡比布町寿町');
ok($zip->set_number('0781271')->is_valid_number, '北海道旭川市東旭川町東桜岡(その他)');
ok($zip->set_number('0781272')->is_valid_number, '北海道旭川市東旭川町豊田(その他)');
ok($zip->set_number('0781273')->is_valid_number, '北海道旭川市東旭川町米原');
ok($zip->set_number('0781274')->is_valid_number, '北海道旭川市東旭川町瑞穂');
ok($zip->set_number('0781300')->is_valid_number, '北海道上川郡当麻町以下に掲載がない場合');
ok($zip->set_number('0781303')->is_valid_number, '北海道上川郡当麻町三条西');
ok($zip->set_number('0781304')->is_valid_number, '北海道上川郡当麻町四条西');
ok($zip->set_number('0781305')->is_valid_number, '北海道上川郡当麻町五条西');
ok($zip->set_number('0781306')->is_valid_number, '北海道上川郡当麻町六条西');
ok($zip->set_number('0781313')->is_valid_number, '北海道上川郡当麻町三条東');
ok($zip->set_number('0781314')->is_valid_number, '北海道上川郡当麻町四条東');
ok($zip->set_number('0781315')->is_valid_number, '北海道上川郡当麻町五条東');
ok($zip->set_number('0781316')->is_valid_number, '北海道上川郡当麻町六条東');
ok($zip->set_number('0781324')->is_valid_number, '北海道上川郡当麻町四条南');
ok($zip->set_number('0781331')->is_valid_number, '北海道上川郡当麻町中央');
ok($zip->set_number('0781332')->is_valid_number, '北海道上川郡当麻町宇園別');
ok($zip->set_number('0781333')->is_valid_number, '北海道上川郡当麻町伊香牛');
ok($zip->set_number('0781334')->is_valid_number, '北海道上川郡当麻町北星');
ok($zip->set_number('0781335')->is_valid_number, '北海道上川郡当麻町緑郷');
ok($zip->set_number('0781337')->is_valid_number, '北海道上川郡当麻町東');
ok($zip->set_number('0781341')->is_valid_number, '北海道上川郡当麻町開明');
ok($zip->set_number('0781400')->is_valid_number, '北海道上川郡愛別町以下に掲載がない場合');
ok($zip->set_number('0781401')->is_valid_number, '北海道上川郡愛別町愛別');
ok($zip->set_number('0781402')->is_valid_number, '北海道上川郡愛別町東町');
ok($zip->set_number('0781403')->is_valid_number, '北海道上川郡愛別町南町');
ok($zip->set_number('0781404')->is_valid_number, '北海道上川郡愛別町北町');
ok($zip->set_number('0781405')->is_valid_number, '北海道上川郡愛別町本町');
ok($zip->set_number('0781411')->is_valid_number, '北海道上川郡愛別町金富');
ok($zip->set_number('0781412')->is_valid_number, '北海道上川郡愛別町厚生');
ok($zip->set_number('0781413')->is_valid_number, '北海道上川郡愛別町伏古');
ok($zip->set_number('0781414')->is_valid_number, '北海道上川郡愛別町協和');
ok($zip->set_number('0781415')->is_valid_number, '北海道上川郡愛別町徳星');
ok($zip->set_number('0781651')->is_valid_number, '北海道上川郡愛別町豊里');
ok($zip->set_number('0781652')->is_valid_number, '北海道上川郡愛別町中央');
ok($zip->set_number('0781653')->is_valid_number, '北海道上川郡愛別町愛山');
ok($zip->set_number('0781654')->is_valid_number, '北海道上川郡愛別町愛山町');
ok($zip->set_number('0781700')->is_valid_number, '北海道上川郡上川町以下に掲載がない場合');
ok($zip->set_number('0781701')->is_valid_number, '北海道上川郡上川町層雲峡');
ok($zip->set_number('0781711')->is_valid_number, '北海道上川郡上川町清川');
ok($zip->set_number('0781712')->is_valid_number, '北海道上川郡上川町白川');
ok($zip->set_number('0781721')->is_valid_number, '北海道上川郡上川町菊水');
ok($zip->set_number('0781722')->is_valid_number, '北海道上川郡上川町新光町');
ok($zip->set_number('0781731')->is_valid_number, '北海道上川郡上川町東雲');
ok($zip->set_number('0781732')->is_valid_number, '北海道上川郡上川町共進');
ok($zip->set_number('0781733')->is_valid_number, '北海道上川郡上川町栄町');
ok($zip->set_number('0781741')->is_valid_number, '北海道上川郡上川町中央町');
ok($zip->set_number('0781742')->is_valid_number, '北海道上川郡上川町西町');
ok($zip->set_number('0781743')->is_valid_number, '北海道上川郡上川町花園町');
ok($zip->set_number('0781744')->is_valid_number, '北海道上川郡上川町北町');
ok($zip->set_number('0781751')->is_valid_number, '北海道上川郡上川町本町');
ok($zip->set_number('0781752')->is_valid_number, '北海道上川郡上川町川端町');
ok($zip->set_number('0781753')->is_valid_number, '北海道上川郡上川町南町');
ok($zip->set_number('0781761')->is_valid_number, '北海道上川郡上川町旭町');
ok($zip->set_number('0781762')->is_valid_number, '北海道上川郡上川町新町');
ok($zip->set_number('0781763')->is_valid_number, '北海道上川郡上川町東町');
ok($zip->set_number('0781771')->is_valid_number, '北海道上川郡上川町中越');
ok($zip->set_number('0781772')->is_valid_number, '北海道上川郡上川町天幕');
ok($zip->set_number('0781773')->is_valid_number, '北海道上川郡上川町日東');
ok($zip->set_number('0781774')->is_valid_number, '北海道上川郡上川町豊原');
ok($zip->set_number('0781775')->is_valid_number, '北海道上川郡上川町越路');
ok($zip->set_number('0782100')->is_valid_number, '北海道雨竜郡秩父別町以下に掲載がない場合');
ok($zip->set_number('0782101')->is_valid_number, '北海道雨竜郡秩父別町1条');
ok($zip->set_number('0782102')->is_valid_number, '北海道雨竜郡秩父別町2条');
ok($zip->set_number('0782103')->is_valid_number, '北海道雨竜郡秩父別町3条');
ok($zip->set_number('0782104')->is_valid_number, '北海道雨竜郡秩父別町4条');
ok($zip->set_number('0782105')->is_valid_number, '北海道雨竜郡秩父別町5条');
ok($zip->set_number('0782106')->is_valid_number, '北海道雨竜郡秩父別町6条');
ok($zip->set_number('0782107')->is_valid_number, '北海道雨竜郡秩父別町7条');
ok($zip->set_number('0782108')->is_valid_number, '北海道雨竜郡秩父別町8条');
ok($zip->set_number('0782109')->is_valid_number, '北海道雨竜郡秩父別町9条');
ok($zip->set_number('0782111')->is_valid_number, '北海道雨竜郡秩父別町南1条');
ok($zip->set_number('0782112')->is_valid_number, '北海道雨竜郡秩父別町南2条');
ok($zip->set_number('0782121')->is_valid_number, '北海道雨竜郡秩父別町滝の上');
ok($zip->set_number('0782122')->is_valid_number, '北海道雨竜郡秩父別町中山');
ok($zip->set_number('0782123')->is_valid_number, '北海道雨竜郡秩父別町東山');
ok($zip->set_number('0782124')->is_valid_number, '北海道雨竜郡秩父別町南山');
ok($zip->set_number('0782200')->is_valid_number, '北海道雨竜郡沼田町以下に掲載がない場合');
ok($zip->set_number('0782201')->is_valid_number, '北海道雨竜郡沼田町旭町');
ok($zip->set_number('0782202')->is_valid_number, '北海道雨竜郡沼田町南一条');
ok($zip->set_number('0782203')->is_valid_number, '北海道雨竜郡沼田町本通');
ok($zip->set_number('0782204')->is_valid_number, '北海道雨竜郡沼田町西町');
ok($zip->set_number('0782205')->is_valid_number, '北海道雨竜郡沼田町北一条');
ok($zip->set_number('0782206')->is_valid_number, '北海道雨竜郡沼田町緑町');
ok($zip->set_number('0782211')->is_valid_number, '北海道雨竜郡沼田町更新');
ok($zip->set_number('0782212')->is_valid_number, '北海道雨竜郡沼田町東予');
ok($zip->set_number('0782213')->is_valid_number, '北海道雨竜郡沼田町共成');
ok($zip->set_number('0782214')->is_valid_number, '北海道雨竜郡沼田町高穂');
ok($zip->set_number('0782221')->is_valid_number, '北海道雨竜郡沼田町真布');
ok($zip->set_number('0782222')->is_valid_number, '北海道雨竜郡沼田町沼田');
ok($zip->set_number('0782223')->is_valid_number, '北海道雨竜郡沼田町北竜');
ok($zip->set_number('0782224')->is_valid_number, '北海道雨竜郡沼田町恵比島');
ok($zip->set_number('0782225')->is_valid_number, '北海道雨竜郡沼田町幌新');
ok($zip->set_number('0782500')->is_valid_number, '北海道雨竜郡北竜町以下に掲載がない場合');
ok($zip->set_number('0782501')->is_valid_number, '北海道雨竜郡北竜町美葉牛');
ok($zip->set_number('0782502')->is_valid_number, '北海道雨竜郡北竜町岩村');
ok($zip->set_number('0782503')->is_valid_number, '北海道雨竜郡北竜町碧水');
ok($zip->set_number('0782511')->is_valid_number, '北海道雨竜郡北竜町板谷');
ok($zip->set_number('0782512')->is_valid_number, '北海道雨竜郡北竜町和');
ok($zip->set_number('0782513')->is_valid_number, '北海道雨竜郡北竜町三谷');
ok($zip->set_number('0782514')->is_valid_number, '北海道雨竜郡北竜町恵岱別');
ok($zip->set_number('0782515')->is_valid_number, '北海道雨竜郡北竜町竜西');
ok($zip->set_number('0782516')->is_valid_number, '北海道雨竜郡北竜町西川');
ok($zip->set_number('0782531')->is_valid_number, '北海道雨竜郡雨竜町第5町内(3)');
ok($zip->set_number('0782600')->is_valid_number, '北海道雨竜郡雨竜町以下に掲載がない場合');
ok($zip->set_number('0782631')->is_valid_number, '北海道雨竜郡雨竜町第1町内');
ok($zip->set_number('0782632')->is_valid_number, '北海道雨竜郡雨竜町第2町内');
ok($zip->set_number('0782633')->is_valid_number, '北海道雨竜郡雨竜町第3町内');
ok($zip->set_number('0782634')->is_valid_number, '北海道雨竜郡雨竜町第4町内');
ok($zip->set_number('0782635')->is_valid_number, '北海道雨竜郡雨竜町第5町内(その他)');
ok($zip->set_number('0782636')->is_valid_number, '北海道雨竜郡雨竜町第6町内');
ok($zip->set_number('0782637')->is_valid_number, '北海道雨竜郡雨竜町第7町内');
ok($zip->set_number('0782638')->is_valid_number, '北海道雨竜郡雨竜町第8町内');
ok($zip->set_number('0782639')->is_valid_number, '北海道雨竜郡雨竜町第9町内');
ok($zip->set_number('0782641')->is_valid_number, '北海道雨竜郡雨竜町第10町内');
ok($zip->set_number('0782642')->is_valid_number, '北海道雨竜郡雨竜町第11町内');
ok($zip->set_number('0782651')->is_valid_number, '北海道樺戸郡新十津川町美沢');
ok($zip->set_number('0783161')->is_valid_number, '北海道留萌市留萌村(峠下)');
ok($zip->set_number('0783162')->is_valid_number, '北海道留萌市東幌町');
ok($zip->set_number('0783163')->is_valid_number, '北海道留萌市南幌町');
ok($zip->set_number('0783164')->is_valid_number, '北海道留萌市留萌村(幌糠)');
ok($zip->set_number('0783165')->is_valid_number, '北海道留萌市藤山町');
ok($zip->set_number('0783165')->is_valid_number, '北海道留萌市留萌原野(その他)');
ok($zip->set_number('0783166')->is_valid_number, '北海道留萌市中幌町');
ok($zip->set_number('0783167')->is_valid_number, '北海道留萌市樽真布町');
ok($zip->set_number('0783168')->is_valid_number, '北海道留萌市幌糠町');
ok($zip->set_number('0783300')->is_valid_number, '北海道留萌郡小平町以下に掲載がない場合');
ok($zip->set_number('0783301')->is_valid_number, '北海道留萌郡小平町小平町');
ok($zip->set_number('0783302')->is_valid_number, '北海道留萌郡小平町臼谷');
ok($zip->set_number('0783303')->is_valid_number, '北海道留萌郡小平町豊平');
ok($zip->set_number('0783304')->is_valid_number, '北海道留萌郡小平町本郷');
ok($zip->set_number('0783305')->is_valid_number, '北海道留萌郡小平町桑園');
ok($zip->set_number('0783306')->is_valid_number, '北海道留萌郡小平町菊岡');
ok($zip->set_number('0783307')->is_valid_number, '北海道留萌郡小平町豊岡');
ok($zip->set_number('0783308')->is_valid_number, '北海道留萌郡小平町岐富');
ok($zip->set_number('0783309')->is_valid_number, '北海道留萌郡小平町沖内');
ok($zip->set_number('0783311')->is_valid_number, '北海道留萌郡小平町花岡');
ok($zip->set_number('0783312')->is_valid_number, '北海道留萌郡小平町富里');
ok($zip->set_number('0783313')->is_valid_number, '北海道留萌郡小平町平和(1区)');
ok($zip->set_number('0783441')->is_valid_number, '北海道留萌郡小平町鬼鹿港町');
ok($zip->set_number('0783442')->is_valid_number, '北海道留萌郡小平町鬼鹿田代');
ok($zip->set_number('0783451')->is_valid_number, '北海道留萌郡小平町鬼鹿豊浜');
ok($zip->set_number('0783452')->is_valid_number, '北海道留萌郡小平町鬼鹿千松');
ok($zip->set_number('0783453')->is_valid_number, '北海道留萌郡小平町鬼鹿元浜');
ok($zip->set_number('0783454')->is_valid_number, '北海道留萌郡小平町鬼鹿広富');
ok($zip->set_number('0783455')->is_valid_number, '北海道留萌郡小平町鬼鹿秀浦');
ok($zip->set_number('0783456')->is_valid_number, '北海道留萌郡小平町鬼鹿富岡');
ok($zip->set_number('0783457')->is_valid_number, '北海道留萌郡小平町大椴');
ok($zip->set_number('0783541')->is_valid_number, '北海道苫前郡苫前町力昼');
ok($zip->set_number('0783621')->is_valid_number, '北海道苫前郡苫前町古丹別');
ok($zip->set_number('0783631')->is_valid_number, '北海道苫前郡苫前町香川(338~849番地)');
ok($zip->set_number('0783632')->is_valid_number, '北海道苫前郡苫前町長島');
ok($zip->set_number('0783633')->is_valid_number, '北海道苫前郡苫前町小川');
ok($zip->set_number('0783634')->is_valid_number, '北海道苫前郡苫前町岩見');
ok($zip->set_number('0783635')->is_valid_number, '北海道苫前郡苫前町東川');
ok($zip->set_number('0783636')->is_valid_number, '北海道苫前郡苫前町霧立');
ok($zip->set_number('0783637')->is_valid_number, '北海道苫前郡苫前町九重');
ok($zip->set_number('0783638')->is_valid_number, '北海道苫前郡苫前町三渓');
ok($zip->set_number('0783700')->is_valid_number, '北海道苫前郡苫前町以下に掲載がない場合');
ok($zip->set_number('0783701')->is_valid_number, '北海道苫前郡苫前町苫前');
ok($zip->set_number('0783702')->is_valid_number, '北海道苫前郡苫前町栄浜');
ok($zip->set_number('0783711')->is_valid_number, '北海道苫前郡苫前町旭');
ok($zip->set_number('0783712')->is_valid_number, '北海道苫前郡苫前町上平');
ok($zip->set_number('0783713')->is_valid_number, '北海道苫前郡苫前町興津');
ok($zip->set_number('0783714')->is_valid_number, '北海道苫前郡苫前町香川(その他)');
ok($zip->set_number('0783715')->is_valid_number, '北海道苫前郡苫前町昭和');
ok($zip->set_number('0783716')->is_valid_number, '北海道苫前郡苫前町豊浦');
ok($zip->set_number('0783717')->is_valid_number, '北海道苫前郡苫前町三豊');
ok($zip->set_number('0783871')->is_valid_number, '北海道苫前郡羽幌町焼尻');
ok($zip->set_number('0783951')->is_valid_number, '北海道苫前郡羽幌町天売(相影)');
ok($zip->set_number('0783952')->is_valid_number, '北海道苫前郡羽幌町天売(富磯)');
ok($zip->set_number('0783953')->is_valid_number, '北海道苫前郡羽幌町天売(和浦)');
ok($zip->set_number('0783954')->is_valid_number, '北海道苫前郡羽幌町天売(前浜)');
ok($zip->set_number('0783955')->is_valid_number, '北海道苫前郡羽幌町天売(弁天)');
ok($zip->set_number('0784100')->is_valid_number, '北海道苫前郡羽幌町以下に掲載がない場合');
ok($zip->set_number('0784101')->is_valid_number, '北海道苫前郡羽幌町南一条');
ok($zip->set_number('0784102')->is_valid_number, '北海道苫前郡羽幌町南二条');
ok($zip->set_number('0784103')->is_valid_number, '北海道苫前郡羽幌町南三条');
ok($zip->set_number('0784104')->is_valid_number, '北海道苫前郡羽幌町南四条');
ok($zip->set_number('0784105')->is_valid_number, '北海道苫前郡羽幌町南五条');
ok($zip->set_number('0784106')->is_valid_number, '北海道苫前郡羽幌町南六条');
ok($zip->set_number('0784107')->is_valid_number, '北海道苫前郡羽幌町南七条');
ok($zip->set_number('0784108')->is_valid_number, '北海道苫前郡羽幌町南大通');
ok($zip->set_number('0784110')->is_valid_number, '北海道苫前郡羽幌町北大通');
ok($zip->set_number('0784111')->is_valid_number, '北海道苫前郡羽幌町北一条');
ok($zip->set_number('0784112')->is_valid_number, '北海道苫前郡羽幌町北二条');
ok($zip->set_number('0784113')->is_valid_number, '北海道苫前郡羽幌町北三条');
ok($zip->set_number('0784114')->is_valid_number, '北海道苫前郡羽幌町北四条');
ok($zip->set_number('0784115')->is_valid_number, '北海道苫前郡羽幌町北五条');
ok($zip->set_number('0784116')->is_valid_number, '北海道苫前郡羽幌町北六条');
ok($zip->set_number('0784117')->is_valid_number, '北海道苫前郡羽幌町朝日');
ok($zip->set_number('0784118')->is_valid_number, '北海道苫前郡羽幌町浜町');
ok($zip->set_number('0784119')->is_valid_number, '北海道苫前郡羽幌町北町');
ok($zip->set_number('0784120')->is_valid_number, '北海道苫前郡羽幌町港町');
ok($zip->set_number('0784121')->is_valid_number, '北海道苫前郡羽幌町幸町');
ok($zip->set_number('0784122')->is_valid_number, '北海道苫前郡羽幌町南町');
ok($zip->set_number('0784123')->is_valid_number, '北海道苫前郡羽幌町栄町');
ok($zip->set_number('0784130')->is_valid_number, '北海道苫前郡羽幌町緑町');
ok($zip->set_number('0784131')->is_valid_number, '北海道苫前郡羽幌町寿町');
ok($zip->set_number('0784132')->is_valid_number, '北海道苫前郡羽幌町中央');
ok($zip->set_number('0784133')->is_valid_number, '北海道苫前郡羽幌町平');
ok($zip->set_number('0784134')->is_valid_number, '北海道苫前郡羽幌町上羽幌');
ok($zip->set_number('0784140')->is_valid_number, '北海道苫前郡羽幌町汐見');
ok($zip->set_number('0784141')->is_valid_number, '北海道苫前郡羽幌町築別');
ok($zip->set_number('0784142')->is_valid_number, '北海道苫前郡羽幌町上築');
ok($zip->set_number('0784143')->is_valid_number, '北海道苫前郡羽幌町高台');
ok($zip->set_number('0784144')->is_valid_number, '北海道苫前郡羽幌町曙');
ok($zip->set_number('0784145')->is_valid_number, '北海道苫前郡羽幌町築別炭砿');
ok($zip->set_number('0784400')->is_valid_number, '北海道苫前郡初山別村以下に掲載がない場合');
ok($zip->set_number('0784411')->is_valid_number, '北海道苫前郡初山別村有明');
ok($zip->set_number('0784412')->is_valid_number, '北海道苫前郡初山別村栄');
ok($zip->set_number('0784421')->is_valid_number, '北海道苫前郡初山別村初山別');
ok($zip->set_number('0784422')->is_valid_number, '北海道苫前郡初山別村千代田');
ok($zip->set_number('0784431')->is_valid_number, '北海道苫前郡初山別村豊岬');
ok($zip->set_number('0784432')->is_valid_number, '北海道苫前郡初山別村明里');
ok($zip->set_number('0784433')->is_valid_number, '北海道苫前郡初山別村共成');
ok($zip->set_number('0788201')->is_valid_number, '北海道旭川市東旭川町東桜岡(30~499番地)');
ok($zip->set_number('0788202')->is_valid_number, '北海道旭川市東旭川町豊田(1~9番地)');
ok($zip->set_number('0788203')->is_valid_number, '北海道旭川市東旭川町日ノ出');
ok($zip->set_number('0788204')->is_valid_number, '北海道旭川市東旭川町桜岡');
ok($zip->set_number('0788205')->is_valid_number, '北海道旭川市東旭川町倉沼');
ok($zip->set_number('0788206')->is_valid_number, '北海道旭川市東旭川町忠別');
ok($zip->set_number('0788207')->is_valid_number, '北海道旭川市東旭川町上兵村');
ok($zip->set_number('0788208')->is_valid_number, '北海道旭川市東旭川町下兵村');
ok($zip->set_number('0788211')->is_valid_number, '北海道旭川市1条通(18~25丁目)');
ok($zip->set_number('0788212')->is_valid_number, '北海道旭川市2条通(18~25丁目)');
ok($zip->set_number('0788213')->is_valid_number, '北海道旭川市3条通(18~25丁目)');
ok($zip->set_number('0788214')->is_valid_number, '北海道旭川市4条通(18~25丁目)');
ok($zip->set_number('0788215')->is_valid_number, '北海道旭川市5条通(18~25丁目)');
ok($zip->set_number('0788216')->is_valid_number, '北海道旭川市6条通(18~25丁目)');
ok($zip->set_number('0788217')->is_valid_number, '北海道旭川市7条通(18~25丁目)');
ok($zip->set_number('0788218')->is_valid_number, '北海道旭川市8条通(18~25丁目)');
ok($zip->set_number('0788219')->is_valid_number, '北海道旭川市9条通(18~25丁目)');
ok($zip->set_number('0788220')->is_valid_number, '北海道旭川市10条通(18~25丁目)');
ok($zip->set_number('0788221')->is_valid_number, '北海道旭川市11条通');
ok($zip->set_number('0788231')->is_valid_number, '北海道旭川市豊岡1条');
ok($zip->set_number('0788232')->is_valid_number, '北海道旭川市豊岡2条');
ok($zip->set_number('0788233')->is_valid_number, '北海道旭川市豊岡3条');
ok($zip->set_number('0788234')->is_valid_number, '北海道旭川市豊岡4条');
ok($zip->set_number('0788235')->is_valid_number, '北海道旭川市豊岡5条');
ok($zip->set_number('0788236')->is_valid_number, '北海道旭川市豊岡6条');
ok($zip->set_number('0788237')->is_valid_number, '北海道旭川市豊岡7条');
ok($zip->set_number('0788238')->is_valid_number, '北海道旭川市豊岡8条');
ok($zip->set_number('0788239')->is_valid_number, '北海道旭川市豊岡9条');
ok($zip->set_number('0788240')->is_valid_number, '北海道旭川市豊岡10条');
ok($zip->set_number('0788241')->is_valid_number, '北海道旭川市豊岡11条');
ok($zip->set_number('0788242')->is_valid_number, '北海道旭川市豊岡12条');
ok($zip->set_number('0788243')->is_valid_number, '北海道旭川市豊岡13条');
ok($zip->set_number('0788244')->is_valid_number, '北海道旭川市豊岡14条');
ok($zip->set_number('0788245')->is_valid_number, '北海道旭川市豊岡15条');
ok($zip->set_number('0788246')->is_valid_number, '北海道旭川市豊岡16条');
ok($zip->set_number('0788251')->is_valid_number, '北海道旭川市東旭川北1条');
ok($zip->set_number('0788252')->is_valid_number, '北海道旭川市東旭川北2条');
ok($zip->set_number('0788253')->is_valid_number, '北海道旭川市東旭川北3条');
ok($zip->set_number('0788261')->is_valid_number, '北海道旭川市東旭川南1条');
ok($zip->set_number('0788262')->is_valid_number, '北海道旭川市東旭川南2条');
ok($zip->set_number('0788271')->is_valid_number, '北海道旭川市工業団地1条');
ok($zip->set_number('0788272')->is_valid_number, '北海道旭川市工業団地2条');
ok($zip->set_number('0788273')->is_valid_number, '北海道旭川市工業団地3条');
ok($zip->set_number('0788274')->is_valid_number, '北海道旭川市工業団地4条');
ok($zip->set_number('0788275')->is_valid_number, '北海道旭川市工業団地5条');
ok($zip->set_number('0788301')->is_valid_number, '北海道旭川市緑が丘1条');
ok($zip->set_number('0788302')->is_valid_number, '北海道旭川市緑が丘2条');
ok($zip->set_number('0788303')->is_valid_number, '北海道旭川市緑が丘3条');
ok($zip->set_number('0788304')->is_valid_number, '北海道旭川市緑が丘4条');
ok($zip->set_number('0788305')->is_valid_number, '北海道旭川市緑が丘5条');
ok($zip->set_number('0788308')->is_valid_number, '北海道旭川市旭神町');
ok($zip->set_number('0788311')->is_valid_number, '北海道旭川市神楽岡1条');
ok($zip->set_number('0788312')->is_valid_number, '北海道旭川市神楽岡2条');
ok($zip->set_number('0788313')->is_valid_number, '北海道旭川市神楽岡3条');
ok($zip->set_number('0788314')->is_valid_number, '北海道旭川市神楽岡4条');
ok($zip->set_number('0788315')->is_valid_number, '北海道旭川市神楽岡5条');
ok($zip->set_number('0788316')->is_valid_number, '北海道旭川市神楽岡6条');
ok($zip->set_number('0788317')->is_valid_number, '北海道旭川市神楽岡7条');
ok($zip->set_number('0788318')->is_valid_number, '北海道旭川市神楽岡8条');
ok($zip->set_number('0788319')->is_valid_number, '北海道旭川市神楽岡9条');
ok($zip->set_number('0788320')->is_valid_number, '北海道旭川市神楽岡10条');
ok($zip->set_number('0788321')->is_valid_number, '北海道旭川市神楽岡11条');
ok($zip->set_number('0788322')->is_valid_number, '北海道旭川市神楽岡12条');
ok($zip->set_number('0788323')->is_valid_number, '北海道旭川市神楽岡13条');
ok($zip->set_number('0788324')->is_valid_number, '北海道旭川市神楽岡14条');
ok($zip->set_number('0788325')->is_valid_number, '北海道旭川市神楽岡15条');
ok($zip->set_number('0788326')->is_valid_number, '北海道旭川市神楽岡16条');
ok($zip->set_number('0788327')->is_valid_number, '北海道旭川市神楽岡公園');
ok($zip->set_number('0788330')->is_valid_number, '北海道旭川市宮下通(18~26丁目)');
ok($zip->set_number('0788331')->is_valid_number, '北海道旭川市南1条通');
ok($zip->set_number('0788332')->is_valid_number, '北海道旭川市南2条通');
ok($zip->set_number('0788333')->is_valid_number, '北海道旭川市南3条通');
ok($zip->set_number('0788334')->is_valid_number, '北海道旭川市南4条通');
ok($zip->set_number('0788335')->is_valid_number, '北海道旭川市南5条通');
ok($zip->set_number('0788336')->is_valid_number, '北海道旭川市南6条通');
ok($zip->set_number('0788337')->is_valid_number, '北海道旭川市南7条通');
ok($zip->set_number('0788338')->is_valid_number, '北海道旭川市南8条通');
ok($zip->set_number('0788339')->is_valid_number, '北海道旭川市南9条通');
ok($zip->set_number('0788340')->is_valid_number, '北海道旭川市東旭川町共栄');
ok($zip->set_number('0788341')->is_valid_number, '北海道旭川市東光1条');
ok($zip->set_number('0788342')->is_valid_number, '北海道旭川市東光2条');
ok($zip->set_number('0788343')->is_valid_number, '北海道旭川市東光3条');
ok($zip->set_number('0788344')->is_valid_number, '北海道旭川市東光4条');
ok($zip->set_number('0788345')->is_valid_number, '北海道旭川市東光5条');
ok($zip->set_number('0788346')->is_valid_number, '北海道旭川市東光6条');
ok($zip->set_number('0788347')->is_valid_number, '北海道旭川市東光7条');
ok($zip->set_number('0788348')->is_valid_number, '北海道旭川市東光8条');
ok($zip->set_number('0788349')->is_valid_number, '北海道旭川市東光9条');
ok($zip->set_number('0788350')->is_valid_number, '北海道旭川市東光10条');
ok($zip->set_number('0788351')->is_valid_number, '北海道旭川市東光11条');
ok($zip->set_number('0788352')->is_valid_number, '北海道旭川市東光12条');
ok($zip->set_number('0788353')->is_valid_number, '北海道旭川市東光13条');
ok($zip->set_number('0788354')->is_valid_number, '北海道旭川市東光14条');
ok($zip->set_number('0788355')->is_valid_number, '北海道旭川市東光15条');
ok($zip->set_number('0788356')->is_valid_number, '北海道旭川市東光16条');
ok($zip->set_number('0788357')->is_valid_number, '北海道旭川市東光17条');
ok($zip->set_number('0788358')->is_valid_number, '北海道旭川市東光18条');
ok($zip->set_number('0788359')->is_valid_number, '北海道旭川市東光19条');
ok($zip->set_number('0788360')->is_valid_number, '北海道旭川市東光20条');
ok($zip->set_number('0788361')->is_valid_number, '北海道旭川市東光21条');
ok($zip->set_number('0788362')->is_valid_number, '北海道旭川市東光22条');
ok($zip->set_number('0788363')->is_valid_number, '北海道旭川市東光23条');
ok($zip->set_number('0788364')->is_valid_number, '北海道旭川市東光24条');
ok($zip->set_number('0788365')->is_valid_number, '北海道旭川市東光25条');
ok($zip->set_number('0788366')->is_valid_number, '北海道旭川市東光26条');
ok($zip->set_number('0788367')->is_valid_number, '北海道旭川市東光27条');
ok($zip->set_number('0788368')->is_valid_number, '北海道旭川市東旭川町旭正');
ok($zip->set_number('0788371')->is_valid_number, '北海道旭川市旭神1条');
ok($zip->set_number('0788372')->is_valid_number, '北海道旭川市旭神2条');
ok($zip->set_number('0788373')->is_valid_number, '北海道旭川市旭神3条');
ok($zip->set_number('0788381')->is_valid_number, '北海道旭川市西神楽1線');
ok($zip->set_number('0788382')->is_valid_number, '北海道旭川市西神楽2線');
ok($zip->set_number('0788383')->is_valid_number, '北海道旭川市西神楽3線');
ok($zip->set_number('0788391')->is_valid_number, '北海道旭川市宮前1条');
ok($zip->set_number('0788392')->is_valid_number, '北海道旭川市宮前2条');
ok($zip->set_number('0788801')->is_valid_number, '北海道旭川市緑が丘東1条');
ok($zip->set_number('0788802')->is_valid_number, '北海道旭川市緑が丘東2条');
ok($zip->set_number('0788803')->is_valid_number, '北海道旭川市緑が丘東3条');
ok($zip->set_number('0788804')->is_valid_number, '北海道旭川市緑が丘東4条');
ok($zip->set_number('0788805')->is_valid_number, '北海道旭川市緑が丘東5条');
ok($zip->set_number('0788811')->is_valid_number, '北海道旭川市緑が丘南1条');
ok($zip->set_number('0788812')->is_valid_number, '北海道旭川市緑が丘南2条');
ok($zip->set_number('0788813')->is_valid_number, '北海道旭川市緑が丘南3条');
ok($zip->set_number('0788814')->is_valid_number, '北海道旭川市緑が丘南4条');
ok($zip->set_number('0788815')->is_valid_number, '北海道旭川市緑が丘南5条');
ok($zip->set_number('0788821')->is_valid_number, '北海道旭川市西御料1条');
ok($zip->set_number('0788822')->is_valid_number, '北海道旭川市西御料2条');
ok($zip->set_number('0788823')->is_valid_number, '北海道旭川市西御料3条');
ok($zip->set_number('0788824')->is_valid_number, '北海道旭川市西御料4条');
ok($zip->set_number('0788825')->is_valid_number, '北海道旭川市西御料5条');
ok($zip->set_number('0790161')->is_valid_number, '北海道美唄市光珠内拓北');
ok($zip->set_number('0790162')->is_valid_number, '北海道美唄市光珠内北');
ok($zip->set_number('0790164')->is_valid_number, '北海道美唄市光珠内下中の沢');
ok($zip->set_number('0790165')->is_valid_number, '北海道美唄市光珠内上中の沢');
ok($zip->set_number('0790166')->is_valid_number, '北海道美唄市光珠内東山');
ok($zip->set_number('0790167')->is_valid_number, '北海道美唄市光珠内町南(その他)');
ok($zip->set_number('0790171')->is_valid_number, '北海道美唄市光珠内中央');
ok($zip->set_number('0790172')->is_valid_number, '北海道美唄市峰延町東');
ok($zip->set_number('0790173')->is_valid_number, '北海道美唄市峰延町公園');
ok($zip->set_number('0790174')->is_valid_number, '北海道美唄市峰延町本町');
ok($zip->set_number('0790175')->is_valid_number, '北海道美唄市峰延町峰樺');
ok($zip->set_number('0790176')->is_valid_number, '北海道美唄市豊葦町');
ok($zip->set_number('0790177')->is_valid_number, '北海道美唄市上美唄町(協和、南)');
ok($zip->set_number('0790181')->is_valid_number, '北海道岩見沢市岡山町');
ok($zip->set_number('0790182')->is_valid_number, '北海道岩見沢市峰延町');
ok($zip->set_number('0790183')->is_valid_number, '北海道岩見沢市大願町');
ok($zip->set_number('0790261')->is_valid_number, '北海道美唄市茶志内町');
ok($zip->set_number('0790262')->is_valid_number, '北海道美唄市日東町栄町');
ok($zip->set_number('0790263')->is_valid_number, '北海道美唄市日東町住吉');
ok($zip->set_number('0790264')->is_valid_number, '北海道美唄市日東町本町');
ok($zip->set_number('0790265')->is_valid_number, '北海道美唄市日東町富の郷');
ok($zip->set_number('0790266')->is_valid_number, '北海道美唄市茶志内町本町');
ok($zip->set_number('0790267')->is_valid_number, '北海道美唄市茶志内町協和');
ok($zip->set_number('0790271')->is_valid_number, '北海道美唄市中村町南');
ok($zip->set_number('0790272')->is_valid_number, '北海道美唄市中村町中央');
ok($zip->set_number('0790273')->is_valid_number, '北海道美唄市中村町北');
ok($zip->set_number('0790274')->is_valid_number, '北海道美唄市北美唄町');
ok($zip->set_number('0790300')->is_valid_number, '北海道空知郡奈井江町以下に掲載がない場合');
ok($zip->set_number('0790301')->is_valid_number, '北海道空知郡奈井江町厳島');
ok($zip->set_number('0790302')->is_valid_number, '北海道空知郡奈井江町白山');
ok($zip->set_number('0790303')->is_valid_number, '北海道空知郡奈井江町向ケ丘');
ok($zip->set_number('0790304')->is_valid_number, '北海道空知郡奈井江町宮村');
ok($zip->set_number('0790305')->is_valid_number, '北海道空知郡奈井江町茶志内');
ok($zip->set_number('0790306')->is_valid_number, '北海道空知郡奈井江町東町');
ok($zip->set_number('0790311')->is_valid_number, '北海道空知郡奈井江町大和');
ok($zip->set_number('0790312')->is_valid_number, '北海道空知郡奈井江町北町');
ok($zip->set_number('0790313')->is_valid_number, '北海道空知郡奈井江町本町');
ok($zip->set_number('0790314')->is_valid_number, '北海道空知郡奈井江町南町');
ok($zip->set_number('0790315')->is_valid_number, '北海道空知郡奈井江町高島');
ok($zip->set_number('0790316')->is_valid_number, '北海道空知郡奈井江町キナウスナイ');
ok($zip->set_number('0790317')->is_valid_number, '北海道空知郡奈井江町瑞穂');
ok($zip->set_number('0790461')->is_valid_number, '北海道滝川市江部乙町');
ok($zip->set_number('0790462')->is_valid_number, '北海道滝川市江部乙町西');
ok($zip->set_number('0790463')->is_valid_number, '北海道滝川市江部乙町東');
ok($zip->set_number('0790500')->is_valid_number, '北海道雨竜郡妹背牛町以下に掲載がない場合');
ok($zip->set_number('0790501')->is_valid_number, '北海道雨竜郡妹背牛町1区');
ok($zip->set_number('0790502')->is_valid_number, '北海道雨竜郡妹背牛町2区');
ok($zip->set_number('0790503')->is_valid_number, '北海道雨竜郡妹背牛町3区');
ok($zip->set_number('0790504')->is_valid_number, '北海道雨竜郡妹背牛町4区');
ok($zip->set_number('0790505')->is_valid_number, '北海道雨竜郡妹背牛町5区');
ok($zip->set_number('0790506')->is_valid_number, '北海道雨竜郡妹背牛町6区');
ok($zip->set_number('0790507')->is_valid_number, '北海道雨竜郡妹背牛町7区');
ok($zip->set_number('0790508')->is_valid_number, '北海道雨竜郡妹背牛町8区');
ok($zip->set_number('0790509')->is_valid_number, '北海道雨竜郡妹背牛町9区');
ok($zip->set_number('0790510')->is_valid_number, '北海道雨竜郡妹背牛町10区');
ok($zip->set_number('0790511')->is_valid_number, '北海道雨竜郡妹背牛町11区');
ok($zip->set_number('0791100')->is_valid_number, '北海道赤平市以下に掲載がない場合');
ok($zip->set_number('0791101')->is_valid_number, '北海道赤平市共和町');
ok($zip->set_number('0791102')->is_valid_number, '北海道赤平市幌岡町');
ok($zip->set_number('0791111')->is_valid_number, '北海道赤平市若木町北');
ok($zip->set_number('0791112')->is_valid_number, '北海道赤平市若木町西');
ok($zip->set_number('0791113')->is_valid_number, '北海道赤平市若木町東');
ok($zip->set_number('0791114')->is_valid_number, '北海道赤平市若木町南');
ok($zip->set_number('0791121')->is_valid_number, '北海道赤平市北文京町');
ok($zip->set_number('0791122')->is_valid_number, '北海道赤平市西文京町');
ok($zip->set_number('0791123')->is_valid_number, '北海道赤平市東文京町');
ok($zip->set_number('0791124')->is_valid_number, '北海道赤平市豊丘町');
ok($zip->set_number('0791131')->is_valid_number, '北海道赤平市西豊里町');
ok($zip->set_number('0791132')->is_valid_number, '北海道赤平市東豊里町');
ok($zip->set_number('0791133')->is_valid_number, '北海道赤平市豊里');
ok($zip->set_number('0791134')->is_valid_number, '北海道赤平市泉町');
ok($zip->set_number('0791135')->is_valid_number, '北海道赤平市錦町');
ok($zip->set_number('0791136')->is_valid_number, '北海道赤平市本町');
ok($zip->set_number('0791141')->is_valid_number, '北海道赤平市大町');
ok($zip->set_number('0791142')->is_valid_number, '北海道赤平市東大町');
ok($zip->set_number('0791143')->is_valid_number, '北海道赤平市赤平');
ok($zip->set_number('0791144')->is_valid_number, '北海道赤平市美園町');
ok($zip->set_number('0791151')->is_valid_number, '北海道赤平市宮下町');
ok($zip->set_number('0791152')->is_valid_number, '北海道赤平市桜木町');
ok($zip->set_number('0791153')->is_valid_number, '北海道赤平市豊栄町');
ok($zip->set_number('0791154')->is_valid_number, '北海道赤平市幸町');
ok($zip->set_number('0791155')->is_valid_number, '北海道赤平市昭和町');
ok($zip->set_number('0791156')->is_valid_number, '北海道赤平市住吉町');
ok($zip->set_number('0791181')->is_valid_number, '北海道砂川市富平(331、459-4、543番地)');
ok($zip->set_number('0791261')->is_valid_number, '北海道赤平市茂尻中央町南');
ok($zip->set_number('0791261')->is_valid_number, '北海道赤平市茂尻中央町北');
ok($zip->set_number('0791262')->is_valid_number, '北海道赤平市茂尻春日町');
ok($zip->set_number('0791262')->is_valid_number, '北海道赤平市茂尻新春日町');
ok($zip->set_number('0791263')->is_valid_number, '北海道赤平市茂尻本町');
ok($zip->set_number('0791264')->is_valid_number, '北海道赤平市茂尻旭町');
ok($zip->set_number('0791264')->is_valid_number, '北海道赤平市茂尻宮下町');
ok($zip->set_number('0791265')->is_valid_number, '北海道赤平市茂尻新町');
ok($zip->set_number('0791266')->is_valid_number, '北海道赤平市茂尻');
ok($zip->set_number('0791266')->is_valid_number, '北海道赤平市茂尻栄町');
ok($zip->set_number('0791267')->is_valid_number, '北海道赤平市茂尻元町南');
ok($zip->set_number('0791268')->is_valid_number, '北海道赤平市茂尻元町北');
ok($zip->set_number('0791271')->is_valid_number, '北海道赤平市百戸町北');
ok($zip->set_number('0791272')->is_valid_number, '北海道赤平市百戸町東');
ok($zip->set_number('0791273')->is_valid_number, '北海道赤平市百戸町西');
ok($zip->set_number('0791274')->is_valid_number, '北海道赤平市エルム町');
ok($zip->set_number('0791281')->is_valid_number, '北海道赤平市平岸新光町');
ok($zip->set_number('0791282')->is_valid_number, '北海道赤平市平岸仲町');
ok($zip->set_number('0791283')->is_valid_number, '北海道赤平市平岸東町');
ok($zip->set_number('0791284')->is_valid_number, '北海道赤平市平岸南町');
ok($zip->set_number('0791285')->is_valid_number, '北海道赤平市平岸曙町');
ok($zip->set_number('0791286')->is_valid_number, '北海道赤平市平岸西町');
ok($zip->set_number('0791287')->is_valid_number, '北海道赤平市平岸桂町');
ok($zip->set_number('0791371')->is_valid_number, '北海道芦別市上芦別町');
ok($zip->set_number('0791372')->is_valid_number, '北海道芦別市野花南町');
ok($zip->set_number('0791562')->is_valid_number, '北海道富良野市山部北町');
ok($zip->set_number('0791563')->is_valid_number, '北海道富良野市山部東町');
ok($zip->set_number('0791564')->is_valid_number, '北海道富良野市山部中町');
ok($zip->set_number('0791565')->is_valid_number, '北海道富良野市山部南町');
ok($zip->set_number('0791566')->is_valid_number, '北海道富良野市山部西町');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西12線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西13線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西14線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西15線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西16線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西17線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西18線');
ok($zip->set_number('0791571')->is_valid_number, '北海道富良野市山部西19線');
ok($zip->set_number('0791572')->is_valid_number, '北海道富良野市山部西20線');
ok($zip->set_number('0791572')->is_valid_number, '北海道富良野市山部西21線');
ok($zip->set_number('0791572')->is_valid_number, '北海道富良野市山部西22線');
ok($zip->set_number('0791572')->is_valid_number, '北海道富良野市山部西23線');
ok($zip->set_number('0791572')->is_valid_number, '北海道富良野市山部西24線');
ok($zip->set_number('0791573')->is_valid_number, '北海道富良野市山部西25線');
ok($zip->set_number('0791573')->is_valid_number, '北海道富良野市山部西26線');
ok($zip->set_number('0791573')->is_valid_number, '北海道富良野市山部西27線');
ok($zip->set_number('0791573')->is_valid_number, '北海道富良野市山部西28線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東12線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東13線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東14線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東15線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東16線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東17線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東18線');
ok($zip->set_number('0791581')->is_valid_number, '北海道富良野市山部東19線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東20線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東21線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東22線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東23線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東24線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東25線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東26線');
ok($zip->set_number('0791582')->is_valid_number, '北海道富良野市山部東27線');
ok($zip->set_number('0792131')->is_valid_number, '北海道空知郡南富良野町金山');
ok($zip->set_number('0792132')->is_valid_number, '北海道空知郡南富良野町下金山');
ok($zip->set_number('0792133')->is_valid_number, '北海道富良野市東山(1710番地)');
ok($zip->set_number('0792200')->is_valid_number, '北海道勇払郡占冠村以下に掲載がない場合');
ok($zip->set_number('0792201')->is_valid_number, '北海道勇払郡占冠村中央');
ok($zip->set_number('0792202')->is_valid_number, '北海道勇払郡占冠村占冠');
ok($zip->set_number('0792203')->is_valid_number, '北海道勇払郡占冠村下トマム');
ok($zip->set_number('0792204')->is_valid_number, '北海道勇払郡占冠村中トマム');
ok($zip->set_number('0792205')->is_valid_number, '北海道勇払郡占冠村上トマム');
ok($zip->set_number('0792206')->is_valid_number, '北海道勇払郡占冠村双珠別');
ok($zip->set_number('0792207')->is_valid_number, '北海道勇払郡占冠村ニニウ');
ok($zip->set_number('0792400')->is_valid_number, '北海道空知郡南富良野町以下に掲載がない場合');
ok($zip->set_number('0792401')->is_valid_number, '北海道空知郡南富良野町幾寅(栄町)');
ok($zip->set_number('0792401')->is_valid_number, '北海道空知郡南富良野町幾寅(住吉町)');
ok($zip->set_number('0792401')->is_valid_number, '北海道空知郡南富良野町幾寅(内藤)');
ok($zip->set_number('0792401')->is_valid_number, '北海道空知郡南富良野町幾寅(仲町)');
ok($zip->set_number('0792402')->is_valid_number, '北海道空知郡南富良野町幾寅(西町)');
ok($zip->set_number('0792403')->is_valid_number, '北海道空知郡南富良野町幾寅(浅野)');
ok($zip->set_number('0792403')->is_valid_number, '北海道空知郡南富良野町幾寅(岐阜)');
ok($zip->set_number('0792403')->is_valid_number, '北海道空知郡南富良野町幾寅(久住)');
ok($zip->set_number('0792403')->is_valid_number, '北海道空知郡南富良野町幾寅(松井)');
ok($zip->set_number('0792403')->is_valid_number, '北海道空知郡南富良野町幾寅(山畔)');
ok($zip->set_number('0792404')->is_valid_number, '北海道空知郡南富良野町幾寅(朝日町)');
ok($zip->set_number('0792404')->is_valid_number, '北海道空知郡南富良野町幾寅(千木町)');
ok($zip->set_number('0792404')->is_valid_number, '北海道空知郡南富良野町幾寅(東町)');
ok($zip->set_number('0792411')->is_valid_number, '北海道空知郡南富良野町東鹿越');
ok($zip->set_number('0792412')->is_valid_number, '北海道空知郡南富良野町東幾寅');
ok($zip->set_number('0792551')->is_valid_number, '北海道空知郡南富良野町落合');
ok($zip->set_number('0792552')->is_valid_number, '北海道空知郡南富良野町北落合');
ok($zip->set_number('0798401')->is_valid_number, '北海道旭川市秋月1条');
ok($zip->set_number('0798402')->is_valid_number, '北海道旭川市秋月2条');
ok($zip->set_number('0798403')->is_valid_number, '北海道旭川市秋月3条');
ok($zip->set_number('0798411')->is_valid_number, '北海道旭川市永山1条');
ok($zip->set_number('0798412')->is_valid_number, '北海道旭川市永山2条');
ok($zip->set_number('0798413')->is_valid_number, '北海道旭川市永山3条');
ok($zip->set_number('0798414')->is_valid_number, '北海道旭川市永山4条');
ok($zip->set_number('0798415')->is_valid_number, '北海道旭川市永山5条');
ok($zip->set_number('0798416')->is_valid_number, '北海道旭川市永山6条');
ok($zip->set_number('0798417')->is_valid_number, '北海道旭川市永山7条');
ok($zip->set_number('0798418')->is_valid_number, '北海道旭川市永山8条');
ok($zip->set_number('0798419')->is_valid_number, '北海道旭川市永山9条');
ok($zip->set_number('0798420')->is_valid_number, '北海道旭川市永山10条');
ok($zip->set_number('0798421')->is_valid_number, '北海道旭川市永山11条');
ok($zip->set_number('0798422')->is_valid_number, '北海道旭川市永山12条');
ok($zip->set_number('0798423')->is_valid_number, '北海道旭川市永山13条');
ok($zip->set_number('0798424')->is_valid_number, '北海道旭川市永山14条');
ok($zip->set_number('0798431')->is_valid_number, '北海道旭川市永山町');
ok($zip->set_number('0798441')->is_valid_number, '北海道旭川市流通団地1条');
ok($zip->set_number('0798442')->is_valid_number, '北海道旭川市流通団地2条');
ok($zip->set_number('0798443')->is_valid_number, '北海道旭川市流通団地3条');
ok($zip->set_number('0798444')->is_valid_number, '北海道旭川市流通団地4条');
ok($zip->set_number('0798451')->is_valid_number, '北海道旭川市永山北1条');
ok($zip->set_number('0798452')->is_valid_number, '北海道旭川市永山北2条');
ok($zip->set_number('0798453')->is_valid_number, '北海道旭川市永山北3条');
ok($zip->set_number('0798454')->is_valid_number, '北海道旭川市永山北4条');
ok($zip->set_number('0800000')->is_valid_number, '北海道帯広市以下に掲載がない場合');
ok($zip->set_number('0800010')->is_valid_number, '北海道帯広市大通南');
ok($zip->set_number('0800011')->is_valid_number, '北海道帯広市西一条南');
ok($zip->set_number('0800012')->is_valid_number, '北海道帯広市西二条南');
ok($zip->set_number('0800013')->is_valid_number, '北海道帯広市西三条南');
ok($zip->set_number('0800014')->is_valid_number, '北海道帯広市西四条南');
ok($zip->set_number('0800015')->is_valid_number, '北海道帯広市西五条南');
ok($zip->set_number('0800016')->is_valid_number, '北海道帯広市西六条南');
ok($zip->set_number('0800017')->is_valid_number, '北海道帯広市西七条南');
ok($zip->set_number('0800018')->is_valid_number, '北海道帯広市西八条南');
ok($zip->set_number('0800019')->is_valid_number, '北海道帯広市西九条南');
ok($zip->set_number('0800020')->is_valid_number, '北海道帯広市西十条南');
ok($zip->set_number('0800021')->is_valid_number, '北海道帯広市西十一条南');
ok($zip->set_number('0800022')->is_valid_number, '北海道帯広市西十二条南');
ok($zip->set_number('0800023')->is_valid_number, '北海道帯広市西十三条南');
ok($zip->set_number('0800024')->is_valid_number, '北海道帯広市西十四条南');
ok($zip->set_number('0800025')->is_valid_number, '北海道帯広市西十五条南');
ok($zip->set_number('0800026')->is_valid_number, '北海道帯広市西十六条南');
ok($zip->set_number('0800027')->is_valid_number, '北海道帯広市西十七条南');
ok($zip->set_number('0800028')->is_valid_number, '北海道帯広市西十八条南');
ok($zip->set_number('0800029')->is_valid_number, '北海道帯広市西十九条南(35~38、41、42丁目)');
ok($zip->set_number('0800030')->is_valid_number, '北海道帯広市大通北');
ok($zip->set_number('0800031')->is_valid_number, '北海道帯広市西一条北');
ok($zip->set_number('0800032')->is_valid_number, '北海道帯広市西二条北');
ok($zip->set_number('0800033')->is_valid_number, '北海道帯広市西三条北');
ok($zip->set_number('0800034')->is_valid_number, '北海道帯広市西四条北');
ok($zip->set_number('0800035')->is_valid_number, '北海道帯広市西五条北');
ok($zip->set_number('0800036')->is_valid_number, '北海道帯広市西六条北');
ok($zip->set_number('0800037')->is_valid_number, '北海道帯広市西七条北');
ok($zip->set_number('0800038')->is_valid_number, '北海道帯広市西八条北');
ok($zip->set_number('0800039')->is_valid_number, '北海道帯広市西九条北');
ok($zip->set_number('0800040')->is_valid_number, '北海道帯広市西十条北');
ok($zip->set_number('0800041')->is_valid_number, '北海道帯広市西十一条北');
ok($zip->set_number('0800042')->is_valid_number, '北海道帯広市西十二条北');
ok($zip->set_number('0800043')->is_valid_number, '北海道帯広市西十三条北');
ok($zip->set_number('0800044')->is_valid_number, '北海道帯広市西十四条北');
ok($zip->set_number('0800045')->is_valid_number, '北海道帯広市西十五条北');
ok($zip->set_number('0800046')->is_valid_number, '北海道帯広市西十六条北');
ok($zip->set_number('0800047')->is_valid_number, '北海道帯広市西十七条北');
ok($zip->set_number('0800048')->is_valid_number, '北海道帯広市西十八条北');
ok($zip->set_number('0800050')->is_valid_number, '北海道帯広市白樺十六条東');
ok($zip->set_number('0800051')->is_valid_number, '北海道帯広市白樺十六条西');
ok($zip->set_number('0800052')->is_valid_number, '北海道帯広市新町東');
ok($zip->set_number('0800053')->is_valid_number, '北海道帯広市新町西');
ok($zip->set_number('0800054')->is_valid_number, '北海道帯広市柏林台北町');
ok($zip->set_number('0800055')->is_valid_number, '北海道帯広市柏林台東町');
ok($zip->set_number('0800056')->is_valid_number, '北海道帯広市柏林台南町');
ok($zip->set_number('0800057')->is_valid_number, '北海道帯広市柏林台中町');
ok($zip->set_number('0800058')->is_valid_number, '北海道帯広市柏林台西町');
ok($zip->set_number('0800100')->is_valid_number, '北海道河東郡音更町以下に掲載がない場合');
ok($zip->set_number('0800101')->is_valid_number, '北海道河東郡音更町大通');
ok($zip->set_number('0800102')->is_valid_number, '北海道河東郡音更町大通北');
ok($zip->set_number('0800103')->is_valid_number, '北海道河東郡音更町元町');
ok($zip->set_number('0800104')->is_valid_number, '北海道河東郡音更町新通');
ok($zip->set_number('0800105')->is_valid_number, '北海道河東郡音更町新通北');
ok($zip->set_number('0800106')->is_valid_number, '北海道河東郡音更町東通');
ok($zip->set_number('0800111')->is_valid_number, '北海道河東郡音更町木野大通東');
ok($zip->set_number('0800112')->is_valid_number, '北海道河東郡音更町木野東通');
ok($zip->set_number('0800121')->is_valid_number, '北海道河東郡音更町柳町北区');
ok($zip->set_number('0800122')->is_valid_number, '北海道河東郡音更町柳町仲区');
ok($zip->set_number('0800123')->is_valid_number, '北海道河東郡音更町柳町南区');
ok($zip->set_number('0800131')->is_valid_number, '北海道河東郡音更町宝来本通');
ok($zip->set_number('0800132')->is_valid_number, '北海道河東郡音更町宝来仲町北');
ok($zip->set_number('0800133')->is_valid_number, '北海道河東郡音更町宝来東町北');
ok($zip->set_number('0800134')->is_valid_number, '北海道河東郡音更町宝来西町南');
ok($zip->set_number('0800135')->is_valid_number, '北海道河東郡音更町宝来仲町南');
ok($zip->set_number('0800136')->is_valid_number, '北海道河東郡音更町宝来東町南');
ok($zip->set_number('0800137')->is_valid_number, '北海道河東郡音更町宝来南一条');
ok($zip->set_number('0800138')->is_valid_number, '北海道河東郡音更町宝来南二条');
ok($zip->set_number('0800139')->is_valid_number, '北海道河東郡音更町宝来西町北');
ok($zip->set_number('0800141')->is_valid_number, '北海道河東郡音更町宝来北一条');
ok($zip->set_number('0800142')->is_valid_number, '北海道河東郡音更町宝来北二条');
ok($zip->set_number('0800143')->is_valid_number, '北海道河東郡音更町宝来北三条');
ok($zip->set_number('0800144')->is_valid_number, '北海道河東郡音更町宝来北四条');
ok($zip->set_number('0800145')->is_valid_number, '北海道河東郡音更町宝来北五条');
ok($zip->set_number('0800146')->is_valid_number, '北海道河東郡音更町宝来北六条');
ok($zip->set_number('0800151')->is_valid_number, '北海道河東郡音更町東和');
ok($zip->set_number('0800161')->is_valid_number, '北海道河東郡音更町ひびき野東町');
ok($zip->set_number('0800162')->is_valid_number, '北海道河東郡音更町ひびき野仲町');
ok($zip->set_number('0800163')->is_valid_number, '北海道河東郡音更町ひびき野西町');
ok($zip->set_number('0800261')->is_valid_number, '北海道河東郡音更町十勝川温泉');
ok($zip->set_number('0800262')->is_valid_number, '北海道河東郡音更町十勝川温泉北');
ok($zip->set_number('0800263')->is_valid_number, '北海道河東郡音更町十勝川温泉南');
ok($zip->set_number('0800271')->is_valid_number, '北海道河東郡音更町長流枝');
ok($zip->set_number('0800271')->is_valid_number, '北海道河東郡音更町長流枝幹線');
ok($zip->set_number('0800272')->is_valid_number, '北海道河東郡音更町下士幌');
ok($zip->set_number('0800272')->is_valid_number, '北海道河東郡音更町下士幌幹線');
ok($zip->set_number('0800301')->is_valid_number, '北海道河東郡音更町木野大通西');
ok($zip->set_number('0800302')->is_valid_number, '北海道河東郡音更町木野西通');
ok($zip->set_number('0800303')->is_valid_number, '北海道河東郡音更町木野公園下町');
ok($zip->set_number('0800304')->is_valid_number, '北海道河東郡音更町木野新町');
ok($zip->set_number('0800305')->is_valid_number, '北海道河東郡音更町北鈴蘭北');
ok($zip->set_number('0800306')->is_valid_number, '北海道河東郡音更町北鈴蘭南');
ok($zip->set_number('0800307')->is_valid_number, '北海道河東郡音更町中鈴蘭北');
ok($zip->set_number('0800308')->is_valid_number, '北海道河東郡音更町中鈴蘭南');
ok($zip->set_number('0800309')->is_valid_number, '北海道河東郡音更町中鈴蘭元町');
ok($zip->set_number('0800311')->is_valid_number, '北海道河東郡音更町南鈴蘭北');
ok($zip->set_number('0800312')->is_valid_number, '北海道河東郡音更町南鈴蘭南');
ok($zip->set_number('0800313')->is_valid_number, '北海道河東郡音更町鈴蘭公園');
ok($zip->set_number('0800314')->is_valid_number, '北海道河東郡音更町共栄台西');
ok($zip->set_number('0800315')->is_valid_number, '北海道河東郡音更町共栄台東');
ok($zip->set_number('0800316')->is_valid_number, '北海道河東郡音更町緑陽台北区');
ok($zip->set_number('0800317')->is_valid_number, '北海道河東郡音更町緑陽台仲区');
ok($zip->set_number('0800318')->is_valid_number, '北海道河東郡音更町緑陽台南区');
ok($zip->set_number('0800321')->is_valid_number, '北海道河東郡音更町桜が丘');
ok($zip->set_number('0800322')->is_valid_number, '北海道河東郡音更町桜が丘西');
ok($zip->set_number('0800323')->is_valid_number, '北海道河東郡音更町住吉台');
ok($zip->set_number('0800324')->is_valid_number, '北海道河東郡音更町南住吉台');
ok($zip->set_number('0800325')->is_valid_number, '北海道河東郡音更町柏寿台');
ok($zip->set_number('0800326')->is_valid_number, '北海道河東郡音更町北明台');
ok($zip->set_number('0800327')->is_valid_number, '北海道河東郡音更町北陽台');
ok($zip->set_number('0800330')->is_valid_number, '北海道河東郡音更町雄飛が丘');
ok($zip->set_number('0800331')->is_valid_number, '北海道河東郡音更町雄飛が丘北区');
ok($zip->set_number('0800332')->is_valid_number, '北海道河東郡音更町雄飛が丘仲区');
ok($zip->set_number('0800333')->is_valid_number, '北海道河東郡音更町雄飛が丘南区');
ok($zip->set_number('0800334')->is_valid_number, '北海道河東郡音更町緑が丘');
ok($zip->set_number('0800335')->is_valid_number, '北海道河東郡音更町希望が丘');
ok($zip->set_number('0800341')->is_valid_number, '北海道河東郡音更町音更');
ok($zip->set_number('0800342')->is_valid_number, '北海道河東郡音更町下音更');
ok($zip->set_number('0800343')->is_valid_number, '北海道河東郡音更町東士狩');
ok($zip->set_number('0800344')->is_valid_number, '北海道河東郡音更町万年');
ok($zip->set_number('0800345')->is_valid_number, '北海道河東郡音更町高倉');
ok($zip->set_number('0800351')->is_valid_number, '北海道河東郡音更町然別');
ok($zip->set_number('0800361')->is_valid_number, '北海道河東郡音更町すずらん台北町');
ok($zip->set_number('0800362')->is_valid_number, '北海道河東郡音更町すずらん台仲町');
ok($zip->set_number('0800363')->is_valid_number, '北海道河東郡音更町すずらん台南町');
ok($zip->set_number('0800561')->is_valid_number, '北海道河東郡音更町豊田');
ok($zip->set_number('0800562')->is_valid_number, '北海道河東郡音更町東音更');
ok($zip->set_number('0800563')->is_valid_number, '北海道河東郡音更町駒場平和台');
ok($zip->set_number('0800564')->is_valid_number, '北海道河東郡音更町駒場北町');
ok($zip->set_number('0800564')->is_valid_number, '北海道河東郡音更町駒場北1条通');
ok($zip->set_number('0800564')->is_valid_number, '北海道河東郡音更町駒場北2条通');
ok($zip->set_number('0800565')->is_valid_number, '北海道河東郡音更町駒場本通');
ok($zip->set_number('0800566')->is_valid_number, '北海道河東郡音更町駒場南1条通');
ok($zip->set_number('0800566')->is_valid_number, '北海道河東郡音更町駒場南2条通');
ok($zip->set_number('0800567')->is_valid_number, '北海道河東郡音更町駒場南3条通');
ok($zip->set_number('0800567')->is_valid_number, '北海道河東郡音更町駒場南4条通');
ok($zip->set_number('0800568')->is_valid_number, '北海道河東郡音更町駒場東');
ok($zip->set_number('0800571')->is_valid_number, '北海道河東郡音更町駒場');
ok($zip->set_number('0800572')->is_valid_number, '北海道河東郡音更町駒場並木');
ok($zip->set_number('0800573')->is_valid_number, '北海道河東郡音更町駒場南');
ok($zip->set_number('0800574')->is_valid_number, '北海道河東郡音更町駒場西');
ok($zip->set_number('0800575')->is_valid_number, '北海道河東郡音更町上然別');
ok($zip->set_number('0800576')->is_valid_number, '北海道河東郡音更町南中音更');
ok($zip->set_number('0800577')->is_valid_number, '北海道河東郡音更町西中音更');
ok($zip->set_number('0800578')->is_valid_number, '北海道河東郡音更町中音更');
ok($zip->set_number('0800801')->is_valid_number, '北海道帯広市東一条南');
ok($zip->set_number('0800802')->is_valid_number, '北海道帯広市東二条南');
ok($zip->set_number('0800803')->is_valid_number, '北海道帯広市東三条南');
ok($zip->set_number('0800804')->is_valid_number, '北海道帯広市東四条南');
ok($zip->set_number('0800805')->is_valid_number, '北海道帯広市東五条南');
ok($zip->set_number('0800806')->is_valid_number, '北海道帯広市東六条南');
ok($zip->set_number('0800807')->is_valid_number, '北海道帯広市東七条南');
ok($zip->set_number('0800808')->is_valid_number, '北海道帯広市東八条南');
ok($zip->set_number('0800809')->is_valid_number, '北海道帯広市東九条南');
ok($zip->set_number('0800810')->is_valid_number, '北海道帯広市東十条南');
ok($zip->set_number('0800811')->is_valid_number, '北海道帯広市東十一条南');
ok($zip->set_number('0800812')->is_valid_number, '北海道帯広市東十二条南');
ok($zip->set_number('0800813')->is_valid_number, '北海道帯広市東十三条南');
ok($zip->set_number('0800814')->is_valid_number, '北海道帯広市東十四条南');
ok($zip->set_number('0800815')->is_valid_number, '北海道帯広市東十五条南');
ok($zip->set_number('0800816')->is_valid_number, '北海道帯広市大川町');
ok($zip->set_number('0800817')->is_valid_number, '北海道帯広市依田町');
ok($zip->set_number('0800821')->is_valid_number, '北海道帯広市東一条北');
ok($zip->set_number('0800822')->is_valid_number, '北海道帯広市東二条北');
ok($zip->set_number('0800823')->is_valid_number, '北海道帯広市東三条北');
ok($zip->set_number('0800824')->is_valid_number, '北海道帯広市東四条北');
ok($zip->set_number('0800831')->is_valid_number, '北海道帯広市稲田町南');
ok($zip->set_number('0800832')->is_valid_number, '北海道帯広市稲田町東');
ok($zip->set_number('0800833')->is_valid_number, '北海道帯広市稲田町基線');
ok($zip->set_number('0800834')->is_valid_number, '北海道帯広市稲田町西');
ok($zip->set_number('0800835')->is_valid_number, '北海道帯広市稲田町');
ok($zip->set_number('0800836')->is_valid_number, '北海道帯広市空港南町');
ok($zip->set_number('0800837')->is_valid_number, '北海道帯広市空港南町南');
ok($zip->set_number('0800838')->is_valid_number, '北海道帯広市大空町');
ok($zip->set_number('0800841')->is_valid_number, '北海道帯広市緑ケ丘一条通');
ok($zip->set_number('0800842')->is_valid_number, '北海道帯広市緑ケ丘二条通');
ok($zip->set_number('0800843')->is_valid_number, '北海道帯広市緑ケ丘三条通');
ok($zip->set_number('0800844')->is_valid_number, '北海道帯広市緑ケ丘東通東');
ok($zip->set_number('0800845')->is_valid_number, '北海道帯広市緑ケ丘東通西');
ok($zip->set_number('0800846')->is_valid_number, '北海道帯広市緑ケ丘');
ok($zip->set_number('0800847')->is_valid_number, '北海道帯広市公園東町');
ok($zip->set_number('0800848')->is_valid_number, '北海道帯広市自由が丘(1、2丁目)');
ok($zip->set_number('0800856')->is_valid_number, '北海道帯広市南町南');
ok($zip->set_number('0800857')->is_valid_number, '北海道帯広市南町');
ok($zip->set_number('0800861')->is_valid_number, '北海道帯広市南の森東');
ok($zip->set_number('0800862')->is_valid_number, '北海道帯広市南の森西');
ok($zip->set_number('0800871')->is_valid_number, '北海道帯広市清流東');
ok($zip->set_number('0800872')->is_valid_number, '北海道帯広市清流西');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町共豊');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町士幌(南一区18号~21号南)');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町東台');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町富秋');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌勝和');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌北');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌北団地');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌共進');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌新東団地');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌新南');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌西');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌東団地');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌文化');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌豊進');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌南');
ok($zip->set_number('0801189')->is_valid_number, '北海道河東郡士幌町中士幌明生');
ok($zip->set_number('0801200')->is_valid_number, '北海道河東郡士幌町以下に掲載がない場合');
ok($zip->set_number('0801201')->is_valid_number, '北海道河東郡士幌町平原第一');
ok($zip->set_number('0801202')->is_valid_number, '北海道河東郡士幌町平原');
ok($zip->set_number('0801203')->is_valid_number, '北海道河東郡士幌町いこい');
ok($zip->set_number('0801204')->is_valid_number, '北海道河東郡士幌町松並');
ok($zip->set_number('0801211')->is_valid_number, '北海道河東郡士幌町若葉第一');
ok($zip->set_number('0801212')->is_valid_number, '北海道河東郡士幌町若葉東');
ok($zip->set_number('0801213')->is_valid_number, '北海道河東郡士幌町新生');
ok($zip->set_number('0801214')->is_valid_number, '北海道河東郡士幌町本通');
ok($zip->set_number('0801215')->is_valid_number, '北海道河東郡士幌町仲通');
ok($zip->set_number('0801216')->is_valid_number, '北海道河東郡士幌町高徳');
ok($zip->set_number('0801217')->is_valid_number, '北海道河東郡士幌町若葉');
ok($zip->set_number('0801221')->is_valid_number, '北海道河東郡士幌町互譲');
ok($zip->set_number('0801222')->is_valid_number, '北海道河東郡士幌町神苑');
ok($zip->set_number('0801223')->is_valid_number, '北海道河東郡士幌町大通');
ok($zip->set_number('0801224')->is_valid_number, '北海道河東郡士幌町柏葉');
ok($zip->set_number('0801225')->is_valid_number, '北海道河東郡士幌町みどり');
ok($zip->set_number('0801226')->is_valid_number, '北海道河東郡士幌町大通西');
ok($zip->set_number('0801227')->is_valid_number, '北海道河東郡士幌町中央');
ok($zip->set_number('0801231')->is_valid_number, '北海道河東郡士幌町睦');
ok($zip->set_number('0801232')->is_valid_number, '北海道河東郡士幌町睦西');
ok($zip->set_number('0801233')->is_valid_number, '北海道河東郡士幌町睦南');
ok($zip->set_number('0801234')->is_valid_number, '北海道河東郡士幌町南団地');
ok($zip->set_number('0801235')->is_valid_number, '北海道河東郡士幌町緑光');
ok($zip->set_number('0801236')->is_valid_number, '北海道河東郡士幌町美園');
ok($zip->set_number('0801241')->is_valid_number, '北海道河東郡士幌町西居辺北');
ok($zip->set_number('0801242')->is_valid_number, '北海道河東郡士幌町松室');
ok($zip->set_number('0801243')->is_valid_number, '北海道河東郡士幌町西居辺');
ok($zip->set_number('0801244')->is_valid_number, '北海道河東郡士幌町柏');
ok($zip->set_number('0801245')->is_valid_number, '北海道河東郡士幌町共成');
ok($zip->set_number('0801246')->is_valid_number, '北海道河東郡士幌町士幌(北一区)');
ok($zip->set_number('0801247')->is_valid_number, '北海道河東郡士幌町平和');
ok($zip->set_number('0801248')->is_valid_number, '北海道河東郡士幌町柏野');
ok($zip->set_number('0801251')->is_valid_number, '北海道河東郡士幌町新盛');
ok($zip->set_number('0801252')->is_valid_number, '北海道河東郡士幌町豊年');
ok($zip->set_number('0801253')->is_valid_number, '北海道河東郡士幌町士幌(南一区21号北~29号)');
ok($zip->set_number('0801254')->is_valid_number, '北海道河東郡士幌町士幌(南旭区)');
ok($zip->set_number('0801255')->is_valid_number, '北海道河東郡士幌町新光');
ok($zip->set_number('0801256')->is_valid_number, '北海道河東郡士幌町佐倉');
ok($zip->set_number('0801257')->is_valid_number, '北海道河東郡士幌町双葉');
ok($zip->set_number('0801261')->is_valid_number, '北海道河東郡士幌町西士幌');
ok($zip->set_number('0801262')->is_valid_number, '北海道河東郡士幌町常盤');
ok($zip->set_number('0801263')->is_valid_number, '北海道河東郡士幌町吉野');
ok($zip->set_number('0801264')->is_valid_number, '北海道河東郡士幌町西吉野');
ok($zip->set_number('0801265')->is_valid_number, '北海道河東郡士幌町新栄');
ok($zip->set_number('0801266')->is_valid_number, '北海道河東郡士幌町新田');
ok($zip->set_number('0801267')->is_valid_number, '北海道河東郡士幌町共立');
ok($zip->set_number('0801271')->is_valid_number, '北海道河東郡士幌町西上');
ok($zip->set_number('0801272')->is_valid_number, '北海道河東郡士幌町百戸');
ok($zip->set_number('0801273')->is_valid_number, '北海道河東郡士幌町中音更');
ok($zip->set_number('0801274')->is_valid_number, '北海道河東郡士幌町共益');
ok($zip->set_number('0801275')->is_valid_number, '北海道河東郡士幌町コマクサ');
ok($zip->set_number('0801276')->is_valid_number, '北海道河東郡士幌町新田第一');
ok($zip->set_number('0801277')->is_valid_number, '北海道河東郡士幌町新田第二');
ok($zip->set_number('0801278')->is_valid_number, '北海道河東郡士幌町栄進');
ok($zip->set_number('0801281')->is_valid_number, '北海道河東郡士幌町朝陽');
ok($zip->set_number('0801282')->is_valid_number, '北海道河東郡士幌町友愛');
ok($zip->set_number('0801283')->is_valid_number, '北海道河東郡士幌町高砂');
ok($zip->set_number('0801284')->is_valid_number, '北海道河東郡士幌町清澄');
ok($zip->set_number('0801285')->is_valid_number, '北海道河東郡士幌町下居辺');
ok($zip->set_number('0801286')->is_valid_number, '北海道河東郡士幌町開運');
ok($zip->set_number('0801287')->is_valid_number, '北海道河東郡士幌町北開');
ok($zip->set_number('0801288')->is_valid_number, '北海道河東郡士幌町北上居辺');
ok($zip->set_number('0801400')->is_valid_number, '北海道河東郡上士幌町以下に掲載がない場合');
ok($zip->set_number('0801401')->is_valid_number, '北海道河東郡上士幌町三股');
ok($zip->set_number('0801402')->is_valid_number, '北海道河東郡上士幌町幌加');
ok($zip->set_number('0801403')->is_valid_number, '北海道河東郡上士幌町ぬかびら源泉郷');
ok($zip->set_number('0801404')->is_valid_number, '北海道河東郡上士幌町黒石平');
ok($zip->set_number('0801405')->is_valid_number, '北海道河東郡上士幌町清水谷');
ok($zip->set_number('0801406')->is_valid_number, '北海道河東郡上士幌町居辺');
ok($zip->set_number('0801407')->is_valid_number, '北海道河東郡上士幌町上音更');
ok($zip->set_number('0801408')->is_valid_number, '北海道河東郡上士幌町上士幌');
ok($zip->set_number('0802101')->is_valid_number, '北海道帯広市清川町');
ok($zip->set_number('0802102')->is_valid_number, '北海道帯広市清川町基線');
ok($zip->set_number('0802103')->is_valid_number, '北海道帯広市清川町西');
ok($zip->set_number('0802104')->is_valid_number, '北海道帯広市清川町東');
ok($zip->set_number('0802105')->is_valid_number, '北海道帯広市太平町');
ok($zip->set_number('0802106')->is_valid_number, '北海道帯広市美栄町(その他)');
ok($zip->set_number('0802111')->is_valid_number, '北海道帯広市上清川町');
ok($zip->set_number('0802112')->is_valid_number, '北海道帯広市上清川町基線');
ok($zip->set_number('0802113')->is_valid_number, '北海道帯広市上清川町西');
ok($zip->set_number('0802114')->is_valid_number, '北海道帯広市上清川町東');
ok($zip->set_number('0802115')->is_valid_number, '北海道帯広市清川町仲通');
ok($zip->set_number('0802116')->is_valid_number, '北海道帯広市清川町本通');
ok($zip->set_number('0802117')->is_valid_number, '北海道帯広市太平町西');
ok($zip->set_number('0802121')->is_valid_number, '北海道帯広市岩内町');
ok($zip->set_number('0802122')->is_valid_number, '北海道帯広市岩内町第1基線');
ok($zip->set_number('0802123')->is_valid_number, '北海道帯広市岩内町西');
ok($zip->set_number('0802124')->is_valid_number, '北海道帯広市岩内町東');
ok($zip->set_number('0802331')->is_valid_number, '北海道帯広市基松町');
ok($zip->set_number('0802332')->is_valid_number, '北海道帯広市富士町(西4~8線49~78番地)');
ok($zip->set_number('0802333')->is_valid_number, '北海道帯広市美栄町(西5~8線79~110番地)');
ok($zip->set_number('0802334')->is_valid_number, '北海道帯広市上帯広町');
ok($zip->set_number('0802335')->is_valid_number, '北海道帯広市広野町');
ok($zip->set_number('0802336')->is_valid_number, '北海道帯広市八千代町');
ok($zip->set_number('0802337')->is_valid_number, '北海道帯広市拓成町');
ok($zip->set_number('0802459')->is_valid_number, '北海道帯広市西十九条北');
ok($zip->set_number('0802460')->is_valid_number, '北海道帯広市西二十条北');
ok($zip->set_number('0802461')->is_valid_number, '北海道帯広市西二十一条北');
ok($zip->set_number('0802462')->is_valid_number, '北海道帯広市西二十二条北');
ok($zip->set_number('0802463')->is_valid_number, '北海道帯広市西二十三条北');
ok($zip->set_number('0802464')->is_valid_number, '北海道帯広市西二十四条北');
ok($zip->set_number('0802465')->is_valid_number, '北海道帯広市西二十五条北');
ok($zip->set_number('0802469')->is_valid_number, '北海道帯広市西十九条南(1~5丁目)');
ok($zip->set_number('0802470')->is_valid_number, '北海道帯広市西二十条南');
ok($zip->set_number('0802471')->is_valid_number, '北海道帯広市西二十一条南');
ok($zip->set_number('0802472')->is_valid_number, '北海道帯広市西二十二条南');
ok($zip->set_number('0802473')->is_valid_number, '北海道帯広市西二十三条南');
ok($zip->set_number('0802474')->is_valid_number, '北海道帯広市西二十四条南');
ok($zip->set_number('0802475')->is_valid_number, '北海道帯広市西二十五条南');
ok($zip->set_number('0802476')->is_valid_number, '北海道帯広市自由が丘(3~7丁目)');
ok($zip->set_number('0810000')->is_valid_number, '北海道上川郡新得町以下に掲載がない場合');
ok($zip->set_number('0810001')->is_valid_number, '北海道上川郡新得町一条北');
ok($zip->set_number('0810002')->is_valid_number, '北海道上川郡新得町二条北');
ok($zip->set_number('0810003')->is_valid_number, '北海道上川郡新得町三条北');
ok($zip->set_number('0810005')->is_valid_number, '北海道上川郡新得町本通北');
ok($zip->set_number('0810006')->is_valid_number, '北海道上川郡新得町栄町');
ok($zip->set_number('0810007')->is_valid_number, '北海道上川郡新得町元町');
ok($zip->set_number('0810008')->is_valid_number, '北海道上川郡新得町本通南');
ok($zip->set_number('0810011')->is_valid_number, '北海道上川郡新得町一条南');
ok($zip->set_number('0810012')->is_valid_number, '北海道上川郡新得町二条南');
ok($zip->set_number('0810013')->is_valid_number, '北海道上川郡新得町三条南');
ok($zip->set_number('0810014')->is_valid_number, '北海道上川郡新得町四条南');
ok($zip->set_number('0810015')->is_valid_number, '北海道上川郡新得町五条南');
ok($zip->set_number('0810021')->is_valid_number, '北海道上川郡新得町西一条北');
ok($zip->set_number('0810022')->is_valid_number, '北海道上川郡新得町西二条北');
ok($zip->set_number('0810023')->is_valid_number, '北海道上川郡新得町西三条北');
ok($zip->set_number('0810031')->is_valid_number, '北海道上川郡新得町西一条南');
ok($zip->set_number('0810032')->is_valid_number, '北海道上川郡新得町西二条南');
ok($zip->set_number('0810033')->is_valid_number, '北海道上川郡新得町西三条南');
ok($zip->set_number('0810034')->is_valid_number, '北海道上川郡新得町西四条南');
ok($zip->set_number('0810035')->is_valid_number, '北海道上川郡新得町上佐幌');
ok($zip->set_number('0810036')->is_valid_number, '北海道上川郡新得町下佐幌');
ok($zip->set_number('0810037')->is_valid_number, '北海道上川郡新得町拓鉄');
ok($zip->set_number('0810038')->is_valid_number, '北海道上川郡新得町新得');
ok($zip->set_number('0810039')->is_valid_number, '北海道上川郡新得町新内');
ok($zip->set_number('0810151')->is_valid_number, '北海道上川郡新得町屈足旭町');
ok($zip->set_number('0810152')->is_valid_number, '北海道上川郡新得町屈足旭町東');
ok($zip->set_number('0810153')->is_valid_number, '北海道上川郡新得町屈足南町');
ok($zip->set_number('0810154')->is_valid_number, '北海道上川郡新得町屈足');
ok($zip->set_number('0810155')->is_valid_number, '北海道上川郡新得町屈足幸町');
ok($zip->set_number('0810156')->is_valid_number, '北海道上川郡新得町屈足幸町西');
ok($zip->set_number('0810161')->is_valid_number, '北海道上川郡新得町屈足柏町');
ok($zip->set_number('0810162')->is_valid_number, '北海道上川郡新得町屈足柏町東');
ok($zip->set_number('0810163')->is_valid_number, '北海道上川郡新得町屈足緑町');
ok($zip->set_number('0810164')->is_valid_number, '北海道上川郡新得町屈足緑町西');
ok($zip->set_number('0810200')->is_valid_number, '北海道河東郡鹿追町以下に掲載がない場合');
ok($zip->set_number('0810201')->is_valid_number, '北海道河東郡鹿追町新町');
ok($zip->set_number('0810202')->is_valid_number, '北海道河東郡鹿追町北町');
ok($zip->set_number('0810203')->is_valid_number, '北海道河東郡鹿追町緑町');
ok($zip->set_number('0810204')->is_valid_number, '北海道河東郡鹿追町笹川北');
ok($zip->set_number('0810205')->is_valid_number, '北海道河東郡鹿追町西笹川');
ok($zip->set_number('0810211')->is_valid_number, '北海道河東郡鹿追町仲町');
ok($zip->set_number('0810212')->is_valid_number, '北海道河東郡鹿追町泉町');
ok($zip->set_number('0810213')->is_valid_number, '北海道河東郡鹿追町西町');
ok($zip->set_number('0810214')->is_valid_number, '北海道河東郡鹿追町北鹿追北');
ok($zip->set_number('0810215')->is_valid_number, '北海道河東郡鹿追町鹿追南');
ok($zip->set_number('0810216')->is_valid_number, '北海道河東郡鹿追町鹿追北');
ok($zip->set_number('0810217')->is_valid_number, '北海道河東郡鹿追町鹿追基線');
ok($zip->set_number('0810218')->is_valid_number, '北海道河東郡鹿追町上然別西');
ok($zip->set_number('0810221')->is_valid_number, '北海道河東郡鹿追町栄町');
ok($zip->set_number('0810222')->is_valid_number, '北海道河東郡鹿追町東町');
ok($zip->set_number('0810223')->is_valid_number, '北海道河東郡鹿追町南町');
ok($zip->set_number('0810224')->is_valid_number, '北海道河東郡鹿追町元町');
ok($zip->set_number('0810225')->is_valid_number, '北海道河東郡鹿追町柏ケ丘');
ok($zip->set_number('0810226')->is_valid_number, '北海道河東郡鹿追町上幌内');
ok($zip->set_number('0810227')->is_valid_number, '北海道河東郡鹿追町幌内西');
ok($zip->set_number('0810228')->is_valid_number, '北海道河東郡鹿追町美蔓西');
ok($zip->set_number('0810341')->is_valid_number, '北海道河東郡鹿追町瓜幕西');
ok($zip->set_number('0810342')->is_valid_number, '北海道河東郡鹿追町瓜幕東');
ok($zip->set_number('0810343')->is_valid_number, '北海道河東郡鹿追町瓜幕南');
ok($zip->set_number('0810344')->is_valid_number, '北海道河東郡鹿追町北瓜幕');
ok($zip->set_number('0810345')->is_valid_number, '北海道河東郡鹿追町中瓜幕西');
ok($zip->set_number('0810346')->is_valid_number, '北海道河東郡鹿追町東瓜幕西');
ok($zip->set_number('0820000')->is_valid_number, '北海道河西郡芽室町以下に掲載がない場合');
ok($zip->set_number('0820001')->is_valid_number, '北海道河西郡芽室町平和');
ok($zip->set_number('0820002')->is_valid_number, '北海道河西郡芽室町北明(光勇)');
ok($zip->set_number('0820003')->is_valid_number, '北海道河西郡芽室町西士狩(国見)');
ok($zip->set_number('0820004')->is_valid_number, '北海道河西郡芽室町東芽室北(下美生)');
ok($zip->set_number('0820005')->is_valid_number, '北海道河西郡芽室町東芽室基線(日甜)');
ok($zip->set_number('0820006')->is_valid_number, '北海道河西郡芽室町東芽室南(大成)');
ok($zip->set_number('0820007')->is_valid_number, '北海道河西郡芽室町北芽室(芽室太、美藁)');
ok($zip->set_number('0820008')->is_valid_number, '北海道河西郡芽室町毛根');
ok($zip->set_number('0820009')->is_valid_number, '北海道河西郡芽室町祥栄西');
ok($zip->set_number('0820010')->is_valid_number, '北海道河西郡芽室町祥栄北');
ok($zip->set_number('0820011')->is_valid_number, '北海道河西郡芽室町東一条');
ok($zip->set_number('0820012')->is_valid_number, '北海道河西郡芽室町東二条');
ok($zip->set_number('0820013')->is_valid_number, '北海道河西郡芽室町東三条');
ok($zip->set_number('0820014')->is_valid_number, '北海道河西郡芽室町東四条');
ok($zip->set_number('0820015')->is_valid_number, '北海道河西郡芽室町東五条');
ok($zip->set_number('0820016')->is_valid_number, '北海道河西郡芽室町東六条');
ok($zip->set_number('0820017')->is_valid_number, '北海道河西郡芽室町東七条');
ok($zip->set_number('0820018')->is_valid_number, '北海道河西郡芽室町東八条');
ok($zip->set_number('0820019')->is_valid_number, '北海道河西郡芽室町東九条');
ok($zip->set_number('0820020')->is_valid_number, '北海道河西郡芽室町東十条');
ok($zip->set_number('0820021')->is_valid_number, '北海道河西郡芽室町東十一条');
ok($zip->set_number('0820022')->is_valid_number, '北海道河西郡芽室町東十二条');
ok($zip->set_number('0820030')->is_valid_number, '北海道河西郡芽室町本通');
ok($zip->set_number('0820031')->is_valid_number, '北海道河西郡芽室町西一条');
ok($zip->set_number('0820032')->is_valid_number, '北海道河西郡芽室町西二条');
ok($zip->set_number('0820033')->is_valid_number, '北海道河西郡芽室町西三条');
ok($zip->set_number('0820034')->is_valid_number, '北海道河西郡芽室町西四条');
ok($zip->set_number('0820035')->is_valid_number, '北海道河西郡芽室町西五条');
ok($zip->set_number('0820036')->is_valid_number, '北海道河西郡芽室町西六条');
ok($zip->set_number('0820037')->is_valid_number, '北海道河西郡芽室町西七条');
ok($zip->set_number('0820038')->is_valid_number, '北海道河西郡芽室町西八条');
ok($zip->set_number('0820039')->is_valid_number, '北海道河西郡芽室町西九条');
ok($zip->set_number('0820040')->is_valid_number, '北海道河西郡芽室町西十条');
ok($zip->set_number('0820041')->is_valid_number, '北海道河西郡芽室町西十一条');
ok($zip->set_number('0820042')->is_valid_number, '北海道河西郡芽室町芽室北(西芽室、中島)');
ok($zip->set_number('0820043')->is_valid_number, '北海道河西郡芽室町芽室基線(元町)');
ok($zip->set_number('0820044')->is_valid_number, '北海道河西郡芽室町芽室南(南弥生、高岩)');
ok($zip->set_number('0820051')->is_valid_number, '北海道河西郡芽室町東一条南');
ok($zip->set_number('0820052')->is_valid_number, '北海道河西郡芽室町東二条南');
ok($zip->set_number('0820053')->is_valid_number, '北海道河西郡芽室町東三条南');
ok($zip->set_number('0820054')->is_valid_number, '北海道河西郡芽室町東四条南');
ok($zip->set_number('0820056')->is_valid_number, '北海道河西郡芽室町東六条南');
ok($zip->set_number('0820057')->is_valid_number, '北海道河西郡芽室町東七条南');
ok($zip->set_number('0820060')->is_valid_number, '北海道河西郡芽室町本通南');
ok($zip->set_number('0820061')->is_valid_number, '北海道河西郡芽室町西一条南');
ok($zip->set_number('0820062')->is_valid_number, '北海道河西郡芽室町西二条南');
ok($zip->set_number('0820063')->is_valid_number, '北海道河西郡芽室町西三条南');
ok($zip->set_number('0820064')->is_valid_number, '北海道河西郡芽室町西四条南');
ok($zip->set_number('0820071')->is_valid_number, '北海道河西郡芽室町新生');
ok($zip->set_number('0820072')->is_valid_number, '北海道河西郡芽室町北伏古南');
ok($zip->set_number('0820073')->is_valid_number, '北海道河西郡芽室町中伏古');
ok($zip->set_number('0820074')->is_valid_number, '北海道河西郡芽室町栄(柏友、光栄、豊来、常盤、丸山)');
ok($zip->set_number('0820075')->is_valid_number, '北海道河西郡芽室町坂の上(博進)');
ok($zip->set_number('0820076')->is_valid_number, '北海道河西郡芽室町美生');
ok($zip->set_number('0820077')->is_valid_number, '北海道河西郡芽室町上芽室南');
ok($zip->set_number('0820078')->is_valid_number, '北海道河西郡芽室町渋山(その他)');
ok($zip->set_number('0820079')->is_valid_number, '北海道河西郡芽室町新朝日');
ok($zip->set_number('0820081')->is_valid_number, '北海道河西郡芽室町新生南');
ok($zip->set_number('0820082')->is_valid_number, '北海道河西郡芽室町北伏古東');
ok($zip->set_number('0820083')->is_valid_number, '北海道河西郡芽室町中伏古東');
ok($zip->set_number('0820084')->is_valid_number, '北海道河西郡芽室町上芽室北');
ok($zip->set_number('0820085')->is_valid_number, '北海道河西郡芽室町上芽室基線');
ok($zip->set_number('0820086')->is_valid_number, '北海道河西郡芽室町中美生');
ok($zip->set_number('0820087')->is_valid_number, '北海道河西郡芽室町上芽室東');
ok($zip->set_number('0820381')->is_valid_number, '北海道河西郡芽室町上伏古');
ok($zip->set_number('0820382')->is_valid_number, '北海道河西郡芽室町雄馬別');
ok($zip->set_number('0820383')->is_valid_number, '北海道河西郡芽室町伏美');
ok($zip->set_number('0820384')->is_valid_number, '北海道河西郡芽室町上美生');
ok($zip->set_number('0820385')->is_valid_number, '北海道河西郡芽室町渋山(上渋山)');
ok($zip->set_number('0820801')->is_valid_number, '北海道河西郡芽室町東めむろ一条北');
ok($zip->set_number('0820802')->is_valid_number, '北海道河西郡芽室町東めむろ二条北');
ok($zip->set_number('0820803')->is_valid_number, '北海道河西郡芽室町東めむろ三条北');
ok($zip->set_number('0820811')->is_valid_number, '北海道河西郡芽室町東めむろ一条南');
ok($zip->set_number('0820812')->is_valid_number, '北海道河西郡芽室町東めむろ二条南');
ok($zip->set_number('0820813')->is_valid_number, '北海道河西郡芽室町東めむろ三条南');
ok($zip->set_number('0830000')->is_valid_number, '北海道中川郡池田町以下に掲載がない場合');
ok($zip->set_number('0830001')->is_valid_number, '北海道中川郡池田町旭町');
ok($zip->set_number('0830002')->is_valid_number, '北海道中川郡池田町清見');
ok($zip->set_number('0830003')->is_valid_number, '北海道中川郡池田町清見ケ丘');
ok($zip->set_number('0830004')->is_valid_number, '北海道中川郡池田町様舞');
ok($zip->set_number('0830020')->is_valid_number, '北海道中川郡池田町大通南');
ok($zip->set_number('0830021')->is_valid_number, '北海道中川郡池田町西一条');
ok($zip->set_number('0830022')->is_valid_number, '北海道中川郡池田町西二条');
ok($zip->set_number('0830023')->is_valid_number, '北海道中川郡池田町西三条');
ok($zip->set_number('0830031')->is_valid_number, '北海道中川郡池田町利別西町');
ok($zip->set_number('0830032')->is_valid_number, '北海道中川郡池田町利別東町');
ok($zip->set_number('0830033')->is_valid_number, '北海道中川郡池田町利別南町');
ok($zip->set_number('0830034')->is_valid_number, '北海道中川郡池田町利別本町');
ok($zip->set_number('0830041')->is_valid_number, '北海道中川郡池田町川合');
ok($zip->set_number('0830042')->is_valid_number, '北海道中川郡池田町千代田');
ok($zip->set_number('0830043')->is_valid_number, '北海道中川郡池田町豊田');
ok($zip->set_number('0830044')->is_valid_number, '北海道中川郡池田町青山');
ok($zip->set_number('0830045')->is_valid_number, '北海道中川郡池田町富岡');
ok($zip->set_number('0830046')->is_valid_number, '北海道中川郡池田町東台');
ok($zip->set_number('0830047')->is_valid_number, '北海道中川郡池田町昭栄');
ok($zip->set_number('0830090')->is_valid_number, '北海道中川郡池田町大通');
ok($zip->set_number('0830091')->is_valid_number, '北海道中川郡池田町東一条');
ok($zip->set_number('0830092')->is_valid_number, '北海道中川郡池田町東二条');
ok($zip->set_number('0840901')->is_valid_number, '北海道釧路市昭和北');
ok($zip->set_number('0840902')->is_valid_number, '北海道釧路市昭和');
ok($zip->set_number('0840903')->is_valid_number, '北海道釧路市昭和町');
ok($zip->set_number('0840904')->is_valid_number, '北海道釧路市新富士町');
ok($zip->set_number('0840905')->is_valid_number, '北海道釧路市鳥取南');
ok($zip->set_number('0840906')->is_valid_number, '北海道釧路市鳥取大通');
ok($zip->set_number('0840907')->is_valid_number, '北海道釧路市鳥取北');
ok($zip->set_number('0840908')->is_valid_number, '北海道釧路市北園');
ok($zip->set_number('0840909')->is_valid_number, '北海道釧路市昭和南');
ok($zip->set_number('0840910')->is_valid_number, '北海道釧路市昭和中央');
ok($zip->set_number('0840911')->is_valid_number, '北海道釧路市星が浦北');
ok($zip->set_number('0840912')->is_valid_number, '北海道釧路市星が浦大通');
ok($zip->set_number('0840913')->is_valid_number, '北海道釧路市星が浦南');
ok($zip->set_number('0840914')->is_valid_number, '北海道釧路市西港');
ok($zip->set_number('0840915')->is_valid_number, '北海道釧路市大楽毛南');
ok($zip->set_number('0840916')->is_valid_number, '北海道釧路市大楽毛西');
ok($zip->set_number('0840917')->is_valid_number, '北海道釧路市大楽毛');
ok($zip->set_number('0840918')->is_valid_number, '北海道釧路市大楽毛北');
ok($zip->set_number('0840921')->is_valid_number, '北海道釧路市美濃');
ok($zip->set_number('0840922')->is_valid_number, '北海道釧路市北斗');
ok($zip->set_number('0840923')->is_valid_number, '北海道釧路市鶴野東');
ok($zip->set_number('0840924')->is_valid_number, '北海道釧路市鶴野');
ok($zip->set_number('0840925')->is_valid_number, '北海道釧路市新野');
ok($zip->set_number('0840926')->is_valid_number, '北海道釧路市鶴丘');
ok($zip->set_number('0840927')->is_valid_number, '北海道釧路市駒牧');
ok($zip->set_number('0840928')->is_valid_number, '北海道釧路市山花');
ok($zip->set_number('0840929')->is_valid_number, '北海道釧路市中鶴野');
ok($zip->set_number('0850000')->is_valid_number, '北海道釧路市以下に掲載がない場合');
ok($zip->set_number('0850001')->is_valid_number, '北海道釧路市古川町');
ok($zip->set_number('0850002')->is_valid_number, '北海道釧路市新釧路町');
ok($zip->set_number('0850003')->is_valid_number, '北海道釧路市川北町');
ok($zip->set_number('0850004')->is_valid_number, '北海道釧路市新富町');
ok($zip->set_number('0850005')->is_valid_number, '北海道釧路市松浦町');
ok($zip->set_number('0850006')->is_valid_number, '北海道釧路市双葉町');
ok($zip->set_number('0850007')->is_valid_number, '北海道釧路市堀川町');
ok($zip->set_number('0850008')->is_valid_number, '北海道釧路市入江町');
ok($zip->set_number('0850011')->is_valid_number, '北海道釧路市旭町');
ok($zip->set_number('0850012')->is_valid_number, '北海道釧路市川上町');
ok($zip->set_number('0850013')->is_valid_number, '北海道釧路市栄町');
ok($zip->set_number('0850014')->is_valid_number, '北海道釧路市末広町');
ok($zip->set_number('0850015')->is_valid_number, '北海道釧路市北大通');
ok($zip->set_number('0850016')->is_valid_number, '北海道釧路市錦町');
ok($zip->set_number('0850017')->is_valid_number, '北海道釧路市幸町');
ok($zip->set_number('0850018')->is_valid_number, '北海道釧路市黒金町');
ok($zip->set_number('0850021')->is_valid_number, '北海道釧路市浪花町');
ok($zip->set_number('0850022')->is_valid_number, '北海道釧路市南浜町');
ok($zip->set_number('0850023')->is_valid_number, '北海道釧路市海運');
ok($zip->set_number('0850024')->is_valid_number, '北海道釧路市浜町');
ok($zip->set_number('0850025')->is_valid_number, '北海道釧路市宝町');
ok($zip->set_number('0850026')->is_valid_number, '北海道釧路市寿');
ok($zip->set_number('0850027')->is_valid_number, '北海道釧路市仲浜町');
ok($zip->set_number('0850031')->is_valid_number, '北海道釧路市中島町');
ok($zip->set_number('0850032')->is_valid_number, '北海道釧路市新栄町');
ok($zip->set_number('0850033')->is_valid_number, '北海道釧路市若松町');
ok($zip->set_number('0850034')->is_valid_number, '北海道釧路市白金町');
ok($zip->set_number('0850035')->is_valid_number, '北海道釧路市共栄大通');
ok($zip->set_number('0850036')->is_valid_number, '北海道釧路市若竹町');
ok($zip->set_number('0850037')->is_valid_number, '北海道釧路市柳町');
ok($zip->set_number('0850038')->is_valid_number, '北海道釧路市花園町');
ok($zip->set_number('0850041')->is_valid_number, '北海道釧路市春日町');
ok($zip->set_number('0850042')->is_valid_number, '北海道釧路市若草町');
ok($zip->set_number('0850043')->is_valid_number, '北海道釧路市喜多町');
ok($zip->set_number('0850044')->is_valid_number, '北海道釧路市川端町');
ok($zip->set_number('0850045')->is_valid_number, '北海道釧路市住之江町');
ok($zip->set_number('0850046')->is_valid_number, '北海道釧路市新橋大通');
ok($zip->set_number('0850047')->is_valid_number, '北海道釧路市新川町');
ok($zip->set_number('0850048')->is_valid_number, '北海道釧路市駒場町');
ok($zip->set_number('0850051')->is_valid_number, '北海道釧路市光陽町');
ok($zip->set_number('0850052')->is_valid_number, '北海道釧路市中園町');
ok($zip->set_number('0850053')->is_valid_number, '北海道釧路市豊川町');
ok($zip->set_number('0850054')->is_valid_number, '北海道釧路市暁町');
ok($zip->set_number('0850055')->is_valid_number, '北海道釧路市治水町');
ok($zip->set_number('0850056')->is_valid_number, '北海道釧路市東川町');
ok($zip->set_number('0850057')->is_valid_number, '北海道釧路市愛国西');
ok($zip->set_number('0850058')->is_valid_number, '北海道釧路市愛国東');
ok($zip->set_number('0850061')->is_valid_number, '北海道釧路市芦野');
ok($zip->set_number('0850062')->is_valid_number, '北海道釧路市愛国');
ok($zip->set_number('0850063')->is_valid_number, '北海道釧路市文苑');
ok($zip->set_number('0850064')->is_valid_number, '北海道釧路市広里');
ok($zip->set_number('0850065')->is_valid_number, '北海道釧路市美原');
ok($zip->set_number('0850201')->is_valid_number, '北海道釧路市阿寒町仁々志別');
ok($zip->set_number('0850202')->is_valid_number, '北海道釧路市阿寒町上仁々志別');
ok($zip->set_number('0850203')->is_valid_number, '北海道釧路市阿寒町中仁々志別');
ok($zip->set_number('0850204')->is_valid_number, '北海道釧路市阿寒町下仁々志別');
ok($zip->set_number('0850205')->is_valid_number, '北海道釧路市阿寒町東栄');
ok($zip->set_number('0850206')->is_valid_number, '北海道釧路市阿寒町共和');
ok($zip->set_number('0850211')->is_valid_number, '北海道釧路市阿寒町下舌辛');
ok($zip->set_number('0850212')->is_valid_number, '北海道釧路市阿寒町旭町');
ok($zip->set_number('0850213')->is_valid_number, '北海道釧路市阿寒町仲町');
ok($zip->set_number('0850214')->is_valid_number, '北海道釧路市阿寒町富士見');
ok($zip->set_number('0850215')->is_valid_number, '北海道釧路市阿寒町中央');
ok($zip->set_number('0850216')->is_valid_number, '北海道釧路市阿寒町北新町');
ok($zip->set_number('0850217')->is_valid_number, '北海道釧路市阿寒町北町');
ok($zip->set_number('0850218')->is_valid_number, '北海道釧路市阿寒町新町');
ok($zip->set_number('0850220')->is_valid_number, '北海道釧路市阿寒町舌辛');
ok($zip->set_number('0850221')->is_valid_number, '北海道釧路市阿寒町上舌辛');
ok($zip->set_number('0850222')->is_valid_number, '北海道釧路市阿寒町布伏内');
ok($zip->set_number('0850223')->is_valid_number, '北海道釧路市阿寒町下布伏内');
ok($zip->set_number('0850224')->is_valid_number, '北海道釧路市阿寒町雄別横山');
ok($zip->set_number('0850225')->is_valid_number, '北海道釧路市阿寒町知茶布');
ok($zip->set_number('0850231')->is_valid_number, '北海道釧路市阿寒町下徹別');
ok($zip->set_number('0850232')->is_valid_number, '北海道釧路市阿寒町大正');
ok($zip->set_number('0850233')->is_valid_number, '北海道釧路市阿寒町西徹別');
ok($zip->set_number('0850234')->is_valid_number, '北海道釧路市阿寒町蘇牛');
ok($zip->set_number('0850235')->is_valid_number, '北海道釧路市阿寒町上徹別');
ok($zip->set_number('0850236')->is_valid_number, '北海道釧路市阿寒町中徹別');
ok($zip->set_number('0850237')->is_valid_number, '北海道釧路市阿寒町徹別中央');
ok($zip->set_number('0850238')->is_valid_number, '北海道釧路市阿寒町飽別');
ok($zip->set_number('0850241')->is_valid_number, '北海道釧路市阿寒町中阿寒');
ok($zip->set_number('0850242')->is_valid_number, '北海道釧路市阿寒町東舌辛');
ok($zip->set_number('0850243')->is_valid_number, '北海道釧路市阿寒町西阿寒');
ok($zip->set_number('0850244')->is_valid_number, '北海道釧路市阿寒町紀ノ丘');
ok($zip->set_number('0850245')->is_valid_number, '北海道釧路市阿寒町上阿寒');
ok($zip->set_number('0850251')->is_valid_number, '北海道釧路市桜田');
ok($zip->set_number('0850252')->is_valid_number, '北海道釧路市青山');
ok($zip->set_number('0850467')->is_valid_number, '北海道釧路市阿寒町阿寒湖温泉(1~6丁目)');
ok($zip->set_number('0850801')->is_valid_number, '北海道釧路市三津浦');
ok($zip->set_number('0850802')->is_valid_number, '北海道釧路市桂恋');
ok($zip->set_number('0850803')->is_valid_number, '北海道釧路市益浦');
ok($zip->set_number('0850804')->is_valid_number, '北海道釧路市白樺台');
ok($zip->set_number('0850805')->is_valid_number, '北海道釧路市桜ケ岡');
ok($zip->set_number('0850806')->is_valid_number, '北海道釧路市武佐');
ok($zip->set_number('0850807')->is_valid_number, '北海道釧路市高山');
ok($zip->set_number('0850811')->is_valid_number, '北海道釧路市興津');
ok($zip->set_number('0850812')->is_valid_number, '北海道釧路市紫雲台');
ok($zip->set_number('0850813')->is_valid_number, '北海道釧路市春採');
ok($zip->set_number('0850814')->is_valid_number, '北海道釧路市緑ケ岡');
ok($zip->set_number('0850815')->is_valid_number, '北海道釧路市材木町');
ok($zip->set_number('0850816')->is_valid_number, '北海道釧路市貝塚');
ok($zip->set_number('0850821')->is_valid_number, '北海道釧路市鶴ケ岱');
ok($zip->set_number('0850822')->is_valid_number, '北海道釧路市春湖台');
ok($zip->set_number('0850823')->is_valid_number, '北海道釧路市千代ノ浦');
ok($zip->set_number('0850824')->is_valid_number, '北海道釧路市柏木町');
ok($zip->set_number('0850825')->is_valid_number, '北海道釧路市千歳町');
ok($zip->set_number('0850826')->is_valid_number, '北海道釧路市城山');
ok($zip->set_number('0850831')->is_valid_number, '北海道釧路市住吉');
ok($zip->set_number('0850832')->is_valid_number, '北海道釧路市富士見');
ok($zip->set_number('0850833')->is_valid_number, '北海道釧路市宮本');
ok($zip->set_number('0850834')->is_valid_number, '北海道釧路市弥生');
ok($zip->set_number('0850835')->is_valid_number, '北海道釧路市浦見');
ok($zip->set_number('0850836')->is_valid_number, '北海道釧路市幣舞町');
ok($zip->set_number('0850837')->is_valid_number, '北海道釧路市大川町');
ok($zip->set_number('0850841')->is_valid_number, '北海道釧路市南大通');
ok($zip->set_number('0850842')->is_valid_number, '北海道釧路市米町');
ok($zip->set_number('0850843')->is_valid_number, '北海道釧路市弁天ケ浜');
ok($zip->set_number('0850844')->is_valid_number, '北海道釧路市知人町');
ok($zip->set_number('0850845')->is_valid_number, '北海道釧路市港町');
ok($zip->set_number('0850846')->is_valid_number, '北海道釧路市入舟');
ok($zip->set_number('0850847')->is_valid_number, '北海道釧路市大町');
ok($zip->set_number('0851131')->is_valid_number, '北海道阿寒郡鶴居村新幌呂');
ok($zip->set_number('0851132')->is_valid_number, '北海道阿寒郡鶴居村上幌呂');
ok($zip->set_number('0851133')->is_valid_number, '北海道阿寒郡鶴居村支幌呂');
ok($zip->set_number('0851134')->is_valid_number, '北海道阿寒郡鶴居村茂幌呂');
ok($zip->set_number('0851141')->is_valid_number, '北海道阿寒郡鶴居村幌呂西');
ok($zip->set_number('0851142')->is_valid_number, '北海道阿寒郡鶴居村幌呂東');
ok($zip->set_number('0851143')->is_valid_number, '北海道阿寒郡鶴居村中幌呂');
ok($zip->set_number('0851144')->is_valid_number, '北海道阿寒郡鶴居村下幌呂');
ok($zip->set_number('0851145')->is_valid_number, '北海道阿寒郡鶴居村温根内');
ok($zip->set_number('0851146')->is_valid_number, '北海道阿寒郡鶴居村アトコシヤラカ');
ok($zip->set_number('0851147')->is_valid_number, '北海道阿寒郡鶴居村幌呂');
ok($zip->set_number('0851200')->is_valid_number, '北海道阿寒郡鶴居村以下に掲載がない場合');
ok($zip->set_number('0851201')->is_valid_number, '北海道阿寒郡鶴居村鶴居北');
ok($zip->set_number('0851202')->is_valid_number, '北海道阿寒郡鶴居村中雪裡(西)');
ok($zip->set_number('0851203')->is_valid_number, '北海道阿寒郡鶴居村鶴居西');
ok($zip->set_number('0851204')->is_valid_number, '北海道阿寒郡鶴居村鶴居南');
ok($zip->set_number('0851205')->is_valid_number, '北海道阿寒郡鶴居村中雪裡(南)');
ok($zip->set_number('0851206')->is_valid_number, '北海道阿寒郡鶴居村鶴居東');
ok($zip->set_number('0851207')->is_valid_number, '北海道阿寒郡鶴居村中雪裡(東)');
ok($zip->set_number('0851211')->is_valid_number, '北海道阿寒郡鶴居村下雪裡');
ok($zip->set_number('0851212')->is_valid_number, '北海道阿寒郡鶴居村支雪裡');
ok($zip->set_number('0851213')->is_valid_number, '北海道阿寒郡鶴居村茂雪裡');
ok($zip->set_number('0851261')->is_valid_number, '北海道阿寒郡鶴居村中久著呂');
ok($zip->set_number('0851262')->is_valid_number, '北海道阿寒郡鶴居村下久著呂');
ok($zip->set_number('0852271')->is_valid_number, '北海道釧路郡釧路町跡永賀村');
ok($zip->set_number('0852272')->is_valid_number, '北海道釧路郡釧路町昆布森');
ok($zip->set_number('0852273')->is_valid_number, '北海道釧路郡釧路町昆布森村');
ok($zip->set_number('0860061')->is_valid_number, '北海道根室市明郷');
ok($zip->set_number('0860062')->is_valid_number, '北海道根室市湖南');
ok($zip->set_number('0860063')->is_valid_number, '北海道根室市東厚床');
ok($zip->set_number('0860064')->is_valid_number, '北海道根室市厚床');
ok($zip->set_number('0860065')->is_valid_number, '北海道根室市西厚床');
ok($zip->set_number('0860071')->is_valid_number, '北海道根室市槍昔');
ok($zip->set_number('0860072')->is_valid_number, '北海道根室市川口');
ok($zip->set_number('0860073')->is_valid_number, '北海道根室市酪陽');
ok($zip->set_number('0860074')->is_valid_number, '北海道根室市東梅');
ok($zip->set_number('0860075')->is_valid_number, '北海道根室市別当賀');
ok($zip->set_number('0860076')->is_valid_number, '北海道根室市初田牛');
ok($zip->set_number('0860081')->is_valid_number, '北海道厚岸郡浜中町厚陽');
ok($zip->set_number('0860131')->is_valid_number, '北海道野付郡別海町上風連');
ok($zip->set_number('0860200')->is_valid_number, '北海道野付郡別海町以下に掲載がない場合');
ok($zip->set_number('0860201')->is_valid_number, '北海道野付郡別海町別海宮舞町');
ok($zip->set_number('0860202')->is_valid_number, '北海道野付郡別海町別海旭町');
ok($zip->set_number('0860203')->is_valid_number, '北海道野付郡別海町別海西本町');
ok($zip->set_number('0860204')->is_valid_number, '北海道野付郡別海町別海新栄町');
ok($zip->set_number('0860205')->is_valid_number, '北海道野付郡別海町別海常盤町');
ok($zip->set_number('0860211')->is_valid_number, '北海道野付郡別海町別海寿町');
ok($zip->set_number('0860212')->is_valid_number, '北海道野付郡別海町別海鶴舞町');
ok($zip->set_number('0860213')->is_valid_number, '北海道野付郡別海町奥行');
ok($zip->set_number('0860214')->is_valid_number, '北海道野付郡別海町別海緑町');
ok($zip->set_number('0860215')->is_valid_number, '北海道野付郡別海町別海川上町');
ok($zip->set_number('0860216')->is_valid_number, '北海道野付郡別海町別海');
ok($zip->set_number('0860341')->is_valid_number, '北海道野付郡別海町中西別緑町');
ok($zip->set_number('0860342')->is_valid_number, '北海道野付郡別海町中西別朝日町');
ok($zip->set_number('0860343')->is_valid_number, '北海道野付郡別海町中西別光町');
ok($zip->set_number('0860344')->is_valid_number, '北海道野付郡別海町中西別本町');
ok($zip->set_number('0860345')->is_valid_number, '北海道野付郡別海町中西別');
ok($zip->set_number('0860346')->is_valid_number, '北海道野付郡別海町矢臼別(その他)');
ok($zip->set_number('0860521')->is_valid_number, '北海道野付郡別海町床丹(その他)');
ok($zip->set_number('0860522')->is_valid_number, '北海道野付郡別海町本別海');
ok($zip->set_number('0860523')->is_valid_number, '北海道野付郡別海町走古丹');
ok($zip->set_number('0860651')->is_valid_number, '北海道野付郡別海町中春別東町');
ok($zip->set_number('0860652')->is_valid_number, '北海道野付郡別海町中春別南町');
ok($zip->set_number('0860653')->is_valid_number, '北海道野付郡別海町中春別西町');
ok($zip->set_number('0860654')->is_valid_number, '北海道野付郡別海町中春別');
ok($zip->set_number('0860655')->is_valid_number, '北海道野付郡別海町床丹(1番地)');
ok($zip->set_number('0860656')->is_valid_number, '北海道野付郡別海町美原');
ok($zip->set_number('0860657')->is_valid_number, '北海道野付郡別海町豊原');
ok($zip->set_number('0861001')->is_valid_number, '北海道標津郡中標津町東一条南');
ok($zip->set_number('0861002')->is_valid_number, '北海道標津郡中標津町東二条南');
ok($zip->set_number('0861003')->is_valid_number, '北海道標津郡中標津町東三条南');
ok($zip->set_number('0861004')->is_valid_number, '北海道標津郡中標津町東四条南');
ok($zip->set_number('0861005')->is_valid_number, '北海道標津郡中標津町東五条南');
ok($zip->set_number('0861006')->is_valid_number, '北海道標津郡中標津町東六条南');
ok($zip->set_number('0861007')->is_valid_number, '北海道標津郡中標津町東七条南');
ok($zip->set_number('0861008')->is_valid_number, '北海道標津郡中標津町東八条南');
ok($zip->set_number('0861009')->is_valid_number, '北海道標津郡中標津町東九条南');
ok($zip->set_number('0861010')->is_valid_number, '北海道標津郡中標津町東十条南');
ok($zip->set_number('0861011')->is_valid_number, '北海道標津郡中標津町東十一条南');
ok($zip->set_number('0861012')->is_valid_number, '北海道標津郡中標津町東十二条南');
ok($zip->set_number('0861013')->is_valid_number, '北海道標津郡中標津町東十三条南');
ok($zip->set_number('0861014')->is_valid_number, '北海道標津郡中標津町東十四条南');
ok($zip->set_number('0861015')->is_valid_number, '北海道標津郡中標津町東十五条南');
ok($zip->set_number('0861016')->is_valid_number, '北海道標津郡中標津町東十六条南');
ok($zip->set_number('0861017')->is_valid_number, '北海道標津郡中標津町東十七条南');
ok($zip->set_number('0861018')->is_valid_number, '北海道標津郡中標津町東十八条南');
ok($zip->set_number('0861019')->is_valid_number, '北海道標津郡中標津町東十九条南');
ok($zip->set_number('0861020')->is_valid_number, '北海道標津郡中標津町東二十条南');
ok($zip->set_number('0861021')->is_valid_number, '北海道標津郡中標津町東二十一条南');
ok($zip->set_number('0861022')->is_valid_number, '北海道標津郡中標津町東二十二条南');
ok($zip->set_number('0861023')->is_valid_number, '北海道標津郡中標津町東二十三条南');
ok($zip->set_number('0861024')->is_valid_number, '北海道標津郡中標津町東二十四条南');
ok($zip->set_number('0861025')->is_valid_number, '北海道標津郡中標津町東二十五条南');
ok($zip->set_number('0861026')->is_valid_number, '北海道標津郡中標津町東二十六条南');
ok($zip->set_number('0861027')->is_valid_number, '北海道標津郡中標津町東二十七条南');
ok($zip->set_number('0861028')->is_valid_number, '北海道標津郡中標津町東二十八条南');
ok($zip->set_number('0861029')->is_valid_number, '北海道標津郡中標津町東二十九条南');
ok($zip->set_number('0861030')->is_valid_number, '北海道標津郡中標津町東三十条南');
ok($zip->set_number('0861031')->is_valid_number, '北海道標津郡中標津町東三十一条南');
ok($zip->set_number('0861032')->is_valid_number, '北海道標津郡中標津町東三十二条南');
ok($zip->set_number('0861033')->is_valid_number, '北海道標津郡中標津町東三十三条南');
ok($zip->set_number('0861034')->is_valid_number, '北海道標津郡中標津町東三十四条南');
ok($zip->set_number('0861035')->is_valid_number, '北海道標津郡中標津町東三十五条南');
ok($zip->set_number('0861036')->is_valid_number, '北海道標津郡中標津町東三十六条南');
ok($zip->set_number('0861037')->is_valid_number, '北海道標津郡中標津町東三十七条南');
ok($zip->set_number('0861038')->is_valid_number, '北海道標津郡中標津町東三十八条南');
ok($zip->set_number('0861039')->is_valid_number, '北海道標津郡中標津町東三十九条南');
ok($zip->set_number('0861041')->is_valid_number, '北海道標津郡中標津町東一条北');
ok($zip->set_number('0861042')->is_valid_number, '北海道標津郡中標津町東二条北');
ok($zip->set_number('0861043')->is_valid_number, '北海道標津郡中標津町東三条北');
ok($zip->set_number('0861044')->is_valid_number, '北海道標津郡中標津町東四条北');
ok($zip->set_number('0861045')->is_valid_number, '北海道標津郡中標津町東五条北');
ok($zip->set_number('0861046')->is_valid_number, '北海道標津郡中標津町東六条北');
ok($zip->set_number('0861047')->is_valid_number, '北海道標津郡中標津町東七条北');
ok($zip->set_number('0861048')->is_valid_number, '北海道標津郡中標津町東八条北');
ok($zip->set_number('0861049')->is_valid_number, '北海道標津郡中標津町東九条北');
ok($zip->set_number('0861050')->is_valid_number, '北海道標津郡中標津町東十条北');
ok($zip->set_number('0861051')->is_valid_number, '北海道標津郡中標津町東十一条北');
ok($zip->set_number('0861052')->is_valid_number, '北海道標津郡中標津町東十二条北');
ok($zip->set_number('0861053')->is_valid_number, '北海道標津郡中標津町東十三条北');
ok($zip->set_number('0861054')->is_valid_number, '北海道標津郡中標津町東十四条北');
ok($zip->set_number('0861055')->is_valid_number, '北海道標津郡中標津町東十五条北');
ok($zip->set_number('0861056')->is_valid_number, '北海道標津郡中標津町東十六条北');
ok($zip->set_number('0861057')->is_valid_number, '北海道標津郡中標津町東十七条北');
ok($zip->set_number('0861058')->is_valid_number, '北海道標津郡中標津町東十八条北');
ok($zip->set_number('0861059')->is_valid_number, '北海道標津郡中標津町東十九条北');
ok($zip->set_number('0861060')->is_valid_number, '北海道標津郡中標津町東二十条北');
ok($zip->set_number('0861061')->is_valid_number, '北海道標津郡中標津町東二十一条北');
ok($zip->set_number('0861062')->is_valid_number, '北海道標津郡中標津町東二十二条北');
ok($zip->set_number('0861063')->is_valid_number, '北海道標津郡中標津町東二十三条北');
ok($zip->set_number('0861064')->is_valid_number, '北海道標津郡中標津町東二十四条北');
ok($zip->set_number('0861065')->is_valid_number, '北海道標津郡中標津町東二十五条北');
ok($zip->set_number('0861066')->is_valid_number, '北海道標津郡中標津町東二十六条北');
ok($zip->set_number('0861067')->is_valid_number, '北海道標津郡中標津町東二十七条北');
ok($zip->set_number('0861068')->is_valid_number, '北海道標津郡中標津町東二十八条北');
ok($zip->set_number('0861069')->is_valid_number, '北海道標津郡中標津町東二十九条北');
ok($zip->set_number('0861070')->is_valid_number, '北海道標津郡中標津町東三十条北');
ok($zip->set_number('0861071')->is_valid_number, '北海道標津郡中標津町東三十一条北');
ok($zip->set_number('0861072')->is_valid_number, '北海道標津郡中標津町東三十二条北');
ok($zip->set_number('0861073')->is_valid_number, '北海道標津郡中標津町東三十三条北');
ok($zip->set_number('0861074')->is_valid_number, '北海道標津郡中標津町東三十四条北');
ok($zip->set_number('0861075')->is_valid_number, '北海道標津郡中標津町東三十五条北');
ok($zip->set_number('0861076')->is_valid_number, '北海道標津郡中標津町東三十六条北');
ok($zip->set_number('0861077')->is_valid_number, '北海道標津郡中標津町東三十七条北');
ok($zip->set_number('0861078')->is_valid_number, '北海道標津郡中標津町東三十八条北');
ok($zip->set_number('0861079')->is_valid_number, '北海道標津郡中標津町東三十九条北');
ok($zip->set_number('0861080')->is_valid_number, '北海道標津郡中標津町東四十条南');
ok($zip->set_number('0861080')->is_valid_number, '北海道標津郡中標津町東四十条北');
ok($zip->set_number('0861081')->is_valid_number, '北海道標津郡中標津町東四十一条南');
ok($zip->set_number('0861081')->is_valid_number, '北海道標津郡中標津町東四十一条北');
ok($zip->set_number('0861082')->is_valid_number, '北海道標津郡中標津町東四十二条南');
ok($zip->set_number('0861082')->is_valid_number, '北海道標津郡中標津町東四十二条北');
ok($zip->set_number('0861083')->is_valid_number, '北海道標津郡中標津町東中');
ok($zip->set_number('0861100')->is_valid_number, '北海道標津郡中標津町以下に掲載がない場合');
ok($zip->set_number('0861101')->is_valid_number, '北海道標津郡中標津町西一条南');
ok($zip->set_number('0861102')->is_valid_number, '北海道標津郡中標津町西二条南');
ok($zip->set_number('0861103')->is_valid_number, '北海道標津郡中標津町西三条南');
ok($zip->set_number('0861104')->is_valid_number, '北海道標津郡中標津町西四条南');
ok($zip->set_number('0861105')->is_valid_number, '北海道標津郡中標津町西五条南');
ok($zip->set_number('0861106')->is_valid_number, '北海道標津郡中標津町西六条南');
ok($zip->set_number('0861107')->is_valid_number, '北海道標津郡中標津町西七条南');
ok($zip->set_number('0861108')->is_valid_number, '北海道標津郡中標津町西八条南');
ok($zip->set_number('0861109')->is_valid_number, '北海道標津郡中標津町西九条南');
ok($zip->set_number('0861110')->is_valid_number, '北海道標津郡中標津町西十条南');
ok($zip->set_number('0861111')->is_valid_number, '北海道標津郡中標津町西十一条南');
ok($zip->set_number('0861112')->is_valid_number, '北海道標津郡中標津町西十二条南');
ok($zip->set_number('0861121')->is_valid_number, '北海道標津郡中標津町西一条北');
ok($zip->set_number('0861122')->is_valid_number, '北海道標津郡中標津町西二条北');
ok($zip->set_number('0861123')->is_valid_number, '北海道標津郡中標津町西三条北');
ok($zip->set_number('0861124')->is_valid_number, '北海道標津郡中標津町西四条北');
ok($zip->set_number('0861125')->is_valid_number, '北海道標津郡中標津町西五条北');
ok($zip->set_number('0861126')->is_valid_number, '北海道標津郡中標津町西六条北');
ok($zip->set_number('0861127')->is_valid_number, '北海道標津郡中標津町西七条北');
ok($zip->set_number('0861128')->is_valid_number, '北海道標津郡中標津町西八条北');
ok($zip->set_number('0861129')->is_valid_number, '北海道標津郡中標津町西九条北');
ok($zip->set_number('0861130')->is_valid_number, '北海道標津郡中標津町西十条北');
ok($zip->set_number('0861131')->is_valid_number, '北海道標津郡中標津町西十一条北');
ok($zip->set_number('0861132')->is_valid_number, '北海道標津郡中標津町西十二条北');
ok($zip->set_number('0861133')->is_valid_number, '北海道標津郡中標津町西十三条北');
ok($zip->set_number('0861134')->is_valid_number, '北海道標津郡中標津町西十四条北');
ok($zip->set_number('0861135')->is_valid_number, '北海道標津郡中標津町旭ケ丘');
ok($zip->set_number('0861136')->is_valid_number, '北海道標津郡中標津町協和');
ok($zip->set_number('0861137')->is_valid_number, '北海道標津郡中標津町俵橋');
ok($zip->set_number('0861139')->is_valid_number, '北海道標津郡中標津町豊岡');
ok($zip->set_number('0861141')->is_valid_number, '北海道標津郡中標津町大通北');
ok($zip->set_number('0861142')->is_valid_number, '北海道標津郡中標津町大通南');
ok($zip->set_number('0861143')->is_valid_number, '北海道標津郡中標津町当幌本通');
ok($zip->set_number('0861144')->is_valid_number, '北海道標津郡中標津町東当幌');
ok($zip->set_number('0861145')->is_valid_number, '北海道標津郡中標津町北中');
ok($zip->set_number('0861146')->is_valid_number, '北海道標津郡中標津町南町');
ok($zip->set_number('0861147')->is_valid_number, '北海道標津郡中標津町共立');
ok($zip->set_number('0861148')->is_valid_number, '北海道標津郡中標津町緑ケ丘');
ok($zip->set_number('0861150')->is_valid_number, '北海道標津郡中標津町南中');
ok($zip->set_number('0861151')->is_valid_number, '北海道標津郡中標津町川西');
ok($zip->set_number('0861152')->is_valid_number, '北海道標津郡中標津町北町');
ok($zip->set_number('0861153')->is_valid_number, '北海道標津郡中標津町桜ケ丘');
ok($zip->set_number('0861156')->is_valid_number, '北海道標津郡中標津町並美ケ丘');
ok($zip->set_number('0861157')->is_valid_number, '北海道標津郡中標津町西町');
ok($zip->set_number('0861159')->is_valid_number, '北海道標津郡中標津町青葉台');
ok($zip->set_number('0861160')->is_valid_number, '北海道標津郡中標津町りんどう町');
ok($zip->set_number('0861163')->is_valid_number, '北海道標津郡中標津町俵中');
ok($zip->set_number('0861164')->is_valid_number, '北海道標津郡中標津町丸山');
ok($zip->set_number('0861165')->is_valid_number, '北海道標津郡中標津町緑町北');
ok($zip->set_number('0861166')->is_valid_number, '北海道標津郡中標津町緑町南');
ok($zip->set_number('0861271')->is_valid_number, '北海道標津郡中標津町武佐');
ok($zip->set_number('0861272')->is_valid_number, '北海道標津郡中標津町開陽');
ok($zip->set_number('0861273')->is_valid_number, '北海道標津郡中標津町俣落(その他)');
ok($zip->set_number('0861451')->is_valid_number, '北海道標津郡標津町川北');
ok($zip->set_number('0861600')->is_valid_number, '北海道標津郡標津町以下に掲載がない場合');
ok($zip->set_number('0861601')->is_valid_number, '北海道標津郡標津町忠類');
ok($zip->set_number('0861602')->is_valid_number, '北海道標津郡標津町伊茶仁');
ok($zip->set_number('0861621')->is_valid_number, '北海道標津郡標津町茶志骨(パイロット)');
ok($zip->set_number('0861622')->is_valid_number, '北海道標津郡標津町茶志骨');
ok($zip->set_number('0861623')->is_valid_number, '北海道標津郡標津町茶志骨(東茶志骨)');
ok($zip->set_number('0861625')->is_valid_number, '北海道標津郡標津町茶志骨(住吉町)');
ok($zip->set_number('0861626')->is_valid_number, '北海道標津郡標津町茶志骨(東浜町)');
ok($zip->set_number('0861630')->is_valid_number, '北海道標津郡標津町北十条');
ok($zip->set_number('0861631')->is_valid_number, '北海道標津郡標津町北一条');
ok($zip->set_number('0861632')->is_valid_number, '北海道標津郡標津町北二条');
ok($zip->set_number('0861633')->is_valid_number, '北海道標津郡標津町北三条');
ok($zip->set_number('0861634')->is_valid_number, '北海道標津郡標津町北四条');
ok($zip->set_number('0861635')->is_valid_number, '北海道標津郡標津町北五条');
ok($zip->set_number('0861636')->is_valid_number, '北海道標津郡標津町北六条');
ok($zip->set_number('0861637')->is_valid_number, '北海道標津郡標津町北七条');
ok($zip->set_number('0861638')->is_valid_number, '北海道標津郡標津町北八条');
ok($zip->set_number('0861639')->is_valid_number, '北海道標津郡標津町北九条');
ok($zip->set_number('0861641')->is_valid_number, '北海道野付郡別海町尾岱沼');
ok($zip->set_number('0861642')->is_valid_number, '北海道野付郡別海町尾岱沼岬町');
ok($zip->set_number('0861643')->is_valid_number, '北海道野付郡別海町尾岱沼港町');
ok($zip->set_number('0861644')->is_valid_number, '北海道野付郡別海町尾岱沼潮見町');
ok($zip->set_number('0861645')->is_valid_number, '北海道野付郡別海町野付');
ok($zip->set_number('0861651')->is_valid_number, '北海道標津郡標津町南一条');
ok($zip->set_number('0861652')->is_valid_number, '北海道標津郡標津町南二条');
ok($zip->set_number('0861653')->is_valid_number, '北海道標津郡標津町南三条');
ok($zip->set_number('0861654')->is_valid_number, '北海道標津郡標津町南四条');
ok($zip->set_number('0861655')->is_valid_number, '北海道標津郡標津町南五条');
ok($zip->set_number('0861656')->is_valid_number, '北海道標津郡標津町南六条');
ok($zip->set_number('0861657')->is_valid_number, '北海道標津郡標津町南七条');
ok($zip->set_number('0861658')->is_valid_number, '北海道標津郡標津町南八条');
ok($zip->set_number('0861731')->is_valid_number, '北海道標津郡標津町古多糠');
ok($zip->set_number('0861732')->is_valid_number, '北海道標津郡標津町薫別');
ok($zip->set_number('0861733')->is_valid_number, '北海道標津郡標津町崎無異');
ok($zip->set_number('0861751')->is_valid_number, '北海道目梨郡羅臼町峯浜町');
ok($zip->set_number('0861752')->is_valid_number, '北海道目梨郡羅臼町幌萌町(その他)');
ok($zip->set_number('0861800')->is_valid_number, '北海道目梨郡羅臼町以下に掲載がない場合');
ok($zip->set_number('0861801')->is_valid_number, '北海道目梨郡羅臼町知床岬');
ok($zip->set_number('0861802')->is_valid_number, '北海道目梨郡羅臼町滝ノ下');
ok($zip->set_number('0861803')->is_valid_number, '北海道目梨郡羅臼町船泊');
ok($zip->set_number('0861804')->is_valid_number, '北海道目梨郡羅臼町化石浜');
ok($zip->set_number('0861805')->is_valid_number, '北海道目梨郡羅臼町崩浜');
ok($zip->set_number('0861806')->is_valid_number, '北海道目梨郡羅臼町相泊');
ok($zip->set_number('0861811')->is_valid_number, '北海道目梨郡羅臼町瀬石');
ok($zip->set_number('0861812')->is_valid_number, '北海道目梨郡羅臼町昆布浜');
ok($zip->set_number('0861813')->is_valid_number, '北海道目梨郡羅臼町北浜');
ok($zip->set_number('0861814')->is_valid_number, '北海道目梨郡羅臼町岬町');
ok($zip->set_number('0861815')->is_valid_number, '北海道目梨郡羅臼町海岸町');
ok($zip->set_number('0861816')->is_valid_number, '北海道目梨郡羅臼町共栄町');
ok($zip->set_number('0861821')->is_valid_number, '北海道目梨郡羅臼町緑町');
ok($zip->set_number('0861822')->is_valid_number, '北海道目梨郡羅臼町湯ノ沢町');
ok($zip->set_number('0861823')->is_valid_number, '北海道目梨郡羅臼町栄町');
ok($zip->set_number('0861831')->is_valid_number, '北海道目梨郡羅臼町富士見町');
ok($zip->set_number('0861832')->is_valid_number, '北海道目梨郡羅臼町船見町');
ok($zip->set_number('0861833')->is_valid_number, '北海道目梨郡羅臼町本町');
ok($zip->set_number('0861834')->is_valid_number, '北海道目梨郡羅臼町礼文町');
ok($zip->set_number('0861835')->is_valid_number, '北海道目梨郡羅臼町松法町');
ok($zip->set_number('0861836')->is_valid_number, '北海道目梨郡羅臼町知昭町');
ok($zip->set_number('0861841')->is_valid_number, '北海道目梨郡羅臼町八木浜町');
ok($zip->set_number('0861842')->is_valid_number, '北海道目梨郡羅臼町麻布町');
ok($zip->set_number('0861843')->is_valid_number, '北海道目梨郡羅臼町春日町');
ok($zip->set_number('0861844')->is_valid_number, '北海道目梨郡羅臼町幌萌町(40-1、623番地)');
ok($zip->set_number('0870000')->is_valid_number, '北海道根室市以下に掲載がない場合');
ok($zip->set_number('0870001')->is_valid_number, '北海道根室市北浜町');
ok($zip->set_number('0870002')->is_valid_number, '北海道根室市牧の内');
ok($zip->set_number('0870003')->is_valid_number, '北海道根室市明治町');
ok($zip->set_number('0870004')->is_valid_number, '北海道根室市光洋町');
ok($zip->set_number('0870005')->is_valid_number, '北海道根室市宝町');
ok($zip->set_number('0870006')->is_valid_number, '北海道根室市曙町');
ok($zip->set_number('0870007')->is_valid_number, '北海道根室市月見町');
ok($zip->set_number('0870008')->is_valid_number, '北海道根室市有磯町');
ok($zip->set_number('0870009')->is_valid_number, '北海道根室市弥栄町');
ok($zip->set_number('0870010')->is_valid_number, '北海道根室市栄町');
ok($zip->set_number('0870011')->is_valid_number, '北海道根室市弁天町');
ok($zip->set_number('0870012')->is_valid_number, '北海道根室市駒場町');
ok($zip->set_number('0870014')->is_valid_number, '北海道根室市朝日町');
ok($zip->set_number('0870015')->is_valid_number, '北海道根室市花咲町');
ok($zip->set_number('0870016')->is_valid_number, '北海道根室市松ケ枝町');
ok($zip->set_number('0870017')->is_valid_number, '北海道根室市鳴海町');
ok($zip->set_number('0870018')->is_valid_number, '北海道根室市千島町');
ok($zip->set_number('0870019')->is_valid_number, '北海道根室市汐見町');
ok($zip->set_number('0870021')->is_valid_number, '北海道根室市幸町');
ok($zip->set_number('0870022')->is_valid_number, '北海道根室市昭和町');
ok($zip->set_number('0870023')->is_valid_number, '北海道根室市桂木');
ok($zip->set_number('0870024')->is_valid_number, '北海道根室市宝林町');
ok($zip->set_number('0870025')->is_valid_number, '北海道根室市西浜町');
ok($zip->set_number('0870026')->is_valid_number, '北海道根室市敷島町');
ok($zip->set_number('0870027')->is_valid_number, '北海道根室市光和町');
ok($zip->set_number('0870028')->is_valid_number, '北海道根室市大正町');
ok($zip->set_number('0870031')->is_valid_number, '北海道根室市月岡町');
ok($zip->set_number('0870032')->is_valid_number, '北海道根室市花咲港');
ok($zip->set_number('0870033')->is_valid_number, '北海道根室市西和田');
ok($zip->set_number('0870034')->is_valid_number, '北海道根室市東和田');
ok($zip->set_number('0870035')->is_valid_number, '北海道根室市温根沼');
ok($zip->set_number('0870036')->is_valid_number, '北海道根室市幌茂尻');
ok($zip->set_number('0870037')->is_valid_number, '北海道根室市穂香');
ok($zip->set_number('0870041')->is_valid_number, '北海道根室市常盤町');
ok($zip->set_number('0870042')->is_valid_number, '北海道根室市清隆町');
ok($zip->set_number('0870043')->is_valid_number, '北海道根室市北斗町');
ok($zip->set_number('0870044')->is_valid_number, '北海道根室市松本町');
ok($zip->set_number('0870045')->is_valid_number, '北海道根室市花園町');
ok($zip->set_number('0870046')->is_valid_number, '北海道根室市岬町');
ok($zip->set_number('0870047')->is_valid_number, '北海道根室市定基町');
ok($zip->set_number('0870048')->is_valid_number, '北海道根室市平内町');
ok($zip->set_number('0870049')->is_valid_number, '北海道根室市弥生町');
ok($zip->set_number('0870051')->is_valid_number, '北海道根室市緑町');
ok($zip->set_number('0870052')->is_valid_number, '北海道根室市梅ケ枝町');
ok($zip->set_number('0870053')->is_valid_number, '北海道根室市本町');
ok($zip->set_number('0870054')->is_valid_number, '北海道根室市海岸町');
ok($zip->set_number('0870055')->is_valid_number, '北海道根室市琴平町');
ok($zip->set_number('0870161')->is_valid_number, '北海道根室市友知');
ok($zip->set_number('0870162')->is_valid_number, '北海道根室市双沖');
ok($zip->set_number('0870163')->is_valid_number, '北海道根室市歯舞');
ok($zip->set_number('0870164')->is_valid_number, '北海道根室市珸瑤瑁');
ok($zip->set_number('0870165')->is_valid_number, '北海道根室市納沙布');
ok($zip->set_number('0870166')->is_valid_number, '北海道根室市温根元');
ok($zip->set_number('0870167')->is_valid_number, '北海道根室市豊里');
ok($zip->set_number('0880101')->is_valid_number, '北海道釧路市音別町馬主来');
ok($zip->set_number('0880102')->is_valid_number, '北海道釧路市音別町中音別(光和)');
ok($zip->set_number('0880103')->is_valid_number, '北海道釧路市音別町中音別(北栄)');
ok($zip->set_number('0880104')->is_valid_number, '北海道釧路市音別町音別原野基線(二俣)');
ok($zip->set_number('0880105')->is_valid_number, '北海道釧路市音別町ムリ');
ok($zip->set_number('0880106')->is_valid_number, '北海道釧路市音別町ヌプキベツ');
ok($zip->set_number('0880107')->is_valid_number, '北海道釧路市音別町チヤンベツ');
ok($zip->set_number('0880108')->is_valid_number, '北海道釧路市音別町音別原野基線(二俣川向)');
ok($zip->set_number('0880109')->is_valid_number, '北海道釧路市音別町音別原野東');
ok($zip->set_number('0880111')->is_valid_number, '北海道釧路市音別町パシクル湖畔');
ok($zip->set_number('0880112')->is_valid_number, '北海道釧路市音別町中音別(チノミ台)');
ok($zip->set_number('0880113')->is_valid_number, '北海道釧路市音別町風連');
ok($zip->set_number('0880114')->is_valid_number, '北海道釧路市音別町海光');
ok($zip->set_number('0880115')->is_valid_number, '北海道釧路市音別町本町');
ok($zip->set_number('0880116')->is_valid_number, '北海道釧路市音別町中園');
ok($zip->set_number('0880117')->is_valid_number, '北海道釧路市音別町朝日');
ok($zip->set_number('0880118')->is_valid_number, '北海道釧路市音別町中音別(その他)');
ok($zip->set_number('0880121')->is_valid_number, '北海道釧路市音別町若草');
ok($zip->set_number('0880122')->is_valid_number, '北海道釧路市音別町あけぼの');
ok($zip->set_number('0880123')->is_valid_number, '北海道釧路市音別町川東');
ok($zip->set_number('0880124')->is_valid_number, '北海道釧路市音別町緑町');
ok($zip->set_number('0880125')->is_valid_number, '北海道釧路市音別町共栄');
ok($zip->set_number('0880126')->is_valid_number, '北海道釧路市音別町音別原野西(川西)');
ok($zip->set_number('0880131')->is_valid_number, '北海道釧路市音別町ノトロ');
ok($zip->set_number('0880132')->is_valid_number, '北海道釧路市音別町尺別(岐線)');
ok($zip->set_number('0880133')->is_valid_number, '北海道釧路市音別町尺別');
ok($zip->set_number('0880134')->is_valid_number, '北海道釧路市音別町キナシ別');
ok($zip->set_number('0880135')->is_valid_number, '北海道釧路市音別町直別');
ok($zip->set_number('0880181')->is_valid_number, '北海道十勝郡浦幌町直別');
ok($zip->set_number('0880300')->is_valid_number, '北海道白糠郡白糠町以下に掲載がない場合');
ok($zip->set_number('0880301')->is_valid_number, '北海道白糠郡白糠町東一条南');
ok($zip->set_number('0880302')->is_valid_number, '北海道白糠郡白糠町東二条南');
ok($zip->set_number('0880303')->is_valid_number, '北海道白糠郡白糠町東三条南');
ok($zip->set_number('0880304')->is_valid_number, '北海道白糠郡白糠町岬');
ok($zip->set_number('0880305')->is_valid_number, '北海道白糠郡白糠町刺牛');
ok($zip->set_number('0880311')->is_valid_number, '北海道白糠郡白糠町西一条南');
ok($zip->set_number('0880312')->is_valid_number, '北海道白糠郡白糠町西二条南');
ok($zip->set_number('0880321')->is_valid_number, '北海道白糠郡白糠町西一条北');
ok($zip->set_number('0880322')->is_valid_number, '北海道白糠郡白糠町西二条北');
ok($zip->set_number('0880323')->is_valid_number, '北海道白糠郡白糠町西四条北');
ok($zip->set_number('0880324')->is_valid_number, '北海道白糠郡白糠町西五条北');
ok($zip->set_number('0880331')->is_valid_number, '北海道白糠郡白糠町東一条北');
ok($zip->set_number('0880332')->is_valid_number, '北海道白糠郡白糠町東二条北');
ok($zip->set_number('0880333')->is_valid_number, '北海道白糠郡白糠町東三条北');
ok($zip->set_number('0880341')->is_valid_number, '北海道白糠郡白糠町大苗');
ok($zip->set_number('0880341')->is_valid_number, '北海道白糠郡白糠町下茶路');
ok($zip->set_number('0880341')->is_valid_number, '北海道白糠郡白糠町相互');
ok($zip->set_number('0880341')->is_valid_number, '北海道白糠郡白糠町西茶路');
ok($zip->set_number('0880341')->is_valid_number, '北海道白糠郡白糠町東茶路');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町御札部');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町御仁田');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町川西');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町高台');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町鍛高');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町茶路(共栄)');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町中茶路');
ok($zip->set_number('0880342')->is_valid_number, '北海道白糠郡白糠町松川');
ok($zip->set_number('0880343')->is_valid_number, '北海道白糠郡白糠町上茶路');
ok($zip->set_number('0880343')->is_valid_number, '北海道白糠郡白糠町新縫別');
ok($zip->set_number('0880343')->is_valid_number, '北海道白糠郡白糠町縫別');
ok($zip->set_number('0880343')->is_valid_number, '北海道白糠郡白糠町南大曲');
ok($zip->set_number('0880343')->is_valid_number, '北海道白糠郡白糠町南上茶路');
ok($zip->set_number('0880344')->is_valid_number, '北海道白糠郡白糠町左股');
ok($zip->set_number('0880344')->is_valid_number, '北海道白糠郡白糠町二股');
ok($zip->set_number('0880344')->is_valid_number, '北海道白糠郡白糠町右股');
ok($zip->set_number('0880351')->is_valid_number, '北海道白糠郡白糠町橋西');
ok($zip->set_number('0880351')->is_valid_number, '北海道白糠郡白糠町坂の丘');
ok($zip->set_number('0880351')->is_valid_number, '北海道白糠郡白糠町下和天別');
ok($zip->set_number('0880351')->is_valid_number, '北海道白糠郡白糠町和天別');
ok($zip->set_number('0880352')->is_valid_number, '北海道白糠郡白糠町川島');
ok($zip->set_number('0880352')->is_valid_number, '北海道白糠郡白糠町大秋');
ok($zip->set_number('0880352')->is_valid_number, '北海道白糠郡白糠町馬主来');
ok($zip->set_number('0880352')->is_valid_number, '北海道白糠郡白糠町緑');
ok($zip->set_number('0880353')->is_valid_number, '北海道白糠郡白糠町大沢');
ok($zip->set_number('0880353')->is_valid_number, '北海道白糠郡白糠町大平');
ok($zip->set_number('0880353')->is_valid_number, '北海道白糠郡白糠町河原');
ok($zip->set_number('0880353')->is_valid_number, '北海道白糠郡白糠町恋隠');
ok($zip->set_number('0880353')->is_valid_number, '北海道白糠郡白糠町中和天別');
ok($zip->set_number('0880353')->is_valid_number, '北海道白糠郡白糠町本郷');
ok($zip->set_number('0880561')->is_valid_number, '北海道白糠郡白糠町大楽毛');
ok($zip->set_number('0880562')->is_valid_number, '北海道白糠郡白糠町コイトイ');
ok($zip->set_number('0880563')->is_valid_number, '北海道白糠郡白糠町庶路甲区');
ok($zip->set_number('0880564')->is_valid_number, '北海道白糠郡白糠町庶路(1区)');
ok($zip->set_number('0880565')->is_valid_number, '北海道白糠郡白糠町庶路(2区)');
ok($zip->set_number('0880566')->is_valid_number, '北海道白糠郡白糠町庶路(宮下)');
ok($zip->set_number('0880567')->is_valid_number, '北海道白糠郡白糠町庶路');
ok($zip->set_number('0880568')->is_valid_number, '北海道白糠郡白糠町庶路乙区');
ok($zip->set_number('0880571')->is_valid_number, '北海道白糠郡白糠町西庶路西一条北');
ok($zip->set_number('0880571')->is_valid_number, '北海道白糠郡白糠町西庶路西二条北');
ok($zip->set_number('0880571')->is_valid_number, '北海道白糠郡白糠町西庶路西三条北');
ok($zip->set_number('0880572')->is_valid_number, '北海道白糠郡白糠町西庶路西一条南');
ok($zip->set_number('0880572')->is_valid_number, '北海道白糠郡白糠町西庶路西二条南');
ok($zip->set_number('0880572')->is_valid_number, '北海道白糠郡白糠町西庶路西三条南');
ok($zip->set_number('0880572')->is_valid_number, '北海道白糠郡白糠町西庶路西四条南');
ok($zip->set_number('0880572')->is_valid_number, '北海道白糠郡白糠町西庶路西五条南');
ok($zip->set_number('0880573')->is_valid_number, '北海道白糠郡白糠町西庶路東一条北');
ok($zip->set_number('0880573')->is_valid_number, '北海道白糠郡白糠町西庶路東二条北');
ok($zip->set_number('0880573')->is_valid_number, '北海道白糠郡白糠町西庶路東三条北');
ok($zip->set_number('0880574')->is_valid_number, '北海道白糠郡白糠町西庶路東一条南');
ok($zip->set_number('0880574')->is_valid_number, '北海道白糠郡白糠町西庶路東二条南');
ok($zip->set_number('0880574')->is_valid_number, '北海道白糠郡白糠町西庶路東三条南');
ok($zip->set_number('0880581')->is_valid_number, '北海道白糠郡白糠町乳呑');
ok($zip->set_number('0880582')->is_valid_number, '北海道白糠郡白糠町中庶路');
ok($zip->set_number('0880583')->is_valid_number, '北海道白糠郡白糠町上庶路');
ok($zip->set_number('0880584')->is_valid_number, '北海道白糠郡白糠町泊別');
ok($zip->set_number('0880585')->is_valid_number, '北海道白糠郡白糠町暁');
ok($zip->set_number('0880586')->is_valid_number, '北海道白糠郡白糠町庶路東');
ok($zip->set_number('0880587')->is_valid_number, '北海道白糠郡白糠町庶路西');
ok($zip->set_number('0880600')->is_valid_number, '北海道釧路郡釧路町以下に掲載がない場合');
ok($zip->set_number('0880601')->is_valid_number, '北海道釧路郡釧路町上別保原野');
ok($zip->set_number('0880602')->is_valid_number, '北海道釧路郡釧路町別保東');
ok($zip->set_number('0880603')->is_valid_number, '北海道釧路郡釧路町別保南');
ok($zip->set_number('0880604')->is_valid_number, '北海道釧路郡釧路町別保');
ok($zip->set_number('0880605')->is_valid_number, '北海道釧路郡釧路町別保原野');
ok($zip->set_number('0880606')->is_valid_number, '北海道釧路郡釧路町中央');
ok($zip->set_number('0880607')->is_valid_number, '北海道釧路郡釧路町床丹');
ok($zip->set_number('0880608')->is_valid_number, '北海道釧路郡釧路町釧望台');
ok($zip->set_number('0880609')->is_valid_number, '北海道釧路郡釧路町共和');
ok($zip->set_number('0880611')->is_valid_number, '北海道釧路郡釧路町豊美');
ok($zip->set_number('0880612')->is_valid_number, '北海道釧路郡釧路町雁来');
ok($zip->set_number('0880613')->is_valid_number, '北海道釧路郡釧路町若葉');
ok($zip->set_number('0880614')->is_valid_number, '北海道釧路郡釧路町国誉');
ok($zip->set_number('0880615')->is_valid_number, '北海道釧路郡釧路町睦');
ok($zip->set_number('0880616')->is_valid_number, '北海道釧路郡釧路町曙');
ok($zip->set_number('0880617')->is_valid_number, '北海道釧路郡釧路町北都');
ok($zip->set_number('0880618')->is_valid_number, '北海道釧路郡釧路町富原');
ok($zip->set_number('0880621')->is_valid_number, '北海道釧路郡釧路町桂木');
ok($zip->set_number('0880622')->is_valid_number, '北海道釧路郡釧路町木場');
ok($zip->set_number('0880623')->is_valid_number, '北海道釧路郡釧路町光和');
ok($zip->set_number('0880624')->is_valid_number, '北海道釧路郡釧路町新開');
ok($zip->set_number('0880625')->is_valid_number, '北海道釧路郡釧路町北見団地');
ok($zip->set_number('0880626')->is_valid_number, '北海道釧路郡釧路町桂');
ok($zip->set_number('0880627')->is_valid_number, '北海道釧路郡釧路町東陽西');
ok($zip->set_number('0880628')->is_valid_number, '北海道釧路郡釧路町東陽大通西');
ok($zip->set_number('0880771')->is_valid_number, '北海道厚岸郡厚岸町上尾幌');
ok($zip->set_number('0880831')->is_valid_number, '北海道釧路郡釧路町仙鳳趾村(仙鳳趾)');
ok($zip->set_number('0880832')->is_valid_number, '北海道釧路郡釧路町仙鳳趾村(知方学)');
ok($zip->set_number('0880833')->is_valid_number, '北海道釧路郡釧路町仙鳳趾村(老者舞)');
ok($zip->set_number('0880834')->is_valid_number, '北海道釧路郡釧路町仙鳳趾村(汐見)');
ok($zip->set_number('0880835')->is_valid_number, '北海道釧路郡釧路町仙鳳趾村(オタクパウシ)');
ok($zip->set_number('0880871')->is_valid_number, '北海道厚岸郡厚岸町尾幌');
ok($zip->set_number('0880872')->is_valid_number, '北海道厚岸郡厚岸町来別');
ok($zip->set_number('0880873')->is_valid_number, '北海道厚岸郡厚岸町乙幌');
ok($zip->set_number('0880874')->is_valid_number, '北海道厚岸郡厚岸町門静(4丁目55~114番地)');
ok($zip->set_number('0880875')->is_valid_number, '北海道厚岸郡厚岸町苫多');
ok($zip->set_number('0880876')->is_valid_number, '北海道厚岸郡厚岸町沖万別');
ok($zip->set_number('0880877')->is_valid_number, '北海道厚岸郡厚岸町敏内');
ok($zip->set_number('0880878')->is_valid_number, '北海道厚岸郡厚岸町ルークシュポール');
ok($zip->set_number('0881100')->is_valid_number, '北海道厚岸郡厚岸町以下に掲載がない場合');
ok($zip->set_number('0881101')->is_valid_number, '北海道厚岸郡厚岸町糸魚沢');
ok($zip->set_number('0881101')->is_valid_number, '北海道厚岸郡厚岸町神岩');
ok($zip->set_number('0881101')->is_valid_number, '北海道厚岸郡厚岸町チライカリベツ');
ok($zip->set_number('0881101')->is_valid_number, '北海道厚岸郡厚岸町別寒辺牛');
ok($zip->set_number('0881101')->is_valid_number, '北海道厚岸郡厚岸町ホロニタイ');
ok($zip->set_number('0881101')->is_valid_number, '北海道厚岸郡厚岸町若松');
ok($zip->set_number('0881102')->is_valid_number, '北海道厚岸郡厚岸町登喜岱');
ok($zip->set_number('0881103')->is_valid_number, '北海道厚岸郡厚岸町小島');
ok($zip->set_number('0881104')->is_valid_number, '北海道厚岸郡厚岸町大黒島');
ok($zip->set_number('0881105')->is_valid_number, '北海道厚岸郡厚岸町末広');
ok($zip->set_number('0881106')->is_valid_number, '北海道厚岸郡厚岸町東梅');
ok($zip->set_number('0881107')->is_valid_number, '北海道厚岸郡厚岸町床潭');
ok($zip->set_number('0881108')->is_valid_number, '北海道厚岸郡厚岸町筑紫恋');
ok($zip->set_number('0881111')->is_valid_number, '北海道厚岸郡厚岸町奔渡');
ok($zip->set_number('0881112')->is_valid_number, '北海道厚岸郡厚岸町有明');
ok($zip->set_number('0881113')->is_valid_number, '北海道厚岸郡厚岸町愛冠');
ok($zip->set_number('0881114')->is_valid_number, '北海道厚岸郡厚岸町湾月');
ok($zip->set_number('0881115')->is_valid_number, '北海道厚岸郡厚岸町梅香');
ok($zip->set_number('0881116')->is_valid_number, '北海道厚岸郡厚岸町松葉');
ok($zip->set_number('0881117')->is_valid_number, '北海道厚岸郡厚岸町御供');
ok($zip->set_number('0881118')->is_valid_number, '北海道厚岸郡厚岸町若竹');
ok($zip->set_number('0881118')->is_valid_number, '北海道厚岸郡厚岸町若竹町');
ok($zip->set_number('0881119')->is_valid_number, '北海道厚岸郡厚岸町住の江');
ok($zip->set_number('0881120')->is_valid_number, '北海道厚岸郡厚岸町山の手');
ok($zip->set_number('0881124')->is_valid_number, '北海道厚岸郡厚岸町宮園');
ok($zip->set_number('0881125')->is_valid_number, '北海道厚岸郡厚岸町白浜');
ok($zip->set_number('0881126')->is_valid_number, '北海道厚岸郡厚岸町門静(その他)');
ok($zip->set_number('0881128')->is_valid_number, '北海道厚岸郡厚岸町港町');
ok($zip->set_number('0881129')->is_valid_number, '北海道厚岸郡厚岸町光栄');
ok($zip->set_number('0881130')->is_valid_number, '北海道厚岸郡厚岸町太田南');
ok($zip->set_number('0881131')->is_valid_number, '北海道厚岸郡厚岸町太田');
ok($zip->set_number('0881132')->is_valid_number, '北海道厚岸郡厚岸町太田東');
ok($zip->set_number('0881133')->is_valid_number, '北海道厚岸郡厚岸町太田宏陽');
ok($zip->set_number('0881134')->is_valid_number, '北海道厚岸郡厚岸町太田西');
ok($zip->set_number('0881135')->is_valid_number, '北海道厚岸郡厚岸町太田北');
ok($zip->set_number('0881136')->is_valid_number, '北海道厚岸郡厚岸町大別');
ok($zip->set_number('0881137')->is_valid_number, '北海道厚岸郡厚岸町片無去');
ok($zip->set_number('0881138')->is_valid_number, '北海道厚岸郡厚岸町セタニウシ');
ok($zip->set_number('0881139')->is_valid_number, '北海道厚岸郡厚岸町サッテベツ');
ok($zip->set_number('0881140')->is_valid_number, '北海道厚岸郡厚岸町サンヌシ');
ok($zip->set_number('0881141')->is_valid_number, '北海道厚岸郡厚岸町太田1の通り');
ok($zip->set_number('0881142')->is_valid_number, '北海道厚岸郡厚岸町太田2の通り');
ok($zip->set_number('0881143')->is_valid_number, '北海道厚岸郡厚岸町太田3の通り');
ok($zip->set_number('0881144')->is_valid_number, '北海道厚岸郡厚岸町太田4の通り');
ok($zip->set_number('0881145')->is_valid_number, '北海道厚岸郡厚岸町太田5の通り');
ok($zip->set_number('0881146')->is_valid_number, '北海道厚岸郡厚岸町太田6の通り');
ok($zip->set_number('0881147')->is_valid_number, '北海道厚岸郡厚岸町太田7の通り');
ok($zip->set_number('0881148')->is_valid_number, '北海道厚岸郡厚岸町太田8の通り');
ok($zip->set_number('0881149')->is_valid_number, '北海道厚岸郡厚岸町太田9の通り');
ok($zip->set_number('0881151')->is_valid_number, '北海道厚岸郡厚岸町真栄');
ok($zip->set_number('0881301')->is_valid_number, '北海道厚岸郡浜中町一番沢');
ok($zip->set_number('0881302')->is_valid_number, '北海道厚岸郡浜中町二番沢');
ok($zip->set_number('0881303')->is_valid_number, '北海道厚岸郡浜中町三番沢');
ok($zip->set_number('0881304')->is_valid_number, '北海道厚岸郡浜中町四番沢');
ok($zip->set_number('0881306')->is_valid_number, '北海道厚岸郡浜中町六番沢');
ok($zip->set_number('0881360')->is_valid_number, '北海道厚岸郡浜中町散布村(北の沢)');
ok($zip->set_number('0881361')->is_valid_number, '北海道厚岸郡浜中町茶内緑');
ok($zip->set_number('0881362')->is_valid_number, '北海道厚岸郡浜中町茶内本町');
ok($zip->set_number('0881363')->is_valid_number, '北海道厚岸郡浜中町茶内栄');
ok($zip->set_number('0881364')->is_valid_number, '北海道厚岸郡浜中町茶内若葉');
ok($zip->set_number('0881365')->is_valid_number, '北海道厚岸郡浜中町茶内橋北東');
ok($zip->set_number('0881366')->is_valid_number, '北海道厚岸郡浜中町茶内橋北西');
ok($zip->set_number('0881367')->is_valid_number, '北海道厚岸郡浜中町茶内旭');
ok($zip->set_number('0881368')->is_valid_number, '北海道厚岸郡浜中町茶内基線');
ok($zip->set_number('0881368')->is_valid_number, '北海道厚岸郡浜中町茶内東1線');
ok($zip->set_number('0881368')->is_valid_number, '北海道厚岸郡浜中町茶内東2線');
ok($zip->set_number('0881369')->is_valid_number, '北海道厚岸郡浜中町茶内西');
ok($zip->set_number('0881370')->is_valid_number, '北海道厚岸郡浜中町西円朱別西');
ok($zip->set_number('0881371')->is_valid_number, '北海道厚岸郡浜中町円朱別西');
ok($zip->set_number('0881389')->is_valid_number, '北海道厚岸郡厚岸町トライベツ');
ok($zip->set_number('0881401')->is_valid_number, '北海道厚岸郡浜中町榊町');
ok($zip->set_number('0881402')->is_valid_number, '北海道厚岸郡浜中町後静');
ok($zip->set_number('0881402')->is_valid_number, '北海道厚岸郡浜中町横浜');
ok($zip->set_number('0881403')->is_valid_number, '北海道厚岸郡浜中町アザラップ');
ok($zip->set_number('0881403')->is_valid_number, '北海道厚岸郡浜中町幌戸');
ok($zip->set_number('0881404')->is_valid_number, '北海道厚岸郡浜中町ムギカラシナイ');
ok($zip->set_number('0881405')->is_valid_number, '北海道厚岸郡浜中町奔幌戸');
ok($zip->set_number('0881406')->is_valid_number, '北海道厚岸郡浜中町赤泊');
ok($zip->set_number('0881406')->is_valid_number, '北海道厚岸郡浜中町羨古丹');
ok($zip->set_number('0881407')->is_valid_number, '北海道厚岸郡浜中町榊町西');
ok($zip->set_number('0881408')->is_valid_number, '北海道厚岸郡浜中町大津屋沢');
ok($zip->set_number('0881409')->is_valid_number, '北海道厚岸郡浜中町走古潭');
ok($zip->set_number('0881412')->is_valid_number, '北海道厚岸郡浜中町後静村(熊牛原野)');
ok($zip->set_number('0881485')->is_valid_number, '北海道厚岸郡浜中町浜中');
ok($zip->set_number('0881486')->is_valid_number, '北海道厚岸郡浜中町熊牛');
ok($zip->set_number('0881487')->is_valid_number, '北海道厚岸郡浜中町茶内東3線');
ok($zip->set_number('0881487')->is_valid_number, '北海道厚岸郡浜中町茶内東4線');
ok($zip->set_number('0881487')->is_valid_number, '北海道厚岸郡浜中町茶内東5線');
ok($zip->set_number('0881487')->is_valid_number, '北海道厚岸郡浜中町茶内東6線');
ok($zip->set_number('0881500')->is_valid_number, '北海道厚岸郡浜中町以下に掲載がない場合');
ok($zip->set_number('0881511')->is_valid_number, '北海道厚岸郡浜中町霧多布東一条');
ok($zip->set_number('0881512')->is_valid_number, '北海道厚岸郡浜中町霧多布東二条');
ok($zip->set_number('0881513')->is_valid_number, '北海道厚岸郡浜中町霧多布東三条');
ok($zip->set_number('0881514')->is_valid_number, '北海道厚岸郡浜中町霧多布東四条');
ok($zip->set_number('0881522')->is_valid_number, '北海道厚岸郡浜中町湯沸');
ok($zip->set_number('0881524')->is_valid_number, '北海道厚岸郡浜中町暮帰別東');
ok($zip->set_number('0881525')->is_valid_number, '北海道厚岸郡浜中町暮帰別西');
ok($zip->set_number('0881526')->is_valid_number, '北海道厚岸郡浜中町新川');
ok($zip->set_number('0881527')->is_valid_number, '北海道厚岸郡浜中町新川東');
ok($zip->set_number('0881528')->is_valid_number, '北海道厚岸郡浜中町新川西');
ok($zip->set_number('0881531')->is_valid_number, '北海道厚岸郡浜中町仲の浜');
ok($zip->set_number('0881532')->is_valid_number, '北海道厚岸郡浜中町琵琶瀬');
ok($zip->set_number('0881534')->is_valid_number, '北海道厚岸郡浜中町渡散布');
ok($zip->set_number('0881535')->is_valid_number, '北海道厚岸郡浜中町養老散布');
ok($zip->set_number('0881536')->is_valid_number, '北海道厚岸郡浜中町火散布');
ok($zip->set_number('0881537')->is_valid_number, '北海道厚岸郡浜中町丸山散布');
ok($zip->set_number('0881538')->is_valid_number, '北海道厚岸郡浜中町藻散布');
ok($zip->set_number('0881551')->is_valid_number, '北海道厚岸郡浜中町霧多布西一条');
ok($zip->set_number('0881552')->is_valid_number, '北海道厚岸郡浜中町霧多布西二条');
ok($zip->set_number('0881553')->is_valid_number, '北海道厚岸郡浜中町霧多布西三条');
ok($zip->set_number('0881554')->is_valid_number, '北海道厚岸郡浜中町霧多布西四条');
ok($zip->set_number('0881561')->is_valid_number, '北海道厚岸郡浜中町霧多布湿原');
ok($zip->set_number('0881571')->is_valid_number, '北海道厚岸郡浜中町道有林');
ok($zip->set_number('0881643')->is_valid_number, '北海道厚岸郡浜中町貰人');
ok($zip->set_number('0881644')->is_valid_number, '北海道厚岸郡浜中町恵茶人');
ok($zip->set_number('0881645')->is_valid_number, '北海道厚岸郡浜中町仙鳳趾');
ok($zip->set_number('0881646')->is_valid_number, '北海道厚岸郡浜中町姉別(丁目)');
ok($zip->set_number('0881647')->is_valid_number, '北海道厚岸郡浜中町姉別南');
ok($zip->set_number('0881648')->is_valid_number, '北海道厚岸郡浜中町姉別北');
ok($zip->set_number('0881649')->is_valid_number, '北海道厚岸郡浜中町姉別緑栄');
ok($zip->set_number('0881781')->is_valid_number, '北海道根室市落石西');
ok($zip->set_number('0881782')->is_valid_number, '北海道根室市落石東');
ok($zip->set_number('0881783')->is_valid_number, '北海道根室市浜松');
ok($zip->set_number('0881784')->is_valid_number, '北海道根室市昆布盛');
ok($zip->set_number('0881785')->is_valid_number, '北海道根室市長節');
ok($zip->set_number('0882140')->is_valid_number, '北海道釧路郡釧路町細岡');
ok($zip->set_number('0882141')->is_valid_number, '北海道釧路郡釧路町達古武');
ok($zip->set_number('0882142')->is_valid_number, '北海道釧路郡釧路町遠野');
ok($zip->set_number('0882143')->is_valid_number, '北海道釧路郡釧路町河畔');
ok($zip->set_number('0882144')->is_valid_number, '北海道釧路郡釧路町鳥里');
ok($zip->set_number('0882145')->is_valid_number, '北海道釧路郡釧路町遠矢');
ok($zip->set_number('0882146')->is_valid_number, '北海道釧路郡釧路町鳥通西');
ok($zip->set_number('0882147')->is_valid_number, '北海道釧路郡釧路町鳥通東');
ok($zip->set_number('0882148')->is_valid_number, '北海道釧路郡釧路町鳥通');
ok($zip->set_number('0882151')->is_valid_number, '北海道釧路郡釧路町よし野');
ok($zip->set_number('0882152')->is_valid_number, '北海道釧路郡釧路町南陽台');
ok($zip->set_number('0882153')->is_valid_number, '北海道釧路郡釧路町緑');
ok($zip->set_number('0882154')->is_valid_number, '北海道釧路郡釧路町柏東');
ok($zip->set_number('0882155')->is_valid_number, '北海道釧路郡釧路町柏西');
ok($zip->set_number('0882156')->is_valid_number, '北海道釧路郡釧路町遠矢南');
ok($zip->set_number('0882157')->is_valid_number, '北海道釧路郡釧路町わらび');
ok($zip->set_number('0882261')->is_valid_number, '北海道川上郡標茶町塘路(その他)');
ok($zip->set_number('0882262')->is_valid_number, '北海道川上郡標茶町ウライヤ');
ok($zip->set_number('0882263')->is_valid_number, '北海道川上郡標茶町沼ノ上');
ok($zip->set_number('0882264')->is_valid_number, '北海道川上郡標茶町塘路原野');
ok($zip->set_number('0882265')->is_valid_number, '北海道川上郡標茶町シラルトロ');
ok($zip->set_number('0882265')->is_valid_number, '北海道川上郡標茶町塘路(32番地)');
ok($zip->set_number('0882266')->is_valid_number, '北海道川上郡標茶町茅沼');
ok($zip->set_number('0882266')->is_valid_number, '北海道川上郡標茶町コツタロ原野');
ok($zip->set_number('0882271')->is_valid_number, '北海道川上郡標茶町阿歴内');
ok($zip->set_number('0882272')->is_valid_number, '北海道川上郡標茶町阿歴内原野');
ok($zip->set_number('0882273')->is_valid_number, '北海道川上郡標茶町西和');
ok($zip->set_number('0882274')->is_valid_number, '北海道川上郡標茶町東阿歴内');
ok($zip->set_number('0882275')->is_valid_number, '北海道川上郡標茶町北片無去');
ok($zip->set_number('0882300')->is_valid_number, '北海道川上郡標茶町以下に掲載がない場合');
ok($zip->set_number('0882301')->is_valid_number, '北海道川上郡標茶町旭');
ok($zip->set_number('0882302')->is_valid_number, '北海道川上郡標茶町富士');
ok($zip->set_number('0882303')->is_valid_number, '北海道川上郡標茶町桜');
ok($zip->set_number('0882304')->is_valid_number, '北海道川上郡標茶町平和');
ok($zip->set_number('0882305')->is_valid_number, '北海道川上郡標茶町麻生');
ok($zip->set_number('0882311')->is_valid_number, '北海道川上郡標茶町開運');
ok($zip->set_number('0882312')->is_valid_number, '北海道川上郡標茶町川上');
ok($zip->set_number('0882313')->is_valid_number, '北海道川上郡標茶町常盤');
ok($zip->set_number('0882314')->is_valid_number, '北海道川上郡標茶町標茶');
ok($zip->set_number('0882321')->is_valid_number, '北海道川上郡標茶町上チャンベツ');
ok($zip->set_number('0882322')->is_valid_number, '北海道川上郡標茶町中チャンベツ');
ok($zip->set_number('0882323')->is_valid_number, '北海道川上郡標茶町下チャンベツ');
ok($zip->set_number('0882324')->is_valid_number, '北海道川上郡標茶町雷別');
ok($zip->set_number('0882331')->is_valid_number, '北海道川上郡標茶町オソツベツ');
ok($zip->set_number('0882331')->is_valid_number, '北海道川上郡標茶町下オソツベツ');
ok($zip->set_number('0882332')->is_valid_number, '北海道川上郡標茶町中オソツベツ');
ok($zip->set_number('0882333')->is_valid_number, '北海道川上郡標茶町上オソツベツ');
ok($zip->set_number('0882334')->is_valid_number, '北海道川上郡標茶町厚生');
ok($zip->set_number('0882335')->is_valid_number, '北海道川上郡標茶町五十石');
ok($zip->set_number('0882336')->is_valid_number, '北海道川上郡標茶町ルルラン');
ok($zip->set_number('0882337')->is_valid_number, '北海道川上郡標茶町北標茶');
ok($zip->set_number('0882337')->is_valid_number, '北海道川上郡標茶町栄(その他)');
ok($zip->set_number('0882338')->is_valid_number, '北海道川上郡標茶町南標茶');
ok($zip->set_number('0882339')->is_valid_number, '北海道川上郡標茶町上多和');
ok($zip->set_number('0882339')->is_valid_number, '北海道川上郡標茶町多和(その他)');
ok($zip->set_number('0882380')->is_valid_number, '北海道川上郡標茶町クチョロ原野');
ok($zip->set_number('0882381')->is_valid_number, '北海道川上郡標茶町中久著呂市街');
ok($zip->set_number('0882382')->is_valid_number, '北海道川上郡標茶町中久著呂');
ok($zip->set_number('0882388')->is_valid_number, '北海道川上郡標茶町コッタロ');
ok($zip->set_number('0882389')->is_valid_number, '北海道川上郡標茶町ヌマオロ原野');
ok($zip->set_number('0882461')->is_valid_number, '北海道川上郡標茶町虹別市街');
ok($zip->set_number('0882462')->is_valid_number, '北海道川上郡標茶町虹別');
ok($zip->set_number('0882463')->is_valid_number, '北海道川上郡標茶町虹別(上虹)');
ok($zip->set_number('0882464')->is_valid_number, '北海道川上郡標茶町虹別(中虹)');
ok($zip->set_number('0882465')->is_valid_number, '北海道川上郡標茶町虹別(萩野)');
ok($zip->set_number('0882561')->is_valid_number, '北海道野付郡別海町西春別駅前柏町');
ok($zip->set_number('0882562')->is_valid_number, '北海道野付郡別海町西春別駅前栄町');
ok($zip->set_number('0882563')->is_valid_number, '北海道野付郡別海町西春別駅前錦町');
ok($zip->set_number('0882564')->is_valid_number, '北海道野付郡別海町西春別駅前西町');
ok($zip->set_number('0882565')->is_valid_number, '北海道野付郡別海町西春別駅前寿町');
ok($zip->set_number('0882566')->is_valid_number, '北海道野付郡別海町西春別駅前曙町');
ok($zip->set_number('0882571')->is_valid_number, '北海道野付郡別海町西春別幸町');
ok($zip->set_number('0882572')->is_valid_number, '北海道野付郡別海町西春別清川町');
ok($zip->set_number('0882573')->is_valid_number, '北海道野付郡別海町西春別本久町');
ok($zip->set_number('0882574')->is_valid_number, '北海道野付郡別海町西春別昭栄町');
ok($zip->set_number('0882575')->is_valid_number, '北海道野付郡別海町西春別宮園町');
ok($zip->set_number('0882576')->is_valid_number, '北海道野付郡別海町西春別');
ok($zip->set_number('0882577')->is_valid_number, '北海道野付郡別海町矢臼別(40の1番地、41の2番地)');
ok($zip->set_number('0882578')->is_valid_number, '北海道野付郡別海町泉川');
ok($zip->set_number('0882601')->is_valid_number, '北海道野付郡別海町大成');
ok($zip->set_number('0882602')->is_valid_number, '北海道野付郡別海町本別');
ok($zip->set_number('0882681')->is_valid_number, '北海道標津郡中標津町当幌');
ok($zip->set_number('0882682')->is_valid_number, '北海道標津郡中標津町計根別');
ok($zip->set_number('0882683')->is_valid_number, '北海道標津郡中標津町上標津');
ok($zip->set_number('0882684')->is_valid_number, '北海道標津郡中標津町養老牛');
ok($zip->set_number('0882685')->is_valid_number, '北海道標津郡中標津町西竹');
ok($zip->set_number('0882686')->is_valid_number, '北海道標津郡中標津町俣落(1629-1、1653-3、1684-5、1886-2、1893、');
ok($zip->set_number('0882686')->is_valid_number, '北海道標津郡中標津町1896-2、1896-3、1906-8、1932-2、1936、');
ok($zip->set_number('0882686')->is_valid_number, '北海道標津郡中標津町1936-2、1951-2、1956-2、1967-2、1980-2、');
ok($zip->set_number('0882686')->is_valid_number, '北海道標津郡中標津町1997-3、2000-2、2000-8、2003、2015-4、');
ok($zip->set_number('0882686')->is_valid_number, '北海道標津郡中標津町2023-2、2038-2、2253-2、2253-5、2253-21、');
ok($zip->set_number('0882686')->is_valid_number, '北海道標津郡中標津町2253-24、2253-35、2253-63)');
ok($zip->set_number('0882721')->is_valid_number, '北海道野付郡別海町上春別緑町');
ok($zip->set_number('0882722')->is_valid_number, '北海道野付郡別海町上春別旭町');
ok($zip->set_number('0882723')->is_valid_number, '北海道野付郡別海町上春別南町');
ok($zip->set_number('0882724')->is_valid_number, '北海道野付郡別海町上春別栄町');
ok($zip->set_number('0882725')->is_valid_number, '北海道野付郡別海町上春別');
ok($zip->set_number('0883141')->is_valid_number, '北海道川上郡標茶町多和(120番地)');
ok($zip->set_number('0883142')->is_valid_number, '北海道川上郡標茶町上磯分内');
ok($zip->set_number('0883143')->is_valid_number, '北海道川上郡標茶町磯分内美幌');
ok($zip->set_number('0883144')->is_valid_number, '北海道川上郡標茶町中多和');
ok($zip->set_number('0883145')->is_valid_number, '北海道川上郡標茶町熊牛原野');
ok($zip->set_number('0883146')->is_valid_number, '北海道川上郡標茶町磯分内下');
ok($zip->set_number('0883147')->is_valid_number, '北海道川上郡標茶町磯分内市街');
ok($zip->set_number('0883148')->is_valid_number, '北海道川上郡標茶町磯分内福島');
ok($zip->set_number('0883149')->is_valid_number, '北海道川上郡標茶町磯分内乙西');
ok($zip->set_number('0883151')->is_valid_number, '北海道川上郡標茶町磯分内上');
ok($zip->set_number('0883152')->is_valid_number, '北海道川上郡標茶町磯分内協盛');
ok($zip->set_number('0883153')->is_valid_number, '北海道川上郡標茶町磯分内小林');
ok($zip->set_number('0883154')->is_valid_number, '北海道川上郡標茶町栄(145、169番地)');
ok($zip->set_number('0883155')->is_valid_number, '北海道川上郡標茶町磯分内平泉');
ok($zip->set_number('0883156')->is_valid_number, '北海道川上郡標茶町磯分内平和');
ok($zip->set_number('0883157')->is_valid_number, '北海道川上郡標茶町磯分内憩');
ok($zip->set_number('0883200')->is_valid_number, '北海道川上郡弟子屈町以下に掲載がない場合');
ok($zip->set_number('0883201')->is_valid_number, '北海道川上郡弟子屈町摩周');
ok($zip->set_number('0883202')->is_valid_number, '北海道川上郡弟子屈町鈴蘭');
ok($zip->set_number('0883203')->is_valid_number, '北海道川上郡弟子屈町湯の島');
ok($zip->set_number('0883204')->is_valid_number, '北海道川上郡弟子屈町朝日');
ok($zip->set_number('0883211')->is_valid_number, '北海道川上郡弟子屈町中央');
ok($zip->set_number('0883212')->is_valid_number, '北海道川上郡弟子屈町泉');
ok($zip->set_number('0883213')->is_valid_number, '北海道川上郡弟子屈町桜丘');
ok($zip->set_number('0883214')->is_valid_number, '北海道川上郡弟子屈町高栄');
ok($zip->set_number('0883215')->is_valid_number, '北海道川上郡弟子屈町美里');
ok($zip->set_number('0883221')->is_valid_number, '北海道川上郡弟子屈町鐺別');
ok($zip->set_number('0883221')->is_valid_number, '北海道川上郡弟子屈町鐺別原野');
ok($zip->set_number('0883222')->is_valid_number, '北海道川上郡弟子屈町弟子屈原野');
ok($zip->set_number('0883223')->is_valid_number, '北海道川上郡弟子屈町仁多');
ok($zip->set_number('0883224')->is_valid_number, '北海道川上郡弟子屈町平和');
ok($zip->set_number('0883225')->is_valid_number, '北海道川上郡弟子屈町最栄利別');
ok($zip->set_number('0883226')->is_valid_number, '北海道川上郡弟子屈町奥オソベツ');
ok($zip->set_number('0883227')->is_valid_number, '北海道川上郡弟子屈町重内');
ok($zip->set_number('0883228')->is_valid_number, '北海道川上郡弟子屈町奥春別');
ok($zip->set_number('0883271')->is_valid_number, '北海道川上郡弟子屈町南弟子屈');
ok($zip->set_number('0883331')->is_valid_number, '北海道川上郡弟子屈町美留和');
ok($zip->set_number('0883331')->is_valid_number, '北海道川上郡弟子屈町美留和原野');
ok($zip->set_number('0883332')->is_valid_number, '北海道川上郡弟子屈町札友内');
ok($zip->set_number('0883332')->is_valid_number, '北海道川上郡弟子屈町札友内原野');
ok($zip->set_number('0883341')->is_valid_number, '北海道川上郡弟子屈町屈斜路');
ok($zip->set_number('0883341')->is_valid_number, '北海道川上郡弟子屈町屈斜路原野');
ok($zip->set_number('0883351')->is_valid_number, '北海道川上郡弟子屈町池の湯');
ok($zip->set_number('0883351')->is_valid_number, '北海道川上郡弟子屈町屈斜路市街地');
ok($zip->set_number('0883351')->is_valid_number, '北海道川上郡弟子屈町古丹');
ok($zip->set_number('0883351')->is_valid_number, '北海道川上郡弟子屈町砂湯');
ok($zip->set_number('0883461')->is_valid_number, '北海道川上郡弟子屈町跡佐登');
ok($zip->set_number('0883461')->is_valid_number, '北海道川上郡弟子屈町跡佐登原野');
ok($zip->set_number('0883462')->is_valid_number, '北海道川上郡弟子屈町川湯駅前');
ok($zip->set_number('0883463')->is_valid_number, '北海道川上郡弟子屈町アトサヌプリ原野');
ok($zip->set_number('0883464')->is_valid_number, '北海道川上郡弟子屈町サワンチサップ');
ok($zip->set_number('0883465')->is_valid_number, '北海道川上郡弟子屈町川湯温泉');
ok($zip->set_number('0890100')->is_valid_number, '北海道上川郡清水町以下に掲載がない場合');
ok($zip->set_number('0890101')->is_valid_number, '北海道上川郡清水町人舞');
ok($zip->set_number('0890102')->is_valid_number, '北海道上川郡清水町下佐幌');
ok($zip->set_number('0890103')->is_valid_number, '北海道上川郡清水町清水');
ok($zip->set_number('0890104')->is_valid_number, '北海道上川郡清水町南三条西');
ok($zip->set_number('0890105')->is_valid_number, '北海道上川郡清水町南四条西');
ok($zip->set_number('0890106')->is_valid_number, '北海道上川郡清水町南五条西');
ok($zip->set_number('0890107')->is_valid_number, '北海道上川郡清水町南六条西');
ok($zip->set_number('0890111')->is_valid_number, '北海道上川郡清水町南三条');
ok($zip->set_number('0890112')->is_valid_number, '北海道上川郡清水町南四条');
ok($zip->set_number('0890113')->is_valid_number, '北海道上川郡清水町南五条');
ok($zip->set_number('0890114')->is_valid_number, '北海道上川郡清水町南六条');
ok($zip->set_number('0890115')->is_valid_number, '北海道上川郡清水町南七条');
ok($zip->set_number('0890116')->is_valid_number, '北海道上川郡清水町南八条');
ok($zip->set_number('0890117')->is_valid_number, '北海道上川郡清水町南九条');
ok($zip->set_number('0890118')->is_valid_number, '北海道上川郡清水町南十条');
ok($zip->set_number('0890121')->is_valid_number, '北海道上川郡清水町北四条西');
ok($zip->set_number('0890122')->is_valid_number, '北海道上川郡清水町北三条西');
ok($zip->set_number('0890123')->is_valid_number, '北海道上川郡清水町北二条西');
ok($zip->set_number('0890124')->is_valid_number, '北海道上川郡清水町北一条西');
ok($zip->set_number('0890125')->is_valid_number, '北海道上川郡清水町本通西');
ok($zip->set_number('0890126')->is_valid_number, '北海道上川郡清水町南一条西');
ok($zip->set_number('0890127')->is_valid_number, '北海道上川郡清水町南二条西');
ok($zip->set_number('0890131')->is_valid_number, '北海道上川郡清水町北五条');
ok($zip->set_number('0890132')->is_valid_number, '北海道上川郡清水町北四条');
ok($zip->set_number('0890133')->is_valid_number, '北海道上川郡清水町北三条');
ok($zip->set_number('0890134')->is_valid_number, '北海道上川郡清水町北二条');
ok($zip->set_number('0890135')->is_valid_number, '北海道上川郡清水町北一条');
ok($zip->set_number('0890136')->is_valid_number, '北海道上川郡清水町本通');
ok($zip->set_number('0890137')->is_valid_number, '北海道上川郡清水町南一条');
ok($zip->set_number('0890138')->is_valid_number, '北海道上川郡清水町南二条');
ok($zip->set_number('0890241')->is_valid_number, '北海道上川郡清水町熊牛');
ok($zip->set_number('0890242')->is_valid_number, '北海道上川郡清水町美蔓');
ok($zip->set_number('0890243')->is_valid_number, '北海道上川郡清水町上然別');
ok($zip->set_number('0890351')->is_valid_number, '北海道上川郡清水町御影西一条');
ok($zip->set_number('0890352')->is_valid_number, '北海道上川郡清水町御影西二条');
ok($zip->set_number('0890353')->is_valid_number, '北海道上川郡清水町御影西三条');
ok($zip->set_number('0890354')->is_valid_number, '北海道上川郡清水町御影本通');
ok($zip->set_number('0890355')->is_valid_number, '北海道上川郡清水町旭山');
ok($zip->set_number('0890356')->is_valid_number, '北海道上川郡清水町羽帯');
ok($zip->set_number('0890357')->is_valid_number, '北海道上川郡清水町御影');
ok($zip->set_number('0890361')->is_valid_number, '北海道上川郡清水町御影東一条南');
ok($zip->set_number('0890362')->is_valid_number, '北海道上川郡清水町御影東二条南');
ok($zip->set_number('0890363')->is_valid_number, '北海道上川郡清水町御影東三条南');
ok($zip->set_number('0890371')->is_valid_number, '北海道上川郡清水町御影東一条');
ok($zip->set_number('0890372')->is_valid_number, '北海道上川郡清水町御影東二条');
ok($zip->set_number('0890373')->is_valid_number, '北海道上川郡清水町御影東三条');
ok($zip->set_number('0890374')->is_valid_number, '北海道上川郡清水町御影東四条');
ok($zip->set_number('0890375')->is_valid_number, '北海道上川郡清水町御影東五条');
ok($zip->set_number('0890376')->is_valid_number, '北海道上川郡清水町御影東六条');
ok($zip->set_number('0890377')->is_valid_number, '北海道上川郡清水町御影東七条');
ok($zip->set_number('0890378')->is_valid_number, '北海道上川郡清水町御影東八条');
ok($zip->set_number('0890531')->is_valid_number, '北海道中川郡幕別町札内暁町');
ok($zip->set_number('0890532')->is_valid_number, '北海道中川郡幕別町札内豊町');
ok($zip->set_number('0890533')->is_valid_number, '北海道中川郡幕別町札内新北町');
ok($zip->set_number('0890534')->is_valid_number, '北海道中川郡幕別町札内北町');
ok($zip->set_number('0890535')->is_valid_number, '北海道中川郡幕別町札内桜町');
ok($zip->set_number('0890536')->is_valid_number, '北海道中川郡幕別町札内西町');
ok($zip->set_number('0890537')->is_valid_number, '北海道中川郡幕別町札内北栄町');
ok($zip->set_number('0890538')->is_valid_number, '北海道中川郡幕別町札内共栄町');
ok($zip->set_number('0890541')->is_valid_number, '北海道中川郡幕別町札内青葉町');
ok($zip->set_number('0890542')->is_valid_number, '北海道中川郡幕別町札内春日町');
ok($zip->set_number('0890543')->is_valid_number, '北海道中川郡幕別町札内中央町');
ok($zip->set_number('0890544')->is_valid_number, '北海道中川郡幕別町札内若草町');
ok($zip->set_number('0890545')->is_valid_number, '北海道中川郡幕別町札内桂町');
ok($zip->set_number('0890546')->is_valid_number, '北海道中川郡幕別町札内堤町');
ok($zip->set_number('0890551')->is_valid_number, '北海道中川郡幕別町札内泉町');
ok($zip->set_number('0890552')->is_valid_number, '北海道中川郡幕別町札内あかしや町');
ok($zip->set_number('0890553')->is_valid_number, '北海道中川郡幕別町札内文京町');
ok($zip->set_number('0890554')->is_valid_number, '北海道中川郡幕別町札内みずほ町');
ok($zip->set_number('0890561')->is_valid_number, '北海道中川郡幕別町札内稔町');
ok($zip->set_number('0890562')->is_valid_number, '北海道中川郡幕別町札内東町');
ok($zip->set_number('0890563')->is_valid_number, '北海道中川郡幕別町千住');
ok($zip->set_number('0890564')->is_valid_number, '北海道中川郡幕別町稲志別');
ok($zip->set_number('0890565')->is_valid_number, '北海道中川郡幕別町新生');
ok($zip->set_number('0890566')->is_valid_number, '北海道中川郡幕別町昭和');
ok($zip->set_number('0890567')->is_valid_number, '北海道中川郡幕別町明倫(78、208番地)');
ok($zip->set_number('0890571')->is_valid_number, '北海道中川郡幕別町依田');
ok($zip->set_number('0890572')->is_valid_number, '北海道中川郡幕別町西和');
ok($zip->set_number('0890573')->is_valid_number, '北海道中川郡幕別町途別');
ok($zip->set_number('0890574')->is_valid_number, '北海道中川郡幕別町日新');
ok($zip->set_number('0890575')->is_valid_number, '北海道中川郡幕別町上稲志別');
ok($zip->set_number('0890576')->is_valid_number, '北海道中川郡幕別町古舞');
ok($zip->set_number('0890577')->is_valid_number, '北海道中川郡幕別町栄');
ok($zip->set_number('0890578')->is_valid_number, '北海道中川郡幕別町中稲志別');
ok($zip->set_number('0890600')->is_valid_number, '北海道中川郡幕別町以下に掲載がない場合');
ok($zip->set_number('0890601')->is_valid_number, '北海道中川郡幕別町幸町');
ok($zip->set_number('0890602')->is_valid_number, '北海道中川郡幕別町旭町');
ok($zip->set_number('0890603')->is_valid_number, '北海道中川郡幕別町本町');
ok($zip->set_number('0890604')->is_valid_number, '北海道中川郡幕別町錦町');
ok($zip->set_number('0890605')->is_valid_number, '北海道中川郡幕別町寿町');
ok($zip->set_number('0890611')->is_valid_number, '北海道中川郡幕別町新町');
ok($zip->set_number('0890612')->is_valid_number, '北海道中川郡幕別町明野');
ok($zip->set_number('0890613')->is_valid_number, '北海道中川郡幕別町新川');
ok($zip->set_number('0890614')->is_valid_number, '北海道中川郡幕別町緑町');
ok($zip->set_number('0890615')->is_valid_number, '北海道中川郡幕別町南町');
ok($zip->set_number('0890616')->is_valid_number, '北海道中川郡幕別町宝町');
ok($zip->set_number('0890621')->is_valid_number, '北海道中川郡幕別町相川');
ok($zip->set_number('0890622')->is_valid_number, '北海道中川郡幕別町大豊');
ok($zip->set_number('0890623')->is_valid_number, '北海道中川郡幕別町南勢');
ok($zip->set_number('0890624')->is_valid_number, '北海道中川郡幕別町軍岡');
ok($zip->set_number('0890625')->is_valid_number, '北海道中川郡幕別町猿別');
ok($zip->set_number('0890626')->is_valid_number, '北海道中川郡幕別町西猿別');
ok($zip->set_number('0890627')->is_valid_number, '北海道中川郡幕別町新和(その他)');
ok($zip->set_number('0890628')->is_valid_number, '北海道中川郡幕別町豊岡');
ok($zip->set_number('0890781')->is_valid_number, '北海道中川郡幕別町五位');
ok($zip->set_number('0890782')->is_valid_number, '北海道中川郡幕別町中里');
ok($zip->set_number('0890783')->is_valid_number, '北海道中川郡幕別町駒畠');
ok($zip->set_number('0890784')->is_valid_number, '北海道中川郡幕別町弘和');
ok($zip->set_number('0890785')->is_valid_number, '北海道中川郡幕別町美川');
ok($zip->set_number('0890786')->is_valid_number, '北海道中川郡幕別町糠内');
ok($zip->set_number('0890787')->is_valid_number, '北海道中川郡幕別町明倫(その他)');
ok($zip->set_number('0890788')->is_valid_number, '北海道中川郡幕別町新和(新田牧場)');
ok($zip->set_number('0891181')->is_valid_number, '北海道帯広市愛国町');
ok($zip->set_number('0891182')->is_valid_number, '北海道帯広市川西町');
ok($zip->set_number('0891183')->is_valid_number, '北海道帯広市豊西町');
ok($zip->set_number('0891184')->is_valid_number, '北海道帯広市別府町');
ok($zip->set_number('0891241')->is_valid_number, '北海道帯広市大正本町');
ok($zip->set_number('0891242')->is_valid_number, '北海道帯広市大正町');
ok($zip->set_number('0891243')->is_valid_number, '北海道帯広市桜木町');
ok($zip->set_number('0891244')->is_valid_number, '北海道帯広市以平町');
ok($zip->set_number('0891245')->is_valid_number, '北海道帯広市泉町');
ok($zip->set_number('0891246')->is_valid_number, '北海道帯広市幸福町');
ok($zip->set_number('0891247')->is_valid_number, '北海道帯広市昭和町');
ok($zip->set_number('0891251')->is_valid_number, '北海道帯広市富士町(その他)');
ok($zip->set_number('0891252')->is_valid_number, '北海道帯広市中島町');
ok($zip->set_number('0891300')->is_valid_number, '北海道河西郡中札内村以下に掲載がない場合');
ok($zip->set_number('0891310')->is_valid_number, '北海道河西郡中札内村大通北');
ok($zip->set_number('0891311')->is_valid_number, '北海道河西郡中札内村西一条北');
ok($zip->set_number('0891312')->is_valid_number, '北海道河西郡中札内村西二条北');
ok($zip->set_number('0891313')->is_valid_number, '北海道河西郡中札内村中札内西');
ok($zip->set_number('0891321')->is_valid_number, '北海道河西郡中札内村東一条北');
ok($zip->set_number('0891322')->is_valid_number, '北海道河西郡中札内村東二条北');
ok($zip->set_number('0891323')->is_valid_number, '北海道河西郡中札内村東三条北');
ok($zip->set_number('0891324')->is_valid_number, '北海道河西郡中札内村東四条北');
ok($zip->set_number('0891325')->is_valid_number, '北海道河西郡中札内村中札内基線');
ok($zip->set_number('0891330')->is_valid_number, '北海道河西郡中札内村大通南');
ok($zip->set_number('0891331')->is_valid_number, '北海道河西郡中札内村西一条南');
ok($zip->set_number('0891332')->is_valid_number, '北海道河西郡中札内村西二条南');
ok($zip->set_number('0891341')->is_valid_number, '北海道河西郡中札内村東一条南');
ok($zip->set_number('0891342')->is_valid_number, '北海道河西郡中札内村東二条南');
ok($zip->set_number('0891343')->is_valid_number, '北海道河西郡中札内村東三条南');
ok($zip->set_number('0891344')->is_valid_number, '北海道河西郡中札内村東四条南');
ok($zip->set_number('0891345')->is_valid_number, '北海道河西郡中札内村東五条南');
ok($zip->set_number('0891351')->is_valid_number, '北海道河西郡中札内村東戸蔦');
ok($zip->set_number('0891352')->is_valid_number, '北海道河西郡中札内村中戸蔦');
ok($zip->set_number('0891353')->is_valid_number, '北海道河西郡中札内村西戸蔦');
ok($zip->set_number('0891354')->is_valid_number, '北海道河西郡中札内村新札内');
ok($zip->set_number('0891355')->is_valid_number, '北海道河西郡中札内村新札内南');
ok($zip->set_number('0891356')->is_valid_number, '北海道河西郡中札内村西札内');
ok($zip->set_number('0891361')->is_valid_number, '北海道河西郡中札内村元大正');
ok($zip->set_number('0891362')->is_valid_number, '北海道河西郡中札内村新生');
ok($zip->set_number('0891363')->is_valid_number, '北海道河西郡中札内村興和');
ok($zip->set_number('0891364')->is_valid_number, '北海道河西郡中札内村共栄');
ok($zip->set_number('0891365')->is_valid_number, '北海道河西郡中札内村協和');
ok($zip->set_number('0891366')->is_valid_number, '北海道河西郡中札内村栄');
ok($zip->set_number('0891367')->is_valid_number, '北海道河西郡中札内村常盤基線');
ok($zip->set_number('0891368')->is_valid_number, '北海道河西郡中札内村南常盤');
ok($zip->set_number('0891371')->is_valid_number, '北海道河西郡中札内村上札内');
ok($zip->set_number('0891372')->is_valid_number, '北海道河西郡中札内村元札内');
ok($zip->set_number('0891373')->is_valid_number, '北海道河西郡中札内村元更別');
ok($zip->set_number('0891374')->is_valid_number, '北海道河西郡中札内村南札内');
ok($zip->set_number('0891500')->is_valid_number, '北海道河西郡更別村以下に掲載がない場合');
ok($zip->set_number('0891501')->is_valid_number, '北海道河西郡更別村新栄町');
ok($zip->set_number('0891502')->is_valid_number, '北海道河西郡更別村花園町');
ok($zip->set_number('0891511')->is_valid_number, '北海道河西郡更別村柏町');
ok($zip->set_number('0891512')->is_valid_number, '北海道河西郡更別村中央町');
ok($zip->set_number('0891513')->is_valid_number, '北海道河西郡更別村本町');
ok($zip->set_number('0891521')->is_valid_number, '北海道河西郡更別村錦町');
ok($zip->set_number('0891522')->is_valid_number, '北海道河西郡更別村若葉町');
ok($zip->set_number('0891531')->is_valid_number, '北海道河西郡更別村曙町');
ok($zip->set_number('0891532')->is_valid_number, '北海道河西郡更別村緑町');
ok($zip->set_number('0891541')->is_valid_number, '北海道河西郡更別村更南');
ok($zip->set_number('0891542')->is_valid_number, '北海道河西郡更別村更別(区)');
ok($zip->set_number('0891543')->is_valid_number, '北海道河西郡更別村昭和区');
ok($zip->set_number('0891551')->is_valid_number, '北海道河西郡更別村旭区');
ok($zip->set_number('0891552')->is_valid_number, '北海道河西郡更別村勢雄');
ok($zip->set_number('0891553')->is_valid_number, '北海道河西郡更別村平和区');
ok($zip->set_number('0891561')->is_valid_number, '北海道河西郡更別村北更別区');
ok($zip->set_number('0891562')->is_valid_number, '北海道河西郡更別村更別(東区)');
ok($zip->set_number('0891563')->is_valid_number, '北海道河西郡更別村南更別区');
ok($zip->set_number('0891571')->is_valid_number, '北海道河西郡更別村香川区');
ok($zip->set_number('0891572')->is_valid_number, '北海道河西郡更別村更生区');
ok($zip->set_number('0891573')->is_valid_number, '北海道河西郡更別村弘和');
ok($zip->set_number('0891573')->is_valid_number, '北海道河西郡更別村東栄');
ok($zip->set_number('0891581')->is_valid_number, '北海道河西郡更別村上更別(南区)');
ok($zip->set_number('0891582')->is_valid_number, '北海道河西郡更別村協和区');
ok($zip->set_number('0891583')->is_valid_number, '北海道河西郡更別村上更別(1区)');
ok($zip->set_number('0891701')->is_valid_number, '北海道中川郡幕別町忠類白銀町');
ok($zip->set_number('0891703')->is_valid_number, '北海道中川郡幕別町忠類栄町');
ok($zip->set_number('0891705')->is_valid_number, '北海道中川郡幕別町忠類本町');
ok($zip->set_number('0891707')->is_valid_number, '北海道中川郡幕別町忠類錦町');
ok($zip->set_number('0891709')->is_valid_number, '北海道中川郡幕別町忠類幸町');
ok($zip->set_number('0891711')->is_valid_number, '北海道中川郡幕別町忠類東宝');
ok($zip->set_number('0891714')->is_valid_number, '北海道中川郡幕別町忠類新生');
ok($zip->set_number('0891715')->is_valid_number, '北海道中川郡幕別町忠類幌内');
ok($zip->set_number('0891716')->is_valid_number, '北海道中川郡幕別町忠類元忠類');
ok($zip->set_number('0891717')->is_valid_number, '北海道中川郡幕別町忠類朝日');
ok($zip->set_number('0891721')->is_valid_number, '北海道中川郡幕別町忠類西当');
ok($zip->set_number('0891724')->is_valid_number, '北海道中川郡幕別町忠類明和');
ok($zip->set_number('0891725')->is_valid_number, '北海道中川郡幕別町忠類中当');
ok($zip->set_number('0891726')->is_valid_number, '北海道中川郡幕別町忠類古里');
ok($zip->set_number('0891727')->is_valid_number, '北海道中川郡幕別町忠類共栄');
ok($zip->set_number('0891728')->is_valid_number, '北海道中川郡幕別町忠類協徳');
ok($zip->set_number('0891729')->is_valid_number, '北海道中川郡幕別町忠類日和');
ok($zip->set_number('0891731')->is_valid_number, '北海道中川郡幕別町忠類公親');
ok($zip->set_number('0891871')->is_valid_number, '北海道中川郡幕別町忠類晩成');
ok($zip->set_number('0891881')->is_valid_number, '北海道広尾郡大樹町生花');
ok($zip->set_number('0891882')->is_valid_number, '北海道広尾郡大樹町晩成');
ok($zip->set_number('0892100')->is_valid_number, '北海道広尾郡大樹町以下に掲載がない場合');
ok($zip->set_number('0892101')->is_valid_number, '北海道広尾郡大樹町東和');
ok($zip->set_number('0892102')->is_valid_number, '北海道広尾郡大樹町大和');
ok($zip->set_number('0892103')->is_valid_number, '北海道広尾郡大樹町上大樹');
ok($zip->set_number('0892104')->is_valid_number, '北海道広尾郡大樹町中大樹');
ok($zip->set_number('0892105')->is_valid_number, '北海道広尾郡大樹町大樹');
ok($zip->set_number('0892106')->is_valid_number, '北海道広尾郡大樹町下大樹');
ok($zip->set_number('0892107')->is_valid_number, '北海道広尾郡大樹町松山');
ok($zip->set_number('0892111')->is_valid_number, '北海道広尾郡大樹町上萠和');
ok($zip->set_number('0892112')->is_valid_number, '北海道広尾郡大樹町萠和');
ok($zip->set_number('0892113')->is_valid_number, '北海道広尾郡大樹町芽武');
ok($zip->set_number('0892114')->is_valid_number, '北海道広尾郡大樹町下芽武');
ok($zip->set_number('0892115')->is_valid_number, '北海道広尾郡大樹町美成');
ok($zip->set_number('0892116')->is_valid_number, '北海道広尾郡大樹町浜大樹');
ok($zip->set_number('0892117')->is_valid_number, '北海道広尾郡大樹町更生');
ok($zip->set_number('0892121')->is_valid_number, '北海道広尾郡大樹町旭浜');
ok($zip->set_number('0892122')->is_valid_number, '北海道広尾郡大樹町中島');
ok($zip->set_number('0892123')->is_valid_number, '北海道広尾郡大樹町上中島');
ok($zip->set_number('0892124')->is_valid_number, '北海道広尾郡大樹町日方');
ok($zip->set_number('0892125')->is_valid_number, '北海道広尾郡大樹町石坂');
ok($zip->set_number('0892126')->is_valid_number, '北海道広尾郡大樹町開進');
ok($zip->set_number('0892127')->is_valid_number, '北海道広尾郡大樹町振別');
ok($zip->set_number('0892131')->is_valid_number, '北海道広尾郡大樹町松山町');
ok($zip->set_number('0892132')->is_valid_number, '北海道広尾郡大樹町双葉町');
ok($zip->set_number('0892133')->is_valid_number, '北海道広尾郡大樹町仲通');
ok($zip->set_number('0892134')->is_valid_number, '北海道広尾郡大樹町東本通');
ok($zip->set_number('0892135')->is_valid_number, '北海道広尾郡大樹町南通');
ok($zip->set_number('0892136')->is_valid_number, '北海道広尾郡大樹町新通');
ok($zip->set_number('0892137')->is_valid_number, '北海道広尾郡大樹町北通');
ok($zip->set_number('0892138')->is_valid_number, '北海道広尾郡大樹町柏木町');
ok($zip->set_number('0892140')->is_valid_number, '北海道広尾郡大樹町栄通');
ok($zip->set_number('0892141')->is_valid_number, '北海道広尾郡大樹町一条通');
ok($zip->set_number('0892142')->is_valid_number, '北海道広尾郡大樹町二条通');
ok($zip->set_number('0892143')->is_valid_number, '北海道広尾郡大樹町三条通');
ok($zip->set_number('0892145')->is_valid_number, '北海道広尾郡大樹町暁町');
ok($zip->set_number('0892146')->is_valid_number, '北海道広尾郡大樹町寿通');
ok($zip->set_number('0892147')->is_valid_number, '北海道広尾郡大樹町鏡町');
ok($zip->set_number('0892148')->is_valid_number, '北海道広尾郡大樹町麻友');
ok($zip->set_number('0892151')->is_valid_number, '北海道広尾郡大樹町高校通');
ok($zip->set_number('0892152')->is_valid_number, '北海道広尾郡大樹町西本通');
ok($zip->set_number('0892153')->is_valid_number, '北海道広尾郡大樹町南町');
ok($zip->set_number('0892154')->is_valid_number, '北海道広尾郡大樹町幸町');
ok($zip->set_number('0892155')->is_valid_number, '北海道広尾郡大樹町緑町');
ok($zip->set_number('0892156')->is_valid_number, '北海道広尾郡大樹町緑苑');
ok($zip->set_number('0892261')->is_valid_number, '北海道広尾郡大樹町尾田');
ok($zip->set_number('0892261')->is_valid_number, '北海道広尾郡大樹町拓北');
ok($zip->set_number('0892261')->is_valid_number, '北海道広尾郡大樹町豊里');
ok($zip->set_number('0892262')->is_valid_number, '北海道広尾郡大樹町相川');
ok($zip->set_number('0892263')->is_valid_number, '北海道広尾郡大樹町拓進');
ok($zip->set_number('0892271')->is_valid_number, '北海道広尾郡大樹町光地園');
ok($zip->set_number('0892272')->is_valid_number, '北海道広尾郡大樹町幸徳');
ok($zip->set_number('0892272')->is_valid_number, '北海道広尾郡大樹町住吉');
ok($zip->set_number('0892273')->is_valid_number, '北海道広尾郡大樹町大光');
ok($zip->set_number('0892273')->is_valid_number, '北海道広尾郡大樹町大全');
ok($zip->set_number('0892445')->is_valid_number, '北海道広尾郡広尾町カシュウンナイ');
ok($zip->set_number('0892446')->is_valid_number, '北海道広尾郡広尾町紋別');
ok($zip->set_number('0892447')->is_valid_number, '北海道広尾郡広尾町上豊似');
ok($zip->set_number('0892447')->is_valid_number, '北海道広尾郡広尾町下トヨイ');
ok($zip->set_number('0892447')->is_valid_number, '北海道広尾郡広尾町下豊似');
ok($zip->set_number('0892447')->is_valid_number, '北海道広尾郡広尾町トヨイベツ');
ok($zip->set_number('0892448')->is_valid_number, '北海道広尾郡広尾町上トヨイ');
ok($zip->set_number('0892455')->is_valid_number, '北海道広尾郡広尾町豊似');
ok($zip->set_number('0892561')->is_valid_number, '北海道広尾郡広尾町野塚');
ok($zip->set_number('0892562')->is_valid_number, '北海道広尾郡広尾町野塚西通');
ok($zip->set_number('0892563')->is_valid_number, '北海道広尾郡広尾町野塚東通');
ok($zip->set_number('0892564')->is_valid_number, '北海道広尾郡広尾町野塚本通');
ok($zip->set_number('0892600')->is_valid_number, '北海道広尾郡広尾町以下に掲載がない場合');
ok($zip->set_number('0892601')->is_valid_number, '北海道広尾郡広尾町東一条');
ok($zip->set_number('0892602')->is_valid_number, '北海道広尾郡広尾町東二条');
ok($zip->set_number('0892603')->is_valid_number, '北海道広尾郡広尾町東三条');
ok($zip->set_number('0892604')->is_valid_number, '北海道広尾郡広尾町会所通');
ok($zip->set_number('0892605')->is_valid_number, '北海道広尾郡広尾町会所前');
ok($zip->set_number('0892611')->is_valid_number, '北海道広尾郡広尾町西一条');
ok($zip->set_number('0892612')->is_valid_number, '北海道広尾郡広尾町西二条');
ok($zip->set_number('0892613')->is_valid_number, '北海道広尾郡広尾町西三条');
ok($zip->set_number('0892614')->is_valid_number, '北海道広尾郡広尾町西四条');
ok($zip->set_number('0892615')->is_valid_number, '北海道広尾郡広尾町本通');
ok($zip->set_number('0892616')->is_valid_number, '北海道広尾郡広尾町陣屋');
ok($zip->set_number('0892621')->is_valid_number, '北海道広尾郡広尾町公園通北');
ok($zip->set_number('0892622')->is_valid_number, '北海道広尾郡広尾町公園通南');
ok($zip->set_number('0892623')->is_valid_number, '北海道広尾郡広尾町並木通西');
ok($zip->set_number('0892624')->is_valid_number, '北海道広尾郡広尾町並木通東');
ok($zip->set_number('0892625')->is_valid_number, '北海道広尾郡広尾町錦通北');
ok($zip->set_number('0892626')->is_valid_number, '北海道広尾郡広尾町錦通南');
ok($zip->set_number('0892627')->is_valid_number, '北海道広尾郡広尾町丸山通北');
ok($zip->set_number('0892628')->is_valid_number, '北海道広尾郡広尾町丸山通南');
ok($zip->set_number('0892631')->is_valid_number, '北海道広尾郡広尾町白樺通北');
ok($zip->set_number('0892632')->is_valid_number, '北海道広尾郡広尾町白樺通南');
ok($zip->set_number('0892633')->is_valid_number, '北海道広尾郡広尾町美幌');
ok($zip->set_number('0892634')->is_valid_number, '北海道広尾郡広尾町フンベ');
ok($zip->set_number('0892635')->is_valid_number, '北海道広尾郡広尾町紅葉通北');
ok($zip->set_number('0892636')->is_valid_number, '北海道広尾郡広尾町紅葉通南');
ok($zip->set_number('0892637')->is_valid_number, '北海道広尾郡広尾町茂寄');
ok($zip->set_number('0892638')->is_valid_number, '北海道広尾郡広尾町茂寄南');
ok($zip->set_number('0892771')->is_valid_number, '北海道広尾郡広尾町音調津');
ok($zip->set_number('0892772')->is_valid_number, '北海道広尾郡広尾町音調津区画外');
ok($zip->set_number('0892773')->is_valid_number, '北海道広尾郡広尾町モエケシ');
ok($zip->set_number('0892774')->is_valid_number, '北海道広尾郡広尾町ルベシベツ');
ok($zip->set_number('0892775')->is_valid_number, '北海道広尾郡広尾町タニイソ');
ok($zip->set_number('0892776')->is_valid_number, '北海道広尾郡広尾町ビタタヌンケ');
ok($zip->set_number('0893151')->is_valid_number, '北海道中川郡池田町大森');
ok($zip->set_number('0893152')->is_valid_number, '北海道中川郡池田町高島');
ok($zip->set_number('0893153')->is_valid_number, '北海道中川郡池田町近牛');
ok($zip->set_number('0893154')->is_valid_number, '北海道中川郡池田町信取');
ok($zip->set_number('0893155')->is_valid_number, '北海道中川郡池田町美加登');
ok($zip->set_number('0893156')->is_valid_number, '北海道中川郡池田町常盤');
ok($zip->set_number('0893281')->is_valid_number, '北海道中川郡本別町勇足元町');
ok($zip->set_number('0893282')->is_valid_number, '北海道中川郡本別町勇足');
ok($zip->set_number('0893283')->is_valid_number, '北海道中川郡本別町押帯');
ok($zip->set_number('0893284')->is_valid_number, '北海道中川郡本別町美蘭別');
ok($zip->set_number('0893300')->is_valid_number, '北海道中川郡本別町以下に掲載がない場合');
ok($zip->set_number('0893301')->is_valid_number, '北海道中川郡本別町東本別');
ok($zip->set_number('0893302')->is_valid_number, '北海道中川郡本別町東町');
ok($zip->set_number('0893303')->is_valid_number, '北海道中川郡本別町向陽町');
ok($zip->set_number('0893304')->is_valid_number, '北海道中川郡本別町坂下町');
ok($zip->set_number('0893305')->is_valid_number, '北海道中川郡本別町共栄');
ok($zip->set_number('0893306')->is_valid_number, '北海道中川郡本別町チエトイ');
ok($zip->set_number('0893307')->is_valid_number, '北海道中川郡本別町負箙');
ok($zip->set_number('0893308')->is_valid_number, '北海道中川郡本別町弥生町');
ok($zip->set_number('0893311')->is_valid_number, '北海道中川郡本別町柏木町');
ok($zip->set_number('0893312')->is_valid_number, '北海道中川郡本別町緑町');
ok($zip->set_number('0893313')->is_valid_number, '北海道中川郡本別町柳町');
ok($zip->set_number('0893314')->is_valid_number, '北海道中川郡本別町南');
ok($zip->set_number('0893321')->is_valid_number, '北海道中川郡本別町上本別(フラツナイ)');
ok($zip->set_number('0893322')->is_valid_number, '北海道中川郡本別町栄町');
ok($zip->set_number('0893323')->is_valid_number, '北海道中川郡本別町美里別(東下)');
ok($zip->set_number('0893324')->is_valid_number, '北海道中川郡本別町新町');
ok($zip->set_number('0893325')->is_valid_number, '北海道中川郡本別町西美里別(その他)');
ok($zip->set_number('0893326')->is_valid_number, '北海道中川郡本別町美里別(高東)');
ok($zip->set_number('0893327')->is_valid_number, '北海道中川郡本別町追名牛(その他)');
ok($zip->set_number('0893331')->is_valid_number, '北海道中川郡本別町錦町');
ok($zip->set_number('0893332')->is_valid_number, '北海道中川郡本別町朝日町');
ok($zip->set_number('0893333')->is_valid_number, '北海道中川郡本別町山手町');
ok($zip->set_number('0893334')->is_valid_number, '北海道中川郡本別町北');
ok($zip->set_number('0893334')->is_valid_number, '北海道中川郡本別町清流町');
ok($zip->set_number('0893442')->is_valid_number, '北海道中川郡本別町美里別(拓農、東活込、東上、東中)');
ok($zip->set_number('0893443')->is_valid_number, '北海道中川郡本別町西美里別(113~791番地、西活込、西上、西中)');
ok($zip->set_number('0893571')->is_valid_number, '北海道十勝郡浦幌町恩根内');
ok($zip->set_number('0893572')->is_valid_number, '北海道十勝郡浦幌町川流布');
ok($zip->set_number('0893573')->is_valid_number, '北海道十勝郡浦幌町富川');
ok($zip->set_number('0893574')->is_valid_number, '北海道十勝郡浦幌町活平');
ok($zip->set_number('0893575')->is_valid_number, '北海道十勝郡浦幌町美園');
ok($zip->set_number('0893576')->is_valid_number, '北海道十勝郡浦幌町相川');
ok($zip->set_number('0893577')->is_valid_number, '北海道十勝郡浦幌町合流');
ok($zip->set_number('0893578')->is_valid_number, '北海道十勝郡浦幌町宝生');
ok($zip->set_number('0893585')->is_valid_number, '北海道十勝郡浦幌町川上');
ok($zip->set_number('0893586')->is_valid_number, '北海道十勝郡浦幌町栄穂');
ok($zip->set_number('0893587')->is_valid_number, '北海道十勝郡浦幌町貴老路');
ok($zip->set_number('0893661')->is_valid_number, '北海道中川郡本別町美栄');
ok($zip->set_number('0893662')->is_valid_number, '北海道中川郡本別町奥仙美里');
ok($zip->set_number('0893663')->is_valid_number, '北海道中川郡本別町仙美里');
ok($zip->set_number('0893664')->is_valid_number, '北海道中川郡本別町仙美里元町');
ok($zip->set_number('0893665')->is_valid_number, '北海道中川郡本別町清里');
ok($zip->set_number('0893666')->is_valid_number, '北海道中川郡本別町上仙美里');
ok($zip->set_number('0893671')->is_valid_number, '北海道中川郡本別町木札内');
ok($zip->set_number('0893672')->is_valid_number, '北海道中川郡本別町追名牛(67-4~113-7番地)');
ok($zip->set_number('0893673')->is_valid_number, '北海道中川郡本別町東仙美里');
ok($zip->set_number('0893674')->is_valid_number, '北海道中川郡本別町下仙美里');
ok($zip->set_number('0893675')->is_valid_number, '北海道中川郡本別町西仙美里');
ok($zip->set_number('0893676')->is_valid_number, '北海道中川郡本別町明美');
ok($zip->set_number('0893677')->is_valid_number, '北海道中川郡本別町美里別(246-7番地)');
ok($zip->set_number('0893700')->is_valid_number, '北海道足寄郡足寄町以下に掲載がない場合');
ok($zip->set_number('0893701')->is_valid_number, '北海道足寄郡足寄町北一条');
ok($zip->set_number('0893702')->is_valid_number, '北海道足寄郡足寄町北二条');
ok($zip->set_number('0893703')->is_valid_number, '北海道足寄郡足寄町北三条');
ok($zip->set_number('0893704')->is_valid_number, '北海道足寄郡足寄町北四条');
ok($zip->set_number('0893705')->is_valid_number, '北海道足寄郡足寄町北五条');
ok($zip->set_number('0893706')->is_valid_number, '北海道足寄郡足寄町北六条');
ok($zip->set_number('0893707')->is_valid_number, '北海道足寄郡足寄町下愛冠');
ok($zip->set_number('0893708')->is_valid_number, '北海道足寄郡足寄町愛冠');
ok($zip->set_number('0893711')->is_valid_number, '北海道足寄郡足寄町南一条');
ok($zip->set_number('0893712')->is_valid_number, '北海道足寄郡足寄町南二条');
ok($zip->set_number('0893713')->is_valid_number, '北海道足寄郡足寄町南三条');
ok($zip->set_number('0893714')->is_valid_number, '北海道足寄郡足寄町南四条');
ok($zip->set_number('0893715')->is_valid_number, '北海道足寄郡足寄町南五条');
ok($zip->set_number('0893716')->is_valid_number, '北海道足寄郡足寄町南六条');
ok($zip->set_number('0893717')->is_valid_number, '北海道足寄郡足寄町南七条');
ok($zip->set_number('0893718')->is_valid_number, '北海道足寄郡足寄町栄町');
ok($zip->set_number('0893721')->is_valid_number, '北海道足寄郡足寄町旭町');
ok($zip->set_number('0893722')->is_valid_number, '北海道足寄郡足寄町新町');
ok($zip->set_number('0893723')->is_valid_number, '北海道足寄郡足寄町中足寄');
ok($zip->set_number('0893724')->is_valid_number, '北海道足寄郡足寄町稲牛');
ok($zip->set_number('0893725')->is_valid_number, '北海道足寄郡足寄町平和');
ok($zip->set_number('0893726')->is_valid_number, '北海道足寄郡足寄町共栄町');
ok($zip->set_number('0893727')->is_valid_number, '北海道足寄郡足寄町郊南');
ok($zip->set_number('0893731')->is_valid_number, '北海道足寄郡足寄町中矢(7~288番地)');
ok($zip->set_number('0893732')->is_valid_number, '北海道足寄郡足寄町里見が丘');
ok($zip->set_number('0893733')->is_valid_number, '北海道足寄郡足寄町西町');
ok($zip->set_number('0893734')->is_valid_number, '北海道足寄郡足寄町常盤');
ok($zip->set_number('0893735')->is_valid_number, '北海道足寄郡足寄町美盛');
ok($zip->set_number('0893736')->is_valid_number, '北海道足寄郡足寄町鷲府');
ok($zip->set_number('0893737')->is_valid_number, '北海道足寄郡足寄町茂喜登牛(12~634番地)');
ok($zip->set_number('0893871')->is_valid_number, '北海道足寄郡足寄町芽登本町');
ok($zip->set_number('0893872')->is_valid_number, '北海道足寄郡足寄町芽登');
ok($zip->set_number('0893873')->is_valid_number, '北海道足寄郡足寄町中矢(426~782番地)');
ok($zip->set_number('0893874')->is_valid_number, '北海道足寄郡足寄町喜登牛');
ok($zip->set_number('0893875')->is_valid_number, '北海道足寄郡足寄町茂喜登牛(759~2786番地)');
ok($zip->set_number('0893961')->is_valid_number, '北海道足寄郡足寄町上足寄');
ok($zip->set_number('0893962')->is_valid_number, '北海道足寄郡足寄町上足寄本町');
ok($zip->set_number('0893963')->is_valid_number, '北海道足寄郡足寄町上螺湾');
ok($zip->set_number('0893964')->is_valid_number, '北海道足寄郡足寄町茂足寄');
ok($zip->set_number('0893965')->is_valid_number, '北海道足寄郡足寄町螺湾');
ok($zip->set_number('0893966')->is_valid_number, '北海道足寄郡足寄町螺湾本町');
ok($zip->set_number('0894141')->is_valid_number, '北海道足寄郡足寄町上利別本町');
ok($zip->set_number('0894142')->is_valid_number, '北海道足寄郡足寄町上利別');
ok($zip->set_number('0894143')->is_valid_number, '北海道足寄郡足寄町白糸');
ok($zip->set_number('0894144')->is_valid_number, '北海道足寄郡足寄町大誉地(10-1番地)');
ok($zip->set_number('0894251')->is_valid_number, '北海道足寄郡足寄町大誉地(その他)');
ok($zip->set_number('0894252')->is_valid_number, '北海道足寄郡足寄町大誉地本町');
ok($zip->set_number('0894261')->is_valid_number, '北海道足寄郡陸別町登良利');
ok($zip->set_number('0894262')->is_valid_number, '北海道足寄郡陸別町薫別');
ok($zip->set_number('0894300')->is_valid_number, '北海道足寄郡陸別町以下に掲載がない場合');
ok($zip->set_number('0894301')->is_valid_number, '北海道足寄郡陸別町ウエンベツ');
ok($zip->set_number('0894302')->is_valid_number, '北海道足寄郡陸別町若葉');
ok($zip->set_number('0894303')->is_valid_number, '北海道足寄郡陸別町下陸別');
ok($zip->set_number('0894304')->is_valid_number, '北海道足寄郡陸別町共和');
ok($zip->set_number('0894305')->is_valid_number, '北海道足寄郡陸別町中陸別');
ok($zip->set_number('0894306')->is_valid_number, '北海道足寄郡陸別町止若内');
ok($zip->set_number('0894307')->is_valid_number, '北海道足寄郡陸別町作集');
ok($zip->set_number('0894308')->is_valid_number, '北海道足寄郡陸別町上陸別');
ok($zip->set_number('0894311')->is_valid_number, '北海道足寄郡陸別町東一条二区');
ok($zip->set_number('0894312')->is_valid_number, '北海道足寄郡陸別町共栄第二');
ok($zip->set_number('0894313')->is_valid_number, '北海道足寄郡陸別町共栄第一');
ok($zip->set_number('0894314')->is_valid_number, '北海道足寄郡陸別町東一条一区');
ok($zip->set_number('0894315')->is_valid_number, '北海道足寄郡陸別町大通');
ok($zip->set_number('0894316')->is_valid_number, '北海道足寄郡陸別町栄町');
ok($zip->set_number('0894321')->is_valid_number, '北海道足寄郡陸別町恩根内');
ok($zip->set_number('0894322')->is_valid_number, '北海道足寄郡陸別町新町一区');
ok($zip->set_number('0894323')->is_valid_number, '北海道足寄郡陸別町新町二区');
ok($zip->set_number('0894324')->is_valid_number, '北海道足寄郡陸別町旭町');
ok($zip->set_number('0894325')->is_valid_number, '北海道足寄郡陸別町元町');
ok($zip->set_number('0894326')->is_valid_number, '北海道足寄郡陸別町緑町');
ok($zip->set_number('0894331')->is_valid_number, '北海道足寄郡陸別町川向');
ok($zip->set_number('0894332')->is_valid_number, '北海道足寄郡陸別町関');
ok($zip->set_number('0894333')->is_valid_number, '北海道足寄郡陸別町殖産');
ok($zip->set_number('0894334')->is_valid_number, '北海道足寄郡陸別町東斗満');
ok($zip->set_number('0894335')->is_valid_number, '北海道足寄郡陸別町中斗満');
ok($zip->set_number('0894336')->is_valid_number, '北海道足寄郡陸別町弥生');
ok($zip->set_number('0894337')->is_valid_number, '北海道足寄郡陸別町下斗満');
ok($zip->set_number('0894341')->is_valid_number, '北海道足寄郡陸別町苫務');
ok($zip->set_number('0894342')->is_valid_number, '北海道足寄郡陸別町上斗満');
ok($zip->set_number('0894343')->is_valid_number, '北海道足寄郡陸別町南斗満');
ok($zip->set_number('0894344')->is_valid_number, '北海道足寄郡陸別町西斗満');
ok($zip->set_number('0894345')->is_valid_number, '北海道足寄郡陸別町北斗満');
ok($zip->set_number('0894346')->is_valid_number, '北海道足寄郡陸別町ポントマム');
ok($zip->set_number('0894351')->is_valid_number, '北海道足寄郡陸別町勲祢別');
ok($zip->set_number('0894352')->is_valid_number, '北海道足寄郡陸別町分線');
ok($zip->set_number('0894353')->is_valid_number, '北海道足寄郡陸別町川上');
ok($zip->set_number('0894354')->is_valid_number, '北海道足寄郡陸別町日宗');
ok($zip->set_number('0894355')->is_valid_number, '北海道足寄郡陸別町小利別');
ok($zip->set_number('0894356')->is_valid_number, '北海道足寄郡陸別町林内');
ok($zip->set_number('0894357')->is_valid_number, '北海道足寄郡陸別町利上');
ok($zip->set_number('0895231')->is_valid_number, '北海道中川郡豊頃町豊頃佐々田町');
ok($zip->set_number('0895232')->is_valid_number, '北海道中川郡豊頃町豊頃旭町');
ok($zip->set_number('0895233')->is_valid_number, '北海道中川郡豊頃町豊頃南町');
ok($zip->set_number('0895234')->is_valid_number, '北海道中川郡豊頃町中央新町');
ok($zip->set_number('0895235')->is_valid_number, '北海道中川郡豊頃町中央若葉町');
ok($zip->set_number('0895241')->is_valid_number, '北海道中川郡豊頃町育素多');
ok($zip->set_number('0895242')->is_valid_number, '北海道中川郡豊頃町北栄');
ok($zip->set_number('0895243')->is_valid_number, '北海道中川郡豊頃町十弗宝町');
ok($zip->set_number('0895244')->is_valid_number, '北海道中川郡豊頃町十弗');
ok($zip->set_number('0895245')->is_valid_number, '北海道中川郡豊頃町礼文内');
ok($zip->set_number('0895246')->is_valid_number, '北海道中川郡豊頃町豊頃');
ok($zip->set_number('0895247')->is_valid_number, '北海道中川郡豊頃町幌岡');
ok($zip->set_number('0895300')->is_valid_number, '北海道中川郡豊頃町以下に掲載がない場合');
ok($zip->set_number('0895301')->is_valid_number, '北海道中川郡豊頃町統内');
ok($zip->set_number('0895302')->is_valid_number, '北海道中川郡豊頃町礼作別');
ok($zip->set_number('0895303')->is_valid_number, '北海道中川郡豊頃町農野牛');
ok($zip->set_number('0895304')->is_valid_number, '北海道中川郡豊頃町牛首別');
ok($zip->set_number('0895305')->is_valid_number, '北海道中川郡豊頃町背負');
ok($zip->set_number('0895306')->is_valid_number, '北海道中川郡豊頃町安骨');
ok($zip->set_number('0895307')->is_valid_number, '北海道中川郡豊頃町旅来');
ok($zip->set_number('0895308')->is_valid_number, '北海道中川郡豊頃町湧洞');
ok($zip->set_number('0895309')->is_valid_number, '北海道中川郡豊頃町二宮');
ok($zip->set_number('0895311')->is_valid_number, '北海道中川郡豊頃町茂岩新和町');
ok($zip->set_number('0895312')->is_valid_number, '北海道中川郡豊頃町茂岩本町');
ok($zip->set_number('0895313')->is_valid_number, '北海道中川郡豊頃町茂岩栄町');
ok($zip->set_number('0895314')->is_valid_number, '北海道中川郡豊頃町茂岩末広町');
ok($zip->set_number('0895315')->is_valid_number, '北海道中川郡豊頃町茂岩');
ok($zip->set_number('0895461')->is_valid_number, '北海道中川郡豊頃町大津元町');
ok($zip->set_number('0895462')->is_valid_number, '北海道中川郡豊頃町大津幸町');
ok($zip->set_number('0895463')->is_valid_number, '北海道中川郡豊頃町大津寿町');
ok($zip->set_number('0895464')->is_valid_number, '北海道中川郡豊頃町大津港町');
ok($zip->set_number('0895465')->is_valid_number, '北海道中川郡豊頃町大津');
ok($zip->set_number('0895466')->is_valid_number, '北海道中川郡豊頃町長節');
ok($zip->set_number('0895541')->is_valid_number, '北海道十勝郡浦幌町吉野');
ok($zip->set_number('0895542')->is_valid_number, '北海道十勝郡浦幌町共栄');
ok($zip->set_number('0895543')->is_valid_number, '北海道十勝郡浦幌町平和');
ok($zip->set_number('0895544')->is_valid_number, '北海道十勝郡浦幌町統太');
ok($zip->set_number('0895545')->is_valid_number, '北海道十勝郡浦幌町養老');
ok($zip->set_number('0895546')->is_valid_number, '北海道十勝郡浦幌町朝日');
ok($zip->set_number('0895547')->is_valid_number, '北海道十勝郡浦幌町生剛');
ok($zip->set_number('0895548')->is_valid_number, '北海道十勝郡浦幌町十勝太');
ok($zip->set_number('0895551')->is_valid_number, '北海道十勝郡浦幌町愛牛');
ok($zip->set_number('0895552')->is_valid_number, '北海道十勝郡浦幌町豊北');
ok($zip->set_number('0895553')->is_valid_number, '北海道十勝郡浦幌町打内');
ok($zip->set_number('0895554')->is_valid_number, '北海道十勝郡浦幌町大平');
ok($zip->set_number('0895555')->is_valid_number, '北海道十勝郡浦幌町トイトッキ');
ok($zip->set_number('0895556')->is_valid_number, '北海道十勝郡浦幌町鼈奴');
ok($zip->set_number('0895557')->is_valid_number, '北海道十勝郡浦幌町ヌタベット');
ok($zip->set_number('0895558')->is_valid_number, '北海道十勝郡浦幌町昆布刈石(30番地)');
ok($zip->set_number('0895600')->is_valid_number, '北海道十勝郡浦幌町以下に掲載がない場合');
ok($zip->set_number('0895601')->is_valid_number, '北海道十勝郡浦幌町宝町');
ok($zip->set_number('0895602')->is_valid_number, '北海道十勝郡浦幌町末広町');
ok($zip->set_number('0895603')->is_valid_number, '北海道十勝郡浦幌町本町');
ok($zip->set_number('0895604')->is_valid_number, '北海道十勝郡浦幌町栄町');
ok($zip->set_number('0895605')->is_valid_number, '北海道十勝郡浦幌町緑町');
ok($zip->set_number('0895606')->is_valid_number, '北海道十勝郡浦幌町住吉町');
ok($zip->set_number('0895607')->is_valid_number, '北海道十勝郡浦幌町材木町');
ok($zip->set_number('0895608')->is_valid_number, '北海道十勝郡浦幌町西町');
ok($zip->set_number('0895611')->is_valid_number, '北海道十勝郡浦幌町寿町');
ok($zip->set_number('0895612')->is_valid_number, '北海道十勝郡浦幌町東山町');
ok($zip->set_number('0895613')->is_valid_number, '北海道十勝郡浦幌町幸町');
ok($zip->set_number('0895614')->is_valid_number, '北海道十勝郡浦幌町桜町');
ok($zip->set_number('0895615')->is_valid_number, '北海道十勝郡浦幌町新町');
ok($zip->set_number('0895617')->is_valid_number, '北海道十勝郡浦幌町光南');
ok($zip->set_number('0895617')->is_valid_number, '北海道十勝郡浦幌町南町');
ok($zip->set_number('0895621')->is_valid_number, '北海道十勝郡浦幌町北町');
ok($zip->set_number('0895622')->is_valid_number, '北海道十勝郡浦幌町北栄');
ok($zip->set_number('0895631')->is_valid_number, '北海道十勝郡浦幌町瀬多来');
ok($zip->set_number('0895632')->is_valid_number, '北海道十勝郡浦幌町留真');
ok($zip->set_number('0895633')->is_valid_number, '北海道十勝郡浦幌町常豊');
ok($zip->set_number('0895633')->is_valid_number, '北海道十勝郡浦幌町常室');
ok($zip->set_number('0895633')->is_valid_number, '北海道十勝郡浦幌町福山');
ok($zip->set_number('0895633')->is_valid_number, '北海道十勝郡浦幌町円山');
ok($zip->set_number('0895634')->is_valid_number, '北海道十勝郡浦幌町帯富');
ok($zip->set_number('0895634')->is_valid_number, '北海道十勝郡浦幌町時和');
ok($zip->set_number('0895635')->is_valid_number, '北海道十勝郡浦幌町静内');
ok($zip->set_number('0895636')->is_valid_number, '北海道十勝郡浦幌町千歳町');
ok($zip->set_number('0895636')->is_valid_number, '北海道十勝郡浦幌町万年');
ok($zip->set_number('0895637')->is_valid_number, '北海道十勝郡浦幌町稲穂');
ok($zip->set_number('0895638')->is_valid_number, '北海道十勝郡浦幌町幾栄');
ok($zip->set_number('0895638')->is_valid_number, '北海道十勝郡浦幌町幾千世');
ok($zip->set_number('0895865')->is_valid_number, '北海道十勝郡浦幌町厚内(全域)');
ok($zip->set_number('0895866')->is_valid_number, '北海道十勝郡浦幌町上厚内');
ok($zip->set_number('0895867')->is_valid_number, '北海道十勝郡浦幌町オコッペ');
ok($zip->set_number('0895868')->is_valid_number, '北海道十勝郡浦幌町昆布刈石(3番地)');
ok($zip->set_number('0895869')->is_valid_number, '北海道十勝郡浦幌町チプネオコッペ');
ok($zip->set_number('0900000')->is_valid_number, '北海道北見市以下に掲載がない場合');
ok($zip->set_number('0900001')->is_valid_number, '北海道北見市小泉');
ok($zip->set_number('0900002')->is_valid_number, '北海道北見市昭和');
ok($zip->set_number('0900003')->is_valid_number, '北海道北見市仁頃町');
ok($zip->set_number('0900004')->is_valid_number, '北海道北見市北陽');
ok($zip->set_number('0900005')->is_valid_number, '北海道北見市大和');
ok($zip->set_number('0900006')->is_valid_number, '北海道北見市上仁頃');
ok($zip->set_number('0900007')->is_valid_number, '北海道北見市美里');
ok($zip->set_number('0900008')->is_valid_number, '北海道北見市大正');
ok($zip->set_number('0900011')->is_valid_number, '北海道北見市曙町');
ok($zip->set_number('0900012')->is_valid_number, '北海道北見市並木町');
ok($zip->set_number('0900013')->is_valid_number, '北海道北見市柏陽町');
ok($zip->set_number('0900014')->is_valid_number, '北海道北見市文京町');
ok($zip->set_number('0900015')->is_valid_number, '北海道北見市公園町');
ok($zip->set_number('0900016')->is_valid_number, '北海道北見市大町');
ok($zip->set_number('0900017')->is_valid_number, '北海道北見市高砂町');
ok($zip->set_number('0900018')->is_valid_number, '北海道北見市青葉町');
ok($zip->set_number('0900019')->is_valid_number, '北海道北見市三楽町');
ok($zip->set_number('0900020')->is_valid_number, '北海道北見市大通東');
ok($zip->set_number('0900021')->is_valid_number, '北海道北見市北一条東');
ok($zip->set_number('0900022')->is_valid_number, '北海道北見市北二条東');
ok($zip->set_number('0900023')->is_valid_number, '北海道北見市北三条東');
ok($zip->set_number('0900024')->is_valid_number, '北海道北見市北四条東');
ok($zip->set_number('0900025')->is_valid_number, '北海道北見市北五条東');
ok($zip->set_number('0900026')->is_valid_number, '北海道北見市北六条東');
ok($zip->set_number('0900027')->is_valid_number, '北海道北見市北七条東');
ok($zip->set_number('0900028')->is_valid_number, '北海道北見市北八条東');
ok($zip->set_number('0900029')->is_valid_number, '北海道北見市北九条東');
ok($zip->set_number('0900030')->is_valid_number, '北海道北見市北十条東');
ok($zip->set_number('0900031')->is_valid_number, '北海道北見市北十一条東');
ok($zip->set_number('0900032')->is_valid_number, '北海道北見市三住町');
ok($zip->set_number('0900033')->is_valid_number, '北海道北見市番場町');
ok($zip->set_number('0900034')->is_valid_number, '北海道北見市中央町');
ok($zip->set_number('0900035')->is_valid_number, '北海道北見市北斗町');
ok($zip->set_number('0900036')->is_valid_number, '北海道北見市幸町');
ok($zip->set_number('0900037')->is_valid_number, '北海道北見市山下町');
ok($zip->set_number('0900040')->is_valid_number, '北海道北見市大通西');
ok($zip->set_number('0900041')->is_valid_number, '北海道北見市北一条西');
ok($zip->set_number('0900042')->is_valid_number, '北海道北見市北二条西');
ok($zip->set_number('0900043')->is_valid_number, '北海道北見市北三条西');
ok($zip->set_number('0900044')->is_valid_number, '北海道北見市北四条西');
ok($zip->set_number('0900045')->is_valid_number, '北海道北見市北五条西');
ok($zip->set_number('0900046')->is_valid_number, '北海道北見市北六条西');
ok($zip->set_number('0900047')->is_valid_number, '北海道北見市北七条西');
ok($zip->set_number('0900048')->is_valid_number, '北海道北見市北八条西');
ok($zip->set_number('0900051')->is_valid_number, '北海道北見市高栄東町');
ok($zip->set_number('0900052')->is_valid_number, '北海道北見市北進町');
ok($zip->set_number('0900053')->is_valid_number, '北海道北見市桂町');
ok($zip->set_number('0900054')->is_valid_number, '北海道北見市双葉町');
ok($zip->set_number('0900055')->is_valid_number, '北海道北見市緑町');
ok($zip->set_number('0900056')->is_valid_number, '北海道北見市卸町');
ok($zip->set_number('0900057')->is_valid_number, '北海道北見市若葉');
ok($zip->set_number('0900058')->is_valid_number, '北海道北見市高栄西町');
ok($zip->set_number('0900061')->is_valid_number, '北海道北見市東陵町');
ok($zip->set_number('0900063')->is_valid_number, '北海道北見市清見町');
ok($zip->set_number('0900064')->is_valid_number, '北海道北見市美芳町');
ok($zip->set_number('0900065')->is_valid_number, '北海道北見市寿町');
ok($zip->set_number('0900066')->is_valid_number, '北海道北見市花月町');
ok($zip->set_number('0900067')->is_valid_number, '北海道北見市緑ケ丘');
ok($zip->set_number('0900068')->is_valid_number, '北海道北見市美山町南');
ok($zip->set_number('0900069')->is_valid_number, '北海道北見市美山町東');
ok($zip->set_number('0900070')->is_valid_number, '北海道北見市美山町西');
ok($zip->set_number('0900801')->is_valid_number, '北海道北見市春光町');
ok($zip->set_number('0900802')->is_valid_number, '北海道北見市田端町');
ok($zip->set_number('0900803')->is_valid_number, '北海道北見市朝日町');
ok($zip->set_number('0900804')->is_valid_number, '北海道北見市桜町');
ok($zip->set_number('0900805')->is_valid_number, '北海道北見市清月町');
ok($zip->set_number('0900806')->is_valid_number, '北海道北見市南町');
ok($zip->set_number('0900807')->is_valid_number, '北海道北見市川東');
ok($zip->set_number('0900808')->is_valid_number, '北海道北見市若松');
ok($zip->set_number('0900810')->is_valid_number, '北海道北見市ひかり野');
ok($zip->set_number('0900811')->is_valid_number, '北海道北見市泉町');
ok($zip->set_number('0900812')->is_valid_number, '北海道北見市南仲町');
ok($zip->set_number('0900813')->is_valid_number, '北海道北見市中ノ島町');
ok($zip->set_number('0900814')->is_valid_number, '北海道北見市光葉町');
ok($zip->set_number('0900815')->is_valid_number, '北海道北見市新生町');
ok($zip->set_number('0900816')->is_valid_number, '北海道北見市花園町');
ok($zip->set_number('0900817')->is_valid_number, '北海道北見市常盤町');
ok($zip->set_number('0900818')->is_valid_number, '北海道北見市本町');
ok($zip->set_number('0900821')->is_valid_number, '北海道北見市川沿町');
ok($zip->set_number('0900822')->is_valid_number, '北海道北見市北央町');
ok($zip->set_number('0900823')->is_valid_number, '北海道北見市広明町');
ok($zip->set_number('0900824')->is_valid_number, '北海道北見市北光');
ok($zip->set_number('0900825')->is_valid_number, '北海道北見市無加川町');
ok($zip->set_number('0900826')->is_valid_number, '北海道北見市末広町');
ok($zip->set_number('0900827')->is_valid_number, '北海道北見市錦町');
ok($zip->set_number('0900831')->is_valid_number, '北海道北見市西富町');
ok($zip->set_number('0900832')->is_valid_number, '北海道北見市栄町');
ok($zip->set_number('0900833')->is_valid_number, '北海道北見市とん田東町');
ok($zip->set_number('0900834')->is_valid_number, '北海道北見市とん田西町');
ok($zip->set_number('0900835')->is_valid_number, '北海道北見市光西町');
ok($zip->set_number('0900836')->is_valid_number, '北海道北見市東三輪');
ok($zip->set_number('0900837')->is_valid_number, '北海道北見市中央三輪');
ok($zip->set_number('0900838')->is_valid_number, '北海道北見市西三輪');
ok($zip->set_number('0910001')->is_valid_number, '北海道北見市留辺蘂町元町');
ok($zip->set_number('0910002')->is_valid_number, '北海道北見市留辺蘂町東町');
ok($zip->set_number('0910003')->is_valid_number, '北海道北見市留辺蘂町仲町');
ok($zip->set_number('0910004')->is_valid_number, '北海道北見市留辺蘂町上町');
ok($zip->set_number('0910007')->is_valid_number, '北海道北見市留辺蘂町富岡');
ok($zip->set_number('0910008')->is_valid_number, '北海道北見市留辺蘂町宮下町');
ok($zip->set_number('0910011')->is_valid_number, '北海道北見市留辺蘂町泉');
ok($zip->set_number('0910016')->is_valid_number, '北海道北見市留辺蘂町丸山');
ok($zip->set_number('0910017')->is_valid_number, '北海道北見市留辺蘂町瑞穂');
ok($zip->set_number('0910018')->is_valid_number, '北海道北見市留辺蘂町花園');
ok($zip->set_number('0910021')->is_valid_number, '北海道北見市留辺蘂町金華');
ok($zip->set_number('0910022')->is_valid_number, '北海道北見市留辺蘂町旭東');
ok($zip->set_number('0910023')->is_valid_number, '北海道北見市留辺蘂町旭中央');
ok($zip->set_number('0910024')->is_valid_number, '北海道北見市留辺蘂町旭南');
ok($zip->set_number('0910025')->is_valid_number, '北海道北見市留辺蘂町旭北');
ok($zip->set_number('0910026')->is_valid_number, '北海道北見市留辺蘂町旭公園');
ok($zip->set_number('0910027')->is_valid_number, '北海道北見市留辺蘂町旭西');
ok($zip->set_number('0910028')->is_valid_number, '北海道北見市留辺蘂町旭3区');
ok($zip->set_number('0910029')->is_valid_number, '北海道北見市留辺蘂町旭1区');
ok($zip->set_number('0910031')->is_valid_number, '北海道北見市留辺蘂町大富');
ok($zip->set_number('0910032')->is_valid_number, '北海道北見市留辺蘂町豊金');
ok($zip->set_number('0910033')->is_valid_number, '北海道北見市留辺蘂町栄町');
ok($zip->set_number('0910151')->is_valid_number, '北海道北見市留辺蘂町昭栄');
ok($zip->set_number('0910153')->is_valid_number, '北海道北見市留辺蘂町松山');
ok($zip->set_number('0910154')->is_valid_number, '北海道北見市留辺蘂町平里');
ok($zip->set_number('0910155')->is_valid_number, '北海道北見市留辺蘂町大和');
ok($zip->set_number('0910156')->is_valid_number, '北海道北見市留辺蘂町川北');
ok($zip->set_number('0910157')->is_valid_number, '北海道北見市留辺蘂町花丘');
ok($zip->set_number('0910161')->is_valid_number, '北海道北見市留辺蘂町厚和');
ok($zip->set_number('0910162')->is_valid_number, '北海道北見市留辺蘂町富士見');
ok($zip->set_number('0910163')->is_valid_number, '北海道北見市留辺蘂町滝の湯');
ok($zip->set_number('0910170')->is_valid_number, '北海道北見市留辺蘂町温根湯温泉');
ok($zip->set_number('0910471')->is_valid_number, '北海道常呂郡佐呂間町大成');
ok($zip->set_number('0910472')->is_valid_number, '北海道常呂郡佐呂間町栄');
ok($zip->set_number('0910473')->is_valid_number, '北海道常呂郡佐呂間町共立');
ok($zip->set_number('0910551')->is_valid_number, '北海道常呂郡佐呂間町若佐');
ok($zip->set_number('0910552')->is_valid_number, '北海道常呂郡佐呂間町富丘');
ok($zip->set_number('0910553')->is_valid_number, '北海道常呂郡佐呂間町朝日');
ok($zip->set_number('0910554')->is_valid_number, '北海道常呂郡佐呂間町武士');
ok($zip->set_number('0910555')->is_valid_number, '北海道常呂郡佐呂間町中園');
ok($zip->set_number('0910556')->is_valid_number, '北海道常呂郡佐呂間町啓生');
ok($zip->set_number('0910557')->is_valid_number, '北海道常呂郡佐呂間町川西');
ok($zip->set_number('0910558')->is_valid_number, '北海道常呂郡佐呂間町栃木');
ok($zip->set_number('0920000')->is_valid_number, '北海道網走郡美幌町以下に掲載がない場合');
ok($zip->set_number('0920001')->is_valid_number, '北海道網走郡美幌町高野');
ok($zip->set_number('0920002')->is_valid_number, '北海道網走郡美幌町美禽');
ok($zip->set_number('0920003')->is_valid_number, '北海道網走郡美幌町鳥里');
ok($zip->set_number('0920004')->is_valid_number, '北海道網走郡美幌町仲町');
ok($zip->set_number('0920005')->is_valid_number, '北海道網走郡美幌町野崎(その他)');
ok($zip->set_number('0920006')->is_valid_number, '北海道網走郡美幌町昭野');
ok($zip->set_number('0920007')->is_valid_number, '北海道網走郡美幌町豊岡');
ok($zip->set_number('0920011')->is_valid_number, '北海道網走郡美幌町東町');
ok($zip->set_number('0920012')->is_valid_number, '北海道網走郡美幌町栄町');
ok($zip->set_number('0920013')->is_valid_number, '北海道網走郡美幌町美芳');
ok($zip->set_number('0920014')->is_valid_number, '北海道網走郡美幌町美里');
ok($zip->set_number('0920015')->is_valid_number, '北海道網走郡美幌町新町');
ok($zip->set_number('0920016')->is_valid_number, '北海道網走郡美幌町瑞治');
ok($zip->set_number('0920017')->is_valid_number, '北海道網走郡美幌町報徳');
ok($zip->set_number('0920018')->is_valid_number, '北海道網走郡美幌町田中');
ok($zip->set_number('0920021')->is_valid_number, '北海道網走郡美幌町日並');
ok($zip->set_number('0920022')->is_valid_number, '北海道網走郡美幌町古梅');
ok($zip->set_number('0920023')->is_valid_number, '北海道網走郡美幌町豊富');
ok($zip->set_number('0920024')->is_valid_number, '北海道網走郡美幌町福住');
ok($zip->set_number('0920025')->is_valid_number, '北海道網走郡美幌町駒生(その他)');
ok($zip->set_number('0920026')->is_valid_number, '北海道網走郡美幌町都橋');
ok($zip->set_number('0920027')->is_valid_number, '北海道網走郡美幌町稲美');
ok($zip->set_number('0920030')->is_valid_number, '北海道網走郡美幌町美富(その他)');
ok($zip->set_number('0920031')->is_valid_number, '北海道網走郡美幌町大通南');
ok($zip->set_number('0920032')->is_valid_number, '北海道網走郡美幌町西一条南');
ok($zip->set_number('0920033')->is_valid_number, '北海道網走郡美幌町西二条南');
ok($zip->set_number('0920041')->is_valid_number, '北海道網走郡美幌町東一条南');
ok($zip->set_number('0920042')->is_valid_number, '北海道網走郡美幌町東二条南');
ok($zip->set_number('0920043')->is_valid_number, '北海道網走郡美幌町東三条南');
ok($zip->set_number('0920044')->is_valid_number, '北海道網走郡美幌町東四条南');
ok($zip->set_number('0920050')->is_valid_number, '北海道網走郡美幌町大通北');
ok($zip->set_number('0920051')->is_valid_number, '北海道網走郡美幌町東一条北');
ok($zip->set_number('0920052')->is_valid_number, '北海道網走郡美幌町東二条北');
ok($zip->set_number('0920053')->is_valid_number, '北海道網走郡美幌町東三条北');
ok($zip->set_number('0920061')->is_valid_number, '北海道網走郡美幌町西一条北');
ok($zip->set_number('0920062')->is_valid_number, '北海道網走郡美幌町西二条北');
ok($zip->set_number('0920063')->is_valid_number, '北海道網走郡美幌町元町');
ok($zip->set_number('0920064')->is_valid_number, '北海道網走郡美幌町青葉');
ok($zip->set_number('0920065')->is_valid_number, '北海道網走郡美幌町青山南');
ok($zip->set_number('0920066')->is_valid_number, '北海道網走郡美幌町青山北');
ok($zip->set_number('0920067')->is_valid_number, '北海道網走郡美幌町三橋南');
ok($zip->set_number('0920068')->is_valid_number, '北海道網走郡美幌町三橋町');
ok($zip->set_number('0920069')->is_valid_number, '北海道網走郡美幌町日の出');
ok($zip->set_number('0920171')->is_valid_number, '北海道網走郡美幌町美富(127~151、183~579番地)');
ok($zip->set_number('0920173')->is_valid_number, '北海道網走郡美幌町美和');
ok($zip->set_number('0920174')->is_valid_number, '北海道網走郡美幌町栄森');
ok($zip->set_number('0920175')->is_valid_number, '北海道網走郡美幌町駒生(268番地)');
ok($zip->set_number('0920176')->is_valid_number, '北海道網走郡美幌町野崎(103、122番地)');
ok($zip->set_number('0920181')->is_valid_number, '北海道網走郡美幌町上町');
ok($zip->set_number('0920183')->is_valid_number, '北海道網走郡美幌町豊幌');
ok($zip->set_number('0920184')->is_valid_number, '北海道網走郡美幌町登栄');
ok($zip->set_number('0920200')->is_valid_number, '北海道網走郡津別町以下に掲載がない場合');
ok($zip->set_number('0920201')->is_valid_number, '北海道網走郡津別町最上');
ok($zip->set_number('0920203')->is_valid_number, '北海道網走郡津別町達美');
ok($zip->set_number('0920205')->is_valid_number, '北海道網走郡津別町岩富');
ok($zip->set_number('0920206')->is_valid_number, '北海道網走郡津別町活汲');
ok($zip->set_number('0920207')->is_valid_number, '北海道網走郡津別町東岡');
ok($zip->set_number('0920211')->is_valid_number, '北海道網走郡津別町西三条');
ok($zip->set_number('0920212')->is_valid_number, '北海道網走郡津別町緑町');
ok($zip->set_number('0920213')->is_valid_number, '北海道網走郡津別町西四条');
ok($zip->set_number('0920214')->is_valid_number, '北海道網走郡津別町西二条');
ok($zip->set_number('0920215')->is_valid_number, '北海道網走郡津別町一条通');
ok($zip->set_number('0920216')->is_valid_number, '北海道網走郡津別町東二条');
ok($zip->set_number('0920217')->is_valid_number, '北海道網走郡津別町東三条');
ok($zip->set_number('0920218')->is_valid_number, '北海道網走郡津別町東四条');
ok($zip->set_number('0920221')->is_valid_number, '北海道網走郡津別町高台');
ok($zip->set_number('0920222')->is_valid_number, '北海道網走郡津別町上里');
ok($zip->set_number('0920223')->is_valid_number, '北海道網走郡津別町美都');
ok($zip->set_number('0920224')->is_valid_number, '北海道網走郡津別町豊永');
ok($zip->set_number('0920225')->is_valid_number, '北海道網走郡津別町共和');
ok($zip->set_number('0920231')->is_valid_number, '北海道網走郡津別町大通');
ok($zip->set_number('0920232')->is_valid_number, '北海道網走郡津別町新町');
ok($zip->set_number('0920233')->is_valid_number, '北海道網走郡津別町柏町');
ok($zip->set_number('0920234')->is_valid_number, '北海道網走郡津別町旭町');
ok($zip->set_number('0920235')->is_valid_number, '北海道網走郡津別町幸町');
ok($zip->set_number('0920236')->is_valid_number, '北海道網走郡津別町本町');
ok($zip->set_number('0920351')->is_valid_number, '北海道網走郡津別町本岐');
ok($zip->set_number('0920352')->is_valid_number, '北海道網走郡津別町木樋');
ok($zip->set_number('0920353')->is_valid_number, '北海道網走郡津別町二又');
ok($zip->set_number('0920354')->is_valid_number, '北海道網走郡津別町双葉');
ok($zip->set_number('0920355')->is_valid_number, '北海道網走郡津別町恩根');
ok($zip->set_number('0920356')->is_valid_number, '北海道網走郡津別町栄');
ok($zip->set_number('0920357')->is_valid_number, '北海道網走郡津別町大昭');
ok($zip->set_number('0920358')->is_valid_number, '北海道網走郡津別町沼沢');
ok($zip->set_number('0920361')->is_valid_number, '北海道網走郡津別町相生');
ok($zip->set_number('0920362')->is_valid_number, '北海道網走郡津別町布川');
ok($zip->set_number('0930000')->is_valid_number, '北海道網走市以下に掲載がない場合');
ok($zip->set_number('0930001')->is_valid_number, '北海道網走市南一条東');
ok($zip->set_number('0930002')->is_valid_number, '北海道網走市南二条東');
ok($zip->set_number('0930003')->is_valid_number, '北海道網走市南三条東');
ok($zip->set_number('0930004')->is_valid_number, '北海道網走市南四条東');
ok($zip->set_number('0930005')->is_valid_number, '北海道網走市南五条東');
ok($zip->set_number('0930006')->is_valid_number, '北海道網走市南六条東');
ok($zip->set_number('0930007')->is_valid_number, '北海道網走市南七条東');
ok($zip->set_number('0930008')->is_valid_number, '北海道網走市南八条東');
ok($zip->set_number('0930009')->is_valid_number, '北海道網走市南九条東');
ok($zip->set_number('0930010')->is_valid_number, '北海道網走市南十条東');
ok($zip->set_number('0930011')->is_valid_number, '北海道網走市南一条西');
ok($zip->set_number('0930012')->is_valid_number, '北海道網走市南二条西');
ok($zip->set_number('0930013')->is_valid_number, '北海道網走市南三条西');
ok($zip->set_number('0930014')->is_valid_number, '北海道網走市南四条西');
ok($zip->set_number('0930015')->is_valid_number, '北海道網走市南五条西');
ok($zip->set_number('0930016')->is_valid_number, '北海道網走市南六条西');
ok($zip->set_number('0930017')->is_valid_number, '北海道網走市南七条西');
ok($zip->set_number('0930018')->is_valid_number, '北海道網走市南八条西');
ok($zip->set_number('0930019')->is_valid_number, '北海道網走市南九条西');
ok($zip->set_number('0930020')->is_valid_number, '北海道網走市南十条西');
ok($zip->set_number('0930021')->is_valid_number, '北海道網走市南十一条西');
ok($zip->set_number('0930022')->is_valid_number, '北海道網走市南十二条西');
ok($zip->set_number('0930023')->is_valid_number, '北海道網走市南十三条西');
ok($zip->set_number('0930024')->is_valid_number, '北海道網走市南十四条西');
ok($zip->set_number('0930031')->is_valid_number, '北海道網走市台町');
ok($zip->set_number('0930032')->is_valid_number, '北海道網走市港町');
ok($zip->set_number('0930033')->is_valid_number, '北海道網走市駒場北');
ok($zip->set_number('0930034')->is_valid_number, '北海道網走市つくしケ丘');
ok($zip->set_number('0930035')->is_valid_number, '北海道網走市駒場南');
ok($zip->set_number('0930041')->is_valid_number, '北海道網走市桂町');
ok($zip->set_number('0930042')->is_valid_number, '北海道網走市潮見');
ok($zip->set_number('0930043')->is_valid_number, '北海道網走市錦町');
ok($zip->set_number('0930044')->is_valid_number, '北海道網走市天都山');
ok($zip->set_number('0930045')->is_valid_number, '北海道網走市大曲');
ok($zip->set_number('0930046')->is_valid_number, '北海道網走市新町');
ok($zip->set_number('0930051')->is_valid_number, '北海道網走市北一条東');
ok($zip->set_number('0930052')->is_valid_number, '北海道網走市北二条東');
ok($zip->set_number('0930053')->is_valid_number, '北海道網走市北三条東');
ok($zip->set_number('0930054')->is_valid_number, '北海道網走市北四条東');
ok($zip->set_number('0930055')->is_valid_number, '北海道網走市北五条東');
ok($zip->set_number('0930056')->is_valid_number, '北海道網走市北六条東');
ok($zip->set_number('0930057')->is_valid_number, '北海道網走市北七条東');
ok($zip->set_number('0930058')->is_valid_number, '北海道網走市北八条東');
ok($zip->set_number('0930059')->is_valid_number, '北海道網走市北九条東');
ok($zip->set_number('0930060')->is_valid_number, '北海道網走市北十条東');
ok($zip->set_number('0930061')->is_valid_number, '北海道網走市北十一条東');
ok($zip->set_number('0930062')->is_valid_number, '北海道網走市北十二条東');
ok($zip->set_number('0930071')->is_valid_number, '北海道網走市北一条西');
ok($zip->set_number('0930072')->is_valid_number, '北海道網走市北二条西');
ok($zip->set_number('0930073')->is_valid_number, '北海道網走市北三条西');
ok($zip->set_number('0930074')->is_valid_number, '北海道網走市北四条西');
ok($zip->set_number('0930075')->is_valid_number, '北海道網走市北五条西');
ok($zip->set_number('0930076')->is_valid_number, '北海道網走市北六条西');
ok($zip->set_number('0930077')->is_valid_number, '北海道網走市北七条西');
ok($zip->set_number('0930078')->is_valid_number, '北海道網走市北八条西');
ok($zip->set_number('0930079')->is_valid_number, '北海道網走市北九条西');
ok($zip->set_number('0930080')->is_valid_number, '北海道網走市北十条西');
ok($zip->set_number('0930081')->is_valid_number, '北海道網走市北十一条西');
ok($zip->set_number('0930082')->is_valid_number, '北海道網走市北十二条西');
ok($zip->set_number('0930083')->is_valid_number, '北海道網走市海岸町');
ok($zip->set_number('0930084')->is_valid_number, '北海道網走市向陽ケ丘');
ok($zip->set_number('0930085')->is_valid_number, '北海道網走市明治');
ok($zip->set_number('0930086')->is_valid_number, '北海道網走市二ツ岩');
ok($zip->set_number('0930087')->is_valid_number, '北海道網走市美岬');
ok($zip->set_number('0930088')->is_valid_number, '北海道網走市三眺');
ok($zip->set_number('0930089')->is_valid_number, '北海道網走市緑町');
ok($zip->set_number('0930090')->is_valid_number, '北海道網走市文化');
ok($zip->set_number('0930131')->is_valid_number, '北海道網走市能取港町');
ok($zip->set_number('0930132')->is_valid_number, '北海道網走市二見ケ岡');
ok($zip->set_number('0930133')->is_valid_number, '北海道網走市嘉多山');
ok($zip->set_number('0930134')->is_valid_number, '北海道網走市越歳');
ok($zip->set_number('0930135')->is_valid_number, '北海道網走市卯原内');
ok($zip->set_number('0930136')->is_valid_number, '北海道網走市平和');
ok($zip->set_number('0930202')->is_valid_number, '北海道北見市常呂町東浜');
ok($zip->set_number('0930210')->is_valid_number, '北海道北見市常呂町常呂');
ok($zip->set_number('0930213')->is_valid_number, '北海道北見市常呂町土佐');
ok($zip->set_number('0930214')->is_valid_number, '北海道北見市常呂町共立');
ok($zip->set_number('0930215')->is_valid_number, '北海道北見市常呂町岐阜');
ok($zip->set_number('0930216')->is_valid_number, '北海道北見市常呂町栄浦');
ok($zip->set_number('0930241')->is_valid_number, '北海道網走市能取');
ok($zip->set_number('0930331')->is_valid_number, '北海道北見市常呂町豊川');
ok($zip->set_number('0930332')->is_valid_number, '北海道北見市常呂町富丘');
ok($zip->set_number('0930333')->is_valid_number, '北海道北見市常呂町福山');
ok($zip->set_number('0930334')->is_valid_number, '北海道北見市常呂町日吉');
ok($zip->set_number('0930335')->is_valid_number, '北海道北見市常呂町吉野');
ok($zip->set_number('0930336')->is_valid_number, '北海道北見市常呂町登');
ok($zip->set_number('0930421')->is_valid_number, '北海道常呂郡佐呂間町浪速');
ok($zip->set_number('0930422')->is_valid_number, '北海道常呂郡佐呂間町幌岩');
ok($zip->set_number('0930423')->is_valid_number, '北海道常呂郡佐呂間町浜佐呂間');
ok($zip->set_number('0930424')->is_valid_number, '北海道常呂郡佐呂間町仁倉');
ok($zip->set_number('0930500')->is_valid_number, '北海道常呂郡佐呂間町以下に掲載がない場合');
ok($zip->set_number('0930501')->is_valid_number, '北海道常呂郡佐呂間町宮前町');
ok($zip->set_number('0930502')->is_valid_number, '北海道常呂郡佐呂間町永代町');
ok($zip->set_number('0930503')->is_valid_number, '北海道常呂郡佐呂間町幸町');
ok($zip->set_number('0930504')->is_valid_number, '北海道常呂郡佐呂間町西富');
ok($zip->set_number('0930505')->is_valid_number, '北海道常呂郡佐呂間町北');
ok($zip->set_number('0930506')->is_valid_number, '北海道常呂郡佐呂間町富武士');
ok($zip->set_number('0930507')->is_valid_number, '北海道常呂郡佐呂間町東');
ok($zip->set_number('0930508')->is_valid_number, '北海道常呂郡佐呂間町知来');
ok($zip->set_number('0930532')->is_valid_number, '北海道常呂郡佐呂間町若里');
ok($zip->set_number('0930651')->is_valid_number, '北海道紋別郡湧別町計呂地');
ok($zip->set_number('0930652')->is_valid_number, '北海道紋別郡湧別町志撫子');
ok($zip->set_number('0930731')->is_valid_number, '北海道紋別郡湧別町芭露');
ok($zip->set_number('0930732')->is_valid_number, '北海道紋別郡湧別町上芭露');
ok($zip->set_number('0930733')->is_valid_number, '北海道紋別郡湧別町西芭露');
ok($zip->set_number('0930734')->is_valid_number, '北海道紋別郡湧別町東芭露');
ok($zip->set_number('0930735')->is_valid_number, '北海道紋別郡湧別町福島(536番地)');
ok($zip->set_number('0940000')->is_valid_number, '北海道紋別市以下に掲載がない場合');
ok($zip->set_number('0940001')->is_valid_number, '北海道紋別市北浜町');
ok($zip->set_number('0940002')->is_valid_number, '北海道紋別市真砂町');
ok($zip->set_number('0940003')->is_valid_number, '北海道紋別市弁天町');
ok($zip->set_number('0940004')->is_valid_number, '北海道紋別市本町');
ok($zip->set_number('0940005')->is_valid_number, '北海道紋別市幸町');
ok($zip->set_number('0940006')->is_valid_number, '北海道紋別市潮見町');
ok($zip->set_number('0940007')->is_valid_number, '北海道紋別市落石町');
ok($zip->set_number('0940011')->is_valid_number, '北海道紋別市港町');
ok($zip->set_number('0940012')->is_valid_number, '北海道紋別市新港町');
ok($zip->set_number('0940013')->is_valid_number, '北海道紋別市南が丘町');
ok($zip->set_number('0940014')->is_valid_number, '北海道紋別市緑町');
ok($zip->set_number('0940015')->is_valid_number, '北海道紋別市花園町');
ok($zip->set_number('0940021')->is_valid_number, '北海道紋別市大山町');
ok($zip->set_number('0940022')->is_valid_number, '北海道紋別市新生');
ok($zip->set_number('0940023')->is_valid_number, '北海道紋別市元紋別');
ok($zip->set_number('0940024')->is_valid_number, '北海道紋別市藻別');
ok($zip->set_number('0940025')->is_valid_number, '北海道紋別市上藻別');
ok($zip->set_number('0940026')->is_valid_number, '北海道紋別市鴻之舞');
ok($zip->set_number('0940027')->is_valid_number, '北海道紋別市上鴻之舞');
ok($zip->set_number('0940031')->is_valid_number, '北海道紋別市海洋公園');
ok($zip->set_number('0950000')->is_valid_number, '北海道士別市以下に掲載がない場合');
ok($zip->set_number('0950001')->is_valid_number, '北海道士別市東一条北');
ok($zip->set_number('0950002')->is_valid_number, '北海道士別市東二条北');
ok($zip->set_number('0950003')->is_valid_number, '北海道士別市東三条北');
ok($zip->set_number('0950004')->is_valid_number, '北海道士別市東四条北');
ok($zip->set_number('0950005')->is_valid_number, '北海道士別市東五条北');
ok($zip->set_number('0950006')->is_valid_number, '北海道士別市東六条北');
ok($zip->set_number('0950007')->is_valid_number, '北海道士別市東七条北');
ok($zip->set_number('0950008')->is_valid_number, '北海道士別市東八条北');
ok($zip->set_number('0950011')->is_valid_number, '北海道士別市東一条');
ok($zip->set_number('0950012')->is_valid_number, '北海道士別市東二条');
ok($zip->set_number('0950013')->is_valid_number, '北海道士別市東三条');
ok($zip->set_number('0950014')->is_valid_number, '北海道士別市東四条');
ok($zip->set_number('0950015')->is_valid_number, '北海道士別市東五条');
ok($zip->set_number('0950016')->is_valid_number, '北海道士別市東六条');
ok($zip->set_number('0950017')->is_valid_number, '北海道士別市東七条');
ok($zip->set_number('0950018')->is_valid_number, '北海道士別市東八条');
ok($zip->set_number('0950019')->is_valid_number, '北海道士別市大通東');
ok($zip->set_number('0950021')->is_valid_number, '北海道士別市西一条');
ok($zip->set_number('0950022')->is_valid_number, '北海道士別市西二条');
ok($zip->set_number('0950023')->is_valid_number, '北海道士別市西三条');
ok($zip->set_number('0950024')->is_valid_number, '北海道士別市西四条');
ok($zip->set_number('0950025')->is_valid_number, '北海道士別市西五条');
ok($zip->set_number('0950029')->is_valid_number, '北海道士別市大通西');
ok($zip->set_number('0950031')->is_valid_number, '北海道士別市西一条北');
ok($zip->set_number('0950032')->is_valid_number, '北海道士別市西二条北');
ok($zip->set_number('0950033')->is_valid_number, '北海道士別市西三条北');
ok($zip->set_number('0950034')->is_valid_number, '北海道士別市西四条北');
ok($zip->set_number('0950035')->is_valid_number, '北海道士別市西五条北');
ok($zip->set_number('0950039')->is_valid_number, '北海道士別市大通北');
ok($zip->set_number('0950041')->is_valid_number, '北海道士別市東九条');
ok($zip->set_number('0950042')->is_valid_number, '北海道士別市東十条');
ok($zip->set_number('0950043')->is_valid_number, '北海道士別市九十九町');
ok($zip->set_number('0950044')->is_valid_number, '北海道士別市東山町');
ok($zip->set_number('0950045')->is_valid_number, '北海道士別市東丘');
ok($zip->set_number('0950046')->is_valid_number, '北海道士別市南町東');
ok($zip->set_number('0950047')->is_valid_number, '北海道士別市南町西');
ok($zip->set_number('0950048')->is_valid_number, '北海道士別市東十一条');
ok($zip->set_number('0950051')->is_valid_number, '北海道士別市北町');
ok($zip->set_number('0950052')->is_valid_number, '北海道士別市学田');
ok($zip->set_number('0950053')->is_valid_number, '北海道士別市新学田');
ok($zip->set_number('0950054')->is_valid_number, '北海道士別市不動町');
ok($zip->set_number('0950055')->is_valid_number, '北海道士別市南士別町');
ok($zip->set_number('0950056')->is_valid_number, '北海道士別市西士別町');
ok($zip->set_number('0950061')->is_valid_number, '北海道士別市下士別町');
ok($zip->set_number('0950062')->is_valid_number, '北海道士別市武徳町');
ok($zip->set_number('0950063')->is_valid_number, '北海道士別市中士別町');
ok($zip->set_number('0950064')->is_valid_number, '北海道士別市川西町');
ok($zip->set_number('0950181')->is_valid_number, '北海道士別市温根別町');
ok($zip->set_number('0950182')->is_valid_number, '北海道士別市温根別町伊文');
ok($zip->set_number('0950183')->is_valid_number, '北海道士別市温根別町北静川');
ok($zip->set_number('0950371')->is_valid_number, '北海道士別市上士別町');
ok($zip->set_number('0950401')->is_valid_number, '北海道士別市朝日町中央');
ok($zip->set_number('0950402')->is_valid_number, '北海道士別市朝日町登和里');
ok($zip->set_number('0950403')->is_valid_number, '北海道士別市朝日町岩尾内');
ok($zip->set_number('0950404')->is_valid_number, '北海道士別市朝日町茂志利');
ok($zip->set_number('0950405')->is_valid_number, '北海道士別市朝日町三栄');
ok($zip->set_number('0950406')->is_valid_number, '北海道士別市朝日町南朝日');
ok($zip->set_number('0960000')->is_valid_number, '北海道名寄市以下に掲載がない場合');
ok($zip->set_number('0960001')->is_valid_number, '北海道名寄市東一条南');
ok($zip->set_number('0960002')->is_valid_number, '北海道名寄市東二条南');
ok($zip->set_number('0960003')->is_valid_number, '北海道名寄市東三条南');
ok($zip->set_number('0960004')->is_valid_number, '北海道名寄市東四条南');
ok($zip->set_number('0960005')->is_valid_number, '北海道名寄市東五条南');
ok($zip->set_number('0960006')->is_valid_number, '北海道名寄市東六条南');
ok($zip->set_number('0960007')->is_valid_number, '北海道名寄市東七条南');
ok($zip->set_number('0960008')->is_valid_number, '北海道名寄市東八条南');
ok($zip->set_number('0960009')->is_valid_number, '北海道名寄市東九条南');
ok($zip->set_number('0960010')->is_valid_number, '北海道名寄市大通南');
ok($zip->set_number('0960011')->is_valid_number, '北海道名寄市西一条南');
ok($zip->set_number('0960012')->is_valid_number, '北海道名寄市西二条南');
ok($zip->set_number('0960013')->is_valid_number, '北海道名寄市西三条南');
ok($zip->set_number('0960014')->is_valid_number, '北海道名寄市西四条南');
ok($zip->set_number('0960015')->is_valid_number, '北海道名寄市西五条南');
ok($zip->set_number('0960016')->is_valid_number, '北海道名寄市西六条南');
ok($zip->set_number('0960017')->is_valid_number, '北海道名寄市西七条南');
ok($zip->set_number('0960018')->is_valid_number, '北海道名寄市西八条南');
ok($zip->set_number('0960019')->is_valid_number, '北海道名寄市西九条南');
ok($zip->set_number('0960020')->is_valid_number, '北海道名寄市西十条南');
ok($zip->set_number('0960021')->is_valid_number, '北海道名寄市西十一条南');
ok($zip->set_number('0960022')->is_valid_number, '北海道名寄市西十二条南');
ok($zip->set_number('0960023')->is_valid_number, '北海道名寄市西十三条南');
ok($zip->set_number('0960024')->is_valid_number, '北海道名寄市西十四条南');
ok($zip->set_number('0960025')->is_valid_number, '北海道名寄市西十五条南');
ok($zip->set_number('0960030')->is_valid_number, '北海道名寄市大通北');
ok($zip->set_number('0960031')->is_valid_number, '北海道名寄市西一条北');
ok($zip->set_number('0960032')->is_valid_number, '北海道名寄市西二条北');
ok($zip->set_number('0960033')->is_valid_number, '北海道名寄市西三条北');
ok($zip->set_number('0960034')->is_valid_number, '北海道名寄市西四条北');
ok($zip->set_number('0960035')->is_valid_number, '北海道名寄市西五条北');
ok($zip->set_number('0960036')->is_valid_number, '北海道名寄市西六条北');
ok($zip->set_number('0960037')->is_valid_number, '北海道名寄市西七条北');
ok($zip->set_number('0960038')->is_valid_number, '北海道名寄市西八条北');
ok($zip->set_number('0960039')->is_valid_number, '北海道名寄市西九条北');
ok($zip->set_number('0960040')->is_valid_number, '北海道名寄市西十条北');
ok($zip->set_number('0960041')->is_valid_number, '北海道名寄市西十一条北');
ok($zip->set_number('0960042')->is_valid_number, '北海道名寄市西十二条北');
ok($zip->set_number('0960043')->is_valid_number, '北海道名寄市西十三条北');
ok($zip->set_number('0960051')->is_valid_number, '北海道名寄市東一条北');
ok($zip->set_number('0960052')->is_valid_number, '北海道名寄市東二条北');
ok($zip->set_number('0960053')->is_valid_number, '北海道名寄市東三条北');
ok($zip->set_number('0960054')->is_valid_number, '北海道名寄市東四条北');
ok($zip->set_number('0960055')->is_valid_number, '北海道名寄市東五条北');
ok($zip->set_number('0960056')->is_valid_number, '北海道名寄市東六条北');
ok($zip->set_number('0960061')->is_valid_number, '北海道名寄市朝日');
ok($zip->set_number('0960062')->is_valid_number, '北海道名寄市日彰');
ok($zip->set_number('0960063')->is_valid_number, '北海道名寄市緑丘');
ok($zip->set_number('0960064')->is_valid_number, '北海道名寄市旭東');
ok($zip->set_number('0960065')->is_valid_number, '北海道名寄市大橋');
ok($zip->set_number('0960066')->is_valid_number, '北海道名寄市日進');
ok($zip->set_number('0960071')->is_valid_number, '北海道名寄市徳田');
ok($zip->set_number('0960072')->is_valid_number, '北海道名寄市豊栄');
ok($zip->set_number('0960073')->is_valid_number, '北海道名寄市共和');
ok($zip->set_number('0960074')->is_valid_number, '北海道名寄市弥生');
ok($zip->set_number('0960075')->is_valid_number, '北海道名寄市曙');
ok($zip->set_number('0960076')->is_valid_number, '北海道名寄市砺波');
ok($zip->set_number('0960077')->is_valid_number, '北海道名寄市瑞穂');
ok($zip->set_number('0960078')->is_valid_number, '北海道名寄市内淵');
ok($zip->set_number('0970000')->is_valid_number, '北海道稚内市以下に掲載がない場合');
ok($zip->set_number('0970001')->is_valid_number, '北海道稚内市末広');
ok($zip->set_number('0970002')->is_valid_number, '北海道稚内市潮見');
ok($zip->set_number('0970003')->is_valid_number, '北海道稚内市こまどり');
ok($zip->set_number('0970004')->is_valid_number, '北海道稚内市緑');
ok($zip->set_number('0970005')->is_valid_number, '北海道稚内市大黒');
ok($zip->set_number('0970006')->is_valid_number, '北海道稚内市新港町');
ok($zip->set_number('0970007')->is_valid_number, '北海道稚内市新末広');
ok($zip->set_number('0970011')->is_valid_number, '北海道稚内市はまなす');
ok($zip->set_number('0970012')->is_valid_number, '北海道稚内市富岡');
ok($zip->set_number('0970013')->is_valid_number, '北海道稚内市若葉台');
ok($zip->set_number('0970014')->is_valid_number, '北海道稚内市新光町');
ok($zip->set_number('0970015')->is_valid_number, '北海道稚内市朝日');
ok($zip->set_number('0970016')->is_valid_number, '北海道稚内市萩見');
ok($zip->set_number('0970017')->is_valid_number, '北海道稚内市栄');
ok($zip->set_number('0970021')->is_valid_number, '北海道稚内市港');
ok($zip->set_number('0970022')->is_valid_number, '北海道稚内市中央');
ok($zip->set_number('0970023')->is_valid_number, '北海道稚内市開運');
ok($zip->set_number('0970024')->is_valid_number, '北海道稚内市宝来');
ok($zip->set_number('0970025')->is_valid_number, '北海道稚内市恵比須');
ok($zip->set_number('0970026')->is_valid_number, '北海道稚内市ノシャップ');
ok($zip->set_number('0970027')->is_valid_number, '北海道稚内市富士見');
ok($zip->set_number('0970035')->is_valid_number, '北海道稚内市抜海村(バッカイ)');
ok($zip->set_number('0970036')->is_valid_number, '北海道稚内市抜海村(クトネベツ)');
ok($zip->set_number('0970037')->is_valid_number, '北海道稚内市西浜');
ok($zip->set_number('0970100')->is_valid_number, '北海道利尻郡利尻富士町以下に掲載がない場合');
ok($zip->set_number('0970101')->is_valid_number, '北海道利尻郡利尻富士町鴛泊');
ok($zip->set_number('0970211')->is_valid_number, '北海道利尻郡利尻富士町鬼脇');
ok($zip->set_number('0970311')->is_valid_number, '北海道利尻郡利尻町仙法志');
ok($zip->set_number('0970400')->is_valid_number, '北海道利尻郡利尻町以下に掲載がない場合');
ok($zip->set_number('0970401')->is_valid_number, '北海道利尻郡利尻町沓形');
ok($zip->set_number('0971111')->is_valid_number, '北海道礼文郡礼文町船泊村(その他)');
ok($zip->set_number('0971200')->is_valid_number, '北海道礼文郡礼文町以下に掲載がない場合');
ok($zip->set_number('0971201')->is_valid_number, '北海道礼文郡礼文町香深村');
ok($zip->set_number('0971202')->is_valid_number, '北海道礼文郡礼文町船泊村(ウヱンナイ)');
ok($zip->set_number('0980100')->is_valid_number, '北海道上川郡和寒町以下に掲載がない場合');
ok($zip->set_number('0980101')->is_valid_number, '北海道上川郡和寒町日ノ出');
ok($zip->set_number('0980102')->is_valid_number, '北海道上川郡和寒町大成');
ok($zip->set_number('0980103')->is_valid_number, '北海道上川郡和寒町北原');
ok($zip->set_number('0980104')->is_valid_number, '北海道上川郡和寒町松岡');
ok($zip->set_number('0980111')->is_valid_number, '北海道上川郡和寒町三笠');
ok($zip->set_number('0980112')->is_valid_number, '北海道上川郡和寒町三和');
ok($zip->set_number('0980113')->is_valid_number, '北海道上川郡和寒町菊野');
ok($zip->set_number('0980114')->is_valid_number, '北海道上川郡和寒町西和');
ok($zip->set_number('0980115')->is_valid_number, '北海道上川郡和寒町福原');
ok($zip->set_number('0980121')->is_valid_number, '北海道上川郡和寒町川西');
ok($zip->set_number('0980122')->is_valid_number, '北海道上川郡和寒町中和');
ok($zip->set_number('0980123')->is_valid_number, '北海道上川郡和寒町東丘');
ok($zip->set_number('0980124')->is_valid_number, '北海道上川郡和寒町南丘');
ok($zip->set_number('0980125')->is_valid_number, '北海道上川郡和寒町塩狩');
ok($zip->set_number('0980126')->is_valid_number, '北海道上川郡和寒町朝日');
ok($zip->set_number('0980131')->is_valid_number, '北海道上川郡和寒町南町');
ok($zip->set_number('0980132')->is_valid_number, '北海道上川郡和寒町西町');
ok($zip->set_number('0980133')->is_valid_number, '北海道上川郡和寒町北町');
ok($zip->set_number('0980134')->is_valid_number, '北海道上川郡和寒町東町');
ok($zip->set_number('0980135')->is_valid_number, '北海道上川郡和寒町東和');
ok($zip->set_number('0980300')->is_valid_number, '北海道上川郡剣淵町以下に掲載がない場合');
ok($zip->set_number('0980331')->is_valid_number, '北海道上川郡剣淵町西町');
ok($zip->set_number('0980332')->is_valid_number, '北海道上川郡剣淵町緑町');
ok($zip->set_number('0980333')->is_valid_number, '北海道上川郡剣淵町元町');
ok($zip->set_number('0980334')->is_valid_number, '北海道上川郡剣淵町屯田町');
ok($zip->set_number('0980335')->is_valid_number, '北海道上川郡剣淵町南桜町');
ok($zip->set_number('0980336')->is_valid_number, '北海道上川郡剣淵町旭町');
ok($zip->set_number('0980337')->is_valid_number, '北海道上川郡剣淵町西岡町');
ok($zip->set_number('0980338')->is_valid_number, '北海道上川郡剣淵町仲町');
ok($zip->set_number('0980339')->is_valid_number, '北海道上川郡剣淵町西原町');
ok($zip->set_number('0980341')->is_valid_number, '北海道上川郡剣淵町東町');
ok($zip->set_number('0980342')->is_valid_number, '北海道上川郡剣淵町藤本町');
ok($zip->set_number('0980475')->is_valid_number, '北海道士別市多寄町');
ok($zip->set_number('0980501')->is_valid_number, '北海道名寄市風連町豊里');
ok($zip->set_number('0980502')->is_valid_number, '北海道名寄市風連町北栄町');
ok($zip->set_number('0980503')->is_valid_number, '北海道名寄市風連町大町');
ok($zip->set_number('0980504')->is_valid_number, '北海道名寄市風連町本町');
ok($zip->set_number('0980505')->is_valid_number, '北海道名寄市風連町南町');
ok($zip->set_number('0980506')->is_valid_number, '北海道名寄市風連町仲町');
ok($zip->set_number('0980507')->is_valid_number, '北海道名寄市風連町西町');
ok($zip->set_number('0980508')->is_valid_number, '北海道名寄市風連町瑞生');
ok($zip->set_number('0980509')->is_valid_number, '北海道名寄市風連町西風連');
ok($zip->set_number('0980511')->is_valid_number, '北海道名寄市風連町新生町');
ok($zip->set_number('0980512')->is_valid_number, '北海道名寄市風連町東風連');
ok($zip->set_number('0980513')->is_valid_number, '北海道名寄市風連町池の上');
ok($zip->set_number('0980514')->is_valid_number, '北海道名寄市風連町旭');
ok($zip->set_number('0980515')->is_valid_number, '北海道名寄市風連町中央');
ok($zip->set_number('0980516')->is_valid_number, '北海道名寄市風連町緑町');
ok($zip->set_number('0980631')->is_valid_number, '北海道名寄市風連町日進');
ok($zip->set_number('0980632')->is_valid_number, '北海道名寄市風連町東生');
ok($zip->set_number('0981200')->is_valid_number, '北海道上川郡下川町以下に掲載がない場合');
ok($zip->set_number('0981201')->is_valid_number, '北海道上川郡下川町旭町');
ok($zip->set_number('0981202')->is_valid_number, '北海道上川郡下川町緑町');
ok($zip->set_number('0981203')->is_valid_number, '北海道上川郡下川町共栄町');
ok($zip->set_number('0981204')->is_valid_number, '北海道上川郡下川町南町');
ok($zip->set_number('0981205')->is_valid_number, '北海道上川郡下川町西町');
ok($zip->set_number('0981206')->is_valid_number, '北海道上川郡下川町幸町');
ok($zip->set_number('0981207')->is_valid_number, '北海道上川郡下川町錦町');
ok($zip->set_number('0981211')->is_valid_number, '北海道上川郡下川町珊瑠');
ok($zip->set_number('0981212')->is_valid_number, '北海道上川郡下川町北町');
ok($zip->set_number('0981213')->is_valid_number, '北海道上川郡下川町三の橋');
ok($zip->set_number('0981214')->is_valid_number, '北海道上川郡下川町渓和');
ok($zip->set_number('0981215')->is_valid_number, '北海道上川郡下川町班渓');
ok($zip->set_number('0981216')->is_valid_number, '北海道上川郡下川町上名寄');
ok($zip->set_number('0981331')->is_valid_number, '北海道上川郡下川町一の橋');
ok($zip->set_number('0981332')->is_valid_number, '北海道上川郡下川町二の橋');
ok($zip->set_number('0981421')->is_valid_number, '北海道紋別郡西興部村上興部');
ok($zip->set_number('0981422')->is_valid_number, '北海道紋別郡西興部村東興');
ok($zip->set_number('0981423')->is_valid_number, '北海道紋別郡西興部村札滑');
ok($zip->set_number('0981424')->is_valid_number, '北海道紋別郡西興部村奥興部');
ok($zip->set_number('0981500')->is_valid_number, '北海道紋別郡西興部村以下に掲載がない場合');
ok($zip->set_number('0981501')->is_valid_number, '北海道紋別郡西興部村西興部');
ok($zip->set_number('0981502')->is_valid_number, '北海道紋別郡西興部村六興');
ok($zip->set_number('0981503')->is_valid_number, '北海道紋別郡西興部村中興部');
ok($zip->set_number('0981504')->is_valid_number, '北海道紋別郡西興部村忍路子');
ok($zip->set_number('0981505')->is_valid_number, '北海道紋別郡西興部村上藻');
ok($zip->set_number('0981506')->is_valid_number, '北海道紋別郡西興部村中藻');
ok($zip->set_number('0981600')->is_valid_number, '北海道紋別郡興部町以下に掲載がない場合');
ok($zip->set_number('0981601')->is_valid_number, '北海道紋別郡興部町興部(元町)');
ok($zip->set_number('0981602')->is_valid_number, '北海道紋別郡興部町興部(浜町)');
ok($zip->set_number('0981603')->is_valid_number, '北海道紋別郡興部町興部(東町)');
ok($zip->set_number('0981604')->is_valid_number, '北海道紋別郡興部町興部(春日町)');
ok($zip->set_number('0981605')->is_valid_number, '北海道紋別郡興部町興部(緑ケ丘)');
ok($zip->set_number('0981606')->is_valid_number, '北海道紋別郡興部町興部(栄町)');
ok($zip->set_number('0981607')->is_valid_number, '北海道紋別郡興部町興部(旭町)');
ok($zip->set_number('0981611')->is_valid_number, '北海道紋別郡興部町興部(泉町)');
ok($zip->set_number('0981612')->is_valid_number, '北海道紋別郡興部町興部(新泉町)');
ok($zip->set_number('0981613')->is_valid_number, '北海道紋別郡興部町興部(新町)');
ok($zip->set_number('0981614')->is_valid_number, '北海道紋別郡興部町興部(幸町)');
ok($zip->set_number('0981615')->is_valid_number, '北海道紋別郡興部町興部(仲町)');
ok($zip->set_number('0981616')->is_valid_number, '北海道紋別郡興部町興部(本町)');
ok($zip->set_number('0981621')->is_valid_number, '北海道紋別郡興部町秋里');
ok($zip->set_number('0981622')->is_valid_number, '北海道紋別郡興部町北興');
ok($zip->set_number('0981623')->is_valid_number, '北海道紋別郡興部町興部(宮下町)');
ok($zip->set_number('0981624')->is_valid_number, '北海道紋別郡興部町宇津');
ok($zip->set_number('0981700')->is_valid_number, '北海道紋別郡雄武町以下に掲載がない場合');
ok($zip->set_number('0981701')->is_valid_number, '北海道紋別郡雄武町北雄武');
ok($zip->set_number('0981702')->is_valid_number, '北海道紋別郡雄武町雄武');
ok($zip->set_number('0981703')->is_valid_number, '北海道紋別郡雄武町沢木');
ok($zip->set_number('0981704')->is_valid_number, '北海道紋別郡雄武町上沢木');
ok($zip->set_number('0981705')->is_valid_number, '北海道紋別郡雄武町南雄武');
ok($zip->set_number('0981706')->is_valid_number, '北海道紋別郡雄武町中雄武');
ok($zip->set_number('0981707')->is_valid_number, '北海道紋別郡雄武町上雄武');
ok($zip->set_number('0981708')->is_valid_number, '北海道紋別郡雄武町上幌内');
ok($zip->set_number('0981821')->is_valid_number, '北海道紋別郡雄武町北幌内');
ok($zip->set_number('0981821')->is_valid_number, '北海道紋別郡雄武町中幌内');
ok($zip->set_number('0981821')->is_valid_number, '北海道紋別郡雄武町幌内');
ok($zip->set_number('0981941')->is_valid_number, '北海道紋別郡興部町沙留');
ok($zip->set_number('0981942')->is_valid_number, '北海道紋別郡興部町富丘');
ok($zip->set_number('0981943')->is_valid_number, '北海道紋別郡興部町住吉');
ok($zip->set_number('0981944')->is_valid_number, '北海道紋別郡興部町豊野');
ok($zip->set_number('0982181')->is_valid_number, '北海道名寄市智恵文');
ok($zip->set_number('0982200')->is_valid_number, '北海道中川郡美深町以下に掲載がない場合');
ok($zip->set_number('0982201')->is_valid_number, '北海道中川郡美深町泉');
ok($zip->set_number('0982202')->is_valid_number, '北海道中川郡美深町玉川');
ok($zip->set_number('0982203')->is_valid_number, '北海道中川郡美深町六郷');
ok($zip->set_number('0982204')->is_valid_number, '北海道中川郡美深町川西');
ok($zip->set_number('0982205')->is_valid_number, '北海道中川郡美深町美深');
ok($zip->set_number('0982206')->is_valid_number, '北海道中川郡美深町菊丘');
ok($zip->set_number('0982207')->is_valid_number, '北海道中川郡美深町辺渓');
ok($zip->set_number('0982208')->is_valid_number, '北海道中川郡美深町仁宇布');
ok($zip->set_number('0982211')->is_valid_number, '北海道中川郡美深町富岡');
ok($zip->set_number('0982212')->is_valid_number, '北海道中川郡美深町班渓');
ok($zip->set_number('0982213')->is_valid_number, '北海道中川郡美深町吉野');
ok($zip->set_number('0982214')->is_valid_number, '北海道中川郡美深町敷島');
ok($zip->set_number('0982220')->is_valid_number, '北海道中川郡美深町大通北');
ok($zip->set_number('0982221')->is_valid_number, '北海道中川郡美深町東一条北');
ok($zip->set_number('0982222')->is_valid_number, '北海道中川郡美深町東二条北');
ok($zip->set_number('0982223')->is_valid_number, '北海道中川郡美深町東三条北');
ok($zip->set_number('0982224')->is_valid_number, '北海道中川郡美深町東四条北');
ok($zip->set_number('0982225')->is_valid_number, '北海道中川郡美深町東五条北');
ok($zip->set_number('0982226')->is_valid_number, '北海道中川郡美深町東六条北');
ok($zip->set_number('0982227')->is_valid_number, '北海道中川郡美深町北町');
ok($zip->set_number('0982230')->is_valid_number, '北海道中川郡美深町大通南');
ok($zip->set_number('0982231')->is_valid_number, '北海道中川郡美深町東一条南');
ok($zip->set_number('0982232')->is_valid_number, '北海道中川郡美深町東二条南');
ok($zip->set_number('0982233')->is_valid_number, '北海道中川郡美深町東三条南');
ok($zip->set_number('0982234')->is_valid_number, '北海道中川郡美深町東四条南');
ok($zip->set_number('0982235')->is_valid_number, '北海道中川郡美深町南町');
ok($zip->set_number('0982236')->is_valid_number, '北海道中川郡美深町東六条南');
ok($zip->set_number('0982237')->is_valid_number, '北海道中川郡美深町若松町');
ok($zip->set_number('0982238')->is_valid_number, '北海道中川郡美深町開運町');
ok($zip->set_number('0982241')->is_valid_number, '北海道中川郡美深町西一条南');
ok($zip->set_number('0982242')->is_valid_number, '北海道中川郡美深町西二条南');
ok($zip->set_number('0982243')->is_valid_number, '北海道中川郡美深町西三条南');
ok($zip->set_number('0982251')->is_valid_number, '北海道中川郡美深町西一条北');
ok($zip->set_number('0982252')->is_valid_number, '北海道中川郡美深町西町');
ok($zip->set_number('0982253')->is_valid_number, '北海道中川郡美深町西三条北');
ok($zip->set_number('0982361')->is_valid_number, '北海道中川郡美深町恩根内');
ok($zip->set_number('0982362')->is_valid_number, '北海道中川郡美深町大手');
ok($zip->set_number('0982363')->is_valid_number, '北海道中川郡美深町小車');
ok($zip->set_number('0982364')->is_valid_number, '北海道中川郡美深町報徳');
ok($zip->set_number('0982365')->is_valid_number, '北海道中川郡美深町西里');
ok($zip->set_number('0982366')->is_valid_number, '北海道中川郡美深町紋穂内');
ok($zip->set_number('0982367')->is_valid_number, '北海道中川郡美深町楠');
ok($zip->set_number('0982368')->is_valid_number, '北海道中川郡美深町清水');
ok($zip->set_number('0982500')->is_valid_number, '北海道中川郡音威子府村以下に掲載がない場合');
ok($zip->set_number('0982501')->is_valid_number, '北海道中川郡音威子府村音威子府');
ok($zip->set_number('0982502')->is_valid_number, '北海道中川郡音威子府村咲来');
ok($zip->set_number('0982621')->is_valid_number, '北海道中川郡中川町共和');
ok($zip->set_number('0982622')->is_valid_number, '北海道中川郡中川町佐久');
ok($zip->set_number('0982623')->is_valid_number, '北海道中川郡中川町富和');
ok($zip->set_number('0982624')->is_valid_number, '北海道中川郡中川町豊里');
ok($zip->set_number('0982625')->is_valid_number, '北海道中川郡中川町安川');
ok($zip->set_number('0982626')->is_valid_number, '北海道中川郡中川町安川(3)');
ok($zip->set_number('0982800')->is_valid_number, '北海道中川郡中川町以下に掲載がない場合');
ok($zip->set_number('0982801')->is_valid_number, '北海道中川郡中川町歌内');
ok($zip->set_number('0982802')->is_valid_number, '北海道中川郡中川町中川');
ok($zip->set_number('0982803')->is_valid_number, '北海道中川郡中川町琴平');
ok($zip->set_number('0982804')->is_valid_number, '北海道中川郡中川町大富');
ok($zip->set_number('0982805')->is_valid_number, '北海道中川郡中川町誉');
ok($zip->set_number('0982806')->is_valid_number, '北海道中川郡中川町国府');
ok($zip->set_number('0982941')->is_valid_number, '北海道天塩郡幌延町上問寒');
ok($zip->set_number('0982942')->is_valid_number, '北海道天塩郡幌延町中問寒');
ok($zip->set_number('0982943')->is_valid_number, '北海道天塩郡幌延町問寒別');
ok($zip->set_number('0982951')->is_valid_number, '北海道天塩郡天塩町下コクネップ');
ok($zip->set_number('0983131')->is_valid_number, '北海道天塩郡天塩町タツネウシ');
ok($zip->set_number('0983132')->is_valid_number, '北海道天塩郡天塩町東雄信内');
ok($zip->set_number('0983133')->is_valid_number, '北海道天塩郡天塩町オヌプナイ');
ok($zip->set_number('0983133')->is_valid_number, '北海道天塩郡天塩町雄信内');
ok($zip->set_number('0983134')->is_valid_number, '北海道天塩郡天塩町円山');
ok($zip->set_number('0983135')->is_valid_number, '北海道天塩郡天塩町東産士');
ok($zip->set_number('0983141')->is_valid_number, '北海道天塩郡天塩町西雄信内');
ok($zip->set_number('0983142')->is_valid_number, '北海道天塩郡天塩町新成');
ok($zip->set_number('0983143')->is_valid_number, '北海道天塩郡天塩町泉源');
ok($zip->set_number('0983144')->is_valid_number, '北海道天塩郡天塩町男能富');
ok($zip->set_number('0983151')->is_valid_number, '北海道天塩郡幌延町雄興');
ok($zip->set_number('0983200')->is_valid_number, '北海道天塩郡幌延町以下に掲載がない場合');
ok($zip->set_number('0983201')->is_valid_number, '北海道天塩郡幌延町一条北');
ok($zip->set_number('0983202')->is_valid_number, '北海道天塩郡幌延町二条北');
ok($zip->set_number('0983203')->is_valid_number, '北海道天塩郡幌延町三条北');
ok($zip->set_number('0983204')->is_valid_number, '北海道天塩郡幌延町四条北');
ok($zip->set_number('0983205')->is_valid_number, '北海道天塩郡幌延町五条北');
ok($zip->set_number('0983206')->is_valid_number, '北海道天塩郡幌延町六条北');
ok($zip->set_number('0983207')->is_valid_number, '北海道天塩郡幌延町宮園町');
ok($zip->set_number('0983211')->is_valid_number, '北海道天塩郡幌延町一条南');
ok($zip->set_number('0983212')->is_valid_number, '北海道天塩郡幌延町二条南');
ok($zip->set_number('0983213')->is_valid_number, '北海道天塩郡幌延町三条南');
ok($zip->set_number('0983214')->is_valid_number, '北海道天塩郡幌延町四条南');
ok($zip->set_number('0983215')->is_valid_number, '北海道天塩郡幌延町五条南');
ok($zip->set_number('0983216')->is_valid_number, '北海道天塩郡幌延町六条南');
ok($zip->set_number('0983217')->is_valid_number, '北海道天塩郡幌延町元町');
ok($zip->set_number('0983221')->is_valid_number, '北海道天塩郡幌延町栄町');
ok($zip->set_number('0983222')->is_valid_number, '北海道天塩郡幌延町東町');
ok($zip->set_number('0983223')->is_valid_number, '北海道天塩郡幌延町幌延');
ok($zip->set_number('0983224')->is_valid_number, '北海道天塩郡幌延町北進');
ok($zip->set_number('0983225')->is_valid_number, '北海道天塩郡幌延町上幌延');
ok($zip->set_number('0983226')->is_valid_number, '北海道天塩郡幌延町開進');
ok($zip->set_number('0983227')->is_valid_number, '北海道天塩郡幌延町浜里');
ok($zip->set_number('0983228')->is_valid_number, '北海道天塩郡幌延町下沼');
ok($zip->set_number('0983300')->is_valid_number, '北海道天塩郡天塩町以下に掲載がない場合');
ok($zip->set_number('0983301')->is_valid_number, '北海道天塩郡天塩町山手通');
ok($zip->set_number('0983302')->is_valid_number, '北海道天塩郡天塩町山手裏通');
ok($zip->set_number('0983303')->is_valid_number, '北海道天塩郡天塩町新栄通');
ok($zip->set_number('0983304')->is_valid_number, '北海道天塩郡天塩町新地通');
ok($zip->set_number('0983305')->is_valid_number, '北海道天塩郡天塩町新開通');
ok($zip->set_number('0983306')->is_valid_number, '北海道天塩郡天塩町海岸通');
ok($zip->set_number('0983311')->is_valid_number, '北海道天塩郡天塩町産士');
ok($zip->set_number('0983312')->is_valid_number, '北海道天塩郡天塩町川口');
ok($zip->set_number('0983313')->is_valid_number, '北海道天塩郡天塩町作返');
ok($zip->set_number('0983314')->is_valid_number, '北海道天塩郡天塩町更岸');
ok($zip->set_number('0983315')->is_valid_number, '北海道天塩郡天塩町天塩');
ok($zip->set_number('0983316')->is_valid_number, '北海道天塩郡天塩町振老');
ok($zip->set_number('0983361')->is_valid_number, '北海道天塩郡遠別町北里(15号の沢)');
ok($zip->set_number('0983500')->is_valid_number, '北海道天塩郡遠別町以下に掲載がない場合');
ok($zip->set_number('0983501')->is_valid_number, '北海道天塩郡遠別町北里(その他)');
ok($zip->set_number('0983502')->is_valid_number, '北海道天塩郡遠別町清川');
ok($zip->set_number('0983503')->is_valid_number, '北海道天塩郡遠別町啓明');
ok($zip->set_number('0983504')->is_valid_number, '北海道天塩郡遠別町丸松');
ok($zip->set_number('0983511')->is_valid_number, '北海道天塩郡遠別町久光');
ok($zip->set_number('0983512')->is_valid_number, '北海道天塩郡遠別町中央');
ok($zip->set_number('0983521')->is_valid_number, '北海道天塩郡遠別町共栄');
ok($zip->set_number('0983522')->is_valid_number, '北海道天塩郡遠別町大成');
ok($zip->set_number('0983523')->is_valid_number, '北海道天塩郡遠別町東野');
ok($zip->set_number('0983531')->is_valid_number, '北海道天塩郡遠別町旭');
ok($zip->set_number('0983532')->is_valid_number, '北海道天塩郡遠別町歌越');
ok($zip->set_number('0983533')->is_valid_number, '北海道天塩郡遠別町金浦');
ok($zip->set_number('0983534')->is_valid_number, '北海道天塩郡遠別町富士見');
ok($zip->set_number('0983541')->is_valid_number, '北海道天塩郡遠別町北浜');
ok($zip->set_number('0983542')->is_valid_number, '北海道天塩郡遠別町幸和');
ok($zip->set_number('0983543')->is_valid_number, '北海道天塩郡遠別町本町');
ok($zip->set_number('0984100')->is_valid_number, '北海道天塩郡豊富町以下に掲載がない場合');
ok($zip->set_number('0984101')->is_valid_number, '北海道天塩郡豊富町福永');
ok($zip->set_number('0984102')->is_valid_number, '北海道天塩郡豊富町目梨別');
ok($zip->set_number('0984103')->is_valid_number, '北海道天塩郡豊富町有明');
ok($zip->set_number('0984104')->is_valid_number, '北海道天塩郡豊富町修徳');
ok($zip->set_number('0984105')->is_valid_number, '北海道天塩郡豊富町幌加');
ok($zip->set_number('0984106')->is_valid_number, '北海道天塩郡豊富町豊徳');
ok($zip->set_number('0984107')->is_valid_number, '北海道天塩郡豊富町稚咲内');
ok($zip->set_number('0984110')->is_valid_number, '北海道天塩郡豊富町大通り');
ok($zip->set_number('0984111')->is_valid_number, '北海道天塩郡豊富町西一条');
ok($zip->set_number('0984112')->is_valid_number, '北海道天塩郡豊富町西二条');
ok($zip->set_number('0984113')->is_valid_number, '北海道天塩郡豊富町西三条');
ok($zip->set_number('0984114')->is_valid_number, '北海道天塩郡豊富町西四条');
ok($zip->set_number('0984115')->is_valid_number, '北海道天塩郡豊富町西五条');
ok($zip->set_number('0984116')->is_valid_number, '北海道天塩郡豊富町西豊富');
ok($zip->set_number('0984117')->is_valid_number, '北海道天塩郡豊富町落合(その他)');
ok($zip->set_number('0984121')->is_valid_number, '北海道天塩郡豊富町東一条');
ok($zip->set_number('0984122')->is_valid_number, '北海道天塩郡豊富町東二条');
ok($zip->set_number('0984123')->is_valid_number, '北海道天塩郡豊富町東三条');
ok($zip->set_number('0984124')->is_valid_number, '北海道天塩郡豊富町東四条');
ok($zip->set_number('0984125')->is_valid_number, '北海道天塩郡豊富町東五条');
ok($zip->set_number('0984126')->is_valid_number, '北海道天塩郡豊富町東六条');
ok($zip->set_number('0984131')->is_valid_number, '北海道天塩郡豊富町東豊富');
ok($zip->set_number('0984132')->is_valid_number, '北海道天塩郡豊富町温泉');
ok($zip->set_number('0984133')->is_valid_number, '北海道天塩郡豊富町本流');
ok($zip->set_number('0984134')->is_valid_number, '北海道天塩郡豊富町豊幌');
ok($zip->set_number('0984135')->is_valid_number, '北海道天塩郡豊富町豊川');
ok($zip->set_number('0984136')->is_valid_number, '北海道天塩郡豊富町新生');
ok($zip->set_number('0984137')->is_valid_number, '北海道天塩郡豊富町徳満');
ok($zip->set_number('0984138')->is_valid_number, '北海道天塩郡豊富町駅前通');
ok($zip->set_number('0984139')->is_valid_number, '北海道天塩郡豊富町仲通り');
ok($zip->set_number('0984140')->is_valid_number, '北海道天塩郡豊富町停車場通');
ok($zip->set_number('0984141')->is_valid_number, '北海道天塩郡豊富町三条通り');
ok($zip->set_number('0984451')->is_valid_number, '北海道天塩郡豊富町兜沼');
ok($zip->set_number('0984455')->is_valid_number, '北海道天塩郡豊富町芦川');
ok($zip->set_number('0984456')->is_valid_number, '北海道天塩郡豊富町開源');
ok($zip->set_number('0984457')->is_valid_number, '北海道天塩郡豊富町沼向');
ok($zip->set_number('0984461')->is_valid_number, '北海道天塩郡豊富町瑞穂東');
ok($zip->set_number('0984462')->is_valid_number, '北海道天塩郡豊富町阿沙流');
ok($zip->set_number('0984463')->is_valid_number, '北海道天塩郡豊富町瑞穂南');
ok($zip->set_number('0984464')->is_valid_number, '北海道天塩郡豊富町豊栄');
ok($zip->set_number('0984465')->is_valid_number, '北海道天塩郡豊富町豊田');
ok($zip->set_number('0984466')->is_valid_number, '北海道天塩郡豊富町清明');
ok($zip->set_number('0984467')->is_valid_number, '北海道天塩郡豊富町豊里');
ok($zip->set_number('0984468')->is_valid_number, '北海道天塩郡豊富町落合(4468番地)');
ok($zip->set_number('0984581')->is_valid_number, '北海道稚内市抜海村(上勇知、下勇知、夕来、オネトマナイ)');
ok($zip->set_number('0984582')->is_valid_number, '北海道稚内市声問村(更喜苫内)');
ok($zip->set_number('0985101')->is_valid_number, '北海道枝幸郡中頓別町岩手');
ok($zip->set_number('0985102')->is_valid_number, '北海道枝幸郡中頓別町小頓別');
ok($zip->set_number('0985103')->is_valid_number, '北海道枝幸郡中頓別町秋田');
ok($zip->set_number('0985111')->is_valid_number, '北海道枝幸郡中頓別町上頓別');
ok($zip->set_number('0985112')->is_valid_number, '北海道枝幸郡中頓別町豊平');
ok($zip->set_number('0985113')->is_valid_number, '北海道枝幸郡中頓別町敏音知');
ok($zip->set_number('0985201')->is_valid_number, '北海道枝幸郡枝幸町歌登パンケナイ');
ok($zip->set_number('0985202')->is_valid_number, '北海道枝幸郡枝幸町歌登東歌登');
ok($zip->set_number('0985203')->is_valid_number, '北海道枝幸郡枝幸町歌登辺毛内');
ok($zip->set_number('0985204')->is_valid_number, '北海道枝幸郡枝幸町歌登南町');
ok($zip->set_number('0985205')->is_valid_number, '北海道枝幸郡枝幸町歌登桧垣町');
ok($zip->set_number('0985206')->is_valid_number, '北海道枝幸郡枝幸町歌登西町');
ok($zip->set_number('0985207')->is_valid_number, '北海道枝幸郡枝幸町歌登東町');
ok($zip->set_number('0985211')->is_valid_number, '北海道枝幸郡枝幸町歌登西歌登');
ok($zip->set_number('0985212')->is_valid_number, '北海道枝幸郡枝幸町歌登中央');
ok($zip->set_number('0985213')->is_valid_number, '北海道枝幸郡枝幸町歌登本幌別');
ok($zip->set_number('0985221')->is_valid_number, '北海道枝幸郡枝幸町歌登毛登別');
ok($zip->set_number('0985441')->is_valid_number, '北海道枝幸郡枝幸町歌登志美宇丹');
ok($zip->set_number('0985442')->is_valid_number, '北海道枝幸郡枝幸町歌登豊沃');
ok($zip->set_number('0985443')->is_valid_number, '北海道枝幸郡枝幸町歌登上徳志別');
ok($zip->set_number('0985444')->is_valid_number, '北海道枝幸郡枝幸町歌登大奮');
ok($zip->set_number('0985445')->is_valid_number, '北海道枝幸郡枝幸町歌登大曲');
ok($zip->set_number('0985500')->is_valid_number, '北海道枝幸郡中頓別町以下に掲載がない場合');
ok($zip->set_number('0985551')->is_valid_number, '北海道枝幸郡中頓別町中頓別');
ok($zip->set_number('0985552')->is_valid_number, '北海道枝幸郡中頓別町寿');
ok($zip->set_number('0985553')->is_valid_number, '北海道枝幸郡中頓別町弥生');
ok($zip->set_number('0985554')->is_valid_number, '北海道枝幸郡中頓別町旭台');
ok($zip->set_number('0985555')->is_valid_number, '北海道枝幸郡中頓別町豊泉');
ok($zip->set_number('0985561')->is_valid_number, '北海道枝幸郡中頓別町兵安');
ok($zip->set_number('0985562')->is_valid_number, '北海道枝幸郡中頓別町神崎');
ok($zip->set_number('0985563')->is_valid_number, '北海道枝幸郡中頓別町藤井');
ok($zip->set_number('0985564')->is_valid_number, '北海道枝幸郡中頓別町上駒');
ok($zip->set_number('0985565')->is_valid_number, '北海道枝幸郡中頓別町松音知');
ok($zip->set_number('0985700')->is_valid_number, '北海道枝幸郡浜頓別町以下に掲載がない場合');
ok($zip->set_number('0985701')->is_valid_number, '北海道枝幸郡浜頓別町栄和');
ok($zip->set_number('0985701')->is_valid_number, '北海道枝幸郡浜頓別町頓別');
ok($zip->set_number('0985702')->is_valid_number, '北海道枝幸郡浜頓別町豊牛');
ok($zip->set_number('0985702')->is_valid_number, '北海道枝幸郡浜頓別町豊寒別');
ok($zip->set_number('0985703')->is_valid_number, '北海道枝幸郡浜頓別町斜内');
ok($zip->set_number('0985703')->is_valid_number, '北海道枝幸郡浜頓別町豊浜');
ok($zip->set_number('0985704')->is_valid_number, '北海道枝幸郡浜頓別町中央北');
ok($zip->set_number('0985705')->is_valid_number, '北海道枝幸郡浜頓別町中央南');
ok($zip->set_number('0985711')->is_valid_number, '北海道枝幸郡浜頓別町北1条');
ok($zip->set_number('0985712')->is_valid_number, '北海道枝幸郡浜頓別町北2条');
ok($zip->set_number('0985713')->is_valid_number, '北海道枝幸郡浜頓別町北3条');
ok($zip->set_number('0985714')->is_valid_number, '北海道枝幸郡浜頓別町北4条');
ok($zip->set_number('0985717')->is_valid_number, '北海道枝幸郡浜頓別町浜頓別');
ok($zip->set_number('0985721')->is_valid_number, '北海道枝幸郡浜頓別町南1条');
ok($zip->set_number('0985722')->is_valid_number, '北海道枝幸郡浜頓別町南2条');
ok($zip->set_number('0985723')->is_valid_number, '北海道枝幸郡浜頓別町南3条');
ok($zip->set_number('0985725')->is_valid_number, '北海道枝幸郡浜頓別町大通');
ok($zip->set_number('0985734')->is_valid_number, '北海道枝幸郡浜頓別町日の出');
ok($zip->set_number('0985738')->is_valid_number, '北海道枝幸郡浜頓別町緑ケ丘');
ok($zip->set_number('0985739')->is_valid_number, '北海道枝幸郡浜頓別町クッチャロ湖畔');
ok($zip->set_number('0985741')->is_valid_number, '北海道枝幸郡浜頓別町旭ケ丘');
ok($zip->set_number('0985742')->is_valid_number, '北海道枝幸郡浜頓別町戸出');
ok($zip->set_number('0985743')->is_valid_number, '北海道枝幸郡浜頓別町楓');
ok($zip->set_number('0985744')->is_valid_number, '北海道枝幸郡浜頓別町宇曽丹');
ok($zip->set_number('0985745')->is_valid_number, '北海道枝幸郡浜頓別町常盤');
ok($zip->set_number('0985751')->is_valid_number, '北海道枝幸郡浜頓別町金ヶ丘');
ok($zip->set_number('0985752')->is_valid_number, '北海道枝幸郡浜頓別町下頓別');
ok($zip->set_number('0985753')->is_valid_number, '北海道枝幸郡浜頓別町高砂');
ok($zip->set_number('0985754')->is_valid_number, '北海道枝幸郡浜頓別町宇津内');
ok($zip->set_number('0985755')->is_valid_number, '北海道枝幸郡浜頓別町茂宇津内');
ok($zip->set_number('0985761')->is_valid_number, '北海道枝幸郡浜頓別町智福');
ok($zip->set_number('0985761')->is_valid_number, '北海道枝幸郡浜頓別町山軽');
ok($zip->set_number('0985762')->is_valid_number, '北海道枝幸郡浜頓別町ポン仁達内');
ok($zip->set_number('0985763')->is_valid_number, '北海道枝幸郡浜頓別町仁達内');
ok($zip->set_number('0985764')->is_valid_number, '北海道枝幸郡浜頓別町安別');
ok($zip->set_number('0985765')->is_valid_number, '北海道枝幸郡浜頓別町共和');
ok($zip->set_number('0985800')->is_valid_number, '北海道枝幸郡枝幸町以下に掲載がない場合');
ok($zip->set_number('0985801')->is_valid_number, '北海道枝幸郡枝幸町徳志別');
ok($zip->set_number('0985802')->is_valid_number, '北海道枝幸郡枝幸町岡島');
ok($zip->set_number('0985803')->is_valid_number, '北海道枝幸郡枝幸町下幌別');
ok($zip->set_number('0985804')->is_valid_number, '北海道枝幸郡枝幸町南浜町');
ok($zip->set_number('0985805')->is_valid_number, '北海道枝幸郡枝幸町幸町');
ok($zip->set_number('0985806')->is_valid_number, '北海道枝幸郡枝幸町梅ケ枝町');
ok($zip->set_number('0985807')->is_valid_number, '北海道枝幸郡枝幸町本町');
ok($zip->set_number('0985808')->is_valid_number, '北海道枝幸郡枝幸町新港町');
ok($zip->set_number('0985814')->is_valid_number, '北海道枝幸郡枝幸町岬町');
ok($zip->set_number('0985815')->is_valid_number, '北海道枝幸郡枝幸町問牧');
ok($zip->set_number('0985816')->is_valid_number, '北海道枝幸郡枝幸町目梨泊');
ok($zip->set_number('0985821')->is_valid_number, '北海道枝幸郡枝幸町栄町');
ok($zip->set_number('0985822')->is_valid_number, '北海道枝幸郡枝幸町北幸町');
ok($zip->set_number('0985823')->is_valid_number, '北海道枝幸郡枝幸町三笠町');
ok($zip->set_number('0985824')->is_valid_number, '北海道枝幸郡枝幸町北栄町');
ok($zip->set_number('0985825')->is_valid_number, '北海道枝幸郡枝幸町新栄町');
ok($zip->set_number('0985826')->is_valid_number, '北海道枝幸郡枝幸町北浜町');
ok($zip->set_number('0985827')->is_valid_number, '北海道枝幸郡枝幸町宇遠内');
ok($zip->set_number('0985951')->is_valid_number, '北海道枝幸郡枝幸町山臼');
ok($zip->set_number('0985952')->is_valid_number, '北海道枝幸郡枝幸町乙忠部');
ok($zip->set_number('0985953')->is_valid_number, '北海道枝幸郡枝幸町風烈布');
ok($zip->set_number('0985954')->is_valid_number, '北海道枝幸郡枝幸町上音標');
ok($zip->set_number('0985955')->is_valid_number, '北海道枝幸郡枝幸町音標');
ok($zip->set_number('0986101')->is_valid_number, '北海道宗谷郡猿払村浅茅野');
ok($zip->set_number('0986102')->is_valid_number, '北海道宗谷郡猿払村浅茅野台地');
ok($zip->set_number('0986103')->is_valid_number, '北海道宗谷郡猿払村狩別');
ok($zip->set_number('0986104')->is_valid_number, '北海道宗谷郡猿払村猿払');
ok($zip->set_number('0986105')->is_valid_number, '北海道宗谷郡猿払村浜猿払');
ok($zip->set_number('0986106')->is_valid_number, '北海道宗谷郡猿払村上猿払');
ok($zip->set_number('0986200')->is_valid_number, '北海道宗谷郡猿払村以下に掲載がない場合');
ok($zip->set_number('0986222')->is_valid_number, '北海道宗谷郡猿払村浜鬼志別');
ok($zip->set_number('0986225')->is_valid_number, '北海道宗谷郡猿払村芦野');
ok($zip->set_number('0986226')->is_valid_number, '北海道宗谷郡猿払村豊里');
ok($zip->set_number('0986228')->is_valid_number, '北海道宗谷郡猿払村小石');
ok($zip->set_number('0986231')->is_valid_number, '北海道宗谷郡猿払村鬼志別東町');
ok($zip->set_number('0986232')->is_valid_number, '北海道宗谷郡猿払村鬼志別西町');
ok($zip->set_number('0986233')->is_valid_number, '北海道宗谷郡猿払村鬼志別南町');
ok($zip->set_number('0986234')->is_valid_number, '北海道宗谷郡猿払村鬼志別北町');
ok($zip->set_number('0986341')->is_valid_number, '北海道宗谷郡猿払村知来別');
ok($zip->set_number('0986384')->is_valid_number, '北海道稚内市宗谷村(峰岡)');
ok($zip->set_number('0986385')->is_valid_number, '北海道稚内市宗谷村(東浦)');
ok($zip->set_number('0986561')->is_valid_number, '北海道稚内市声問村(樺岡)');
ok($zip->set_number('0986562')->is_valid_number, '北海道稚内市声問村(上声問)');
ok($zip->set_number('0986563')->is_valid_number, '北海道稚内市声問村(沼川)');
ok($zip->set_number('0986564')->is_valid_number, '北海道稚内市声問村(川西)');
ok($zip->set_number('0986565')->is_valid_number, '北海道稚内市声問村(曙)');
ok($zip->set_number('0986571')->is_valid_number, '北海道稚内市声問村(曲渕)');
ok($zip->set_number('0986572')->is_valid_number, '北海道稚内市声問村(開進)');
ok($zip->set_number('0986573')->is_valid_number, '北海道稚内市声問村(下豊別)');
ok($zip->set_number('0986574')->is_valid_number, '北海道稚内市声問村(上豊別)');
ok($zip->set_number('0986575')->is_valid_number, '北海道稚内市声問村(天興)');
ok($zip->set_number('0986576')->is_valid_number, '北海道稚内市声問村(川南)');
ok($zip->set_number('0986642')->is_valid_number, '北海道稚内市声問(1~5丁目)');
ok($zip->set_number('0986642')->is_valid_number, '北海道稚内市声問村(声問)');
ok($zip->set_number('0986643')->is_valid_number, '北海道稚内市声問村(メクマ)');
ok($zip->set_number('0986644')->is_valid_number, '北海道稚内市宗谷村(増幌)');
ok($zip->set_number('0986645')->is_valid_number, '北海道稚内市声問村(恵北)');
ok($zip->set_number('0986751')->is_valid_number, '北海道稚内市宗谷村(豊岩)');
ok($zip->set_number('0986754')->is_valid_number, '北海道稚内市宗谷村(清浜)');
ok($zip->set_number('0986755')->is_valid_number, '北海道稚内市宗谷村(宗谷)');
ok($zip->set_number('0986756')->is_valid_number, '北海道稚内市宗谷村(富磯)');
ok($zip->set_number('0986757')->is_valid_number, '北海道稚内市宗谷村(増幌浜)');
ok($zip->set_number('0986758')->is_valid_number, '北海道稚内市宗谷岬');
ok($zip->set_number('0990101')->is_valid_number, '北海道紋別郡遠軽町下白滝');
ok($zip->set_number('0990102')->is_valid_number, '北海道紋別郡遠軽町旧白滝');
ok($zip->set_number('0990111')->is_valid_number, '北海道紋別郡遠軽町白滝');
ok($zip->set_number('0990121')->is_valid_number, '北海道紋別郡遠軽町白滝北支湧別');
ok($zip->set_number('0990122')->is_valid_number, '北海道紋別郡遠軽町白滝支湧別');
ok($zip->set_number('0990123')->is_valid_number, '北海道紋別郡遠軽町白滝上支湧別');
ok($zip->set_number('0990124')->is_valid_number, '北海道紋別郡遠軽町東白滝');
ok($zip->set_number('0990125')->is_valid_number, '北海道紋別郡遠軽町白滝天狗平');
ok($zip->set_number('0990126')->is_valid_number, '北海道紋別郡遠軽町奥白滝');
ok($zip->set_number('0990127')->is_valid_number, '北海道紋別郡遠軽町上白滝');
ok($zip->set_number('0990201')->is_valid_number, '北海道紋別郡遠軽町丸瀬布新町');
ok($zip->set_number('0990202')->is_valid_number, '北海道紋別郡遠軽町丸瀬布天神町');
ok($zip->set_number('0990203')->is_valid_number, '北海道紋別郡遠軽町丸瀬布中町');
ok($zip->set_number('0990204')->is_valid_number, '北海道紋別郡遠軽町丸瀬布西町');
ok($zip->set_number('0990205')->is_valid_number, '北海道紋別郡遠軽町丸瀬布東町');
ok($zip->set_number('0990206')->is_valid_number, '北海道紋別郡遠軽町丸瀬布水谷町');
ok($zip->set_number('0990207')->is_valid_number, '北海道紋別郡遠軽町丸瀬布元町');
ok($zip->set_number('0990211')->is_valid_number, '北海道紋別郡遠軽町丸瀬布金山');
ok($zip->set_number('0990212')->is_valid_number, '北海道紋別郡遠軽町丸瀬布上丸');
ok($zip->set_number('0990213')->is_valid_number, '北海道紋別郡遠軽町丸瀬布上武利');
ok($zip->set_number('0990214')->is_valid_number, '北海道紋別郡遠軽町丸瀬布大平');
ok($zip->set_number('0990215')->is_valid_number, '北海道紋別郡遠軽町丸瀬布南丸');
ok($zip->set_number('0990216')->is_valid_number, '北海道紋別郡遠軽町丸瀬布武利');
ok($zip->set_number('0990341')->is_valid_number, '北海道紋別郡遠軽町瀬戸瀬東町');
ok($zip->set_number('0990342')->is_valid_number, '北海道紋別郡遠軽町瀬戸瀬西町');
ok($zip->set_number('0990343')->is_valid_number, '北海道紋別郡遠軽町栄野');
ok($zip->set_number('0990344')->is_valid_number, '北海道紋別郡遠軽町野上');
ok($zip->set_number('0990345')->is_valid_number, '北海道紋別郡遠軽町湯の里');
ok($zip->set_number('0990346')->is_valid_number, '北海道紋別郡遠軽町若咲内');
ok($zip->set_number('0990347')->is_valid_number, '北海道紋別郡遠軽町柏');
ok($zip->set_number('0990400')->is_valid_number, '北海道紋別郡遠軽町以下に掲載がない場合');
ok($zip->set_number('0990401')->is_valid_number, '北海道紋別郡遠軽町学田');
ok($zip->set_number('0990402')->is_valid_number, '北海道紋別郡遠軽町二条通北');
ok($zip->set_number('0990403')->is_valid_number, '北海道紋別郡遠軽町一条通北');
ok($zip->set_number('0990404')->is_valid_number, '北海道紋別郡遠軽町大通北');
ok($zip->set_number('0990405')->is_valid_number, '北海道紋別郡遠軽町岩見通北');
ok($zip->set_number('0990406')->is_valid_number, '北海道紋別郡遠軽町宮前町');
ok($zip->set_number('0990407')->is_valid_number, '北海道紋別郡遠軽町丸大');
ok($zip->set_number('0990408')->is_valid_number, '北海道紋別郡遠軽町留岡');
ok($zip->set_number('0990410')->is_valid_number, '北海道紋別郡遠軽町東町');
ok($zip->set_number('0990411')->is_valid_number, '北海道紋別郡遠軽町向遠軽');
ok($zip->set_number('0990412')->is_valid_number, '北海道紋別郡遠軽町豊里');
ok($zip->set_number('0990413')->is_valid_number, '北海道紋別郡遠軽町寿町');
ok($zip->set_number('0990414')->is_valid_number, '北海道紋別郡遠軽町南町');
ok($zip->set_number('0990415')->is_valid_number, '北海道紋別郡遠軽町岩見通南');
ok($zip->set_number('0990416')->is_valid_number, '北海道紋別郡遠軽町大通南');
ok($zip->set_number('0990417')->is_valid_number, '北海道紋別郡遠軽町一条通南');
ok($zip->set_number('0990418')->is_valid_number, '北海道紋別郡遠軽町二条通南');
ok($zip->set_number('0990421')->is_valid_number, '北海道紋別郡遠軽町福路');
ok($zip->set_number('0990422')->is_valid_number, '北海道紋別郡遠軽町清川');
ok($zip->set_number('0990423')->is_valid_number, '北海道紋別郡遠軽町若松');
ok($zip->set_number('0990424')->is_valid_number, '北海道紋別郡遠軽町美山');
ok($zip->set_number('0990425')->is_valid_number, '北海道紋別郡遠軽町千代田');
ok($zip->set_number('0990426')->is_valid_number, '北海道紋別郡遠軽町社名淵');
ok($zip->set_number('0990427')->is_valid_number, '北海道紋別郡遠軽町見晴');
ok($zip->set_number('0990428')->is_valid_number, '北海道紋別郡遠軽町西町');
ok($zip->set_number('0990621')->is_valid_number, '北海道紋別郡遠軽町生田原水穂');
ok($zip->set_number('0990622')->is_valid_number, '北海道紋別郡遠軽町生田原安国');
ok($zip->set_number('0990623')->is_valid_number, '北海道紋別郡遠軽町生田原旭野');
ok($zip->set_number('0990624')->is_valid_number, '北海道紋別郡遠軽町生田原豊原');
ok($zip->set_number('0990701')->is_valid_number, '北海道紋別郡遠軽町生田原');
ok($zip->set_number('0990702')->is_valid_number, '北海道紋別郡遠軽町生田原伊吹');
ok($zip->set_number('0990703')->is_valid_number, '北海道紋別郡遠軽町生田原八重');
ok($zip->set_number('0990704')->is_valid_number, '北海道紋別郡遠軽町生田原岩戸');
ok($zip->set_number('0990705')->is_valid_number, '北海道紋別郡遠軽町生田原清里');
ok($zip->set_number('0990871')->is_valid_number, '北海道北見市相内町');
ok($zip->set_number('0990872')->is_valid_number, '北海道北見市豊田');
ok($zip->set_number('0990873')->is_valid_number, '北海道北見市西相内');
ok($zip->set_number('0990874')->is_valid_number, '北海道北見市住吉');
ok($zip->set_number('0990875')->is_valid_number, '北海道北見市本沢');
ok($zip->set_number('0990876')->is_valid_number, '北海道北見市富里');
ok($zip->set_number('0990877')->is_valid_number, '北海道北見市柏木');
ok($zip->set_number('0990878')->is_valid_number, '北海道北見市東相内町');
ok($zip->set_number('0990879')->is_valid_number, '北海道北見市美園');
ok($zip->set_number('0991100')->is_valid_number, '北海道常呂郡置戸町以下に掲載がない場合');
ok($zip->set_number('0991101')->is_valid_number, '北海道常呂郡置戸町北光');
ok($zip->set_number('0991102')->is_valid_number, '北海道常呂郡置戸町緑');
ok($zip->set_number('0991103')->is_valid_number, '北海道常呂郡置戸町栄二');
ok($zip->set_number('0991104')->is_valid_number, '北海道常呂郡置戸町栄一');
ok($zip->set_number('0991105')->is_valid_number, '北海道常呂郡置戸町洗心');
ok($zip->set_number('0991106')->is_valid_number, '北海道常呂郡置戸町新和');
ok($zip->set_number('0991112')->is_valid_number, '北海道常呂郡置戸町若松');
ok($zip->set_number('0991113')->is_valid_number, '北海道常呂郡置戸町新光');
ok($zip->set_number('0991114')->is_valid_number, '北海道常呂郡置戸町協生');
ok($zip->set_number('0991115')->is_valid_number, '北海道常呂郡置戸町宮下');
ok($zip->set_number('0991116')->is_valid_number, '北海道常呂郡置戸町朝日');
ok($zip->set_number('0991117')->is_valid_number, '北海道常呂郡置戸町宮坂');
ok($zip->set_number('0991118')->is_valid_number, '北海道常呂郡置戸町若木');
ok($zip->set_number('0991121')->is_valid_number, '北海道常呂郡置戸町北農');
ok($zip->set_number('0991122')->is_valid_number, '北海道常呂郡置戸町林友');
ok($zip->set_number('0991123')->is_valid_number, '北海道常呂郡置戸町拓殖');
ok($zip->set_number('0991124')->is_valid_number, '北海道常呂郡置戸町拓実');
ok($zip->set_number('0991131')->is_valid_number, '北海道常呂郡置戸町中央');
ok($zip->set_number('0991132')->is_valid_number, '北海道常呂郡置戸町協和');
ok($zip->set_number('0991133')->is_valid_number, '北海道常呂郡置戸町更盛');
ok($zip->set_number('0991134')->is_valid_number, '北海道常呂郡置戸町十全');
ok($zip->set_number('0991135')->is_valid_number, '北海道常呂郡置戸町国栄');
ok($zip->set_number('0991136')->is_valid_number, '北海道常呂郡置戸町日進');
ok($zip->set_number('0991137')->is_valid_number, '北海道常呂郡置戸町大美');
ok($zip->set_number('0991138')->is_valid_number, '北海道常呂郡置戸町中里');
ok($zip->set_number('0991251')->is_valid_number, '北海道常呂郡置戸町安住');
ok($zip->set_number('0991252')->is_valid_number, '北海道常呂郡置戸町勝山');
ok($zip->set_number('0991253')->is_valid_number, '北海道常呂郡置戸町春日');
ok($zip->set_number('0991254')->is_valid_number, '北海道常呂郡置戸町常元');
ok($zip->set_number('0991361')->is_valid_number, '北海道常呂郡置戸町境野');
ok($zip->set_number('0991362')->is_valid_number, '北海道常呂郡置戸町雄勝');
ok($zip->set_number('0991363')->is_valid_number, '北海道常呂郡置戸町幸岡');
ok($zip->set_number('0991364')->is_valid_number, '北海道常呂郡置戸町秋田');
ok($zip->set_number('0991365')->is_valid_number, '北海道常呂郡置戸町豊住');
ok($zip->set_number('0991366')->is_valid_number, '北海道常呂郡置戸町川南');
ok($zip->set_number('0991367')->is_valid_number, '北海道常呂郡置戸町常盤');
ok($zip->set_number('0991400')->is_valid_number, '北海道常呂郡訓子府町以下に掲載がない場合');
ok($zip->set_number('0991401')->is_valid_number, '北海道常呂郡訓子府町日出');
ok($zip->set_number('0991402')->is_valid_number, '北海道常呂郡訓子府町穂波');
ok($zip->set_number('0991403')->is_valid_number, '北海道常呂郡訓子府町東幸町');
ok($zip->set_number('0991404')->is_valid_number, '北海道常呂郡訓子府町柏丘');
ok($zip->set_number('0991405')->is_valid_number, '北海道常呂郡訓子府町高園');
ok($zip->set_number('0991406')->is_valid_number, '北海道常呂郡訓子府町弥生');
ok($zip->set_number('0991407')->is_valid_number, '北海道常呂郡訓子府町福野');
ok($zip->set_number('0991411')->is_valid_number, '北海道常呂郡訓子府町大谷');
ok($zip->set_number('0991412')->is_valid_number, '北海道常呂郡訓子府町緑丘');
ok($zip->set_number('0991413')->is_valid_number, '北海道常呂郡訓子府町協成');
ok($zip->set_number('0991414')->is_valid_number, '北海道常呂郡訓子府町開盛');
ok($zip->set_number('0991415')->is_valid_number, '北海道常呂郡訓子府町美園');
ok($zip->set_number('0991416')->is_valid_number, '北海道常呂郡訓子府町常盤');
ok($zip->set_number('0991417')->is_valid_number, '北海道常呂郡訓子府町末広町');
ok($zip->set_number('0991418')->is_valid_number, '北海道常呂郡訓子府町実郷');
ok($zip->set_number('0991421')->is_valid_number, '北海道常呂郡訓子府町駒里');
ok($zip->set_number('0991422')->is_valid_number, '北海道常呂郡訓子府町北栄');
ok($zip->set_number('0991423')->is_valid_number, '北海道常呂郡訓子府町西幸町');
ok($zip->set_number('0991424')->is_valid_number, '北海道常呂郡訓子府町西富');
ok($zip->set_number('0991425')->is_valid_number, '北海道常呂郡訓子府町若葉町');
ok($zip->set_number('0991426')->is_valid_number, '北海道常呂郡訓子府町清住');
ok($zip->set_number('0991427')->is_valid_number, '北海道常呂郡訓子府町豊坂');
ok($zip->set_number('0991431')->is_valid_number, '北海道常呂郡訓子府町東町');
ok($zip->set_number('0991432')->is_valid_number, '北海道常呂郡訓子府町旭町');
ok($zip->set_number('0991433')->is_valid_number, '北海道常呂郡訓子府町仲町');
ok($zip->set_number('0991434')->is_valid_number, '北海道常呂郡訓子府町栄町');
ok($zip->set_number('0991435')->is_valid_number, '北海道常呂郡訓子府町若富町');
ok($zip->set_number('0991436')->is_valid_number, '北海道常呂郡訓子府町大町');
ok($zip->set_number('0991437')->is_valid_number, '北海道常呂郡訓子府町元町');
ok($zip->set_number('0991581')->is_valid_number, '北海道北見市南丘');
ok($zip->set_number('0991582')->is_valid_number, '北海道北見市開成');
ok($zip->set_number('0991583')->is_valid_number, '北海道北見市北上');
ok($zip->set_number('0991584')->is_valid_number, '北海道北見市常川');
ok($zip->set_number('0991585')->is_valid_number, '北海道北見市上ところ');
ok($zip->set_number('0991586')->is_valid_number, '北海道北見市広郷');
ok($zip->set_number('0991587')->is_valid_number, '北海道北見市豊地');
ok($zip->set_number('0992101')->is_valid_number, '北海道北見市端野町一区');
ok($zip->set_number('0992102')->is_valid_number, '北海道北見市端野町二区');
ok($zip->set_number('0992103')->is_valid_number, '北海道北見市端野町三区');
ok($zip->set_number('0992104')->is_valid_number, '北海道北見市端野町端野');
ok($zip->set_number('0992105')->is_valid_number, '北海道北見市端野町忠志');
ok($zip->set_number('0992106')->is_valid_number, '北海道北見市端野町協和');
ok($zip->set_number('0992107')->is_valid_number, '北海道北見市端野町川向');
ok($zip->set_number('0992111')->is_valid_number, '北海道北見市端野町北登');
ok($zip->set_number('0992112')->is_valid_number, '北海道北見市端野町豊実');
ok($zip->set_number('0992231')->is_valid_number, '北海道北見市端野町緋牛内');
ok($zip->set_number('0992300')->is_valid_number, '北海道網走郡大空町以下に掲載がない場合');
ok($zip->set_number('0992301')->is_valid_number, '北海道網走郡大空町女満別本郷');
ok($zip->set_number('0992302')->is_valid_number, '北海道網走郡大空町女満別住吉');
ok($zip->set_number('0992303')->is_valid_number, '北海道網走郡大空町女満別豊里');
ok($zip->set_number('0992304')->is_valid_number, '北海道網走郡大空町女満別公園');
ok($zip->set_number('0992305')->is_valid_number, '北海道網走郡大空町女満別東陽');
ok($zip->set_number('0992306')->is_valid_number, '北海道網走郡大空町女満別湖畔');
ok($zip->set_number('0992310')->is_valid_number, '北海道網走郡大空町女満別本通');
ok($zip->set_number('0992311')->is_valid_number, '北海道網走郡大空町女満別東一条');
ok($zip->set_number('0992312')->is_valid_number, '北海道網走郡大空町女満別東二条');
ok($zip->set_number('0992321')->is_valid_number, '北海道網走郡大空町女満別西一条');
ok($zip->set_number('0992322')->is_valid_number, '北海道網走郡大空町女満別西二条');
ok($zip->set_number('0992323')->is_valid_number, '北海道網走郡大空町女満別西三条');
ok($zip->set_number('0992324')->is_valid_number, '北海道網走郡大空町女満別西四条');
ok($zip->set_number('0992325')->is_valid_number, '北海道網走郡大空町女満別西五条');
ok($zip->set_number('0992326')->is_valid_number, '北海道網走郡大空町女満別西六条');
ok($zip->set_number('0992327')->is_valid_number, '北海道網走郡大空町女満別西七条');
ok($zip->set_number('0992351')->is_valid_number, '北海道網走郡大空町女満別公園通');
ok($zip->set_number('0992354')->is_valid_number, '北海道網走郡大空町女満別眺湖台');
ok($zip->set_number('0992355')->is_valid_number, '北海道網走郡大空町女満別夕陽台');
ok($zip->set_number('0992356')->is_valid_number, '北海道網走郡大空町女満別昭和');
ok($zip->set_number('0992361')->is_valid_number, '北海道網走郡大空町女満別湖南');
ok($zip->set_number('0992362')->is_valid_number, '北海道網走郡大空町女満別朝日');
ok($zip->set_number('0992371')->is_valid_number, '北海道網走郡大空町女満別中央');
ok($zip->set_number('0992372')->is_valid_number, '北海道網走郡大空町女満別大東');
ok($zip->set_number('0992373')->is_valid_number, '北海道網走郡大空町女満別巴沢');
ok($zip->set_number('0992381')->is_valid_number, '北海道網走郡大空町女満別大成');
ok($zip->set_number('0992382')->is_valid_number, '北海道網走郡大空町女満別開陽');
ok($zip->set_number('0992383')->is_valid_number, '北海道網走郡大空町女満別日進');
ok($zip->set_number('0992421')->is_valid_number, '北海道網走市呼人');
ok($zip->set_number('0992422')->is_valid_number, '北海道網走市八坂');
ok($zip->set_number('0992423')->is_valid_number, '北海道網走市東網走');
ok($zip->set_number('0992424')->is_valid_number, '北海道網走市中園');
ok($zip->set_number('0993111')->is_valid_number, '北海道網走市藻琴');
ok($zip->set_number('0993112')->is_valid_number, '北海道網走市北浜');
ok($zip->set_number('0993113')->is_valid_number, '北海道網走市実豊');
ok($zip->set_number('0993114')->is_valid_number, '北海道網走市丸万');
ok($zip->set_number('0993115')->is_valid_number, '北海道網走市稲富');
ok($zip->set_number('0993116')->is_valid_number, '北海道網走市山里');
ok($zip->set_number('0993117')->is_valid_number, '北海道網走市昭和');
ok($zip->set_number('0993118')->is_valid_number, '北海道網走市豊郷');
ok($zip->set_number('0993119')->is_valid_number, '北海道網走市鱒浦');
ok($zip->set_number('0993201')->is_valid_number, '北海道網走郡大空町東藻琴(西区)');
ok($zip->set_number('0993202')->is_valid_number, '北海道網走郡大空町東藻琴西倉');
ok($zip->set_number('0993211')->is_valid_number, '北海道網走郡大空町東藻琴(北1区)');
ok($zip->set_number('0993212')->is_valid_number, '北海道網走郡大空町東藻琴(北2区)');
ok($zip->set_number('0993213')->is_valid_number, '北海道網走郡大空町東藻琴(中央区)');
ok($zip->set_number('0993214')->is_valid_number, '北海道網走郡大空町東藻琴(南区)');
ok($zip->set_number('0993221')->is_valid_number, '北海道網走郡大空町東藻琴大進');
ok($zip->set_number('0993222')->is_valid_number, '北海道網走郡大空町東藻琴新富');
ok($zip->set_number('0993223')->is_valid_number, '北海道網走郡大空町東藻琴(東区)');
ok($zip->set_number('0993224')->is_valid_number, '北海道網走郡大空町東藻琴明生');
ok($zip->set_number('0993225')->is_valid_number, '北海道網走郡大空町東藻琴(旭台)');
ok($zip->set_number('0993231')->is_valid_number, '北海道網走郡大空町東藻琴千草');
ok($zip->set_number('0993232')->is_valid_number, '北海道網走郡大空町東藻琴末広');
ok($zip->set_number('0993233')->is_valid_number, '北海道網走郡大空町東藻琴(上東)');
ok($zip->set_number('0993234')->is_valid_number, '北海道網走郡大空町東藻琴福富');
ok($zip->set_number('0993243')->is_valid_number, '北海道網走郡大空町東藻琴山園');
ok($zip->set_number('0993244')->is_valid_number, '北海道網走郡大空町東藻琴(その他)');
ok($zip->set_number('0993451')->is_valid_number, '北海道斜里郡小清水町倉栄');
ok($zip->set_number('0993452')->is_valid_number, '北海道斜里郡小清水町浜小清水');
ok($zip->set_number('0993453')->is_valid_number, '北海道斜里郡小清水町北斗');
ok($zip->set_number('0993454')->is_valid_number, '北海道斜里郡小清水町止別');
ok($zip->set_number('0993501')->is_valid_number, '北海道網走市音根内');
ok($zip->set_number('0993502')->is_valid_number, '北海道網走市浦士別');
ok($zip->set_number('0993503')->is_valid_number, '北海道網走市栄');
ok($zip->set_number('0993504')->is_valid_number, '北海道網走市清浦');
ok($zip->set_number('0993600')->is_valid_number, '北海道斜里郡小清水町以下に掲載がない場合');
ok($zip->set_number('0993601')->is_valid_number, '北海道斜里郡小清水町萱野');
ok($zip->set_number('0993602')->is_valid_number, '北海道斜里郡小清水町東野');
ok($zip->set_number('0993603')->is_valid_number, '北海道斜里郡小清水町泉');
ok($zip->set_number('0993604')->is_valid_number, '北海道斜里郡小清水町水上');
ok($zip->set_number('0993605')->is_valid_number, '北海道斜里郡小清水町もこと山');
ok($zip->set_number('0993611')->is_valid_number, '北海道斜里郡小清水町上徳');
ok($zip->set_number('0993612')->is_valid_number, '北海道斜里郡小清水町共和');
ok($zip->set_number('0993613')->is_valid_number, '北海道斜里郡小清水町神浦');
ok($zip->set_number('0993614')->is_valid_number, '北海道斜里郡小清水町美和');
ok($zip->set_number('0993615')->is_valid_number, '北海道斜里郡小清水町中里');
ok($zip->set_number('0993616')->is_valid_number, '北海道斜里郡小清水町旭');
ok($zip->set_number('0993621')->is_valid_number, '北海道斜里郡小清水町小清水(1区桜ケ丘)');
ok($zip->set_number('0993622')->is_valid_number, '北海道斜里郡小清水町小清水(1区)');
ok($zip->set_number('0993623')->is_valid_number, '北海道斜里郡小清水町小清水(2区)');
ok($zip->set_number('0993624')->is_valid_number, '北海道斜里郡小清水町小清水(3区)');
ok($zip->set_number('0993625')->is_valid_number, '北海道斜里郡小清水町小清水(4区)');
ok($zip->set_number('0993626')->is_valid_number, '北海道斜里郡小清水町小清水(5区)');
ok($zip->set_number('0993627')->is_valid_number, '北海道斜里郡小清水町小清水(6区)');
ok($zip->set_number('0993628')->is_valid_number, '北海道斜里郡小清水町小清水(7区)');
ok($zip->set_number('0993631')->is_valid_number, '北海道斜里郡小清水町小清水(7区川東)');
ok($zip->set_number('0993632')->is_valid_number, '北海道斜里郡小清水町小清水(8区北)');
ok($zip->set_number('0993633')->is_valid_number, '北海道斜里郡小清水町小清水(8区南)');
ok($zip->set_number('0993634')->is_valid_number, '北海道斜里郡小清水町小清水(9区北)');
ok($zip->set_number('0993635')->is_valid_number, '北海道斜里郡小清水町小清水(9区南)');
ok($zip->set_number('0993636')->is_valid_number, '北海道斜里郡小清水町小清水(10区)');
ok($zip->set_number('0993637')->is_valid_number, '北海道斜里郡小清水町小清水(11区)');
ok($zip->set_number('0994100')->is_valid_number, '北海道斜里郡斜里町以下に掲載がない場合');
ok($zip->set_number('0994111')->is_valid_number, '北海道斜里郡斜里町前浜町');
ok($zip->set_number('0994112')->is_valid_number, '北海道斜里郡斜里町港町');
ok($zip->set_number('0994113')->is_valid_number, '北海道斜里郡斜里町本町');
ok($zip->set_number('0994114')->is_valid_number, '北海道斜里郡斜里町朝日町');
ok($zip->set_number('0994115')->is_valid_number, '北海道斜里郡斜里町光陽町');
ok($zip->set_number('0994116')->is_valid_number, '北海道斜里郡斜里町文光町');
ok($zip->set_number('0994117')->is_valid_number, '北海道斜里郡斜里町青葉町');
ok($zip->set_number('0994118')->is_valid_number, '北海道斜里郡斜里町新光町');
ok($zip->set_number('0994121')->is_valid_number, '北海道斜里郡斜里町日の出');
ok($zip->set_number('0994122')->is_valid_number, '北海道斜里郡斜里町峰浜');
ok($zip->set_number('0994123')->is_valid_number, '北海道斜里郡斜里町朱円東');
ok($zip->set_number('0994124')->is_valid_number, '北海道斜里郡斜里町朱円');
ok($zip->set_number('0994125')->is_valid_number, '北海道斜里郡斜里町朱円西');
ok($zip->set_number('0994126')->is_valid_number, '北海道斜里郡斜里町以久科北');
ok($zip->set_number('0994127')->is_valid_number, '北海道斜里郡斜里町以久科南');
ok($zip->set_number('0994131')->is_valid_number, '北海道斜里郡斜里町越川');
ok($zip->set_number('0994132')->is_valid_number, '北海道斜里郡斜里町富士');
ok($zip->set_number('0994133')->is_valid_number, '北海道斜里郡斜里町三井');
ok($zip->set_number('0994134')->is_valid_number, '北海道斜里郡斜里町豊里');
ok($zip->set_number('0994135')->is_valid_number, '北海道斜里郡斜里町来運');
ok($zip->set_number('0994141')->is_valid_number, '北海道斜里郡斜里町豊倉');
ok($zip->set_number('0994142')->is_valid_number, '北海道斜里郡斜里町中斜里');
ok($zip->set_number('0994143')->is_valid_number, '北海道斜里郡斜里町川上');
ok($zip->set_number('0994144')->is_valid_number, '北海道斜里郡斜里町大栄');
ok($zip->set_number('0994145')->is_valid_number, '北海道斜里郡斜里町美咲');
ok($zip->set_number('0994146')->is_valid_number, '北海道斜里郡斜里町港西町');
ok($zip->set_number('0994147')->is_valid_number, '北海道斜里郡斜里町西町');
ok($zip->set_number('0994351')->is_valid_number, '北海道斜里郡斜里町ウトロ香川');
ok($zip->set_number('0994352')->is_valid_number, '北海道斜里郡斜里町ウトロ高原');
ok($zip->set_number('0994353')->is_valid_number, '北海道斜里郡斜里町ウトロ中島');
ok($zip->set_number('0994354')->is_valid_number, '北海道斜里郡斜里町ウトロ西');
ok($zip->set_number('0994355')->is_valid_number, '北海道斜里郡斜里町ウトロ東');
ok($zip->set_number('0994356')->is_valid_number, '北海道斜里郡斜里町岩尾別');
ok($zip->set_number('0994357')->is_valid_number, '北海道斜里郡斜里町真鯉');
ok($zip->set_number('0994400')->is_valid_number, '北海道斜里郡清里町以下に掲載がない場合');
ok($zip->set_number('0994401')->is_valid_number, '北海道斜里郡清里町上斜里');
ok($zip->set_number('0994402')->is_valid_number, '北海道斜里郡清里町下江鳶');
ok($zip->set_number('0994403')->is_valid_number, '北海道斜里郡清里町向陽');
ok($zip->set_number('0994404')->is_valid_number, '北海道斜里郡清里町江南');
ok($zip->set_number('0994405')->is_valid_number, '北海道斜里郡清里町羽衣町');
ok($zip->set_number('0994406')->is_valid_number, '北海道斜里郡清里町水元町');
ok($zip->set_number('0994407')->is_valid_number, '北海道斜里郡清里町新町');
ok($zip->set_number('0994521')->is_valid_number, '北海道斜里郡清里町札弦町');
ok($zip->set_number('0994522')->is_valid_number, '北海道斜里郡清里町神威');
ok($zip->set_number('0994523')->is_valid_number, '北海道斜里郡清里町川向');
ok($zip->set_number('0994524')->is_valid_number, '北海道斜里郡清里町青葉');
ok($zip->set_number('0994525')->is_valid_number, '北海道斜里郡清里町緑町');
ok($zip->set_number('0994526')->is_valid_number, '北海道斜里郡清里町清泉');
ok($zip->set_number('0995171')->is_valid_number, '北海道紋別市渚滑町');
ok($zip->set_number('0995172')->is_valid_number, '北海道紋別市渚滑町元新');
ok($zip->set_number('0995173')->is_valid_number, '北海道紋別市渚滑町元西');
ok($zip->set_number('0995174')->is_valid_number, '北海道紋別市渚滑町宇津々');
ok($zip->set_number('0995175')->is_valid_number, '北海道紋別市渚滑町川向');
ok($zip->set_number('0995351')->is_valid_number, '北海道紋別市上渚滑町下渚滑');
ok($zip->set_number('0995352')->is_valid_number, '北海道紋別市上渚滑町中渚滑');
ok($zip->set_number('0995353')->is_valid_number, '北海道紋別市上渚滑町上東');
ok($zip->set_number('0995354')->is_valid_number, '北海道紋別市上渚滑町');
ok($zip->set_number('0995355')->is_valid_number, '北海道紋別市上渚滑町更生');
ok($zip->set_number('0995361')->is_valid_number, '北海道紋別市上渚滑町和訓辺');
ok($zip->set_number('0995362')->is_valid_number, '北海道紋別市上渚滑町奥東');
ok($zip->set_number('0995363')->is_valid_number, '北海道紋別市上渚滑町下立牛');
ok($zip->set_number('0995364')->is_valid_number, '北海道紋別市上渚滑町上古丹');
ok($zip->set_number('0995365')->is_valid_number, '北海道紋別市上渚滑町中立牛');
ok($zip->set_number('0995541')->is_valid_number, '北海道紋別郡滝上町濁川中央');
ok($zip->set_number('0995542')->is_valid_number, '北海道紋別郡滝上町濁川みどり町');
ok($zip->set_number('0995543')->is_valid_number, '北海道紋別郡滝上町新町');
ok($zip->set_number('0995544')->is_valid_number, '北海道紋別郡滝上町雄鎮内');
ok($zip->set_number('0995551')->is_valid_number, '北海道紋別郡滝上町大正');
ok($zip->set_number('0995552')->is_valid_number, '北海道紋別郡滝上町滝下');
ok($zip->set_number('0995553')->is_valid_number, '北海道紋別郡滝上町雄柏');
ok($zip->set_number('0995600')->is_valid_number, '北海道紋別郡滝上町以下に掲載がない場合');
ok($zip->set_number('0995601')->is_valid_number, '北海道紋別郡滝上町あけぼの町');
ok($zip->set_number('0995602')->is_valid_number, '北海道紋別郡滝上町旭町');
ok($zip->set_number('0995603')->is_valid_number, '北海道紋別郡滝上町滝美町');
ok($zip->set_number('0995604')->is_valid_number, '北海道紋別郡滝上町元町');
ok($zip->set_number('0995605')->is_valid_number, '北海道紋別郡滝上町栄町');
ok($zip->set_number('0995606')->is_valid_number, '北海道紋別郡滝上町幸町');
ok($zip->set_number('0995611')->is_valid_number, '北海道紋別郡滝上町第1区');
ok($zip->set_number('0995612')->is_valid_number, '北海道紋別郡滝上町白鳥');
ok($zip->set_number('0995612')->is_valid_number, '北海道紋別郡滝上町第2区');
ok($zip->set_number('0995613')->is_valid_number, '北海道紋別郡滝上町第3区');
ok($zip->set_number('0995613')->is_valid_number, '北海道紋別郡滝上町第4区');
ok($zip->set_number('0995613')->is_valid_number, '北海道紋別郡滝上町第5区');
ok($zip->set_number('0995613')->is_valid_number, '北海道紋別郡滝上町滝西');
ok($zip->set_number('0995614')->is_valid_number, '北海道紋別郡滝上町札久留');
ok($zip->set_number('0996131')->is_valid_number, '北海道紋別市一本松');
ok($zip->set_number('0996131')->is_valid_number, '北海道紋別市八十士');
ok($zip->set_number('0996132')->is_valid_number, '北海道紋別市小向');
ok($zip->set_number('0996133')->is_valid_number, '北海道紋別市弘道');
ok($zip->set_number('0996241')->is_valid_number, '北海道紋別市沼の上');
ok($zip->set_number('0996242')->is_valid_number, '北海道紋別市志文');
ok($zip->set_number('0996271')->is_valid_number, '北海道紋別郡湧別町信部内');
ok($zip->set_number('0996272')->is_valid_number, '北海道紋別郡湧別町緑蔭');
ok($zip->set_number('0996321')->is_valid_number, '北海道紋別郡湧別町旭');
ok($zip->set_number('0996322')->is_valid_number, '北海道紋別郡湧別町北兵村三区');
ok($zip->set_number('0996323')->is_valid_number, '北海道紋別郡湧別町北兵村二区');
ok($zip->set_number('0996325')->is_valid_number, '北海道紋別郡湧別町北兵村一区');
ok($zip->set_number('0996326')->is_valid_number, '北海道紋別郡湧別町中湧別北町');
ok($zip->set_number('0996327')->is_valid_number, '北海道紋別郡湧別町中湧別東町');
ok($zip->set_number('0996328')->is_valid_number, '北海道紋別郡湧別町中湧別南町');
ok($zip->set_number('0996329')->is_valid_number, '北海道紋別郡湧別町中湧別中町');
ok($zip->set_number('0996400')->is_valid_number, '北海道紋別郡湧別町以下に掲載がない場合');
ok($zip->set_number('0996401')->is_valid_number, '北海道紋別郡湧別町港町');
ok($zip->set_number('0996402')->is_valid_number, '北海道紋別郡湧別町曙町');
ok($zip->set_number('0996403')->is_valid_number, '北海道紋別郡湧別町緑町');
ok($zip->set_number('0996404')->is_valid_number, '北海道紋別郡湧別町栄町');
ok($zip->set_number('0996411')->is_valid_number, '北海道紋別郡湧別町東');
ok($zip->set_number('0996412')->is_valid_number, '北海道紋別郡湧別町登栄床');
ok($zip->set_number('0996413')->is_valid_number, '北海道紋別郡湧別町福島(その他)');
ok($zip->set_number('0996414')->is_valid_number, '北海道紋別郡湧別町錦町');
ok($zip->set_number('0996415')->is_valid_number, '北海道紋別郡湧別町川西');
ok($zip->set_number('0996501')->is_valid_number, '北海道紋別郡湧別町上湧別屯田市街地');
ok($zip->set_number('0996503')->is_valid_number, '北海道紋別郡湧別町開盛');
ok($zip->set_number('0996504')->is_valid_number, '北海道紋別郡湧別町上富美');
ok($zip->set_number('0996505')->is_valid_number, '北海道紋別郡湧別町富美');
ok($zip->set_number('0996506')->is_valid_number, '北海道紋別郡湧別町札富美');
ok($zip->set_number('0996507')->is_valid_number, '北海道紋別郡湧別町南兵村三区');
ok($zip->set_number('0996508')->is_valid_number, '北海道紋別郡湧別町南兵村二区');
ok($zip->set_number('0996509')->is_valid_number, '北海道紋別郡湧別町南兵村一区');
ok($zip->set_number('1000000')->is_valid_number, '東京都千代田区以下に掲載がない場合');
ok($zip->set_number('1000001')->is_valid_number, '東京都千代田区千代田');
ok($zip->set_number('1000002')->is_valid_number, '東京都千代田区皇居外苑');
ok($zip->set_number('1000003')->is_valid_number, '東京都千代田区一ツ橋(1丁目)');
ok($zip->set_number('1000004')->is_valid_number, '東京都千代田区大手町(次のビルを除く)');
ok($zip->set_number('1000005')->is_valid_number, '東京都千代田区丸の内(次のビルを除く)');
ok($zip->set_number('1000006')->is_valid_number, '東京都千代田区有楽町');
ok($zip->set_number('1000011')->is_valid_number, '東京都千代田区内幸町');
ok($zip->set_number('1000012')->is_valid_number, '東京都千代田区日比谷公園');
ok($zip->set_number('1000013')->is_valid_number, '東京都千代田区霞が関(次のビルを除く)');
ok($zip->set_number('1000014')->is_valid_number, '東京都千代田区永田町(次のビルを除く)');
ok($zip->set_number('1000100')->is_valid_number, '東京都大島町以下に掲載がない場合');
ok($zip->set_number('1000101')->is_valid_number, '東京都大島町元町');
ok($zip->set_number('1000102')->is_valid_number, '東京都大島町岡田');
ok($zip->set_number('1000103')->is_valid_number, '東京都大島町泉津');
ok($zip->set_number('1000104')->is_valid_number, '東京都大島町野増');
ok($zip->set_number('1000211')->is_valid_number, '東京都大島町差木地');
ok($zip->set_number('1000212')->is_valid_number, '東京都大島町波浮港');
ok($zip->set_number('1000301')->is_valid_number, '東京都利島村利島村一円');
ok($zip->set_number('1000400')->is_valid_number, '東京都新島村以下に掲載がない場合');
ok($zip->set_number('1000401')->is_valid_number, '東京都新島村若郷');
ok($zip->set_number('1000402')->is_valid_number, '東京都新島村本村');
ok($zip->set_number('1000511')->is_valid_number, '東京都新島村式根島');
ok($zip->set_number('1000601')->is_valid_number, '東京都神津島村神津島村一円');
ok($zip->set_number('1001100')->is_valid_number, '東京都三宅島三宅村以下に掲載がない場合');
ok($zip->set_number('1001101')->is_valid_number, '東京都三宅島三宅村神着');
ok($zip->set_number('1001102')->is_valid_number, '東京都三宅島三宅村伊豆');
ok($zip->set_number('1001103')->is_valid_number, '東京都三宅島三宅村伊ケ谷');
ok($zip->set_number('1001211')->is_valid_number, '東京都三宅島三宅村坪田');
ok($zip->set_number('1001212')->is_valid_number, '東京都三宅島三宅村阿古');
ok($zip->set_number('1001213')->is_valid_number, '東京都三宅島三宅村雄山');
ok($zip->set_number('1001301')->is_valid_number, '東京都御蔵島村御蔵島村一円');
ok($zip->set_number('1001400')->is_valid_number, '東京都八丈島八丈町以下に掲載がない場合');
ok($zip->set_number('1001401')->is_valid_number, '東京都八丈島八丈町大賀郷');
ok($zip->set_number('1001511')->is_valid_number, '東京都八丈島八丈町三根');
ok($zip->set_number('1001621')->is_valid_number, '東京都八丈島八丈町樫立');
ok($zip->set_number('1001622')->is_valid_number, '東京都八丈島八丈町末吉');
ok($zip->set_number('1001623')->is_valid_number, '東京都八丈島八丈町中之郷');
ok($zip->set_number('1001701')->is_valid_number, '東京都青ヶ島村青ヶ島村一円');
ok($zip->set_number('1002100')->is_valid_number, '東京都小笠原村以下に掲載がない場合');
ok($zip->set_number('1002101')->is_valid_number, '東京都小笠原村父島');
ok($zip->set_number('1002211')->is_valid_number, '東京都小笠原村母島');
ok($zip->set_number('1006001')->is_valid_number, '東京都千代田区霞が関霞が関ビル(1階)');
ok($zip->set_number('1006002')->is_valid_number, '東京都千代田区霞が関霞が関ビル(2階)');
ok($zip->set_number('1006003')->is_valid_number, '東京都千代田区霞が関霞が関ビル(3階)');
ok($zip->set_number('1006004')->is_valid_number, '東京都千代田区霞が関霞が関ビル(4階)');
ok($zip->set_number('1006005')->is_valid_number, '東京都千代田区霞が関霞が関ビル(5階)');
ok($zip->set_number('1006006')->is_valid_number, '東京都千代田区霞が関霞が関ビル(6階)');
ok($zip->set_number('1006007')->is_valid_number, '東京都千代田区霞が関霞が関ビル(7階)');
ok($zip->set_number('1006008')->is_valid_number, '東京都千代田区霞が関霞が関ビル(8階)');
ok($zip->set_number('1006009')->is_valid_number, '東京都千代田区霞が関霞が関ビル(9階)');
ok($zip->set_number('1006010')->is_valid_number, '東京都千代田区霞が関霞が関ビル(10階)');
ok($zip->set_number('1006011')->is_valid_number, '東京都千代田区霞が関霞が関ビル(11階)');
ok($zip->set_number('1006012')->is_valid_number, '東京都千代田区霞が関霞が関ビル(12階)');
ok($zip->set_number('1006013')->is_valid_number, '東京都千代田区霞が関霞が関ビル(13階)');
ok($zip->set_number('1006014')->is_valid_number, '東京都千代田区霞が関霞が関ビル(14階)');
ok($zip->set_number('1006015')->is_valid_number, '東京都千代田区霞が関霞が関ビル(15階)');
ok($zip->set_number('1006016')->is_valid_number, '東京都千代田区霞が関霞が関ビル(16階)');
ok($zip->set_number('1006017')->is_valid_number, '東京都千代田区霞が関霞が関ビル(17階)');
ok($zip->set_number('1006018')->is_valid_number, '東京都千代田区霞が関霞が関ビル(18階)');
ok($zip->set_number('1006019')->is_valid_number, '東京都千代田区霞が関霞が関ビル(19階)');
ok($zip->set_number('1006020')->is_valid_number, '東京都千代田区霞が関霞が関ビル(20階)');
ok($zip->set_number('1006021')->is_valid_number, '東京都千代田区霞が関霞が関ビル(21階)');
ok($zip->set_number('1006022')->is_valid_number, '東京都千代田区霞が関霞が関ビル(22階)');
ok($zip->set_number('1006023')->is_valid_number, '東京都千代田区霞が関霞が関ビル(23階)');
ok($zip->set_number('1006024')->is_valid_number, '東京都千代田区霞が関霞が関ビル(24階)');
ok($zip->set_number('1006025')->is_valid_number, '東京都千代田区霞が関霞が関ビル(25階)');
ok($zip->set_number('1006026')->is_valid_number, '東京都千代田区霞が関霞が関ビル(26階)');
ok($zip->set_number('1006027')->is_valid_number, '東京都千代田区霞が関霞が関ビル(27階)');
ok($zip->set_number('1006028')->is_valid_number, '東京都千代田区霞が関霞が関ビル(28階)');
ok($zip->set_number('1006029')->is_valid_number, '東京都千代田区霞が関霞が関ビル(29階)');
ok($zip->set_number('1006030')->is_valid_number, '東京都千代田区霞が関霞が関ビル(30階)');
ok($zip->set_number('1006031')->is_valid_number, '東京都千代田区霞が関霞が関ビル(31階)');
ok($zip->set_number('1006032')->is_valid_number, '東京都千代田区霞が関霞が関ビル(32階)');
ok($zip->set_number('1006033')->is_valid_number, '東京都千代田区霞が関霞が関ビル(33階)');
ok($zip->set_number('1006034')->is_valid_number, '東京都千代田区霞が関霞が関ビル(34階)');
ok($zip->set_number('1006035')->is_valid_number, '東京都千代田区霞が関霞が関ビル(35階)');
ok($zip->set_number('1006036')->is_valid_number, '東京都千代田区霞が関霞が関ビル(36階)');
ok($zip->set_number('1006090')->is_valid_number, '東京都千代田区霞が関霞が関ビル(地階・階層不明)');
ok($zip->set_number('1006101')->is_valid_number, '東京都千代田区永田町山王パークタワー(1階)');
ok($zip->set_number('1006102')->is_valid_number, '東京都千代田区永田町山王パークタワー(2階)');
ok($zip->set_number('1006103')->is_valid_number, '東京都千代田区永田町山王パークタワー(3階)');
ok($zip->set_number('1006104')->is_valid_number, '東京都千代田区永田町山王パークタワー(4階)');
ok($zip->set_number('1006105')->is_valid_number, '東京都千代田区永田町山王パークタワー(5階)');
ok($zip->set_number('1006106')->is_valid_number, '東京都千代田区永田町山王パークタワー(6階)');
ok($zip->set_number('1006107')->is_valid_number, '東京都千代田区永田町山王パークタワー(7階)');
ok($zip->set_number('1006108')->is_valid_number, '東京都千代田区永田町山王パークタワー(8階)');
ok($zip->set_number('1006109')->is_valid_number, '東京都千代田区永田町山王パークタワー(9階)');
ok($zip->set_number('1006110')->is_valid_number, '東京都千代田区永田町山王パークタワー(10階)');
ok($zip->set_number('1006111')->is_valid_number, '東京都千代田区永田町山王パークタワー(11階)');
ok($zip->set_number('1006112')->is_valid_number, '東京都千代田区永田町山王パークタワー(12階)');
ok($zip->set_number('1006113')->is_valid_number, '東京都千代田区永田町山王パークタワー(13階)');
ok($zip->set_number('1006114')->is_valid_number, '東京都千代田区永田町山王パークタワー(14階)');
ok($zip->set_number('1006115')->is_valid_number, '東京都千代田区永田町山王パークタワー(15階)');
ok($zip->set_number('1006116')->is_valid_number, '東京都千代田区永田町山王パークタワー(16階)');
ok($zip->set_number('1006117')->is_valid_number, '東京都千代田区永田町山王パークタワー(17階)');
ok($zip->set_number('1006118')->is_valid_number, '東京都千代田区永田町山王パークタワー(18階)');
ok($zip->set_number('1006119')->is_valid_number, '東京都千代田区永田町山王パークタワー(19階)');
ok($zip->set_number('1006120')->is_valid_number, '東京都千代田区永田町山王パークタワー(20階)');
ok($zip->set_number('1006121')->is_valid_number, '東京都千代田区永田町山王パークタワー(21階)');
ok($zip->set_number('1006122')->is_valid_number, '東京都千代田区永田町山王パークタワー(22階)');
ok($zip->set_number('1006123')->is_valid_number, '東京都千代田区永田町山王パークタワー(23階)');
ok($zip->set_number('1006124')->is_valid_number, '東京都千代田区永田町山王パークタワー(24階)');
ok($zip->set_number('1006125')->is_valid_number, '東京都千代田区永田町山王パークタワー(25階)');
ok($zip->set_number('1006126')->is_valid_number, '東京都千代田区永田町山王パークタワー(26階)');
ok($zip->set_number('1006127')->is_valid_number, '東京都千代田区永田町山王パークタワー(27階)');
ok($zip->set_number('1006128')->is_valid_number, '東京都千代田区永田町山王パークタワー(28階)');
ok($zip->set_number('1006129')->is_valid_number, '東京都千代田区永田町山王パークタワー(29階)');
ok($zip->set_number('1006130')->is_valid_number, '東京都千代田区永田町山王パークタワー(30階)');
ok($zip->set_number('1006131')->is_valid_number, '東京都千代田区永田町山王パークタワー(31階)');
ok($zip->set_number('1006132')->is_valid_number, '東京都千代田区永田町山王パークタワー(32階)');
ok($zip->set_number('1006133')->is_valid_number, '東京都千代田区永田町山王パークタワー(33階)');
ok($zip->set_number('1006134')->is_valid_number, '東京都千代田区永田町山王パークタワー(34階)');
ok($zip->set_number('1006135')->is_valid_number, '東京都千代田区永田町山王パークタワー(35階)');
ok($zip->set_number('1006136')->is_valid_number, '東京都千代田区永田町山王パークタワー(36階)');
ok($zip->set_number('1006137')->is_valid_number, '東京都千代田区永田町山王パークタワー(37階)');
ok($zip->set_number('1006138')->is_valid_number, '東京都千代田区永田町山王パークタワー(38階)');
ok($zip->set_number('1006139')->is_valid_number, '東京都千代田区永田町山王パークタワー(39階)');
ok($zip->set_number('1006140')->is_valid_number, '東京都千代田区永田町山王パークタワー(40階)');
ok($zip->set_number('1006141')->is_valid_number, '東京都千代田区永田町山王パークタワー(41階)');
ok($zip->set_number('1006142')->is_valid_number, '東京都千代田区永田町山王パークタワー(42階)');
ok($zip->set_number('1006143')->is_valid_number, '東京都千代田区永田町山王パークタワー(43階)');
ok($zip->set_number('1006144')->is_valid_number, '東京都千代田区永田町山王パークタワー(44階)');
ok($zip->set_number('1006190')->is_valid_number, '東京都千代田区永田町山王パークタワー(地階・階層不明)');
ok($zip->set_number('1006201')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(1階)');
ok($zip->set_number('1006202')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(2階)');
ok($zip->set_number('1006203')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(3階)');
ok($zip->set_number('1006204')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(4階)');
ok($zip->set_number('1006205')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(5階)');
ok($zip->set_number('1006206')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(6階)');
ok($zip->set_number('1006207')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(7階)');
ok($zip->set_number('1006208')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(8階)');
ok($zip->set_number('1006209')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(9階)');
ok($zip->set_number('1006210')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(10階)');
ok($zip->set_number('1006211')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(11階)');
ok($zip->set_number('1006212')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(12階)');
ok($zip->set_number('1006213')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(13階)');
ok($zip->set_number('1006214')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(14階)');
ok($zip->set_number('1006215')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(15階)');
ok($zip->set_number('1006216')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(16階)');
ok($zip->set_number('1006217')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(17階)');
ok($zip->set_number('1006218')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(18階)');
ok($zip->set_number('1006219')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(19階)');
ok($zip->set_number('1006220')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(20階)');
ok($zip->set_number('1006221')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(21階)');
ok($zip->set_number('1006222')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(22階)');
ok($zip->set_number('1006223')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(23階)');
ok($zip->set_number('1006224')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(24階)');
ok($zip->set_number('1006225')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(25階)');
ok($zip->set_number('1006226')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(26階)');
ok($zip->set_number('1006227')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(27階)');
ok($zip->set_number('1006228')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(28階)');
ok($zip->set_number('1006229')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(29階)');
ok($zip->set_number('1006230')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(30階)');
ok($zip->set_number('1006231')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(31階)');
ok($zip->set_number('1006290')->is_valid_number, '東京都千代田区丸の内パシフィックセンチュリープレイス丸の内(地階・階層不明)');
ok($zip->set_number('1006301')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(1階)');
ok($zip->set_number('1006302')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(2階)');
ok($zip->set_number('1006303')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(3階)');
ok($zip->set_number('1006304')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(4階)');
ok($zip->set_number('1006305')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(5階)');
ok($zip->set_number('1006306')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(6階)');
ok($zip->set_number('1006307')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(7階)');
ok($zip->set_number('1006308')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(8階)');
ok($zip->set_number('1006309')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(9階)');
ok($zip->set_number('1006310')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(10階)');
ok($zip->set_number('1006311')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(11階)');
ok($zip->set_number('1006312')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(12階)');
ok($zip->set_number('1006313')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(13階)');
ok($zip->set_number('1006314')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(14階)');
ok($zip->set_number('1006315')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(15階)');
ok($zip->set_number('1006316')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(16階)');
ok($zip->set_number('1006317')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(17階)');
ok($zip->set_number('1006318')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(18階)');
ok($zip->set_number('1006319')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(19階)');
ok($zip->set_number('1006320')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(20階)');
ok($zip->set_number('1006321')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(21階)');
ok($zip->set_number('1006322')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(22階)');
ok($zip->set_number('1006323')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(23階)');
ok($zip->set_number('1006324')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(24階)');
ok($zip->set_number('1006325')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(25階)');
ok($zip->set_number('1006326')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(26階)');
ok($zip->set_number('1006327')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(27階)');
ok($zip->set_number('1006328')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(28階)');
ok($zip->set_number('1006329')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(29階)');
ok($zip->set_number('1006330')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(30階)');
ok($zip->set_number('1006331')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(31階)');
ok($zip->set_number('1006332')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(32階)');
ok($zip->set_number('1006333')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(33階)');
ok($zip->set_number('1006334')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(34階)');
ok($zip->set_number('1006335')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(35階)');
ok($zip->set_number('1006336')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(36階)');
ok($zip->set_number('1006337')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(37階)');
ok($zip->set_number('1006390')->is_valid_number, '東京都千代田区丸の内丸の内ビルディング(地階・階層不明)');
ok($zip->set_number('1006401')->is_valid_number, '東京都千代田区丸の内東京ビルディング(1階)');
ok($zip->set_number('1006402')->is_valid_number, '東京都千代田区丸の内東京ビルディング(2階)');
ok($zip->set_number('1006403')->is_valid_number, '東京都千代田区丸の内東京ビルディング(3階)');
ok($zip->set_number('1006404')->is_valid_number, '東京都千代田区丸の内東京ビルディング(4階)');
ok($zip->set_number('1006405')->is_valid_number, '東京都千代田区丸の内東京ビルディング(5階)');
ok($zip->set_number('1006406')->is_valid_number, '東京都千代田区丸の内東京ビルディング(6階)');
ok($zip->set_number('1006407')->is_valid_number, '東京都千代田区丸の内東京ビルディング(7階)');
ok($zip->set_number('1006408')->is_valid_number, '東京都千代田区丸の内東京ビルディング(8階)');
ok($zip->set_number('1006409')->is_valid_number, '東京都千代田区丸の内東京ビルディング(9階)');
ok($zip->set_number('1006410')->is_valid_number, '東京都千代田区丸の内東京ビルディング(10階)');
ok($zip->set_number('1006411')->is_valid_number, '東京都千代田区丸の内東京ビルディング(11階)');
ok($zip->set_number('1006412')->is_valid_number, '東京都千代田区丸の内東京ビルディング(12階)');
ok($zip->set_number('1006413')->is_valid_number, '東京都千代田区丸の内東京ビルディング(13階)');
ok($zip->set_number('1006414')->is_valid_number, '東京都千代田区丸の内東京ビルディング(14階)');
ok($zip->set_number('1006415')->is_valid_