
package Paws::EC2::ReplaceNetworkAclAssociation {
  use Moose;
  has AssociationId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'associationId' , required => 1);
  has DryRun => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'dryRun' );
  has NetworkAclId => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'networkAclId' , required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ReplaceNetworkAclAssociation');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::EC2::ReplaceNetworkAclAssociationResult');
  class_has _result_key => (isa => 'Str', is => 'ro');
}
1;

### main pod documentation begin ###

=head1 NAME

Paws::EC2::ReplaceNetworkAclAssociation - Arguments for method ReplaceNetworkAclAssociation on Paws::EC2

=head1 DESCRIPTION

This class represents the parameters used for calling the method ReplaceNetworkAclAssociation on the 
Amazon Elastic Compute Cloud service. Use the attributes of this class
as arguments to method ReplaceNetworkAclAssociation.

You shouln't make instances of this class. Each attribute should be used as a named argument in the call to ReplaceNetworkAclAssociation.

As an example:

  $service_obj->ReplaceNetworkAclAssociation(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES

=head2 B<REQUIRED> AssociationId => Str

  

The ID of the current association between the original network ACL and
the subnet.










=head2 DryRun => Bool

  

=head2 B<REQUIRED> NetworkAclId => Str

  

The ID of the new network ACL to associate with the subnet.












=head1 SEE ALSO

This class forms part of L<Paws>, and documents parameters for ReplaceNetworkAclAssociation in Paws::EC2

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

