
package Paws::Route53Domains::UpdateDomainContactPrivacy {
  use Moose;
  has AdminPrivacy => (is => 'ro', isa => 'Bool');
  has DomainName => (is => 'ro', isa => 'Str', required => 1);
  has RegistrantPrivacy => (is => 'ro', isa => 'Bool');
  has TechPrivacy => (is => 'ro', isa => 'Bool');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateDomainContactPrivacy');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Route53Domains::UpdateDomainContactPrivacyResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
}
1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53Domains::UpdateDomainContactPrivacy - Arguments for method UpdateDomainContactPrivacy on Paws::Route53Domains

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateDomainContactPrivacy on the 
Amazon Route 53 Domains service. Use the attributes of this class
as arguments to method UpdateDomainContactPrivacy.

You shouln't make instances of this class. Each attribute should be used as a named argument in the call to UpdateDomainContactPrivacy.

As an example:

  $service_obj->UpdateDomainContactPrivacy(Att1 => $value1, Att2 => $value2, ...);

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.

=head1 ATTRIBUTES

=head2 AdminPrivacy => Bool

  

Whether you want to conceal contact information from WHOIS queries. If
you specify true, WHOIS ("who is") queries will return contact
information for our registrar partner, Gandi, instead of the contact
information that you enter.

Type: Boolean

Default: None

Valid values: C<true> | C<false>

Required: No










=head2 B<REQUIRED> DomainName => Str

  

The name of a domain.

Type: String

Default: None

Constraints: The domain name can contain only the letters a through z,
the numbers 0 through 9, and hyphen (-). Internationalized Domain Names
are not supported.

Required: Yes










=head2 RegistrantPrivacy => Bool

  

Whether you want to conceal contact information from WHOIS queries. If
you specify true, WHOIS ("who is") queries will return contact
information for our registrar partner, Gandi, instead of the contact
information that you enter.

Type: Boolean

Default: None

Valid values: C<true> | C<false>

Required: No










=head2 TechPrivacy => Bool

  

Whether you want to conceal contact information from WHOIS queries. If
you specify true, WHOIS ("who is") queries will return contact
information for our registrar partner, Gandi, instead of the contact
information that you enter.

Type: Boolean

Default: None

Valid values: C<true> | C<false>

Required: No












=head1 SEE ALSO

This class forms part of L<Paws>, and documents parameters for UpdateDomainContactPrivacy in Paws::Route53Domains

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

