package Bencher::Formatter::RoundNumbers;

our $DATE = '2016-01-22'; # DATE
our $VERSION = '0.34'; # VERSION

use 5.010001;
use strict;
use warnings;
#use Log::Any::IfLOG '$log';

use parent qw(Bencher::Formatter);

use Role::Tiny::With;
with 'Bencher::Role::ResultMunger';

sub munge_result {
    my ($self, $envres) = @_;

    my $ff = $envres->[3]{'table.fields'};

    for my $rit (@{$envres->[2]}) {
        # 'time' has been scaled by ScaleTime, while 'rate' hasn't. so we use
        # 1/'rate' here
        my $num_significant_digits =
            $rit->{errors} == 0 ? 6 :
            sprintf("%d", log( abs(1/$rit->{rate}) / $rit->{errors})/log(10));
        my $fmt = "%.${num_significant_digits}g";
        $rit->{time} = sprintf($fmt, $rit->{time});
        if (exists $rit->{rate}) {
            $rit->{rate} = sprintf($fmt, $rit->{rate});
        }
        $rit->{errors} = sprintf("%.2g", $rit->{errors});
        if (exists $rit->{mod_overhead_time}) {
            $rit->{mod_overhead_time} = sprintf(
                $fmt, $rit->{mod_overhead_time});
        }
    }
}

1;
# ABSTRACT: Round numbers (rate, time) to certain significant digits according to errors

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Formatter::RoundNumbers - Round numbers (rate, time) to certain significant digits according to errors

=head1 VERSION

This document describes version 0.34 of Bencher::Formatter::RoundNumbers (from Perl distribution Bencher), released on 2016-01-22.

=for Pod::Coverage .*

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
