package Bencher::Scenario::CmdLineParsingModules;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark command-line parsing modules',
    participants => [
        {
            fcall_template => 'Parse::CommandLine::parse_command_line(<cmdline>)',
            result_is_list => 1,
        },
        {
            fcall_template => 'Complete::Bash::parse_cmdline(<cmdline>, 0)',
        },
    ],

    datasets => [
        {
            name => 'empty',
            args => {
                cmdline => q[],
            },
        },
        {
            name => 'cmd-only',
            args => {
                cmdline => q[somecmd],
            },
        },
        {
            name => '2args-simple',
            args => {
                cmdline => q[somecmd arg1 arg-two],
            },
        },
        {
            name => '4args',
            args => {
                cmdline => q[command '' arg1 "arg2 in quotes" arg3\\ with\\ spaces "arg4 with \\"quotes\\" and \\\\backslash"],
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark command-line parsing modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::CmdLineParsingModules

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::CmdLineParsingModules (from Perl distribution Bencher-Scenario-CmdLineParsingModules), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m CmdLineParsingModules

To run module startup overhead benchmark:

 % bencher --module-startup -m CmdLineParsingModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<Parse::CommandLine> 0.02

L<Complete::Bash> 0.24

=head1 BENCHMARK PARTICIPANTS

=over

=item * Parse::CommandLine::parse_command_line (perl_code)

Function call template:

 Parse::CommandLine::parse_command_line(<cmdline>)



=item * Complete::Bash::parse_cmdline (perl_code)

Function call template:

 Complete::Bash::parse_cmdline(<cmdline>, 0)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------------------------------------------------------------------+-----------+---------+---------+---------+
 | seq | name                                                                            | rate      | time    | errors  | samples |
 +-----+---------------------------------------------------------------------------------+-----------+---------+---------+---------+
 | 7   | {dataset=>"4args",participant=>"Complete::Bash::parse_cmdline"}                 | 2.41e+04  | 41.6μs  | 1.3e-08 | 20      |
 | 3   | {dataset=>"4args",participant=>"Parse::CommandLine::parse_command_line"}        | 2.66e+04  | 37.6μs  | 5.2e-08 | 21      |
 | 6   | {dataset=>"2args-simple",participant=>"Complete::Bash::parse_cmdline"}          | 5.54e+04  | 18μs    | 2.7e-08 | 20      |
 | 2   | {dataset=>"2args-simple",participant=>"Parse::CommandLine::parse_command_line"} | 1.1e+05   | 9.4μs   | 5.7e-08 | 20      |
 | 5   | {dataset=>"cmd-only",participant=>"Complete::Bash::parse_cmdline"}              | 1.24e+05  | 8.07μs  | 9.8e-09 | 21      |
 | 1   | {dataset=>"cmd-only",participant=>"Parse::CommandLine::parse_command_line"}     | 2.6e+05   | 3.85μs  | 1.6e-09 | 22      |
 | 4   | {dataset=>"empty",participant=>"Complete::Bash::parse_cmdline"}                 | 8.603e+05 | 1.162μs | 4.5e-11 | 20      |
 | 0   | {dataset=>"empty",participant=>"Parse::CommandLine::parse_command_line"}        | 1.76e+06  | 0.569μs | 8.3e-10 | 20      |
 +-----+---------------------------------------------------------------------------------+-----------+---------+---------+---------+


Benchmark module startup overhead:

 +-----+---------------------+-------+-------------------+---------+---------+
 | seq | name                | time  | mod_overhead_time | errors  | samples |
 +-----+---------------------+-------+-------------------+---------+---------+
 | 2   | Complete::Bash      | 9.2ms | 4.8ms             | 4.9e-05 | 22      |
 | 1   | Parse::CommandLine  | 8.7ms | 4.3ms             | 4.5e-05 | 20      |
 | 0   | perl -e1 (baseline) | 4.4ms | 0ms               | 3e-05   | 20      |
 +-----+---------------------+-------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-CmdLineParsingModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-CmdLineParsingModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-CmdLineParsingModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
